/*********************************************************************************************************************
* MM32F527X-E9P Opensourec Library MM32F527X-E9P Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ MM32F527X-E9P Դһ
* 
* MM32F527X-E9P Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_common_function
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           MDK 5.37
* ƽ̨          MM32F527X_E9P
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-08-10        Teternal            first version
********************************************************************************************************************/

#ifndef _zf_common_function_h_
#define _zf_common_function_h_

#include "zf_common_typedef.h"

//====================================================궨庯====================================================
//-------------------------------------------------------------------------------------------------------------------
//      ֵ ݷΧ [-32767,32767]
// ˵     dat             Ҫֵ
// ز     int             ؾֵ
// ʹʾ     dat = func_abs(dat);                            // dat
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
#define     func_abs(x)             ((x) >= 0 ? (x): -(x))

//-------------------------------------------------------------------------------------------------------------------
//      ޷ ݷΧ [-32768,32767]
// ˵     x               ޷
// ˵     y               ޷Χ(ݻᱻ-y+y֮)
// ز     int             ޷֮         
// ʹʾ     int dat = func_limit(500, 300);                 // ݱ-300+300֮  ˷صĽ300
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
#define     func_limit(x, y)        ((x) > (y) ? (y) : ((x) < -(y) ? -(y) : (x)))

//-------------------------------------------------------------------------------------------------------------------
//      ˫޷ ݷΧ [-32768,32767]
// ˵     x               ޷
// ˵     a               ޷Χ߽
// ˵     b               ޷Χұ߽
// ز     int             ޷֮         
// ʹʾ     int dat = func_limit_ab(500, -300, 400);        //ݱ-300+400֮  ˷صĽ400
// עϢ     
//-------------------------------------------------------------------------------------------------------------------
#define     func_limit_ab(x, a, b)  ((x) < (a) ? (a) : ((x) > (b) ? (b) : (x)))

//====================================================궨庯====================================================

//=====================================================溯=====================================================
uint32      func_get_greatest_common_divisor    (uint32 num1, uint32 num2);

void        func_soft_delay                     (volatile long t);

int32       func_str_to_int                     (char *str);
void        func_int_to_str                     (char *str, int32 number);
uint32      func_str_to_uint                    (char *str);
void        func_uint_to_str                    (char *str, uint32 number);
float       func_str_to_float                   (char *str);
void        func_float_to_str                   (char *str, float number, uint8 point_bit);
double      func_str_to_double                  (char *str);
void        func_double_to_str                  (char *str, double number, uint8 point_bit);
uint32      func_str_to_hex                     (char *str);
void        func_hex_to_str                     (char *str, uint32 number);

uint32      zf_sprintf                          (int8 *buff, const int8 *format, ...);
//=====================================================溯=====================================================

#endif
