/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_common_debug
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/

#ifndef _zf_common_debug_h_
#define _zf_common_debug_h_

#include "zf_common_typedef.h"

// ޸Ĵڲ debug UART жϽ Ҫͬ debug_interrupr_handler ӦжϷ
// ޸Ĵڲ debug UART жϽ Ҫͬ debug_interrupr_handler ӦжϷ
// ޸Ĵڲ debug UART жϽ Ҫͬ debug_interrupr_handler ӦжϷ
#define DEBUG_UART_INDEX            (UART_1)                                    // ָ debug uart ʹõĵĴ
#define DEBUG_UART_BAUDRATE         (115200)                                    // ָ debug uart ʹõĵĴڲ
#define DEBUG_UART_TX_PIN           (UART1_TX_B12 )                             // ָ debug uart ʹõĵĴ
#define DEBUG_UART_RX_PIN           (UART1_RX_B13)                              // ָ debug uart ʹõĵĴ

#define DEBUG_UART_USE_INTERRUPT    (0)                                         // Ƿ debug uart ж

//-------------------------------------------------------------------------------------------------------------------
//      
// ˵     x           жǷ񴥷 0- 1-
// ز     void
// ʹʾ     zf_assert(0);
// עϢ     һڲж zf_assert(0) ͶԱ
//              Ĭ» Debug UART 
//              ʹÿԴĻӿڳʼĻ Ļʾ
//-------------------------------------------------------------------------------------------------------------------
#define zf_assert(x)                (debug_assert_handler((x), __FILE__, __LINE__))

//-------------------------------------------------------------------------------------------------------------------
//      Log Ϣ
// ˵     x           жǷ񴥷 0- 1-
// ˵     *str        Ҫ Log Ϣ
// ز     void
// ʹʾ     zf_log(0, "Error");
// עϢ     Ϣ һЩ߾֮
//              Ĭ» Debug UART 
//              ʹÿԴĻӿڳʼĻ Ļʾ
//-------------------------------------------------------------------------------------------------------------------
#define zf_log(x, str)              (debug_log_handler((x), (str), __FILE__, __LINE__))

typedef struct
{
    uint16 type_index;                                                          // ʾ 0- 1-Ļ

    uint16 display_x_max;                                                       // ĻʾΧ
    uint16 display_y_max;                                                       // ĻʾΧ

    uint8 font_x_size;                                                          // ĻʾС
    uint8 font_y_size;                                                          // ĻʾС

    void (*output_uart)             (const char *str);                          // ʾָ
    void (*output_screen)           (uint16 x, uint16 y, const char *str);      // Ļַʾָ
    void (*output_screen_clear)     (void);                                     // Ļָ
}debug_output_struct;

#if DEBUG_UART_USE_INTERRUPT                                                    //  debug uart ж
#define     DEBUG_RING_BUFFER_LEN   (64)                                        // 廷λС Ĭ 64byte
void        debug_interrupr_handler (void);
uint32      debug_read_ring_buffer  (uint8 *data);
#endif

void        debug_assert_enable         (void);
void        debug_assert_disable        (void);
void        debug_assert_handler        (uint8 pass, char *file, int line);
void        debug_log_handler           (uint8 pass, char *str, char *file, int line);
void        debug_output_struct_init    (debug_output_struct *info);
void        debug_output_init           (debug_output_struct *info);
void        debug_init                  (void);

#endif
