/*********************************************************************************************************************
* RT1064DVL6A Opensourec Library RT1064DVL6A Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
* 
* ļ RT1064DVL6A Դһ
* 
* RT1064DVL6A Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
* 
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
* 
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
* 
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          zf_common_debug
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           IAR 8.32.4 or MDK 5.33
* ƽ̨          RT1064DVL6A
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2022-09-21        SeekFree            first version
********************************************************************************************************************/

#include "fsl_pwm.h"
#include "zf_common_fifo.h"
#include "zf_common_interrupt.h"
#include "zf_driver_gpio.h"
#include "zf_driver_pwm.h"
#include "zf_driver_uart.h"

#include "zf_common_debug.h"

#if DEBUG_UART_USE_INTERRUPT                                                    //  debug uart ж
uint8                       debug_uart_buffer[DEBUG_RING_BUFFER_LEN];           // ݴ
uint8                       debug_uart_data;
fifo_struct                 debug_uart_fifo;
#endif

static debug_output_struct  debug_output_info;
static volatile uint8       zf_debug_init_flag = 0;
static volatile uint8       zf_debug_assert_enable = 1;

//-------------------------------------------------------------------------------------------------------------------
//      debug ʱ  120MHz һʱ ƬҪݸʱ
// ˵     void
// ز     void
// ʹʾ     debug_delay();
// עϢ     ļڲ ûùע Ҳ޸
//-------------------------------------------------------------------------------------------------------------------
static void debug_delay (void)
{
    vuint32 loop_1 = 0, loop_2 = 0;
    for(loop_1 = 0; loop_1 <= 0xFF; loop_1 ++)
    {
        for(loop_2 = 0; loop_2 <= 0xFFFF; loop_2 ++)
        {
            __NOP();
        }
    }
}

//-------------------------------------------------------------------------------------------------------------------
//      debug  ҪǷֹԺźάֶӲʧ
// ˵     void
// ز     void
// ʹʾ     debug_protective_handler();
// עϢ     ļڲ ûùע Ҳ޸
//-------------------------------------------------------------------------------------------------------------------
static void debug_protective_handler (void)
{
    pwm_set_duty(PWM1_MODULE0_CHB_D13, 0);
    pwm_set_duty(PWM1_MODULE0_CHA_D12, 0);
    pwm_set_duty(PWM1_MODULE1_CHB_D15, 0);
    pwm_set_duty(PWM1_MODULE1_CHA_D14, 0);
    pwm_set_duty(PWM1_MODULE2_CHB_D17, 0);
    pwm_set_duty(PWM1_MODULE2_CHA_D16, 0);
    pwm_set_duty(PWM1_MODULE3_CHB_B11, 0);
    pwm_set_duty(PWM1_MODULE3_CHA_B10, 0);
    
    
    pwm_set_duty(PWM2_MODULE0_CHB_C7, 0);
    pwm_set_duty(PWM2_MODULE0_CHA_C6, 0);
    pwm_set_duty(PWM2_MODULE1_CHB_C9, 0);
    pwm_set_duty(PWM2_MODULE1_CHA_C8, 0);
    pwm_set_duty(PWM2_MODULE2_CHB_C11, 0);
    pwm_set_duty(PWM2_MODULE2_CHA_C10, 0);
    pwm_set_duty(PWM2_MODULE3_CHB_B1, 0);
    pwm_set_duty(PWM2_MODULE3_CHA_B0, 0);
    
    pwm_set_duty(PWM4_MODULE0_CHA_B24, 0);
    pwm_set_duty(PWM4_MODULE1_CHA_B25, 0);
    pwm_set_duty(PWM4_MODULE2_CHA_C30, 0);
    pwm_set_duty(PWM4_MODULE3_CHA_C31, 0);
}

//-------------------------------------------------------------------------------------------------------------------
//      debug ӿ
// ˵     *str        Ҫַ
// ز     void
// ʹʾ     debug_uart_str_output("Log message");
// עϢ     ļڲ ûùע Ҳ޸
//-------------------------------------------------------------------------------------------------------------------
static void debug_uart_str_output (const char *str)
{
    uart_write_string(DEBUG_UART_INDEX, str);
}

//-------------------------------------------------------------------------------------------------------------------
//      debug ӿ
// ˵     *type       log 
// ˵     *file       ļ
// ˵     line        Ŀ
// ˵     *str        Ϣ
// ز     void
// ʹʾ     debug_output("Log message", file, line, str);
// עϢ     ļڲ ûùע Ҳ޸
//-------------------------------------------------------------------------------------------------------------------
static void debug_output (char *type, char *file, int line, char *str)
{
    char *file_str;
    vuint16 i = 0, j = 0;
    vint16 len_origin = 0;
    vint16 show_len = 0;
    vint16 show_line_index = 0;
    len_origin = strlen(file);

    char output_buffer[256];
    char file_path_buffer[64];

    if(debug_output_info.type_index)
    {
        debug_output_info.output_screen_clear();
    }

    if(zf_debug_init_flag)
    {
        if(debug_output_info.type_index)
        {
            // Ҫнļ·
            // <· ֻһĿ¼  src/main.c>
            //  line : xxxx
            debug_output_info.output_screen(0, show_line_index ++, type);

            file_str = file;
            len_origin = strlen(file);
            show_len = (debug_output_info.display_x_max / debug_output_info.font_x_size);

            while(*file_str++ != '\0');

            // ֻȡһĿ¼ ļ̷Ŀ¼  MDK Ĺ̸Ŀ¼ ͻֱǰĿ¼
            for(j = 0; (j < 2) && (len_origin >= 0); len_origin --)             //  '/'
            {
                file_str --;
                if((*file_str == '/') || (*file_str == 0x5C))
                {
                    j ++;
                }
            }

            // ļ·浽
            if(len_origin >= 0)
            {
                file_str ++;
                sprintf(output_buffer, "file: %s", file_str);
            }
            else
            {
                if(0 == j)
                {
                    sprintf(output_buffer, "file: mdk/%s", file_str);
                }
                else
                {
                    sprintf(output_buffer, "file: %s", file_str);
                }
            }

            // Ļʾ·
            for(i = 0; i < ((strlen(output_buffer) / show_len) + 1); i ++)
            {
                for(j = 0; j < show_len; j ++)
                {
                    if(strlen(output_buffer) < (j + i * show_len))
                    {
                        break;
                    }
                    file_path_buffer[j] = output_buffer[j + i * show_len];
                }
                
                file_path_buffer[j] = '\0';                                     // ĩβ\0
                
                debug_output_info.output_screen(0, debug_output_info.font_y_size * show_line_index ++, file_path_buffer);
            }

            // Ļʾк
            sprintf(output_buffer, "line: %d", line);
            debug_output_info.output_screen(0, debug_output_info.font_y_size * show_line_index ++, output_buffer);

            // Ļʾ Log еĻ
            if(NULL != str)
            {
                for(i = 0; i < ((strlen(str) / show_len) + 1); i ++)
                {
                    for(j = 0; j < show_len; j ++)
                    {
                        if(strlen(str) < (j + i * show_len))
                        {
                            break;
                        }
                        file_path_buffer[j] = str[j + i * show_len];
                    }
                    
                    file_path_buffer[j] = '\0';                                 // ĩβ\0
                    
                    debug_output_info.output_screen(0, debug_output_info.font_y_size * show_line_index ++, file_path_buffer);
                }
            }
        }
        else
        {
            char output_buffer[256];
            memset(output_buffer, 0, 256);
            debug_output_info.output_uart(type);
            if(NULL != str)
            {
                sprintf(output_buffer, "\r\nfile %s line %d: %s.\r\n", file, line, str);
            }
            else
            {
                sprintf(output_buffer, "\r\nfile %s line %d.\r\n", file, line);
            }
            debug_output_info.output_uart(output_buffer);
        }
    }
}

#if DEBUG_UART_USE_INTERRUPT                                                    //  ֻôжϲű

//-------------------------------------------------------------------------------------------------------------------
//      ȡ debug λ
// ˵     *data       ݴŵָ
// ز     uint32      ݵʵʳ
// ʹʾ     uint8 data[64]; uint32 len = debug_read_ring_buffer(data);
// עϢ     Ҫ DEBUG_UART_USE_INTERRUPT 궨ſʹ
//-------------------------------------------------------------------------------------------------------------------
uint32 debug_read_ring_buffer (uint8 *data)
{
    uint32 data_len = sizeof(data);
    fifo_read_buffer(&debug_uart_fifo, data, &data_len, FIFO_READ_AND_CLEAN);
    return data_len;
}

//-------------------------------------------------------------------------------------------------------------------
//      debug жϴ isr.c жӦжϷ
// ˵     void
// ز     void
// ʹʾ     debug_interrupr_handler();
// עϢ     Ҫ DEBUG_UART_USE_INTERRUPT 궨ſʹ
//              ұĬϷ UART1 Ĵڽжϴ
//-------------------------------------------------------------------------------------------------------------------
void debug_interrupr_handler (void)
{
    if(zf_debug_init_flag)
    {
        uart_query_byte(DEBUG_UART_INDEX, &debug_uart_data);                    // ȡ
        fifo_write_buffer(&debug_uart_fifo, &debug_uart_data, 1);               //  FIFO
    }
}

#endif

//-------------------------------------------------------------------------     // printf ض ˲ֲû
#if defined(__ICCARM__)
#define PUTCHAR_PROTOTYPE int32_t fputc (int32_t ch, FILE *f)
#define GETCHAR_PROTOTYPE int32_t fgetc (FILE *f)
#elif defined(__GNUC__)
#define PUTCHAR_PROTOTYPE int32_t __io_putchar (int32_t ch)
#define GETCHAR_PROTOTYPE int32_t __io_getchar ()
#endif

#if defined(__ICCARM__)
PUTCHAR_PROTOTYPE
{
    uart_write_byte(DEBUG_UART_INDEX, (ch & 0xFF));
    return ch;
}

GETCHAR_PROTOTYPE
{
    return uart_read_byte(DEBUG_UART_INDEX);
}
#else
int32_t fputc (int32_t ch, FILE* f)
{
    uart_write_byte(DEBUG_UART_INDEX, (ch & 0xFF));
    return ch;
}

int fgetc(FILE *f)
{
    return uart_read_byte(DEBUG_UART_INDEX);
}
#endif
//-------------------------------------------------------------------------     // printf ض ˲ֲû

//-------------------------------------------------------------------------------------------------------------------
//      ö
// ˵     void
// ز     void
// ʹʾ     debug_assert_enable();
// עϢ     ĬϿ 鿪
//-------------------------------------------------------------------------------------------------------------------
void debug_assert_enable (void)
{
    zf_debug_assert_enable = 1;
}

//-------------------------------------------------------------------------------------------------------------------
//      ö
// ˵     void
// ز     void
// ʹʾ     debug_assert_disable();
// עϢ     ĬϿ ö
//-------------------------------------------------------------------------------------------------------------------
void debug_assert_disable (void)
{
    zf_debug_assert_enable = 0;
}

//-------------------------------------------------------------------------------------------------------------------
//      debug Դ
// ˵     pass        жǷ񴥷
// ˵     *file       ļ
// ˵     line        Ŀ
// ز     void
// ʹʾ     zf_assert(0);
// עϢ     ֱӵõ ˲ֲû
//              ʹ zf_commmon_debug.h е zf_assert(x) ӿ
//-------------------------------------------------------------------------------------------------------------------
void debug_assert_handler (uint8 pass, char *file, int line)
{
    do
    {
        if(pass || !zf_debug_assert_enable)
        {
            break;
        }

        static uint8 assert_nest_index = 0;

        if(0 != assert_nest_index)
        {
            while(1);
        }
        assert_nest_index ++;

        interrupt_global_disable();
        debug_protective_handler();

        while(1)
        {
            // תͣס
            // һĺݳ
            // Լõ zf_assert(x) ӿڴ

            //  debug_init ʼ log 
            // ڶӦȥ鿴ĸļһб

            // ûгʼ debug
            // ǾͿ file ֵַ line 
            // Ǵļ·ƺͶӦ

            // ȥԿΪʲô

            debug_output("Assert error", file, line, NULL);
            debug_delay();
        }
    }while(0);
}

//-------------------------------------------------------------------------------------------------------------------
//      debug Ϣ
// ˵     pass        жǷ񴥷
// ˵     *str        Ϣ
// ˵     *file       ļ
// ˵     line        Ŀ
// ز     void
// ʹʾ     zf_log(0, "Log Message");
// עϢ     ֱӵõ ˲ֲû
//              ʹ zf_commmon_debug.h е zf_log(x, str) ӿ
//-------------------------------------------------------------------------------------------------------------------
void debug_log_handler (uint8 pass, char *str, char *file, int line)
{
    do
    {
        if(pass)
        {
            break;
        }
        if(zf_debug_init_flag)
        {
            debug_output("Log message", file, line, str);
            //printf("Log message from %s line %d :\"%s\".\r\n", file, line, str);
        }
    }while(0);
}

//-------------------------------------------------------------------------------------------------------------------
//      debug Ϣʼ
// ˵     *info       debug Ϣṹ
// ز     void
// ʹʾ     debug_output_struct_init(info);
// עϢ     һ㲻û
//-------------------------------------------------------------------------------------------------------------------
void debug_output_struct_init (debug_output_struct *info)
{
    info->type_index            = 0;

    info->display_x_max         = 0xFFFF;
    info->display_y_max         = 0xFFFF;

    info->font_x_size           = 0xFF;
    info->font_y_size           = 0xFF;

    info->output_uart           = NULL;
    info->output_screen         = NULL;
    info->output_screen_clear   = NULL;
}

//-------------------------------------------------------------------------------------------------------------------
//      debug 󶨳ʼ
// ˵     *info       debug Ϣṹ
// ز     void
// ʹʾ     debug_output_init(info);
// עϢ     һ㲻û
//-------------------------------------------------------------------------------------------------------------------
void debug_output_init (debug_output_struct *info)
{
    debug_output_info.type_index            = info->type_index;

    debug_output_info.display_x_max         = info->display_x_max;
    debug_output_info.display_y_max         = info->display_y_max;

    debug_output_info.font_x_size           = info->font_x_size;
    debug_output_info.font_y_size           = info->font_y_size;
    
    debug_output_info.output_uart           = info->output_uart;
    debug_output_info.output_screen         = info->output_screen;
    debug_output_info.output_screen_clear   = info->output_screen_clear;

    zf_debug_init_flag = 1;
}

//-------------------------------------------------------------------------------------------------------------------
//      debug ڳʼ
// ˵     void
// ز     void
// ʹʾ     debug_init();
// עϢ     ԴʾĬϵ ĬϽжϽ
//-------------------------------------------------------------------------------------------------------------------
void debug_init (void)
{
    debug_output_struct info;
    debug_output_struct_init(&info);
    info.output_uart = debug_uart_str_output;
    debug_output_init(&info);

    uart_init(
        DEBUG_UART_INDEX,                                                       //  zf_common_debug.h в鿴Ӧֵ
        DEBUG_UART_BAUDRATE,                                                    //  zf_common_debug.h в鿴Ӧֵ
        DEBUG_UART_TX_PIN,                                                      //  zf_common_debug.h в鿴Ӧֵ
        DEBUG_UART_RX_PIN);                                                     //  zf_common_debug.h в鿴Ӧֵ

#if DEBUG_UART_USE_INTERRUPT                                                    //  ֻôжϲű
    fifo_init(&debug_uart_fifo, FIFO_DATA_8BIT, debug_uart_buffer, DEBUG_RING_BUFFER_LEN);
    uart_rx_interrupt(DEBUG_UART_INDEX, 1);                                     // ʹܶӦڽж
#endif
}

