/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_driver_pit
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding            first version
********************************************************************************************************************/

#ifndef _zf_driver_pit_h_
#define _zf_driver_pit_h_

#include "zf_common_typedef.h"

typedef enum // öͨ
{
    CCU60_CH0,
    CCU60_CH1,
    CCU61_CH0,
    CCU61_CH1,
}pit_index_enum;


#define pit_clear_flag(pit_index) (IfxCcu6_clearInterruptStatusFlag(IfxCcu6_getAddress((IfxCcu6_Index)(pit_index / 2)), (IfxCcu6_InterruptSource)(7+((pit_index % 2)*2))))

//====================================================PIT ====================================================
void pit_close               (pit_index_enum pit_index);
void pit_start               (pit_index_enum pit_index);
void pit_all_close           (void);
void pit_disable             (pit_index_enum pit_index);
void pit_enable              (pit_index_enum pit_index);
void pit_init                (pit_index_enum pit_index, uint32 time);
//====================================================PIT ====================================================

//====================================================PIT չ====================================================
//-------------------------------------------------------------------------------------------------------------------
//        pit_msʼ
//  ˵      pit_index           ѡCCU6ģ
//  ˵      time                ʱ(λ)
//  ز      void
//  ʹʾ      pit_ms_init(CCU60_CH0, 5);      // ж5ms
//-------------------------------------------------------------------------------------------------------------------
#define pit_ms_init(pit_index, time)  pit_init((pit_index), (time*1000))   // (λΪ )
//-------------------------------------------------------------------------------------------------------------------
//        pit_usʼ
//  ˵      pit_index           ѡCCU6ģ
//  ˵      time                ʱ(λ΢)
//  ز      void
//  ʹʾ      pit_us_init(CCU60_CH0, 5);      // ж5us
//-------------------------------------------------------------------------------------------------------------------
#define pit_us_init(pit_index, time)  pit_init((pit_index), (time))        // (λΪ ΢)
//====================================================PIT չ====================================================

#endif
