/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_driver_gpio
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding            first version
********************************************************************************************************************/

#include "zf_driver_gpio.h"

//-------------------------------------------------------------------------------------------------------------------
//        ȡGPIOַ
//  ˵      pin         ѡ (ѡΧ zf_driver_gpio.h gpio_pin_enumöֵȷ)
//  ز      void
//  ʹʾ      get_port(P00_0)
//  עϢ      ļڲ ûùע Ҳ޸
//-------------------------------------------------------------------------------------------------------------------
Ifx_P* get_port (gpio_pin_enum pin)
{
    volatile Ifx_P *port;

    switch(pin&0xffe0)
    {
        case P00_0: port = &MODULE_P00; break;
        case P02_0: port = &MODULE_P02; break;
        case P10_0: port = &MODULE_P10; break;
        case P11_0: port = &MODULE_P11; break;
        case P13_0: port = &MODULE_P13; break;
        case P14_0: port = &MODULE_P14; break;
        case P15_0: port = &MODULE_P15; break;
        case P20_0: port = &MODULE_P20; break;
        case P21_0: port = &MODULE_P21; break;
        case P22_0: port = &MODULE_P22; break;
        case P23_0: port = &MODULE_P23; break;
        case P32_0: port = &MODULE_P32; break;
        case P33_0: port = &MODULE_P33; break;
        default:break;
    }
#pragma warning 507
    return port;
#pragma warning default
}

//-------------------------------------------------------------------------------------------------------------------
//      gpio 
// ˵     pin         ѡ (ѡΧ zf_driver_gpio.h  gpio_pin_enum öֵȷ)
// ˵     dat         0͵ƽ 1ߵƽ
// ز     void
// ʹʾ     gpio_set_level(P00_0, 1);// P00_0 ߵƽ
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void gpio_set_level (gpio_pin_enum pin, uint8 dat)
{
    if(dat)
    {
        IfxPort_setPinHigh(get_port(pin), pin&0x1f);
    }
    else
    {
        IfxPort_setPinLow(get_port(pin), pin&0x1f);
    }
}
//-------------------------------------------------------------------------------------------------------------------
//      gpio ƽȡ
// ˵     pin         ѡ (ѡΧ zf_driver_gpio.h  gpio_pin_enum öֵȷ)
// ز     uint8       ŵǰƽ
// ʹʾ     uint8 status = gpio_get_level(P00_0);// ȡP00_0ŵƽ
// עϢ
//-------------------------------------------------------------------------------------------------------------------
uint8 gpio_get_level (gpio_pin_enum pin)
{
    return IfxPort_getPinState(get_port(pin), pin&0x1f);
}

//-------------------------------------------------------------------------------------------------------------------
//      gpio תƽ
// ˵     pin         ѡ (ѡΧ zf_driver_gpio.h  gpio_pin_enum öֵȷ)
// ز     void
// ʹʾ     gpio_toggle_level(P00_0);// P00_0ŵƽת
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void gpio_toggle_level (gpio_pin_enum pin)
{
    IfxPort_togglePin(get_port(pin), pin&0x1f);
}

//-------------------------------------------------------------------------------------------------------------------
//      gpio 
// ˵     pin         ѡ (ѡΧ zf_driver_gpio.h  gpio_pin_enum öֵȷ)
// ˵     dir         ŵķ   GPO   룺GPI
// ˵     mode        ŵģʽ (ѡΧ zf_driver_gpio.h  gpio_mode_enum öֵȷ)
// ز     void
// ʹʾ     gpio_dir(P00_0, GPO, GPO_PUSH_PULL);// P00_0Ϊģʽ
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void gpio_set_dir (gpio_pin_enum pin, gpio_dir_enum dir, gpio_mode_enum pinmode)
{
    IfxPort_Mode port_mode;
    if(dir == GPI)
    {
        switch(pinmode)
        {
            case GPI_FLOATING_IN:port_mode = IfxPort_Mode_inputNoPullDevice ;       break; // 
            case GPI_PULL_DOWN  :port_mode = IfxPort_Mode_inputPullDown     ;       break; // 
            default:             port_mode = IfxPort_Mode_inputPullUp       ;       break; // ĬΪ
        }
    }
    else
    {
        switch(pinmode)
        {
            case GPO_OPEN_DTAIN :port_mode = IfxPort_Mode_outputOpenDrainGeneral;   break;// ©
            default:             port_mode = IfxPort_Mode_outputPushPullGeneral ;   break;// ĬΪ
        }
    }

    IfxPort_setPinMode(get_port(pin), pin&0x1f, port_mode);
}

//-------------------------------------------------------------------------------------------------------------------
//      gpio ʼ
// ˵     pin         ѡ (ѡΧ zf_driver_gpio.h  gpio_pin_enum öֵȷ)
// ˵     mode        ŵķ [GPI/GPIO]
// ˵     dat         ųʼʱõĵƽ״̬ʱЧ 0͵ƽ 1ߵƽ ΪģʽʱЧ
// ˵     mode        ŵģʽ (ѡΧ zf_driver_gpio.h  gpio_mode_enum öֵȷ)
// ز     void
// ʹʾ     gpio_init(P00_0, GPO, 1, GPO_PUSH_PULL); // P00_0ʼΪGPIOܡģʽߵƽ
// עϢ     ҪرעP20_2ǲģֻĹ
//-------------------------------------------------------------------------------------------------------------------
void gpio_init (gpio_pin_enum pin, gpio_dir_enum dir, uint8 dat, gpio_mode_enum pinmode)
{
    IfxPort_Mode port_mode;

    if(dir == GPI)
    {
        switch(pinmode)
        {
            case GPI_FLOATING_IN:port_mode = IfxPort_Mode_inputNoPullDevice ;       break; // 
            case GPI_PULL_DOWN  :port_mode = IfxPort_Mode_inputPullDown     ;       break; // 
            default:             port_mode = IfxPort_Mode_inputPullUp       ;       break; // ĬΪ
        }
    }
    else
    {
        switch(pinmode)
        {
            case GPO_OPEN_DTAIN :port_mode = IfxPort_Mode_outputOpenDrainGeneral;   break;// ©
            default:             port_mode = IfxPort_Mode_outputPushPullGeneral ;   break;// ĬΪ
        }
    }

    IfxPort_setPinMode(get_port(pin), pin&0x1f, port_mode);

    IfxPort_setPinPadDriver(get_port(pin), pin&0x1f, IfxPort_PadDriver_cmosAutomotiveSpeed1);

    if(dir == GPO)
    {
        if(dat)
        {
            IfxPort_setPinHigh(get_port(pin), pin&0x1f);
        }
        else
        {
            IfxPort_setPinLow(get_port(pin), pin&0x1f);
        }
    }

}
