/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_driver_flash
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding            first version
* 2023-07-14       pudding            ޸ע
********************************************************************************************************************/

#ifndef _zf_driver_flash_h_
#define _zf_driver_flash_h_

#include "ifxFlash_cfg.h"
#include "zf_common_typedef.h"

#define EEPROM_BASE_ADDR             (IFXFLASH_DFLASH_START)
#define EEPROM_SIZE                  (IFXFLASH_DFLASH_SIZE)                     // һ256KB
#define EEPROM_PAGE_SIZE             (EEPROM_SIZE / IFXFLASH_DFLASH_NUM_LOG_SECTORS)
#define EEPROM_PAGE_NUM              (IFXFLASH_DFLASH_NUM_LOG_SECTORS)          // 256KBΪ64ҳ

#define FLASH_DATA_SIZE              (IFXFLASH_DFLASH_PAGE_LENGTH)
#define EEPROM_PAGE_LENGTH           (EEPROM_PAGE_SIZE/FLASH_DATA_SIZE)         // ÿҳԴ512uint32͵


typedef union                                                                   // ̶ݻ嵥Ԫʽ
{
    float   float_type;                                                         // float  
    uint32  uint32_type;                                                        // uint32 
    int32   int32_type;                                                         // int32  
    uint16  uint16_type;                                                        // uint16 
    int16   int16_type;                                                         // int16  
    uint8   uint8_type;                                                         // uint8  
    int8    int8_type;                                                          // int8   
}flash_data_union;                                                              // ݹͬһ 32bit ַ

extern flash_data_union flash_union_buffer[EEPROM_PAGE_LENGTH];

//====================================================FLASH ====================================================
uint8   flash_check                     (uint32 sector_num, uint32 page_num);                                   // УFLASHҳǷ
void    flash_erase_page                (uint32 sector_num, uint32 page_num);                                   // ҳ
void    flash_read_page                 (uint32 sector_num, uint32 page_num, uint32 *buf, uint16 len);          // ȡһҳ
void    flash_write_page                (uint32 sector_num, uint32 page_num, const uint32 *buf, uint16 len);    // һҳ
void    flash_read_page_to_buffer       (uint32 sector_num, uint32 page_num);                                   // ָ FLASH ָҳȡݵ
uint8   flash_write_page_from_buffer    (uint32 sector_num, uint32 page_num);                                   // ָ FLASH ָҳд뻺
void    flash_buffer_clear              (void);                                                                 // ݻ
//====================================================FALSH ====================================================


#endif
