/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_driver_delay
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding            first version
* 2023-11-28       pudding            ޸ͨʱ߼ΪжϴжϹرʹüĴѭȡʱ
********************************************************************************************************************/

#include "IfxStm.h"
#include "IFXSTM_CFG.h"
#include "SysSe/Bsp/Bsp.h"
#include "zf_common_interrupt.h"
#include "zf_driver_delay.h"


#define IFX_INTPRIO_STM0_SR0  220
#define IFX_INTPRIO_STM1_SR0  221
#define IFX_INTPRIO_STM2_SR0  222

static vuint8 stm0_isr_flag = 1;
static vuint8 stm1_isr_flag = 1;
static vuint8 stm2_isr_flag = 1;

IFX_INTERRUPT(stm0_isr, 0, IFX_INTPRIO_STM0_SR0)
{
    interrupt_global_enable(0);                     // жǶ
    IfxStm_clearCompareFlag(&MODULE_STM0, IfxStm_Comparator_0);
    stm0_isr_flag = 0;
}

IFX_INTERRUPT(stm1_isr, 1, IFX_INTPRIO_STM1_SR0)
{
    interrupt_global_enable(0);                     // жǶ
    IfxStm_clearCompareFlag(&MODULE_STM1, IfxStm_Comparator_0);
    stm1_isr_flag = 0;
}

IFX_INTERRUPT(stm2_isr, 2, IFX_INTPRIO_STM2_SR0)
{
    interrupt_global_enable(0);                     // жǶ
    IfxStm_clearCompareFlag(&MODULE_STM2, IfxStm_Comparator_0);
    stm2_isr_flag = 0;
}
//-------------------------------------------------------------------------------------------------------------------
//        systemʱ
//  ˵      time            ʱһֵʱ䣨λΪ룬÷Χ0-20000000
//  ز      void
//  ʹʾ      ûãûʹhļеĺ궨 // 100Mʱ СλΪ 10ns
//-------------------------------------------------------------------------------------------------------------------
void system_delay_10ns (uint32 time)
{
    uint32 interrupt_global_state;

    IfxStm_Index stm_index;

    stm_index = (IfxStm_Index)IfxCpu_getCoreId();

    if(areInterruptsEnabled() == 0)
    {
        IfxStm_waitTicks(IfxStm_getAddress(stm_index), time);
    }
    else
    {
        switch(stm_index)
        {
            case IfxStm_Index_0:
            {
                Ifx_STM *stm_sfr = &MODULE_STM0;
                stm0_isr_flag = 1;
                interrupt_global_state = interrupt_global_disable();     // رȫж
                stm_sfr->CMP[0].U = stm_sfr->TIM0.U + time;
                interrupt_global_enable(interrupt_global_state);         // ȫж
                while(stm0_isr_flag);
            }break;
            case IfxStm_Index_1:
            {
                Ifx_STM *stm_sfr = &MODULE_STM1;
                stm1_isr_flag = 1;
                interrupt_global_state = interrupt_global_disable();     // رȫж
                stm_sfr->CMP[0].U = stm_sfr->TIM0.U + time;
                interrupt_global_enable(interrupt_global_state);         // ȫж
                while(stm1_isr_flag);
            }break;
            case IfxStm_Index_2:
            {
                Ifx_STM *stm_sfr = &MODULE_STM2;
                stm2_isr_flag = 1;
                interrupt_global_state = interrupt_global_disable();     // رȫж
                stm_sfr->CMP[0].U = stm_sfr->TIM0.U + time;
                interrupt_global_enable(interrupt_global_state);         // ȫж
                while(stm2_isr_flag);
            }break;
            case IfxStm_Index_none: break;
        }
    }
}

//-------------------------------------------------------------------------------------------------------------------
//        system ΢ ʱ(ʼĴ)
//  ˵      time            ʱʱ  λus
//  ز      void
//  ʹʾ      system_delay_us_register(100);  // ʱ100΢
//-------------------------------------------------------------------------------------------------------------------
void system_delay_us_register (uint32 time)
{
    IfxStm_Index stm_index;

    stm_index = (IfxStm_Index)IfxCpu_getCoreId();

    IfxStm_waitTicks(IfxStm_getAddress(stm_index), time * 100);
}

//-------------------------------------------------------------------------------------------------------------------
//        system ΢ ʱ
//  ˵      time            ʱʱ  λus
//  ز      void
//  ʹʾ      system_delay_us(100);  // ʱ100΢
//-------------------------------------------------------------------------------------------------------------------
void system_delay_us (uint32 time)
{
    if(time > 40000000)
    {
        while(time > 40000000)
        {
            system_delay_10ns(4000000000);
            time = time - 40000000;
        }
        system_delay_10ns(time * 100);
    }
    else
    {
        system_delay_10ns(time * 100);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//        system  ʱ
//  ˵      time            ʱʱ  λms
//  ز      void
//  ʹʾ      system_delay_ms(100);  // ʱ100
//-------------------------------------------------------------------------------------------------------------------
void system_delay_ms (uint32 time)
{
    if(time > 40000)
    {
        while(time > 40000)
        {
            system_delay_10ns(4000000000);
            time = time - 40000;
        }
        system_delay_10ns(time * 100000);
    }
    else
    {
        system_delay_10ns(time * 100000);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//        system ӳٳʼ
//  ز      void
//  ʹʾ      system_delay_init();
//-------------------------------------------------------------------------------------------------------------------
void system_delay_init(void)
{
    IfxStm_CompareConfig stmConfig;
    boolean interrupt_state = disableInterrupts();

    stmConfig.comparator          = IfxStm_Comparator_0;
    stmConfig.compareOffset       = IfxStm_ComparatorOffset_0;
    stmConfig.compareSize         = IfxStm_ComparatorSize_32Bits;
    stmConfig.comparatorInterrupt = IfxStm_ComparatorInterrupt_ir0;
    stmConfig.ticks               = 1;
    stmConfig.triggerPriority     = IFX_INTPRIO_STM0_SR0;
    stmConfig.typeOfService       = IfxSrc_Tos_cpu0;

    IfxStm_initCompare(&MODULE_STM0, &stmConfig);
    IfxStm_clearCompareFlag(&MODULE_STM0, IfxStm_Comparator_0);

    stmConfig.comparator          = IfxStm_Comparator_0;
    stmConfig.compareOffset       = IfxStm_ComparatorOffset_0;
    stmConfig.compareSize         = IfxStm_ComparatorSize_32Bits;
    stmConfig.comparatorInterrupt = IfxStm_ComparatorInterrupt_ir0;
    stmConfig.ticks               = 1;
    stmConfig.triggerPriority     = IFX_INTPRIO_STM1_SR0;
    stmConfig.typeOfService       = IfxSrc_Tos_cpu1;

    IfxStm_initCompare(&MODULE_STM1, &stmConfig);
    IfxStm_clearCompareFlag(&MODULE_STM1, IfxStm_Comparator_0);

    stmConfig.comparator          = IfxStm_Comparator_0;
    stmConfig.compareOffset       = IfxStm_ComparatorOffset_0;
    stmConfig.compareSize         = IfxStm_ComparatorSize_32Bits;
    stmConfig.comparatorInterrupt = IfxStm_ComparatorInterrupt_ir0;
    stmConfig.ticks               = 1;
    stmConfig.triggerPriority     = IFX_INTPRIO_STM2_SR0;
    stmConfig.typeOfService       = IfxSrc_Tos_cpu2;

    IfxStm_initCompare(&MODULE_STM2, &stmConfig);
    IfxStm_clearCompareFlag(&MODULE_STM2, IfxStm_Comparator_0);

    restoreInterrupts(interrupt_state);
}
