/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_wifi_uart
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding            first version
* 2023-04-28       pudding            ע˵
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   RX                  鿴 zf_device_wifi_uart.h  WIFI_UART_RX_PIN 궨
*                   TX                  鿴 zf_device_wifi_uart.h  WIFI_UART_TX_PIN 궨
*                   RTS                 鿴 zf_device_wifi_uart.h  WIFI_UART_RTS_PIN 궨
*                   RST                 鿴 zf_device_wifi_uart.h  WIFI_UART_RST_PIN 궨
*                   VCC                 5V Դ
*                   GND                 Դ
*                   
*                   ------------------------------------
*********************************************************************************************************************/

#ifndef _zf_device_wifi_uart_h_
#define _zf_device_wifi_uart_h_

#include "zf_common_typedef.h"

//============================================== WIFI_UART ===================================================
#define WIFI_UART_INDEX         (UART_2)                                        // WIFI ģ ʹõĴ
#define WIFI_UART_TX_PIN        (UART2_RX_P10_6)                                //  WIFI ģ TX
#define WIFI_UART_RX_PIN        (UART2_TX_P10_5)                                //  WIFI ģ RX
#define WIFI_UART_BAUD          (115200)                                        // ģ鹤
#define WIFI_UART_RTS_PIN       (P10_2)                                         // λ  ָʾǰģǷԽ  0-Լ  1-Լ
#define WIFI_UART_HARDWARE_RST  (1)                                             // ǷʹӲλ 0-ʹλ 1-ʹӲ RST
#if WIFI_UART_HARDWARE_RST                                                      // ʹӲλ ׳ֵƬλ޷ʼģ
#define WIFI_UART_RST_PIN       (P11_6)                                         // Ӳλ
#endif
//============================================== WIFI_UART ===================================================


//============================================== WIFI_UART ===================================================
#define WIFI_UART_BUFFER_SIZE   (256)                                           // ջС

#define WIFI_UART_AUTO_CONNECT  (0)                                             // ǷʼʱTCPUDP    0-  1-ԶTCP  2-ԶUDP  3ԶTCP

#if     (WIFI_UART_AUTO_CONNECT > 3)
#error "WIFI_UART_AUTO_CONNECT ֵֻΪ [0,1,2,3]"
#else
#define WIFI_UART_TARGET_IP     "192.168.137.1"                                 // Ŀ IP
#define WIFI_UART_TARGET_PORT   "8080"                                          // ĿĶ˿
#define WIFI_UART_LOCAL_PORT    "8080"                                          // ˿
#endif
//============================================== WIFI_UART ===================================================

//============================================== WIFI_UART ṹ==================================================
typedef enum
{
    WIFI_UART_STATION,                                                          // 豸ģʽ
    WIFI_UART_SOFTAP,                                                           // APģʽ
}wifi_uart_mode_enum;

typedef enum
{
    WIFI_UART_COMMAND,                                                          // ʹķʽ
    WIFI_UART_SERIANET,                                                         // ʹ͸ķʽ
}wifi_uart_transfer_mode_enum;

typedef enum
{
    WIFI_UART_TCP_CLIENT,                                                       // ģTCP
    WIFI_UART_TCP_SERVER,                                                       // ģΪTCP
    WIFI_UART_UDP_CLIENT,                                                       // ģUDP
}wifi_uart_connect_mode_enum;

typedef enum
{
    WIFI_UART_SERVER_OFF,                                                       // ģδӷ
    WIFI_UART_SERVER_ON,                                                        // ģѾӷ
}wifi_uart_connect_state_enum;

typedef enum
{
    WIFI_UART_LINK_0,                                                           // ģ鵱ǰ 0
    WIFI_UART_LINK_1,                                                           // ģ鵱ǰ 1
    WIFI_UART_LINK_2,                                                           // ģ鵱ǰ 2
    WIFI_UART_LINK_3,                                                           // ģ鵱ǰ 3
    WIFI_UART_LINK_4,                                                           // ģ鵱ǰ 4
}wifi_uart_link_id_enum;

typedef struct
{
    uint8                           wifi_uart_version[12];                      // ̼汾         ַʽ
    uint8                           wifi_uart_mac[20];                          //  MAC ַ    ַʽ
    uint8                           wifi_uart_local_ip[17];                     //  IP ַ     ַʽ
    uint8                           wifi_uart_local_port[10];                   // ˿ں       ַʽ
    uint8                           wifi_uart_remote_ip[5][17];                 // Զ IP ַ     ַʽ
    wifi_uart_mode_enum             wifi_uart_mode;                             // WIFI ģʽ
    wifi_uart_transfer_mode_enum    wifi_uart_transfer_mode;                    // ǰģʽ
    wifi_uart_connect_mode_enum     wifi_uart_connect_mode;                     // ģʽ
    wifi_uart_connect_state_enum    wifi_uart_connect_state;                    // 
}wifi_uart_information_struct;
//============================================== WIFI_UART ṹ==================================================


//============================================== WIFI_UART ȫֱ===================================================
extern wifi_uart_information_struct wifi_uart_information;
//============================================== WIFI_UART ȫֱ===================================================


//============================================== WIFI_UART ===================================================
uint8   wifi_uart_disconnected_wifi         (void);                                                                         // Ͽ WIFI 
uint8   wifi_uart_entry_serianet            (void);                                                                         // ͸ģʽ
uint8   wifi_uart_exit_serianet             (void);                                                                         // ر͸ģʽ

uint8   wifi_uart_connect_tcp_servers       (char *ip, char *port, wifi_uart_transfer_mode_enum mode);                      //  TCP 
uint8   wifi_uart_connect_udp_client        (char *ip, char *port, char *local_port, wifi_uart_transfer_mode_enum mode);    //  UDP 
uint8   wifi_uart_disconnect_link           (void);                                                                         // Ͽ TCP Server ʹñӿڽϿ
uint8   wifi_uart_disconnect_link_with_id   (wifi_uart_link_id_enum link_id);                                               // TCP Server Ͽָ TCP/UDP Client зӦ

uint8   wifi_uart_entry_tcp_servers         (char *port);                                                                   //  TCP 
uint8   wifi_uart_exit_tcp_servers          (void);                                                                         // ر TCP 
uint8   wifi_uart_tcp_servers_check_link    (void);                                                                         // TCP Server ģʽ¼鵱ǰ ȡ IP

uint32  wifi_uart_send_buffer               (const uint8 *buff, uint32 len);                                                // WIFI ģݷͺ
uint32  wifi_uart_tcp_servers_send_buffer   (const uint8 *buff, uint32 len, wifi_uart_link_id_enum id);                     // WIFI ģΪ TCP Server ָĿ豸ͺ
uint32  wifi_uart_read_buffer               (uint8 *buff, uint32 len);                                                      // WIFI ģݽպ

void    wifi_uart_callback                  (void);                                                                         // WIFI ģ鴮ڻص
uint8   wifi_uart_init                      (char *wifi_ssid, char *pass_word, wifi_uart_mode_enum wifi_mode);              // WIFI ģʼ
//============================================== WIFI_UART ===================================================

#endif
