/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_virtual_oscilloscope
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding            first version
********************************************************************************************************************/

#include "zf_device_virtual_oscilloscope.h"

uint8 virtual_oscilloscope_data[10];

//-------------------------------------------------------------------------------------------------------------------
//      CRC У
// ˵     buff            Ҫ CRC ݵַ
// ˵     crc_cnt         Ҫ CRC ݸ
// ز     uint16          CRC У
// ʹʾ     crc_16  = crc_check(virtual_oscilloscope_data, 8);
// עϢ     ڲʹ û
//-------------------------------------------------------------------------------------------------------------------
static uint16 crc_check (uint8 *buff, uint8 crc_cnt)
{
    uint16 crc_temp;
    uint8 i, j;
    crc_temp = 0xffff;

    for(i = 0; i < crc_cnt; i ++)
    {
        crc_temp ^= buff[i];
        for(j = 0; 8 > j; j ++)
        {
            if (crc_temp & 0x01)
            {
                crc_temp = (crc_temp >> 1) ^ 0xa001;
            }
            else
            {
                crc_temp = crc_temp >> 1;
            }
        }
    }
    return(crc_temp);
}

//-------------------------------------------------------------------------------------------------------------------
//      ʾת
// ˵     data1           Ҫ͵ĵһ
// ˵     data2           Ҫ͵ĵڶ
// ˵     data3           Ҫ͵ĵ
// ˵     data4           Ҫ͵ĵĸ
// ز     void
// ʹʾ     uint8 data_buffer[10];
//              virtual_oscilloscope_data_conversion(100, 200, 300, 400, data_buffer);
//              wireless_uart_send_buff(data_buffer, 10);
// עϢ      ֻǴ
//-------------------------------------------------------------------------------------------------------------------
void virtual_oscilloscope_data_conversion (const int16 data1, const int16 data2, const int16 data3, const int16 data4)
{
    uint16 crc_16 = 0;

    virtual_oscilloscope_data[0] = (uint8)((uint16)data1 & 0xff);
    virtual_oscilloscope_data[1] = (uint8)((uint16)data1 >> 8);

    virtual_oscilloscope_data[2] = (uint8)((uint16)data2 & 0xff);
    virtual_oscilloscope_data[3] = (uint8)((uint16)data2 >> 8);

    virtual_oscilloscope_data[4] = (uint8)((uint16)data3 & 0xff);
    virtual_oscilloscope_data[5] = (uint8)((uint16)data3>>8);

    virtual_oscilloscope_data[6] = (uint8)((uint16)data4 & 0xff);
    virtual_oscilloscope_data[7] = (uint8)((uint16)data4 >> 8);

    crc_16  = crc_check(virtual_oscilloscope_data, 8);
    virtual_oscilloscope_data[8] = (uint8)(crc_16 & 0xff);
    virtual_oscilloscope_data[9] = (uint8)(crc_16 >> 8);
}
