/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_type
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding            first version
* 2023-04-28       pudding            ע˵
* 2023-05-26       pudding            SPI WIFI жϻصָ
********************************************************************************************************************/

#ifndef _zf_device_type_h_
#define _zf_device_type_h_

#include "zf_common_debug.h"

//==============================================  ṹ==================================================
typedef enum
{
    NO_CAMERE = 0,                                                              // ͷ
    CAMERA_BIN_IIC,                                                             // С IIC 汾
    CAMERA_BIN_UART,                                                            // С UART 汾
    CAMERA_GRAYSCALE,                                                           // 
    CAMERA_COLOR,                                                               // ͫ
}camera_type_enum;

typedef enum
{
    NO_WIRELESS = 0,                                                            // 豸
    WIRELESS_UART,                                                              // ߴ
    BLUETOOTH_CH9141,                                                           //  CH9141
    WIFI_UART,                                                                  //  WiFi
    RECEIVER_UART,                                                              // ǹʽң
    LORA3A22_UART,
}wireless_type_enum;

typedef enum
{
    NO_TOF = 0,                                                                 // 豸
    TOF_DL1A,                                                                   // DL1A
    TOF_DL1B,                                                                   // DL1B
}tof_type_enum;
//==============================================  ṹ==================================================


//=========================================== صָ뼰 ==============================================
typedef void (*callback_function)(void);

extern wireless_type_enum wireless_type;
extern callback_function wireless_module_uart_handler;                          // ߴڽжϺָ룬ݳʼʱõĺת

extern camera_type_enum camera_type;
extern callback_function camera_dma_handler;                                    // ͨѶжϺָ룬ݳʼʱõĺת
extern callback_function camera_vsync_handler;                                  // ͨѶжϺָ룬ݳʼʱõĺת
extern callback_function camera_uart_handler;                                   // ͨѶжϺָ룬ݳʼʱõĺת
extern callback_function wireless_module_spi_handler;                           // WIFI SPI GPIOжϺָ룬ݳʼʱõĺת

extern tof_type_enum     tof_type;                                              // ToF ģ 
extern callback_function tof_module_exti_handler;                               // ToF ģ INT ж
//=========================================== صָ뼰 ==============================================


//============================================= жϻص ================================================
void   set_camera_type          (camera_type_enum type_set, callback_function vsync_callback, callback_function dma_callback, callback_function uart_callback);
void   set_wireless_type        (wireless_type_enum type_set, callback_function wireless_callback);
void   set_tof_type             (tof_type_enum type_set, callback_function exti_callback);
//============================================= жϻص ================================================

#endif
