/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_type
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding            first version
* 2023-05-26       pudding            SPI WIFI жϻصָ
* 2024-01-16       pudding            ƳSPI WIFI жϻصָ SPI WIFIʹⲿж
********************************************************************************************************************/

#include "zf_device_type.h"

static void type_default_callback(void);

camera_type_enum    camera_type                     = NO_CAMERE;                    // ͷͱ
callback_function   camera_uart_handler             = type_default_callback;        // ͨѶжϺָ룬ݳʼʱõĺת
callback_function   camera_vsync_handler            = type_default_callback;        // жϺָ룬ݳʼʱõĺת
callback_function   camera_dma_handler              = type_default_callback;        // DMAжϺָ룬ݳʼʱõĺת

wireless_type_enum  wireless_type                   = NO_WIRELESS;
callback_function   wireless_module_uart_handler    = type_default_callback;        // ߴڽжϺָ룬ݳʼʱõĺת

tof_type_enum       tof_type                        = NO_TOF;
callback_function   tof_module_exti_handler         = type_default_callback;        // ToF ģ INT ж

//-------------------------------------------------------------------------------------------------------------------
//      Ĭϻص
// ˵     void
// ز     void
// ʹʾ
// עϢ      ֹûгʼ豸ʱܷ
//-------------------------------------------------------------------------------------------------------------------
static void type_default_callback (void)
{

}
//-------------------------------------------------------------------------------------------------------------------
//      ͷ
// ˵     type_set        ѡͷ
// ˵     vsync_callback  豸ĳжϻص
// ˵     dma_callback    豸 DMA жϻص
// ˵     uart_callback   豸Ĵڻص
// ز     void
// ʹʾ     set_camera_type(CAMERA_GRAYSCALE);
// עϢ     һɸͷʼڲ
//-------------------------------------------------------------------------------------------------------------------
void  set_camera_type (camera_type_enum type_set, callback_function vsync_callback, callback_function dma_callback, callback_function uart_callback)
{
    camera_type = type_set;
    camera_uart_handler = ((uart_callback == NULL) ? (type_default_callback) : (uart_callback));
    camera_vsync_handler = ((vsync_callback == NULL) ? (type_default_callback) : (vsync_callback));
    camera_dma_handler = ((dma_callback == NULL) ? (type_default_callback) : (dma_callback));
}

//-------------------------------------------------------------------------------------------------------------------
//      ģ
// ˵     type_set        ѡģ
// ˵     uart_callback   豸Ĵڻص
// ز     void
// ʹʾ     set_wireless_type(WIRELESS_UART, uart_callback);
// עϢ     һɸͷʼڲ
//-------------------------------------------------------------------------------------------------------------------
void set_wireless_type (wireless_type_enum type_set, callback_function wireless_callback)
{
    wireless_type = type_set;
    wireless_module_uart_handler = ((wireless_callback == NULL) ? (type_default_callback) : (wireless_callback));
}
//-------------------------------------------------------------------------------------------------------------------
//       ToF ģ
// ˵     type_set        ѡ ToF ģ
// ˵     exti_callback   豸ⲿжϻص
// ز     void
// ʹʾ     set_tof_type(TOF_DL1A, dl1a_int_handler);
// עϢ     һɸͷʼڲ
//-------------------------------------------------------------------------------------------------------------------
void set_tof_type (tof_type_enum type_set, callback_function exti_callback)
{
    tof_type = type_set;
    tof_module_exti_handler = ((exti_callback == NULL) ? (type_default_callback) : (exti_callback));
}

