/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_scc8660
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-09-15       pudding            first version
* 2024-02-02       pudding            MCUͫ
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                  ------------------------------------
*                  ģܽ             Ƭܽ
*                  TXD                鿴 zf_device_scc8660.h  SCC8660_COF_UART_TX 궨
*                  RXD                鿴 zf_device_scc8660.h  SCC8660_COF_UART_RX 궨
*                  PCLK               鿴 zf_device_scc8660.h  SCC8660_PCLK_PIN 궨
*                  VSY                鿴 zf_device_scc8660.h  SCC8660_VSYNC_PIN 궨
*                  D0-D7              鿴 zf_device_scc8660.h  SCC8660_DATA_PIN 궨 Ӹö忪ʼ˸
*                  VCC                3.3VԴ
*                  GND                Դ
*                  
*                  ------------------------------------
********************************************************************************************************************/

#ifndef _zf_device_scc8660_h_
#define _zf_device_scc8660_h_

#include "zf_device_type.h"

//================================================ SCC8660 ================================================
#define SCC8660_COF_UART        (UART_1)                                        // ͷʹõĴ
#define SCC8660_COF_BAUR        (9600  )                                        // ͫ ôڲ
#define SCC8660_COF_UART_TX     (UART1_RX_P02_3)                                // ͫ UART-TX  ҪڵƬ RX 
#define SCC8660_COF_UART_RX     (UART1_TX_P02_2)                                // ͫ UART-RX  ҪڵƬ TX 

#define SCC8660_COF_IIC_DELAY   (800)                                           // ͫ IIC ʱ
#define SCC8660_COF_IIC_SCL     (P02_3)                                         // ͫ IIC-SCL 
#define SCC8660_COF_IIC_SDA     (P02_2)                                         // ͫ IIC-SDA 

#define SCC8660_DMA_CH          (IfxDma_ChannelId_5)
#define SCC8660_PCLK_PIN        (ERU_CH2_REQ14_P02_1)                           // PCLK ź TIM_ETR Žֹ޸
#define SCC8660_VSYNC_PIN       (ERU_CH3_REQ6_P02_0 )                           // ж
#define SCC8660_DATA_PIN        (P00_0)                                         //   ֻ GPIOx0  GPIOx8 ʼ ˸ F0-F7
#define SCC8660_DATA_ADD        (get_port_in_addr(SCC8660_DATA_PIN))

#define SCC8660_INIT_TIMEOUT    (0x00F0)                                        // Ĭϵͷʼʱʱ Ϊλ
//================================================ SCC8660 ================================================

//================================================ SCC8660 ã֧ͫ֡ʰ汾===========================
#define SCC8660_W               (160)                                           // ͼ ѡΪ160 80  40
#define SCC8660_H               (120)                                           // ͼ߶ ѡΪ120 160 240
#define SCC8660_IMAGE_SIZE      (SCC8660_W * 2 * SCC8660_H)                     // ͼС SCC8660_W*2*SCC8660_H ܳ 65535

#define SCC8660_AUTO_EXP_DEF    (0  )                                           // Զع     ĬϲԶع  Χ [0-1] 0Ϊر
#define SCC8660_BRIGHT_DEF      (500)                                           //      ֶعĬϣ300   ֶعʱΧ0-65535   ԶعƼֵ100 Զعʱ÷Χ0-255
#define SCC8660_FPS_DEF         (60 )                                           // ͼ֡     Ĭϣ50        ѡΪ60 50 30 25 ʵ֡ʻҪSCC8660_PCLK_DIV
#define SCC8660_PCLK_DIV_DEF    (2  )                                           // PCLKƵϵ Ĭϣ5         ѡΪ<0:1/1> <1:2/3> <2:1/2> <3:1/3> <4:1/4> <5:1/8>
                                                                                //              ƵϵԽPCLKƵԽͣPCLKԼDVPӿڵĸţPCLKƵӰ֡ʡ뱣Ĭϡ
                                                                                //              FPSΪ50֡pclkƵϵѡΪ5ͷ֡Ϊ50*1/8=6.25֡
                                                                                //              £SCC8660_PCLK_DIVԽͼԽ
#define SCC8660_PCLK_MODE_DEF   (0  )                                           // PCLKģʽ     Ĭϣ0         ѡΪ[0,1] 0ź 1ź <ͨΪ0ʹSTM32DCMIӿڲɼҪΪ1>
#define SCC8660_COLOR_MODE_DEF  (0  )                                           // ͼɫģʽ Ĭϣ0         ѡΪ[0,1] 0ɫģʽ   1ģʽɫʱͶߣ
#define SCC8660_DATA_FORMAT_DEF (0  )                                           // ݸʽ Ĭϣ0         ѡΪ[0-3] 0RGB565 1RGB565(ֽڽ) 2YUV422(YUYV) 3YUV422(UYVY)
#define SCC8660_MANUAL_WB_DEF   (0  )                                           // ֶƽ   Ĭϣ0         ѡΪ[0,0x65-0xa0] 0رֶƽ⣬Զƽ    ֶƽ ֶƽʱ Χ0x65-0xa0
//================================================ SCC8660 ã֧ͫ֡ʰ汾===========================

//=============================================== SCC8660 ṹ================================================
typedef enum
{
    SCC8660_INIT                = 0x00,                                         // ͷʼ
    SCC8660_AUTO_EXP,                                                           // Զع
    SCC8660_BRIGHT,                                                             // 
    SCC8660_FPS,                                                                // ͷ֡
    SCC8660_SET_COL,                                                            // ͼ
    SCC8660_SET_ROW,                                                            // ͼ
    SCC8660_PCLK_DIV,                                                           // ʱӷƵ
    SCC8660_PCLK_MODE,                                                          // ʱģʽ
    SCC8660_COLOR_MODE,                                                         // ɫģʽ
    SCC8660_DATA_FORMAT,                                                        // ݸʽ
    SCC8660_MANUAL_WB,                                                          // ֶƽ
    SCC8660_CONFIG_FINISH,                                                      // λҪռλ

    SCC8660_GET_WHO_AM_I        = 0xEF,                                         // ˭жͷͺ
    SCC8660_SET_BRIGHT          = 0xF0,                                         // 
    SCC8660_GET_STATUS          = 0XF1,                                         // ȡͷ
    SCC8660_GET_VERSION         = 0xF2,                                         // ̼汾
    SCC8660_SET_MANUAL_WB       = 0xF3,                                         // ֶƽ

    SCC8660_SET_REG_ADDR        = 0xFE,
    SCC8660_SET_REG_DATA        = 0xFF,
}scc8660_cmd_enum;
//=============================================== SCC8660 ṹ================================================

//===============================================ͷö=======================================================
typedef enum
{
    SCC8660_UART,
    SCC8660_SCCB,
}scc8660_type_enum;
//===============================================ͷö=======================================================

//=============================================== SCC8660 ȫֱ=================================================
extern vuint8       scc8660_finish_flag;                                        // һͼɼɱ־λ
extern uint16       scc8660_image[SCC8660_H][SCC8660_W];                        // ͼ񱣴
//=============================================== SCC8660 ȫֱ=================================================

//=============================================== SCC8660 =================================================
uint16      scc8660_get_id              (void);                                 // ȡͷ ID
uint16      scc8660_get_parameter       (uint16 config);                        // ͷعʱ
uint16      scc8660_get_version         (void);                                 // ȡɫͷ̼汾
uint8       scc8660_set_brightness      (uint16 data);                          // ͼ
uint8       scc8660_set_white_balance   (uint16 data);                          // ðƽ
uint8       scc8660_set_reg             (uint8 addr, uint16 data);              // ͷڲĴд
uint8       scc8660_init                (void);                                 // SCC8660 ͷʼ
//=============================================== SCC8660 =================================================
#endif

