/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_scc8660
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-09-15       pudding            first version
* 2024-02-02       pudding            MCUͫ
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                  ------------------------------------
*                  ģܽ             Ƭܽ
*                  TXD                鿴 zf_device_scc8660.h  SCC8660_COF_UART_TX 궨
*                  RXD                鿴 zf_device_scc8660.h  SCC8660_COF_UART_RX 궨
*                  PCLK               鿴 zf_device_scc8660.h  SCC8660_PCLK_PIN 궨
*                  VSY                鿴 zf_device_scc8660.h  SCC8660_VSYNC_PIN 궨
*                  D0-D7              鿴 zf_device_scc8660.h  SCC8660_DATA_PIN 궨 Ӹö忪ʼ˸
*                  VCC                3.3VԴ
*                  GND                Դ
*                  
*                  ------------------------------------
********************************************************************************************************************/

#include "zf_common_interrupt.h"
#include "zf_common_debug.h"
#include "zf_common_fifo.h"
#include "zf_driver_delay.h"
#include "zf_driver_dma.h"
#include "zf_driver_exti.h"
#include "zf_driver_gpio.h"
#include "zf_driver_uart.h"
#include "zf_driver_soft_iic.h"
#include "zf_device_camera.h"
#include "zf_device_type.h"
#include "zf_device_config.h"

#include "zf_device_scc8660.h"

vuint8 scc8660_finish_flag = 0;                                                 // һͼɼɱ־λ
IFX_ALIGN(4) uint16 scc8660_image[SCC8660_H][SCC8660_W];

uint8   scc8660_link_list_num;

uint8   scc8660_lost_flag = 1;                                                  // ͼʧ־λ
uint8   scc8660_dma_int_num;                                                    // ǰDMAжϴ
uint8   scc8660_dma_init_flag;                                                  // ǷҪ³ʼ

static scc8660_type_enum scc8660_type;

// Ҫõͷ ޸Ĳ
static int16 scc8660_set_confing_buffer[SCC8660_CONFIG_FINISH][2]=
{
    {SCC8660_INIT,              0},                                             // ͷʼʼ

    {SCC8660_AUTO_EXP,          SCC8660_AUTO_EXP_DEF},                          // Զع
    {SCC8660_BRIGHT,            SCC8660_BRIGHT_DEF},                            // 
    {SCC8660_FPS,               SCC8660_FPS_DEF},                               // ͼ֡
    {SCC8660_SET_COL,           SCC8660_W * 4},                                 // ͼ
    {SCC8660_SET_ROW,           SCC8660_H},                                     // ͼ
    {SCC8660_PCLK_DIV,          SCC8660_PCLK_DIV_DEF},                          // PCLKƵϵ
    {SCC8660_PCLK_MODE,         SCC8660_PCLK_MODE_DEF},                         // PCLKģʽ
    {SCC8660_COLOR_MODE,        SCC8660_COLOR_MODE_DEF},                        // ͼɫģʽ
    {SCC8660_DATA_FORMAT,       SCC8660_DATA_FORMAT_DEF},                       // ݸʽ
    {SCC8660_MANUAL_WB,         SCC8660_MANUAL_WB_DEF}                          // ֶƽ
};

// ͷڲȡ ޸Ĳ
static int16 scc8660_get_confing_buffer[SCC8660_CONFIG_FINISH - 1][2]=
{
    {SCC8660_AUTO_EXP,          0},
    {SCC8660_BRIGHT,            0},                                             // 
    {SCC8660_FPS,               0},                                             // ͼ֡
    {SCC8660_SET_COL,           0},                                             // ͼ
    {SCC8660_SET_ROW,           0},                                             // ͼ
    {SCC8660_PCLK_DIV,          0},                                             // PCLKƵϵ
    {SCC8660_PCLK_MODE,         0},                                             // PCLKģʽ
    {SCC8660_COLOR_MODE,        0},                                             // ͼɫģʽ
    {SCC8660_DATA_FORMAT,       0},                                             // ݸʽ
    {SCC8660_MANUAL_WB,         0},                                             // ƽ
};

//-------------------------------------------------------------------------------------------------------------------
//      ͷڲϢ ڲ
// ˵     buff            Ϣĵַ
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     if(scc8660_set_config(scc8660_set_confing_buffer)){}
// עϢ     øúǰȳʼ
//-------------------------------------------------------------------------------------------------------------------
static uint8 scc8660_set_config (int16 buff[SCC8660_CONFIG_FINISH][2])
{
    uint8 return_state = 1;
    uint8  uart_buffer[4];
    uint16 temp;
    uint16 timeout_count = 0;
    uint32 loop_count = 0;
    uint32 uart_buffer_index = 0;

    // ò  οֲ
    // ʼͷ³ʼ
    for(loop_count = SCC8660_MANUAL_WB; loop_count < SCC8660_SET_REG_DATA; loop_count --)
    {
        uart_buffer[0] = 0xA5;
        uart_buffer[1] = (uint8)buff[loop_count][0];
        temp = buff[loop_count][1];
        uart_buffer[2] = temp >> 8;
        uart_buffer[3] = (uint8)temp;
        uart_write_buffer(SCC8660_COF_UART, uart_buffer, 4);

        system_delay_ms(2);
    }

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            if((0xff == uart_buffer[1]) || (0xff == uart_buffer[2]))
            {
                return_state = 0;
                break;
            }
        }
        system_delay_ms(1);
    }while(SCC8660_INIT_TIMEOUT > timeout_count ++);

    // ϲֶͷõȫᱣͷ51Ƭeeprom
    // set_exposure_timeõعݲ洢eeprom
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ȡͷڲϢ ڲ
// ˵     buff            Ϣĵַ
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     if(scc8660_get_config(scc8660_get_confing_buffer)){}
// עϢ     øúǰȳʼ
//-------------------------------------------------------------------------------------------------------------------
static uint8 scc8660_get_config (int16 buff[SCC8660_CONFIG_FINISH-1][2])
{
    uint8 return_state = 0;
    uint8  uart_buffer[4];
    uint16 temp;
    uint16 timeout_count = 0;
    uint32 loop_count = 0;
    uint32 uart_buffer_index = 0;

    for(loop_count = SCC8660_MANUAL_WB - 1; loop_count >= 1; loop_count --)
    {
        uart_buffer[0] = 0xA5;
        uart_buffer[1] = SCC8660_GET_STATUS;
        temp = buff[loop_count][0];
        uart_buffer[2] = temp >> 8;
        uart_buffer[3] = (uint8)temp;
        uart_write_buffer(SCC8660_COF_UART, uart_buffer, 4);

        timeout_count = 0;
        do
        {
            if(3 <= fifo_used(&camera_receiver_fifo))
            {
                uart_buffer_index = 3;
                fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
                buff[loop_count][1] = uart_buffer[1] << 8 | uart_buffer[2];
                break;
            }
            system_delay_ms(1);
        }while(SCC8660_INIT_TIMEOUT > timeout_count ++);
        if(timeout_count > SCC8660_INIT_TIMEOUT)                                // ʱ
        {
            return_state = 1;
            break;
        }
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//        SCC8660ͷͨŻص
//  ˵      void
//  ز      void
//  ʹʾ      scc8660_uart_callback();
//-------------------------------------------------------------------------------------------------------------------
static void scc8660_uart_callback (void)
{
    uint8 data = 0;
    uart_query_byte(SCC8660_COF_UART, &data);
    if(0xA5 == data)
    {
        fifo_clear(&camera_receiver_fifo);
    }
    fifo_write_element(&camera_receiver_fifo, data);
}

//-------------------------------------------------------------------------------------------------------------------
//      ȡͷ ID
// ˵     void
// ز     uint16          0-ȡ N-汾
// ʹʾ     scc8660_get_id();
// עϢ     øúǰȳʼ
//-------------------------------------------------------------------------------------------------------------------
uint16 scc8660_get_id (void)
{
    uint16 temp;
    uint8  uart_buffer[4];
    uint16 timeout_count = 0;
    uint16 return_value = 0;
    uint32 uart_buffer_index = 0;

    uart_buffer[0] = 0xA5;
    uart_buffer[1] = SCC8660_GET_WHO_AM_I;
    temp = 0;
    uart_buffer[2] = temp >> 8;
    uart_buffer[3] = (uint8)temp;
    uart_write_buffer(SCC8660_COF_UART, uart_buffer, 4);

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            return_value = uart_buffer[1] << 8 | uart_buffer[2];
            break;
        }
        system_delay_ms(1);
    }while(SCC8660_INIT_TIMEOUT > timeout_count ++);
    return return_value;
}

//-------------------------------------------------------------------------------------------------------------------
//      ͷعʱ
// ˵     light           عʱԽͼԽͷյݷֱʼFPSعʱõݹôͷֵ
// ز     uint16          
// ʹʾ     scc8660_get_parameter();
// עϢ     øúǰȳʼ
//-------------------------------------------------------------------------------------------------------------------
uint16 scc8660_get_parameter (uint16 config)
{
    uint8  uart_buffer[4];
    uint16 timeout_count = 0;
    uint16 return_value = 0;
    uint32 uart_buffer_index = 0;

    uart_buffer[0] = 0xA5;
    uart_buffer[1] = SCC8660_GET_WHO_AM_I;
    uart_buffer[2] = 0x00;
    uart_buffer[3] = (uint8)config;
    uart_write_buffer(SCC8660_COF_UART, uart_buffer, 4);

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            return_value = uart_buffer[1] << 8 | uart_buffer[2];
            break;
        }
        system_delay_ms(1);
    }while(SCC8660_INIT_TIMEOUT > timeout_count ++);
    return return_value;
}

//-------------------------------------------------------------------------------------------------------------------
//      ȡɫͷ̼汾
// ˵     void
// ز     uint16          汾
// ʹʾ     scc8660_get_version();
// עϢ     øúǰȳʼͷô
//-------------------------------------------------------------------------------------------------------------------
uint16 scc8660_get_version (void)
{
    uint16 temp;
    uint8  uart_buffer[4];
    uint16 timeout_count = 0;
    uint16 return_value = 0;
    uint32 uart_buffer_index = 0;

    uart_buffer[0] = 0xA5;
    uart_buffer[1] = SCC8660_GET_STATUS;
    temp           = SCC8660_GET_VERSION;
    uart_buffer[2] = temp >> 8;
    uart_buffer[3] = (uint8)temp;

    uart_write_buffer(SCC8660_COF_UART, uart_buffer, 4);

    do
    {
        if(3 <= fifo_used(&camera_receiver_fifo))
        {
            uart_buffer_index = 3;
            fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
            return_value = uart_buffer[1] << 8 | uart_buffer[2];
            break;
        }
        system_delay_ms(1);
    }while(SCC8660_INIT_TIMEOUT > timeout_count ++);
    return return_value;
}

//-------------------------------------------------------------------------------------------------------------------
//      ͼ
// ˵     data            Ҫõֵ
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     scc8660_set_brightness(data);
// עϢ     øúǰȳʼͷô   ͨúõĲᱻ51Ƭ
//-------------------------------------------------------------------------------------------------------------------
uint8 scc8660_set_brightness (uint16 data)
{
    uint8 return_state = 0;

    if(SCC8660_UART == scc8660_type)
    {
        uint8  uart_buffer[4];
        uint16 temp;
        uint16 timeout_count = 0;
        uint32 uart_buffer_index = 0;

        uart_buffer[0] = 0xA5;
        uart_buffer[1] = SCC8660_SET_BRIGHT;
        uart_buffer[2] = data >> 8;
        uart_buffer[3] = (uint8)data;

        uart_write_buffer(SCC8660_COF_UART, uart_buffer, 4);

        do
        {
            if(3 <= fifo_used(&camera_receiver_fifo))
            {
                uart_buffer_index = 3;
                fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
                temp = uart_buffer[1] << 8 | uart_buffer[2];
                break;
            }
            system_delay_ms(1);
        }while(SCC8660_INIT_TIMEOUT > timeout_count ++);
        if((temp != data) || (SCC8660_INIT_TIMEOUT <= timeout_count))
        {
            return_state = 1;
        }
    }
    else
    {
        return_state = scc8660_set_brightness_sccb(data);
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ðƽ
// ˵     data            Ҫõֵ
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     scc8660_set_white_balance(data);
// עϢ     ͨúõĲᱻ51Ƭ øúǰȳʼͷô
//-------------------------------------------------------------------------------------------------------------------
uint8 scc8660_set_white_balance (uint16 data)
{
    uint8 return_state = 0;

    if(SCC8660_UART == scc8660_type)
    {
        uint8  uart_buffer[4];
        uint16 temp;
        uint16 timeout_count = 0;
        uint32 uart_buffer_index = 0;

        uart_buffer[0] = 0xA5;
        uart_buffer[1] = SCC8660_SET_MANUAL_WB;
        uart_buffer[2] = data >> 8;
        uart_buffer[3] = (uint8)data;

        uart_write_buffer(SCC8660_COF_UART, uart_buffer, 4);

        do
        {
            if(3 <= fifo_used(&camera_receiver_fifo))
            {
                uart_buffer_index = 3;
                fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
                temp = uart_buffer[1] << 8 | uart_buffer[2];
                break;
            }
            system_delay_ms(1);
        }while(SCC8660_INIT_TIMEOUT > timeout_count ++);
        if((temp != data) || (SCC8660_INIT_TIMEOUT <= timeout_count))
        {
            return_state = 1;
        }
    }
    else
    {
        return_state = scc8660_set_manual_wb_sccb(data);
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ͷڲĴд
// ˵     addr            ͷڲĴַ
// ˵     data            Ҫд
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     scc8660_set_reg(addr, data);
// עϢ     øúǰȳʼ
//-------------------------------------------------------------------------------------------------------------------
uint8 scc8660_set_reg (uint8 addr, uint16 data)
{
    uint8 return_state = 0;

    if(SCC8660_UART == scc8660_type)
    {
        uint8  uart_buffer[4];
        uint16 temp;
        uint16 timeout_count = 0;
        uint32 uart_buffer_index = 0;

        uart_buffer[0] = 0xA5;
        uart_buffer[1] = SCC8660_SET_REG_ADDR;
        uart_buffer[2] = 0x00;
        uart_buffer[3] = (uint8)addr;
        uart_write_buffer(SCC8660_COF_UART, uart_buffer, 4);

        system_delay_ms(10);
        uart_buffer[0] = 0xA5;
        uart_buffer[1] = SCC8660_SET_REG_DATA;
        temp           = data;
        uart_buffer[2] = temp >> 8;
        uart_buffer[3] = (uint8)temp;
        uart_write_buffer(SCC8660_COF_UART, uart_buffer, 4);

        do
        {
            if(3 <= fifo_used(&camera_receiver_fifo))
            {
                uart_buffer_index = 3;
                fifo_read_buffer(&camera_receiver_fifo, uart_buffer, &uart_buffer_index, FIFO_READ_AND_CLEAN);
                temp = uart_buffer[1] << 8 | uart_buffer[2];
                break;
            }
            system_delay_ms(1);
        }while(SCC8660_INIT_TIMEOUT > timeout_count ++);
        if((temp != data) || (SCC8660_INIT_TIMEOUT <= timeout_count))
        {
            return_state = 1;
        }

    }
    else
    {
        return_state = scc8660_set_reg_sccb(addr, data);
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//        SCC8660ͷж
//  ˵      void
//  ز      void
//  ʹʾ      scc8660_vsync_handler();
//-------------------------------------------------------------------------------------------------------------------
static void scc8660_vsync_handler(void)
{
    exti_flag_clear(SCC8660_VSYNC_PIN);
    scc8660_dma_int_num = 0;
    if(scc8660_dma_init_flag || scc8660_lost_flag)
    {
        scc8660_dma_init_flag = 0;
        IfxDma_resetChannel(&MODULE_DMA, SCC8660_DMA_CH);
        scc8660_link_list_num = dma_init(SCC8660_DMA_CH,
                                         SCC8660_DATA_ADD,
                                         (uint8 *)scc8660_image[0],
                                         SCC8660_PCLK_PIN,
                                         EXTI_TRIGGER_RISING,
                                         SCC8660_IMAGE_SIZE);
        dma_enable(SCC8660_DMA_CH);
    }
    else
    {
        if(1 == scc8660_link_list_num)
        {
            dma_set_destination(SCC8660_DMA_CH, (uint8 *)scc8660_image[0]); // ûвӴģʽ Ŀĵַ
        }
        dma_enable(SCC8660_DMA_CH);
    }
    scc8660_lost_flag = 1;
}

//-------------------------------------------------------------------------------------------------------------------
//        SCC8660ͷDMAж
//  ˵      void
//  ز      void
//  ʹʾ      scc8660_dma_handler();
//-------------------------------------------------------------------------------------------------------------------
static void scc8660_dma_handler(void)
{
    clear_dma_flag(SCC8660_DMA_CH);

    if(IfxDma_getChannelTransactionRequestLost(&MODULE_DMA, SCC8660_DMA_CH)) // ͼλж
    {
        scc8660_finish_flag = 0;
        dma_disable(SCC8660_DMA_CH);
        IfxDma_clearChannelTransactionRequestLost(&MODULE_DMA, SCC8660_DMA_CH);
        scc8660_dma_init_flag = 1;
    }
    else
    {
        scc8660_dma_int_num++;
        if(scc8660_dma_int_num >= scc8660_link_list_num)
        {
            // ɼ
            // һͼӲɼʼɼʱ3.8MS(50FPS188*120ֱ)
            scc8660_dma_int_num = 0;
            scc8660_lost_flag   = 0;
            scc8660_finish_flag = 1;
            dma_disable(SCC8660_DMA_CH);
        }
    }
}

//-------------------------------------------------------------------------------------------------------------------
//      SCC8660 ͷʼ
// ˵     void
// ز     uint8           1-ʧ 0-ɹ
// ʹʾ     scc8660_init();
// עϢ
//-------------------------------------------------------------------------------------------------------------------
uint8 scc8660_init (void)
{
    uint8 return_state = 0;
    soft_iic_info_struct scc8660_iic_struct;

    // ʼ֮ǰ߳
    gpio_init(P02_0, GPO, GPIO_HIGH, GPO_PUSH_PULL);
    gpio_init(P02_1, GPO, GPIO_HIGH, GPO_PUSH_PULL);

    do
    {
        system_delay_ms(200);
        set_camera_type(CAMERA_COLOR, scc8660_vsync_handler, scc8660_dma_handler, NULL);                                              // ͷ
        // ȳSCCBͨѶ
        scc8660_type = SCC8660_SCCB;
        soft_iic_init(&scc8660_iic_struct, 0, SCC8660_COF_IIC_DELAY, SCC8660_COF_IIC_SCL, SCC8660_COF_IIC_SDA);
        if(scc8660_set_config_sccb(&scc8660_iic_struct, scc8660_set_confing_buffer))
        {
            // SCCBͨѶʧܣԴͨѶ
            scc8660_type = SCC8660_UART;
            camera_fifo_init();
            set_camera_type(CAMERA_COLOR, scc8660_vsync_handler, scc8660_dma_handler, &scc8660_uart_callback);  // ͷ
            uart_init (SCC8660_COF_UART, SCC8660_COF_BAUR, SCC8660_COF_UART_RX, SCC8660_COF_UART_TX);   //ʼ ͷ
            uart_rx_interrupt(SCC8660_COF_UART, 1);
            fifo_clear(&camera_receiver_fifo);

            if(scc8660_set_config(scc8660_set_confing_buffer))
            {
                // ˶Ϣ ʾλ
                // ôͨųʱ˳
                // һ½û ûܾǻ
                zf_log(0, "SCC8660 set config error.");
                set_camera_type(NO_CAMERE, NULL, NULL, NULL);
                return_state = 1;
                break;
            }

            // ȡñڲ鿴Ƿȷ
            if(scc8660_get_config(scc8660_get_confing_buffer))
            {
                // ˶Ϣ ʾλ
                // ôǴͨųʱ˳
                // һ½û ûܾǻ
                zf_log(0, "SCC8660 get config error.");
                set_camera_type(NO_CAMERE, NULL, NULL, NULL);
                return_state = 1;
                break;
            }
        }

        scc8660_link_list_num = camera_init(SCC8660_DATA_ADD, (uint8 *)scc8660_image[0], SCC8660_IMAGE_SIZE);
    }while(0);

    return return_state;
}

