/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_key
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding            first version
* 2023-04-28       pudding            ע˵
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   // һ尴Ӧ
*                   KEY1/S1             鿴 zf_device_key.h  KEY_LIST[0]
*                   KEY2/S2             鿴 zf_device_key.h  KEY_LIST[1]
*                   KEY3/S3             鿴 zf_device_key.h  KEY_LIST[2]
*                   KEY4/S4             鿴 zf_device_key.h  KEY_LIST[3]
*                   ------------------------------------
********************************************************************************************************************/

#include "zf_common_debug.h"

#include "zf_device_key.h"

static uint32               scanner_period = 0;                                 // ɨ
static uint32               key_press_time[KEY_NUMBER];                         // źųʱ
static key_state_enum       key_state[KEY_NUMBER];                              // ״̬

static const gpio_pin_enum  key_index[KEY_NUMBER] = KEY_LIST;                   // б

//-------------------------------------------------------------------------------------------------------------------
//      ״̬ɨ
// ˵     void
// ز     void
// ʹʾ     key_scanner();
// עϢ     ѭ PIT ж
//-------------------------------------------------------------------------------------------------------------------
void key_scanner (void)
{
    uint8 i = 0;
    for(i = 0; KEY_NUMBER > i; i ++)
    {
        if(KEY_RELEASE_LEVEL != gpio_get_level(key_index[i]))                   // 
        {
            key_press_time[i] ++;
            if(KEY_LONG_PRESS_PERIOD / scanner_period <= key_press_time[i])
            {
                key_state[i] = KEY_LONG_PRESS;
            }
        }
        else                                                                    // ͷ
        {
            if((KEY_LONG_PRESS != key_state[i]) && (KEY_MAX_SHOCK_PERIOD / scanner_period <= key_press_time[i]))
            {
                key_state[i] = KEY_SHORT_PRESS;
            }
            else
            {
                key_state[i] = KEY_RELEASE;
            }
            key_press_time[i] = 0;
        }
    }
}

//-------------------------------------------------------------------------------------------------------------------
//      ȡ״̬
// ˵     key_n           
// ز     key_state_enum  ״̬
// ʹʾ     key_get_state(KEY_1);
// עϢ
//-------------------------------------------------------------------------------------------------------------------
key_state_enum key_get_state (key_index_enum key_n)
{
    return key_state[key_n];
}

//-------------------------------------------------------------------------------------------------------------------
//      ָ״̬
// ˵     key_n           
// ز     void            
// ʹʾ     key_clear_state(KEY_1);
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void key_clear_state (key_index_enum key_n)
{
    key_state[key_n] = KEY_RELEASE;
}

//-------------------------------------------------------------------------------------------------------------------
//      а״̬
// ˵     void            
// ز     void            
// ʹʾ     key_clear_all_state();
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void key_clear_all_state (void)
{
    key_state[0] = KEY_RELEASE;
    key_state[1] = KEY_RELEASE;
    key_state[2] = KEY_RELEASE;
    key_state[3] = KEY_RELEASE;
}

//-------------------------------------------------------------------------------------------------------------------
//      ʼ
// ˵     period          ɨ ԺΪλ
// ز     void
// ʹʾ     key_init(10);
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void key_init (uint32 period)
{
    zf_assert(0 < period);
    uint8 loop_temp = 0; 
    for(loop_temp = 0; KEY_NUMBER > loop_temp; loop_temp ++)
    {
        gpio_init(key_index[loop_temp], GPI, GPIO_HIGH, GPI_PULL_UP);
        key_state[loop_temp] = KEY_RELEASE;
    }
    scanner_period = period;
}
