/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_ips200
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding            first version
* 2023-04-28       pudding            ע˵
* 2023-05-20       pudding            ޸޷
********************************************************************************************************************/
/********************************************************************************************************************
* ߶壺
*                  ------------------------------------
*                  ģܽ             Ƭܽ
*                  // ˫  Ӳ
*                  RD                 鿴 zf_device_ips200.h  IPS200_RD_PIN_PARALLEL8     궨
*                  WR                 鿴 zf_device_ips200.h  IPS200_WR_PIN_PARALLEL8     궨
*                  RS                 鿴 zf_device_ips200.h  IPS200_RS_PIN_PARALLEL8     궨
*                  RST                鿴 zf_device_ips200.h  IPS200_RST_PIN_PARALLEL8    궨
*                  CS                 鿴 zf_device_ips200.h  IPS200_CS_PIN_PARALLEL8     궨
*                  BL                 鿴 zf_device_ips200.h  IPS200_BL_PIN_PARALLEL8     궨
*                  D0-D7              鿴 zf_device_ips200.h  IPS200_Dx_PIN_PARALLEL8     궨
*                  VCC                3.3VԴ
*                  GND                Դ
*
*                  //  SPI  Ӳ
*                  SCL                鿴 zf_device_ips200.h  IPS200_SCL_PIN_SPI  궨
*                  SDA                鿴 zf_device_ips200.h  IPS200_SDA_PIN_SPI  궨
*                  RST                鿴 zf_device_ips200.h  IPS200_RST_PIN_SPI  궨
*                  DC                 鿴 zf_device_ips200.h  IPS200_DC_PIN_SPI   궨
*                  CS                 鿴 zf_device_ips200.h  IPS200_CS_PIN_SPI   궨
*                  BLk                鿴 zf_device_ips200.h  IPS200_BLk_PIN_SPI  궨
*                  VCC                3.3VԴ
*                  GND                Դ
*                  ֱ 320 * 240
*                  ------------------------------------
********************************************************************************************************************/

#ifndef _zf_device_ips200_h_
#define _zf_device_ips200_h_

#include "zf_common_typedef.h"

//================================================== IPS200 ================================================
#define IPS200_USE_SOFT_SPI             (0 )                                    // ĬʹӲ SPI ʽ ʹӲ SPI ʽ
#if IPS200_USE_SOFT_SPI                                                         //  ɫĲȷ ɫҵľûõ
//==================================================== SPI ====================================================
// ʹõǵĻ SPI  ޸
#define IPS200_SOFT_SPI_DELAY           (0 )                                    //  SPI ʱʱ ֵԽС SPI ͨԽ
#define IPS200_SCL_PIN                  (P15_3)                                 //  SPI SCK 
#define IPS200_SDA_PIN                  (P15_5)                                 //  SPI MOSI 
//==================================================== SPI ====================================================
#else
//====================================================Ӳ SPI ====================================================
// ʹõǵĻ SPI  ޸
#define IPS200_SPI_SPEED                (60*1000*1000)                          // Ӳ SPI 
#define IPS200_SPI                      (SPI_2           )                      // Ӳ SPI 
#define IPS200_SCL_PIN_SPI              (SPI2_SCLK_P15_3 )                      // Ӳ SPI SCK 
#define IPS200_SDA_PIN_SPI              (SPI2_MOSI_P15_5 )                      // Ӳ SPI MOSI 
#define IPS200_SDA_IN_PIN_SPI           (SPI2_MISO_P15_4 )                      // Ӳ SPI MISO   IPSûMISOţȻҪ壬spiĳʼʱҪʹ
//====================================================Ӳ SPI ====================================================
#endif
// ʹõǵĻ SPI  ޸
#define IPS200_RST_PIN_SPI              (P15_1)                                 // (SPI)ҺλŶ
#define IPS200_DC_PIN_SPI               (P15_0)                                 // (SPI)ҺλŶ
#define IPS200_CS_PIN_SPI               (P15_2)                                 // (SPI)ҺƬѡŶ
#define IPS200_BLk_PIN_SPI              (P15_4)                                 // (SPI)ҺŶ

// ʹõ˫Ļ  ޸
#define IPS200_RD_PIN_PARALLEL8         (P15_3)                                 // ˫()ҺȡλŶ
#define IPS200_WR_PIN_PARALLEL8         (P15_5)                                 // ˫()ҺдλŶ
#define IPS200_RST_PIN_PARALLEL8        (P15_0)                                 // ˫()ҺλŶ
#define IPS200_RS_PIN_PARALLEL8         (P15_1)                                 // ˫()ҺλŶ
#define IPS200_CS_PIN_PARALLEL8         (P15_2)                                 // ˫()ҺƬѡŶ
#define IPS200_BL_PIN_PARALLEL8         (P15_4)                                 // ˫()ҺŶ
// ޸ Ļ˫ õõ
//D0-D3ĸű C0-C3,C1-C4ȵȣ
//D4-D7ĸű B0-B3,B1-B4ȵȡ
//ӵͬ˿ڵ˼ĻD0-D3C1-C4ӣD4-D7B2-B5ӡ
//лźע޸IPS200_DATA_PORT1IPS200_DATA_PORT2궨
#define IPS200_D0_PIN_PARALLEL8         (P11_9 )                                // ˫()ҺD0
#define IPS200_D1_PIN_PARALLEL8         (P11_10)                                // ˫()ҺD1
#define IPS200_D2_PIN_PARALLEL8         (P11_11)                                // ˫()ҺD2
#define IPS200_D3_PIN_PARALLEL8         (P11_12)                                // ˫()ҺD3
#define IPS200_D4_PIN_PARALLEL8         (P13_0 )                                // ˫()ҺD4
#define IPS200_D5_PIN_PARALLEL8         (P13_1 )                                // ˫()ҺD5
#define IPS200_D6_PIN_PARALLEL8         (P13_2 )                                // ˫()ҺD6
#define IPS200_D7_PIN_PARALLEL8         (P13_3 )                                // ˫()ҺD7

#define IPS200_DEFAULT_DISPLAY_DIR      (IPS200_PORTAIT)                        // Ĭϵʾ
#define IPS200_DEFAULT_PENCOLOR         (RGB565_RED    )                        // ĬϵĻɫ
#define IPS200_DEFAULT_BGCOLOR          (RGB565_WHITE  )                        // Ĭϵıɫ
#define IPS200_DEFAULT_DISPLAY_FONT     (IPS200_8X16_FONT)                      // Ĭϵģʽ

//ݶ˿PORTлźظPORTи   ʹ˿ڽ  ˶ʼ
#define IPS200_DATA_PORT1               (4)       //0:P00˿  1P01˿  2P02˿  3P10˿  4P11˿  5P12˿  6P13˿  7P14˿  8P15˿  9P20˿  10P21˿  11P22˿  12P23˿  13P32˿  14P33˿
#define IPS200_DATAPORT1                (get_port_out_addr(IPS200_DATA_PORT1))
#define DATA_START_NUM1                 (IPS200_D0_PIN_PARALLEL8&0x1f)          // ŵʼ
#define IPS200_DATA_PORT2               (6)       //0:P00˿  1P01˿  2P02˿  3P10˿  4P11˿  5P12˿  6P13˿  7P14˿  8P15˿  9P20˿  10P21˿  11P22˿  12P23˿  13P32˿  14P33˿
#define IPS200_DATAPORT2                (get_port_out_addr(IPS200_DATA_PORT2))
#define DATA_START_NUM2                 (IPS200_D4_PIN_PARALLEL8&0x1f)          // ŵʼ

// 
#define IPS200_RD(x)                    ((x) ? (gpio_high(IPS200_RD_PIN_PARALLEL8)) : (gpio_low(IPS200_RD_PIN_PARALLEL8)))
#define IPS200_WR(x)                    ((x) ? (gpio_high(IPS200_WR_PIN_PARALLEL8)) : (gpio_low(IPS200_WR_PIN_PARALLEL8)))
#define IPS200_RST(x)                   ((x) ? (gpio_high(ips_rst_pin))             : (gpio_low(ips_rst_pin)))
#define IPS200_BL(x)                    ((x) ? (gpio_high(ips_bl_pin))              : (gpio_low(ips_bl_pin)))
#define IPS200_RS(x)                    ((x) ? (gpio_high(IPS200_RS_PIN_PARALLEL8)) : (gpio_low(IPS200_RS_PIN_PARALLEL8)))
#define IPS200_DC(x)                    ((x) ? (gpio_high(IPS200_DC_PIN_SPI))       : (gpio_low(IPS200_DC_PIN_SPI)))
#define IPS200_CS(x)                    ((x) ? (gpio_high(IPS200_CS_PIN_SPI))       : (gpio_low(IPS200_CS_PIN_SPI)))
//================================================== IPS200 ================================================


//================================================== IPS200 ṹ===============================================
typedef enum
{
    IPS200_TYPE_SPI,                                                            // SPI 
    IPS200_TYPE_PARALLEL8,                                                      // 
}ips200_type_enum;

typedef enum
{
    IPS200_PORTAIT                      = 0,                                    // ģʽ
    IPS200_PORTAIT_180                  = 1,                                    // ģʽ  ת180
    IPS200_CROSSWISE                    = 2,                                    // ģʽ
    IPS200_CROSSWISE_180                = 3,                                    // ģʽ  ת180
}ips200_dir_enum;

typedef enum
{
    IPS200_6X8_FONT                     = 0,                                    // 6x8      
    IPS200_8X16_FONT                    = 1,                                    // 8x16     
    IPS200_16X16_FONT                   = 2,                                    // 16x16     Ŀǰ֧
}ips200_font_size_enum;
extern  uint16  ips200_width_max;
extern  uint16  ips200_height_max;
//================================================== IPS200 ṹ===============================================


//================================================== IPS200 ================================================
void    ips200_clear                    (void);                                                                                // IPS200 
void    ips200_full                     (const uint16 color);                                                                  // IPS200 Ļ亯
void    ips200_set_dir                  (ips200_dir_enum dir);                                                                 // IPS200 ʾ
void    ips200_set_font                 (ips200_font_size_enum font);                                                          // IPS200 ʾ
void    ips200_set_color                (const uint16 pen, const uint16 bgcolor);                                              // IPS200 ʾɫ
void    ips200_draw_point               (uint16 x, uint16 y, const uint16 color);                                              // IPS200 㺯
void    ips200_draw_line                (uint16 x_start, uint16 y_start, uint16 x_end, uint16 y_end, const uint16 color);      // IPS200 ߺ

void    ips200_show_char                (uint16 x, uint16 y, const char dat);
void    ips200_show_string              (uint16 x, uint16 y, const char dat[]);
void    ips200_show_int                 (uint16 x, uint16 y, const int32 dat, uint8 num);
void    ips200_show_uint                (uint16 x, uint16 y, const uint32 dat, uint8 num);
void    ips200_show_float               (uint16 x, uint16 y, const double dat, uint8 num, uint8 pointnum);

void    ips200_show_binary_image        (uint16 x, uint16 y, const uint8 *image, uint16 width, uint16 height, uint16 dis_width, uint16 dis_height);                      // IPS200 ʾֵͼ ÿ˸һֽ
void    ips200_show_gray_image          (uint16 x, uint16 y, const uint8 *image, uint16 width, uint16 height, uint16 dis_width, uint16 dis_height, uint8 threshold);     // IPS200 ʾ 8bit Ҷͼ ֵֵ
void    ips200_show_rgb565_image        (uint16 x, uint16 y, const uint16 *image, uint16 width, uint16 height, uint16 dis_width, uint16 dis_height, uint8 color_mode);   // IPS200 ʾ RGB565 ɫͼ

void    ips200_show_wave                (uint16 x, uint16 y, const uint16 *wave, uint16 width, uint16 value_max, uint16 dis_width, uint16 dis_value_max);                // IPS200 ʾ
void    ips200_show_chinese             (uint16 x, uint16 y, uint8 size, const uint8 *chinese_buffer, uint8 number, const uint16 color);                                 // IPS200 ʾ

void    ips200_init                     (ips200_type_enum type_select);                                                         // 2 IPSҺʼ
//================================================== IPS200 ================================================


//================================================== IPS200 չ================================================
//-------------------------------------------------------------------------------------------------------------------
//      IPS200 ʾСͼ
// ˵     p               ͼָ
// ˵     width           ͼʵʿ
// ˵     height          ͼʵʸ߶
// ز     void
// ʹʾ     ips200_displayimage7725(ov7725_image_binary[0], OV7725_W, OV7725_H);
// עϢ     չһʾĬţĻʼ㿪ʼʾ
//-------------------------------------------------------------------------------------------------------------------
#define ips200_displayimage7725(p, width, height)       (ips200_show_binary_image(0, 0, (p), OV7725_W, OV7725_H, (width), (height)))
//-------------------------------------------------------------------------------------------------------------------
//      IPS200 ʾͼ
// ˵     p               ͼָ
// ˵     width           ͼʵʿ
// ˵     height          ͼʵʸ߶
// ز     void
// ʹʾ     ips200_displayimage03x(mt9v03x_image[0], MT9V03X_W, MT9V03X_H);
// עϢ     չһʾĬţĻʼ㿪ʼʾ
//-------------------------------------------------------------------------------------------------------------------
#define ips200_displayimage03x(p, width, height)        (ips200_show_gray_image(0, 0, (p), MT9V03X_W, MT9V03X_H, (width), (height), 0))
//-------------------------------------------------------------------------------------------------------------------
//      IPS200 ʾͫͼ
// ˵     p               ͼָ
// ˵     width           ͼʵʿ
// ˵     height          ͼʵʸ߶
// ز     void
// ʹʾ     ips200_displayimage8660(scc8660_image[0], SCC8660_W, SCC8660_H);
// עϢ     չһʾĬţĻʼ㿪ʼʾ
//-------------------------------------------------------------------------------------------------------------------
#define ips200_displayimage8660(p, width, height)       (ips200_show_rgb565_image(0, 0, (p), SCC8660_W, SCC8660_H, (width), (height), 1))
//================================================== IPS200 չ================================================


#endif

