/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_imu963ra
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding            first version
* 2023-04-28       pudding            ע˵
* 2024-01-30       pudding            ת 
********************************************************************************************************************/
/********************************************************************************************************************
* ߶壺
*                  ------------------------------------
*                  ģܽ             Ƭܽ
*                  // Ӳ SPI 
*                  SCL/SPC            鿴 zf_device_imu963ra.h  IMU963RA_SPC_PIN 궨
*                  SDA/DSI            鿴 zf_device_imu963ra.h  IMU963RA_SDI_PIN 궨
*                  SA0/SDO            鿴 zf_device_imu963ra.h  IMU963RA_SDO_PIN 궨
*                  CS                 鿴 zf_device_imu963ra.h  IMU963RA_CS_PIN  궨
*                  VCC                3.3VԴ
*                  GND                Դ
*                  
*
*                  //  IIC 
*                  SCL/SPC            鿴 zf_device_imu963ra.h  IMU963RA_SCL_PIN 궨
*                  SDA/DSI            鿴 zf_device_imu963ra.h  IMU963RA_SDA_PIN 궨
*                  VCC                3.3VԴ
*                  GND                Դ
*                  
*                  ------------------------------------
********************************************************************************************************************/

#ifndef _zf_device_imu963ra_h_
#define _zf_device_imu963ra_h_

#include "zf_common_typedef.h"

//================================================ IMU963RA ================================================
#define IMU963RA_USE_SOFT_IIC                       (0)                         // ĬʹӲ SPI ʽ
#if IMU963RA_USE_SOFT_IIC                                                       //  ɫĲȷ ɫҵľûõ
//==================================================== IIC ====================================================
#define IMU963RA_SOFT_IIC_DELAY                     (59 )                       //  IIC ʱʱ ֵԽС IIC ͨԽ
#define IMU963RA_SCL_PIN                            (P20_11)                    //  IIC SCL   IMU963RA  SCL 
#define IMU963RA_SDA_PIN                            (P20_14)                    //  IIC SDA   IMU963RA  SDA 
//==================================================== IIC ====================================================
#else

//====================================================Ӳ SPI ====================================================
#define IMU963RA_SPI_SPEED                          (10 * 1000 * 1000)          // Ӳ SPI 
#define IMU963RA_SPI                                (SPI_0           )          // Ӳ SPI 
#define IMU963RA_SPC_PIN                            (SPI0_SCLK_P20_11)          // Ӳ SPI SCK 
#define IMU963RA_SDI_PIN                            (SPI0_MOSI_P20_14)          // Ӳ SPI MOSI 
#define IMU963RA_SDO_PIN                            (SPI0_MISO_P20_12)          // Ӳ SPI MISO 
//====================================================Ӳ SPI ====================================================
#endif

#define IMU963RA_CS_PIN                             (P20_13)                    // CS Ƭѡ
#define IMU963RA_CS(x)                              (x? (gpio_high(IMU963RA_CS_PIN)): (gpio_low(IMU963RA_CS_PIN)))

typedef enum
{
    IMU963RA_ACC_SAMPLE_SGN_2G ,                                                // ٶȼ 2G  (ACC = Accelerometer ٶȼ) (SGN = signum  ʾΧ) (G = g ٶ g9.80 m/s^2)
    IMU963RA_ACC_SAMPLE_SGN_4G ,                                                // ٶȼ 4G  (ACC = Accelerometer ٶȼ) (SGN = signum  ʾΧ) (G = g ٶ g9.80 m/s^2)
    IMU963RA_ACC_SAMPLE_SGN_8G ,                                                // ٶȼ 8G  (ACC = Accelerometer ٶȼ) (SGN = signum  ʾΧ) (G = g ٶ g9.80 m/s^2)
    IMU963RA_ACC_SAMPLE_SGN_16G,                                                // ٶȼ 16G (ACC = Accelerometer ٶȼ) (SGN = signum  ʾΧ) (G = g ٶ g9.80 m/s^2)
}imu963ra_acc_sample_config;

typedef enum
{
    IMU963RA_GYRO_SAMPLE_SGN_125DPS ,                                           //  125DPS  (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
    IMU963RA_GYRO_SAMPLE_SGN_250DPS ,                                           //  250DPS  (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
    IMU963RA_GYRO_SAMPLE_SGN_500DPS ,                                           //  500DPS  (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
    IMU963RA_GYRO_SAMPLE_SGN_1000DPS,                                           //  1000DPS (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
    IMU963RA_GYRO_SAMPLE_SGN_2000DPS,                                           //  2000DPS (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
    IMU963RA_GYRO_SAMPLE_SGN_4000DPS,                                           //  4000DPS (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
}imu963ra_gyro_sample_config;

typedef enum
{
    IMU963RA_MAG_SAMPLE_2G,                                                     //  2G (MAG = Magnetometer ) (G = Gs ˹)
    IMU963RA_MAG_SAMPLE_8G,                                                     //  8G (MAG = Magnetometer ) (G = Gs ˹)
}imu963ra_mag_sample_config;

#define IMU963RA_ACC_SAMPLE_DEFAULT     ( IMU963RA_ACC_SAMPLE_SGN_8G )          // Ĭϵ ٶȼ ʼ
#define IMU963RA_GYRO_SAMPLE_DEFAULT    ( IMU963RA_GYRO_SAMPLE_SGN_2000DPS )    // Ĭϵ    ʼ
#define IMU963RA_MAG_SAMPLE_DEFAULT     ( IMU963RA_MAG_SAMPLE_8G )              // Ĭϵ    ʼ
#define IMU963RA_TIMEOUT_COUNT                      (0x00FF)                    // IMU963RA ʱ
//================================================ IMU963RA ================================================


//================================================ IMU963RA ڲַ================================================
#define IMU963RA_DEV_ADDR                           (0x6B)                      // SA0ӵأ0x6A SA00x6B ģĬ
#define IMU963RA_SPI_W                              (0x00)
#define IMU963RA_SPI_R                              (0x80)

#define IMU963RA_FUNC_CFG_ACCESS                    (0x01)
#define IMU963RA_INT1_CTRL                          (0x0D)
#define IMU963RA_WHO_AM_I                           (0x0F)
#define IMU963RA_CTRL1_XL                           (0x10)
#define IMU963RA_CTRL2_G                            (0x11)
#define IMU963RA_CTRL3_C                            (0x12)
#define IMU963RA_CTRL4_C                            (0x13)
#define IMU963RA_CTRL5_C                            (0x14)
#define IMU963RA_CTRL6_C                            (0x15)
#define IMU963RA_CTRL7_G                            (0x16)
#define IMU963RA_CTRL9_XL                           (0x18)
#define IMU963RA_OUTX_L_G                           (0x22)
#define IMU963RA_OUTX_L_A                           (0x28)

//ؼĴ ҪFUNC_CFG_ACCESSSHUB_REG_ACCESSλΪ1ȷ
#define IMU963RA_SENSOR_HUB_1                       (0x02)
#define IMU963RA_MASTER_CONFIG                      (0x14)
#define IMU963RA_SLV0_ADD                           (0x15)
#define IMU963RA_SLV0_SUBADD                        (0x16)
#define IMU963RA_SLV0_CONFIG                        (0x17)
#define IMU963RA_DATAWRITE_SLV0                     (0x21)
#define IMU963RA_STATUS_MASTER                      (0x22)

#define IMU963RA_MAG_ADDR                           (0x0D)                      // 7λIICַ
#define IMU963RA_MAG_OUTX_L                         (0x00)
#define IMU963RA_MAG_CONTROL1                       (0x09)
#define IMU963RA_MAG_CONTROL2                       (0x0A)
#define IMU963RA_MAG_FBR                            (0x0B)
#define IMU963RA_MAG_CHIP_ID                        (0x0D)

#define IMU963RA_ACC_SAMPLE                         (0x3C)                      // ٶȼ
// Ϊ:0x30 ٶΪ:2G      ȡļٶȼ 16393תΪλݣλg(m/s^2)
// Ϊ:0x38 ٶΪ:4G      ȡļٶȼ 8197 תΪλݣλg(m/s^2)
// Ϊ:0x3C ٶΪ:8G      ȡļٶȼ 4098 תΪλݣλg(m/s^2)
// Ϊ:0x34 ٶΪ:16G     ȡļٶȼ 2049 תΪλݣλg(m/s^2)

#define IMU963RA_GYR_SAMPLE                         (0x5C)                      // 
// Ϊ:0x52 Ϊ:125dps  ȡݳ228.6   תΪλݣλΪ/s
// Ϊ:0x50 Ϊ:250dps  ȡݳ114.3   תΪλݣλΪ/s
// Ϊ:0x54 Ϊ:500dps  ȡݳ57.1    תΪλݣλΪ/s
// Ϊ:0x58 Ϊ:1000dps ȡݳ28.6    תΪλݣλΪ/s
// Ϊ:0x5C Ϊ:2000dps ȡݳ14.3    תΪλݣλΪ/s
// Ϊ:0x51 Ϊ:4000dps ȡݳ7.1     תΪλݣλΪ/s

#define IMU963RA_MAG_SAMPLE                         (0x19)                      // شż
// Ϊ:0x19 Ϊ:8G     ȡļٶȼ 3000 תΪλݣλG(˹)
// Ϊ:0x09 Ϊ:2G     ȡļٶȼ 12000תΪλݣλG(˹)
//================================================ IMU963RA ڲַ================================================


//================================================ IMU963RA ȫֱ================================================
extern int16 imu963ra_acc_x,  imu963ra_acc_y,  imu963ra_acc_z;                  //       GYRO ()
extern int16 imu963ra_gyro_x, imu963ra_gyro_y, imu963ra_gyro_z;                 // ٶȼ     ACC  (accelerometer ٶȼ)
extern int16 imu963ra_mag_x,  imu963ra_mag_y,  imu963ra_mag_z;                  //       MAG  (magnetometer )
extern float imu963ra_transition_factor[3];                                     // תʵֵı
//================================================ IMU963RA ȫֱ================================================


//================================================ IMU963RA ================================================
void    imu963ra_get_acc            (void);                                     // ȡ IMU963RA ٶȼ
void    imu963ra_get_gyro           (void);                                     // ȡ IMU963RA 
void    imu963ra_get_mag            (void);                                     // ȡ IMU963RA 
uint8   imu963ra_init               (void);                                     // ʼ IMU963RA
//================================================ IMU963RA ================================================


//================================================ IMU963RA չ================================================
//-------------------------------------------------------------------------------------------------------------------
//       IMU963RA ٶȼתΪʵ
// ˵     acc_value       ļٶȼ
// ز     void
// ʹʾ     float data = imu963ra_acc_transition(imu963ra_acc_x);               // λΪ g(m/s^2)
// עϢ
//-------------------------------------------------------------------------------------------------------------------
#define imu963ra_acc_transition(acc_value)      ((float)(acc_value) / imu963ra_transition_factor[0])

//-------------------------------------------------------------------------------------------------------------------
//       IMU963RA תΪʵ
// ˵     gyro_value      
// ز     void
// ʹʾ     float data = imu963ra_gyro_transition(imu963ra_gyro_x);             // λΪ /s
// עϢ
//-------------------------------------------------------------------------------------------------------------------
#define imu963ra_gyro_transition(gyro_value)    ((float)(gyro_value) / imu963ra_transition_factor[1])

//-------------------------------------------------------------------------------------------------------------------
//       IMU963RA תΪʵ
// ˵     mag_value       Ĵ
// ز     void
// ʹʾ     float data = imu963ra_mag_transition(imu963ra_mag_x);               // λΪ G
// עϢ
//-------------------------------------------------------------------------------------------------------------------
#define imu963ra_mag_transition(mag_value)    ((float)(mag_value) / imu963ra_transition_factor[2])
//================================================ IMU963RA չ================================================

#endif
