/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_imu660ra
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding            first version
* 2023-04-28       pudding            ע˵
* 2023-09-15       pudding            תʵֵϸ˵
* 2024-01-30       pudding            ת 
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   // Ӳ SPI 
*                   SCL/SPC           鿴 zf_device_imu660ra.h  IMU660RA_SPC_PIN 궨
*                   SDA/DSI           鿴 zf_device_imu660ra.h  IMU660RA_SDI_PIN 궨
*                   SA0/SDO           鿴 zf_device_imu660ra.h  IMU660RA_SDO_PIN 궨
*                   CS                鿴 zf_device_imu660ra.h  IMU660RA_CS_PIN 궨
*                   VCC               3.3VԴ
*                   GND               Դ
*                   
*
*                   //  IIC 
*                   SCL/SPC           鿴 zf_device_imu660ra.h  IMU660RA_SCL_PIN 궨
*                   SDA/DSI           鿴 zf_device_imu660ra.h  IMU660RA_SDA_PIN 궨
*                   VCC               3.3VԴ
*                   GND               Դ
*                   
*                   ------------------------------------
********************************************************************************************************************/

#ifndef _zf_device_imu660ra_h_
#define _zf_device_imu660ra_h_

#include "zf_common_typedef.h"

//================================================ IMU660RA ================================================
// IMU660RA_USE_SOFT_IICΪ0ʾʹӲSPI Ϊ1ʾʹIIC
// IMU660RA_USE_SOFT_IICҪȱ벢س򣬵ƬģҪϵͨѶ
#define IMU660RA_USE_SOFT_IIC         (0)                                       // ĬʹӲ SPI ʽ
#if IMU660RA_USE_SOFT_IIC                                                       //  ɫĲȷ ɫҵľûõ
//==================================================== IIC ====================================================
#define IMU660RA_SOFT_IIC_DELAY       (59)                                      //  IIC ʱʱ ֵԽС IIC ͨԽ
#define IMU660RA_SCL_PIN              (P20_11)                                  //  IIC SCL   IMU660RA  SCL 
#define IMU660RA_SDA_PIN              (P20_14)                                  //  IIC SDA   IMU660RA  SDA 
//==================================================== IIC ====================================================
#else
//====================================================Ӳ SPI ====================================================
#define IMU660RA_SPI_SPEED            (10 * 1000 * 1000)                        // Ӳ SPI 
#define IMU660RA_SPI                  (SPI_0)                                   // Ӳ SPI 
#define IMU660RA_SPC_PIN              (SPI0_SCLK_P20_11)                        // Ӳ SPI SCK 
#define IMU660RA_SDI_PIN              (SPI0_MOSI_P20_14)                        // Ӳ SPI MOSI 
#define IMU660RA_SDO_PIN              (SPI0_MISO_P20_12)                        // Ӳ SPI MISO 
//====================================================Ӳ SPI ====================================================
#endif
#define IMU660RA_CS_PIN               (P20_13)                                  // CS Ƭѡ
#define IMU660RA_CS(x)                ((x) ? (gpio_high(IMU660RA_CS_PIN)) : (gpio_low(IMU660RA_CS_PIN)))
typedef enum
{
    IMU660RA_ACC_SAMPLE_SGN_2G ,                                                // ٶȼ 2G  (ACC = Accelerometer ٶȼ) (SGN = signum  ʾΧ) (G = g ٶ g9.80 m/s^2)
    IMU660RA_ACC_SAMPLE_SGN_4G ,                                                // ٶȼ 4G  (ACC = Accelerometer ٶȼ) (SGN = signum  ʾΧ) (G = g ٶ g9.80 m/s^2)
    IMU660RA_ACC_SAMPLE_SGN_8G ,                                                // ٶȼ 8G  (ACC = Accelerometer ٶȼ) (SGN = signum  ʾΧ) (G = g ٶ g9.80 m/s^2)
    IMU660RA_ACC_SAMPLE_SGN_16G,                                                // ٶȼ 16G (ACC = Accelerometer ٶȼ) (SGN = signum  ʾΧ) (G = g ٶ g9.80 m/s^2)
}imu660ra_acc_sample_config;

typedef enum
{
    IMU660RA_GYRO_SAMPLE_SGN_125DPS ,                                           //  125DPS  (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
    IMU660RA_GYRO_SAMPLE_SGN_250DPS ,                                           //  250DPS  (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
    IMU660RA_GYRO_SAMPLE_SGN_500DPS ,                                           //  500DPS  (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
    IMU660RA_GYRO_SAMPLE_SGN_1000DPS,                                           //  1000DPS (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
    IMU660RA_GYRO_SAMPLE_SGN_2000DPS,                                           //  2000DPS (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
}imu660ra_gyro_sample_config;

#define IMU660RA_ACC_SAMPLE_DEFAULT   ( IMU660RA_ACC_SAMPLE_SGN_8G )            // Ĭϵ ٶȼ ʼ
#define IMU660RA_GYRO_SAMPLE_DEFAULT  ( IMU660RA_GYRO_SAMPLE_SGN_2000DPS )      // Ĭϵ    ʼ
#define IMU660RA_TIMEOUT_COUNT        (0x00FF)                                  // IMU660 ʱ
//================================================ IMU660RA ================================================


//================================================ IMU660RA ڲַ================================================
#define IMU660RA_DEV_ADDR             (0x69)                                    // SA0ӵأ0x68 SA00x69 ģĬ
#define IMU660RA_SPI_W                (0x00)
#define IMU660RA_SPI_R                (0x80)

#define IMU660RA_CHIP_ID              (0x00)
#define IMU660RA_PWR_CONF             (0x7C)
#define IMU660RA_PWR_CTRL             (0x7D)
#define IMU660RA_INIT_CTRL            (0x59)
#define IMU660RA_INIT_DATA            (0x5E)
#define IMU660RA_INT_STA              (0x21)
#define IMU660RA_ACC_ADDRESS          (0x0C)
#define IMU660RA_GYRO_ADDRESS         (0x12)
#define IMU660RA_ACC_CONF             (0x40)
#define IMU660RA_ACC_RANGE            (0x41)
#define IMU660RA_GYR_CONF             (0x42)
#define IMU660RA_GYR_RANGE            (0x43)

#define IMU660RA_ACC_SAMPLE           (0x02)                                    // ٶȼ
//                                Ϊ25ת IMU660RAļٶƯϵΪ 0.004%/K  ֵƫ¶ϵΪ 0.25mg/K
// Ϊ:0x00 ٶȼΪ:2g         ȡļٶȼ  16384   תΪλ λg(m/s^2)
// Ϊ:0x01 ٶȼΪ:4g         ȡļٶȼ  8192    תΪλ λg(m/s^2)
// Ϊ:0x02 ٶȼΪ:8g         ȡļٶȼ  4096    תΪλ λg(m/s^2)
// Ϊ:0x03 ٶȼΪ:16g        ȡļٶȼ  2048    תΪλ λg(m/s^2)

#define IMU660RA_GYR_SAMPLE           (0x00)                                    // 
//                                Ϊ25ת IMU660RAƯϵΪ 0.02%/K  ֵƫ¶ϵΪ 0.015dps/K
// Ϊ:0x00 Ϊ:2000dps      ȡݳ16.384          תΪλݣλΪ/s
// Ϊ:0x01 Ϊ:1000dps      ȡݳ32.768          תΪλݣλΪ/s
// Ϊ:0x02 Ϊ:500 dps      ȡݳ65.536          תΪλݣλΪ/s
// Ϊ:0x03 Ϊ:250 dps      ȡݳ131.072         תΪλݣλΪ/s
// Ϊ:0x04 Ϊ:250 dps      ȡݳ262.144         תΪλݣλΪ/s
//================================================ IMU660RA ڲַ================================================


//================================================ IMU660RA ȫֱ================================================
extern int16 imu660ra_gyro_x, imu660ra_gyro_y, imu660ra_gyro_z;                 //       GYRO ()
extern int16 imu660ra_acc_x, imu660ra_acc_y, imu660ra_acc_z;                    // ٶȼ     ACC  (accelerometer ٶȼ)
extern float imu660ra_transition_factor[2];                                     // תʵֵı
//================================================ IMU660RA ȫֱ================================================


//================================================ IMU660RA ================================================
void  imu660ra_get_acc              (void);                                     // ȡ IMU660RA ٶȼ
void  imu660ra_get_gyro             (void);                                     // ȡ IMU660RA 
uint8 imu660ra_init                 (void);                                     // ʼ IMU660RA
//================================================ IMU660RA ================================================


//================================================ IMU660RA չ================================================
//-------------------------------------------------------------------------------------------------------------------
//       IMU660RA ٶȼתΪʵ
// ˵     acc_value       ļٶȼ
// ز     void
// ʹʾ     float data = imu660ra_acc_transition(imu660ra_acc_x);           // λΪ g(m/s^2)
// עϢ
//-------------------------------------------------------------------------------------------------------------------
#define imu660ra_acc_transition(acc_value)      ((float)(acc_value) / imu660ra_transition_factor[0])

//-------------------------------------------------------------------------------------------------------------------
//       IMU660RA תΪʵ
// ˵     gyro_value      
// ز     void
// ʹʾ     float data = imu660ra_gyro_transition(imu660ra_gyro_x);         // λΪ /s
// עϢ
//-------------------------------------------------------------------------------------------------------------------
#define imu660ra_gyro_transition(gyro_value)    ((float)(gyro_value) / imu660ra_transition_factor[1])
//================================================ IMU660RA չ================================================

#endif

