/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_icm20602
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                              ע
* 2022-11-03       pudding            first version
* 2023-04-28       pudding            ע˵
* 2024-01-30       pudding            ת 
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ           Ƭܽ
*                   // Ӳ SPI 
*                   SCL/SPC           鿴 zf_device_icm20602.h  ICM20602_SPC_PIN 궨
*                   SDA/DSI           鿴 zf_device_icm20602.h  ICM20602_SDI_PIN 궨
*                   SA0/SDO           鿴 zf_device_icm20602.h  ICM20602_SDO_PIN 궨
*                   CS                鿴 zf_device_icm20602.h  ICM20602_CS_PIN 궨
*                   VCC               3.3VԴ
*                   GND               Դ
*                   
*
*                   //  IIC 
*                   SCL/SPC           鿴 zf_device_icm20602.h  ICM20602_SCL_PIN 궨
*                   SDA/DSI           鿴 zf_device_icm20602.h  ICM20602_SDA_PIN 궨
*                   VCC               3.3VԴ
*                   GND               Դ
*                   
*                   ------------------------------------
********************************************************************************************************************/
#ifndef _zf_device_icm20602_h_
#define _zf_device_icm20602_h_

#include "zf_common_typedef.h"

//================================================ ICM20602 ================================================
// ICM20602_USE_SOFT_IICΪ0ʾʹӲSPI Ϊ1ʾʹIIC
#define ICM20602_USE_SOFT_IIC       (0)                                         // ĬʹӲ SPI ʽ
#if ICM20602_USE_SOFT_IIC                                                       //  ɫĲȷ ɫҵľûõ
//==================================================== IIC ====================================================
#define ICM20602_SOFT_IIC_DELAY     (59 )                                       //  IIC ʱʱ ֵԽС IIC ͨԽ
#define ICM20602_SCL_PIN            (P20_11)                                    //  IIC SCL   ICM20602  SCL 
#define ICM20602_SDA_PIN            (P20_14)                                    //  IIC SDA   ICM20602  SDA 
//==================================================== IIC ====================================================
#else
//====================================================Ӳ SPI ====================================================
#define ICM20602_SPI_SPEED          (10 * 1000 * 1000)                          // Ӳ SPI 
#define ICM20602_SPI                (SPI_0)                                     // Ӳ SPI 
#define ICM20602_SPC_PIN            (SPI0_SCLK_P20_11)                          // Ӳ SPI SCK 
#define ICM20602_SDI_PIN            (SPI0_MOSI_P20_14)                          // Ӳ SPI MOSI 
#define ICM20602_SDO_PIN            (SPI0_MISO_P20_12)                          // Ӳ SPI MISO 
//====================================================Ӳ SPI ====================================================
#endif

#define ICM20602_CS_PIN             (P20_13)                                    // CS Ƭѡ
#define ICM20602_CS(x)              ((x) ? (gpio_high(ICM20602_CS_PIN)) : (gpio_low(ICM20602_CS_PIN)))
typedef enum
{
    ICM20602_ACC_SAMPLE_SGN_2G ,                                                // ٶȼ 2G  (ACC = Accelerometer ٶȼ) (SGN = signum  ʾΧ) (G = g ٶ g9.80 m/s^2)
    ICM20602_ACC_SAMPLE_SGN_4G ,                                                // ٶȼ 4G  (ACC = Accelerometer ٶȼ) (SGN = signum  ʾΧ) (G = g ٶ g9.80 m/s^2)
    ICM20602_ACC_SAMPLE_SGN_8G ,                                                // ٶȼ 8G  (ACC = Accelerometer ٶȼ) (SGN = signum  ʾΧ) (G = g ٶ g9.80 m/s^2)
    ICM20602_ACC_SAMPLE_SGN_16G,                                                // ٶȼ 16G (ACC = Accelerometer ٶȼ) (SGN = signum  ʾΧ) (G = g ٶ g9.80 m/s^2)
}icm20602_acc_sample_config;

typedef enum
{
    ICM20602_GYRO_SAMPLE_SGN_250DPS ,                                           //  250DPS  (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
    ICM20602_GYRO_SAMPLE_SGN_500DPS ,                                           //  500DPS  (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
    ICM20602_GYRO_SAMPLE_SGN_1000DPS,                                           //  1000DPS (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
    ICM20602_GYRO_SAMPLE_SGN_2000DPS,                                           //  2000DPS (GYRO = Gyroscope ) (SGN = signum  ʾΧ) (DPS = Degree Per Second ٶȵλ /S)
}icm20602_gyro_sample_config;

#define ICM20602_ACC_SAMPLE_DEFAULT     ( ICM20602_ACC_SAMPLE_SGN_8G )          // Ĭϵ ٶȼ ʼ
#define ICM20602_GYRO_SAMPLE_DEFAULT    ( ICM20602_GYRO_SAMPLE_SGN_2000DPS )    // Ĭϵ    ʼ
#define ICM20602_TIMEOUT_COUNT      (0x00FF)                                    // ICM20602 ʱ
//================================================ ICM20602 ================================================


//================================================ ICM20602 ڲַ================================================
#define ICM20602_DEV_ADDR           (0x69)                                      // SA0ӵأ0x68 SA00x69 ģĬ
#define ICM20602_SPI_W              (0x00)
#define ICM20602_SPI_R              (0x80)

#define ICM20602_XG_OFFS_TC_H       (0x04)
#define ICM20602_XG_OFFS_TC_L       (0x05)
#define ICM20602_YG_OFFS_TC_H       (0x07)
#define ICM20602_YG_OFFS_TC_L       (0x08)
#define ICM20602_ZG_OFFS_TC_H       (0x0A)
#define ICM20602_ZG_OFFS_TC_L       (0x0B)
#define ICM20602_SELF_TEST_X_ACCEL  (0x0D)
#define ICM20602_SELF_TEST_Y_ACCEL  (0x0E)
#define ICM20602_SELF_TEST_Z_ACCEL  (0x0F)
#define ICM20602_XG_OFFS_USRH       (0x13)
#define ICM20602_XG_OFFS_USRL       (0x14)
#define ICM20602_YG_OFFS_USRH       (0x15)
#define ICM20602_YG_OFFS_USRL       (0x16)
#define ICM20602_ZG_OFFS_USRH       (0x17)
#define ICM20602_ZG_OFFS_USRL       (0x18)
#define ICM20602_SMPLRT_DIV         (0x19)
#define ICM20602_CONFIG             (0x1A)
#define ICM20602_GYRO_CONFIG        (0x1B)
#define ICM20602_ACCEL_CONFIG       (0x1C)
#define ICM20602_ACCEL_CONFIG_2     (0x1D)
#define ICM20602_LP_MODE_CFG        (0x1E)
#define ICM20602_ACCEL_WOM_X_THR    (0x20)
#define ICM20602_ACCEL_WOM_Y_THR    (0x21)
#define ICM20602_ACCEL_WOM_Z_THR    (0x22)
#define ICM20602_FIFO_EN            (0x23)
#define ICM20602_FSYNC_INT          (0x36)
#define ICM20602_INT_PIN_CFG        (0x37)
#define ICM20602_INT_ENABLE         (0x38)
#define ICM20602_FIFO_WM_INT_STATUS (0x39)
#define ICM20602_INT_STATUS         (0x3A)
#define ICM20602_ACCEL_XOUT_H       (0x3B)
#define ICM20602_ACCEL_XOUT_L       (0x3C)
#define ICM20602_ACCEL_YOUT_H       (0x3D)
#define ICM20602_ACCEL_YOUT_L       (0x3E)
#define ICM20602_ACCEL_ZOUT_H       (0x3F)
#define ICM20602_ACCEL_ZOUT_L       (0x40)
#define ICM20602_TEMP_OUT_H         (0x41)
#define ICM20602_TEMP_OUT_L         (0x42)
#define ICM20602_GYRO_XOUT_H        (0x43)
#define ICM20602_GYRO_XOUT_L        (0x44)
#define ICM20602_GYRO_YOUT_H        (0x45)
#define ICM20602_GYRO_YOUT_L        (0x46)
#define ICM20602_GYRO_ZOUT_H        (0x47)
#define ICM20602_GYRO_ZOUT_L        (0x48)
#define ICM20602_SELF_TEST_X_GYRO   (0x50)
#define ICM20602_SELF_TEST_Y_GYRO   (0x51)
#define ICM20602_SELF_TEST_Z_GYRO   (0x52)
#define ICM20602_FIFO_WM_TH1        (0x60)
#define ICM20602_FIFO_WM_TH2        (0x61)
#define ICM20602_SIGNAL_PATH_RESET  (0x68)
#define ICM20602_ACCEL_INTEL_CTRL   (0x69)
#define ICM20602_USER_CTRL          (0x6A)
#define ICM20602_PWR_MGMT_1         (0x6B)
#define ICM20602_PWR_MGMT_2         (0x6C)
#define ICM20602_I2C_IF             (0x70)
#define ICM20602_FIFO_COUNTH        (0x72)
#define ICM20602_FIFO_COUNTL        (0x73)
#define ICM20602_FIFO_R_W           (0x74)
#define ICM20602_WHO_AM_I           (0x75)
#define ICM20602_XA_OFFSET_H        (0x77)
#define ICM20602_XA_OFFSET_L        (0x78)
#define ICM20602_YA_OFFSET_H        (0x7A)
#define ICM20602_YA_OFFSET_L        (0x7B)
#define ICM20602_ZA_OFFSET_H        (0x7D)
#define ICM20602_ZA_OFFSET_L        (0x7E)

#define ICM20602_ACC_SAMPLE         (0x10)                                      // ٶȼ
// Ϊ:0x00 ٶȼΪ:2g          ȡļٶȼ 16384      תΪλݣλg(m/s^2)
// Ϊ:0x08 ٶȼΪ:4g          ȡļٶȼ 8192       תΪλݣλg(m/s^2)
// Ϊ:0x10 ٶȼΪ:8g          ȡļٶȼ 4096       תΪλݣλg(m/s^2)
// Ϊ:0x18 ٶȼΪ:16g         ȡļٶȼ 2048       תΪλݣλg(m/s^2)

#define ICM20602_GYR_SAMPLE         (0x18)                                      // 
// Ϊ:0x00 Ϊ:250 dps     ȡݳ131           תΪλݣλΪ/s
// Ϊ:0x08 Ϊ:500 dps     ȡݳ65.5          תΪλݣλΪ/s
// Ϊ:0x10 Ϊ:1000dps     ȡݳ32.8          תΪλݣλΪ/s
// Ϊ:0x18 Ϊ:2000dps     ȡݳ16.4          תΪλݣλΪ/s
//================================================ ICM20602 ڲַ================================================


//================================================ ICM20602 ȫֱ================================================
extern int16 icm20602_gyro_x, icm20602_gyro_y, icm20602_gyro_z;                 //       GYRO ()
extern int16 icm20602_acc_x,  icm20602_acc_y,  icm20602_acc_z;                  // ٶȼ     ACC  (accelerometer ٶȼ)
extern float icm20602_transition_factor[2];                                     // תʵֵı
//================================================ ICM20602 ȫֱ================================================


//================================================ ICM20602 ================================================
void    icm20602_get_acc            (void);                                     // ȡ ICM20602 ٶȼ
void    icm20602_get_gyro           (void);                                     // ȡ ICM20602 
uint8   icm20602_init               (void);                                     // ʼ ICM20602
//================================================ ICM20602 ================================================


//================================================ ICM20602 չ================================================
//-------------------------------------------------------------------------------------------------------------------
//       ICM20602 ٶȼתΪʵ
// ˵     acc_value       ļٶȼ
// ز     void
// ʹʾ     float data = icm20602_acc_transition(icm20602_acc_x);               // λΪ g(m/s^2)
// עϢ
//-------------------------------------------------------------------------------------------------------------------
#define icm20602_acc_transition(acc_value)      ((float)(acc_value) / icm20602_transition_factor[0])

//-------------------------------------------------------------------------------------------------------------------
//       ICM20602 תΪʵ
// ˵     gyro_value      
// ز     void
// ʹʾ     float data = icm20602_gyro_transition(icm20602_gyro_x);             // λΪ /s
// עϢ
//-------------------------------------------------------------------------------------------------------------------
#define icm20602_gyro_transition(gyro_value)    ((float)(gyro_value) / icm20602_transition_factor[1])
//================================================ ICM20602 չ================================================


#endif

