/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_gnss
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2024-01-02       pudding           first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   RX                  鿴 zf_device_gnss.h  GNSS_RX 궨
*                   TX                  鿴 zf_device_gnss.h  GNSS_TX 궨
*                   VCC                 3.3VԴ
*                   GND                 Դ
*                   ------------------------------------
********************************************************************************************************************/

#ifndef _zf_device_gnss_h_
#define _zf_device_gnss_h_

#include "zf_common_typedef.h"

//--------------------------------------------------------------------------------------------------
//
//--------------------------------------------------------------------------------------------------
#define GNSS_UART           (UART_3)
#define GNSS_RX             (UART3_TX_P15_6)                                    // GPS RXӵƬ
#define GNSS_TX             (UART3_RX_P15_7)                                    // GPS TX

#define ANGLE_TO_RAD(x)     ( (x) * PI / 180.0 )                                // ǶתΪ
#define RAD_TO_ANGLE(x)     ( (x) * 180.0 / PI )                                // תΪǶ
#define PI                  ( 3.1415926535898 )

typedef enum
{
    TAU1201 = 1,                                                                // ɿƼ˫ƵGPSģ
    GN42A   = 1,                                                                // ɿƼ˫ƵGPSģ TAU1201һ
    GN43RFA = 2,                                                                // ɿƼƵRTKģ
}gps_device_enum;

typedef struct
{
    uint16      year;  
    uint8       month; 
    uint8       day;
    uint8       hour;
    uint8       minute;
    uint8       second;
}gps_time_struct;

typedef struct
{
    gps_time_struct    time;                                                    // ʱ
    
    uint8       state;                                                          // Ч״̬  1λЧ  0λЧ
    
    uint16      latitude_degree;                                                // 
    uint16      latitude_cent;                                                  // 
    uint16      latitude_second;                                                //     ǱŴ100ģҪǱʹø
    uint16      longitude_degree;                                               // 
    uint16      longitude_cent;                                                 // 
    uint16      longitude_second;                                               //     ǱŴ100ģҪǱʹø
    
    double      latitude;                                                       // γ
    double      longitude;                                                      // 
    
    int8        ns;                                                             // γȰ N򣩻 Sϰ
    int8        ew;                                                             // Ȱ E W
    
    float       speed;                                                          // ٶȣ/ÿСʱ
    float       direction;                                                      // 溽000.0~359.9 ȣ汱Ϊο׼+
    uint8       antenna_direction_state;                                        // ˫߲Ч״̬ 1Ч  0ЧЧʱantenna_directionЧ
    float       antenna_direction;                                              // ָ汱ɵļнǣ000.0~359.9 ȣ
    
    // ϢGNGGAлȡ
    uint8       satellite_used;                                                 // ڶλ
    float       height;                                                         // ߶
}gnss_info_struct;

typedef enum
{
    GPS_STATE_RECEIVING,                                                        // ڽ
    GPS_STATE_RECEIVED,                                                         // ݽ
    GPS_STATE_PARSING,                                                          // ڽ
}gps_state_enum;

extern gnss_info_struct gnss;
extern uint8            gnss_flag;


double      get_two_points_distance     (double lat1, double lng1, double lat2, double lng2);
double      get_two_points_azimuth      (double lat1, double lon1, double lat2, double lon2);
uint8       gnss_data_parse             (void);
void        gnss_uart_callback          (void);
void        gnss_init                   (gps_device_enum gps_device);

#endif
