/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_absolute_encoder
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding           first version
* 2023-04-25       pudding           ע˵
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   SCLK               鿴 zf_device_absolute_encoder.h  ABSOLUTE_ENCODER_SCLK_PIN 궨
*                   MOSI               鿴 zf_device_absolute_encoder.h  ABSOLUTE_ENCODER_MOSI_PIN 궨
*                   MISO               鿴 zf_device_absolute_encoder.h  ABSOLUTE_ENCODER_MISO_PIN 궨
*                   CS                 鿴 zf_device_absolute_encoder.h  ABSOLUTE_ENCODER_CS_PIN 궨
*                   VCC                3.3VԴ
*                   GND                Դ
*                   ------------------------------------
********************************************************************************************************************/

#ifndef _zf_device_absolute_encoder_h_
#define _zf_device_absolute_encoder_h_

#include "zf_common_typedef.h"

//================================================= Ƕȴ ================================================
#define ABSOLUTE_ENCODER_USE_SOFT_SPI       (0)                                 // ĬʹӲ SPI ʽ
#if ABSOLUTE_ENCODER_USE_SOFT_SPI                                               //  ɫĲȷ ɫҵľûõ
//==================================================== SPI ====================================================
#define ABSOLUTE_ENCODER_SOFT_SPI_DELAY     (1)                                 //  SPI ʱʱ ֵԽС SPI ͨԽ
#define ABSOLUTE_ENCODER_SCLK_PIN           (P20_11)                            //  SPI SCK 
#define ABSOLUTE_ENCODER_MOSI_PIN           (P20_14)                            //  SPI MOSI 
#define ABSOLUTE_ENCODER_MISO_PIN           (P20_12)                            //  SPI MISO 
//==================================================== SPI ====================================================
#else
//====================================================Ӳ SPI ====================================================
#define ABSOLUTE_ENCODER_SPI_SPEED          (10*1000*1000)                      // Ӳ SPI 
#define ABSOLUTE_ENCODER_SPI                (SPI_0)                             // Ӳ SPI 
#define ABSOLUTE_ENCODER_SCLK_PIN           (SPI0_SCLK_P20_11)                  // Ӳ SPI SCK 
#define ABSOLUTE_ENCODER_MOSI_PIN           (SPI0_MOSI_P20_14)                  // Ӳ SPI MOSI 
#define ABSOLUTE_ENCODER_MISO_PIN           (SPI0_MISO_P20_12)                  // Ӳ SPI MISO 
//====================================================Ӳ SPI ====================================================
#endif

#define ABSOLUTE_ENCODER_CS_PIN             (P20_13)                            // CSŶ
#define ABSOLUTE_ENCODER_CSN(x)             ((x) ? (gpio_high(ABSOLUTE_ENCODER_CS_PIN)): (gpio_low(ABSOLUTE_ENCODER_CS_PIN)))

#define ABSOLUTE_ENCODER_TIMEOUT_COUNT      (100)                               // Լ쳬ʱʱ
#define ABSOLUTE_ENCODER_DEFAULT_ZERO       (0)

#define ABSOLUTE_ENCODER_SPI_W              (0x80)
#define ABSOLUTE_ENCODER_SPI_R              (0x40)

#define ABSOLUTE_ENCODER_ZERO_L_REG         (0x00)
#define ABSOLUTE_ENCODER_ZERO_H_REG         (0x01)
#define ABSOLUTE_ENCODER_DIR_REG            (0X09)
//================================================= Ƕȴ ================================================


//================================================= Ƕȴ ================================================
int16   absolute_encoder_get_location       (void);                             // ֵȡǰǶֵ
int16   absolute_encoder_get_offset         (void);                             // ֵȡϴλõƫֵ
uint8   absolute_encoder_init               (void);                             // ֵʼ
//================================================= Ƕȴ ================================================
#endif

