/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_absolute_encoder
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-03       pudding           first version
* 2023-04-25       pudding           ע˵
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   SCLK               鿴 zf_device_absolute_encoder.h  ABSOLUTE_ENCODER_SCLK_PIN 궨
*                   MOSI               鿴 zf_device_absolute_encoder.h  ABSOLUTE_ENCODER_MOSI_PIN 궨
*                   MISO               鿴 zf_device_absolute_encoder.h  ABSOLUTE_ENCODER_MISO_PIN 궨
*                   CS                 鿴 zf_device_absolute_encoder.h  ABSOLUTE_ENCODER_CS_PIN 궨
*                   VCC                3.3VԴ
*                   GND                Դ
*                   ------------------------------------
********************************************************************************************************************/


#include "zf_common_debug.h"
#include "zf_common_function.h"
#include "zf_driver_delay.h"
#include "zf_driver_soft_spi.h"
#include "zf_driver_spi.h"

#include "zf_device_absolute_encoder.h"

static int16 now_location = 0;                  // ǰλö static:̬ļô˱
static int16 last_location = 0;                 // ϴλö static:̬ļô˱

#if ABSOLUTE_ENCODER_USE_SOFT_SPI
static soft_spi_info_struct                 absolute_encoder_spi;                                   // ǶȱSPIṹ
#define absolute_encoder_read()             (soft_spi_read_8bit(&absolute_encoder_spi))             // ݶȡ
#define absolute_encoder_write(data)        (soft_spi_write_8bit(&absolute_encoder_spi, (data)))    // д뺯
#else
#define absolute_encoder_read()             (spi_read_8bit(ABSOLUTE_ENCODER_SPI))                   // ݶȡ
#define absolute_encoder_write(data)        (spi_write_8bit(ABSOLUTE_ENCODER_SPI, (data)))          // д뺯
#endif

//-------------------------------------------------------------------------------------------------------------------
//      ֵдĴ
// ˵     reg             Ĵַ
// ˵     data            
// ز     void
// ʹʾ     absolute_encoder_write_register(i + 1, dat[i]);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static void absolute_encoder_write_register(uint8 reg, uint8 data)
{
    ABSOLUTE_ENCODER_CSN(0);                                                    // Ƭѡѡ
    absolute_encoder_write(reg | ABSOLUTE_ENCODER_SPI_W);                       // Ĵ
    absolute_encoder_write(data);                                               // 
    ABSOLUTE_ENCODER_CSN(1);                                                    // Ƭѡͷ
    system_delay_us(1);                                                         // Ҫ
    ABSOLUTE_ENCODER_CSN(0);                                                    // Ƭѡѡ
    absolute_encoder_read();                                                    // ᷵дǷɹ ж
    absolute_encoder_read();                                                    // Ҫ
    ABSOLUTE_ENCODER_CSN(1);                                                    // Ƭѡͷ
}

//-------------------------------------------------------------------------------------------------------------------
//      ֵĴ ڲ
// ˵     reg             Ĵַ
// ز     uint8           
// ʹʾ     absolute_encoder_read_register(6);
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint8 absolute_encoder_read_register(uint8 reg)
{
    uint8 data = 0;
    ABSOLUTE_ENCODER_CSN(0);                                                    // Ƭѡѡ
    absolute_encoder_write(reg | ABSOLUTE_ENCODER_SPI_R);                       // Ĵ
    absolute_encoder_write(0x00);                                               // ռλ
    ABSOLUTE_ENCODER_CSN(1);                                                    // Ƭѡͷ
    system_delay_us(1);                                                         // Ҫ
    ABSOLUTE_ENCODER_CSN(0);                                                    // Ƭѡѡ
    data = absolute_encoder_read();                                             // ȡȡ
    absolute_encoder_read();                                                    // Ҫ
    ABSOLUTE_ENCODER_CSN(1);                                                    // Ƭѡͷ
    return data;
}

//-------------------------------------------------------------------------------------------------------------------
//      ֵλ ڲ
// ˵     void
// ز     uint16          λֵ
// ʹʾ     absolute_encoder_read_data();
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint16 absolute_encoder_read_data (void)
{
    uint16 data = 0;
    ABSOLUTE_ENCODER_CSN(0);                                                    // Ƭѡѡ
    data = absolute_encoder_read();                                             // ȡ߰λ
    data = (data & 0x00FF) << 8;                                                // λ
    data |= absolute_encoder_read();                                            // ȡͰλ
    ABSOLUTE_ENCODER_CSN(1);                                                    // Ƭѡͷ
    return data;
}

//-------------------------------------------------------------------------------------------------------------------
//      ֵԼ ڲ
// ˵     void
// ز     uint8           Լ״̬
// ʹʾ     absolute_encoder_self_check();
// עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint8 absolute_encoder_self_check (void)
{
    uint8 i = 0, return_state = 0;
    uint8 dat[6] = {0, 0, 0, 0xC0, 0xFF, 0x1C};
    uint16 time_count = 0;
    while(0x1C != absolute_encoder_read_register(6))                            // ȡ״̬Ĵ
    {
        for(i = 0; 6 > i; i ++)
        {
            absolute_encoder_write_register(i + 1, dat[i]);                     // дĬò
            system_delay_ms(1);
        }
        if(ABSOLUTE_ENCODER_TIMEOUT_COUNT < time_count ++)                      // ȴʱ
        {
            return_state = 1;
            break;
        }
    }
    return return_state;
}

//-------------------------------------------------------------------------------------------------------------------
//      ֵȡǰǶֵ
// ˵     void
// ز     int16           Ƕֵ
// ʹʾ     absolute_encoder_get_location();
// עϢ
//-------------------------------------------------------------------------------------------------------------------
int16 absolute_encoder_get_location (void)
{
    last_location = now_location;                                               // ǰһελ
    now_location = absolute_encoder_read_data() >> 4;                           // ȡǰλ
    return now_location;
}

//-------------------------------------------------------------------------------------------------------------------
//      ֵȡϴλõƫֵ
// ˵     void
// ز     int16           ƫֵ
// ʹʾ     absolute_encoder_get_offset();
// עϢ
//-------------------------------------------------------------------------------------------------------------------
int16 absolute_encoder_get_offset (void)
{
    int16 result_data = 0;
    if(2048 < func_abs(now_location - last_location))
    {
        result_data = (2048 < now_location ? (now_location - 4096 - last_location) : (now_location + 4096 - last_location));
    }
    else
    {
        result_data = (now_location - last_location);
    }
    return result_data;
}

//-------------------------------------------------------------------------------------------------------------------
//      ֵʼ
// ˵     void
// ز     uint8           ʼ״̬ 0-ɹ 1-ʧ
// ʹʾ     absolute_encoder_init();
// עϢ
//-------------------------------------------------------------------------------------------------------------------
uint8 absolute_encoder_init (void)
{
    uint8 return_state = 0;
    uint16 zero_position = ABSOLUTE_ENCODER_DEFAULT_ZERO;
#if ABSOLUTE_ENCODER_USE_SOFT_SPI
    soft_spi_init(&absolute_encoder_spi, 0, ABSOLUTE_ENCODER_SOFT_SPI_DELAY, ABSOLUTE_ENCODER_SCLK_PIN, ABSOLUTE_ENCODER_MOSI_PIN, ABSOLUTE_ENCODER_MISO_PIN, SOFT_SPI_PIN_NULL);
#else
    spi_init(ABSOLUTE_ENCODER_SPI, SPI_MODE0, ABSOLUTE_ENCODER_SPI_SPEED, ABSOLUTE_ENCODER_SCLK_PIN, ABSOLUTE_ENCODER_MOSI_PIN, ABSOLUTE_ENCODER_MISO_PIN, SPI_CS_NULL);
#endif
    gpio_init(ABSOLUTE_ENCODER_CS_PIN, GPO, GPIO_LOW, GPO_PUSH_PULL);

    do
    {
        if(absolute_encoder_self_check())
        {
            // ˶Ϣ ʾλ
            // ôǾֵԼʱ˳
            // һ½û ûܾǻ
            return_state = 1;
            zf_log(0, "absolute encoder init errror.");
            break;
        }
        absolute_encoder_write_register(ABSOLUTE_ENCODER_DIR_REG, 0x00);                    // ת תֵС0x00   תֵ0x80
        zero_position = (uint16)(4096 - zero_position);
        zero_position = zero_position << 4;
        absolute_encoder_write_register(ABSOLUTE_ENCODER_ZERO_L_REG, (uint8)zero_position); // λ
        absolute_encoder_write_register(ABSOLUTE_ENCODER_ZERO_H_REG, zero_position >> 8);
    }while(0);
    return return_state;
}
