/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          seekfree_assistant_interface
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2024-01-01       pudding            first version
********************************************************************************************************************/

#include "zf_common_typedef.h"
#include "zf_common_fifo.h"
#include "zf_common_debug.h"
#include "zf_driver_uart.h"
#include "zf_device_wireless_uart.h"
#include "zf_device_bluetooth_ch9141.h"
#include "zf_device_wifi_uart.h"
#include "zf_device_wifi_spi.h"
#include "seekfree_assistant.h"

#include "seekfree_assistant_interface.h"


extern seekfree_assistant_transfer_callback_function   seekfree_assistant_transfer_callback;    // ݷͺָ
extern seekfree_assistant_receive_callback_function    seekfree_assistant_receive_callback;     // ݽպָ


//-------------------------------------------------------------------------------------------------------------------
//      ַͺ
// ˵     *buff           Ҫ͵ݵַ
// ˵     length          Ҫ͵ĳ
// ز     uint32          ʣδݳ
// ʹʾ
//-------------------------------------------------------------------------------------------------------------------
ZF_WEAK uint32 seekfree_assistant_transfer (const uint8 *buff, uint32 length)
{
    
    // ѡԶͨѶʽʱ Ҫݷ͹
    return length;
}

//-------------------------------------------------------------------------------------------------------------------
//      ֽݺ
// ˵     *buff           Ҫյݵַ
// ˵     length          Ҫյ󳤶
// ز     uint32          յݳ
// ʹʾ
//-------------------------------------------------------------------------------------------------------------------
ZF_WEAK uint32 seekfree_assistant_receive (uint8 *buff, uint32 length)
{
    // ѡԶͨѶʽʱ Ҫݽչ
    return 0;
}

//-------------------------------------------------------------------------------------------------------------------
//      ֽӿ ʼ
// ˵
// ز     void
// ʹʾ     seekfree_assistant_interface_init(SEEKFREE_ASSISTANT_WIFI_SPI); ʹøWIFI SPIģշ
// ע         Ҫе豸ĳʼʹתڽݵշҪеתڵĳʼȻٵseekfree_assistant_interface_initֵĽӿڳʼ
//-------------------------------------------------------------------------------------------------------------------
ZF_WEAK void seekfree_assistant_interface_init (seekfree_assistant_transfer_device_enum transfer_device)
{
    switch(transfer_device)
    {
        case SEEKFREE_ASSISTANT_DEBUG_UART:
        {
            seekfree_assistant_transfer_callback = debug_send_buffer;
            seekfree_assistant_receive_callback = debug_read_ring_buffer;
        }break;
        
        case SEEKFREE_ASSISTANT_WIRELESS_UART:
        {
            seekfree_assistant_transfer_callback = wireless_uart_send_buffer;
            seekfree_assistant_receive_callback = wireless_uart_read_buffer;
        }break;
        
        case SEEKFREE_ASSISTANT_BLE6A20:
        {
//            seekfree_assistant_transfer_callback = ble6a20_send_buffer;
//            seekfree_assistant_receive_callback = ble6a20_read_buffer;
        }break;

        case SEEKFREE_ASSISTANT_CH9141:
        {
            seekfree_assistant_transfer_callback = bluetooth_ch9141_send_buffer;
            seekfree_assistant_receive_callback = bluetooth_ch9141_read_buffer;
        }break;
        
        case SEEKFREE_ASSISTANT_WIFI_UART:
        {
            seekfree_assistant_transfer_callback = wifi_uart_send_buffer;
            seekfree_assistant_receive_callback = wifi_uart_read_buffer;
        }break;
        
        case SEEKFREE_ASSISTANT_WIFI_SPI:
        {
            seekfree_assistant_transfer_callback = wifi_spi_send_buffer;
            seekfree_assistant_receive_callback = wifi_spi_read_buffer;
        }break;
        
        case SEEKFREE_ASSISTANT_CUSTOM:
        {         
            // Լ ʵseekfree_assistant_transferseekfree_assistant_receiveݵշ
            
        }break;
    }
}


