/*********************************************************************************************************************
* TC377 Opensourec Library TC377 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC377 Դһ
*
* TC377 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
* 
* ļ          seekfree_assistant
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC377TP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2024-01-01       pudding            first version
********************************************************************************************************************/
#ifndef _seekfree_assistant_h_
#define _seekfree_assistant_h_


#include "zf_common_typedef.h"


// 1ʹܲڵĹ  0رղڵĹ
#define SEEKFREE_ASSISTANT_SET_PARAMETR_ENABLE      ( 1 )



// FIFOС
#define SEEKFREE_ASSISTANT_BUFFER_SIZE              ( 0x80 )
    
// ʾͨ
#define SEEKFREE_ASSISTANT_SET_OSCILLOSCOPE_COUNT   ( 0x08 )
    
// Եͨ
#define SEEKFREE_ASSISTANT_SET_PARAMETR_COUNT       ( 0x08 )
    
// ͼ
#define SEEKFREE_ASSISTANT_CAMERA_MAX_BOUNDARY      ( 0x08 )
    
// Ƭλ͵֡ͷ
#define SEEKFREE_ASSISTANT_SEND_HEAD                ( 0xAA )
    
// ͷ
#define SEEKFREE_ASSISTANT_CAMERA_FUNCTION          ( 0x02 )
#define SEEKFREE_ASSISTANT_CAMERA_DOT_FUNCTION      ( 0x03 )
#define SEEKFREE_ASSISTANT_CAMERA_OSCILLOSCOPE      ( 0x10 )
    
// λƬ͵֡ͷ
#define SEEKFREE_ASSISTANT_RECEIVE_HEAD             ( 0x55 )
    
// 
#define SEEKFREE_ASSISTANT_RECEIVE_SET_PARAMETER    ( 0x20 )


// ͷö
typedef enum
{
    // ͷͺŶ
    SEEKFREE_ASSISTANT_OV7725_BIN = 1,
    SEEKFREE_ASSISTANT_MT9V03X,
    SEEKFREE_ASSISTANT_SCC8660,

    // ͼͶ
    SEEKFREE_ASSISTANT_BINARY = 1,
    SEEKFREE_ASSISTANT_GRAY,
    SEEKFREE_ASSISTANT_RGB565,
}seekfree_assistant_image_type_enum;

// ͷö
typedef enum
{
    // ͷͺŶ
    X_BOUNDARY,     // ͵ͼб߽ϢֻXҲֻкϢͼ߶ȵõ
    Y_BOUNDARY,     // ͵ͼб߽ϢֻYҲֻϢͼȵõͨ
    XY_BOUNDARY,    // ͵ͼб߽ϢXYָλãͿԷʾЧ
    NO_BOUNDARY,    // ͵ͼûбϢ
}seekfree_assistant_boundary_type_enum;

typedef struct
{
    uint8 head;                                                 // ֡ͷ
    uint8 channel_num;                                          // λΪ  λΪͨ
    uint8 check_sum;                                            // У
    uint8 length;                                               // 
    float data[SEEKFREE_ASSISTANT_SET_OSCILLOSCOPE_COUNT];      // ͨ
}seekfree_assistant_oscilloscope_struct;


typedef struct
{
    uint8 head;                                                 // ֡ͷ
    uint8 function;                                             // 
    uint8 camera_type;                                          // λʾ߽ λʾǷͼ  0x133ʾһͼ߽磨߽ͨ硢ߡұ߽磩1ʾûͼ
    uint8 length;                                               // ȣЭ鲿֣
    uint16 image_width;                                         // ͼ
    uint16 image_height;                                        // ͼ߶
}seekfree_assistant_camera_struct;          
            
            
typedef struct          
{           
    uint8 head;                                                 // ֡ͷ
    uint8 function;                                             // 
    uint8 dot_type;                                             //   BIT5116λ 08λ    BIT7-BIT60ֻX 1ֻY 2XY궼    BIT3-BIT0߽
    uint8 length;                                               // ȣЭ鲿֣
    uint16 dot_num;                                             // 
    uint8  valid_flag;                                          // ͨʶ
    uint8  reserve;                                             // 
}seekfree_assistant_camera_dot_struct;          
            
typedef struct          
{           
    void *image_addr;                                           // ͷַ
    uint16 width;                                               // ͼ
    uint16 height;                                              // ͼ߶
    seekfree_assistant_image_type_enum camera_type;             // ͷ
    void *boundary_x[SEEKFREE_ASSISTANT_CAMERA_MAX_BOUNDARY];   // ַ߽
    void *boundary_y[SEEKFREE_ASSISTANT_CAMERA_MAX_BOUNDARY];   // ַ߽
}seekfree_assistant_camera_buffer_struct;

typedef struct
{
    uint8 head;                                                 // ֡ͷ
    uint8 function;                                             // 
    uint8 channel;                                              // ͨ
    uint8 check_sum;                                            // У
    float data;                                                 // 
}seekfree_assistant_parameter_struct;

typedef uint32 (*seekfree_assistant_transfer_callback_function) (const uint8 *buff, uint32 length);
typedef uint32 (*seekfree_assistant_receive_callback_function)  (uint8 *buff, uint32 length);

extern seekfree_assistant_oscilloscope_struct                   seekfree_assistant_oscilloscope_data;                                               // ʾ
extern float                                                    seekfree_assistant_parameter[SEEKFREE_ASSISTANT_SET_PARAMETR_COUNT];                // յĲ
extern vuint8                                                   seekfree_assistant_parameter_update_flag[SEEKFREE_ASSISTANT_SET_PARAMETR_COUNT];    // ±־λ
    
    
void    seekfree_assistant_oscilloscope_send                    (seekfree_assistant_oscilloscope_struct *seekfree_assistant_oscilloscope);
void    seekfree_assistant_camera_information_config            (seekfree_assistant_image_type_enum camera_type, void *image_addr, uint16 width, uint16 height);
void    seekfree_assistant_camera_boundary_config               (seekfree_assistant_boundary_type_enum boundary_type, uint16 dot_num, void *dot_x1, void *dot_x2, void *dot_x3, void *dot_y1, void *dot_y2, void *dot_y3);
void    seekfree_assistant_camera_send                          (void);
void    seekfree_assistant_data_analysis                        (void);



#endif
