/**
 * \file Ifx_FftF32_TwiddleTable.c
 * \brief Floating-point Fast Fourier Transform Twiddle-Factors
 *
 *
 * \version disabled
 * \copyright Copyright (c) 2013 Infineon Technologies AG. All rights reserved.
 *
 *
 *                                 IMPORTANT NOTICE
 *
 *
 * Use of this file is subject to the terms of use agreed between (i) you or 
 * the company in which ordinary course of business you are acting and (ii) 
 * Infineon Technologies AG or its licensees. If and as long as no such 
 * terms of use are agreed, use of this file is subject to following:


 * Boost Software License - Version 1.0 - August 17th, 2003

 * Permission is hereby granted, free of charge, to any person or 
 * organization obtaining a copy of the software and accompanying 
 * documentation covered by this license (the "Software") to use, reproduce,
 * display, distribute, execute, and transmit the Software, and to prepare
 * derivative works of the Software, and to permit third-parties to whom the 
 * Software is furnished to do so, all subject to the following:

 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer, must
 * be included in all copies of the Software, in whole or in part, and all
 * derivative works of the Software, unless such copies or derivative works are
 * solely in the form of machine-executable object code generated by a source
 * language processor.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.

 *
 */

#include "Ifx_FftF32.h"

/*lint -e915*/
IFX_CONST cfloat32 Ifx_g_FftF32_twiddleTable[IFX_FFTF32_MAX_LENGTH / 2] = {
    {_DATAF(1.00000000000000000000),  _DATAF(-0.00000000000000000000)},
    {_DATAF(0.99999994039535522000),  _DATAF(-0.00038349517853930593)},
    {_DATAF(0.99999970197677612000),  _DATAF(-0.00076699029887095094)},
    {_DATAF(0.99999934434890747000),  _DATAF(-0.00115048536099493500)},
    {_DATAF(0.99999880790710449000),  _DATAF(-0.00153398013208061460)},
    {_DATAF(0.99999815225601196000),  _DATAF(-0.00191747478675097230)},
    {_DATAF(0.99999737739562988000),  _DATAF(-0.00230096909217536450)},
    {_DATAF(0.99999642372131348000),  _DATAF(-0.00268446304835379120)},
    {_DATAF(0.99999529123306274000),  _DATAF(-0.00306795677170157430)},
    {_DATAF(0.99999403953552246000),  _DATAF(-0.00345145002938807010)},
    {_DATAF(0.99999266862869263000),  _DATAF(-0.00383494258858263490)},
    {_DATAF(0.99999111890792847000),  _DATAF(-0.00421843444928526880)},
    {_DATAF(0.99998939037322998000),  _DATAF(-0.00460192607715725900)},
    {_DATAF(0.99998760223388672000),  _DATAF(-0.00498541677370667460)},
    {_DATAF(0.99998557567596436000),  _DATAF(-0.00536890700459480290)},
    {_DATAF(0.99998342990875244000),  _DATAF(-0.00575239630416035650)},
    {_DATAF(0.99998116493225098000),  _DATAF(-0.00613588467240333560)},
    {_DATAF(0.99997872114181519000),  _DATAF(-0.00651937210932374000)},
    {_DATAF(0.99997615814208984000),  _DATAF(-0.00690285861492156980)},
    {_DATAF(0.99997347593307495000),  _DATAF(-0.00728634418919682500)},
    {_DATAF(0.99997061491012573000),  _DATAF(-0.00766982883214950560)},
    {_DATAF(0.99996757507324219000),  _DATAF(-0.00805331207811832430)},
    {_DATAF(0.99996441602706909000),  _DATAF(-0.00843679439276456830)},
    {_DATAF(0.99996107816696167000),  _DATAF(-0.00882027484476566310)},
    {_DATAF(0.99995762109756470000),  _DATAF(-0.00920375436544418330)},
    {_DATAF(0.99995404481887817000),  _DATAF(-0.00958723295480012890)},
    {_DATAF(0.99995028972625732000),  _DATAF(-0.00997070968151092530)},
    {_DATAF(0.99994641542434692000),  _DATAF(-0.01035418547689914700)},
    {_DATAF(0.99994236230850220000),  _DATAF(-0.01073765940964222000)},
    {_DATAF(0.99993813037872314000),  _DATAF(-0.01112113147974014300)},
    {_DATAF(0.99993383884429932000),  _DATAF(-0.01150460168719291700)},
    {_DATAF(0.99992930889129639000),  _DATAF(-0.01188807096332311600)},
    {_DATAF(0.99992471933364868000),  _DATAF(-0.01227153837680816700)},
    {_DATAF(0.99991995096206665000),  _DATAF(-0.01265500392764806700)},
    {_DATAF(0.99991500377655029000),  _DATAF(-0.01303846761584281900)},
    {_DATAF(0.99990993738174438000),  _DATAF(-0.01342192851006984700)},
    {_DATAF(0.99990469217300415000),  _DATAF(-0.01380538847297430000)},
    {_DATAF(0.99989932775497437000),  _DATAF(-0.01418884657323360400)},
    {_DATAF(0.99989384412765503000),  _DATAF(-0.01457230187952518500)},
    {_DATAF(0.99988818168640137000),  _DATAF(-0.01495575532317161600)},
    {_DATAF(0.99988234043121338000),  _DATAF(-0.01533920597285032300)},
    {_DATAF(0.99987637996673584000),  _DATAF(-0.01572265475988388100)},
    {_DATAF(0.99987030029296875000),  _DATAF(-0.01610610261559486400)},
    {_DATAF(0.99986404180526733000),  _DATAF(-0.01648954674601554900)},
    {_DATAF(0.99985766410827637000),  _DATAF(-0.01687298715114593500)},
    {_DATAF(0.99985110759735107000),  _DATAF(-0.01725642755627632100)},
    {_DATAF(0.99984443187713623000),  _DATAF(-0.01763986423611640900)},
    {_DATAF(0.99983757734298706000),  _DATAF(-0.01802329905331134800)},
    {_DATAF(0.99983060359954834000),  _DATAF(-0.01840673014521598800)},
    {_DATAF(0.99982345104217529000),  _DATAF(-0.01879015937447547900)},
    {_DATAF(0.99981617927551270000),  _DATAF(-0.01917358487844467200)},
    {_DATAF(0.99980872869491577000),  _DATAF(-0.01955700851976871500)},
    {_DATAF(0.99980115890502930000),  _DATAF(-0.01994042843580246000)},
    {_DATAF(0.99979346990585327000),  _DATAF(-0.02032384648919105500)},
    {_DATAF(0.99978560209274292000),  _DATAF(-0.02070726081728935200)},
    {_DATAF(0.99977755546569824000),  _DATAF(-0.02109067142009735100)},
    {_DATAF(0.99976938962936401000),  _DATAF(-0.02147408016026020100)},
    {_DATAF(0.99976110458374023000),  _DATAF(-0.02185748517513275100)},
    {_DATAF(0.99975264072418213000),  _DATAF(-0.02224088832736015300)},
    {_DATAF(0.99974405765533447000),  _DATAF(-0.02262428589165210700)},
    {_DATAF(0.99973529577255249000),  _DATAF(-0.02300768159329891200)},
    {_DATAF(0.99972641468048096000),  _DATAF(-0.02339107356965541800)},
    {_DATAF(0.99971735477447510000),  _DATAF(-0.02377446182072162600)},
    {_DATAF(0.99970817565917969000),  _DATAF(-0.02415784634649753600)},
    {_DATAF(0.99969881772994995000),  _DATAF(-0.02454122900962829600)},
    {_DATAF(0.99968934059143066000),  _DATAF(-0.02492460608482360800)},
    {_DATAF(0.99967968463897705000),  _DATAF(-0.02530798129737377200)},
    {_DATAF(0.99966990947723389000),  _DATAF(-0.02569135092198848700)},
    {_DATAF(0.99966001510620117000),  _DATAF(-0.02607471868395805400)},
    {_DATAF(0.99964994192123413000),  _DATAF(-0.02645808085799217200)},
    {_DATAF(0.99963968992233276000),  _DATAF(-0.02684143930673599200)},
    {_DATAF(0.99962931871414185000),  _DATAF(-0.02722479403018951400)},
    {_DATAF(0.99961882829666138000),  _DATAF(-0.02760814502835273700)},
    {_DATAF(0.99960815906524658000),  _DATAF(-0.02799149230122566200)},
    {_DATAF(0.99959737062454224000),  _DATAF(-0.02837483584880828900)},
    {_DATAF(0.99958640336990356000),  _DATAF(-0.02875817380845546700)},
    {_DATAF(0.99957531690597534000),  _DATAF(-0.02914150804281234700)},
    {_DATAF(0.99956405162811279000),  _DATAF(-0.02952483855187892900)},
    {_DATAF(0.99955266714096069000),  _DATAF(-0.02990816533565521200)},
    {_DATAF(0.99954110383987427000),  _DATAF(-0.03029148653149604800)},
    {_DATAF(0.99952942132949829000),  _DATAF(-0.03067480400204658500)},
    {_DATAF(0.99951756000518799000),  _DATAF(-0.03105811588466167400)},
    {_DATAF(0.99950557947158813000),  _DATAF(-0.03144142404198646500)},
    {_DATAF(0.99949347972869873000),  _DATAF(-0.03182472661137580900)},
    {_DATAF(0.99948120117187500000),  _DATAF(-0.03220802545547485400)},
    {_DATAF(0.99946874380111694000),  _DATAF(-0.03259132057428360000)},
    {_DATAF(0.99945616722106934000),  _DATAF(-0.03297460824251174900)},
    {_DATAF(0.99944347143173218000),  _DATAF(-0.03335789218544960000)},
    {_DATAF(0.99943059682846069000),  _DATAF(-0.03374117240309715300)},
    {_DATAF(0.99941760301589966000),  _DATAF(-0.03412444517016410800)},
    {_DATAF(0.99940443038940430000),  _DATAF(-0.03450771421194076500)},
    {_DATAF(0.99939113855361938000),  _DATAF(-0.03489097952842712400)},
    {_DATAF(0.99937766790390015000),  _DATAF(-0.03527423739433288600)},
    {_DATAF(0.99936407804489136000),  _DATAF(-0.03565749153494834900)},
    {_DATAF(0.99935030937194824000),  _DATAF(-0.03604074195027351400)},
    {_DATAF(0.99933642148971558000),  _DATAF(-0.03642398491501808200)},
    {_DATAF(0.99932235479354858000),  _DATAF(-0.03680722415447235100)},
    {_DATAF(0.99930816888809204000),  _DATAF(-0.03719045594334602400)},
    {_DATAF(0.99929386377334595000),  _DATAF(-0.03757368400692939800)},
    {_DATAF(0.99927937984466553000),  _DATAF(-0.03795690461993217500)},
    {_DATAF(0.99926477670669556000),  _DATAF(-0.03834012150764465300)},
    {_DATAF(0.99924999475479126000),  _DATAF(-0.03872333094477653500)},
    {_DATAF(0.99923503398895264000),  _DATAF(-0.03910653665661811800)},
    {_DATAF(0.99921995401382446000),  _DATAF(-0.03948973491787910500)},
    {_DATAF(0.99920475482940674000),  _DATAF(-0.03987292572855949400)},
    {_DATAF(0.99918937683105469000),  _DATAF(-0.04025611653923988300)},
    {_DATAF(0.99917387962341309000),  _DATAF(-0.04063929617404937700)},
    {_DATAF(0.99915820360183716000),  _DATAF(-0.04102247208356857300)},
    {_DATAF(0.99914240837097168000),  _DATAF(-0.04140564054250717200)},
    {_DATAF(0.99912649393081665000),  _DATAF(-0.04178880527615547200)},
    {_DATAF(0.99911034107208252000),  _DATAF(-0.04217196255922317500)},
    {_DATAF(0.99909412860870361000),  _DATAF(-0.04255511239171028100)},
    {_DATAF(0.99907773733139038000),  _DATAF(-0.04293825849890708900)},
    {_DATAF(0.99906116724014282000),  _DATAF(-0.04332139343023300200)},
    {_DATAF(0.99904447793960571000),  _DATAF(-0.04370452836155891400)},
    {_DATAF(0.99902766942977905000),  _DATAF(-0.04408765211701393100)},
    {_DATAF(0.99901068210601807000),  _DATAF(-0.04447077214717865000)},
    {_DATAF(0.99899357557296753000),  _DATAF(-0.04485388472676277200)},
    {_DATAF(0.99897629022598267000),  _DATAF(-0.04523698985576629600)},
    {_DATAF(0.99895888566970825000),  _DATAF(-0.04562009125947952300)},
    {_DATAF(0.99894130229949951000),  _DATAF(-0.04600318148732185400)},
    {_DATAF(0.99892359972000122000),  _DATAF(-0.04638626798987388600)},
    {_DATAF(0.99890571832656860000),  _DATAF(-0.04676934704184532200)},
    {_DATAF(0.99888771772384644000),  _DATAF(-0.04715241864323616000)},
    {_DATAF(0.99886953830718994000),  _DATAF(-0.04753548279404640200)},
    {_DATAF(0.99885123968124390000),  _DATAF(-0.04791854321956634500)},
    {_DATAF(0.99883282184600830000),  _DATAF(-0.04830159246921539300)},
    {_DATAF(0.99881422519683838000),  _DATAF(-0.04868463799357414200)},
    {_DATAF(0.99879544973373413000),  _DATAF(-0.04906767606735229500)},
    {_DATAF(0.99877655506134033000),  _DATAF(-0.04945070296525955200)},
    {_DATAF(0.99875754117965698000),  _DATAF(-0.04983372613787651100)},
    {_DATAF(0.99873834848403931000),  _DATAF(-0.05021674185991287200)},
    {_DATAF(0.99871903657913208000),  _DATAF(-0.05059975013136863700)},
    {_DATAF(0.99869954586029053000),  _DATAF(-0.05098275095224380500)},
    {_DATAF(0.99867993593215942000),  _DATAF(-0.05136574059724807700)},
    {_DATAF(0.99866014719009399000),  _DATAF(-0.05174872651696205100)},
    {_DATAF(0.99864023923873901000),  _DATAF(-0.05213170498609542800)},
    {_DATAF(0.99862015247344971000),  _DATAF(-0.05251467600464820900)},
    {_DATAF(0.99859994649887085000),  _DATAF(-0.05289763584733009300)},
    {_DATAF(0.99857956171035767000),  _DATAF(-0.05328059196472168000)},
    {_DATAF(0.99855905771255493000),  _DATAF(-0.05366353690624237100)},
    {_DATAF(0.99853843450546265000),  _DATAF(-0.05404647812247276300)},
    {_DATAF(0.99851763248443604000),  _DATAF(-0.05442940816283226000)},
    {_DATAF(0.99849665164947510000),  _DATAF(-0.05481233075261116000)},
    {_DATAF(0.99847555160522461000),  _DATAF(-0.05519524589180946400)},
    {_DATAF(0.99845433235168457000),  _DATAF(-0.05557814985513687100)},
    {_DATAF(0.99843293428421021000),  _DATAF(-0.05596105009317398100)},
    {_DATAF(0.99841141700744629000),  _DATAF(-0.05634393915534019500)},
    {_DATAF(0.99838972091674805000),  _DATAF(-0.05672682076692581200)},
    {_DATAF(0.99836790561676025000),  _DATAF(-0.05710969492793083200)},
    {_DATAF(0.99834591150283813000),  _DATAF(-0.05749255791306495700)},
    {_DATAF(0.99832379817962646000),  _DATAF(-0.05787541717290878300)},
    {_DATAF(0.99830156564712524000),  _DATAF(-0.05825826525688171400)},
    {_DATAF(0.99827915430068970000),  _DATAF(-0.05864110589027404800)},
    {_DATAF(0.99825656414031982000),  _DATAF(-0.05902393534779548600)},
    {_DATAF(0.99823385477066040000),  _DATAF(-0.05940675735473632800)},
    {_DATAF(0.99821102619171143000),  _DATAF(-0.05978957191109657300)},
    {_DATAF(0.99818801879882813000),  _DATAF(-0.06017237529158592200)},
    {_DATAF(0.99816483259201050000),  _DATAF(-0.06055517122149467500)},
    {_DATAF(0.99814152717590332000),  _DATAF(-0.06093795970082283000)},
    {_DATAF(0.99811810255050659000),  _DATAF(-0.06132073700428009000)},
    {_DATAF(0.99809449911117554000),  _DATAF(-0.06170350685715675400)},
    {_DATAF(0.99807077646255493000),  _DATAF(-0.06208626553416252100)},
    {_DATAF(0.99804687500000000000),  _DATAF(-0.06246901676058769200)},
    {_DATAF(0.99802285432815552000),  _DATAF(-0.06285175681114196800)},
    {_DATAF(0.99799871444702148000),  _DATAF(-0.06323449313640594500)},
    {_DATAF(0.99797439575195313000),  _DATAF(-0.06361721456050872800)},
    {_DATAF(0.99794989824295044000),  _DATAF(-0.06399992853403091400)},
    {_DATAF(0.99792528152465820000),  _DATAF(-0.06438262760639190700)},
    {_DATAF(0.99790054559707642000),  _DATAF(-0.06476532667875289900)},
    {_DATAF(0.99787563085556030000),  _DATAF(-0.06514801084995269800)},
    {_DATAF(0.99785053730010986000),  _DATAF(-0.06553068757057189900)},
    {_DATAF(0.99782532453536987000),  _DATAF(-0.06591334939002990700)},
    {_DATAF(0.99779999256134033000),  _DATAF(-0.06629601120948791500)},
    {_DATAF(0.99777448177337646000),  _DATAF(-0.06667865812778472900)},
    {_DATAF(0.99774885177612305000),  _DATAF(-0.06706129014492034900)},
    {_DATAF(0.99772304296493530000),  _DATAF(-0.06744392216205596900)},
    {_DATAF(0.99769711494445801000),  _DATAF(-0.06782653927803039600)},
    {_DATAF(0.99767106771469116000),  _DATAF(-0.06820914149284362800)},
    {_DATAF(0.99764484167098999000),  _DATAF(-0.06859174370765686000)},
    {_DATAF(0.99761843681335449000),  _DATAF(-0.06897433102130889900)},
    {_DATAF(0.99759191274642944000),  _DATAF(-0.06935690343379974400)},
    {_DATAF(0.99756520986557007000),  _DATAF(-0.06973946839570999100)},
    {_DATAF(0.99753844738006592000),  _DATAF(-0.07012202590703964200)},
    {_DATAF(0.99751144647598267000),  _DATAF(-0.07050457596778869600)},
    {_DATAF(0.99748432636260986000),  _DATAF(-0.07088711112737655600)},
    {_DATAF(0.99745708703994751000),  _DATAF(-0.07126963138580322300)},
    {_DATAF(0.99742966890335083000),  _DATAF(-0.07165215164422988900)},
    {_DATAF(0.99740213155746460000),  _DATAF(-0.07203464955091476400)},
    {_DATAF(0.99737441539764404000),  _DATAF(-0.07241714745759964000)},
    {_DATAF(0.99734658002853394000),  _DATAF(-0.07279963046312332200)},
    {_DATAF(0.99731856584548950000),  _DATAF(-0.07318209856748580900)},
    {_DATAF(0.99729043245315552000),  _DATAF(-0.07356456667184829700)},
    {_DATAF(0.99726217985153198000),  _DATAF(-0.07394701242446899400)},
    {_DATAF(0.99723374843597412000),  _DATAF(-0.07432945072650909400)},
    {_DATAF(0.99720513820648193000),  _DATAF(-0.07471188157796859700)},
    {_DATAF(0.99717640876770020000),  _DATAF(-0.07509429752826690700)},
    {_DATAF(0.99714756011962891000),  _DATAF(-0.07547670602798461900)},
    {_DATAF(0.99711853265762329000),  _DATAF(-0.07585910707712173500)},
    {_DATAF(0.99708938598632813000),  _DATAF(-0.07624148577451705900)},
    {_DATAF(0.99706006050109863000),  _DATAF(-0.07662386447191238400)},
    {_DATAF(0.99703061580657959000),  _DATAF(-0.07700622081756591800)},
    {_DATAF(0.99700099229812622000),  _DATAF(-0.07738857716321945200)},
    {_DATAF(0.99697124958038330000),  _DATAF(-0.07777091115713119500)},
    {_DATAF(0.99694132804870605000),  _DATAF(-0.07815324515104293800)},
    {_DATAF(0.99691128730773926000),  _DATAF(-0.07853555679321289100)},
    {_DATAF(0.99688112735748291000),  _DATAF(-0.07891786098480224600)},
    {_DATAF(0.99685078859329224000),  _DATAF(-0.07930015772581100500)},
    {_DATAF(0.99682027101516724000),  _DATAF(-0.07968243956565856900)},
    {_DATAF(0.99678969383239746000),  _DATAF(-0.08006470650434494000)},
    {_DATAF(0.99675887823104858000),  _DATAF(-0.08044696599245071400)},
    {_DATAF(0.99672794342041016000),  _DATAF(-0.08082921057939529400)},
    {_DATAF(0.99669688940048218000),  _DATAF(-0.08121144771575927700)},
    {_DATAF(0.99666565656661987000),  _DATAF(-0.08159366995096206700)},
    {_DATAF(0.99663430452346802000),  _DATAF(-0.08197587728500366200)},
    {_DATAF(0.99660277366638184000),  _DATAF(-0.08235807716846466100)},
    {_DATAF(0.99657112360000610000),  _DATAF(-0.08274026215076446500)},
    {_DATAF(0.99653935432434082000),  _DATAF(-0.08312243968248367300)},
    {_DATAF(0.99650740623474121000),  _DATAF(-0.08350460231304168700)},
    {_DATAF(0.99647527933120728000),  _DATAF(-0.08388675004243850700)},
    {_DATAF(0.99644303321838379000),  _DATAF(-0.08426889032125473000)},
    {_DATAF(0.99641066789627075000),  _DATAF(-0.08465101569890976000)},
    {_DATAF(0.99637812376022339000),  _DATAF(-0.08503312617540359500)},
    {_DATAF(0.99634546041488647000),  _DATAF(-0.08541522175073623700)},
    {_DATAF(0.99631261825561523000),  _DATAF(-0.08579730987548828100)},
    {_DATAF(0.99627965688705444000),  _DATAF(-0.08617939054965972900)},
    {_DATAF(0.99624651670455933000),  _DATAF(-0.08656144887208938600)},
    {_DATAF(0.99621325731277466000),  _DATAF(-0.08694349974393844600)},
    {_DATAF(0.99617981910705566000),  _DATAF(-0.08732553571462631200)},
    {_DATAF(0.99614626169204712000),  _DATAF(-0.08770755678415298500)},
    {_DATAF(0.99611258506774902000),  _DATAF(-0.08808957040309906000)},
    {_DATAF(0.99607872962951660000),  _DATAF(-0.08847156912088394200)},
    {_DATAF(0.99604469537734985000),  _DATAF(-0.08885355293750762900)},
    {_DATAF(0.99601054191589355000),  _DATAF(-0.08923552185297012300)},
    {_DATAF(0.99597626924514771000),  _DATAF(-0.08961748331785202000)},
    {_DATAF(0.99594181776046753000),  _DATAF(-0.08999942988157272300)},
    {_DATAF(0.99590724706649780000),  _DATAF(-0.09038136154413223300)},
    {_DATAF(0.99587249755859375000),  _DATAF(-0.09076327830553054800)},
    {_DATAF(0.99583762884140015000),  _DATAF(-0.09114518761634826700)},
    {_DATAF(0.99580258131027222000),  _DATAF(-0.09152707457542419400)},
    {_DATAF(0.99576741456985474000),  _DATAF(-0.09190895408391952500)},
    {_DATAF(0.99573206901550293000),  _DATAF(-0.09229081869125366200)},
    {_DATAF(0.99569660425186157000),  _DATAF(-0.09267267584800720200)},
    {_DATAF(0.99566102027893066000),  _DATAF(-0.09305451065301895100)},
    {_DATAF(0.99562525749206543000),  _DATAF(-0.09343633800745010400)},
    {_DATAF(0.99558937549591064000),  _DATAF(-0.09381814301013946500)},
    {_DATAF(0.99555331468582153000),  _DATAF(-0.09419994056224823000)},
    {_DATAF(0.99551707506179810000),  _DATAF(-0.09458172321319580100)},
    {_DATAF(0.99548077583312988000),  _DATAF(-0.09496349841356277500)},
    {_DATAF(0.99544423818588257000),  _DATAF(-0.09534525126218795800)},
    {_DATAF(0.99540764093399048000),  _DATAF(-0.09572698920965194700)},
    {_DATAF(0.99537086486816406000),  _DATAF(-0.09610871970653533900)},
    {_DATAF(0.99533390998840332000),  _DATAF(-0.09649042785167694100)},
    {_DATAF(0.99529683589935303000),  _DATAF(-0.09687212854623794600)},
    {_DATAF(0.99525958299636841000),  _DATAF(-0.09725381433963775600)},
    {_DATAF(0.99522227048873901000),  _DATAF(-0.09763548523187637300)},
    {_DATAF(0.99518471956253052000),  _DATAF(-0.09801714122295379600)},
    {_DATAF(0.99514704942703247000),  _DATAF(-0.09839878231287002600)},
    {_DATAF(0.99510926008224487000),  _DATAF(-0.09878040850162506100)},
    {_DATAF(0.99507129192352295000),  _DATAF(-0.09916201978921890300)},
    {_DATAF(0.99503320455551147000),  _DATAF(-0.09954361617565155000)},
    {_DATAF(0.99499493837356567000),  _DATAF(-0.09992520511150360100)},
    {_DATAF(0.99495655298233032000),  _DATAF(-0.10030677169561386000)},
    {_DATAF(0.99491798877716064000),  _DATAF(-0.10068832337856293000)},
    {_DATAF(0.99487930536270142000),  _DATAF(-0.10106986016035080000)},
    {_DATAF(0.99484050273895264000),  _DATAF(-0.10145138949155807000)},
    {_DATAF(0.99480152130126953000),  _DATAF(-0.10183289647102356000)},
    {_DATAF(0.99476242065429688000),  _DATAF(-0.10221438854932785000)},
    {_DATAF(0.99472314119338989000),  _DATAF(-0.10259586572647095000)},
    {_DATAF(0.99468368291854858000),  _DATAF(-0.10297733545303345000)},
    {_DATAF(0.99464416503906250000),  _DATAF(-0.10335878282785416000)},
    {_DATAF(0.99460440874099731000),  _DATAF(-0.10374021530151367000)},
    {_DATAF(0.99456459283828735000),  _DATAF(-0.10412163287401199000)},
    {_DATAF(0.99452453851699829000),  _DATAF(-0.10450303554534912000)},
    {_DATAF(0.99448442459106445000),  _DATAF(-0.10488442331552505000)},
    {_DATAF(0.99444413185119629000),  _DATAF(-0.10526579618453979000)},
    {_DATAF(0.99440366029739380000),  _DATAF(-0.10564715415239334000)},
    {_DATAF(0.99436306953430176000),  _DATAF(-0.10602849721908569000)},
    {_DATAF(0.99432235956192017000),  _DATAF(-0.10640981793403625000)},
    {_DATAF(0.99428147077560425000),  _DATAF(-0.10679113119840622000)},
    {_DATAF(0.99424046277999878000),  _DATAF(-0.10717242211103439000)},
    {_DATAF(0.99419927597045898000),  _DATAF(-0.10755370557308197000)},
    {_DATAF(0.99415796995162964000),  _DATAF(-0.10793496668338776000)},
    {_DATAF(0.99411648511886597000),  _DATAF(-0.10831621289253235000)},
    {_DATAF(0.99407488107681274000),  _DATAF(-0.10869744420051575000)},
    {_DATAF(0.99403309822082520000),  _DATAF(-0.10907866060733795000)},
    {_DATAF(0.99399119615554810000),  _DATAF(-0.10945985466241837000)},
    {_DATAF(0.99394917488098145000),  _DATAF(-0.10984104126691818000)},
    {_DATAF(0.99390697479248047000),  _DATAF(-0.11022220551967621000)},
    {_DATAF(0.99386465549468994000),  _DATAF(-0.11060335487127304000)},
    {_DATAF(0.99382215738296509000),  _DATAF(-0.11098448932170868000)},
    {_DATAF(0.99377948045730591000),  _DATAF(-0.11136560887098312000)},
    {_DATAF(0.99373674392700195000),  _DATAF(-0.11174671351909637000)},
    {_DATAF(0.99369376897811890000),  _DATAF(-0.11212779581546783000)},
    {_DATAF(0.99365073442459106000),  _DATAF(-0.11250886321067810000)},
    {_DATAF(0.99360752105712891000),  _DATAF(-0.11288991570472717000)},
    {_DATAF(0.99356412887573242000),  _DATAF(-0.11327095329761505000)},
    {_DATAF(0.99352061748504639000),  _DATAF(-0.11365196853876114000)},
    {_DATAF(0.99347698688507080000),  _DATAF(-0.11403297632932663000)},
    {_DATAF(0.99343317747116089000),  _DATAF(-0.11441396176815033000)},
    {_DATAF(0.99338918924331665000),  _DATAF(-0.11479492485523224000)},
    {_DATAF(0.99334514141082764000),  _DATAF(-0.11517588049173355000)},
    {_DATAF(0.99330085515975952000),  _DATAF(-0.11555681377649307000)},
    {_DATAF(0.99325650930404663000),  _DATAF(-0.11593773216009140000)},
    {_DATAF(0.99321192502975464000),  _DATAF(-0.11631862819194794000)},
    {_DATAF(0.99316728115081787000),  _DATAF(-0.11669951677322388000)},
    {_DATAF(0.99312245845794678000),  _DATAF(-0.11708038300275803000)},
    {_DATAF(0.99307745695114136000),  _DATAF(-0.11746122688055038000)},
    {_DATAF(0.99303233623504639000),  _DATAF(-0.11784206330776215000)},
    {_DATAF(0.99298709630966187000),  _DATAF(-0.11822287738323212000)},
    {_DATAF(0.99294167757034302000),  _DATAF(-0.11860367655754089000)},
    {_DATAF(0.99289613962173462000),  _DATAF(-0.11898445338010788000)},
    {_DATAF(0.99285042285919189000),  _DATAF(-0.11936521530151367000)},
    {_DATAF(0.99280458688735962000),  _DATAF(-0.11974596232175827000)},
    {_DATAF(0.99275857210159302000),  _DATAF(-0.12012668699026108000)},
    {_DATAF(0.99271243810653687000),  _DATAF(-0.12050739675760269000)},
    {_DATAF(0.99266612529754639000),  _DATAF(-0.12088808417320251000)},
    {_DATAF(0.99261969327926636000),  _DATAF(-0.12126876413822174000)},
    {_DATAF(0.99257314205169678000),  _DATAF(-0.12164941430091858000)},
    {_DATAF(0.99252641201019287000),  _DATAF(-0.12203005701303482000)},
    {_DATAF(0.99247956275939941000),  _DATAF(-0.12241067737340927000)},
    {_DATAF(0.99243253469467163000),  _DATAF(-0.12279127538204193000)},
    {_DATAF(0.99238532781600952000),  _DATAF(-0.12317185848951340000)},
    {_DATAF(0.99233806133270264000),  _DATAF(-0.12355242669582367000)},
    {_DATAF(0.99229061603546143000),  _DATAF(-0.12393297255039215000)},
    {_DATAF(0.99224299192428589000),  _DATAF(-0.12431350350379944000)},
    {_DATAF(0.99219524860382080000),  _DATAF(-0.12469401955604553000)},
    {_DATAF(0.99214732646942139000),  _DATAF(-0.12507450580596924000)},
    {_DATAF(0.99209928512573242000),  _DATAF(-0.12545497715473175000)},
    {_DATAF(0.99205112457275391000),  _DATAF(-0.12583543360233307000)},
    {_DATAF(0.99200278520584106000),  _DATAF(-0.12621587514877319000)},
    {_DATAF(0.99195432662963867000),  _DATAF(-0.12659630179405212000)},
    {_DATAF(0.99190568923950195000),  _DATAF(-0.12697669863700867000)},
    {_DATAF(0.99185693264007568000),  _DATAF(-0.12735708057880402000)},
    {_DATAF(0.99180799722671509000),  _DATAF(-0.12773744761943817000)},
    {_DATAF(0.99175894260406494000),  _DATAF(-0.12811778485774994000)},
    {_DATAF(0.99170976877212524000),  _DATAF(-0.12849810719490051000)},
    {_DATAF(0.99166041612625122000),  _DATAF(-0.12887841463088989000)},
    {_DATAF(0.99161088466644287000),  _DATAF(-0.12925870716571808000)},
    {_DATAF(0.99156123399734497000),  _DATAF(-0.12963896989822388000)},
    {_DATAF(0.99151146411895752000),  _DATAF(-0.13001921772956848000)},
    {_DATAF(0.99146151542663574000),  _DATAF(-0.13039945065975189000)},
    {_DATAF(0.99141144752502441000),  _DATAF(-0.13077966868877411000)},
    {_DATAF(0.99136126041412354000),  _DATAF(-0.13115985691547394000)},
    {_DATAF(0.99131083488464355000),  _DATAF(-0.13154003024101257000)},
    {_DATAF(0.99126034975051880000),  _DATAF(-0.13192018866539001000)},
    {_DATAF(0.99120968580245972000),  _DATAF(-0.13230031728744507000)},
    {_DATAF(0.99115884304046631000),  _DATAF(-0.13268043100833893000)},
    {_DATAF(0.99110794067382813000),  _DATAF(-0.13306052982807159000)},
    {_DATAF(0.99105679988861084000),  _DATAF(-0.13344059884548187000)},
    {_DATAF(0.99100553989410400000),  _DATAF(-0.13382065296173096000)},
    {_DATAF(0.99095416069030762000),  _DATAF(-0.13420069217681885000)},
    {_DATAF(0.99090266227722168000),  _DATAF(-0.13458070158958435000)},
    {_DATAF(0.99085092544555664000),  _DATAF(-0.13496071100234985000)},
    {_DATAF(0.99079912900924683000),  _DATAF(-0.13534067571163177000)},
    {_DATAF(0.99074715375900269000),  _DATAF(-0.13572064042091370000)},
    {_DATAF(0.99069499969482422000),  _DATAF(-0.13610057532787323000)},
    {_DATAF(0.99064278602600098000),  _DATAF(-0.13648049533367157000)},
    {_DATAF(0.99059033393859863000),  _DATAF(-0.13686038553714752000)},
    {_DATAF(0.99053776264190674000),  _DATAF(-0.13724026083946228000)},
    {_DATAF(0.99048507213592529000),  _DATAF(-0.13762012124061584000)},
    {_DATAF(0.99043226242065430000),  _DATAF(-0.13799995183944702000)},
    {_DATAF(0.99037921428680420000),  _DATAF(-0.13837976753711700000)},
    {_DATAF(0.99032610654830933000),  _DATAF(-0.13875956833362579000)},
    {_DATAF(0.99027281999588013000),  _DATAF(-0.13913933932781219000)},
    {_DATAF(0.99021935462951660000),  _DATAF(-0.13951909542083740000)},
    {_DATAF(0.99016582965850830000),  _DATAF(-0.13989883661270142000)},
    {_DATAF(0.99011206626892090000),  _DATAF(-0.14027854800224304000)},
    {_DATAF(0.99005818367004395000),  _DATAF(-0.14065824449062347000)},
    {_DATAF(0.99000418186187744000),  _DATAF(-0.14103791117668152000)},
    {_DATAF(0.98995006084442139000),  _DATAF(-0.14141756296157837000)},
    {_DATAF(0.98989570140838623000),  _DATAF(-0.14179719984531403000)},
    {_DATAF(0.98984128236770630000),  _DATAF(-0.14217680692672729000)},
    {_DATAF(0.98978668451309204000),  _DATAF(-0.14255639910697937000)},
    {_DATAF(0.98973196744918823000),  _DATAF(-0.14293596148490906000)},
    {_DATAF(0.98967707157135010000),  _DATAF(-0.14331550896167755000)},
    {_DATAF(0.98962199687957764000),  _DATAF(-0.14369502663612366000)},
    {_DATAF(0.98956686258316040000),  _DATAF(-0.14407454431056976000)},
    {_DATAF(0.98951148986816406000),  _DATAF(-0.14445401728153229000)},
    {_DATAF(0.98945605754852295000),  _DATAF(-0.14483349025249481000)},
    {_DATAF(0.98940044641494751000),  _DATAF(-0.14521291851997375000)},
    {_DATAF(0.98934465646743774000),  _DATAF(-0.14559234678745270000)},
    {_DATAF(0.98928874731063843000),  _DATAF(-0.14597174525260925000)},
    {_DATAF(0.98923271894454956000),  _DATAF(-0.14635111391544342000)},
    {_DATAF(0.98917651176452637000),  _DATAF(-0.14673046767711639000)},
    {_DATAF(0.98912018537521362000),  _DATAF(-0.14710980653762817000)},
    {_DATAF(0.98906368017196655000),  _DATAF(-0.14748911559581757000)},
    {_DATAF(0.98900705575942993000),  _DATAF(-0.14786840975284576000)},
    {_DATAF(0.98895025253295898000),  _DATAF(-0.14824767410755157000)},
    {_DATAF(0.98889333009719849000),  _DATAF(-0.14862692356109619000)},
    {_DATAF(0.98883628845214844000),  _DATAF(-0.14900614321231842000)},
    {_DATAF(0.98877906799316406000),  _DATAF(-0.14938534796237946000)},
    {_DATAF(0.98872166872024536000),  _DATAF(-0.14976453781127930000)},
    {_DATAF(0.98866420984268188000),  _DATAF(-0.15014369785785675000)},
    {_DATAF(0.98860651254653931000),  _DATAF(-0.15052282810211182000)},
    {_DATAF(0.98854875564575195000),  _DATAF(-0.15090194344520569000)},
    {_DATAF(0.98849081993103027000),  _DATAF(-0.15128104388713837000)},
    {_DATAF(0.98843270540237427000),  _DATAF(-0.15166011452674866000)},
    {_DATAF(0.98837447166442871000),  _DATAF(-0.15203915536403656000)},
    {_DATAF(0.98831611871719360000),  _DATAF(-0.15241818130016327000)},
    {_DATAF(0.98825758695602417000),  _DATAF(-0.15279719233512878000)},
    {_DATAF(0.98819887638092041000),  _DATAF(-0.15317615866661072000)},
    {_DATAF(0.98814010620117188000),  _DATAF(-0.15355512499809265000)},
    {_DATAF(0.98808109760284424000),  _DATAF(-0.15393406152725220000)},
    {_DATAF(0.98802202939987183000),  _DATAF(-0.15431296825408936000)},
    {_DATAF(0.98796278238296509000),  _DATAF(-0.15469186007976532000)},
    {_DATAF(0.98790335655212402000),  _DATAF(-0.15507073700428009000)},
    {_DATAF(0.98784381151199341000),  _DATAF(-0.15544956922531128000)},
    {_DATAF(0.98778414726257324000),  _DATAF(-0.15582840144634247000)},
    {_DATAF(0.98772430419921875000),  _DATAF(-0.15620720386505127000)},
    {_DATAF(0.98766434192657471000),  _DATAF(-0.15658597648143768000)},
    {_DATAF(0.98760420083999634000),  _DATAF(-0.15696471929550171000)},
    {_DATAF(0.98754394054412842000),  _DATAF(-0.15734346210956573000)},
    {_DATAF(0.98748350143432617000),  _DATAF(-0.15772216022014618000)},
    {_DATAF(0.98742294311523438000),  _DATAF(-0.15810084342956543000)},
    {_DATAF(0.98736226558685303000),  _DATAF(-0.15847951173782349000)},
    {_DATAF(0.98730140924453735000),  _DATAF(-0.15885815024375916000)},
    {_DATAF(0.98724043369293213000),  _DATAF(-0.15923675894737244000)},
    {_DATAF(0.98717927932739258000),  _DATAF(-0.15961535274982452000)},
    {_DATAF(0.98711800575256348000),  _DATAF(-0.15999391674995422000)},
    {_DATAF(0.98705655336380005000),  _DATAF(-0.16037245094776154000)},
    {_DATAF(0.98699498176574707000),  _DATAF(-0.16075097024440765000)},
    {_DATAF(0.98693329095840454000),  _DATAF(-0.16112947463989258000)},
    {_DATAF(0.98687142133712769000),  _DATAF(-0.16150794923305511000)},
    {_DATAF(0.98680937290191650000),  _DATAF(-0.16188639402389526000)},
    {_DATAF(0.98674726486206055000),  _DATAF(-0.16226482391357422000)},
    {_DATAF(0.98668491840362549000),  _DATAF(-0.16264322400093079000)},
    {_DATAF(0.98662251234054565000),  _DATAF(-0.16302159428596497000)},
    {_DATAF(0.98655992746353149000),  _DATAF(-0.16339994966983795000)},
    {_DATAF(0.98649716377258301000),  _DATAF(-0.16377827525138855000)},
    {_DATAF(0.98643428087234497000),  _DATAF(-0.16415658593177795000)},
    {_DATAF(0.98637127876281738000),  _DATAF(-0.16453486680984497000)},
    {_DATAF(0.98630809783935547000),  _DATAF(-0.16491311788558960000)},
    {_DATAF(0.98624479770660400000),  _DATAF(-0.16529135406017303000)},
    {_DATAF(0.98618131875991821000),  _DATAF(-0.16566956043243408000)},
    {_DATAF(0.98611772060394287000),  _DATAF(-0.16604773700237274000)},
    {_DATAF(0.98605394363403320000),  _DATAF(-0.16642589867115021000)},
    {_DATAF(0.98599004745483398000),  _DATAF(-0.16680404543876648000)},
    {_DATAF(0.98592603206634521000),  _DATAF(-0.16718214750289917000)},
    {_DATAF(0.98586183786392212000),  _DATAF(-0.16756023466587067000)},
    {_DATAF(0.98579752445220947000),  _DATAF(-0.16793829202651978000)},
    {_DATAF(0.98573303222656250000),  _DATAF(-0.16831633448600769000)},
    {_DATAF(0.98566842079162598000),  _DATAF(-0.16869434714317322000)},
    {_DATAF(0.98560363054275513000),  _DATAF(-0.16907232999801636000)},
    {_DATAF(0.98553872108459473000),  _DATAF(-0.16945029795169830000)},
    {_DATAF(0.98547369241714478000),  _DATAF(-0.16982822120189667000)},
    {_DATAF(0.98540848493576050000),  _DATAF(-0.17020614445209503000)},
    {_DATAF(0.98534315824508667000),  _DATAF(-0.17058402299880981000)},
    {_DATAF(0.98527765274047852000),  _DATAF(-0.17096188664436340000)},
    {_DATAF(0.98521202802658081000),  _DATAF(-0.17133972048759460000)},
    {_DATAF(0.98514622449874878000),  _DATAF(-0.17171753942966461000)},
    {_DATAF(0.98508030176162720000),  _DATAF(-0.17209532856941223000)},
    {_DATAF(0.98501425981521606000),  _DATAF(-0.17247308790683746000)},
    {_DATAF(0.98494803905487061000),  _DATAF(-0.17285081744194031000)},
    {_DATAF(0.98488163948059082000),  _DATAF(-0.17322853207588196000)},
    {_DATAF(0.98481518030166626000),  _DATAF(-0.17360621690750122000)},
    {_DATAF(0.98474848270416260000),  _DATAF(-0.17398387193679810000)},
    {_DATAF(0.98468172550201416000),  _DATAF(-0.17436151206493378000)},
    {_DATAF(0.98461478948593140000),  _DATAF(-0.17473910748958588000)},
    {_DATAF(0.98454767465591431000),  _DATAF(-0.17511670291423798000)},
    {_DATAF(0.98448044061660767000),  _DATAF(-0.17549425363540649000)},
    {_DATAF(0.98441308736801147000),  _DATAF(-0.17587178945541382000)},
    {_DATAF(0.98434555530548096000),  _DATAF(-0.17624929547309875000)},
    {_DATAF(0.98427790403366089000),  _DATAF(-0.17662677168846130000)},
    {_DATAF(0.98421007394790649000),  _DATAF(-0.17700421810150146000)},
    {_DATAF(0.98414212465286255000),  _DATAF(-0.17738164961338043000)},
    {_DATAF(0.98407405614852905000),  _DATAF(-0.17775905132293701000)},
    {_DATAF(0.98400580883026123000),  _DATAF(-0.17813642323017120000)},
    {_DATAF(0.98393744230270386000),  _DATAF(-0.17851376533508301000)},
    {_DATAF(0.98386889696121216000),  _DATAF(-0.17889109253883362000)},
    {_DATAF(0.98380023241043091000),  _DATAF(-0.17926838994026184000)},
    {_DATAF(0.98373138904571533000),  _DATAF(-0.17964565753936768000)},
    {_DATAF(0.98366242647171021000),  _DATAF(-0.18002289533615112000)},
    {_DATAF(0.98359328508377075000),  _DATAF(-0.18040011823177338000)},
    {_DATAF(0.98352402448654175000),  _DATAF(-0.18077731132507324000)},
    {_DATAF(0.98345464468002319000),  _DATAF(-0.18115447461605072000)},
    {_DATAF(0.98338508605957031000),  _DATAF(-0.18153160810470581000)},
    {_DATAF(0.98331540822982788000),  _DATAF(-0.18190871179103851000)},
    {_DATAF(0.98324561119079590000),  _DATAF(-0.18228580057621002000)},
    {_DATAF(0.98317563533782959000),  _DATAF(-0.18266285955905914000)},
    {_DATAF(0.98310548067092896000),  _DATAF(-0.18303988873958588000)},
    {_DATAF(0.98303520679473877000),  _DATAF(-0.18341688811779022000)},
    {_DATAF(0.98296481370925903000),  _DATAF(-0.18379387259483337000)},
    {_DATAF(0.98289424180984497000),  _DATAF(-0.18417081236839294000)},
    {_DATAF(0.98282355070114136000),  _DATAF(-0.18454773724079132000)},
    {_DATAF(0.98275268077850342000),  _DATAF(-0.18492463231086731000)},
    {_DATAF(0.98268169164657593000),  _DATAF(-0.18530149757862091000)},
    {_DATAF(0.98261058330535889000),  _DATAF(-0.18567833304405212000)},
    {_DATAF(0.98253929615020752000),  _DATAF(-0.18605515360832214000)},
    {_DATAF(0.98246788978576660000),  _DATAF(-0.18643194437026978000)},
    {_DATAF(0.98239630460739136000),  _DATAF(-0.18680869042873383000)},
    {_DATAF(0.98232460021972656000),  _DATAF(-0.18718542158603668000)},
    {_DATAF(0.98225271701812744000),  _DATAF(-0.18756212294101715000)},
    {_DATAF(0.98218071460723877000),  _DATAF(-0.18793880939483643000)},
    {_DATAF(0.98210859298706055000),  _DATAF(-0.18831545114517212000)},
    {_DATAF(0.98203629255294800000),  _DATAF(-0.18869207799434662000)},
    {_DATAF(0.98196387290954590000),  _DATAF(-0.18906866014003754000)},
    {_DATAF(0.98189127445220947000),  _DATAF(-0.18944522738456726000)},
    {_DATAF(0.98181855678558350000),  _DATAF(-0.18982176482677460000)},
    {_DATAF(0.98174571990966797000),  _DATAF(-0.19019827246665955000)},
    {_DATAF(0.98167270421981812000),  _DATAF(-0.19057475030422211000)},
    {_DATAF(0.98159950971603394000),  _DATAF(-0.19095121324062347000)},
    {_DATAF(0.98152625560760498000),  _DATAF(-0.19132763147354126000)},
    {_DATAF(0.98145276308059692000),  _DATAF(-0.19170403480529785000)},
    {_DATAF(0.98137921094894409000),  _DATAF(-0.19208039343357086000)},
    {_DATAF(0.98130548000335693000),  _DATAF(-0.19245673716068268000)},
    {_DATAF(0.98123157024383545000),  _DATAF(-0.19283305108547211000)},
    {_DATAF(0.98115754127502441000),  _DATAF(-0.19320933520793915000)},
    {_DATAF(0.98108339309692383000),  _DATAF(-0.19358558952808380000)},
    {_DATAF(0.98100906610488892000),  _DATAF(-0.19396181404590607000)},
    {_DATAF(0.98093461990356445000),  _DATAF(-0.19433800876140594000)},
    {_DATAF(0.98085999488830566000),  _DATAF(-0.19471418857574463000)},
    {_DATAF(0.98078525066375732000),  _DATAF(-0.19509032368659973000)},
    {_DATAF(0.98071038722991943000),  _DATAF(-0.19546642899513245000)},
    {_DATAF(0.98063534498214722000),  _DATAF(-0.19584251940250397000)},
    {_DATAF(0.98056018352508545000),  _DATAF(-0.19621856510639191000)},
    {_DATAF(0.98048484325408936000),  _DATAF(-0.19659459590911865000)},
    {_DATAF(0.98040938377380371000),  _DATAF(-0.19697059690952301000)},
    {_DATAF(0.98033380508422852000),  _DATAF(-0.19734656810760498000)},
    {_DATAF(0.98025804758071899000),  _DATAF(-0.19772249460220337000)},
    {_DATAF(0.98018211126327515000),  _DATAF(-0.19809840619564056000)},
    {_DATAF(0.98010611534118652000),  _DATAF(-0.19847428798675537000)},
    {_DATAF(0.98002988100051880000),  _DATAF(-0.19885013997554779000)},
    {_DATAF(0.97995358705520630000),  _DATAF(-0.19922596216201782000)},
    {_DATAF(0.97987711429595947000),  _DATAF(-0.19960175454616547000)},
    {_DATAF(0.97980046272277832000),  _DATAF(-0.19997751712799072000)},
    {_DATAF(0.97972375154495239000),  _DATAF(-0.20035324990749359000)},
    {_DATAF(0.97964680194854736000),  _DATAF(-0.20072895288467407000)},
    {_DATAF(0.97956979274749756000),  _DATAF(-0.20110464096069336000)},
    {_DATAF(0.97949254512786865000),  _DATAF(-0.20148028433322906000)},
    {_DATAF(0.97941523790359497000),  _DATAF(-0.20185589790344238000)},
    {_DATAF(0.97933775186538696000),  _DATAF(-0.20223148167133331000)},
    {_DATAF(0.97926014661788940000),  _DATAF(-0.20260703563690186000)},
    {_DATAF(0.97918236255645752000),  _DATAF(-0.20298255980014801000)},
    {_DATAF(0.97910445928573608000),  _DATAF(-0.20335806906223297000)},
    {_DATAF(0.97902637720108032000),  _DATAF(-0.20373353362083435000)},
    {_DATAF(0.97894817590713501000),  _DATAF(-0.20410896837711334000)},
    {_DATAF(0.97886985540390015000),  _DATAF(-0.20448437333106995000)},
    {_DATAF(0.97879135608673096000),  _DATAF(-0.20485974848270416000)},
    {_DATAF(0.97871267795562744000),  _DATAF(-0.20523509383201599000)},
    {_DATAF(0.97863394021987915000),  _DATAF(-0.20561040937900543000)},
    {_DATAF(0.97855502367019653000),  _DATAF(-0.20598569512367249000)},
    {_DATAF(0.97847592830657959000),  _DATAF(-0.20636095106601715000)},
    {_DATAF(0.97839671373367310000),  _DATAF(-0.20673617720603943000)},
    {_DATAF(0.97831737995147705000),  _DATAF(-0.20711137354373932000)},
    {_DATAF(0.97823786735534668000),  _DATAF(-0.20748654007911682000)},
    {_DATAF(0.97815823554992676000),  _DATAF(-0.20786167681217194000)},
    {_DATAF(0.97807842493057251000),  _DATAF(-0.20823678374290466000)},
    {_DATAF(0.97799849510192871000),  _DATAF(-0.20861184597015381000)},
    {_DATAF(0.97791844606399536000),  _DATAF(-0.20898689329624176000)},
    {_DATAF(0.97783821821212769000),  _DATAF(-0.20936191082000732000)},
    {_DATAF(0.97775787115097046000),  _DATAF(-0.20973688364028931000)},
    {_DATAF(0.97767734527587891000),  _DATAF(-0.21011184155941010000)},
    {_DATAF(0.97759670019149780000),  _DATAF(-0.21048675477504730000)},
    {_DATAF(0.97751593589782715000),  _DATAF(-0.21086163818836212000)},
    {_DATAF(0.97743499279022217000),  _DATAF(-0.21123650670051575000)},
    {_DATAF(0.97735387086868286000),  _DATAF(-0.21161133050918579000)},
    {_DATAF(0.97727268934249878000),  _DATAF(-0.21198612451553345000)},
    {_DATAF(0.97719132900238037000),  _DATAF(-0.21236088871955872000)},
    {_DATAF(0.97710978984832764000),  _DATAF(-0.21273562312126160000)},
    {_DATAF(0.97702813148498535000),  _DATAF(-0.21311031281948090000)},
    {_DATAF(0.97694635391235352000),  _DATAF(-0.21348498761653900000)},
    {_DATAF(0.97686439752578735000),  _DATAF(-0.21385963261127472000)},
    {_DATAF(0.97678232192993164000),  _DATAF(-0.21423423290252686000)},
    {_DATAF(0.97670006752014160000),  _DATAF(-0.21460881829261780000)},
    {_DATAF(0.97661769390106201000),  _DATAF(-0.21498335897922516000)},
    {_DATAF(0.97653520107269287000),  _DATAF(-0.21535786986351013000)},
    {_DATAF(0.97645252943038940000),  _DATAF(-0.21573235094547272000)},
    {_DATAF(0.97636973857879639000),  _DATAF(-0.21610680222511292000)},
    {_DATAF(0.97628676891326904000),  _DATAF(-0.21648120880126953000)},
    {_DATAF(0.97620368003845215000),  _DATAF(-0.21685560047626495000)},
    {_DATAF(0.97612047195434570000),  _DATAF(-0.21722994744777679000)},
    {_DATAF(0.97603708505630493000),  _DATAF(-0.21760427951812744000)},
    {_DATAF(0.97595357894897461000),  _DATAF(-0.21797856688499451000)},
    {_DATAF(0.97586989402770996000),  _DATAF(-0.21835282444953918000)},
    {_DATAF(0.97578608989715576000),  _DATAF(-0.21872705221176147000)},
    {_DATAF(0.97570210695266724000),  _DATAF(-0.21910123527050018000)},
    {_DATAF(0.97561800479888916000),  _DATAF(-0.21947540342807770000)},
    {_DATAF(0.97553378343582153000),  _DATAF(-0.21984952688217163000)},
    {_DATAF(0.97544938325881958000),  _DATAF(-0.22022362053394318000)},
    {_DATAF(0.97536486387252808000),  _DATAF(-0.22059768438339233000)},
    {_DATAF(0.97528022527694702000),  _DATAF(-0.22097171843051910000)},
    {_DATAF(0.97519540786743164000),  _DATAF(-0.22134572267532349000)},
    {_DATAF(0.97511047124862671000),  _DATAF(-0.22171968221664429000)},
    {_DATAF(0.97502535581588745000),  _DATAF(-0.22209362685680389000)},
    {_DATAF(0.97494012117385864000),  _DATAF(-0.22246752679347992000)},
    {_DATAF(0.97485470771789551000),  _DATAF(-0.22284139692783356000)},
    {_DATAF(0.97476917505264282000),  _DATAF(-0.22321522235870361000)},
    {_DATAF(0.97468352317810059000),  _DATAF(-0.22358903288841248000)},
    {_DATAF(0.97459769248962402000),  _DATAF(-0.22396279871463776000)},
    {_DATAF(0.97451174259185791000),  _DATAF(-0.22433653473854065000)},
    {_DATAF(0.97442561388015747000),  _DATAF(-0.22471024096012115000)},
    {_DATAF(0.97433936595916748000),  _DATAF(-0.22508391737937927000)},
    {_DATAF(0.97425299882888794000),  _DATAF(-0.22545754909515381000)},
    {_DATAF(0.97416645288467407000),  _DATAF(-0.22583115100860596000)},
    {_DATAF(0.97407978773117065000),  _DATAF(-0.22620472311973572000)},
    {_DATAF(0.97399294376373291000),  _DATAF(-0.22657826542854309000)},
    {_DATAF(0.97390598058700562000),  _DATAF(-0.22695176303386688000)},
    {_DATAF(0.97381889820098877000),  _DATAF(-0.22732524573802948000)},
    {_DATAF(0.97373163700103760000),  _DATAF(-0.22769868373870850000)},
    {_DATAF(0.97364425659179688000),  _DATAF(-0.22807207703590393000)},
    {_DATAF(0.97355669736862183000),  _DATAF(-0.22844545543193817000)},
    {_DATAF(0.97346901893615723000),  _DATAF(-0.22881878912448883000)},
    {_DATAF(0.97338122129440308000),  _DATAF(-0.22919209301471710000)},
    {_DATAF(0.97329324483871460000),  _DATAF(-0.22956536710262299000)},
    {_DATAF(0.97320514917373657000),  _DATAF(-0.22993859648704529000)},
    {_DATAF(0.97311687469482422000),  _DATAF(-0.23031181097030640000)},
    {_DATAF(0.97302848100662231000),  _DATAF(-0.23068498075008392000)},
    {_DATAF(0.97293996810913086000),  _DATAF(-0.23105810582637787000)},
    {_DATAF(0.97285127639770508000),  _DATAF(-0.23143121600151062000)},
    {_DATAF(0.97276246547698975000),  _DATAF(-0.23180428147315979000)},
    {_DATAF(0.97267347574234009000),  _DATAF(-0.23217730224132538000)},
    {_DATAF(0.97258436679840088000),  _DATAF(-0.23255030810832977000)},
    {_DATAF(0.97249513864517212000),  _DATAF(-0.23292326927185059000)},
    {_DATAF(0.97240573167800903000),  _DATAF(-0.23329620063304901000)},
    {_DATAF(0.97231620550155640000),  _DATAF(-0.23366910219192505000)},
    {_DATAF(0.97222650051116943000),  _DATAF(-0.23404195904731750000)},
    {_DATAF(0.97213667631149292000),  _DATAF(-0.23441478610038757000)},
    {_DATAF(0.97204673290252686000),  _DATAF(-0.23478758335113525000)},
    {_DATAF(0.97195661067962646000),  _DATAF(-0.23516033589839935000)},
    {_DATAF(0.97186630964279175000),  _DATAF(-0.23553305864334106000)},
    {_DATAF(0.97177594900131226000),  _DATAF(-0.23590575158596039000)},
    {_DATAF(0.97168540954589844000),  _DATAF(-0.23627839982509613000)},
    {_DATAF(0.97159469127655029000),  _DATAF(-0.23665101826190948000)},
    {_DATAF(0.97150391340255737000),  _DATAF(-0.23702360689640045000)},
    {_DATAF(0.97141289710998535000),  _DATAF(-0.23739615082740784000)},
    {_DATAF(0.97132182121276855000),  _DATAF(-0.23776866495609283000)},
    {_DATAF(0.97123056650161743000),  _DATAF(-0.23814114928245544000)},
    {_DATAF(0.97113913297653198000),  _DATAF(-0.23851358890533447000)},
    {_DATAF(0.97104763984680176000),  _DATAF(-0.23888599872589111000)},
    {_DATAF(0.97095590829849243000),  _DATAF(-0.23925837874412537000)},
    {_DATAF(0.97086411714553833000),  _DATAF(-0.23963071405887604000)},
    {_DATAF(0.97077214717864990000),  _DATAF(-0.24000301957130432000)},
    {_DATAF(0.97068005800247192000),  _DATAF(-0.24037529528141022000)},
    {_DATAF(0.97058779001235962000),  _DATAF(-0.24074752628803253000)},
    {_DATAF(0.97049540281295776000),  _DATAF(-0.24111972749233246000)},
    {_DATAF(0.97040283679962158000),  _DATAF(-0.24149188399314880000)},
    {_DATAF(0.97031015157699585000),  _DATAF(-0.24186401069164276000)},
    {_DATAF(0.97021734714508057000),  _DATAF(-0.24223610758781433000)},
    {_DATAF(0.97012436389923096000),  _DATAF(-0.24260815978050232000)},
    {_DATAF(0.97003126144409180000),  _DATAF(-0.24298018217086792000)},
    {_DATAF(0.96993798017501831000),  _DATAF(-0.24335215985774994000)},
    {_DATAF(0.96984457969665527000),  _DATAF(-0.24372410774230957000)},
    {_DATAF(0.96975106000900269000),  _DATAF(-0.24409602582454681000)},
    {_DATAF(0.96965736150741577000),  _DATAF(-0.24446789920330048000)},
    {_DATAF(0.96956354379653931000),  _DATAF(-0.24483974277973175000)},
    {_DATAF(0.96946960687637329000),  _DATAF(-0.24521154165267944000)},
    {_DATAF(0.96937549114227295000),  _DATAF(-0.24558331072330475000)},
    {_DATAF(0.96928125619888306000),  _DATAF(-0.24595504999160767000)},
    {_DATAF(0.96918684244155884000),  _DATAF(-0.24632674455642700000)},
    {_DATAF(0.96909230947494507000),  _DATAF(-0.24669840931892395000)},
    {_DATAF(0.96899759769439697000),  _DATAF(-0.24707002937793732000)},
    {_DATAF(0.96890282630920410000),  _DATAF(-0.24744161963462830000)},
    {_DATAF(0.96880781650543213000),  _DATAF(-0.24781316518783569000)},
    {_DATAF(0.96871274709701538000),  _DATAF(-0.24818468093872070000)},
    {_DATAF(0.96861749887466431000),  _DATAF(-0.24855616688728333000)},
    {_DATAF(0.96852207183837891000),  _DATAF(-0.24892760813236237000)},
    {_DATAF(0.96842658519744873000),  _DATAF(-0.24929900467395782000)},
    {_DATAF(0.96833086013793945000),  _DATAF(-0.24967038631439209000)},
    {_DATAF(0.96823507547378540000),  _DATAF(-0.25004172325134277000)},
    {_DATAF(0.96813911199569702000),  _DATAF(-0.25041300058364868000)},
    {_DATAF(0.96804302930831909000),  _DATAF(-0.25078427791595459000)},
    {_DATAF(0.96794676780700684000),  _DATAF(-0.25115549564361572000)},
    {_DATAF(0.96785038709640503000),  _DATAF(-0.25152668356895447000)},
    {_DATAF(0.96775382757186890000),  _DATAF(-0.25189781188964844000)},
    {_DATAF(0.96765714883804321000),  _DATAF(-0.25226894021034241000)},
    {_DATAF(0.96756035089492798000),  _DATAF(-0.25264000892639160000)},
    {_DATAF(0.96746337413787842000),  _DATAF(-0.25301104784011841000)},
    {_DATAF(0.96736627817153931000),  _DATAF(-0.25338202714920044000)},
    {_DATAF(0.96726906299591064000),  _DATAF(-0.25375300645828247000)},
    {_DATAF(0.96717166900634766000),  _DATAF(-0.25412392616271973000)},
    {_DATAF(0.96707415580749512000),  _DATAF(-0.25449481606483459000)},
    {_DATAF(0.96697646379470825000),  _DATAF(-0.25486564636230469000)},
    {_DATAF(0.96687865257263184000),  _DATAF(-0.25523647665977478000)},
    {_DATAF(0.96678072214126587000),  _DATAF(-0.25560724735260010000)},
    {_DATAF(0.96668261289596558000),  _DATAF(-0.25597798824310303000)},
    {_DATAF(0.96658438444137573000),  _DATAF(-0.25634866952896118000)},
    {_DATAF(0.96648597717285156000),  _DATAF(-0.25671935081481934000)},
    {_DATAF(0.96638745069503784000),  _DATAF(-0.25708997249603271000)},
    {_DATAF(0.96628880500793457000),  _DATAF(-0.25746056437492371000)},
    {_DATAF(0.96618998050689697000),  _DATAF(-0.25783109664916992000)},
    {_DATAF(0.96609103679656982000),  _DATAF(-0.25820159912109375000)},
    {_DATAF(0.96599197387695313000),  _DATAF(-0.25857207179069519000)},
    {_DATAF(0.96589273214340210000),  _DATAF(-0.25894251465797424000)},
    {_DATAF(0.96579337120056152000),  _DATAF(-0.25931292772293091000)},
    {_DATAF(0.96569383144378662000),  _DATAF(-0.25968328118324280000)},
    {_DATAF(0.96559417247772217000),  _DATAF(-0.26005360484123230000)},
    {_DATAF(0.96549439430236816000),  _DATAF(-0.26042386889457703000)},
    {_DATAF(0.96539443731307983000),  _DATAF(-0.26079410314559937000)},
    {_DATAF(0.96529436111450195000),  _DATAF(-0.26116433739662170000)},
    {_DATAF(0.96519410610198975000),  _DATAF(-0.26153448224067688000)},
    {_DATAF(0.96509379148483276000),  _DATAF(-0.26190462708473206000)},
    {_DATAF(0.96499323844909668000),  _DATAF(-0.26227471232414246000)},
    {_DATAF(0.96489262580871582000),  _DATAF(-0.26264476776123047000)},
    {_DATAF(0.96479183435440063000),  _DATAF(-0.26301476359367371000)},
    {_DATAF(0.96469086408615112000),  _DATAF(-0.26338472962379456000)},
    {_DATAF(0.96458977460861206000),  _DATAF(-0.26375466585159302000)},
    {_DATAF(0.96448856592178345000),  _DATAF(-0.26412457227706909000)},
    {_DATAF(0.96438723802566528000),  _DATAF(-0.26449441909790039000)},
    {_DATAF(0.96428573131561279000),  _DATAF(-0.26486423611640930000)},
    {_DATAF(0.96418404579162598000),  _DATAF(-0.26523402333259583000)},
    {_DATAF(0.96408230066299438000),  _DATAF(-0.26560378074645996000)},
    {_DATAF(0.96398037672042847000),  _DATAF(-0.26597347855567932000)},
    {_DATAF(0.96387827396392822000),  _DATAF(-0.26634314656257629000)},
    {_DATAF(0.96377605199813843000),  _DATAF(-0.26671275496482849000)},
    {_DATAF(0.96367371082305908000),  _DATAF(-0.26708233356475830000)},
    {_DATAF(0.96357119083404541000),  _DATAF(-0.26745188236236572000)},
    {_DATAF(0.96346855163574219000),  _DATAF(-0.26782140135765076000)},
    {_DATAF(0.96336579322814941000),  _DATAF(-0.26819086074829102000)},
    {_DATAF(0.96326285600662231000),  _DATAF(-0.26856029033660889000)},
    {_DATAF(0.96315979957580566000),  _DATAF(-0.26892966032028198000)},
    {_DATAF(0.96305662393569946000),  _DATAF(-0.26929903030395508000)},
    {_DATAF(0.96295326948165894000),  _DATAF(-0.26966831088066101000)},
    {_DATAF(0.96284979581832886000),  _DATAF(-0.27003759145736694000)},
    {_DATAF(0.96274614334106445000),  _DATAF(-0.27040681242942810000)},
    {_DATAF(0.96264237165451050000),  _DATAF(-0.27077600359916687000)},
    {_DATAF(0.96253848075866699000),  _DATAF(-0.27114516496658325000)},
    {_DATAF(0.96243441104888916000),  _DATAF(-0.27151426672935486000)},
    {_DATAF(0.96233022212982178000),  _DATAF(-0.27188333868980408000)},
    {_DATAF(0.96222585439682007000),  _DATAF(-0.27225238084793091000)},
    {_DATAF(0.96212142705917358000),  _DATAF(-0.27262136340141296000)},
    {_DATAF(0.96201676130294800000),  _DATAF(-0.27299031615257263000)},
    {_DATAF(0.96191203594207764000),  _DATAF(-0.27335920929908752000)},
    {_DATAF(0.96180713176727295000),  _DATAF(-0.27372807264328003000)},
    {_DATAF(0.96170204877853394000),  _DATAF(-0.27409690618515015000)},
    {_DATAF(0.96159690618515015000),  _DATAF(-0.27446570992469788000)},
    {_DATAF(0.96149158477783203000),  _DATAF(-0.27483445405960083000)},
    {_DATAF(0.96138608455657959000),  _DATAF(-0.27520313858985901000)},
    {_DATAF(0.96128046512603760000),  _DATAF(-0.27557182312011719000)},
    {_DATAF(0.96117472648620605000),  _DATAF(-0.27594044804573059000)},
    {_DATAF(0.96106886863708496000),  _DATAF(-0.27630904316902161000)},
    {_DATAF(0.96096283197402954000),  _DATAF(-0.27667757868766785000)},
    {_DATAF(0.96085661649703979000),  _DATAF(-0.27704608440399170000)},
    {_DATAF(0.96075034141540527000),  _DATAF(-0.27741453051567078000)},
    {_DATAF(0.96064388751983643000),  _DATAF(-0.27778297662734985000)},
    {_DATAF(0.96053725481033325000),  _DATAF(-0.27815136313438416000)},
    {_DATAF(0.96043050289154053000),  _DATAF(-0.27851969003677368000)},
    {_DATAF(0.96032363176345825000),  _DATAF(-0.27888798713684082000)},
    {_DATAF(0.96021664142608643000),  _DATAF(-0.27925625443458557000)},
    {_DATAF(0.96010947227478027000),  _DATAF(-0.27962446212768555000)},
    {_DATAF(0.96000212430953979000),  _DATAF(-0.27999264001846313000)},
    {_DATAF(0.95989471673965454000),  _DATAF(-0.28036078810691833000)},
    {_DATAF(0.95978713035583496000),  _DATAF(-0.28072887659072876000)},
    {_DATAF(0.95967936515808105000),  _DATAF(-0.28109693527221680000)},
    {_DATAF(0.95957154035568237000),  _DATAF(-0.28146493434906006000)},
    {_DATAF(0.95946347713470459000),  _DATAF(-0.28183290362358093000)},
    {_DATAF(0.95935535430908203000),  _DATAF(-0.28220084309577942000)},
    {_DATAF(0.95924705266952515000),  _DATAF(-0.28256872296333313000)},
    {_DATAF(0.95913863182067871000),  _DATAF(-0.28293657302856445000)},
    {_DATAF(0.95903003215789795000),  _DATAF(-0.28330436348915100000)},
    {_DATAF(0.95892131328582764000),  _DATAF(-0.28367212414741516000)},
    {_DATAF(0.95881247520446777000),  _DATAF(-0.28403985500335693000)},
    {_DATAF(0.95870345830917358000),  _DATAF(-0.28440752625465393000)},
    {_DATAF(0.95859432220458984000),  _DATAF(-0.28477516770362854000)},
    {_DATAF(0.95848506689071655000),  _DATAF(-0.28514277935028076000)},
    {_DATAF(0.95837563276290894000),  _DATAF(-0.28551033139228821000)},
    {_DATAF(0.95826607942581177000),  _DATAF(-0.28587782382965088000)},
    {_DATAF(0.95815634727478027000),  _DATAF(-0.28624531626701355000)},
    {_DATAF(0.95804649591445923000),  _DATAF(-0.28661271929740906000)},
    {_DATAF(0.95793652534484863000),  _DATAF(-0.28698012232780457000)},
    {_DATAF(0.95782643556594849000),  _DATAF(-0.28734746575355530000)},
    {_DATAF(0.95771616697311401000),  _DATAF(-0.28771474957466125000)},
    {_DATAF(0.95760571956634521000),  _DATAF(-0.28808203339576721000)},
    {_DATAF(0.95749521255493164000),  _DATAF(-0.28844922780990601000)},
    {_DATAF(0.95738452672958374000),  _DATAF(-0.28881642222404480000)},
    {_DATAF(0.95727366209030151000),  _DATAF(-0.28918352723121643000)},
    {_DATAF(0.95716267824172974000),  _DATAF(-0.28955063223838806000)},
    {_DATAF(0.95705157518386841000),  _DATAF(-0.28991767764091492000)},
    {_DATAF(0.95694035291671753000),  _DATAF(-0.29028466343879700000)},
    {_DATAF(0.95682895183563232000),  _DATAF(-0.29065164923667908000)},
    {_DATAF(0.95671743154525757000),  _DATAF(-0.29101854562759399000)},
    {_DATAF(0.95660573244094849000),  _DATAF(-0.29138544201850891000)},
    {_DATAF(0.95649391412734985000),  _DATAF(-0.29175224900245667000)},
    {_DATAF(0.95638197660446167000),  _DATAF(-0.29211905598640442000)},
    {_DATAF(0.95626986026763916000),  _DATAF(-0.29248580336570740000)},
    {_DATAF(0.95615762472152710000),  _DATAF(-0.29285249114036560000)},
    {_DATAF(0.95604526996612549000),  _DATAF(-0.29321914911270142000)},
    {_DATAF(0.95593273639678955000),  _DATAF(-0.29358577728271484000)},
    {_DATAF(0.95582008361816406000),  _DATAF(-0.29395234584808350000)},
    {_DATAF(0.95570725202560425000),  _DATAF(-0.29431888461112976000)},
    {_DATAF(0.95559436082839966000),  _DATAF(-0.29468536376953125000)},
    {_DATAF(0.95548123121261597000),  _DATAF(-0.29505181312561035000)},
    {_DATAF(0.95536804199218750000),  _DATAF(-0.29541820287704468000)},
    {_DATAF(0.95525467395782471000),  _DATAF(-0.29578456282615662000)},
    {_DATAF(0.95514118671417236000),  _DATAF(-0.29615089297294617000)},
    {_DATAF(0.95502752065658569000),  _DATAF(-0.29651716351509094000)},
    {_DATAF(0.95491373538970947000),  _DATAF(-0.29688337445259094000)},
    {_DATAF(0.95479983091354370000),  _DATAF(-0.29724955558776855000)},
    {_DATAF(0.95468574762344360000),  _DATAF(-0.29761570692062378000)},
    {_DATAF(0.95457154512405396000),  _DATAF(-0.29798179864883423000)},
    {_DATAF(0.95445722341537476000),  _DATAF(-0.29834786057472229000)},
    {_DATAF(0.95434272289276123000),  _DATAF(-0.29871386289596558000)},
    {_DATAF(0.95422810316085815000),  _DATAF(-0.29907983541488647000)},
    {_DATAF(0.95411330461502075000),  _DATAF(-0.29944574832916260000)},
    {_DATAF(0.95399844646453857000),  _DATAF(-0.29981163144111633000)},
    {_DATAF(0.95388334989547729000),  _DATAF(-0.30017745494842529000)},
    {_DATAF(0.95376819372177124000),  _DATAF(-0.30054324865341187000)},
    {_DATAF(0.95365285873413086000),  _DATAF(-0.30090898275375366000)},
    {_DATAF(0.95353740453720093000),  _DATAF(-0.30127468705177307000)},
    {_DATAF(0.95342177152633667000),  _DATAF(-0.30164033174514771000)},
    {_DATAF(0.95330601930618286000),  _DATAF(-0.30200594663619995000)},
    {_DATAF(0.95319014787673950000),  _DATAF(-0.30237150192260742000)},
    {_DATAF(0.95307409763336182000),  _DATAF(-0.30273702740669250000)},
    {_DATAF(0.95295792818069458000),  _DATAF(-0.30310252308845520000)},
    {_DATAF(0.95284163951873779000),  _DATAF(-0.30346795916557312000)},
    {_DATAF(0.95272517204284668000),  _DATAF(-0.30383333563804626000)},
    {_DATAF(0.95260858535766602000),  _DATAF(-0.30419868230819702000)},
    {_DATAF(0.95249187946319580000),  _DATAF(-0.30456396937370300000)},
    {_DATAF(0.95237499475479126000),  _DATAF(-0.30492922663688660000)},
    {_DATAF(0.95225799083709717000),  _DATAF(-0.30529442429542542000)},
    {_DATAF(0.95214086771011353000),  _DATAF(-0.30565959215164185000)},
    {_DATAF(0.95202356576919556000),  _DATAF(-0.30602473020553589000)},
    {_DATAF(0.95190614461898804000),  _DATAF(-0.30638980865478516000)},
    {_DATAF(0.95178854465484619000),  _DATAF(-0.30675482749938965000)},
    {_DATAF(0.95167088508605957000),  _DATAF(-0.30711981654167175000)},
    {_DATAF(0.95155298709869385000),  _DATAF(-0.30748474597930908000)},
    {_DATAF(0.95143502950668335000),  _DATAF(-0.30784964561462402000)},
    {_DATAF(0.95131689310073853000),  _DATAF(-0.30821448564529419000)},
    {_DATAF(0.95119863748550415000),  _DATAF(-0.30857929587364197000)},
    {_DATAF(0.95108020305633545000),  _DATAF(-0.30894404649734497000)},
    {_DATAF(0.95096164941787720000),  _DATAF(-0.30930876731872559000)},
    {_DATAF(0.95084297657012939000),  _DATAF(-0.30967342853546143000)},
    {_DATAF(0.95072412490844727000),  _DATAF(-0.31003805994987488000)},
    {_DATAF(0.95060515403747559000),  _DATAF(-0.31040263175964355000)},
    {_DATAF(0.95048606395721436000),  _DATAF(-0.31076714396476746000)},
    {_DATAF(0.95036685466766357000),  _DATAF(-0.31113162636756897000)},
    {_DATAF(0.95024746656417847000),  _DATAF(-0.31149607896804810000)},
    {_DATAF(0.95012789964675903000),  _DATAF(-0.31186047196388245000)},
    {_DATAF(0.95000827312469482000),  _DATAF(-0.31222480535507202000)},
    {_DATAF(0.94988846778869629000),  _DATAF(-0.31258910894393921000)},
    {_DATAF(0.94976848363876343000),  _DATAF(-0.31295338273048401000)},
    {_DATAF(0.94964838027954102000),  _DATAF(-0.31331756711006165000)},
    {_DATAF(0.94952815771102905000),  _DATAF(-0.31368175148963928000)},
    {_DATAF(0.94940781593322754000),  _DATAF(-0.31404584646224976000)},
    {_DATAF(0.94928729534149170000),  _DATAF(-0.31440994143486023000)},
    {_DATAF(0.94916665554046631000),  _DATAF(-0.31477394700050354000)},
    {_DATAF(0.94904589653015137000),  _DATAF(-0.31513792276382446000)},
    {_DATAF(0.94892495870590210000),  _DATAF(-0.31550186872482300000)},
    {_DATAF(0.94880390167236328000),  _DATAF(-0.31586575508117676000)},
    {_DATAF(0.94868266582489014000),  _DATAF(-0.31622958183288574000)},
    {_DATAF(0.94856137037277222000),  _DATAF(-0.31659337878227234000)},
    {_DATAF(0.94843989610671997000),  _DATAF(-0.31695711612701416000)},
    {_DATAF(0.94831824302673340000),  _DATAF(-0.31732082366943359000)},
    {_DATAF(0.94819647073745728000),  _DATAF(-0.31768447160720825000)},
    {_DATAF(0.94807457923889160000),  _DATAF(-0.31804808974266052000)},
    {_DATAF(0.94795256853103638000),  _DATAF(-0.31841164827346802000)},
    {_DATAF(0.94783037900924683000),  _DATAF(-0.31877514719963074000)},
    {_DATAF(0.94770807027816772000),  _DATAF(-0.31913861632347107000)},
    {_DATAF(0.94758558273315430000),  _DATAF(-0.31950202584266663000)},
    {_DATAF(0.94746297597885132000),  _DATAF(-0.31986540555953979000)},
    {_DATAF(0.94734025001525879000),  _DATAF(-0.32022872567176819000)},
    {_DATAF(0.94721740484237671000),  _DATAF(-0.32059201598167419000)},
    {_DATAF(0.94709438085556030000),  _DATAF(-0.32095524668693542000)},
    {_DATAF(0.94697123765945435000),  _DATAF(-0.32131841778755188000)},
    {_DATAF(0.94684791564941406000),  _DATAF(-0.32168155908584595000)},
    {_DATAF(0.94672447443008423000),  _DATAF(-0.32204464077949524000)},
    {_DATAF(0.94660091400146484000),  _DATAF(-0.32240769267082214000)},
    {_DATAF(0.94647717475891113000),  _DATAF(-0.32277068495750427000)},
    {_DATAF(0.94635337591171265000),  _DATAF(-0.32313361763954163000)},
    {_DATAF(0.94622933864593506000),  _DATAF(-0.32349652051925659000)},
    {_DATAF(0.94610524177551270000),  _DATAF(-0.32385936379432678000)},
    {_DATAF(0.94598096609115601000),  _DATAF(-0.32422217726707458000)},
    {_DATAF(0.94585657119750977000),  _DATAF(-0.32458493113517761000)},
    {_DATAF(0.94573199748992920000),  _DATAF(-0.32494762539863586000)},
    {_DATAF(0.94560730457305908000),  _DATAF(-0.32531028985977173000)},
    {_DATAF(0.94548249244689941000),  _DATAF(-0.32567289471626282000)},
    {_DATAF(0.94535756111145020000),  _DATAF(-0.32603546977043152000)},
    {_DATAF(0.94523245096206665000),  _DATAF(-0.32639798521995544000)},
    {_DATAF(0.94510722160339355000),  _DATAF(-0.32676044106483459000)},
    {_DATAF(0.94498181343078613000),  _DATAF(-0.32712286710739136000)},
    {_DATAF(0.94485628604888916000),  _DATAF(-0.32748523354530334000)},
    {_DATAF(0.94473063945770264000),  _DATAF(-0.32784757018089294000)},
    {_DATAF(0.94460481405258179000),  _DATAF(-0.32820984721183777000)},
    {_DATAF(0.94447892904281616000),  _DATAF(-0.32857206463813782000)},
    {_DATAF(0.94435280561447144000),  _DATAF(-0.32893425226211548000)},
    {_DATAF(0.94422662258148193000),  _DATAF(-0.32929638028144836000)},
    {_DATAF(0.94410026073455811000),  _DATAF(-0.32965844869613647000)},
    {_DATAF(0.94397377967834473000),  _DATAF(-0.33002048730850220000)},
    {_DATAF(0.94384711980819702000),  _DATAF(-0.33038249611854553000)},
    {_DATAF(0.94372034072875977000),  _DATAF(-0.33074441552162170000)},
    {_DATAF(0.94359344244003296000),  _DATAF(-0.33110630512237549000)},
    {_DATAF(0.94346642494201660000),  _DATAF(-0.33146813511848450000)},
    {_DATAF(0.94333922863006592000),  _DATAF(-0.33182993531227112000)},
    {_DATAF(0.94321191310882568000),  _DATAF(-0.33219167590141296000)},
    {_DATAF(0.94308441877365112000),  _DATAF(-0.33255335688591003000)},
    {_DATAF(0.94295686483383179000),  _DATAF(-0.33291500806808472000)},
    {_DATAF(0.94282907247543335000),  _DATAF(-0.33327659964561462000)},
    {_DATAF(0.94270122051239014000),  _DATAF(-0.33363816142082214000)},
    {_DATAF(0.94257318973541260000),  _DATAF(-0.33399966359138489000)},
    {_DATAF(0.94244503974914551000),  _DATAF(-0.33436110615730286000)},
    {_DATAF(0.94231677055358887000),  _DATAF(-0.33472248911857605000)},
    {_DATAF(0.94218832254409790000),  _DATAF(-0.33508384227752686000)},
    {_DATAF(0.94205975532531738000),  _DATAF(-0.33544513583183289000)},
    {_DATAF(0.94193100929260254000),  _DATAF(-0.33580639958381653000)},
    {_DATAF(0.94180220365524292000),  _DATAF(-0.33616760373115540000)},
    {_DATAF(0.94167321920394897000),  _DATAF(-0.33652874827384949000)},
    {_DATAF(0.94154405593872070000),  _DATAF(-0.33688986301422119000)},
    {_DATAF(0.94141477346420288000),  _DATAF(-0.33725091814994812000)},
    {_DATAF(0.94128537178039551000),  _DATAF(-0.33761191368103027000)},
    {_DATAF(0.94115585088729858000),  _DATAF(-0.33797284960746765000)},
    {_DATAF(0.94102615118026733000),  _DATAF(-0.33833375573158264000)},
    {_DATAF(0.94089633226394653000),  _DATAF(-0.33869463205337524000)},
    {_DATAF(0.94076639413833618000),  _DATAF(-0.33905541896820068000)},
    {_DATAF(0.94063627719879150000),  _DATAF(-0.33941617608070374000)},
    {_DATAF(0.94050604104995728000),  _DATAF(-0.33977687358856201000)},
    {_DATAF(0.94037568569183350000),  _DATAF(-0.34013754129409790000)},
    {_DATAF(0.94024521112442017000),  _DATAF(-0.34049814939498901000)},
    {_DATAF(0.94011455774307251000),  _DATAF(-0.34085869789123535000)},
    {_DATAF(0.93998372554779053000),  _DATAF(-0.34121921658515930000)},
    {_DATAF(0.93985283374786377000),  _DATAF(-0.34157964587211609000)},
    {_DATAF(0.93972176313400269000),  _DATAF(-0.34194007515907288000)},
    {_DATAF(0.93959057331085205000),  _DATAF(-0.34230041503906250000)},
    {_DATAF(0.93945920467376709000),  _DATAF(-0.34266072511672974000)},
    {_DATAF(0.93932771682739258000),  _DATAF(-0.34302097558975220000)},
    {_DATAF(0.93919610977172852000),  _DATAF(-0.34338116645812988000)},
    {_DATAF(0.93906438350677490000),  _DATAF(-0.34374132752418518000)},
    {_DATAF(0.93893247842788696000),  _DATAF(-0.34410142898559570000)},
    {_DATAF(0.93880045413970947000),  _DATAF(-0.34446147084236145000)},
    {_DATAF(0.93866831064224243000),  _DATAF(-0.34482148289680481000)},
    {_DATAF(0.93853598833084106000),  _DATAF(-0.34518143534660339000)},
    {_DATAF(0.93840354681015015000),  _DATAF(-0.34554132819175720000)},
    {_DATAF(0.93827092647552490000),  _DATAF(-0.34590116143226624000)},
    {_DATAF(0.93813824653625488000),  _DATAF(-0.34626096487045288000)},
    {_DATAF(0.93800538778305054000),  _DATAF(-0.34662070870399475000)},
    {_DATAF(0.93787235021591187000),  _DATAF(-0.34698042273521423000)},
    {_DATAF(0.93773925304412842000),  _DATAF(-0.34734004735946655000)},
    {_DATAF(0.93760597705841064000),  _DATAF(-0.34769964218139648000)},
    {_DATAF(0.93747258186340332000),  _DATAF(-0.34805917739868164000)},
    {_DATAF(0.93733900785446167000),  _DATAF(-0.34841868281364441000)},
    {_DATAF(0.93720531463623047000),  _DATAF(-0.34877812862396240000)},
    {_DATAF(0.93707150220870972000),  _DATAF(-0.34913751482963562000)},
    {_DATAF(0.93693757057189941000),  _DATAF(-0.34949684143066406000)},
    {_DATAF(0.93680346012115479000),  _DATAF(-0.34985613822937012000)},
    {_DATAF(0.93666923046112061000),  _DATAF(-0.35021537542343140000)},
    {_DATAF(0.93653482198715210000),  _DATAF(-0.35057455301284790000)},
    {_DATAF(0.93640029430389404000),  _DATAF(-0.35093367099761963000)},
    {_DATAF(0.93626564741134644000),  _DATAF(-0.35129275918006897000)},
    {_DATAF(0.93613088130950928000),  _DATAF(-0.35165178775787354000)},
    {_DATAF(0.93599593639373779000),  _DATAF(-0.35201075673103333000)},
    {_DATAF(0.93586087226867676000),  _DATAF(-0.35236969590187073000)},
    {_DATAF(0.93572568893432617000),  _DATAF(-0.35272854566574097000)},
    {_DATAF(0.93559032678604126000),  _DATAF(-0.35308736562728882000)},
    {_DATAF(0.93545484542846680000),  _DATAF(-0.35344615578651428000)},
    {_DATAF(0.93531924486160278000),  _DATAF(-0.35380485653877258000)},
    {_DATAF(0.93518352508544922000),  _DATAF(-0.35416352748870850000)},
    {_DATAF(0.93504762649536133000),  _DATAF(-0.35452213883399963000)},
    {_DATAF(0.93491160869598389000),  _DATAF(-0.35488069057464600000)},
    {_DATAF(0.93477541208267212000),  _DATAF(-0.35523921251296997000)},
    {_DATAF(0.93463915586471558000),  _DATAF(-0.35559767484664917000)},
    {_DATAF(0.93450272083282471000),  _DATAF(-0.35595607757568359000)},
    {_DATAF(0.93436610698699951000),  _DATAF(-0.35631442070007324000)},
    {_DATAF(0.93422937393188477000),  _DATAF(-0.35667270421981812000)},
    {_DATAF(0.93409252166748047000),  _DATAF(-0.35703095793724060000)},
    {_DATAF(0.93395555019378662000),  _DATAF(-0.35738915205001831000)},
    {_DATAF(0.93381845951080322000),  _DATAF(-0.35774728655815125000)},
    {_DATAF(0.93368119001388550000),  _DATAF(-0.35810539126396179000)},
    {_DATAF(0.93354380130767822000),  _DATAF(-0.35846340656280518000)},
    {_DATAF(0.93340623378753662000),  _DATAF(-0.35882139205932617000)},
    {_DATAF(0.93326854705810547000),  _DATAF(-0.35917934775352478000)},
    {_DATAF(0.93313074111938477000),  _DATAF(-0.35953721404075623000)},
    {_DATAF(0.93299281597137451000),  _DATAF(-0.35989505052566528000)},
    {_DATAF(0.93285471200942993000),  _DATAF(-0.36025279760360718000)},
    {_DATAF(0.93271648883819580000),  _DATAF(-0.36061051487922668000)},
    {_DATAF(0.93257814645767212000),  _DATAF(-0.36096820235252380000)},
    {_DATAF(0.93243962526321411000),  _DATAF(-0.36132580041885376000)},
    {_DATAF(0.93230098485946655000),  _DATAF(-0.36168336868286133000)},
    {_DATAF(0.93216222524642944000),  _DATAF(-0.36204087734222412000)},
    {_DATAF(0.93202328681945801000),  _DATAF(-0.36239832639694214000)},
    {_DATAF(0.93188428878784180000),  _DATAF(-0.36275571584701538000)},
    {_DATAF(0.93174505233764648000),  _DATAF(-0.36311307549476624000)},
    {_DATAF(0.93160575628280640000),  _DATAF(-0.36347037553787231000)},
    {_DATAF(0.93146628141403198000),  _DATAF(-0.36382761597633362000)},
    {_DATAF(0.93132668733596802000),  _DATAF(-0.36418479681015015000)},
    {_DATAF(0.93118697404861450000),  _DATAF(-0.36454191803932190000)},
    {_DATAF(0.93104708194732666000),  _DATAF(-0.36489900946617126000)},
    {_DATAF(0.93090713024139404000),  _DATAF(-0.36525601148605347000)},
    {_DATAF(0.93076694011688232000),  _DATAF(-0.36561298370361328000)},
    {_DATAF(0.93062669038772583000),  _DATAF(-0.36596992611885071000)},
    {_DATAF(0.93048626184463501000),  _DATAF(-0.36632677912712097000)},
    {_DATAF(0.93034571409225464000),  _DATAF(-0.36668360233306885000)},
    {_DATAF(0.93020504713058472000),  _DATAF(-0.36704033613204956000)},
    {_DATAF(0.93006420135498047000),  _DATAF(-0.36739704012870789000)},
    {_DATAF(0.92992323637008667000),  _DATAF(-0.36775368452072144000)},
    {_DATAF(0.92978215217590332000),  _DATAF(-0.36811029911041260000)},
    {_DATAF(0.92964088916778564000),  _DATAF(-0.36846682429313660000)},
    {_DATAF(0.92949950695037842000),  _DATAF(-0.36882331967353821000)},
    {_DATAF(0.92935800552368164000),  _DATAF(-0.36917975544929504000)},
    {_DATAF(0.92921638488769531000),  _DATAF(-0.36953613162040710000)},
    {_DATAF(0.92907458543777466000),  _DATAF(-0.36989244818687439000)},
    {_DATAF(0.92893266677856445000),  _DATAF(-0.37024870514869690000)},
    {_DATAF(0.92879062891006470000),  _DATAF(-0.37060493230819702000)},
    {_DATAF(0.92864841222763062000),  _DATAF(-0.37096109986305237000)},
    {_DATAF(0.92850607633590698000),  _DATAF(-0.37131720781326294000)},
    {_DATAF(0.92836362123489380000),  _DATAF(-0.37167325615882874000)},
    {_DATAF(0.92822098731994629000),  _DATAF(-0.37202924489974976000)},
    {_DATAF(0.92807829380035400000),  _DATAF(-0.37238517403602600000)},
    {_DATAF(0.92793542146682739000),  _DATAF(-0.37274107336997986000)},
    {_DATAF(0.92779237031936646000),  _DATAF(-0.37309691309928894000)},
    {_DATAF(0.92764925956726074000),  _DATAF(-0.37345266342163086000)},
    {_DATAF(0.92750597000122070000),  _DATAF(-0.37380838394165039000)},
    {_DATAF(0.92736250162124634000),  _DATAF(-0.37416407465934753000)},
    {_DATAF(0.92721897363662720000),  _DATAF(-0.37451967597007751000)},
    {_DATAF(0.92707526683807373000),  _DATAF(-0.37487521767616272000)},
    {_DATAF(0.92693144083023071000),  _DATAF(-0.37523072957992554000)},
    {_DATAF(0.92678749561309814000),  _DATAF(-0.37558618187904358000)},
    {_DATAF(0.92664337158203125000),  _DATAF(-0.37594157457351685000)},
    {_DATAF(0.92649912834167480000),  _DATAF(-0.37629690766334534000)},
    {_DATAF(0.92635476589202881000),  _DATAF(-0.37665218114852905000)},
    {_DATAF(0.92621022462844849000),  _DATAF(-0.37700742483139038000)},
    {_DATAF(0.92606556415557861000),  _DATAF(-0.37736257910728455000)},
    {_DATAF(0.92592078447341919000),  _DATAF(-0.37771770358085632000)},
    {_DATAF(0.92577588558197021000),  _DATAF(-0.37807273864746094000)},
    {_DATAF(0.92563080787658691000),  _DATAF(-0.37842774391174316000)},
    {_DATAF(0.92548561096191406000),  _DATAF(-0.37878268957138062000)},
    {_DATAF(0.92534029483795166000),  _DATAF(-0.37913760542869568000)},
    {_DATAF(0.92519485950469971000),  _DATAF(-0.37949243187904358000)},
    {_DATAF(0.92504924535751343000),  _DATAF(-0.37984719872474670000)},
    {_DATAF(0.92490351200103760000),  _DATAF(-0.38020193576812744000)},
    {_DATAF(0.92475759983062744000),  _DATAF(-0.38055661320686340000)},
    {_DATAF(0.92461162805557251000),  _DATAF(-0.38091120123863220000)},
    {_DATAF(0.92446547746658325000),  _DATAF(-0.38126575946807861000)},
    {_DATAF(0.92431920766830444000),  _DATAF(-0.38162025809288025000)},
    {_DATAF(0.92417275905609131000),  _DATAF(-0.38197472691535950000)},
    {_DATAF(0.92402625083923340000),  _DATAF(-0.38232910633087158000)},
    {_DATAF(0.92387950420379639000),  _DATAF(-0.38268342614173889000)},
    {_DATAF(0.92373269796371460000),  _DATAF(-0.38303771615028381000)},
    {_DATAF(0.92358577251434326000),  _DATAF(-0.38339191675186157000)},
    {_DATAF(0.92343866825103760000),  _DATAF(-0.38374608755111694000)},
    {_DATAF(0.92329144477844238000),  _DATAF(-0.38410019874572754000)},
    {_DATAF(0.92314404249191284000),  _DATAF(-0.38445425033569336000)},
    {_DATAF(0.92299652099609375000),  _DATAF(-0.38480824232101440000)},
    {_DATAF(0.92284888029098511000),  _DATAF(-0.38516217470169067000)},
    {_DATAF(0.92270112037658691000),  _DATAF(-0.38551604747772217000)},
    {_DATAF(0.92255324125289917000),  _DATAF(-0.38586989045143127000)},
    {_DATAF(0.92240518331527710000),  _DATAF(-0.38622364401817322000)},
    {_DATAF(0.92225700616836548000),  _DATAF(-0.38657733798027039000)},
    {_DATAF(0.92210865020751953000),  _DATAF(-0.38693100214004517000)},
    {_DATAF(0.92196023464202881000),  _DATAF(-0.38728460669517517000)},
    {_DATAF(0.92181164026260376000),  _DATAF(-0.38763815164566040000)},
    {_DATAF(0.92166292667388916000),  _DATAF(-0.38799160718917847000)},
    {_DATAF(0.92151403427124023000),  _DATAF(-0.38834503293037415000)},
    {_DATAF(0.92136502265930176000),  _DATAF(-0.38869842886924744000)},
    {_DATAF(0.92121589183807373000),  _DATAF(-0.38905173540115356000)},
    {_DATAF(0.92106664180755615000),  _DATAF(-0.38940498232841492000)},
    {_DATAF(0.92091721296310425000),  _DATAF(-0.38975816965103149000)},
    {_DATAF(0.92076772451400757000),  _DATAF(-0.39011132717132568000)},
    {_DATAF(0.92061805725097656000),  _DATAF(-0.39046439528465271000)},
    {_DATAF(0.92046821117401123000),  _DATAF(-0.39081740379333496000)},
    {_DATAF(0.92031830549240112000),  _DATAF(-0.39117038249969482000)},
    {_DATAF(0.92016822099685669000),  _DATAF(-0.39152330160140991000)},
    {_DATAF(0.92001795768737793000),  _DATAF(-0.39187613129615784000)},
    {_DATAF(0.91986763477325439000),  _DATAF(-0.39222893118858337000)},
    {_DATAF(0.91971713304519653000),  _DATAF(-0.39258167147636414000)},
    {_DATAF(0.91956651210784912000),  _DATAF(-0.39293435215950012000)},
    {_DATAF(0.91941577196121216000),  _DATAF(-0.39328697323799133000)},
    {_DATAF(0.91926485300064087000),  _DATAF(-0.39363953471183777000)},
    {_DATAF(0.91911387443542480000),  _DATAF(-0.39399203658103943000)},
    {_DATAF(0.91896271705627441000),  _DATAF(-0.39434447884559631000)},
    {_DATAF(0.91881138086318970000),  _DATAF(-0.39469686150550842000)},
    {_DATAF(0.91865998506546021000),  _DATAF(-0.39504921436309814000)},
    {_DATAF(0.91850841045379639000),  _DATAF(-0.39540147781372070000)},
    {_DATAF(0.91835671663284302000),  _DATAF(-0.39575368165969849000)},
    {_DATAF(0.91820484399795532000),  _DATAF(-0.39610585570335388000)},
    {_DATAF(0.91805291175842285000),  _DATAF(-0.39645794034004211000)},
    {_DATAF(0.91790080070495605000),  _DATAF(-0.39680999517440796000)},
    {_DATAF(0.91774851083755493000),  _DATAF(-0.39716196060180664000)},
    {_DATAF(0.91759616136550903000),  _DATAF(-0.39751389622688293000)},
    {_DATAF(0.91744363307952881000),  _DATAF(-0.39786574244499207000)},
    {_DATAF(0.91729098558425903000),  _DATAF(-0.39821755886077881000)},
    {_DATAF(0.91713821887969971000),  _DATAF(-0.39856931567192078000)},
    {_DATAF(0.91698527336120605000),  _DATAF(-0.39892101287841797000)},
    {_DATAF(0.91683226823806763000),  _DATAF(-0.39927262067794800000)},
    {_DATAF(0.91667908430099487000),  _DATAF(-0.39962419867515564000)},
    {_DATAF(0.91652572154998779000),  _DATAF(-0.39997571706771851000)},
    {_DATAF(0.91637229919433594000),  _DATAF(-0.40032717585563660000)},
    {_DATAF(0.91621869802474976000),  _DATAF(-0.40067857503890991000)},
    {_DATAF(0.91606497764587402000),  _DATAF(-0.40102988481521606000)},
    {_DATAF(0.91591107845306396000),  _DATAF(-0.40138116478919983000)},
    {_DATAF(0.91575711965560913000),  _DATAF(-0.40173238515853882000)},
    {_DATAF(0.91560298204421997000),  _DATAF(-0.40208354592323303000)},
    {_DATAF(0.91544872522354126000),  _DATAF(-0.40243464708328247000)},
    {_DATAF(0.91529428958892822000),  _DATAF(-0.40278568863868713000)},
    {_DATAF(0.91513979434967041000),  _DATAF(-0.40313667058944702000)},
    {_DATAF(0.91498512029647827000),  _DATAF(-0.40348759293556213000)},
    {_DATAF(0.91483032703399658000),  _DATAF(-0.40383845567703247000)},
    {_DATAF(0.91467535495758057000),  _DATAF(-0.40418925881385803000)},
    {_DATAF(0.91452032327651978000),  _DATAF(-0.40454000234603882000)},
    {_DATAF(0.91436511278152466000),  _DATAF(-0.40489068627357483000)},
    {_DATAF(0.91420978307723999000),  _DATAF(-0.40524131059646606000)},
    {_DATAF(0.91405427455902100000),  _DATAF(-0.40559187531471252000)},
    {_DATAF(0.91389864683151245000),  _DATAF(-0.40594238042831421000)},
    {_DATAF(0.91374289989471436000),  _DATAF(-0.40629282593727112000)},
    {_DATAF(0.91358703374862671000),  _DATAF(-0.40664321184158325000)},
    {_DATAF(0.91343104839324951000),  _DATAF(-0.40699353814125061000)},
    {_DATAF(0.91327488422393799000),  _DATAF(-0.40734380483627319000)},
    {_DATAF(0.91311860084533691000),  _DATAF(-0.40769401192665100000)},
    {_DATAF(0.91296219825744629000),  _DATAF(-0.40804415941238403000)},
    {_DATAF(0.91280561685562134000),  _DATAF(-0.40839424729347229000)},
    {_DATAF(0.91264897584915161000),  _DATAF(-0.40874427556991577000)},
    {_DATAF(0.91249215602874756000),  _DATAF(-0.40909424424171448000)},
    {_DATAF(0.91233515739440918000),  _DATAF(-0.40944415330886841000)},
    {_DATAF(0.91217809915542603000),  _DATAF(-0.40979400277137756000)},
    {_DATAF(0.91202086210250854000),  _DATAF(-0.41014379262924194000)},
    {_DATAF(0.91186350584030151000),  _DATAF(-0.41049349308013916000)},
    {_DATAF(0.91170603036880493000),  _DATAF(-0.41084316372871399000)},
    {_DATAF(0.91154843568801880000),  _DATAF(-0.41119277477264404000)},
    {_DATAF(0.91139066219329834000),  _DATAF(-0.41154232621192932000)},
    {_DATAF(0.91123276948928833000),  _DATAF(-0.41189181804656982000)},
    {_DATAF(0.91107475757598877000),  _DATAF(-0.41224122047424316000)},
    {_DATAF(0.91091656684875488000),  _DATAF(-0.41259059309959412000)},
    {_DATAF(0.91075825691223145000),  _DATAF(-0.41293987631797791000)},
    {_DATAF(0.91059982776641846000),  _DATAF(-0.41328912973403931000)},
    {_DATAF(0.91044127941131592000),  _DATAF(-0.41363832354545593000)},
    {_DATAF(0.91028261184692383000),  _DATAF(-0.41398742794990540000)},
    {_DATAF(0.91012376546859741000),  _DATAF(-0.41433650255203247000)},
    {_DATAF(0.90996479988098145000),  _DATAF(-0.41468548774719238000)},
    {_DATAF(0.90980571508407593000),  _DATAF(-0.41503441333770752000)},
    {_DATAF(0.90964645147323608000),  _DATAF(-0.41538330912590027000)},
    {_DATAF(0.90948712825775146000),  _DATAF(-0.41573211550712585000)},
    {_DATAF(0.90932762622833252000),  _DATAF(-0.41608086228370667000)},
    {_DATAF(0.90916800498962402000),  _DATAF(-0.41642954945564270000)},
    {_DATAF(0.90900820493698120000),  _DATAF(-0.41677817702293396000)},
    {_DATAF(0.90884834527969360000),  _DATAF(-0.41712677478790283000)},
    {_DATAF(0.90868830680847168000),  _DATAF(-0.41747528314590454000)},
    {_DATAF(0.90852808952331543000),  _DATAF(-0.41782370209693909000)},
    {_DATAF(0.90836781263351440000),  _DATAF(-0.41817209124565125000)},
    {_DATAF(0.90820735692977905000),  _DATAF(-0.41852042078971863000)},
    {_DATAF(0.90804684162139893000),  _DATAF(-0.41886869072914124000)},
    {_DATAF(0.90788608789443970000),  _DATAF(-0.41921690106391907000)},
    {_DATAF(0.90772527456283569000),  _DATAF(-0.41956502199172974000)},
    {_DATAF(0.90756434202194214000),  _DATAF(-0.41991311311721802000)},
    {_DATAF(0.90740323066711426000),  _DATAF(-0.42026111483573914000)},
    {_DATAF(0.90724200010299683000),  _DATAF(-0.42060908675193787000)},
    {_DATAF(0.90708059072494507000),  _DATAF(-0.42095696926116943000)},
    {_DATAF(0.90691912174224854000),  _DATAF(-0.42130479216575623000)},
    {_DATAF(0.90675747394561768000),  _DATAF(-0.42165255546569824000)},
    {_DATAF(0.90659570693969727000),  _DATAF(-0.42200025916099548000)},
    {_DATAF(0.90643382072448730000),  _DATAF(-0.42234790325164795000)},
    {_DATAF(0.90627175569534302000),  _DATAF(-0.42269548773765564000)},
    {_DATAF(0.90610957145690918000),  _DATAF(-0.42304301261901855000)},
    {_DATAF(0.90594726800918579000),  _DATAF(-0.42339047789573669000)},
    {_DATAF(0.90578484535217285000),  _DATAF(-0.42373788356781006000)},
    {_DATAF(0.90562230348587036000),  _DATAF(-0.42408519983291626000)},
    {_DATAF(0.90545958280563354000),  _DATAF(-0.42443248629570007000)},
    {_DATAF(0.90529674291610718000),  _DATAF(-0.42477968335151672000)},
    {_DATAF(0.90513378381729126000),  _DATAF(-0.42512682080268860000)},
    {_DATAF(0.90497070550918579000),  _DATAF(-0.42547389864921570000)},
    {_DATAF(0.90480744838714600000),  _DATAF(-0.42582091689109802000)},
    {_DATAF(0.90464407205581665000),  _DATAF(-0.42616787552833557000)},
    {_DATAF(0.90448057651519775000),  _DATAF(-0.42651477456092834000)},
    {_DATAF(0.90431696176528931000),  _DATAF(-0.42686161398887634000)},
    {_DATAF(0.90415316820144653000),  _DATAF(-0.42720839381217957000)},
    {_DATAF(0.90398931503295898000),  _DATAF(-0.42755508422851563000)},
    {_DATAF(0.90382528305053711000),  _DATAF(-0.42790174484252930000)},
    {_DATAF(0.90366107225418091000),  _DATAF(-0.42824831604957581000)},
    {_DATAF(0.90349680185317993000),  _DATAF(-0.42859482765197754000)},
    {_DATAF(0.90333235263824463000),  _DATAF(-0.42894127964973450000)},
    {_DATAF(0.90316778421401978000),  _DATAF(-0.42928767204284668000)},
    {_DATAF(0.90300309658050537000),  _DATAF(-0.42963400483131409000)},
    {_DATAF(0.90283828973770142000),  _DATAF(-0.42998027801513672000)},
    {_DATAF(0.90267330408096313000),  _DATAF(-0.43032649159431458000)},
    {_DATAF(0.90250819921493530000),  _DATAF(-0.43067261576652527000)},
    {_DATAF(0.90234297513961792000),  _DATAF(-0.43101871013641357000)},
    {_DATAF(0.90217763185501099000),  _DATAF(-0.43136471509933472000)},
    {_DATAF(0.90201216936111450000),  _DATAF(-0.43171066045761108000)},
    {_DATAF(0.90184652805328369000),  _DATAF(-0.43205654621124268000)},
    {_DATAF(0.90168076753616333000),  _DATAF(-0.43240237236022949000)},
    {_DATAF(0.90151488780975342000),  _DATAF(-0.43274813890457153000)},
    {_DATAF(0.90134882926940918000),  _DATAF(-0.43309381604194641000)},
    {_DATAF(0.90118271112442017000),  _DATAF(-0.43343946337699890000)},
    {_DATAF(0.90101641416549683000),  _DATAF(-0.43378502130508423000)},
    {_DATAF(0.90084999799728394000),  _DATAF(-0.43413051962852478000)},
    {_DATAF(0.90068340301513672000),  _DATAF(-0.43447595834732056000)},
    {_DATAF(0.90051674842834473000),  _DATAF(-0.43482133746147156000)},
    {_DATAF(0.90034991502761841000),  _DATAF(-0.43516665697097778000)},
    {_DATAF(0.90018296241760254000),  _DATAF(-0.43551188707351685000)},
    {_DATAF(0.90001589059829712000),  _DATAF(-0.43585708737373352000)},
    {_DATAF(0.89984869956970215000),  _DATAF(-0.43620219826698303000)},
    {_DATAF(0.89968132972717285000),  _DATAF(-0.43654724955558777000)},
    {_DATAF(0.89951384067535400000),  _DATAF(-0.43689224123954773000)},
    {_DATAF(0.89934623241424561000),  _DATAF(-0.43723717331886292000)},
    {_DATAF(0.89917850494384766000),  _DATAF(-0.43758204579353333000)},
    {_DATAF(0.89901059865951538000),  _DATAF(-0.43792682886123657000)},
    {_DATAF(0.89884263277053833000),  _DATAF(-0.43827158212661743000)},
    {_DATAF(0.89867448806762695000),  _DATAF(-0.43861624598503113000)},
    {_DATAF(0.89850616455078125000),  _DATAF(-0.43896085023880005000)},
    {_DATAF(0.89833778142929077000),  _DATAF(-0.43930539488792419000)},
    {_DATAF(0.89816927909851074000),  _DATAF(-0.43964985013008118000)},
    {_DATAF(0.89800059795379639000),  _DATAF(-0.43999427556991577000)},
    {_DATAF(0.89783179759979248000),  _DATAF(-0.44033861160278320000)},
    {_DATAF(0.89766281843185425000),  _DATAF(-0.44068288803100586000)},
    {_DATAF(0.89749377965927124000),  _DATAF(-0.44102710485458374000)},
    {_DATAF(0.89732456207275391000),  _DATAF(-0.44137126207351685000)},
    {_DATAF(0.89715522527694702000),  _DATAF(-0.44171535968780518000)},
    {_DATAF(0.89698576927185059000),  _DATAF(-0.44205936789512634000)},
    {_DATAF(0.89681619405746460000),  _DATAF(-0.44240334630012512000)},
    {_DATAF(0.89664649963378906000),  _DATAF(-0.44274723529815674000)},
    {_DATAF(0.89647662639617920000),  _DATAF(-0.44309106469154358000)},
    {_DATAF(0.89630663394927979000),  _DATAF(-0.44343480467796326000)},
    {_DATAF(0.89613652229309082000),  _DATAF(-0.44377851486206055000)},
    {_DATAF(0.89596623182296753000),  _DATAF(-0.44412213563919067000)},
    {_DATAF(0.89579588174819946000),  _DATAF(-0.44446569681167603000)},
    {_DATAF(0.89562535285949707000),  _DATAF(-0.44480919837951660000)},
    {_DATAF(0.89545470476150513000),  _DATAF(-0.44515264034271240000)},
    {_DATAF(0.89528393745422363000),  _DATAF(-0.44549602270126343000)},
    {_DATAF(0.89511299133300781000),  _DATAF(-0.44583931565284729000)},
    {_DATAF(0.89494198560714722000),  _DATAF(-0.44618254899978638000)},
    {_DATAF(0.89477080106735229000),  _DATAF(-0.44652572274208069000)},
    {_DATAF(0.89459949731826782000),  _DATAF(-0.44686883687973022000)},
    {_DATAF(0.89442807435989380000),  _DATAF(-0.44721189141273499000)},
    {_DATAF(0.89425647258758545000),  _DATAF(-0.44755485653877258000)},
    {_DATAF(0.89408475160598755000),  _DATAF(-0.44789776206016541000)},
    {_DATAF(0.89391297101974487000),  _DATAF(-0.44824060797691345000)},
    {_DATAF(0.89374095201492310000),  _DATAF(-0.44858339428901672000)},
    {_DATAF(0.89356887340545654000),  _DATAF(-0.44892609119415283000)},
    {_DATAF(0.89339667558670044000),  _DATAF(-0.44926875829696655000)},
    {_DATAF(0.89322429895401001000),  _DATAF(-0.44961133599281311000)},
    {_DATAF(0.89305180311203003000),  _DATAF(-0.44995385408401489000)},
    {_DATAF(0.89287918806076050000),  _DATAF(-0.45029628276824951000)},
    {_DATAF(0.89270645380020142000),  _DATAF(-0.45063868165016174000)},
    {_DATAF(0.89253354072570801000),  _DATAF(-0.45098099112510681000)},
    {_DATAF(0.89236056804656982000),  _DATAF(-0.45132324099540710000)},
    {_DATAF(0.89218741655349731000),  _DATAF(-0.45166543126106262000)},
    {_DATAF(0.89201414585113525000),  _DATAF(-0.45200753211975098000)},
    {_DATAF(0.89184069633483887000),  _DATAF(-0.45234957337379456000)},
    {_DATAF(0.89166718721389771000),  _DATAF(-0.45269158482551575000)},
    {_DATAF(0.89149349927902222000),  _DATAF(-0.45303347706794739000)},
    {_DATAF(0.89131969213485718000),  _DATAF(-0.45337533950805664000)},
    {_DATAF(0.89114576578140259000),  _DATAF(-0.45371711254119873000)},
    {_DATAF(0.89097172021865845000),  _DATAF(-0.45405882596969604000)},
    {_DATAF(0.89079749584197998000),  _DATAF(-0.45440047979354858000)},
    {_DATAF(0.89062315225601196000),  _DATAF(-0.45474207401275635000)},
    {_DATAF(0.89044874906539917000),  _DATAF(-0.45508357882499695000)},
    {_DATAF(0.89027410745620728000),  _DATAF(-0.45542502403259277000)},
    {_DATAF(0.89009940624237061000),  _DATAF(-0.45576640963554382000)},
    {_DATAF(0.88992458581924438000),  _DATAF(-0.45610773563385010000)},
    {_DATAF(0.88974958658218384000),  _DATAF(-0.45644897222518921000)},
    {_DATAF(0.88957446813583374000),  _DATAF(-0.45679014921188354000)},
    {_DATAF(0.88939923048019409000),  _DATAF(-0.45713126659393311000)},
    {_DATAF(0.88922387361526489000),  _DATAF(-0.45747232437133789000)},
    {_DATAF(0.88904833793640137000),  _DATAF(-0.45781329274177551000)},
    {_DATAF(0.88887274265289307000),  _DATAF(-0.45815420150756836000)},
    {_DATAF(0.88869696855545044000),  _DATAF(-0.45849505066871643000)},
    {_DATAF(0.88852107524871826000),  _DATAF(-0.45883584022521973000)},
    {_DATAF(0.88834506273269653000),  _DATAF(-0.45917654037475586000)},
    {_DATAF(0.88816887140274048000),  _DATAF(-0.45951718091964722000)},
    {_DATAF(0.88799256086349487000),  _DATAF(-0.45985776185989380000)},
    {_DATAF(0.88781619071960449000),  _DATAF(-0.46019828319549561000)},
    {_DATAF(0.88763964176177979000),  _DATAF(-0.46053871512413025000)},
    {_DATAF(0.88746291399002075000),  _DATAF(-0.46087908744812012000)},
    {_DATAF(0.88728612661361694000),  _DATAF(-0.46121940016746521000)},
    {_DATAF(0.88710916042327881000),  _DATAF(-0.46155962347984314000)},
    {_DATAF(0.88693213462829590000),  _DATAF(-0.46189978718757629000)},
    {_DATAF(0.88675493001937866000),  _DATAF(-0.46223989129066467000)},
    {_DATAF(0.88657760620117188000),  _DATAF(-0.46257993578910828000)},
    {_DATAF(0.88640010356903076000),  _DATAF(-0.46291989088058472000)},
    {_DATAF(0.88622254133224487000),  _DATAF(-0.46325978636741638000)},
    {_DATAF(0.88604480028152466000),  _DATAF(-0.46359962224960327000)},
    {_DATAF(0.88586694002151489000),  _DATAF(-0.46393936872482300000)},
    {_DATAF(0.88568896055221558000),  _DATAF(-0.46427905559539795000)},
    {_DATAF(0.88551086187362671000),  _DATAF(-0.46461868286132813000)},
    {_DATAF(0.88533258438110352000),  _DATAF(-0.46495825052261353000)},
    {_DATAF(0.88515424728393555000),  _DATAF(-0.46529772877693176000)},
    {_DATAF(0.88497573137283325000),  _DATAF(-0.46563714742660522000)},
    {_DATAF(0.88479709625244141000),  _DATAF(-0.46597650647163391000)},
    {_DATAF(0.88461834192276001000),  _DATAF(-0.46631577610969543000)},
    {_DATAF(0.88443946838378906000),  _DATAF(-0.46665498614311218000)},
    {_DATAF(0.88426041603088379000),  _DATAF(-0.46699413657188416000)},
    {_DATAF(0.88408124446868896000),  _DATAF(-0.46733319759368896000)},
    {_DATAF(0.88390195369720459000),  _DATAF(-0.46767222881317139000)},
    {_DATAF(0.88372254371643066000),  _DATAF(-0.46801114082336426000)},
    {_DATAF(0.88354301452636719000),  _DATAF(-0.46835002303123474000)},
    {_DATAF(0.88336336612701416000),  _DATAF(-0.46868881583213806000)},
    {_DATAF(0.88318353891372681000),  _DATAF(-0.46902754902839661000)},
    {_DATAF(0.88300359249114990000),  _DATAF(-0.46936622262001038000)},
    {_DATAF(0.88282352685928345000),  _DATAF(-0.46970480680465698000)},
    {_DATAF(0.88264334201812744000),  _DATAF(-0.47004333138465881000)},
    {_DATAF(0.88246303796768188000),  _DATAF(-0.47038179636001587000)},
    {_DATAF(0.88228255510330200000),  _DATAF(-0.47072017192840576000)},
    {_DATAF(0.88210195302963257000),  _DATAF(-0.47105848789215088000)},
    {_DATAF(0.88192129135131836000),  _DATAF(-0.47139674425125122000)},
    {_DATAF(0.88174045085906982000),  _DATAF(-0.47173491120338440000)},
    {_DATAF(0.88155943155288696000),  _DATAF(-0.47207301855087280000)},
    {_DATAF(0.88137835264205933000),  _DATAF(-0.47241106629371643000)},
    {_DATAF(0.88119709491729736000),  _DATAF(-0.47274902462959290000)},
    {_DATAF(0.88101577758789063000),  _DATAF(-0.47308692336082458000)},
    {_DATAF(0.88083428144454956000),  _DATAF(-0.47342476248741150000)},
    {_DATAF(0.88065266609191895000),  _DATAF(-0.47376251220703125000)},
    {_DATAF(0.88047087192535400000),  _DATAF(-0.47410020232200623000)},
    {_DATAF(0.88028901815414429000),  _DATAF(-0.47443783283233643000)},
    {_DATAF(0.88010698556900024000),  _DATAF(-0.47477537393569946000)},
    {_DATAF(0.87992483377456665000),  _DATAF(-0.47511285543441772000)},
    {_DATAF(0.87974262237548828000),  _DATAF(-0.47545027732849121000)},
    {_DATAF(0.87956017255783081000),  _DATAF(-0.47578760981559753000)},
    {_DATAF(0.87937766313552856000),  _DATAF(-0.47612488269805908000)},
    {_DATAF(0.87919503450393677000),  _DATAF(-0.47646209597587585000)},
    {_DATAF(0.87901222705841064000),  _DATAF(-0.47679921984672546000)},
    {_DATAF(0.87882930040359497000),  _DATAF(-0.47713628411293030000)},
    {_DATAF(0.87864625453948975000),  _DATAF(-0.47747328877449036000)},
    {_DATAF(0.87846308946609497000),  _DATAF(-0.47781020402908325000)},
    {_DATAF(0.87827980518341064000),  _DATAF(-0.47814705967903137000)},
    {_DATAF(0.87809634208679199000),  _DATAF(-0.47848382592201233000)},
    {_DATAF(0.87791281938552856000),  _DATAF(-0.47882056236267090000)},
    {_DATAF(0.87772911787033081000),  _DATAF(-0.47915717959403992000)},
    {_DATAF(0.87754529714584351000),  _DATAF(-0.47949376702308655000)},
    {_DATAF(0.87736135721206665000),  _DATAF(-0.47983026504516602000)},
    {_DATAF(0.87717723846435547000),  _DATAF(-0.48016667366027832000)},
    {_DATAF(0.87699306011199951000),  _DATAF(-0.48050305247306824000)},
    {_DATAF(0.87680870294570923000),  _DATAF(-0.48083934187889099000)},
    {_DATAF(0.87662428617477417000),  _DATAF(-0.48117554187774658000)},
    {_DATAF(0.87643969058990479000),  _DATAF(-0.48151168227195740000)},
    {_DATAF(0.87625491619110107000),  _DATAF(-0.48184776306152344000)},
    {_DATAF(0.87607008218765259000),  _DATAF(-0.48218378424644470000)},
    {_DATAF(0.87588512897491455000),  _DATAF(-0.48251971602439880000)},
    {_DATAF(0.87569999694824219000),  _DATAF(-0.48285555839538574000)},
    {_DATAF(0.87551474571228027000),  _DATAF(-0.48319137096405029000)},
    {_DATAF(0.87532937526702881000),  _DATAF(-0.48352706432342529000)},
    {_DATAF(0.87514388561248779000),  _DATAF(-0.48386272788047791000)},
    {_DATAF(0.87495827674865723000),  _DATAF(-0.48419830203056335000)},
    {_DATAF(0.87477254867553711000),  _DATAF(-0.48453381657600403000)},
    {_DATAF(0.87458664178848267000),  _DATAF(-0.48486924171447754000)},
    {_DATAF(0.87440061569213867000),  _DATAF(-0.48520460724830627000)},
    {_DATAF(0.87421452999114990000),  _DATAF(-0.48553991317749023000)},
    {_DATAF(0.87402826547622681000),  _DATAF(-0.48587512969970703000)},
    {_DATAF(0.87384182214736938000),  _DATAF(-0.48621028661727905000)},
    {_DATAF(0.87365531921386719000),  _DATAF(-0.48654535412788391000)},
    {_DATAF(0.87346869707107544000),  _DATAF(-0.48688036203384399000)},
    {_DATAF(0.87328189611434937000),  _DATAF(-0.48721531033515930000)},
    {_DATAF(0.87309497594833374000),  _DATAF(-0.48755016922950745000)},
    {_DATAF(0.87290793657302856000),  _DATAF(-0.48788493871688843000)},
    {_DATAF(0.87272077798843384000),  _DATAF(-0.48821967840194702000)},
    {_DATAF(0.87253350019454956000),  _DATAF(-0.48855432868003845000)},
    {_DATAF(0.87234604358673096000),  _DATAF(-0.48888888955116272000)},
    {_DATAF(0.87215852737426758000),  _DATAF(-0.48922339081764221000)},
    {_DATAF(0.87197083234786987000),  _DATAF(-0.48955783247947693000)},
    {_DATAF(0.87178301811218262000),  _DATAF(-0.48989218473434448000)},
    {_DATAF(0.87159508466720581000),  _DATAF(-0.49022647738456726000)},
    {_DATAF(0.87140703201293945000),  _DATAF(-0.49056071043014526000)},
    {_DATAF(0.87121886014938354000),  _DATAF(-0.49089485406875610000)},
    {_DATAF(0.87103050947189331000),  _DATAF(-0.49122890830039978000)},
    {_DATAF(0.87084203958511353000),  _DATAF(-0.49156290292739868000)},
    {_DATAF(0.87065351009368896000),  _DATAF(-0.49189683794975281000)},
    {_DATAF(0.87046480178833008000),  _DATAF(-0.49223071336746216000)},
    {_DATAF(0.87027597427368164000),  _DATAF(-0.49256446957588196000)},
    {_DATAF(0.87008696794509888000),  _DATAF(-0.49289819598197937000)},
    {_DATAF(0.86989790201187134000),  _DATAF(-0.49323183298110962000)},
    {_DATAF(0.86970865726470947000),  _DATAF(-0.49356541037559509000)},
    {_DATAF(0.86951935291290283000),  _DATAF(-0.49389889836311340000)},
    {_DATAF(0.86932986974716187000),  _DATAF(-0.49423229694366455000)},
    {_DATAF(0.86914026737213135000),  _DATAF(-0.49456566572189331000)},
    {_DATAF(0.86895054578781128000),  _DATAF(-0.49489894509315491000)},
    {_DATAF(0.86876070499420166000),  _DATAF(-0.49523213505744934000)},
    {_DATAF(0.86857068538665771000),  _DATAF(-0.49556526541709900000)},
    {_DATAF(0.86838060617446899000),  _DATAF(-0.49589830636978149000)},
    {_DATAF(0.86819034814834595000),  _DATAF(-0.49623128771781921000)},
    {_DATAF(0.86799997091293335000),  _DATAF(-0.49656420946121216000)},
    {_DATAF(0.86780947446823120000),  _DATAF(-0.49689704179763794000)},
    {_DATAF(0.86761885881423950000),  _DATAF(-0.49722981452941895000)},
    {_DATAF(0.86742812395095825000),  _DATAF(-0.49756249785423279000)},
    {_DATAF(0.86723726987838745000),  _DATAF(-0.49789512157440186000)},
    {_DATAF(0.86704623699188232000),  _DATAF(-0.49822765588760376000)},
    {_DATAF(0.86685508489608765000),  _DATAF(-0.49856013059616089000)},
    {_DATAF(0.86666387319564819000),  _DATAF(-0.49889254570007324000)},
    {_DATAF(0.86647248268127441000),  _DATAF(-0.49922487139701843000)},
    {_DATAF(0.86628097295761108000),  _DATAF(-0.49955710768699646000)},
    {_DATAF(0.86608928442001343000),  _DATAF(-0.49988928437232971000)},
    {_DATAF(0.86589753627777100000),  _DATAF(-0.50022137165069580000)},
    {_DATAF(0.86570566892623901000),  _DATAF(-0.50055342912673950000)},
    {_DATAF(0.86551362276077271000),  _DATAF(-0.50088536739349365000)},
    {_DATAF(0.86532145738601685000),  _DATAF(-0.50121724605560303000)},
    {_DATAF(0.86512917280197144000),  _DATAF(-0.50154906511306763000)},
    {_DATAF(0.86493676900863647000),  _DATAF(-0.50188082456588745000)},
    {_DATAF(0.86474424600601196000),  _DATAF(-0.50221246480941772000)},
    {_DATAF(0.86455160379409790000),  _DATAF(-0.50254404544830322000)},
    {_DATAF(0.86435878276824951000),  _DATAF(-0.50287556648254395000)},
    {_DATAF(0.86416590213775635000),  _DATAF(-0.50320702791213989000)},
    {_DATAF(0.86397284269332886000),  _DATAF(-0.50353837013244629000)},
    {_DATAF(0.86377966403961182000),  _DATAF(-0.50386965274810791000)},
    {_DATAF(0.86358636617660522000),  _DATAF(-0.50420087575912476000)},
    {_DATAF(0.86339294910430908000),  _DATAF(-0.50453203916549683000)},
    {_DATAF(0.86319941282272339000),  _DATAF(-0.50486308336257935000)},
    {_DATAF(0.86300575733184814000),  _DATAF(-0.50519412755966187000)},
    {_DATAF(0.86281192302703857000),  _DATAF(-0.50552505254745483000)},
    {_DATAF(0.86261802911758423000),  _DATAF(-0.50585585832595825000)},
    {_DATAF(0.86242395639419556000),  _DATAF(-0.50618666410446167000)},
    {_DATAF(0.86222976446151733000),  _DATAF(-0.50651735067367554000)},
    {_DATAF(0.86203545331954956000),  _DATAF(-0.50684797763824463000)},
    {_DATAF(0.86184102296829224000),  _DATAF(-0.50717854499816895000)},
    {_DATAF(0.86164647340774536000),  _DATAF(-0.50750899314880371000)},
    {_DATAF(0.86145174503326416000),  _DATAF(-0.50783938169479370000)},
    {_DATAF(0.86125695705413818000),  _DATAF(-0.50816971063613892000)},
    {_DATAF(0.86106199026107788000),  _DATAF(-0.50849997997283936000)},
    {_DATAF(0.86086696386337280000),  _DATAF(-0.50883013010025024000)},
    {_DATAF(0.86067175865173340000),  _DATAF(-0.50916022062301636000)},
    {_DATAF(0.86047643423080444000),  _DATAF(-0.50949025154113770000)},
    {_DATAF(0.86028099060058594000),  _DATAF(-0.50982022285461426000)},
    {_DATAF(0.86008536815643311000),  _DATAF(-0.51015007495880127000)},
    {_DATAF(0.85988968610763550000),  _DATAF(-0.51047992706298828000)},
    {_DATAF(0.85969388484954834000),  _DATAF(-0.51080960035324097000)},
    {_DATAF(0.85949790477752686000),  _DATAF(-0.51113927364349365000)},
    {_DATAF(0.85930180549621582000),  _DATAF(-0.51146882772445679000)},
    {_DATAF(0.85910558700561523000),  _DATAF(-0.51179832220077515000)},
    {_DATAF(0.85890924930572510000),  _DATAF(-0.51212775707244873000)},
    {_DATAF(0.85871279239654541000),  _DATAF(-0.51245713233947754000)},
    {_DATAF(0.85851621627807617000),  _DATAF(-0.51278638839721680000)},
    {_DATAF(0.85831952095031738000),  _DATAF(-0.51311558485031128000)},
    {_DATAF(0.85812264680862427000),  _DATAF(-0.51344472169876099000)},
    {_DATAF(0.85792571306228638000),  _DATAF(-0.51377379894256592000)},
    {_DATAF(0.85772860050201416000),  _DATAF(-0.51410275697708130000)},
    {_DATAF(0.85753136873245239000),  _DATAF(-0.51443165540695190000)},
    {_DATAF(0.85733401775360107000),  _DATAF(-0.51476043462753296000)},
    {_DATAF(0.85713654756546021000),  _DATAF(-0.51508921384811401000)},
    {_DATAF(0.85693895816802979000),  _DATAF(-0.51541787385940552000)},
    {_DATAF(0.85674124956130981000),  _DATAF(-0.51574647426605225000)},
    {_DATAF(0.85654342174530029000),  _DATAF(-0.51607501506805420000)},
    {_DATAF(0.85634541511535645000),  _DATAF(-0.51640343666076660000)},
    {_DATAF(0.85614734888076782000),  _DATAF(-0.51673179864883423000)},
    {_DATAF(0.85594910383224487000),  _DATAF(-0.51706010103225708000)},
    {_DATAF(0.85575073957443237000),  _DATAF(-0.51738828420639038000)},
    {_DATAF(0.85555225610733032000),  _DATAF(-0.51771646738052368000)},
    {_DATAF(0.85535365343093872000),  _DATAF(-0.51804453134536743000)},
    {_DATAF(0.85515493154525757000),  _DATAF(-0.51837247610092163000)},
    {_DATAF(0.85495609045028687000),  _DATAF(-0.51870042085647583000)},
    {_DATAF(0.85475707054138184000),  _DATAF(-0.51902824640274048000)},
    {_DATAF(0.85455799102783203000),  _DATAF(-0.51935601234436035000)},
    {_DATAF(0.85435873270034790000),  _DATAF(-0.51968365907669067000)},
    {_DATAF(0.85415941476821899000),  _DATAF(-0.52001124620437622000)},
    {_DATAF(0.85395991802215576000),  _DATAF(-0.52033877372741699000)},
    {_DATAF(0.85376030206680298000),  _DATAF(-0.52066624164581299000)},
    {_DATAF(0.85356056690216064000),  _DATAF(-0.52099364995956421000)},
    {_DATAF(0.85336071252822876000),  _DATAF(-0.52132093906402588000)},
    {_DATAF(0.85316073894500732000),  _DATAF(-0.52164816856384277000)},
    {_DATAF(0.85296058654785156000),  _DATAF(-0.52197527885437012000)},
    {_DATAF(0.85276037454605103000),  _DATAF(-0.52230238914489746000)},
    {_DATAF(0.85255998373031616000),  _DATAF(-0.52262938022613525000)},
    {_DATAF(0.85235953330993652000),  _DATAF(-0.52295625209808350000)},
    {_DATAF(0.85215890407562256000),  _DATAF(-0.52328312397003174000)},
    {_DATAF(0.85195815563201904000),  _DATAF(-0.52360987663269043000)},
    {_DATAF(0.85175728797912598000),  _DATAF(-0.52393656969070435000)},
    {_DATAF(0.85155630111694336000),  _DATAF(-0.52426314353942871000)},
    {_DATAF(0.85135519504547119000),  _DATAF(-0.52458965778350830000)},
    {_DATAF(0.85115396976470947000),  _DATAF(-0.52491611242294312000)},
    {_DATAF(0.85095256567001343000),  _DATAF(-0.52524250745773315000)},
    {_DATAF(0.85075110197067261000),  _DATAF(-0.52556878328323364000)},
    {_DATAF(0.85054945945739746000),  _DATAF(-0.52589499950408936000)},
    {_DATAF(0.85034775733947754000),  _DATAF(-0.52622115612030029000)},
    {_DATAF(0.85014587640762329000),  _DATAF(-0.52654725313186646000)},
    {_DATAF(0.84994387626647949000),  _DATAF(-0.52687323093414307000)},
    {_DATAF(0.84974175691604614000),  _DATAF(-0.52719914913177490000)},
    {_DATAF(0.84953951835632324000),  _DATAF(-0.52752494812011719000)},
    {_DATAF(0.84933716058731079000),  _DATAF(-0.52785074710845947000)},
    {_DATAF(0.84913468360900879000),  _DATAF(-0.52817642688751221000)},
    {_DATAF(0.84893202781677246000),  _DATAF(-0.52850198745727539000)},
    {_DATAF(0.84872931241989136000),  _DATAF(-0.52882754802703857000)},
    {_DATAF(0.84852647781372070000),  _DATAF(-0.52915298938751221000)},
    {_DATAF(0.84832346439361572000),  _DATAF(-0.52947831153869629000)},
    {_DATAF(0.84812033176422119000),  _DATAF(-0.52980363368988037000)},
    {_DATAF(0.84791707992553711000),  _DATAF(-0.53012883663177490000)},
    {_DATAF(0.84771376848220825000),  _DATAF(-0.53045397996902466000)},
    {_DATAF(0.84751027822494507000),  _DATAF(-0.53077900409698486000)},
    {_DATAF(0.84730660915374756000),  _DATAF(-0.53110402822494507000)},
    {_DATAF(0.84710288047790527000),  _DATAF(-0.53142887353897095000)},
    {_DATAF(0.84689903259277344000),  _DATAF(-0.53175371885299683000)},
    {_DATAF(0.84669506549835205000),  _DATAF(-0.53207844495773315000)},
    {_DATAF(0.84649091958999634000),  _DATAF(-0.53240311145782471000)},
    {_DATAF(0.84628671407699585000),  _DATAF(-0.53272771835327148000)},
    {_DATAF(0.84608232975006104000),  _DATAF(-0.53305220603942871000)},
    {_DATAF(0.84587788581848145000),  _DATAF(-0.53337663412094116000)},
    {_DATAF(0.84567326307296753000),  _DATAF(-0.53370100259780884000)},
    {_DATAF(0.84546852111816406000),  _DATAF(-0.53402525186538696000)},
    {_DATAF(0.84526365995407104000),  _DATAF(-0.53434944152832031000)},
    {_DATAF(0.84505867958068848000),  _DATAF(-0.53467357158660889000)},
    {_DATAF(0.84485357999801636000),  _DATAF(-0.53499764204025269000)},
    {_DATAF(0.84464836120605469000),  _DATAF(-0.53532159328460693000)},
    {_DATAF(0.84444296360015869000),  _DATAF(-0.53564548492431641000)},
    {_DATAF(0.84423750638961792000),  _DATAF(-0.53596925735473633000)},
    {_DATAF(0.84403187036514282000),  _DATAF(-0.53629297018051147000)},
    {_DATAF(0.84382617473602295000),  _DATAF(-0.53661662340164185000)},
    {_DATAF(0.84362030029296875000),  _DATAF(-0.53694015741348267000)},
    {_DATAF(0.84341436624526978000),  _DATAF(-0.53726369142532349000)},
    {_DATAF(0.84320825338363647000),  _DATAF(-0.53758704662322998000)},
    {_DATAF(0.84300202131271362000),  _DATAF(-0.53791040182113647000)},
    {_DATAF(0.84279567003250122000),  _DATAF(-0.53823363780975342000)},
    {_DATAF(0.84258919954299927000),  _DATAF(-0.53855681419372559000)},
    {_DATAF(0.84238260984420776000),  _DATAF(-0.53887993097305298000)},
    {_DATAF(0.84217590093612671000),  _DATAF(-0.53920292854309082000)},
    {_DATAF(0.84196901321411133000),  _DATAF(-0.53952586650848389000)},
    {_DATAF(0.84176206588745117000),  _DATAF(-0.53984868526458740000)},
    {_DATAF(0.84155499935150146000),  _DATAF(-0.54017144441604614000)},
    {_DATAF(0.84134775400161743000),  _DATAF(-0.54049414396286011000)},
    {_DATAF(0.84114044904708862000),  _DATAF(-0.54081678390502930000)},
    {_DATAF(0.84093296527862549000),  _DATAF(-0.54113930463790894000)},
    {_DATAF(0.84072536230087280000),  _DATAF(-0.54146176576614380000)},
    {_DATAF(0.84051764011383057000),  _DATAF(-0.54178416728973389000)},
    {_DATAF(0.84030985832214355000),  _DATAF(-0.54210644960403442000)},
    {_DATAF(0.84010189771652222000),  _DATAF(-0.54242867231369019000)},
    {_DATAF(0.83989381790161133000),  _DATAF(-0.54275077581405640000)},
    {_DATAF(0.83968561887741089000),  _DATAF(-0.54307281970977783000)},
    {_DATAF(0.83947724103927612000),  _DATAF(-0.54339480400085449000)},
    {_DATAF(0.83926880359649658000),  _DATAF(-0.54371672868728638000)},
    {_DATAF(0.83906024694442749000),  _DATAF(-0.54403853416442871000)},
    {_DATAF(0.83885151147842407000),  _DATAF(-0.54436028003692627000)},
    {_DATAF(0.83864271640777588000),  _DATAF(-0.54468190670013428000)},
    {_DATAF(0.83843380212783813000),  _DATAF(-0.54500347375869751000)},
    {_DATAF(0.83822470903396606000),  _DATAF(-0.54532498121261597000)},
    {_DATAF(0.83801549673080444000),  _DATAF(-0.54564642906188965000)},
    {_DATAF(0.83780622482299805000),  _DATAF(-0.54596775770187378000)},
    {_DATAF(0.83759677410125732000),  _DATAF(-0.54628896713256836000)},
    {_DATAF(0.83738720417022705000),  _DATAF(-0.54661017656326294000)},
    {_DATAF(0.83717751502990723000),  _DATAF(-0.54693126678466797000)},
    {_DATAF(0.83696770668029785000),  _DATAF(-0.54725229740142822000)},
    {_DATAF(0.83675777912139893000),  _DATAF(-0.54757320880889893000)},
    {_DATAF(0.83654773235321045000),  _DATAF(-0.54789406061172485000)},
    {_DATAF(0.83633756637573242000),  _DATAF(-0.54821485280990601000)},
    {_DATAF(0.83612728118896484000),  _DATAF(-0.54853552579879761000)},
    {_DATAF(0.83591681718826294000),  _DATAF(-0.54885613918304443000)},
    {_DATAF(0.83570629358291626000),  _DATAF(-0.54917663335800171000)},
    {_DATAF(0.83549559116363525000),  _DATAF(-0.54949712753295898000)},
    {_DATAF(0.83528482913970947000),  _DATAF(-0.54981750249862671000)},
    {_DATAF(0.83507388830184937000),  _DATAF(-0.55013775825500488000)},
    {_DATAF(0.83486288785934448000),  _DATAF(-0.55045795440673828000)},
    {_DATAF(0.83465170860290527000),  _DATAF(-0.55077809095382690000)},
    {_DATAF(0.83444041013717651000),  _DATAF(-0.55109816789627075000)},
    {_DATAF(0.83422905206680298000),  _DATAF(-0.55141812562942505000)},
    {_DATAF(0.83401751518249512000),  _DATAF(-0.55173796415328979000)},
    {_DATAF(0.83380585908889771000),  _DATAF(-0.55205780267715454000)},
    {_DATAF(0.83359408378601074000),  _DATAF(-0.55237752199172974000)},
    {_DATAF(0.83338218927383423000),  _DATAF(-0.55269712209701538000)},
    {_DATAF(0.83317017555236816000),  _DATAF(-0.55301672220230103000)},
    {_DATAF(0.83295804262161255000),  _DATAF(-0.55333620309829712000)},
    {_DATAF(0.83274579048156738000),  _DATAF(-0.55365556478500366000)},
    {_DATAF(0.83253335952758789000),  _DATAF(-0.55397486686706543000)},
    {_DATAF(0.83232086896896362000),  _DATAF(-0.55429410934448242000)},
    {_DATAF(0.83210825920104980000),  _DATAF(-0.55461329221725464000)},
    {_DATAF(0.83189547061920166000),  _DATAF(-0.55493235588073730000)},
    {_DATAF(0.83168262243270874000),  _DATAF(-0.55525130033493042000)},
    {_DATAF(0.83146959543228149000),  _DATAF(-0.55557024478912354000)},
    {_DATAF(0.83125650882720947000),  _DATAF(-0.55588907003402710000)},
    {_DATAF(0.83104324340820313000),  _DATAF(-0.55620777606964111000)},
    {_DATAF(0.83082985877990723000),  _DATAF(-0.55652648210525513000)},
    {_DATAF(0.83061641454696655000),  _DATAF(-0.55684500932693481000)},
    {_DATAF(0.83040279150009155000),  _DATAF(-0.55716353654861450000)},
    {_DATAF(0.83018904924392700000),  _DATAF(-0.55748194456100464000)},
    {_DATAF(0.82997518777847290000),  _DATAF(-0.55780029296875000000)},
    {_DATAF(0.82976120710372925000),  _DATAF(-0.55811852216720581000)},
    {_DATAF(0.82954710721969604000),  _DATAF(-0.55843669176101685000)},
    {_DATAF(0.82933294773101807000),  _DATAF(-0.55875480175018311000)},
    {_DATAF(0.82911854982376099000),  _DATAF(-0.55907279253005981000)},
    {_DATAF(0.82890409231185913000),  _DATAF(-0.55939072370529175000)},
    {_DATAF(0.82868951559066772000),  _DATAF(-0.55970853567123413000)},
    {_DATAF(0.82847481966018677000),  _DATAF(-0.56002628803253174000)},
    {_DATAF(0.82826000452041626000),  _DATAF(-0.56034398078918457000)},
    {_DATAF(0.82804507017135620000),  _DATAF(-0.56066155433654785000)},
    {_DATAF(0.82782995700836182000),  _DATAF(-0.56097906827926636000)},
    {_DATAF(0.82761478424072266000),  _DATAF(-0.56129652261734009000)},
    {_DATAF(0.82739949226379395000),  _DATAF(-0.56161385774612427000)},
    {_DATAF(0.82718402147293091000),  _DATAF(-0.56193113327026367000)},
    {_DATAF(0.82696849107742310000),  _DATAF(-0.56224828958511353000)},
    {_DATAF(0.82675278186798096000),  _DATAF(-0.56256538629531860000)},
    {_DATAF(0.82653701305389404000),  _DATAF(-0.56288242340087891000)},
    {_DATAF(0.82632106542587280000),  _DATAF(-0.56319934129714966000)},
    {_DATAF(0.82610499858856201000),  _DATAF(-0.56351619958877563000)},
    {_DATAF(0.82588887214660645000),  _DATAF(-0.56383293867111206000)},
    {_DATAF(0.82567256689071655000),  _DATAF(-0.56414961814880371000)},
    {_DATAF(0.82545614242553711000),  _DATAF(-0.56446623802185059000)},
    {_DATAF(0.82523959875106812000),  _DATAF(-0.56478273868560791000)},
    {_DATAF(0.82502299547195435000),  _DATAF(-0.56509917974472046000)},
    {_DATAF(0.82480621337890625000),  _DATAF(-0.56541556119918823000)},
    {_DATAF(0.82458931207656860000),  _DATAF(-0.56573182344436646000)},
    {_DATAF(0.82437229156494141000),  _DATAF(-0.56604796648025513000)},
    {_DATAF(0.82415515184402466000),  _DATAF(-0.56636410951614380000)},
    {_DATAF(0.82393789291381836000),  _DATAF(-0.56668013334274292000)},
    {_DATAF(0.82372051477432251000),  _DATAF(-0.56699603796005249000)},
    {_DATAF(0.82350301742553711000),  _DATAF(-0.56731188297271729000)},
    {_DATAF(0.82328540086746216000),  _DATAF(-0.56762766838073730000)},
    {_DATAF(0.82306766510009766000),  _DATAF(-0.56794333457946777000)},
    {_DATAF(0.82284981012344360000),  _DATAF(-0.56825894117355347000)},
    {_DATAF(0.82263177633285522000),  _DATAF(-0.56857448816299438000)},
    {_DATAF(0.82241368293762207000),  _DATAF(-0.56888991594314575000)},
    {_DATAF(0.82219547033309937000),  _DATAF(-0.56920522451400757000)},
    {_DATAF(0.82197713851928711000),  _DATAF(-0.56952053308486938000)},
    {_DATAF(0.82175862789154053000),  _DATAF(-0.56983572244644165000)},
    {_DATAF(0.82154005765914917000),  _DATAF(-0.57015079259872437000)},
    {_DATAF(0.82132136821746826000),  _DATAF(-0.57046580314636230000)},
    {_DATAF(0.82110249996185303000),  _DATAF(-0.57078075408935547000)},
    {_DATAF(0.82088357210159302000),  _DATAF(-0.57109558582305908000)},
    {_DATAF(0.82066446542739868000),  _DATAF(-0.57141035795211792000)},
    {_DATAF(0.82044529914855957000),  _DATAF(-0.57172501087188721000)},
    {_DATAF(0.82022595405578613000),  _DATAF(-0.57203960418701172000)},
    {_DATAF(0.82000654935836792000),  _DATAF(-0.57235413789749146000)},
    {_DATAF(0.81978696584701538000),  _DATAF(-0.57266855239868164000)},
    {_DATAF(0.81956732273101807000),  _DATAF(-0.57298290729522705000)},
    {_DATAF(0.81934750080108643000),  _DATAF(-0.57329714298248291000)},
    {_DATAF(0.81912761926651001000),  _DATAF(-0.57361131906509399000)},
    {_DATAF(0.81890755891799927000),  _DATAF(-0.57392543554306030000)},
    {_DATAF(0.81868737936019897000),  _DATAF(-0.57423943281173706000)},
    {_DATAF(0.81846714019775391000),  _DATAF(-0.57455337047576904000)},
    {_DATAF(0.81824672222137451000),  _DATAF(-0.57486718893051147000)},
    {_DATAF(0.81802618503570557000),  _DATAF(-0.57518094778060913000)},
    {_DATAF(0.81780558824539185000),  _DATAF(-0.57549458742141724000)},
    {_DATAF(0.81758481264114380000),  _DATAF(-0.57580816745758057000)},
    {_DATAF(0.81736391782760620000),  _DATAF(-0.57612168788909912000)},
    {_DATAF(0.81714290380477905000),  _DATAF(-0.57643508911132813000)},
    {_DATAF(0.81692183017730713000),  _DATAF(-0.57674843072891235000)},
    {_DATAF(0.81670057773590088000),  _DATAF(-0.57706165313720703000)},
    {_DATAF(0.81647920608520508000),  _DATAF(-0.57737481594085693000)},
    {_DATAF(0.81625771522521973000),  _DATAF(-0.57768791913986206000)},
    {_DATAF(0.81603610515594482000),  _DATAF(-0.57800090312957764000)},
    {_DATAF(0.81581443548202515000),  _DATAF(-0.57831376791000366000)},
    {_DATAF(0.81559258699417114000),  _DATAF(-0.57862663269042969000)},
    {_DATAF(0.81537061929702759000),  _DATAF(-0.57893931865692139000)},
    {_DATAF(0.81514853239059448000),  _DATAF(-0.57925200462341309000)},
    {_DATAF(0.81492632627487183000),  _DATAF(-0.57956457138061523000)},
    {_DATAF(0.81470400094985962000),  _DATAF(-0.57987701892852783000)},
    {_DATAF(0.81448155641555786000),  _DATAF(-0.58018940687179565000)},
    {_DATAF(0.81425899267196655000),  _DATAF(-0.58050173521041870000)},
    {_DATAF(0.81403630971908569000),  _DATAF(-0.58081394433975220000)},
    {_DATAF(0.81381350755691528000),  _DATAF(-0.58112609386444092000)},
    {_DATAF(0.81359058618545532000),  _DATAF(-0.58143812417984009000)},
    {_DATAF(0.81336754560470581000),  _DATAF(-0.58175009489059448000)},
    {_DATAF(0.81314438581466675000),  _DATAF(-0.58206200599670410000)},
    {_DATAF(0.81292116641998291000),  _DATAF(-0.58237379789352417000)},
    {_DATAF(0.81269776821136475000),  _DATAF(-0.58268547058105469000)},
    {_DATAF(0.81247425079345703000),  _DATAF(-0.58299714326858521000)},
    {_DATAF(0.81225061416625977000),  _DATAF(-0.58330863714218140000)},
    {_DATAF(0.81202685832977295000),  _DATAF(-0.58362013101577759000)},
    {_DATAF(0.81180298328399658000),  _DATAF(-0.58393144607543945000)},
    {_DATAF(0.81157898902893066000),  _DATAF(-0.58424276113510132000)},
    {_DATAF(0.81135487556457520000),  _DATAF(-0.58455395698547363000)},
    {_DATAF(0.81113064289093018000),  _DATAF(-0.58486503362655640000)},
    {_DATAF(0.81090623140335083000),  _DATAF(-0.58517605066299438000)},
    {_DATAF(0.81068176031112671000),  _DATAF(-0.58548700809478760000)},
    {_DATAF(0.81045717000961304000),  _DATAF(-0.58579784631729126000)},
    {_DATAF(0.81023246049880981000),  _DATAF(-0.58610862493515015000)},
    {_DATAF(0.81000763177871704000),  _DATAF(-0.58641928434371948000)},
    {_DATAF(0.80978268384933472000),  _DATAF(-0.58672988414764404000)},
    {_DATAF(0.80955761671066284000),  _DATAF(-0.58704036474227905000)},
    {_DATAF(0.80933243036270142000),  _DATAF(-0.58735078573226929000)},
    {_DATAF(0.80910712480545044000),  _DATAF(-0.58766114711761475000)},
    {_DATAF(0.80888170003890991000),  _DATAF(-0.58797138929367065000)},
    {_DATAF(0.80865615606307983000),  _DATAF(-0.58828157186508179000)},
    {_DATAF(0.80843049287796021000),  _DATAF(-0.58859163522720337000)},
    {_DATAF(0.80820471048355103000),  _DATAF(-0.58890157938003540000)},
    {_DATAF(0.80797880887985229000),  _DATAF(-0.58921152353286743000)},
    {_DATAF(0.80775284767150879000),  _DATAF(-0.58952128887176514000)},
    {_DATAF(0.80752670764923096000),  _DATAF(-0.58983105421066284000)},
    {_DATAF(0.80730044841766357000),  _DATAF(-0.59014070034027100000)},
    {_DATAF(0.80707406997680664000),  _DATAF(-0.59045022726058960000)},
    {_DATAF(0.80684757232666016000),  _DATAF(-0.59075969457626343000)},
    {_DATAF(0.80662095546722412000),  _DATAF(-0.59106910228729248000)},
    {_DATAF(0.80639421939849854000),  _DATAF(-0.59137839078903198000)},
    {_DATAF(0.80616736412048340000),  _DATAF(-0.59168756008148193000)},
    {_DATAF(0.80594038963317871000),  _DATAF(-0.59199666976928711000)},
    {_DATAF(0.80571329593658447000),  _DATAF(-0.59230571985244751000)},
    {_DATAF(0.80548608303070068000),  _DATAF(-0.59261465072631836000)},
    {_DATAF(0.80525875091552734000),  _DATAF(-0.59292352199554443000)},
    {_DATAF(0.80503135919570923000),  _DATAF(-0.59323227405548096000)},
    {_DATAF(0.80480378866195679000),  _DATAF(-0.59354096651077271000)},
    {_DATAF(0.80457609891891479000),  _DATAF(-0.59384959936141968000)},
    {_DATAF(0.80434828996658325000),  _DATAF(-0.59415805339813232000)},
    {_DATAF(0.80412036180496216000),  _DATAF(-0.59446650743484497000)},
    {_DATAF(0.80389231443405151000),  _DATAF(-0.59477484226226807000)},
    {_DATAF(0.80366420745849609000),  _DATAF(-0.59508305788040161000)},
    {_DATAF(0.80343592166900635000),  _DATAF(-0.59539121389389038000)},
    {_DATAF(0.80320751667022705000),  _DATAF(-0.59569931030273438000)},
    {_DATAF(0.80297905206680298000),  _DATAF(-0.59600728750228882000)},
    {_DATAF(0.80275040864944458000),  _DATAF(-0.59631520509719849000)},
    {_DATAF(0.80252164602279663000),  _DATAF(-0.59662300348281860000)},
    {_DATAF(0.80229282379150391000),  _DATAF(-0.59693068265914917000)},
    {_DATAF(0.80206382274627686000),  _DATAF(-0.59723836183547974000)},
    {_DATAF(0.80183470249176025000),  _DATAF(-0.59754586219787598000)},
    {_DATAF(0.80160552263259888000),  _DATAF(-0.59785336256027222000)},
    {_DATAF(0.80137616395950317000),  _DATAF(-0.59816068410873413000)},
    {_DATAF(0.80114674568176270000),  _DATAF(-0.59846800565719604000)},
    {_DATAF(0.80091714859008789000),  _DATAF(-0.59877520799636841000)},
    {_DATAF(0.80068749189376831000),  _DATAF(-0.59908229112625122000)},
    {_DATAF(0.80045765638351440000),  _DATAF(-0.59938931465148926000)},
    {_DATAF(0.80022776126861572000),  _DATAF(-0.59969621896743774000)},
    {_DATAF(0.79999768733978271000),  _DATAF(-0.60000306367874146000)},
    {_DATAF(0.79976755380630493000),  _DATAF(-0.60030978918075562000)},
    {_DATAF(0.79953724145889282000),  _DATAF(-0.60061645507812500000)},
    {_DATAF(0.79930686950683594000),  _DATAF(-0.60092306137084961000)},
    {_DATAF(0.79907637834548950000),  _DATAF(-0.60122954845428467000)},
    {_DATAF(0.79884576797485352000),  _DATAF(-0.60153591632843018000)},
    {_DATAF(0.79861497879028320000),  _DATAF(-0.60184222459793091000)},
    {_DATAF(0.79838413000106812000),  _DATAF(-0.60214847326278687000)},
    {_DATAF(0.79815316200256348000),  _DATAF(-0.60245460271835327000)},
    {_DATAF(0.79792207479476929000),  _DATAF(-0.60276067256927490000)},
    {_DATAF(0.79769086837768555000),  _DATAF(-0.60306662321090698000)},
    {_DATAF(0.79745948314666748000),  _DATAF(-0.60337245464324951000)},
    {_DATAF(0.79722803831100464000),  _DATAF(-0.60367822647094727000)},
    {_DATAF(0.79699647426605225000),  _DATAF(-0.60398393869400024000)},
    {_DATAF(0.79676479101181030000),  _DATAF(-0.60428953170776367000)},
    {_DATAF(0.79653298854827881000),  _DATAF(-0.60459506511688232000)},
    {_DATAF(0.79630106687545776000),  _DATAF(-0.60490047931671143000)},
    {_DATAF(0.79606908559799194000),  _DATAF(-0.60520577430725098000)},
    {_DATAF(0.79583692550659180000),  _DATAF(-0.60551106929779053000)},
    {_DATAF(0.79560464620590210000),  _DATAF(-0.60581618547439575000)},
    {_DATAF(0.79537224769592285000),  _DATAF(-0.60612124204635620000)},
    {_DATAF(0.79513972997665405000),  _DATAF(-0.60642623901367188000)},
    {_DATAF(0.79490715265274048000),  _DATAF(-0.60673111677169800000)},
    {_DATAF(0.79467439651489258000),  _DATAF(-0.60703593492507935000)},
    {_DATAF(0.79444152116775513000),  _DATAF(-0.60734063386917114000)},
    {_DATAF(0.79420858621597290000),  _DATAF(-0.60764527320861816000)},
    {_DATAF(0.79397547245025635000),  _DATAF(-0.60794979333877563000)},
    {_DATAF(0.79374229907989502000),  _DATAF(-0.60825425386428833000)},
    {_DATAF(0.79350894689559937000),  _DATAF(-0.60855859518051147000)},
    {_DATAF(0.79327553510665894000),  _DATAF(-0.60886281728744507000)},
    {_DATAF(0.79304194450378418000),  _DATAF(-0.60916703939437866000)},
    {_DATAF(0.79280829429626465000),  _DATAF(-0.60947108268737793000)},
    {_DATAF(0.79257452487945557000),  _DATAF(-0.60977506637573242000)},
    {_DATAF(0.79234057664871216000),  _DATAF(-0.61007899045944214000)},
    {_DATAF(0.79210656881332397000),  _DATAF(-0.61038279533386230000)},
    {_DATAF(0.79187244176864624000),  _DATAF(-0.61068654060363770000)},
    {_DATAF(0.79163819551467896000),  _DATAF(-0.61099016666412354000)},
    {_DATAF(0.79140383005142212000),  _DATAF(-0.61129373311996460000)},
    {_DATAF(0.79116934537887573000),  _DATAF(-0.61159718036651611000)},
    {_DATAF(0.79093474149703979000),  _DATAF(-0.61190050840377808000)},
    {_DATAF(0.79070001840591431000),  _DATAF(-0.61220377683639526000)},
    {_DATAF(0.79046517610549927000),  _DATAF(-0.61250698566436768000)},
    {_DATAF(0.79023021459579468000),  _DATAF(-0.61281007528305054000)},
    {_DATAF(0.78999513387680054000),  _DATAF(-0.61311310529708862000)},
    {_DATAF(0.78975999355316162000),  _DATAF(-0.61341601610183716000)},
    {_DATAF(0.78952467441558838000),  _DATAF(-0.61371880769729614000)},
    {_DATAF(0.78928923606872559000),  _DATAF(-0.61402153968811035000)},
    {_DATAF(0.78905373811721802000),  _DATAF(-0.61432421207427979000)},
    {_DATAF(0.78881806135177612000),  _DATAF(-0.61462676525115967000)},
    {_DATAF(0.78858232498168945000),  _DATAF(-0.61492919921875000000)},
    {_DATAF(0.78834640979766846000),  _DATAF(-0.61523157358169556000)},
    {_DATAF(0.78811043500900269000),  _DATAF(-0.61553388833999634000)},
    {_DATAF(0.78787434101104736000),  _DATAF(-0.61583608388900757000)},
    {_DATAF(0.78763806819915771000),  _DATAF(-0.61613816022872925000)},
    {_DATAF(0.78740173578262329000),  _DATAF(-0.61644017696380615000)},
    {_DATAF(0.78716528415679932000),  _DATAF(-0.61674207448959351000)},
    {_DATAF(0.78692871332168579000),  _DATAF(-0.61704391241073608000)},
    {_DATAF(0.78669202327728271000),  _DATAF(-0.61734563112258911000)},
    {_DATAF(0.78645521402359009000),  _DATAF(-0.61764729022979736000)},
    {_DATAF(0.78621828556060791000),  _DATAF(-0.61794888973236084000)},
    {_DATAF(0.78598123788833618000),  _DATAF(-0.61825031042098999000)},
    {_DATAF(0.78574407100677490000),  _DATAF(-0.61855173110961914000)},
    {_DATAF(0.78550684452056885000),  _DATAF(-0.61885297298431396000)},
    {_DATAF(0.78526943922042847000),  _DATAF(-0.61915415525436401000)},
    {_DATAF(0.78503191471099854000),  _DATAF(-0.61945527791976929000)},
    {_DATAF(0.78479433059692383000),  _DATAF(-0.61975628137588501000)},
    {_DATAF(0.78455656766891479000),  _DATAF(-0.62005722522735596000)},
    {_DATAF(0.78431874513626099000),  _DATAF(-0.62035804986953735000)},
    {_DATAF(0.78408080339431763000),  _DATAF(-0.62065875530242920000)},
    {_DATAF(0.78384268283843994000),  _DATAF(-0.62095940113067627000)},
    {_DATAF(0.78360450267791748000),  _DATAF(-0.62125998735427856000)},
    {_DATAF(0.78336620330810547000),  _DATAF(-0.62156045436859131000)},
    {_DATAF(0.78312778472900391000),  _DATAF(-0.62186080217361450000)},
    {_DATAF(0.78288924694061279000),  _DATAF(-0.62216109037399292000)},
    {_DATAF(0.78265058994293213000),  _DATAF(-0.62246125936508179000)},
    {_DATAF(0.78241181373596191000),  _DATAF(-0.62276136875152588000)},
    {_DATAF(0.78217291831970215000),  _DATAF(-0.62306135892868042000)},
    {_DATAF(0.78193396329879761000),  _DATAF(-0.62336128950119019000)},
    {_DATAF(0.78169482946395874000),  _DATAF(-0.62366110086441040000)},
    {_DATAF(0.78145557641983032000),  _DATAF(-0.62396085262298584000)},
    {_DATAF(0.78121626377105713000),  _DATAF(-0.62426048517227173000)},
    {_DATAF(0.78097677230834961000),  _DATAF(-0.62456005811691284000)},
    {_DATAF(0.78073722124099731000),  _DATAF(-0.62485951185226440000)},
    {_DATAF(0.78049755096435547000),  _DATAF(-0.62515884637832642000)},
    {_DATAF(0.78025776147842407000),  _DATAF(-0.62545812129974365000)},
    {_DATAF(0.78001779317855835000),  _DATAF(-0.62575727701187134000)},
    {_DATAF(0.77977776527404785000),  _DATAF(-0.62605637311935425000)},
    {_DATAF(0.77953761816024780000),  _DATAF(-0.62635540962219238000)},
    {_DATAF(0.77929735183715820000),  _DATAF(-0.62665426731109619000)},
    {_DATAF(0.77905702590942383000),  _DATAF(-0.62695312500000000000)},
    {_DATAF(0.77881652116775513000),  _DATAF(-0.62725180387496948000)},
    {_DATAF(0.77857589721679688000),  _DATAF(-0.62755042314529419000)},
    {_DATAF(0.77833521366119385000),  _DATAF(-0.62784898281097412000)},
    {_DATAF(0.77809435129165649000),  _DATAF(-0.62814742326736450000)},
    {_DATAF(0.77785342931747437000),  _DATAF(-0.62844574451446533000)},
    {_DATAF(0.77761232852935791000),  _DATAF(-0.62874400615692139000)},
    {_DATAF(0.77737116813659668000),  _DATAF(-0.62904220819473267000)},
    {_DATAF(0.77712988853454590000),  _DATAF(-0.62934023141860962000)},
    {_DATAF(0.77688848972320557000),  _DATAF(-0.62963825464248657000)},
    {_DATAF(0.77664697170257568000),  _DATAF(-0.62993609905242920000)},
    {_DATAF(0.77640533447265625000),  _DATAF(-0.63023394346237183000)},
    {_DATAF(0.77616357803344727000),  _DATAF(-0.63053160905838013000)},
    {_DATAF(0.77592170238494873000),  _DATAF(-0.63082921504974365000)},
    {_DATAF(0.77567970752716064000),  _DATAF(-0.63112676143646240000)},
    {_DATAF(0.77543765306472778000),  _DATAF(-0.63142418861389160000)},
    {_DATAF(0.77519541978836060000),  _DATAF(-0.63172149658203125000)},
    {_DATAF(0.77495312690734863000),  _DATAF(-0.63201874494552612000)},
    {_DATAF(0.77471065521240234000),  _DATAF(-0.63231587409973145000)},
    {_DATAF(0.77446812391281128000),  _DATAF(-0.63261294364929199000)},
    {_DATAF(0.77422547340393066000),  _DATAF(-0.63290989398956299000)},
    {_DATAF(0.77398270368576050000),  _DATAF(-0.63320678472518921000)},
    {_DATAF(0.77373981475830078000),  _DATAF(-0.63350355625152588000)},
    {_DATAF(0.77349680662155151000),  _DATAF(-0.63380020856857300000)},
    {_DATAF(0.77325367927551270000),  _DATAF(-0.63409680128097534000)},
    {_DATAF(0.77301043272018433000),  _DATAF(-0.63439327478408813000)},
    {_DATAF(0.77276712656021118000),  _DATAF(-0.63468968868255615000)},
    {_DATAF(0.77252364158630371000),  _DATAF(-0.63498598337173462000)},
    {_DATAF(0.77228009700775146000),  _DATAF(-0.63528221845626831000)},
    {_DATAF(0.77203637361526489000),  _DATAF(-0.63557833433151245000)},
    {_DATAF(0.77179259061813354000),  _DATAF(-0.63587433099746704000)},
    {_DATAF(0.77154868841171265000),  _DATAF(-0.63617026805877686000)},
    {_DATAF(0.77130466699600220000),  _DATAF(-0.63646614551544189000)},
    {_DATAF(0.77106052637100220000),  _DATAF(-0.63676184415817261000)},
    {_DATAF(0.77081626653671265000),  _DATAF(-0.63705748319625854000)},
    {_DATAF(0.77057188749313354000),  _DATAF(-0.63735306262969971000)},
    {_DATAF(0.77032744884490967000),  _DATAF(-0.63764852285385132000)},
    {_DATAF(0.77008283138275146000),  _DATAF(-0.63794392347335815000)},
    {_DATAF(0.76983815431594849000),  _DATAF(-0.63823920488357544000)},
    {_DATAF(0.76959329843521118000),  _DATAF(-0.63853436708450317000)},
    {_DATAF(0.76934838294982910000),  _DATAF(-0.63882946968078613000)},
    {_DATAF(0.76910334825515747000),  _DATAF(-0.63912445306777954000)},
    {_DATAF(0.76885819435119629000),  _DATAF(-0.63941931724548340000)},
    {_DATAF(0.76861292123794556000),  _DATAF(-0.63971418142318726000)},
    {_DATAF(0.76836752891540527000),  _DATAF(-0.64000886678695679000)},
    {_DATAF(0.76812201738357544000),  _DATAF(-0.64030349254608154000)},
    {_DATAF(0.76787644624710083000),  _DATAF(-0.64059799909591675000)},
    {_DATAF(0.76763069629669189000),  _DATAF(-0.64089244604110718000)},
    {_DATAF(0.76738488674163818000),  _DATAF(-0.64118677377700806000)},
    {_DATAF(0.76713889837265015000),  _DATAF(-0.64148104190826416000)},
    {_DATAF(0.76689285039901733000),  _DATAF(-0.64177513122558594000)},
    {_DATAF(0.76664668321609497000),  _DATAF(-0.64206922054290771000)},
    {_DATAF(0.76640039682388306000),  _DATAF(-0.64236319065093994000)},
    {_DATAF(0.76615399122238159000),  _DATAF(-0.64265704154968262000)},
    {_DATAF(0.76590746641159058000),  _DATAF(-0.64295083284378052000)},
    {_DATAF(0.76566088199615479000),  _DATAF(-0.64324450492858887000)},
    {_DATAF(0.76541411876678467000),  _DATAF(-0.64353805780410767000)},
    {_DATAF(0.76516723632812500000),  _DATAF(-0.64383155107498169000)},
    {_DATAF(0.76492029428482056000),  _DATAF(-0.64412492513656616000)},
    {_DATAF(0.76467323303222656000),  _DATAF(-0.64441823959350586000)},
    {_DATAF(0.76442605257034302000),  _DATAF(-0.64471143484115601000)},
    {_DATAF(0.76417875289916992000),  _DATAF(-0.64500451087951660000)},
    {_DATAF(0.76393133401870728000),  _DATAF(-0.64529752731323242000)},
    {_DATAF(0.76368379592895508000),  _DATAF(-0.64559048414230347000)},
    {_DATAF(0.76343613862991333000),  _DATAF(-0.64588326215744019000)},
    {_DATAF(0.76318842172622681000),  _DATAF(-0.64617604017257690000)},
    {_DATAF(0.76294052600860596000),  _DATAF(-0.64646863937377930000)},
    {_DATAF(0.76269257068634033000),  _DATAF(-0.64676117897033691000)},
    {_DATAF(0.76244449615478516000),  _DATAF(-0.64705359935760498000)},
    {_DATAF(0.76219630241394043000),  _DATAF(-0.64734596014022827000)},
    {_DATAF(0.76194798946380615000),  _DATAF(-0.64763820171356201000)},
    {_DATAF(0.76169955730438232000),  _DATAF(-0.64793038368225098000)},
    {_DATAF(0.76145100593566895000),  _DATAF(-0.64822244644165039000)},
    {_DATAF(0.76120239496231079000),  _DATAF(-0.64851438999176025000)},
    {_DATAF(0.76095360517501831000),  _DATAF(-0.64880627393722534000)},
    {_DATAF(0.76070475578308105000),  _DATAF(-0.64909803867340088000)},
    {_DATAF(0.76045578718185425000),  _DATAF(-0.64938974380493164000)},
    {_DATAF(0.76020669937133789000),  _DATAF(-0.64968132972717285000)},
    {_DATAF(0.75995749235153198000),  _DATAF(-0.64997279644012451000)},
    {_DATAF(0.75970816612243652000),  _DATAF(-0.65026420354843140000)},
    {_DATAF(0.75945872068405151000),  _DATAF(-0.65055549144744873000)},
    {_DATAF(0.75920921564102173000),  _DATAF(-0.65084666013717651000)},
    {_DATAF(0.75895953178405762000),  _DATAF(-0.65113776922225952000)},
    {_DATAF(0.75870978832244873000),  _DATAF(-0.65142881870269775000)},
    {_DATAF(0.75845992565155029000),  _DATAF(-0.65171968936920166000)},
    {_DATAF(0.75820988416671753000),  _DATAF(-0.65201056003570557000)},
    {_DATAF(0.75795978307723999000),  _DATAF(-0.65230125188827515000)},
    {_DATAF(0.75770962238311768000),  _DATAF(-0.65259188413619995000)},
    {_DATAF(0.75745928287506104000),  _DATAF(-0.65288239717483521000)},
    {_DATAF(0.75720882415771484000),  _DATAF(-0.65317285060882568000)},
    {_DATAF(0.75695830583572388000),  _DATAF(-0.65346318483352661000)},
    {_DATAF(0.75670766830444336000),  _DATAF(-0.65375339984893799000)},
    {_DATAF(0.75645685195922852000),  _DATAF(-0.65404355525970459000)},
    {_DATAF(0.75620597600936890000),  _DATAF(-0.65433359146118164000)},
    {_DATAF(0.75595504045486450000),  _DATAF(-0.65462356805801392000)},
    {_DATAF(0.75570392608642578000),  _DATAF(-0.65491342544555664000)},
    {_DATAF(0.75545269250869751000),  _DATAF(-0.65520316362380981000)},
    {_DATAF(0.75520139932632446000),  _DATAF(-0.65549284219741821000)},
    {_DATAF(0.75494992733001709000),  _DATAF(-0.65578240156173706000)},
    {_DATAF(0.75469839572906494000),  _DATAF(-0.65607190132141113000)},
    {_DATAF(0.75444674491882324000),  _DATAF(-0.65636128187179565000)},
    {_DATAF(0.75419497489929199000),  _DATAF(-0.65665054321289063000)},
    {_DATAF(0.75394308567047119000),  _DATAF(-0.65693974494934082000)},
    {_DATAF(0.75369113683700562000),  _DATAF(-0.65722882747650146000)},
    {_DATAF(0.75343900918960571000),  _DATAF(-0.65751779079437256000)},
    {_DATAF(0.75318682193756104000),  _DATAF(-0.65780669450759888000)},
    {_DATAF(0.75293445587158203000),  _DATAF(-0.65809547901153564000)},
    {_DATAF(0.75268203020095825000),  _DATAF(-0.65838420391082764000)},
    {_DATAF(0.75242948532104492000),  _DATAF(-0.65867280960083008000)},
    {_DATAF(0.75217682123184204000),  _DATAF(-0.65896129608154297000)},
    {_DATAF(0.75192409753799438000),  _DATAF(-0.65924972295761108000)},
    {_DATAF(0.75167119503021240000),  _DATAF(-0.65953803062438965000)},
    {_DATAF(0.75141823291778564000),  _DATAF(-0.65982621908187866000)},
    {_DATAF(0.75116515159606934000),  _DATAF(-0.66011434793472290000)},
    {_DATAF(0.75091195106506348000),  _DATAF(-0.66040235757827759000)},
    {_DATAF(0.75065863132476807000),  _DATAF(-0.66069030761718750000)},
    {_DATAF(0.75040519237518311000),  _DATAF(-0.66097813844680786000)},
    {_DATAF(0.75015163421630859000),  _DATAF(-0.66126585006713867000)},
    {_DATAF(0.74989801645278931000),  _DATAF(-0.66155344247817993000)},
    {_DATAF(0.74964421987533569000),  _DATAF(-0.66184097528457642000)},
    {_DATAF(0.74939036369323730000),  _DATAF(-0.66212844848632813000)},
    {_DATAF(0.74913638830184937000),  _DATAF(-0.66241580247879028000)},
    {_DATAF(0.74888229370117188000),  _DATAF(-0.66270303726196289000)},
    {_DATAF(0.74862807989120483000),  _DATAF(-0.66299015283584595000)},
    {_DATAF(0.74837380647659302000),  _DATAF(-0.66327720880508423000)},
    {_DATAF(0.74811935424804688000),  _DATAF(-0.66356414556503296000)},
    {_DATAF(0.74786484241485596000),  _DATAF(-0.66385102272033691000)},
    {_DATAF(0.74761021137237549000),  _DATAF(-0.66413778066635132000)},
    {_DATAF(0.74735546112060547000),  _DATAF(-0.66442441940307617000)},
    {_DATAF(0.74710059165954590000),  _DATAF(-0.66471099853515625000)},
    {_DATAF(0.74684566259384155000),  _DATAF(-0.66499745845794678000)},
    {_DATAF(0.74659055471420288000),  _DATAF(-0.66528379917144775000)},
    {_DATAF(0.74633538722991943000),  _DATAF(-0.66557008028030396000)},
    {_DATAF(0.74608010053634644000),  _DATAF(-0.66585624217987061000)},
    {_DATAF(0.74582469463348389000),  _DATAF(-0.66614228487014771000)},
    {_DATAF(0.74556916952133179000),  _DATAF(-0.66642826795578003000)},
    {_DATAF(0.74531352519989014000),  _DATAF(-0.66671413183212280000)},
    {_DATAF(0.74505776166915894000),  _DATAF(-0.66699993610382080000)},
    {_DATAF(0.74480193853378296000),  _DATAF(-0.66728562116622925000)},
    {_DATAF(0.74454599618911743000),  _DATAF(-0.66757118701934814000)},
    {_DATAF(0.74428993463516235000),  _DATAF(-0.66785663366317749000)},
    {_DATAF(0.74403375387191772000),  _DATAF(-0.66814202070236206000)},
    {_DATAF(0.74377745389938354000),  _DATAF(-0.66842734813690186000)},
    {_DATAF(0.74352109432220459000),  _DATAF(-0.66871249675750732000)},
    {_DATAF(0.74326455593109131000),  _DATAF(-0.66899758577346802000)},
    {_DATAF(0.74300795793533325000),  _DATAF(-0.66928261518478394000)},
    {_DATAF(0.74275124073028564000),  _DATAF(-0.66956746578216553000)},
    {_DATAF(0.74249440431594849000),  _DATAF(-0.66985225677490234000)},
    {_DATAF(0.74223744869232178000),  _DATAF(-0.67013698816299438000)},
    {_DATAF(0.74198043346405029000),  _DATAF(-0.67042154073715210000)},
    {_DATAF(0.74172323942184448000),  _DATAF(-0.67070603370666504000)},
    {_DATAF(0.74146598577499390000),  _DATAF(-0.67099046707153320000)},
    {_DATAF(0.74120861291885376000),  _DATAF(-0.67127478122711182000)},
    {_DATAF(0.74095112085342407000),  _DATAF(-0.67155897617340088000)},
    {_DATAF(0.74069350957870483000),  _DATAF(-0.67184305191040039000)},
    {_DATAF(0.74043583869934082000),  _DATAF(-0.67212706804275513000)},
    {_DATAF(0.74017798900604248000),  _DATAF(-0.67241096496582031000)},
    {_DATAF(0.73992007970809937000),  _DATAF(-0.67269474267959595000)},
    {_DATAF(0.73966205120086670000),  _DATAF(-0.67297846078872681000)},
    {_DATAF(0.73940390348434448000),  _DATAF(-0.67326205968856812000)},
    {_DATAF(0.73914569616317749000),  _DATAF(-0.67354559898376465000)},
    {_DATAF(0.73888731002807617000),  _DATAF(-0.67382901906967163000)},
    {_DATAF(0.73862886428833008000),  _DATAF(-0.67411231994628906000)},
    {_DATAF(0.73837029933929443000),  _DATAF(-0.67439550161361694000)},
    {_DATAF(0.73811161518096924000),  _DATAF(-0.67467862367630005000)},
    {_DATAF(0.73785281181335449000),  _DATAF(-0.67496162652969360000)},
    {_DATAF(0.73759388923645020000),  _DATAF(-0.67524456977844238000)},
    {_DATAF(0.73733490705490112000),  _DATAF(-0.67552739381790161000)},
    {_DATAF(0.73707580566406250000),  _DATAF(-0.67581009864807129000)},
    {_DATAF(0.73681658506393433000),  _DATAF(-0.67609268426895142000)},
    {_DATAF(0.73655724525451660000),  _DATAF(-0.67637521028518677000)},
    {_DATAF(0.73629778623580933000),  _DATAF(-0.67665761709213257000)},
    {_DATAF(0.73603826761245728000),  _DATAF(-0.67693996429443359000)},
    {_DATAF(0.73577857017517090000),  _DATAF(-0.67722219228744507000)},
    {_DATAF(0.73551881313323975000),  _DATAF(-0.67750430107116699000)},
    {_DATAF(0.73525893688201904000),  _DATAF(-0.67778629064559937000)},
    {_DATAF(0.73499894142150879000),  _DATAF(-0.67806822061538696000)},
    {_DATAF(0.73473888635635376000),  _DATAF(-0.67835003137588501000)},
    {_DATAF(0.73447865247726440000),  _DATAF(-0.67863178253173828000)},
    {_DATAF(0.73421835899353027000),  _DATAF(-0.67891335487365723000)},
    {_DATAF(0.73395794630050659000),  _DATAF(-0.67919492721557617000)},
    {_DATAF(0.73369741439819336000),  _DATAF(-0.67947632074356079000)},
    {_DATAF(0.73343682289123535000),  _DATAF(-0.67975765466690063000)},
    {_DATAF(0.73317605257034302000),  _DATAF(-0.68003886938095093000)},
    {_DATAF(0.73291522264480591000),  _DATAF(-0.68031996488571167000)},
    {_DATAF(0.73265427350997925000),  _DATAF(-0.68060100078582764000)},
    {_DATAF(0.73239320516586304000),  _DATAF(-0.68088191747665405000)},
    {_DATAF(0.73213201761245728000),  _DATAF(-0.68116271495819092000)},
    {_DATAF(0.73187077045440674000),  _DATAF(-0.68144345283508301000)},
    {_DATAF(0.73160940408706665000),  _DATAF(-0.68172407150268555000)},
    {_DATAF(0.73134791851043701000),  _DATAF(-0.68200457096099854000)},
    {_DATAF(0.73108631372451782000),  _DATAF(-0.68228501081466675000)},
    {_DATAF(0.73082458972930908000),  _DATAF(-0.68256533145904541000)},
    {_DATAF(0.73056274652481079000),  _DATAF(-0.68284553289413452000)},
    {_DATAF(0.73030084371566772000),  _DATAF(-0.68312567472457886000)},
    {_DATAF(0.73003882169723511000),  _DATAF(-0.68340569734573364000)},
    {_DATAF(0.72977668046951294000),  _DATAF(-0.68368560075759888000)},
    {_DATAF(0.72951442003250122000),  _DATAF(-0.68396538496017456000)},
    {_DATAF(0.72925209999084473000),  _DATAF(-0.68424510955810547000)},
    {_DATAF(0.72898960113525391000),  _DATAF(-0.68452471494674683000)},
    {_DATAF(0.72872704267501831000),  _DATAF(-0.68480426073074341000)},
    {_DATAF(0.72846436500549316000),  _DATAF(-0.68508368730545044000)},
    {_DATAF(0.72820162773132324000),  _DATAF(-0.68536299467086792000)},
    {_DATAF(0.72793871164321899000),  _DATAF(-0.68564218282699585000)},
    {_DATAF(0.72767573595046997000),  _DATAF(-0.68592131137847900000)},
    {_DATAF(0.72741264104843140000),  _DATAF(-0.68620032072067261000)},
    {_DATAF(0.72714942693710327000),  _DATAF(-0.68647921085357666000)},
    {_DATAF(0.72688609361648560000),  _DATAF(-0.68675804138183594000)},
    {_DATAF(0.72662270069122314000),  _DATAF(-0.68703675270080566000)},
    {_DATAF(0.72635912895202637000),  _DATAF(-0.68731534481048584000)},
    {_DATAF(0.72609549760818481000),  _DATAF(-0.68759381771087646000)},
    {_DATAF(0.72583180665969849000),  _DATAF(-0.68787223100662231000)},
    {_DATAF(0.72556793689727783000),  _DATAF(-0.68815052509307861000)},
    {_DATAF(0.72530394792556763000),  _DATAF(-0.68842875957489014000)},
    {_DATAF(0.72503989934921265000),  _DATAF(-0.68870687484741211000)},
    {_DATAF(0.72477573156356812000),  _DATAF(-0.68898487091064453000)},
    {_DATAF(0.72451144456863403000),  _DATAF(-0.68926274776458740000)},
    {_DATAF(0.72424709796905518000),  _DATAF(-0.68954056501388550000)},
    {_DATAF(0.72398257255554199000),  _DATAF(-0.68981826305389404000)},
    {_DATAF(0.72371798753738403000),  _DATAF(-0.69009584188461304000)},
    {_DATAF(0.72345328330993652000),  _DATAF(-0.69037330150604248000)},
    {_DATAF(0.72318845987319946000),  _DATAF(-0.69065070152282715000)},
    {_DATAF(0.72292357683181763000),  _DATAF(-0.69092798233032227000)},
    {_DATAF(0.72265857458114624000),  _DATAF(-0.69120520353317261000)},
    {_DATAF(0.72239345312118530000),  _DATAF(-0.69148224592208862000)},
    {_DATAF(0.72212821245193481000),  _DATAF(-0.69175922870635986000)},
    {_DATAF(0.72186285257339478000),  _DATAF(-0.69203615188598633000)},
    {_DATAF(0.72159743309020996000),  _DATAF(-0.69231289625167847000)},
    {_DATAF(0.72133183479309082000),  _DATAF(-0.69258958101272583000)},
    {_DATAF(0.72106617689132690000),  _DATAF(-0.69286614656448364000)},
    {_DATAF(0.72080045938491821000),  _DATAF(-0.69314265251159668000)},
    {_DATAF(0.72053456306457520000),  _DATAF(-0.69341903924942017000)},
    {_DATAF(0.72026860713958740000),  _DATAF(-0.69369530677795410000)},
    {_DATAF(0.72000253200531006000),  _DATAF(-0.69397145509719849000)},
    {_DATAF(0.71973633766174316000),  _DATAF(-0.69424754381179810000)},
    {_DATAF(0.71947002410888672000),  _DATAF(-0.69452351331710815000)},
    {_DATAF(0.71920365095138550000),  _DATAF(-0.69479936361312866000)},
    {_DATAF(0.71893709897994995000),  _DATAF(-0.69507509469985962000)},
    {_DATAF(0.71867048740386963000),  _DATAF(-0.69535076618194580000)},
    {_DATAF(0.71840381622314453000),  _DATAF(-0.69562631845474243000)},
    {_DATAF(0.71813696622848511000),  _DATAF(-0.69590175151824951000)},
    {_DATAF(0.71787005662918091000),  _DATAF(-0.69617712497711182000)},
    {_DATAF(0.71760302782058716000),  _DATAF(-0.69645237922668457000)},
    {_DATAF(0.71733587980270386000),  _DATAF(-0.69672751426696777000)},
    {_DATAF(0.71706861257553101000),  _DATAF(-0.69700258970260620000)},
    {_DATAF(0.71680128574371338000),  _DATAF(-0.69727748632431030000)},
    {_DATAF(0.71653383970260620000),  _DATAF(-0.69755232334136963000)},
    {_DATAF(0.71626627445220947000),  _DATAF(-0.69782710075378418000)},
    {_DATAF(0.71599858999252319000),  _DATAF(-0.69810169935226440000)},
    {_DATAF(0.71573084592819214000),  _DATAF(-0.69837623834609985000)},
    {_DATAF(0.71546292304992676000),  _DATAF(-0.69865065813064575000)},
    {_DATAF(0.71519494056701660000),  _DATAF(-0.69892501831054688000)},
    {_DATAF(0.71492689847946167000),  _DATAF(-0.69919919967651367000)},
    {_DATAF(0.71465867757797241000),  _DATAF(-0.69947332143783569000)},
    {_DATAF(0.71439039707183838000),  _DATAF(-0.69974738359451294000)},
    {_DATAF(0.71412199735641479000),  _DATAF(-0.70002126693725586000)},
    {_DATAF(0.71385347843170166000),  _DATAF(-0.70029509067535400000)},
    {_DATAF(0.71358484029769897000),  _DATAF(-0.70056879520416260000)},
    {_DATAF(0.71331614255905151000),  _DATAF(-0.70084238052368164000)},
    {_DATAF(0.71304732561111450000),  _DATAF(-0.70111590623855591000)},
    {_DATAF(0.71277838945388794000),  _DATAF(-0.70138931274414063000)},
    {_DATAF(0.71250939369201660000),  _DATAF(-0.70166260004043579000)},
    {_DATAF(0.71224021911621094000),  _DATAF(-0.70193576812744141000)},
    {_DATAF(0.71197098493576050000),  _DATAF(-0.70220887660980225000)},
    {_DATAF(0.71170163154602051000),  _DATAF(-0.70248186588287354000)},
    {_DATAF(0.71143221855163574000),  _DATAF(-0.70275473594665527000)},
    {_DATAF(0.71116262674331665000),  _DATAF(-0.70302754640579224000)},
    {_DATAF(0.71089297533035278000),  _DATAF(-0.70330017805099487000)},
    {_DATAF(0.71062320470809937000),  _DATAF(-0.70357275009155273000)},
    {_DATAF(0.71035337448120117000),  _DATAF(-0.70384526252746582000)},
    {_DATAF(0.71008336544036865000),  _DATAF(-0.70411759614944458000)},
    {_DATAF(0.70981329679489136000),  _DATAF(-0.70438987016677856000)},
    {_DATAF(0.70954310894012451000),  _DATAF(-0.70466202497482300000)},
    {_DATAF(0.70927280187606812000),  _DATAF(-0.70493406057357788000)},
    {_DATAF(0.70900243520736694000),  _DATAF(-0.70520603656768799000)},
    {_DATAF(0.70873194932937622000),  _DATAF(-0.70547789335250854000)},
    {_DATAF(0.70846134424209595000),  _DATAF(-0.70574963092803955000)},
    {_DATAF(0.70819061994552612000),  _DATAF(-0.70602124929428101000)},
    {_DATAF(0.70791983604431152000),  _DATAF(-0.70629280805587769000)},
    {_DATAF(0.70764893293380737000),  _DATAF(-0.70656424760818481000)},
    {_DATAF(0.70737791061401367000),  _DATAF(-0.70683556795120239000)},
    {_DATAF(0.70710676908493042000),  _DATAF(-0.70710676908493042000)},
    {_DATAF(0.70683556795120239000),  _DATAF(-0.70737791061401367000)},
    {_DATAF(0.70656424760818481000),  _DATAF(-0.70764893293380737000)},
    {_DATAF(0.70629280805587769000),  _DATAF(-0.70791983604431152000)},
    {_DATAF(0.70602124929428101000),  _DATAF(-0.70819061994552612000)},
    {_DATAF(0.70574963092803955000),  _DATAF(-0.70846134424209595000)},
    {_DATAF(0.70547789335250854000),  _DATAF(-0.70873194932937622000)},
    {_DATAF(0.70520603656768799000),  _DATAF(-0.70900243520736694000)},
    {_DATAF(0.70493406057357788000),  _DATAF(-0.70927280187606812000)},
    {_DATAF(0.70466202497482300000),  _DATAF(-0.70954310894012451000)},
    {_DATAF(0.70438987016677856000),  _DATAF(-0.70981329679489136000)},
    {_DATAF(0.70411759614944458000),  _DATAF(-0.71008336544036865000)},
    {_DATAF(0.70384526252746582000),  _DATAF(-0.71035337448120117000)},
    {_DATAF(0.70357275009155273000),  _DATAF(-0.71062320470809937000)},
    {_DATAF(0.70330017805099487000),  _DATAF(-0.71089297533035278000)},
    {_DATAF(0.70302754640579224000),  _DATAF(-0.71116262674331665000)},
    {_DATAF(0.70275473594665527000),  _DATAF(-0.71143221855163574000)},
    {_DATAF(0.70248186588287354000),  _DATAF(-0.71170163154602051000)},
    {_DATAF(0.70220887660980225000),  _DATAF(-0.71197098493576050000)},
    {_DATAF(0.70193576812744141000),  _DATAF(-0.71224021911621094000)},
    {_DATAF(0.70166260004043579000),  _DATAF(-0.71250939369201660000)},
    {_DATAF(0.70138931274414063000),  _DATAF(-0.71277838945388794000)},
    {_DATAF(0.70111590623855591000),  _DATAF(-0.71304732561111450000)},
    {_DATAF(0.70084238052368164000),  _DATAF(-0.71331614255905151000)},
    {_DATAF(0.70056879520416260000),  _DATAF(-0.71358484029769897000)},
    {_DATAF(0.70029509067535400000),  _DATAF(-0.71385347843170166000)},
    {_DATAF(0.70002126693725586000),  _DATAF(-0.71412199735641479000)},
    {_DATAF(0.69974738359451294000),  _DATAF(-0.71439039707183838000)},
    {_DATAF(0.69947332143783569000),  _DATAF(-0.71465867757797241000)},
    {_DATAF(0.69919919967651367000),  _DATAF(-0.71492689847946167000)},
    {_DATAF(0.69892501831054688000),  _DATAF(-0.71519494056701660000)},
    {_DATAF(0.69865065813064575000),  _DATAF(-0.71546292304992676000)},
    {_DATAF(0.69837623834609985000),  _DATAF(-0.71573084592819214000)},
    {_DATAF(0.69810169935226440000),  _DATAF(-0.71599858999252319000)},
    {_DATAF(0.69782710075378418000),  _DATAF(-0.71626627445220947000)},
    {_DATAF(0.69755232334136963000),  _DATAF(-0.71653383970260620000)},
    {_DATAF(0.69727748632431030000),  _DATAF(-0.71680128574371338000)},
    {_DATAF(0.69700258970260620000),  _DATAF(-0.71706861257553101000)},
    {_DATAF(0.69672751426696777000),  _DATAF(-0.71733587980270386000)},
    {_DATAF(0.69645237922668457000),  _DATAF(-0.71760302782058716000)},
    {_DATAF(0.69617712497711182000),  _DATAF(-0.71787005662918091000)},
    {_DATAF(0.69590175151824951000),  _DATAF(-0.71813696622848511000)},
    {_DATAF(0.69562631845474243000),  _DATAF(-0.71840381622314453000)},
    {_DATAF(0.69535076618194580000),  _DATAF(-0.71867048740386963000)},
    {_DATAF(0.69507509469985962000),  _DATAF(-0.71893709897994995000)},
    {_DATAF(0.69479936361312866000),  _DATAF(-0.71920365095138550000)},
    {_DATAF(0.69452351331710815000),  _DATAF(-0.71947002410888672000)},
    {_DATAF(0.69424754381179810000),  _DATAF(-0.71973633766174316000)},
    {_DATAF(0.69397145509719849000),  _DATAF(-0.72000253200531006000)},
    {_DATAF(0.69369530677795410000),  _DATAF(-0.72026860713958740000)},
    {_DATAF(0.69341903924942017000),  _DATAF(-0.72053456306457520000)},
    {_DATAF(0.69314265251159668000),  _DATAF(-0.72080045938491821000)},
    {_DATAF(0.69286614656448364000),  _DATAF(-0.72106617689132690000)},
    {_DATAF(0.69258958101272583000),  _DATAF(-0.72133183479309082000)},
    {_DATAF(0.69231289625167847000),  _DATAF(-0.72159743309020996000)},
    {_DATAF(0.69203615188598633000),  _DATAF(-0.72186285257339478000)},
    {_DATAF(0.69175922870635986000),  _DATAF(-0.72212821245193481000)},
    {_DATAF(0.69148224592208862000),  _DATAF(-0.72239345312118530000)},
    {_DATAF(0.69120520353317261000),  _DATAF(-0.72265857458114624000)},
    {_DATAF(0.69092798233032227000),  _DATAF(-0.72292357683181763000)},
    {_DATAF(0.69065070152282715000),  _DATAF(-0.72318845987319946000)},
    {_DATAF(0.69037330150604248000),  _DATAF(-0.72345328330993652000)},
    {_DATAF(0.69009584188461304000),  _DATAF(-0.72371798753738403000)},
    {_DATAF(0.68981826305389404000),  _DATAF(-0.72398257255554199000)},
    {_DATAF(0.68954056501388550000),  _DATAF(-0.72424709796905518000)},
    {_DATAF(0.68926274776458740000),  _DATAF(-0.72451144456863403000)},
    {_DATAF(0.68898487091064453000),  _DATAF(-0.72477573156356812000)},
    {_DATAF(0.68870687484741211000),  _DATAF(-0.72503989934921265000)},
    {_DATAF(0.68842875957489014000),  _DATAF(-0.72530394792556763000)},
    {_DATAF(0.68815052509307861000),  _DATAF(-0.72556793689727783000)},
    {_DATAF(0.68787223100662231000),  _DATAF(-0.72583180665969849000)},
    {_DATAF(0.68759381771087646000),  _DATAF(-0.72609549760818481000)},
    {_DATAF(0.68731534481048584000),  _DATAF(-0.72635912895202637000)},
    {_DATAF(0.68703675270080566000),  _DATAF(-0.72662270069122314000)},
    {_DATAF(0.68675804138183594000),  _DATAF(-0.72688609361648560000)},
    {_DATAF(0.68647921085357666000),  _DATAF(-0.72714942693710327000)},
    {_DATAF(0.68620032072067261000),  _DATAF(-0.72741264104843140000)},
    {_DATAF(0.68592131137847900000),  _DATAF(-0.72767573595046997000)},
    {_DATAF(0.68564218282699585000),  _DATAF(-0.72793871164321899000)},
    {_DATAF(0.68536299467086792000),  _DATAF(-0.72820162773132324000)},
    {_DATAF(0.68508368730545044000),  _DATAF(-0.72846436500549316000)},
    {_DATAF(0.68480426073074341000),  _DATAF(-0.72872704267501831000)},
    {_DATAF(0.68452471494674683000),  _DATAF(-0.72898960113525391000)},
    {_DATAF(0.68424510955810547000),  _DATAF(-0.72925209999084473000)},
    {_DATAF(0.68396538496017456000),  _DATAF(-0.72951442003250122000)},
    {_DATAF(0.68368560075759888000),  _DATAF(-0.72977668046951294000)},
    {_DATAF(0.68340569734573364000),  _DATAF(-0.73003882169723511000)},
    {_DATAF(0.68312567472457886000),  _DATAF(-0.73030084371566772000)},
    {_DATAF(0.68284553289413452000),  _DATAF(-0.73056274652481079000)},
    {_DATAF(0.68256533145904541000),  _DATAF(-0.73082458972930908000)},
    {_DATAF(0.68228501081466675000),  _DATAF(-0.73108631372451782000)},
    {_DATAF(0.68200457096099854000),  _DATAF(-0.73134791851043701000)},
    {_DATAF(0.68172407150268555000),  _DATAF(-0.73160940408706665000)},
    {_DATAF(0.68144345283508301000),  _DATAF(-0.73187077045440674000)},
    {_DATAF(0.68116271495819092000),  _DATAF(-0.73213201761245728000)},
    {_DATAF(0.68088191747665405000),  _DATAF(-0.73239320516586304000)},
    {_DATAF(0.68060100078582764000),  _DATAF(-0.73265427350997925000)},
    {_DATAF(0.68031996488571167000),  _DATAF(-0.73291522264480591000)},
    {_DATAF(0.68003886938095093000),  _DATAF(-0.73317605257034302000)},
    {_DATAF(0.67975765466690063000),  _DATAF(-0.73343682289123535000)},
    {_DATAF(0.67947632074356079000),  _DATAF(-0.73369741439819336000)},
    {_DATAF(0.67919492721557617000),  _DATAF(-0.73395794630050659000)},
    {_DATAF(0.67891335487365723000),  _DATAF(-0.73421835899353027000)},
    {_DATAF(0.67863178253173828000),  _DATAF(-0.73447865247726440000)},
    {_DATAF(0.67835003137588501000),  _DATAF(-0.73473888635635376000)},
    {_DATAF(0.67806822061538696000),  _DATAF(-0.73499894142150879000)},
    {_DATAF(0.67778629064559937000),  _DATAF(-0.73525893688201904000)},
    {_DATAF(0.67750430107116699000),  _DATAF(-0.73551881313323975000)},
    {_DATAF(0.67722219228744507000),  _DATAF(-0.73577857017517090000)},
    {_DATAF(0.67693996429443359000),  _DATAF(-0.73603826761245728000)},
    {_DATAF(0.67665761709213257000),  _DATAF(-0.73629778623580933000)},
    {_DATAF(0.67637521028518677000),  _DATAF(-0.73655724525451660000)},
    {_DATAF(0.67609268426895142000),  _DATAF(-0.73681658506393433000)},
    {_DATAF(0.67581009864807129000),  _DATAF(-0.73707580566406250000)},
    {_DATAF(0.67552739381790161000),  _DATAF(-0.73733490705490112000)},
    {_DATAF(0.67524456977844238000),  _DATAF(-0.73759388923645020000)},
    {_DATAF(0.67496162652969360000),  _DATAF(-0.73785281181335449000)},
    {_DATAF(0.67467862367630005000),  _DATAF(-0.73811161518096924000)},
    {_DATAF(0.67439550161361694000),  _DATAF(-0.73837029933929443000)},
    {_DATAF(0.67411231994628906000),  _DATAF(-0.73862886428833008000)},
    {_DATAF(0.67382901906967163000),  _DATAF(-0.73888731002807617000)},
    {_DATAF(0.67354559898376465000),  _DATAF(-0.73914569616317749000)},
    {_DATAF(0.67326205968856812000),  _DATAF(-0.73940390348434448000)},
    {_DATAF(0.67297846078872681000),  _DATAF(-0.73966205120086670000)},
    {_DATAF(0.67269474267959595000),  _DATAF(-0.73992007970809937000)},
    {_DATAF(0.67241096496582031000),  _DATAF(-0.74017798900604248000)},
    {_DATAF(0.67212706804275513000),  _DATAF(-0.74043583869934082000)},
    {_DATAF(0.67184305191040039000),  _DATAF(-0.74069350957870483000)},
    {_DATAF(0.67155897617340088000),  _DATAF(-0.74095112085342407000)},
    {_DATAF(0.67127478122711182000),  _DATAF(-0.74120861291885376000)},
    {_DATAF(0.67099046707153320000),  _DATAF(-0.74146598577499390000)},
    {_DATAF(0.67070603370666504000),  _DATAF(-0.74172323942184448000)},
    {_DATAF(0.67042154073715210000),  _DATAF(-0.74198043346405029000)},
    {_DATAF(0.67013698816299438000),  _DATAF(-0.74223744869232178000)},
    {_DATAF(0.66985225677490234000),  _DATAF(-0.74249440431594849000)},
    {_DATAF(0.66956746578216553000),  _DATAF(-0.74275124073028564000)},
    {_DATAF(0.66928261518478394000),  _DATAF(-0.74300795793533325000)},
    {_DATAF(0.66899758577346802000),  _DATAF(-0.74326455593109131000)},
    {_DATAF(0.66871249675750732000),  _DATAF(-0.74352109432220459000)},
    {_DATAF(0.66842734813690186000),  _DATAF(-0.74377745389938354000)},
    {_DATAF(0.66814202070236206000),  _DATAF(-0.74403375387191772000)},
    {_DATAF(0.66785663366317749000),  _DATAF(-0.74428993463516235000)},
    {_DATAF(0.66757118701934814000),  _DATAF(-0.74454599618911743000)},
    {_DATAF(0.66728562116622925000),  _DATAF(-0.74480193853378296000)},
    {_DATAF(0.66699993610382080000),  _DATAF(-0.74505776166915894000)},
    {_DATAF(0.66671413183212280000),  _DATAF(-0.74531352519989014000)},
    {_DATAF(0.66642826795578003000),  _DATAF(-0.74556916952133179000)},
    {_DATAF(0.66614228487014771000),  _DATAF(-0.74582469463348389000)},
    {_DATAF(0.66585624217987061000),  _DATAF(-0.74608010053634644000)},
    {_DATAF(0.66557008028030396000),  _DATAF(-0.74633538722991943000)},
    {_DATAF(0.66528379917144775000),  _DATAF(-0.74659055471420288000)},
    {_DATAF(0.66499745845794678000),  _DATAF(-0.74684566259384155000)},
    {_DATAF(0.66471099853515625000),  _DATAF(-0.74710059165954590000)},
    {_DATAF(0.66442441940307617000),  _DATAF(-0.74735546112060547000)},
    {_DATAF(0.66413778066635132000),  _DATAF(-0.74761021137237549000)},
    {_DATAF(0.66385102272033691000),  _DATAF(-0.74786484241485596000)},
    {_DATAF(0.66356414556503296000),  _DATAF(-0.74811935424804688000)},
    {_DATAF(0.66327720880508423000),  _DATAF(-0.74837380647659302000)},
    {_DATAF(0.66299015283584595000),  _DATAF(-0.74862807989120483000)},
    {_DATAF(0.66270303726196289000),  _DATAF(-0.74888229370117188000)},
    {_DATAF(0.66241580247879028000),  _DATAF(-0.74913638830184937000)},
    {_DATAF(0.66212844848632813000),  _DATAF(-0.74939036369323730000)},
    {_DATAF(0.66184097528457642000),  _DATAF(-0.74964421987533569000)},
    {_DATAF(0.66155344247817993000),  _DATAF(-0.74989801645278931000)},
    {_DATAF(0.66126585006713867000),  _DATAF(-0.75015163421630859000)},
    {_DATAF(0.66097813844680786000),  _DATAF(-0.75040519237518311000)},
    {_DATAF(0.66069030761718750000),  _DATAF(-0.75065863132476807000)},
    {_DATAF(0.66040235757827759000),  _DATAF(-0.75091195106506348000)},
    {_DATAF(0.66011434793472290000),  _DATAF(-0.75116515159606934000)},
    {_DATAF(0.65982621908187866000),  _DATAF(-0.75141823291778564000)},
    {_DATAF(0.65953803062438965000),  _DATAF(-0.75167119503021240000)},
    {_DATAF(0.65924972295761108000),  _DATAF(-0.75192409753799438000)},
    {_DATAF(0.65896129608154297000),  _DATAF(-0.75217682123184204000)},
    {_DATAF(0.65867280960083008000),  _DATAF(-0.75242948532104492000)},
    {_DATAF(0.65838420391082764000),  _DATAF(-0.75268203020095825000)},
    {_DATAF(0.65809547901153564000),  _DATAF(-0.75293445587158203000)},
    {_DATAF(0.65780669450759888000),  _DATAF(-0.75318682193756104000)},
    {_DATAF(0.65751779079437256000),  _DATAF(-0.75343900918960571000)},
    {_DATAF(0.65722882747650146000),  _DATAF(-0.75369113683700562000)},
    {_DATAF(0.65693974494934082000),  _DATAF(-0.75394308567047119000)},
    {_DATAF(0.65665054321289063000),  _DATAF(-0.75419497489929199000)},
    {_DATAF(0.65636128187179565000),  _DATAF(-0.75444674491882324000)},
    {_DATAF(0.65607190132141113000),  _DATAF(-0.75469839572906494000)},
    {_DATAF(0.65578240156173706000),  _DATAF(-0.75494992733001709000)},
    {_DATAF(0.65549284219741821000),  _DATAF(-0.75520139932632446000)},
    {_DATAF(0.65520316362380981000),  _DATAF(-0.75545269250869751000)},
    {_DATAF(0.65491342544555664000),  _DATAF(-0.75570392608642578000)},
    {_DATAF(0.65462356805801392000),  _DATAF(-0.75595504045486450000)},
    {_DATAF(0.65433359146118164000),  _DATAF(-0.75620597600936890000)},
    {_DATAF(0.65404355525970459000),  _DATAF(-0.75645685195922852000)},
    {_DATAF(0.65375339984893799000),  _DATAF(-0.75670766830444336000)},
    {_DATAF(0.65346318483352661000),  _DATAF(-0.75695830583572388000)},
    {_DATAF(0.65317285060882568000),  _DATAF(-0.75720882415771484000)},
    {_DATAF(0.65288239717483521000),  _DATAF(-0.75745928287506104000)},
    {_DATAF(0.65259188413619995000),  _DATAF(-0.75770962238311768000)},
    {_DATAF(0.65230125188827515000),  _DATAF(-0.75795978307723999000)},
    {_DATAF(0.65201056003570557000),  _DATAF(-0.75820988416671753000)},
    {_DATAF(0.65171968936920166000),  _DATAF(-0.75845992565155029000)},
    {_DATAF(0.65142881870269775000),  _DATAF(-0.75870978832244873000)},
    {_DATAF(0.65113776922225952000),  _DATAF(-0.75895953178405762000)},
    {_DATAF(0.65084666013717651000),  _DATAF(-0.75920921564102173000)},
    {_DATAF(0.65055549144744873000),  _DATAF(-0.75945872068405151000)},
    {_DATAF(0.65026420354843140000),  _DATAF(-0.75970816612243652000)},
    {_DATAF(0.64997279644012451000),  _DATAF(-0.75995749235153198000)},
    {_DATAF(0.64968132972717285000),  _DATAF(-0.76020669937133789000)},
    {_DATAF(0.64938974380493164000),  _DATAF(-0.76045578718185425000)},
    {_DATAF(0.64909803867340088000),  _DATAF(-0.76070475578308105000)},
    {_DATAF(0.64880627393722534000),  _DATAF(-0.76095360517501831000)},
    {_DATAF(0.64851438999176025000),  _DATAF(-0.76120239496231079000)},
    {_DATAF(0.64822244644165039000),  _DATAF(-0.76145100593566895000)},
    {_DATAF(0.64793038368225098000),  _DATAF(-0.76169955730438232000)},
    {_DATAF(0.64763820171356201000),  _DATAF(-0.76194798946380615000)},
    {_DATAF(0.64734596014022827000),  _DATAF(-0.76219630241394043000)},
    {_DATAF(0.64705359935760498000),  _DATAF(-0.76244449615478516000)},
    {_DATAF(0.64676117897033691000),  _DATAF(-0.76269257068634033000)},
    {_DATAF(0.64646863937377930000),  _DATAF(-0.76294052600860596000)},
    {_DATAF(0.64617604017257690000),  _DATAF(-0.76318842172622681000)},
    {_DATAF(0.64588326215744019000),  _DATAF(-0.76343613862991333000)},
    {_DATAF(0.64559048414230347000),  _DATAF(-0.76368379592895508000)},
    {_DATAF(0.64529752731323242000),  _DATAF(-0.76393133401870728000)},
    {_DATAF(0.64500451087951660000),  _DATAF(-0.76417875289916992000)},
    {_DATAF(0.64471143484115601000),  _DATAF(-0.76442605257034302000)},
    {_DATAF(0.64441823959350586000),  _DATAF(-0.76467323303222656000)},
    {_DATAF(0.64412492513656616000),  _DATAF(-0.76492029428482056000)},
    {_DATAF(0.64383155107498169000),  _DATAF(-0.76516723632812500000)},
    {_DATAF(0.64353805780410767000),  _DATAF(-0.76541411876678467000)},
    {_DATAF(0.64324450492858887000),  _DATAF(-0.76566088199615479000)},
    {_DATAF(0.64295083284378052000),  _DATAF(-0.76590746641159058000)},
    {_DATAF(0.64265704154968262000),  _DATAF(-0.76615399122238159000)},
    {_DATAF(0.64236319065093994000),  _DATAF(-0.76640039682388306000)},
    {_DATAF(0.64206922054290771000),  _DATAF(-0.76664668321609497000)},
    {_DATAF(0.64177513122558594000),  _DATAF(-0.76689285039901733000)},
    {_DATAF(0.64148104190826416000),  _DATAF(-0.76713889837265015000)},
    {_DATAF(0.64118677377700806000),  _DATAF(-0.76738488674163818000)},
    {_DATAF(0.64089244604110718000),  _DATAF(-0.76763069629669189000)},
    {_DATAF(0.64059799909591675000),  _DATAF(-0.76787644624710083000)},
    {_DATAF(0.64030349254608154000),  _DATAF(-0.76812201738357544000)},
    {_DATAF(0.64000886678695679000),  _DATAF(-0.76836752891540527000)},
    {_DATAF(0.63971418142318726000),  _DATAF(-0.76861292123794556000)},
    {_DATAF(0.63941931724548340000),  _DATAF(-0.76885819435119629000)},
    {_DATAF(0.63912445306777954000),  _DATAF(-0.76910334825515747000)},
    {_DATAF(0.63882946968078613000),  _DATAF(-0.76934838294982910000)},
    {_DATAF(0.63853436708450317000),  _DATAF(-0.76959329843521118000)},
    {_DATAF(0.63823920488357544000),  _DATAF(-0.76983815431594849000)},
    {_DATAF(0.63794392347335815000),  _DATAF(-0.77008283138275146000)},
    {_DATAF(0.63764852285385132000),  _DATAF(-0.77032744884490967000)},
    {_DATAF(0.63735306262969971000),  _DATAF(-0.77057188749313354000)},
    {_DATAF(0.63705748319625854000),  _DATAF(-0.77081626653671265000)},
    {_DATAF(0.63676184415817261000),  _DATAF(-0.77106052637100220000)},
    {_DATAF(0.63646614551544189000),  _DATAF(-0.77130466699600220000)},
    {_DATAF(0.63617026805877686000),  _DATAF(-0.77154868841171265000)},
    {_DATAF(0.63587433099746704000),  _DATAF(-0.77179259061813354000)},
    {_DATAF(0.63557833433151245000),  _DATAF(-0.77203637361526489000)},
    {_DATAF(0.63528221845626831000),  _DATAF(-0.77228009700775146000)},
    {_DATAF(0.63498598337173462000),  _DATAF(-0.77252364158630371000)},
    {_DATAF(0.63468968868255615000),  _DATAF(-0.77276712656021118000)},
    {_DATAF(0.63439327478408813000),  _DATAF(-0.77301043272018433000)},
    {_DATAF(0.63409680128097534000),  _DATAF(-0.77325367927551270000)},
    {_DATAF(0.63380020856857300000),  _DATAF(-0.77349680662155151000)},
    {_DATAF(0.63350355625152588000),  _DATAF(-0.77373981475830078000)},
    {_DATAF(0.63320678472518921000),  _DATAF(-0.77398270368576050000)},
    {_DATAF(0.63290989398956299000),  _DATAF(-0.77422547340393066000)},
    {_DATAF(0.63261294364929199000),  _DATAF(-0.77446812391281128000)},
    {_DATAF(0.63231587409973145000),  _DATAF(-0.77471065521240234000)},
    {_DATAF(0.63201874494552612000),  _DATAF(-0.77495312690734863000)},
    {_DATAF(0.63172149658203125000),  _DATAF(-0.77519541978836060000)},
    {_DATAF(0.63142418861389160000),  _DATAF(-0.77543765306472778000)},
    {_DATAF(0.63112676143646240000),  _DATAF(-0.77567970752716064000)},
    {_DATAF(0.63082921504974365000),  _DATAF(-0.77592170238494873000)},
    {_DATAF(0.63053160905838013000),  _DATAF(-0.77616357803344727000)},
    {_DATAF(0.63023394346237183000),  _DATAF(-0.77640533447265625000)},
    {_DATAF(0.62993609905242920000),  _DATAF(-0.77664697170257568000)},
    {_DATAF(0.62963825464248657000),  _DATAF(-0.77688848972320557000)},
    {_DATAF(0.62934023141860962000),  _DATAF(-0.77712988853454590000)},
    {_DATAF(0.62904220819473267000),  _DATAF(-0.77737116813659668000)},
    {_DATAF(0.62874400615692139000),  _DATAF(-0.77761232852935791000)},
    {_DATAF(0.62844574451446533000),  _DATAF(-0.77785342931747437000)},
    {_DATAF(0.62814742326736450000),  _DATAF(-0.77809435129165649000)},
    {_DATAF(0.62784898281097412000),  _DATAF(-0.77833521366119385000)},
    {_DATAF(0.62755042314529419000),  _DATAF(-0.77857589721679688000)},
    {_DATAF(0.62725180387496948000),  _DATAF(-0.77881652116775513000)},
    {_DATAF(0.62695312500000000000),  _DATAF(-0.77905702590942383000)},
    {_DATAF(0.62665426731109619000),  _DATAF(-0.77929735183715820000)},
    {_DATAF(0.62635540962219238000),  _DATAF(-0.77953761816024780000)},
    {_DATAF(0.62605637311935425000),  _DATAF(-0.77977776527404785000)},
    {_DATAF(0.62575727701187134000),  _DATAF(-0.78001779317855835000)},
    {_DATAF(0.62545812129974365000),  _DATAF(-0.78025776147842407000)},
    {_DATAF(0.62515884637832642000),  _DATAF(-0.78049755096435547000)},
    {_DATAF(0.62485951185226440000),  _DATAF(-0.78073722124099731000)},
    {_DATAF(0.62456005811691284000),  _DATAF(-0.78097677230834961000)},
    {_DATAF(0.62426048517227173000),  _DATAF(-0.78121626377105713000)},
    {_DATAF(0.62396085262298584000),  _DATAF(-0.78145557641983032000)},
    {_DATAF(0.62366110086441040000),  _DATAF(-0.78169482946395874000)},
    {_DATAF(0.62336128950119019000),  _DATAF(-0.78193396329879761000)},
    {_DATAF(0.62306135892868042000),  _DATAF(-0.78217291831970215000)},
    {_DATAF(0.62276136875152588000),  _DATAF(-0.78241181373596191000)},
    {_DATAF(0.62246125936508179000),  _DATAF(-0.78265058994293213000)},
    {_DATAF(0.62216109037399292000),  _DATAF(-0.78288924694061279000)},
    {_DATAF(0.62186080217361450000),  _DATAF(-0.78312778472900391000)},
    {_DATAF(0.62156045436859131000),  _DATAF(-0.78336620330810547000)},
    {_DATAF(0.62125998735427856000),  _DATAF(-0.78360450267791748000)},
    {_DATAF(0.62095940113067627000),  _DATAF(-0.78384268283843994000)},
    {_DATAF(0.62065875530242920000),  _DATAF(-0.78408080339431763000)},
    {_DATAF(0.62035804986953735000),  _DATAF(-0.78431874513626099000)},
    {_DATAF(0.62005722522735596000),  _DATAF(-0.78455656766891479000)},
    {_DATAF(0.61975628137588501000),  _DATAF(-0.78479433059692383000)},
    {_DATAF(0.61945527791976929000),  _DATAF(-0.78503191471099854000)},
    {_DATAF(0.61915415525436401000),  _DATAF(-0.78526943922042847000)},
    {_DATAF(0.61885297298431396000),  _DATAF(-0.78550684452056885000)},
    {_DATAF(0.61855173110961914000),  _DATAF(-0.78574407100677490000)},
    {_DATAF(0.61825031042098999000),  _DATAF(-0.78598123788833618000)},
    {_DATAF(0.61794888973236084000),  _DATAF(-0.78621828556060791000)},
    {_DATAF(0.61764729022979736000),  _DATAF(-0.78645521402359009000)},
    {_DATAF(0.61734563112258911000),  _DATAF(-0.78669202327728271000)},
    {_DATAF(0.61704391241073608000),  _DATAF(-0.78692871332168579000)},
    {_DATAF(0.61674207448959351000),  _DATAF(-0.78716528415679932000)},
    {_DATAF(0.61644017696380615000),  _DATAF(-0.78740173578262329000)},
    {_DATAF(0.61613816022872925000),  _DATAF(-0.78763806819915771000)},
    {_DATAF(0.61583608388900757000),  _DATAF(-0.78787434101104736000)},
    {_DATAF(0.61553388833999634000),  _DATAF(-0.78811043500900269000)},
    {_DATAF(0.61523157358169556000),  _DATAF(-0.78834640979766846000)},
    {_DATAF(0.61492919921875000000),  _DATAF(-0.78858232498168945000)},
    {_DATAF(0.61462676525115967000),  _DATAF(-0.78881806135177612000)},
    {_DATAF(0.61432421207427979000),  _DATAF(-0.78905373811721802000)},
    {_DATAF(0.61402153968811035000),  _DATAF(-0.78928923606872559000)},
    {_DATAF(0.61371880769729614000),  _DATAF(-0.78952467441558838000)},
    {_DATAF(0.61341601610183716000),  _DATAF(-0.78975999355316162000)},
    {_DATAF(0.61311310529708862000),  _DATAF(-0.78999513387680054000)},
    {_DATAF(0.61281007528305054000),  _DATAF(-0.79023021459579468000)},
    {_DATAF(0.61250698566436768000),  _DATAF(-0.79046517610549927000)},
    {_DATAF(0.61220377683639526000),  _DATAF(-0.79070001840591431000)},
    {_DATAF(0.61190050840377808000),  _DATAF(-0.79093474149703979000)},
    {_DATAF(0.61159718036651611000),  _DATAF(-0.79116934537887573000)},
    {_DATAF(0.61129373311996460000),  _DATAF(-0.79140383005142212000)},
    {_DATAF(0.61099016666412354000),  _DATAF(-0.79163819551467896000)},
    {_DATAF(0.61068654060363770000),  _DATAF(-0.79187244176864624000)},
    {_DATAF(0.61038279533386230000),  _DATAF(-0.79210656881332397000)},
    {_DATAF(0.61007899045944214000),  _DATAF(-0.79234057664871216000)},
    {_DATAF(0.60977506637573242000),  _DATAF(-0.79257452487945557000)},
    {_DATAF(0.60947108268737793000),  _DATAF(-0.79280829429626465000)},
    {_DATAF(0.60916703939437866000),  _DATAF(-0.79304194450378418000)},
    {_DATAF(0.60886281728744507000),  _DATAF(-0.79327553510665894000)},
    {_DATAF(0.60855859518051147000),  _DATAF(-0.79350894689559937000)},
    {_DATAF(0.60825425386428833000),  _DATAF(-0.79374229907989502000)},
    {_DATAF(0.60794979333877563000),  _DATAF(-0.79397547245025635000)},
    {_DATAF(0.60764527320861816000),  _DATAF(-0.79420858621597290000)},
    {_DATAF(0.60734063386917114000),  _DATAF(-0.79444152116775513000)},
    {_DATAF(0.60703593492507935000),  _DATAF(-0.79467439651489258000)},
    {_DATAF(0.60673111677169800000),  _DATAF(-0.79490715265274048000)},
    {_DATAF(0.60642623901367188000),  _DATAF(-0.79513972997665405000)},
    {_DATAF(0.60612124204635620000),  _DATAF(-0.79537224769592285000)},
    {_DATAF(0.60581618547439575000),  _DATAF(-0.79560464620590210000)},
    {_DATAF(0.60551106929779053000),  _DATAF(-0.79583692550659180000)},
    {_DATAF(0.60520577430725098000),  _DATAF(-0.79606908559799194000)},
    {_DATAF(0.60490047931671143000),  _DATAF(-0.79630106687545776000)},
    {_DATAF(0.60459506511688232000),  _DATAF(-0.79653298854827881000)},
    {_DATAF(0.60428953170776367000),  _DATAF(-0.79676479101181030000)},
    {_DATAF(0.60398393869400024000),  _DATAF(-0.79699647426605225000)},
    {_DATAF(0.60367822647094727000),  _DATAF(-0.79722803831100464000)},
    {_DATAF(0.60337245464324951000),  _DATAF(-0.79745948314666748000)},
    {_DATAF(0.60306662321090698000),  _DATAF(-0.79769086837768555000)},
    {_DATAF(0.60276067256927490000),  _DATAF(-0.79792207479476929000)},
    {_DATAF(0.60245460271835327000),  _DATAF(-0.79815316200256348000)},
    {_DATAF(0.60214847326278687000),  _DATAF(-0.79838413000106812000)},
    {_DATAF(0.60184222459793091000),  _DATAF(-0.79861497879028320000)},
    {_DATAF(0.60153591632843018000),  _DATAF(-0.79884576797485352000)},
    {_DATAF(0.60122954845428467000),  _DATAF(-0.79907637834548950000)},
    {_DATAF(0.60092306137084961000),  _DATAF(-0.79930686950683594000)},
    {_DATAF(0.60061645507812500000),  _DATAF(-0.79953724145889282000)},
    {_DATAF(0.60030978918075562000),  _DATAF(-0.79976755380630493000)},
    {_DATAF(0.60000306367874146000),  _DATAF(-0.79999768733978271000)},
    {_DATAF(0.59969621896743774000),  _DATAF(-0.80022776126861572000)},
    {_DATAF(0.59938931465148926000),  _DATAF(-0.80045765638351440000)},
    {_DATAF(0.59908229112625122000),  _DATAF(-0.80068749189376831000)},
    {_DATAF(0.59877520799636841000),  _DATAF(-0.80091714859008789000)},
    {_DATAF(0.59846800565719604000),  _DATAF(-0.80114674568176270000)},
    {_DATAF(0.59816068410873413000),  _DATAF(-0.80137616395950317000)},
    {_DATAF(0.59785336256027222000),  _DATAF(-0.80160552263259888000)},
    {_DATAF(0.59754586219787598000),  _DATAF(-0.80183470249176025000)},
    {_DATAF(0.59723836183547974000),  _DATAF(-0.80206382274627686000)},
    {_DATAF(0.59693068265914917000),  _DATAF(-0.80229282379150391000)},
    {_DATAF(0.59662300348281860000),  _DATAF(-0.80252164602279663000)},
    {_DATAF(0.59631520509719849000),  _DATAF(-0.80275040864944458000)},
    {_DATAF(0.59600728750228882000),  _DATAF(-0.80297905206680298000)},
    {_DATAF(0.59569931030273438000),  _DATAF(-0.80320751667022705000)},
    {_DATAF(0.59539121389389038000),  _DATAF(-0.80343592166900635000)},
    {_DATAF(0.59508305788040161000),  _DATAF(-0.80366420745849609000)},
    {_DATAF(0.59477484226226807000),  _DATAF(-0.80389231443405151000)},
    {_DATAF(0.59446650743484497000),  _DATAF(-0.80412036180496216000)},
    {_DATAF(0.59415805339813232000),  _DATAF(-0.80434828996658325000)},
    {_DATAF(0.59384959936141968000),  _DATAF(-0.80457609891891479000)},
    {_DATAF(0.59354096651077271000),  _DATAF(-0.80480378866195679000)},
    {_DATAF(0.59323227405548096000),  _DATAF(-0.80503135919570923000)},
    {_DATAF(0.59292352199554443000),  _DATAF(-0.80525875091552734000)},
    {_DATAF(0.59261465072631836000),  _DATAF(-0.80548608303070068000)},
    {_DATAF(0.59230571985244751000),  _DATAF(-0.80571329593658447000)},
    {_DATAF(0.59199666976928711000),  _DATAF(-0.80594038963317871000)},
    {_DATAF(0.59168756008148193000),  _DATAF(-0.80616736412048340000)},
    {_DATAF(0.59137839078903198000),  _DATAF(-0.80639421939849854000)},
    {_DATAF(0.59106910228729248000),  _DATAF(-0.80662095546722412000)},
    {_DATAF(0.59075969457626343000),  _DATAF(-0.80684757232666016000)},
    {_DATAF(0.59045022726058960000),  _DATAF(-0.80707406997680664000)},
    {_DATAF(0.59014070034027100000),  _DATAF(-0.80730044841766357000)},
    {_DATAF(0.58983105421066284000),  _DATAF(-0.80752670764923096000)},
    {_DATAF(0.58952128887176514000),  _DATAF(-0.80775284767150879000)},
    {_DATAF(0.58921152353286743000),  _DATAF(-0.80797880887985229000)},
    {_DATAF(0.58890157938003540000),  _DATAF(-0.80820471048355103000)},
    {_DATAF(0.58859163522720337000),  _DATAF(-0.80843049287796021000)},
    {_DATAF(0.58828157186508179000),  _DATAF(-0.80865615606307983000)},
    {_DATAF(0.58797138929367065000),  _DATAF(-0.80888170003890991000)},
    {_DATAF(0.58766114711761475000),  _DATAF(-0.80910712480545044000)},
    {_DATAF(0.58735078573226929000),  _DATAF(-0.80933243036270142000)},
    {_DATAF(0.58704036474227905000),  _DATAF(-0.80955761671066284000)},
    {_DATAF(0.58672988414764404000),  _DATAF(-0.80978268384933472000)},
    {_DATAF(0.58641928434371948000),  _DATAF(-0.81000763177871704000)},
    {_DATAF(0.58610862493515015000),  _DATAF(-0.81023246049880981000)},
    {_DATAF(0.58579784631729126000),  _DATAF(-0.81045717000961304000)},
    {_DATAF(0.58548700809478760000),  _DATAF(-0.81068176031112671000)},
    {_DATAF(0.58517605066299438000),  _DATAF(-0.81090623140335083000)},
    {_DATAF(0.58486503362655640000),  _DATAF(-0.81113064289093018000)},
    {_DATAF(0.58455395698547363000),  _DATAF(-0.81135487556457520000)},
    {_DATAF(0.58424276113510132000),  _DATAF(-0.81157898902893066000)},
    {_DATAF(0.58393144607543945000),  _DATAF(-0.81180298328399658000)},
    {_DATAF(0.58362013101577759000),  _DATAF(-0.81202685832977295000)},
    {_DATAF(0.58330863714218140000),  _DATAF(-0.81225061416625977000)},
    {_DATAF(0.58299714326858521000),  _DATAF(-0.81247425079345703000)},
    {_DATAF(0.58268547058105469000),  _DATAF(-0.81269776821136475000)},
    {_DATAF(0.58237379789352417000),  _DATAF(-0.81292116641998291000)},
    {_DATAF(0.58206200599670410000),  _DATAF(-0.81314438581466675000)},
    {_DATAF(0.58175009489059448000),  _DATAF(-0.81336754560470581000)},
    {_DATAF(0.58143812417984009000),  _DATAF(-0.81359058618545532000)},
    {_DATAF(0.58112609386444092000),  _DATAF(-0.81381350755691528000)},
    {_DATAF(0.58081394433975220000),  _DATAF(-0.81403630971908569000)},
    {_DATAF(0.58050173521041870000),  _DATAF(-0.81425899267196655000)},
    {_DATAF(0.58018940687179565000),  _DATAF(-0.81448155641555786000)},
    {_DATAF(0.57987701892852783000),  _DATAF(-0.81470400094985962000)},
    {_DATAF(0.57956457138061523000),  _DATAF(-0.81492632627487183000)},
    {_DATAF(0.57925200462341309000),  _DATAF(-0.81514853239059448000)},
    {_DATAF(0.57893931865692139000),  _DATAF(-0.81537061929702759000)},
    {_DATAF(0.57862663269042969000),  _DATAF(-0.81559258699417114000)},
    {_DATAF(0.57831376791000366000),  _DATAF(-0.81581443548202515000)},
    {_DATAF(0.57800090312957764000),  _DATAF(-0.81603610515594482000)},
    {_DATAF(0.57768791913986206000),  _DATAF(-0.81625771522521973000)},
    {_DATAF(0.57737481594085693000),  _DATAF(-0.81647920608520508000)},
    {_DATAF(0.57706165313720703000),  _DATAF(-0.81670057773590088000)},
    {_DATAF(0.57674843072891235000),  _DATAF(-0.81692183017730713000)},
    {_DATAF(0.57643508911132813000),  _DATAF(-0.81714290380477905000)},
    {_DATAF(0.57612168788909912000),  _DATAF(-0.81736391782760620000)},
    {_DATAF(0.57580816745758057000),  _DATAF(-0.81758481264114380000)},
    {_DATAF(0.57549458742141724000),  _DATAF(-0.81780558824539185000)},
    {_DATAF(0.57518094778060913000),  _DATAF(-0.81802618503570557000)},
    {_DATAF(0.57486718893051147000),  _DATAF(-0.81824672222137451000)},
    {_DATAF(0.57455337047576904000),  _DATAF(-0.81846714019775391000)},
    {_DATAF(0.57423943281173706000),  _DATAF(-0.81868737936019897000)},
    {_DATAF(0.57392543554306030000),  _DATAF(-0.81890755891799927000)},
    {_DATAF(0.57361131906509399000),  _DATAF(-0.81912761926651001000)},
    {_DATAF(0.57329714298248291000),  _DATAF(-0.81934750080108643000)},
    {_DATAF(0.57298290729522705000),  _DATAF(-0.81956732273101807000)},
    {_DATAF(0.57266855239868164000),  _DATAF(-0.81978696584701538000)},
    {_DATAF(0.57235413789749146000),  _DATAF(-0.82000654935836792000)},
    {_DATAF(0.57203960418701172000),  _DATAF(-0.82022595405578613000)},
    {_DATAF(0.57172501087188721000),  _DATAF(-0.82044529914855957000)},
    {_DATAF(0.57141035795211792000),  _DATAF(-0.82066446542739868000)},
    {_DATAF(0.57109558582305908000),  _DATAF(-0.82088357210159302000)},
    {_DATAF(0.57078075408935547000),  _DATAF(-0.82110249996185303000)},
    {_DATAF(0.57046580314636230000),  _DATAF(-0.82132136821746826000)},
    {_DATAF(0.57015079259872437000),  _DATAF(-0.82154005765914917000)},
    {_DATAF(0.56983572244644165000),  _DATAF(-0.82175862789154053000)},
    {_DATAF(0.56952053308486938000),  _DATAF(-0.82197713851928711000)},
    {_DATAF(0.56920522451400757000),  _DATAF(-0.82219547033309937000)},
    {_DATAF(0.56888991594314575000),  _DATAF(-0.82241368293762207000)},
    {_DATAF(0.56857448816299438000),  _DATAF(-0.82263177633285522000)},
    {_DATAF(0.56825894117355347000),  _DATAF(-0.82284981012344360000)},
    {_DATAF(0.56794333457946777000),  _DATAF(-0.82306766510009766000)},
    {_DATAF(0.56762766838073730000),  _DATAF(-0.82328540086746216000)},
    {_DATAF(0.56731188297271729000),  _DATAF(-0.82350301742553711000)},
    {_DATAF(0.56699603796005249000),  _DATAF(-0.82372051477432251000)},
    {_DATAF(0.56668013334274292000),  _DATAF(-0.82393789291381836000)},
    {_DATAF(0.56636410951614380000),  _DATAF(-0.82415515184402466000)},
    {_DATAF(0.56604796648025513000),  _DATAF(-0.82437229156494141000)},
    {_DATAF(0.56573182344436646000),  _DATAF(-0.82458931207656860000)},
    {_DATAF(0.56541556119918823000),  _DATAF(-0.82480621337890625000)},
    {_DATAF(0.56509917974472046000),  _DATAF(-0.82502299547195435000)},
    {_DATAF(0.56478273868560791000),  _DATAF(-0.82523959875106812000)},
    {_DATAF(0.56446623802185059000),  _DATAF(-0.82545614242553711000)},
    {_DATAF(0.56414961814880371000),  _DATAF(-0.82567256689071655000)},
    {_DATAF(0.56383293867111206000),  _DATAF(-0.82588887214660645000)},
    {_DATAF(0.56351619958877563000),  _DATAF(-0.82610499858856201000)},
    {_DATAF(0.56319934129714966000),  _DATAF(-0.82632106542587280000)},
    {_DATAF(0.56288242340087891000),  _DATAF(-0.82653701305389404000)},
    {_DATAF(0.56256538629531860000),  _DATAF(-0.82675278186798096000)},
    {_DATAF(0.56224828958511353000),  _DATAF(-0.82696849107742310000)},
    {_DATAF(0.56193113327026367000),  _DATAF(-0.82718402147293091000)},
    {_DATAF(0.56161385774612427000),  _DATAF(-0.82739949226379395000)},
    {_DATAF(0.56129652261734009000),  _DATAF(-0.82761478424072266000)},
    {_DATAF(0.56097906827926636000),  _DATAF(-0.82782995700836182000)},
    {_DATAF(0.56066155433654785000),  _DATAF(-0.82804507017135620000)},
    {_DATAF(0.56034398078918457000),  _DATAF(-0.82826000452041626000)},
    {_DATAF(0.56002628803253174000),  _DATAF(-0.82847481966018677000)},
    {_DATAF(0.55970853567123413000),  _DATAF(-0.82868951559066772000)},
    {_DATAF(0.55939072370529175000),  _DATAF(-0.82890409231185913000)},
    {_DATAF(0.55907279253005981000),  _DATAF(-0.82911854982376099000)},
    {_DATAF(0.55875480175018311000),  _DATAF(-0.82933294773101807000)},
    {_DATAF(0.55843669176101685000),  _DATAF(-0.82954710721969604000)},
    {_DATAF(0.55811852216720581000),  _DATAF(-0.82976120710372925000)},
    {_DATAF(0.55780029296875000000),  _DATAF(-0.82997518777847290000)},
    {_DATAF(0.55748194456100464000),  _DATAF(-0.83018904924392700000)},
    {_DATAF(0.55716353654861450000),  _DATAF(-0.83040279150009155000)},
    {_DATAF(0.55684500932693481000),  _DATAF(-0.83061641454696655000)},
    {_DATAF(0.55652648210525513000),  _DATAF(-0.83082985877990723000)},
    {_DATAF(0.55620777606964111000),  _DATAF(-0.83104324340820313000)},
    {_DATAF(0.55588907003402710000),  _DATAF(-0.83125650882720947000)},
    {_DATAF(0.55557024478912354000),  _DATAF(-0.83146959543228149000)},
    {_DATAF(0.55525130033493042000),  _DATAF(-0.83168262243270874000)},
    {_DATAF(0.55493235588073730000),  _DATAF(-0.83189547061920166000)},
    {_DATAF(0.55461329221725464000),  _DATAF(-0.83210825920104980000)},
    {_DATAF(0.55429410934448242000),  _DATAF(-0.83232086896896362000)},
    {_DATAF(0.55397486686706543000),  _DATAF(-0.83253335952758789000)},
    {_DATAF(0.55365556478500366000),  _DATAF(-0.83274579048156738000)},
    {_DATAF(0.55333620309829712000),  _DATAF(-0.83295804262161255000)},
    {_DATAF(0.55301672220230103000),  _DATAF(-0.83317017555236816000)},
    {_DATAF(0.55269712209701538000),  _DATAF(-0.83338218927383423000)},
    {_DATAF(0.55237752199172974000),  _DATAF(-0.83359408378601074000)},
    {_DATAF(0.55205780267715454000),  _DATAF(-0.83380585908889771000)},
    {_DATAF(0.55173796415328979000),  _DATAF(-0.83401751518249512000)},
    {_DATAF(0.55141812562942505000),  _DATAF(-0.83422905206680298000)},
    {_DATAF(0.55109816789627075000),  _DATAF(-0.83444041013717651000)},
    {_DATAF(0.55077809095382690000),  _DATAF(-0.83465170860290527000)},
    {_DATAF(0.55045795440673828000),  _DATAF(-0.83486288785934448000)},
    {_DATAF(0.55013775825500488000),  _DATAF(-0.83507388830184937000)},
    {_DATAF(0.54981750249862671000),  _DATAF(-0.83528482913970947000)},
    {_DATAF(0.54949712753295898000),  _DATAF(-0.83549559116363525000)},
    {_DATAF(0.54917663335800171000),  _DATAF(-0.83570629358291626000)},
    {_DATAF(0.54885613918304443000),  _DATAF(-0.83591681718826294000)},
    {_DATAF(0.54853552579879761000),  _DATAF(-0.83612728118896484000)},
    {_DATAF(0.54821485280990601000),  _DATAF(-0.83633756637573242000)},
    {_DATAF(0.54789406061172485000),  _DATAF(-0.83654773235321045000)},
    {_DATAF(0.54757320880889893000),  _DATAF(-0.83675777912139893000)},
    {_DATAF(0.54725229740142822000),  _DATAF(-0.83696770668029785000)},
    {_DATAF(0.54693126678466797000),  _DATAF(-0.83717751502990723000)},
    {_DATAF(0.54661017656326294000),  _DATAF(-0.83738720417022705000)},
    {_DATAF(0.54628896713256836000),  _DATAF(-0.83759677410125732000)},
    {_DATAF(0.54596775770187378000),  _DATAF(-0.83780622482299805000)},
    {_DATAF(0.54564642906188965000),  _DATAF(-0.83801549673080444000)},
    {_DATAF(0.54532498121261597000),  _DATAF(-0.83822470903396606000)},
    {_DATAF(0.54500347375869751000),  _DATAF(-0.83843380212783813000)},
    {_DATAF(0.54468190670013428000),  _DATAF(-0.83864271640777588000)},
    {_DATAF(0.54436028003692627000),  _DATAF(-0.83885151147842407000)},
    {_DATAF(0.54403853416442871000),  _DATAF(-0.83906024694442749000)},
    {_DATAF(0.54371672868728638000),  _DATAF(-0.83926880359649658000)},
    {_DATAF(0.54339480400085449000),  _DATAF(-0.83947724103927612000)},
    {_DATAF(0.54307281970977783000),  _DATAF(-0.83968561887741089000)},
    {_DATAF(0.54275077581405640000),  _DATAF(-0.83989381790161133000)},
    {_DATAF(0.54242867231369019000),  _DATAF(-0.84010189771652222000)},
    {_DATAF(0.54210644960403442000),  _DATAF(-0.84030985832214355000)},
    {_DATAF(0.54178416728973389000),  _DATAF(-0.84051764011383057000)},
    {_DATAF(0.54146176576614380000),  _DATAF(-0.84072536230087280000)},
    {_DATAF(0.54113930463790894000),  _DATAF(-0.84093296527862549000)},
    {_DATAF(0.54081678390502930000),  _DATAF(-0.84114044904708862000)},
    {_DATAF(0.54049414396286011000),  _DATAF(-0.84134775400161743000)},
    {_DATAF(0.54017144441604614000),  _DATAF(-0.84155499935150146000)},
    {_DATAF(0.53984868526458740000),  _DATAF(-0.84176206588745117000)},
    {_DATAF(0.53952586650848389000),  _DATAF(-0.84196901321411133000)},
    {_DATAF(0.53920292854309082000),  _DATAF(-0.84217590093612671000)},
    {_DATAF(0.53887993097305298000),  _DATAF(-0.84238260984420776000)},
    {_DATAF(0.53855681419372559000),  _DATAF(-0.84258919954299927000)},
    {_DATAF(0.53823363780975342000),  _DATAF(-0.84279567003250122000)},
    {_DATAF(0.53791040182113647000),  _DATAF(-0.84300202131271362000)},
    {_DATAF(0.53758704662322998000),  _DATAF(-0.84320825338363647000)},
    {_DATAF(0.53726369142532349000),  _DATAF(-0.84341436624526978000)},
    {_DATAF(0.53694015741348267000),  _DATAF(-0.84362030029296875000)},
    {_DATAF(0.53661662340164185000),  _DATAF(-0.84382617473602295000)},
    {_DATAF(0.53629297018051147000),  _DATAF(-0.84403187036514282000)},
    {_DATAF(0.53596925735473633000),  _DATAF(-0.84423750638961792000)},
    {_DATAF(0.53564548492431641000),  _DATAF(-0.84444296360015869000)},
    {_DATAF(0.53532159328460693000),  _DATAF(-0.84464836120605469000)},
    {_DATAF(0.53499764204025269000),  _DATAF(-0.84485357999801636000)},
    {_DATAF(0.53467357158660889000),  _DATAF(-0.84505867958068848000)},
    {_DATAF(0.53434944152832031000),  _DATAF(-0.84526365995407104000)},
    {_DATAF(0.53402525186538696000),  _DATAF(-0.84546852111816406000)},
    {_DATAF(0.53370100259780884000),  _DATAF(-0.84567326307296753000)},
    {_DATAF(0.53337663412094116000),  _DATAF(-0.84587788581848145000)},
    {_DATAF(0.53305220603942871000),  _DATAF(-0.84608232975006104000)},
    {_DATAF(0.53272771835327148000),  _DATAF(-0.84628671407699585000)},
    {_DATAF(0.53240311145782471000),  _DATAF(-0.84649091958999634000)},
    {_DATAF(0.53207844495773315000),  _DATAF(-0.84669506549835205000)},
    {_DATAF(0.53175371885299683000),  _DATAF(-0.84689903259277344000)},
    {_DATAF(0.53142887353897095000),  _DATAF(-0.84710288047790527000)},
    {_DATAF(0.53110402822494507000),  _DATAF(-0.84730660915374756000)},
    {_DATAF(0.53077900409698486000),  _DATAF(-0.84751027822494507000)},
    {_DATAF(0.53045397996902466000),  _DATAF(-0.84771376848220825000)},
    {_DATAF(0.53012883663177490000),  _DATAF(-0.84791707992553711000)},
    {_DATAF(0.52980363368988037000),  _DATAF(-0.84812033176422119000)},
    {_DATAF(0.52947831153869629000),  _DATAF(-0.84832346439361572000)},
    {_DATAF(0.52915298938751221000),  _DATAF(-0.84852647781372070000)},
    {_DATAF(0.52882754802703857000),  _DATAF(-0.84872931241989136000)},
    {_DATAF(0.52850198745727539000),  _DATAF(-0.84893202781677246000)},
    {_DATAF(0.52817642688751221000),  _DATAF(-0.84913468360900879000)},
    {_DATAF(0.52785074710845947000),  _DATAF(-0.84933716058731079000)},
    {_DATAF(0.52752494812011719000),  _DATAF(-0.84953951835632324000)},
    {_DATAF(0.52719914913177490000),  _DATAF(-0.84974175691604614000)},
    {_DATAF(0.52687323093414307000),  _DATAF(-0.84994387626647949000)},
    {_DATAF(0.52654725313186646000),  _DATAF(-0.85014587640762329000)},
    {_DATAF(0.52622115612030029000),  _DATAF(-0.85034775733947754000)},
    {_DATAF(0.52589499950408936000),  _DATAF(-0.85054945945739746000)},
    {_DATAF(0.52556878328323364000),  _DATAF(-0.85075110197067261000)},
    {_DATAF(0.52524250745773315000),  _DATAF(-0.85095256567001343000)},
    {_DATAF(0.52491611242294312000),  _DATAF(-0.85115396976470947000)},
    {_DATAF(0.52458965778350830000),  _DATAF(-0.85135519504547119000)},
    {_DATAF(0.52426314353942871000),  _DATAF(-0.85155630111694336000)},
    {_DATAF(0.52393656969070435000),  _DATAF(-0.85175728797912598000)},
    {_DATAF(0.52360987663269043000),  _DATAF(-0.85195815563201904000)},
    {_DATAF(0.52328312397003174000),  _DATAF(-0.85215890407562256000)},
    {_DATAF(0.52295625209808350000),  _DATAF(-0.85235953330993652000)},
    {_DATAF(0.52262938022613525000),  _DATAF(-0.85255998373031616000)},
    {_DATAF(0.52230238914489746000),  _DATAF(-0.85276037454605103000)},
    {_DATAF(0.52197527885437012000),  _DATAF(-0.85296058654785156000)},
    {_DATAF(0.52164816856384277000),  _DATAF(-0.85316073894500732000)},
    {_DATAF(0.52132093906402588000),  _DATAF(-0.85336071252822876000)},
    {_DATAF(0.52099364995956421000),  _DATAF(-0.85356056690216064000)},
    {_DATAF(0.52066624164581299000),  _DATAF(-0.85376030206680298000)},
    {_DATAF(0.52033877372741699000),  _DATAF(-0.85395991802215576000)},
    {_DATAF(0.52001124620437622000),  _DATAF(-0.85415941476821899000)},
    {_DATAF(0.51968365907669067000),  _DATAF(-0.85435873270034790000)},
    {_DATAF(0.51935601234436035000),  _DATAF(-0.85455799102783203000)},
    {_DATAF(0.51902824640274048000),  _DATAF(-0.85475707054138184000)},
    {_DATAF(0.51870042085647583000),  _DATAF(-0.85495609045028687000)},
    {_DATAF(0.51837247610092163000),  _DATAF(-0.85515493154525757000)},
    {_DATAF(0.51804453134536743000),  _DATAF(-0.85535365343093872000)},
    {_DATAF(0.51771646738052368000),  _DATAF(-0.85555225610733032000)},
    {_DATAF(0.51738828420639038000),  _DATAF(-0.85575073957443237000)},
    {_DATAF(0.51706010103225708000),  _DATAF(-0.85594910383224487000)},
    {_DATAF(0.51673179864883423000),  _DATAF(-0.85614734888076782000)},
    {_DATAF(0.51640343666076660000),  _DATAF(-0.85634541511535645000)},
    {_DATAF(0.51607501506805420000),  _DATAF(-0.85654342174530029000)},
    {_DATAF(0.51574647426605225000),  _DATAF(-0.85674124956130981000)},
    {_DATAF(0.51541787385940552000),  _DATAF(-0.85693895816802979000)},
    {_DATAF(0.51508921384811401000),  _DATAF(-0.85713654756546021000)},
    {_DATAF(0.51476043462753296000),  _DATAF(-0.85733401775360107000)},
    {_DATAF(0.51443165540695190000),  _DATAF(-0.85753136873245239000)},
    {_DATAF(0.51410275697708130000),  _DATAF(-0.85772860050201416000)},
    {_DATAF(0.51377379894256592000),  _DATAF(-0.85792571306228638000)},
    {_DATAF(0.51344472169876099000),  _DATAF(-0.85812264680862427000)},
    {_DATAF(0.51311558485031128000),  _DATAF(-0.85831952095031738000)},
    {_DATAF(0.51278638839721680000),  _DATAF(-0.85851621627807617000)},
    {_DATAF(0.51245713233947754000),  _DATAF(-0.85871279239654541000)},
    {_DATAF(0.51212775707244873000),  _DATAF(-0.85890924930572510000)},
    {_DATAF(0.51179832220077515000),  _DATAF(-0.85910558700561523000)},
    {_DATAF(0.51146882772445679000),  _DATAF(-0.85930180549621582000)},
    {_DATAF(0.51113927364349365000),  _DATAF(-0.85949790477752686000)},
    {_DATAF(0.51080960035324097000),  _DATAF(-0.85969388484954834000)},
    {_DATAF(0.51047992706298828000),  _DATAF(-0.85988968610763550000)},
    {_DATAF(0.51015007495880127000),  _DATAF(-0.86008536815643311000)},
    {_DATAF(0.50982022285461426000),  _DATAF(-0.86028099060058594000)},
    {_DATAF(0.50949025154113770000),  _DATAF(-0.86047643423080444000)},
    {_DATAF(0.50916022062301636000),  _DATAF(-0.86067175865173340000)},
    {_DATAF(0.50883013010025024000),  _DATAF(-0.86086696386337280000)},
    {_DATAF(0.50849997997283936000),  _DATAF(-0.86106199026107788000)},
    {_DATAF(0.50816971063613892000),  _DATAF(-0.86125695705413818000)},
    {_DATAF(0.50783938169479370000),  _DATAF(-0.86145174503326416000)},
    {_DATAF(0.50750899314880371000),  _DATAF(-0.86164647340774536000)},
    {_DATAF(0.50717854499816895000),  _DATAF(-0.86184102296829224000)},
    {_DATAF(0.50684797763824463000),  _DATAF(-0.86203545331954956000)},
    {_DATAF(0.50651735067367554000),  _DATAF(-0.86222976446151733000)},
    {_DATAF(0.50618666410446167000),  _DATAF(-0.86242395639419556000)},
    {_DATAF(0.50585585832595825000),  _DATAF(-0.86261802911758423000)},
    {_DATAF(0.50552505254745483000),  _DATAF(-0.86281192302703857000)},
    {_DATAF(0.50519412755966187000),  _DATAF(-0.86300575733184814000)},
    {_DATAF(0.50486308336257935000),  _DATAF(-0.86319941282272339000)},
    {_DATAF(0.50453203916549683000),  _DATAF(-0.86339294910430908000)},
    {_DATAF(0.50420087575912476000),  _DATAF(-0.86358636617660522000)},
    {_DATAF(0.50386965274810791000),  _DATAF(-0.86377966403961182000)},
    {_DATAF(0.50353837013244629000),  _DATAF(-0.86397284269332886000)},
    {_DATAF(0.50320702791213989000),  _DATAF(-0.86416590213775635000)},
    {_DATAF(0.50287556648254395000),  _DATAF(-0.86435878276824951000)},
    {_DATAF(0.50254404544830322000),  _DATAF(-0.86455160379409790000)},
    {_DATAF(0.50221246480941772000),  _DATAF(-0.86474424600601196000)},
    {_DATAF(0.50188082456588745000),  _DATAF(-0.86493676900863647000)},
    {_DATAF(0.50154906511306763000),  _DATAF(-0.86512917280197144000)},
    {_DATAF(0.50121724605560303000),  _DATAF(-0.86532145738601685000)},
    {_DATAF(0.50088536739349365000),  _DATAF(-0.86551362276077271000)},
    {_DATAF(0.50055342912673950000),  _DATAF(-0.86570566892623901000)},
    {_DATAF(0.50022137165069580000),  _DATAF(-0.86589753627777100000)},
    {_DATAF(0.49988928437232971000),  _DATAF(-0.86608928442001343000)},
    {_DATAF(0.49955710768699646000),  _DATAF(-0.86628097295761108000)},
    {_DATAF(0.49922487139701843000),  _DATAF(-0.86647248268127441000)},
    {_DATAF(0.49889254570007324000),  _DATAF(-0.86666387319564819000)},
    {_DATAF(0.49856013059616089000),  _DATAF(-0.86685508489608765000)},
    {_DATAF(0.49822765588760376000),  _DATAF(-0.86704623699188232000)},
    {_DATAF(0.49789512157440186000),  _DATAF(-0.86723726987838745000)},
    {_DATAF(0.49756249785423279000),  _DATAF(-0.86742812395095825000)},
    {_DATAF(0.49722981452941895000),  _DATAF(-0.86761885881423950000)},
    {_DATAF(0.49689704179763794000),  _DATAF(-0.86780947446823120000)},
    {_DATAF(0.49656420946121216000),  _DATAF(-0.86799997091293335000)},
    {_DATAF(0.49623128771781921000),  _DATAF(-0.86819034814834595000)},
    {_DATAF(0.49589830636978149000),  _DATAF(-0.86838060617446899000)},
    {_DATAF(0.49556526541709900000),  _DATAF(-0.86857068538665771000)},
    {_DATAF(0.49523213505744934000),  _DATAF(-0.86876070499420166000)},
    {_DATAF(0.49489894509315491000),  _DATAF(-0.86895054578781128000)},
    {_DATAF(0.49456566572189331000),  _DATAF(-0.86914026737213135000)},
    {_DATAF(0.49423229694366455000),  _DATAF(-0.86932986974716187000)},
    {_DATAF(0.49389889836311340000),  _DATAF(-0.86951935291290283000)},
    {_DATAF(0.49356541037559509000),  _DATAF(-0.86970865726470947000)},
    {_DATAF(0.49323183298110962000),  _DATAF(-0.86989790201187134000)},
    {_DATAF(0.49289819598197937000),  _DATAF(-0.87008696794509888000)},
    {_DATAF(0.49256446957588196000),  _DATAF(-0.87027597427368164000)},
    {_DATAF(0.49223071336746216000),  _DATAF(-0.87046480178833008000)},
    {_DATAF(0.49189683794975281000),  _DATAF(-0.87065351009368896000)},
    {_DATAF(0.49156290292739868000),  _DATAF(-0.87084203958511353000)},
    {_DATAF(0.49122890830039978000),  _DATAF(-0.87103050947189331000)},
    {_DATAF(0.49089485406875610000),  _DATAF(-0.87121886014938354000)},
    {_DATAF(0.49056071043014526000),  _DATAF(-0.87140703201293945000)},
    {_DATAF(0.49022647738456726000),  _DATAF(-0.87159508466720581000)},
    {_DATAF(0.48989218473434448000),  _DATAF(-0.87178301811218262000)},
    {_DATAF(0.48955783247947693000),  _DATAF(-0.87197083234786987000)},
    {_DATAF(0.48922339081764221000),  _DATAF(-0.87215852737426758000)},
    {_DATAF(0.48888888955116272000),  _DATAF(-0.87234604358673096000)},
    {_DATAF(0.48855432868003845000),  _DATAF(-0.87253350019454956000)},
    {_DATAF(0.48821967840194702000),  _DATAF(-0.87272077798843384000)},
    {_DATAF(0.48788493871688843000),  _DATAF(-0.87290793657302856000)},
    {_DATAF(0.48755016922950745000),  _DATAF(-0.87309497594833374000)},
    {_DATAF(0.48721531033515930000),  _DATAF(-0.87328189611434937000)},
    {_DATAF(0.48688036203384399000),  _DATAF(-0.87346869707107544000)},
    {_DATAF(0.48654535412788391000),  _DATAF(-0.87365531921386719000)},
    {_DATAF(0.48621028661727905000),  _DATAF(-0.87384182214736938000)},
    {_DATAF(0.48587512969970703000),  _DATAF(-0.87402826547622681000)},
    {_DATAF(0.48553991317749023000),  _DATAF(-0.87421452999114990000)},
    {_DATAF(0.48520460724830627000),  _DATAF(-0.87440061569213867000)},
    {_DATAF(0.48486924171447754000),  _DATAF(-0.87458664178848267000)},
    {_DATAF(0.48453381657600403000),  _DATAF(-0.87477254867553711000)},
    {_DATAF(0.48419830203056335000),  _DATAF(-0.87495827674865723000)},
    {_DATAF(0.48386272788047791000),  _DATAF(-0.87514388561248779000)},
    {_DATAF(0.48352706432342529000),  _DATAF(-0.87532937526702881000)},
    {_DATAF(0.48319137096405029000),  _DATAF(-0.87551474571228027000)},
    {_DATAF(0.48285555839538574000),  _DATAF(-0.87569999694824219000)},
    {_DATAF(0.48251971602439880000),  _DATAF(-0.87588512897491455000)},
    {_DATAF(0.48218378424644470000),  _DATAF(-0.87607008218765259000)},
    {_DATAF(0.48184776306152344000),  _DATAF(-0.87625491619110107000)},
    {_DATAF(0.48151168227195740000),  _DATAF(-0.87643969058990479000)},
    {_DATAF(0.48117554187774658000),  _DATAF(-0.87662428617477417000)},
    {_DATAF(0.48083934187889099000),  _DATAF(-0.87680870294570923000)},
    {_DATAF(0.48050305247306824000),  _DATAF(-0.87699306011199951000)},
    {_DATAF(0.48016667366027832000),  _DATAF(-0.87717723846435547000)},
    {_DATAF(0.47983026504516602000),  _DATAF(-0.87736135721206665000)},
    {_DATAF(0.47949376702308655000),  _DATAF(-0.87754529714584351000)},
    {_DATAF(0.47915717959403992000),  _DATAF(-0.87772911787033081000)},
    {_DATAF(0.47882056236267090000),  _DATAF(-0.87791281938552856000)},
    {_DATAF(0.47848382592201233000),  _DATAF(-0.87809634208679199000)},
    {_DATAF(0.47814705967903137000),  _DATAF(-0.87827980518341064000)},
    {_DATAF(0.47781020402908325000),  _DATAF(-0.87846308946609497000)},
    {_DATAF(0.47747328877449036000),  _DATAF(-0.87864625453948975000)},
    {_DATAF(0.47713628411293030000),  _DATAF(-0.87882930040359497000)},
    {_DATAF(0.47679921984672546000),  _DATAF(-0.87901222705841064000)},
    {_DATAF(0.47646209597587585000),  _DATAF(-0.87919503450393677000)},
    {_DATAF(0.47612488269805908000),  _DATAF(-0.87937766313552856000)},
    {_DATAF(0.47578760981559753000),  _DATAF(-0.87956017255783081000)},
    {_DATAF(0.47545027732849121000),  _DATAF(-0.87974262237548828000)},
    {_DATAF(0.47511285543441772000),  _DATAF(-0.87992483377456665000)},
    {_DATAF(0.47477537393569946000),  _DATAF(-0.88010698556900024000)},
    {_DATAF(0.47443783283233643000),  _DATAF(-0.88028901815414429000)},
    {_DATAF(0.47410020232200623000),  _DATAF(-0.88047087192535400000)},
    {_DATAF(0.47376251220703125000),  _DATAF(-0.88065266609191895000)},
    {_DATAF(0.47342476248741150000),  _DATAF(-0.88083428144454956000)},
    {_DATAF(0.47308692336082458000),  _DATAF(-0.88101577758789063000)},
    {_DATAF(0.47274902462959290000),  _DATAF(-0.88119709491729736000)},
    {_DATAF(0.47241106629371643000),  _DATAF(-0.88137835264205933000)},
    {_DATAF(0.47207301855087280000),  _DATAF(-0.88155943155288696000)},
    {_DATAF(0.47173491120338440000),  _DATAF(-0.88174045085906982000)},
    {_DATAF(0.47139674425125122000),  _DATAF(-0.88192129135131836000)},
    {_DATAF(0.47105848789215088000),  _DATAF(-0.88210195302963257000)},
    {_DATAF(0.47072017192840576000),  _DATAF(-0.88228255510330200000)},
    {_DATAF(0.47038179636001587000),  _DATAF(-0.88246303796768188000)},
    {_DATAF(0.47004333138465881000),  _DATAF(-0.88264334201812744000)},
    {_DATAF(0.46970480680465698000),  _DATAF(-0.88282352685928345000)},
    {_DATAF(0.46936622262001038000),  _DATAF(-0.88300359249114990000)},
    {_DATAF(0.46902754902839661000),  _DATAF(-0.88318353891372681000)},
    {_DATAF(0.46868881583213806000),  _DATAF(-0.88336336612701416000)},
    {_DATAF(0.46835002303123474000),  _DATAF(-0.88354301452636719000)},
    {_DATAF(0.46801114082336426000),  _DATAF(-0.88372254371643066000)},
    {_DATAF(0.46767222881317139000),  _DATAF(-0.88390195369720459000)},
    {_DATAF(0.46733319759368896000),  _DATAF(-0.88408124446868896000)},
    {_DATAF(0.46699413657188416000),  _DATAF(-0.88426041603088379000)},
    {_DATAF(0.46665498614311218000),  _DATAF(-0.88443946838378906000)},
    {_DATAF(0.46631577610969543000),  _DATAF(-0.88461834192276001000)},
    {_DATAF(0.46597650647163391000),  _DATAF(-0.88479709625244141000)},
    {_DATAF(0.46563714742660522000),  _DATAF(-0.88497573137283325000)},
    {_DATAF(0.46529772877693176000),  _DATAF(-0.88515424728393555000)},
    {_DATAF(0.46495825052261353000),  _DATAF(-0.88533258438110352000)},
    {_DATAF(0.46461868286132813000),  _DATAF(-0.88551086187362671000)},
    {_DATAF(0.46427905559539795000),  _DATAF(-0.88568896055221558000)},
    {_DATAF(0.46393936872482300000),  _DATAF(-0.88586694002151489000)},
    {_DATAF(0.46359962224960327000),  _DATAF(-0.88604480028152466000)},
    {_DATAF(0.46325978636741638000),  _DATAF(-0.88622254133224487000)},
    {_DATAF(0.46291989088058472000),  _DATAF(-0.88640010356903076000)},
    {_DATAF(0.46257993578910828000),  _DATAF(-0.88657760620117188000)},
    {_DATAF(0.46223989129066467000),  _DATAF(-0.88675493001937866000)},
    {_DATAF(0.46189978718757629000),  _DATAF(-0.88693213462829590000)},
    {_DATAF(0.46155962347984314000),  _DATAF(-0.88710916042327881000)},
    {_DATAF(0.46121940016746521000),  _DATAF(-0.88728612661361694000)},
    {_DATAF(0.46087908744812012000),  _DATAF(-0.88746291399002075000)},
    {_DATAF(0.46053871512413025000),  _DATAF(-0.88763964176177979000)},
    {_DATAF(0.46019828319549561000),  _DATAF(-0.88781619071960449000)},
    {_DATAF(0.45985776185989380000),  _DATAF(-0.88799256086349487000)},
    {_DATAF(0.45951718091964722000),  _DATAF(-0.88816887140274048000)},
    {_DATAF(0.45917654037475586000),  _DATAF(-0.88834506273269653000)},
    {_DATAF(0.45883584022521973000),  _DATAF(-0.88852107524871826000)},
    {_DATAF(0.45849505066871643000),  _DATAF(-0.88869696855545044000)},
    {_DATAF(0.45815420150756836000),  _DATAF(-0.88887274265289307000)},
    {_DATAF(0.45781329274177551000),  _DATAF(-0.88904833793640137000)},
    {_DATAF(0.45747232437133789000),  _DATAF(-0.88922387361526489000)},
    {_DATAF(0.45713126659393311000),  _DATAF(-0.88939923048019409000)},
    {_DATAF(0.45679014921188354000),  _DATAF(-0.88957446813583374000)},
    {_DATAF(0.45644897222518921000),  _DATAF(-0.88974958658218384000)},
    {_DATAF(0.45610773563385010000),  _DATAF(-0.88992458581924438000)},
    {_DATAF(0.45576640963554382000),  _DATAF(-0.89009940624237061000)},
    {_DATAF(0.45542502403259277000),  _DATAF(-0.89027410745620728000)},
    {_DATAF(0.45508357882499695000),  _DATAF(-0.89044874906539917000)},
    {_DATAF(0.45474207401275635000),  _DATAF(-0.89062315225601196000)},
    {_DATAF(0.45440047979354858000),  _DATAF(-0.89079749584197998000)},
    {_DATAF(0.45405882596969604000),  _DATAF(-0.89097172021865845000)},
    {_DATAF(0.45371711254119873000),  _DATAF(-0.89114576578140259000)},
    {_DATAF(0.45337533950805664000),  _DATAF(-0.89131969213485718000)},
    {_DATAF(0.45303347706794739000),  _DATAF(-0.89149349927902222000)},
    {_DATAF(0.45269158482551575000),  _DATAF(-0.89166718721389771000)},
    {_DATAF(0.45234957337379456000),  _DATAF(-0.89184069633483887000)},
    {_DATAF(0.45200753211975098000),  _DATAF(-0.89201414585113525000)},
    {_DATAF(0.45166543126106262000),  _DATAF(-0.89218741655349731000)},
    {_DATAF(0.45132324099540710000),  _DATAF(-0.89236056804656982000)},
    {_DATAF(0.45098099112510681000),  _DATAF(-0.89253354072570801000)},
    {_DATAF(0.45063868165016174000),  _DATAF(-0.89270645380020142000)},
    {_DATAF(0.45029628276824951000),  _DATAF(-0.89287918806076050000)},
    {_DATAF(0.44995385408401489000),  _DATAF(-0.89305180311203003000)},
    {_DATAF(0.44961133599281311000),  _DATAF(-0.89322429895401001000)},
    {_DATAF(0.44926875829696655000),  _DATAF(-0.89339667558670044000)},
    {_DATAF(0.44892609119415283000),  _DATAF(-0.89356887340545654000)},
    {_DATAF(0.44858339428901672000),  _DATAF(-0.89374095201492310000)},
    {_DATAF(0.44824060797691345000),  _DATAF(-0.89391297101974487000)},
    {_DATAF(0.44789776206016541000),  _DATAF(-0.89408475160598755000)},
    {_DATAF(0.44755485653877258000),  _DATAF(-0.89425647258758545000)},
    {_DATAF(0.44721189141273499000),  _DATAF(-0.89442807435989380000)},
    {_DATAF(0.44686883687973022000),  _DATAF(-0.89459949731826782000)},
    {_DATAF(0.44652572274208069000),  _DATAF(-0.89477080106735229000)},
    {_DATAF(0.44618254899978638000),  _DATAF(-0.89494198560714722000)},
    {_DATAF(0.44583931565284729000),  _DATAF(-0.89511299133300781000)},
    {_DATAF(0.44549602270126343000),  _DATAF(-0.89528393745422363000)},
    {_DATAF(0.44515264034271240000),  _DATAF(-0.89545470476150513000)},
    {_DATAF(0.44480919837951660000),  _DATAF(-0.89562535285949707000)},
    {_DATAF(0.44446569681167603000),  _DATAF(-0.89579588174819946000)},
    {_DATAF(0.44412213563919067000),  _DATAF(-0.89596623182296753000)},
    {_DATAF(0.44377851486206055000),  _DATAF(-0.89613652229309082000)},
    {_DATAF(0.44343480467796326000),  _DATAF(-0.89630663394927979000)},
    {_DATAF(0.44309106469154358000),  _DATAF(-0.89647662639617920000)},
    {_DATAF(0.44274723529815674000),  _DATAF(-0.89664649963378906000)},
    {_DATAF(0.44240334630012512000),  _DATAF(-0.89681619405746460000)},
    {_DATAF(0.44205936789512634000),  _DATAF(-0.89698576927185059000)},
    {_DATAF(0.44171535968780518000),  _DATAF(-0.89715522527694702000)},
    {_DATAF(0.44137126207351685000),  _DATAF(-0.89732456207275391000)},
    {_DATAF(0.44102710485458374000),  _DATAF(-0.89749377965927124000)},
    {_DATAF(0.44068288803100586000),  _DATAF(-0.89766281843185425000)},
    {_DATAF(0.44033861160278320000),  _DATAF(-0.89783179759979248000)},
    {_DATAF(0.43999427556991577000),  _DATAF(-0.89800059795379639000)},
    {_DATAF(0.43964985013008118000),  _DATAF(-0.89816927909851074000)},
    {_DATAF(0.43930539488792419000),  _DATAF(-0.89833778142929077000)},
    {_DATAF(0.43896085023880005000),  _DATAF(-0.89850616455078125000)},
    {_DATAF(0.43861624598503113000),  _DATAF(-0.89867448806762695000)},
    {_DATAF(0.43827158212661743000),  _DATAF(-0.89884263277053833000)},
    {_DATAF(0.43792682886123657000),  _DATAF(-0.89901059865951538000)},
    {_DATAF(0.43758204579353333000),  _DATAF(-0.89917850494384766000)},
    {_DATAF(0.43723717331886292000),  _DATAF(-0.89934623241424561000)},
    {_DATAF(0.43689224123954773000),  _DATAF(-0.89951384067535400000)},
    {_DATAF(0.43654724955558777000),  _DATAF(-0.89968132972717285000)},
    {_DATAF(0.43620219826698303000),  _DATAF(-0.89984869956970215000)},
    {_DATAF(0.43585708737373352000),  _DATAF(-0.90001589059829712000)},
    {_DATAF(0.43551188707351685000),  _DATAF(-0.90018296241760254000)},
    {_DATAF(0.43516665697097778000),  _DATAF(-0.90034991502761841000)},
    {_DATAF(0.43482133746147156000),  _DATAF(-0.90051674842834473000)},
    {_DATAF(0.43447595834732056000),  _DATAF(-0.90068340301513672000)},
    {_DATAF(0.43413051962852478000),  _DATAF(-0.90084999799728394000)},
    {_DATAF(0.43378502130508423000),  _DATAF(-0.90101641416549683000)},
    {_DATAF(0.43343946337699890000),  _DATAF(-0.90118271112442017000)},
    {_DATAF(0.43309381604194641000),  _DATAF(-0.90134882926940918000)},
    {_DATAF(0.43274813890457153000),  _DATAF(-0.90151488780975342000)},
    {_DATAF(0.43240237236022949000),  _DATAF(-0.90168076753616333000)},
    {_DATAF(0.43205654621124268000),  _DATAF(-0.90184652805328369000)},
    {_DATAF(0.43171066045761108000),  _DATAF(-0.90201216936111450000)},
    {_DATAF(0.43136471509933472000),  _DATAF(-0.90217763185501099000)},
    {_DATAF(0.43101871013641357000),  _DATAF(-0.90234297513961792000)},
    {_DATAF(0.43067261576652527000),  _DATAF(-0.90250819921493530000)},
    {_DATAF(0.43032649159431458000),  _DATAF(-0.90267330408096313000)},
    {_DATAF(0.42998027801513672000),  _DATAF(-0.90283828973770142000)},
    {_DATAF(0.42963400483131409000),  _DATAF(-0.90300309658050537000)},
    {_DATAF(0.42928767204284668000),  _DATAF(-0.90316778421401978000)},
    {_DATAF(0.42894127964973450000),  _DATAF(-0.90333235263824463000)},
    {_DATAF(0.42859482765197754000),  _DATAF(-0.90349680185317993000)},
    {_DATAF(0.42824831604957581000),  _DATAF(-0.90366107225418091000)},
    {_DATAF(0.42790174484252930000),  _DATAF(-0.90382528305053711000)},
    {_DATAF(0.42755508422851563000),  _DATAF(-0.90398931503295898000)},
    {_DATAF(0.42720839381217957000),  _DATAF(-0.90415316820144653000)},
    {_DATAF(0.42686161398887634000),  _DATAF(-0.90431696176528931000)},
    {_DATAF(0.42651477456092834000),  _DATAF(-0.90448057651519775000)},
    {_DATAF(0.42616787552833557000),  _DATAF(-0.90464407205581665000)},
    {_DATAF(0.42582091689109802000),  _DATAF(-0.90480744838714600000)},
    {_DATAF(0.42547389864921570000),  _DATAF(-0.90497070550918579000)},
    {_DATAF(0.42512682080268860000),  _DATAF(-0.90513378381729126000)},
    {_DATAF(0.42477968335151672000),  _DATAF(-0.90529674291610718000)},
    {_DATAF(0.42443248629570007000),  _DATAF(-0.90545958280563354000)},
    {_DATAF(0.42408519983291626000),  _DATAF(-0.90562230348587036000)},
    {_DATAF(0.42373788356781006000),  _DATAF(-0.90578484535217285000)},
    {_DATAF(0.42339047789573669000),  _DATAF(-0.90594726800918579000)},
    {_DATAF(0.42304301261901855000),  _DATAF(-0.90610957145690918000)},
    {_DATAF(0.42269548773765564000),  _DATAF(-0.90627175569534302000)},
    {_DATAF(0.42234790325164795000),  _DATAF(-0.90643382072448730000)},
    {_DATAF(0.42200025916099548000),  _DATAF(-0.90659570693969727000)},
    {_DATAF(0.42165255546569824000),  _DATAF(-0.90675747394561768000)},
    {_DATAF(0.42130479216575623000),  _DATAF(-0.90691912174224854000)},
    {_DATAF(0.42095696926116943000),  _DATAF(-0.90708059072494507000)},
    {_DATAF(0.42060908675193787000),  _DATAF(-0.90724200010299683000)},
    {_DATAF(0.42026111483573914000),  _DATAF(-0.90740323066711426000)},
    {_DATAF(0.41991311311721802000),  _DATAF(-0.90756434202194214000)},
    {_DATAF(0.41956502199172974000),  _DATAF(-0.90772527456283569000)},
    {_DATAF(0.41921690106391907000),  _DATAF(-0.90788608789443970000)},
    {_DATAF(0.41886869072914124000),  _DATAF(-0.90804684162139893000)},
    {_DATAF(0.41852042078971863000),  _DATAF(-0.90820735692977905000)},
    {_DATAF(0.41817209124565125000),  _DATAF(-0.90836781263351440000)},
    {_DATAF(0.41782370209693909000),  _DATAF(-0.90852808952331543000)},
    {_DATAF(0.41747528314590454000),  _DATAF(-0.90868830680847168000)},
    {_DATAF(0.41712677478790283000),  _DATAF(-0.90884834527969360000)},
    {_DATAF(0.41677817702293396000),  _DATAF(-0.90900820493698120000)},
    {_DATAF(0.41642954945564270000),  _DATAF(-0.90916800498962402000)},
    {_DATAF(0.41608086228370667000),  _DATAF(-0.90932762622833252000)},
    {_DATAF(0.41573211550712585000),  _DATAF(-0.90948712825775146000)},
    {_DATAF(0.41538330912590027000),  _DATAF(-0.90964645147323608000)},
    {_DATAF(0.41503441333770752000),  _DATAF(-0.90980571508407593000)},
    {_DATAF(0.41468548774719238000),  _DATAF(-0.90996479988098145000)},
    {_DATAF(0.41433650255203247000),  _DATAF(-0.91012376546859741000)},
    {_DATAF(0.41398742794990540000),  _DATAF(-0.91028261184692383000)},
    {_DATAF(0.41363832354545593000),  _DATAF(-0.91044127941131592000)},
    {_DATAF(0.41328912973403931000),  _DATAF(-0.91059982776641846000)},
    {_DATAF(0.41293987631797791000),  _DATAF(-0.91075825691223145000)},
    {_DATAF(0.41259059309959412000),  _DATAF(-0.91091656684875488000)},
    {_DATAF(0.41224122047424316000),  _DATAF(-0.91107475757598877000)},
    {_DATAF(0.41189181804656982000),  _DATAF(-0.91123276948928833000)},
    {_DATAF(0.41154232621192932000),  _DATAF(-0.91139066219329834000)},
    {_DATAF(0.41119277477264404000),  _DATAF(-0.91154843568801880000)},
    {_DATAF(0.41084316372871399000),  _DATAF(-0.91170603036880493000)},
    {_DATAF(0.41049349308013916000),  _DATAF(-0.91186350584030151000)},
    {_DATAF(0.41014379262924194000),  _DATAF(-0.91202086210250854000)},
    {_DATAF(0.40979400277137756000),  _DATAF(-0.91217809915542603000)},
    {_DATAF(0.40944415330886841000),  _DATAF(-0.91233515739440918000)},
    {_DATAF(0.40909424424171448000),  _DATAF(-0.91249215602874756000)},
    {_DATAF(0.40874427556991577000),  _DATAF(-0.91264897584915161000)},
    {_DATAF(0.40839424729347229000),  _DATAF(-0.91280561685562134000)},
    {_DATAF(0.40804415941238403000),  _DATAF(-0.91296219825744629000)},
    {_DATAF(0.40769401192665100000),  _DATAF(-0.91311860084533691000)},
    {_DATAF(0.40734380483627319000),  _DATAF(-0.91327488422393799000)},
    {_DATAF(0.40699353814125061000),  _DATAF(-0.91343104839324951000)},
    {_DATAF(0.40664321184158325000),  _DATAF(-0.91358703374862671000)},
    {_DATAF(0.40629282593727112000),  _DATAF(-0.91374289989471436000)},
    {_DATAF(0.40594238042831421000),  _DATAF(-0.91389864683151245000)},
    {_DATAF(0.40559187531471252000),  _DATAF(-0.91405427455902100000)},
    {_DATAF(0.40524131059646606000),  _DATAF(-0.91420978307723999000)},
    {_DATAF(0.40489068627357483000),  _DATAF(-0.91436511278152466000)},
    {_DATAF(0.40454000234603882000),  _DATAF(-0.91452032327651978000)},
    {_DATAF(0.40418925881385803000),  _DATAF(-0.91467535495758057000)},
    {_DATAF(0.40383845567703247000),  _DATAF(-0.91483032703399658000)},
    {_DATAF(0.40348759293556213000),  _DATAF(-0.91498512029647827000)},
    {_DATAF(0.40313667058944702000),  _DATAF(-0.91513979434967041000)},
    {_DATAF(0.40278568863868713000),  _DATAF(-0.91529428958892822000)},
    {_DATAF(0.40243464708328247000),  _DATAF(-0.91544872522354126000)},
    {_DATAF(0.40208354592323303000),  _DATAF(-0.91560298204421997000)},
    {_DATAF(0.40173238515853882000),  _DATAF(-0.91575711965560913000)},
    {_DATAF(0.40138116478919983000),  _DATAF(-0.91591107845306396000)},
    {_DATAF(0.40102988481521606000),  _DATAF(-0.91606497764587402000)},
    {_DATAF(0.40067857503890991000),  _DATAF(-0.91621869802474976000)},
    {_DATAF(0.40032717585563660000),  _DATAF(-0.91637229919433594000)},
    {_DATAF(0.39997571706771851000),  _DATAF(-0.91652572154998779000)},
    {_DATAF(0.39962419867515564000),  _DATAF(-0.91667908430099487000)},
    {_DATAF(0.39927262067794800000),  _DATAF(-0.91683226823806763000)},
    {_DATAF(0.39892101287841797000),  _DATAF(-0.91698527336120605000)},
    {_DATAF(0.39856931567192078000),  _DATAF(-0.91713821887969971000)},
    {_DATAF(0.39821755886077881000),  _DATAF(-0.91729098558425903000)},
    {_DATAF(0.39786574244499207000),  _DATAF(-0.91744363307952881000)},
    {_DATAF(0.39751389622688293000),  _DATAF(-0.91759616136550903000)},
    {_DATAF(0.39716196060180664000),  _DATAF(-0.91774851083755493000)},
    {_DATAF(0.39680999517440796000),  _DATAF(-0.91790080070495605000)},
    {_DATAF(0.39645794034004211000),  _DATAF(-0.91805291175842285000)},
    {_DATAF(0.39610585570335388000),  _DATAF(-0.91820484399795532000)},
    {_DATAF(0.39575368165969849000),  _DATAF(-0.91835671663284302000)},
    {_DATAF(0.39540147781372070000),  _DATAF(-0.91850841045379639000)},
    {_DATAF(0.39504921436309814000),  _DATAF(-0.91865998506546021000)},
    {_DATAF(0.39469686150550842000),  _DATAF(-0.91881138086318970000)},
    {_DATAF(0.39434447884559631000),  _DATAF(-0.91896271705627441000)},
    {_DATAF(0.39399203658103943000),  _DATAF(-0.91911387443542480000)},
    {_DATAF(0.39363953471183777000),  _DATAF(-0.91926485300064087000)},
    {_DATAF(0.39328697323799133000),  _DATAF(-0.91941577196121216000)},
    {_DATAF(0.39293435215950012000),  _DATAF(-0.91956651210784912000)},
    {_DATAF(0.39258167147636414000),  _DATAF(-0.91971713304519653000)},
    {_DATAF(0.39222893118858337000),  _DATAF(-0.91986763477325439000)},
    {_DATAF(0.39187613129615784000),  _DATAF(-0.92001795768737793000)},
    {_DATAF(0.39152330160140991000),  _DATAF(-0.92016822099685669000)},
    {_DATAF(0.39117038249969482000),  _DATAF(-0.92031830549240112000)},
    {_DATAF(0.39081740379333496000),  _DATAF(-0.92046821117401123000)},
    {_DATAF(0.39046439528465271000),  _DATAF(-0.92061805725097656000)},
    {_DATAF(0.39011132717132568000),  _DATAF(-0.92076772451400757000)},
    {_DATAF(0.38975816965103149000),  _DATAF(-0.92091721296310425000)},
    {_DATAF(0.38940498232841492000),  _DATAF(-0.92106664180755615000)},
    {_DATAF(0.38905173540115356000),  _DATAF(-0.92121589183807373000)},
    {_DATAF(0.38869842886924744000),  _DATAF(-0.92136502265930176000)},
    {_DATAF(0.38834503293037415000),  _DATAF(-0.92151403427124023000)},
    {_DATAF(0.38799160718917847000),  _DATAF(-0.92166292667388916000)},
    {_DATAF(0.38763815164566040000),  _DATAF(-0.92181164026260376000)},
    {_DATAF(0.38728460669517517000),  _DATAF(-0.92196023464202881000)},
    {_DATAF(0.38693100214004517000),  _DATAF(-0.92210865020751953000)},
    {_DATAF(0.38657733798027039000),  _DATAF(-0.92225700616836548000)},
    {_DATAF(0.38622364401817322000),  _DATAF(-0.92240518331527710000)},
    {_DATAF(0.38586989045143127000),  _DATAF(-0.92255324125289917000)},
    {_DATAF(0.38551604747772217000),  _DATAF(-0.92270112037658691000)},
    {_DATAF(0.38516217470169067000),  _DATAF(-0.92284888029098511000)},
    {_DATAF(0.38480824232101440000),  _DATAF(-0.92299652099609375000)},
    {_DATAF(0.38445425033569336000),  _DATAF(-0.92314404249191284000)},
    {_DATAF(0.38410019874572754000),  _DATAF(-0.92329144477844238000)},
    {_DATAF(0.38374608755111694000),  _DATAF(-0.92343866825103760000)},
    {_DATAF(0.38339191675186157000),  _DATAF(-0.92358577251434326000)},
    {_DATAF(0.38303771615028381000),  _DATAF(-0.92373269796371460000)},
    {_DATAF(0.38268342614173889000),  _DATAF(-0.92387950420379639000)},
    {_DATAF(0.38232910633087158000),  _DATAF(-0.92402625083923340000)},
    {_DATAF(0.38197472691535950000),  _DATAF(-0.92417275905609131000)},
    {_DATAF(0.38162025809288025000),  _DATAF(-0.92431920766830444000)},
    {_DATAF(0.38126575946807861000),  _DATAF(-0.92446547746658325000)},
    {_DATAF(0.38091120123863220000),  _DATAF(-0.92461162805557251000)},
    {_DATAF(0.38055661320686340000),  _DATAF(-0.92475759983062744000)},
    {_DATAF(0.38020193576812744000),  _DATAF(-0.92490351200103760000)},
    {_DATAF(0.37984719872474670000),  _DATAF(-0.92504924535751343000)},
    {_DATAF(0.37949243187904358000),  _DATAF(-0.92519485950469971000)},
    {_DATAF(0.37913760542869568000),  _DATAF(-0.92534029483795166000)},
    {_DATAF(0.37878268957138062000),  _DATAF(-0.92548561096191406000)},
    {_DATAF(0.37842774391174316000),  _DATAF(-0.92563080787658691000)},
    {_DATAF(0.37807273864746094000),  _DATAF(-0.92577588558197021000)},
    {_DATAF(0.37771770358085632000),  _DATAF(-0.92592078447341919000)},
    {_DATAF(0.37736257910728455000),  _DATAF(-0.92606556415557861000)},
    {_DATAF(0.37700742483139038000),  _DATAF(-0.92621022462844849000)},
    {_DATAF(0.37665218114852905000),  _DATAF(-0.92635476589202881000)},
    {_DATAF(0.37629690766334534000),  _DATAF(-0.92649912834167480000)},
    {_DATAF(0.37594157457351685000),  _DATAF(-0.92664337158203125000)},
    {_DATAF(0.37558618187904358000),  _DATAF(-0.92678749561309814000)},
    {_DATAF(0.37523072957992554000),  _DATAF(-0.92693144083023071000)},
    {_DATAF(0.37487521767616272000),  _DATAF(-0.92707526683807373000)},
    {_DATAF(0.37451967597007751000),  _DATAF(-0.92721897363662720000)},
    {_DATAF(0.37416407465934753000),  _DATAF(-0.92736250162124634000)},
    {_DATAF(0.37380838394165039000),  _DATAF(-0.92750597000122070000)},
    {_DATAF(0.37345266342163086000),  _DATAF(-0.92764925956726074000)},
    {_DATAF(0.37309691309928894000),  _DATAF(-0.92779237031936646000)},
    {_DATAF(0.37274107336997986000),  _DATAF(-0.92793542146682739000)},
    {_DATAF(0.37238517403602600000),  _DATAF(-0.92807829380035400000)},
    {_DATAF(0.37202924489974976000),  _DATAF(-0.92822098731994629000)},
    {_DATAF(0.37167325615882874000),  _DATAF(-0.92836362123489380000)},
    {_DATAF(0.37131720781326294000),  _DATAF(-0.92850607633590698000)},
    {_DATAF(0.37096109986305237000),  _DATAF(-0.92864841222763062000)},
    {_DATAF(0.37060493230819702000),  _DATAF(-0.92879062891006470000)},
    {_DATAF(0.37024870514869690000),  _DATAF(-0.92893266677856445000)},
    {_DATAF(0.36989244818687439000),  _DATAF(-0.92907458543777466000)},
    {_DATAF(0.36953613162040710000),  _DATAF(-0.92921638488769531000)},
    {_DATAF(0.36917975544929504000),  _DATAF(-0.92935800552368164000)},
    {_DATAF(0.36882331967353821000),  _DATAF(-0.92949950695037842000)},
    {_DATAF(0.36846682429313660000),  _DATAF(-0.92964088916778564000)},
    {_DATAF(0.36811029911041260000),  _DATAF(-0.92978215217590332000)},
    {_DATAF(0.36775368452072144000),  _DATAF(-0.92992323637008667000)},
    {_DATAF(0.36739704012870789000),  _DATAF(-0.93006420135498047000)},
    {_DATAF(0.36704033613204956000),  _DATAF(-0.93020504713058472000)},
    {_DATAF(0.36668360233306885000),  _DATAF(-0.93034571409225464000)},
    {_DATAF(0.36632677912712097000),  _DATAF(-0.93048626184463501000)},
    {_DATAF(0.36596992611885071000),  _DATAF(-0.93062669038772583000)},
    {_DATAF(0.36561298370361328000),  _DATAF(-0.93076694011688232000)},
    {_DATAF(0.36525601148605347000),  _DATAF(-0.93090713024139404000)},
    {_DATAF(0.36489900946617126000),  _DATAF(-0.93104708194732666000)},
    {_DATAF(0.36454191803932190000),  _DATAF(-0.93118697404861450000)},
    {_DATAF(0.36418479681015015000),  _DATAF(-0.93132668733596802000)},
    {_DATAF(0.36382761597633362000),  _DATAF(-0.93146628141403198000)},
    {_DATAF(0.36347037553787231000),  _DATAF(-0.93160575628280640000)},
    {_DATAF(0.36311307549476624000),  _DATAF(-0.93174505233764648000)},
    {_DATAF(0.36275571584701538000),  _DATAF(-0.93188428878784180000)},
    {_DATAF(0.36239832639694214000),  _DATAF(-0.93202328681945801000)},
    {_DATAF(0.36204087734222412000),  _DATAF(-0.93216222524642944000)},
    {_DATAF(0.36168336868286133000),  _DATAF(-0.93230098485946655000)},
    {_DATAF(0.36132580041885376000),  _DATAF(-0.93243962526321411000)},
    {_DATAF(0.36096820235252380000),  _DATAF(-0.93257814645767212000)},
    {_DATAF(0.36061051487922668000),  _DATAF(-0.93271648883819580000)},
    {_DATAF(0.36025279760360718000),  _DATAF(-0.93285471200942993000)},
    {_DATAF(0.35989505052566528000),  _DATAF(-0.93299281597137451000)},
    {_DATAF(0.35953721404075623000),  _DATAF(-0.93313074111938477000)},
    {_DATAF(0.35917934775352478000),  _DATAF(-0.93326854705810547000)},
    {_DATAF(0.35882139205932617000),  _DATAF(-0.93340623378753662000)},
    {_DATAF(0.35846340656280518000),  _DATAF(-0.93354380130767822000)},
    {_DATAF(0.35810539126396179000),  _DATAF(-0.93368119001388550000)},
    {_DATAF(0.35774728655815125000),  _DATAF(-0.93381845951080322000)},
    {_DATAF(0.35738915205001831000),  _DATAF(-0.93395555019378662000)},
    {_DATAF(0.35703095793724060000),  _DATAF(-0.93409252166748047000)},
    {_DATAF(0.35667270421981812000),  _DATAF(-0.93422937393188477000)},
    {_DATAF(0.35631442070007324000),  _DATAF(-0.93436610698699951000)},
    {_DATAF(0.35595607757568359000),  _DATAF(-0.93450272083282471000)},
    {_DATAF(0.35559767484664917000),  _DATAF(-0.93463915586471558000)},
    {_DATAF(0.35523921251296997000),  _DATAF(-0.93477541208267212000)},
    {_DATAF(0.35488069057464600000),  _DATAF(-0.93491160869598389000)},
    {_DATAF(0.35452213883399963000),  _DATAF(-0.93504762649536133000)},
    {_DATAF(0.35416352748870850000),  _DATAF(-0.93518352508544922000)},
    {_DATAF(0.35380485653877258000),  _DATAF(-0.93531924486160278000)},
    {_DATAF(0.35344615578651428000),  _DATAF(-0.93545484542846680000)},
    {_DATAF(0.35308736562728882000),  _DATAF(-0.93559032678604126000)},
    {_DATAF(0.35272854566574097000),  _DATAF(-0.93572568893432617000)},
    {_DATAF(0.35236969590187073000),  _DATAF(-0.93586087226867676000)},
    {_DATAF(0.35201075673103333000),  _DATAF(-0.93599593639373779000)},
    {_DATAF(0.35165178775787354000),  _DATAF(-0.93613088130950928000)},
    {_DATAF(0.35129275918006897000),  _DATAF(-0.93626564741134644000)},
    {_DATAF(0.35093367099761963000),  _DATAF(-0.93640029430389404000)},
    {_DATAF(0.35057455301284790000),  _DATAF(-0.93653482198715210000)},
    {_DATAF(0.35021537542343140000),  _DATAF(-0.93666923046112061000)},
    {_DATAF(0.34985613822937012000),  _DATAF(-0.93680346012115479000)},
    {_DATAF(0.34949684143066406000),  _DATAF(-0.93693757057189941000)},
    {_DATAF(0.34913751482963562000),  _DATAF(-0.93707150220870972000)},
    {_DATAF(0.34877812862396240000),  _DATAF(-0.93720531463623047000)},
    {_DATAF(0.34841868281364441000),  _DATAF(-0.93733900785446167000)},
    {_DATAF(0.34805917739868164000),  _DATAF(-0.93747258186340332000)},
    {_DATAF(0.34769964218139648000),  _DATAF(-0.93760597705841064000)},
    {_DATAF(0.34734004735946655000),  _DATAF(-0.93773925304412842000)},
    {_DATAF(0.34698042273521423000),  _DATAF(-0.93787235021591187000)},
    {_DATAF(0.34662070870399475000),  _DATAF(-0.93800538778305054000)},
    {_DATAF(0.34626096487045288000),  _DATAF(-0.93813824653625488000)},
    {_DATAF(0.34590116143226624000),  _DATAF(-0.93827092647552490000)},
    {_DATAF(0.34554132819175720000),  _DATAF(-0.93840354681015015000)},
    {_DATAF(0.34518143534660339000),  _DATAF(-0.93853598833084106000)},
    {_DATAF(0.34482148289680481000),  _DATAF(-0.93866831064224243000)},
    {_DATAF(0.34446147084236145000),  _DATAF(-0.93880045413970947000)},
    {_DATAF(0.34410142898559570000),  _DATAF(-0.93893247842788696000)},
    {_DATAF(0.34374132752418518000),  _DATAF(-0.93906438350677490000)},
    {_DATAF(0.34338116645812988000),  _DATAF(-0.93919610977172852000)},
    {_DATAF(0.34302097558975220000),  _DATAF(-0.93932771682739258000)},
    {_DATAF(0.34266072511672974000),  _DATAF(-0.93945920467376709000)},
    {_DATAF(0.34230041503906250000),  _DATAF(-0.93959057331085205000)},
    {_DATAF(0.34194007515907288000),  _DATAF(-0.93972176313400269000)},
    {_DATAF(0.34157964587211609000),  _DATAF(-0.93985283374786377000)},
    {_DATAF(0.34121921658515930000),  _DATAF(-0.93998372554779053000)},
    {_DATAF(0.34085869789123535000),  _DATAF(-0.94011455774307251000)},
    {_DATAF(0.34049814939498901000),  _DATAF(-0.94024521112442017000)},
    {_DATAF(0.34013754129409790000),  _DATAF(-0.94037568569183350000)},
    {_DATAF(0.33977687358856201000),  _DATAF(-0.94050604104995728000)},
    {_DATAF(0.33941617608070374000),  _DATAF(-0.94063627719879150000)},
    {_DATAF(0.33905541896820068000),  _DATAF(-0.94076639413833618000)},
    {_DATAF(0.33869463205337524000),  _DATAF(-0.94089633226394653000)},
    {_DATAF(0.33833375573158264000),  _DATAF(-0.94102615118026733000)},
    {_DATAF(0.33797284960746765000),  _DATAF(-0.94115585088729858000)},
    {_DATAF(0.33761191368103027000),  _DATAF(-0.94128537178039551000)},
    {_DATAF(0.33725091814994812000),  _DATAF(-0.94141477346420288000)},
    {_DATAF(0.33688986301422119000),  _DATAF(-0.94154405593872070000)},
    {_DATAF(0.33652874827384949000),  _DATAF(-0.94167321920394897000)},
    {_DATAF(0.33616760373115540000),  _DATAF(-0.94180220365524292000)},
    {_DATAF(0.33580639958381653000),  _DATAF(-0.94193100929260254000)},
    {_DATAF(0.33544513583183289000),  _DATAF(-0.94205975532531738000)},
    {_DATAF(0.33508384227752686000),  _DATAF(-0.94218832254409790000)},
    {_DATAF(0.33472248911857605000),  _DATAF(-0.94231677055358887000)},
    {_DATAF(0.33436110615730286000),  _DATAF(-0.94244503974914551000)},
    {_DATAF(0.33399966359138489000),  _DATAF(-0.94257318973541260000)},
    {_DATAF(0.33363816142082214000),  _DATAF(-0.94270122051239014000)},
    {_DATAF(0.33327659964561462000),  _DATAF(-0.94282907247543335000)},
    {_DATAF(0.33291500806808472000),  _DATAF(-0.94295686483383179000)},
    {_DATAF(0.33255335688591003000),  _DATAF(-0.94308441877365112000)},
    {_DATAF(0.33219167590141296000),  _DATAF(-0.94321191310882568000)},
    {_DATAF(0.33182993531227112000),  _DATAF(-0.94333922863006592000)},
    {_DATAF(0.33146813511848450000),  _DATAF(-0.94346642494201660000)},
    {_DATAF(0.33110630512237549000),  _DATAF(-0.94359344244003296000)},
    {_DATAF(0.33074441552162170000),  _DATAF(-0.94372034072875977000)},
    {_DATAF(0.33038249611854553000),  _DATAF(-0.94384711980819702000)},
    {_DATAF(0.33002048730850220000),  _DATAF(-0.94397377967834473000)},
    {_DATAF(0.32965844869613647000),  _DATAF(-0.94410026073455811000)},
    {_DATAF(0.32929638028144836000),  _DATAF(-0.94422662258148193000)},
    {_DATAF(0.32893425226211548000),  _DATAF(-0.94435280561447144000)},
    {_DATAF(0.32857206463813782000),  _DATAF(-0.94447892904281616000)},
    {_DATAF(0.32820984721183777000),  _DATAF(-0.94460481405258179000)},
    {_DATAF(0.32784757018089294000),  _DATAF(-0.94473063945770264000)},
    {_DATAF(0.32748523354530334000),  _DATAF(-0.94485628604888916000)},
    {_DATAF(0.32712286710739136000),  _DATAF(-0.94498181343078613000)},
    {_DATAF(0.32676044106483459000),  _DATAF(-0.94510722160339355000)},
    {_DATAF(0.32639798521995544000),  _DATAF(-0.94523245096206665000)},
    {_DATAF(0.32603546977043152000),  _DATAF(-0.94535756111145020000)},
    {_DATAF(0.32567289471626282000),  _DATAF(-0.94548249244689941000)},
    {_DATAF(0.32531028985977173000),  _DATAF(-0.94560730457305908000)},
    {_DATAF(0.32494762539863586000),  _DATAF(-0.94573199748992920000)},
    {_DATAF(0.32458493113517761000),  _DATAF(-0.94585657119750977000)},
    {_DATAF(0.32422217726707458000),  _DATAF(-0.94598096609115601000)},
    {_DATAF(0.32385936379432678000),  _DATAF(-0.94610524177551270000)},
    {_DATAF(0.32349652051925659000),  _DATAF(-0.94622933864593506000)},
    {_DATAF(0.32313361763954163000),  _DATAF(-0.94635337591171265000)},
    {_DATAF(0.32277068495750427000),  _DATAF(-0.94647717475891113000)},
    {_DATAF(0.32240769267082214000),  _DATAF(-0.94660091400146484000)},
    {_DATAF(0.32204464077949524000),  _DATAF(-0.94672447443008423000)},
    {_DATAF(0.32168155908584595000),  _DATAF(-0.94684791564941406000)},
    {_DATAF(0.32131841778755188000),  _DATAF(-0.94697123765945435000)},
    {_DATAF(0.32095524668693542000),  _DATAF(-0.94709438085556030000)},
    {_DATAF(0.32059201598167419000),  _DATAF(-0.94721740484237671000)},
    {_DATAF(0.32022872567176819000),  _DATAF(-0.94734025001525879000)},
    {_DATAF(0.31986540555953979000),  _DATAF(-0.94746297597885132000)},
    {_DATAF(0.31950202584266663000),  _DATAF(-0.94758558273315430000)},
    {_DATAF(0.31913861632347107000),  _DATAF(-0.94770807027816772000)},
    {_DATAF(0.31877514719963074000),  _DATAF(-0.94783037900924683000)},
    {_DATAF(0.31841164827346802000),  _DATAF(-0.94795256853103638000)},
    {_DATAF(0.31804808974266052000),  _DATAF(-0.94807457923889160000)},
    {_DATAF(0.31768447160720825000),  _DATAF(-0.94819647073745728000)},
    {_DATAF(0.31732082366943359000),  _DATAF(-0.94831824302673340000)},
    {_DATAF(0.31695711612701416000),  _DATAF(-0.94843989610671997000)},
    {_DATAF(0.31659337878227234000),  _DATAF(-0.94856137037277222000)},
    {_DATAF(0.31622958183288574000),  _DATAF(-0.94868266582489014000)},
    {_DATAF(0.31586575508117676000),  _DATAF(-0.94880390167236328000)},
    {_DATAF(0.31550186872482300000),  _DATAF(-0.94892495870590210000)},
    {_DATAF(0.31513792276382446000),  _DATAF(-0.94904589653015137000)},
    {_DATAF(0.31477394700050354000),  _DATAF(-0.94916665554046631000)},
    {_DATAF(0.31440994143486023000),  _DATAF(-0.94928729534149170000)},
    {_DATAF(0.31404584646224976000),  _DATAF(-0.94940781593322754000)},
    {_DATAF(0.31368175148963928000),  _DATAF(-0.94952815771102905000)},
    {_DATAF(0.31331756711006165000),  _DATAF(-0.94964838027954102000)},
    {_DATAF(0.31295338273048401000),  _DATAF(-0.94976848363876343000)},
    {_DATAF(0.31258910894393921000),  _DATAF(-0.94988846778869629000)},
    {_DATAF(0.31222480535507202000),  _DATAF(-0.95000827312469482000)},
    {_DATAF(0.31186047196388245000),  _DATAF(-0.95012789964675903000)},
    {_DATAF(0.31149607896804810000),  _DATAF(-0.95024746656417847000)},
    {_DATAF(0.31113162636756897000),  _DATAF(-0.95036685466766357000)},
    {_DATAF(0.31076714396476746000),  _DATAF(-0.95048606395721436000)},
    {_DATAF(0.31040263175964355000),  _DATAF(-0.95060515403747559000)},
    {_DATAF(0.31003805994987488000),  _DATAF(-0.95072412490844727000)},
    {_DATAF(0.30967342853546143000),  _DATAF(-0.95084297657012939000)},
    {_DATAF(0.30930876731872559000),  _DATAF(-0.95096164941787720000)},
    {_DATAF(0.30894404649734497000),  _DATAF(-0.95108020305633545000)},
    {_DATAF(0.30857929587364197000),  _DATAF(-0.95119863748550415000)},
    {_DATAF(0.30821448564529419000),  _DATAF(-0.95131689310073853000)},
    {_DATAF(0.30784964561462402000),  _DATAF(-0.95143502950668335000)},
    {_DATAF(0.30748474597930908000),  _DATAF(-0.95155298709869385000)},
    {_DATAF(0.30711981654167175000),  _DATAF(-0.95167088508605957000)},
    {_DATAF(0.30675482749938965000),  _DATAF(-0.95178854465484619000)},
    {_DATAF(0.30638980865478516000),  _DATAF(-0.95190614461898804000)},
    {_DATAF(0.30602473020553589000),  _DATAF(-0.95202356576919556000)},
    {_DATAF(0.30565959215164185000),  _DATAF(-0.95214086771011353000)},
    {_DATAF(0.30529442429542542000),  _DATAF(-0.95225799083709717000)},
    {_DATAF(0.30492922663688660000),  _DATAF(-0.95237499475479126000)},
    {_DATAF(0.30456396937370300000),  _DATAF(-0.95249187946319580000)},
    {_DATAF(0.30419868230819702000),  _DATAF(-0.95260858535766602000)},
    {_DATAF(0.30383333563804626000),  _DATAF(-0.95272517204284668000)},
    {_DATAF(0.30346795916557312000),  _DATAF(-0.95284163951873779000)},
    {_DATAF(0.30310252308845520000),  _DATAF(-0.95295792818069458000)},
    {_DATAF(0.30273702740669250000),  _DATAF(-0.95307409763336182000)},
    {_DATAF(0.30237150192260742000),  _DATAF(-0.95319014787673950000)},
    {_DATAF(0.30200594663619995000),  _DATAF(-0.95330601930618286000)},
    {_DATAF(0.30164033174514771000),  _DATAF(-0.95342177152633667000)},
    {_DATAF(0.30127468705177307000),  _DATAF(-0.95353740453720093000)},
    {_DATAF(0.30090898275375366000),  _DATAF(-0.95365285873413086000)},
    {_DATAF(0.30054324865341187000),  _DATAF(-0.95376819372177124000)},
    {_DATAF(0.30017745494842529000),  _DATAF(-0.95388334989547729000)},
    {_DATAF(0.29981163144111633000),  _DATAF(-0.95399844646453857000)},
    {_DATAF(0.29944574832916260000),  _DATAF(-0.95411330461502075000)},
    {_DATAF(0.29907983541488647000),  _DATAF(-0.95422810316085815000)},
    {_DATAF(0.29871386289596558000),  _DATAF(-0.95434272289276123000)},
    {_DATAF(0.29834786057472229000),  _DATAF(-0.95445722341537476000)},
    {_DATAF(0.29798179864883423000),  _DATAF(-0.95457154512405396000)},
    {_DATAF(0.29761570692062378000),  _DATAF(-0.95468574762344360000)},
    {_DATAF(0.29724955558776855000),  _DATAF(-0.95479983091354370000)},
    {_DATAF(0.29688337445259094000),  _DATAF(-0.95491373538970947000)},
    {_DATAF(0.29651716351509094000),  _DATAF(-0.95502752065658569000)},
    {_DATAF(0.29615089297294617000),  _DATAF(-0.95514118671417236000)},
    {_DATAF(0.29578456282615662000),  _DATAF(-0.95525467395782471000)},
    {_DATAF(0.29541820287704468000),  _DATAF(-0.95536804199218750000)},
    {_DATAF(0.29505181312561035000),  _DATAF(-0.95548123121261597000)},
    {_DATAF(0.29468536376953125000),  _DATAF(-0.95559436082839966000)},
    {_DATAF(0.29431888461112976000),  _DATAF(-0.95570725202560425000)},
    {_DATAF(0.29395234584808350000),  _DATAF(-0.95582008361816406000)},
    {_DATAF(0.29358577728271484000),  _DATAF(-0.95593273639678955000)},
    {_DATAF(0.29321914911270142000),  _DATAF(-0.95604526996612549000)},
    {_DATAF(0.29285249114036560000),  _DATAF(-0.95615762472152710000)},
    {_DATAF(0.29248580336570740000),  _DATAF(-0.95626986026763916000)},
    {_DATAF(0.29211905598640442000),  _DATAF(-0.95638197660446167000)},
    {_DATAF(0.29175224900245667000),  _DATAF(-0.95649391412734985000)},
    {_DATAF(0.29138544201850891000),  _DATAF(-0.95660573244094849000)},
    {_DATAF(0.29101854562759399000),  _DATAF(-0.95671743154525757000)},
    {_DATAF(0.29065164923667908000),  _DATAF(-0.95682895183563232000)},
    {_DATAF(0.29028466343879700000),  _DATAF(-0.95694035291671753000)},
    {_DATAF(0.28991767764091492000),  _DATAF(-0.95705157518386841000)},
    {_DATAF(0.28955063223838806000),  _DATAF(-0.95716267824172974000)},
    {_DATAF(0.28918352723121643000),  _DATAF(-0.95727366209030151000)},
    {_DATAF(0.28881642222404480000),  _DATAF(-0.95738452672958374000)},
    {_DATAF(0.28844922780990601000),  _DATAF(-0.95749521255493164000)},
    {_DATAF(0.28808203339576721000),  _DATAF(-0.95760571956634521000)},
    {_DATAF(0.28771474957466125000),  _DATAF(-0.95771616697311401000)},
    {_DATAF(0.28734746575355530000),  _DATAF(-0.95782643556594849000)},
    {_DATAF(0.28698012232780457000),  _DATAF(-0.95793652534484863000)},
    {_DATAF(0.28661271929740906000),  _DATAF(-0.95804649591445923000)},
    {_DATAF(0.28624531626701355000),  _DATAF(-0.95815634727478027000)},
    {_DATAF(0.28587782382965088000),  _DATAF(-0.95826607942581177000)},
    {_DATAF(0.28551033139228821000),  _DATAF(-0.95837563276290894000)},
    {_DATAF(0.28514277935028076000),  _DATAF(-0.95848506689071655000)},
    {_DATAF(0.28477516770362854000),  _DATAF(-0.95859432220458984000)},
    {_DATAF(0.28440752625465393000),  _DATAF(-0.95870345830917358000)},
    {_DATAF(0.28403985500335693000),  _DATAF(-0.95881247520446777000)},
    {_DATAF(0.28367212414741516000),  _DATAF(-0.95892131328582764000)},
    {_DATAF(0.28330436348915100000),  _DATAF(-0.95903003215789795000)},
    {_DATAF(0.28293657302856445000),  _DATAF(-0.95913863182067871000)},
    {_DATAF(0.28256872296333313000),  _DATAF(-0.95924705266952515000)},
    {_DATAF(0.28220084309577942000),  _DATAF(-0.95935535430908203000)},
    {_DATAF(0.28183290362358093000),  _DATAF(-0.95946347713470459000)},
    {_DATAF(0.28146493434906006000),  _DATAF(-0.95957154035568237000)},
    {_DATAF(0.28109693527221680000),  _DATAF(-0.95967936515808105000)},
    {_DATAF(0.28072887659072876000),  _DATAF(-0.95978713035583496000)},
    {_DATAF(0.28036078810691833000),  _DATAF(-0.95989471673965454000)},
    {_DATAF(0.27999264001846313000),  _DATAF(-0.96000212430953979000)},
    {_DATAF(0.27962446212768555000),  _DATAF(-0.96010947227478027000)},
    {_DATAF(0.27925625443458557000),  _DATAF(-0.96021664142608643000)},
    {_DATAF(0.27888798713684082000),  _DATAF(-0.96032363176345825000)},
    {_DATAF(0.27851969003677368000),  _DATAF(-0.96043050289154053000)},
    {_DATAF(0.27815136313438416000),  _DATAF(-0.96053725481033325000)},
    {_DATAF(0.27778297662734985000),  _DATAF(-0.96064388751983643000)},
    {_DATAF(0.27741453051567078000),  _DATAF(-0.96075034141540527000)},
    {_DATAF(0.27704608440399170000),  _DATAF(-0.96085661649703979000)},
    {_DATAF(0.27667757868766785000),  _DATAF(-0.96096283197402954000)},
    {_DATAF(0.27630904316902161000),  _DATAF(-0.96106886863708496000)},
    {_DATAF(0.27594044804573059000),  _DATAF(-0.96117472648620605000)},
    {_DATAF(0.27557182312011719000),  _DATAF(-0.96128046512603760000)},
    {_DATAF(0.27520313858985901000),  _DATAF(-0.96138608455657959000)},
    {_DATAF(0.27483445405960083000),  _DATAF(-0.96149158477783203000)},
    {_DATAF(0.27446570992469788000),  _DATAF(-0.96159690618515015000)},
    {_DATAF(0.27409690618515015000),  _DATAF(-0.96170204877853394000)},
    {_DATAF(0.27372807264328003000),  _DATAF(-0.96180713176727295000)},
    {_DATAF(0.27335920929908752000),  _DATAF(-0.96191203594207764000)},
    {_DATAF(0.27299031615257263000),  _DATAF(-0.96201676130294800000)},
    {_DATAF(0.27262136340141296000),  _DATAF(-0.96212142705917358000)},
    {_DATAF(0.27225238084793091000),  _DATAF(-0.96222585439682007000)},
    {_DATAF(0.27188333868980408000),  _DATAF(-0.96233022212982178000)},
    {_DATAF(0.27151426672935486000),  _DATAF(-0.96243441104888916000)},
    {_DATAF(0.27114516496658325000),  _DATAF(-0.96253848075866699000)},
    {_DATAF(0.27077600359916687000),  _DATAF(-0.96264237165451050000)},
    {_DATAF(0.27040681242942810000),  _DATAF(-0.96274614334106445000)},
    {_DATAF(0.27003759145736694000),  _DATAF(-0.96284979581832886000)},
    {_DATAF(0.26966831088066101000),  _DATAF(-0.96295326948165894000)},
    {_DATAF(0.26929903030395508000),  _DATAF(-0.96305662393569946000)},
    {_DATAF(0.26892966032028198000),  _DATAF(-0.96315979957580566000)},
    {_DATAF(0.26856029033660889000),  _DATAF(-0.96326285600662231000)},
    {_DATAF(0.26819086074829102000),  _DATAF(-0.96336579322814941000)},
    {_DATAF(0.26782140135765076000),  _DATAF(-0.96346855163574219000)},
    {_DATAF(0.26745188236236572000),  _DATAF(-0.96357119083404541000)},
    {_DATAF(0.26708233356475830000),  _DATAF(-0.96367371082305908000)},
    {_DATAF(0.26671275496482849000),  _DATAF(-0.96377605199813843000)},
    {_DATAF(0.26634314656257629000),  _DATAF(-0.96387827396392822000)},
    {_DATAF(0.26597347855567932000),  _DATAF(-0.96398037672042847000)},
    {_DATAF(0.26560378074645996000),  _DATAF(-0.96408230066299438000)},
    {_DATAF(0.26523402333259583000),  _DATAF(-0.96418404579162598000)},
    {_DATAF(0.26486423611640930000),  _DATAF(-0.96428573131561279000)},
    {_DATAF(0.26449441909790039000),  _DATAF(-0.96438723802566528000)},
    {_DATAF(0.26412457227706909000),  _DATAF(-0.96448856592178345000)},
    {_DATAF(0.26375466585159302000),  _DATAF(-0.96458977460861206000)},
    {_DATAF(0.26338472962379456000),  _DATAF(-0.96469086408615112000)},
    {_DATAF(0.26301476359367371000),  _DATAF(-0.96479183435440063000)},
    {_DATAF(0.26264476776123047000),  _DATAF(-0.96489262580871582000)},
    {_DATAF(0.26227471232414246000),  _DATAF(-0.96499323844909668000)},
    {_DATAF(0.26190462708473206000),  _DATAF(-0.96509379148483276000)},
    {_DATAF(0.26153448224067688000),  _DATAF(-0.96519410610198975000)},
    {_DATAF(0.26116433739662170000),  _DATAF(-0.96529436111450195000)},
    {_DATAF(0.26079410314559937000),  _DATAF(-0.96539443731307983000)},
    {_DATAF(0.26042386889457703000),  _DATAF(-0.96549439430236816000)},
    {_DATAF(0.26005360484123230000),  _DATAF(-0.96559417247772217000)},
    {_DATAF(0.25968328118324280000),  _DATAF(-0.96569383144378662000)},
    {_DATAF(0.25931292772293091000),  _DATAF(-0.96579337120056152000)},
    {_DATAF(0.25894251465797424000),  _DATAF(-0.96589273214340210000)},
    {_DATAF(0.25857207179069519000),  _DATAF(-0.96599197387695313000)},
    {_DATAF(0.25820159912109375000),  _DATAF(-0.96609103679656982000)},
    {_DATAF(0.25783109664916992000),  _DATAF(-0.96618998050689697000)},
    {_DATAF(0.25746056437492371000),  _DATAF(-0.96628880500793457000)},
    {_DATAF(0.25708997249603271000),  _DATAF(-0.96638745069503784000)},
    {_DATAF(0.25671935081481934000),  _DATAF(-0.96648597717285156000)},
    {_DATAF(0.25634866952896118000),  _DATAF(-0.96658438444137573000)},
    {_DATAF(0.25597798824310303000),  _DATAF(-0.96668261289596558000)},
    {_DATAF(0.25560724735260010000),  _DATAF(-0.96678072214126587000)},
    {_DATAF(0.25523647665977478000),  _DATAF(-0.96687865257263184000)},
    {_DATAF(0.25486564636230469000),  _DATAF(-0.96697646379470825000)},
    {_DATAF(0.25449481606483459000),  _DATAF(-0.96707415580749512000)},
    {_DATAF(0.25412392616271973000),  _DATAF(-0.96717166900634766000)},
    {_DATAF(0.25375300645828247000),  _DATAF(-0.96726906299591064000)},
    {_DATAF(0.25338202714920044000),  _DATAF(-0.96736627817153931000)},
    {_DATAF(0.25301104784011841000),  _DATAF(-0.96746337413787842000)},
    {_DATAF(0.25264000892639160000),  _DATAF(-0.96756035089492798000)},
    {_DATAF(0.25226894021034241000),  _DATAF(-0.96765714883804321000)},
    {_DATAF(0.25189781188964844000),  _DATAF(-0.96775382757186890000)},
    {_DATAF(0.25152668356895447000),  _DATAF(-0.96785038709640503000)},
    {_DATAF(0.25115549564361572000),  _DATAF(-0.96794676780700684000)},
    {_DATAF(0.25078427791595459000),  _DATAF(-0.96804302930831909000)},
    {_DATAF(0.25041300058364868000),  _DATAF(-0.96813911199569702000)},
    {_DATAF(0.25004172325134277000),  _DATAF(-0.96823507547378540000)},
    {_DATAF(0.24967038631439209000),  _DATAF(-0.96833086013793945000)},
    {_DATAF(0.24929900467395782000),  _DATAF(-0.96842658519744873000)},
    {_DATAF(0.24892760813236237000),  _DATAF(-0.96852207183837891000)},
    {_DATAF(0.24855616688728333000),  _DATAF(-0.96861749887466431000)},
    {_DATAF(0.24818468093872070000),  _DATAF(-0.96871274709701538000)},
    {_DATAF(0.24781316518783569000),  _DATAF(-0.96880781650543213000)},
    {_DATAF(0.24744161963462830000),  _DATAF(-0.96890282630920410000)},
    {_DATAF(0.24707002937793732000),  _DATAF(-0.96899759769439697000)},
    {_DATAF(0.24669840931892395000),  _DATAF(-0.96909230947494507000)},
    {_DATAF(0.24632674455642700000),  _DATAF(-0.96918684244155884000)},
    {_DATAF(0.24595504999160767000),  _DATAF(-0.96928125619888306000)},
    {_DATAF(0.24558331072330475000),  _DATAF(-0.96937549114227295000)},
    {_DATAF(0.24521154165267944000),  _DATAF(-0.96946960687637329000)},
    {_DATAF(0.24483974277973175000),  _DATAF(-0.96956354379653931000)},
    {_DATAF(0.24446789920330048000),  _DATAF(-0.96965736150741577000)},
    {_DATAF(0.24409602582454681000),  _DATAF(-0.96975106000900269000)},
    {_DATAF(0.24372410774230957000),  _DATAF(-0.96984457969665527000)},
    {_DATAF(0.24335215985774994000),  _DATAF(-0.96993798017501831000)},
    {_DATAF(0.24298018217086792000),  _DATAF(-0.97003126144409180000)},
    {_DATAF(0.24260815978050232000),  _DATAF(-0.97012436389923096000)},
    {_DATAF(0.24223610758781433000),  _DATAF(-0.97021734714508057000)},
    {_DATAF(0.24186401069164276000),  _DATAF(-0.97031015157699585000)},
    {_DATAF(0.24149188399314880000),  _DATAF(-0.97040283679962158000)},
    {_DATAF(0.24111972749233246000),  _DATAF(-0.97049540281295776000)},
    {_DATAF(0.24074752628803253000),  _DATAF(-0.97058779001235962000)},
    {_DATAF(0.24037529528141022000),  _DATAF(-0.97068005800247192000)},
    {_DATAF(0.24000301957130432000),  _DATAF(-0.97077214717864990000)},
    {_DATAF(0.23963071405887604000),  _DATAF(-0.97086411714553833000)},
    {_DATAF(0.23925837874412537000),  _DATAF(-0.97095590829849243000)},
    {_DATAF(0.23888599872589111000),  _DATAF(-0.97104763984680176000)},
    {_DATAF(0.23851358890533447000),  _DATAF(-0.97113913297653198000)},
    {_DATAF(0.23814114928245544000),  _DATAF(-0.97123056650161743000)},
    {_DATAF(0.23776866495609283000),  _DATAF(-0.97132182121276855000)},
    {_DATAF(0.23739615082740784000),  _DATAF(-0.97141289710998535000)},
    {_DATAF(0.23702360689640045000),  _DATAF(-0.97150391340255737000)},
    {_DATAF(0.23665101826190948000),  _DATAF(-0.97159469127655029000)},
    {_DATAF(0.23627839982509613000),  _DATAF(-0.97168540954589844000)},
    {_DATAF(0.23590575158596039000),  _DATAF(-0.97177594900131226000)},
    {_DATAF(0.23553305864334106000),  _DATAF(-0.97186630964279175000)},
    {_DATAF(0.23516033589839935000),  _DATAF(-0.97195661067962646000)},
    {_DATAF(0.23478758335113525000),  _DATAF(-0.97204673290252686000)},
    {_DATAF(0.23441478610038757000),  _DATAF(-0.97213667631149292000)},
    {_DATAF(0.23404195904731750000),  _DATAF(-0.97222650051116943000)},
    {_DATAF(0.23366910219192505000),  _DATAF(-0.97231620550155640000)},
    {_DATAF(0.23329620063304901000),  _DATAF(-0.97240573167800903000)},
    {_DATAF(0.23292326927185059000),  _DATAF(-0.97249513864517212000)},
    {_DATAF(0.23255030810832977000),  _DATAF(-0.97258436679840088000)},
    {_DATAF(0.23217730224132538000),  _DATAF(-0.97267347574234009000)},
    {_DATAF(0.23180428147315979000),  _DATAF(-0.97276246547698975000)},
    {_DATAF(0.23143121600151062000),  _DATAF(-0.97285127639770508000)},
    {_DATAF(0.23105810582637787000),  _DATAF(-0.97293996810913086000)},
    {_DATAF(0.23068498075008392000),  _DATAF(-0.97302848100662231000)},
    {_DATAF(0.23031181097030640000),  _DATAF(-0.97311687469482422000)},
    {_DATAF(0.22993859648704529000),  _DATAF(-0.97320514917373657000)},
    {_DATAF(0.22956536710262299000),  _DATAF(-0.97329324483871460000)},
    {_DATAF(0.22919209301471710000),  _DATAF(-0.97338122129440308000)},
    {_DATAF(0.22881878912448883000),  _DATAF(-0.97346901893615723000)},
    {_DATAF(0.22844545543193817000),  _DATAF(-0.97355669736862183000)},
    {_DATAF(0.22807207703590393000),  _DATAF(-0.97364425659179688000)},
    {_DATAF(0.22769868373870850000),  _DATAF(-0.97373163700103760000)},
    {_DATAF(0.22732524573802948000),  _DATAF(-0.97381889820098877000)},
    {_DATAF(0.22695176303386688000),  _DATAF(-0.97390598058700562000)},
    {_DATAF(0.22657826542854309000),  _DATAF(-0.97399294376373291000)},
    {_DATAF(0.22620472311973572000),  _DATAF(-0.97407978773117065000)},
    {_DATAF(0.22583115100860596000),  _DATAF(-0.97416645288467407000)},
    {_DATAF(0.22545754909515381000),  _DATAF(-0.97425299882888794000)},
    {_DATAF(0.22508391737937927000),  _DATAF(-0.97433936595916748000)},
    {_DATAF(0.22471024096012115000),  _DATAF(-0.97442561388015747000)},
    {_DATAF(0.22433653473854065000),  _DATAF(-0.97451174259185791000)},
    {_DATAF(0.22396279871463776000),  _DATAF(-0.97459769248962402000)},
    {_DATAF(0.22358903288841248000),  _DATAF(-0.97468352317810059000)},
    {_DATAF(0.22321522235870361000),  _DATAF(-0.97476917505264282000)},
    {_DATAF(0.22284139692783356000),  _DATAF(-0.97485470771789551000)},
    {_DATAF(0.22246752679347992000),  _DATAF(-0.97494012117385864000)},
    {_DATAF(0.22209362685680389000),  _DATAF(-0.97502535581588745000)},
    {_DATAF(0.22171968221664429000),  _DATAF(-0.97511047124862671000)},
    {_DATAF(0.22134572267532349000),  _DATAF(-0.97519540786743164000)},
    {_DATAF(0.22097171843051910000),  _DATAF(-0.97528022527694702000)},
    {_DATAF(0.22059768438339233000),  _DATAF(-0.97536486387252808000)},
    {_DATAF(0.22022362053394318000),  _DATAF(-0.97544938325881958000)},
    {_DATAF(0.21984952688217163000),  _DATAF(-0.97553378343582153000)},
    {_DATAF(0.21947540342807770000),  _DATAF(-0.97561800479888916000)},
    {_DATAF(0.21910123527050018000),  _DATAF(-0.97570210695266724000)},
    {_DATAF(0.21872705221176147000),  _DATAF(-0.97578608989715576000)},
    {_DATAF(0.21835282444953918000),  _DATAF(-0.97586989402770996000)},
    {_DATAF(0.21797856688499451000),  _DATAF(-0.97595357894897461000)},
    {_DATAF(0.21760427951812744000),  _DATAF(-0.97603708505630493000)},
    {_DATAF(0.21722994744777679000),  _DATAF(-0.97612047195434570000)},
    {_DATAF(0.21685560047626495000),  _DATAF(-0.97620368003845215000)},
    {_DATAF(0.21648120880126953000),  _DATAF(-0.97628676891326904000)},
    {_DATAF(0.21610680222511292000),  _DATAF(-0.97636973857879639000)},
    {_DATAF(0.21573235094547272000),  _DATAF(-0.97645252943038940000)},
    {_DATAF(0.21535786986351013000),  _DATAF(-0.97653520107269287000)},
    {_DATAF(0.21498335897922516000),  _DATAF(-0.97661769390106201000)},
    {_DATAF(0.21460881829261780000),  _DATAF(-0.97670006752014160000)},
    {_DATAF(0.21423423290252686000),  _DATAF(-0.97678232192993164000)},
    {_DATAF(0.21385963261127472000),  _DATAF(-0.97686439752578735000)},
    {_DATAF(0.21348498761653900000),  _DATAF(-0.97694635391235352000)},
    {_DATAF(0.21311031281948090000),  _DATAF(-0.97702813148498535000)},
    {_DATAF(0.21273562312126160000),  _DATAF(-0.97710978984832764000)},
    {_DATAF(0.21236088871955872000),  _DATAF(-0.97719132900238037000)},
    {_DATAF(0.21198612451553345000),  _DATAF(-0.97727268934249878000)},
    {_DATAF(0.21161133050918579000),  _DATAF(-0.97735387086868286000)},
    {_DATAF(0.21123650670051575000),  _DATAF(-0.97743499279022217000)},
    {_DATAF(0.21086163818836212000),  _DATAF(-0.97751593589782715000)},
    {_DATAF(0.21048675477504730000),  _DATAF(-0.97759670019149780000)},
    {_DATAF(0.21011184155941010000),  _DATAF(-0.97767734527587891000)},
    {_DATAF(0.20973688364028931000),  _DATAF(-0.97775787115097046000)},
    {_DATAF(0.20936191082000732000),  _DATAF(-0.97783821821212769000)},
    {_DATAF(0.20898689329624176000),  _DATAF(-0.97791844606399536000)},
    {_DATAF(0.20861184597015381000),  _DATAF(-0.97799849510192871000)},
    {_DATAF(0.20823678374290466000),  _DATAF(-0.97807842493057251000)},
    {_DATAF(0.20786167681217194000),  _DATAF(-0.97815823554992676000)},
    {_DATAF(0.20748654007911682000),  _DATAF(-0.97823786735534668000)},
    {_DATAF(0.20711137354373932000),  _DATAF(-0.97831737995147705000)},
    {_DATAF(0.20673617720603943000),  _DATAF(-0.97839671373367310000)},
    {_DATAF(0.20636095106601715000),  _DATAF(-0.97847592830657959000)},
    {_DATAF(0.20598569512367249000),  _DATAF(-0.97855502367019653000)},
    {_DATAF(0.20561040937900543000),  _DATAF(-0.97863394021987915000)},
    {_DATAF(0.20523509383201599000),  _DATAF(-0.97871267795562744000)},
    {_DATAF(0.20485974848270416000),  _DATAF(-0.97879135608673096000)},
    {_DATAF(0.20448437333106995000),  _DATAF(-0.97886985540390015000)},
    {_DATAF(0.20410896837711334000),  _DATAF(-0.97894817590713501000)},
    {_DATAF(0.20373353362083435000),  _DATAF(-0.97902637720108032000)},
    {_DATAF(0.20335806906223297000),  _DATAF(-0.97910445928573608000)},
    {_DATAF(0.20298255980014801000),  _DATAF(-0.97918236255645752000)},
    {_DATAF(0.20260703563690186000),  _DATAF(-0.97926014661788940000)},
    {_DATAF(0.20223148167133331000),  _DATAF(-0.97933775186538696000)},
    {_DATAF(0.20185589790344238000),  _DATAF(-0.97941523790359497000)},
    {_DATAF(0.20148028433322906000),  _DATAF(-0.97949254512786865000)},
    {_DATAF(0.20110464096069336000),  _DATAF(-0.97956979274749756000)},
    {_DATAF(0.20072895288467407000),  _DATAF(-0.97964680194854736000)},
    {_DATAF(0.20035324990749359000),  _DATAF(-0.97972375154495239000)},
    {_DATAF(0.19997751712799072000),  _DATAF(-0.97980046272277832000)},
    {_DATAF(0.19960175454616547000),  _DATAF(-0.97987711429595947000)},
    {_DATAF(0.19922596216201782000),  _DATAF(-0.97995358705520630000)},
    {_DATAF(0.19885013997554779000),  _DATAF(-0.98002988100051880000)},
    {_DATAF(0.19847428798675537000),  _DATAF(-0.98010611534118652000)},
    {_DATAF(0.19809840619564056000),  _DATAF(-0.98018211126327515000)},
    {_DATAF(0.19772249460220337000),  _DATAF(-0.98025804758071899000)},
    {_DATAF(0.19734656810760498000),  _DATAF(-0.98033380508422852000)},
    {_DATAF(0.19697059690952301000),  _DATAF(-0.98040938377380371000)},
    {_DATAF(0.19659459590911865000),  _DATAF(-0.98048484325408936000)},
    {_DATAF(0.19621856510639191000),  _DATAF(-0.98056018352508545000)},
    {_DATAF(0.19584251940250397000),  _DATAF(-0.98063534498214722000)},
    {_DATAF(0.19546642899513245000),  _DATAF(-0.98071038722991943000)},
    {_DATAF(0.19509032368659973000),  _DATAF(-0.98078525066375732000)},
    {_DATAF(0.19471418857574463000),  _DATAF(-0.98085999488830566000)},
    {_DATAF(0.19433800876140594000),  _DATAF(-0.98093461990356445000)},
    {_DATAF(0.19396181404590607000),  _DATAF(-0.98100906610488892000)},
    {_DATAF(0.19358558952808380000),  _DATAF(-0.98108339309692383000)},
    {_DATAF(0.19320933520793915000),  _DATAF(-0.98115754127502441000)},
    {_DATAF(0.19283305108547211000),  _DATAF(-0.98123157024383545000)},
    {_DATAF(0.19245673716068268000),  _DATAF(-0.98130548000335693000)},
    {_DATAF(0.19208039343357086000),  _DATAF(-0.98137921094894409000)},
    {_DATAF(0.19170403480529785000),  _DATAF(-0.98145276308059692000)},
    {_DATAF(0.19132763147354126000),  _DATAF(-0.98152625560760498000)},
    {_DATAF(0.19095121324062347000),  _DATAF(-0.98159950971603394000)},
    {_DATAF(0.19057475030422211000),  _DATAF(-0.98167270421981812000)},
    {_DATAF(0.19019827246665955000),  _DATAF(-0.98174571990966797000)},
    {_DATAF(0.18982176482677460000),  _DATAF(-0.98181855678558350000)},
    {_DATAF(0.18944522738456726000),  _DATAF(-0.98189127445220947000)},
    {_DATAF(0.18906866014003754000),  _DATAF(-0.98196387290954590000)},
    {_DATAF(0.18869207799434662000),  _DATAF(-0.98203629255294800000)},
    {_DATAF(0.18831545114517212000),  _DATAF(-0.98210859298706055000)},
    {_DATAF(0.18793880939483643000),  _DATAF(-0.98218071460723877000)},
    {_DATAF(0.18756212294101715000),  _DATAF(-0.98225271701812744000)},
    {_DATAF(0.18718542158603668000),  _DATAF(-0.98232460021972656000)},
    {_DATAF(0.18680869042873383000),  _DATAF(-0.98239630460739136000)},
    {_DATAF(0.18643194437026978000),  _DATAF(-0.98246788978576660000)},
    {_DATAF(0.18605515360832214000),  _DATAF(-0.98253929615020752000)},
    {_DATAF(0.18567833304405212000),  _DATAF(-0.98261058330535889000)},
    {_DATAF(0.18530149757862091000),  _DATAF(-0.98268169164657593000)},
    {_DATAF(0.18492463231086731000),  _DATAF(-0.98275268077850342000)},
    {_DATAF(0.18454773724079132000),  _DATAF(-0.98282355070114136000)},
    {_DATAF(0.18417081236839294000),  _DATAF(-0.98289424180984497000)},
    {_DATAF(0.18379387259483337000),  _DATAF(-0.98296481370925903000)},
    {_DATAF(0.18341688811779022000),  _DATAF(-0.98303520679473877000)},
    {_DATAF(0.18303988873958588000),  _DATAF(-0.98310548067092896000)},
    {_DATAF(0.18266285955905914000),  _DATAF(-0.98317563533782959000)},
    {_DATAF(0.18228580057621002000),  _DATAF(-0.98324561119079590000)},
    {_DATAF(0.18190871179103851000),  _DATAF(-0.98331540822982788000)},
    {_DATAF(0.18153160810470581000),  _DATAF(-0.98338508605957031000)},
    {_DATAF(0.18115447461605072000),  _DATAF(-0.98345464468002319000)},
    {_DATAF(0.18077731132507324000),  _DATAF(-0.98352402448654175000)},
    {_DATAF(0.18040011823177338000),  _DATAF(-0.98359328508377075000)},
    {_DATAF(0.18002289533615112000),  _DATAF(-0.98366242647171021000)},
    {_DATAF(0.17964565753936768000),  _DATAF(-0.98373138904571533000)},
    {_DATAF(0.17926838994026184000),  _DATAF(-0.98380023241043091000)},
    {_DATAF(0.17889109253883362000),  _DATAF(-0.98386889696121216000)},
    {_DATAF(0.17851376533508301000),  _DATAF(-0.98393744230270386000)},
    {_DATAF(0.17813642323017120000),  _DATAF(-0.98400580883026123000)},
    {_DATAF(0.17775905132293701000),  _DATAF(-0.98407405614852905000)},
    {_DATAF(0.17738164961338043000),  _DATAF(-0.98414212465286255000)},
    {_DATAF(0.17700421810150146000),  _DATAF(-0.98421007394790649000)},
    {_DATAF(0.17662677168846130000),  _DATAF(-0.98427790403366089000)},
    {_DATAF(0.17624929547309875000),  _DATAF(-0.98434555530548096000)},
    {_DATAF(0.17587178945541382000),  _DATAF(-0.98441308736801147000)},
    {_DATAF(0.17549425363540649000),  _DATAF(-0.98448044061660767000)},
    {_DATAF(0.17511670291423798000),  _DATAF(-0.98454767465591431000)},
    {_DATAF(0.17473910748958588000),  _DATAF(-0.98461478948593140000)},
    {_DATAF(0.17436151206493378000),  _DATAF(-0.98468172550201416000)},
    {_DATAF(0.17398387193679810000),  _DATAF(-0.98474848270416260000)},
    {_DATAF(0.17360621690750122000),  _DATAF(-0.98481518030166626000)},
    {_DATAF(0.17322853207588196000),  _DATAF(-0.98488163948059082000)},
    {_DATAF(0.17285081744194031000),  _DATAF(-0.98494803905487061000)},
    {_DATAF(0.17247308790683746000),  _DATAF(-0.98501425981521606000)},
    {_DATAF(0.17209532856941223000),  _DATAF(-0.98508030176162720000)},
    {_DATAF(0.17171753942966461000),  _DATAF(-0.98514622449874878000)},
    {_DATAF(0.17133972048759460000),  _DATAF(-0.98521202802658081000)},
    {_DATAF(0.17096188664436340000),  _DATAF(-0.98527765274047852000)},
    {_DATAF(0.17058402299880981000),  _DATAF(-0.98534315824508667000)},
    {_DATAF(0.17020614445209503000),  _DATAF(-0.98540848493576050000)},
    {_DATAF(0.16982822120189667000),  _DATAF(-0.98547369241714478000)},
    {_DATAF(0.16945029795169830000),  _DATAF(-0.98553872108459473000)},
    {_DATAF(0.16907232999801636000),  _DATAF(-0.98560363054275513000)},
    {_DATAF(0.16869434714317322000),  _DATAF(-0.98566842079162598000)},
    {_DATAF(0.16831633448600769000),  _DATAF(-0.98573303222656250000)},
    {_DATAF(0.16793829202651978000),  _DATAF(-0.98579752445220947000)},
    {_DATAF(0.16756023466587067000),  _DATAF(-0.98586183786392212000)},
    {_DATAF(0.16718214750289917000),  _DATAF(-0.98592603206634521000)},
    {_DATAF(0.16680404543876648000),  _DATAF(-0.98599004745483398000)},
    {_DATAF(0.16642589867115021000),  _DATAF(-0.98605394363403320000)},
    {_DATAF(0.16604773700237274000),  _DATAF(-0.98611772060394287000)},
    {_DATAF(0.16566956043243408000),  _DATAF(-0.98618131875991821000)},
    {_DATAF(0.16529135406017303000),  _DATAF(-0.98624479770660400000)},
    {_DATAF(0.16491311788558960000),  _DATAF(-0.98630809783935547000)},
    {_DATAF(0.16453486680984497000),  _DATAF(-0.98637127876281738000)},
    {_DATAF(0.16415658593177795000),  _DATAF(-0.98643428087234497000)},
    {_DATAF(0.16377827525138855000),  _DATAF(-0.98649716377258301000)},
    {_DATAF(0.16339994966983795000),  _DATAF(-0.98655992746353149000)},
    {_DATAF(0.16302159428596497000),  _DATAF(-0.98662251234054565000)},
    {_DATAF(0.16264322400093079000),  _DATAF(-0.98668491840362549000)},
    {_DATAF(0.16226482391357422000),  _DATAF(-0.98674726486206055000)},
    {_DATAF(0.16188639402389526000),  _DATAF(-0.98680937290191650000)},
    {_DATAF(0.16150794923305511000),  _DATAF(-0.98687142133712769000)},
    {_DATAF(0.16112947463989258000),  _DATAF(-0.98693329095840454000)},
    {_DATAF(0.16075097024440765000),  _DATAF(-0.98699498176574707000)},
    {_DATAF(0.16037245094776154000),  _DATAF(-0.98705655336380005000)},
    {_DATAF(0.15999391674995422000),  _DATAF(-0.98711800575256348000)},
    {_DATAF(0.15961535274982452000),  _DATAF(-0.98717927932739258000)},
    {_DATAF(0.15923675894737244000),  _DATAF(-0.98724043369293213000)},
    {_DATAF(0.15885815024375916000),  _DATAF(-0.98730140924453735000)},
    {_DATAF(0.15847951173782349000),  _DATAF(-0.98736226558685303000)},
    {_DATAF(0.15810084342956543000),  _DATAF(-0.98742294311523438000)},
    {_DATAF(0.15772216022014618000),  _DATAF(-0.98748350143432617000)},
    {_DATAF(0.15734346210956573000),  _DATAF(-0.98754394054412842000)},
    {_DATAF(0.15696471929550171000),  _DATAF(-0.98760420083999634000)},
    {_DATAF(0.15658597648143768000),  _DATAF(-0.98766434192657471000)},
    {_DATAF(0.15620720386505127000),  _DATAF(-0.98772430419921875000)},
    {_DATAF(0.15582840144634247000),  _DATAF(-0.98778414726257324000)},
    {_DATAF(0.15544956922531128000),  _DATAF(-0.98784381151199341000)},
    {_DATAF(0.15507073700428009000),  _DATAF(-0.98790335655212402000)},
    {_DATAF(0.15469186007976532000),  _DATAF(-0.98796278238296509000)},
    {_DATAF(0.15431296825408936000),  _DATAF(-0.98802202939987183000)},
    {_DATAF(0.15393406152725220000),  _DATAF(-0.98808109760284424000)},
    {_DATAF(0.15355512499809265000),  _DATAF(-0.98814010620117188000)},
    {_DATAF(0.15317615866661072000),  _DATAF(-0.98819887638092041000)},
    {_DATAF(0.15279719233512878000),  _DATAF(-0.98825758695602417000)},
    {_DATAF(0.15241818130016327000),  _DATAF(-0.98831611871719360000)},
    {_DATAF(0.15203915536403656000),  _DATAF(-0.98837447166442871000)},
    {_DATAF(0.15166011452674866000),  _DATAF(-0.98843270540237427000)},
    {_DATAF(0.15128104388713837000),  _DATAF(-0.98849081993103027000)},
    {_DATAF(0.15090194344520569000),  _DATAF(-0.98854875564575195000)},
    {_DATAF(0.15052282810211182000),  _DATAF(-0.98860651254653931000)},
    {_DATAF(0.15014369785785675000),  _DATAF(-0.98866420984268188000)},
    {_DATAF(0.14976453781127930000),  _DATAF(-0.98872166872024536000)},
    {_DATAF(0.14938534796237946000),  _DATAF(-0.98877906799316406000)},
    {_DATAF(0.14900614321231842000),  _DATAF(-0.98883628845214844000)},
    {_DATAF(0.14862692356109619000),  _DATAF(-0.98889333009719849000)},
    {_DATAF(0.14824767410755157000),  _DATAF(-0.98895025253295898000)},
    {_DATAF(0.14786840975284576000),  _DATAF(-0.98900705575942993000)},
    {_DATAF(0.14748911559581757000),  _DATAF(-0.98906368017196655000)},
    {_DATAF(0.14710980653762817000),  _DATAF(-0.98912018537521362000)},
    {_DATAF(0.14673046767711639000),  _DATAF(-0.98917651176452637000)},
    {_DATAF(0.14635111391544342000),  _DATAF(-0.98923271894454956000)},
    {_DATAF(0.14597174525260925000),  _DATAF(-0.98928874731063843000)},
    {_DATAF(0.14559234678745270000),  _DATAF(-0.98934465646743774000)},
    {_DATAF(0.14521291851997375000),  _DATAF(-0.98940044641494751000)},
    {_DATAF(0.14483349025249481000),  _DATAF(-0.98945605754852295000)},
    {_DATAF(0.14445401728153229000),  _DATAF(-0.98951148986816406000)},
    {_DATAF(0.14407454431056976000),  _DATAF(-0.98956686258316040000)},
    {_DATAF(0.14369502663612366000),  _DATAF(-0.98962199687957764000)},
    {_DATAF(0.14331550896167755000),  _DATAF(-0.98967707157135010000)},
    {_DATAF(0.14293596148490906000),  _DATAF(-0.98973196744918823000)},
    {_DATAF(0.14255639910697937000),  _DATAF(-0.98978668451309204000)},
    {_DATAF(0.14217680692672729000),  _DATAF(-0.98984128236770630000)},
    {_DATAF(0.14179719984531403000),  _DATAF(-0.98989570140838623000)},
    {_DATAF(0.14141756296157837000),  _DATAF(-0.98995006084442139000)},
    {_DATAF(0.14103791117668152000),  _DATAF(-0.99000418186187744000)},
    {_DATAF(0.14065824449062347000),  _DATAF(-0.99005818367004395000)},
    {_DATAF(0.14027854800224304000),  _DATAF(-0.99011206626892090000)},
    {_DATAF(0.13989883661270142000),  _DATAF(-0.99016582965850830000)},
    {_DATAF(0.13951909542083740000),  _DATAF(-0.99021935462951660000)},
    {_DATAF(0.13913933932781219000),  _DATAF(-0.99027281999588013000)},
    {_DATAF(0.13875956833362579000),  _DATAF(-0.99032610654830933000)},
    {_DATAF(0.13837976753711700000),  _DATAF(-0.99037921428680420000)},
    {_DATAF(0.13799995183944702000),  _DATAF(-0.99043226242065430000)},
    {_DATAF(0.13762012124061584000),  _DATAF(-0.99048507213592529000)},
    {_DATAF(0.13724026083946228000),  _DATAF(-0.99053776264190674000)},
    {_DATAF(0.13686038553714752000),  _DATAF(-0.99059033393859863000)},
    {_DATAF(0.13648049533367157000),  _DATAF(-0.99064278602600098000)},
    {_DATAF(0.13610057532787323000),  _DATAF(-0.99069499969482422000)},
    {_DATAF(0.13572064042091370000),  _DATAF(-0.99074715375900269000)},
    {_DATAF(0.13534067571163177000),  _DATAF(-0.99079912900924683000)},
    {_DATAF(0.13496071100234985000),  _DATAF(-0.99085092544555664000)},
    {_DATAF(0.13458070158958435000),  _DATAF(-0.99090266227722168000)},
    {_DATAF(0.13420069217681885000),  _DATAF(-0.99095416069030762000)},
    {_DATAF(0.13382065296173096000),  _DATAF(-0.99100553989410400000)},
    {_DATAF(0.13344059884548187000),  _DATAF(-0.99105679988861084000)},
    {_DATAF(0.13306052982807159000),  _DATAF(-0.99110794067382813000)},
    {_DATAF(0.13268043100833893000),  _DATAF(-0.99115884304046631000)},
    {_DATAF(0.13230031728744507000),  _DATAF(-0.99120968580245972000)},
    {_DATAF(0.13192018866539001000),  _DATAF(-0.99126034975051880000)},
    {_DATAF(0.13154003024101257000),  _DATAF(-0.99131083488464355000)},
    {_DATAF(0.13115985691547394000),  _DATAF(-0.99136126041412354000)},
    {_DATAF(0.13077966868877411000),  _DATAF(-0.99141144752502441000)},
    {_DATAF(0.13039945065975189000),  _DATAF(-0.99146151542663574000)},
    {_DATAF(0.13001921772956848000),  _DATAF(-0.99151146411895752000)},
    {_DATAF(0.12963896989822388000),  _DATAF(-0.99156123399734497000)},
    {_DATAF(0.12925870716571808000),  _DATAF(-0.99161088466644287000)},
    {_DATAF(0.12887841463088989000),  _DATAF(-0.99166041612625122000)},
    {_DATAF(0.12849810719490051000),  _DATAF(-0.99170976877212524000)},
    {_DATAF(0.12811778485774994000),  _DATAF(-0.99175894260406494000)},
    {_DATAF(0.12773744761943817000),  _DATAF(-0.99180799722671509000)},
    {_DATAF(0.12735708057880402000),  _DATAF(-0.99185693264007568000)},
    {_DATAF(0.12697669863700867000),  _DATAF(-0.99190568923950195000)},
    {_DATAF(0.12659630179405212000),  _DATAF(-0.99195432662963867000)},
    {_DATAF(0.12621587514877319000),  _DATAF(-0.99200278520584106000)},
    {_DATAF(0.12583543360233307000),  _DATAF(-0.99205112457275391000)},
    {_DATAF(0.12545497715473175000),  _DATAF(-0.99209928512573242000)},
    {_DATAF(0.12507450580596924000),  _DATAF(-0.99214732646942139000)},
    {_DATAF(0.12469401955604553000),  _DATAF(-0.99219524860382080000)},
    {_DATAF(0.12431350350379944000),  _DATAF(-0.99224299192428589000)},
    {_DATAF(0.12393297255039215000),  _DATAF(-0.99229061603546143000)},
    {_DATAF(0.12355242669582367000),  _DATAF(-0.99233806133270264000)},
    {_DATAF(0.12317185848951340000),  _DATAF(-0.99238532781600952000)},
    {_DATAF(0.12279127538204193000),  _DATAF(-0.99243253469467163000)},
    {_DATAF(0.12241067737340927000),  _DATAF(-0.99247956275939941000)},
    {_DATAF(0.12203005701303482000),  _DATAF(-0.99252641201019287000)},
    {_DATAF(0.12164941430091858000),  _DATAF(-0.99257314205169678000)},
    {_DATAF(0.12126876413822174000),  _DATAF(-0.99261969327926636000)},
    {_DATAF(0.12088808417320251000),  _DATAF(-0.99266612529754639000)},
    {_DATAF(0.12050739675760269000),  _DATAF(-0.99271243810653687000)},
    {_DATAF(0.12012668699026108000),  _DATAF(-0.99275857210159302000)},
    {_DATAF(0.11974596232175827000),  _DATAF(-0.99280458688735962000)},
    {_DATAF(0.11936521530151367000),  _DATAF(-0.99285042285919189000)},
    {_DATAF(0.11898445338010788000),  _DATAF(-0.99289613962173462000)},
    {_DATAF(0.11860367655754089000),  _DATAF(-0.99294167757034302000)},
    {_DATAF(0.11822287738323212000),  _DATAF(-0.99298709630966187000)},
    {_DATAF(0.11784206330776215000),  _DATAF(-0.99303233623504639000)},
    {_DATAF(0.11746122688055038000),  _DATAF(-0.99307745695114136000)},
    {_DATAF(0.11708038300275803000),  _DATAF(-0.99312245845794678000)},
    {_DATAF(0.11669951677322388000),  _DATAF(-0.99316728115081787000)},
    {_DATAF(0.11631862819194794000),  _DATAF(-0.99321192502975464000)},
    {_DATAF(0.11593773216009140000),  _DATAF(-0.99325650930404663000)},
    {_DATAF(0.11555681377649307000),  _DATAF(-0.99330085515975952000)},
    {_DATAF(0.11517588049173355000),  _DATAF(-0.99334514141082764000)},
    {_DATAF(0.11479492485523224000),  _DATAF(-0.99338918924331665000)},
    {_DATAF(0.11441396176815033000),  _DATAF(-0.99343317747116089000)},
    {_DATAF(0.11403297632932663000),  _DATAF(-0.99347698688507080000)},
    {_DATAF(0.11365196853876114000),  _DATAF(-0.99352061748504639000)},
    {_DATAF(0.11327095329761505000),  _DATAF(-0.99356412887573242000)},
    {_DATAF(0.11288991570472717000),  _DATAF(-0.99360752105712891000)},
    {_DATAF(0.11250886321067810000),  _DATAF(-0.99365073442459106000)},
    {_DATAF(0.11212779581546783000),  _DATAF(-0.99369376897811890000)},
    {_DATAF(0.11174671351909637000),  _DATAF(-0.99373674392700195000)},
    {_DATAF(0.11136560887098312000),  _DATAF(-0.99377948045730591000)},
    {_DATAF(0.11098448932170868000),  _DATAF(-0.99382215738296509000)},
    {_DATAF(0.11060335487127304000),  _DATAF(-0.99386465549468994000)},
    {_DATAF(0.11022220551967621000),  _DATAF(-0.99390697479248047000)},
    {_DATAF(0.10984104126691818000),  _DATAF(-0.99394917488098145000)},
    {_DATAF(0.10945985466241837000),  _DATAF(-0.99399119615554810000)},
    {_DATAF(0.10907866060733795000),  _DATAF(-0.99403309822082520000)},
    {_DATAF(0.10869744420051575000),  _DATAF(-0.99407488107681274000)},
    {_DATAF(0.10831621289253235000),  _DATAF(-0.99411648511886597000)},
    {_DATAF(0.10793496668338776000),  _DATAF(-0.99415796995162964000)},
    {_DATAF(0.10755370557308197000),  _DATAF(-0.99419927597045898000)},
    {_DATAF(0.10717242211103439000),  _DATAF(-0.99424046277999878000)},
    {_DATAF(0.10679113119840622000),  _DATAF(-0.99428147077560425000)},
    {_DATAF(0.10640981793403625000),  _DATAF(-0.99432235956192017000)},
    {_DATAF(0.10602849721908569000),  _DATAF(-0.99436306953430176000)},
    {_DATAF(0.10564715415239334000),  _DATAF(-0.99440366029739380000)},
    {_DATAF(0.10526579618453979000),  _DATAF(-0.99444413185119629000)},
    {_DATAF(0.10488442331552505000),  _DATAF(-0.99448442459106445000)},
    {_DATAF(0.10450303554534912000),  _DATAF(-0.99452453851699829000)},
    {_DATAF(0.10412163287401199000),  _DATAF(-0.99456459283828735000)},
    {_DATAF(0.10374021530151367000),  _DATAF(-0.99460440874099731000)},
    {_DATAF(0.10335878282785416000),  _DATAF(-0.99464416503906250000)},
    {_DATAF(0.10297733545303345000),  _DATAF(-0.99468368291854858000)},
    {_DATAF(0.10259586572647095000),  _DATAF(-0.99472314119338989000)},
    {_DATAF(0.10221438854932785000),  _DATAF(-0.99476242065429688000)},
    {_DATAF(0.10183289647102356000),  _DATAF(-0.99480152130126953000)},
    {_DATAF(0.10145138949155807000),  _DATAF(-0.99484050273895264000)},
    {_DATAF(0.10106986016035080000),  _DATAF(-0.99487930536270142000)},
    {_DATAF(0.10068832337856293000),  _DATAF(-0.99491798877716064000)},
    {_DATAF(0.10030677169561386000),  _DATAF(-0.99495655298233032000)},
    {_DATAF(0.09992520511150360100),  _DATAF(-0.99499493837356567000)},
    {_DATAF(0.09954361617565155000),  _DATAF(-0.99503320455551147000)},
    {_DATAF(0.09916201978921890300),  _DATAF(-0.99507129192352295000)},
    {_DATAF(0.09878040850162506100),  _DATAF(-0.99510926008224487000)},
    {_DATAF(0.09839878231287002600),  _DATAF(-0.99514704942703247000)},
    {_DATAF(0.09801714122295379600),  _DATAF(-0.99518471956253052000)},
    {_DATAF(0.09763548523187637300),  _DATAF(-0.99522227048873901000)},
    {_DATAF(0.09725381433963775600),  _DATAF(-0.99525958299636841000)},
    {_DATAF(0.09687212854623794600),  _DATAF(-0.99529683589935303000)},
    {_DATAF(0.09649042785167694100),  _DATAF(-0.99533390998840332000)},
    {_DATAF(0.09610871970653533900),  _DATAF(-0.99537086486816406000)},
    {_DATAF(0.09572698920965194700),  _DATAF(-0.99540764093399048000)},
    {_DATAF(0.09534525126218795800),  _DATAF(-0.99544423818588257000)},
    {_DATAF(0.09496349841356277500),  _DATAF(-0.99548077583312988000)},
    {_DATAF(0.09458172321319580100),  _DATAF(-0.99551707506179810000)},
    {_DATAF(0.09419994056224823000),  _DATAF(-0.99555331468582153000)},
    {_DATAF(0.09381814301013946500),  _DATAF(-0.99558937549591064000)},
    {_DATAF(0.09343633800745010400),  _DATAF(-0.99562525749206543000)},
    {_DATAF(0.09305451065301895100),  _DATAF(-0.99566102027893066000)},
    {_DATAF(0.09267267584800720200),  _DATAF(-0.99569660425186157000)},
    {_DATAF(0.09229081869125366200),  _DATAF(-0.99573206901550293000)},
    {_DATAF(0.09190895408391952500),  _DATAF(-0.99576741456985474000)},
    {_DATAF(0.09152707457542419400),  _DATAF(-0.99580258131027222000)},
    {_DATAF(0.09114518761634826700),  _DATAF(-0.99583762884140015000)},
    {_DATAF(0.09076327830553054800),  _DATAF(-0.99587249755859375000)},
    {_DATAF(0.09038136154413223300),  _DATAF(-0.99590724706649780000)},
    {_DATAF(0.08999942988157272300),  _DATAF(-0.99594181776046753000)},
    {_DATAF(0.08961748331785202000),  _DATAF(-0.99597626924514771000)},
    {_DATAF(0.08923552185297012300),  _DATAF(-0.99601054191589355000)},
    {_DATAF(0.08885355293750762900),  _DATAF(-0.99604469537734985000)},
    {_DATAF(0.08847156912088394200),  _DATAF(-0.99607872962951660000)},
    {_DATAF(0.08808957040309906000),  _DATAF(-0.99611258506774902000)},
    {_DATAF(0.08770755678415298500),  _DATAF(-0.99614626169204712000)},
    {_DATAF(0.08732553571462631200),  _DATAF(-0.99617981910705566000)},
    {_DATAF(0.08694349974393844600),  _DATAF(-0.99621325731277466000)},
    {_DATAF(0.08656144887208938600),  _DATAF(-0.99624651670455933000)},
    {_DATAF(0.08617939054965972900),  _DATAF(-0.99627965688705444000)},
    {_DATAF(0.08579730987548828100),  _DATAF(-0.99631261825561523000)},
    {_DATAF(0.08541522175073623700),  _DATAF(-0.99634546041488647000)},
    {_DATAF(0.08503312617540359500),  _DATAF(-0.99637812376022339000)},
    {_DATAF(0.08465101569890976000),  _DATAF(-0.99641066789627075000)},
    {_DATAF(0.08426889032125473000),  _DATAF(-0.99644303321838379000)},
    {_DATAF(0.08388675004243850700),  _DATAF(-0.99647527933120728000)},
    {_DATAF(0.08350460231304168700),  _DATAF(-0.99650740623474121000)},
    {_DATAF(0.08312243968248367300),  _DATAF(-0.99653935432434082000)},
    {_DATAF(0.08274026215076446500),  _DATAF(-0.99657112360000610000)},
    {_DATAF(0.08235807716846466100),  _DATAF(-0.99660277366638184000)},
    {_DATAF(0.08197587728500366200),  _DATAF(-0.99663430452346802000)},
    {_DATAF(0.08159366995096206700),  _DATAF(-0.99666565656661987000)},
    {_DATAF(0.08121144771575927700),  _DATAF(-0.99669688940048218000)},
    {_DATAF(0.08082921057939529400),  _DATAF(-0.99672794342041016000)},
    {_DATAF(0.08044696599245071400),  _DATAF(-0.99675887823104858000)},
    {_DATAF(0.08006470650434494000),  _DATAF(-0.99678969383239746000)},
    {_DATAF(0.07968243956565856900),  _DATAF(-0.99682027101516724000)},
    {_DATAF(0.07930015772581100500),  _DATAF(-0.99685078859329224000)},
    {_DATAF(0.07891786098480224600),  _DATAF(-0.99688112735748291000)},
    {_DATAF(0.07853555679321289100),  _DATAF(-0.99691128730773926000)},
    {_DATAF(0.07815324515104293800),  _DATAF(-0.99694132804870605000)},
    {_DATAF(0.07777091115713119500),  _DATAF(-0.99697124958038330000)},
    {_DATAF(0.07738857716321945200),  _DATAF(-0.99700099229812622000)},
    {_DATAF(0.07700622081756591800),  _DATAF(-0.99703061580657959000)},
    {_DATAF(0.07662386447191238400),  _DATAF(-0.99706006050109863000)},
    {_DATAF(0.07624148577451705900),  _DATAF(-0.99708938598632813000)},
    {_DATAF(0.07585910707712173500),  _DATAF(-0.99711853265762329000)},
    {_DATAF(0.07547670602798461900),  _DATAF(-0.99714756011962891000)},
    {_DATAF(0.07509429752826690700),  _DATAF(-0.99717640876770020000)},
    {_DATAF(0.07471188157796859700),  _DATAF(-0.99720513820648193000)},
    {_DATAF(0.07432945072650909400),  _DATAF(-0.99723374843597412000)},
    {_DATAF(0.07394701242446899400),  _DATAF(-0.99726217985153198000)},
    {_DATAF(0.07356456667184829700),  _DATAF(-0.99729043245315552000)},
    {_DATAF(0.07318209856748580900),  _DATAF(-0.99731856584548950000)},
    {_DATAF(0.07279963046312332200),  _DATAF(-0.99734658002853394000)},
    {_DATAF(0.07241714745759964000),  _DATAF(-0.99737441539764404000)},
    {_DATAF(0.07203464955091476400),  _DATAF(-0.99740213155746460000)},
    {_DATAF(0.07165215164422988900),  _DATAF(-0.99742966890335083000)},
    {_DATAF(0.07126963138580322300),  _DATAF(-0.99745708703994751000)},
    {_DATAF(0.07088711112737655600),  _DATAF(-0.99748432636260986000)},
    {_DATAF(0.07050457596778869600),  _DATAF(-0.99751144647598267000)},
    {_DATAF(0.07012202590703964200),  _DATAF(-0.99753844738006592000)},
    {_DATAF(0.06973946839570999100),  _DATAF(-0.99756520986557007000)},
    {_DATAF(0.06935690343379974400),  _DATAF(-0.99759191274642944000)},
    {_DATAF(0.06897433102130889900),  _DATAF(-0.99761843681335449000)},
    {_DATAF(0.06859174370765686000),  _DATAF(-0.99764484167098999000)},
    {_DATAF(0.06820914149284362800),  _DATAF(-0.99767106771469116000)},
    {_DATAF(0.06782653927803039600),  _DATAF(-0.99769711494445801000)},
    {_DATAF(0.06744392216205596900),  _DATAF(-0.99772304296493530000)},
    {_DATAF(0.06706129014492034900),  _DATAF(-0.99774885177612305000)},
    {_DATAF(0.06667865812778472900),  _DATAF(-0.99777448177337646000)},
    {_DATAF(0.06629601120948791500),  _DATAF(-0.99779999256134033000)},
    {_DATAF(0.06591334939002990700),  _DATAF(-0.99782532453536987000)},
    {_DATAF(0.06553068757057189900),  _DATAF(-0.99785053730010986000)},
    {_DATAF(0.06514801084995269800),  _DATAF(-0.99787563085556030000)},
    {_DATAF(0.06476532667875289900),  _DATAF(-0.99790054559707642000)},
    {_DATAF(0.06438262760639190700),  _DATAF(-0.99792528152465820000)},
    {_DATAF(0.06399992853403091400),  _DATAF(-0.99794989824295044000)},
    {_DATAF(0.06361721456050872800),  _DATAF(-0.99797439575195313000)},
    {_DATAF(0.06323449313640594500),  _DATAF(-0.99799871444702148000)},
    {_DATAF(0.06285175681114196800),  _DATAF(-0.99802285432815552000)},
    {_DATAF(0.06246901676058769200),  _DATAF(-0.99804687500000000000)},
    {_DATAF(0.06208626553416252100),  _DATAF(-0.99807077646255493000)},
    {_DATAF(0.06170350685715675400),  _DATAF(-0.99809449911117554000)},
    {_DATAF(0.06132073700428009000),  _DATAF(-0.99811810255050659000)},
    {_DATAF(0.06093795970082283000),  _DATAF(-0.99814152717590332000)},
    {_DATAF(0.06055517122149467500),  _DATAF(-0.99816483259201050000)},
    {_DATAF(0.06017237529158592200),  _DATAF(-0.99818801879882813000)},
    {_DATAF(0.05978957191109657300),  _DATAF(-0.99821102619171143000)},
    {_DATAF(0.05940675735473632800),  _DATAF(-0.99823385477066040000)},
    {_DATAF(0.05902393534779548600),  _DATAF(-0.99825656414031982000)},
    {_DATAF(0.05864110589027404800),  _DATAF(-0.99827915430068970000)},
    {_DATAF(0.05825826525688171400),  _DATAF(-0.99830156564712524000)},
    {_DATAF(0.05787541717290878300),  _DATAF(-0.99832379817962646000)},
    {_DATAF(0.05749255791306495700),  _DATAF(-0.99834591150283813000)},
    {_DATAF(0.05710969492793083200),  _DATAF(-0.99836790561676025000)},
    {_DATAF(0.05672682076692581200),  _DATAF(-0.99838972091674805000)},
    {_DATAF(0.05634393915534019500),  _DATAF(-0.99841141700744629000)},
    {_DATAF(0.05596105009317398100),  _DATAF(-0.99843293428421021000)},
    {_DATAF(0.05557814985513687100),  _DATAF(-0.99845433235168457000)},
    {_DATAF(0.05519524589180946400),  _DATAF(-0.99847555160522461000)},
    {_DATAF(0.05481233075261116000),  _DATAF(-0.99849665164947510000)},
    {_DATAF(0.05442940816283226000),  _DATAF(-0.99851763248443604000)},
    {_DATAF(0.05404647812247276300),  _DATAF(-0.99853843450546265000)},
    {_DATAF(0.05366353690624237100),  _DATAF(-0.99855905771255493000)},
    {_DATAF(0.05328059196472168000),  _DATAF(-0.99857956171035767000)},
    {_DATAF(0.05289763584733009300),  _DATAF(-0.99859994649887085000)},
    {_DATAF(0.05251467600464820900),  _DATAF(-0.99862015247344971000)},
    {_DATAF(0.05213170498609542800),  _DATAF(-0.99864023923873901000)},
    {_DATAF(0.05174872651696205100),  _DATAF(-0.99866014719009399000)},
    {_DATAF(0.05136574059724807700),  _DATAF(-0.99867993593215942000)},
    {_DATAF(0.05098275095224380500),  _DATAF(-0.99869954586029053000)},
    {_DATAF(0.05059975013136863700),  _DATAF(-0.99871903657913208000)},
    {_DATAF(0.05021674185991287200),  _DATAF(-0.99873834848403931000)},
    {_DATAF(0.04983372613787651100),  _DATAF(-0.99875754117965698000)},
    {_DATAF(0.04945070296525955200),  _DATAF(-0.99877655506134033000)},
    {_DATAF(0.04906767606735229500),  _DATAF(-0.99879544973373413000)},
    {_DATAF(0.04868463799357414200),  _DATAF(-0.99881422519683838000)},
    {_DATAF(0.04830159246921539300),  _DATAF(-0.99883282184600830000)},
    {_DATAF(0.04791854321956634500),  _DATAF(-0.99885123968124390000)},
    {_DATAF(0.04753548279404640200),  _DATAF(-0.99886953830718994000)},
    {_DATAF(0.04715241864323616000),  _DATAF(-0.99888771772384644000)},
    {_DATAF(0.04676934704184532200),  _DATAF(-0.99890571832656860000)},
    {_DATAF(0.04638626798987388600),  _DATAF(-0.99892359972000122000)},
    {_DATAF(0.04600318148732185400),  _DATAF(-0.99894130229949951000)},
    {_DATAF(0.04562009125947952300),  _DATAF(-0.99895888566970825000)},
    {_DATAF(0.04523698985576629600),  _DATAF(-0.99897629022598267000)},
    {_DATAF(0.04485388472676277200),  _DATAF(-0.99899357557296753000)},
    {_DATAF(0.04447077214717865000),  _DATAF(-0.99901068210601807000)},
    {_DATAF(0.04408765211701393100),  _DATAF(-0.99902766942977905000)},
    {_DATAF(0.04370452836155891400),  _DATAF(-0.99904447793960571000)},
    {_DATAF(0.04332139343023300200),  _DATAF(-0.99906116724014282000)},
    {_DATAF(0.04293825849890708900),  _DATAF(-0.99907773733139038000)},
    {_DATAF(0.04255511239171028100),  _DATAF(-0.99909412860870361000)},
    {_DATAF(0.04217196255922317500),  _DATAF(-0.99911034107208252000)},
    {_DATAF(0.04178880527615547200),  _DATAF(-0.99912649393081665000)},
    {_DATAF(0.04140564054250717200),  _DATAF(-0.99914240837097168000)},
    {_DATAF(0.04102247208356857300),  _DATAF(-0.99915820360183716000)},
    {_DATAF(0.04063929617404937700),  _DATAF(-0.99917387962341309000)},
    {_DATAF(0.04025611653923988300),  _DATAF(-0.99918937683105469000)},
    {_DATAF(0.03987292572855949400),  _DATAF(-0.99920475482940674000)},
    {_DATAF(0.03948973491787910500),  _DATAF(-0.99921995401382446000)},
    {_DATAF(0.03910653665661811800),  _DATAF(-0.99923503398895264000)},
    {_DATAF(0.03872333094477653500),  _DATAF(-0.99924999475479126000)},
    {_DATAF(0.03834012150764465300),  _DATAF(-0.99926477670669556000)},
    {_DATAF(0.03795690461993217500),  _DATAF(-0.99927937984466553000)},
    {_DATAF(0.03757368400692939800),  _DATAF(-0.99929386377334595000)},
    {_DATAF(0.03719045594334602400),  _DATAF(-0.99930816888809204000)},
    {_DATAF(0.03680722415447235100),  _DATAF(-0.99932235479354858000)},
    {_DATAF(0.03642398491501808200),  _DATAF(-0.99933642148971558000)},
    {_DATAF(0.03604074195027351400),  _DATAF(-0.99935030937194824000)},
    {_DATAF(0.03565749153494834900),  _DATAF(-0.99936407804489136000)},
    {_DATAF(0.03527423739433288600),  _DATAF(-0.99937766790390015000)},
    {_DATAF(0.03489097952842712400),  _DATAF(-0.99939113855361938000)},
    {_DATAF(0.03450771421194076500),  _DATAF(-0.99940443038940430000)},
    {_DATAF(0.03412444517016410800),  _DATAF(-0.99941760301589966000)},
    {_DATAF(0.03374117240309715300),  _DATAF(-0.99943059682846069000)},
    {_DATAF(0.03335789218544960000),  _DATAF(-0.99944347143173218000)},
    {_DATAF(0.03297460824251174900),  _DATAF(-0.99945616722106934000)},
    {_DATAF(0.03259132057428360000),  _DATAF(-0.99946874380111694000)},
    {_DATAF(0.03220802545547485400),  _DATAF(-0.99948120117187500000)},
    {_DATAF(0.03182472661137580900),  _DATAF(-0.99949347972869873000)},
    {_DATAF(0.03144142404198646500),  _DATAF(-0.99950557947158813000)},
    {_DATAF(0.03105811588466167400),  _DATAF(-0.99951756000518799000)},
    {_DATAF(0.03067480400204658500),  _DATAF(-0.99952942132949829000)},
    {_DATAF(0.03029148653149604800),  _DATAF(-0.99954110383987427000)},
    {_DATAF(0.02990816533565521200),  _DATAF(-0.99955266714096069000)},
    {_DATAF(0.02952483855187892900),  _DATAF(-0.99956405162811279000)},
    {_DATAF(0.02914150804281234700),  _DATAF(-0.99957531690597534000)},
    {_DATAF(0.02875817380845546700),  _DATAF(-0.99958640336990356000)},
    {_DATAF(0.02837483584880828900),  _DATAF(-0.99959737062454224000)},
    {_DATAF(0.02799149230122566200),  _DATAF(-0.99960815906524658000)},
    {_DATAF(0.02760814502835273700),  _DATAF(-0.99961882829666138000)},
    {_DATAF(0.02722479403018951400),  _DATAF(-0.99962931871414185000)},
    {_DATAF(0.02684143930673599200),  _DATAF(-0.99963968992233276000)},
    {_DATAF(0.02645808085799217200),  _DATAF(-0.99964994192123413000)},
    {_DATAF(0.02607471868395805400),  _DATAF(-0.99966001510620117000)},
    {_DATAF(0.02569135092198848700),  _DATAF(-0.99966990947723389000)},
    {_DATAF(0.02530798129737377200),  _DATAF(-0.99967968463897705000)},
    {_DATAF(0.02492460608482360800),  _DATAF(-0.99968934059143066000)},
    {_DATAF(0.02454122900962829600),  _DATAF(-0.99969881772994995000)},
    {_DATAF(0.02415784634649753600),  _DATAF(-0.99970817565917969000)},
    {_DATAF(0.02377446182072162600),  _DATAF(-0.99971735477447510000)},
    {_DATAF(0.02339107356965541800),  _DATAF(-0.99972641468048096000)},
    {_DATAF(0.02300768159329891200),  _DATAF(-0.99973529577255249000)},
    {_DATAF(0.02262428589165210700),  _DATAF(-0.99974405765533447000)},
    {_DATAF(0.02224088832736015300),  _DATAF(-0.99975264072418213000)},
    {_DATAF(0.02185748517513275100),  _DATAF(-0.99976110458374023000)},
    {_DATAF(0.02147408016026020100),  _DATAF(-0.99976938962936401000)},
    {_DATAF(0.02109067142009735100),  _DATAF(-0.99977755546569824000)},
    {_DATAF(0.02070726081728935200),  _DATAF(-0.99978560209274292000)},
    {_DATAF(0.02032384648919105500),  _DATAF(-0.99979346990585327000)},
    {_DATAF(0.01994042843580246000),  _DATAF(-0.99980115890502930000)},
    {_DATAF(0.01955700851976871500),  _DATAF(-0.99980872869491577000)},
    {_DATAF(0.01917358487844467200),  _DATAF(-0.99981617927551270000)},
    {_DATAF(0.01879015937447547900),  _DATAF(-0.99982345104217529000)},
    {_DATAF(0.01840673014521598800),  _DATAF(-0.99983060359954834000)},
    {_DATAF(0.01802329905331134800),  _DATAF(-0.99983757734298706000)},
    {_DATAF(0.01763986423611640900),  _DATAF(-0.99984443187713623000)},
    {_DATAF(0.01725642755627632100),  _DATAF(-0.99985110759735107000)},
    {_DATAF(0.01687298715114593500),  _DATAF(-0.99985766410827637000)},
    {_DATAF(0.01648954674601554900),  _DATAF(-0.99986404180526733000)},
    {_DATAF(0.01610610261559486400),  _DATAF(-0.99987030029296875000)},
    {_DATAF(0.01572265475988388100),  _DATAF(-0.99987637996673584000)},
    {_DATAF(0.01533920597285032300),  _DATAF(-0.99988234043121338000)},
    {_DATAF(0.01495575532317161600),  _DATAF(-0.99988818168640137000)},
    {_DATAF(0.01457230187952518500),  _DATAF(-0.99989384412765503000)},
    {_DATAF(0.01418884657323360400),  _DATAF(-0.99989932775497437000)},
    {_DATAF(0.01380538847297430000),  _DATAF(-0.99990469217300415000)},
    {_DATAF(0.01342192851006984700),  _DATAF(-0.99990993738174438000)},
    {_DATAF(0.01303846761584281900),  _DATAF(-0.99991500377655029000)},
    {_DATAF(0.01265500392764806700),  _DATAF(-0.99991995096206665000)},
    {_DATAF(0.01227153837680816700),  _DATAF(-0.99992471933364868000)},
    {_DATAF(0.01188807096332311600),  _DATAF(-0.99992930889129639000)},
    {_DATAF(0.01150460168719291700),  _DATAF(-0.99993383884429932000)},
    {_DATAF(0.01112113147974014300),  _DATAF(-0.99993813037872314000)},
    {_DATAF(0.01073765940964222000),  _DATAF(-0.99994236230850220000)},
    {_DATAF(0.01035418547689914700),  _DATAF(-0.99994641542434692000)},
    {_DATAF(0.00997070968151092530),  _DATAF(-0.99995028972625732000)},
    {_DATAF(0.00958723295480012890),  _DATAF(-0.99995404481887817000)},
    {_DATAF(0.00920375436544418330),  _DATAF(-0.99995762109756470000)},
    {_DATAF(0.00882027484476566310),  _DATAF(-0.99996107816696167000)},
    {_DATAF(0.00843679439276456830),  _DATAF(-0.99996441602706909000)},
    {_DATAF(0.00805331207811832430),  _DATAF(-0.99996757507324219000)},
    {_DATAF(0.00766982883214950560),  _DATAF(-0.99997061491012573000)},
    {_DATAF(0.00728634418919682500),  _DATAF(-0.99997347593307495000)},
    {_DATAF(0.00690285861492156980),  _DATAF(-0.99997615814208984000)},
    {_DATAF(0.00651937210932374000),  _DATAF(-0.99997872114181519000)},
    {_DATAF(0.00613588467240333560),  _DATAF(-0.99998116493225098000)},
    {_DATAF(0.00575239630416035650),  _DATAF(-0.99998342990875244000)},
    {_DATAF(0.00536890700459480290),  _DATAF(-0.99998557567596436000)},
    {_DATAF(0.00498541677370667460),  _DATAF(-0.99998760223388672000)},
    {_DATAF(0.00460192607715725900),  _DATAF(-0.99998939037322998000)},
    {_DATAF(0.00421843444928526880),  _DATAF(-0.99999111890792847000)},
    {_DATAF(0.00383494258858263490),  _DATAF(-0.99999266862869263000)},
    {_DATAF(0.00345145002938807010),  _DATAF(-0.99999403953552246000)},
    {_DATAF(0.00306795677170157430),  _DATAF(-0.99999529123306274000)},
    {_DATAF(0.00268446304835379120),  _DATAF(-0.99999642372131348000)},
    {_DATAF(0.00230096909217536450),  _DATAF(-0.99999737739562988000)},
    {_DATAF(0.00191747478675097230),  _DATAF(-0.99999815225601196000)},
    {_DATAF(0.00153398013208061460),  _DATAF(-0.99999880790710449000)},
    {_DATAF(0.00115048536099493500),  _DATAF(-0.99999934434890747000)},
    {_DATAF(0.00076699029887095094),  _DATAF(-0.99999970197677612000)},
    {_DATAF(0.00038349517853930593),  _DATAF(-0.99999994039535522000)},
    {_DATAF(0.00000000000000006123),  _DATAF(-1.00000000000000000000)},
    {_DATAF(-0.00038349517853930593), _DATAF(-0.99999994039535522000)},
    {_DATAF(-0.00076699029887095094), _DATAF(-0.99999970197677612000)},
    {_DATAF(-0.00115048536099493500), _DATAF(-0.99999934434890747000)},
    {_DATAF(-0.00153398013208061460), _DATAF(-0.99999880790710449000)},
    {_DATAF(-0.00191747478675097230), _DATAF(-0.99999815225601196000)},
    {_DATAF(-0.00230096909217536450), _DATAF(-0.99999737739562988000)},
    {_DATAF(-0.00268446304835379120), _DATAF(-0.99999642372131348000)},
    {_DATAF(-0.00306795677170157430), _DATAF(-0.99999529123306274000)},
    {_DATAF(-0.00345145002938807010), _DATAF(-0.99999403953552246000)},
    {_DATAF(-0.00383494258858263490), _DATAF(-0.99999266862869263000)},
    {_DATAF(-0.00421843444928526880), _DATAF(-0.99999111890792847000)},
    {_DATAF(-0.00460192607715725900), _DATAF(-0.99998939037322998000)},
    {_DATAF(-0.00498541677370667460), _DATAF(-0.99998760223388672000)},
    {_DATAF(-0.00536890700459480290), _DATAF(-0.99998557567596436000)},
    {_DATAF(-0.00575239630416035650), _DATAF(-0.99998342990875244000)},
    {_DATAF(-0.00613588467240333560), _DATAF(-0.99998116493225098000)},
    {_DATAF(-0.00651937210932374000), _DATAF(-0.99997872114181519000)},
    {_DATAF(-0.00690285861492156980), _DATAF(-0.99997615814208984000)},
    {_DATAF(-0.00728634418919682500), _DATAF(-0.99997347593307495000)},
    {_DATAF(-0.00766982883214950560), _DATAF(-0.99997061491012573000)},
    {_DATAF(-0.00805331207811832430), _DATAF(-0.99996757507324219000)},
    {_DATAF(-0.00843679439276456830), _DATAF(-0.99996441602706909000)},
    {_DATAF(-0.00882027484476566310), _DATAF(-0.99996107816696167000)},
    {_DATAF(-0.00920375436544418330), _DATAF(-0.99995762109756470000)},
    {_DATAF(-0.00958723295480012890), _DATAF(-0.99995404481887817000)},
    {_DATAF(-0.00997070968151092530), _DATAF(-0.99995028972625732000)},
    {_DATAF(-0.01035418547689914700), _DATAF(-0.99994641542434692000)},
    {_DATAF(-0.01073765940964222000), _DATAF(-0.99994236230850220000)},
    {_DATAF(-0.01112113147974014300), _DATAF(-0.99993813037872314000)},
    {_DATAF(-0.01150460168719291700), _DATAF(-0.99993383884429932000)},
    {_DATAF(-0.01188807096332311600), _DATAF(-0.99992930889129639000)},
    {_DATAF(-0.01227153837680816700), _DATAF(-0.99992471933364868000)},
    {_DATAF(-0.01265500392764806700), _DATAF(-0.99991995096206665000)},
    {_DATAF(-0.01303846761584281900), _DATAF(-0.99991500377655029000)},
    {_DATAF(-0.01342192851006984700), _DATAF(-0.99990993738174438000)},
    {_DATAF(-0.01380538847297430000), _DATAF(-0.99990469217300415000)},
    {_DATAF(-0.01418884657323360400), _DATAF(-0.99989932775497437000)},
    {_DATAF(-0.01457230187952518500), _DATAF(-0.99989384412765503000)},
    {_DATAF(-0.01495575532317161600), _DATAF(-0.99988818168640137000)},
    {_DATAF(-0.01533920597285032300), _DATAF(-0.99988234043121338000)},
    {_DATAF(-0.01572265475988388100), _DATAF(-0.99987637996673584000)},
    {_DATAF(-0.01610610261559486400), _DATAF(-0.99987030029296875000)},
    {_DATAF(-0.01648954674601554900), _DATAF(-0.99986404180526733000)},
    {_DATAF(-0.01687298715114593500), _DATAF(-0.99985766410827637000)},
    {_DATAF(-0.01725642755627632100), _DATAF(-0.99985110759735107000)},
    {_DATAF(-0.01763986423611640900), _DATAF(-0.99984443187713623000)},
    {_DATAF(-0.01802329905331134800), _DATAF(-0.99983757734298706000)},
    {_DATAF(-0.01840673014521598800), _DATAF(-0.99983060359954834000)},
    {_DATAF(-0.01879015937447547900), _DATAF(-0.99982345104217529000)},
    {_DATAF(-0.01917358487844467200), _DATAF(-0.99981617927551270000)},
    {_DATAF(-0.01955700851976871500), _DATAF(-0.99980872869491577000)},
    {_DATAF(-0.01994042843580246000), _DATAF(-0.99980115890502930000)},
    {_DATAF(-0.02032384648919105500), _DATAF(-0.99979346990585327000)},
    {_DATAF(-0.02070726081728935200), _DATAF(-0.99978560209274292000)},
    {_DATAF(-0.02109067142009735100), _DATAF(-0.99977755546569824000)},
    {_DATAF(-0.02147408016026020100), _DATAF(-0.99976938962936401000)},
    {_DATAF(-0.02185748517513275100), _DATAF(-0.99976110458374023000)},
    {_DATAF(-0.02224088832736015300), _DATAF(-0.99975264072418213000)},
    {_DATAF(-0.02262428589165210700), _DATAF(-0.99974405765533447000)},
    {_DATAF(-0.02300768159329891200), _DATAF(-0.99973529577255249000)},
    {_DATAF(-0.02339107356965541800), _DATAF(-0.99972641468048096000)},
    {_DATAF(-0.02377446182072162600), _DATAF(-0.99971735477447510000)},
    {_DATAF(-0.02415784634649753600), _DATAF(-0.99970817565917969000)},
    {_DATAF(-0.02454122900962829600), _DATAF(-0.99969881772994995000)},
    {_DATAF(-0.02492460608482360800), _DATAF(-0.99968934059143066000)},
    {_DATAF(-0.02530798129737377200), _DATAF(-0.99967968463897705000)},
    {_DATAF(-0.02569135092198848700), _DATAF(-0.99966990947723389000)},
    {_DATAF(-0.02607471868395805400), _DATAF(-0.99966001510620117000)},
    {_DATAF(-0.02645808085799217200), _DATAF(-0.99964994192123413000)},
    {_DATAF(-0.02684143930673599200), _DATAF(-0.99963968992233276000)},
    {_DATAF(-0.02722479403018951400), _DATAF(-0.99962931871414185000)},
    {_DATAF(-0.02760814502835273700), _DATAF(-0.99961882829666138000)},
    {_DATAF(-0.02799149230122566200), _DATAF(-0.99960815906524658000)},
    {_DATAF(-0.02837483584880828900), _DATAF(-0.99959737062454224000)},
    {_DATAF(-0.02875817380845546700), _DATAF(-0.99958640336990356000)},
    {_DATAF(-0.02914150804281234700), _DATAF(-0.99957531690597534000)},
    {_DATAF(-0.02952483855187892900), _DATAF(-0.99956405162811279000)},
    {_DATAF(-0.02990816533565521200), _DATAF(-0.99955266714096069000)},
    {_DATAF(-0.03029148653149604800), _DATAF(-0.99954110383987427000)},
    {_DATAF(-0.03067480400204658500), _DATAF(-0.99952942132949829000)},
    {_DATAF(-0.03105811588466167400), _DATAF(-0.99951756000518799000)},
    {_DATAF(-0.03144142404198646500), _DATAF(-0.99950557947158813000)},
    {_DATAF(-0.03182472661137580900), _DATAF(-0.99949347972869873000)},
    {_DATAF(-0.03220802545547485400), _DATAF(-0.99948120117187500000)},
    {_DATAF(-0.03259132057428360000), _DATAF(-0.99946874380111694000)},
    {_DATAF(-0.03297460824251174900), _DATAF(-0.99945616722106934000)},
    {_DATAF(-0.03335789218544960000), _DATAF(-0.99944347143173218000)},
    {_DATAF(-0.03374117240309715300), _DATAF(-0.99943059682846069000)},
    {_DATAF(-0.03412444517016410800), _DATAF(-0.99941760301589966000)},
    {_DATAF(-0.03450771421194076500), _DATAF(-0.99940443038940430000)},
    {_DATAF(-0.03489097952842712400), _DATAF(-0.99939113855361938000)},
    {_DATAF(-0.03527423739433288600), _DATAF(-0.99937766790390015000)},
    {_DATAF(-0.03565749153494834900), _DATAF(-0.99936407804489136000)},
    {_DATAF(-0.03604074195027351400), _DATAF(-0.99935030937194824000)},
    {_DATAF(-0.03642398491501808200), _DATAF(-0.99933642148971558000)},
    {_DATAF(-0.03680722415447235100), _DATAF(-0.99932235479354858000)},
    {_DATAF(-0.03719045594334602400), _DATAF(-0.99930816888809204000)},
    {_DATAF(-0.03757368400692939800), _DATAF(-0.99929386377334595000)},
    {_DATAF(-0.03795690461993217500), _DATAF(-0.99927937984466553000)},
    {_DATAF(-0.03834012150764465300), _DATAF(-0.99926477670669556000)},
    {_DATAF(-0.03872333094477653500), _DATAF(-0.99924999475479126000)},
    {_DATAF(-0.03910653665661811800), _DATAF(-0.99923503398895264000)},
    {_DATAF(-0.03948973491787910500), _DATAF(-0.99921995401382446000)},
    {_DATAF(-0.03987292572855949400), _DATAF(-0.99920475482940674000)},
    {_DATAF(-0.04025611653923988300), _DATAF(-0.99918937683105469000)},
    {_DATAF(-0.04063929617404937700), _DATAF(-0.99917387962341309000)},
    {_DATAF(-0.04102247208356857300), _DATAF(-0.99915820360183716000)},
    {_DATAF(-0.04140564054250717200), _DATAF(-0.99914240837097168000)},
    {_DATAF(-0.04178880527615547200), _DATAF(-0.99912649393081665000)},
    {_DATAF(-0.04217196255922317500), _DATAF(-0.99911034107208252000)},
    {_DATAF(-0.04255511239171028100), _DATAF(-0.99909412860870361000)},
    {_DATAF(-0.04293825849890708900), _DATAF(-0.99907773733139038000)},
    {_DATAF(-0.04332139343023300200), _DATAF(-0.99906116724014282000)},
    {_DATAF(-0.04370452836155891400), _DATAF(-0.99904447793960571000)},
    {_DATAF(-0.04408765211701393100), _DATAF(-0.99902766942977905000)},
    {_DATAF(-0.04447077214717865000), _DATAF(-0.99901068210601807000)},
    {_DATAF(-0.04485388472676277200), _DATAF(-0.99899357557296753000)},
    {_DATAF(-0.04523698985576629600), _DATAF(-0.99897629022598267000)},
    {_DATAF(-0.04562009125947952300), _DATAF(-0.99895888566970825000)},
    {_DATAF(-0.04600318148732185400), _DATAF(-0.99894130229949951000)},
    {_DATAF(-0.04638626798987388600), _DATAF(-0.99892359972000122000)},
    {_DATAF(-0.04676934704184532200), _DATAF(-0.99890571832656860000)},
    {_DATAF(-0.04715241864323616000), _DATAF(-0.99888771772384644000)},
    {_DATAF(-0.04753548279404640200), _DATAF(-0.99886953830718994000)},
    {_DATAF(-0.04791854321956634500), _DATAF(-0.99885123968124390000)},
    {_DATAF(-0.04830159246921539300), _DATAF(-0.99883282184600830000)},
    {_DATAF(-0.04868463799357414200), _DATAF(-0.99881422519683838000)},
    {_DATAF(-0.04906767606735229500), _DATAF(-0.99879544973373413000)},
    {_DATAF(-0.04945070296525955200), _DATAF(-0.99877655506134033000)},
    {_DATAF(-0.04983372613787651100), _DATAF(-0.99875754117965698000)},
    {_DATAF(-0.05021674185991287200), _DATAF(-0.99873834848403931000)},
    {_DATAF(-0.05059975013136863700), _DATAF(-0.99871903657913208000)},
    {_DATAF(-0.05098275095224380500), _DATAF(-0.99869954586029053000)},
    {_DATAF(-0.05136574059724807700), _DATAF(-0.99867993593215942000)},
    {_DATAF(-0.05174872651696205100), _DATAF(-0.99866014719009399000)},
    {_DATAF(-0.05213170498609542800), _DATAF(-0.99864023923873901000)},
    {_DATAF(-0.05251467600464820900), _DATAF(-0.99862015247344971000)},
    {_DATAF(-0.05289763584733009300), _DATAF(-0.99859994649887085000)},
    {_DATAF(-0.05328059196472168000), _DATAF(-0.99857956171035767000)},
    {_DATAF(-0.05366353690624237100), _DATAF(-0.99855905771255493000)},
    {_DATAF(-0.05404647812247276300), _DATAF(-0.99853843450546265000)},
    {_DATAF(-0.05442940816283226000), _DATAF(-0.99851763248443604000)},
    {_DATAF(-0.05481233075261116000), _DATAF(-0.99849665164947510000)},
    {_DATAF(-0.05519524589180946400), _DATAF(-0.99847555160522461000)},
    {_DATAF(-0.05557814985513687100), _DATAF(-0.99845433235168457000)},
    {_DATAF(-0.05596105009317398100), _DATAF(-0.99843293428421021000)},
    {_DATAF(-0.05634393915534019500), _DATAF(-0.99841141700744629000)},
    {_DATAF(-0.05672682076692581200), _DATAF(-0.99838972091674805000)},
    {_DATAF(-0.05710969492793083200), _DATAF(-0.99836790561676025000)},
    {_DATAF(-0.05749255791306495700), _DATAF(-0.99834591150283813000)},
    {_DATAF(-0.05787541717290878300), _DATAF(-0.99832379817962646000)},
    {_DATAF(-0.05825826525688171400), _DATAF(-0.99830156564712524000)},
    {_DATAF(-0.05864110589027404800), _DATAF(-0.99827915430068970000)},
    {_DATAF(-0.05902393534779548600), _DATAF(-0.99825656414031982000)},
    {_DATAF(-0.05940675735473632800), _DATAF(-0.99823385477066040000)},
    {_DATAF(-0.05978957191109657300), _DATAF(-0.99821102619171143000)},
    {_DATAF(-0.06017237529158592200), _DATAF(-0.99818801879882813000)},
    {_DATAF(-0.06055517122149467500), _DATAF(-0.99816483259201050000)},
    {_DATAF(-0.06093795970082283000), _DATAF(-0.99814152717590332000)},
    {_DATAF(-0.06132073700428009000), _DATAF(-0.99811810255050659000)},
    {_DATAF(-0.06170350685715675400), _DATAF(-0.99809449911117554000)},
    {_DATAF(-0.06208626553416252100), _DATAF(-0.99807077646255493000)},
    {_DATAF(-0.06246901676058769200), _DATAF(-0.99804687500000000000)},
    {_DATAF(-0.06285175681114196800), _DATAF(-0.99802285432815552000)},
    {_DATAF(-0.06323449313640594500), _DATAF(-0.99799871444702148000)},
    {_DATAF(-0.06361721456050872800), _DATAF(-0.99797439575195313000)},
    {_DATAF(-0.06399992853403091400), _DATAF(-0.99794989824295044000)},
    {_DATAF(-0.06438262760639190700), _DATAF(-0.99792528152465820000)},
    {_DATAF(-0.06476532667875289900), _DATAF(-0.99790054559707642000)},
    {_DATAF(-0.06514801084995269800), _DATAF(-0.99787563085556030000)},
    {_DATAF(-0.06553068757057189900), _DATAF(-0.99785053730010986000)},
    {_DATAF(-0.06591334939002990700), _DATAF(-0.99782532453536987000)},
    {_DATAF(-0.06629601120948791500), _DATAF(-0.99779999256134033000)},
    {_DATAF(-0.06667865812778472900), _DATAF(-0.99777448177337646000)},
    {_DATAF(-0.06706129014492034900), _DATAF(-0.99774885177612305000)},
    {_DATAF(-0.06744392216205596900), _DATAF(-0.99772304296493530000)},
    {_DATAF(-0.06782653927803039600), _DATAF(-0.99769711494445801000)},
    {_DATAF(-0.06820914149284362800), _DATAF(-0.99767106771469116000)},
    {_DATAF(-0.06859174370765686000), _DATAF(-0.99764484167098999000)},
    {_DATAF(-0.06897433102130889900), _DATAF(-0.99761843681335449000)},
    {_DATAF(-0.06935690343379974400), _DATAF(-0.99759191274642944000)},
    {_DATAF(-0.06973946839570999100), _DATAF(-0.99756520986557007000)},
    {_DATAF(-0.07012202590703964200), _DATAF(-0.99753844738006592000)},
    {_DATAF(-0.07050457596778869600), _DATAF(-0.99751144647598267000)},
    {_DATAF(-0.07088711112737655600), _DATAF(-0.99748432636260986000)},
    {_DATAF(-0.07126963138580322300), _DATAF(-0.99745708703994751000)},
    {_DATAF(-0.07165215164422988900), _DATAF(-0.99742966890335083000)},
    {_DATAF(-0.07203464955091476400), _DATAF(-0.99740213155746460000)},
    {_DATAF(-0.07241714745759964000), _DATAF(-0.99737441539764404000)},
    {_DATAF(-0.07279963046312332200), _DATAF(-0.99734658002853394000)},
    {_DATAF(-0.07318209856748580900), _DATAF(-0.99731856584548950000)},
    {_DATAF(-0.07356456667184829700), _DATAF(-0.99729043245315552000)},
    {_DATAF(-0.07394701242446899400), _DATAF(-0.99726217985153198000)},
    {_DATAF(-0.07432945072650909400), _DATAF(-0.99723374843597412000)},
    {_DATAF(-0.07471188157796859700), _DATAF(-0.99720513820648193000)},
    {_DATAF(-0.07509429752826690700), _DATAF(-0.99717640876770020000)},
    {_DATAF(-0.07547670602798461900), _DATAF(-0.99714756011962891000)},
    {_DATAF(-0.07585910707712173500), _DATAF(-0.99711853265762329000)},
    {_DATAF(-0.07624148577451705900), _DATAF(-0.99708938598632813000)},
    {_DATAF(-0.07662386447191238400), _DATAF(-0.99706006050109863000)},
    {_DATAF(-0.07700622081756591800), _DATAF(-0.99703061580657959000)},
    {_DATAF(-0.07738857716321945200), _DATAF(-0.99700099229812622000)},
    {_DATAF(-0.07777091115713119500), _DATAF(-0.99697124958038330000)},
    {_DATAF(-0.07815324515104293800), _DATAF(-0.99694132804870605000)},
    {_DATAF(-0.07853555679321289100), _DATAF(-0.99691128730773926000)},
    {_DATAF(-0.07891786098480224600), _DATAF(-0.99688112735748291000)},
    {_DATAF(-0.07930015772581100500), _DATAF(-0.99685078859329224000)},
    {_DATAF(-0.07968243956565856900), _DATAF(-0.99682027101516724000)},
    {_DATAF(-0.08006470650434494000), _DATAF(-0.99678969383239746000)},
    {_DATAF(-0.08044696599245071400), _DATAF(-0.99675887823104858000)},
    {_DATAF(-0.08082921057939529400), _DATAF(-0.99672794342041016000)},
    {_DATAF(-0.08121144771575927700), _DATAF(-0.99669688940048218000)},
    {_DATAF(-0.08159366995096206700), _DATAF(-0.99666565656661987000)},
    {_DATAF(-0.08197587728500366200), _DATAF(-0.99663430452346802000)},
    {_DATAF(-0.08235807716846466100), _DATAF(-0.99660277366638184000)},
    {_DATAF(-0.08274026215076446500), _DATAF(-0.99657112360000610000)},
    {_DATAF(-0.08312243968248367300), _DATAF(-0.99653935432434082000)},
    {_DATAF(-0.08350460231304168700), _DATAF(-0.99650740623474121000)},
    {_DATAF(-0.08388675004243850700), _DATAF(-0.99647527933120728000)},
    {_DATAF(-0.08426889032125473000), _DATAF(-0.99644303321838379000)},
    {_DATAF(-0.08465101569890976000), _DATAF(-0.99641066789627075000)},
    {_DATAF(-0.08503312617540359500), _DATAF(-0.99637812376022339000)},
    {_DATAF(-0.08541522175073623700), _DATAF(-0.99634546041488647000)},
    {_DATAF(-0.08579730987548828100), _DATAF(-0.99631261825561523000)},
    {_DATAF(-0.08617939054965972900), _DATAF(-0.99627965688705444000)},
    {_DATAF(-0.08656144887208938600), _DATAF(-0.99624651670455933000)},
    {_DATAF(-0.08694349974393844600), _DATAF(-0.99621325731277466000)},
    {_DATAF(-0.08732553571462631200), _DATAF(-0.99617981910705566000)},
    {_DATAF(-0.08770755678415298500), _DATAF(-0.99614626169204712000)},
    {_DATAF(-0.08808957040309906000), _DATAF(-0.99611258506774902000)},
    {_DATAF(-0.08847156912088394200), _DATAF(-0.99607872962951660000)},
    {_DATAF(-0.08885355293750762900), _DATAF(-0.99604469537734985000)},
    {_DATAF(-0.08923552185297012300), _DATAF(-0.99601054191589355000)},
    {_DATAF(-0.08961748331785202000), _DATAF(-0.99597626924514771000)},
    {_DATAF(-0.08999942988157272300), _DATAF(-0.99594181776046753000)},
    {_DATAF(-0.09038136154413223300), _DATAF(-0.99590724706649780000)},
    {_DATAF(-0.09076327830553054800), _DATAF(-0.99587249755859375000)},
    {_DATAF(-0.09114518761634826700), _DATAF(-0.99583762884140015000)},
    {_DATAF(-0.09152707457542419400), _DATAF(-0.99580258131027222000)},
    {_DATAF(-0.09190895408391952500), _DATAF(-0.99576741456985474000)},
    {_DATAF(-0.09229081869125366200), _DATAF(-0.99573206901550293000)},
    {_DATAF(-0.09267267584800720200), _DATAF(-0.99569660425186157000)},
    {_DATAF(-0.09305451065301895100), _DATAF(-0.99566102027893066000)},
    {_DATAF(-0.09343633800745010400), _DATAF(-0.99562525749206543000)},
    {_DATAF(-0.09381814301013946500), _DATAF(-0.99558937549591064000)},
    {_DATAF(-0.09419994056224823000), _DATAF(-0.99555331468582153000)},
    {_DATAF(-0.09458172321319580100), _DATAF(-0.99551707506179810000)},
    {_DATAF(-0.09496349841356277500), _DATAF(-0.99548077583312988000)},
    {_DATAF(-0.09534525126218795800), _DATAF(-0.99544423818588257000)},
    {_DATAF(-0.09572698920965194700), _DATAF(-0.99540764093399048000)},
    {_DATAF(-0.09610871970653533900), _DATAF(-0.99537086486816406000)},
    {_DATAF(-0.09649042785167694100), _DATAF(-0.99533390998840332000)},
    {_DATAF(-0.09687212854623794600), _DATAF(-0.99529683589935303000)},
    {_DATAF(-0.09725381433963775600), _DATAF(-0.99525958299636841000)},
    {_DATAF(-0.09763548523187637300), _DATAF(-0.99522227048873901000)},
    {_DATAF(-0.09801714122295379600), _DATAF(-0.99518471956253052000)},
    {_DATAF(-0.09839878231287002600), _DATAF(-0.99514704942703247000)},
    {_DATAF(-0.09878040850162506100), _DATAF(-0.99510926008224487000)},
    {_DATAF(-0.09916201978921890300), _DATAF(-0.99507129192352295000)},
    {_DATAF(-0.09954361617565155000), _DATAF(-0.99503320455551147000)},
    {_DATAF(-0.09992520511150360100), _DATAF(-0.99499493837356567000)},
    {_DATAF(-0.10030677169561386000), _DATAF(-0.99495655298233032000)},
    {_DATAF(-0.10068832337856293000), _DATAF(-0.99491798877716064000)},
    {_DATAF(-0.10106986016035080000), _DATAF(-0.99487930536270142000)},
    {_DATAF(-0.10145138949155807000), _DATAF(-0.99484050273895264000)},
    {_DATAF(-0.10183289647102356000), _DATAF(-0.99480152130126953000)},
    {_DATAF(-0.10221438854932785000), _DATAF(-0.99476242065429688000)},
    {_DATAF(-0.10259586572647095000), _DATAF(-0.99472314119338989000)},
    {_DATAF(-0.10297733545303345000), _DATAF(-0.99468368291854858000)},
    {_DATAF(-0.10335878282785416000), _DATAF(-0.99464416503906250000)},
    {_DATAF(-0.10374021530151367000), _DATAF(-0.99460440874099731000)},
    {_DATAF(-0.10412163287401199000), _DATAF(-0.99456459283828735000)},
    {_DATAF(-0.10450303554534912000), _DATAF(-0.99452453851699829000)},
    {_DATAF(-0.10488442331552505000), _DATAF(-0.99448442459106445000)},
    {_DATAF(-0.10526579618453979000), _DATAF(-0.99444413185119629000)},
    {_DATAF(-0.10564715415239334000), _DATAF(-0.99440366029739380000)},
    {_DATAF(-0.10602849721908569000), _DATAF(-0.99436306953430176000)},
    {_DATAF(-0.10640981793403625000), _DATAF(-0.99432235956192017000)},
    {_DATAF(-0.10679113119840622000), _DATAF(-0.99428147077560425000)},
    {_DATAF(-0.10717242211103439000), _DATAF(-0.99424046277999878000)},
    {_DATAF(-0.10755370557308197000), _DATAF(-0.99419927597045898000)},
    {_DATAF(-0.10793496668338776000), _DATAF(-0.99415796995162964000)},
    {_DATAF(-0.10831621289253235000), _DATAF(-0.99411648511886597000)},
    {_DATAF(-0.10869744420051575000), _DATAF(-0.99407488107681274000)},
    {_DATAF(-0.10907866060733795000), _DATAF(-0.99403309822082520000)},
    {_DATAF(-0.10945985466241837000), _DATAF(-0.99399119615554810000)},
    {_DATAF(-0.10984104126691818000), _DATAF(-0.99394917488098145000)},
    {_DATAF(-0.11022220551967621000), _DATAF(-0.99390697479248047000)},
    {_DATAF(-0.11060335487127304000), _DATAF(-0.99386465549468994000)},
    {_DATAF(-0.11098448932170868000), _DATAF(-0.99382215738296509000)},
    {_DATAF(-0.11136560887098312000), _DATAF(-0.99377948045730591000)},
    {_DATAF(-0.11174671351909637000), _DATAF(-0.99373674392700195000)},
    {_DATAF(-0.11212779581546783000), _DATAF(-0.99369376897811890000)},
    {_DATAF(-0.11250886321067810000), _DATAF(-0.99365073442459106000)},
    {_DATAF(-0.11288991570472717000), _DATAF(-0.99360752105712891000)},
    {_DATAF(-0.11327095329761505000), _DATAF(-0.99356412887573242000)},
    {_DATAF(-0.11365196853876114000), _DATAF(-0.99352061748504639000)},
    {_DATAF(-0.11403297632932663000), _DATAF(-0.99347698688507080000)},
    {_DATAF(-0.11441396176815033000), _DATAF(-0.99343317747116089000)},
    {_DATAF(-0.11479492485523224000), _DATAF(-0.99338918924331665000)},
    {_DATAF(-0.11517588049173355000), _DATAF(-0.99334514141082764000)},
    {_DATAF(-0.11555681377649307000), _DATAF(-0.99330085515975952000)},
    {_DATAF(-0.11593773216009140000), _DATAF(-0.99325650930404663000)},
    {_DATAF(-0.11631862819194794000), _DATAF(-0.99321192502975464000)},
    {_DATAF(-0.11669951677322388000), _DATAF(-0.99316728115081787000)},
    {_DATAF(-0.11708038300275803000), _DATAF(-0.99312245845794678000)},
    {_DATAF(-0.11746122688055038000), _DATAF(-0.99307745695114136000)},
    {_DATAF(-0.11784206330776215000), _DATAF(-0.99303233623504639000)},
    {_DATAF(-0.11822287738323212000), _DATAF(-0.99298709630966187000)},
    {_DATAF(-0.11860367655754089000), _DATAF(-0.99294167757034302000)},
    {_DATAF(-0.11898445338010788000), _DATAF(-0.99289613962173462000)},
    {_DATAF(-0.11936521530151367000), _DATAF(-0.99285042285919189000)},
    {_DATAF(-0.11974596232175827000), _DATAF(-0.99280458688735962000)},
    {_DATAF(-0.12012668699026108000), _DATAF(-0.99275857210159302000)},
    {_DATAF(-0.12050739675760269000), _DATAF(-0.99271243810653687000)},
    {_DATAF(-0.12088808417320251000), _DATAF(-0.99266612529754639000)},
    {_DATAF(-0.12126876413822174000), _DATAF(-0.99261969327926636000)},
    {_DATAF(-0.12164941430091858000), _DATAF(-0.99257314205169678000)},
    {_DATAF(-0.12203005701303482000), _DATAF(-0.99252641201019287000)},
    {_DATAF(-0.12241067737340927000), _DATAF(-0.99247956275939941000)},
    {_DATAF(-0.12279127538204193000), _DATAF(-0.99243253469467163000)},
    {_DATAF(-0.12317185848951340000), _DATAF(-0.99238532781600952000)},
    {_DATAF(-0.12355242669582367000), _DATAF(-0.99233806133270264000)},
    {_DATAF(-0.12393297255039215000), _DATAF(-0.99229061603546143000)},
    {_DATAF(-0.12431350350379944000), _DATAF(-0.99224299192428589000)},
    {_DATAF(-0.12469401955604553000), _DATAF(-0.99219524860382080000)},
    {_DATAF(-0.12507450580596924000), _DATAF(-0.99214732646942139000)},
    {_DATAF(-0.12545497715473175000), _DATAF(-0.99209928512573242000)},
    {_DATAF(-0.12583543360233307000), _DATAF(-0.99205112457275391000)},
    {_DATAF(-0.12621587514877319000), _DATAF(-0.99200278520584106000)},
    {_DATAF(-0.12659630179405212000), _DATAF(-0.99195432662963867000)},
    {_DATAF(-0.12697669863700867000), _DATAF(-0.99190568923950195000)},
    {_DATAF(-0.12735708057880402000), _DATAF(-0.99185693264007568000)},
    {_DATAF(-0.12773744761943817000), _DATAF(-0.99180799722671509000)},
    {_DATAF(-0.12811778485774994000), _DATAF(-0.99175894260406494000)},
    {_DATAF(-0.12849810719490051000), _DATAF(-0.99170976877212524000)},
    {_DATAF(-0.12887841463088989000), _DATAF(-0.99166041612625122000)},
    {_DATAF(-0.12925870716571808000), _DATAF(-0.99161088466644287000)},
    {_DATAF(-0.12963896989822388000), _DATAF(-0.99156123399734497000)},
    {_DATAF(-0.13001921772956848000), _DATAF(-0.99151146411895752000)},
    {_DATAF(-0.13039945065975189000), _DATAF(-0.99146151542663574000)},
    {_DATAF(-0.13077966868877411000), _DATAF(-0.99141144752502441000)},
    {_DATAF(-0.13115985691547394000), _DATAF(-0.99136126041412354000)},
    {_DATAF(-0.13154003024101257000), _DATAF(-0.99131083488464355000)},
    {_DATAF(-0.13192018866539001000), _DATAF(-0.99126034975051880000)},
    {_DATAF(-0.13230031728744507000), _DATAF(-0.99120968580245972000)},
    {_DATAF(-0.13268043100833893000), _DATAF(-0.99115884304046631000)},
    {_DATAF(-0.13306052982807159000), _DATAF(-0.99110794067382813000)},
    {_DATAF(-0.13344059884548187000), _DATAF(-0.99105679988861084000)},
    {_DATAF(-0.13382065296173096000), _DATAF(-0.99100553989410400000)},
    {_DATAF(-0.13420069217681885000), _DATAF(-0.99095416069030762000)},
    {_DATAF(-0.13458070158958435000), _DATAF(-0.99090266227722168000)},
    {_DATAF(-0.13496071100234985000), _DATAF(-0.99085092544555664000)},
    {_DATAF(-0.13534067571163177000), _DATAF(-0.99079912900924683000)},
    {_DATAF(-0.13572064042091370000), _DATAF(-0.99074715375900269000)},
    {_DATAF(-0.13610057532787323000), _DATAF(-0.99069499969482422000)},
    {_DATAF(-0.13648049533367157000), _DATAF(-0.99064278602600098000)},
    {_DATAF(-0.13686038553714752000), _DATAF(-0.99059033393859863000)},
    {_DATAF(-0.13724026083946228000), _DATAF(-0.99053776264190674000)},
    {_DATAF(-0.13762012124061584000), _DATAF(-0.99048507213592529000)},
    {_DATAF(-0.13799995183944702000), _DATAF(-0.99043226242065430000)},
    {_DATAF(-0.13837976753711700000), _DATAF(-0.99037921428680420000)},
    {_DATAF(-0.13875956833362579000), _DATAF(-0.99032610654830933000)},
    {_DATAF(-0.13913933932781219000), _DATAF(-0.99027281999588013000)},
    {_DATAF(-0.13951909542083740000), _DATAF(-0.99021935462951660000)},
    {_DATAF(-0.13989883661270142000), _DATAF(-0.99016582965850830000)},
    {_DATAF(-0.14027854800224304000), _DATAF(-0.99011206626892090000)},
    {_DATAF(-0.14065824449062347000), _DATAF(-0.99005818367004395000)},
    {_DATAF(-0.14103791117668152000), _DATAF(-0.99000418186187744000)},
    {_DATAF(-0.14141756296157837000), _DATAF(-0.98995006084442139000)},
    {_DATAF(-0.14179719984531403000), _DATAF(-0.98989570140838623000)},
    {_DATAF(-0.14217680692672729000), _DATAF(-0.98984128236770630000)},
    {_DATAF(-0.14255639910697937000), _DATAF(-0.98978668451309204000)},
    {_DATAF(-0.14293596148490906000), _DATAF(-0.98973196744918823000)},
    {_DATAF(-0.14331550896167755000), _DATAF(-0.98967707157135010000)},
    {_DATAF(-0.14369502663612366000), _DATAF(-0.98962199687957764000)},
    {_DATAF(-0.14407454431056976000), _DATAF(-0.98956686258316040000)},
    {_DATAF(-0.14445401728153229000), _DATAF(-0.98951148986816406000)},
    {_DATAF(-0.14483349025249481000), _DATAF(-0.98945605754852295000)},
    {_DATAF(-0.14521291851997375000), _DATAF(-0.98940044641494751000)},
    {_DATAF(-0.14559234678745270000), _DATAF(-0.98934465646743774000)},
    {_DATAF(-0.14597174525260925000), _DATAF(-0.98928874731063843000)},
    {_DATAF(-0.14635111391544342000), _DATAF(-0.98923271894454956000)},
    {_DATAF(-0.14673046767711639000), _DATAF(-0.98917651176452637000)},
    {_DATAF(-0.14710980653762817000), _DATAF(-0.98912018537521362000)},
    {_DATAF(-0.14748911559581757000), _DATAF(-0.98906368017196655000)},
    {_DATAF(-0.14786840975284576000), _DATAF(-0.98900705575942993000)},
    {_DATAF(-0.14824767410755157000), _DATAF(-0.98895025253295898000)},
    {_DATAF(-0.14862692356109619000), _DATAF(-0.98889333009719849000)},
    {_DATAF(-0.14900614321231842000), _DATAF(-0.98883628845214844000)},
    {_DATAF(-0.14938534796237946000), _DATAF(-0.98877906799316406000)},
    {_DATAF(-0.14976453781127930000), _DATAF(-0.98872166872024536000)},
    {_DATAF(-0.15014369785785675000), _DATAF(-0.98866420984268188000)},
    {_DATAF(-0.15052282810211182000), _DATAF(-0.98860651254653931000)},
    {_DATAF(-0.15090194344520569000), _DATAF(-0.98854875564575195000)},
    {_DATAF(-0.15128104388713837000), _DATAF(-0.98849081993103027000)},
    {_DATAF(-0.15166011452674866000), _DATAF(-0.98843270540237427000)},
    {_DATAF(-0.15203915536403656000), _DATAF(-0.98837447166442871000)},
    {_DATAF(-0.15241818130016327000), _DATAF(-0.98831611871719360000)},
    {_DATAF(-0.15279719233512878000), _DATAF(-0.98825758695602417000)},
    {_DATAF(-0.15317615866661072000), _DATAF(-0.98819887638092041000)},
    {_DATAF(-0.15355512499809265000), _DATAF(-0.98814010620117188000)},
    {_DATAF(-0.15393406152725220000), _DATAF(-0.98808109760284424000)},
    {_DATAF(-0.15431296825408936000), _DATAF(-0.98802202939987183000)},
    {_DATAF(-0.15469186007976532000), _DATAF(-0.98796278238296509000)},
    {_DATAF(-0.15507073700428009000), _DATAF(-0.98790335655212402000)},
    {_DATAF(-0.15544956922531128000), _DATAF(-0.98784381151199341000)},
    {_DATAF(-0.15582840144634247000), _DATAF(-0.98778414726257324000)},
    {_DATAF(-0.15620720386505127000), _DATAF(-0.98772430419921875000)},
    {_DATAF(-0.15658597648143768000), _DATAF(-0.98766434192657471000)},
    {_DATAF(-0.15696471929550171000), _DATAF(-0.98760420083999634000)},
    {_DATAF(-0.15734346210956573000), _DATAF(-0.98754394054412842000)},
    {_DATAF(-0.15772216022014618000), _DATAF(-0.98748350143432617000)},
    {_DATAF(-0.15810084342956543000), _DATAF(-0.98742294311523438000)},
    {_DATAF(-0.15847951173782349000), _DATAF(-0.98736226558685303000)},
    {_DATAF(-0.15885815024375916000), _DATAF(-0.98730140924453735000)},
    {_DATAF(-0.15923675894737244000), _DATAF(-0.98724043369293213000)},
    {_DATAF(-0.15961535274982452000), _DATAF(-0.98717927932739258000)},
    {_DATAF(-0.15999391674995422000), _DATAF(-0.98711800575256348000)},
    {_DATAF(-0.16037245094776154000), _DATAF(-0.98705655336380005000)},
    {_DATAF(-0.16075097024440765000), _DATAF(-0.98699498176574707000)},
    {_DATAF(-0.16112947463989258000), _DATAF(-0.98693329095840454000)},
    {_DATAF(-0.16150794923305511000), _DATAF(-0.98687142133712769000)},
    {_DATAF(-0.16188639402389526000), _DATAF(-0.98680937290191650000)},
    {_DATAF(-0.16226482391357422000), _DATAF(-0.98674726486206055000)},
    {_DATAF(-0.16264322400093079000), _DATAF(-0.98668491840362549000)},
    {_DATAF(-0.16302159428596497000), _DATAF(-0.98662251234054565000)},
    {_DATAF(-0.16339994966983795000), _DATAF(-0.98655992746353149000)},
    {_DATAF(-0.16377827525138855000), _DATAF(-0.98649716377258301000)},
    {_DATAF(-0.16415658593177795000), _DATAF(-0.98643428087234497000)},
    {_DATAF(-0.16453486680984497000), _DATAF(-0.98637127876281738000)},
    {_DATAF(-0.16491311788558960000), _DATAF(-0.98630809783935547000)},
    {_DATAF(-0.16529135406017303000), _DATAF(-0.98624479770660400000)},
    {_DATAF(-0.16566956043243408000), _DATAF(-0.98618131875991821000)},
    {_DATAF(-0.16604773700237274000), _DATAF(-0.98611772060394287000)},
    {_DATAF(-0.16642589867115021000), _DATAF(-0.98605394363403320000)},
    {_DATAF(-0.16680404543876648000), _DATAF(-0.98599004745483398000)},
    {_DATAF(-0.16718214750289917000), _DATAF(-0.98592603206634521000)},
    {_DATAF(-0.16756023466587067000), _DATAF(-0.98586183786392212000)},
    {_DATAF(-0.16793829202651978000), _DATAF(-0.98579752445220947000)},
    {_DATAF(-0.16831633448600769000), _DATAF(-0.98573303222656250000)},
    {_DATAF(-0.16869434714317322000), _DATAF(-0.98566842079162598000)},
    {_DATAF(-0.16907232999801636000), _DATAF(-0.98560363054275513000)},
    {_DATAF(-0.16945029795169830000), _DATAF(-0.98553872108459473000)},
    {_DATAF(-0.16982822120189667000), _DATAF(-0.98547369241714478000)},
    {_DATAF(-0.17020614445209503000), _DATAF(-0.98540848493576050000)},
    {_DATAF(-0.17058402299880981000), _DATAF(-0.98534315824508667000)},
    {_DATAF(-0.17096188664436340000), _DATAF(-0.98527765274047852000)},
    {_DATAF(-0.17133972048759460000), _DATAF(-0.98521202802658081000)},
    {_DATAF(-0.17171753942966461000), _DATAF(-0.98514622449874878000)},
    {_DATAF(-0.17209532856941223000), _DATAF(-0.98508030176162720000)},
    {_DATAF(-0.17247308790683746000), _DATAF(-0.98501425981521606000)},
    {_DATAF(-0.17285081744194031000), _DATAF(-0.98494803905487061000)},
    {_DATAF(-0.17322853207588196000), _DATAF(-0.98488163948059082000)},
    {_DATAF(-0.17360621690750122000), _DATAF(-0.98481518030166626000)},
    {_DATAF(-0.17398387193679810000), _DATAF(-0.98474848270416260000)},
    {_DATAF(-0.17436151206493378000), _DATAF(-0.98468172550201416000)},
    {_DATAF(-0.17473910748958588000), _DATAF(-0.98461478948593140000)},
    {_DATAF(-0.17511670291423798000), _DATAF(-0.98454767465591431000)},
    {_DATAF(-0.17549425363540649000), _DATAF(-0.98448044061660767000)},
    {_DATAF(-0.17587178945541382000), _DATAF(-0.98441308736801147000)},
    {_DATAF(-0.17624929547309875000), _DATAF(-0.98434555530548096000)},
    {_DATAF(-0.17662677168846130000), _DATAF(-0.98427790403366089000)},
    {_DATAF(-0.17700421810150146000), _DATAF(-0.98421007394790649000)},
    {_DATAF(-0.17738164961338043000), _DATAF(-0.98414212465286255000)},
    {_DATAF(-0.17775905132293701000), _DATAF(-0.98407405614852905000)},
    {_DATAF(-0.17813642323017120000), _DATAF(-0.98400580883026123000)},
    {_DATAF(-0.17851376533508301000), _DATAF(-0.98393744230270386000)},
    {_DATAF(-0.17889109253883362000), _DATAF(-0.98386889696121216000)},
    {_DATAF(-0.17926838994026184000), _DATAF(-0.98380023241043091000)},
    {_DATAF(-0.17964565753936768000), _DATAF(-0.98373138904571533000)},
    {_DATAF(-0.18002289533615112000), _DATAF(-0.98366242647171021000)},
    {_DATAF(-0.18040011823177338000), _DATAF(-0.98359328508377075000)},
    {_DATAF(-0.18077731132507324000), _DATAF(-0.98352402448654175000)},
    {_DATAF(-0.18115447461605072000), _DATAF(-0.98345464468002319000)},
    {_DATAF(-0.18153160810470581000), _DATAF(-0.98338508605957031000)},
    {_DATAF(-0.18190871179103851000), _DATAF(-0.98331540822982788000)},
    {_DATAF(-0.18228580057621002000), _DATAF(-0.98324561119079590000)},
    {_DATAF(-0.18266285955905914000), _DATAF(-0.98317563533782959000)},
    {_DATAF(-0.18303988873958588000), _DATAF(-0.98310548067092896000)},
    {_DATAF(-0.18341688811779022000), _DATAF(-0.98303520679473877000)},
    {_DATAF(-0.18379387259483337000), _DATAF(-0.98296481370925903000)},
    {_DATAF(-0.18417081236839294000), _DATAF(-0.98289424180984497000)},
    {_DATAF(-0.18454773724079132000), _DATAF(-0.98282355070114136000)},
    {_DATAF(-0.18492463231086731000), _DATAF(-0.98275268077850342000)},
    {_DATAF(-0.18530149757862091000), _DATAF(-0.98268169164657593000)},
    {_DATAF(-0.18567833304405212000), _DATAF(-0.98261058330535889000)},
    {_DATAF(-0.18605515360832214000), _DATAF(-0.98253929615020752000)},
    {_DATAF(-0.18643194437026978000), _DATAF(-0.98246788978576660000)},
    {_DATAF(-0.18680869042873383000), _DATAF(-0.98239630460739136000)},
    {_DATAF(-0.18718542158603668000), _DATAF(-0.98232460021972656000)},
    {_DATAF(-0.18756212294101715000), _DATAF(-0.98225271701812744000)},
    {_DATAF(-0.18793880939483643000), _DATAF(-0.98218071460723877000)},
    {_DATAF(-0.18831545114517212000), _DATAF(-0.98210859298706055000)},
    {_DATAF(-0.18869207799434662000), _DATAF(-0.98203629255294800000)},
    {_DATAF(-0.18906866014003754000), _DATAF(-0.98196387290954590000)},
    {_DATAF(-0.18944522738456726000), _DATAF(-0.98189127445220947000)},
    {_DATAF(-0.18982176482677460000), _DATAF(-0.98181855678558350000)},
    {_DATAF(-0.19019827246665955000), _DATAF(-0.98174571990966797000)},
    {_DATAF(-0.19057475030422211000), _DATAF(-0.98167270421981812000)},
    {_DATAF(-0.19095121324062347000), _DATAF(-0.98159950971603394000)},
    {_DATAF(-0.19132763147354126000), _DATAF(-0.98152625560760498000)},
    {_DATAF(-0.19170403480529785000), _DATAF(-0.98145276308059692000)},
    {_DATAF(-0.19208039343357086000), _DATAF(-0.98137921094894409000)},
    {_DATAF(-0.19245673716068268000), _DATAF(-0.98130548000335693000)},
    {_DATAF(-0.19283305108547211000), _DATAF(-0.98123157024383545000)},
    {_DATAF(-0.19320933520793915000), _DATAF(-0.98115754127502441000)},
    {_DATAF(-0.19358558952808380000), _DATAF(-0.98108339309692383000)},
    {_DATAF(-0.19396181404590607000), _DATAF(-0.98100906610488892000)},
    {_DATAF(-0.19433800876140594000), _DATAF(-0.98093461990356445000)},
    {_DATAF(-0.19471418857574463000), _DATAF(-0.98085999488830566000)},
    {_DATAF(-0.19509032368659973000), _DATAF(-0.98078525066375732000)},
    {_DATAF(-0.19546642899513245000), _DATAF(-0.98071038722991943000)},
    {_DATAF(-0.19584251940250397000), _DATAF(-0.98063534498214722000)},
    {_DATAF(-0.19621856510639191000), _DATAF(-0.98056018352508545000)},
    {_DATAF(-0.19659459590911865000), _DATAF(-0.98048484325408936000)},
    {_DATAF(-0.19697059690952301000), _DATAF(-0.98040938377380371000)},
    {_DATAF(-0.19734656810760498000), _DATAF(-0.98033380508422852000)},
    {_DATAF(-0.19772249460220337000), _DATAF(-0.98025804758071899000)},
    {_DATAF(-0.19809840619564056000), _DATAF(-0.98018211126327515000)},
    {_DATAF(-0.19847428798675537000), _DATAF(-0.98010611534118652000)},
    {_DATAF(-0.19885013997554779000), _DATAF(-0.98002988100051880000)},
    {_DATAF(-0.19922596216201782000), _DATAF(-0.97995358705520630000)},
    {_DATAF(-0.19960175454616547000), _DATAF(-0.97987711429595947000)},
    {_DATAF(-0.19997751712799072000), _DATAF(-0.97980046272277832000)},
    {_DATAF(-0.20035324990749359000), _DATAF(-0.97972375154495239000)},
    {_DATAF(-0.20072895288467407000), _DATAF(-0.97964680194854736000)},
    {_DATAF(-0.20110464096069336000), _DATAF(-0.97956979274749756000)},
    {_DATAF(-0.20148028433322906000), _DATAF(-0.97949254512786865000)},
    {_DATAF(-0.20185589790344238000), _DATAF(-0.97941523790359497000)},
    {_DATAF(-0.20223148167133331000), _DATAF(-0.97933775186538696000)},
    {_DATAF(-0.20260703563690186000), _DATAF(-0.97926014661788940000)},
    {_DATAF(-0.20298255980014801000), _DATAF(-0.97918236255645752000)},
    {_DATAF(-0.20335806906223297000), _DATAF(-0.97910445928573608000)},
    {_DATAF(-0.20373353362083435000), _DATAF(-0.97902637720108032000)},
    {_DATAF(-0.20410896837711334000), _DATAF(-0.97894817590713501000)},
    {_DATAF(-0.20448437333106995000), _DATAF(-0.97886985540390015000)},
    {_DATAF(-0.20485974848270416000), _DATAF(-0.97879135608673096000)},
    {_DATAF(-0.20523509383201599000), _DATAF(-0.97871267795562744000)},
    {_DATAF(-0.20561040937900543000), _DATAF(-0.97863394021987915000)},
    {_DATAF(-0.20598569512367249000), _DATAF(-0.97855502367019653000)},
    {_DATAF(-0.20636095106601715000), _DATAF(-0.97847592830657959000)},
    {_DATAF(-0.20673617720603943000), _DATAF(-0.97839671373367310000)},
    {_DATAF(-0.20711137354373932000), _DATAF(-0.97831737995147705000)},
    {_DATAF(-0.20748654007911682000), _DATAF(-0.97823786735534668000)},
    {_DATAF(-0.20786167681217194000), _DATAF(-0.97815823554992676000)},
    {_DATAF(-0.20823678374290466000), _DATAF(-0.97807842493057251000)},
    {_DATAF(-0.20861184597015381000), _DATAF(-0.97799849510192871000)},
    {_DATAF(-0.20898689329624176000), _DATAF(-0.97791844606399536000)},
    {_DATAF(-0.20936191082000732000), _DATAF(-0.97783821821212769000)},
    {_DATAF(-0.20973688364028931000), _DATAF(-0.97775787115097046000)},
    {_DATAF(-0.21011184155941010000), _DATAF(-0.97767734527587891000)},
    {_DATAF(-0.21048675477504730000), _DATAF(-0.97759670019149780000)},
    {_DATAF(-0.21086163818836212000), _DATAF(-0.97751593589782715000)},
    {_DATAF(-0.21123650670051575000), _DATAF(-0.97743499279022217000)},
    {_DATAF(-0.21161133050918579000), _DATAF(-0.97735387086868286000)},
    {_DATAF(-0.21198612451553345000), _DATAF(-0.97727268934249878000)},
    {_DATAF(-0.21236088871955872000), _DATAF(-0.97719132900238037000)},
    {_DATAF(-0.21273562312126160000), _DATAF(-0.97710978984832764000)},
    {_DATAF(-0.21311031281948090000), _DATAF(-0.97702813148498535000)},
    {_DATAF(-0.21348498761653900000), _DATAF(-0.97694635391235352000)},
    {_DATAF(-0.21385963261127472000), _DATAF(-0.97686439752578735000)},
    {_DATAF(-0.21423423290252686000), _DATAF(-0.97678232192993164000)},
    {_DATAF(-0.21460881829261780000), _DATAF(-0.97670006752014160000)},
    {_DATAF(-0.21498335897922516000), _DATAF(-0.97661769390106201000)},
    {_DATAF(-0.21535786986351013000), _DATAF(-0.97653520107269287000)},
    {_DATAF(-0.21573235094547272000), _DATAF(-0.97645252943038940000)},
    {_DATAF(-0.21610680222511292000), _DATAF(-0.97636973857879639000)},
    {_DATAF(-0.21648120880126953000), _DATAF(-0.97628676891326904000)},
    {_DATAF(-0.21685560047626495000), _DATAF(-0.97620368003845215000)},
    {_DATAF(-0.21722994744777679000), _DATAF(-0.97612047195434570000)},
    {_DATAF(-0.21760427951812744000), _DATAF(-0.97603708505630493000)},
    {_DATAF(-0.21797856688499451000), _DATAF(-0.97595357894897461000)},
    {_DATAF(-0.21835282444953918000), _DATAF(-0.97586989402770996000)},
    {_DATAF(-0.21872705221176147000), _DATAF(-0.97578608989715576000)},
    {_DATAF(-0.21910123527050018000), _DATAF(-0.97570210695266724000)},
    {_DATAF(-0.21947540342807770000), _DATAF(-0.97561800479888916000)},
    {_DATAF(-0.21984952688217163000), _DATAF(-0.97553378343582153000)},
    {_DATAF(-0.22022362053394318000), _DATAF(-0.97544938325881958000)},
    {_DATAF(-0.22059768438339233000), _DATAF(-0.97536486387252808000)},
    {_DATAF(-0.22097171843051910000), _DATAF(-0.97528022527694702000)},
    {_DATAF(-0.22134572267532349000), _DATAF(-0.97519540786743164000)},
    {_DATAF(-0.22171968221664429000), _DATAF(-0.97511047124862671000)},
    {_DATAF(-0.22209362685680389000), _DATAF(-0.97502535581588745000)},
    {_DATAF(-0.22246752679347992000), _DATAF(-0.97494012117385864000)},
    {_DATAF(-0.22284139692783356000), _DATAF(-0.97485470771789551000)},
    {_DATAF(-0.22321522235870361000), _DATAF(-0.97476917505264282000)},
    {_DATAF(-0.22358903288841248000), _DATAF(-0.97468352317810059000)},
    {_DATAF(-0.22396279871463776000), _DATAF(-0.97459769248962402000)},
    {_DATAF(-0.22433653473854065000), _DATAF(-0.97451174259185791000)},
    {_DATAF(-0.22471024096012115000), _DATAF(-0.97442561388015747000)},
    {_DATAF(-0.22508391737937927000), _DATAF(-0.97433936595916748000)},
    {_DATAF(-0.22545754909515381000), _DATAF(-0.97425299882888794000)},
    {_DATAF(-0.22583115100860596000), _DATAF(-0.97416645288467407000)},
    {_DATAF(-0.22620472311973572000), _DATAF(-0.97407978773117065000)},
    {_DATAF(-0.22657826542854309000), _DATAF(-0.97399294376373291000)},
    {_DATAF(-0.22695176303386688000), _DATAF(-0.97390598058700562000)},
    {_DATAF(-0.22732524573802948000), _DATAF(-0.97381889820098877000)},
    {_DATAF(-0.22769868373870850000), _DATAF(-0.97373163700103760000)},
    {_DATAF(-0.22807207703590393000), _DATAF(-0.97364425659179688000)},
    {_DATAF(-0.22844545543193817000), _DATAF(-0.97355669736862183000)},
    {_DATAF(-0.22881878912448883000), _DATAF(-0.97346901893615723000)},
    {_DATAF(-0.22919209301471710000), _DATAF(-0.97338122129440308000)},
    {_DATAF(-0.22956536710262299000), _DATAF(-0.97329324483871460000)},
    {_DATAF(-0.22993859648704529000), _DATAF(-0.97320514917373657000)},
    {_DATAF(-0.23031181097030640000), _DATAF(-0.97311687469482422000)},
    {_DATAF(-0.23068498075008392000), _DATAF(-0.97302848100662231000)},
    {_DATAF(-0.23105810582637787000), _DATAF(-0.97293996810913086000)},
    {_DATAF(-0.23143121600151062000), _DATAF(-0.97285127639770508000)},
    {_DATAF(-0.23180428147315979000), _DATAF(-0.97276246547698975000)},
    {_DATAF(-0.23217730224132538000), _DATAF(-0.97267347574234009000)},
    {_DATAF(-0.23255030810832977000), _DATAF(-0.97258436679840088000)},
    {_DATAF(-0.23292326927185059000), _DATAF(-0.97249513864517212000)},
    {_DATAF(-0.23329620063304901000), _DATAF(-0.97240573167800903000)},
    {_DATAF(-0.23366910219192505000), _DATAF(-0.97231620550155640000)},
    {_DATAF(-0.23404195904731750000), _DATAF(-0.97222650051116943000)},
    {_DATAF(-0.23441478610038757000), _DATAF(-0.97213667631149292000)},
    {_DATAF(-0.23478758335113525000), _DATAF(-0.97204673290252686000)},
    {_DATAF(-0.23516033589839935000), _DATAF(-0.97195661067962646000)},
    {_DATAF(-0.23553305864334106000), _DATAF(-0.97186630964279175000)},
    {_DATAF(-0.23590575158596039000), _DATAF(-0.97177594900131226000)},
    {_DATAF(-0.23627839982509613000), _DATAF(-0.97168540954589844000)},
    {_DATAF(-0.23665101826190948000), _DATAF(-0.97159469127655029000)},
    {_DATAF(-0.23702360689640045000), _DATAF(-0.97150391340255737000)},
    {_DATAF(-0.23739615082740784000), _DATAF(-0.97141289710998535000)},
    {_DATAF(-0.23776866495609283000), _DATAF(-0.97132182121276855000)},
    {_DATAF(-0.23814114928245544000), _DATAF(-0.97123056650161743000)},
    {_DATAF(-0.23851358890533447000), _DATAF(-0.97113913297653198000)},
    {_DATAF(-0.23888599872589111000), _DATAF(-0.97104763984680176000)},
    {_DATAF(-0.23925837874412537000), _DATAF(-0.97095590829849243000)},
    {_DATAF(-0.23963071405887604000), _DATAF(-0.97086411714553833000)},
    {_DATAF(-0.24000301957130432000), _DATAF(-0.97077214717864990000)},
    {_DATAF(-0.24037529528141022000), _DATAF(-0.97068005800247192000)},
    {_DATAF(-0.24074752628803253000), _DATAF(-0.97058779001235962000)},
    {_DATAF(-0.24111972749233246000), _DATAF(-0.97049540281295776000)},
    {_DATAF(-0.24149188399314880000), _DATAF(-0.97040283679962158000)},
    {_DATAF(-0.24186401069164276000), _DATAF(-0.97031015157699585000)},
    {_DATAF(-0.24223610758781433000), _DATAF(-0.97021734714508057000)},
    {_DATAF(-0.24260815978050232000), _DATAF(-0.97012436389923096000)},
    {_DATAF(-0.24298018217086792000), _DATAF(-0.97003126144409180000)},
    {_DATAF(-0.24335215985774994000), _DATAF(-0.96993798017501831000)},
    {_DATAF(-0.24372410774230957000), _DATAF(-0.96984457969665527000)},
    {_DATAF(-0.24409602582454681000), _DATAF(-0.96975106000900269000)},
    {_DATAF(-0.24446789920330048000), _DATAF(-0.96965736150741577000)},
    {_DATAF(-0.24483974277973175000), _DATAF(-0.96956354379653931000)},
    {_DATAF(-0.24521154165267944000), _DATAF(-0.96946960687637329000)},
    {_DATAF(-0.24558331072330475000), _DATAF(-0.96937549114227295000)},
    {_DATAF(-0.24595504999160767000), _DATAF(-0.96928125619888306000)},
    {_DATAF(-0.24632674455642700000), _DATAF(-0.96918684244155884000)},
    {_DATAF(-0.24669840931892395000), _DATAF(-0.96909230947494507000)},
    {_DATAF(-0.24707002937793732000), _DATAF(-0.96899759769439697000)},
    {_DATAF(-0.24744161963462830000), _DATAF(-0.96890282630920410000)},
    {_DATAF(-0.24781316518783569000), _DATAF(-0.96880781650543213000)},
    {_DATAF(-0.24818468093872070000), _DATAF(-0.96871274709701538000)},
    {_DATAF(-0.24855616688728333000), _DATAF(-0.96861749887466431000)},
    {_DATAF(-0.24892760813236237000), _DATAF(-0.96852207183837891000)},
    {_DATAF(-0.24929900467395782000), _DATAF(-0.96842658519744873000)},
    {_DATAF(-0.24967038631439209000), _DATAF(-0.96833086013793945000)},
    {_DATAF(-0.25004172325134277000), _DATAF(-0.96823507547378540000)},
    {_DATAF(-0.25041300058364868000), _DATAF(-0.96813911199569702000)},
    {_DATAF(-0.25078427791595459000), _DATAF(-0.96804302930831909000)},
    {_DATAF(-0.25115549564361572000), _DATAF(-0.96794676780700684000)},
    {_DATAF(-0.25152668356895447000), _DATAF(-0.96785038709640503000)},
    {_DATAF(-0.25189781188964844000), _DATAF(-0.96775382757186890000)},
    {_DATAF(-0.25226894021034241000), _DATAF(-0.96765714883804321000)},
    {_DATAF(-0.25264000892639160000), _DATAF(-0.96756035089492798000)},
    {_DATAF(-0.25301104784011841000), _DATAF(-0.96746337413787842000)},
    {_DATAF(-0.25338202714920044000), _DATAF(-0.96736627817153931000)},
    {_DATAF(-0.25375300645828247000), _DATAF(-0.96726906299591064000)},
    {_DATAF(-0.25412392616271973000), _DATAF(-0.96717166900634766000)},
    {_DATAF(-0.25449481606483459000), _DATAF(-0.96707415580749512000)},
    {_DATAF(-0.25486564636230469000), _DATAF(-0.96697646379470825000)},
    {_DATAF(-0.25523647665977478000), _DATAF(-0.96687865257263184000)},
    {_DATAF(-0.25560724735260010000), _DATAF(-0.96678072214126587000)},
    {_DATAF(-0.25597798824310303000), _DATAF(-0.96668261289596558000)},
    {_DATAF(-0.25634866952896118000), _DATAF(-0.96658438444137573000)},
    {_DATAF(-0.25671935081481934000), _DATAF(-0.96648597717285156000)},
    {_DATAF(-0.25708997249603271000), _DATAF(-0.96638745069503784000)},
    {_DATAF(-0.25746056437492371000), _DATAF(-0.96628880500793457000)},
    {_DATAF(-0.25783109664916992000), _DATAF(-0.96618998050689697000)},
    {_DATAF(-0.25820159912109375000), _DATAF(-0.96609103679656982000)},
    {_DATAF(-0.25857207179069519000), _DATAF(-0.96599197387695313000)},
    {_DATAF(-0.25894251465797424000), _DATAF(-0.96589273214340210000)},
    {_DATAF(-0.25931292772293091000), _DATAF(-0.96579337120056152000)},
    {_DATAF(-0.25968328118324280000), _DATAF(-0.96569383144378662000)},
    {_DATAF(-0.26005360484123230000), _DATAF(-0.96559417247772217000)},
    {_DATAF(-0.26042386889457703000), _DATAF(-0.96549439430236816000)},
    {_DATAF(-0.26079410314559937000), _DATAF(-0.96539443731307983000)},
    {_DATAF(-0.26116433739662170000), _DATAF(-0.96529436111450195000)},
    {_DATAF(-0.26153448224067688000), _DATAF(-0.96519410610198975000)},
    {_DATAF(-0.26190462708473206000), _DATAF(-0.96509379148483276000)},
    {_DATAF(-0.26227471232414246000), _DATAF(-0.96499323844909668000)},
    {_DATAF(-0.26264476776123047000), _DATAF(-0.96489262580871582000)},
    {_DATAF(-0.26301476359367371000), _DATAF(-0.96479183435440063000)},
    {_DATAF(-0.26338472962379456000), _DATAF(-0.96469086408615112000)},
    {_DATAF(-0.26375466585159302000), _DATAF(-0.96458977460861206000)},
    {_DATAF(-0.26412457227706909000), _DATAF(-0.96448856592178345000)},
    {_DATAF(-0.26449441909790039000), _DATAF(-0.96438723802566528000)},
    {_DATAF(-0.26486423611640930000), _DATAF(-0.96428573131561279000)},
    {_DATAF(-0.26523402333259583000), _DATAF(-0.96418404579162598000)},
    {_DATAF(-0.26560378074645996000), _DATAF(-0.96408230066299438000)},
    {_DATAF(-0.26597347855567932000), _DATAF(-0.96398037672042847000)},
    {_DATAF(-0.26634314656257629000), _DATAF(-0.96387827396392822000)},
    {_DATAF(-0.26671275496482849000), _DATAF(-0.96377605199813843000)},
    {_DATAF(-0.26708233356475830000), _DATAF(-0.96367371082305908000)},
    {_DATAF(-0.26745188236236572000), _DATAF(-0.96357119083404541000)},
    {_DATAF(-0.26782140135765076000), _DATAF(-0.96346855163574219000)},
    {_DATAF(-0.26819086074829102000), _DATAF(-0.96336579322814941000)},
    {_DATAF(-0.26856029033660889000), _DATAF(-0.96326285600662231000)},
    {_DATAF(-0.26892966032028198000), _DATAF(-0.96315979957580566000)},
    {_DATAF(-0.26929903030395508000), _DATAF(-0.96305662393569946000)},
    {_DATAF(-0.26966831088066101000), _DATAF(-0.96295326948165894000)},
    {_DATAF(-0.27003759145736694000), _DATAF(-0.96284979581832886000)},
    {_DATAF(-0.27040681242942810000), _DATAF(-0.96274614334106445000)},
    {_DATAF(-0.27077600359916687000), _DATAF(-0.96264237165451050000)},
    {_DATAF(-0.27114516496658325000), _DATAF(-0.96253848075866699000)},
    {_DATAF(-0.27151426672935486000), _DATAF(-0.96243441104888916000)},
    {_DATAF(-0.27188333868980408000), _DATAF(-0.96233022212982178000)},
    {_DATAF(-0.27225238084793091000), _DATAF(-0.96222585439682007000)},
    {_DATAF(-0.27262136340141296000), _DATAF(-0.96212142705917358000)},
    {_DATAF(-0.27299031615257263000), _DATAF(-0.96201676130294800000)},
    {_DATAF(-0.27335920929908752000), _DATAF(-0.96191203594207764000)},
    {_DATAF(-0.27372807264328003000), _DATAF(-0.96180713176727295000)},
    {_DATAF(-0.27409690618515015000), _DATAF(-0.96170204877853394000)},
    {_DATAF(-0.27446570992469788000), _DATAF(-0.96159690618515015000)},
    {_DATAF(-0.27483445405960083000), _DATAF(-0.96149158477783203000)},
    {_DATAF(-0.27520313858985901000), _DATAF(-0.96138608455657959000)},
    {_DATAF(-0.27557182312011719000), _DATAF(-0.96128046512603760000)},
    {_DATAF(-0.27594044804573059000), _DATAF(-0.96117472648620605000)},
    {_DATAF(-0.27630904316902161000), _DATAF(-0.96106886863708496000)},
    {_DATAF(-0.27667757868766785000), _DATAF(-0.96096283197402954000)},
    {_DATAF(-0.27704608440399170000), _DATAF(-0.96085661649703979000)},
    {_DATAF(-0.27741453051567078000), _DATAF(-0.96075034141540527000)},
    {_DATAF(-0.27778297662734985000), _DATAF(-0.96064388751983643000)},
    {_DATAF(-0.27815136313438416000), _DATAF(-0.96053725481033325000)},
    {_DATAF(-0.27851969003677368000), _DATAF(-0.96043050289154053000)},
    {_DATAF(-0.27888798713684082000), _DATAF(-0.96032363176345825000)},
    {_DATAF(-0.27925625443458557000), _DATAF(-0.96021664142608643000)},
    {_DATAF(-0.27962446212768555000), _DATAF(-0.96010947227478027000)},
    {_DATAF(-0.27999264001846313000), _DATAF(-0.96000212430953979000)},
    {_DATAF(-0.28036078810691833000), _DATAF(-0.95989471673965454000)},
    {_DATAF(-0.28072887659072876000), _DATAF(-0.95978713035583496000)},
    {_DATAF(-0.28109693527221680000), _DATAF(-0.95967936515808105000)},
    {_DATAF(-0.28146493434906006000), _DATAF(-0.95957154035568237000)},
    {_DATAF(-0.28183290362358093000), _DATAF(-0.95946347713470459000)},
    {_DATAF(-0.28220084309577942000), _DATAF(-0.95935535430908203000)},
    {_DATAF(-0.28256872296333313000), _DATAF(-0.95924705266952515000)},
    {_DATAF(-0.28293657302856445000), _DATAF(-0.95913863182067871000)},
    {_DATAF(-0.28330436348915100000), _DATAF(-0.95903003215789795000)},
    {_DATAF(-0.28367212414741516000), _DATAF(-0.95892131328582764000)},
    {_DATAF(-0.28403985500335693000), _DATAF(-0.95881247520446777000)},
    {_DATAF(-0.28440752625465393000), _DATAF(-0.95870345830917358000)},
    {_DATAF(-0.28477516770362854000), _DATAF(-0.95859432220458984000)},
    {_DATAF(-0.28514277935028076000), _DATAF(-0.95848506689071655000)},
    {_DATAF(-0.28551033139228821000), _DATAF(-0.95837563276290894000)},
    {_DATAF(-0.28587782382965088000), _DATAF(-0.95826607942581177000)},
    {_DATAF(-0.28624531626701355000), _DATAF(-0.95815634727478027000)},
    {_DATAF(-0.28661271929740906000), _DATAF(-0.95804649591445923000)},
    {_DATAF(-0.28698012232780457000), _DATAF(-0.95793652534484863000)},
    {_DATAF(-0.28734746575355530000), _DATAF(-0.95782643556594849000)},
    {_DATAF(-0.28771474957466125000), _DATAF(-0.95771616697311401000)},
    {_DATAF(-0.28808203339576721000), _DATAF(-0.95760571956634521000)},
    {_DATAF(-0.28844922780990601000), _DATAF(-0.95749521255493164000)},
    {_DATAF(-0.28881642222404480000), _DATAF(-0.95738452672958374000)},
    {_DATAF(-0.28918352723121643000), _DATAF(-0.95727366209030151000)},
    {_DATAF(-0.28955063223838806000), _DATAF(-0.95716267824172974000)},
    {_DATAF(-0.28991767764091492000), _DATAF(-0.95705157518386841000)},
    {_DATAF(-0.29028466343879700000), _DATAF(-0.95694035291671753000)},
    {_DATAF(-0.29065164923667908000), _DATAF(-0.95682895183563232000)},
    {_DATAF(-0.29101854562759399000), _DATAF(-0.95671743154525757000)},
    {_DATAF(-0.29138544201850891000), _DATAF(-0.95660573244094849000)},
    {_DATAF(-0.29175224900245667000), _DATAF(-0.95649391412734985000)},
    {_DATAF(-0.29211905598640442000), _DATAF(-0.95638197660446167000)},
    {_DATAF(-0.29248580336570740000), _DATAF(-0.95626986026763916000)},
    {_DATAF(-0.29285249114036560000), _DATAF(-0.95615762472152710000)},
    {_DATAF(-0.29321914911270142000), _DATAF(-0.95604526996612549000)},
    {_DATAF(-0.29358577728271484000), _DATAF(-0.95593273639678955000)},
    {_DATAF(-0.29395234584808350000), _DATAF(-0.95582008361816406000)},
    {_DATAF(-0.29431888461112976000), _DATAF(-0.95570725202560425000)},
    {_DATAF(-0.29468536376953125000), _DATAF(-0.95559436082839966000)},
    {_DATAF(-0.29505181312561035000), _DATAF(-0.95548123121261597000)},
    {_DATAF(-0.29541820287704468000), _DATAF(-0.95536804199218750000)},
    {_DATAF(-0.29578456282615662000), _DATAF(-0.95525467395782471000)},
    {_DATAF(-0.29615089297294617000), _DATAF(-0.95514118671417236000)},
    {_DATAF(-0.29651716351509094000), _DATAF(-0.95502752065658569000)},
    {_DATAF(-0.29688337445259094000), _DATAF(-0.95491373538970947000)},
    {_DATAF(-0.29724955558776855000), _DATAF(-0.95479983091354370000)},
    {_DATAF(-0.29761570692062378000), _DATAF(-0.95468574762344360000)},
    {_DATAF(-0.29798179864883423000), _DATAF(-0.95457154512405396000)},
    {_DATAF(-0.29834786057472229000), _DATAF(-0.95445722341537476000)},
    {_DATAF(-0.29871386289596558000), _DATAF(-0.95434272289276123000)},
    {_DATAF(-0.29907983541488647000), _DATAF(-0.95422810316085815000)},
    {_DATAF(-0.29944574832916260000), _DATAF(-0.95411330461502075000)},
    {_DATAF(-0.29981163144111633000), _DATAF(-0.95399844646453857000)},
    {_DATAF(-0.30017745494842529000), _DATAF(-0.95388334989547729000)},
    {_DATAF(-0.30054324865341187000), _DATAF(-0.95376819372177124000)},
    {_DATAF(-0.30090898275375366000), _DATAF(-0.95365285873413086000)},
    {_DATAF(-0.30127468705177307000), _DATAF(-0.95353740453720093000)},
    {_DATAF(-0.30164033174514771000), _DATAF(-0.95342177152633667000)},
    {_DATAF(-0.30200594663619995000), _DATAF(-0.95330601930618286000)},
    {_DATAF(-0.30237150192260742000), _DATAF(-0.95319014787673950000)},
    {_DATAF(-0.30273702740669250000), _DATAF(-0.95307409763336182000)},
    {_DATAF(-0.30310252308845520000), _DATAF(-0.95295792818069458000)},
    {_DATAF(-0.30346795916557312000), _DATAF(-0.95284163951873779000)},
    {_DATAF(-0.30383333563804626000), _DATAF(-0.95272517204284668000)},
    {_DATAF(-0.30419868230819702000), _DATAF(-0.95260858535766602000)},
    {_DATAF(-0.30456396937370300000), _DATAF(-0.95249187946319580000)},
    {_DATAF(-0.30492922663688660000), _DATAF(-0.95237499475479126000)},
    {_DATAF(-0.30529442429542542000), _DATAF(-0.95225799083709717000)},
    {_DATAF(-0.30565959215164185000), _DATAF(-0.95214086771011353000)},
    {_DATAF(-0.30602473020553589000), _DATAF(-0.95202356576919556000)},
    {_DATAF(-0.30638980865478516000), _DATAF(-0.95190614461898804000)},
    {_DATAF(-0.30675482749938965000), _DATAF(-0.95178854465484619000)},
    {_DATAF(-0.30711981654167175000), _DATAF(-0.95167088508605957000)},
    {_DATAF(-0.30748474597930908000), _DATAF(-0.95155298709869385000)},
    {_DATAF(-0.30784964561462402000), _DATAF(-0.95143502950668335000)},
    {_DATAF(-0.30821448564529419000), _DATAF(-0.95131689310073853000)},
    {_DATAF(-0.30857929587364197000), _DATAF(-0.95119863748550415000)},
    {_DATAF(-0.30894404649734497000), _DATAF(-0.95108020305633545000)},
    {_DATAF(-0.30930876731872559000), _DATAF(-0.95096164941787720000)},
    {_DATAF(-0.30967342853546143000), _DATAF(-0.95084297657012939000)},
    {_DATAF(-0.31003805994987488000), _DATAF(-0.95072412490844727000)},
    {_DATAF(-0.31040263175964355000), _DATAF(-0.95060515403747559000)},
    {_DATAF(-0.31076714396476746000), _DATAF(-0.95048606395721436000)},
    {_DATAF(-0.31113162636756897000), _DATAF(-0.95036685466766357000)},
    {_DATAF(-0.31149607896804810000), _DATAF(-0.95024746656417847000)},
    {_DATAF(-0.31186047196388245000), _DATAF(-0.95012789964675903000)},
    {_DATAF(-0.31222480535507202000), _DATAF(-0.95000827312469482000)},
    {_DATAF(-0.31258910894393921000), _DATAF(-0.94988846778869629000)},
    {_DATAF(-0.31295338273048401000), _DATAF(-0.94976848363876343000)},
    {_DATAF(-0.31331756711006165000), _DATAF(-0.94964838027954102000)},
    {_DATAF(-0.31368175148963928000), _DATAF(-0.94952815771102905000)},
    {_DATAF(-0.31404584646224976000), _DATAF(-0.94940781593322754000)},
    {_DATAF(-0.31440994143486023000), _DATAF(-0.94928729534149170000)},
    {_DATAF(-0.31477394700050354000), _DATAF(-0.94916665554046631000)},
    {_DATAF(-0.31513792276382446000), _DATAF(-0.94904589653015137000)},
    {_DATAF(-0.31550186872482300000), _DATAF(-0.94892495870590210000)},
    {_DATAF(-0.31586575508117676000), _DATAF(-0.94880390167236328000)},
    {_DATAF(-0.31622958183288574000), _DATAF(-0.94868266582489014000)},
    {_DATAF(-0.31659337878227234000), _DATAF(-0.94856137037277222000)},
    {_DATAF(-0.31695711612701416000), _DATAF(-0.94843989610671997000)},
    {_DATAF(-0.31732082366943359000), _DATAF(-0.94831824302673340000)},
    {_DATAF(-0.31768447160720825000), _DATAF(-0.94819647073745728000)},
    {_DATAF(-0.31804808974266052000), _DATAF(-0.94807457923889160000)},
    {_DATAF(-0.31841164827346802000), _DATAF(-0.94795256853103638000)},
    {_DATAF(-0.31877514719963074000), _DATAF(-0.94783037900924683000)},
    {_DATAF(-0.31913861632347107000), _DATAF(-0.94770807027816772000)},
    {_DATAF(-0.31950202584266663000), _DATAF(-0.94758558273315430000)},
    {_DATAF(-0.31986540555953979000), _DATAF(-0.94746297597885132000)},
    {_DATAF(-0.32022872567176819000), _DATAF(-0.94734025001525879000)},
    {_DATAF(-0.32059201598167419000), _DATAF(-0.94721740484237671000)},
    {_DATAF(-0.32095524668693542000), _DATAF(-0.94709438085556030000)},
    {_DATAF(-0.32131841778755188000), _DATAF(-0.94697123765945435000)},
    {_DATAF(-0.32168155908584595000), _DATAF(-0.94684791564941406000)},
    {_DATAF(-0.32204464077949524000), _DATAF(-0.94672447443008423000)},
    {_DATAF(-0.32240769267082214000), _DATAF(-0.94660091400146484000)},
    {_DATAF(-0.32277068495750427000), _DATAF(-0.94647717475891113000)},
    {_DATAF(-0.32313361763954163000), _DATAF(-0.94635337591171265000)},
    {_DATAF(-0.32349652051925659000), _DATAF(-0.94622933864593506000)},
    {_DATAF(-0.32385936379432678000), _DATAF(-0.94610524177551270000)},
    {_DATAF(-0.32422217726707458000), _DATAF(-0.94598096609115601000)},
    {_DATAF(-0.32458493113517761000), _DATAF(-0.94585657119750977000)},
    {_DATAF(-0.32494762539863586000), _DATAF(-0.94573199748992920000)},
    {_DATAF(-0.32531028985977173000), _DATAF(-0.94560730457305908000)},
    {_DATAF(-0.32567289471626282000), _DATAF(-0.94548249244689941000)},
    {_DATAF(-0.32603546977043152000), _DATAF(-0.94535756111145020000)},
    {_DATAF(-0.32639798521995544000), _DATAF(-0.94523245096206665000)},
    {_DATAF(-0.32676044106483459000), _DATAF(-0.94510722160339355000)},
    {_DATAF(-0.32712286710739136000), _DATAF(-0.94498181343078613000)},
    {_DATAF(-0.32748523354530334000), _DATAF(-0.94485628604888916000)},
    {_DATAF(-0.32784757018089294000), _DATAF(-0.94473063945770264000)},
    {_DATAF(-0.32820984721183777000), _DATAF(-0.94460481405258179000)},
    {_DATAF(-0.32857206463813782000), _DATAF(-0.94447892904281616000)},
    {_DATAF(-0.32893425226211548000), _DATAF(-0.94435280561447144000)},
    {_DATAF(-0.32929638028144836000), _DATAF(-0.94422662258148193000)},
    {_DATAF(-0.32965844869613647000), _DATAF(-0.94410026073455811000)},
    {_DATAF(-0.33002048730850220000), _DATAF(-0.94397377967834473000)},
    {_DATAF(-0.33038249611854553000), _DATAF(-0.94384711980819702000)},
    {_DATAF(-0.33074441552162170000), _DATAF(-0.94372034072875977000)},
    {_DATAF(-0.33110630512237549000), _DATAF(-0.94359344244003296000)},
    {_DATAF(-0.33146813511848450000), _DATAF(-0.94346642494201660000)},
    {_DATAF(-0.33182993531227112000), _DATAF(-0.94333922863006592000)},
    {_DATAF(-0.33219167590141296000), _DATAF(-0.94321191310882568000)},
    {_DATAF(-0.33255335688591003000), _DATAF(-0.94308441877365112000)},
    {_DATAF(-0.33291500806808472000), _DATAF(-0.94295686483383179000)},
    {_DATAF(-0.33327659964561462000), _DATAF(-0.94282907247543335000)},
    {_DATAF(-0.33363816142082214000), _DATAF(-0.94270122051239014000)},
    {_DATAF(-0.33399966359138489000), _DATAF(-0.94257318973541260000)},
    {_DATAF(-0.33436110615730286000), _DATAF(-0.94244503974914551000)},
    {_DATAF(-0.33472248911857605000), _DATAF(-0.94231677055358887000)},
    {_DATAF(-0.33508384227752686000), _DATAF(-0.94218832254409790000)},
    {_DATAF(-0.33544513583183289000), _DATAF(-0.94205975532531738000)},
    {_DATAF(-0.33580639958381653000), _DATAF(-0.94193100929260254000)},
    {_DATAF(-0.33616760373115540000), _DATAF(-0.94180220365524292000)},
    {_DATAF(-0.33652874827384949000), _DATAF(-0.94167321920394897000)},
    {_DATAF(-0.33688986301422119000), _DATAF(-0.94154405593872070000)},
    {_DATAF(-0.33725091814994812000), _DATAF(-0.94141477346420288000)},
    {_DATAF(-0.33761191368103027000), _DATAF(-0.94128537178039551000)},
    {_DATAF(-0.33797284960746765000), _DATAF(-0.94115585088729858000)},
    {_DATAF(-0.33833375573158264000), _DATAF(-0.94102615118026733000)},
    {_DATAF(-0.33869463205337524000), _DATAF(-0.94089633226394653000)},
    {_DATAF(-0.33905541896820068000), _DATAF(-0.94076639413833618000)},
    {_DATAF(-0.33941617608070374000), _DATAF(-0.94063627719879150000)},
    {_DATAF(-0.33977687358856201000), _DATAF(-0.94050604104995728000)},
    {_DATAF(-0.34013754129409790000), _DATAF(-0.94037568569183350000)},
    {_DATAF(-0.34049814939498901000), _DATAF(-0.94024521112442017000)},
    {_DATAF(-0.34085869789123535000), _DATAF(-0.94011455774307251000)},
    {_DATAF(-0.34121921658515930000), _DATAF(-0.93998372554779053000)},
    {_DATAF(-0.34157964587211609000), _DATAF(-0.93985283374786377000)},
    {_DATAF(-0.34194007515907288000), _DATAF(-0.93972176313400269000)},
    {_DATAF(-0.34230041503906250000), _DATAF(-0.93959057331085205000)},
    {_DATAF(-0.34266072511672974000), _DATAF(-0.93945920467376709000)},
    {_DATAF(-0.34302097558975220000), _DATAF(-0.93932771682739258000)},
    {_DATAF(-0.34338116645812988000), _DATAF(-0.93919610977172852000)},
    {_DATAF(-0.34374132752418518000), _DATAF(-0.93906438350677490000)},
    {_DATAF(-0.34410142898559570000), _DATAF(-0.93893247842788696000)},
    {_DATAF(-0.34446147084236145000), _DATAF(-0.93880045413970947000)},
    {_DATAF(-0.34482148289680481000), _DATAF(-0.93866831064224243000)},
    {_DATAF(-0.34518143534660339000), _DATAF(-0.93853598833084106000)},
    {_DATAF(-0.34554132819175720000), _DATAF(-0.93840354681015015000)},
    {_DATAF(-0.34590116143226624000), _DATAF(-0.93827092647552490000)},
    {_DATAF(-0.34626096487045288000), _DATAF(-0.93813824653625488000)},
    {_DATAF(-0.34662070870399475000), _DATAF(-0.93800538778305054000)},
    {_DATAF(-0.34698042273521423000), _DATAF(-0.93787235021591187000)},
    {_DATAF(-0.34734004735946655000), _DATAF(-0.93773925304412842000)},
    {_DATAF(-0.34769964218139648000), _DATAF(-0.93760597705841064000)},
    {_DATAF(-0.34805917739868164000), _DATAF(-0.93747258186340332000)},
    {_DATAF(-0.34841868281364441000), _DATAF(-0.93733900785446167000)},
    {_DATAF(-0.34877812862396240000), _DATAF(-0.93720531463623047000)},
    {_DATAF(-0.34913751482963562000), _DATAF(-0.93707150220870972000)},
    {_DATAF(-0.34949684143066406000), _DATAF(-0.93693757057189941000)},
    {_DATAF(-0.34985613822937012000), _DATAF(-0.93680346012115479000)},
    {_DATAF(-0.35021537542343140000), _DATAF(-0.93666923046112061000)},
    {_DATAF(-0.35057455301284790000), _DATAF(-0.93653482198715210000)},
    {_DATAF(-0.35093367099761963000), _DATAF(-0.93640029430389404000)},
    {_DATAF(-0.35129275918006897000), _DATAF(-0.93626564741134644000)},
    {_DATAF(-0.35165178775787354000), _DATAF(-0.93613088130950928000)},
    {_DATAF(-0.35201075673103333000), _DATAF(-0.93599593639373779000)},
    {_DATAF(-0.35236969590187073000), _DATAF(-0.93586087226867676000)},
    {_DATAF(-0.35272854566574097000), _DATAF(-0.93572568893432617000)},
    {_DATAF(-0.35308736562728882000), _DATAF(-0.93559032678604126000)},
    {_DATAF(-0.35344615578651428000), _DATAF(-0.93545484542846680000)},
    {_DATAF(-0.35380485653877258000), _DATAF(-0.93531924486160278000)},
    {_DATAF(-0.35416352748870850000), _DATAF(-0.93518352508544922000)},
    {_DATAF(-0.35452213883399963000), _DATAF(-0.93504762649536133000)},
    {_DATAF(-0.35488069057464600000), _DATAF(-0.93491160869598389000)},
    {_DATAF(-0.35523921251296997000), _DATAF(-0.93477541208267212000)},
    {_DATAF(-0.35559767484664917000), _DATAF(-0.93463915586471558000)},
    {_DATAF(-0.35595607757568359000), _DATAF(-0.93450272083282471000)},
    {_DATAF(-0.35631442070007324000), _DATAF(-0.93436610698699951000)},
    {_DATAF(-0.35667270421981812000), _DATAF(-0.93422937393188477000)},
    {_DATAF(-0.35703095793724060000), _DATAF(-0.93409252166748047000)},
    {_DATAF(-0.35738915205001831000), _DATAF(-0.93395555019378662000)},
    {_DATAF(-0.35774728655815125000), _DATAF(-0.93381845951080322000)},
    {_DATAF(-0.35810539126396179000), _DATAF(-0.93368119001388550000)},
    {_DATAF(-0.35846340656280518000), _DATAF(-0.93354380130767822000)},
    {_DATAF(-0.35882139205932617000), _DATAF(-0.93340623378753662000)},
    {_DATAF(-0.35917934775352478000), _DATAF(-0.93326854705810547000)},
    {_DATAF(-0.35953721404075623000), _DATAF(-0.93313074111938477000)},
    {_DATAF(-0.35989505052566528000), _DATAF(-0.93299281597137451000)},
    {_DATAF(-0.36025279760360718000), _DATAF(-0.93285471200942993000)},
    {_DATAF(-0.36061051487922668000), _DATAF(-0.93271648883819580000)},
    {_DATAF(-0.36096820235252380000), _DATAF(-0.93257814645767212000)},
    {_DATAF(-0.36132580041885376000), _DATAF(-0.93243962526321411000)},
    {_DATAF(-0.36168336868286133000), _DATAF(-0.93230098485946655000)},
    {_DATAF(-0.36204087734222412000), _DATAF(-0.93216222524642944000)},
    {_DATAF(-0.36239832639694214000), _DATAF(-0.93202328681945801000)},
    {_DATAF(-0.36275571584701538000), _DATAF(-0.93188428878784180000)},
    {_DATAF(-0.36311307549476624000), _DATAF(-0.93174505233764648000)},
    {_DATAF(-0.36347037553787231000), _DATAF(-0.93160575628280640000)},
    {_DATAF(-0.36382761597633362000), _DATAF(-0.93146628141403198000)},
    {_DATAF(-0.36418479681015015000), _DATAF(-0.93132668733596802000)},
    {_DATAF(-0.36454191803932190000), _DATAF(-0.93118697404861450000)},
    {_DATAF(-0.36489900946617126000), _DATAF(-0.93104708194732666000)},
    {_DATAF(-0.36525601148605347000), _DATAF(-0.93090713024139404000)},
    {_DATAF(-0.36561298370361328000), _DATAF(-0.93076694011688232000)},
    {_DATAF(-0.36596992611885071000), _DATAF(-0.93062669038772583000)},
    {_DATAF(-0.36632677912712097000), _DATAF(-0.93048626184463501000)},
    {_DATAF(-0.36668360233306885000), _DATAF(-0.93034571409225464000)},
    {_DATAF(-0.36704033613204956000), _DATAF(-0.93020504713058472000)},
    {_DATAF(-0.36739704012870789000), _DATAF(-0.93006420135498047000)},
    {_DATAF(-0.36775368452072144000), _DATAF(-0.92992323637008667000)},
    {_DATAF(-0.36811029911041260000), _DATAF(-0.92978215217590332000)},
    {_DATAF(-0.36846682429313660000), _DATAF(-0.92964088916778564000)},
    {_DATAF(-0.36882331967353821000), _DATAF(-0.92949950695037842000)},
    {_DATAF(-0.36917975544929504000), _DATAF(-0.92935800552368164000)},
    {_DATAF(-0.36953613162040710000), _DATAF(-0.92921638488769531000)},
    {_DATAF(-0.36989244818687439000), _DATAF(-0.92907458543777466000)},
    {_DATAF(-0.37024870514869690000), _DATAF(-0.92893266677856445000)},
    {_DATAF(-0.37060493230819702000), _DATAF(-0.92879062891006470000)},
    {_DATAF(-0.37096109986305237000), _DATAF(-0.92864841222763062000)},
    {_DATAF(-0.37131720781326294000), _DATAF(-0.92850607633590698000)},
    {_DATAF(-0.37167325615882874000), _DATAF(-0.92836362123489380000)},
    {_DATAF(-0.37202924489974976000), _DATAF(-0.92822098731994629000)},
    {_DATAF(-0.37238517403602600000), _DATAF(-0.92807829380035400000)},
    {_DATAF(-0.37274107336997986000), _DATAF(-0.92793542146682739000)},
    {_DATAF(-0.37309691309928894000), _DATAF(-0.92779237031936646000)},
    {_DATAF(-0.37345266342163086000), _DATAF(-0.92764925956726074000)},
    {_DATAF(-0.37380838394165039000), _DATAF(-0.92750597000122070000)},
    {_DATAF(-0.37416407465934753000), _DATAF(-0.92736250162124634000)},
    {_DATAF(-0.37451967597007751000), _DATAF(-0.92721897363662720000)},
    {_DATAF(-0.37487521767616272000), _DATAF(-0.92707526683807373000)},
    {_DATAF(-0.37523072957992554000), _DATAF(-0.92693144083023071000)},
    {_DATAF(-0.37558618187904358000), _DATAF(-0.92678749561309814000)},
    {_DATAF(-0.37594157457351685000), _DATAF(-0.92664337158203125000)},
    {_DATAF(-0.37629690766334534000), _DATAF(-0.92649912834167480000)},
    {_DATAF(-0.37665218114852905000), _DATAF(-0.92635476589202881000)},
    {_DATAF(-0.37700742483139038000), _DATAF(-0.92621022462844849000)},
    {_DATAF(-0.37736257910728455000), _DATAF(-0.92606556415557861000)},
    {_DATAF(-0.37771770358085632000), _DATAF(-0.92592078447341919000)},
    {_DATAF(-0.37807273864746094000), _DATAF(-0.92577588558197021000)},
    {_DATAF(-0.37842774391174316000), _DATAF(-0.92563080787658691000)},
    {_DATAF(-0.37878268957138062000), _DATAF(-0.92548561096191406000)},
    {_DATAF(-0.37913760542869568000), _DATAF(-0.92534029483795166000)},
    {_DATAF(-0.37949243187904358000), _DATAF(-0.92519485950469971000)},
    {_DATAF(-0.37984719872474670000), _DATAF(-0.92504924535751343000)},
    {_DATAF(-0.38020193576812744000), _DATAF(-0.92490351200103760000)},
    {_DATAF(-0.38055661320686340000), _DATAF(-0.92475759983062744000)},
    {_DATAF(-0.38091120123863220000), _DATAF(-0.92461162805557251000)},
    {_DATAF(-0.38126575946807861000), _DATAF(-0.92446547746658325000)},
    {_DATAF(-0.38162025809288025000), _DATAF(-0.92431920766830444000)},
    {_DATAF(-0.38197472691535950000), _DATAF(-0.92417275905609131000)},
    {_DATAF(-0.38232910633087158000), _DATAF(-0.92402625083923340000)},
    {_DATAF(-0.38268342614173889000), _DATAF(-0.92387950420379639000)},
    {_DATAF(-0.38303771615028381000), _DATAF(-0.92373269796371460000)},
    {_DATAF(-0.38339191675186157000), _DATAF(-0.92358577251434326000)},
    {_DATAF(-0.38374608755111694000), _DATAF(-0.92343866825103760000)},
    {_DATAF(-0.38410019874572754000), _DATAF(-0.92329144477844238000)},
    {_DATAF(-0.38445425033569336000), _DATAF(-0.92314404249191284000)},
    {_DATAF(-0.38480824232101440000), _DATAF(-0.92299652099609375000)},
    {_DATAF(-0.38516217470169067000), _DATAF(-0.92284888029098511000)},
    {_DATAF(-0.38551604747772217000), _DATAF(-0.92270112037658691000)},
    {_DATAF(-0.38586989045143127000), _DATAF(-0.92255324125289917000)},
    {_DATAF(-0.38622364401817322000), _DATAF(-0.92240518331527710000)},
    {_DATAF(-0.38657733798027039000), _DATAF(-0.92225700616836548000)},
    {_DATAF(-0.38693100214004517000), _DATAF(-0.92210865020751953000)},
    {_DATAF(-0.38728460669517517000), _DATAF(-0.92196023464202881000)},
    {_DATAF(-0.38763815164566040000), _DATAF(-0.92181164026260376000)},
    {_DATAF(-0.38799160718917847000), _DATAF(-0.92166292667388916000)},
    {_DATAF(-0.38834503293037415000), _DATAF(-0.92151403427124023000)},
    {_DATAF(-0.38869842886924744000), _DATAF(-0.92136502265930176000)},
    {_DATAF(-0.38905173540115356000), _DATAF(-0.92121589183807373000)},
    {_DATAF(-0.38940498232841492000), _DATAF(-0.92106664180755615000)},
    {_DATAF(-0.38975816965103149000), _DATAF(-0.92091721296310425000)},
    {_DATAF(-0.39011132717132568000), _DATAF(-0.92076772451400757000)},
    {_DATAF(-0.39046439528465271000), _DATAF(-0.92061805725097656000)},
    {_DATAF(-0.39081740379333496000), _DATAF(-0.92046821117401123000)},
    {_DATAF(-0.39117038249969482000), _DATAF(-0.92031830549240112000)},
    {_DATAF(-0.39152330160140991000), _DATAF(-0.92016822099685669000)},
    {_DATAF(-0.39187613129615784000), _DATAF(-0.92001795768737793000)},
    {_DATAF(-0.39222893118858337000), _DATAF(-0.91986763477325439000)},
    {_DATAF(-0.39258167147636414000), _DATAF(-0.91971713304519653000)},
    {_DATAF(-0.39293435215950012000), _DATAF(-0.91956651210784912000)},
    {_DATAF(-0.39328697323799133000), _DATAF(-0.91941577196121216000)},
    {_DATAF(-0.39363953471183777000), _DATAF(-0.91926485300064087000)},
    {_DATAF(-0.39399203658103943000), _DATAF(-0.91911387443542480000)},
    {_DATAF(-0.39434447884559631000), _DATAF(-0.91896271705627441000)},
    {_DATAF(-0.39469686150550842000), _DATAF(-0.91881138086318970000)},
    {_DATAF(-0.39504921436309814000), _DATAF(-0.91865998506546021000)},
    {_DATAF(-0.39540147781372070000), _DATAF(-0.91850841045379639000)},
    {_DATAF(-0.39575368165969849000), _DATAF(-0.91835671663284302000)},
    {_DATAF(-0.39610585570335388000), _DATAF(-0.91820484399795532000)},
    {_DATAF(-0.39645794034004211000), _DATAF(-0.91805291175842285000)},
    {_DATAF(-0.39680999517440796000), _DATAF(-0.91790080070495605000)},
    {_DATAF(-0.39716196060180664000), _DATAF(-0.91774851083755493000)},
    {_DATAF(-0.39751389622688293000), _DATAF(-0.91759616136550903000)},
    {_DATAF(-0.39786574244499207000), _DATAF(-0.91744363307952881000)},
    {_DATAF(-0.39821755886077881000), _DATAF(-0.91729098558425903000)},
    {_DATAF(-0.39856931567192078000), _DATAF(-0.91713821887969971000)},
    {_DATAF(-0.39892101287841797000), _DATAF(-0.91698527336120605000)},
    {_DATAF(-0.39927262067794800000), _DATAF(-0.91683226823806763000)},
    {_DATAF(-0.39962419867515564000), _DATAF(-0.91667908430099487000)},
    {_DATAF(-0.39997571706771851000), _DATAF(-0.91652572154998779000)},
    {_DATAF(-0.40032717585563660000), _DATAF(-0.91637229919433594000)},
    {_DATAF(-0.40067857503890991000), _DATAF(-0.91621869802474976000)},
    {_DATAF(-0.40102988481521606000), _DATAF(-0.91606497764587402000)},
    {_DATAF(-0.40138116478919983000), _DATAF(-0.91591107845306396000)},
    {_DATAF(-0.40173238515853882000), _DATAF(-0.91575711965560913000)},
    {_DATAF(-0.40208354592323303000), _DATAF(-0.91560298204421997000)},
    {_DATAF(-0.40243464708328247000), _DATAF(-0.91544872522354126000)},
    {_DATAF(-0.40278568863868713000), _DATAF(-0.91529428958892822000)},
    {_DATAF(-0.40313667058944702000), _DATAF(-0.91513979434967041000)},
    {_DATAF(-0.40348759293556213000), _DATAF(-0.91498512029647827000)},
    {_DATAF(-0.40383845567703247000), _DATAF(-0.91483032703399658000)},
    {_DATAF(-0.40418925881385803000), _DATAF(-0.91467535495758057000)},
    {_DATAF(-0.40454000234603882000), _DATAF(-0.91452032327651978000)},
    {_DATAF(-0.40489068627357483000), _DATAF(-0.91436511278152466000)},
    {_DATAF(-0.40524131059646606000), _DATAF(-0.91420978307723999000)},
    {_DATAF(-0.40559187531471252000), _DATAF(-0.91405427455902100000)},
    {_DATAF(-0.40594238042831421000), _DATAF(-0.91389864683151245000)},
    {_DATAF(-0.40629282593727112000), _DATAF(-0.91374289989471436000)},
    {_DATAF(-0.40664321184158325000), _DATAF(-0.91358703374862671000)},
    {_DATAF(-0.40699353814125061000), _DATAF(-0.91343104839324951000)},
    {_DATAF(-0.40734380483627319000), _DATAF(-0.91327488422393799000)},
    {_DATAF(-0.40769401192665100000), _DATAF(-0.91311860084533691000)},
    {_DATAF(-0.40804415941238403000), _DATAF(-0.91296219825744629000)},
    {_DATAF(-0.40839424729347229000), _DATAF(-0.91280561685562134000)},
    {_DATAF(-0.40874427556991577000), _DATAF(-0.91264897584915161000)},
    {_DATAF(-0.40909424424171448000), _DATAF(-0.91249215602874756000)},
    {_DATAF(-0.40944415330886841000), _DATAF(-0.91233515739440918000)},
    {_DATAF(-0.40979400277137756000), _DATAF(-0.91217809915542603000)},
    {_DATAF(-0.41014379262924194000), _DATAF(-0.91202086210250854000)},
    {_DATAF(-0.41049349308013916000), _DATAF(-0.91186350584030151000)},
    {_DATAF(-0.41084316372871399000), _DATAF(-0.91170603036880493000)},
    {_DATAF(-0.41119277477264404000), _DATAF(-0.91154843568801880000)},
    {_DATAF(-0.41154232621192932000), _DATAF(-0.91139066219329834000)},
    {_DATAF(-0.41189181804656982000), _DATAF(-0.91123276948928833000)},
    {_DATAF(-0.41224122047424316000), _DATAF(-0.91107475757598877000)},
    {_DATAF(-0.41259059309959412000), _DATAF(-0.91091656684875488000)},
    {_DATAF(-0.41293987631797791000), _DATAF(-0.91075825691223145000)},
    {_DATAF(-0.41328912973403931000), _DATAF(-0.91059982776641846000)},
    {_DATAF(-0.41363832354545593000), _DATAF(-0.91044127941131592000)},
    {_DATAF(-0.41398742794990540000), _DATAF(-0.91028261184692383000)},
    {_DATAF(-0.41433650255203247000), _DATAF(-0.91012376546859741000)},
    {_DATAF(-0.41468548774719238000), _DATAF(-0.90996479988098145000)},
    {_DATAF(-0.41503441333770752000), _DATAF(-0.90980571508407593000)},
    {_DATAF(-0.41538330912590027000), _DATAF(-0.90964645147323608000)},
    {_DATAF(-0.41573211550712585000), _DATAF(-0.90948712825775146000)},
    {_DATAF(-0.41608086228370667000), _DATAF(-0.90932762622833252000)},
    {_DATAF(-0.41642954945564270000), _DATAF(-0.90916800498962402000)},
    {_DATAF(-0.41677817702293396000), _DATAF(-0.90900820493698120000)},
    {_DATAF(-0.41712677478790283000), _DATAF(-0.90884834527969360000)},
    {_DATAF(-0.41747528314590454000), _DATAF(-0.90868830680847168000)},
    {_DATAF(-0.41782370209693909000), _DATAF(-0.90852808952331543000)},
    {_DATAF(-0.41817209124565125000), _DATAF(-0.90836781263351440000)},
    {_DATAF(-0.41852042078971863000), _DATAF(-0.90820735692977905000)},
    {_DATAF(-0.41886869072914124000), _DATAF(-0.90804684162139893000)},
    {_DATAF(-0.41921690106391907000), _DATAF(-0.90788608789443970000)},
    {_DATAF(-0.41956502199172974000), _DATAF(-0.90772527456283569000)},
    {_DATAF(-0.41991311311721802000), _DATAF(-0.90756434202194214000)},
    {_DATAF(-0.42026111483573914000), _DATAF(-0.90740323066711426000)},
    {_DATAF(-0.42060908675193787000), _DATAF(-0.90724200010299683000)},
    {_DATAF(-0.42095696926116943000), _DATAF(-0.90708059072494507000)},
    {_DATAF(-0.42130479216575623000), _DATAF(-0.90691912174224854000)},
    {_DATAF(-0.42165255546569824000), _DATAF(-0.90675747394561768000)},
    {_DATAF(-0.42200025916099548000), _DATAF(-0.90659570693969727000)},
    {_DATAF(-0.42234790325164795000), _DATAF(-0.90643382072448730000)},
    {_DATAF(-0.42269548773765564000), _DATAF(-0.90627175569534302000)},
    {_DATAF(-0.42304301261901855000), _DATAF(-0.90610957145690918000)},
    {_DATAF(-0.42339047789573669000), _DATAF(-0.90594726800918579000)},
    {_DATAF(-0.42373788356781006000), _DATAF(-0.90578484535217285000)},
    {_DATAF(-0.42408519983291626000), _DATAF(-0.90562230348587036000)},
    {_DATAF(-0.42443248629570007000), _DATAF(-0.90545958280563354000)},
    {_DATAF(-0.42477968335151672000), _DATAF(-0.90529674291610718000)},
    {_DATAF(-0.42512682080268860000), _DATAF(-0.90513378381729126000)},
    {_DATAF(-0.42547389864921570000), _DATAF(-0.90497070550918579000)},
    {_DATAF(-0.42582091689109802000), _DATAF(-0.90480744838714600000)},
    {_DATAF(-0.42616787552833557000), _DATAF(-0.90464407205581665000)},
    {_DATAF(-0.42651477456092834000), _DATAF(-0.90448057651519775000)},
    {_DATAF(-0.42686161398887634000), _DATAF(-0.90431696176528931000)},
    {_DATAF(-0.42720839381217957000), _DATAF(-0.90415316820144653000)},
    {_DATAF(-0.42755508422851563000), _DATAF(-0.90398931503295898000)},
    {_DATAF(-0.42790174484252930000), _DATAF(-0.90382528305053711000)},
    {_DATAF(-0.42824831604957581000), _DATAF(-0.90366107225418091000)},
    {_DATAF(-0.42859482765197754000), _DATAF(-0.90349680185317993000)},
    {_DATAF(-0.42894127964973450000), _DATAF(-0.90333235263824463000)},
    {_DATAF(-0.42928767204284668000), _DATAF(-0.90316778421401978000)},
    {_DATAF(-0.42963400483131409000), _DATAF(-0.90300309658050537000)},
    {_DATAF(-0.42998027801513672000), _DATAF(-0.90283828973770142000)},
    {_DATAF(-0.43032649159431458000), _DATAF(-0.90267330408096313000)},
    {_DATAF(-0.43067261576652527000), _DATAF(-0.90250819921493530000)},
    {_DATAF(-0.43101871013641357000), _DATAF(-0.90234297513961792000)},
    {_DATAF(-0.43136471509933472000), _DATAF(-0.90217763185501099000)},
    {_DATAF(-0.43171066045761108000), _DATAF(-0.90201216936111450000)},
    {_DATAF(-0.43205654621124268000), _DATAF(-0.90184652805328369000)},
    {_DATAF(-0.43240237236022949000), _DATAF(-0.90168076753616333000)},
    {_DATAF(-0.43274813890457153000), _DATAF(-0.90151488780975342000)},
    {_DATAF(-0.43309381604194641000), _DATAF(-0.90134882926940918000)},
    {_DATAF(-0.43343946337699890000), _DATAF(-0.90118271112442017000)},
    {_DATAF(-0.43378502130508423000), _DATAF(-0.90101641416549683000)},
    {_DATAF(-0.43413051962852478000), _DATAF(-0.90084999799728394000)},
    {_DATAF(-0.43447595834732056000), _DATAF(-0.90068340301513672000)},
    {_DATAF(-0.43482133746147156000), _DATAF(-0.90051674842834473000)},
    {_DATAF(-0.43516665697097778000), _DATAF(-0.90034991502761841000)},
    {_DATAF(-0.43551188707351685000), _DATAF(-0.90018296241760254000)},
    {_DATAF(-0.43585708737373352000), _DATAF(-0.90001589059829712000)},
    {_DATAF(-0.43620219826698303000), _DATAF(-0.89984869956970215000)},
    {_DATAF(-0.43654724955558777000), _DATAF(-0.89968132972717285000)},
    {_DATAF(-0.43689224123954773000), _DATAF(-0.89951384067535400000)},
    {_DATAF(-0.43723717331886292000), _DATAF(-0.89934623241424561000)},
    {_DATAF(-0.43758204579353333000), _DATAF(-0.89917850494384766000)},
    {_DATAF(-0.43792682886123657000), _DATAF(-0.89901059865951538000)},
    {_DATAF(-0.43827158212661743000), _DATAF(-0.89884263277053833000)},
    {_DATAF(-0.43861624598503113000), _DATAF(-0.89867448806762695000)},
    {_DATAF(-0.43896085023880005000), _DATAF(-0.89850616455078125000)},
    {_DATAF(-0.43930539488792419000), _DATAF(-0.89833778142929077000)},
    {_DATAF(-0.43964985013008118000), _DATAF(-0.89816927909851074000)},
    {_DATAF(-0.43999427556991577000), _DATAF(-0.89800059795379639000)},
    {_DATAF(-0.44033861160278320000), _DATAF(-0.89783179759979248000)},
    {_DATAF(-0.44068288803100586000), _DATAF(-0.89766281843185425000)},
    {_DATAF(-0.44102710485458374000), _DATAF(-0.89749377965927124000)},
    {_DATAF(-0.44137126207351685000), _DATAF(-0.89732456207275391000)},
    {_DATAF(-0.44171535968780518000), _DATAF(-0.89715522527694702000)},
    {_DATAF(-0.44205936789512634000), _DATAF(-0.89698576927185059000)},
    {_DATAF(-0.44240334630012512000), _DATAF(-0.89681619405746460000)},
    {_DATAF(-0.44274723529815674000), _DATAF(-0.89664649963378906000)},
    {_DATAF(-0.44309106469154358000), _DATAF(-0.89647662639617920000)},
    {_DATAF(-0.44343480467796326000), _DATAF(-0.89630663394927979000)},
    {_DATAF(-0.44377851486206055000), _DATAF(-0.89613652229309082000)},
    {_DATAF(-0.44412213563919067000), _DATAF(-0.89596623182296753000)},
    {_DATAF(-0.44446569681167603000), _DATAF(-0.89579588174819946000)},
    {_DATAF(-0.44480919837951660000), _DATAF(-0.89562535285949707000)},
    {_DATAF(-0.44515264034271240000), _DATAF(-0.89545470476150513000)},
    {_DATAF(-0.44549602270126343000), _DATAF(-0.89528393745422363000)},
    {_DATAF(-0.44583931565284729000), _DATAF(-0.89511299133300781000)},
    {_DATAF(-0.44618254899978638000), _DATAF(-0.89494198560714722000)},
    {_DATAF(-0.44652572274208069000), _DATAF(-0.89477080106735229000)},
    {_DATAF(-0.44686883687973022000), _DATAF(-0.89459949731826782000)},
    {_DATAF(-0.44721189141273499000), _DATAF(-0.89442807435989380000)},
    {_DATAF(-0.44755485653877258000), _DATAF(-0.89425647258758545000)},
    {_DATAF(-0.44789776206016541000), _DATAF(-0.89408475160598755000)},
    {_DATAF(-0.44824060797691345000), _DATAF(-0.89391297101974487000)},
    {_DATAF(-0.44858339428901672000), _DATAF(-0.89374095201492310000)},
    {_DATAF(-0.44892609119415283000), _DATAF(-0.89356887340545654000)},
    {_DATAF(-0.44926875829696655000), _DATAF(-0.89339667558670044000)},
    {_DATAF(-0.44961133599281311000), _DATAF(-0.89322429895401001000)},
    {_DATAF(-0.44995385408401489000), _DATAF(-0.89305180311203003000)},
    {_DATAF(-0.45029628276824951000), _DATAF(-0.89287918806076050000)},
    {_DATAF(-0.45063868165016174000), _DATAF(-0.89270645380020142000)},
    {_DATAF(-0.45098099112510681000), _DATAF(-0.89253354072570801000)},
    {_DATAF(-0.45132324099540710000), _DATAF(-0.89236056804656982000)},
    {_DATAF(-0.45166543126106262000), _DATAF(-0.89218741655349731000)},
    {_DATAF(-0.45200753211975098000), _DATAF(-0.89201414585113525000)},
    {_DATAF(-0.45234957337379456000), _DATAF(-0.89184069633483887000)},
    {_DATAF(-0.45269158482551575000), _DATAF(-0.89166718721389771000)},
    {_DATAF(-0.45303347706794739000), _DATAF(-0.89149349927902222000)},
    {_DATAF(-0.45337533950805664000), _DATAF(-0.89131969213485718000)},
    {_DATAF(-0.45371711254119873000), _DATAF(-0.89114576578140259000)},
    {_DATAF(-0.45405882596969604000), _DATAF(-0.89097172021865845000)},
    {_DATAF(-0.45440047979354858000), _DATAF(-0.89079749584197998000)},
    {_DATAF(-0.45474207401275635000), _DATAF(-0.89062315225601196000)},
    {_DATAF(-0.45508357882499695000), _DATAF(-0.89044874906539917000)},
    {_DATAF(-0.45542502403259277000), _DATAF(-0.89027410745620728000)},
    {_DATAF(-0.45576640963554382000), _DATAF(-0.89009940624237061000)},
    {_DATAF(-0.45610773563385010000), _DATAF(-0.88992458581924438000)},
    {_DATAF(-0.45644897222518921000), _DATAF(-0.88974958658218384000)},
    {_DATAF(-0.45679014921188354000), _DATAF(-0.88957446813583374000)},
    {_DATAF(-0.45713126659393311000), _DATAF(-0.88939923048019409000)},
    {_DATAF(-0.45747232437133789000), _DATAF(-0.88922387361526489000)},
    {_DATAF(-0.45781329274177551000), _DATAF(-0.88904833793640137000)},
    {_DATAF(-0.45815420150756836000), _DATAF(-0.88887274265289307000)},
    {_DATAF(-0.45849505066871643000), _DATAF(-0.88869696855545044000)},
    {_DATAF(-0.45883584022521973000), _DATAF(-0.88852107524871826000)},
    {_DATAF(-0.45917654037475586000), _DATAF(-0.88834506273269653000)},
    {_DATAF(-0.45951718091964722000), _DATAF(-0.88816887140274048000)},
    {_DATAF(-0.45985776185989380000), _DATAF(-0.88799256086349487000)},
    {_DATAF(-0.46019828319549561000), _DATAF(-0.88781619071960449000)},
    {_DATAF(-0.46053871512413025000), _DATAF(-0.88763964176177979000)},
    {_DATAF(-0.46087908744812012000), _DATAF(-0.88746291399002075000)},
    {_DATAF(-0.46121940016746521000), _DATAF(-0.88728612661361694000)},
    {_DATAF(-0.46155962347984314000), _DATAF(-0.88710916042327881000)},
    {_DATAF(-0.46189978718757629000), _DATAF(-0.88693213462829590000)},
    {_DATAF(-0.46223989129066467000), _DATAF(-0.88675493001937866000)},
    {_DATAF(-0.46257993578910828000), _DATAF(-0.88657760620117188000)},
    {_DATAF(-0.46291989088058472000), _DATAF(-0.88640010356903076000)},
    {_DATAF(-0.46325978636741638000), _DATAF(-0.88622254133224487000)},
    {_DATAF(-0.46359962224960327000), _DATAF(-0.88604480028152466000)},
    {_DATAF(-0.46393936872482300000), _DATAF(-0.88586694002151489000)},
    {_DATAF(-0.46427905559539795000), _DATAF(-0.88568896055221558000)},
    {_DATAF(-0.46461868286132813000), _DATAF(-0.88551086187362671000)},
    {_DATAF(-0.46495825052261353000), _DATAF(-0.88533258438110352000)},
    {_DATAF(-0.46529772877693176000), _DATAF(-0.88515424728393555000)},
    {_DATAF(-0.46563714742660522000), _DATAF(-0.88497573137283325000)},
    {_DATAF(-0.46597650647163391000), _DATAF(-0.88479709625244141000)},
    {_DATAF(-0.46631577610969543000), _DATAF(-0.88461834192276001000)},
    {_DATAF(-0.46665498614311218000), _DATAF(-0.88443946838378906000)},
    {_DATAF(-0.46699413657188416000), _DATAF(-0.88426041603088379000)},
    {_DATAF(-0.46733319759368896000), _DATAF(-0.88408124446868896000)},
    {_DATAF(-0.46767222881317139000), _DATAF(-0.88390195369720459000)},
    {_DATAF(-0.46801114082336426000), _DATAF(-0.88372254371643066000)},
    {_DATAF(-0.46835002303123474000), _DATAF(-0.88354301452636719000)},
    {_DATAF(-0.46868881583213806000), _DATAF(-0.88336336612701416000)},
    {_DATAF(-0.46902754902839661000), _DATAF(-0.88318353891372681000)},
    {_DATAF(-0.46936622262001038000), _DATAF(-0.88300359249114990000)},
    {_DATAF(-0.46970480680465698000), _DATAF(-0.88282352685928345000)},
    {_DATAF(-0.47004333138465881000), _DATAF(-0.88264334201812744000)},
    {_DATAF(-0.47038179636001587000), _DATAF(-0.88246303796768188000)},
    {_DATAF(-0.47072017192840576000), _DATAF(-0.88228255510330200000)},
    {_DATAF(-0.47105848789215088000), _DATAF(-0.88210195302963257000)},
    {_DATAF(-0.47139674425125122000), _DATAF(-0.88192129135131836000)},
    {_DATAF(-0.47173491120338440000), _DATAF(-0.88174045085906982000)},
    {_DATAF(-0.47207301855087280000), _DATAF(-0.88155943155288696000)},
    {_DATAF(-0.47241106629371643000), _DATAF(-0.88137835264205933000)},
    {_DATAF(-0.47274902462959290000), _DATAF(-0.88119709491729736000)},
    {_DATAF(-0.47308692336082458000), _DATAF(-0.88101577758789063000)},
    {_DATAF(-0.47342476248741150000), _DATAF(-0.88083428144454956000)},
    {_DATAF(-0.47376251220703125000), _DATAF(-0.88065266609191895000)},
    {_DATAF(-0.47410020232200623000), _DATAF(-0.88047087192535400000)},
    {_DATAF(-0.47443783283233643000), _DATAF(-0.88028901815414429000)},
    {_DATAF(-0.47477537393569946000), _DATAF(-0.88010698556900024000)},
    {_DATAF(-0.47511285543441772000), _DATAF(-0.87992483377456665000)},
    {_DATAF(-0.47545027732849121000), _DATAF(-0.87974262237548828000)},
    {_DATAF(-0.47578760981559753000), _DATAF(-0.87956017255783081000)},
    {_DATAF(-0.47612488269805908000), _DATAF(-0.87937766313552856000)},
    {_DATAF(-0.47646209597587585000), _DATAF(-0.87919503450393677000)},
    {_DATAF(-0.47679921984672546000), _DATAF(-0.87901222705841064000)},
    {_DATAF(-0.47713628411293030000), _DATAF(-0.87882930040359497000)},
    {_DATAF(-0.47747328877449036000), _DATAF(-0.87864625453948975000)},
    {_DATAF(-0.47781020402908325000), _DATAF(-0.87846308946609497000)},
    {_DATAF(-0.47814705967903137000), _DATAF(-0.87827980518341064000)},
    {_DATAF(-0.47848382592201233000), _DATAF(-0.87809634208679199000)},
    {_DATAF(-0.47882056236267090000), _DATAF(-0.87791281938552856000)},
    {_DATAF(-0.47915717959403992000), _DATAF(-0.87772911787033081000)},
    {_DATAF(-0.47949376702308655000), _DATAF(-0.87754529714584351000)},
    {_DATAF(-0.47983026504516602000), _DATAF(-0.87736135721206665000)},
    {_DATAF(-0.48016667366027832000), _DATAF(-0.87717723846435547000)},
    {_DATAF(-0.48050305247306824000), _DATAF(-0.87699306011199951000)},
    {_DATAF(-0.48083934187889099000), _DATAF(-0.87680870294570923000)},
    {_DATAF(-0.48117554187774658000), _DATAF(-0.87662428617477417000)},
    {_DATAF(-0.48151168227195740000), _DATAF(-0.87643969058990479000)},
    {_DATAF(-0.48184776306152344000), _DATAF(-0.87625491619110107000)},
    {_DATAF(-0.48218378424644470000), _DATAF(-0.87607008218765259000)},
    {_DATAF(-0.48251971602439880000), _DATAF(-0.87588512897491455000)},
    {_DATAF(-0.48285555839538574000), _DATAF(-0.87569999694824219000)},
    {_DATAF(-0.48319137096405029000), _DATAF(-0.87551474571228027000)},
    {_DATAF(-0.48352706432342529000), _DATAF(-0.87532937526702881000)},
    {_DATAF(-0.48386272788047791000), _DATAF(-0.87514388561248779000)},
    {_DATAF(-0.48419830203056335000), _DATAF(-0.87495827674865723000)},
    {_DATAF(-0.48453381657600403000), _DATAF(-0.87477254867553711000)},
    {_DATAF(-0.48486924171447754000), _DATAF(-0.87458664178848267000)},
    {_DATAF(-0.48520460724830627000), _DATAF(-0.87440061569213867000)},
    {_DATAF(-0.48553991317749023000), _DATAF(-0.87421452999114990000)},
    {_DATAF(-0.48587512969970703000), _DATAF(-0.87402826547622681000)},
    {_DATAF(-0.48621028661727905000), _DATAF(-0.87384182214736938000)},
    {_DATAF(-0.48654535412788391000), _DATAF(-0.87365531921386719000)},
    {_DATAF(-0.48688036203384399000), _DATAF(-0.87346869707107544000)},
    {_DATAF(-0.48721531033515930000), _DATAF(-0.87328189611434937000)},
    {_DATAF(-0.48755016922950745000), _DATAF(-0.87309497594833374000)},
    {_DATAF(-0.48788493871688843000), _DATAF(-0.87290793657302856000)},
    {_DATAF(-0.48821967840194702000), _DATAF(-0.87272077798843384000)},
    {_DATAF(-0.48855432868003845000), _DATAF(-0.87253350019454956000)},
    {_DATAF(-0.48888888955116272000), _DATAF(-0.87234604358673096000)},
    {_DATAF(-0.48922339081764221000), _DATAF(-0.87215852737426758000)},
    {_DATAF(-0.48955783247947693000), _DATAF(-0.87197083234786987000)},
    {_DATAF(-0.48989218473434448000), _DATAF(-0.87178301811218262000)},
    {_DATAF(-0.49022647738456726000), _DATAF(-0.87159508466720581000)},
    {_DATAF(-0.49056071043014526000), _DATAF(-0.87140703201293945000)},
    {_DATAF(-0.49089485406875610000), _DATAF(-0.87121886014938354000)},
    {_DATAF(-0.49122890830039978000), _DATAF(-0.87103050947189331000)},
    {_DATAF(-0.49156290292739868000), _DATAF(-0.87084203958511353000)},
    {_DATAF(-0.49189683794975281000), _DATAF(-0.87065351009368896000)},
    {_DATAF(-0.49223071336746216000), _DATAF(-0.87046480178833008000)},
    {_DATAF(-0.49256446957588196000), _DATAF(-0.87027597427368164000)},
    {_DATAF(-0.49289819598197937000), _DATAF(-0.87008696794509888000)},
    {_DATAF(-0.49323183298110962000), _DATAF(-0.86989790201187134000)},
    {_DATAF(-0.49356541037559509000), _DATAF(-0.86970865726470947000)},
    {_DATAF(-0.49389889836311340000), _DATAF(-0.86951935291290283000)},
    {_DATAF(-0.49423229694366455000), _DATAF(-0.86932986974716187000)},
    {_DATAF(-0.49456566572189331000), _DATAF(-0.86914026737213135000)},
    {_DATAF(-0.49489894509315491000), _DATAF(-0.86895054578781128000)},
    {_DATAF(-0.49523213505744934000), _DATAF(-0.86876070499420166000)},
    {_DATAF(-0.49556526541709900000), _DATAF(-0.86857068538665771000)},
    {_DATAF(-0.49589830636978149000), _DATAF(-0.86838060617446899000)},
    {_DATAF(-0.49623128771781921000), _DATAF(-0.86819034814834595000)},
    {_DATAF(-0.49656420946121216000), _DATAF(-0.86799997091293335000)},
    {_DATAF(-0.49689704179763794000), _DATAF(-0.86780947446823120000)},
    {_DATAF(-0.49722981452941895000), _DATAF(-0.86761885881423950000)},
    {_DATAF(-0.49756249785423279000), _DATAF(-0.86742812395095825000)},
    {_DATAF(-0.49789512157440186000), _DATAF(-0.86723726987838745000)},
    {_DATAF(-0.49822765588760376000), _DATAF(-0.86704623699188232000)},
    {_DATAF(-0.49856013059616089000), _DATAF(-0.86685508489608765000)},
    {_DATAF(-0.49889254570007324000), _DATAF(-0.86666387319564819000)},
    {_DATAF(-0.49922487139701843000), _DATAF(-0.86647248268127441000)},
    {_DATAF(-0.49955710768699646000), _DATAF(-0.86628097295761108000)},
    {_DATAF(-0.49988928437232971000), _DATAF(-0.86608928442001343000)},
    {_DATAF(-0.50022137165069580000), _DATAF(-0.86589753627777100000)},
    {_DATAF(-0.50055342912673950000), _DATAF(-0.86570566892623901000)},
    {_DATAF(-0.50088536739349365000), _DATAF(-0.86551362276077271000)},
    {_DATAF(-0.50121724605560303000), _DATAF(-0.86532145738601685000)},
    {_DATAF(-0.50154906511306763000), _DATAF(-0.86512917280197144000)},
    {_DATAF(-0.50188082456588745000), _DATAF(-0.86493676900863647000)},
    {_DATAF(-0.50221246480941772000), _DATAF(-0.86474424600601196000)},
    {_DATAF(-0.50254404544830322000), _DATAF(-0.86455160379409790000)},
    {_DATAF(-0.50287556648254395000), _DATAF(-0.86435878276824951000)},
    {_DATAF(-0.50320702791213989000), _DATAF(-0.86416590213775635000)},
    {_DATAF(-0.50353837013244629000), _DATAF(-0.86397284269332886000)},
    {_DATAF(-0.50386965274810791000), _DATAF(-0.86377966403961182000)},
    {_DATAF(-0.50420087575912476000), _DATAF(-0.86358636617660522000)},
    {_DATAF(-0.50453203916549683000), _DATAF(-0.86339294910430908000)},
    {_DATAF(-0.50486308336257935000), _DATAF(-0.86319941282272339000)},
    {_DATAF(-0.50519412755966187000), _DATAF(-0.86300575733184814000)},
    {_DATAF(-0.50552505254745483000), _DATAF(-0.86281192302703857000)},
    {_DATAF(-0.50585585832595825000), _DATAF(-0.86261802911758423000)},
    {_DATAF(-0.50618666410446167000), _DATAF(-0.86242395639419556000)},
    {_DATAF(-0.50651735067367554000), _DATAF(-0.86222976446151733000)},
    {_DATAF(-0.50684797763824463000), _DATAF(-0.86203545331954956000)},
    {_DATAF(-0.50717854499816895000), _DATAF(-0.86184102296829224000)},
    {_DATAF(-0.50750899314880371000), _DATAF(-0.86164647340774536000)},
    {_DATAF(-0.50783938169479370000), _DATAF(-0.86145174503326416000)},
    {_DATAF(-0.50816971063613892000), _DATAF(-0.86125695705413818000)},
    {_DATAF(-0.50849997997283936000), _DATAF(-0.86106199026107788000)},
    {_DATAF(-0.50883013010025024000), _DATAF(-0.86086696386337280000)},
    {_DATAF(-0.50916022062301636000), _DATAF(-0.86067175865173340000)},
    {_DATAF(-0.50949025154113770000), _DATAF(-0.86047643423080444000)},
    {_DATAF(-0.50982022285461426000), _DATAF(-0.86028099060058594000)},
    {_DATAF(-0.51015007495880127000), _DATAF(-0.86008536815643311000)},
    {_DATAF(-0.51047992706298828000), _DATAF(-0.85988968610763550000)},
    {_DATAF(-0.51080960035324097000), _DATAF(-0.85969388484954834000)},
    {_DATAF(-0.51113927364349365000), _DATAF(-0.85949790477752686000)},
    {_DATAF(-0.51146882772445679000), _DATAF(-0.85930180549621582000)},
    {_DATAF(-0.51179832220077515000), _DATAF(-0.85910558700561523000)},
    {_DATAF(-0.51212775707244873000), _DATAF(-0.85890924930572510000)},
    {_DATAF(-0.51245713233947754000), _DATAF(-0.85871279239654541000)},
    {_DATAF(-0.51278638839721680000), _DATAF(-0.85851621627807617000)},
    {_DATAF(-0.51311558485031128000), _DATAF(-0.85831952095031738000)},
    {_DATAF(-0.51344472169876099000), _DATAF(-0.85812264680862427000)},
    {_DATAF(-0.51377379894256592000), _DATAF(-0.85792571306228638000)},
    {_DATAF(-0.51410275697708130000), _DATAF(-0.85772860050201416000)},
    {_DATAF(-0.51443165540695190000), _DATAF(-0.85753136873245239000)},
    {_DATAF(-0.51476043462753296000), _DATAF(-0.85733401775360107000)},
    {_DATAF(-0.51508921384811401000), _DATAF(-0.85713654756546021000)},
    {_DATAF(-0.51541787385940552000), _DATAF(-0.85693895816802979000)},
    {_DATAF(-0.51574647426605225000), _DATAF(-0.85674124956130981000)},
    {_DATAF(-0.51607501506805420000), _DATAF(-0.85654342174530029000)},
    {_DATAF(-0.51640343666076660000), _DATAF(-0.85634541511535645000)},
    {_DATAF(-0.51673179864883423000), _DATAF(-0.85614734888076782000)},
    {_DATAF(-0.51706010103225708000), _DATAF(-0.85594910383224487000)},
    {_DATAF(-0.51738828420639038000), _DATAF(-0.85575073957443237000)},
    {_DATAF(-0.51771646738052368000), _DATAF(-0.85555225610733032000)},
    {_DATAF(-0.51804453134536743000), _DATAF(-0.85535365343093872000)},
    {_DATAF(-0.51837247610092163000), _DATAF(-0.85515493154525757000)},
    {_DATAF(-0.51870042085647583000), _DATAF(-0.85495609045028687000)},
    {_DATAF(-0.51902824640274048000), _DATAF(-0.85475707054138184000)},
    {_DATAF(-0.51935601234436035000), _DATAF(-0.85455799102783203000)},
    {_DATAF(-0.51968365907669067000), _DATAF(-0.85435873270034790000)},
    {_DATAF(-0.52001124620437622000), _DATAF(-0.85415941476821899000)},
    {_DATAF(-0.52033877372741699000), _DATAF(-0.85395991802215576000)},
    {_DATAF(-0.52066624164581299000), _DATAF(-0.85376030206680298000)},
    {_DATAF(-0.52099364995956421000), _DATAF(-0.85356056690216064000)},
    {_DATAF(-0.52132093906402588000), _DATAF(-0.85336071252822876000)},
    {_DATAF(-0.52164816856384277000), _DATAF(-0.85316073894500732000)},
    {_DATAF(-0.52197527885437012000), _DATAF(-0.85296058654785156000)},
    {_DATAF(-0.52230238914489746000), _DATAF(-0.85276037454605103000)},
    {_DATAF(-0.52262938022613525000), _DATAF(-0.85255998373031616000)},
    {_DATAF(-0.52295625209808350000), _DATAF(-0.85235953330993652000)},
    {_DATAF(-0.52328312397003174000), _DATAF(-0.85215890407562256000)},
    {_DATAF(-0.52360987663269043000), _DATAF(-0.85195815563201904000)},
    {_DATAF(-0.52393656969070435000), _DATAF(-0.85175728797912598000)},
    {_DATAF(-0.52426314353942871000), _DATAF(-0.85155630111694336000)},
    {_DATAF(-0.52458965778350830000), _DATAF(-0.85135519504547119000)},
    {_DATAF(-0.52491611242294312000), _DATAF(-0.85115396976470947000)},
    {_DATAF(-0.52524250745773315000), _DATAF(-0.85095256567001343000)},
    {_DATAF(-0.52556878328323364000), _DATAF(-0.85075110197067261000)},
    {_DATAF(-0.52589499950408936000), _DATAF(-0.85054945945739746000)},
    {_DATAF(-0.52622115612030029000), _DATAF(-0.85034775733947754000)},
    {_DATAF(-0.52654725313186646000), _DATAF(-0.85014587640762329000)},
    {_DATAF(-0.52687323093414307000), _DATAF(-0.84994387626647949000)},
    {_DATAF(-0.52719914913177490000), _DATAF(-0.84974175691604614000)},
    {_DATAF(-0.52752494812011719000), _DATAF(-0.84953951835632324000)},
    {_DATAF(-0.52785074710845947000), _DATAF(-0.84933716058731079000)},
    {_DATAF(-0.52817642688751221000), _DATAF(-0.84913468360900879000)},
    {_DATAF(-0.52850198745727539000), _DATAF(-0.84893202781677246000)},
    {_DATAF(-0.52882754802703857000), _DATAF(-0.84872931241989136000)},
    {_DATAF(-0.52915298938751221000), _DATAF(-0.84852647781372070000)},
    {_DATAF(-0.52947831153869629000), _DATAF(-0.84832346439361572000)},
    {_DATAF(-0.52980363368988037000), _DATAF(-0.84812033176422119000)},
    {_DATAF(-0.53012883663177490000), _DATAF(-0.84791707992553711000)},
    {_DATAF(-0.53045397996902466000), _DATAF(-0.84771376848220825000)},
    {_DATAF(-0.53077900409698486000), _DATAF(-0.84751027822494507000)},
    {_DATAF(-0.53110402822494507000), _DATAF(-0.84730660915374756000)},
    {_DATAF(-0.53142887353897095000), _DATAF(-0.84710288047790527000)},
    {_DATAF(-0.53175371885299683000), _DATAF(-0.84689903259277344000)},
    {_DATAF(-0.53207844495773315000), _DATAF(-0.84669506549835205000)},
    {_DATAF(-0.53240311145782471000), _DATAF(-0.84649091958999634000)},
    {_DATAF(-0.53272771835327148000), _DATAF(-0.84628671407699585000)},
    {_DATAF(-0.53305220603942871000), _DATAF(-0.84608232975006104000)},
    {_DATAF(-0.53337663412094116000), _DATAF(-0.84587788581848145000)},
    {_DATAF(-0.53370100259780884000), _DATAF(-0.84567326307296753000)},
    {_DATAF(-0.53402525186538696000), _DATAF(-0.84546852111816406000)},
    {_DATAF(-0.53434944152832031000), _DATAF(-0.84526365995407104000)},
    {_DATAF(-0.53467357158660889000), _DATAF(-0.84505867958068848000)},
    {_DATAF(-0.53499764204025269000), _DATAF(-0.84485357999801636000)},
    {_DATAF(-0.53532159328460693000), _DATAF(-0.84464836120605469000)},
    {_DATAF(-0.53564548492431641000), _DATAF(-0.84444296360015869000)},
    {_DATAF(-0.53596925735473633000), _DATAF(-0.84423750638961792000)},
    {_DATAF(-0.53629297018051147000), _DATAF(-0.84403187036514282000)},
    {_DATAF(-0.53661662340164185000), _DATAF(-0.84382617473602295000)},
    {_DATAF(-0.53694015741348267000), _DATAF(-0.84362030029296875000)},
    {_DATAF(-0.53726369142532349000), _DATAF(-0.84341436624526978000)},
    {_DATAF(-0.53758704662322998000), _DATAF(-0.84320825338363647000)},
    {_DATAF(-0.53791040182113647000), _DATAF(-0.84300202131271362000)},
    {_DATAF(-0.53823363780975342000), _DATAF(-0.84279567003250122000)},
    {_DATAF(-0.53855681419372559000), _DATAF(-0.84258919954299927000)},
    {_DATAF(-0.53887993097305298000), _DATAF(-0.84238260984420776000)},
    {_DATAF(-0.53920292854309082000), _DATAF(-0.84217590093612671000)},
    {_DATAF(-0.53952586650848389000), _DATAF(-0.84196901321411133000)},
    {_DATAF(-0.53984868526458740000), _DATAF(-0.84176206588745117000)},
    {_DATAF(-0.54017144441604614000), _DATAF(-0.84155499935150146000)},
    {_DATAF(-0.54049414396286011000), _DATAF(-0.84134775400161743000)},
    {_DATAF(-0.54081678390502930000), _DATAF(-0.84114044904708862000)},
    {_DATAF(-0.54113930463790894000), _DATAF(-0.84093296527862549000)},
    {_DATAF(-0.54146176576614380000), _DATAF(-0.84072536230087280000)},
    {_DATAF(-0.54178416728973389000), _DATAF(-0.84051764011383057000)},
    {_DATAF(-0.54210644960403442000), _DATAF(-0.84030985832214355000)},
    {_DATAF(-0.54242867231369019000), _DATAF(-0.84010189771652222000)},
    {_DATAF(-0.54275077581405640000), _DATAF(-0.83989381790161133000)},
    {_DATAF(-0.54307281970977783000), _DATAF(-0.83968561887741089000)},
    {_DATAF(-0.54339480400085449000), _DATAF(-0.83947724103927612000)},
    {_DATAF(-0.54371672868728638000), _DATAF(-0.83926880359649658000)},
    {_DATAF(-0.54403853416442871000), _DATAF(-0.83906024694442749000)},
    {_DATAF(-0.54436028003692627000), _DATAF(-0.83885151147842407000)},
    {_DATAF(-0.54468190670013428000), _DATAF(-0.83864271640777588000)},
    {_DATAF(-0.54500347375869751000), _DATAF(-0.83843380212783813000)},
    {_DATAF(-0.54532498121261597000), _DATAF(-0.83822470903396606000)},
    {_DATAF(-0.54564642906188965000), _DATAF(-0.83801549673080444000)},
    {_DATAF(-0.54596775770187378000), _DATAF(-0.83780622482299805000)},
    {_DATAF(-0.54628896713256836000), _DATAF(-0.83759677410125732000)},
    {_DATAF(-0.54661017656326294000), _DATAF(-0.83738720417022705000)},
    {_DATAF(-0.54693126678466797000), _DATAF(-0.83717751502990723000)},
    {_DATAF(-0.54725229740142822000), _DATAF(-0.83696770668029785000)},
    {_DATAF(-0.54757320880889893000), _DATAF(-0.83675777912139893000)},
    {_DATAF(-0.54789406061172485000), _DATAF(-0.83654773235321045000)},
    {_DATAF(-0.54821485280990601000), _DATAF(-0.83633756637573242000)},
    {_DATAF(-0.54853552579879761000), _DATAF(-0.83612728118896484000)},
    {_DATAF(-0.54885613918304443000), _DATAF(-0.83591681718826294000)},
    {_DATAF(-0.54917663335800171000), _DATAF(-0.83570629358291626000)},
    {_DATAF(-0.54949712753295898000), _DATAF(-0.83549559116363525000)},
    {_DATAF(-0.54981750249862671000), _DATAF(-0.83528482913970947000)},
    {_DATAF(-0.55013775825500488000), _DATAF(-0.83507388830184937000)},
    {_DATAF(-0.55045795440673828000), _DATAF(-0.83486288785934448000)},
    {_DATAF(-0.55077809095382690000), _DATAF(-0.83465170860290527000)},
    {_DATAF(-0.55109816789627075000), _DATAF(-0.83444041013717651000)},
    {_DATAF(-0.55141812562942505000), _DATAF(-0.83422905206680298000)},
    {_DATAF(-0.55173796415328979000), _DATAF(-0.83401751518249512000)},
    {_DATAF(-0.55205780267715454000), _DATAF(-0.83380585908889771000)},
    {_DATAF(-0.55237752199172974000), _DATAF(-0.83359408378601074000)},
    {_DATAF(-0.55269712209701538000), _DATAF(-0.83338218927383423000)},
    {_DATAF(-0.55301672220230103000), _DATAF(-0.83317017555236816000)},
    {_DATAF(-0.55333620309829712000), _DATAF(-0.83295804262161255000)},
    {_DATAF(-0.55365556478500366000), _DATAF(-0.83274579048156738000)},
    {_DATAF(-0.55397486686706543000), _DATAF(-0.83253335952758789000)},
    {_DATAF(-0.55429410934448242000), _DATAF(-0.83232086896896362000)},
    {_DATAF(-0.55461329221725464000), _DATAF(-0.83210825920104980000)},
    {_DATAF(-0.55493235588073730000), _DATAF(-0.83189547061920166000)},
    {_DATAF(-0.55525130033493042000), _DATAF(-0.83168262243270874000)},
    {_DATAF(-0.55557024478912354000), _DATAF(-0.83146959543228149000)},
    {_DATAF(-0.55588907003402710000), _DATAF(-0.83125650882720947000)},
    {_DATAF(-0.55620777606964111000), _DATAF(-0.83104324340820313000)},
    {_DATAF(-0.55652648210525513000), _DATAF(-0.83082985877990723000)},
    {_DATAF(-0.55684500932693481000), _DATAF(-0.83061641454696655000)},
    {_DATAF(-0.55716353654861450000), _DATAF(-0.83040279150009155000)},
    {_DATAF(-0.55748194456100464000), _DATAF(-0.83018904924392700000)},
    {_DATAF(-0.55780029296875000000), _DATAF(-0.82997518777847290000)},
    {_DATAF(-0.55811852216720581000), _DATAF(-0.82976120710372925000)},
    {_DATAF(-0.55843669176101685000), _DATAF(-0.82954710721969604000)},
    {_DATAF(-0.55875480175018311000), _DATAF(-0.82933294773101807000)},
    {_DATAF(-0.55907279253005981000), _DATAF(-0.82911854982376099000)},
    {_DATAF(-0.55939072370529175000), _DATAF(-0.82890409231185913000)},
    {_DATAF(-0.55970853567123413000), _DATAF(-0.82868951559066772000)},
    {_DATAF(-0.56002628803253174000), _DATAF(-0.82847481966018677000)},
    {_DATAF(-0.56034398078918457000), _DATAF(-0.82826000452041626000)},
    {_DATAF(-0.56066155433654785000), _DATAF(-0.82804507017135620000)},
    {_DATAF(-0.56097906827926636000), _DATAF(-0.82782995700836182000)},
    {_DATAF(-0.56129652261734009000), _DATAF(-0.82761478424072266000)},
    {_DATAF(-0.56161385774612427000), _DATAF(-0.82739949226379395000)},
    {_DATAF(-0.56193113327026367000), _DATAF(-0.82718402147293091000)},
    {_DATAF(-0.56224828958511353000), _DATAF(-0.82696849107742310000)},
    {_DATAF(-0.56256538629531860000), _DATAF(-0.82675278186798096000)},
    {_DATAF(-0.56288242340087891000), _DATAF(-0.82653701305389404000)},
    {_DATAF(-0.56319934129714966000), _DATAF(-0.82632106542587280000)},
    {_DATAF(-0.56351619958877563000), _DATAF(-0.82610499858856201000)},
    {_DATAF(-0.56383293867111206000), _DATAF(-0.82588887214660645000)},
    {_DATAF(-0.56414961814880371000), _DATAF(-0.82567256689071655000)},
    {_DATAF(-0.56446623802185059000), _DATAF(-0.82545614242553711000)},
    {_DATAF(-0.56478273868560791000), _DATAF(-0.82523959875106812000)},
    {_DATAF(-0.56509917974472046000), _DATAF(-0.82502299547195435000)},
    {_DATAF(-0.56541556119918823000), _DATAF(-0.82480621337890625000)},
    {_DATAF(-0.56573182344436646000), _DATAF(-0.82458931207656860000)},
    {_DATAF(-0.56604796648025513000), _DATAF(-0.82437229156494141000)},
    {_DATAF(-0.56636410951614380000), _DATAF(-0.82415515184402466000)},
    {_DATAF(-0.56668013334274292000), _DATAF(-0.82393789291381836000)},
    {_DATAF(-0.56699603796005249000), _DATAF(-0.82372051477432251000)},
    {_DATAF(-0.56731188297271729000), _DATAF(-0.82350301742553711000)},
    {_DATAF(-0.56762766838073730000), _DATAF(-0.82328540086746216000)},
    {_DATAF(-0.56794333457946777000), _DATAF(-0.82306766510009766000)},
    {_DATAF(-0.56825894117355347000), _DATAF(-0.82284981012344360000)},
    {_DATAF(-0.56857448816299438000), _DATAF(-0.82263177633285522000)},
    {_DATAF(-0.56888991594314575000), _DATAF(-0.82241368293762207000)},
    {_DATAF(-0.56920522451400757000), _DATAF(-0.82219547033309937000)},
    {_DATAF(-0.56952053308486938000), _DATAF(-0.82197713851928711000)},
    {_DATAF(-0.56983572244644165000), _DATAF(-0.82175862789154053000)},
    {_DATAF(-0.57015079259872437000), _DATAF(-0.82154005765914917000)},
    {_DATAF(-0.57046580314636230000), _DATAF(-0.82132136821746826000)},
    {_DATAF(-0.57078075408935547000), _DATAF(-0.82110249996185303000)},
    {_DATAF(-0.57109558582305908000), _DATAF(-0.82088357210159302000)},
    {_DATAF(-0.57141035795211792000), _DATAF(-0.82066446542739868000)},
    {_DATAF(-0.57172501087188721000), _DATAF(-0.82044529914855957000)},
    {_DATAF(-0.57203960418701172000), _DATAF(-0.82022595405578613000)},
    {_DATAF(-0.57235413789749146000), _DATAF(-0.82000654935836792000)},
    {_DATAF(-0.57266855239868164000), _DATAF(-0.81978696584701538000)},
    {_DATAF(-0.57298290729522705000), _DATAF(-0.81956732273101807000)},
    {_DATAF(-0.57329714298248291000), _DATAF(-0.81934750080108643000)},
    {_DATAF(-0.57361131906509399000), _DATAF(-0.81912761926651001000)},
    {_DATAF(-0.57392543554306030000), _DATAF(-0.81890755891799927000)},
    {_DATAF(-0.57423943281173706000), _DATAF(-0.81868737936019897000)},
    {_DATAF(-0.57455337047576904000), _DATAF(-0.81846714019775391000)},
    {_DATAF(-0.57486718893051147000), _DATAF(-0.81824672222137451000)},
    {_DATAF(-0.57518094778060913000), _DATAF(-0.81802618503570557000)},
    {_DATAF(-0.57549458742141724000), _DATAF(-0.81780558824539185000)},
    {_DATAF(-0.57580816745758057000), _DATAF(-0.81758481264114380000)},
    {_DATAF(-0.57612168788909912000), _DATAF(-0.81736391782760620000)},
    {_DATAF(-0.57643508911132813000), _DATAF(-0.81714290380477905000)},
    {_DATAF(-0.57674843072891235000), _DATAF(-0.81692183017730713000)},
    {_DATAF(-0.57706165313720703000), _DATAF(-0.81670057773590088000)},
    {_DATAF(-0.57737481594085693000), _DATAF(-0.81647920608520508000)},
    {_DATAF(-0.57768791913986206000), _DATAF(-0.81625771522521973000)},
    {_DATAF(-0.57800090312957764000), _DATAF(-0.81603610515594482000)},
    {_DATAF(-0.57831376791000366000), _DATAF(-0.81581443548202515000)},
    {_DATAF(-0.57862663269042969000), _DATAF(-0.81559258699417114000)},
    {_DATAF(-0.57893931865692139000), _DATAF(-0.81537061929702759000)},
    {_DATAF(-0.57925200462341309000), _DATAF(-0.81514853239059448000)},
    {_DATAF(-0.57956457138061523000), _DATAF(-0.81492632627487183000)},
    {_DATAF(-0.57987701892852783000), _DATAF(-0.81470400094985962000)},
    {_DATAF(-0.58018940687179565000), _DATAF(-0.81448155641555786000)},
    {_DATAF(-0.58050173521041870000), _DATAF(-0.81425899267196655000)},
    {_DATAF(-0.58081394433975220000), _DATAF(-0.81403630971908569000)},
    {_DATAF(-0.58112609386444092000), _DATAF(-0.81381350755691528000)},
    {_DATAF(-0.58143812417984009000), _DATAF(-0.81359058618545532000)},
    {_DATAF(-0.58175009489059448000), _DATAF(-0.81336754560470581000)},
    {_DATAF(-0.58206200599670410000), _DATAF(-0.81314438581466675000)},
    {_DATAF(-0.58237379789352417000), _DATAF(-0.81292116641998291000)},
    {_DATAF(-0.58268547058105469000), _DATAF(-0.81269776821136475000)},
    {_DATAF(-0.58299714326858521000), _DATAF(-0.81247425079345703000)},
    {_DATAF(-0.58330863714218140000), _DATAF(-0.81225061416625977000)},
    {_DATAF(-0.58362013101577759000), _DATAF(-0.81202685832977295000)},
    {_DATAF(-0.58393144607543945000), _DATAF(-0.81180298328399658000)},
    {_DATAF(-0.58424276113510132000), _DATAF(-0.81157898902893066000)},
    {_DATAF(-0.58455395698547363000), _DATAF(-0.81135487556457520000)},
    {_DATAF(-0.58486503362655640000), _DATAF(-0.81113064289093018000)},
    {_DATAF(-0.58517605066299438000), _DATAF(-0.81090623140335083000)},
    {_DATAF(-0.58548700809478760000), _DATAF(-0.81068176031112671000)},
    {_DATAF(-0.58579784631729126000), _DATAF(-0.81045717000961304000)},
    {_DATAF(-0.58610862493515015000), _DATAF(-0.81023246049880981000)},
    {_DATAF(-0.58641928434371948000), _DATAF(-0.81000763177871704000)},
    {_DATAF(-0.58672988414764404000), _DATAF(-0.80978268384933472000)},
    {_DATAF(-0.58704036474227905000), _DATAF(-0.80955761671066284000)},
    {_DATAF(-0.58735078573226929000), _DATAF(-0.80933243036270142000)},
    {_DATAF(-0.58766114711761475000), _DATAF(-0.80910712480545044000)},
    {_DATAF(-0.58797138929367065000), _DATAF(-0.80888170003890991000)},
    {_DATAF(-0.58828157186508179000), _DATAF(-0.80865615606307983000)},
    {_DATAF(-0.58859163522720337000), _DATAF(-0.80843049287796021000)},
    {_DATAF(-0.58890157938003540000), _DATAF(-0.80820471048355103000)},
    {_DATAF(-0.58921152353286743000), _DATAF(-0.80797880887985229000)},
    {_DATAF(-0.58952128887176514000), _DATAF(-0.80775284767150879000)},
    {_DATAF(-0.58983105421066284000), _DATAF(-0.80752670764923096000)},
    {_DATAF(-0.59014070034027100000), _DATAF(-0.80730044841766357000)},
    {_DATAF(-0.59045022726058960000), _DATAF(-0.80707406997680664000)},
    {_DATAF(-0.59075969457626343000), _DATAF(-0.80684757232666016000)},
    {_DATAF(-0.59106910228729248000), _DATAF(-0.80662095546722412000)},
    {_DATAF(-0.59137839078903198000), _DATAF(-0.80639421939849854000)},
    {_DATAF(-0.59168756008148193000), _DATAF(-0.80616736412048340000)},
    {_DATAF(-0.59199666976928711000), _DATAF(-0.80594038963317871000)},
    {_DATAF(-0.59230571985244751000), _DATAF(-0.80571329593658447000)},
    {_DATAF(-0.59261465072631836000), _DATAF(-0.80548608303070068000)},
    {_DATAF(-0.59292352199554443000), _DATAF(-0.80525875091552734000)},
    {_DATAF(-0.59323227405548096000), _DATAF(-0.80503135919570923000)},
    {_DATAF(-0.59354096651077271000), _DATAF(-0.80480378866195679000)},
    {_DATAF(-0.59384959936141968000), _DATAF(-0.80457609891891479000)},
    {_DATAF(-0.59415805339813232000), _DATAF(-0.80434828996658325000)},
    {_DATAF(-0.59446650743484497000), _DATAF(-0.80412036180496216000)},
    {_DATAF(-0.59477484226226807000), _DATAF(-0.80389231443405151000)},
    {_DATAF(-0.59508305788040161000), _DATAF(-0.80366420745849609000)},
    {_DATAF(-0.59539121389389038000), _DATAF(-0.80343592166900635000)},
    {_DATAF(-0.59569931030273438000), _DATAF(-0.80320751667022705000)},
    {_DATAF(-0.59600728750228882000), _DATAF(-0.80297905206680298000)},
    {_DATAF(-0.59631520509719849000), _DATAF(-0.80275040864944458000)},
    {_DATAF(-0.59662300348281860000), _DATAF(-0.80252164602279663000)},
    {_DATAF(-0.59693068265914917000), _DATAF(-0.80229282379150391000)},
    {_DATAF(-0.59723836183547974000), _DATAF(-0.80206382274627686000)},
    {_DATAF(-0.59754586219787598000), _DATAF(-0.80183470249176025000)},
    {_DATAF(-0.59785336256027222000), _DATAF(-0.80160552263259888000)},
    {_DATAF(-0.59816068410873413000), _DATAF(-0.80137616395950317000)},
    {_DATAF(-0.59846800565719604000), _DATAF(-0.80114674568176270000)},
    {_DATAF(-0.59877520799636841000), _DATAF(-0.80091714859008789000)},
    {_DATAF(-0.59908229112625122000), _DATAF(-0.80068749189376831000)},
    {_DATAF(-0.59938931465148926000), _DATAF(-0.80045765638351440000)},
    {_DATAF(-0.59969621896743774000), _DATAF(-0.80022776126861572000)},
    {_DATAF(-0.60000306367874146000), _DATAF(-0.79999768733978271000)},
    {_DATAF(-0.60030978918075562000), _DATAF(-0.79976755380630493000)},
    {_DATAF(-0.60061645507812500000), _DATAF(-0.79953724145889282000)},
    {_DATAF(-0.60092306137084961000), _DATAF(-0.79930686950683594000)},
    {_DATAF(-0.60122954845428467000), _DATAF(-0.79907637834548950000)},
    {_DATAF(-0.60153591632843018000), _DATAF(-0.79884576797485352000)},
    {_DATAF(-0.60184222459793091000), _DATAF(-0.79861497879028320000)},
    {_DATAF(-0.60214847326278687000), _DATAF(-0.79838413000106812000)},
    {_DATAF(-0.60245460271835327000), _DATAF(-0.79815316200256348000)},
    {_DATAF(-0.60276067256927490000), _DATAF(-0.79792207479476929000)},
    {_DATAF(-0.60306662321090698000), _DATAF(-0.79769086837768555000)},
    {_DATAF(-0.60337245464324951000), _DATAF(-0.79745948314666748000)},
    {_DATAF(-0.60367822647094727000), _DATAF(-0.79722803831100464000)},
    {_DATAF(-0.60398393869400024000), _DATAF(-0.79699647426605225000)},
    {_DATAF(-0.60428953170776367000), _DATAF(-0.79676479101181030000)},
    {_DATAF(-0.60459506511688232000), _DATAF(-0.79653298854827881000)},
    {_DATAF(-0.60490047931671143000), _DATAF(-0.79630106687545776000)},
    {_DATAF(-0.60520577430725098000), _DATAF(-0.79606908559799194000)},
    {_DATAF(-0.60551106929779053000), _DATAF(-0.79583692550659180000)},
    {_DATAF(-0.60581618547439575000), _DATAF(-0.79560464620590210000)},
    {_DATAF(-0.60612124204635620000), _DATAF(-0.79537224769592285000)},
    {_DATAF(-0.60642623901367188000), _DATAF(-0.79513972997665405000)},
    {_DATAF(-0.60673111677169800000), _DATAF(-0.79490715265274048000)},
    {_DATAF(-0.60703593492507935000), _DATAF(-0.79467439651489258000)},
    {_DATAF(-0.60734063386917114000), _DATAF(-0.79444152116775513000)},
    {_DATAF(-0.60764527320861816000), _DATAF(-0.79420858621597290000)},
    {_DATAF(-0.60794979333877563000), _DATAF(-0.79397547245025635000)},
    {_DATAF(-0.60825425386428833000), _DATAF(-0.79374229907989502000)},
    {_DATAF(-0.60855859518051147000), _DATAF(-0.79350894689559937000)},
    {_DATAF(-0.60886281728744507000), _DATAF(-0.79327553510665894000)},
    {_DATAF(-0.60916703939437866000), _DATAF(-0.79304194450378418000)},
    {_DATAF(-0.60947108268737793000), _DATAF(-0.79280829429626465000)},
    {_DATAF(-0.60977506637573242000), _DATAF(-0.79257452487945557000)},
    {_DATAF(-0.61007899045944214000), _DATAF(-0.79234057664871216000)},
    {_DATAF(-0.61038279533386230000), _DATAF(-0.79210656881332397000)},
    {_DATAF(-0.61068654060363770000), _DATAF(-0.79187244176864624000)},
    {_DATAF(-0.61099016666412354000), _DATAF(-0.79163819551467896000)},
    {_DATAF(-0.61129373311996460000), _DATAF(-0.79140383005142212000)},
    {_DATAF(-0.61159718036651611000), _DATAF(-0.79116934537887573000)},
    {_DATAF(-0.61190050840377808000), _DATAF(-0.79093474149703979000)},
    {_DATAF(-0.61220377683639526000), _DATAF(-0.79070001840591431000)},
    {_DATAF(-0.61250698566436768000), _DATAF(-0.79046517610549927000)},
    {_DATAF(-0.61281007528305054000), _DATAF(-0.79023021459579468000)},
    {_DATAF(-0.61311310529708862000), _DATAF(-0.78999513387680054000)},
    {_DATAF(-0.61341601610183716000), _DATAF(-0.78975999355316162000)},
    {_DATAF(-0.61371880769729614000), _DATAF(-0.78952467441558838000)},
    {_DATAF(-0.61402153968811035000), _DATAF(-0.78928923606872559000)},
    {_DATAF(-0.61432421207427979000), _DATAF(-0.78905373811721802000)},
    {_DATAF(-0.61462676525115967000), _DATAF(-0.78881806135177612000)},
    {_DATAF(-0.61492919921875000000), _DATAF(-0.78858232498168945000)},
    {_DATAF(-0.61523157358169556000), _DATAF(-0.78834640979766846000)},
    {_DATAF(-0.61553388833999634000), _DATAF(-0.78811043500900269000)},
    {_DATAF(-0.61583608388900757000), _DATAF(-0.78787434101104736000)},
    {_DATAF(-0.61613816022872925000), _DATAF(-0.78763806819915771000)},
    {_DATAF(-0.61644017696380615000), _DATAF(-0.78740173578262329000)},
    {_DATAF(-0.61674207448959351000), _DATAF(-0.78716528415679932000)},
    {_DATAF(-0.61704391241073608000), _DATAF(-0.78692871332168579000)},
    {_DATAF(-0.61734563112258911000), _DATAF(-0.78669202327728271000)},
    {_DATAF(-0.61764729022979736000), _DATAF(-0.78645521402359009000)},
    {_DATAF(-0.61794888973236084000), _DATAF(-0.78621828556060791000)},
    {_DATAF(-0.61825031042098999000), _DATAF(-0.78598123788833618000)},
    {_DATAF(-0.61855173110961914000), _DATAF(-0.78574407100677490000)},
    {_DATAF(-0.61885297298431396000), _DATAF(-0.78550684452056885000)},
    {_DATAF(-0.61915415525436401000), _DATAF(-0.78526943922042847000)},
    {_DATAF(-0.61945527791976929000), _DATAF(-0.78503191471099854000)},
    {_DATAF(-0.61975628137588501000), _DATAF(-0.78479433059692383000)},
    {_DATAF(-0.62005722522735596000), _DATAF(-0.78455656766891479000)},
    {_DATAF(-0.62035804986953735000), _DATAF(-0.78431874513626099000)},
    {_DATAF(-0.62065875530242920000), _DATAF(-0.78408080339431763000)},
    {_DATAF(-0.62095940113067627000), _DATAF(-0.78384268283843994000)},
    {_DATAF(-0.62125998735427856000), _DATAF(-0.78360450267791748000)},
    {_DATAF(-0.62156045436859131000), _DATAF(-0.78336620330810547000)},
    {_DATAF(-0.62186080217361450000), _DATAF(-0.78312778472900391000)},
    {_DATAF(-0.62216109037399292000), _DATAF(-0.78288924694061279000)},
    {_DATAF(-0.62246125936508179000), _DATAF(-0.78265058994293213000)},
    {_DATAF(-0.62276136875152588000), _DATAF(-0.78241181373596191000)},
    {_DATAF(-0.62306135892868042000), _DATAF(-0.78217291831970215000)},
    {_DATAF(-0.62336128950119019000), _DATAF(-0.78193396329879761000)},
    {_DATAF(-0.62366110086441040000), _DATAF(-0.78169482946395874000)},
    {_DATAF(-0.62396085262298584000), _DATAF(-0.78145557641983032000)},
    {_DATAF(-0.62426048517227173000), _DATAF(-0.78121626377105713000)},
    {_DATAF(-0.62456005811691284000), _DATAF(-0.78097677230834961000)},
    {_DATAF(-0.62485951185226440000), _DATAF(-0.78073722124099731000)},
    {_DATAF(-0.62515884637832642000), _DATAF(-0.78049755096435547000)},
    {_DATAF(-0.62545812129974365000), _DATAF(-0.78025776147842407000)},
    {_DATAF(-0.62575727701187134000), _DATAF(-0.78001779317855835000)},
    {_DATAF(-0.62605637311935425000), _DATAF(-0.77977776527404785000)},
    {_DATAF(-0.62635540962219238000), _DATAF(-0.77953761816024780000)},
    {_DATAF(-0.62665426731109619000), _DATAF(-0.77929735183715820000)},
    {_DATAF(-0.62695312500000000000), _DATAF(-0.77905702590942383000)},
    {_DATAF(-0.62725180387496948000), _DATAF(-0.77881652116775513000)},
    {_DATAF(-0.62755042314529419000), _DATAF(-0.77857589721679688000)},
    {_DATAF(-0.62784898281097412000), _DATAF(-0.77833521366119385000)},
    {_DATAF(-0.62814742326736450000), _DATAF(-0.77809435129165649000)},
    {_DATAF(-0.62844574451446533000), _DATAF(-0.77785342931747437000)},
    {_DATAF(-0.62874400615692139000), _DATAF(-0.77761232852935791000)},
    {_DATAF(-0.62904220819473267000), _DATAF(-0.77737116813659668000)},
    {_DATAF(-0.62934023141860962000), _DATAF(-0.77712988853454590000)},
    {_DATAF(-0.62963825464248657000), _DATAF(-0.77688848972320557000)},
    {_DATAF(-0.62993609905242920000), _DATAF(-0.77664697170257568000)},
    {_DATAF(-0.63023394346237183000), _DATAF(-0.77640533447265625000)},
    {_DATAF(-0.63053160905838013000), _DATAF(-0.77616357803344727000)},
    {_DATAF(-0.63082921504974365000), _DATAF(-0.77592170238494873000)},
    {_DATAF(-0.63112676143646240000), _DATAF(-0.77567970752716064000)},
    {_DATAF(-0.63142418861389160000), _DATAF(-0.77543765306472778000)},
    {_DATAF(-0.63172149658203125000), _DATAF(-0.77519541978836060000)},
    {_DATAF(-0.63201874494552612000), _DATAF(-0.77495312690734863000)},
    {_DATAF(-0.63231587409973145000), _DATAF(-0.77471065521240234000)},
    {_DATAF(-0.63261294364929199000), _DATAF(-0.77446812391281128000)},
    {_DATAF(-0.63290989398956299000), _DATAF(-0.77422547340393066000)},
    {_DATAF(-0.63320678472518921000), _DATAF(-0.77398270368576050000)},
    {_DATAF(-0.63350355625152588000), _DATAF(-0.77373981475830078000)},
    {_DATAF(-0.63380020856857300000), _DATAF(-0.77349680662155151000)},
    {_DATAF(-0.63409680128097534000), _DATAF(-0.77325367927551270000)},
    {_DATAF(-0.63439327478408813000), _DATAF(-0.77301043272018433000)},
    {_DATAF(-0.63468968868255615000), _DATAF(-0.77276712656021118000)},
    {_DATAF(-0.63498598337173462000), _DATAF(-0.77252364158630371000)},
    {_DATAF(-0.63528221845626831000), _DATAF(-0.77228009700775146000)},
    {_DATAF(-0.63557833433151245000), _DATAF(-0.77203637361526489000)},
    {_DATAF(-0.63587433099746704000), _DATAF(-0.77179259061813354000)},
    {_DATAF(-0.63617026805877686000), _DATAF(-0.77154868841171265000)},
    {_DATAF(-0.63646614551544189000), _DATAF(-0.77130466699600220000)},
    {_DATAF(-0.63676184415817261000), _DATAF(-0.77106052637100220000)},
    {_DATAF(-0.63705748319625854000), _DATAF(-0.77081626653671265000)},
    {_DATAF(-0.63735306262969971000), _DATAF(-0.77057188749313354000)},
    {_DATAF(-0.63764852285385132000), _DATAF(-0.77032744884490967000)},
    {_DATAF(-0.63794392347335815000), _DATAF(-0.77008283138275146000)},
    {_DATAF(-0.63823920488357544000), _DATAF(-0.76983815431594849000)},
    {_DATAF(-0.63853436708450317000), _DATAF(-0.76959329843521118000)},
    {_DATAF(-0.63882946968078613000), _DATAF(-0.76934838294982910000)},
    {_DATAF(-0.63912445306777954000), _DATAF(-0.76910334825515747000)},
    {_DATAF(-0.63941931724548340000), _DATAF(-0.76885819435119629000)},
    {_DATAF(-0.63971418142318726000), _DATAF(-0.76861292123794556000)},
    {_DATAF(-0.64000886678695679000), _DATAF(-0.76836752891540527000)},
    {_DATAF(-0.64030349254608154000), _DATAF(-0.76812201738357544000)},
    {_DATAF(-0.64059799909591675000), _DATAF(-0.76787644624710083000)},
    {_DATAF(-0.64089244604110718000), _DATAF(-0.76763069629669189000)},
    {_DATAF(-0.64118677377700806000), _DATAF(-0.76738488674163818000)},
    {_DATAF(-0.64148104190826416000), _DATAF(-0.76713889837265015000)},
    {_DATAF(-0.64177513122558594000), _DATAF(-0.76689285039901733000)},
    {_DATAF(-0.64206922054290771000), _DATAF(-0.76664668321609497000)},
    {_DATAF(-0.64236319065093994000), _DATAF(-0.76640039682388306000)},
    {_DATAF(-0.64265704154968262000), _DATAF(-0.76615399122238159000)},
    {_DATAF(-0.64295083284378052000), _DATAF(-0.76590746641159058000)},
    {_DATAF(-0.64324450492858887000), _DATAF(-0.76566088199615479000)},
    {_DATAF(-0.64353805780410767000), _DATAF(-0.76541411876678467000)},
    {_DATAF(-0.64383155107498169000), _DATAF(-0.76516723632812500000)},
    {_DATAF(-0.64412492513656616000), _DATAF(-0.76492029428482056000)},
    {_DATAF(-0.64441823959350586000), _DATAF(-0.76467323303222656000)},
    {_DATAF(-0.64471143484115601000), _DATAF(-0.76442605257034302000)},
    {_DATAF(-0.64500451087951660000), _DATAF(-0.76417875289916992000)},
    {_DATAF(-0.64529752731323242000), _DATAF(-0.76393133401870728000)},
    {_DATAF(-0.64559048414230347000), _DATAF(-0.76368379592895508000)},
    {_DATAF(-0.64588326215744019000), _DATAF(-0.76343613862991333000)},
    {_DATAF(-0.64617604017257690000), _DATAF(-0.76318842172622681000)},
    {_DATAF(-0.64646863937377930000), _DATAF(-0.76294052600860596000)},
    {_DATAF(-0.64676117897033691000), _DATAF(-0.76269257068634033000)},
    {_DATAF(-0.64705359935760498000), _DATAF(-0.76244449615478516000)},
    {_DATAF(-0.64734596014022827000), _DATAF(-0.76219630241394043000)},
    {_DATAF(-0.64763820171356201000), _DATAF(-0.76194798946380615000)},
    {_DATAF(-0.64793038368225098000), _DATAF(-0.76169955730438232000)},
    {_DATAF(-0.64822244644165039000), _DATAF(-0.76145100593566895000)},
    {_DATAF(-0.64851438999176025000), _DATAF(-0.76120239496231079000)},
    {_DATAF(-0.64880627393722534000), _DATAF(-0.76095360517501831000)},
    {_DATAF(-0.64909803867340088000), _DATAF(-0.76070475578308105000)},
    {_DATAF(-0.64938974380493164000), _DATAF(-0.76045578718185425000)},
    {_DATAF(-0.64968132972717285000), _DATAF(-0.76020669937133789000)},
    {_DATAF(-0.64997279644012451000), _DATAF(-0.75995749235153198000)},
    {_DATAF(-0.65026420354843140000), _DATAF(-0.75970816612243652000)},
    {_DATAF(-0.65055549144744873000), _DATAF(-0.75945872068405151000)},
    {_DATAF(-0.65084666013717651000), _DATAF(-0.75920921564102173000)},
    {_DATAF(-0.65113776922225952000), _DATAF(-0.75895953178405762000)},
    {_DATAF(-0.65142881870269775000), _DATAF(-0.75870978832244873000)},
    {_DATAF(-0.65171968936920166000), _DATAF(-0.75845992565155029000)},
    {_DATAF(-0.65201056003570557000), _DATAF(-0.75820988416671753000)},
    {_DATAF(-0.65230125188827515000), _DATAF(-0.75795978307723999000)},
    {_DATAF(-0.65259188413619995000), _DATAF(-0.75770962238311768000)},
    {_DATAF(-0.65288239717483521000), _DATAF(-0.75745928287506104000)},
    {_DATAF(-0.65317285060882568000), _DATAF(-0.75720882415771484000)},
    {_DATAF(-0.65346318483352661000), _DATAF(-0.75695830583572388000)},
    {_DATAF(-0.65375339984893799000), _DATAF(-0.75670766830444336000)},
    {_DATAF(-0.65404355525970459000), _DATAF(-0.75645685195922852000)},
    {_DATAF(-0.65433359146118164000), _DATAF(-0.75620597600936890000)},
    {_DATAF(-0.65462356805801392000), _DATAF(-0.75595504045486450000)},
    {_DATAF(-0.65491342544555664000), _DATAF(-0.75570392608642578000)},
    {_DATAF(-0.65520316362380981000), _DATAF(-0.75545269250869751000)},
    {_DATAF(-0.65549284219741821000), _DATAF(-0.75520139932632446000)},
    {_DATAF(-0.65578240156173706000), _DATAF(-0.75494992733001709000)},
    {_DATAF(-0.65607190132141113000), _DATAF(-0.75469839572906494000)},
    {_DATAF(-0.65636128187179565000), _DATAF(-0.75444674491882324000)},
    {_DATAF(-0.65665054321289063000), _DATAF(-0.75419497489929199000)},
    {_DATAF(-0.65693974494934082000), _DATAF(-0.75394308567047119000)},
    {_DATAF(-0.65722882747650146000), _DATAF(-0.75369113683700562000)},
    {_DATAF(-0.65751779079437256000), _DATAF(-0.75343900918960571000)},
    {_DATAF(-0.65780669450759888000), _DATAF(-0.75318682193756104000)},
    {_DATAF(-0.65809547901153564000), _DATAF(-0.75293445587158203000)},
    {_DATAF(-0.65838420391082764000), _DATAF(-0.75268203020095825000)},
    {_DATAF(-0.65867280960083008000), _DATAF(-0.75242948532104492000)},
    {_DATAF(-0.65896129608154297000), _DATAF(-0.75217682123184204000)},
    {_DATAF(-0.65924972295761108000), _DATAF(-0.75192409753799438000)},
    {_DATAF(-0.65953803062438965000), _DATAF(-0.75167119503021240000)},
    {_DATAF(-0.65982621908187866000), _DATAF(-0.75141823291778564000)},
    {_DATAF(-0.66011434793472290000), _DATAF(-0.75116515159606934000)},
    {_DATAF(-0.66040235757827759000), _DATAF(-0.75091195106506348000)},
    {_DATAF(-0.66069030761718750000), _DATAF(-0.75065863132476807000)},
    {_DATAF(-0.66097813844680786000), _DATAF(-0.75040519237518311000)},
    {_DATAF(-0.66126585006713867000), _DATAF(-0.75015163421630859000)},
    {_DATAF(-0.66155344247817993000), _DATAF(-0.74989801645278931000)},
    {_DATAF(-0.66184097528457642000), _DATAF(-0.74964421987533569000)},
    {_DATAF(-0.66212844848632813000), _DATAF(-0.74939036369323730000)},
    {_DATAF(-0.66241580247879028000), _DATAF(-0.74913638830184937000)},
    {_DATAF(-0.66270303726196289000), _DATAF(-0.74888229370117188000)},
    {_DATAF(-0.66299015283584595000), _DATAF(-0.74862807989120483000)},
    {_DATAF(-0.66327720880508423000), _DATAF(-0.74837380647659302000)},
    {_DATAF(-0.66356414556503296000), _DATAF(-0.74811935424804688000)},
    {_DATAF(-0.66385102272033691000), _DATAF(-0.74786484241485596000)},
    {_DATAF(-0.66413778066635132000), _DATAF(-0.74761021137237549000)},
    {_DATAF(-0.66442441940307617000), _DATAF(-0.74735546112060547000)},
    {_DATAF(-0.66471099853515625000), _DATAF(-0.74710059165954590000)},
    {_DATAF(-0.66499745845794678000), _DATAF(-0.74684566259384155000)},
    {_DATAF(-0.66528379917144775000), _DATAF(-0.74659055471420288000)},
    {_DATAF(-0.66557008028030396000), _DATAF(-0.74633538722991943000)},
    {_DATAF(-0.66585624217987061000), _DATAF(-0.74608010053634644000)},
    {_DATAF(-0.66614228487014771000), _DATAF(-0.74582469463348389000)},
    {_DATAF(-0.66642826795578003000), _DATAF(-0.74556916952133179000)},
    {_DATAF(-0.66671413183212280000), _DATAF(-0.74531352519989014000)},
    {_DATAF(-0.66699993610382080000), _DATAF(-0.74505776166915894000)},
    {_DATAF(-0.66728562116622925000), _DATAF(-0.74480193853378296000)},
    {_DATAF(-0.66757118701934814000), _DATAF(-0.74454599618911743000)},
    {_DATAF(-0.66785663366317749000), _DATAF(-0.74428993463516235000)},
    {_DATAF(-0.66814202070236206000), _DATAF(-0.74403375387191772000)},
    {_DATAF(-0.66842734813690186000), _DATAF(-0.74377745389938354000)},
    {_DATAF(-0.66871249675750732000), _DATAF(-0.74352109432220459000)},
    {_DATAF(-0.66899758577346802000), _DATAF(-0.74326455593109131000)},
    {_DATAF(-0.66928261518478394000), _DATAF(-0.74300795793533325000)},
    {_DATAF(-0.66956746578216553000), _DATAF(-0.74275124073028564000)},
    {_DATAF(-0.66985225677490234000), _DATAF(-0.74249440431594849000)},
    {_DATAF(-0.67013698816299438000), _DATAF(-0.74223744869232178000)},
    {_DATAF(-0.67042154073715210000), _DATAF(-0.74198043346405029000)},
    {_DATAF(-0.67070603370666504000), _DATAF(-0.74172323942184448000)},
    {_DATAF(-0.67099046707153320000), _DATAF(-0.74146598577499390000)},
    {_DATAF(-0.67127478122711182000), _DATAF(-0.74120861291885376000)},
    {_DATAF(-0.67155897617340088000), _DATAF(-0.74095112085342407000)},
    {_DATAF(-0.67184305191040039000), _DATAF(-0.74069350957870483000)},
    {_DATAF(-0.67212706804275513000), _DATAF(-0.74043583869934082000)},
    {_DATAF(-0.67241096496582031000), _DATAF(-0.74017798900604248000)},
    {_DATAF(-0.67269474267959595000), _DATAF(-0.73992007970809937000)},
    {_DATAF(-0.67297846078872681000), _DATAF(-0.73966205120086670000)},
    {_DATAF(-0.67326205968856812000), _DATAF(-0.73940390348434448000)},
    {_DATAF(-0.67354559898376465000), _DATAF(-0.73914569616317749000)},
    {_DATAF(-0.67382901906967163000), _DATAF(-0.73888731002807617000)},
    {_DATAF(-0.67411231994628906000), _DATAF(-0.73862886428833008000)},
    {_DATAF(-0.67439550161361694000), _DATAF(-0.73837029933929443000)},
    {_DATAF(-0.67467862367630005000), _DATAF(-0.73811161518096924000)},
    {_DATAF(-0.67496162652969360000), _DATAF(-0.73785281181335449000)},
    {_DATAF(-0.67524456977844238000), _DATAF(-0.73759388923645020000)},
    {_DATAF(-0.67552739381790161000), _DATAF(-0.73733490705490112000)},
    {_DATAF(-0.67581009864807129000), _DATAF(-0.73707580566406250000)},
    {_DATAF(-0.67609268426895142000), _DATAF(-0.73681658506393433000)},
    {_DATAF(-0.67637521028518677000), _DATAF(-0.73655724525451660000)},
    {_DATAF(-0.67665761709213257000), _DATAF(-0.73629778623580933000)},
    {_DATAF(-0.67693996429443359000), _DATAF(-0.73603826761245728000)},
    {_DATAF(-0.67722219228744507000), _DATAF(-0.73577857017517090000)},
    {_DATAF(-0.67750430107116699000), _DATAF(-0.73551881313323975000)},
    {_DATAF(-0.67778629064559937000), _DATAF(-0.73525893688201904000)},
    {_DATAF(-0.67806822061538696000), _DATAF(-0.73499894142150879000)},
    {_DATAF(-0.67835003137588501000), _DATAF(-0.73473888635635376000)},
    {_DATAF(-0.67863178253173828000), _DATAF(-0.73447865247726440000)},
    {_DATAF(-0.67891335487365723000), _DATAF(-0.73421835899353027000)},
    {_DATAF(-0.67919492721557617000), _DATAF(-0.73395794630050659000)},
    {_DATAF(-0.67947632074356079000), _DATAF(-0.73369741439819336000)},
    {_DATAF(-0.67975765466690063000), _DATAF(-0.73343682289123535000)},
    {_DATAF(-0.68003886938095093000), _DATAF(-0.73317605257034302000)},
    {_DATAF(-0.68031996488571167000), _DATAF(-0.73291522264480591000)},
    {_DATAF(-0.68060100078582764000), _DATAF(-0.73265427350997925000)},
    {_DATAF(-0.68088191747665405000), _DATAF(-0.73239320516586304000)},
    {_DATAF(-0.68116271495819092000), _DATAF(-0.73213201761245728000)},
    {_DATAF(-0.68144345283508301000), _DATAF(-0.73187077045440674000)},
    {_DATAF(-0.68172407150268555000), _DATAF(-0.73160940408706665000)},
    {_DATAF(-0.68200457096099854000), _DATAF(-0.73134791851043701000)},
    {_DATAF(-0.68228501081466675000), _DATAF(-0.73108631372451782000)},
    {_DATAF(-0.68256533145904541000), _DATAF(-0.73082458972930908000)},
    {_DATAF(-0.68284553289413452000), _DATAF(-0.73056274652481079000)},
    {_DATAF(-0.68312567472457886000), _DATAF(-0.73030084371566772000)},
    {_DATAF(-0.68340569734573364000), _DATAF(-0.73003882169723511000)},
    {_DATAF(-0.68368560075759888000), _DATAF(-0.72977668046951294000)},
    {_DATAF(-0.68396538496017456000), _DATAF(-0.72951442003250122000)},
    {_DATAF(-0.68424510955810547000), _DATAF(-0.72925209999084473000)},
    {_DATAF(-0.68452471494674683000), _DATAF(-0.72898960113525391000)},
    {_DATAF(-0.68480426073074341000), _DATAF(-0.72872704267501831000)},
    {_DATAF(-0.68508368730545044000), _DATAF(-0.72846436500549316000)},
    {_DATAF(-0.68536299467086792000), _DATAF(-0.72820162773132324000)},
    {_DATAF(-0.68564218282699585000), _DATAF(-0.72793871164321899000)},
    {_DATAF(-0.68592131137847900000), _DATAF(-0.72767573595046997000)},
    {_DATAF(-0.68620032072067261000), _DATAF(-0.72741264104843140000)},
    {_DATAF(-0.68647921085357666000), _DATAF(-0.72714942693710327000)},
    {_DATAF(-0.68675804138183594000), _DATAF(-0.72688609361648560000)},
    {_DATAF(-0.68703675270080566000), _DATAF(-0.72662270069122314000)},
    {_DATAF(-0.68731534481048584000), _DATAF(-0.72635912895202637000)},
    {_DATAF(-0.68759381771087646000), _DATAF(-0.72609549760818481000)},
    {_DATAF(-0.68787223100662231000), _DATAF(-0.72583180665969849000)},
    {_DATAF(-0.68815052509307861000), _DATAF(-0.72556793689727783000)},
    {_DATAF(-0.68842875957489014000), _DATAF(-0.72530394792556763000)},
    {_DATAF(-0.68870687484741211000), _DATAF(-0.72503989934921265000)},
    {_DATAF(-0.68898487091064453000), _DATAF(-0.72477573156356812000)},
    {_DATAF(-0.68926274776458740000), _DATAF(-0.72451144456863403000)},
    {_DATAF(-0.68954056501388550000), _DATAF(-0.72424709796905518000)},
    {_DATAF(-0.68981826305389404000), _DATAF(-0.72398257255554199000)},
    {_DATAF(-0.69009584188461304000), _DATAF(-0.72371798753738403000)},
    {_DATAF(-0.69037330150604248000), _DATAF(-0.72345328330993652000)},
    {_DATAF(-0.69065070152282715000), _DATAF(-0.72318845987319946000)},
    {_DATAF(-0.69092798233032227000), _DATAF(-0.72292357683181763000)},
    {_DATAF(-0.69120520353317261000), _DATAF(-0.72265857458114624000)},
    {_DATAF(-0.69148224592208862000), _DATAF(-0.72239345312118530000)},
    {_DATAF(-0.69175922870635986000), _DATAF(-0.72212821245193481000)},
    {_DATAF(-0.69203615188598633000), _DATAF(-0.72186285257339478000)},
    {_DATAF(-0.69231289625167847000), _DATAF(-0.72159743309020996000)},
    {_DATAF(-0.69258958101272583000), _DATAF(-0.72133183479309082000)},
    {_DATAF(-0.69286614656448364000), _DATAF(-0.72106617689132690000)},
    {_DATAF(-0.69314265251159668000), _DATAF(-0.72080045938491821000)},
    {_DATAF(-0.69341903924942017000), _DATAF(-0.72053456306457520000)},
    {_DATAF(-0.69369530677795410000), _DATAF(-0.72026860713958740000)},
    {_DATAF(-0.69397145509719849000), _DATAF(-0.72000253200531006000)},
    {_DATAF(-0.69424754381179810000), _DATAF(-0.71973633766174316000)},
    {_DATAF(-0.69452351331710815000), _DATAF(-0.71947002410888672000)},
    {_DATAF(-0.69479936361312866000), _DATAF(-0.71920365095138550000)},
    {_DATAF(-0.69507509469985962000), _DATAF(-0.71893709897994995000)},
    {_DATAF(-0.69535076618194580000), _DATAF(-0.71867048740386963000)},
    {_DATAF(-0.69562631845474243000), _DATAF(-0.71840381622314453000)},
    {_DATAF(-0.69590175151824951000), _DATAF(-0.71813696622848511000)},
    {_DATAF(-0.69617712497711182000), _DATAF(-0.71787005662918091000)},
    {_DATAF(-0.69645237922668457000), _DATAF(-0.71760302782058716000)},
    {_DATAF(-0.69672751426696777000), _DATAF(-0.71733587980270386000)},
    {_DATAF(-0.69700258970260620000), _DATAF(-0.71706861257553101000)},
    {_DATAF(-0.69727748632431030000), _DATAF(-0.71680128574371338000)},
    {_DATAF(-0.69755232334136963000), _DATAF(-0.71653383970260620000)},
    {_DATAF(-0.69782710075378418000), _DATAF(-0.71626627445220947000)},
    {_DATAF(-0.69810169935226440000), _DATAF(-0.71599858999252319000)},
    {_DATAF(-0.69837623834609985000), _DATAF(-0.71573084592819214000)},
    {_DATAF(-0.69865065813064575000), _DATAF(-0.71546292304992676000)},
    {_DATAF(-0.69892501831054688000), _DATAF(-0.71519494056701660000)},
    {_DATAF(-0.69919919967651367000), _DATAF(-0.71492689847946167000)},
    {_DATAF(-0.69947332143783569000), _DATAF(-0.71465867757797241000)},
    {_DATAF(-0.69974738359451294000), _DATAF(-0.71439039707183838000)},
    {_DATAF(-0.70002126693725586000), _DATAF(-0.71412199735641479000)},
    {_DATAF(-0.70029509067535400000), _DATAF(-0.71385347843170166000)},
    {_DATAF(-0.70056879520416260000), _DATAF(-0.71358484029769897000)},
    {_DATAF(-0.70084238052368164000), _DATAF(-0.71331614255905151000)},
    {_DATAF(-0.70111590623855591000), _DATAF(-0.71304732561111450000)},
    {_DATAF(-0.70138931274414063000), _DATAF(-0.71277838945388794000)},
    {_DATAF(-0.70166260004043579000), _DATAF(-0.71250939369201660000)},
    {_DATAF(-0.70193576812744141000), _DATAF(-0.71224021911621094000)},
    {_DATAF(-0.70220887660980225000), _DATAF(-0.71197098493576050000)},
    {_DATAF(-0.70248186588287354000), _DATAF(-0.71170163154602051000)},
    {_DATAF(-0.70275473594665527000), _DATAF(-0.71143221855163574000)},
    {_DATAF(-0.70302754640579224000), _DATAF(-0.71116262674331665000)},
    {_DATAF(-0.70330017805099487000), _DATAF(-0.71089297533035278000)},
    {_DATAF(-0.70357275009155273000), _DATAF(-0.71062320470809937000)},
    {_DATAF(-0.70384526252746582000), _DATAF(-0.71035337448120117000)},
    {_DATAF(-0.70411759614944458000), _DATAF(-0.71008336544036865000)},
    {_DATAF(-0.70438987016677856000), _DATAF(-0.70981329679489136000)},
    {_DATAF(-0.70466202497482300000), _DATAF(-0.70954310894012451000)},
    {_DATAF(-0.70493406057357788000), _DATAF(-0.70927280187606812000)},
    {_DATAF(-0.70520603656768799000), _DATAF(-0.70900243520736694000)},
    {_DATAF(-0.70547789335250854000), _DATAF(-0.70873194932937622000)},
    {_DATAF(-0.70574963092803955000), _DATAF(-0.70846134424209595000)},
    {_DATAF(-0.70602124929428101000), _DATAF(-0.70819061994552612000)},
    {_DATAF(-0.70629280805587769000), _DATAF(-0.70791983604431152000)},
    {_DATAF(-0.70656424760818481000), _DATAF(-0.70764893293380737000)},
    {_DATAF(-0.70683556795120239000), _DATAF(-0.70737791061401367000)},
    {_DATAF(-0.70710676908493042000), _DATAF(-0.70710676908493042000)},
    {_DATAF(-0.70737791061401367000), _DATAF(-0.70683556795120239000)},
    {_DATAF(-0.70764893293380737000), _DATAF(-0.70656424760818481000)},
    {_DATAF(-0.70791983604431152000), _DATAF(-0.70629280805587769000)},
    {_DATAF(-0.70819061994552612000), _DATAF(-0.70602124929428101000)},
    {_DATAF(-0.70846134424209595000), _DATAF(-0.70574963092803955000)},
    {_DATAF(-0.70873194932937622000), _DATAF(-0.70547789335250854000)},
    {_DATAF(-0.70900243520736694000), _DATAF(-0.70520603656768799000)},
    {_DATAF(-0.70927280187606812000), _DATAF(-0.70493406057357788000)},
    {_DATAF(-0.70954310894012451000), _DATAF(-0.70466202497482300000)},
    {_DATAF(-0.70981329679489136000), _DATAF(-0.70438987016677856000)},
    {_DATAF(-0.71008336544036865000), _DATAF(-0.70411759614944458000)},
    {_DATAF(-0.71035337448120117000), _DATAF(-0.70384526252746582000)},
    {_DATAF(-0.71062320470809937000), _DATAF(-0.70357275009155273000)},
    {_DATAF(-0.71089297533035278000), _DATAF(-0.70330017805099487000)},
    {_DATAF(-0.71116262674331665000), _DATAF(-0.70302754640579224000)},
    {_DATAF(-0.71143221855163574000), _DATAF(-0.70275473594665527000)},
    {_DATAF(-0.71170163154602051000), _DATAF(-0.70248186588287354000)},
    {_DATAF(-0.71197098493576050000), _DATAF(-0.70220887660980225000)},
    {_DATAF(-0.71224021911621094000), _DATAF(-0.70193576812744141000)},
    {_DATAF(-0.71250939369201660000), _DATAF(-0.70166260004043579000)},
    {_DATAF(-0.71277838945388794000), _DATAF(-0.70138931274414063000)},
    {_DATAF(-0.71304732561111450000), _DATAF(-0.70111590623855591000)},
    {_DATAF(-0.71331614255905151000), _DATAF(-0.70084238052368164000)},
    {_DATAF(-0.71358484029769897000), _DATAF(-0.70056879520416260000)},
    {_DATAF(-0.71385347843170166000), _DATAF(-0.70029509067535400000)},
    {_DATAF(-0.71412199735641479000), _DATAF(-0.70002126693725586000)},
    {_DATAF(-0.71439039707183838000), _DATAF(-0.69974738359451294000)},
    {_DATAF(-0.71465867757797241000), _DATAF(-0.69947332143783569000)},
    {_DATAF(-0.71492689847946167000), _DATAF(-0.69919919967651367000)},
    {_DATAF(-0.71519494056701660000), _DATAF(-0.69892501831054688000)},
    {_DATAF(-0.71546292304992676000), _DATAF(-0.69865065813064575000)},
    {_DATAF(-0.71573084592819214000), _DATAF(-0.69837623834609985000)},
    {_DATAF(-0.71599858999252319000), _DATAF(-0.69810169935226440000)},
    {_DATAF(-0.71626627445220947000), _DATAF(-0.69782710075378418000)},
    {_DATAF(-0.71653383970260620000), _DATAF(-0.69755232334136963000)},
    {_DATAF(-0.71680128574371338000), _DATAF(-0.69727748632431030000)},
    {_DATAF(-0.71706861257553101000), _DATAF(-0.69700258970260620000)},
    {_DATAF(-0.71733587980270386000), _DATAF(-0.69672751426696777000)},
    {_DATAF(-0.71760302782058716000), _DATAF(-0.69645237922668457000)},
    {_DATAF(-0.71787005662918091000), _DATAF(-0.69617712497711182000)},
    {_DATAF(-0.71813696622848511000), _DATAF(-0.69590175151824951000)},
    {_DATAF(-0.71840381622314453000), _DATAF(-0.69562631845474243000)},
    {_DATAF(-0.71867048740386963000), _DATAF(-0.69535076618194580000)},
    {_DATAF(-0.71893709897994995000), _DATAF(-0.69507509469985962000)},
    {_DATAF(-0.71920365095138550000), _DATAF(-0.69479936361312866000)},
    {_DATAF(-0.71947002410888672000), _DATAF(-0.69452351331710815000)},
    {_DATAF(-0.71973633766174316000), _DATAF(-0.69424754381179810000)},
    {_DATAF(-0.72000253200531006000), _DATAF(-0.69397145509719849000)},
    {_DATAF(-0.72026860713958740000), _DATAF(-0.69369530677795410000)},
    {_DATAF(-0.72053456306457520000), _DATAF(-0.69341903924942017000)},
    {_DATAF(-0.72080045938491821000), _DATAF(-0.69314265251159668000)},
    {_DATAF(-0.72106617689132690000), _DATAF(-0.69286614656448364000)},
    {_DATAF(-0.72133183479309082000), _DATAF(-0.69258958101272583000)},
    {_DATAF(-0.72159743309020996000), _DATAF(-0.69231289625167847000)},
    {_DATAF(-0.72186285257339478000), _DATAF(-0.69203615188598633000)},
    {_DATAF(-0.72212821245193481000), _DATAF(-0.69175922870635986000)},
    {_DATAF(-0.72239345312118530000), _DATAF(-0.69148224592208862000)},
    {_DATAF(-0.72265857458114624000), _DATAF(-0.69120520353317261000)},
    {_DATAF(-0.72292357683181763000), _DATAF(-0.69092798233032227000)},
    {_DATAF(-0.72318845987319946000), _DATAF(-0.69065070152282715000)},
    {_DATAF(-0.72345328330993652000), _DATAF(-0.69037330150604248000)},
    {_DATAF(-0.72371798753738403000), _DATAF(-0.69009584188461304000)},
    {_DATAF(-0.72398257255554199000), _DATAF(-0.68981826305389404000)},
    {_DATAF(-0.72424709796905518000), _DATAF(-0.68954056501388550000)},
    {_DATAF(-0.72451144456863403000), _DATAF(-0.68926274776458740000)},
    {_DATAF(-0.72477573156356812000), _DATAF(-0.68898487091064453000)},
    {_DATAF(-0.72503989934921265000), _DATAF(-0.68870687484741211000)},
    {_DATAF(-0.72530394792556763000), _DATAF(-0.68842875957489014000)},
    {_DATAF(-0.72556793689727783000), _DATAF(-0.68815052509307861000)},
    {_DATAF(-0.72583180665969849000), _DATAF(-0.68787223100662231000)},
    {_DATAF(-0.72609549760818481000), _DATAF(-0.68759381771087646000)},
    {_DATAF(-0.72635912895202637000), _DATAF(-0.68731534481048584000)},
    {_DATAF(-0.72662270069122314000), _DATAF(-0.68703675270080566000)},
    {_DATAF(-0.72688609361648560000), _DATAF(-0.68675804138183594000)},
    {_DATAF(-0.72714942693710327000), _DATAF(-0.68647921085357666000)},
    {_DATAF(-0.72741264104843140000), _DATAF(-0.68620032072067261000)},
    {_DATAF(-0.72767573595046997000), _DATAF(-0.68592131137847900000)},
    {_DATAF(-0.72793871164321899000), _DATAF(-0.68564218282699585000)},
    {_DATAF(-0.72820162773132324000), _DATAF(-0.68536299467086792000)},
    {_DATAF(-0.72846436500549316000), _DATAF(-0.68508368730545044000)},
    {_DATAF(-0.72872704267501831000), _DATAF(-0.68480426073074341000)},
    {_DATAF(-0.72898960113525391000), _DATAF(-0.68452471494674683000)},
    {_DATAF(-0.72925209999084473000), _DATAF(-0.68424510955810547000)},
    {_DATAF(-0.72951442003250122000), _DATAF(-0.68396538496017456000)},
    {_DATAF(-0.72977668046951294000), _DATAF(-0.68368560075759888000)},
    {_DATAF(-0.73003882169723511000), _DATAF(-0.68340569734573364000)},
    {_DATAF(-0.73030084371566772000), _DATAF(-0.68312567472457886000)},
    {_DATAF(-0.73056274652481079000), _DATAF(-0.68284553289413452000)},
    {_DATAF(-0.73082458972930908000), _DATAF(-0.68256533145904541000)},
    {_DATAF(-0.73108631372451782000), _DATAF(-0.68228501081466675000)},
    {_DATAF(-0.73134791851043701000), _DATAF(-0.68200457096099854000)},
    {_DATAF(-0.73160940408706665000), _DATAF(-0.68172407150268555000)},
    {_DATAF(-0.73187077045440674000), _DATAF(-0.68144345283508301000)},
    {_DATAF(-0.73213201761245728000), _DATAF(-0.68116271495819092000)},
    {_DATAF(-0.73239320516586304000), _DATAF(-0.68088191747665405000)},
    {_DATAF(-0.73265427350997925000), _DATAF(-0.68060100078582764000)},
    {_DATAF(-0.73291522264480591000), _DATAF(-0.68031996488571167000)},
    {_DATAF(-0.73317605257034302000), _DATAF(-0.68003886938095093000)},
    {_DATAF(-0.73343682289123535000), _DATAF(-0.67975765466690063000)},
    {_DATAF(-0.73369741439819336000), _DATAF(-0.67947632074356079000)},
    {_DATAF(-0.73395794630050659000), _DATAF(-0.67919492721557617000)},
    {_DATAF(-0.73421835899353027000), _DATAF(-0.67891335487365723000)},
    {_DATAF(-0.73447865247726440000), _DATAF(-0.67863178253173828000)},
    {_DATAF(-0.73473888635635376000), _DATAF(-0.67835003137588501000)},
    {_DATAF(-0.73499894142150879000), _DATAF(-0.67806822061538696000)},
    {_DATAF(-0.73525893688201904000), _DATAF(-0.67778629064559937000)},
    {_DATAF(-0.73551881313323975000), _DATAF(-0.67750430107116699000)},
    {_DATAF(-0.73577857017517090000), _DATAF(-0.67722219228744507000)},
    {_DATAF(-0.73603826761245728000), _DATAF(-0.67693996429443359000)},
    {_DATAF(-0.73629778623580933000), _DATAF(-0.67665761709213257000)},
    {_DATAF(-0.73655724525451660000), _DATAF(-0.67637521028518677000)},
    {_DATAF(-0.73681658506393433000), _DATAF(-0.67609268426895142000)},
    {_DATAF(-0.73707580566406250000), _DATAF(-0.67581009864807129000)},
    {_DATAF(-0.73733490705490112000), _DATAF(-0.67552739381790161000)},
    {_DATAF(-0.73759388923645020000), _DATAF(-0.67524456977844238000)},
    {_DATAF(-0.73785281181335449000), _DATAF(-0.67496162652969360000)},
    {_DATAF(-0.73811161518096924000), _DATAF(-0.67467862367630005000)},
    {_DATAF(-0.73837029933929443000), _DATAF(-0.67439550161361694000)},
    {_DATAF(-0.73862886428833008000), _DATAF(-0.67411231994628906000)},
    {_DATAF(-0.73888731002807617000), _DATAF(-0.67382901906967163000)},
    {_DATAF(-0.73914569616317749000), _DATAF(-0.67354559898376465000)},
    {_DATAF(-0.73940390348434448000), _DATAF(-0.67326205968856812000)},
    {_DATAF(-0.73966205120086670000), _DATAF(-0.67297846078872681000)},
    {_DATAF(-0.73992007970809937000), _DATAF(-0.67269474267959595000)},
    {_DATAF(-0.74017798900604248000), _DATAF(-0.67241096496582031000)},
    {_DATAF(-0.74043583869934082000), _DATAF(-0.67212706804275513000)},
    {_DATAF(-0.74069350957870483000), _DATAF(-0.67184305191040039000)},
    {_DATAF(-0.74095112085342407000), _DATAF(-0.67155897617340088000)},
    {_DATAF(-0.74120861291885376000), _DATAF(-0.67127478122711182000)},
    {_DATAF(-0.74146598577499390000), _DATAF(-0.67099046707153320000)},
    {_DATAF(-0.74172323942184448000), _DATAF(-0.67070603370666504000)},
    {_DATAF(-0.74198043346405029000), _DATAF(-0.67042154073715210000)},
    {_DATAF(-0.74223744869232178000), _DATAF(-0.67013698816299438000)},
    {_DATAF(-0.74249440431594849000), _DATAF(-0.66985225677490234000)},
    {_DATAF(-0.74275124073028564000), _DATAF(-0.66956746578216553000)},
    {_DATAF(-0.74300795793533325000), _DATAF(-0.66928261518478394000)},
    {_DATAF(-0.74326455593109131000), _DATAF(-0.66899758577346802000)},
    {_DATAF(-0.74352109432220459000), _DATAF(-0.66871249675750732000)},
    {_DATAF(-0.74377745389938354000), _DATAF(-0.66842734813690186000)},
    {_DATAF(-0.74403375387191772000), _DATAF(-0.66814202070236206000)},
    {_DATAF(-0.74428993463516235000), _DATAF(-0.66785663366317749000)},
    {_DATAF(-0.74454599618911743000), _DATAF(-0.66757118701934814000)},
    {_DATAF(-0.74480193853378296000), _DATAF(-0.66728562116622925000)},
    {_DATAF(-0.74505776166915894000), _DATAF(-0.66699993610382080000)},
    {_DATAF(-0.74531352519989014000), _DATAF(-0.66671413183212280000)},
    {_DATAF(-0.74556916952133179000), _DATAF(-0.66642826795578003000)},
    {_DATAF(-0.74582469463348389000), _DATAF(-0.66614228487014771000)},
    {_DATAF(-0.74608010053634644000), _DATAF(-0.66585624217987061000)},
    {_DATAF(-0.74633538722991943000), _DATAF(-0.66557008028030396000)},
    {_DATAF(-0.74659055471420288000), _DATAF(-0.66528379917144775000)},
    {_DATAF(-0.74684566259384155000), _DATAF(-0.66499745845794678000)},
    {_DATAF(-0.74710059165954590000), _DATAF(-0.66471099853515625000)},
    {_DATAF(-0.74735546112060547000), _DATAF(-0.66442441940307617000)},
    {_DATAF(-0.74761021137237549000), _DATAF(-0.66413778066635132000)},
    {_DATAF(-0.74786484241485596000), _DATAF(-0.66385102272033691000)},
    {_DATAF(-0.74811935424804688000), _DATAF(-0.66356414556503296000)},
    {_DATAF(-0.74837380647659302000), _DATAF(-0.66327720880508423000)},
    {_DATAF(-0.74862807989120483000), _DATAF(-0.66299015283584595000)},
    {_DATAF(-0.74888229370117188000), _DATAF(-0.66270303726196289000)},
    {_DATAF(-0.74913638830184937000), _DATAF(-0.66241580247879028000)},
    {_DATAF(-0.74939036369323730000), _DATAF(-0.66212844848632813000)},
    {_DATAF(-0.74964421987533569000), _DATAF(-0.66184097528457642000)},
    {_DATAF(-0.74989801645278931000), _DATAF(-0.66155344247817993000)},
    {_DATAF(-0.75015163421630859000), _DATAF(-0.66126585006713867000)},
    {_DATAF(-0.75040519237518311000), _DATAF(-0.66097813844680786000)},
    {_DATAF(-0.75065863132476807000), _DATAF(-0.66069030761718750000)},
    {_DATAF(-0.75091195106506348000), _DATAF(-0.66040235757827759000)},
    {_DATAF(-0.75116515159606934000), _DATAF(-0.66011434793472290000)},
    {_DATAF(-0.75141823291778564000), _DATAF(-0.65982621908187866000)},
    {_DATAF(-0.75167119503021240000), _DATAF(-0.65953803062438965000)},
    {_DATAF(-0.75192409753799438000), _DATAF(-0.65924972295761108000)},
    {_DATAF(-0.75217682123184204000), _DATAF(-0.65896129608154297000)},
    {_DATAF(-0.75242948532104492000), _DATAF(-0.65867280960083008000)},
    {_DATAF(-0.75268203020095825000), _DATAF(-0.65838420391082764000)},
    {_DATAF(-0.75293445587158203000), _DATAF(-0.65809547901153564000)},
    {_DATAF(-0.75318682193756104000), _DATAF(-0.65780669450759888000)},
    {_DATAF(-0.75343900918960571000), _DATAF(-0.65751779079437256000)},
    {_DATAF(-0.75369113683700562000), _DATAF(-0.65722882747650146000)},
    {_DATAF(-0.75394308567047119000), _DATAF(-0.65693974494934082000)},
    {_DATAF(-0.75419497489929199000), _DATAF(-0.65665054321289063000)},
    {_DATAF(-0.75444674491882324000), _DATAF(-0.65636128187179565000)},
    {_DATAF(-0.75469839572906494000), _DATAF(-0.65607190132141113000)},
    {_DATAF(-0.75494992733001709000), _DATAF(-0.65578240156173706000)},
    {_DATAF(-0.75520139932632446000), _DATAF(-0.65549284219741821000)},
    {_DATAF(-0.75545269250869751000), _DATAF(-0.65520316362380981000)},
    {_DATAF(-0.75570392608642578000), _DATAF(-0.65491342544555664000)},
    {_DATAF(-0.75595504045486450000), _DATAF(-0.65462356805801392000)},
    {_DATAF(-0.75620597600936890000), _DATAF(-0.65433359146118164000)},
    {_DATAF(-0.75645685195922852000), _DATAF(-0.65404355525970459000)},
    {_DATAF(-0.75670766830444336000), _DATAF(-0.65375339984893799000)},
    {_DATAF(-0.75695830583572388000), _DATAF(-0.65346318483352661000)},
    {_DATAF(-0.75720882415771484000), _DATAF(-0.65317285060882568000)},
    {_DATAF(-0.75745928287506104000), _DATAF(-0.65288239717483521000)},
    {_DATAF(-0.75770962238311768000), _DATAF(-0.65259188413619995000)},
    {_DATAF(-0.75795978307723999000), _DATAF(-0.65230125188827515000)},
    {_DATAF(-0.75820988416671753000), _DATAF(-0.65201056003570557000)},
    {_DATAF(-0.75845992565155029000), _DATAF(-0.65171968936920166000)},
    {_DATAF(-0.75870978832244873000), _DATAF(-0.65142881870269775000)},
    {_DATAF(-0.75895953178405762000), _DATAF(-0.65113776922225952000)},
    {_DATAF(-0.75920921564102173000), _DATAF(-0.65084666013717651000)},
    {_DATAF(-0.75945872068405151000), _DATAF(-0.65055549144744873000)},
    {_DATAF(-0.75970816612243652000), _DATAF(-0.65026420354843140000)},
    {_DATAF(-0.75995749235153198000), _DATAF(-0.64997279644012451000)},
    {_DATAF(-0.76020669937133789000), _DATAF(-0.64968132972717285000)},
    {_DATAF(-0.76045578718185425000), _DATAF(-0.64938974380493164000)},
    {_DATAF(-0.76070475578308105000), _DATAF(-0.64909803867340088000)},
    {_DATAF(-0.76095360517501831000), _DATAF(-0.64880627393722534000)},
    {_DATAF(-0.76120239496231079000), _DATAF(-0.64851438999176025000)},
    {_DATAF(-0.76145100593566895000), _DATAF(-0.64822244644165039000)},
    {_DATAF(-0.76169955730438232000), _DATAF(-0.64793038368225098000)},
    {_DATAF(-0.76194798946380615000), _DATAF(-0.64763820171356201000)},
    {_DATAF(-0.76219630241394043000), _DATAF(-0.64734596014022827000)},
    {_DATAF(-0.76244449615478516000), _DATAF(-0.64705359935760498000)},
    {_DATAF(-0.76269257068634033000), _DATAF(-0.64676117897033691000)},
    {_DATAF(-0.76294052600860596000), _DATAF(-0.64646863937377930000)},
    {_DATAF(-0.76318842172622681000), _DATAF(-0.64617604017257690000)},
    {_DATAF(-0.76343613862991333000), _DATAF(-0.64588326215744019000)},
    {_DATAF(-0.76368379592895508000), _DATAF(-0.64559048414230347000)},
    {_DATAF(-0.76393133401870728000), _DATAF(-0.64529752731323242000)},
    {_DATAF(-0.76417875289916992000), _DATAF(-0.64500451087951660000)},
    {_DATAF(-0.76442605257034302000), _DATAF(-0.64471143484115601000)},
    {_DATAF(-0.76467323303222656000), _DATAF(-0.64441823959350586000)},
    {_DATAF(-0.76492029428482056000), _DATAF(-0.64412492513656616000)},
    {_DATAF(-0.76516723632812500000), _DATAF(-0.64383155107498169000)},
    {_DATAF(-0.76541411876678467000), _DATAF(-0.64353805780410767000)},
    {_DATAF(-0.76566088199615479000), _DATAF(-0.64324450492858887000)},
    {_DATAF(-0.76590746641159058000), _DATAF(-0.64295083284378052000)},
    {_DATAF(-0.76615399122238159000), _DATAF(-0.64265704154968262000)},
    {_DATAF(-0.76640039682388306000), _DATAF(-0.64236319065093994000)},
    {_DATAF(-0.76664668321609497000), _DATAF(-0.64206922054290771000)},
    {_DATAF(-0.76689285039901733000), _DATAF(-0.64177513122558594000)},
    {_DATAF(-0.76713889837265015000), _DATAF(-0.64148104190826416000)},
    {_DATAF(-0.76738488674163818000), _DATAF(-0.64118677377700806000)},
    {_DATAF(-0.76763069629669189000), _DATAF(-0.64089244604110718000)},
    {_DATAF(-0.76787644624710083000), _DATAF(-0.64059799909591675000)},
    {_DATAF(-0.76812201738357544000), _DATAF(-0.64030349254608154000)},
    {_DATAF(-0.76836752891540527000), _DATAF(-0.64000886678695679000)},
    {_DATAF(-0.76861292123794556000), _DATAF(-0.63971418142318726000)},
    {_DATAF(-0.76885819435119629000), _DATAF(-0.63941931724548340000)},
    {_DATAF(-0.76910334825515747000), _DATAF(-0.63912445306777954000)},
    {_DATAF(-0.76934838294982910000), _DATAF(-0.63882946968078613000)},
    {_DATAF(-0.76959329843521118000), _DATAF(-0.63853436708450317000)},
    {_DATAF(-0.76983815431594849000), _DATAF(-0.63823920488357544000)},
    {_DATAF(-0.77008283138275146000), _DATAF(-0.63794392347335815000)},
    {_DATAF(-0.77032744884490967000), _DATAF(-0.63764852285385132000)},
    {_DATAF(-0.77057188749313354000), _DATAF(-0.63735306262969971000)},
    {_DATAF(-0.77081626653671265000), _DATAF(-0.63705748319625854000)},
    {_DATAF(-0.77106052637100220000), _DATAF(-0.63676184415817261000)},
    {_DATAF(-0.77130466699600220000), _DATAF(-0.63646614551544189000)},
    {_DATAF(-0.77154868841171265000), _DATAF(-0.63617026805877686000)},
    {_DATAF(-0.77179259061813354000), _DATAF(-0.63587433099746704000)},
    {_DATAF(-0.77203637361526489000), _DATAF(-0.63557833433151245000)},
    {_DATAF(-0.77228009700775146000), _DATAF(-0.63528221845626831000)},
    {_DATAF(-0.77252364158630371000), _DATAF(-0.63498598337173462000)},
    {_DATAF(-0.77276712656021118000), _DATAF(-0.63468968868255615000)},
    {_DATAF(-0.77301043272018433000), _DATAF(-0.63439327478408813000)},
    {_DATAF(-0.77325367927551270000), _DATAF(-0.63409680128097534000)},
    {_DATAF(-0.77349680662155151000), _DATAF(-0.63380020856857300000)},
    {_DATAF(-0.77373981475830078000), _DATAF(-0.63350355625152588000)},
    {_DATAF(-0.77398270368576050000), _DATAF(-0.63320678472518921000)},
    {_DATAF(-0.77422547340393066000), _DATAF(-0.63290989398956299000)},
    {_DATAF(-0.77446812391281128000), _DATAF(-0.63261294364929199000)},
    {_DATAF(-0.77471065521240234000), _DATAF(-0.63231587409973145000)},
    {_DATAF(-0.77495312690734863000), _DATAF(-0.63201874494552612000)},
    {_DATAF(-0.77519541978836060000), _DATAF(-0.63172149658203125000)},
    {_DATAF(-0.77543765306472778000), _DATAF(-0.63142418861389160000)},
    {_DATAF(-0.77567970752716064000), _DATAF(-0.63112676143646240000)},
    {_DATAF(-0.77592170238494873000), _DATAF(-0.63082921504974365000)},
    {_DATAF(-0.77616357803344727000), _DATAF(-0.63053160905838013000)},
    {_DATAF(-0.77640533447265625000), _DATAF(-0.63023394346237183000)},
    {_DATAF(-0.77664697170257568000), _DATAF(-0.62993609905242920000)},
    {_DATAF(-0.77688848972320557000), _DATAF(-0.62963825464248657000)},
    {_DATAF(-0.77712988853454590000), _DATAF(-0.62934023141860962000)},
    {_DATAF(-0.77737116813659668000), _DATAF(-0.62904220819473267000)},
    {_DATAF(-0.77761232852935791000), _DATAF(-0.62874400615692139000)},
    {_DATAF(-0.77785342931747437000), _DATAF(-0.62844574451446533000)},
    {_DATAF(-0.77809435129165649000), _DATAF(-0.62814742326736450000)},
    {_DATAF(-0.77833521366119385000), _DATAF(-0.62784898281097412000)},
    {_DATAF(-0.77857589721679688000), _DATAF(-0.62755042314529419000)},
    {_DATAF(-0.77881652116775513000), _DATAF(-0.62725180387496948000)},
    {_DATAF(-0.77905702590942383000), _DATAF(-0.62695312500000000000)},
    {_DATAF(-0.77929735183715820000), _DATAF(-0.62665426731109619000)},
    {_DATAF(-0.77953761816024780000), _DATAF(-0.62635540962219238000)},
    {_DATAF(-0.77977776527404785000), _DATAF(-0.62605637311935425000)},
    {_DATAF(-0.78001779317855835000), _DATAF(-0.62575727701187134000)},
    {_DATAF(-0.78025776147842407000), _DATAF(-0.62545812129974365000)},
    {_DATAF(-0.78049755096435547000), _DATAF(-0.62515884637832642000)},
    {_DATAF(-0.78073722124099731000), _DATAF(-0.62485951185226440000)},
    {_DATAF(-0.78097677230834961000), _DATAF(-0.62456005811691284000)},
    {_DATAF(-0.78121626377105713000), _DATAF(-0.62426048517227173000)},
    {_DATAF(-0.78145557641983032000), _DATAF(-0.62396085262298584000)},
    {_DATAF(-0.78169482946395874000), _DATAF(-0.62366110086441040000)},
    {_DATAF(-0.78193396329879761000), _DATAF(-0.62336128950119019000)},
    {_DATAF(-0.78217291831970215000), _DATAF(-0.62306135892868042000)},
    {_DATAF(-0.78241181373596191000), _DATAF(-0.62276136875152588000)},
    {_DATAF(-0.78265058994293213000), _DATAF(-0.62246125936508179000)},
    {_DATAF(-0.78288924694061279000), _DATAF(-0.62216109037399292000)},
    {_DATAF(-0.78312778472900391000), _DATAF(-0.62186080217361450000)},
    {_DATAF(-0.78336620330810547000), _DATAF(-0.62156045436859131000)},
    {_DATAF(-0.78360450267791748000), _DATAF(-0.62125998735427856000)},
    {_DATAF(-0.78384268283843994000), _DATAF(-0.62095940113067627000)},
    {_DATAF(-0.78408080339431763000), _DATAF(-0.62065875530242920000)},
    {_DATAF(-0.78431874513626099000), _DATAF(-0.62035804986953735000)},
    {_DATAF(-0.78455656766891479000), _DATAF(-0.62005722522735596000)},
    {_DATAF(-0.78479433059692383000), _DATAF(-0.61975628137588501000)},
    {_DATAF(-0.78503191471099854000), _DATAF(-0.61945527791976929000)},
    {_DATAF(-0.78526943922042847000), _DATAF(-0.61915415525436401000)},
    {_DATAF(-0.78550684452056885000), _DATAF(-0.61885297298431396000)},
    {_DATAF(-0.78574407100677490000), _DATAF(-0.61855173110961914000)},
    {_DATAF(-0.78598123788833618000), _DATAF(-0.61825031042098999000)},
    {_DATAF(-0.78621828556060791000), _DATAF(-0.61794888973236084000)},
    {_DATAF(-0.78645521402359009000), _DATAF(-0.61764729022979736000)},
    {_DATAF(-0.78669202327728271000), _DATAF(-0.61734563112258911000)},
    {_DATAF(-0.78692871332168579000), _DATAF(-0.61704391241073608000)},
    {_DATAF(-0.78716528415679932000), _DATAF(-0.61674207448959351000)},
    {_DATAF(-0.78740173578262329000), _DATAF(-0.61644017696380615000)},
    {_DATAF(-0.78763806819915771000), _DATAF(-0.61613816022872925000)},
    {_DATAF(-0.78787434101104736000), _DATAF(-0.61583608388900757000)},
    {_DATAF(-0.78811043500900269000), _DATAF(-0.61553388833999634000)},
    {_DATAF(-0.78834640979766846000), _DATAF(-0.61523157358169556000)},
    {_DATAF(-0.78858232498168945000), _DATAF(-0.61492919921875000000)},
    {_DATAF(-0.78881806135177612000), _DATAF(-0.61462676525115967000)},
    {_DATAF(-0.78905373811721802000), _DATAF(-0.61432421207427979000)},
    {_DATAF(-0.78928923606872559000), _DATAF(-0.61402153968811035000)},
    {_DATAF(-0.78952467441558838000), _DATAF(-0.61371880769729614000)},
    {_DATAF(-0.78975999355316162000), _DATAF(-0.61341601610183716000)},
    {_DATAF(-0.78999513387680054000), _DATAF(-0.61311310529708862000)},
    {_DATAF(-0.79023021459579468000), _DATAF(-0.61281007528305054000)},
    {_DATAF(-0.79046517610549927000), _DATAF(-0.61250698566436768000)},
    {_DATAF(-0.79070001840591431000), _DATAF(-0.61220377683639526000)},
    {_DATAF(-0.79093474149703979000), _DATAF(-0.61190050840377808000)},
    {_DATAF(-0.79116934537887573000), _DATAF(-0.61159718036651611000)},
    {_DATAF(-0.79140383005142212000), _DATAF(-0.61129373311996460000)},
    {_DATAF(-0.79163819551467896000), _DATAF(-0.61099016666412354000)},
    {_DATAF(-0.79187244176864624000), _DATAF(-0.61068654060363770000)},
    {_DATAF(-0.79210656881332397000), _DATAF(-0.61038279533386230000)},
    {_DATAF(-0.79234057664871216000), _DATAF(-0.61007899045944214000)},
    {_DATAF(-0.79257452487945557000), _DATAF(-0.60977506637573242000)},
    {_DATAF(-0.79280829429626465000), _DATAF(-0.60947108268737793000)},
    {_DATAF(-0.79304194450378418000), _DATAF(-0.60916703939437866000)},
    {_DATAF(-0.79327553510665894000), _DATAF(-0.60886281728744507000)},
    {_DATAF(-0.79350894689559937000), _DATAF(-0.60855859518051147000)},
    {_DATAF(-0.79374229907989502000), _DATAF(-0.60825425386428833000)},
    {_DATAF(-0.79397547245025635000), _DATAF(-0.60794979333877563000)},
    {_DATAF(-0.79420858621597290000), _DATAF(-0.60764527320861816000)},
    {_DATAF(-0.79444152116775513000), _DATAF(-0.60734063386917114000)},
    {_DATAF(-0.79467439651489258000), _DATAF(-0.60703593492507935000)},
    {_DATAF(-0.79490715265274048000), _DATAF(-0.60673111677169800000)},
    {_DATAF(-0.79513972997665405000), _DATAF(-0.60642623901367188000)},
    {_DATAF(-0.79537224769592285000), _DATAF(-0.60612124204635620000)},
    {_DATAF(-0.79560464620590210000), _DATAF(-0.60581618547439575000)},
    {_DATAF(-0.79583692550659180000), _DATAF(-0.60551106929779053000)},
    {_DATAF(-0.79606908559799194000), _DATAF(-0.60520577430725098000)},
    {_DATAF(-0.79630106687545776000), _DATAF(-0.60490047931671143000)},
    {_DATAF(-0.79653298854827881000), _DATAF(-0.60459506511688232000)},
    {_DATAF(-0.79676479101181030000), _DATAF(-0.60428953170776367000)},
    {_DATAF(-0.79699647426605225000), _DATAF(-0.60398393869400024000)},
    {_DATAF(-0.79722803831100464000), _DATAF(-0.60367822647094727000)},
    {_DATAF(-0.79745948314666748000), _DATAF(-0.60337245464324951000)},
    {_DATAF(-0.79769086837768555000), _DATAF(-0.60306662321090698000)},
    {_DATAF(-0.79792207479476929000), _DATAF(-0.60276067256927490000)},
    {_DATAF(-0.79815316200256348000), _DATAF(-0.60245460271835327000)},
    {_DATAF(-0.79838413000106812000), _DATAF(-0.60214847326278687000)},
    {_DATAF(-0.79861497879028320000), _DATAF(-0.60184222459793091000)},
    {_DATAF(-0.79884576797485352000), _DATAF(-0.60153591632843018000)},
    {_DATAF(-0.79907637834548950000), _DATAF(-0.60122954845428467000)},
    {_DATAF(-0.79930686950683594000), _DATAF(-0.60092306137084961000)},
    {_DATAF(-0.79953724145889282000), _DATAF(-0.60061645507812500000)},
    {_DATAF(-0.79976755380630493000), _DATAF(-0.60030978918075562000)},
    {_DATAF(-0.79999768733978271000), _DATAF(-0.60000306367874146000)},
    {_DATAF(-0.80022776126861572000), _DATAF(-0.59969621896743774000)},
    {_DATAF(-0.80045765638351440000), _DATAF(-0.59938931465148926000)},
    {_DATAF(-0.80068749189376831000), _DATAF(-0.59908229112625122000)},
    {_DATAF(-0.80091714859008789000), _DATAF(-0.59877520799636841000)},
    {_DATAF(-0.80114674568176270000), _DATAF(-0.59846800565719604000)},
    {_DATAF(-0.80137616395950317000), _DATAF(-0.59816068410873413000)},
    {_DATAF(-0.80160552263259888000), _DATAF(-0.59785336256027222000)},
    {_DATAF(-0.80183470249176025000), _DATAF(-0.59754586219787598000)},
    {_DATAF(-0.80206382274627686000), _DATAF(-0.59723836183547974000)},
    {_DATAF(-0.80229282379150391000), _DATAF(-0.59693068265914917000)},
    {_DATAF(-0.80252164602279663000), _DATAF(-0.59662300348281860000)},
    {_DATAF(-0.80275040864944458000), _DATAF(-0.59631520509719849000)},
    {_DATAF(-0.80297905206680298000), _DATAF(-0.59600728750228882000)},
    {_DATAF(-0.80320751667022705000), _DATAF(-0.59569931030273438000)},
    {_DATAF(-0.80343592166900635000), _DATAF(-0.59539121389389038000)},
    {_DATAF(-0.80366420745849609000), _DATAF(-0.59508305788040161000)},
    {_DATAF(-0.80389231443405151000), _DATAF(-0.59477484226226807000)},
    {_DATAF(-0.80412036180496216000), _DATAF(-0.59446650743484497000)},
    {_DATAF(-0.80434828996658325000), _DATAF(-0.59415805339813232000)},
    {_DATAF(-0.80457609891891479000), _DATAF(-0.59384959936141968000)},
    {_DATAF(-0.80480378866195679000), _DATAF(-0.59354096651077271000)},
    {_DATAF(-0.80503135919570923000), _DATAF(-0.59323227405548096000)},
    {_DATAF(-0.80525875091552734000), _DATAF(-0.59292352199554443000)},
    {_DATAF(-0.80548608303070068000), _DATAF(-0.59261465072631836000)},
    {_DATAF(-0.80571329593658447000), _DATAF(-0.59230571985244751000)},
    {_DATAF(-0.80594038963317871000), _DATAF(-0.59199666976928711000)},
    {_DATAF(-0.80616736412048340000), _DATAF(-0.59168756008148193000)},
    {_DATAF(-0.80639421939849854000), _DATAF(-0.59137839078903198000)},
    {_DATAF(-0.80662095546722412000), _DATAF(-0.59106910228729248000)},
    {_DATAF(-0.80684757232666016000), _DATAF(-0.59075969457626343000)},
    {_DATAF(-0.80707406997680664000), _DATAF(-0.59045022726058960000)},
    {_DATAF(-0.80730044841766357000), _DATAF(-0.59014070034027100000)},
    {_DATAF(-0.80752670764923096000), _DATAF(-0.58983105421066284000)},
    {_DATAF(-0.80775284767150879000), _DATAF(-0.58952128887176514000)},
    {_DATAF(-0.80797880887985229000), _DATAF(-0.58921152353286743000)},
    {_DATAF(-0.80820471048355103000), _DATAF(-0.58890157938003540000)},
    {_DATAF(-0.80843049287796021000), _DATAF(-0.58859163522720337000)},
    {_DATAF(-0.80865615606307983000), _DATAF(-0.58828157186508179000)},
    {_DATAF(-0.80888170003890991000), _DATAF(-0.58797138929367065000)},
    {_DATAF(-0.80910712480545044000), _DATAF(-0.58766114711761475000)},
    {_DATAF(-0.80933243036270142000), _DATAF(-0.58735078573226929000)},
    {_DATAF(-0.80955761671066284000), _DATAF(-0.58704036474227905000)},
    {_DATAF(-0.80978268384933472000), _DATAF(-0.58672988414764404000)},
    {_DATAF(-0.81000763177871704000), _DATAF(-0.58641928434371948000)},
    {_DATAF(-0.81023246049880981000), _DATAF(-0.58610862493515015000)},
    {_DATAF(-0.81045717000961304000), _DATAF(-0.58579784631729126000)},
    {_DATAF(-0.81068176031112671000), _DATAF(-0.58548700809478760000)},
    {_DATAF(-0.81090623140335083000), _DATAF(-0.58517605066299438000)},
    {_DATAF(-0.81113064289093018000), _DATAF(-0.58486503362655640000)},
    {_DATAF(-0.81135487556457520000), _DATAF(-0.58455395698547363000)},
    {_DATAF(-0.81157898902893066000), _DATAF(-0.58424276113510132000)},
    {_DATAF(-0.81180298328399658000), _DATAF(-0.58393144607543945000)},
    {_DATAF(-0.81202685832977295000), _DATAF(-0.58362013101577759000)},
    {_DATAF(-0.81225061416625977000), _DATAF(-0.58330863714218140000)},
    {_DATAF(-0.81247425079345703000), _DATAF(-0.58299714326858521000)},
    {_DATAF(-0.81269776821136475000), _DATAF(-0.58268547058105469000)},
    {_DATAF(-0.81292116641998291000), _DATAF(-0.58237379789352417000)},
    {_DATAF(-0.81314438581466675000), _DATAF(-0.58206200599670410000)},
    {_DATAF(-0.81336754560470581000), _DATAF(-0.58175009489059448000)},
    {_DATAF(-0.81359058618545532000), _DATAF(-0.58143812417984009000)},
    {_DATAF(-0.81381350755691528000), _DATAF(-0.58112609386444092000)},
    {_DATAF(-0.81403630971908569000), _DATAF(-0.58081394433975220000)},
    {_DATAF(-0.81425899267196655000), _DATAF(-0.58050173521041870000)},
    {_DATAF(-0.81448155641555786000), _DATAF(-0.58018940687179565000)},
    {_DATAF(-0.81470400094985962000), _DATAF(-0.57987701892852783000)},
    {_DATAF(-0.81492632627487183000), _DATAF(-0.57956457138061523000)},
    {_DATAF(-0.81514853239059448000), _DATAF(-0.57925200462341309000)},
    {_DATAF(-0.81537061929702759000), _DATAF(-0.57893931865692139000)},
    {_DATAF(-0.81559258699417114000), _DATAF(-0.57862663269042969000)},
    {_DATAF(-0.81581443548202515000), _DATAF(-0.57831376791000366000)},
    {_DATAF(-0.81603610515594482000), _DATAF(-0.57800090312957764000)},
    {_DATAF(-0.81625771522521973000), _DATAF(-0.57768791913986206000)},
    {_DATAF(-0.81647920608520508000), _DATAF(-0.57737481594085693000)},
    {_DATAF(-0.81670057773590088000), _DATAF(-0.57706165313720703000)},
    {_DATAF(-0.81692183017730713000), _DATAF(-0.57674843072891235000)},
    {_DATAF(-0.81714290380477905000), _DATAF(-0.57643508911132813000)},
    {_DATAF(-0.81736391782760620000), _DATAF(-0.57612168788909912000)},
    {_DATAF(-0.81758481264114380000), _DATAF(-0.57580816745758057000)},
    {_DATAF(-0.81780558824539185000), _DATAF(-0.57549458742141724000)},
    {_DATAF(-0.81802618503570557000), _DATAF(-0.57518094778060913000)},
    {_DATAF(-0.81824672222137451000), _DATAF(-0.57486718893051147000)},
    {_DATAF(-0.81846714019775391000), _DATAF(-0.57455337047576904000)},
    {_DATAF(-0.81868737936019897000), _DATAF(-0.57423943281173706000)},
    {_DATAF(-0.81890755891799927000), _DATAF(-0.57392543554306030000)},
    {_DATAF(-0.81912761926651001000), _DATAF(-0.57361131906509399000)},
    {_DATAF(-0.81934750080108643000), _DATAF(-0.57329714298248291000)},
    {_DATAF(-0.81956732273101807000), _DATAF(-0.57298290729522705000)},
    {_DATAF(-0.81978696584701538000), _DATAF(-0.57266855239868164000)},
    {_DATAF(-0.82000654935836792000), _DATAF(-0.57235413789749146000)},
    {_DATAF(-0.82022595405578613000), _DATAF(-0.57203960418701172000)},
    {_DATAF(-0.82044529914855957000), _DATAF(-0.57172501087188721000)},
    {_DATAF(-0.82066446542739868000), _DATAF(-0.57141035795211792000)},
    {_DATAF(-0.82088357210159302000), _DATAF(-0.57109558582305908000)},
    {_DATAF(-0.82110249996185303000), _DATAF(-0.57078075408935547000)},
    {_DATAF(-0.82132136821746826000), _DATAF(-0.57046580314636230000)},
    {_DATAF(-0.82154005765914917000), _DATAF(-0.57015079259872437000)},
    {_DATAF(-0.82175862789154053000), _DATAF(-0.56983572244644165000)},
    {_DATAF(-0.82197713851928711000), _DATAF(-0.56952053308486938000)},
    {_DATAF(-0.82219547033309937000), _DATAF(-0.56920522451400757000)},
    {_DATAF(-0.82241368293762207000), _DATAF(-0.56888991594314575000)},
    {_DATAF(-0.82263177633285522000), _DATAF(-0.56857448816299438000)},
    {_DATAF(-0.82284981012344360000), _DATAF(-0.56825894117355347000)},
    {_DATAF(-0.82306766510009766000), _DATAF(-0.56794333457946777000)},
    {_DATAF(-0.82328540086746216000), _DATAF(-0.56762766838073730000)},
    {_DATAF(-0.82350301742553711000), _DATAF(-0.56731188297271729000)},
    {_DATAF(-0.82372051477432251000), _DATAF(-0.56699603796005249000)},
    {_DATAF(-0.82393789291381836000), _DATAF(-0.56668013334274292000)},
    {_DATAF(-0.82415515184402466000), _DATAF(-0.56636410951614380000)},
    {_DATAF(-0.82437229156494141000), _DATAF(-0.56604796648025513000)},
    {_DATAF(-0.82458931207656860000), _DATAF(-0.56573182344436646000)},
    {_DATAF(-0.82480621337890625000), _DATAF(-0.56541556119918823000)},
    {_DATAF(-0.82502299547195435000), _DATAF(-0.56509917974472046000)},
    {_DATAF(-0.82523959875106812000), _DATAF(-0.56478273868560791000)},
    {_DATAF(-0.82545614242553711000), _DATAF(-0.56446623802185059000)},
    {_DATAF(-0.82567256689071655000), _DATAF(-0.56414961814880371000)},
    {_DATAF(-0.82588887214660645000), _DATAF(-0.56383293867111206000)},
    {_DATAF(-0.82610499858856201000), _DATAF(-0.56351619958877563000)},
    {_DATAF(-0.82632106542587280000), _DATAF(-0.56319934129714966000)},
    {_DATAF(-0.82653701305389404000), _DATAF(-0.56288242340087891000)},
    {_DATAF(-0.82675278186798096000), _DATAF(-0.56256538629531860000)},
    {_DATAF(-0.82696849107742310000), _DATAF(-0.56224828958511353000)},
    {_DATAF(-0.82718402147293091000), _DATAF(-0.56193113327026367000)},
    {_DATAF(-0.82739949226379395000), _DATAF(-0.56161385774612427000)},
    {_DATAF(-0.82761478424072266000), _DATAF(-0.56129652261734009000)},
    {_DATAF(-0.82782995700836182000), _DATAF(-0.56097906827926636000)},
    {_DATAF(-0.82804507017135620000), _DATAF(-0.56066155433654785000)},
    {_DATAF(-0.82826000452041626000), _DATAF(-0.56034398078918457000)},
    {_DATAF(-0.82847481966018677000), _DATAF(-0.56002628803253174000)},
    {_DATAF(-0.82868951559066772000), _DATAF(-0.55970853567123413000)},
    {_DATAF(-0.82890409231185913000), _DATAF(-0.55939072370529175000)},
    {_DATAF(-0.82911854982376099000), _DATAF(-0.55907279253005981000)},
    {_DATAF(-0.82933294773101807000), _DATAF(-0.55875480175018311000)},
    {_DATAF(-0.82954710721969604000), _DATAF(-0.55843669176101685000)},
    {_DATAF(-0.82976120710372925000), _DATAF(-0.55811852216720581000)},
    {_DATAF(-0.82997518777847290000), _DATAF(-0.55780029296875000000)},
    {_DATAF(-0.83018904924392700000), _DATAF(-0.55748194456100464000)},
    {_DATAF(-0.83040279150009155000), _DATAF(-0.55716353654861450000)},
    {_DATAF(-0.83061641454696655000), _DATAF(-0.55684500932693481000)},
    {_DATAF(-0.83082985877990723000), _DATAF(-0.55652648210525513000)},
    {_DATAF(-0.83104324340820313000), _DATAF(-0.55620777606964111000)},
    {_DATAF(-0.83125650882720947000), _DATAF(-0.55588907003402710000)},
    {_DATAF(-0.83146959543228149000), _DATAF(-0.55557024478912354000)},
    {_DATAF(-0.83168262243270874000), _DATAF(-0.55525130033493042000)},
    {_DATAF(-0.83189547061920166000), _DATAF(-0.55493235588073730000)},
    {_DATAF(-0.83210825920104980000), _DATAF(-0.55461329221725464000)},
    {_DATAF(-0.83232086896896362000), _DATAF(-0.55429410934448242000)},
    {_DATAF(-0.83253335952758789000), _DATAF(-0.55397486686706543000)},
    {_DATAF(-0.83274579048156738000), _DATAF(-0.55365556478500366000)},
    {_DATAF(-0.83295804262161255000), _DATAF(-0.55333620309829712000)},
    {_DATAF(-0.83317017555236816000), _DATAF(-0.55301672220230103000)},
    {_DATAF(-0.83338218927383423000), _DATAF(-0.55269712209701538000)},
    {_DATAF(-0.83359408378601074000), _DATAF(-0.55237752199172974000)},
    {_DATAF(-0.83380585908889771000), _DATAF(-0.55205780267715454000)},
    {_DATAF(-0.83401751518249512000), _DATAF(-0.55173796415328979000)},
    {_DATAF(-0.83422905206680298000), _DATAF(-0.55141812562942505000)},
    {_DATAF(-0.83444041013717651000), _DATAF(-0.55109816789627075000)},
    {_DATAF(-0.83465170860290527000), _DATAF(-0.55077809095382690000)},
    {_DATAF(-0.83486288785934448000), _DATAF(-0.55045795440673828000)},
    {_DATAF(-0.83507388830184937000), _DATAF(-0.55013775825500488000)},
    {_DATAF(-0.83528482913970947000), _DATAF(-0.54981750249862671000)},
    {_DATAF(-0.83549559116363525000), _DATAF(-0.54949712753295898000)},
    {_DATAF(-0.83570629358291626000), _DATAF(-0.54917663335800171000)},
    {_DATAF(-0.83591681718826294000), _DATAF(-0.54885613918304443000)},
    {_DATAF(-0.83612728118896484000), _DATAF(-0.54853552579879761000)},
    {_DATAF(-0.83633756637573242000), _DATAF(-0.54821485280990601000)},
    {_DATAF(-0.83654773235321045000), _DATAF(-0.54789406061172485000)},
    {_DATAF(-0.83675777912139893000), _DATAF(-0.54757320880889893000)},
    {_DATAF(-0.83696770668029785000), _DATAF(-0.54725229740142822000)},
    {_DATAF(-0.83717751502990723000), _DATAF(-0.54693126678466797000)},
    {_DATAF(-0.83738720417022705000), _DATAF(-0.54661017656326294000)},
    {_DATAF(-0.83759677410125732000), _DATAF(-0.54628896713256836000)},
    {_DATAF(-0.83780622482299805000), _DATAF(-0.54596775770187378000)},
    {_DATAF(-0.83801549673080444000), _DATAF(-0.54564642906188965000)},
    {_DATAF(-0.83822470903396606000), _DATAF(-0.54532498121261597000)},
    {_DATAF(-0.83843380212783813000), _DATAF(-0.54500347375869751000)},
    {_DATAF(-0.83864271640777588000), _DATAF(-0.54468190670013428000)},
    {_DATAF(-0.83885151147842407000), _DATAF(-0.54436028003692627000)},
    {_DATAF(-0.83906024694442749000), _DATAF(-0.54403853416442871000)},
    {_DATAF(-0.83926880359649658000), _DATAF(-0.54371672868728638000)},
    {_DATAF(-0.83947724103927612000), _DATAF(-0.54339480400085449000)},
    {_DATAF(-0.83968561887741089000), _DATAF(-0.54307281970977783000)},
    {_DATAF(-0.83989381790161133000), _DATAF(-0.54275077581405640000)},
    {_DATAF(-0.84010189771652222000), _DATAF(-0.54242867231369019000)},
    {_DATAF(-0.84030985832214355000), _DATAF(-0.54210644960403442000)},
    {_DATAF(-0.84051764011383057000), _DATAF(-0.54178416728973389000)},
    {_DATAF(-0.84072536230087280000), _DATAF(-0.54146176576614380000)},
    {_DATAF(-0.84093296527862549000), _DATAF(-0.54113930463790894000)},
    {_DATAF(-0.84114044904708862000), _DATAF(-0.54081678390502930000)},
    {_DATAF(-0.84134775400161743000), _DATAF(-0.54049414396286011000)},
    {_DATAF(-0.84155499935150146000), _DATAF(-0.54017144441604614000)},
    {_DATAF(-0.84176206588745117000), _DATAF(-0.53984868526458740000)},
    {_DATAF(-0.84196901321411133000), _DATAF(-0.53952586650848389000)},
    {_DATAF(-0.84217590093612671000), _DATAF(-0.53920292854309082000)},
    {_DATAF(-0.84238260984420776000), _DATAF(-0.53887993097305298000)},
    {_DATAF(-0.84258919954299927000), _DATAF(-0.53855681419372559000)},
    {_DATAF(-0.84279567003250122000), _DATAF(-0.53823363780975342000)},
    {_DATAF(-0.84300202131271362000), _DATAF(-0.53791040182113647000)},
    {_DATAF(-0.84320825338363647000), _DATAF(-0.53758704662322998000)},
    {_DATAF(-0.84341436624526978000), _DATAF(-0.53726369142532349000)},
    {_DATAF(-0.84362030029296875000), _DATAF(-0.53694015741348267000)},
    {_DATAF(-0.84382617473602295000), _DATAF(-0.53661662340164185000)},
    {_DATAF(-0.84403187036514282000), _DATAF(-0.53629297018051147000)},
    {_DATAF(-0.84423750638961792000), _DATAF(-0.53596925735473633000)},
    {_DATAF(-0.84444296360015869000), _DATAF(-0.53564548492431641000)},
    {_DATAF(-0.84464836120605469000), _DATAF(-0.53532159328460693000)},
    {_DATAF(-0.84485357999801636000), _DATAF(-0.53499764204025269000)},
    {_DATAF(-0.84505867958068848000), _DATAF(-0.53467357158660889000)},
    {_DATAF(-0.84526365995407104000), _DATAF(-0.53434944152832031000)},
    {_DATAF(-0.84546852111816406000), _DATAF(-0.53402525186538696000)},
    {_DATAF(-0.84567326307296753000), _DATAF(-0.53370100259780884000)},
    {_DATAF(-0.84587788581848145000), _DATAF(-0.53337663412094116000)},
    {_DATAF(-0.84608232975006104000), _DATAF(-0.53305220603942871000)},
    {_DATAF(-0.84628671407699585000), _DATAF(-0.53272771835327148000)},
    {_DATAF(-0.84649091958999634000), _DATAF(-0.53240311145782471000)},
    {_DATAF(-0.84669506549835205000), _DATAF(-0.53207844495773315000)},
    {_DATAF(-0.84689903259277344000), _DATAF(-0.53175371885299683000)},
    {_DATAF(-0.84710288047790527000), _DATAF(-0.53142887353897095000)},
    {_DATAF(-0.84730660915374756000), _DATAF(-0.53110402822494507000)},
    {_DATAF(-0.84751027822494507000), _DATAF(-0.53077900409698486000)},
    {_DATAF(-0.84771376848220825000), _DATAF(-0.53045397996902466000)},
    {_DATAF(-0.84791707992553711000), _DATAF(-0.53012883663177490000)},
    {_DATAF(-0.84812033176422119000), _DATAF(-0.52980363368988037000)},
    {_DATAF(-0.84832346439361572000), _DATAF(-0.52947831153869629000)},
    {_DATAF(-0.84852647781372070000), _DATAF(-0.52915298938751221000)},
    {_DATAF(-0.84872931241989136000), _DATAF(-0.52882754802703857000)},
    {_DATAF(-0.84893202781677246000), _DATAF(-0.52850198745727539000)},
    {_DATAF(-0.84913468360900879000), _DATAF(-0.52817642688751221000)},
    {_DATAF(-0.84933716058731079000), _DATAF(-0.52785074710845947000)},
    {_DATAF(-0.84953951835632324000), _DATAF(-0.52752494812011719000)},
    {_DATAF(-0.84974175691604614000), _DATAF(-0.52719914913177490000)},
    {_DATAF(-0.84994387626647949000), _DATAF(-0.52687323093414307000)},
    {_DATAF(-0.85014587640762329000), _DATAF(-0.52654725313186646000)},
    {_DATAF(-0.85034775733947754000), _DATAF(-0.52622115612030029000)},
    {_DATAF(-0.85054945945739746000), _DATAF(-0.52589499950408936000)},
    {_DATAF(-0.85075110197067261000), _DATAF(-0.52556878328323364000)},
    {_DATAF(-0.85095256567001343000), _DATAF(-0.52524250745773315000)},
    {_DATAF(-0.85115396976470947000), _DATAF(-0.52491611242294312000)},
    {_DATAF(-0.85135519504547119000), _DATAF(-0.52458965778350830000)},
    {_DATAF(-0.85155630111694336000), _DATAF(-0.52426314353942871000)},
    {_DATAF(-0.85175728797912598000), _DATAF(-0.52393656969070435000)},
    {_DATAF(-0.85195815563201904000), _DATAF(-0.52360987663269043000)},
    {_DATAF(-0.85215890407562256000), _DATAF(-0.52328312397003174000)},
    {_DATAF(-0.85235953330993652000), _DATAF(-0.52295625209808350000)},
    {_DATAF(-0.85255998373031616000), _DATAF(-0.52262938022613525000)},
    {_DATAF(-0.85276037454605103000), _DATAF(-0.52230238914489746000)},
    {_DATAF(-0.85296058654785156000), _DATAF(-0.52197527885437012000)},
    {_DATAF(-0.85316073894500732000), _DATAF(-0.52164816856384277000)},
    {_DATAF(-0.85336071252822876000), _DATAF(-0.52132093906402588000)},
    {_DATAF(-0.85356056690216064000), _DATAF(-0.52099364995956421000)},
    {_DATAF(-0.85376030206680298000), _DATAF(-0.52066624164581299000)},
    {_DATAF(-0.85395991802215576000), _DATAF(-0.52033877372741699000)},
    {_DATAF(-0.85415941476821899000), _DATAF(-0.52001124620437622000)},
    {_DATAF(-0.85435873270034790000), _DATAF(-0.51968365907669067000)},
    {_DATAF(-0.85455799102783203000), _DATAF(-0.51935601234436035000)},
    {_DATAF(-0.85475707054138184000), _DATAF(-0.51902824640274048000)},
    {_DATAF(-0.85495609045028687000), _DATAF(-0.51870042085647583000)},
    {_DATAF(-0.85515493154525757000), _DATAF(-0.51837247610092163000)},
    {_DATAF(-0.85535365343093872000), _DATAF(-0.51804453134536743000)},
    {_DATAF(-0.85555225610733032000), _DATAF(-0.51771646738052368000)},
    {_DATAF(-0.85575073957443237000), _DATAF(-0.51738828420639038000)},
    {_DATAF(-0.85594910383224487000), _DATAF(-0.51706010103225708000)},
    {_DATAF(-0.85614734888076782000), _DATAF(-0.51673179864883423000)},
    {_DATAF(-0.85634541511535645000), _DATAF(-0.51640343666076660000)},
    {_DATAF(-0.85654342174530029000), _DATAF(-0.51607501506805420000)},
    {_DATAF(-0.85674124956130981000), _DATAF(-0.51574647426605225000)},
    {_DATAF(-0.85693895816802979000), _DATAF(-0.51541787385940552000)},
    {_DATAF(-0.85713654756546021000), _DATAF(-0.51508921384811401000)},
    {_DATAF(-0.85733401775360107000), _DATAF(-0.51476043462753296000)},
    {_DATAF(-0.85753136873245239000), _DATAF(-0.51443165540695190000)},
    {_DATAF(-0.85772860050201416000), _DATAF(-0.51410275697708130000)},
    {_DATAF(-0.85792571306228638000), _DATAF(-0.51377379894256592000)},
    {_DATAF(-0.85812264680862427000), _DATAF(-0.51344472169876099000)},
    {_DATAF(-0.85831952095031738000), _DATAF(-0.51311558485031128000)},
    {_DATAF(-0.85851621627807617000), _DATAF(-0.51278638839721680000)},
    {_DATAF(-0.85871279239654541000), _DATAF(-0.51245713233947754000)},
    {_DATAF(-0.85890924930572510000), _DATAF(-0.51212775707244873000)},
    {_DATAF(-0.85910558700561523000), _DATAF(-0.51179832220077515000)},
    {_DATAF(-0.85930180549621582000), _DATAF(-0.51146882772445679000)},
    {_DATAF(-0.85949790477752686000), _DATAF(-0.51113927364349365000)},
    {_DATAF(-0.85969388484954834000), _DATAF(-0.51080960035324097000)},
    {_DATAF(-0.85988968610763550000), _DATAF(-0.51047992706298828000)},
    {_DATAF(-0.86008536815643311000), _DATAF(-0.51015007495880127000)},
    {_DATAF(-0.86028099060058594000), _DATAF(-0.50982022285461426000)},
    {_DATAF(-0.86047643423080444000), _DATAF(-0.50949025154113770000)},
    {_DATAF(-0.86067175865173340000), _DATAF(-0.50916022062301636000)},
    {_DATAF(-0.86086696386337280000), _DATAF(-0.50883013010025024000)},
    {_DATAF(-0.86106199026107788000), _DATAF(-0.50849997997283936000)},
    {_DATAF(-0.86125695705413818000), _DATAF(-0.50816971063613892000)},
    {_DATAF(-0.86145174503326416000), _DATAF(-0.50783938169479370000)},
    {_DATAF(-0.86164647340774536000), _DATAF(-0.50750899314880371000)},
    {_DATAF(-0.86184102296829224000), _DATAF(-0.50717854499816895000)},
    {_DATAF(-0.86203545331954956000), _DATAF(-0.50684797763824463000)},
    {_DATAF(-0.86222976446151733000), _DATAF(-0.50651735067367554000)},
    {_DATAF(-0.86242395639419556000), _DATAF(-0.50618666410446167000)},
    {_DATAF(-0.86261802911758423000), _DATAF(-0.50585585832595825000)},
    {_DATAF(-0.86281192302703857000), _DATAF(-0.50552505254745483000)},
    {_DATAF(-0.86300575733184814000), _DATAF(-0.50519412755966187000)},
    {_DATAF(-0.86319941282272339000), _DATAF(-0.50486308336257935000)},
    {_DATAF(-0.86339294910430908000), _DATAF(-0.50453203916549683000)},
    {_DATAF(-0.86358636617660522000), _DATAF(-0.50420087575912476000)},
    {_DATAF(-0.86377966403961182000), _DATAF(-0.50386965274810791000)},
    {_DATAF(-0.86397284269332886000), _DATAF(-0.50353837013244629000)},
    {_DATAF(-0.86416590213775635000), _DATAF(-0.50320702791213989000)},
    {_DATAF(-0.86435878276824951000), _DATAF(-0.50287556648254395000)},
    {_DATAF(-0.86455160379409790000), _DATAF(-0.50254404544830322000)},
    {_DATAF(-0.86474424600601196000), _DATAF(-0.50221246480941772000)},
    {_DATAF(-0.86493676900863647000), _DATAF(-0.50188082456588745000)},
    {_DATAF(-0.86512917280197144000), _DATAF(-0.50154906511306763000)},
    {_DATAF(-0.86532145738601685000), _DATAF(-0.50121724605560303000)},
    {_DATAF(-0.86551362276077271000), _DATAF(-0.50088536739349365000)},
    {_DATAF(-0.86570566892623901000), _DATAF(-0.50055342912673950000)},
    {_DATAF(-0.86589753627777100000), _DATAF(-0.50022137165069580000)},
    {_DATAF(-0.86608928442001343000), _DATAF(-0.49988928437232971000)},
    {_DATAF(-0.86628097295761108000), _DATAF(-0.49955710768699646000)},
    {_DATAF(-0.86647248268127441000), _DATAF(-0.49922487139701843000)},
    {_DATAF(-0.86666387319564819000), _DATAF(-0.49889254570007324000)},
    {_DATAF(-0.86685508489608765000), _DATAF(-0.49856013059616089000)},
    {_DATAF(-0.86704623699188232000), _DATAF(-0.49822765588760376000)},
    {_DATAF(-0.86723726987838745000), _DATAF(-0.49789512157440186000)},
    {_DATAF(-0.86742812395095825000), _DATAF(-0.49756249785423279000)},
    {_DATAF(-0.86761885881423950000), _DATAF(-0.49722981452941895000)},
    {_DATAF(-0.86780947446823120000), _DATAF(-0.49689704179763794000)},
    {_DATAF(-0.86799997091293335000), _DATAF(-0.49656420946121216000)},
    {_DATAF(-0.86819034814834595000), _DATAF(-0.49623128771781921000)},
    {_DATAF(-0.86838060617446899000), _DATAF(-0.49589830636978149000)},
    {_DATAF(-0.86857068538665771000), _DATAF(-0.49556526541709900000)},
    {_DATAF(-0.86876070499420166000), _DATAF(-0.49523213505744934000)},
    {_DATAF(-0.86895054578781128000), _DATAF(-0.49489894509315491000)},
    {_DATAF(-0.86914026737213135000), _DATAF(-0.49456566572189331000)},
    {_DATAF(-0.86932986974716187000), _DATAF(-0.49423229694366455000)},
    {_DATAF(-0.86951935291290283000), _DATAF(-0.49389889836311340000)},
    {_DATAF(-0.86970865726470947000), _DATAF(-0.49356541037559509000)},
    {_DATAF(-0.86989790201187134000), _DATAF(-0.49323183298110962000)},
    {_DATAF(-0.87008696794509888000), _DATAF(-0.49289819598197937000)},
    {_DATAF(-0.87027597427368164000), _DATAF(-0.49256446957588196000)},
    {_DATAF(-0.87046480178833008000), _DATAF(-0.49223071336746216000)},
    {_DATAF(-0.87065351009368896000), _DATAF(-0.49189683794975281000)},
    {_DATAF(-0.87084203958511353000), _DATAF(-0.49156290292739868000)},
    {_DATAF(-0.87103050947189331000), _DATAF(-0.49122890830039978000)},
    {_DATAF(-0.87121886014938354000), _DATAF(-0.49089485406875610000)},
    {_DATAF(-0.87140703201293945000), _DATAF(-0.49056071043014526000)},
    {_DATAF(-0.87159508466720581000), _DATAF(-0.49022647738456726000)},
    {_DATAF(-0.87178301811218262000), _DATAF(-0.48989218473434448000)},
    {_DATAF(-0.87197083234786987000), _DATAF(-0.48955783247947693000)},
    {_DATAF(-0.87215852737426758000), _DATAF(-0.48922339081764221000)},
    {_DATAF(-0.87234604358673096000), _DATAF(-0.48888888955116272000)},
    {_DATAF(-0.87253350019454956000), _DATAF(-0.48855432868003845000)},
    {_DATAF(-0.87272077798843384000), _DATAF(-0.48821967840194702000)},
    {_DATAF(-0.87290793657302856000), _DATAF(-0.48788493871688843000)},
    {_DATAF(-0.87309497594833374000), _DATAF(-0.48755016922950745000)},
    {_DATAF(-0.87328189611434937000), _DATAF(-0.48721531033515930000)},
    {_DATAF(-0.87346869707107544000), _DATAF(-0.48688036203384399000)},
    {_DATAF(-0.87365531921386719000), _DATAF(-0.48654535412788391000)},
    {_DATAF(-0.87384182214736938000), _DATAF(-0.48621028661727905000)},
    {_DATAF(-0.87402826547622681000), _DATAF(-0.48587512969970703000)},
    {_DATAF(-0.87421452999114990000), _DATAF(-0.48553991317749023000)},
    {_DATAF(-0.87440061569213867000), _DATAF(-0.48520460724830627000)},
    {_DATAF(-0.87458664178848267000), _DATAF(-0.48486924171447754000)},
    {_DATAF(-0.87477254867553711000), _DATAF(-0.48453381657600403000)},
    {_DATAF(-0.87495827674865723000), _DATAF(-0.48419830203056335000)},
    {_DATAF(-0.87514388561248779000), _DATAF(-0.48386272788047791000)},
    {_DATAF(-0.87532937526702881000), _DATAF(-0.48352706432342529000)},
    {_DATAF(-0.87551474571228027000), _DATAF(-0.48319137096405029000)},
    {_DATAF(-0.87569999694824219000), _DATAF(-0.48285555839538574000)},
    {_DATAF(-0.87588512897491455000), _DATAF(-0.48251971602439880000)},
    {_DATAF(-0.87607008218765259000), _DATAF(-0.48218378424644470000)},
    {_DATAF(-0.87625491619110107000), _DATAF(-0.48184776306152344000)},
    {_DATAF(-0.87643969058990479000), _DATAF(-0.48151168227195740000)},
    {_DATAF(-0.87662428617477417000), _DATAF(-0.48117554187774658000)},
    {_DATAF(-0.87680870294570923000), _DATAF(-0.48083934187889099000)},
    {_DATAF(-0.87699306011199951000), _DATAF(-0.48050305247306824000)},
    {_DATAF(-0.87717723846435547000), _DATAF(-0.48016667366027832000)},
    {_DATAF(-0.87736135721206665000), _DATAF(-0.47983026504516602000)},
    {_DATAF(-0.87754529714584351000), _DATAF(-0.47949376702308655000)},
    {_DATAF(-0.87772911787033081000), _DATAF(-0.47915717959403992000)},
    {_DATAF(-0.87791281938552856000), _DATAF(-0.47882056236267090000)},
    {_DATAF(-0.87809634208679199000), _DATAF(-0.47848382592201233000)},
    {_DATAF(-0.87827980518341064000), _DATAF(-0.47814705967903137000)},
    {_DATAF(-0.87846308946609497000), _DATAF(-0.47781020402908325000)},
    {_DATAF(-0.87864625453948975000), _DATAF(-0.47747328877449036000)},
    {_DATAF(-0.87882930040359497000), _DATAF(-0.47713628411293030000)},
    {_DATAF(-0.87901222705841064000), _DATAF(-0.47679921984672546000)},
    {_DATAF(-0.87919503450393677000), _DATAF(-0.47646209597587585000)},
    {_DATAF(-0.87937766313552856000), _DATAF(-0.47612488269805908000)},
    {_DATAF(-0.87956017255783081000), _DATAF(-0.47578760981559753000)},
    {_DATAF(-0.87974262237548828000), _DATAF(-0.47545027732849121000)},
    {_DATAF(-0.87992483377456665000), _DATAF(-0.47511285543441772000)},
    {_DATAF(-0.88010698556900024000), _DATAF(-0.47477537393569946000)},
    {_DATAF(-0.88028901815414429000), _DATAF(-0.47443783283233643000)},
    {_DATAF(-0.88047087192535400000), _DATAF(-0.47410020232200623000)},
    {_DATAF(-0.88065266609191895000), _DATAF(-0.47376251220703125000)},
    {_DATAF(-0.88083428144454956000), _DATAF(-0.47342476248741150000)},
    {_DATAF(-0.88101577758789063000), _DATAF(-0.47308692336082458000)},
    {_DATAF(-0.88119709491729736000), _DATAF(-0.47274902462959290000)},
    {_DATAF(-0.88137835264205933000), _DATAF(-0.47241106629371643000)},
    {_DATAF(-0.88155943155288696000), _DATAF(-0.47207301855087280000)},
    {_DATAF(-0.88174045085906982000), _DATAF(-0.47173491120338440000)},
    {_DATAF(-0.88192129135131836000), _DATAF(-0.47139674425125122000)},
    {_DATAF(-0.88210195302963257000), _DATAF(-0.47105848789215088000)},
    {_DATAF(-0.88228255510330200000), _DATAF(-0.47072017192840576000)},
    {_DATAF(-0.88246303796768188000), _DATAF(-0.47038179636001587000)},
    {_DATAF(-0.88264334201812744000), _DATAF(-0.47004333138465881000)},
    {_DATAF(-0.88282352685928345000), _DATAF(-0.46970480680465698000)},
    {_DATAF(-0.88300359249114990000), _DATAF(-0.46936622262001038000)},
    {_DATAF(-0.88318353891372681000), _DATAF(-0.46902754902839661000)},
    {_DATAF(-0.88336336612701416000), _DATAF(-0.46868881583213806000)},
    {_DATAF(-0.88354301452636719000), _DATAF(-0.46835002303123474000)},
    {_DATAF(-0.88372254371643066000), _DATAF(-0.46801114082336426000)},
    {_DATAF(-0.88390195369720459000), _DATAF(-0.46767222881317139000)},
    {_DATAF(-0.88408124446868896000), _DATAF(-0.46733319759368896000)},
    {_DATAF(-0.88426041603088379000), _DATAF(-0.46699413657188416000)},
    {_DATAF(-0.88443946838378906000), _DATAF(-0.46665498614311218000)},
    {_DATAF(-0.88461834192276001000), _DATAF(-0.46631577610969543000)},
    {_DATAF(-0.88479709625244141000), _DATAF(-0.46597650647163391000)},
    {_DATAF(-0.88497573137283325000), _DATAF(-0.46563714742660522000)},
    {_DATAF(-0.88515424728393555000), _DATAF(-0.46529772877693176000)},
    {_DATAF(-0.88533258438110352000), _DATAF(-0.46495825052261353000)},
    {_DATAF(-0.88551086187362671000), _DATAF(-0.46461868286132813000)},
    {_DATAF(-0.88568896055221558000), _DATAF(-0.46427905559539795000)},
    {_DATAF(-0.88586694002151489000), _DATAF(-0.46393936872482300000)},
    {_DATAF(-0.88604480028152466000), _DATAF(-0.46359962224960327000)},
    {_DATAF(-0.88622254133224487000), _DATAF(-0.46325978636741638000)},
    {_DATAF(-0.88640010356903076000), _DATAF(-0.46291989088058472000)},
    {_DATAF(-0.88657760620117188000), _DATAF(-0.46257993578910828000)},
    {_DATAF(-0.88675493001937866000), _DATAF(-0.46223989129066467000)},
    {_DATAF(-0.88693213462829590000), _DATAF(-0.46189978718757629000)},
    {_DATAF(-0.88710916042327881000), _DATAF(-0.46155962347984314000)},
    {_DATAF(-0.88728612661361694000), _DATAF(-0.46121940016746521000)},
    {_DATAF(-0.88746291399002075000), _DATAF(-0.46087908744812012000)},
    {_DATAF(-0.88763964176177979000), _DATAF(-0.46053871512413025000)},
    {_DATAF(-0.88781619071960449000), _DATAF(-0.46019828319549561000)},
    {_DATAF(-0.88799256086349487000), _DATAF(-0.45985776185989380000)},
    {_DATAF(-0.88816887140274048000), _DATAF(-0.45951718091964722000)},
    {_DATAF(-0.88834506273269653000), _DATAF(-0.45917654037475586000)},
    {_DATAF(-0.88852107524871826000), _DATAF(-0.45883584022521973000)},
    {_DATAF(-0.88869696855545044000), _DATAF(-0.45849505066871643000)},
    {_DATAF(-0.88887274265289307000), _DATAF(-0.45815420150756836000)},
    {_DATAF(-0.88904833793640137000), _DATAF(-0.45781329274177551000)},
    {_DATAF(-0.88922387361526489000), _DATAF(-0.45747232437133789000)},
    {_DATAF(-0.88939923048019409000), _DATAF(-0.45713126659393311000)},
    {_DATAF(-0.88957446813583374000), _DATAF(-0.45679014921188354000)},
    {_DATAF(-0.88974958658218384000), _DATAF(-0.45644897222518921000)},
    {_DATAF(-0.88992458581924438000), _DATAF(-0.45610773563385010000)},
    {_DATAF(-0.89009940624237061000), _DATAF(-0.45576640963554382000)},
    {_DATAF(-0.89027410745620728000), _DATAF(-0.45542502403259277000)},
    {_DATAF(-0.89044874906539917000), _DATAF(-0.45508357882499695000)},
    {_DATAF(-0.89062315225601196000), _DATAF(-0.45474207401275635000)},
    {_DATAF(-0.89079749584197998000), _DATAF(-0.45440047979354858000)},
    {_DATAF(-0.89097172021865845000), _DATAF(-0.45405882596969604000)},
    {_DATAF(-0.89114576578140259000), _DATAF(-0.45371711254119873000)},
    {_DATAF(-0.89131969213485718000), _DATAF(-0.45337533950805664000)},
    {_DATAF(-0.89149349927902222000), _DATAF(-0.45303347706794739000)},
    {_DATAF(-0.89166718721389771000), _DATAF(-0.45269158482551575000)},
    {_DATAF(-0.89184069633483887000), _DATAF(-0.45234957337379456000)},
    {_DATAF(-0.89201414585113525000), _DATAF(-0.45200753211975098000)},
    {_DATAF(-0.89218741655349731000), _DATAF(-0.45166543126106262000)},
    {_DATAF(-0.89236056804656982000), _DATAF(-0.45132324099540710000)},
    {_DATAF(-0.89253354072570801000), _DATAF(-0.45098099112510681000)},
    {_DATAF(-0.89270645380020142000), _DATAF(-0.45063868165016174000)},
    {_DATAF(-0.89287918806076050000), _DATAF(-0.45029628276824951000)},
    {_DATAF(-0.89305180311203003000), _DATAF(-0.44995385408401489000)},
    {_DATAF(-0.89322429895401001000), _DATAF(-0.44961133599281311000)},
    {_DATAF(-0.89339667558670044000), _DATAF(-0.44926875829696655000)},
    {_DATAF(-0.89356887340545654000), _DATAF(-0.44892609119415283000)},
    {_DATAF(-0.89374095201492310000), _DATAF(-0.44858339428901672000)},
    {_DATAF(-0.89391297101974487000), _DATAF(-0.44824060797691345000)},
    {_DATAF(-0.89408475160598755000), _DATAF(-0.44789776206016541000)},
    {_DATAF(-0.89425647258758545000), _DATAF(-0.44755485653877258000)},
    {_DATAF(-0.89442807435989380000), _DATAF(-0.44721189141273499000)},
    {_DATAF(-0.89459949731826782000), _DATAF(-0.44686883687973022000)},
    {_DATAF(-0.89477080106735229000), _DATAF(-0.44652572274208069000)},
    {_DATAF(-0.89494198560714722000), _DATAF(-0.44618254899978638000)},
    {_DATAF(-0.89511299133300781000), _DATAF(-0.44583931565284729000)},
    {_DATAF(-0.89528393745422363000), _DATAF(-0.44549602270126343000)},
    {_DATAF(-0.89545470476150513000), _DATAF(-0.44515264034271240000)},
    {_DATAF(-0.89562535285949707000), _DATAF(-0.44480919837951660000)},
    {_DATAF(-0.89579588174819946000), _DATAF(-0.44446569681167603000)},
    {_DATAF(-0.89596623182296753000), _DATAF(-0.44412213563919067000)},
    {_DATAF(-0.89613652229309082000), _DATAF(-0.44377851486206055000)},
    {_DATAF(-0.89630663394927979000), _DATAF(-0.44343480467796326000)},
    {_DATAF(-0.89647662639617920000), _DATAF(-0.44309106469154358000)},
    {_DATAF(-0.89664649963378906000), _DATAF(-0.44274723529815674000)},
    {_DATAF(-0.89681619405746460000), _DATAF(-0.44240334630012512000)},
    {_DATAF(-0.89698576927185059000), _DATAF(-0.44205936789512634000)},
    {_DATAF(-0.89715522527694702000), _DATAF(-0.44171535968780518000)},
    {_DATAF(-0.89732456207275391000), _DATAF(-0.44137126207351685000)},
    {_DATAF(-0.89749377965927124000), _DATAF(-0.44102710485458374000)},
    {_DATAF(-0.89766281843185425000), _DATAF(-0.44068288803100586000)},
    {_DATAF(-0.89783179759979248000), _DATAF(-0.44033861160278320000)},
    {_DATAF(-0.89800059795379639000), _DATAF(-0.43999427556991577000)},
    {_DATAF(-0.89816927909851074000), _DATAF(-0.43964985013008118000)},
    {_DATAF(-0.89833778142929077000), _DATAF(-0.43930539488792419000)},
    {_DATAF(-0.89850616455078125000), _DATAF(-0.43896085023880005000)},
    {_DATAF(-0.89867448806762695000), _DATAF(-0.43861624598503113000)},
    {_DATAF(-0.89884263277053833000), _DATAF(-0.43827158212661743000)},
    {_DATAF(-0.89901059865951538000), _DATAF(-0.43792682886123657000)},
    {_DATAF(-0.89917850494384766000), _DATAF(-0.43758204579353333000)},
    {_DATAF(-0.89934623241424561000), _DATAF(-0.43723717331886292000)},
    {_DATAF(-0.89951384067535400000), _DATAF(-0.43689224123954773000)},
    {_DATAF(-0.89968132972717285000), _DATAF(-0.43654724955558777000)},
    {_DATAF(-0.89984869956970215000), _DATAF(-0.43620219826698303000)},
    {_DATAF(-0.90001589059829712000), _DATAF(-0.43585708737373352000)},
    {_DATAF(-0.90018296241760254000), _DATAF(-0.43551188707351685000)},
    {_DATAF(-0.90034991502761841000), _DATAF(-0.43516665697097778000)},
    {_DATAF(-0.90051674842834473000), _DATAF(-0.43482133746147156000)},
    {_DATAF(-0.90068340301513672000), _DATAF(-0.43447595834732056000)},
    {_DATAF(-0.90084999799728394000), _DATAF(-0.43413051962852478000)},
    {_DATAF(-0.90101641416549683000), _DATAF(-0.43378502130508423000)},
    {_DATAF(-0.90118271112442017000), _DATAF(-0.43343946337699890000)},
    {_DATAF(-0.90134882926940918000), _DATAF(-0.43309381604194641000)},
    {_DATAF(-0.90151488780975342000), _DATAF(-0.43274813890457153000)},
    {_DATAF(-0.90168076753616333000), _DATAF(-0.43240237236022949000)},
    {_DATAF(-0.90184652805328369000), _DATAF(-0.43205654621124268000)},
    {_DATAF(-0.90201216936111450000), _DATAF(-0.43171066045761108000)},
    {_DATAF(-0.90217763185501099000), _DATAF(-0.43136471509933472000)},
    {_DATAF(-0.90234297513961792000), _DATAF(-0.43101871013641357000)},
    {_DATAF(-0.90250819921493530000), _DATAF(-0.43067261576652527000)},
    {_DATAF(-0.90267330408096313000), _DATAF(-0.43032649159431458000)},
    {_DATAF(-0.90283828973770142000), _DATAF(-0.42998027801513672000)},
    {_DATAF(-0.90300309658050537000), _DATAF(-0.42963400483131409000)},
    {_DATAF(-0.90316778421401978000), _DATAF(-0.42928767204284668000)},
    {_DATAF(-0.90333235263824463000), _DATAF(-0.42894127964973450000)},
    {_DATAF(-0.90349680185317993000), _DATAF(-0.42859482765197754000)},
    {_DATAF(-0.90366107225418091000), _DATAF(-0.42824831604957581000)},
    {_DATAF(-0.90382528305053711000), _DATAF(-0.42790174484252930000)},
    {_DATAF(-0.90398931503295898000), _DATAF(-0.42755508422851563000)},
    {_DATAF(-0.90415316820144653000), _DATAF(-0.42720839381217957000)},
    {_DATAF(-0.90431696176528931000), _DATAF(-0.42686161398887634000)},
    {_DATAF(-0.90448057651519775000), _DATAF(-0.42651477456092834000)},
    {_DATAF(-0.90464407205581665000), _DATAF(-0.42616787552833557000)},
    {_DATAF(-0.90480744838714600000), _DATAF(-0.42582091689109802000)},
    {_DATAF(-0.90497070550918579000), _DATAF(-0.42547389864921570000)},
    {_DATAF(-0.90513378381729126000), _DATAF(-0.42512682080268860000)},
    {_DATAF(-0.90529674291610718000), _DATAF(-0.42477968335151672000)},
    {_DATAF(-0.90545958280563354000), _DATAF(-0.42443248629570007000)},
    {_DATAF(-0.90562230348587036000), _DATAF(-0.42408519983291626000)},
    {_DATAF(-0.90578484535217285000), _DATAF(-0.42373788356781006000)},
    {_DATAF(-0.90594726800918579000), _DATAF(-0.42339047789573669000)},
    {_DATAF(-0.90610957145690918000), _DATAF(-0.42304301261901855000)},
    {_DATAF(-0.90627175569534302000), _DATAF(-0.42269548773765564000)},
    {_DATAF(-0.90643382072448730000), _DATAF(-0.42234790325164795000)},
    {_DATAF(-0.90659570693969727000), _DATAF(-0.42200025916099548000)},
    {_DATAF(-0.90675747394561768000), _DATAF(-0.42165255546569824000)},
    {_DATAF(-0.90691912174224854000), _DATAF(-0.42130479216575623000)},
    {_DATAF(-0.90708059072494507000), _DATAF(-0.42095696926116943000)},
    {_DATAF(-0.90724200010299683000), _DATAF(-0.42060908675193787000)},
    {_DATAF(-0.90740323066711426000), _DATAF(-0.42026111483573914000)},
    {_DATAF(-0.90756434202194214000), _DATAF(-0.41991311311721802000)},
    {_DATAF(-0.90772527456283569000), _DATAF(-0.41956502199172974000)},
    {_DATAF(-0.90788608789443970000), _DATAF(-0.41921690106391907000)},
    {_DATAF(-0.90804684162139893000), _DATAF(-0.41886869072914124000)},
    {_DATAF(-0.90820735692977905000), _DATAF(-0.41852042078971863000)},
    {_DATAF(-0.90836781263351440000), _DATAF(-0.41817209124565125000)},
    {_DATAF(-0.90852808952331543000), _DATAF(-0.41782370209693909000)},
    {_DATAF(-0.90868830680847168000), _DATAF(-0.41747528314590454000)},
    {_DATAF(-0.90884834527969360000), _DATAF(-0.41712677478790283000)},
    {_DATAF(-0.90900820493698120000), _DATAF(-0.41677817702293396000)},
    {_DATAF(-0.90916800498962402000), _DATAF(-0.41642954945564270000)},
    {_DATAF(-0.90932762622833252000), _DATAF(-0.41608086228370667000)},
    {_DATAF(-0.90948712825775146000), _DATAF(-0.41573211550712585000)},
    {_DATAF(-0.90964645147323608000), _DATAF(-0.41538330912590027000)},
    {_DATAF(-0.90980571508407593000), _DATAF(-0.41503441333770752000)},
    {_DATAF(-0.90996479988098145000), _DATAF(-0.41468548774719238000)},
    {_DATAF(-0.91012376546859741000), _DATAF(-0.41433650255203247000)},
    {_DATAF(-0.91028261184692383000), _DATAF(-0.41398742794990540000)},
    {_DATAF(-0.91044127941131592000), _DATAF(-0.41363832354545593000)},
    {_DATAF(-0.91059982776641846000), _DATAF(-0.41328912973403931000)},
    {_DATAF(-0.91075825691223145000), _DATAF(-0.41293987631797791000)},
    {_DATAF(-0.91091656684875488000), _DATAF(-0.41259059309959412000)},
    {_DATAF(-0.91107475757598877000), _DATAF(-0.41224122047424316000)},
    {_DATAF(-0.91123276948928833000), _DATAF(-0.41189181804656982000)},
    {_DATAF(-0.91139066219329834000), _DATAF(-0.41154232621192932000)},
    {_DATAF(-0.91154843568801880000), _DATAF(-0.41119277477264404000)},
    {_DATAF(-0.91170603036880493000), _DATAF(-0.41084316372871399000)},
    {_DATAF(-0.91186350584030151000), _DATAF(-0.41049349308013916000)},
    {_DATAF(-0.91202086210250854000), _DATAF(-0.41014379262924194000)},
    {_DATAF(-0.91217809915542603000), _DATAF(-0.40979400277137756000)},
    {_DATAF(-0.91233515739440918000), _DATAF(-0.40944415330886841000)},
    {_DATAF(-0.91249215602874756000), _DATAF(-0.40909424424171448000)},
    {_DATAF(-0.91264897584915161000), _DATAF(-0.40874427556991577000)},
    {_DATAF(-0.91280561685562134000), _DATAF(-0.40839424729347229000)},
    {_DATAF(-0.91296219825744629000), _DATAF(-0.40804415941238403000)},
    {_DATAF(-0.91311860084533691000), _DATAF(-0.40769401192665100000)},
    {_DATAF(-0.91327488422393799000), _DATAF(-0.40734380483627319000)},
    {_DATAF(-0.91343104839324951000), _DATAF(-0.40699353814125061000)},
    {_DATAF(-0.91358703374862671000), _DATAF(-0.40664321184158325000)},
    {_DATAF(-0.91374289989471436000), _DATAF(-0.40629282593727112000)},
    {_DATAF(-0.91389864683151245000), _DATAF(-0.40594238042831421000)},
    {_DATAF(-0.91405427455902100000), _DATAF(-0.40559187531471252000)},
    {_DATAF(-0.91420978307723999000), _DATAF(-0.40524131059646606000)},
    {_DATAF(-0.91436511278152466000), _DATAF(-0.40489068627357483000)},
    {_DATAF(-0.91452032327651978000), _DATAF(-0.40454000234603882000)},
    {_DATAF(-0.91467535495758057000), _DATAF(-0.40418925881385803000)},
    {_DATAF(-0.91483032703399658000), _DATAF(-0.40383845567703247000)},
    {_DATAF(-0.91498512029647827000), _DATAF(-0.40348759293556213000)},
    {_DATAF(-0.91513979434967041000), _DATAF(-0.40313667058944702000)},
    {_DATAF(-0.91529428958892822000), _DATAF(-0.40278568863868713000)},
    {_DATAF(-0.91544872522354126000), _DATAF(-0.40243464708328247000)},
    {_DATAF(-0.91560298204421997000), _DATAF(-0.40208354592323303000)},
    {_DATAF(-0.91575711965560913000), _DATAF(-0.40173238515853882000)},
    {_DATAF(-0.91591107845306396000), _DATAF(-0.40138116478919983000)},
    {_DATAF(-0.91606497764587402000), _DATAF(-0.40102988481521606000)},
    {_DATAF(-0.91621869802474976000), _DATAF(-0.40067857503890991000)},
    {_DATAF(-0.91637229919433594000), _DATAF(-0.40032717585563660000)},
    {_DATAF(-0.91652572154998779000), _DATAF(-0.39997571706771851000)},
    {_DATAF(-0.91667908430099487000), _DATAF(-0.39962419867515564000)},
    {_DATAF(-0.91683226823806763000), _DATAF(-0.39927262067794800000)},
    {_DATAF(-0.91698527336120605000), _DATAF(-0.39892101287841797000)},
    {_DATAF(-0.91713821887969971000), _DATAF(-0.39856931567192078000)},
    {_DATAF(-0.91729098558425903000), _DATAF(-0.39821755886077881000)},
    {_DATAF(-0.91744363307952881000), _DATAF(-0.39786574244499207000)},
    {_DATAF(-0.91759616136550903000), _DATAF(-0.39751389622688293000)},
    {_DATAF(-0.91774851083755493000), _DATAF(-0.39716196060180664000)},
    {_DATAF(-0.91790080070495605000), _DATAF(-0.39680999517440796000)},
    {_DATAF(-0.91805291175842285000), _DATAF(-0.39645794034004211000)},
    {_DATAF(-0.91820484399795532000), _DATAF(-0.39610585570335388000)},
    {_DATAF(-0.91835671663284302000), _DATAF(-0.39575368165969849000)},
    {_DATAF(-0.91850841045379639000), _DATAF(-0.39540147781372070000)},
    {_DATAF(-0.91865998506546021000), _DATAF(-0.39504921436309814000)},
    {_DATAF(-0.91881138086318970000), _DATAF(-0.39469686150550842000)},
    {_DATAF(-0.91896271705627441000), _DATAF(-0.39434447884559631000)},
    {_DATAF(-0.91911387443542480000), _DATAF(-0.39399203658103943000)},
    {_DATAF(-0.91926485300064087000), _DATAF(-0.39363953471183777000)},
    {_DATAF(-0.91941577196121216000), _DATAF(-0.39328697323799133000)},
    {_DATAF(-0.91956651210784912000), _DATAF(-0.39293435215950012000)},
    {_DATAF(-0.91971713304519653000), _DATAF(-0.39258167147636414000)},
    {_DATAF(-0.91986763477325439000), _DATAF(-0.39222893118858337000)},
    {_DATAF(-0.92001795768737793000), _DATAF(-0.39187613129615784000)},
    {_DATAF(-0.92016822099685669000), _DATAF(-0.39152330160140991000)},
    {_DATAF(-0.92031830549240112000), _DATAF(-0.39117038249969482000)},
    {_DATAF(-0.92046821117401123000), _DATAF(-0.39081740379333496000)},
    {_DATAF(-0.92061805725097656000), _DATAF(-0.39046439528465271000)},
    {_DATAF(-0.92076772451400757000), _DATAF(-0.39011132717132568000)},
    {_DATAF(-0.92091721296310425000), _DATAF(-0.38975816965103149000)},
    {_DATAF(-0.92106664180755615000), _DATAF(-0.38940498232841492000)},
    {_DATAF(-0.92121589183807373000), _DATAF(-0.38905173540115356000)},
    {_DATAF(-0.92136502265930176000), _DATAF(-0.38869842886924744000)},
    {_DATAF(-0.92151403427124023000), _DATAF(-0.38834503293037415000)},
    {_DATAF(-0.92166292667388916000), _DATAF(-0.38799160718917847000)},
    {_DATAF(-0.92181164026260376000), _DATAF(-0.38763815164566040000)},
    {_DATAF(-0.92196023464202881000), _DATAF(-0.38728460669517517000)},
    {_DATAF(-0.92210865020751953000), _DATAF(-0.38693100214004517000)},
    {_DATAF(-0.92225700616836548000), _DATAF(-0.38657733798027039000)},
    {_DATAF(-0.92240518331527710000), _DATAF(-0.38622364401817322000)},
    {_DATAF(-0.92255324125289917000), _DATAF(-0.38586989045143127000)},
    {_DATAF(-0.92270112037658691000), _DATAF(-0.38551604747772217000)},
    {_DATAF(-0.92284888029098511000), _DATAF(-0.38516217470169067000)},
    {_DATAF(-0.92299652099609375000), _DATAF(-0.38480824232101440000)},
    {_DATAF(-0.92314404249191284000), _DATAF(-0.38445425033569336000)},
    {_DATAF(-0.92329144477844238000), _DATAF(-0.38410019874572754000)},
    {_DATAF(-0.92343866825103760000), _DATAF(-0.38374608755111694000)},
    {_DATAF(-0.92358577251434326000), _DATAF(-0.38339191675186157000)},
    {_DATAF(-0.92373269796371460000), _DATAF(-0.38303771615028381000)},
    {_DATAF(-0.92387950420379639000), _DATAF(-0.38268342614173889000)},
    {_DATAF(-0.92402625083923340000), _DATAF(-0.38232910633087158000)},
    {_DATAF(-0.92417275905609131000), _DATAF(-0.38197472691535950000)},
    {_DATAF(-0.92431920766830444000), _DATAF(-0.38162025809288025000)},
    {_DATAF(-0.92446547746658325000), _DATAF(-0.38126575946807861000)},
    {_DATAF(-0.92461162805557251000), _DATAF(-0.38091120123863220000)},
    {_DATAF(-0.92475759983062744000), _DATAF(-0.38055661320686340000)},
    {_DATAF(-0.92490351200103760000), _DATAF(-0.38020193576812744000)},
    {_DATAF(-0.92504924535751343000), _DATAF(-0.37984719872474670000)},
    {_DATAF(-0.92519485950469971000), _DATAF(-0.37949243187904358000)},
    {_DATAF(-0.92534029483795166000), _DATAF(-0.37913760542869568000)},
    {_DATAF(-0.92548561096191406000), _DATAF(-0.37878268957138062000)},
    {_DATAF(-0.92563080787658691000), _DATAF(-0.37842774391174316000)},
    {_DATAF(-0.92577588558197021000), _DATAF(-0.37807273864746094000)},
    {_DATAF(-0.92592078447341919000), _DATAF(-0.37771770358085632000)},
    {_DATAF(-0.92606556415557861000), _DATAF(-0.37736257910728455000)},
    {_DATAF(-0.92621022462844849000), _DATAF(-0.37700742483139038000)},
    {_DATAF(-0.92635476589202881000), _DATAF(-0.37665218114852905000)},
    {_DATAF(-0.92649912834167480000), _DATAF(-0.37629690766334534000)},
    {_DATAF(-0.92664337158203125000), _DATAF(-0.37594157457351685000)},
    {_DATAF(-0.92678749561309814000), _DATAF(-0.37558618187904358000)},
    {_DATAF(-0.92693144083023071000), _DATAF(-0.37523072957992554000)},
    {_DATAF(-0.92707526683807373000), _DATAF(-0.37487521767616272000)},
    {_DATAF(-0.92721897363662720000), _DATAF(-0.37451967597007751000)},
    {_DATAF(-0.92736250162124634000), _DATAF(-0.37416407465934753000)},
    {_DATAF(-0.92750597000122070000), _DATAF(-0.37380838394165039000)},
    {_DATAF(-0.92764925956726074000), _DATAF(-0.37345266342163086000)},
    {_DATAF(-0.92779237031936646000), _DATAF(-0.37309691309928894000)},
    {_DATAF(-0.92793542146682739000), _DATAF(-0.37274107336997986000)},
    {_DATAF(-0.92807829380035400000), _DATAF(-0.37238517403602600000)},
    {_DATAF(-0.92822098731994629000), _DATAF(-0.37202924489974976000)},
    {_DATAF(-0.92836362123489380000), _DATAF(-0.37167325615882874000)},
    {_DATAF(-0.92850607633590698000), _DATAF(-0.37131720781326294000)},
    {_DATAF(-0.92864841222763062000), _DATAF(-0.37096109986305237000)},
    {_DATAF(-0.92879062891006470000), _DATAF(-0.37060493230819702000)},
    {_DATAF(-0.92893266677856445000), _DATAF(-0.37024870514869690000)},
    {_DATAF(-0.92907458543777466000), _DATAF(-0.36989244818687439000)},
    {_DATAF(-0.92921638488769531000), _DATAF(-0.36953613162040710000)},
    {_DATAF(-0.92935800552368164000), _DATAF(-0.36917975544929504000)},
    {_DATAF(-0.92949950695037842000), _DATAF(-0.36882331967353821000)},
    {_DATAF(-0.92964088916778564000), _DATAF(-0.36846682429313660000)},
    {_DATAF(-0.92978215217590332000), _DATAF(-0.36811029911041260000)},
    {_DATAF(-0.92992323637008667000), _DATAF(-0.36775368452072144000)},
    {_DATAF(-0.93006420135498047000), _DATAF(-0.36739704012870789000)},
    {_DATAF(-0.93020504713058472000), _DATAF(-0.36704033613204956000)},
    {_DATAF(-0.93034571409225464000), _DATAF(-0.36668360233306885000)},
    {_DATAF(-0.93048626184463501000), _DATAF(-0.36632677912712097000)},
    {_DATAF(-0.93062669038772583000), _DATAF(-0.36596992611885071000)},
    {_DATAF(-0.93076694011688232000), _DATAF(-0.36561298370361328000)},
    {_DATAF(-0.93090713024139404000), _DATAF(-0.36525601148605347000)},
    {_DATAF(-0.93104708194732666000), _DATAF(-0.36489900946617126000)},
    {_DATAF(-0.93118697404861450000), _DATAF(-0.36454191803932190000)},
    {_DATAF(-0.93132668733596802000), _DATAF(-0.36418479681015015000)},
    {_DATAF(-0.93146628141403198000), _DATAF(-0.36382761597633362000)},
    {_DATAF(-0.93160575628280640000), _DATAF(-0.36347037553787231000)},
    {_DATAF(-0.93174505233764648000), _DATAF(-0.36311307549476624000)},
    {_DATAF(-0.93188428878784180000), _DATAF(-0.36275571584701538000)},
    {_DATAF(-0.93202328681945801000), _DATAF(-0.36239832639694214000)},
    {_DATAF(-0.93216222524642944000), _DATAF(-0.36204087734222412000)},
    {_DATAF(-0.93230098485946655000), _DATAF(-0.36168336868286133000)},
    {_DATAF(-0.93243962526321411000), _DATAF(-0.36132580041885376000)},
    {_DATAF(-0.93257814645767212000), _DATAF(-0.36096820235252380000)},
    {_DATAF(-0.93271648883819580000), _DATAF(-0.36061051487922668000)},
    {_DATAF(-0.93285471200942993000), _DATAF(-0.36025279760360718000)},
    {_DATAF(-0.93299281597137451000), _DATAF(-0.35989505052566528000)},
    {_DATAF(-0.93313074111938477000), _DATAF(-0.35953721404075623000)},
    {_DATAF(-0.93326854705810547000), _DATAF(-0.35917934775352478000)},
    {_DATAF(-0.93340623378753662000), _DATAF(-0.35882139205932617000)},
    {_DATAF(-0.93354380130767822000), _DATAF(-0.35846340656280518000)},
    {_DATAF(-0.93368119001388550000), _DATAF(-0.35810539126396179000)},
    {_DATAF(-0.93381845951080322000), _DATAF(-0.35774728655815125000)},
    {_DATAF(-0.93395555019378662000), _DATAF(-0.35738915205001831000)},
    {_DATAF(-0.93409252166748047000), _DATAF(-0.35703095793724060000)},
    {_DATAF(-0.93422937393188477000), _DATAF(-0.35667270421981812000)},
    {_DATAF(-0.93436610698699951000), _DATAF(-0.35631442070007324000)},
    {_DATAF(-0.93450272083282471000), _DATAF(-0.35595607757568359000)},
    {_DATAF(-0.93463915586471558000), _DATAF(-0.35559767484664917000)},
    {_DATAF(-0.93477541208267212000), _DATAF(-0.35523921251296997000)},
    {_DATAF(-0.93491160869598389000), _DATAF(-0.35488069057464600000)},
    {_DATAF(-0.93504762649536133000), _DATAF(-0.35452213883399963000)},
    {_DATAF(-0.93518352508544922000), _DATAF(-0.35416352748870850000)},
    {_DATAF(-0.93531924486160278000), _DATAF(-0.35380485653877258000)},
    {_DATAF(-0.93545484542846680000), _DATAF(-0.35344615578651428000)},
    {_DATAF(-0.93559032678604126000), _DATAF(-0.35308736562728882000)},
    {_DATAF(-0.93572568893432617000), _DATAF(-0.35272854566574097000)},
    {_DATAF(-0.93586087226867676000), _DATAF(-0.35236969590187073000)},
    {_DATAF(-0.93599593639373779000), _DATAF(-0.35201075673103333000)},
    {_DATAF(-0.93613088130950928000), _DATAF(-0.35165178775787354000)},
    {_DATAF(-0.93626564741134644000), _DATAF(-0.35129275918006897000)},
    {_DATAF(-0.93640029430389404000), _DATAF(-0.35093367099761963000)},
    {_DATAF(-0.93653482198715210000), _DATAF(-0.35057455301284790000)},
    {_DATAF(-0.93666923046112061000), _DATAF(-0.35021537542343140000)},
    {_DATAF(-0.93680346012115479000), _DATAF(-0.34985613822937012000)},
    {_DATAF(-0.93693757057189941000), _DATAF(-0.34949684143066406000)},
    {_DATAF(-0.93707150220870972000), _DATAF(-0.34913751482963562000)},
    {_DATAF(-0.93720531463623047000), _DATAF(-0.34877812862396240000)},
    {_DATAF(-0.93733900785446167000), _DATAF(-0.34841868281364441000)},
    {_DATAF(-0.93747258186340332000), _DATAF(-0.34805917739868164000)},
    {_DATAF(-0.93760597705841064000), _DATAF(-0.34769964218139648000)},
    {_DATAF(-0.93773925304412842000), _DATAF(-0.34734004735946655000)},
    {_DATAF(-0.93787235021591187000), _DATAF(-0.34698042273521423000)},
    {_DATAF(-0.93800538778305054000), _DATAF(-0.34662070870399475000)},
    {_DATAF(-0.93813824653625488000), _DATAF(-0.34626096487045288000)},
    {_DATAF(-0.93827092647552490000), _DATAF(-0.34590116143226624000)},
    {_DATAF(-0.93840354681015015000), _DATAF(-0.34554132819175720000)},
    {_DATAF(-0.93853598833084106000), _DATAF(-0.34518143534660339000)},
    {_DATAF(-0.93866831064224243000), _DATAF(-0.34482148289680481000)},
    {_DATAF(-0.93880045413970947000), _DATAF(-0.34446147084236145000)},
    {_DATAF(-0.93893247842788696000), _DATAF(-0.34410142898559570000)},
    {_DATAF(-0.93906438350677490000), _DATAF(-0.34374132752418518000)},
    {_DATAF(-0.93919610977172852000), _DATAF(-0.34338116645812988000)},
    {_DATAF(-0.93932771682739258000), _DATAF(-0.34302097558975220000)},
    {_DATAF(-0.93945920467376709000), _DATAF(-0.34266072511672974000)},
    {_DATAF(-0.93959057331085205000), _DATAF(-0.34230041503906250000)},
    {_DATAF(-0.93972176313400269000), _DATAF(-0.34194007515907288000)},
    {_DATAF(-0.93985283374786377000), _DATAF(-0.34157964587211609000)},
    {_DATAF(-0.93998372554779053000), _DATAF(-0.34121921658515930000)},
    {_DATAF(-0.94011455774307251000), _DATAF(-0.34085869789123535000)},
    {_DATAF(-0.94024521112442017000), _DATAF(-0.34049814939498901000)},
    {_DATAF(-0.94037568569183350000), _DATAF(-0.34013754129409790000)},
    {_DATAF(-0.94050604104995728000), _DATAF(-0.33977687358856201000)},
    {_DATAF(-0.94063627719879150000), _DATAF(-0.33941617608070374000)},
    {_DATAF(-0.94076639413833618000), _DATAF(-0.33905541896820068000)},
    {_DATAF(-0.94089633226394653000), _DATAF(-0.33869463205337524000)},
    {_DATAF(-0.94102615118026733000), _DATAF(-0.33833375573158264000)},
    {_DATAF(-0.94115585088729858000), _DATAF(-0.33797284960746765000)},
    {_DATAF(-0.94128537178039551000), _DATAF(-0.33761191368103027000)},
    {_DATAF(-0.94141477346420288000), _DATAF(-0.33725091814994812000)},
    {_DATAF(-0.94154405593872070000), _DATAF(-0.33688986301422119000)},
    {_DATAF(-0.94167321920394897000), _DATAF(-0.33652874827384949000)},
    {_DATAF(-0.94180220365524292000), _DATAF(-0.33616760373115540000)},
    {_DATAF(-0.94193100929260254000), _DATAF(-0.33580639958381653000)},
    {_DATAF(-0.94205975532531738000), _DATAF(-0.33544513583183289000)},
    {_DATAF(-0.94218832254409790000), _DATAF(-0.33508384227752686000)},
    {_DATAF(-0.94231677055358887000), _DATAF(-0.33472248911857605000)},
    {_DATAF(-0.94244503974914551000), _DATAF(-0.33436110615730286000)},
    {_DATAF(-0.94257318973541260000), _DATAF(-0.33399966359138489000)},
    {_DATAF(-0.94270122051239014000), _DATAF(-0.33363816142082214000)},
    {_DATAF(-0.94282907247543335000), _DATAF(-0.33327659964561462000)},
    {_DATAF(-0.94295686483383179000), _DATAF(-0.33291500806808472000)},
    {_DATAF(-0.94308441877365112000), _DATAF(-0.33255335688591003000)},
    {_DATAF(-0.94321191310882568000), _DATAF(-0.33219167590141296000)},
    {_DATAF(-0.94333922863006592000), _DATAF(-0.33182993531227112000)},
    {_DATAF(-0.94346642494201660000), _DATAF(-0.33146813511848450000)},
    {_DATAF(-0.94359344244003296000), _DATAF(-0.33110630512237549000)},
    {_DATAF(-0.94372034072875977000), _DATAF(-0.33074441552162170000)},
    {_DATAF(-0.94384711980819702000), _DATAF(-0.33038249611854553000)},
    {_DATAF(-0.94397377967834473000), _DATAF(-0.33002048730850220000)},
    {_DATAF(-0.94410026073455811000), _DATAF(-0.32965844869613647000)},
    {_DATAF(-0.94422662258148193000), _DATAF(-0.32929638028144836000)},
    {_DATAF(-0.94435280561447144000), _DATAF(-0.32893425226211548000)},
    {_DATAF(-0.94447892904281616000), _DATAF(-0.32857206463813782000)},
    {_DATAF(-0.94460481405258179000), _DATAF(-0.32820984721183777000)},
    {_DATAF(-0.94473063945770264000), _DATAF(-0.32784757018089294000)},
    {_DATAF(-0.94485628604888916000), _DATAF(-0.32748523354530334000)},
    {_DATAF(-0.94498181343078613000), _DATAF(-0.32712286710739136000)},
    {_DATAF(-0.94510722160339355000), _DATAF(-0.32676044106483459000)},
    {_DATAF(-0.94523245096206665000), _DATAF(-0.32639798521995544000)},
    {_DATAF(-0.94535756111145020000), _DATAF(-0.32603546977043152000)},
    {_DATAF(-0.94548249244689941000), _DATAF(-0.32567289471626282000)},
    {_DATAF(-0.94560730457305908000), _DATAF(-0.32531028985977173000)},
    {_DATAF(-0.94573199748992920000), _DATAF(-0.32494762539863586000)},
    {_DATAF(-0.94585657119750977000), _DATAF(-0.32458493113517761000)},
    {_DATAF(-0.94598096609115601000), _DATAF(-0.32422217726707458000)},
    {_DATAF(-0.94610524177551270000), _DATAF(-0.32385936379432678000)},
    {_DATAF(-0.94622933864593506000), _DATAF(-0.32349652051925659000)},
    {_DATAF(-0.94635337591171265000), _DATAF(-0.32313361763954163000)},
    {_DATAF(-0.94647717475891113000), _DATAF(-0.32277068495750427000)},
    {_DATAF(-0.94660091400146484000), _DATAF(-0.32240769267082214000)},
    {_DATAF(-0.94672447443008423000), _DATAF(-0.32204464077949524000)},
    {_DATAF(-0.94684791564941406000), _DATAF(-0.32168155908584595000)},
    {_DATAF(-0.94697123765945435000), _DATAF(-0.32131841778755188000)},
    {_DATAF(-0.94709438085556030000), _DATAF(-0.32095524668693542000)},
    {_DATAF(-0.94721740484237671000), _DATAF(-0.32059201598167419000)},
    {_DATAF(-0.94734025001525879000), _DATAF(-0.32022872567176819000)},
    {_DATAF(-0.94746297597885132000), _DATAF(-0.31986540555953979000)},
    {_DATAF(-0.94758558273315430000), _DATAF(-0.31950202584266663000)},
    {_DATAF(-0.94770807027816772000), _DATAF(-0.31913861632347107000)},
    {_DATAF(-0.94783037900924683000), _DATAF(-0.31877514719963074000)},
    {_DATAF(-0.94795256853103638000), _DATAF(-0.31841164827346802000)},
    {_DATAF(-0.94807457923889160000), _DATAF(-0.31804808974266052000)},
    {_DATAF(-0.94819647073745728000), _DATAF(-0.31768447160720825000)},
    {_DATAF(-0.94831824302673340000), _DATAF(-0.31732082366943359000)},
    {_DATAF(-0.94843989610671997000), _DATAF(-0.31695711612701416000)},
    {_DATAF(-0.94856137037277222000), _DATAF(-0.31659337878227234000)},
    {_DATAF(-0.94868266582489014000), _DATAF(-0.31622958183288574000)},
    {_DATAF(-0.94880390167236328000), _DATAF(-0.31586575508117676000)},
    {_DATAF(-0.94892495870590210000), _DATAF(-0.31550186872482300000)},
    {_DATAF(-0.94904589653015137000), _DATAF(-0.31513792276382446000)},
    {_DATAF(-0.94916665554046631000), _DATAF(-0.31477394700050354000)},
    {_DATAF(-0.94928729534149170000), _DATAF(-0.31440994143486023000)},
    {_DATAF(-0.94940781593322754000), _DATAF(-0.31404584646224976000)},
    {_DATAF(-0.94952815771102905000), _DATAF(-0.31368175148963928000)},
    {_DATAF(-0.94964838027954102000), _DATAF(-0.31331756711006165000)},
    {_DATAF(-0.94976848363876343000), _DATAF(-0.31295338273048401000)},
    {_DATAF(-0.94988846778869629000), _DATAF(-0.31258910894393921000)},
    {_DATAF(-0.95000827312469482000), _DATAF(-0.31222480535507202000)},
    {_DATAF(-0.95012789964675903000), _DATAF(-0.31186047196388245000)},
    {_DATAF(-0.95024746656417847000), _DATAF(-0.31149607896804810000)},
    {_DATAF(-0.95036685466766357000), _DATAF(-0.31113162636756897000)},
    {_DATAF(-0.95048606395721436000), _DATAF(-0.31076714396476746000)},
    {_DATAF(-0.95060515403747559000), _DATAF(-0.31040263175964355000)},
    {_DATAF(-0.95072412490844727000), _DATAF(-0.31003805994987488000)},
    {_DATAF(-0.95084297657012939000), _DATAF(-0.30967342853546143000)},
    {_DATAF(-0.95096164941787720000), _DATAF(-0.30930876731872559000)},
    {_DATAF(-0.95108020305633545000), _DATAF(-0.30894404649734497000)},
    {_DATAF(-0.95119863748550415000), _DATAF(-0.30857929587364197000)},
    {_DATAF(-0.95131689310073853000), _DATAF(-0.30821448564529419000)},
    {_DATAF(-0.95143502950668335000), _DATAF(-0.30784964561462402000)},
    {_DATAF(-0.95155298709869385000), _DATAF(-0.30748474597930908000)},
    {_DATAF(-0.95167088508605957000), _DATAF(-0.30711981654167175000)},
    {_DATAF(-0.95178854465484619000), _DATAF(-0.30675482749938965000)},
    {_DATAF(-0.95190614461898804000), _DATAF(-0.30638980865478516000)},
    {_DATAF(-0.95202356576919556000), _DATAF(-0.30602473020553589000)},
    {_DATAF(-0.95214086771011353000), _DATAF(-0.30565959215164185000)},
    {_DATAF(-0.95225799083709717000), _DATAF(-0.30529442429542542000)},
    {_DATAF(-0.95237499475479126000), _DATAF(-0.30492922663688660000)},
    {_DATAF(-0.95249187946319580000), _DATAF(-0.30456396937370300000)},
    {_DATAF(-0.95260858535766602000), _DATAF(-0.30419868230819702000)},
    {_DATAF(-0.95272517204284668000), _DATAF(-0.30383333563804626000)},
    {_DATAF(-0.95284163951873779000), _DATAF(-0.30346795916557312000)},
    {_DATAF(-0.95295792818069458000), _DATAF(-0.30310252308845520000)},
    {_DATAF(-0.95307409763336182000), _DATAF(-0.30273702740669250000)},
    {_DATAF(-0.95319014787673950000), _DATAF(-0.30237150192260742000)},
    {_DATAF(-0.95330601930618286000), _DATAF(-0.30200594663619995000)},
    {_DATAF(-0.95342177152633667000), _DATAF(-0.30164033174514771000)},
    {_DATAF(-0.95353740453720093000), _DATAF(-0.30127468705177307000)},
    {_DATAF(-0.95365285873413086000), _DATAF(-0.30090898275375366000)},
    {_DATAF(-0.95376819372177124000), _DATAF(-0.30054324865341187000)},
    {_DATAF(-0.95388334989547729000), _DATAF(-0.30017745494842529000)},
    {_DATAF(-0.95399844646453857000), _DATAF(-0.29981163144111633000)},
    {_DATAF(-0.95411330461502075000), _DATAF(-0.29944574832916260000)},
    {_DATAF(-0.95422810316085815000), _DATAF(-0.29907983541488647000)},
    {_DATAF(-0.95434272289276123000), _DATAF(-0.29871386289596558000)},
    {_DATAF(-0.95445722341537476000), _DATAF(-0.29834786057472229000)},
    {_DATAF(-0.95457154512405396000), _DATAF(-0.29798179864883423000)},
    {_DATAF(-0.95468574762344360000), _DATAF(-0.29761570692062378000)},
    {_DATAF(-0.95479983091354370000), _DATAF(-0.29724955558776855000)},
    {_DATAF(-0.95491373538970947000), _DATAF(-0.29688337445259094000)},
    {_DATAF(-0.95502752065658569000), _DATAF(-0.29651716351509094000)},
    {_DATAF(-0.95514118671417236000), _DATAF(-0.29615089297294617000)},
    {_DATAF(-0.95525467395782471000), _DATAF(-0.29578456282615662000)},
    {_DATAF(-0.95536804199218750000), _DATAF(-0.29541820287704468000)},
    {_DATAF(-0.95548123121261597000), _DATAF(-0.29505181312561035000)},
    {_DATAF(-0.95559436082839966000), _DATAF(-0.29468536376953125000)},
    {_DATAF(-0.95570725202560425000), _DATAF(-0.29431888461112976000)},
    {_DATAF(-0.95582008361816406000), _DATAF(-0.29395234584808350000)},
    {_DATAF(-0.95593273639678955000), _DATAF(-0.29358577728271484000)},
    {_DATAF(-0.95604526996612549000), _DATAF(-0.29321914911270142000)},
    {_DATAF(-0.95615762472152710000), _DATAF(-0.29285249114036560000)},
    {_DATAF(-0.95626986026763916000), _DATAF(-0.29248580336570740000)},
    {_DATAF(-0.95638197660446167000), _DATAF(-0.29211905598640442000)},
    {_DATAF(-0.95649391412734985000), _DATAF(-0.29175224900245667000)},
    {_DATAF(-0.95660573244094849000), _DATAF(-0.29138544201850891000)},
    {_DATAF(-0.95671743154525757000), _DATAF(-0.29101854562759399000)},
    {_DATAF(-0.95682895183563232000), _DATAF(-0.29065164923667908000)},
    {_DATAF(-0.95694035291671753000), _DATAF(-0.29028466343879700000)},
    {_DATAF(-0.95705157518386841000), _DATAF(-0.28991767764091492000)},
    {_DATAF(-0.95716267824172974000), _DATAF(-0.28955063223838806000)},
    {_DATAF(-0.95727366209030151000), _DATAF(-0.28918352723121643000)},
    {_DATAF(-0.95738452672958374000), _DATAF(-0.28881642222404480000)},
    {_DATAF(-0.95749521255493164000), _DATAF(-0.28844922780990601000)},
    {_DATAF(-0.95760571956634521000), _DATAF(-0.28808203339576721000)},
    {_DATAF(-0.95771616697311401000), _DATAF(-0.28771474957466125000)},
    {_DATAF(-0.95782643556594849000), _DATAF(-0.28734746575355530000)},
    {_DATAF(-0.95793652534484863000), _DATAF(-0.28698012232780457000)},
    {_DATAF(-0.95804649591445923000), _DATAF(-0.28661271929740906000)},
    {_DATAF(-0.95815634727478027000), _DATAF(-0.28624531626701355000)},
    {_DATAF(-0.95826607942581177000), _DATAF(-0.28587782382965088000)},
    {_DATAF(-0.95837563276290894000), _DATAF(-0.28551033139228821000)},
    {_DATAF(-0.95848506689071655000), _DATAF(-0.28514277935028076000)},
    {_DATAF(-0.95859432220458984000), _DATAF(-0.28477516770362854000)},
    {_DATAF(-0.95870345830917358000), _DATAF(-0.28440752625465393000)},
    {_DATAF(-0.95881247520446777000), _DATAF(-0.28403985500335693000)},
    {_DATAF(-0.95892131328582764000), _DATAF(-0.28367212414741516000)},
    {_DATAF(-0.95903003215789795000), _DATAF(-0.28330436348915100000)},
    {_DATAF(-0.95913863182067871000), _DATAF(-0.28293657302856445000)},
    {_DATAF(-0.95924705266952515000), _DATAF(-0.28256872296333313000)},
    {_DATAF(-0.95935535430908203000), _DATAF(-0.28220084309577942000)},
    {_DATAF(-0.95946347713470459000), _DATAF(-0.28183290362358093000)},
    {_DATAF(-0.95957154035568237000), _DATAF(-0.28146493434906006000)},
    {_DATAF(-0.95967936515808105000), _DATAF(-0.28109693527221680000)},
    {_DATAF(-0.95978713035583496000), _DATAF(-0.28072887659072876000)},
    {_DATAF(-0.95989471673965454000), _DATAF(-0.28036078810691833000)},
    {_DATAF(-0.96000212430953979000), _DATAF(-0.27999264001846313000)},
    {_DATAF(-0.96010947227478027000), _DATAF(-0.27962446212768555000)},
    {_DATAF(-0.96021664142608643000), _DATAF(-0.27925625443458557000)},
    {_DATAF(-0.96032363176345825000), _DATAF(-0.27888798713684082000)},
    {_DATAF(-0.96043050289154053000), _DATAF(-0.27851969003677368000)},
    {_DATAF(-0.96053725481033325000), _DATAF(-0.27815136313438416000)},
    {_DATAF(-0.96064388751983643000), _DATAF(-0.27778297662734985000)},
    {_DATAF(-0.96075034141540527000), _DATAF(-0.27741453051567078000)},
    {_DATAF(-0.96085661649703979000), _DATAF(-0.27704608440399170000)},
    {_DATAF(-0.96096283197402954000), _DATAF(-0.27667757868766785000)},
    {_DATAF(-0.96106886863708496000), _DATAF(-0.27630904316902161000)},
    {_DATAF(-0.96117472648620605000), _DATAF(-0.27594044804573059000)},
    {_DATAF(-0.96128046512603760000), _DATAF(-0.27557182312011719000)},
    {_DATAF(-0.96138608455657959000), _DATAF(-0.27520313858985901000)},
    {_DATAF(-0.96149158477783203000), _DATAF(-0.27483445405960083000)},
    {_DATAF(-0.96159690618515015000), _DATAF(-0.27446570992469788000)},
    {_DATAF(-0.96170204877853394000), _DATAF(-0.27409690618515015000)},
    {_DATAF(-0.96180713176727295000), _DATAF(-0.27372807264328003000)},
    {_DATAF(-0.96191203594207764000), _DATAF(-0.27335920929908752000)},
    {_DATAF(-0.96201676130294800000), _DATAF(-0.27299031615257263000)},
    {_DATAF(-0.96212142705917358000), _DATAF(-0.27262136340141296000)},
    {_DATAF(-0.96222585439682007000), _DATAF(-0.27225238084793091000)},
    {_DATAF(-0.96233022212982178000), _DATAF(-0.27188333868980408000)},
    {_DATAF(-0.96243441104888916000), _DATAF(-0.27151426672935486000)},
    {_DATAF(-0.96253848075866699000), _DATAF(-0.27114516496658325000)},
    {_DATAF(-0.96264237165451050000), _DATAF(-0.27077600359916687000)},
    {_DATAF(-0.96274614334106445000), _DATAF(-0.27040681242942810000)},
    {_DATAF(-0.96284979581832886000), _DATAF(-0.27003759145736694000)},
    {_DATAF(-0.96295326948165894000), _DATAF(-0.26966831088066101000)},
    {_DATAF(-0.96305662393569946000), _DATAF(-0.26929903030395508000)},
    {_DATAF(-0.96315979957580566000), _DATAF(-0.26892966032028198000)},
    {_DATAF(-0.96326285600662231000), _DATAF(-0.26856029033660889000)},
    {_DATAF(-0.96336579322814941000), _DATAF(-0.26819086074829102000)},
    {_DATAF(-0.96346855163574219000), _DATAF(-0.26782140135765076000)},
    {_DATAF(-0.96357119083404541000), _DATAF(-0.26745188236236572000)},
    {_DATAF(-0.96367371082305908000), _DATAF(-0.26708233356475830000)},
    {_DATAF(-0.96377605199813843000), _DATAF(-0.26671275496482849000)},
    {_DATAF(-0.96387827396392822000), _DATAF(-0.26634314656257629000)},
    {_DATAF(-0.96398037672042847000), _DATAF(-0.26597347855567932000)},
    {_DATAF(-0.96408230066299438000), _DATAF(-0.26560378074645996000)},
    {_DATAF(-0.96418404579162598000), _DATAF(-0.26523402333259583000)},
    {_DATAF(-0.96428573131561279000), _DATAF(-0.26486423611640930000)},
    {_DATAF(-0.96438723802566528000), _DATAF(-0.26449441909790039000)},
    {_DATAF(-0.96448856592178345000), _DATAF(-0.26412457227706909000)},
    {_DATAF(-0.96458977460861206000), _DATAF(-0.26375466585159302000)},
    {_DATAF(-0.96469086408615112000), _DATAF(-0.26338472962379456000)},
    {_DATAF(-0.96479183435440063000), _DATAF(-0.26301476359367371000)},
    {_DATAF(-0.96489262580871582000), _DATAF(-0.26264476776123047000)},
    {_DATAF(-0.96499323844909668000), _DATAF(-0.26227471232414246000)},
    {_DATAF(-0.96509379148483276000), _DATAF(-0.26190462708473206000)},
    {_DATAF(-0.96519410610198975000), _DATAF(-0.26153448224067688000)},
    {_DATAF(-0.96529436111450195000), _DATAF(-0.26116433739662170000)},
    {_DATAF(-0.96539443731307983000), _DATAF(-0.26079410314559937000)},
    {_DATAF(-0.96549439430236816000), _DATAF(-0.26042386889457703000)},
    {_DATAF(-0.96559417247772217000), _DATAF(-0.26005360484123230000)},
    {_DATAF(-0.96569383144378662000), _DATAF(-0.25968328118324280000)},
    {_DATAF(-0.96579337120056152000), _DATAF(-0.25931292772293091000)},
    {_DATAF(-0.96589273214340210000), _DATAF(-0.25894251465797424000)},
    {_DATAF(-0.96599197387695313000), _DATAF(-0.25857207179069519000)},
    {_DATAF(-0.96609103679656982000), _DATAF(-0.25820159912109375000)},
    {_DATAF(-0.96618998050689697000), _DATAF(-0.25783109664916992000)},
    {_DATAF(-0.96628880500793457000), _DATAF(-0.25746056437492371000)},
    {_DATAF(-0.96638745069503784000), _DATAF(-0.25708997249603271000)},
    {_DATAF(-0.96648597717285156000), _DATAF(-0.25671935081481934000)},
    {_DATAF(-0.96658438444137573000), _DATAF(-0.25634866952896118000)},
    {_DATAF(-0.96668261289596558000), _DATAF(-0.25597798824310303000)},
    {_DATAF(-0.96678072214126587000), _DATAF(-0.25560724735260010000)},
    {_DATAF(-0.96687865257263184000), _DATAF(-0.25523647665977478000)},
    {_DATAF(-0.96697646379470825000), _DATAF(-0.25486564636230469000)},
    {_DATAF(-0.96707415580749512000), _DATAF(-0.25449481606483459000)},
    {_DATAF(-0.96717166900634766000), _DATAF(-0.25412392616271973000)},
    {_DATAF(-0.96726906299591064000), _DATAF(-0.25375300645828247000)},
    {_DATAF(-0.96736627817153931000), _DATAF(-0.25338202714920044000)},
    {_DATAF(-0.96746337413787842000), _DATAF(-0.25301104784011841000)},
    {_DATAF(-0.96756035089492798000), _DATAF(-0.25264000892639160000)},
    {_DATAF(-0.96765714883804321000), _DATAF(-0.25226894021034241000)},
    {_DATAF(-0.96775382757186890000), _DATAF(-0.25189781188964844000)},
    {_DATAF(-0.96785038709640503000), _DATAF(-0.25152668356895447000)},
    {_DATAF(-0.96794676780700684000), _DATAF(-0.25115549564361572000)},
    {_DATAF(-0.96804302930831909000), _DATAF(-0.25078427791595459000)},
    {_DATAF(-0.96813911199569702000), _DATAF(-0.25041300058364868000)},
    {_DATAF(-0.96823507547378540000), _DATAF(-0.25004172325134277000)},
    {_DATAF(-0.96833086013793945000), _DATAF(-0.24967038631439209000)},
    {_DATAF(-0.96842658519744873000), _DATAF(-0.24929900467395782000)},
    {_DATAF(-0.96852207183837891000), _DATAF(-0.24892760813236237000)},
    {_DATAF(-0.96861749887466431000), _DATAF(-0.24855616688728333000)},
    {_DATAF(-0.96871274709701538000), _DATAF(-0.24818468093872070000)},
    {_DATAF(-0.96880781650543213000), _DATAF(-0.24781316518783569000)},
    {_DATAF(-0.96890282630920410000), _DATAF(-0.24744161963462830000)},
    {_DATAF(-0.96899759769439697000), _DATAF(-0.24707002937793732000)},
    {_DATAF(-0.96909230947494507000), _DATAF(-0.24669840931892395000)},
    {_DATAF(-0.96918684244155884000), _DATAF(-0.24632674455642700000)},
    {_DATAF(-0.96928125619888306000), _DATAF(-0.24595504999160767000)},
    {_DATAF(-0.96937549114227295000), _DATAF(-0.24558331072330475000)},
    {_DATAF(-0.96946960687637329000), _DATAF(-0.24521154165267944000)},
    {_DATAF(-0.96956354379653931000), _DATAF(-0.24483974277973175000)},
    {_DATAF(-0.96965736150741577000), _DATAF(-0.24446789920330048000)},
    {_DATAF(-0.96975106000900269000), _DATAF(-0.24409602582454681000)},
    {_DATAF(-0.96984457969665527000), _DATAF(-0.24372410774230957000)},
    {_DATAF(-0.96993798017501831000), _DATAF(-0.24335215985774994000)},
    {_DATAF(-0.97003126144409180000), _DATAF(-0.24298018217086792000)},
    {_DATAF(-0.97012436389923096000), _DATAF(-0.24260815978050232000)},
    {_DATAF(-0.97021734714508057000), _DATAF(-0.24223610758781433000)},
    {_DATAF(-0.97031015157699585000), _DATAF(-0.24186401069164276000)},
    {_DATAF(-0.97040283679962158000), _DATAF(-0.24149188399314880000)},
    {_DATAF(-0.97049540281295776000), _DATAF(-0.24111972749233246000)},
    {_DATAF(-0.97058779001235962000), _DATAF(-0.24074752628803253000)},
    {_DATAF(-0.97068005800247192000), _DATAF(-0.24037529528141022000)},
    {_DATAF(-0.97077214717864990000), _DATAF(-0.24000301957130432000)},
    {_DATAF(-0.97086411714553833000), _DATAF(-0.23963071405887604000)},
    {_DATAF(-0.97095590829849243000), _DATAF(-0.23925837874412537000)},
    {_DATAF(-0.97104763984680176000), _DATAF(-0.23888599872589111000)},
    {_DATAF(-0.97113913297653198000), _DATAF(-0.23851358890533447000)},
    {_DATAF(-0.97123056650161743000), _DATAF(-0.23814114928245544000)},
    {_DATAF(-0.97132182121276855000), _DATAF(-0.23776866495609283000)},
    {_DATAF(-0.97141289710998535000), _DATAF(-0.23739615082740784000)},
    {_DATAF(-0.97150391340255737000), _DATAF(-0.23702360689640045000)},
    {_DATAF(-0.97159469127655029000), _DATAF(-0.23665101826190948000)},
    {_DATAF(-0.97168540954589844000), _DATAF(-0.23627839982509613000)},
    {_DATAF(-0.97177594900131226000), _DATAF(-0.23590575158596039000)},
    {_DATAF(-0.97186630964279175000), _DATAF(-0.23553305864334106000)},
    {_DATAF(-0.97195661067962646000), _DATAF(-0.23516033589839935000)},
    {_DATAF(-0.97204673290252686000), _DATAF(-0.23478758335113525000)},
    {_DATAF(-0.97213667631149292000), _DATAF(-0.23441478610038757000)},
    {_DATAF(-0.97222650051116943000), _DATAF(-0.23404195904731750000)},
    {_DATAF(-0.97231620550155640000), _DATAF(-0.23366910219192505000)},
    {_DATAF(-0.97240573167800903000), _DATAF(-0.23329620063304901000)},
    {_DATAF(-0.97249513864517212000), _DATAF(-0.23292326927185059000)},
    {_DATAF(-0.97258436679840088000), _DATAF(-0.23255030810832977000)},
    {_DATAF(-0.97267347574234009000), _DATAF(-0.23217730224132538000)},
    {_DATAF(-0.97276246547698975000), _DATAF(-0.23180428147315979000)},
    {_DATAF(-0.97285127639770508000), _DATAF(-0.23143121600151062000)},
    {_DATAF(-0.97293996810913086000), _DATAF(-0.23105810582637787000)},
    {_DATAF(-0.97302848100662231000), _DATAF(-0.23068498075008392000)},
    {_DATAF(-0.97311687469482422000), _DATAF(-0.23031181097030640000)},
    {_DATAF(-0.97320514917373657000), _DATAF(-0.22993859648704529000)},
    {_DATAF(-0.97329324483871460000), _DATAF(-0.22956536710262299000)},
    {_DATAF(-0.97338122129440308000), _DATAF(-0.22919209301471710000)},
    {_DATAF(-0.97346901893615723000), _DATAF(-0.22881878912448883000)},
    {_DATAF(-0.97355669736862183000), _DATAF(-0.22844545543193817000)},
    {_DATAF(-0.97364425659179688000), _DATAF(-0.22807207703590393000)},
    {_DATAF(-0.97373163700103760000), _DATAF(-0.22769868373870850000)},
    {_DATAF(-0.97381889820098877000), _DATAF(-0.22732524573802948000)},
    {_DATAF(-0.97390598058700562000), _DATAF(-0.22695176303386688000)},
    {_DATAF(-0.97399294376373291000), _DATAF(-0.22657826542854309000)},
    {_DATAF(-0.97407978773117065000), _DATAF(-0.22620472311973572000)},
    {_DATAF(-0.97416645288467407000), _DATAF(-0.22583115100860596000)},
    {_DATAF(-0.97425299882888794000), _DATAF(-0.22545754909515381000)},
    {_DATAF(-0.97433936595916748000), _DATAF(-0.22508391737937927000)},
    {_DATAF(-0.97442561388015747000), _DATAF(-0.22471024096012115000)},
    {_DATAF(-0.97451174259185791000), _DATAF(-0.22433653473854065000)},
    {_DATAF(-0.97459769248962402000), _DATAF(-0.22396279871463776000)},
    {_DATAF(-0.97468352317810059000), _DATAF(-0.22358903288841248000)},
    {_DATAF(-0.97476917505264282000), _DATAF(-0.22321522235870361000)},
    {_DATAF(-0.97485470771789551000), _DATAF(-0.22284139692783356000)},
    {_DATAF(-0.97494012117385864000), _DATAF(-0.22246752679347992000)},
    {_DATAF(-0.97502535581588745000), _DATAF(-0.22209362685680389000)},
    {_DATAF(-0.97511047124862671000), _DATAF(-0.22171968221664429000)},
    {_DATAF(-0.97519540786743164000), _DATAF(-0.22134572267532349000)},
    {_DATAF(-0.97528022527694702000), _DATAF(-0.22097171843051910000)},
    {_DATAF(-0.97536486387252808000), _DATAF(-0.22059768438339233000)},
    {_DATAF(-0.97544938325881958000), _DATAF(-0.22022362053394318000)},
    {_DATAF(-0.97553378343582153000), _DATAF(-0.21984952688217163000)},
    {_DATAF(-0.97561800479888916000), _DATAF(-0.21947540342807770000)},
    {_DATAF(-0.97570210695266724000), _DATAF(-0.21910123527050018000)},
    {_DATAF(-0.97578608989715576000), _DATAF(-0.21872705221176147000)},
    {_DATAF(-0.97586989402770996000), _DATAF(-0.21835282444953918000)},
    {_DATAF(-0.97595357894897461000), _DATAF(-0.21797856688499451000)},
    {_DATAF(-0.97603708505630493000), _DATAF(-0.21760427951812744000)},
    {_DATAF(-0.97612047195434570000), _DATAF(-0.21722994744777679000)},
    {_DATAF(-0.97620368003845215000), _DATAF(-0.21685560047626495000)},
    {_DATAF(-0.97628676891326904000), _DATAF(-0.21648120880126953000)},
    {_DATAF(-0.97636973857879639000), _DATAF(-0.21610680222511292000)},
    {_DATAF(-0.97645252943038940000), _DATAF(-0.21573235094547272000)},
    {_DATAF(-0.97653520107269287000), _DATAF(-0.21535786986351013000)},
    {_DATAF(-0.97661769390106201000), _DATAF(-0.21498335897922516000)},
    {_DATAF(-0.97670006752014160000), _DATAF(-0.21460881829261780000)},
    {_DATAF(-0.97678232192993164000), _DATAF(-0.21423423290252686000)},
    {_DATAF(-0.97686439752578735000), _DATAF(-0.21385963261127472000)},
    {_DATAF(-0.97694635391235352000), _DATAF(-0.21348498761653900000)},
    {_DATAF(-0.97702813148498535000), _DATAF(-0.21311031281948090000)},
    {_DATAF(-0.97710978984832764000), _DATAF(-0.21273562312126160000)},
    {_DATAF(-0.97719132900238037000), _DATAF(-0.21236088871955872000)},
    {_DATAF(-0.97727268934249878000), _DATAF(-0.21198612451553345000)},
    {_DATAF(-0.97735387086868286000), _DATAF(-0.21161133050918579000)},
    {_DATAF(-0.97743499279022217000), _DATAF(-0.21123650670051575000)},
    {_DATAF(-0.97751593589782715000), _DATAF(-0.21086163818836212000)},
    {_DATAF(-0.97759670019149780000), _DATAF(-0.21048675477504730000)},
    {_DATAF(-0.97767734527587891000), _DATAF(-0.21011184155941010000)},
    {_DATAF(-0.97775787115097046000), _DATAF(-0.20973688364028931000)},
    {_DATAF(-0.97783821821212769000), _DATAF(-0.20936191082000732000)},
    {_DATAF(-0.97791844606399536000), _DATAF(-0.20898689329624176000)},
    {_DATAF(-0.97799849510192871000), _DATAF(-0.20861184597015381000)},
    {_DATAF(-0.97807842493057251000), _DATAF(-0.20823678374290466000)},
    {_DATAF(-0.97815823554992676000), _DATAF(-0.20786167681217194000)},
    {_DATAF(-0.97823786735534668000), _DATAF(-0.20748654007911682000)},
    {_DATAF(-0.97831737995147705000), _DATAF(-0.20711137354373932000)},
    {_DATAF(-0.97839671373367310000), _DATAF(-0.20673617720603943000)},
    {_DATAF(-0.97847592830657959000), _DATAF(-0.20636095106601715000)},
    {_DATAF(-0.97855502367019653000), _DATAF(-0.20598569512367249000)},
    {_DATAF(-0.97863394021987915000), _DATAF(-0.20561040937900543000)},
    {_DATAF(-0.97871267795562744000), _DATAF(-0.20523509383201599000)},
    {_DATAF(-0.97879135608673096000), _DATAF(-0.20485974848270416000)},
    {_DATAF(-0.97886985540390015000), _DATAF(-0.20448437333106995000)},
    {_DATAF(-0.97894817590713501000), _DATAF(-0.20410896837711334000)},
    {_DATAF(-0.97902637720108032000), _DATAF(-0.20373353362083435000)},
    {_DATAF(-0.97910445928573608000), _DATAF(-0.20335806906223297000)},
    {_DATAF(-0.97918236255645752000), _DATAF(-0.20298255980014801000)},
    {_DATAF(-0.97926014661788940000), _DATAF(-0.20260703563690186000)},
    {_DATAF(-0.97933775186538696000), _DATAF(-0.20223148167133331000)},
    {_DATAF(-0.97941523790359497000), _DATAF(-0.20185589790344238000)},
    {_DATAF(-0.97949254512786865000), _DATAF(-0.20148028433322906000)},
    {_DATAF(-0.97956979274749756000), _DATAF(-0.20110464096069336000)},
    {_DATAF(-0.97964680194854736000), _DATAF(-0.20072895288467407000)},
    {_DATAF(-0.97972375154495239000), _DATAF(-0.20035324990749359000)},
    {_DATAF(-0.97980046272277832000), _DATAF(-0.19997751712799072000)},
    {_DATAF(-0.97987711429595947000), _DATAF(-0.19960175454616547000)},
    {_DATAF(-0.97995358705520630000), _DATAF(-0.19922596216201782000)},
    {_DATAF(-0.98002988100051880000), _DATAF(-0.19885013997554779000)},
    {_DATAF(-0.98010611534118652000), _DATAF(-0.19847428798675537000)},
    {_DATAF(-0.98018211126327515000), _DATAF(-0.19809840619564056000)},
    {_DATAF(-0.98025804758071899000), _DATAF(-0.19772249460220337000)},
    {_DATAF(-0.98033380508422852000), _DATAF(-0.19734656810760498000)},
    {_DATAF(-0.98040938377380371000), _DATAF(-0.19697059690952301000)},
    {_DATAF(-0.98048484325408936000), _DATAF(-0.19659459590911865000)},
    {_DATAF(-0.98056018352508545000), _DATAF(-0.19621856510639191000)},
    {_DATAF(-0.98063534498214722000), _DATAF(-0.19584251940250397000)},
    {_DATAF(-0.98071038722991943000), _DATAF(-0.19546642899513245000)},
    {_DATAF(-0.98078525066375732000), _DATAF(-0.19509032368659973000)},
    {_DATAF(-0.98085999488830566000), _DATAF(-0.19471418857574463000)},
    {_DATAF(-0.98093461990356445000), _DATAF(-0.19433800876140594000)},
    {_DATAF(-0.98100906610488892000), _DATAF(-0.19396181404590607000)},
    {_DATAF(-0.98108339309692383000), _DATAF(-0.19358558952808380000)},
    {_DATAF(-0.98115754127502441000), _DATAF(-0.19320933520793915000)},
    {_DATAF(-0.98123157024383545000), _DATAF(-0.19283305108547211000)},
    {_DATAF(-0.98130548000335693000), _DATAF(-0.19245673716068268000)},
    {_DATAF(-0.98137921094894409000), _DATAF(-0.19208039343357086000)},
    {_DATAF(-0.98145276308059692000), _DATAF(-0.19170403480529785000)},
    {_DATAF(-0.98152625560760498000), _DATAF(-0.19132763147354126000)},
    {_DATAF(-0.98159950971603394000), _DATAF(-0.19095121324062347000)},
    {_DATAF(-0.98167270421981812000), _DATAF(-0.19057475030422211000)},
    {_DATAF(-0.98174571990966797000), _DATAF(-0.19019827246665955000)},
    {_DATAF(-0.98181855678558350000), _DATAF(-0.18982176482677460000)},
    {_DATAF(-0.98189127445220947000), _DATAF(-0.18944522738456726000)},
    {_DATAF(-0.98196387290954590000), _DATAF(-0.18906866014003754000)},
    {_DATAF(-0.98203629255294800000), _DATAF(-0.18869207799434662000)},
    {_DATAF(-0.98210859298706055000), _DATAF(-0.18831545114517212000)},
    {_DATAF(-0.98218071460723877000), _DATAF(-0.18793880939483643000)},
    {_DATAF(-0.98225271701812744000), _DATAF(-0.18756212294101715000)},
    {_DATAF(-0.98232460021972656000), _DATAF(-0.18718542158603668000)},
    {_DATAF(-0.98239630460739136000), _DATAF(-0.18680869042873383000)},
    {_DATAF(-0.98246788978576660000), _DATAF(-0.18643194437026978000)},
    {_DATAF(-0.98253929615020752000), _DATAF(-0.18605515360832214000)},
    {_DATAF(-0.98261058330535889000), _DATAF(-0.18567833304405212000)},
    {_DATAF(-0.98268169164657593000), _DATAF(-0.18530149757862091000)},
    {_DATAF(-0.98275268077850342000), _DATAF(-0.18492463231086731000)},
    {_DATAF(-0.98282355070114136000), _DATAF(-0.18454773724079132000)},
    {_DATAF(-0.98289424180984497000), _DATAF(-0.18417081236839294000)},
    {_DATAF(-0.98296481370925903000), _DATAF(-0.18379387259483337000)},
    {_DATAF(-0.98303520679473877000), _DATAF(-0.18341688811779022000)},
    {_DATAF(-0.98310548067092896000), _DATAF(-0.18303988873958588000)},
    {_DATAF(-0.98317563533782959000), _DATAF(-0.18266285955905914000)},
    {_DATAF(-0.98324561119079590000), _DATAF(-0.18228580057621002000)},
    {_DATAF(-0.98331540822982788000), _DATAF(-0.18190871179103851000)},
    {_DATAF(-0.98338508605957031000), _DATAF(-0.18153160810470581000)},
    {_DATAF(-0.98345464468002319000), _DATAF(-0.18115447461605072000)},
    {_DATAF(-0.98352402448654175000), _DATAF(-0.18077731132507324000)},
    {_DATAF(-0.98359328508377075000), _DATAF(-0.18040011823177338000)},
    {_DATAF(-0.98366242647171021000), _DATAF(-0.18002289533615112000)},
    {_DATAF(-0.98373138904571533000), _DATAF(-0.17964565753936768000)},
    {_DATAF(-0.98380023241043091000), _DATAF(-0.17926838994026184000)},
    {_DATAF(-0.98386889696121216000), _DATAF(-0.17889109253883362000)},
    {_DATAF(-0.98393744230270386000), _DATAF(-0.17851376533508301000)},
    {_DATAF(-0.98400580883026123000), _DATAF(-0.17813642323017120000)},
    {_DATAF(-0.98407405614852905000), _DATAF(-0.17775905132293701000)},
    {_DATAF(-0.98414212465286255000), _DATAF(-0.17738164961338043000)},
    {_DATAF(-0.98421007394790649000), _DATAF(-0.17700421810150146000)},
    {_DATAF(-0.98427790403366089000), _DATAF(-0.17662677168846130000)},
    {_DATAF(-0.98434555530548096000), _DATAF(-0.17624929547309875000)},
    {_DATAF(-0.98441308736801147000), _DATAF(-0.17587178945541382000)},
    {_DATAF(-0.98448044061660767000), _DATAF(-0.17549425363540649000)},
    {_DATAF(-0.98454767465591431000), _DATAF(-0.17511670291423798000)},
    {_DATAF(-0.98461478948593140000), _DATAF(-0.17473910748958588000)},
    {_DATAF(-0.98468172550201416000), _DATAF(-0.17436151206493378000)},
    {_DATAF(-0.98474848270416260000), _DATAF(-0.17398387193679810000)},
    {_DATAF(-0.98481518030166626000), _DATAF(-0.17360621690750122000)},
    {_DATAF(-0.98488163948059082000), _DATAF(-0.17322853207588196000)},
    {_DATAF(-0.98494803905487061000), _DATAF(-0.17285081744194031000)},
    {_DATAF(-0.98501425981521606000), _DATAF(-0.17247308790683746000)},
    {_DATAF(-0.98508030176162720000), _DATAF(-0.17209532856941223000)},
    {_DATAF(-0.98514622449874878000), _DATAF(-0.17171753942966461000)},
    {_DATAF(-0.98521202802658081000), _DATAF(-0.17133972048759460000)},
    {_DATAF(-0.98527765274047852000), _DATAF(-0.17096188664436340000)},
    {_DATAF(-0.98534315824508667000), _DATAF(-0.17058402299880981000)},
    {_DATAF(-0.98540848493576050000), _DATAF(-0.17020614445209503000)},
    {_DATAF(-0.98547369241714478000), _DATAF(-0.16982822120189667000)},
    {_DATAF(-0.98553872108459473000), _DATAF(-0.16945029795169830000)},
    {_DATAF(-0.98560363054275513000), _DATAF(-0.16907232999801636000)},
    {_DATAF(-0.98566842079162598000), _DATAF(-0.16869434714317322000)},
    {_DATAF(-0.98573303222656250000), _DATAF(-0.16831633448600769000)},
    {_DATAF(-0.98579752445220947000), _DATAF(-0.16793829202651978000)},
    {_DATAF(-0.98586183786392212000), _DATAF(-0.16756023466587067000)},
    {_DATAF(-0.98592603206634521000), _DATAF(-0.16718214750289917000)},
    {_DATAF(-0.98599004745483398000), _DATAF(-0.16680404543876648000)},
    {_DATAF(-0.98605394363403320000), _DATAF(-0.16642589867115021000)},
    {_DATAF(-0.98611772060394287000), _DATAF(-0.16604773700237274000)},
    {_DATAF(-0.98618131875991821000), _DATAF(-0.16566956043243408000)},
    {_DATAF(-0.98624479770660400000), _DATAF(-0.16529135406017303000)},
    {_DATAF(-0.98630809783935547000), _DATAF(-0.16491311788558960000)},
    {_DATAF(-0.98637127876281738000), _DATAF(-0.16453486680984497000)},
    {_DATAF(-0.98643428087234497000), _DATAF(-0.16415658593177795000)},
    {_DATAF(-0.98649716377258301000), _DATAF(-0.16377827525138855000)},
    {_DATAF(-0.98655992746353149000), _DATAF(-0.16339994966983795000)},
    {_DATAF(-0.98662251234054565000), _DATAF(-0.16302159428596497000)},
    {_DATAF(-0.98668491840362549000), _DATAF(-0.16264322400093079000)},
    {_DATAF(-0.98674726486206055000), _DATAF(-0.16226482391357422000)},
    {_DATAF(-0.98680937290191650000), _DATAF(-0.16188639402389526000)},
    {_DATAF(-0.98687142133712769000), _DATAF(-0.16150794923305511000)},
    {_DATAF(-0.98693329095840454000), _DATAF(-0.16112947463989258000)},
    {_DATAF(-0.98699498176574707000), _DATAF(-0.16075097024440765000)},
    {_DATAF(-0.98705655336380005000), _DATAF(-0.16037245094776154000)},
    {_DATAF(-0.98711800575256348000), _DATAF(-0.15999391674995422000)},
    {_DATAF(-0.98717927932739258000), _DATAF(-0.15961535274982452000)},
    {_DATAF(-0.98724043369293213000), _DATAF(-0.15923675894737244000)},
    {_DATAF(-0.98730140924453735000), _DATAF(-0.15885815024375916000)},
    {_DATAF(-0.98736226558685303000), _DATAF(-0.15847951173782349000)},
    {_DATAF(-0.98742294311523438000), _DATAF(-0.15810084342956543000)},
    {_DATAF(-0.98748350143432617000), _DATAF(-0.15772216022014618000)},
    {_DATAF(-0.98754394054412842000), _DATAF(-0.15734346210956573000)},
    {_DATAF(-0.98760420083999634000), _DATAF(-0.15696471929550171000)},
    {_DATAF(-0.98766434192657471000), _DATAF(-0.15658597648143768000)},
    {_DATAF(-0.98772430419921875000), _DATAF(-0.15620720386505127000)},
    {_DATAF(-0.98778414726257324000), _DATAF(-0.15582840144634247000)},
    {_DATAF(-0.98784381151199341000), _DATAF(-0.15544956922531128000)},
    {_DATAF(-0.98790335655212402000), _DATAF(-0.15507073700428009000)},
    {_DATAF(-0.98796278238296509000), _DATAF(-0.15469186007976532000)},
    {_DATAF(-0.98802202939987183000), _DATAF(-0.15431296825408936000)},
    {_DATAF(-0.98808109760284424000), _DATAF(-0.15393406152725220000)},
    {_DATAF(-0.98814010620117188000), _DATAF(-0.15355512499809265000)},
    {_DATAF(-0.98819887638092041000), _DATAF(-0.15317615866661072000)},
    {_DATAF(-0.98825758695602417000), _DATAF(-0.15279719233512878000)},
    {_DATAF(-0.98831611871719360000), _DATAF(-0.15241818130016327000)},
    {_DATAF(-0.98837447166442871000), _DATAF(-0.15203915536403656000)},
    {_DATAF(-0.98843270540237427000), _DATAF(-0.15166011452674866000)},
    {_DATAF(-0.98849081993103027000), _DATAF(-0.15128104388713837000)},
    {_DATAF(-0.98854875564575195000), _DATAF(-0.15090194344520569000)},
    {_DATAF(-0.98860651254653931000), _DATAF(-0.15052282810211182000)},
    {_DATAF(-0.98866420984268188000), _DATAF(-0.15014369785785675000)},
    {_DATAF(-0.98872166872024536000), _DATAF(-0.14976453781127930000)},
    {_DATAF(-0.98877906799316406000), _DATAF(-0.14938534796237946000)},
    {_DATAF(-0.98883628845214844000), _DATAF(-0.14900614321231842000)},
    {_DATAF(-0.98889333009719849000), _DATAF(-0.14862692356109619000)},
    {_DATAF(-0.98895025253295898000), _DATAF(-0.14824767410755157000)},
    {_DATAF(-0.98900705575942993000), _DATAF(-0.14786840975284576000)},
    {_DATAF(-0.98906368017196655000), _DATAF(-0.14748911559581757000)},
    {_DATAF(-0.98912018537521362000), _DATAF(-0.14710980653762817000)},
    {_DATAF(-0.98917651176452637000), _DATAF(-0.14673046767711639000)},
    {_DATAF(-0.98923271894454956000), _DATAF(-0.14635111391544342000)},
    {_DATAF(-0.98928874731063843000), _DATAF(-0.14597174525260925000)},
    {_DATAF(-0.98934465646743774000), _DATAF(-0.14559234678745270000)},
    {_DATAF(-0.98940044641494751000), _DATAF(-0.14521291851997375000)},
    {_DATAF(-0.98945605754852295000), _DATAF(-0.14483349025249481000)},
    {_DATAF(-0.98951148986816406000), _DATAF(-0.14445401728153229000)},
    {_DATAF(-0.98956686258316040000), _DATAF(-0.14407454431056976000)},
    {_DATAF(-0.98962199687957764000), _DATAF(-0.14369502663612366000)},
    {_DATAF(-0.98967707157135010000), _DATAF(-0.14331550896167755000)},
    {_DATAF(-0.98973196744918823000), _DATAF(-0.14293596148490906000)},
    {_DATAF(-0.98978668451309204000), _DATAF(-0.14255639910697937000)},
    {_DATAF(-0.98984128236770630000), _DATAF(-0.14217680692672729000)},
    {_DATAF(-0.98989570140838623000), _DATAF(-0.14179719984531403000)},
    {_DATAF(-0.98995006084442139000), _DATAF(-0.14141756296157837000)},
    {_DATAF(-0.99000418186187744000), _DATAF(-0.14103791117668152000)},
    {_DATAF(-0.99005818367004395000), _DATAF(-0.14065824449062347000)},
    {_DATAF(-0.99011206626892090000), _DATAF(-0.14027854800224304000)},
    {_DATAF(-0.99016582965850830000), _DATAF(-0.13989883661270142000)},
    {_DATAF(-0.99021935462951660000), _DATAF(-0.13951909542083740000)},
    {_DATAF(-0.99027281999588013000), _DATAF(-0.13913933932781219000)},
    {_DATAF(-0.99032610654830933000), _DATAF(-0.13875956833362579000)},
    {_DATAF(-0.99037921428680420000), _DATAF(-0.13837976753711700000)},
    {_DATAF(-0.99043226242065430000), _DATAF(-0.13799995183944702000)},
    {_DATAF(-0.99048507213592529000), _DATAF(-0.13762012124061584000)},
    {_DATAF(-0.99053776264190674000), _DATAF(-0.13724026083946228000)},
    {_DATAF(-0.99059033393859863000), _DATAF(-0.13686038553714752000)},
    {_DATAF(-0.99064278602600098000), _DATAF(-0.13648049533367157000)},
    {_DATAF(-0.99069499969482422000), _DATAF(-0.13610057532787323000)},
    {_DATAF(-0.99074715375900269000), _DATAF(-0.13572064042091370000)},
    {_DATAF(-0.99079912900924683000), _DATAF(-0.13534067571163177000)},
    {_DATAF(-0.99085092544555664000), _DATAF(-0.13496071100234985000)},
    {_DATAF(-0.99090266227722168000), _DATAF(-0.13458070158958435000)},
    {_DATAF(-0.99095416069030762000), _DATAF(-0.13420069217681885000)},
    {_DATAF(-0.99100553989410400000), _DATAF(-0.13382065296173096000)},
    {_DATAF(-0.99105679988861084000), _DATAF(-0.13344059884548187000)},
    {_DATAF(-0.99110794067382813000), _DATAF(-0.13306052982807159000)},
    {_DATAF(-0.99115884304046631000), _DATAF(-0.13268043100833893000)},
    {_DATAF(-0.99120968580245972000), _DATAF(-0.13230031728744507000)},
    {_DATAF(-0.99126034975051880000), _DATAF(-0.13192018866539001000)},
    {_DATAF(-0.99131083488464355000), _DATAF(-0.13154003024101257000)},
    {_DATAF(-0.99136126041412354000), _DATAF(-0.13115985691547394000)},
    {_DATAF(-0.99141144752502441000), _DATAF(-0.13077966868877411000)},
    {_DATAF(-0.99146151542663574000), _DATAF(-0.13039945065975189000)},
    {_DATAF(-0.99151146411895752000), _DATAF(-0.13001921772956848000)},
    {_DATAF(-0.99156123399734497000), _DATAF(-0.12963896989822388000)},
    {_DATAF(-0.99161088466644287000), _DATAF(-0.12925870716571808000)},
    {_DATAF(-0.99166041612625122000), _DATAF(-0.12887841463088989000)},
    {_DATAF(-0.99170976877212524000), _DATAF(-0.12849810719490051000)},
    {_DATAF(-0.99175894260406494000), _DATAF(-0.12811778485774994000)},
    {_DATAF(-0.99180799722671509000), _DATAF(-0.12773744761943817000)},
    {_DATAF(-0.99185693264007568000), _DATAF(-0.12735708057880402000)},
    {_DATAF(-0.99190568923950195000), _DATAF(-0.12697669863700867000)},
    {_DATAF(-0.99195432662963867000), _DATAF(-0.12659630179405212000)},
    {_DATAF(-0.99200278520584106000), _DATAF(-0.12621587514877319000)},
    {_DATAF(-0.99205112457275391000), _DATAF(-0.12583543360233307000)},
    {_DATAF(-0.99209928512573242000), _DATAF(-0.12545497715473175000)},
    {_DATAF(-0.99214732646942139000), _DATAF(-0.12507450580596924000)},
    {_DATAF(-0.99219524860382080000), _DATAF(-0.12469401955604553000)},
    {_DATAF(-0.99224299192428589000), _DATAF(-0.12431350350379944000)},
    {_DATAF(-0.99229061603546143000), _DATAF(-0.12393297255039215000)},
    {_DATAF(-0.99233806133270264000), _DATAF(-0.12355242669582367000)},
    {_DATAF(-0.99238532781600952000), _DATAF(-0.12317185848951340000)},
    {_DATAF(-0.99243253469467163000), _DATAF(-0.12279127538204193000)},
    {_DATAF(-0.99247956275939941000), _DATAF(-0.12241067737340927000)},
    {_DATAF(-0.99252641201019287000), _DATAF(-0.12203005701303482000)},
    {_DATAF(-0.99257314205169678000), _DATAF(-0.12164941430091858000)},
    {_DATAF(-0.99261969327926636000), _DATAF(-0.12126876413822174000)},
    {_DATAF(-0.99266612529754639000), _DATAF(-0.12088808417320251000)},
    {_DATAF(-0.99271243810653687000), _DATAF(-0.12050739675760269000)},
    {_DATAF(-0.99275857210159302000), _DATAF(-0.12012668699026108000)},
    {_DATAF(-0.99280458688735962000), _DATAF(-0.11974596232175827000)},
    {_DATAF(-0.99285042285919189000), _DATAF(-0.11936521530151367000)},
    {_DATAF(-0.99289613962173462000), _DATAF(-0.11898445338010788000)},
    {_DATAF(-0.99294167757034302000), _DATAF(-0.11860367655754089000)},
    {_DATAF(-0.99298709630966187000), _DATAF(-0.11822287738323212000)},
    {_DATAF(-0.99303233623504639000), _DATAF(-0.11784206330776215000)},
    {_DATAF(-0.99307745695114136000), _DATAF(-0.11746122688055038000)},
    {_DATAF(-0.99312245845794678000), _DATAF(-0.11708038300275803000)},
    {_DATAF(-0.99316728115081787000), _DATAF(-0.11669951677322388000)},
    {_DATAF(-0.99321192502975464000), _DATAF(-0.11631862819194794000)},
    {_DATAF(-0.99325650930404663000), _DATAF(-0.11593773216009140000)},
    {_DATAF(-0.99330085515975952000), _DATAF(-0.11555681377649307000)},
    {_DATAF(-0.99334514141082764000), _DATAF(-0.11517588049173355000)},
    {_DATAF(-0.99338918924331665000), _DATAF(-0.11479492485523224000)},
    {_DATAF(-0.99343317747116089000), _DATAF(-0.11441396176815033000)},
    {_DATAF(-0.99347698688507080000), _DATAF(-0.11403297632932663000)},
    {_DATAF(-0.99352061748504639000), _DATAF(-0.11365196853876114000)},
    {_DATAF(-0.99356412887573242000), _DATAF(-0.11327095329761505000)},
    {_DATAF(-0.99360752105712891000), _DATAF(-0.11288991570472717000)},
    {_DATAF(-0.99365073442459106000), _DATAF(-0.11250886321067810000)},
    {_DATAF(-0.99369376897811890000), _DATAF(-0.11212779581546783000)},
    {_DATAF(-0.99373674392700195000), _DATAF(-0.11174671351909637000)},
    {_DATAF(-0.99377948045730591000), _DATAF(-0.11136560887098312000)},
    {_DATAF(-0.99382215738296509000), _DATAF(-0.11098448932170868000)},
    {_DATAF(-0.99386465549468994000), _DATAF(-0.11060335487127304000)},
    {_DATAF(-0.99390697479248047000), _DATAF(-0.11022220551967621000)},
    {_DATAF(-0.99394917488098145000), _DATAF(-0.10984104126691818000)},
    {_DATAF(-0.99399119615554810000), _DATAF(-0.10945985466241837000)},
    {_DATAF(-0.99403309822082520000), _DATAF(-0.10907866060733795000)},
    {_DATAF(-0.99407488107681274000), _DATAF(-0.10869744420051575000)},
    {_DATAF(-0.99411648511886597000), _DATAF(-0.10831621289253235000)},
    {_DATAF(-0.99415796995162964000), _DATAF(-0.10793496668338776000)},
    {_DATAF(-0.99419927597045898000), _DATAF(-0.10755370557308197000)},
    {_DATAF(-0.99424046277999878000), _DATAF(-0.10717242211103439000)},
    {_DATAF(-0.99428147077560425000), _DATAF(-0.10679113119840622000)},
    {_DATAF(-0.99432235956192017000), _DATAF(-0.10640981793403625000)},
    {_DATAF(-0.99436306953430176000), _DATAF(-0.10602849721908569000)},
    {_DATAF(-0.99440366029739380000), _DATAF(-0.10564715415239334000)},
    {_DATAF(-0.99444413185119629000), _DATAF(-0.10526579618453979000)},
    {_DATAF(-0.99448442459106445000), _DATAF(-0.10488442331552505000)},
    {_DATAF(-0.99452453851699829000), _DATAF(-0.10450303554534912000)},
    {_DATAF(-0.99456459283828735000), _DATAF(-0.10412163287401199000)},
    {_DATAF(-0.99460440874099731000), _DATAF(-0.10374021530151367000)},
    {_DATAF(-0.99464416503906250000), _DATAF(-0.10335878282785416000)},
    {_DATAF(-0.99468368291854858000), _DATAF(-0.10297733545303345000)},
    {_DATAF(-0.99472314119338989000), _DATAF(-0.10259586572647095000)},
    {_DATAF(-0.99476242065429688000), _DATAF(-0.10221438854932785000)},
    {_DATAF(-0.99480152130126953000), _DATAF(-0.10183289647102356000)},
    {_DATAF(-0.99484050273895264000), _DATAF(-0.10145138949155807000)},
    {_DATAF(-0.99487930536270142000), _DATAF(-0.10106986016035080000)},
    {_DATAF(-0.99491798877716064000), _DATAF(-0.10068832337856293000)},
    {_DATAF(-0.99495655298233032000), _DATAF(-0.10030677169561386000)},
    {_DATAF(-0.99499493837356567000), _DATAF(-0.09992520511150360100)},
    {_DATAF(-0.99503320455551147000), _DATAF(-0.09954361617565155000)},
    {_DATAF(-0.99507129192352295000), _DATAF(-0.09916201978921890300)},
    {_DATAF(-0.99510926008224487000), _DATAF(-0.09878040850162506100)},
    {_DATAF(-0.99514704942703247000), _DATAF(-0.09839878231287002600)},
    {_DATAF(-0.99518471956253052000), _DATAF(-0.09801714122295379600)},
    {_DATAF(-0.99522227048873901000), _DATAF(-0.09763548523187637300)},
    {_DATAF(-0.99525958299636841000), _DATAF(-0.09725381433963775600)},
    {_DATAF(-0.99529683589935303000), _DATAF(-0.09687212854623794600)},
    {_DATAF(-0.99533390998840332000), _DATAF(-0.09649042785167694100)},
    {_DATAF(-0.99537086486816406000), _DATAF(-0.09610871970653533900)},
    {_DATAF(-0.99540764093399048000), _DATAF(-0.09572698920965194700)},
    {_DATAF(-0.99544423818588257000), _DATAF(-0.09534525126218795800)},
    {_DATAF(-0.99548077583312988000), _DATAF(-0.09496349841356277500)},
    {_DATAF(-0.99551707506179810000), _DATAF(-0.09458172321319580100)},
    {_DATAF(-0.99555331468582153000), _DATAF(-0.09419994056224823000)},
    {_DATAF(-0.99558937549591064000), _DATAF(-0.09381814301013946500)},
    {_DATAF(-0.99562525749206543000), _DATAF(-0.09343633800745010400)},
    {_DATAF(-0.99566102027893066000), _DATAF(-0.09305451065301895100)},
    {_DATAF(-0.99569660425186157000), _DATAF(-0.09267267584800720200)},
    {_DATAF(-0.99573206901550293000), _DATAF(-0.09229081869125366200)},
    {_DATAF(-0.99576741456985474000), _DATAF(-0.09190895408391952500)},
    {_DATAF(-0.99580258131027222000), _DATAF(-0.09152707457542419400)},
    {_DATAF(-0.99583762884140015000), _DATAF(-0.09114518761634826700)},
    {_DATAF(-0.99587249755859375000), _DATAF(-0.09076327830553054800)},
    {_DATAF(-0.99590724706649780000), _DATAF(-0.09038136154413223300)},
    {_DATAF(-0.99594181776046753000), _DATAF(-0.08999942988157272300)},
    {_DATAF(-0.99597626924514771000), _DATAF(-0.08961748331785202000)},
    {_DATAF(-0.99601054191589355000), _DATAF(-0.08923552185297012300)},
    {_DATAF(-0.99604469537734985000), _DATAF(-0.08885355293750762900)},
    {_DATAF(-0.99607872962951660000), _DATAF(-0.08847156912088394200)},
    {_DATAF(-0.99611258506774902000), _DATAF(-0.08808957040309906000)},
    {_DATAF(-0.99614626169204712000), _DATAF(-0.08770755678415298500)},
    {_DATAF(-0.99617981910705566000), _DATAF(-0.08732553571462631200)},
    {_DATAF(-0.99621325731277466000), _DATAF(-0.08694349974393844600)},
    {_DATAF(-0.99624651670455933000), _DATAF(-0.08656144887208938600)},
    {_DATAF(-0.99627965688705444000), _DATAF(-0.08617939054965972900)},
    {_DATAF(-0.99631261825561523000), _DATAF(-0.08579730987548828100)},
    {_DATAF(-0.99634546041488647000), _DATAF(-0.08541522175073623700)},
    {_DATAF(-0.99637812376022339000), _DATAF(-0.08503312617540359500)},
    {_DATAF(-0.99641066789627075000), _DATAF(-0.08465101569890976000)},
    {_DATAF(-0.99644303321838379000), _DATAF(-0.08426889032125473000)},
    {_DATAF(-0.99647527933120728000), _DATAF(-0.08388675004243850700)},
    {_DATAF(-0.99650740623474121000), _DATAF(-0.08350460231304168700)},
    {_DATAF(-0.99653935432434082000), _DATAF(-0.08312243968248367300)},
    {_DATAF(-0.99657112360000610000), _DATAF(-0.08274026215076446500)},
    {_DATAF(-0.99660277366638184000), _DATAF(-0.08235807716846466100)},
    {_DATAF(-0.99663430452346802000), _DATAF(-0.08197587728500366200)},
    {_DATAF(-0.99666565656661987000), _DATAF(-0.08159366995096206700)},
    {_DATAF(-0.99669688940048218000), _DATAF(-0.08121144771575927700)},
    {_DATAF(-0.99672794342041016000), _DATAF(-0.08082921057939529400)},
    {_DATAF(-0.99675887823104858000), _DATAF(-0.08044696599245071400)},
    {_DATAF(-0.99678969383239746000), _DATAF(-0.08006470650434494000)},
    {_DATAF(-0.99682027101516724000), _DATAF(-0.07968243956565856900)},
    {_DATAF(-0.99685078859329224000), _DATAF(-0.07930015772581100500)},
    {_DATAF(-0.99688112735748291000), _DATAF(-0.07891786098480224600)},
    {_DATAF(-0.99691128730773926000), _DATAF(-0.07853555679321289100)},
    {_DATAF(-0.99694132804870605000), _DATAF(-0.07815324515104293800)},
    {_DATAF(-0.99697124958038330000), _DATAF(-0.07777091115713119500)},
    {_DATAF(-0.99700099229812622000), _DATAF(-0.07738857716321945200)},
    {_DATAF(-0.99703061580657959000), _DATAF(-0.07700622081756591800)},
    {_DATAF(-0.99706006050109863000), _DATAF(-0.07662386447191238400)},
    {_DATAF(-0.99708938598632813000), _DATAF(-0.07624148577451705900)},
    {_DATAF(-0.99711853265762329000), _DATAF(-0.07585910707712173500)},
    {_DATAF(-0.99714756011962891000), _DATAF(-0.07547670602798461900)},
    {_DATAF(-0.99717640876770020000), _DATAF(-0.07509429752826690700)},
    {_DATAF(-0.99720513820648193000), _DATAF(-0.07471188157796859700)},
    {_DATAF(-0.99723374843597412000), _DATAF(-0.07432945072650909400)},
    {_DATAF(-0.99726217985153198000), _DATAF(-0.07394701242446899400)},
    {_DATAF(-0.99729043245315552000), _DATAF(-0.07356456667184829700)},
    {_DATAF(-0.99731856584548950000), _DATAF(-0.07318209856748580900)},
    {_DATAF(-0.99734658002853394000), _DATAF(-0.07279963046312332200)},
    {_DATAF(-0.99737441539764404000), _DATAF(-0.07241714745759964000)},
    {_DATAF(-0.99740213155746460000), _DATAF(-0.07203464955091476400)},
    {_DATAF(-0.99742966890335083000), _DATAF(-0.07165215164422988900)},
    {_DATAF(-0.99745708703994751000), _DATAF(-0.07126963138580322300)},
    {_DATAF(-0.99748432636260986000), _DATAF(-0.07088711112737655600)},
    {_DATAF(-0.99751144647598267000), _DATAF(-0.07050457596778869600)},
    {_DATAF(-0.99753844738006592000), _DATAF(-0.07012202590703964200)},
    {_DATAF(-0.99756520986557007000), _DATAF(-0.06973946839570999100)},
    {_DATAF(-0.99759191274642944000), _DATAF(-0.06935690343379974400)},
    {_DATAF(-0.99761843681335449000), _DATAF(-0.06897433102130889900)},
    {_DATAF(-0.99764484167098999000), _DATAF(-0.06859174370765686000)},
    {_DATAF(-0.99767106771469116000), _DATAF(-0.06820914149284362800)},
    {_DATAF(-0.99769711494445801000), _DATAF(-0.06782653927803039600)},
    {_DATAF(-0.99772304296493530000), _DATAF(-0.06744392216205596900)},
    {_DATAF(-0.99774885177612305000), _DATAF(-0.06706129014492034900)},
    {_DATAF(-0.99777448177337646000), _DATAF(-0.06667865812778472900)},
    {_DATAF(-0.99779999256134033000), _DATAF(-0.06629601120948791500)},
    {_DATAF(-0.99782532453536987000), _DATAF(-0.06591334939002990700)},
    {_DATAF(-0.99785053730010986000), _DATAF(-0.06553068757057189900)},
    {_DATAF(-0.99787563085556030000), _DATAF(-0.06514801084995269800)},
    {_DATAF(-0.99790054559707642000), _DATAF(-0.06476532667875289900)},
    {_DATAF(-0.99792528152465820000), _DATAF(-0.06438262760639190700)},
    {_DATAF(-0.99794989824295044000), _DATAF(-0.06399992853403091400)},
    {_DATAF(-0.99797439575195313000), _DATAF(-0.06361721456050872800)},
    {_DATAF(-0.99799871444702148000), _DATAF(-0.06323449313640594500)},
    {_DATAF(-0.99802285432815552000), _DATAF(-0.06285175681114196800)},
    {_DATAF(-0.99804687500000000000), _DATAF(-0.06246901676058769200)},
    {_DATAF(-0.99807077646255493000), _DATAF(-0.06208626553416252100)},
    {_DATAF(-0.99809449911117554000), _DATAF(-0.06170350685715675400)},
    {_DATAF(-0.99811810255050659000), _DATAF(-0.06132073700428009000)},
    {_DATAF(-0.99814152717590332000), _DATAF(-0.06093795970082283000)},
    {_DATAF(-0.99816483259201050000), _DATAF(-0.06055517122149467500)},
    {_DATAF(-0.99818801879882813000), _DATAF(-0.06017237529158592200)},
    {_DATAF(-0.99821102619171143000), _DATAF(-0.05978957191109657300)},
    {_DATAF(-0.99823385477066040000), _DATAF(-0.05940675735473632800)},
    {_DATAF(-0.99825656414031982000), _DATAF(-0.05902393534779548600)},
    {_DATAF(-0.99827915430068970000), _DATAF(-0.05864110589027404800)},
    {_DATAF(-0.99830156564712524000), _DATAF(-0.05825826525688171400)},
    {_DATAF(-0.99832379817962646000), _DATAF(-0.05787541717290878300)},
    {_DATAF(-0.99834591150283813000), _DATAF(-0.05749255791306495700)},
    {_DATAF(-0.99836790561676025000), _DATAF(-0.05710969492793083200)},
    {_DATAF(-0.99838972091674805000), _DATAF(-0.05672682076692581200)},
    {_DATAF(-0.99841141700744629000), _DATAF(-0.05634393915534019500)},
    {_DATAF(-0.99843293428421021000), _DATAF(-0.05596105009317398100)},
    {_DATAF(-0.99845433235168457000), _DATAF(-0.05557814985513687100)},
    {_DATAF(-0.99847555160522461000), _DATAF(-0.05519524589180946400)},
    {_DATAF(-0.99849665164947510000), _DATAF(-0.05481233075261116000)},
    {_DATAF(-0.99851763248443604000), _DATAF(-0.05442940816283226000)},
    {_DATAF(-0.99853843450546265000), _DATAF(-0.05404647812247276300)},
    {_DATAF(-0.99855905771255493000), _DATAF(-0.05366353690624237100)},
    {_DATAF(-0.99857956171035767000), _DATAF(-0.05328059196472168000)},
    {_DATAF(-0.99859994649887085000), _DATAF(-0.05289763584733009300)},
    {_DATAF(-0.99862015247344971000), _DATAF(-0.05251467600464820900)},
    {_DATAF(-0.99864023923873901000), _DATAF(-0.05213170498609542800)},
    {_DATAF(-0.99866014719009399000), _DATAF(-0.05174872651696205100)},
    {_DATAF(-0.99867993593215942000), _DATAF(-0.05136574059724807700)},
    {_DATAF(-0.99869954586029053000), _DATAF(-0.05098275095224380500)},
    {_DATAF(-0.99871903657913208000), _DATAF(-0.05059975013136863700)},
    {_DATAF(-0.99873834848403931000), _DATAF(-0.05021674185991287200)},
    {_DATAF(-0.99875754117965698000), _DATAF(-0.04983372613787651100)},
    {_DATAF(-0.99877655506134033000), _DATAF(-0.04945070296525955200)},
    {_DATAF(-0.99879544973373413000), _DATAF(-0.04906767606735229500)},
    {_DATAF(-0.99881422519683838000), _DATAF(-0.04868463799357414200)},
    {_DATAF(-0.99883282184600830000), _DATAF(-0.04830159246921539300)},
    {_DATAF(-0.99885123968124390000), _DATAF(-0.04791854321956634500)},
    {_DATAF(-0.99886953830718994000), _DATAF(-0.04753548279404640200)},
    {_DATAF(-0.99888771772384644000), _DATAF(-0.04715241864323616000)},
    {_DATAF(-0.99890571832656860000), _DATAF(-0.04676934704184532200)},
    {_DATAF(-0.99892359972000122000), _DATAF(-0.04638626798987388600)},
    {_DATAF(-0.99894130229949951000), _DATAF(-0.04600318148732185400)},
    {_DATAF(-0.99895888566970825000), _DATAF(-0.04562009125947952300)},
    {_DATAF(-0.99897629022598267000), _DATAF(-0.04523698985576629600)},
    {_DATAF(-0.99899357557296753000), _DATAF(-0.04485388472676277200)},
    {_DATAF(-0.99901068210601807000), _DATAF(-0.04447077214717865000)},
    {_DATAF(-0.99902766942977905000), _DATAF(-0.04408765211701393100)},
    {_DATAF(-0.99904447793960571000), _DATAF(-0.04370452836155891400)},
    {_DATAF(-0.99906116724014282000), _DATAF(-0.04332139343023300200)},
    {_DATAF(-0.99907773733139038000), _DATAF(-0.04293825849890708900)},
    {_DATAF(-0.99909412860870361000), _DATAF(-0.04255511239171028100)},
    {_DATAF(-0.99911034107208252000), _DATAF(-0.04217196255922317500)},
    {_DATAF(-0.99912649393081665000), _DATAF(-0.04178880527615547200)},
    {_DATAF(-0.99914240837097168000), _DATAF(-0.04140564054250717200)},
    {_DATAF(-0.99915820360183716000), _DATAF(-0.04102247208356857300)},
    {_DATAF(-0.99917387962341309000), _DATAF(-0.04063929617404937700)},
    {_DATAF(-0.99918937683105469000), _DATAF(-0.04025611653923988300)},
    {_DATAF(-0.99920475482940674000), _DATAF(-0.03987292572855949400)},
    {_DATAF(-0.99921995401382446000), _DATAF(-0.03948973491787910500)},
    {_DATAF(-0.99923503398895264000), _DATAF(-0.03910653665661811800)},
    {_DATAF(-0.99924999475479126000), _DATAF(-0.03872333094477653500)},
    {_DATAF(-0.99926477670669556000), _DATAF(-0.03834012150764465300)},
    {_DATAF(-0.99927937984466553000), _DATAF(-0.03795690461993217500)},
    {_DATAF(-0.99929386377334595000), _DATAF(-0.03757368400692939800)},
    {_DATAF(-0.99930816888809204000), _DATAF(-0.03719045594334602400)},
    {_DATAF(-0.99932235479354858000), _DATAF(-0.03680722415447235100)},
    {_DATAF(-0.99933642148971558000), _DATAF(-0.03642398491501808200)},
    {_DATAF(-0.99935030937194824000), _DATAF(-0.03604074195027351400)},
    {_DATAF(-0.99936407804489136000), _DATAF(-0.03565749153494834900)},
    {_DATAF(-0.99937766790390015000), _DATAF(-0.03527423739433288600)},
    {_DATAF(-0.99939113855361938000), _DATAF(-0.03489097952842712400)},
    {_DATAF(-0.99940443038940430000), _DATAF(-0.03450771421194076500)},
    {_DATAF(-0.99941760301589966000), _DATAF(-0.03412444517016410800)},
    {_DATAF(-0.99943059682846069000), _DATAF(-0.03374117240309715300)},
    {_DATAF(-0.99944347143173218000), _DATAF(-0.03335789218544960000)},
    {_DATAF(-0.99945616722106934000), _DATAF(-0.03297460824251174900)},
    {_DATAF(-0.99946874380111694000), _DATAF(-0.03259132057428360000)},
    {_DATAF(-0.99948120117187500000), _DATAF(-0.03220802545547485400)},
    {_DATAF(-0.99949347972869873000), _DATAF(-0.03182472661137580900)},
    {_DATAF(-0.99950557947158813000), _DATAF(-0.03144142404198646500)},
    {_DATAF(-0.99951756000518799000), _DATAF(-0.03105811588466167400)},
    {_DATAF(-0.99952942132949829000), _DATAF(-0.03067480400204658500)},
    {_DATAF(-0.99954110383987427000), _DATAF(-0.03029148653149604800)},
    {_DATAF(-0.99955266714096069000), _DATAF(-0.02990816533565521200)},
    {_DATAF(-0.99956405162811279000), _DATAF(-0.02952483855187892900)},
    {_DATAF(-0.99957531690597534000), _DATAF(-0.02914150804281234700)},
    {_DATAF(-0.99958640336990356000), _DATAF(-0.02875817380845546700)},
    {_DATAF(-0.99959737062454224000), _DATAF(-0.02837483584880828900)},
    {_DATAF(-0.99960815906524658000), _DATAF(-0.02799149230122566200)},
    {_DATAF(-0.99961882829666138000), _DATAF(-0.02760814502835273700)},
    {_DATAF(-0.99962931871414185000), _DATAF(-0.02722479403018951400)},
    {_DATAF(-0.99963968992233276000), _DATAF(-0.02684143930673599200)},
    {_DATAF(-0.99964994192123413000), _DATAF(-0.02645808085799217200)},
    {_DATAF(-0.99966001510620117000), _DATAF(-0.02607471868395805400)},
    {_DATAF(-0.99966990947723389000), _DATAF(-0.02569135092198848700)},
    {_DATAF(-0.99967968463897705000), _DATAF(-0.02530798129737377200)},
    {_DATAF(-0.99968934059143066000), _DATAF(-0.02492460608482360800)},
    {_DATAF(-0.99969881772994995000), _DATAF(-0.02454122900962829600)},
    {_DATAF(-0.99970817565917969000), _DATAF(-0.02415784634649753600)},
    {_DATAF(-0.99971735477447510000), _DATAF(-0.02377446182072162600)},
    {_DATAF(-0.99972641468048096000), _DATAF(-0.02339107356965541800)},
    {_DATAF(-0.99973529577255249000), _DATAF(-0.02300768159329891200)},
    {_DATAF(-0.99974405765533447000), _DATAF(-0.02262428589165210700)},
    {_DATAF(-0.99975264072418213000), _DATAF(-0.02224088832736015300)},
    {_DATAF(-0.99976110458374023000), _DATAF(-0.02185748517513275100)},
    {_DATAF(-0.99976938962936401000), _DATAF(-0.02147408016026020100)},
    {_DATAF(-0.99977755546569824000), _DATAF(-0.02109067142009735100)},
    {_DATAF(-0.99978560209274292000), _DATAF(-0.02070726081728935200)},
    {_DATAF(-0.99979346990585327000), _DATAF(-0.02032384648919105500)},
    {_DATAF(-0.99980115890502930000), _DATAF(-0.01994042843580246000)},
    {_DATAF(-0.99980872869491577000), _DATAF(-0.01955700851976871500)},
    {_DATAF(-0.99981617927551270000), _DATAF(-0.01917358487844467200)},
    {_DATAF(-0.99982345104217529000), _DATAF(-0.01879015937447547900)},
    {_DATAF(-0.99983060359954834000), _DATAF(-0.01840673014521598800)},
    {_DATAF(-0.99983757734298706000), _DATAF(-0.01802329905331134800)},
    {_DATAF(-0.99984443187713623000), _DATAF(-0.01763986423611640900)},
    {_DATAF(-0.99985110759735107000), _DATAF(-0.01725642755627632100)},
    {_DATAF(-0.99985766410827637000), _DATAF(-0.01687298715114593500)},
    {_DATAF(-0.99986404180526733000), _DATAF(-0.01648954674601554900)},
    {_DATAF(-0.99987030029296875000), _DATAF(-0.01610610261559486400)},
    {_DATAF(-0.99987637996673584000), _DATAF(-0.01572265475988388100)},
    {_DATAF(-0.99988234043121338000), _DATAF(-0.01533920597285032300)},
    {_DATAF(-0.99988818168640137000), _DATAF(-0.01495575532317161600)},
    {_DATAF(-0.99989384412765503000), _DATAF(-0.01457230187952518500)},
    {_DATAF(-0.99989932775497437000), _DATAF(-0.01418884657323360400)},
    {_DATAF(-0.99990469217300415000), _DATAF(-0.01380538847297430000)},
    {_DATAF(-0.99990993738174438000), _DATAF(-0.01342192851006984700)},
    {_DATAF(-0.99991500377655029000), _DATAF(-0.01303846761584281900)},
    {_DATAF(-0.99991995096206665000), _DATAF(-0.01265500392764806700)},
    {_DATAF(-0.99992471933364868000), _DATAF(-0.01227153837680816700)},
    {_DATAF(-0.99992930889129639000), _DATAF(-0.01188807096332311600)},
    {_DATAF(-0.99993383884429932000), _DATAF(-0.01150460168719291700)},
    {_DATAF(-0.99993813037872314000), _DATAF(-0.01112113147974014300)},
    {_DATAF(-0.99994236230850220000), _DATAF(-0.01073765940964222000)},
    {_DATAF(-0.99994641542434692000), _DATAF(-0.01035418547689914700)},
    {_DATAF(-0.99995028972625732000), _DATAF(-0.00997070968151092530)},
    {_DATAF(-0.99995404481887817000), _DATAF(-0.00958723295480012890)},
    {_DATAF(-0.99995762109756470000), _DATAF(-0.00920375436544418330)},
    {_DATAF(-0.99996107816696167000), _DATAF(-0.00882027484476566310)},
    {_DATAF(-0.99996441602706909000), _DATAF(-0.00843679439276456830)},
    {_DATAF(-0.99996757507324219000), _DATAF(-0.00805331207811832430)},
    {_DATAF(-0.99997061491012573000), _DATAF(-0.00766982883214950560)},
    {_DATAF(-0.99997347593307495000), _DATAF(-0.00728634418919682500)},
    {_DATAF(-0.99997615814208984000), _DATAF(-0.00690285861492156980)},
    {_DATAF(-0.99997872114181519000), _DATAF(-0.00651937210932374000)},
    {_DATAF(-0.99998116493225098000), _DATAF(-0.00613588467240333560)},
    {_DATAF(-0.99998342990875244000), _DATAF(-0.00575239630416035650)},
    {_DATAF(-0.99998557567596436000), _DATAF(-0.00536890700459480290)},
    {_DATAF(-0.99998760223388672000), _DATAF(-0.00498541677370667460)},
    {_DATAF(-0.99998939037322998000), _DATAF(-0.00460192607715725900)},
    {_DATAF(-0.99999111890792847000), _DATAF(-0.00421843444928526880)},
    {_DATAF(-0.99999266862869263000), _DATAF(-0.00383494258858263490)},
    {_DATAF(-0.99999403953552246000), _DATAF(-0.00345145002938807010)},
    {_DATAF(-0.99999529123306274000), _DATAF(-0.00306795677170157430)},
    {_DATAF(-0.99999642372131348000), _DATAF(-0.00268446304835379120)},
    {_DATAF(-0.99999737739562988000), _DATAF(-0.00230096909217536450)},
    {_DATAF(-0.99999815225601196000), _DATAF(-0.00191747478675097230)},
    {_DATAF(-0.99999880790710449000), _DATAF(-0.00153398013208061460)},
    {_DATAF(-0.99999934434890747000), _DATAF(-0.00115048536099493500)},
    {_DATAF(-0.99999970197677612000), _DATAF(-0.00076699029887095094)},
    {_DATAF(-0.99999994039535522000), _DATAF(-0.00038349517853930593)},
};
/*lint +e915*/
