/**
 * \file IfxEdsadc_reg.h
 * \brief
 * \copyright Copyright (c) 2019 Infineon Technologies AG. All rights reserved.
 *
 *
 * Version: TC37xPD_UM_V1.2.0.R0
 * Specification: TC3xx User Manual V1.2.0
 * MAY BE CHANGED BY USER [yes/no]: No
 *
 *                                 IMPORTANT NOTICE
 *
 *
 * Use of this file is subject to the terms of use agreed between (i) you or 
 * the company in which ordinary course of business you are acting and (ii) 
 * Infineon Technologies AG or its licensees. If and as long as no such 
 * terms of use are agreed, use of this file is subject to following:


 * Boost Software License - Version 1.0 - August 17th, 2003

 * Permission is hereby granted, free of charge, to any person or 
 * organization obtaining a copy of the software and accompanying 
 * documentation covered by this license (the "Software") to use, reproduce,
 * display, distribute, execute, and transmit the Software, and to prepare
 * derivative works of the Software, and to permit third-parties to whom the 
 * Software is furnished to do so, all subject to the following:

 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer, must
 * be included in all copies of the Software, in whole or in part, and all
 * derivative works of the Software, unless such copies or derivative works are
 * solely in the form of machine-executable object code generated by a source
 * language processor.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * \defgroup IfxSfr_Edsadc_Registers_Cfg Edsadc address
 * \ingroup IfxSfr_Edsadc_Registers
 * 
 * \defgroup IfxSfr_Edsadc_Registers_Cfg_BaseAddress Base address
 * \ingroup IfxSfr_Edsadc_Registers_Cfg
 *
 * \defgroup IfxSfr_Edsadc_Registers_Cfg_Edsadc 2-EDSADC
 * \ingroup IfxSfr_Edsadc_Registers_Cfg
 *
 *
 */
#ifndef IFXEDSADC_REG_H
#define IFXEDSADC_REG_H 1
/******************************************************************************/
#include "IfxEdsadc_regdef.h"
/******************************************************************************/

/******************************************************************************/

/******************************************************************************/

/** \addtogroup IfxSfr_Edsadc_Registers_Cfg_BaseAddress
 * \{  */

/** \brief EDSADC object */
#define MODULE_EDSADC /*lint --e(923, 9078)*/ ((*(Ifx_EDSADC*)0xF0024000u))
/** \}  */


/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Edsadc_Registers_Cfg_Edsadc
 * \{  */
/** \brief 0, Clock Control Register */
#define EDSADC_CLC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CLC*)0xF0024000u)

/** \brief 8, Module Identification Register */
#define EDSADC_ID /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_ID*)0xF0024008u)

/** \brief 28, OCDS Control and Status Register */
#define EDSADC_OCS /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_OCS*)0xF0024028u)

/** \brief 2C, Kernel Reset Status Clear Register */
#define EDSADC_KRSTCLR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_KRSTCLR*)0xF002402Cu)

/** \brief 30, Kernel Reset Register 1 */
#define EDSADC_KRST1 /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_KRST1*)0xF0024030u)

/** \brief 34, Kernel Reset Register 0 */
#define EDSADC_KRST0 /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_KRST0*)0xF0024034u)

/** \brief 3C, Access Enable Register 0 */
#define EDSADC_ACCEN0 /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_ACCEN0*)0xF002403Cu)

/** \brief 80, Global Configuration Register */
#define EDSADC_GLOBCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_GLOBCFG*)0xF0024080u)

/** \brief 88, Global Run Control Register */
#define EDSADC_GLOBRC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_GLOBRC*)0xF0024088u)

/** \brief 90, Access Protection Register */
#define EDSADC_ACCPROT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_ACCPROT*)0xF0024090u)

/** \brief A0, Carrier Generator Configuration Register */
#define EDSADC_CGCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CGCFG*)0xF00240A0u)

/** \brief E0, Event Flag Register */
#define EDSADC_EVFLAG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_EVFLAG*)0xF00240E0u)

/** \brief E4, Event Flag Clear Register */
#define EDSADC_EVFLAGCLR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_EVFLAGCLR*)0xF00240E4u)

/** \brief 100, Modulator Configuration Register 0 */
#define EDSADC_CH0_MODCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_MODCFG*)0xF0024100u)
/** Alias (User Manual Name) for EDSADC_CH0_MODCFG.
* To use register names with standard convension, please use EDSADC_CH0_MODCFG.
*/
#define EDSADC_MODCFG0 (EDSADC_CH0_MODCFG)

/** \brief 108, Demodulator Input Config. Register 0 */
#define EDSADC_CH0_DICFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_DICFG*)0xF0024108u)
/** Alias (User Manual Name) for EDSADC_CH0_DICFG.
* To use register names with standard convension, please use EDSADC_CH0_DICFG.
*/
#define EDSADC_DICFG0 (EDSADC_CH0_DICFG)

/** \brief 110, Filter Configuration Register 0, Main */
#define EDSADC_CH0_FCFGM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGM*)0xF0024110u)
/** Alias (User Manual Name) for EDSADC_CH0_FCFGM.
* To use register names with standard convension, please use EDSADC_CH0_FCFGM.
*/
#define EDSADC_FCFGM0 (EDSADC_CH0_FCFGM)

/** \brief 114, Filter Configuration Register 0, CIC Filter */
#define EDSADC_CH0_FCFGC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGC*)0xF0024114u)
/** Alias (User Manual Name) for EDSADC_CH0_FCFGC.
* To use register names with standard convension, please use EDSADC_CH0_FCFGC.
*/
#define EDSADC_FCFGC0 (EDSADC_CH0_FCFGC)

/** \brief 118, Filter Counter Register 0, CIC Filter */
#define EDSADC_CH0_FCNTC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCNTC*)0xF0024118u)
/** Alias (User Manual Name) for EDSADC_CH0_FCNTC.
* To use register names with standard convension, please use EDSADC_CH0_FCNTC.
*/
#define EDSADC_FCNTC0 (EDSADC_CH0_FCNTC)

/** \brief 11C, Overshoot Compensation Cfg. Register 0 */
#define EDSADC_CH0_OVSCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_OVSCFG*)0xF002411Cu)
/** Alias (User Manual Name) for EDSADC_CH0_OVSCFG.
* To use register names with standard convension, please use EDSADC_CH0_OVSCFG.
*/
#define EDSADC_OVSCFG0 (EDSADC_CH0_OVSCFG)

/** \brief 120, Integration Window Control Register 0 */
#define EDSADC_CH0_IWCTR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_IWCTR*)0xF0024120u)
/** Alias (User Manual Name) for EDSADC_CH0_IWCTR.
* To use register names with standard convension, please use EDSADC_CH0_IWCTR.
*/
#define EDSADC_IWCTR0 (EDSADC_CH0_IWCTR)

/** \brief 124, Intermediate Integration Value */
#define EDSADC_CH0_IIVAL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_IIVAL*)0xF0024124u)
/** Alias (User Manual Name) for EDSADC_CH0_IIVAL.
* To use register names with standard convension, please use EDSADC_CH0_IIVAL.
*/
#define EDSADC_IIVAL0 (EDSADC_CH0_IIVAL)

/** \brief 128, Integrator Status Register 0 */
#define EDSADC_CH0_ISTAT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_ISTAT*)0xF0024128u)
/** Alias (User Manual Name) for EDSADC_CH0_ISTAT.
* To use register names with standard convension, please use EDSADC_CH0_ISTAT.
*/
#define EDSADC_ISTAT0 (EDSADC_CH0_ISTAT)

/** \brief 12C, Result FIFO Control Register 0 */
#define EDSADC_CH0_RFC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RFC*)0xF002412Cu)
/** Alias (User Manual Name) for EDSADC_CH0_RFC.
* To use register names with standard convension, please use EDSADC_CH0_RFC.
*/
#define EDSADC_RFC0 (EDSADC_CH0_RFC)

/** \brief 130, Result Register 0 Main */
#define EDSADC_CH0_RESM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RESM*)0xF0024130u)
/** Alias (User Manual Name) for EDSADC_CH0_RESM.
* To use register names with standard convension, please use EDSADC_CH0_RESM.
*/
#define EDSADC_RESM0 (EDSADC_CH0_RESM)

/** \brief 138, Offset Compensation Register 0 */
#define EDSADC_CH0_OFFCOMP /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_OFFCOMP*)0xF0024138u)
/** Alias (User Manual Name) for EDSADC_CH0_OFFCOMP.
* To use register names with standard convension, please use EDSADC_CH0_OFFCOMP.
*/
#define EDSADC_OFFCOMP0 (EDSADC_CH0_OFFCOMP)

/** \brief 13C, Gain Calibration Register 0 */
#define EDSADC_CH0_GAINCAL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCAL*)0xF002413Cu)
/** Alias (User Manual Name) for EDSADC_CH0_GAINCAL.
* To use register names with standard convension, please use EDSADC_CH0_GAINCAL.
*/
#define EDSADC_GAINCAL0 (EDSADC_CH0_GAINCAL)

/** \brief 140, Gain Control Register 0 */
#define EDSADC_CH0_GAINCTR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCTR*)0xF0024140u)
/** Alias (User Manual Name) for EDSADC_CH0_GAINCTR.
* To use register names with standard convension, please use EDSADC_CH0_GAINCTR.
*/
#define EDSADC_GAINCTR0 (EDSADC_CH0_GAINCTR)

/** \brief 144, Gain Correction Register 0 */
#define EDSADC_CH0_GAINCORR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCORR*)0xF0024144u)
/** Alias (User Manual Name) for EDSADC_CH0_GAINCORR.
* To use register names with standard convension, please use EDSADC_CH0_GAINCORR.
*/
#define EDSADC_GAINCORR0 (EDSADC_CH0_GAINCORR)

/** \brief 150, Time-Stamp Register 0 */
#define EDSADC_CH0_TSTMP /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_TSTMP*)0xF0024150u)
/** Alias (User Manual Name) for EDSADC_CH0_TSTMP.
* To use register names with standard convension, please use EDSADC_CH0_TSTMP.
*/
#define EDSADC_TSTMP0 (EDSADC_CH0_TSTMP)

/** \brief 154, Time-Stamp Counter 0 */
#define EDSADC_CH0_TSCNT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_TSCNT*)0xF0024154u)
/** Alias (User Manual Name) for EDSADC_CH0_TSCNT.
* To use register names with standard convension, please use EDSADC_CH0_TSCNT.
*/
#define EDSADC_TSCNT0 (EDSADC_CH0_TSCNT)

/** \brief 170, Auxiliary Filter Configuration Register 0 */
#define EDSADC_CH0_FCFGA /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGA*)0xF0024170u)
/** Alias (User Manual Name) for EDSADC_CH0_FCFGA.
* To use register names with standard convension, please use EDSADC_CH0_FCFGA.
*/
#define EDSADC_FCFGA0 (EDSADC_CH0_FCFGA)

/** \brief 178, Boundary Select Register 0 */
#define EDSADC_CH0_BOUNDSEL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_BOUNDSEL*)0xF0024178u)
/** Alias (User Manual Name) for EDSADC_CH0_BOUNDSEL.
* To use register names with standard convension, please use EDSADC_CH0_BOUNDSEL.
*/
#define EDSADC_BOUNDSEL0 (EDSADC_CH0_BOUNDSEL)

/** \brief 180, Result Register 0 Auxiliary */
#define EDSADC_CH0_RESA /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RESA*)0xF0024180u)
/** Alias (User Manual Name) for EDSADC_CH0_RESA.
* To use register names with standard convension, please use EDSADC_CH0_RESA.
*/
#define EDSADC_RESA0 (EDSADC_CH0_RESA)

/** \brief 1A0, Carrier Generator Synchronization Reg. 0 */
#define EDSADC_CH0_CGSYNC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_CGSYNC*)0xF00241A0u)
/** Alias (User Manual Name) for EDSADC_CH0_CGSYNC.
* To use register names with standard convension, please use EDSADC_CH0_CGSYNC.
*/
#define EDSADC_CGSYNC0 (EDSADC_CH0_CGSYNC)

/** \brief 1A8, Rectification Configuration Register 0 */
#define EDSADC_CH0_RECTCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RECTCFG*)0xF00241A8u)
/** Alias (User Manual Name) for EDSADC_CH0_RECTCFG.
* To use register names with standard convension, please use EDSADC_CH0_RECTCFG.
*/
#define EDSADC_RECTCFG0 (EDSADC_CH0_RECTCFG)

/** \brief 1B0, Common Mode Voltage Register 0 */
#define EDSADC_CH0_VCM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_VCM*)0xF00241B0u)
/** Alias (User Manual Name) for EDSADC_CH0_VCM.
* To use register names with standard convension, please use EDSADC_CH0_VCM.
*/
#define EDSADC_VCM0 (EDSADC_CH0_VCM)

/** \brief 200, Modulator Configuration Register 1 */
#define EDSADC_CH1_MODCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_MODCFG*)0xF0024200u)
/** Alias (User Manual Name) for EDSADC_CH1_MODCFG.
* To use register names with standard convension, please use EDSADC_CH1_MODCFG.
*/
#define EDSADC_MODCFG1 (EDSADC_CH1_MODCFG)

/** \brief 208, Demodulator Input Config. Register 1 */
#define EDSADC_CH1_DICFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_DICFG*)0xF0024208u)
/** Alias (User Manual Name) for EDSADC_CH1_DICFG.
* To use register names with standard convension, please use EDSADC_CH1_DICFG.
*/
#define EDSADC_DICFG1 (EDSADC_CH1_DICFG)

/** \brief 210, Filter Configuration Register 1, Main */
#define EDSADC_CH1_FCFGM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGM*)0xF0024210u)
/** Alias (User Manual Name) for EDSADC_CH1_FCFGM.
* To use register names with standard convension, please use EDSADC_CH1_FCFGM.
*/
#define EDSADC_FCFGM1 (EDSADC_CH1_FCFGM)

/** \brief 214, Filter Configuration Register 1, CIC Filter */
#define EDSADC_CH1_FCFGC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGC*)0xF0024214u)
/** Alias (User Manual Name) for EDSADC_CH1_FCFGC.
* To use register names with standard convension, please use EDSADC_CH1_FCFGC.
*/
#define EDSADC_FCFGC1 (EDSADC_CH1_FCFGC)

/** \brief 218, Filter Counter Register 1, CIC Filter */
#define EDSADC_CH1_FCNTC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCNTC*)0xF0024218u)
/** Alias (User Manual Name) for EDSADC_CH1_FCNTC.
* To use register names with standard convension, please use EDSADC_CH1_FCNTC.
*/
#define EDSADC_FCNTC1 (EDSADC_CH1_FCNTC)

/** \brief 21C, Overshoot Compensation Cfg. Register 1 */
#define EDSADC_CH1_OVSCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_OVSCFG*)0xF002421Cu)
/** Alias (User Manual Name) for EDSADC_CH1_OVSCFG.
* To use register names with standard convension, please use EDSADC_CH1_OVSCFG.
*/
#define EDSADC_OVSCFG1 (EDSADC_CH1_OVSCFG)

/** \brief 220, Integration Window Control Register 1 */
#define EDSADC_CH1_IWCTR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_IWCTR*)0xF0024220u)
/** Alias (User Manual Name) for EDSADC_CH1_IWCTR.
* To use register names with standard convension, please use EDSADC_CH1_IWCTR.
*/
#define EDSADC_IWCTR1 (EDSADC_CH1_IWCTR)

/** \brief 224, Intermediate Integration Value */
#define EDSADC_CH1_IIVAL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_IIVAL*)0xF0024224u)
/** Alias (User Manual Name) for EDSADC_CH1_IIVAL.
* To use register names with standard convension, please use EDSADC_CH1_IIVAL.
*/
#define EDSADC_IIVAL1 (EDSADC_CH1_IIVAL)

/** \brief 228, Integrator Status Register 1 */
#define EDSADC_CH1_ISTAT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_ISTAT*)0xF0024228u)
/** Alias (User Manual Name) for EDSADC_CH1_ISTAT.
* To use register names with standard convension, please use EDSADC_CH1_ISTAT.
*/
#define EDSADC_ISTAT1 (EDSADC_CH1_ISTAT)

/** \brief 22C, Result FIFO Control Register 1 */
#define EDSADC_CH1_RFC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RFC*)0xF002422Cu)
/** Alias (User Manual Name) for EDSADC_CH1_RFC.
* To use register names with standard convension, please use EDSADC_CH1_RFC.
*/
#define EDSADC_RFC1 (EDSADC_CH1_RFC)

/** \brief 230, Result Register 1 Main */
#define EDSADC_CH1_RESM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RESM*)0xF0024230u)
/** Alias (User Manual Name) for EDSADC_CH1_RESM.
* To use register names with standard convension, please use EDSADC_CH1_RESM.
*/
#define EDSADC_RESM1 (EDSADC_CH1_RESM)

/** \brief 238, Offset Compensation Register 1 */
#define EDSADC_CH1_OFFCOMP /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_OFFCOMP*)0xF0024238u)
/** Alias (User Manual Name) for EDSADC_CH1_OFFCOMP.
* To use register names with standard convension, please use EDSADC_CH1_OFFCOMP.
*/
#define EDSADC_OFFCOMP1 (EDSADC_CH1_OFFCOMP)

/** \brief 23C, Gain Calibration Register 1 */
#define EDSADC_CH1_GAINCAL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCAL*)0xF002423Cu)
/** Alias (User Manual Name) for EDSADC_CH1_GAINCAL.
* To use register names with standard convension, please use EDSADC_CH1_GAINCAL.
*/
#define EDSADC_GAINCAL1 (EDSADC_CH1_GAINCAL)

/** \brief 240, Gain Control Register 1 */
#define EDSADC_CH1_GAINCTR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCTR*)0xF0024240u)
/** Alias (User Manual Name) for EDSADC_CH1_GAINCTR.
* To use register names with standard convension, please use EDSADC_CH1_GAINCTR.
*/
#define EDSADC_GAINCTR1 (EDSADC_CH1_GAINCTR)

/** \brief 244, Gain Correction Register 1 */
#define EDSADC_CH1_GAINCORR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCORR*)0xF0024244u)
/** Alias (User Manual Name) for EDSADC_CH1_GAINCORR.
* To use register names with standard convension, please use EDSADC_CH1_GAINCORR.
*/
#define EDSADC_GAINCORR1 (EDSADC_CH1_GAINCORR)

/** \brief 250, Time-Stamp Register 1 */
#define EDSADC_CH1_TSTMP /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_TSTMP*)0xF0024250u)
/** Alias (User Manual Name) for EDSADC_CH1_TSTMP.
* To use register names with standard convension, please use EDSADC_CH1_TSTMP.
*/
#define EDSADC_TSTMP1 (EDSADC_CH1_TSTMP)

/** \brief 254, Time-Stamp Counter 1 */
#define EDSADC_CH1_TSCNT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_TSCNT*)0xF0024254u)
/** Alias (User Manual Name) for EDSADC_CH1_TSCNT.
* To use register names with standard convension, please use EDSADC_CH1_TSCNT.
*/
#define EDSADC_TSCNT1 (EDSADC_CH1_TSCNT)

/** \brief 270, Auxiliary Filter Configuration Register 1 */
#define EDSADC_CH1_FCFGA /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGA*)0xF0024270u)
/** Alias (User Manual Name) for EDSADC_CH1_FCFGA.
* To use register names with standard convension, please use EDSADC_CH1_FCFGA.
*/
#define EDSADC_FCFGA1 (EDSADC_CH1_FCFGA)

/** \brief 278, Boundary Select Register 1 */
#define EDSADC_CH1_BOUNDSEL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_BOUNDSEL*)0xF0024278u)
/** Alias (User Manual Name) for EDSADC_CH1_BOUNDSEL.
* To use register names with standard convension, please use EDSADC_CH1_BOUNDSEL.
*/
#define EDSADC_BOUNDSEL1 (EDSADC_CH1_BOUNDSEL)

/** \brief 280, Result Register 1 Auxiliary */
#define EDSADC_CH1_RESA /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RESA*)0xF0024280u)
/** Alias (User Manual Name) for EDSADC_CH1_RESA.
* To use register names with standard convension, please use EDSADC_CH1_RESA.
*/
#define EDSADC_RESA1 (EDSADC_CH1_RESA)

/** \brief 2A0, Carrier Generator Synchronization Reg. 1 */
#define EDSADC_CH1_CGSYNC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_CGSYNC*)0xF00242A0u)
/** Alias (User Manual Name) for EDSADC_CH1_CGSYNC.
* To use register names with standard convension, please use EDSADC_CH1_CGSYNC.
*/
#define EDSADC_CGSYNC1 (EDSADC_CH1_CGSYNC)

/** \brief 2A8, Rectification Configuration Register 1 */
#define EDSADC_CH1_RECTCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RECTCFG*)0xF00242A8u)
/** Alias (User Manual Name) for EDSADC_CH1_RECTCFG.
* To use register names with standard convension, please use EDSADC_CH1_RECTCFG.
*/
#define EDSADC_RECTCFG1 (EDSADC_CH1_RECTCFG)

/** \brief 2B0, Common Mode Voltage Register 1 */
#define EDSADC_CH1_VCM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_VCM*)0xF00242B0u)
/** Alias (User Manual Name) for EDSADC_CH1_VCM.
* To use register names with standard convension, please use EDSADC_CH1_VCM.
*/
#define EDSADC_VCM1 (EDSADC_CH1_VCM)

/** \brief 300, Modulator Configuration Register 2 */
#define EDSADC_CH2_MODCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_MODCFG*)0xF0024300u)
/** Alias (User Manual Name) for EDSADC_CH2_MODCFG.
* To use register names with standard convension, please use EDSADC_CH2_MODCFG.
*/
#define EDSADC_MODCFG2 (EDSADC_CH2_MODCFG)

/** \brief 308, Demodulator Input Config. Register 2 */
#define EDSADC_CH2_DICFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_DICFG*)0xF0024308u)
/** Alias (User Manual Name) for EDSADC_CH2_DICFG.
* To use register names with standard convension, please use EDSADC_CH2_DICFG.
*/
#define EDSADC_DICFG2 (EDSADC_CH2_DICFG)

/** \brief 310, Filter Configuration Register 2, Main */
#define EDSADC_CH2_FCFGM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGM*)0xF0024310u)
/** Alias (User Manual Name) for EDSADC_CH2_FCFGM.
* To use register names with standard convension, please use EDSADC_CH2_FCFGM.
*/
#define EDSADC_FCFGM2 (EDSADC_CH2_FCFGM)

/** \brief 314, Filter Configuration Register 2, CIC Filter */
#define EDSADC_CH2_FCFGC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGC*)0xF0024314u)
/** Alias (User Manual Name) for EDSADC_CH2_FCFGC.
* To use register names with standard convension, please use EDSADC_CH2_FCFGC.
*/
#define EDSADC_FCFGC2 (EDSADC_CH2_FCFGC)

/** \brief 318, Filter Counter Register 2, CIC Filter */
#define EDSADC_CH2_FCNTC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCNTC*)0xF0024318u)
/** Alias (User Manual Name) for EDSADC_CH2_FCNTC.
* To use register names with standard convension, please use EDSADC_CH2_FCNTC.
*/
#define EDSADC_FCNTC2 (EDSADC_CH2_FCNTC)

/** \brief 31C, Overshoot Compensation Cfg. Register 2 */
#define EDSADC_CH2_OVSCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_OVSCFG*)0xF002431Cu)
/** Alias (User Manual Name) for EDSADC_CH2_OVSCFG.
* To use register names with standard convension, please use EDSADC_CH2_OVSCFG.
*/
#define EDSADC_OVSCFG2 (EDSADC_CH2_OVSCFG)

/** \brief 320, Integration Window Control Register 2 */
#define EDSADC_CH2_IWCTR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_IWCTR*)0xF0024320u)
/** Alias (User Manual Name) for EDSADC_CH2_IWCTR.
* To use register names with standard convension, please use EDSADC_CH2_IWCTR.
*/
#define EDSADC_IWCTR2 (EDSADC_CH2_IWCTR)

/** \brief 324, Intermediate Integration Value */
#define EDSADC_CH2_IIVAL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_IIVAL*)0xF0024324u)
/** Alias (User Manual Name) for EDSADC_CH2_IIVAL.
* To use register names with standard convension, please use EDSADC_CH2_IIVAL.
*/
#define EDSADC_IIVAL2 (EDSADC_CH2_IIVAL)

/** \brief 328, Integrator Status Register 2 */
#define EDSADC_CH2_ISTAT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_ISTAT*)0xF0024328u)
/** Alias (User Manual Name) for EDSADC_CH2_ISTAT.
* To use register names with standard convension, please use EDSADC_CH2_ISTAT.
*/
#define EDSADC_ISTAT2 (EDSADC_CH2_ISTAT)

/** \brief 32C, Result FIFO Control Register 2 */
#define EDSADC_CH2_RFC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RFC*)0xF002432Cu)
/** Alias (User Manual Name) for EDSADC_CH2_RFC.
* To use register names with standard convension, please use EDSADC_CH2_RFC.
*/
#define EDSADC_RFC2 (EDSADC_CH2_RFC)

/** \brief 330, Result Register 2 Main */
#define EDSADC_CH2_RESM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RESM*)0xF0024330u)
/** Alias (User Manual Name) for EDSADC_CH2_RESM.
* To use register names with standard convension, please use EDSADC_CH2_RESM.
*/
#define EDSADC_RESM2 (EDSADC_CH2_RESM)

/** \brief 338, Offset Compensation Register 2 */
#define EDSADC_CH2_OFFCOMP /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_OFFCOMP*)0xF0024338u)
/** Alias (User Manual Name) for EDSADC_CH2_OFFCOMP.
* To use register names with standard convension, please use EDSADC_CH2_OFFCOMP.
*/
#define EDSADC_OFFCOMP2 (EDSADC_CH2_OFFCOMP)

/** \brief 33C, Gain Calibration Register 2 */
#define EDSADC_CH2_GAINCAL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCAL*)0xF002433Cu)
/** Alias (User Manual Name) for EDSADC_CH2_GAINCAL.
* To use register names with standard convension, please use EDSADC_CH2_GAINCAL.
*/
#define EDSADC_GAINCAL2 (EDSADC_CH2_GAINCAL)

/** \brief 340, Gain Control Register 2 */
#define EDSADC_CH2_GAINCTR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCTR*)0xF0024340u)
/** Alias (User Manual Name) for EDSADC_CH2_GAINCTR.
* To use register names with standard convension, please use EDSADC_CH2_GAINCTR.
*/
#define EDSADC_GAINCTR2 (EDSADC_CH2_GAINCTR)

/** \brief 344, Gain Correction Register 2 */
#define EDSADC_CH2_GAINCORR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCORR*)0xF0024344u)
/** Alias (User Manual Name) for EDSADC_CH2_GAINCORR.
* To use register names with standard convension, please use EDSADC_CH2_GAINCORR.
*/
#define EDSADC_GAINCORR2 (EDSADC_CH2_GAINCORR)

/** \brief 350, Time-Stamp Register 2 */
#define EDSADC_CH2_TSTMP /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_TSTMP*)0xF0024350u)
/** Alias (User Manual Name) for EDSADC_CH2_TSTMP.
* To use register names with standard convension, please use EDSADC_CH2_TSTMP.
*/
#define EDSADC_TSTMP2 (EDSADC_CH2_TSTMP)

/** \brief 354, Time-Stamp Counter 2 */
#define EDSADC_CH2_TSCNT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_TSCNT*)0xF0024354u)
/** Alias (User Manual Name) for EDSADC_CH2_TSCNT.
* To use register names with standard convension, please use EDSADC_CH2_TSCNT.
*/
#define EDSADC_TSCNT2 (EDSADC_CH2_TSCNT)

/** \brief 370, Auxiliary Filter Configuration Register 2 */
#define EDSADC_CH2_FCFGA /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGA*)0xF0024370u)
/** Alias (User Manual Name) for EDSADC_CH2_FCFGA.
* To use register names with standard convension, please use EDSADC_CH2_FCFGA.
*/
#define EDSADC_FCFGA2 (EDSADC_CH2_FCFGA)

/** \brief 378, Boundary Select Register 2 */
#define EDSADC_CH2_BOUNDSEL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_BOUNDSEL*)0xF0024378u)
/** Alias (User Manual Name) for EDSADC_CH2_BOUNDSEL.
* To use register names with standard convension, please use EDSADC_CH2_BOUNDSEL.
*/
#define EDSADC_BOUNDSEL2 (EDSADC_CH2_BOUNDSEL)

/** \brief 380, Result Register 2 Auxiliary */
#define EDSADC_CH2_RESA /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RESA*)0xF0024380u)
/** Alias (User Manual Name) for EDSADC_CH2_RESA.
* To use register names with standard convension, please use EDSADC_CH2_RESA.
*/
#define EDSADC_RESA2 (EDSADC_CH2_RESA)

/** \brief 3A0, Carrier Generator Synchronization Reg. 2 */
#define EDSADC_CH2_CGSYNC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_CGSYNC*)0xF00243A0u)
/** Alias (User Manual Name) for EDSADC_CH2_CGSYNC.
* To use register names with standard convension, please use EDSADC_CH2_CGSYNC.
*/
#define EDSADC_CGSYNC2 (EDSADC_CH2_CGSYNC)

/** \brief 3A8, Rectification Configuration Register 2 */
#define EDSADC_CH2_RECTCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RECTCFG*)0xF00243A8u)
/** Alias (User Manual Name) for EDSADC_CH2_RECTCFG.
* To use register names with standard convension, please use EDSADC_CH2_RECTCFG.
*/
#define EDSADC_RECTCFG2 (EDSADC_CH2_RECTCFG)

/** \brief 3B0, Common Mode Voltage Register 2 */
#define EDSADC_CH2_VCM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_VCM*)0xF00243B0u)
/** Alias (User Manual Name) for EDSADC_CH2_VCM.
* To use register names with standard convension, please use EDSADC_CH2_VCM.
*/
#define EDSADC_VCM2 (EDSADC_CH2_VCM)

/** \brief 400, Modulator Configuration Register 3 */
#define EDSADC_CH3_MODCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_MODCFG*)0xF0024400u)
/** Alias (User Manual Name) for EDSADC_CH3_MODCFG.
* To use register names with standard convension, please use EDSADC_CH3_MODCFG.
*/
#define EDSADC_MODCFG3 (EDSADC_CH3_MODCFG)

/** \brief 408, Demodulator Input Config. Register 3 */
#define EDSADC_CH3_DICFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_DICFG*)0xF0024408u)
/** Alias (User Manual Name) for EDSADC_CH3_DICFG.
* To use register names with standard convension, please use EDSADC_CH3_DICFG.
*/
#define EDSADC_DICFG3 (EDSADC_CH3_DICFG)

/** \brief 410, Filter Configuration Register 3, Main */
#define EDSADC_CH3_FCFGM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGM*)0xF0024410u)
/** Alias (User Manual Name) for EDSADC_CH3_FCFGM.
* To use register names with standard convension, please use EDSADC_CH3_FCFGM.
*/
#define EDSADC_FCFGM3 (EDSADC_CH3_FCFGM)

/** \brief 414, Filter Configuration Register 3, CIC Filter */
#define EDSADC_CH3_FCFGC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGC*)0xF0024414u)
/** Alias (User Manual Name) for EDSADC_CH3_FCFGC.
* To use register names with standard convension, please use EDSADC_CH3_FCFGC.
*/
#define EDSADC_FCFGC3 (EDSADC_CH3_FCFGC)

/** \brief 418, Filter Counter Register 3, CIC Filter */
#define EDSADC_CH3_FCNTC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCNTC*)0xF0024418u)
/** Alias (User Manual Name) for EDSADC_CH3_FCNTC.
* To use register names with standard convension, please use EDSADC_CH3_FCNTC.
*/
#define EDSADC_FCNTC3 (EDSADC_CH3_FCNTC)

/** \brief 41C, Overshoot Compensation Cfg. Register 3 */
#define EDSADC_CH3_OVSCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_OVSCFG*)0xF002441Cu)
/** Alias (User Manual Name) for EDSADC_CH3_OVSCFG.
* To use register names with standard convension, please use EDSADC_CH3_OVSCFG.
*/
#define EDSADC_OVSCFG3 (EDSADC_CH3_OVSCFG)

/** \brief 420, Integration Window Control Register 3 */
#define EDSADC_CH3_IWCTR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_IWCTR*)0xF0024420u)
/** Alias (User Manual Name) for EDSADC_CH3_IWCTR.
* To use register names with standard convension, please use EDSADC_CH3_IWCTR.
*/
#define EDSADC_IWCTR3 (EDSADC_CH3_IWCTR)

/** \brief 424, Intermediate Integration Value */
#define EDSADC_CH3_IIVAL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_IIVAL*)0xF0024424u)
/** Alias (User Manual Name) for EDSADC_CH3_IIVAL.
* To use register names with standard convension, please use EDSADC_CH3_IIVAL.
*/
#define EDSADC_IIVAL3 (EDSADC_CH3_IIVAL)

/** \brief 428, Integrator Status Register 3 */
#define EDSADC_CH3_ISTAT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_ISTAT*)0xF0024428u)
/** Alias (User Manual Name) for EDSADC_CH3_ISTAT.
* To use register names with standard convension, please use EDSADC_CH3_ISTAT.
*/
#define EDSADC_ISTAT3 (EDSADC_CH3_ISTAT)

/** \brief 42C, Result FIFO Control Register 3 */
#define EDSADC_CH3_RFC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RFC*)0xF002442Cu)
/** Alias (User Manual Name) for EDSADC_CH3_RFC.
* To use register names with standard convension, please use EDSADC_CH3_RFC.
*/
#define EDSADC_RFC3 (EDSADC_CH3_RFC)

/** \brief 430, Result Register 3 Main */
#define EDSADC_CH3_RESM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RESM*)0xF0024430u)
/** Alias (User Manual Name) for EDSADC_CH3_RESM.
* To use register names with standard convension, please use EDSADC_CH3_RESM.
*/
#define EDSADC_RESM3 (EDSADC_CH3_RESM)

/** \brief 438, Offset Compensation Register 3 */
#define EDSADC_CH3_OFFCOMP /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_OFFCOMP*)0xF0024438u)
/** Alias (User Manual Name) for EDSADC_CH3_OFFCOMP.
* To use register names with standard convension, please use EDSADC_CH3_OFFCOMP.
*/
#define EDSADC_OFFCOMP3 (EDSADC_CH3_OFFCOMP)

/** \brief 43C, Gain Calibration Register 3 */
#define EDSADC_CH3_GAINCAL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCAL*)0xF002443Cu)
/** Alias (User Manual Name) for EDSADC_CH3_GAINCAL.
* To use register names with standard convension, please use EDSADC_CH3_GAINCAL.
*/
#define EDSADC_GAINCAL3 (EDSADC_CH3_GAINCAL)

/** \brief 440, Gain Control Register 3 */
#define EDSADC_CH3_GAINCTR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCTR*)0xF0024440u)
/** Alias (User Manual Name) for EDSADC_CH3_GAINCTR.
* To use register names with standard convension, please use EDSADC_CH3_GAINCTR.
*/
#define EDSADC_GAINCTR3 (EDSADC_CH3_GAINCTR)

/** \brief 444, Gain Correction Register 3 */
#define EDSADC_CH3_GAINCORR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCORR*)0xF0024444u)
/** Alias (User Manual Name) for EDSADC_CH3_GAINCORR.
* To use register names with standard convension, please use EDSADC_CH3_GAINCORR.
*/
#define EDSADC_GAINCORR3 (EDSADC_CH3_GAINCORR)

/** \brief 450, Time-Stamp Register 3 */
#define EDSADC_CH3_TSTMP /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_TSTMP*)0xF0024450u)
/** Alias (User Manual Name) for EDSADC_CH3_TSTMP.
* To use register names with standard convension, please use EDSADC_CH3_TSTMP.
*/
#define EDSADC_TSTMP3 (EDSADC_CH3_TSTMP)

/** \brief 454, Time-Stamp Counter 3 */
#define EDSADC_CH3_TSCNT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_TSCNT*)0xF0024454u)
/** Alias (User Manual Name) for EDSADC_CH3_TSCNT.
* To use register names with standard convension, please use EDSADC_CH3_TSCNT.
*/
#define EDSADC_TSCNT3 (EDSADC_CH3_TSCNT)

/** \brief 470, Auxiliary Filter Configuration Register 3 */
#define EDSADC_CH3_FCFGA /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGA*)0xF0024470u)
/** Alias (User Manual Name) for EDSADC_CH3_FCFGA.
* To use register names with standard convension, please use EDSADC_CH3_FCFGA.
*/
#define EDSADC_FCFGA3 (EDSADC_CH3_FCFGA)

/** \brief 478, Boundary Select Register 3 */
#define EDSADC_CH3_BOUNDSEL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_BOUNDSEL*)0xF0024478u)
/** Alias (User Manual Name) for EDSADC_CH3_BOUNDSEL.
* To use register names with standard convension, please use EDSADC_CH3_BOUNDSEL.
*/
#define EDSADC_BOUNDSEL3 (EDSADC_CH3_BOUNDSEL)

/** \brief 480, Result Register 3 Auxiliary */
#define EDSADC_CH3_RESA /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RESA*)0xF0024480u)
/** Alias (User Manual Name) for EDSADC_CH3_RESA.
* To use register names with standard convension, please use EDSADC_CH3_RESA.
*/
#define EDSADC_RESA3 (EDSADC_CH3_RESA)

/** \brief 4A0, Carrier Generator Synchronization Reg. 3 */
#define EDSADC_CH3_CGSYNC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_CGSYNC*)0xF00244A0u)
/** Alias (User Manual Name) for EDSADC_CH3_CGSYNC.
* To use register names with standard convension, please use EDSADC_CH3_CGSYNC.
*/
#define EDSADC_CGSYNC3 (EDSADC_CH3_CGSYNC)

/** \brief 4A8, Rectification Configuration Register 3 */
#define EDSADC_CH3_RECTCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RECTCFG*)0xF00244A8u)
/** Alias (User Manual Name) for EDSADC_CH3_RECTCFG.
* To use register names with standard convension, please use EDSADC_CH3_RECTCFG.
*/
#define EDSADC_RECTCFG3 (EDSADC_CH3_RECTCFG)

/** \brief 4B0, Common Mode Voltage Register 3 */
#define EDSADC_CH3_VCM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_VCM*)0xF00244B0u)
/** Alias (User Manual Name) for EDSADC_CH3_VCM.
* To use register names with standard convension, please use EDSADC_CH3_VCM.
*/
#define EDSADC_VCM3 (EDSADC_CH3_VCM)

/** \brief 500, Modulator Configuration Register 4 */
#define EDSADC_CH4_MODCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_MODCFG*)0xF0024500u)
/** Alias (User Manual Name) for EDSADC_CH4_MODCFG.
* To use register names with standard convension, please use EDSADC_CH4_MODCFG.
*/
#define EDSADC_MODCFG4 (EDSADC_CH4_MODCFG)

/** \brief 508, Demodulator Input Config. Register 4 */
#define EDSADC_CH4_DICFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_DICFG*)0xF0024508u)
/** Alias (User Manual Name) for EDSADC_CH4_DICFG.
* To use register names with standard convension, please use EDSADC_CH4_DICFG.
*/
#define EDSADC_DICFG4 (EDSADC_CH4_DICFG)

/** \brief 510, Filter Configuration Register 4, Main */
#define EDSADC_CH4_FCFGM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGM*)0xF0024510u)
/** Alias (User Manual Name) for EDSADC_CH4_FCFGM.
* To use register names with standard convension, please use EDSADC_CH4_FCFGM.
*/
#define EDSADC_FCFGM4 (EDSADC_CH4_FCFGM)

/** \brief 514, Filter Configuration Register 4, CIC Filter */
#define EDSADC_CH4_FCFGC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGC*)0xF0024514u)
/** Alias (User Manual Name) for EDSADC_CH4_FCFGC.
* To use register names with standard convension, please use EDSADC_CH4_FCFGC.
*/
#define EDSADC_FCFGC4 (EDSADC_CH4_FCFGC)

/** \brief 518, Filter Counter Register 4, CIC Filter */
#define EDSADC_CH4_FCNTC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCNTC*)0xF0024518u)
/** Alias (User Manual Name) for EDSADC_CH4_FCNTC.
* To use register names with standard convension, please use EDSADC_CH4_FCNTC.
*/
#define EDSADC_FCNTC4 (EDSADC_CH4_FCNTC)

/** \brief 51C, Overshoot Compensation Cfg. Register 4 */
#define EDSADC_CH4_OVSCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_OVSCFG*)0xF002451Cu)
/** Alias (User Manual Name) for EDSADC_CH4_OVSCFG.
* To use register names with standard convension, please use EDSADC_CH4_OVSCFG.
*/
#define EDSADC_OVSCFG4 (EDSADC_CH4_OVSCFG)

/** \brief 520, Integration Window Control Register 4 */
#define EDSADC_CH4_IWCTR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_IWCTR*)0xF0024520u)
/** Alias (User Manual Name) for EDSADC_CH4_IWCTR.
* To use register names with standard convension, please use EDSADC_CH4_IWCTR.
*/
#define EDSADC_IWCTR4 (EDSADC_CH4_IWCTR)

/** \brief 524, Intermediate Integration Value */
#define EDSADC_CH4_IIVAL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_IIVAL*)0xF0024524u)
/** Alias (User Manual Name) for EDSADC_CH4_IIVAL.
* To use register names with standard convension, please use EDSADC_CH4_IIVAL.
*/
#define EDSADC_IIVAL4 (EDSADC_CH4_IIVAL)

/** \brief 528, Integrator Status Register 4 */
#define EDSADC_CH4_ISTAT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_ISTAT*)0xF0024528u)
/** Alias (User Manual Name) for EDSADC_CH4_ISTAT.
* To use register names with standard convension, please use EDSADC_CH4_ISTAT.
*/
#define EDSADC_ISTAT4 (EDSADC_CH4_ISTAT)

/** \brief 52C, Result FIFO Control Register 4 */
#define EDSADC_CH4_RFC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RFC*)0xF002452Cu)
/** Alias (User Manual Name) for EDSADC_CH4_RFC.
* To use register names with standard convension, please use EDSADC_CH4_RFC.
*/
#define EDSADC_RFC4 (EDSADC_CH4_RFC)

/** \brief 530, Result Register 4 Main */
#define EDSADC_CH4_RESM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RESM*)0xF0024530u)
/** Alias (User Manual Name) for EDSADC_CH4_RESM.
* To use register names with standard convension, please use EDSADC_CH4_RESM.
*/
#define EDSADC_RESM4 (EDSADC_CH4_RESM)

/** \brief 538, Offset Compensation Register 4 */
#define EDSADC_CH4_OFFCOMP /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_OFFCOMP*)0xF0024538u)
/** Alias (User Manual Name) for EDSADC_CH4_OFFCOMP.
* To use register names with standard convension, please use EDSADC_CH4_OFFCOMP.
*/
#define EDSADC_OFFCOMP4 (EDSADC_CH4_OFFCOMP)

/** \brief 53C, Gain Calibration Register 4 */
#define EDSADC_CH4_GAINCAL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCAL*)0xF002453Cu)
/** Alias (User Manual Name) for EDSADC_CH4_GAINCAL.
* To use register names with standard convension, please use EDSADC_CH4_GAINCAL.
*/
#define EDSADC_GAINCAL4 (EDSADC_CH4_GAINCAL)

/** \brief 540, Gain Control Register 4 */
#define EDSADC_CH4_GAINCTR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCTR*)0xF0024540u)
/** Alias (User Manual Name) for EDSADC_CH4_GAINCTR.
* To use register names with standard convension, please use EDSADC_CH4_GAINCTR.
*/
#define EDSADC_GAINCTR4 (EDSADC_CH4_GAINCTR)

/** \brief 544, Gain Correction Register 4 */
#define EDSADC_CH4_GAINCORR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCORR*)0xF0024544u)
/** Alias (User Manual Name) for EDSADC_CH4_GAINCORR.
* To use register names with standard convension, please use EDSADC_CH4_GAINCORR.
*/
#define EDSADC_GAINCORR4 (EDSADC_CH4_GAINCORR)

/** \brief 550, Time-Stamp Register 4 */
#define EDSADC_CH4_TSTMP /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_TSTMP*)0xF0024550u)
/** Alias (User Manual Name) for EDSADC_CH4_TSTMP.
* To use register names with standard convension, please use EDSADC_CH4_TSTMP.
*/
#define EDSADC_TSTMP4 (EDSADC_CH4_TSTMP)

/** \brief 554, Time-Stamp Counter 4 */
#define EDSADC_CH4_TSCNT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_TSCNT*)0xF0024554u)
/** Alias (User Manual Name) for EDSADC_CH4_TSCNT.
* To use register names with standard convension, please use EDSADC_CH4_TSCNT.
*/
#define EDSADC_TSCNT4 (EDSADC_CH4_TSCNT)

/** \brief 570, Auxiliary Filter Configuration Register 4 */
#define EDSADC_CH4_FCFGA /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGA*)0xF0024570u)
/** Alias (User Manual Name) for EDSADC_CH4_FCFGA.
* To use register names with standard convension, please use EDSADC_CH4_FCFGA.
*/
#define EDSADC_FCFGA4 (EDSADC_CH4_FCFGA)

/** \brief 578, Boundary Select Register 4 */
#define EDSADC_CH4_BOUNDSEL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_BOUNDSEL*)0xF0024578u)
/** Alias (User Manual Name) for EDSADC_CH4_BOUNDSEL.
* To use register names with standard convension, please use EDSADC_CH4_BOUNDSEL.
*/
#define EDSADC_BOUNDSEL4 (EDSADC_CH4_BOUNDSEL)

/** \brief 580, Result Register 4 Auxiliary */
#define EDSADC_CH4_RESA /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RESA*)0xF0024580u)
/** Alias (User Manual Name) for EDSADC_CH4_RESA.
* To use register names with standard convension, please use EDSADC_CH4_RESA.
*/
#define EDSADC_RESA4 (EDSADC_CH4_RESA)

/** \brief 5A0, Carrier Generator Synchronization Reg. 4 */
#define EDSADC_CH4_CGSYNC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_CGSYNC*)0xF00245A0u)
/** Alias (User Manual Name) for EDSADC_CH4_CGSYNC.
* To use register names with standard convension, please use EDSADC_CH4_CGSYNC.
*/
#define EDSADC_CGSYNC4 (EDSADC_CH4_CGSYNC)

/** \brief 5A8, Rectification Configuration Register 4 */
#define EDSADC_CH4_RECTCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RECTCFG*)0xF00245A8u)
/** Alias (User Manual Name) for EDSADC_CH4_RECTCFG.
* To use register names with standard convension, please use EDSADC_CH4_RECTCFG.
*/
#define EDSADC_RECTCFG4 (EDSADC_CH4_RECTCFG)

/** \brief 5B0, Common Mode Voltage Register 4 */
#define EDSADC_CH4_VCM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_VCM*)0xF00245B0u)
/** Alias (User Manual Name) for EDSADC_CH4_VCM.
* To use register names with standard convension, please use EDSADC_CH4_VCM.
*/
#define EDSADC_VCM4 (EDSADC_CH4_VCM)

/** \brief 600, Modulator Configuration Register 5 */
#define EDSADC_CH5_MODCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_MODCFG*)0xF0024600u)
/** Alias (User Manual Name) for EDSADC_CH5_MODCFG.
* To use register names with standard convension, please use EDSADC_CH5_MODCFG.
*/
#define EDSADC_MODCFG5 (EDSADC_CH5_MODCFG)

/** \brief 608, Demodulator Input Config. Register 5 */
#define EDSADC_CH5_DICFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_DICFG*)0xF0024608u)
/** Alias (User Manual Name) for EDSADC_CH5_DICFG.
* To use register names with standard convension, please use EDSADC_CH5_DICFG.
*/
#define EDSADC_DICFG5 (EDSADC_CH5_DICFG)

/** \brief 610, Filter Configuration Register 5, Main */
#define EDSADC_CH5_FCFGM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGM*)0xF0024610u)
/** Alias (User Manual Name) for EDSADC_CH5_FCFGM.
* To use register names with standard convension, please use EDSADC_CH5_FCFGM.
*/
#define EDSADC_FCFGM5 (EDSADC_CH5_FCFGM)

/** \brief 614, Filter Configuration Register 5, CIC Filter */
#define EDSADC_CH5_FCFGC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGC*)0xF0024614u)
/** Alias (User Manual Name) for EDSADC_CH5_FCFGC.
* To use register names with standard convension, please use EDSADC_CH5_FCFGC.
*/
#define EDSADC_FCFGC5 (EDSADC_CH5_FCFGC)

/** \brief 618, Filter Counter Register 5, CIC Filter */
#define EDSADC_CH5_FCNTC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCNTC*)0xF0024618u)
/** Alias (User Manual Name) for EDSADC_CH5_FCNTC.
* To use register names with standard convension, please use EDSADC_CH5_FCNTC.
*/
#define EDSADC_FCNTC5 (EDSADC_CH5_FCNTC)

/** \brief 61C, Overshoot Compensation Cfg. Register 5 */
#define EDSADC_CH5_OVSCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_OVSCFG*)0xF002461Cu)
/** Alias (User Manual Name) for EDSADC_CH5_OVSCFG.
* To use register names with standard convension, please use EDSADC_CH5_OVSCFG.
*/
#define EDSADC_OVSCFG5 (EDSADC_CH5_OVSCFG)

/** \brief 620, Integration Window Control Register 5 */
#define EDSADC_CH5_IWCTR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_IWCTR*)0xF0024620u)
/** Alias (User Manual Name) for EDSADC_CH5_IWCTR.
* To use register names with standard convension, please use EDSADC_CH5_IWCTR.
*/
#define EDSADC_IWCTR5 (EDSADC_CH5_IWCTR)

/** \brief 624, Intermediate Integration Value */
#define EDSADC_CH5_IIVAL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_IIVAL*)0xF0024624u)
/** Alias (User Manual Name) for EDSADC_CH5_IIVAL.
* To use register names with standard convension, please use EDSADC_CH5_IIVAL.
*/
#define EDSADC_IIVAL5 (EDSADC_CH5_IIVAL)

/** \brief 628, Integrator Status Register 5 */
#define EDSADC_CH5_ISTAT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_ISTAT*)0xF0024628u)
/** Alias (User Manual Name) for EDSADC_CH5_ISTAT.
* To use register names with standard convension, please use EDSADC_CH5_ISTAT.
*/
#define EDSADC_ISTAT5 (EDSADC_CH5_ISTAT)

/** \brief 62C, Result FIFO Control Register 5 */
#define EDSADC_CH5_RFC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RFC*)0xF002462Cu)
/** Alias (User Manual Name) for EDSADC_CH5_RFC.
* To use register names with standard convension, please use EDSADC_CH5_RFC.
*/
#define EDSADC_RFC5 (EDSADC_CH5_RFC)

/** \brief 630, Result Register 5 Main */
#define EDSADC_CH5_RESM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RESM*)0xF0024630u)
/** Alias (User Manual Name) for EDSADC_CH5_RESM.
* To use register names with standard convension, please use EDSADC_CH5_RESM.
*/
#define EDSADC_RESM5 (EDSADC_CH5_RESM)

/** \brief 638, Offset Compensation Register 5 */
#define EDSADC_CH5_OFFCOMP /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_OFFCOMP*)0xF0024638u)
/** Alias (User Manual Name) for EDSADC_CH5_OFFCOMP.
* To use register names with standard convension, please use EDSADC_CH5_OFFCOMP.
*/
#define EDSADC_OFFCOMP5 (EDSADC_CH5_OFFCOMP)

/** \brief 63C, Gain Calibration Register 5 */
#define EDSADC_CH5_GAINCAL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCAL*)0xF002463Cu)
/** Alias (User Manual Name) for EDSADC_CH5_GAINCAL.
* To use register names with standard convension, please use EDSADC_CH5_GAINCAL.
*/
#define EDSADC_GAINCAL5 (EDSADC_CH5_GAINCAL)

/** \brief 640, Gain Control Register 5 */
#define EDSADC_CH5_GAINCTR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCTR*)0xF0024640u)
/** Alias (User Manual Name) for EDSADC_CH5_GAINCTR.
* To use register names with standard convension, please use EDSADC_CH5_GAINCTR.
*/
#define EDSADC_GAINCTR5 (EDSADC_CH5_GAINCTR)

/** \brief 644, Gain Correction Register 5 */
#define EDSADC_CH5_GAINCORR /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_GAINCORR*)0xF0024644u)
/** Alias (User Manual Name) for EDSADC_CH5_GAINCORR.
* To use register names with standard convension, please use EDSADC_CH5_GAINCORR.
*/
#define EDSADC_GAINCORR5 (EDSADC_CH5_GAINCORR)

/** \brief 650, Time-Stamp Register 5 */
#define EDSADC_CH5_TSTMP /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_TSTMP*)0xF0024650u)
/** Alias (User Manual Name) for EDSADC_CH5_TSTMP.
* To use register names with standard convension, please use EDSADC_CH5_TSTMP.
*/
#define EDSADC_TSTMP5 (EDSADC_CH5_TSTMP)

/** \brief 654, Time-Stamp Counter 5 */
#define EDSADC_CH5_TSCNT /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_TSCNT*)0xF0024654u)
/** Alias (User Manual Name) for EDSADC_CH5_TSCNT.
* To use register names with standard convension, please use EDSADC_CH5_TSCNT.
*/
#define EDSADC_TSCNT5 (EDSADC_CH5_TSCNT)

/** \brief 670, Auxiliary Filter Configuration Register 5 */
#define EDSADC_CH5_FCFGA /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_FCFGA*)0xF0024670u)
/** Alias (User Manual Name) for EDSADC_CH5_FCFGA.
* To use register names with standard convension, please use EDSADC_CH5_FCFGA.
*/
#define EDSADC_FCFGA5 (EDSADC_CH5_FCFGA)

/** \brief 678, Boundary Select Register 5 */
#define EDSADC_CH5_BOUNDSEL /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_BOUNDSEL*)0xF0024678u)
/** Alias (User Manual Name) for EDSADC_CH5_BOUNDSEL.
* To use register names with standard convension, please use EDSADC_CH5_BOUNDSEL.
*/
#define EDSADC_BOUNDSEL5 (EDSADC_CH5_BOUNDSEL)

/** \brief 680, Result Register 5 Auxiliary */
#define EDSADC_CH5_RESA /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RESA*)0xF0024680u)
/** Alias (User Manual Name) for EDSADC_CH5_RESA.
* To use register names with standard convension, please use EDSADC_CH5_RESA.
*/
#define EDSADC_RESA5 (EDSADC_CH5_RESA)

/** \brief 6A0, Carrier Generator Synchronization Reg. 5 */
#define EDSADC_CH5_CGSYNC /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_CGSYNC*)0xF00246A0u)
/** Alias (User Manual Name) for EDSADC_CH5_CGSYNC.
* To use register names with standard convension, please use EDSADC_CH5_CGSYNC.
*/
#define EDSADC_CGSYNC5 (EDSADC_CH5_CGSYNC)

/** \brief 6A8, Rectification Configuration Register 5 */
#define EDSADC_CH5_RECTCFG /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_RECTCFG*)0xF00246A8u)
/** Alias (User Manual Name) for EDSADC_CH5_RECTCFG.
* To use register names with standard convension, please use EDSADC_CH5_RECTCFG.
*/
#define EDSADC_RECTCFG5 (EDSADC_CH5_RECTCFG)

/** \brief 6B0, Common Mode Voltage Register 5 */
#define EDSADC_CH5_VCM /*lint --e(923, 9078)*/ (*(volatile Ifx_EDSADC_CH_VCM*)0xF00246B0u)
/** Alias (User Manual Name) for EDSADC_CH5_VCM.
* To use register names with standard convension, please use EDSADC_CH5_VCM.
*/
#define EDSADC_VCM5 (EDSADC_CH5_VCM)


/** \}  */

/******************************************************************************/

/******************************************************************************/

#endif /* IFXEDSADC_REG_H */
