#include "wifi.h"
#include "image.h"
#include "control.h"
//WiFiʼ
void wifi_init(void)
{

    while(wifi_spi_init(WIFI_SSID_TEST, WIFI_PASSWORD_TEST))
    {
        printf("\r\n connect wifi failed. \r\n");
        system_delay_ms(100);                                                   // ʼʧ ȴ 100ms
    }

    printf("\r\n module version:%s",wifi_spi_version);                          // ģ̼汾
    printf("\r\n module mac    :%s",wifi_spi_mac_addr);                         // ģ MAC Ϣ
    printf("\r\n module ip     :%s",wifi_spi_ip_addr_port);                     // ģ IP ַ

}
//λTCP
void TCP_client_init(void)
{
    // zf_device_wifi_spi.h ļڵĺ궨Ըģ() WIFI ֮ǷԶ TCP  UDP 
    if(0 == WIFI_SPI_AUTO_CONNECT)                                              // ûпԶ ҪֶĿ IP
    {
        while(wifi_spi_socket_connect(                                          // ָĿ IP Ķ˿ڽ TCP 
            "TCP",                                                              // ָʹTCPʽͨѶ
            WIFI_SPI_TARGET_IP,                                                 // ָԶ˵IPַдλIPַ
            WIFI_SPI_TARGET_PORT,                                               // ָԶ˵Ķ˿ںţдλĶ˿ںţͨλĬ8080
            WIFI_SPI_LOCAL_PORT))                                               // ָĶ˿ں
        {
            // һֱʧ һǲûнӲλ
            printf("\r\n Connect TCP Servers error, try again.");
            system_delay_ms(100);                                               // ʧ ȴ 100ms
        }
    }
}
//λTCP
void TCP_seekfree_init(void)
{
    // zf_device_wifi_spi.h ļڵĺ궨Ըģ() WIFI ֮ǷԶ TCP  UDP 
        if(1 != WIFI_SPI_AUTO_CONNECT)                                              // ûпԶ ҪֶĿ IP
        {
            while(wifi_spi_socket_connect(                                          // ָĿ IP Ķ˿ڽ TCP 
                "TCP",                                                              // ָʹTCPʽͨѶ
                WIFI_TARGET_IP,                                                 // ָԶ˵IPַдλIPַ
                WIFI_TARGET_PORT,                                               // ָԶ˵Ķ˿ںţдλĶ˿ںţͨλĬ8080
                WIFI_LOCAL_PORT))                                               // ָĶ˿ں
            {
                // һֱʧ һǲûнӲλ
                printf("\r\n Connect TCP Servers error, try again.");
                system_delay_ms(100);                                               // ʧ ȴ 100ms
            }
        }
}

//wifiڷ
void wifi_send_int(int a)
{
    int len;
    uint8 wifi_data_buffer[256];
    len = snprintf((char*)wifi_data_buffer, sizeof(wifi_data_buffer),"%d",a);
    wifi_spi_send_buffer(wifi_data_buffer, sizeof(wifi_data_buffer));
}

//wifiڷ͸
void wifi_send_float(float a)
{
    int len;
    uint8 wifi_data_buffer[256];
    len = snprintf((char*)wifi_data_buffer, sizeof(wifi_data_buffer),"%f",a);
    wifi_spi_send_buffer(wifi_data_buffer, sizeof(wifi_data_buffer));
}

//wifiڷַ
void wifi_send_char(char a[])
{
    uint8 *wifi_data_buffer = (uint8 *)a;
    wifi_spi_send_buffer(wifi_data_buffer, sizeof(wifi_data_buffer));
}

//wifiڽ
void wifi_get(uint8 wifi_spi_get_data_buffer[])
{
    wifi_spi_read_buffer(wifi_spi_get_data_buffer, sizeof(wifi_spi_get_data_buffer));
}

// ֳʼ
void seekfree_init(void)
{
    // ֳʼ ݴʹøWIFI SPI
   seekfree_assistant_interface_init(SEEKFREE_ASSISTANT_WIFI_SPI);

   // ҪͼϢصseekfree_assistant_camera_information_configбҪĲ
   // Ҫͱseekfree_assistant_camera_boundary_configñߵϢ
}

//ֲ
void seekfree_oscilloscope_send(void)
{
    // дҪ͵ݣмͨдٸ
    // д4ͨ
    seekfree_assistant_oscilloscope_data.data[0] = imu963ra_gyro_z;
    seekfree_assistant_oscilloscope_data.data[1] = target_velocity;
    seekfree_assistant_oscilloscope_data.data[2] = Turn_Pwm;
    seekfree_assistant_oscilloscope_data.data[3] = 2;
//        detector_oscilloscope_data.data[4] = 10;
//        detector_oscilloscope_data.data[5] = 100;
//        detector_oscilloscope_data.data[6] = 1000;
//        detector_oscilloscope_data.data[7] = 10000;

    // ñҪͼͨ
    seekfree_assistant_oscilloscope_data.channel_num = 4;

    // 4ͨݣ֧8ͨ
    seekfree_assistant_oscilloscope_send(&seekfree_assistant_oscilloscope_data);

    system_delay_ms(20);
    // пܻϿθ²ΪʹWIFIвȷӳٵµ

    // λ͹Ĳݻseekfree_assistant_oscilloscope_dataУͨߵԵķʽ鿴
    // Ϊ˷дѭʵʹƼŵжϵλãҪȷܹʱıãڲ20ms
    seekfree_assistant_data_analysis();

}


//ͷͼ
void seekfree_camera_send(void)
{
    seekfree_assistant_camera_information_config(SEEKFREE_ASSISTANT_MT9V03X, bin_image[0], MT9V03X_W, MT9V03X_H);
    seekfree_assistant_camera_boundary_config(X_BOUNDARY, MT9V03X_H, x1_boundary, x2_boundary, x3_boundary, NULL, NULL ,NULL);
    // ͼ
    seekfree_assistant_camera_send();
     // ʹUDPЭ鴫Ƽȫ͵ģ֮wifi_spi_udp_send_now()Ը֪ģյݷ͵
     // ûģڳ2δյݺ󣬽ݷ͵
     // wifi_spi_udp_send_now()ǰģ鲻Ҫ40960ֽ
     // wifi_spi_udp_send_now();
}
