#include "small_driver_uart_control.h"

small_device_value_struct motor_value;      // ͨѶṹ


//-------------------------------------------------------------------------------------------------------------------
//      ˢ ڽջص
// ˵     void
// ز     void
// ʹʾ     uart_control_callback(1000, -1000);
// עϢ     ڽյٶ  úҪڶӦĴڽже
//-------------------------------------------------------------------------------------------------------------------
void uart_control_callback(void)
{
    uint8 receive_data;                                                                     // ʱ

    if(uart_query_byte(SMALL_DRIVER_UART, &receive_data))                                   // մ
    {
        if(receive_data == 0xA5 && motor_value.receive_data_buffer[0] != 0xA5)              // жǷյ֡ͷ  ǰǷȷ֡ͷ
        {
            motor_value.receive_data_count = 0;                                             // δյ֡ͷδȷ֡ͷ½
        }

        motor_value.receive_data_buffer[motor_value.receive_data_count ++] = receive_data;  // 洮

        if(motor_value.receive_data_count >= 7)                                             // жǷյָ
        {
            if(motor_value.receive_data_buffer[0] == 0xA5)                                  // ж֡ͷǷȷ
            {

                motor_value.sum_check_data = 0;                                             // Уλ

                for(int i = 0; i < 6; i ++)
                {
                    motor_value.sum_check_data += motor_value.receive_data_buffer[i];       // ¼Уλ
                }

                if(motor_value.sum_check_data == motor_value.receive_data_buffer[6])        // У׼ȷ
                {

                    if(motor_value.receive_data_buffer[1] == 0x02)                          // жǷȷյ ٶ 
                    {
                        motor_value.receive_left_speed_data  = (((int)motor_value.receive_data_buffer[2] << 8) | (int)motor_value.receive_data_buffer[3]);  // ת

                        motor_value.receive_right_speed_data = (((int)motor_value.receive_data_buffer[4] << 8) | (int)motor_value.receive_data_buffer[5]);  // Ҳת
                    }

                    motor_value.receive_data_count = 0;                                     // ֵ

                    memset(motor_value.receive_data_buffer, 0, 7);                          // 
                }
                else
                {
                    motor_value.receive_data_count = 0;                                     // ֵ

                    memset(motor_value.receive_data_buffer, 0, 7);                          // 
                }
            }
            else
            {
                motor_value.receive_data_count = 0;                                         // ֵ

                memset(motor_value.receive_data_buffer, 0, 7);                              // 
            }
        }
    }
}

//-------------------------------------------------------------------------------------------------------------------
//      ˢ õռձ
// ˵     left_duty       ռձ  Χ -10000 ~ 10000  Ϊת
// ˵     right_duty      Ҳռձ  Χ -10000 ~ 10000  Ϊת
// ز     void
// ʹʾ     small_driver_set_duty(1000, -1000);
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void small_driver_set_duty(int16 left_duty, int16 right_duty)
{
    motor_value.send_data_buffer[0] = 0xA5;                                         // ֡ͷ

    motor_value.send_data_buffer[1] = 0X01;                                         // ù

    motor_value.send_data_buffer[2] = (uint8)((left_duty & 0xFF00) >> 8);           //  ռձ ĸ߰λ

    motor_value.send_data_buffer[3] = (uint8)(left_duty & 0x00FF);                  //  ռձ ĵͰλ

    motor_value.send_data_buffer[4] = (uint8)((right_duty & 0xFF00) >> 8);          //  Ҳռձ ĸ߰λ

    motor_value.send_data_buffer[5] = (uint8)(right_duty & 0x00FF);                 //  Ҳռձ ĵͰλ

    motor_value.send_data_buffer[6] = 0;                                            // У

    for(int i = 0; i < 6; i ++)
    {
        motor_value.send_data_buffer[6] += motor_value.send_data_buffer[i];         // Уλ
    }

    uart_write_buffer(SMALL_DRIVER_UART, motor_value.send_data_buffer, 7);                     // ռձȵ ֽڰ 
}

//-------------------------------------------------------------------------------------------------------------------
//      ˢ ȡٶϢ
// ˵     void
// ز     void
// ʹʾ     small_driver_get_speed();
// עϢ     跢һ ڷٶϢ(Ĭ10ms)
//-------------------------------------------------------------------------------------------------------------------
void small_driver_get_speed(void)
{
    motor_value.send_data_buffer[0] = 0xA5;                                         // ֡ͷ

    motor_value.send_data_buffer[1] = 0X02;                                         // ù

    motor_value.send_data_buffer[2] = 0x00;                                         // λ

    motor_value.send_data_buffer[3] = 0x00;                                         // λ

    motor_value.send_data_buffer[4] = 0x00;                                         // λ

    motor_value.send_data_buffer[5] = 0x00;                                         // λ

    motor_value.send_data_buffer[6] = 0xA7;                                         // Уλ

    uart_write_buffer(SMALL_DRIVER_UART, motor_value.send_data_buffer, 7);                     // ͻȡתݵ ֽڰ 
}


//-------------------------------------------------------------------------------------------------------------------
//      ˢ ʼ
// ˵     void
// ز     void
// ʹʾ     small_driver_init();
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void small_driver_init(void)
{
    memset(motor_value.send_data_buffer, 0, 7);                             // 

    memset(motor_value.receive_data_buffer, 0, 7);                          // 

    motor_value.receive_data_count          = 0;

    motor_value.sum_check_data              = 0;

    motor_value.receive_right_speed_data    = 0;

    motor_value.receive_left_speed_data     = 0;
}


//-------------------------------------------------------------------------------------------------------------------
//      ˢ ͨѶʼ
// ˵     void
// ز     void
// ʹʾ     small_driver_uart_init();
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void small_driver_uart_init(void)
{
    uart_init(SMALL_DRIVER_UART, SMALL_DRIVER_BAUDRATE, SMALL_DRIVER_RX, SMALL_DRIVER_TX);      // ڳʼ

    uart_rx_interrupt(SMALL_DRIVER_UART, 1);                                                    // ʹܴڽж

    small_driver_init();                                                                        // ṹʼ

    small_driver_set_duty(0, 0);                                                                // 0ռձ

    small_driver_get_speed();                                                                   // ȡʵʱٶ
}














