#include "zf_common_headfile.h"
#include "pid.h"

/*************************************************************************
 *  ƣfloat constrain_float(float amt, float low, float high)
 *  ˵޷
 *  ˵
  * @param    amt    
  * @param    low    ֵ
  * @param    high   ֵ
 *  أ
 *  ޸ʱ䣺202041
 *      ע
 *************************************************************************/
float constrain_float(float amt, float low, float high)
{
    return ((amt)<(low)?(low):((amt)>(high)?(high):(amt)));//ССֵСֵֵֵ
}

// pidʼ
void PidInit(pid_param_t * pid)//ʼ
{
    pid->kp        = 0;
    pid->ki        = 0;
    pid->kd        = 0;
    pid->imax      = 0;
    pid->out_p     = 0;
    pid->out_i     = 0;
    pid->out_d     = 0;
    pid->out       = 0;
    pid->integrator= 0;
    pid->last_error= 0;
    pid->last_derivative   = 0;
    pid->last_t    = 0;
}

//PID
void PidChange(pid_param_t * pid, float p, float i,float d)//PID
{
    pid->kp        = p;
    pid->ki        = i;
    pid->kd        = d;

}

/*************************************************************************
 *  ƣfloat PidLocCtrl(pid_param_t * pid, float error)
 *  ˵pidλʽ
 *  ˵
  * @param    pid     pid
  * @param    error   pid
 *  أPID
 *  ޸ʱ䣺202041
 *      ע
 *************************************************************************/
float PidLocCtrl(pid_param_t * pid, float error)
{
    /* ۻ */
    pid->integrator += error;

    /* ޷ */
    constrain_float(pid->integrator, -pid->imax, pid->imax);


    pid->out_p = pid->kp * error;
    pid->out_i = pid->ki * pid->integrator;
    pid->out_d = pid->kd * (error - pid->last_error);

    pid->last_error = error;

    pid->out = pid->out_p + pid->out_i + pid->out_d;

    return pid->out;
}
/*************************************************************************
 *  ƣfloat PidIncCtrl(pid_param_t * pid, float error)
 *  ˵pidʽ
 *  ˵
  * @param    pid     pid
  * @param    error   pid
 *  أPID   עѾϴν
 *  ޸ʱ䣺202041
 *      ע
 *************************************************************************/
float PidIncCtrl(pid_param_t * pid, float error)
{


    pid->out_p = pid->kp * (error - pid->last_error);
    pid->out_i = pid->ki * error;
    pid->out_d = pid->kd * ((error - 2.0f*(pid->last_error)) + pid->last_derivative);

    pid->last_derivative = error - pid->last_error;
    pid->last_error = error;

    pid->out += pid->out_p + pid->out_i + pid->out_d;

    return pid->out;
}
/*ŵ㣺
λʽPIDһַǵʽ㷨ֱӿִлƽСu(k)ִֵлʵλãСǰǶȣһһӦģִлֲĶпԺܺӦ

ȱ㣺
ÿȥ״̬йأʱҪe(k)ۼӣ㹤

ʽPIDȱ㣺
ŵ㣺
ʱӰСҪʱ߼жϵķȥݡ
ֶ/ԶлʱСʵŶлʱܱԭֵ
ʽвҪۼӡu(k)ȷ3εĲֵйء


ȱ㣺
ٻֽضЧӦ̬

Ӱеıضʽ̫ã

*/




