#include "jump_control.h"
#include "engine.h"
#include "control.h"
#include "FiveBarLinkageData.h"
#include "image.h"
extern IMU_t IMU_data;
int jump_stop = 0;
JumpState jump_state = JUMP_FREE;

// ԾеĿλ
#define PREPARE_X 0.00  // мλ
#define PREPARE_Y 0.03

#define BURST_X 0.00   // мλ
#define BURST_Y 0.14

#define AIR_RETRACT_X 0.00  // мλ
#define AIR_RETRACT_Y 0.03

#define PRE_BUFFER_X 0.00  // ǰλ
#define PRE_BUFFER_Y 0.05

#define EXE_BUFFER_X -0.01  // ǰ
#define EXE_BUFFER_Y 0.05

#define RECOVER_X 0.00  // ָмλ
#define RECOVER_Y 0.04

// Ծƺ
void jump_process_control(float *current_x, float *current_y) {
    int leg1, leg2;
    switch (jump_state) {
        case JUMP_PREPARE:
            // ׼׶Σʼλ
            jump_stop = 0;
            if ( *current_y!= PREPARE_Y) {
                *current_y = PREPARE_Y;
                servo_control(*current_x, *current_y, &leg1, &leg2);//Ƶǰx䣬Ծy
                engine_maintain(leg1, leg2);
                system_delay_ms(50);
                jump_state = JUMP_BURST;
            } else {
                // ׼׶ɣ뱬׶
                jump_state = JUMP_BURST;
            }

        case JUMP_BURST:
            // ׶Σչ
            //*current_x = BURST_X;
           // *current_y = BURST_Y;
            //servo_control(*current_x, *current_y, &leg1, &leg2);
            engine_maintain(1050, 1050);
            jump_state = JUMP_EXE_BUFFER;
            system_delay_ms(130);

//        case JUMP_AIR_RETRACT:
//            // ׶
//            *current_x = AIR_RETRACT_X;
//            *current_y = AIR_RETRACT_Y;
//            servo_control(*current_x, *current_y, &leg1, &leg2);
//            engine_maintain(leg1, leg2);
//            jump_state = JUMP_PRE_BUFFER;
//            system_delay_ms(80);


//        case JUMP_PRE_BUFFER:
//            // ׼׶Σǰ
//            *current_x = PRE_BUFFER_X;
//            *current_y = PRE_BUFFER_Y;
//            servo_control(*current_x, *current_y, &leg1, &leg2);
//            engine_maintain(leg1, leg2);
//            system_delay_ms(50);
//

        case JUMP_EXE_BUFFER://״̬
            // ִн׶Σһǰ
            jump_stop = 1;
            *current_x = EXE_BUFFER_X;
            *current_y = EXE_BUFFER_Y;
            servo_control(*current_x, *current_y, &leg1, &leg2);
            engine_maintain(leg1, leg2);
            while(IMU_data.accel[2] < 3.0f) //жϽٶ,ײٶ
            { // ⵽Ӵ
            }
            jump_state = JUMP_RECOVER;
        case JUMP_RECOVER:
            // ָ׶Σصмλ
            jump_stop = 0;
            *current_x = RECOVER_X;
            *current_y = RECOVER_Y;
            servo_control(*current_x, *current_y, &leg1, &leg2);
            engine_maintain(leg1, leg2);
            jump_position = 0;
            system_delay_ms(200);
            jump_state = JUMP_FREE;

        case JUMP_FREE:

            break;

            // ״̬

    }
}

// Ծֹ
void jump_abort(void) {
    engine_maintain(600, 600);  // ŷΪмλ
    jump_state = JUMP_PREPARE;  // Ծ״̬Ϊ׼״̬
}
