/*********************************************************************************************************************
* TC364 Opensourec Library TC364 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC364 Դһ
*
* TC364 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_driver_dma
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC364DP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-02       pudding            first version
********************************************************************************************************************/

#include "IfxDma_Dma.h"
#include "IfxScuEru.h"
#include "isr_config.h"
#include "zf_common_debug.h"
#include "zf_driver_dma.h"

typedef struct
{
    Ifx_DMA_CH linked_list[10];              // DMA
    IfxDma_Dma_Channel channel;             // DMAͨ
}DMA_LINK;

#if(0 == DMA_INT_SERVICE)
#pragma section all "cpu0_dsram"
IFX_ALIGN(256) DMA_LINK dma_link_list;

#elif(1 == DMA_INT_SERVICE)
#pragma section all "cpu1_dsram"
IFX_ALIGN(256) DMA_LINK dma_link_list;

#endif
#pragma section all restore
//-------------------------------------------------------------------------------------------------------------------
//       dmaʼ
// ˵      dma_ch              ѡDMAͨ
// ˵      source_addr         Դַ
// ˵      destination_addr    Ŀĵַ
// ˵      exti_pin            ôeruͨ
// ˵      trigger             ôʽ
// ˵      dma_count           dmaƴ
// ز      uint8
// ʹʾ      dma_init(MT9V03X_DMA_CH, MT9V03X_DATA_ADD, mt9v03x_image[0], MT9V03X_PCLK_PIN, EXTI_TRIGGER_RISING, MT9V03X_IMAGE_SIZE);
// עϢ
//-------------------------------------------------------------------------------------------------------------------
uint8 dma_init (IfxDma_ChannelId dma_ch, uint8 *source_addr, uint8 *destination_addr, exti_pin_enum exti_pin, exti_trigger_enum trigger, uint32 dma_count)
{
    IfxDma_Dma_Channel dmaChn;

    exti_init(exti_pin, trigger);               // eruDMAͨ   eruļeruȼΪͨ

    IfxDma_Dma_Config        dmaConfig;
    IfxDma_Dma_initModuleConfig(&dmaConfig, &MODULE_DMA);

    IfxDma_Dma               dma;
    IfxDma_Dma_initModule(&dma, &dmaConfig);

    IfxDma_Dma_ChannelConfig cfg;
    IfxDma_Dma_initChannelConfig(&cfg, &dma);

    uint8  list_num, i;
    uint32 single_channel_dma_count;

    zf_assert(!(dma_count%8));                  // Ϊ8ı


    list_num = 1;
    single_channel_dma_count = dma_count / list_num;
    if(16384 < single_channel_dma_count)
    {
        while(TRUE)
        {
            single_channel_dma_count = dma_count / list_num;
            if((single_channel_dma_count <= 16384) && !(dma_count % list_num))
            {
                break;
            }
            list_num++;
            if(list_num > 10)
            {
                zf_assert(FALSE);
            }
        }
    }


    if(1 == list_num)
    {
        cfg.shadowControl               = IfxDma_ChannelShadow_none;
        cfg.operationMode               = IfxDma_ChannelOperationMode_single;
        cfg.shadowAddress               = 0;
    }
    else
    {
        cfg.shadowControl               = IfxDma_ChannelShadow_linkedList;
        cfg.operationMode               = IfxDma_ChannelOperationMode_continuous;
        cfg.shadowAddress               = IFXCPU_GLB_ADDR_DSPR(IfxCpu_getCoreId(), (unsigned)&dma_link_list.linked_list[1]);
    }

    cfg.requestMode                     = IfxDma_ChannelRequestMode_oneTransferPerRequest;
    cfg.moveSize                        = IfxDma_ChannelMoveSize_8bit;
    cfg.busPriority                     = IfxDma_ChannelBusPriority_high;

    cfg.sourceAddress                   = IFXCPU_GLB_ADDR_DSPR(IfxCpu_getCoreId(), source_addr);
    cfg.sourceAddressCircularRange      = IfxDma_ChannelIncrementCircular_none;
    cfg.sourceCircularBufferEnabled     = TRUE;

    cfg.destinationAddressIncrementStep = IfxDma_ChannelIncrementStep_1;

    cfg.channelId                       = (IfxDma_ChannelId)dma_ch;
    cfg.hardwareRequestEnabled          = FALSE;
    cfg.channelInterruptEnabled         = TRUE;
    cfg.channelInterruptPriority        = DMA_INT_PRIO;
    cfg.channelInterruptTypeOfService   = DMA_INT_SERVICE;



    cfg.destinationAddress              = IFXCPU_GLB_ADDR_DSPR(IfxCpu_getCoreId(), destination_addr);

    cfg.transferCount                   = (uint16)single_channel_dma_count;

    IfxDma_Dma_initChannel(&dmaChn, &cfg);

    if(1 < list_num)
    {
        i = 0;
        while(i < list_num)
        {
            cfg.destinationAddress      = IFXCPU_GLB_ADDR_DSPR(IfxCpu_getCoreId(), destination_addr + single_channel_dma_count * i);
            if(i == (list_num - 1))
            {
                cfg.shadowAddress       = IFXCPU_GLB_ADDR_DSPR(IfxCpu_getCoreId(), (uint32)&dma_link_list.linked_list[0]);
            }
            else
            {
                cfg.shadowAddress       = IFXCPU_GLB_ADDR_DSPR(IfxCpu_getCoreId(), (uint32)&dma_link_list.linked_list[i+1]);
            }
            cfg.transferCount           = (uint16)single_channel_dma_count;

            IfxDma_Dma_initLinkedListEntry((void *)&dma_link_list.linked_list[i], &cfg);
            i++;
        }
    }

    IfxDma_Dma_getSrcPointer(&dma_link_list.channel)->B.CLRR = 1;

    return list_num;
}


//-------------------------------------------------------------------------------------------------------------------
//      dma ֹ
// ˵     ch              ѡ dma ͨ ( zf_driver_dma.h ö dma_channel_enum )
// ز     void
// ʹʾ     dma_disable(MT9V03X_DMA_CH);
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void dma_disable (IfxDma_ChannelId dma_ch)
{
    IfxDma_disableChannelTransaction(&MODULE_DMA, dma_ch);
}


//-------------------------------------------------------------------------------------------------------------------
//      dma ʹ
// ˵     ch              ѡ dma ͨ ( zf_driver_dma.h ö dma_channel_enum )
// ز     void
// ʹʾ     dma_enable(MT9V03X_DMA_CH);
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void dma_enable (IfxDma_ChannelId dma_ch)
{
    IfxDma_enableChannelTransaction(&MODULE_DMA, dma_ch);
}
