/*********************************************************************************************************************
* TC364 Opensourec Library TC364 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC364 Դһ
*
* TC364 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_wifi_spi
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC364DP
*           https://seekfree.taobao.com/
* 
* ޸ļ¼
*                               ע
* 2024-01-18        SeekFree            first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   RST                 鿴 zf_device_wifi_spi.h  WIFI_SPI_RST_PIN 궨
*                   INT                 鿴 zf_device_wifi_spi.h  WIFI_SPI_INT_PIN 궨
*                   CS                  鿴 zf_device_wifi_spi.h  WIFI_SPI_CS_PIN 궨
*                   MISO                鿴 zf_device_wifi_spi.h  WIFI_SPI_MISO_PIN 궨
*                   SCK                 鿴 zf_device_wifi_spi.h  WIFI_SPI_SCK_PIN 궨
*                   MOSI                鿴 zf_device_wifi_spi.h  WIFI_SPI_MOSI_PIN 궨
*                   5V                  5V Դ
*                   GND                 Դ
*                   
*                   ------------------------------------
*********************************************************************************************************************/

#ifndef _zf_device_wifi_spi_h
#define _zf_device_wifi_spi_h

#include "zf_common_typedef.h"

          
#define WIFI_SPI_INDEX              (SPI_3             )        // ʹõSPI
#define WIFI_SPI_SPEED              (30 * 1000 * 1000  )        // Ӳ SPI 
#define WIFI_SPI_SCK_PIN            (SPI3_SCLK_P22_3   )        // SPI_SCK
#define WIFI_SPI_MOSI_PIN           (SPI3_MOSI_P22_0   )        // SPI_MOSI
#define WIFI_SPI_MISO_PIN           (SPI3_MISO_P22_1   )        // SPI_MISO  IPSûMISOţȻҪ壬spiĳʼʱҪʹ
#define WIFI_SPI_CS_PIN             (P22_2             )        // SPI_CS CS
#define WIFI_SPI_INT_PIN            (P15_8             )        // 
#define WIFI_SPI_RST_PIN            (P23_1             )        // 帴λ


#define WIFI_SPI_RECVIVE_FIFO_SIZE  (1024)                      // FIFOС
#define WIFI_SPI_READ_TRANSFER      (1)                         // ڵwifi_spi_read_buffer ǷԷSPIͨѶģǷҪȡ 1SPIͨѶ 0SPIͨѶȡFIFO
                                                                // Ӧóûκεĵط÷ͺWIFI_SPI_READ_TRANSFERΪ1
                                                                
#define WIFI_SPI_AUTO_CONNECT       (0)                         // ǷʼʱTCPUDP    0-Զ  1-ԶTCP  2-ԶUDP

#if     (WIFI_SPI_AUTO_CONNECT > 2)    
#error "WIFI_SPI_AUTO_CONNECT ֵֻΪ [0,1,2]"
#else   
#define WIFI_SPI_TARGET_IP          "192.168.137.1"              // Ŀ IP
#define WIFI_SPI_TARGET_PORT        "8086"                      // ĿĶ˿
#define WIFI_SPI_LOCAL_PORT         "6666"                      // Ķ˿ 0  ÷Χ2048-65535  Ĭ 6666
#endif


#define WIFI_SPI_RECVIVE_SIZE       (32)                        // ÿSPIյֽ ޸
#define WIFI_SPI_TRANSFER_SIZE      (4088)                      // SPIյֽ ޸



typedef enum
{
    // ͵
    WIFI_SPI_INVALID1               = 0x00,                     // Чݰ
    WIFI_SPI_RESET                  = 0x01,                     // λ
    WIFI_SPI_DATA                   = 0x02,                     // ͸ݰ
    WIFI_SPI_UDP_SEND               = 0x03,                     // UDP,ĬSPIݺ2MSδյԶ
    WIFI_SPI_CLOSE_SOCKET           = 0x04,                     // Ͽ
                
    WIFI_SPI_SET_WIFI_INFORMATION   = 0x10,                     // WIFIϢ
    WIFI_SPI_SET_SOCKET_INFORMATION = 0x11,                     // SOCKETϢ
                    
    WIFI_SPI_GET_VERSION            = 0x20,                     // ȡģ汾
    WIFI_SPI_GET_MAC_ADDR           = 0x21,                     // ȡģMACַ
    WIFI_SPI_GET_IP_ADDR            = 0x22,                     // ȡģIPַ
                    
    // ӻش
    WIFI_SPI_REPLY_OK               = 0x80,                     // ӻӦȷ
    WIFI_SPI_REPLY_ERROR            = 0x81,                     // ӻӦĴ
                    
    WIFI_SPI_REPLY_DATA_START       = 0x90,                     // ӻشݰһҪȡ
    WIFI_SPI_REPLY_DATA_END         = 0x91,                     // ӻشݰѶȡ
                    
    WIFI_SPI_REPLY_VERSION          = 0xA0,                     // ӻظ̼汾
    WIFI_SPI_REPLY_MAC_ADDR         = 0xA1,                     // ӻظMACַϢ
    WIFI_SPI_REPLY_IP_ADDR          = 0xA2,                     // ӻظIPַ˿ں
    WIFI_SPI_INVALID2               = 0xFF                      // Чݰ
}wifi_spi_packets_command_enum;             
                
typedef enum                
{               
    WIFI_SPI_IDLE,                                              // ģУԽSPIͨѶ
    WIFI_SPI_BUSY,                                              // ģæɽSPIͨѶ
}wifi_spi_state_enum;               
                
                
typedef struct              
{               
    uint8   command;                                            // 
    uint8   reserve;                                            // 
    uint16  length;                                             // Ч
}wifi_spi_head_struct;              
                
                
typedef struct              
{               
    wifi_spi_head_struct  head;                                 // ֡ͷ
    uint8 buffer[WIFI_SPI_RECVIVE_SIZE];                        // 
}wifi_spi_packets_struct;               
                
                
extern char wifi_spi_version[12];                               // ̼汾         ַ
extern char wifi_spi_mac_addr[20];                              // ģMACַ      ַ
extern char wifi_spi_ip_addr_port[25];                          // IPַ˿ں   ַ

uint8  wifi_spi_wifi_connect        (char *wifi_ssid, char *pass_word);
uint8  wifi_spi_socket_connect      (char *transport_type, char *ip_addr, char *port, char *local_port);
uint8  wifi_spi_socket_disconnect   (void);
uint8  wifi_spi_udp_send_now        (void);
uint32 wifi_spi_send_buffer         (const uint8 *buff, uint32 length);
uint32 wifi_spi_read_buffer         (uint8 *buffer, uint32 length);

uint8  wifi_spi_init                (char *wifi_ssid, char *pass_word);

#endif

