/*********************************************************************************************************************
* TC364 Opensourec Library TC364 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC364 Դһ
*
* TC364 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_uart_receiver
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC364DP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-04       JKS                first version
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                   ------------------------------------
*                   ģܽ            Ƭܽ
*                   TXD               鿴 zf_device_uart_receiver.h  UART_RECEVIER_RX_PIN 궨
*                   GND               Դ
*                   5V                5VԴ
*                   ------------------------------------
********************************************************************************************************************/

#include "zf_device_type.h"
#include "zf_driver_uart.h"
#include "zf_driver_timer.h"
#include "zf_device_uart_receiver.h"

uart_receiver_struct    uart_receiver ;             // ڽջͨ״̬

uint8   uart_receiver_data[REV_DATA_LEN]  = {0};    // ԭʼ

//-------------------------------------------------------------------------------------------------------------------
//       ȡεuart_receiver_interval_timeʱ
//  ˵     void
//  ز     uint32            شӿʼڵʱ(λ1us)
//  ʹʾ     uint32 time = uart_receiver_interval_time();
//  עϢ     ڲ
//-------------------------------------------------------------------------------------------------------------------
static uint32 uart_receiver_interval_time (void)
{
    static uint32 time_last = 0;
    uint32 time, interval_time;
    uint32 stm_clk;

    stm_clk = IfxStm_getFrequency(IfxStm_getAddress((IfxStm_Index)(IfxCpu_getCoreId())));

    time = IfxStm_getLower(IfxStm_getAddress((IfxStm_Index)(IfxCpu_getCoreId())));
    interval_time = time - time_last;
    time_last = time;
    interval_time = (uint32)((uint64)interval_time * 1000000 / stm_clk);

    return interval_time;
}

//-------------------------------------------------------------------------------------------------------------------
//      SBUSݽ
// ˵     *remote_data    ңݵĵַ
// ˵     *bufer          ԭʼ
// ز     void
// ʹʾ
// עϢ     sbusݽн
//-------------------------------------------------------------------------------------------------------------------
static void uart_receiver_analysis (uart_receiver_struct *remote_data,uint8 * buffer)
{
    uint8 num = 0;
    remote_data->channel[num++] = (buffer[1] |buffer[ 2] << 8 ) & 0x07FF;
    remote_data->channel[num++] = (buffer[2] >> 3 | buffer[3] << 5 ) & 0x07FF;
    remote_data->channel[num++] = (buffer[3] >> 6 | buffer[4] << 2 | buffer[5] << 10 ) & 0x07FF;
    remote_data->channel[num++] = (buffer[5] >> 1 | buffer[6] << 7 ) & 0x07FF;
    remote_data->channel[num++] = (buffer[6] >> 4 | buffer[7] << 4 ) & 0x07FF;
    remote_data->channel[num++] = (buffer[7] >> 7 | buffer[8] << 1 | buffer[9] << 9 ) & 0x07FF;
    remote_data->state = (SBUS_NORMAL_STATE == buffer[23]) ? 1 : 0;
    uart_receiver.finsh_flag  = 1;
}

//-------------------------------------------------------------------------------------------------------------------
//      ڽջģ жϻص
// ˵     void
// ز     void
// ʹʾ     uart_receiver_callback();
// עϢ     ú ISR ļ жϳͨuart_receiver_uart_handlerָ뱻
//-------------------------------------------------------------------------------------------------------------------
void uart_receiver_callback(void)
{
    static vuint8 length = 0;

    if (uart_receiver_interval_time() > 3000)
    {
        length = 0;
    }
    uart_receiver_data[length++] = uart_read_byte(UART_RECEVIER_UART_INDEX);
    if  ( (REV_DATA_LEN  == length)                                                                    // ֡֡ͷ֡βЭ
        && (FRAME_STAR   == uart_receiver_data[0])
        && (FRAME_END    == uart_receiver_data[24]))
    {
        uart_receiver_analysis(&uart_receiver, uart_receiver_data);
    }
}

//-------------------------------------------------------------------------------------------------------------------
//      ڽջʼ
// ˵     void
// ز     void
// ʹʾ     uart_receiver_init();
//-------------------------------------------------------------------------------------------------------------------
void uart_receiver_init(void)
{
    uart_sbus_init(UART_RECEVIER_UART_INDEX, SBUS_UART_BAUDRATE, UART_RECEVIER_TX_PIN, UART_RECEVIER_RX_PIN);

    // ôжϻص
    set_wireless_type(RECEIVER_UART, uart_receiver_callback);
}
