/*********************************************************************************************************************
* TC264 Opensourec Library TC264 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC264 Դһ
*
* TC264 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_common_font
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC264D
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-08-10        Teternal            first version
* 2023-12-06        Teternal            ²߼ ޸ݶȡʱ쳣Ĳ
********************************************************************************************************************/

#ifndef _zf_common_fifo_h_
#define _zf_common_fifo_h_

#include "zf_common_typedef.h"

typedef enum
{
    FIFO_SUCCESS,                                                               // FIFO ɹ

    FIFO_RESET_UNDO,                                                            // FIFO òδִ
    FIFO_CLEAR_UNDO,                                                            // FIFO ղδִ
    FIFO_BUFFER_NULL,                                                           // FIFO û쳣
    FIFO_WRITE_UNDO,                                                            // FIFO дδִ
    FIFO_SPACE_NO_ENOUGH,                                                       // FIFO д ռ䲻
    FIFO_READ_UNDO,                                                             // FIFO ȡδִ
    FIFO_DATA_NO_ENOUGH,                                                        // FIFO ȡ ݳȲ
}fifo_state_enum;                                                               // FIFO 

// ߼
// ò   ǿ FIFO ʹ
// д   Լдʱ
// ˳ȡ   պòʱ
// βȡ   պԼдʱ
// ȡղ   պԼȡʱ
// Ϊ˷ֹжǶ׵ݻ
typedef enum
{
    FIFO_IDLE       = 0x00,                                                     // ״̬

    FIFO_RESET      = 0x01,                                                     // ִû
    FIFO_CLEAR      = 0x02,                                                     // ִջ
    FIFO_WRITE      = 0x04,                                                     // ִд뻺
    FIFO_READ       = 0x08,                                                     // ִжȡ
}fifo_execution_enum;                                                           // FIFO ״̬ ΪǶʹԤ ޷ȫ

typedef enum
{
    FIFO_READ_AND_CLEAN,                                                        // FIFO ģʽ ȡͷŶӦ
    FIFO_READ_ONLY,                                                             // FIFO ģʽ ȡ
}fifo_operation_enum;

typedef enum
{
    FIFO_DATA_8BIT,                                                             // FIFO λ 8bit
    FIFO_DATA_16BIT,                                                            // FIFO λ 16bit
    FIFO_DATA_32BIT,                                                            // FIFO λ 32bit
}fifo_data_type_enum;

typedef struct
{
    uint8               execution;                                              // ִв
    fifo_data_type_enum type;                                                   // 
    void                *buffer;                                                // ָ
    uint32              head;                                                   // ͷָ ָյĻ
    uint32              end;                                                    // βָ ָǿջ棨ȫճ⣩
    uint32              size;                                                   // ʣС
    uint32              max;                                                    // ܴС
}fifo_struct;

fifo_state_enum fifo_clear              (fifo_struct *fifo);
uint32          fifo_used               (fifo_struct *fifo);

fifo_state_enum fifo_write_element      (fifo_struct *fifo, uint32 dat);
fifo_state_enum fifo_write_buffer       (fifo_struct *fifo, void *dat, uint32 length);
fifo_state_enum fifo_read_element       (fifo_struct *fifo, void *dat, fifo_operation_enum flag);
fifo_state_enum fifo_read_buffer        (fifo_struct *fifo, void *dat, uint32 *length, fifo_operation_enum flag);
fifo_state_enum fifo_read_tail_buffer   (fifo_struct *fifo, void *dat, uint32 *length, fifo_operation_enum flag);

fifo_state_enum fifo_init               (fifo_struct *fifo, fifo_data_type_enum type, void *buffer_addr, uint32 size);

#endif
