/*********************************************************************************************************************
* TC364 Opensourec Library TC364 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC364 Դһ
*
* TC364 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_common_debug
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC364DP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-09-15       pudding            first version
* 2022-05-26       pudding            Դڷͺ޸ĬϿж
* 2022-05-27       pudding            ĸ߱ӹܣ߱ʱرжϼPWM
********************************************************************************************************************/

#ifndef _zf_common_debug_h_
#define _zf_common_debug_h_

#include "zf_common_typedef.h"
#include "zf_common_interrupt.h"

#define DEBUG_UART_INDEX            (UART_0)            // ָ debug uart ʹõĵĴ
#define DEBUG_UART_BAUDRATE         (115200)            // ָ debug uart ʹõĵĴڲ
#define DEBUG_UART_TX_PIN           (UART0_TX_P14_0)    // ָ debug uart ʹõĵĴ
#define DEBUG_UART_RX_PIN           (UART0_RX_P14_1)    // ָ debug uart ʹõĵĴ
#define DEBUG_UART_USE_INTERRUPT    (1)                 // Ƿ debug uart ж


//-------------------------------------------------------------------------------------------------------------------
//      
// ˵     x           жǷ񴥷 0- 1-
// ز     void
// ʹʾ     zf_assert(0);
// עϢ     һڲж zf_assert(0) ͶԱ
//             Ĭ» Debug UART 
//             ʹÿԴĻӿڳʼĻ Ļʾ
//-------------------------------------------------------------------------------------------------------------------
#define zf_assert(x)                (debug_assert_handler((x), __FILE__, __LINE__))     //  һڲж zf_assert(0) ͶԱ
//-------------------------------------------------------------------------------------------------------------------
//      Log Ϣ
// ˵     x           жǷ񴥷 0- 1-
// ˵     *str        Ҫ Log Ϣ
// ز     void
// ʹʾ     zf_log(0, "Error");
// עϢ     Ϣ һЩ߾֮
//             Ĭ» Debug UART 
//             ʹÿԴĻӿڳʼĻ Ļʾ
//-------------------------------------------------------------------------------------------------------------------
#define zf_log(x, str)              (debug_log_handler((x), (str), __FILE__, __LINE__)) // Ϣ һЩ߾֮

//-------------------------------------------------------------------------------------------------------------------
//      CPUӹ
// ز     void
// עϢ     CPUʱͨlogϢû
//-------------------------------------------------------------------------------------------------------------------
#define IFX_CFG_CPU_TRAP_BE_HOOK(x)     zf_log(0, "Memory access failure or Use an uninitialized peripheral, Locate faults through debugging"); assert_interrupt_config(); while(1);
#define IFX_CFG_CPU_TRAP_IPE_HOOK(x)    zf_log(0, "Accessing an null address, Locate faults through debugging");                                assert_interrupt_config(); while(1);
#define IFX_CFG_CPU_TRAP_ASSERT_HOOK(x) zf_log(0, "Cpu Assertion error, Locate faults through debugging");                                      assert_interrupt_config(); while(1);
#define IFX_CFG_CPU_TRAP_CME_HOOK(x)    zf_log(0, "Context management error, Locate faults through debugging");                                 assert_interrupt_config(); while(1);
#define IFX_CFG_CPU_TRAP_IE_HOOK(x)     zf_log(0, "Instruction Error, Locate faults through debugging");                                        assert_interrupt_config(); while(1);
#define IFX_CFG_CPU_TRAP_MME_HOOK(x)    zf_log(0, "Memory management error, Locate faults through debugging");                                  assert_interrupt_config(); while(1);

typedef struct
{
    uint16 type_index;

    uint16 display_x_max;
    uint16 display_y_max;

    uint8 font_x_size;
    uint8 font_y_size;

    void (*output_uart)                (const char *str);
    void (*output_screen)              (uint16 x, uint16 y, const char *str);
    void (*output_screen_clear)        (void);
}debug_output_struct;


#if DEBUG_UART_USE_INTERRUPT                                                            //  debug uart ж
#define DEBUG_RING_BUFFER_LEN          (64)                                             // 廷λС Ĭ 64byte
void    debug_interrupr_handler        (void);
uint32  debug_read_ring_buffer         (uint8 *buff, uint32 len);
#endif


uint32  debug_send_buffer              (const uint8 *buff, uint32 len);                 // Դڻ
void    debug_assert_enable            (void);
void    debug_assert_disable           (void);
void    debug_assert_handler           (uint8 pass, char *file, int line);
void    debug_log_handler              (uint8 pass, char *str, char *file, int line);
void    debug_output_struct_init       (debug_output_struct *info);
void    debug_output_init              (debug_output_struct *info);
void    debug_init                     (void);

#endif

