/**
 * \file IfxGtm_PinMap.h
 * \brief GTM I/O map
 * \ingroup IfxLld_Gtm
 *
 * \version iLLD_1_0_1_11_0
 * \copyright Copyright (c) 2017 Infineon Technologies AG. All rights reserved.
 *
 *
 *                                 IMPORTANT NOTICE
 *
 *
 * Use of this file is subject to the terms of use agreed between (i) you or 
 * the company in which ordinary course of business you are acting and (ii) 
 * Infineon Technologies AG or its licensees. If and as long as no such 
 * terms of use are agreed, use of this file is subject to following:


 * Boost Software License - Version 1.0 - August 17th, 2003

 * Permission is hereby granted, free of charge, to any person or 
 * organization obtaining a copy of the software and accompanying 
 * documentation covered by this license (the "Software") to use, reproduce,
 * display, distribute, execute, and transmit the Software, and to prepare
 * derivative works of the Software, and to permit third-parties to whom the 
 * Software is furnished to do so, all subject to the following:

 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer, must
 * be included in all copies of the Software, in whole or in part, and all
 * derivative works of the Software, unless such copies or derivative works are
 * solely in the form of machine-executable object code generated by a source
 * language processor.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.

 *
 * \defgroup IfxLld_Gtm_pinmap GTM Pin Mapping
 * \ingroup IfxLld_Gtm
 */

#ifndef IFXGTM_PINMAP_H
#define IFXGTM_PINMAP_H

#include <IfxGtm_reg.h>
#include <_Impl/IfxGtm_cfg.h>
#include <Port/Std/IfxPort.h>
#include <Gtm/Std/IfxGtm_Atom.h>
#include <Gtm/Std/IfxGtm_Tom.h>
#include <Gtm/Std/IfxGtm_Tim.h>

/** \addtogroup IfxLld_Gtm_pinmap
 * \{ */

/** \brief CHxSEL register control code */
typedef enum
{
    IfxGtm_ChXSel_a,
    IfxGtm_ChXSel_b,
    IfxGtm_ChXSel_c,
    IfxGtm_ChXSel_d,

    IfxGtm_ChXSel_e,
    IfxGtm_ChXSel_f,
    IfxGtm_ChXSel_g,
    IfxGtm_ChXSel_h,

    IfxGtm_ChXSel_i,
    IfxGtm_ChXSel_j,
    IfxGtm_ChXSel_k,
    IfxGtm_ChXSel_l,

    IfxGtm_ChXSel_m,
    IfxGtm_ChXSel_n,
    IfxGtm_ChXSel_o,
    IfxGtm_ChXSel_p
} IfxGtm_ChXSel;

/** \brief TOUTSEL register control code */
typedef enum
{
    IfxGtm_ToutSel_a,
    IfxGtm_ToutSel_b,
    IfxGtm_ToutSel_c,
    IfxGtm_ToutSel_d,
    IfxGtm_ToutSel_e,
    IfxGtm_ToutSel_f,
    IfxGtm_ToutSel_g,
    IfxGtm_ToutSel_h,
    IfxGtm_ToutSel_i,
    IfxGtm_ToutSel_j,
    IfxGtm_ToutSel_k,
    IfxGtm_ToutSel_l    

} IfxGtm_ToutSel;

/** \brief TIN pin mapping structure */
typedef const struct
{
    IfxGtm_Tim      tim;        /**< \brief TIM unit index */
    IfxGtm_Tim_Ch   channel;    /**< \brief TIM channel index */
    IfxPort_Pin     pin;        /**< \brief Port pin */
    IfxGtm_ChXSel   select;     /**< \brief Input multiplexer value */
} IfxGtm_Tim_TinMap;

/** \brief ATOM TOUT pin mapping structure */
typedef const struct
{
    IfxGtm_Atom         atom;       /**< \brief ATOM unit index */
    IfxGtm_Atom_Ch      channel;    /**< \brief ATOM channel index */
    IfxGtm_ToutSel      toutSel;    /**< \brief TOUTSEL register control code */
    uint32              toutn;      /**< \brief TOUT number */
    IfxPort_Pin         pin;        /**< \brief Port pin */
    IfxPort_OutputIdx   select;     /**< \brief Port control code */
} IfxGtm_Atom_ToutMap;

/** \brief Pointer to \ref IfxGtm_Atom_ToutMap */
typedef IfxGtm_Atom_ToutMap *IfxGtm_Atom_ToutMapP;

/** \brief TOM TOUT pin mapping structure */
typedef const struct
{
    IfxGtm_Tom          tom;        /**< \brief TOM unit index */
    IfxGtm_Tom_Ch       channel;    /**< \brief TOM channel index */
    IfxGtm_ToutSel      toutSel;    /**< \brief TOUTSEL register control code */
    uint32              toutn;      /**< \brief TOUT number */
    IfxPort_Pin         pin;        /**< \brief Port pin */
    IfxPort_OutputIdx   select;     /**< \brief Port control code */
} IfxGtm_Tom_ToutMap;

/** \brief GTM Clock Output */
typedef const struct
{
    Ifx_GTM*          module;   /**< \brief Base address */
    IfxPort_Pin       pin;      /**< \brief Port pin */
    IfxPort_OutputIdx select;   /**< \brief Port control code */
} IfxGtm_Clk_Out;

/** \brief Pointer to \ref IfxGtm_Tom_ToutMap */
typedef IfxGtm_Tom_ToutMap *IfxGtm_Tom_ToutMapP;

IFX_EXTERN void IfxGtm_PinMap_setTimTin(IfxGtm_Tim_TinMap *config, IfxPort_InputMode inputMode);
IFX_EXTERN void IfxGtm_PinMap_setAtomTout(IfxGtm_Atom_ToutMap *config, IfxPort_OutputMode outputMode, IfxPort_PadDriver padDriver);
IFX_EXTERN void IfxGtm_PinMap_setTomTout(IfxGtm_Tom_ToutMap *config, IfxPort_OutputMode outputMode, IfxPort_PadDriver padDriver);

IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_0N_TOUT17_P00_8_OUT;  /**< \brief IfxGtm_ATOM0_0N_TOUT17_P00_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_0N_TOUT43_P23_2_OUT;  /**< \brief IfxGtm_ATOM0_0N_TOUT43_P23_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_0N_TOUT54_P21_3_OUT;  /**< \brief IfxGtm_ATOM0_0N_TOUT54_P21_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_0N_TOUT7_P02_7_OUT;  /**< \brief IfxGtm_ATOM0_0N_TOUT7_P02_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_0_TOUT0_P02_0_OUT;  /**< \brief IfxGtm_ATOM0_0_TOUT0_P02_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_0_TOUT48_P22_1_OUT;  /**< \brief IfxGtm_ATOM0_0_TOUT48_P22_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_0_TOUT53_P21_2_OUT;  /**< \brief IfxGtm_ATOM0_0_TOUT53_P21_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_0_TOUT85_P14_5_OUT;  /**< \brief IfxGtm_ATOM0_0_TOUT85_P14_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_0_TOUT8_P02_8_OUT;  /**< \brief IfxGtm_ATOM0_0_TOUT8_P02_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_0_TOUT9_P00_0_OUT;  /**< \brief IfxGtm_ATOM0_0_TOUT9_P00_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1N_TOUT14_P00_5_OUT;  /**< \brief IfxGtm_ATOM0_1N_TOUT14_P00_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1N_TOUT39_P32_3_OUT;  /**< \brief IfxGtm_ATOM0_1N_TOUT39_P32_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1N_TOUT41_P23_0_OUT;  /**< \brief IfxGtm_ATOM0_1N_TOUT41_P23_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1N_TOUT4_P02_4_OUT;  /**< \brief IfxGtm_ATOM0_1N_TOUT4_P02_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1N_TOUT50_P22_3_OUT;  /**< \brief IfxGtm_ATOM0_1N_TOUT50_P22_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1N_TOUT53_P21_2_OUT;  /**< \brief IfxGtm_ATOM0_1N_TOUT53_P21_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1N_TOUT55_P21_4_OUT;  /**< \brief IfxGtm_ATOM0_1N_TOUT55_P21_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1N_TOUT57_P21_6_OUT;  /**< \brief IfxGtm_ATOM0_1N_TOUT57_P21_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1N_TOUT61_P20_3_OUT;  /**< \brief IfxGtm_ATOM0_1N_TOUT61_P20_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1_TOUT10_P00_1_OUT;  /**< \brief IfxGtm_ATOM0_1_TOUT10_P00_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1_TOUT11_P00_2_OUT;  /**< \brief IfxGtm_ATOM0_1_TOUT11_P00_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1_TOUT1_P02_1_OUT;  /**< \brief IfxGtm_ATOM0_1_TOUT1_P02_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1_TOUT31_P33_9_OUT;  /**< \brief IfxGtm_ATOM0_1_TOUT31_P33_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1_TOUT47_P22_0_OUT;  /**< \brief IfxGtm_ATOM0_1_TOUT47_P22_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1_TOUT54_P21_3_OUT;  /**< \brief IfxGtm_ATOM0_1_TOUT54_P21_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_1_TOUT84_P14_4_OUT;  /**< \brief IfxGtm_ATOM0_1_TOUT84_P14_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2N_TOUT15_P00_6_OUT;  /**< \brief IfxGtm_ATOM0_2N_TOUT15_P00_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2N_TOUT23_P33_1_OUT;  /**< \brief IfxGtm_ATOM0_2N_TOUT23_P33_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2N_TOUT40_P32_4_OUT;  /**< \brief IfxGtm_ATOM0_2N_TOUT40_P32_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2N_TOUT41_P23_0_OUT;  /**< \brief IfxGtm_ATOM0_2N_TOUT41_P23_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2N_TOUT44_P23_3_OUT;  /**< \brief IfxGtm_ATOM0_2N_TOUT44_P23_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2N_TOUT56_P21_5_OUT;  /**< \brief IfxGtm_ATOM0_2N_TOUT56_P21_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2N_TOUT58_P21_7_OUT;  /**< \brief IfxGtm_ATOM0_2N_TOUT58_P21_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2N_TOUT5_P02_5_OUT;  /**< \brief IfxGtm_ATOM0_2N_TOUT5_P02_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2N_TOUT65_P20_9_OUT;  /**< \brief IfxGtm_ATOM0_2N_TOUT65_P20_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2_TOUT12_P00_3_OUT;  /**< \brief IfxGtm_ATOM0_2_TOUT12_P00_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2_TOUT2_P02_2_OUT;  /**< \brief IfxGtm_ATOM0_2_TOUT2_P02_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2_TOUT33_P33_11_OUT;  /**< \brief IfxGtm_ATOM0_2_TOUT33_P33_11_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2_TOUT42_P23_1_OUT;  /**< \brief IfxGtm_ATOM0_2_TOUT42_P23_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2_TOUT46_P23_5_OUT;  /**< \brief IfxGtm_ATOM0_2_TOUT46_P23_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2_TOUT55_P21_4_OUT;  /**< \brief IfxGtm_ATOM0_2_TOUT55_P21_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_2_TOUT83_P14_3_OUT;  /**< \brief IfxGtm_ATOM0_2_TOUT83_P14_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3N_TOUT16_P00_7_OUT;  /**< \brief IfxGtm_ATOM0_3N_TOUT16_P00_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3N_TOUT24_P33_2_OUT;  /**< \brief IfxGtm_ATOM0_3N_TOUT24_P33_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3N_TOUT42_P23_1_OUT;  /**< \brief IfxGtm_ATOM0_3N_TOUT42_P23_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3N_TOUT45_P23_4_OUT;  /**< \brief IfxGtm_ATOM0_3N_TOUT45_P23_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3N_TOUT59_P20_0_OUT;  /**< \brief IfxGtm_ATOM0_3N_TOUT59_P20_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3N_TOUT66_P20_10_OUT;  /**< \brief IfxGtm_ATOM0_3N_TOUT66_P20_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3N_TOUT6_P02_6_OUT;  /**< \brief IfxGtm_ATOM0_3N_TOUT6_P02_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3_TOUT13_P00_4_OUT;  /**< \brief IfxGtm_ATOM0_3_TOUT13_P00_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3_TOUT38_P32_2_OUT;  /**< \brief IfxGtm_ATOM0_3_TOUT38_P32_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3_TOUT3_P02_3_OUT;  /**< \brief IfxGtm_ATOM0_3_TOUT3_P02_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3_TOUT49_P22_2_OUT;  /**< \brief IfxGtm_ATOM0_3_TOUT49_P22_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3_TOUT56_P21_5_OUT;  /**< \brief IfxGtm_ATOM0_3_TOUT56_P21_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3_TOUT60_P20_1_OUT;  /**< \brief IfxGtm_ATOM0_3_TOUT60_P20_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_3_TOUT82_P14_2_OUT;  /**< \brief IfxGtm_ATOM0_3_TOUT82_P14_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_4N_TOUT13_P00_4_OUT;  /**< \brief IfxGtm_ATOM0_4N_TOUT13_P00_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_4N_TOUT3_P02_3_OUT;  /**< \brief IfxGtm_ATOM0_4N_TOUT3_P02_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_4_TOUT14_P00_5_OUT;  /**< \brief IfxGtm_ATOM0_4_TOUT14_P00_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_4_TOUT29_P33_7_OUT;  /**< \brief IfxGtm_ATOM0_4_TOUT29_P33_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_4_TOUT39_P32_3_OUT;  /**< \brief IfxGtm_ATOM0_4_TOUT39_P32_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_4_TOUT4_P02_4_OUT;  /**< \brief IfxGtm_ATOM0_4_TOUT4_P02_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_4_TOUT50_P22_3_OUT;  /**< \brief IfxGtm_ATOM0_4_TOUT50_P22_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_4_TOUT57_P21_6_OUT;  /**< \brief IfxGtm_ATOM0_4_TOUT57_P21_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_4_TOUT61_P20_3_OUT;  /**< \brief IfxGtm_ATOM0_4_TOUT61_P20_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_4_TOUT81_P14_1_OUT;  /**< \brief IfxGtm_ATOM0_4_TOUT81_P14_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_5N_TOUT0_P02_0_OUT;  /**< \brief IfxGtm_ATOM0_5N_TOUT0_P02_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_5N_TOUT26_P33_4_OUT;  /**< \brief IfxGtm_ATOM0_5N_TOUT26_P33_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_5N_TOUT8_P02_8_OUT;  /**< \brief IfxGtm_ATOM0_5N_TOUT8_P02_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_5N_TOUT9_P00_0_OUT;  /**< \brief IfxGtm_ATOM0_5N_TOUT9_P00_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_5_TOUT15_P00_6_OUT;  /**< \brief IfxGtm_ATOM0_5_TOUT15_P00_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_5_TOUT23_P33_1_OUT;  /**< \brief IfxGtm_ATOM0_5_TOUT23_P33_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_5_TOUT40_P32_4_OUT;  /**< \brief IfxGtm_ATOM0_5_TOUT40_P32_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_5_TOUT41_P23_0_OUT;  /**< \brief IfxGtm_ATOM0_5_TOUT41_P23_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_5_TOUT58_P21_7_OUT;  /**< \brief IfxGtm_ATOM0_5_TOUT58_P21_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_5_TOUT5_P02_5_OUT;  /**< \brief IfxGtm_ATOM0_5_TOUT5_P02_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_6N_TOUT10_P00_1_OUT;  /**< \brief IfxGtm_ATOM0_6N_TOUT10_P00_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_6N_TOUT11_P00_2_OUT;  /**< \brief IfxGtm_ATOM0_6N_TOUT11_P00_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_6N_TOUT1_P02_1_OUT;  /**< \brief IfxGtm_ATOM0_6N_TOUT1_P02_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_6N_TOUT27_P33_5_OUT;  /**< \brief IfxGtm_ATOM0_6N_TOUT27_P33_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_6_TOUT106_P10_4_OUT;  /**< \brief IfxGtm_ATOM0_6_TOUT106_P10_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_6_TOUT16_P00_7_OUT;  /**< \brief IfxGtm_ATOM0_6_TOUT16_P00_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_6_TOUT24_P33_2_OUT;  /**< \brief IfxGtm_ATOM0_6_TOUT24_P33_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_6_TOUT42_P23_1_OUT;  /**< \brief IfxGtm_ATOM0_6_TOUT42_P23_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_6_TOUT59_P20_0_OUT;  /**< \brief IfxGtm_ATOM0_6_TOUT59_P20_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_6_TOUT6_P02_6_OUT;  /**< \brief IfxGtm_ATOM0_6_TOUT6_P02_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_7N_TOUT12_P00_3_OUT;  /**< \brief IfxGtm_ATOM0_7N_TOUT12_P00_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_7N_TOUT28_P33_6_OUT;  /**< \brief IfxGtm_ATOM0_7N_TOUT28_P33_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_7N_TOUT2_P02_2_OUT;  /**< \brief IfxGtm_ATOM0_7N_TOUT2_P02_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_7_TOUT17_P00_8_OUT;  /**< \brief IfxGtm_ATOM0_7_TOUT17_P00_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_7_TOUT25_P33_3_OUT;  /**< \brief IfxGtm_ATOM0_7_TOUT25_P33_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_7_TOUT45_P23_4_OUT;  /**< \brief IfxGtm_ATOM0_7_TOUT45_P23_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_7_TOUT64_P20_8_OUT;  /**< \brief IfxGtm_ATOM0_7_TOUT64_P20_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM0_7_TOUT7_P02_7_OUT;  /**< \brief IfxGtm_ATOM0_7_TOUT7_P02_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_0N_TOUT17_P00_8_OUT;  /**< \brief IfxGtm_ATOM1_0N_TOUT17_P00_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_0N_TOUT7_P02_7_OUT;  /**< \brief IfxGtm_ATOM1_0N_TOUT7_P02_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_0_TOUT0_P02_0_OUT;  /**< \brief IfxGtm_ATOM1_0_TOUT0_P02_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_0_TOUT109_P10_7_OUT;  /**< \brief IfxGtm_ATOM1_0_TOUT109_P10_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_0_TOUT68_P20_12_OUT;  /**< \brief IfxGtm_ATOM1_0_TOUT68_P20_12_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_0_TOUT76_P15_5_OUT;  /**< \brief IfxGtm_ATOM1_0_TOUT76_P15_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_0_TOUT77_P15_6_OUT;  /**< \brief IfxGtm_ATOM1_0_TOUT77_P15_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_0_TOUT87_P14_7_OUT;  /**< \brief IfxGtm_ATOM1_0_TOUT87_P14_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_0_TOUT8_P02_8_OUT;  /**< \brief IfxGtm_ATOM1_0_TOUT8_P02_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_0_TOUT9_P00_0_OUT;  /**< \brief IfxGtm_ATOM1_0_TOUT9_P00_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1N_TOUT102_P10_0_OUT;  /**< \brief IfxGtm_ATOM1_1N_TOUT102_P10_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1N_TOUT14_P00_5_OUT;  /**< \brief IfxGtm_ATOM1_1N_TOUT14_P00_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1N_TOUT39_P32_3_OUT;  /**< \brief IfxGtm_ATOM1_1N_TOUT39_P32_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1N_TOUT4_P02_4_OUT;  /**< \brief IfxGtm_ATOM1_1N_TOUT4_P02_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1N_TOUT61_P20_3_OUT;  /**< \brief IfxGtm_ATOM1_1N_TOUT61_P20_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1N_TOUT72_P15_1_OUT;  /**< \brief IfxGtm_ATOM1_1N_TOUT72_P15_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1_TOUT103_P10_1_OUT;  /**< \brief IfxGtm_ATOM1_1_TOUT103_P10_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1_TOUT10_P00_1_OUT;  /**< \brief IfxGtm_ATOM1_1_TOUT10_P00_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1_TOUT11_P00_2_OUT;  /**< \brief IfxGtm_ATOM1_1_TOUT11_P00_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1_TOUT1_P02_1_OUT;  /**< \brief IfxGtm_ATOM1_1_TOUT1_P02_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1_TOUT31_P33_9_OUT;  /**< \brief IfxGtm_ATOM1_1_TOUT31_P33_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1_TOUT69_P20_13_OUT;  /**< \brief IfxGtm_ATOM1_1_TOUT69_P20_13_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1_TOUT78_P15_7_OUT;  /**< \brief IfxGtm_ATOM1_1_TOUT78_P15_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1_TOUT79_P15_8_OUT;  /**< \brief IfxGtm_ATOM1_1_TOUT79_P15_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_1_TOUT86_P14_6_OUT;  /**< \brief IfxGtm_ATOM1_1_TOUT86_P14_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2N_TOUT110_P10_8_OUT;  /**< \brief IfxGtm_ATOM1_2N_TOUT110_P10_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2N_TOUT15_P00_6_OUT;  /**< \brief IfxGtm_ATOM1_2N_TOUT15_P00_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2N_TOUT23_P33_1_OUT;  /**< \brief IfxGtm_ATOM1_2N_TOUT23_P33_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2N_TOUT40_P32_4_OUT;  /**< \brief IfxGtm_ATOM1_2N_TOUT40_P32_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2N_TOUT41_P23_0_OUT;  /**< \brief IfxGtm_ATOM1_2N_TOUT41_P23_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2N_TOUT5_P02_5_OUT;  /**< \brief IfxGtm_ATOM1_2N_TOUT5_P02_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2N_TOUT73_P15_2_OUT;  /**< \brief IfxGtm_ATOM1_2N_TOUT73_P15_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2_TOUT104_P10_2_OUT;  /**< \brief IfxGtm_ATOM1_2_TOUT104_P10_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2_TOUT107_P10_5_OUT;  /**< \brief IfxGtm_ATOM1_2_TOUT107_P10_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2_TOUT12_P00_3_OUT;  /**< \brief IfxGtm_ATOM1_2_TOUT12_P00_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2_TOUT2_P02_2_OUT;  /**< \brief IfxGtm_ATOM1_2_TOUT2_P02_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2_TOUT33_P33_11_OUT;  /**< \brief IfxGtm_ATOM1_2_TOUT33_P33_11_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2_TOUT70_P20_14_OUT;  /**< \brief IfxGtm_ATOM1_2_TOUT70_P20_14_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_2_TOUT80_P14_0_OUT;  /**< \brief IfxGtm_ATOM1_2_TOUT80_P14_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3N_TOUT106_P10_4_OUT;  /**< \brief IfxGtm_ATOM1_3N_TOUT106_P10_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3N_TOUT16_P00_7_OUT;  /**< \brief IfxGtm_ATOM1_3N_TOUT16_P00_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3N_TOUT24_P33_2_OUT;  /**< \brief IfxGtm_ATOM1_3N_TOUT24_P33_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3N_TOUT42_P23_1_OUT;  /**< \brief IfxGtm_ATOM1_3N_TOUT42_P23_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3N_TOUT6_P02_6_OUT;  /**< \brief IfxGtm_ATOM1_3N_TOUT6_P02_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3N_TOUT74_P15_3_OUT;  /**< \brief IfxGtm_ATOM1_3N_TOUT74_P15_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3_TOUT105_P10_3_OUT;  /**< \brief IfxGtm_ATOM1_3_TOUT105_P10_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3_TOUT108_P10_6_OUT;  /**< \brief IfxGtm_ATOM1_3_TOUT108_P10_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3_TOUT13_P00_4_OUT;  /**< \brief IfxGtm_ATOM1_3_TOUT13_P00_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3_TOUT38_P32_2_OUT;  /**< \brief IfxGtm_ATOM1_3_TOUT38_P32_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3_TOUT3_P02_3_OUT;  /**< \brief IfxGtm_ATOM1_3_TOUT3_P02_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3_TOUT60_P20_1_OUT;  /**< \brief IfxGtm_ATOM1_3_TOUT60_P20_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_3_TOUT71_P15_0_OUT;  /**< \brief IfxGtm_ATOM1_3_TOUT71_P15_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4N_TOUT105_P10_3_OUT;  /**< \brief IfxGtm_ATOM1_4N_TOUT105_P10_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4N_TOUT108_P10_6_OUT;  /**< \brief IfxGtm_ATOM1_4N_TOUT108_P10_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4N_TOUT13_P00_4_OUT;  /**< \brief IfxGtm_ATOM1_4N_TOUT13_P00_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4N_TOUT3_P02_3_OUT;  /**< \brief IfxGtm_ATOM1_4N_TOUT3_P02_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4N_TOUT71_P15_0_OUT;  /**< \brief IfxGtm_ATOM1_4N_TOUT71_P15_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4N_TOUT75_P15_4_OUT;  /**< \brief IfxGtm_ATOM1_4N_TOUT75_P15_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4_TOUT102_P10_0_OUT;  /**< \brief IfxGtm_ATOM1_4_TOUT102_P10_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4_TOUT14_P00_5_OUT;  /**< \brief IfxGtm_ATOM1_4_TOUT14_P00_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4_TOUT29_P33_7_OUT;  /**< \brief IfxGtm_ATOM1_4_TOUT29_P33_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4_TOUT39_P32_3_OUT;  /**< \brief IfxGtm_ATOM1_4_TOUT39_P32_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4_TOUT4_P02_4_OUT;  /**< \brief IfxGtm_ATOM1_4_TOUT4_P02_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4_TOUT61_P20_3_OUT;  /**< \brief IfxGtm_ATOM1_4_TOUT61_P20_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_4_TOUT72_P15_1_OUT;  /**< \brief IfxGtm_ATOM1_4_TOUT72_P15_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5N_TOUT0_P02_0_OUT;  /**< \brief IfxGtm_ATOM1_5N_TOUT0_P02_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5N_TOUT109_P10_7_OUT;  /**< \brief IfxGtm_ATOM1_5N_TOUT109_P10_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5N_TOUT26_P33_4_OUT;  /**< \brief IfxGtm_ATOM1_5N_TOUT26_P33_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5N_TOUT76_P15_5_OUT;  /**< \brief IfxGtm_ATOM1_5N_TOUT76_P15_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5N_TOUT77_P15_6_OUT;  /**< \brief IfxGtm_ATOM1_5N_TOUT77_P15_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5N_TOUT8_P02_8_OUT;  /**< \brief IfxGtm_ATOM1_5N_TOUT8_P02_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5N_TOUT9_P00_0_OUT;  /**< \brief IfxGtm_ATOM1_5N_TOUT9_P00_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5_TOUT110_P10_8_OUT;  /**< \brief IfxGtm_ATOM1_5_TOUT110_P10_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5_TOUT15_P00_6_OUT;  /**< \brief IfxGtm_ATOM1_5_TOUT15_P00_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5_TOUT23_P33_1_OUT;  /**< \brief IfxGtm_ATOM1_5_TOUT23_P33_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5_TOUT40_P32_4_OUT;  /**< \brief IfxGtm_ATOM1_5_TOUT40_P32_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5_TOUT41_P23_0_OUT;  /**< \brief IfxGtm_ATOM1_5_TOUT41_P23_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5_TOUT5_P02_5_OUT;  /**< \brief IfxGtm_ATOM1_5_TOUT5_P02_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5_TOUT65_P20_9_OUT;  /**< \brief IfxGtm_ATOM1_5_TOUT65_P20_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_5_TOUT73_P15_2_OUT;  /**< \brief IfxGtm_ATOM1_5_TOUT73_P15_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6N_TOUT103_P10_1_OUT;  /**< \brief IfxGtm_ATOM1_6N_TOUT103_P10_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6N_TOUT10_P00_1_OUT;  /**< \brief IfxGtm_ATOM1_6N_TOUT10_P00_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6N_TOUT11_P00_2_OUT;  /**< \brief IfxGtm_ATOM1_6N_TOUT11_P00_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6N_TOUT1_P02_1_OUT;  /**< \brief IfxGtm_ATOM1_6N_TOUT1_P02_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6N_TOUT27_P33_5_OUT;  /**< \brief IfxGtm_ATOM1_6N_TOUT27_P33_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6N_TOUT78_P15_7_OUT;  /**< \brief IfxGtm_ATOM1_6N_TOUT78_P15_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6_TOUT106_P10_4_OUT;  /**< \brief IfxGtm_ATOM1_6_TOUT106_P10_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6_TOUT16_P00_7_OUT;  /**< \brief IfxGtm_ATOM1_6_TOUT16_P00_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6_TOUT24_P33_2_OUT;  /**< \brief IfxGtm_ATOM1_6_TOUT24_P33_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6_TOUT42_P23_1_OUT;  /**< \brief IfxGtm_ATOM1_6_TOUT42_P23_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6_TOUT66_P20_10_OUT;  /**< \brief IfxGtm_ATOM1_6_TOUT66_P20_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6_TOUT6_P02_6_OUT;  /**< \brief IfxGtm_ATOM1_6_TOUT6_P02_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_6_TOUT74_P15_3_OUT;  /**< \brief IfxGtm_ATOM1_6_TOUT74_P15_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_7N_TOUT104_P10_2_OUT;  /**< \brief IfxGtm_ATOM1_7N_TOUT104_P10_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_7N_TOUT107_P10_5_OUT;  /**< \brief IfxGtm_ATOM1_7N_TOUT107_P10_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_7N_TOUT12_P00_3_OUT;  /**< \brief IfxGtm_ATOM1_7N_TOUT12_P00_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_7N_TOUT28_P33_6_OUT;  /**< \brief IfxGtm_ATOM1_7N_TOUT28_P33_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_7N_TOUT2_P02_2_OUT;  /**< \brief IfxGtm_ATOM1_7N_TOUT2_P02_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_7N_TOUT79_P15_8_OUT;  /**< \brief IfxGtm_ATOM1_7N_TOUT79_P15_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_7_TOUT17_P00_8_OUT;  /**< \brief IfxGtm_ATOM1_7_TOUT17_P00_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_7_TOUT25_P33_3_OUT;  /**< \brief IfxGtm_ATOM1_7_TOUT25_P33_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_7_TOUT45_P23_4_OUT;  /**< \brief IfxGtm_ATOM1_7_TOUT45_P23_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_7_TOUT67_P20_11_OUT;  /**< \brief IfxGtm_ATOM1_7_TOUT67_P20_11_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_7_TOUT75_P15_4_OUT;  /**< \brief IfxGtm_ATOM1_7_TOUT75_P15_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM1_7_TOUT7_P02_7_OUT;  /**< \brief IfxGtm_ATOM1_7_TOUT7_P02_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_0N_TOUT101_P11_12_OUT;  /**< \brief IfxGtm_ATOM2_0N_TOUT101_P11_12_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_0N_TOUT108_P10_6_OUT;  /**< \brief IfxGtm_ATOM2_0N_TOUT108_P10_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_0N_TOUT12_P00_3_OUT;  /**< \brief IfxGtm_ATOM2_0N_TOUT12_P00_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_0N_TOUT25_P33_3_OUT;  /**< \brief IfxGtm_ATOM2_0N_TOUT25_P33_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_0N_TOUT32_P33_10_OUT;  /**< \brief IfxGtm_ATOM2_0N_TOUT32_P33_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_0N_TOUT37_P32_1_OUT;  /**< \brief IfxGtm_ATOM2_0N_TOUT37_P32_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_0_TOUT109_P10_7_OUT;  /**< \brief IfxGtm_ATOM2_0_TOUT109_P10_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_0_TOUT18_P00_9_OUT;  /**< \brief IfxGtm_ATOM2_0_TOUT18_P00_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_0_TOUT26_P33_4_OUT;  /**< \brief IfxGtm_ATOM2_0_TOUT26_P33_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_0_TOUT32_P33_10_OUT;  /**< \brief IfxGtm_ATOM2_0_TOUT32_P33_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_0_TOUT94_P13_3_OUT;  /**< \brief IfxGtm_ATOM2_0_TOUT94_P13_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1N_TOUT105_P10_3_OUT;  /**< \brief IfxGtm_ATOM2_1N_TOUT105_P10_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1N_TOUT22_P33_0_OUT;  /**< \brief IfxGtm_ATOM2_1N_TOUT22_P33_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1N_TOUT30_P33_8_OUT;  /**< \brief IfxGtm_ATOM2_1N_TOUT30_P33_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1N_TOUT34_P33_12_OUT;  /**< \brief IfxGtm_ATOM2_1N_TOUT34_P33_12_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1N_TOUT51_P21_0_OUT;  /**< \brief IfxGtm_ATOM2_1N_TOUT51_P21_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1N_TOUT90_P14_10_OUT;  /**< \brief IfxGtm_ATOM2_1N_TOUT90_P14_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1N_TOUT91_P13_0_OUT;  /**< \brief IfxGtm_ATOM2_1N_TOUT91_P13_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1N_TOUT98_P11_9_OUT;  /**< \brief IfxGtm_ATOM2_1N_TOUT98_P11_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1N_TOUT9_P00_0_OUT;  /**< \brief IfxGtm_ATOM2_1N_TOUT9_P00_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1_TOUT102_P10_0_OUT;  /**< \brief IfxGtm_ATOM2_1_TOUT102_P10_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1_TOUT19_P00_10_OUT;  /**< \brief IfxGtm_ATOM2_1_TOUT19_P00_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1_TOUT27_P33_5_OUT;  /**< \brief IfxGtm_ATOM2_1_TOUT27_P33_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1_TOUT43_P23_2_OUT;  /**< \brief IfxGtm_ATOM2_1_TOUT43_P23_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1_TOUT90_P14_10_OUT;  /**< \brief IfxGtm_ATOM2_1_TOUT90_P14_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_1_TOUT95_P11_2_OUT;  /**< \brief IfxGtm_ATOM2_1_TOUT95_P11_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2N_TOUT106_P10_4_OUT;  /**< \brief IfxGtm_ATOM2_2N_TOUT106_P10_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2N_TOUT10_P00_1_OUT;  /**< \brief IfxGtm_ATOM2_2N_TOUT10_P00_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2N_TOUT23_P33_1_OUT;  /**< \brief IfxGtm_ATOM2_2N_TOUT23_P33_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2N_TOUT31_P33_9_OUT;  /**< \brief IfxGtm_ATOM2_2N_TOUT31_P33_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2N_TOUT35_P33_13_OUT;  /**< \brief IfxGtm_ATOM2_2N_TOUT35_P33_13_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2N_TOUT52_P21_1_OUT;  /**< \brief IfxGtm_ATOM2_2N_TOUT52_P21_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2N_TOUT91_P13_0_OUT;  /**< \brief IfxGtm_ATOM2_2N_TOUT91_P13_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2N_TOUT92_P13_1_OUT;  /**< \brief IfxGtm_ATOM2_2N_TOUT92_P13_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2N_TOUT99_P11_10_OUT;  /**< \brief IfxGtm_ATOM2_2N_TOUT99_P11_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2_TOUT103_P10_1_OUT;  /**< \brief IfxGtm_ATOM2_2_TOUT103_P10_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2_TOUT20_P00_11_OUT;  /**< \brief IfxGtm_ATOM2_2_TOUT20_P00_11_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2_TOUT28_P33_6_OUT;  /**< \brief IfxGtm_ATOM2_2_TOUT28_P33_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2_TOUT44_P23_3_OUT;  /**< \brief IfxGtm_ATOM2_2_TOUT44_P23_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2_TOUT88_P14_8_OUT;  /**< \brief IfxGtm_ATOM2_2_TOUT88_P14_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_2_TOUT96_P11_3_OUT;  /**< \brief IfxGtm_ATOM2_2_TOUT96_P11_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3N_TOUT100_P11_11_OUT;  /**< \brief IfxGtm_ATOM2_3N_TOUT100_P11_11_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3N_TOUT107_P10_5_OUT;  /**< \brief IfxGtm_ATOM2_3N_TOUT107_P10_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3N_TOUT11_P00_2_OUT;  /**< \brief IfxGtm_ATOM2_3N_TOUT11_P00_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3N_TOUT24_P33_2_OUT;  /**< \brief IfxGtm_ATOM2_3N_TOUT24_P33_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3N_TOUT33_P33_11_OUT;  /**< \brief IfxGtm_ATOM2_3N_TOUT33_P33_11_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3N_TOUT36_P32_0_OUT;  /**< \brief IfxGtm_ATOM2_3N_TOUT36_P32_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3N_TOUT62_P20_6_OUT;  /**< \brief IfxGtm_ATOM2_3N_TOUT62_P20_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3N_TOUT92_P13_1_OUT;  /**< \brief IfxGtm_ATOM2_3N_TOUT92_P13_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3N_TOUT93_P13_2_OUT;  /**< \brief IfxGtm_ATOM2_3N_TOUT93_P13_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3_TOUT104_P10_2_OUT;  /**< \brief IfxGtm_ATOM2_3_TOUT104_P10_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3_TOUT21_P00_12_OUT;  /**< \brief IfxGtm_ATOM2_3_TOUT21_P00_12_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3_TOUT29_P33_7_OUT;  /**< \brief IfxGtm_ATOM2_3_TOUT29_P33_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3_TOUT89_P14_9_OUT;  /**< \brief IfxGtm_ATOM2_3_TOUT89_P14_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_3_TOUT97_P11_6_OUT;  /**< \brief IfxGtm_ATOM2_3_TOUT97_P11_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_4N_TOUT29_P33_7_OUT;  /**< \brief IfxGtm_ATOM2_4N_TOUT29_P33_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_4N_TOUT57_P21_6_OUT;  /**< \brief IfxGtm_ATOM2_4N_TOUT57_P21_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_4N_TOUT86_P14_6_OUT;  /**< \brief IfxGtm_ATOM2_4N_TOUT86_P14_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_4N_TOUT97_P11_6_OUT;  /**< \brief IfxGtm_ATOM2_4N_TOUT97_P11_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_4_TOUT22_P33_0_OUT;  /**< \brief IfxGtm_ATOM2_4_TOUT22_P33_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_4_TOUT30_P33_8_OUT;  /**< \brief IfxGtm_ATOM2_4_TOUT30_P33_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_4_TOUT34_P33_12_OUT;  /**< \brief IfxGtm_ATOM2_4_TOUT34_P33_12_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_4_TOUT51_P21_0_OUT;  /**< \brief IfxGtm_ATOM2_4_TOUT51_P21_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_4_TOUT90_P14_10_OUT;  /**< \brief IfxGtm_ATOM2_4_TOUT90_P14_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_4_TOUT98_P11_9_OUT;  /**< \brief IfxGtm_ATOM2_4_TOUT98_P11_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_5N_TOUT120_P11_1_OUT;  /**< \brief IfxGtm_ATOM2_5N_TOUT120_P11_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_5N_TOUT26_P33_4_OUT;  /**< \brief IfxGtm_ATOM2_5N_TOUT26_P33_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_5N_TOUT59_P20_0_OUT;  /**< \brief IfxGtm_ATOM2_5N_TOUT59_P20_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_5N_TOUT87_P14_7_OUT;  /**< \brief IfxGtm_ATOM2_5N_TOUT87_P14_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_5N_TOUT94_P13_3_OUT;  /**< \brief IfxGtm_ATOM2_5N_TOUT94_P13_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_5_TOUT35_P33_13_OUT;  /**< \brief IfxGtm_ATOM2_5_TOUT35_P33_13_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_5_TOUT52_P21_1_OUT;  /**< \brief IfxGtm_ATOM2_5_TOUT52_P21_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_5_TOUT65_P20_9_OUT;  /**< \brief IfxGtm_ATOM2_5_TOUT65_P20_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_5_TOUT91_P13_0_OUT;  /**< \brief IfxGtm_ATOM2_5_TOUT91_P13_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_5_TOUT99_P11_10_OUT;  /**< \brief IfxGtm_ATOM2_5_TOUT99_P11_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_6N_TOUT27_P33_5_OUT;  /**< \brief IfxGtm_ATOM2_6N_TOUT27_P33_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_6N_TOUT60_P20_1_OUT;  /**< \brief IfxGtm_ATOM2_6N_TOUT60_P20_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_6N_TOUT88_P14_8_OUT;  /**< \brief IfxGtm_ATOM2_6N_TOUT88_P14_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_6N_TOUT95_P11_2_OUT;  /**< \brief IfxGtm_ATOM2_6N_TOUT95_P11_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_6_TOUT100_P11_11_OUT;  /**< \brief IfxGtm_ATOM2_6_TOUT100_P11_11_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_6_TOUT36_P32_0_OUT;  /**< \brief IfxGtm_ATOM2_6_TOUT36_P32_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_6_TOUT62_P20_6_OUT;  /**< \brief IfxGtm_ATOM2_6_TOUT62_P20_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_6_TOUT92_P13_1_OUT;  /**< \brief IfxGtm_ATOM2_6_TOUT92_P13_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_7N_TOUT28_P33_6_OUT;  /**< \brief IfxGtm_ATOM2_7N_TOUT28_P33_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_7N_TOUT61_P20_3_OUT;  /**< \brief IfxGtm_ATOM2_7N_TOUT61_P20_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_7N_TOUT89_P14_9_OUT;  /**< \brief IfxGtm_ATOM2_7N_TOUT89_P14_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_7N_TOUT96_P11_3_OUT;  /**< \brief IfxGtm_ATOM2_7N_TOUT96_P11_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_7_TOUT101_P11_12_OUT;  /**< \brief IfxGtm_ATOM2_7_TOUT101_P11_12_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_7_TOUT37_P32_1_OUT;  /**< \brief IfxGtm_ATOM2_7_TOUT37_P32_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_7_TOUT63_P20_7_OUT;  /**< \brief IfxGtm_ATOM2_7_TOUT63_P20_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM2_7_TOUT93_P13_2_OUT;  /**< \brief IfxGtm_ATOM2_7_TOUT93_P13_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_0N_TOUT101_P11_12_OUT;  /**< \brief IfxGtm_ATOM3_0N_TOUT101_P11_12_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_0N_TOUT17_P00_8_OUT;  /**< \brief IfxGtm_ATOM3_0N_TOUT17_P00_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_0N_TOUT25_P33_3_OUT;  /**< \brief IfxGtm_ATOM3_0N_TOUT25_P33_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_0N_TOUT32_P33_10_OUT;  /**< \brief IfxGtm_ATOM3_0N_TOUT32_P33_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_0N_TOUT37_P32_1_OUT;  /**< \brief IfxGtm_ATOM3_0N_TOUT37_P32_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_0N_TOUT63_P20_7_OUT;  /**< \brief IfxGtm_ATOM3_0N_TOUT63_P20_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_0N_TOUT76_P15_5_OUT;  /**< \brief IfxGtm_ATOM3_0N_TOUT76_P15_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_0_TOUT18_P00_9_OUT;  /**< \brief IfxGtm_ATOM3_0_TOUT18_P00_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_0_TOUT26_P33_4_OUT;  /**< \brief IfxGtm_ATOM3_0_TOUT26_P33_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_0_TOUT32_P33_10_OUT;  /**< \brief IfxGtm_ATOM3_0_TOUT32_P33_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_0_TOUT65_P20_9_OUT;  /**< \brief IfxGtm_ATOM3_0_TOUT65_P20_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_0_TOUT94_P13_3_OUT;  /**< \brief IfxGtm_ATOM3_0_TOUT94_P13_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1N_TOUT14_P00_5_OUT;  /**< \brief IfxGtm_ATOM3_1N_TOUT14_P00_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1N_TOUT22_P33_0_OUT;  /**< \brief IfxGtm_ATOM3_1N_TOUT22_P33_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1N_TOUT30_P33_8_OUT;  /**< \brief IfxGtm_ATOM3_1N_TOUT30_P33_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1N_TOUT34_P33_12_OUT;  /**< \brief IfxGtm_ATOM3_1N_TOUT34_P33_12_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1N_TOUT51_P21_0_OUT;  /**< \brief IfxGtm_ATOM3_1N_TOUT51_P21_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1N_TOUT79_P15_8_OUT;  /**< \brief IfxGtm_ATOM3_1N_TOUT79_P15_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1N_TOUT90_P14_10_OUT;  /**< \brief IfxGtm_ATOM3_1N_TOUT90_P14_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1N_TOUT91_P13_0_OUT;  /**< \brief IfxGtm_ATOM3_1N_TOUT91_P13_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1N_TOUT98_P11_9_OUT;  /**< \brief IfxGtm_ATOM3_1N_TOUT98_P11_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1_TOUT128_P12_0_OUT;  /**< \brief IfxGtm_ATOM3_1_TOUT128_P12_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1_TOUT19_P00_10_OUT;  /**< \brief IfxGtm_ATOM3_1_TOUT19_P00_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1_TOUT27_P33_5_OUT;  /**< \brief IfxGtm_ATOM3_1_TOUT27_P33_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1_TOUT43_P23_2_OUT;  /**< \brief IfxGtm_ATOM3_1_TOUT43_P23_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1_TOUT64_P20_8_OUT;  /**< \brief IfxGtm_ATOM3_1_TOUT64_P20_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1_TOUT90_P14_10_OUT;  /**< \brief IfxGtm_ATOM3_1_TOUT90_P14_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_1_TOUT95_P11_2_OUT;  /**< \brief IfxGtm_ATOM3_1_TOUT95_P11_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2N_TOUT15_P00_6_OUT;  /**< \brief IfxGtm_ATOM3_2N_TOUT15_P00_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2N_TOUT23_P33_1_OUT;  /**< \brief IfxGtm_ATOM3_2N_TOUT23_P33_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2N_TOUT31_P33_9_OUT;  /**< \brief IfxGtm_ATOM3_2N_TOUT31_P33_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2N_TOUT35_P33_13_OUT;  /**< \brief IfxGtm_ATOM3_2N_TOUT35_P33_13_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2N_TOUT52_P21_1_OUT;  /**< \brief IfxGtm_ATOM3_2N_TOUT52_P21_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2N_TOUT78_P15_7_OUT;  /**< \brief IfxGtm_ATOM3_2N_TOUT78_P15_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2N_TOUT91_P13_0_OUT;  /**< \brief IfxGtm_ATOM3_2N_TOUT91_P13_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2N_TOUT92_P13_1_OUT;  /**< \brief IfxGtm_ATOM3_2N_TOUT92_P13_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2N_TOUT99_P11_10_OUT;  /**< \brief IfxGtm_ATOM3_2N_TOUT99_P11_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2_TOUT20_P00_11_OUT;  /**< \brief IfxGtm_ATOM3_2_TOUT20_P00_11_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2_TOUT28_P33_6_OUT;  /**< \brief IfxGtm_ATOM3_2_TOUT28_P33_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2_TOUT44_P23_3_OUT;  /**< \brief IfxGtm_ATOM3_2_TOUT44_P23_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2_TOUT63_P20_7_OUT;  /**< \brief IfxGtm_ATOM3_2_TOUT63_P20_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2_TOUT88_P14_8_OUT;  /**< \brief IfxGtm_ATOM3_2_TOUT88_P14_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_2_TOUT96_P11_3_OUT;  /**< \brief IfxGtm_ATOM3_2_TOUT96_P11_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3N_TOUT100_P11_11_OUT;  /**< \brief IfxGtm_ATOM3_3N_TOUT100_P11_11_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3N_TOUT16_P00_7_OUT;  /**< \brief IfxGtm_ATOM3_3N_TOUT16_P00_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3N_TOUT24_P33_2_OUT;  /**< \brief IfxGtm_ATOM3_3N_TOUT24_P33_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3N_TOUT33_P33_11_OUT;  /**< \brief IfxGtm_ATOM3_3N_TOUT33_P33_11_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3N_TOUT36_P32_0_OUT;  /**< \brief IfxGtm_ATOM3_3N_TOUT36_P32_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3N_TOUT62_P20_6_OUT;  /**< \brief IfxGtm_ATOM3_3N_TOUT62_P20_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3N_TOUT77_P15_6_OUT;  /**< \brief IfxGtm_ATOM3_3N_TOUT77_P15_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3N_TOUT92_P13_1_OUT;  /**< \brief IfxGtm_ATOM3_3N_TOUT92_P13_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3N_TOUT93_P13_2_OUT;  /**< \brief IfxGtm_ATOM3_3N_TOUT93_P13_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3_TOUT21_P00_12_OUT;  /**< \brief IfxGtm_ATOM3_3_TOUT21_P00_12_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3_TOUT29_P33_7_OUT;  /**< \brief IfxGtm_ATOM3_3_TOUT29_P33_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3_TOUT62_P20_6_OUT;  /**< \brief IfxGtm_ATOM3_3_TOUT62_P20_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3_TOUT89_P14_9_OUT;  /**< \brief IfxGtm_ATOM3_3_TOUT89_P14_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_3_TOUT97_P11_6_OUT;  /**< \brief IfxGtm_ATOM3_3_TOUT97_P11_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_4N_TOUT21_P00_12_OUT;  /**< \brief IfxGtm_ATOM3_4N_TOUT21_P00_12_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_4N_TOUT29_P33_7_OUT;  /**< \brief IfxGtm_ATOM3_4N_TOUT29_P33_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_4N_TOUT57_P21_6_OUT;  /**< \brief IfxGtm_ATOM3_4N_TOUT57_P21_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_4N_TOUT86_P14_6_OUT;  /**< \brief IfxGtm_ATOM3_4N_TOUT86_P14_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_4N_TOUT97_P11_6_OUT;  /**< \brief IfxGtm_ATOM3_4N_TOUT97_P11_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_4_TOUT22_P33_0_OUT;  /**< \brief IfxGtm_ATOM3_4_TOUT22_P33_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_4_TOUT30_P33_8_OUT;  /**< \brief IfxGtm_ATOM3_4_TOUT30_P33_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_4_TOUT34_P33_12_OUT;  /**< \brief IfxGtm_ATOM3_4_TOUT34_P33_12_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_4_TOUT51_P21_0_OUT;  /**< \brief IfxGtm_ATOM3_4_TOUT51_P21_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_4_TOUT90_P14_10_OUT;  /**< \brief IfxGtm_ATOM3_4_TOUT90_P14_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_4_TOUT98_P11_9_OUT;  /**< \brief IfxGtm_ATOM3_4_TOUT98_P11_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_5N_TOUT120_P11_1_OUT;  /**< \brief IfxGtm_ATOM3_5N_TOUT120_P11_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_5N_TOUT18_P00_9_OUT;  /**< \brief IfxGtm_ATOM3_5N_TOUT18_P00_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_5N_TOUT26_P33_4_OUT;  /**< \brief IfxGtm_ATOM3_5N_TOUT26_P33_4_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_5N_TOUT59_P20_0_OUT;  /**< \brief IfxGtm_ATOM3_5N_TOUT59_P20_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_5N_TOUT87_P14_7_OUT;  /**< \brief IfxGtm_ATOM3_5N_TOUT87_P14_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_5N_TOUT94_P13_3_OUT;  /**< \brief IfxGtm_ATOM3_5N_TOUT94_P13_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_5_TOUT35_P33_13_OUT;  /**< \brief IfxGtm_ATOM3_5_TOUT35_P33_13_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_5_TOUT52_P21_1_OUT;  /**< \brief IfxGtm_ATOM3_5_TOUT52_P21_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_5_TOUT64_P20_8_OUT;  /**< \brief IfxGtm_ATOM3_5_TOUT64_P20_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_5_TOUT91_P13_0_OUT;  /**< \brief IfxGtm_ATOM3_5_TOUT91_P13_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_5_TOUT99_P11_10_OUT;  /**< \brief IfxGtm_ATOM3_5_TOUT99_P11_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_6N_TOUT19_P00_10_OUT;  /**< \brief IfxGtm_ATOM3_6N_TOUT19_P00_10_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_6N_TOUT27_P33_5_OUT;  /**< \brief IfxGtm_ATOM3_6N_TOUT27_P33_5_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_6N_TOUT60_P20_1_OUT;  /**< \brief IfxGtm_ATOM3_6N_TOUT60_P20_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_6N_TOUT88_P14_8_OUT;  /**< \brief IfxGtm_ATOM3_6N_TOUT88_P14_8_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_6N_TOUT95_P11_2_OUT;  /**< \brief IfxGtm_ATOM3_6N_TOUT95_P11_2_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_6_TOUT100_P11_11_OUT;  /**< \brief IfxGtm_ATOM3_6_TOUT100_P11_11_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_6_TOUT36_P32_0_OUT;  /**< \brief IfxGtm_ATOM3_6_TOUT36_P32_0_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_6_TOUT62_P20_6_OUT;  /**< \brief IfxGtm_ATOM3_6_TOUT62_P20_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_6_TOUT92_P13_1_OUT;  /**< \brief IfxGtm_ATOM3_6_TOUT92_P13_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_7N_TOUT20_P00_11_OUT;  /**< \brief IfxGtm_ATOM3_7N_TOUT20_P00_11_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_7N_TOUT28_P33_6_OUT;  /**< \brief IfxGtm_ATOM3_7N_TOUT28_P33_6_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_7N_TOUT61_P20_3_OUT;  /**< \brief IfxGtm_ATOM3_7N_TOUT61_P20_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_7N_TOUT89_P14_9_OUT;  /**< \brief IfxGtm_ATOM3_7N_TOUT89_P14_9_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_7N_TOUT96_P11_3_OUT;  /**< \brief IfxGtm_ATOM3_7N_TOUT96_P11_3_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_7_TOUT101_P11_12_OUT;  /**< \brief IfxGtm_ATOM3_7_TOUT101_P11_12_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_7_TOUT37_P32_1_OUT;  /**< \brief IfxGtm_ATOM3_7_TOUT37_P32_1_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_7_TOUT63_P20_7_OUT;  /**< \brief IfxGtm_ATOM3_7_TOUT63_P20_7_OUT */
IFX_EXTERN IfxGtm_Atom_ToutMap IfxGtm_ATOM3_7_TOUT93_P13_2_OUT;  /**< \brief IfxGtm_ATOM3_7_TOUT93_P13_2_OUT */
IFX_EXTERN IfxGtm_Clk_Out IfxGtm_CLK0_P23_1_OUT;  /**< \brief CGM generated clock */
IFX_EXTERN IfxGtm_Clk_Out IfxGtm_CLK1_P32_4_OUT;  /**< \brief CGM generated clock */
IFX_EXTERN IfxGtm_Clk_Out IfxGtm_CLK2_P11_12_OUT;  /**< \brief CGM generated clock */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_0_P00_9_IN;  /**< \brief IfxGtm_TIM0_0_P00_9_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_0_P02_0_IN;  /**< \brief IfxGtm_TIM0_0_P02_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_0_P10_7_IN;  /**< \brief IfxGtm_TIM0_0_P10_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_0_P14_5_IN;  /**< \brief IfxGtm_TIM0_0_P14_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_0_P14_7_IN;  /**< \brief IfxGtm_TIM0_0_P14_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_0_P15_6_IN;  /**< \brief IfxGtm_TIM0_0_P15_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_0_P21_2_IN;  /**< \brief IfxGtm_TIM0_0_P21_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_0_P22_1_IN;  /**< \brief IfxGtm_TIM0_0_P22_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_0_P33_10_IN;  /**< \brief IfxGtm_TIM0_0_P33_10_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_0_P33_4_IN;  /**< \brief IfxGtm_TIM0_0_P33_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_1_P00_10_IN;  /**< \brief IfxGtm_TIM0_1_P00_10_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_1_P02_1_IN;  /**< \brief IfxGtm_TIM0_1_P02_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_1_P10_1_IN;  /**< \brief IfxGtm_TIM0_1_P10_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_1_P14_6_IN;  /**< \brief IfxGtm_TIM0_1_P14_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_1_P15_7_IN;  /**< \brief IfxGtm_TIM0_1_P15_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_1_P21_3_IN;  /**< \brief IfxGtm_TIM0_1_P21_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_1_P22_0_IN;  /**< \brief IfxGtm_TIM0_1_P22_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_1_P33_5_IN;  /**< \brief IfxGtm_TIM0_1_P33_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_1_P33_9_IN;  /**< \brief IfxGtm_TIM0_1_P33_9_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_2_P00_11_IN;  /**< \brief IfxGtm_TIM0_2_P00_11_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_2_P02_2_IN;  /**< \brief IfxGtm_TIM0_2_P02_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_2_P10_2_IN;  /**< \brief IfxGtm_TIM0_2_P10_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_2_P10_5_IN;  /**< \brief IfxGtm_TIM0_2_P10_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_2_P15_8_IN;  /**< \brief IfxGtm_TIM0_2_P15_8_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_2_P21_4_IN;  /**< \brief IfxGtm_TIM0_2_P21_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_2_P23_5_IN;  /**< \brief IfxGtm_TIM0_2_P23_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_2_P33_11_IN;  /**< \brief IfxGtm_TIM0_2_P33_11_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_2_P33_6_IN;  /**< \brief IfxGtm_TIM0_2_P33_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_3_P00_12_IN;  /**< \brief IfxGtm_TIM0_3_P00_12_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_3_P02_3_IN;  /**< \brief IfxGtm_TIM0_3_P02_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_3_P10_3_IN;  /**< \brief IfxGtm_TIM0_3_P10_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_3_P10_6_IN;  /**< \brief IfxGtm_TIM0_3_P10_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_3_P14_0_IN;  /**< \brief IfxGtm_TIM0_3_P14_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_3_P21_5_IN;  /**< \brief IfxGtm_TIM0_3_P21_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_3_P22_2_IN;  /**< \brief IfxGtm_TIM0_3_P22_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_3_P32_2_IN;  /**< \brief IfxGtm_TIM0_3_P32_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_3_P33_7_IN;  /**< \brief IfxGtm_TIM0_3_P33_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_4_P02_4_IN;  /**< \brief IfxGtm_TIM0_4_P02_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_4_P10_0_IN;  /**< \brief IfxGtm_TIM0_4_P10_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_4_P14_1_IN;  /**< \brief IfxGtm_TIM0_4_P14_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_4_P21_6_IN;  /**< \brief IfxGtm_TIM0_4_P21_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_4_P22_3_IN;  /**< \brief IfxGtm_TIM0_4_P22_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_4_P32_3_IN;  /**< \brief IfxGtm_TIM0_4_P32_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_4_P33_0_IN;  /**< \brief IfxGtm_TIM0_4_P33_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_4_P33_8_IN;  /**< \brief IfxGtm_TIM0_4_P33_8_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_5_P02_5_IN;  /**< \brief IfxGtm_TIM0_5_P02_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_5_P10_8_IN;  /**< \brief IfxGtm_TIM0_5_P10_8_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_5_P14_2_IN;  /**< \brief IfxGtm_TIM0_5_P14_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_5_P21_7_IN;  /**< \brief IfxGtm_TIM0_5_P21_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_5_P23_0_IN;  /**< \brief IfxGtm_TIM0_5_P23_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_5_P32_4_IN;  /**< \brief IfxGtm_TIM0_5_P32_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_5_P33_1_IN;  /**< \brief IfxGtm_TIM0_5_P33_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_6_P02_6_IN;  /**< \brief IfxGtm_TIM0_6_P02_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_6_P10_4_IN;  /**< \brief IfxGtm_TIM0_6_P10_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_6_P14_3_IN;  /**< \brief IfxGtm_TIM0_6_P14_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_6_P20_0_IN;  /**< \brief IfxGtm_TIM0_6_P20_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_6_P23_1_IN;  /**< \brief IfxGtm_TIM0_6_P23_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_6_P23_2_IN;  /**< \brief IfxGtm_TIM0_6_P23_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_6_P33_2_IN;  /**< \brief IfxGtm_TIM0_6_P33_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_7_P02_7_IN;  /**< \brief IfxGtm_TIM0_7_P02_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_7_P11_15_IN;  /**< \brief IfxGtm_TIM0_7_P11_15_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_7_P14_4_IN;  /**< \brief IfxGtm_TIM0_7_P14_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_7_P20_8_IN;  /**< \brief IfxGtm_TIM0_7_P20_8_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_7_P23_3_IN;  /**< \brief IfxGtm_TIM0_7_P23_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_7_P23_4_IN;  /**< \brief IfxGtm_TIM0_7_P23_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM0_7_P33_3_IN;  /**< \brief IfxGtm_TIM0_7_P33_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_0_P00_9_IN;  /**< \brief IfxGtm_TIM1_0_P00_9_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_0_P02_0_IN;  /**< \brief IfxGtm_TIM1_0_P02_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_0_P10_7_IN;  /**< \brief IfxGtm_TIM1_0_P10_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_0_P14_5_IN;  /**< \brief IfxGtm_TIM1_0_P14_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_0_P14_7_IN;  /**< \brief IfxGtm_TIM1_0_P14_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_0_P15_6_IN;  /**< \brief IfxGtm_TIM1_0_P15_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_0_P21_2_IN;  /**< \brief IfxGtm_TIM1_0_P21_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_0_P22_1_IN;  /**< \brief IfxGtm_TIM1_0_P22_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_0_P33_10_IN;  /**< \brief IfxGtm_TIM1_0_P33_10_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_0_P33_4_IN;  /**< \brief IfxGtm_TIM1_0_P33_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_1_P00_10_IN;  /**< \brief IfxGtm_TIM1_1_P00_10_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_1_P02_1_IN;  /**< \brief IfxGtm_TIM1_1_P02_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_1_P10_1_IN;  /**< \brief IfxGtm_TIM1_1_P10_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_1_P14_6_IN;  /**< \brief IfxGtm_TIM1_1_P14_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_1_P15_7_IN;  /**< \brief IfxGtm_TIM1_1_P15_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_1_P21_3_IN;  /**< \brief IfxGtm_TIM1_1_P21_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_1_P22_0_IN;  /**< \brief IfxGtm_TIM1_1_P22_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_1_P33_5_IN;  /**< \brief IfxGtm_TIM1_1_P33_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_1_P33_9_IN;  /**< \brief IfxGtm_TIM1_1_P33_9_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_2_P00_11_IN;  /**< \brief IfxGtm_TIM1_2_P00_11_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_2_P02_2_IN;  /**< \brief IfxGtm_TIM1_2_P02_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_2_P10_2_IN;  /**< \brief IfxGtm_TIM1_2_P10_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_2_P10_5_IN;  /**< \brief IfxGtm_TIM1_2_P10_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_2_P15_8_IN;  /**< \brief IfxGtm_TIM1_2_P15_8_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_2_P21_4_IN;  /**< \brief IfxGtm_TIM1_2_P21_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_2_P23_5_IN;  /**< \brief IfxGtm_TIM1_2_P23_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_2_P33_11_IN;  /**< \brief IfxGtm_TIM1_2_P33_11_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_2_P33_6_IN;  /**< \brief IfxGtm_TIM1_2_P33_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_3_P00_12_IN;  /**< \brief IfxGtm_TIM1_3_P00_12_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_3_P02_3_IN;  /**< \brief IfxGtm_TIM1_3_P02_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_3_P10_3_IN;  /**< \brief IfxGtm_TIM1_3_P10_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_3_P10_6_IN;  /**< \brief IfxGtm_TIM1_3_P10_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_3_P14_0_IN;  /**< \brief IfxGtm_TIM1_3_P14_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_3_P21_5_IN;  /**< \brief IfxGtm_TIM1_3_P21_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_3_P22_2_IN;  /**< \brief IfxGtm_TIM1_3_P22_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_3_P32_2_IN;  /**< \brief IfxGtm_TIM1_3_P32_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_3_P33_7_IN;  /**< \brief IfxGtm_TIM1_3_P33_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_4_P02_4_IN;  /**< \brief IfxGtm_TIM1_4_P02_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_4_P10_0_IN;  /**< \brief IfxGtm_TIM1_4_P10_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_4_P14_1_IN;  /**< \brief IfxGtm_TIM1_4_P14_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_4_P20_0_IN;  /**< \brief IfxGtm_TIM1_4_P20_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_4_P21_6_IN;  /**< \brief IfxGtm_TIM1_4_P21_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_4_P22_3_IN;  /**< \brief IfxGtm_TIM1_4_P22_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_4_P32_3_IN;  /**< \brief IfxGtm_TIM1_4_P32_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_4_P33_0_IN;  /**< \brief IfxGtm_TIM1_4_P33_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_4_P33_8_IN;  /**< \brief IfxGtm_TIM1_4_P33_8_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_5_P02_5_IN;  /**< \brief IfxGtm_TIM1_5_P02_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_5_P10_8_IN;  /**< \brief IfxGtm_TIM1_5_P10_8_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_5_P14_2_IN;  /**< \brief IfxGtm_TIM1_5_P14_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_5_P20_7_IN;  /**< \brief IfxGtm_TIM1_5_P20_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_5_P21_7_IN;  /**< \brief IfxGtm_TIM1_5_P21_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_5_P23_0_IN;  /**< \brief IfxGtm_TIM1_5_P23_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_5_P32_4_IN;  /**< \brief IfxGtm_TIM1_5_P32_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_5_P33_1_IN;  /**< \brief IfxGtm_TIM1_5_P33_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_6_P02_6_IN;  /**< \brief IfxGtm_TIM1_6_P02_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_6_P10_4_IN;  /**< \brief IfxGtm_TIM1_6_P10_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_6_P14_3_IN;  /**< \brief IfxGtm_TIM1_6_P14_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_6_P20_0_IN;  /**< \brief IfxGtm_TIM1_6_P20_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_6_P23_1_IN;  /**< \brief IfxGtm_TIM1_6_P23_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_6_P23_2_IN;  /**< \brief IfxGtm_TIM1_6_P23_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_6_P33_2_IN;  /**< \brief IfxGtm_TIM1_6_P33_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_7_P02_7_IN;  /**< \brief IfxGtm_TIM1_7_P02_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_7_P14_4_IN;  /**< \brief IfxGtm_TIM1_7_P14_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_7_P20_8_IN;  /**< \brief IfxGtm_TIM1_7_P20_8_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_7_P23_3_IN;  /**< \brief IfxGtm_TIM1_7_P23_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_7_P23_4_IN;  /**< \brief IfxGtm_TIM1_7_P23_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM1_7_P33_3_IN;  /**< \brief IfxGtm_TIM1_7_P33_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_0_P00_0_IN;  /**< \brief IfxGtm_TIM2_0_P00_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_0_P02_8_IN;  /**< \brief IfxGtm_TIM2_0_P02_8_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_0_P11_0_IN;  /**< \brief IfxGtm_TIM2_0_P11_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_0_P11_10_IN;  /**< \brief IfxGtm_TIM2_0_P11_10_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_0_P13_3_IN;  /**< \brief IfxGtm_TIM2_0_P13_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_0_P15_5_IN;  /**< \brief IfxGtm_TIM2_0_P15_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_0_P20_12_IN;  /**< \brief IfxGtm_TIM2_0_P20_12_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_0_P33_12_IN;  /**< \brief IfxGtm_TIM2_0_P33_12_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_1_P00_1_IN;  /**< \brief IfxGtm_TIM2_1_P00_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_1_P00_2_IN;  /**< \brief IfxGtm_TIM2_1_P00_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_1_P11_1_IN;  /**< \brief IfxGtm_TIM2_1_P11_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_1_P11_2_IN;  /**< \brief IfxGtm_TIM2_1_P11_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_1_P20_13_IN;  /**< \brief IfxGtm_TIM2_1_P20_13_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_1_P33_13_IN;  /**< \brief IfxGtm_TIM2_1_P33_13_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_2_P00_3_IN;  /**< \brief IfxGtm_TIM2_2_P00_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_2_P11_3_IN;  /**< \brief IfxGtm_TIM2_2_P11_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_2_P11_4_IN;  /**< \brief IfxGtm_TIM2_2_P11_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_2_P14_8_IN;  /**< \brief IfxGtm_TIM2_2_P14_8_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_2_P15_6_IN;  /**< \brief IfxGtm_TIM2_2_P15_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_2_P20_14_IN;  /**< \brief IfxGtm_TIM2_2_P20_14_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_2_P32_0_IN;  /**< \brief IfxGtm_TIM2_2_P32_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_3_P00_4_IN;  /**< \brief IfxGtm_TIM2_3_P00_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_3_P11_5_IN;  /**< \brief IfxGtm_TIM2_3_P11_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_3_P11_6_IN;  /**< \brief IfxGtm_TIM2_3_P11_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_3_P14_9_IN;  /**< \brief IfxGtm_TIM2_3_P14_9_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_3_P15_0_IN;  /**< \brief IfxGtm_TIM2_3_P15_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_3_P20_1_IN;  /**< \brief IfxGtm_TIM2_3_P20_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_4_P00_5_IN;  /**< \brief IfxGtm_TIM2_4_P00_5_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_4_P11_7_IN;  /**< \brief IfxGtm_TIM2_4_P11_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_4_P11_9_IN;  /**< \brief IfxGtm_TIM2_4_P11_9_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_4_P14_10_IN;  /**< \brief IfxGtm_TIM2_4_P14_10_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_4_P15_1_IN;  /**< \brief IfxGtm_TIM2_4_P15_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_4_P20_3_IN;  /**< \brief IfxGtm_TIM2_4_P20_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_4_P21_0_IN;  /**< \brief IfxGtm_TIM2_4_P21_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_5_P00_6_IN;  /**< \brief IfxGtm_TIM2_5_P00_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_5_P11_10_IN;  /**< \brief IfxGtm_TIM2_5_P11_10_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_5_P11_8_IN;  /**< \brief IfxGtm_TIM2_5_P11_8_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_5_P13_0_IN;  /**< \brief IfxGtm_TIM2_5_P13_0_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_5_P15_2_IN;  /**< \brief IfxGtm_TIM2_5_P15_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_5_P20_9_IN;  /**< \brief IfxGtm_TIM2_5_P20_9_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_5_P21_1_IN;  /**< \brief IfxGtm_TIM2_5_P21_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_6_P00_7_IN;  /**< \brief IfxGtm_TIM2_6_P00_7_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_6_P11_11_IN;  /**< \brief IfxGtm_TIM2_6_P11_11_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_6_P11_13_IN;  /**< \brief IfxGtm_TIM2_6_P11_13_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_6_P13_1_IN;  /**< \brief IfxGtm_TIM2_6_P13_1_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_6_P15_3_IN;  /**< \brief IfxGtm_TIM2_6_P15_3_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_6_P20_10_IN;  /**< \brief IfxGtm_TIM2_6_P20_10_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_6_P20_6_IN;  /**< \brief IfxGtm_TIM2_6_P20_6_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_7_P00_8_IN;  /**< \brief IfxGtm_TIM2_7_P00_8_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_7_P11_12_IN;  /**< \brief IfxGtm_TIM2_7_P11_12_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_7_P11_14_IN;  /**< \brief IfxGtm_TIM2_7_P11_14_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_7_P13_2_IN;  /**< \brief IfxGtm_TIM2_7_P13_2_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_7_P15_4_IN;  /**< \brief IfxGtm_TIM2_7_P15_4_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_7_P20_11_IN;  /**< \brief IfxGtm_TIM2_7_P20_11_IN */
IFX_EXTERN IfxGtm_Tim_TinMap IfxGtm_TIM2_7_P20_7_IN;  /**< \brief IfxGtm_TIM2_7_P20_7_IN */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0N_TOUT106_P10_4_OUT;  /**< \brief IfxGtm_TOM0_0N_TOUT106_P10_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0N_TOUT17_P00_8_OUT;  /**< \brief IfxGtm_TOM0_0N_TOUT17_P00_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0N_TOUT25_P33_3_OUT;  /**< \brief IfxGtm_TOM0_0N_TOUT25_P33_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0N_TOUT34_P33_12_OUT;  /**< \brief IfxGtm_TOM0_0N_TOUT34_P33_12_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0N_TOUT51_P21_0_OUT;  /**< \brief IfxGtm_TOM0_0N_TOUT51_P21_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0N_TOUT61_P20_3_OUT;  /**< \brief IfxGtm_TOM0_0N_TOUT61_P20_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0N_TOUT72_P15_1_OUT;  /**< \brief IfxGtm_TOM0_0N_TOUT72_P15_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0N_TOUT7_P02_7_OUT;  /**< \brief IfxGtm_TOM0_0N_TOUT7_P02_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0N_TOUT91_P13_0_OUT;  /**< \brief IfxGtm_TOM0_0N_TOUT91_P13_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0N_TOUT9_P00_0_OUT;  /**< \brief IfxGtm_TOM0_0N_TOUT9_P00_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0_TOUT0_P02_0_OUT;  /**< \brief IfxGtm_TOM0_0_TOUT0_P02_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0_TOUT109_P10_7_OUT;  /**< \brief IfxGtm_TOM0_0_TOUT109_P10_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0_TOUT18_P00_9_OUT;  /**< \brief IfxGtm_TOM0_0_TOUT18_P00_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0_TOUT26_P33_4_OUT;  /**< \brief IfxGtm_TOM0_0_TOUT26_P33_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0_TOUT32_P33_10_OUT;  /**< \brief IfxGtm_TOM0_0_TOUT32_P33_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0_TOUT53_P21_2_OUT;  /**< \brief IfxGtm_TOM0_0_TOUT53_P21_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0_TOUT76_P15_5_OUT;  /**< \brief IfxGtm_TOM0_0_TOUT76_P15_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0_TOUT77_P15_6_OUT;  /**< \brief IfxGtm_TOM0_0_TOUT77_P15_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0_TOUT85_P14_5_OUT;  /**< \brief IfxGtm_TOM0_0_TOUT85_P14_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_0_TOUT87_P14_7_OUT;  /**< \brief IfxGtm_TOM0_0_TOUT87_P14_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_10_TOUT12_P00_3_OUT;  /**< \brief IfxGtm_TOM0_10_TOUT12_P00_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_10_TOUT2_P02_2_OUT;  /**< \brief IfxGtm_TOM0_10_TOUT2_P02_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_10_TOUT41_P23_0_OUT;  /**< \brief IfxGtm_TOM0_10_TOUT41_P23_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_10_TOUT46_P23_5_OUT;  /**< \brief IfxGtm_TOM0_10_TOUT46_P23_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_10_TOUT96_P11_3_OUT;  /**< \brief IfxGtm_TOM0_10_TOUT96_P11_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_11_TOUT13_P00_4_OUT;  /**< \brief IfxGtm_TOM0_11_TOUT13_P00_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_11_TOUT3_P02_3_OUT;  /**< \brief IfxGtm_TOM0_11_TOUT3_P02_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_11_TOUT43_P23_2_OUT;  /**< \brief IfxGtm_TOM0_11_TOUT43_P23_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_11_TOUT49_P22_2_OUT;  /**< \brief IfxGtm_TOM0_11_TOUT49_P22_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_11_TOUT97_P11_6_OUT;  /**< \brief IfxGtm_TOM0_11_TOUT97_P11_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_12_TOUT14_P00_5_OUT;  /**< \brief IfxGtm_TOM0_12_TOUT14_P00_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_12_TOUT44_P23_3_OUT;  /**< \brief IfxGtm_TOM0_12_TOUT44_P23_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_12_TOUT4_P02_4_OUT;  /**< \brief IfxGtm_TOM0_12_TOUT4_P02_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_12_TOUT50_P22_3_OUT;  /**< \brief IfxGtm_TOM0_12_TOUT50_P22_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_12_TOUT98_P11_9_OUT;  /**< \brief IfxGtm_TOM0_12_TOUT98_P11_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_13_TOUT15_P00_6_OUT;  /**< \brief IfxGtm_TOM0_13_TOUT15_P00_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_13_TOUT5_P02_5_OUT;  /**< \brief IfxGtm_TOM0_13_TOUT5_P02_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_13_TOUT99_P11_10_OUT;  /**< \brief IfxGtm_TOM0_13_TOUT99_P11_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_14_TOUT100_P11_11_OUT;  /**< \brief IfxGtm_TOM0_14_TOUT100_P11_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_14_TOUT16_P00_7_OUT;  /**< \brief IfxGtm_TOM0_14_TOUT16_P00_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_14_TOUT6_P02_6_OUT;  /**< \brief IfxGtm_TOM0_14_TOUT6_P02_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_15_TOUT101_P11_12_OUT;  /**< \brief IfxGtm_TOM0_15_TOUT101_P11_12_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_15_TOUT17_P00_8_OUT;  /**< \brief IfxGtm_TOM0_15_TOUT17_P00_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_15_TOUT42_P23_1_OUT;  /**< \brief IfxGtm_TOM0_15_TOUT42_P23_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_15_TOUT7_P02_7_OUT;  /**< \brief IfxGtm_TOM0_15_TOUT7_P02_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT107_P10_5_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT107_P10_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT10_P00_1_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT10_P00_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT14_P00_5_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT14_P00_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT22_P33_0_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT22_P33_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT30_P33_8_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT30_P33_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT35_P33_13_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT35_P33_13_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT39_P32_3_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT39_P32_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT4_P02_4_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT4_P02_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT52_P21_1_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT52_P21_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT57_P21_6_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT57_P21_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT73_P15_2_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT73_P15_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT90_P14_10_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT90_P14_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1N_TOUT92_P13_1_OUT;  /**< \brief IfxGtm_TOM0_1N_TOUT92_P13_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1_TOUT103_P10_1_OUT;  /**< \brief IfxGtm_TOM0_1_TOUT103_P10_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1_TOUT19_P00_10_OUT;  /**< \brief IfxGtm_TOM0_1_TOUT19_P00_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1_TOUT1_P02_1_OUT;  /**< \brief IfxGtm_TOM0_1_TOUT1_P02_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1_TOUT27_P33_5_OUT;  /**< \brief IfxGtm_TOM0_1_TOUT27_P33_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1_TOUT31_P33_9_OUT;  /**< \brief IfxGtm_TOM0_1_TOUT31_P33_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1_TOUT54_P21_3_OUT;  /**< \brief IfxGtm_TOM0_1_TOUT54_P21_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1_TOUT78_P15_7_OUT;  /**< \brief IfxGtm_TOM0_1_TOUT78_P15_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_1_TOUT86_P14_6_OUT;  /**< \brief IfxGtm_TOM0_1_TOUT86_P14_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2N_TOUT108_P10_6_OUT;  /**< \brief IfxGtm_TOM0_2N_TOUT108_P10_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2N_TOUT11_P00_2_OUT;  /**< \brief IfxGtm_TOM0_2N_TOUT11_P00_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2N_TOUT15_P00_6_OUT;  /**< \brief IfxGtm_TOM0_2N_TOUT15_P00_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2N_TOUT23_P33_1_OUT;  /**< \brief IfxGtm_TOM0_2N_TOUT23_P33_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2N_TOUT40_P32_4_OUT;  /**< \brief IfxGtm_TOM0_2N_TOUT40_P32_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2N_TOUT58_P21_7_OUT;  /**< \brief IfxGtm_TOM0_2N_TOUT58_P21_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2N_TOUT5_P02_5_OUT;  /**< \brief IfxGtm_TOM0_2N_TOUT5_P02_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2N_TOUT74_P15_3_OUT;  /**< \brief IfxGtm_TOM0_2N_TOUT74_P15_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2N_TOUT93_P13_2_OUT;  /**< \brief IfxGtm_TOM0_2N_TOUT93_P13_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2_TOUT104_P10_2_OUT;  /**< \brief IfxGtm_TOM0_2_TOUT104_P10_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2_TOUT107_P10_5_OUT;  /**< \brief IfxGtm_TOM0_2_TOUT107_P10_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2_TOUT20_P00_11_OUT;  /**< \brief IfxGtm_TOM0_2_TOUT20_P00_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2_TOUT28_P33_6_OUT;  /**< \brief IfxGtm_TOM0_2_TOUT28_P33_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2_TOUT2_P02_2_OUT;  /**< \brief IfxGtm_TOM0_2_TOUT2_P02_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2_TOUT33_P33_11_OUT;  /**< \brief IfxGtm_TOM0_2_TOUT33_P33_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2_TOUT55_P21_4_OUT;  /**< \brief IfxGtm_TOM0_2_TOUT55_P21_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2_TOUT79_P15_8_OUT;  /**< \brief IfxGtm_TOM0_2_TOUT79_P15_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_2_TOUT88_P14_8_OUT;  /**< \brief IfxGtm_TOM0_2_TOUT88_P14_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3N_TOUT109_P10_7_OUT;  /**< \brief IfxGtm_TOM0_3N_TOUT109_P10_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3N_TOUT12_P00_3_OUT;  /**< \brief IfxGtm_TOM0_3N_TOUT12_P00_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3N_TOUT16_P00_7_OUT;  /**< \brief IfxGtm_TOM0_3N_TOUT16_P00_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3N_TOUT24_P33_2_OUT;  /**< \brief IfxGtm_TOM0_3N_TOUT24_P33_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3N_TOUT42_P23_1_OUT;  /**< \brief IfxGtm_TOM0_3N_TOUT42_P23_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3N_TOUT59_P20_0_OUT;  /**< \brief IfxGtm_TOM0_3N_TOUT59_P20_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3N_TOUT60_P20_1_OUT;  /**< \brief IfxGtm_TOM0_3N_TOUT60_P20_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3N_TOUT6_P02_6_OUT;  /**< \brief IfxGtm_TOM0_3N_TOUT6_P02_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3N_TOUT75_P15_4_OUT;  /**< \brief IfxGtm_TOM0_3N_TOUT75_P15_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3N_TOUT94_P13_3_OUT;  /**< \brief IfxGtm_TOM0_3N_TOUT94_P13_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3_TOUT105_P10_3_OUT;  /**< \brief IfxGtm_TOM0_3_TOUT105_P10_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3_TOUT108_P10_6_OUT;  /**< \brief IfxGtm_TOM0_3_TOUT108_P10_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3_TOUT21_P00_12_OUT;  /**< \brief IfxGtm_TOM0_3_TOUT21_P00_12_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3_TOUT29_P33_7_OUT;  /**< \brief IfxGtm_TOM0_3_TOUT29_P33_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3_TOUT38_P32_2_OUT;  /**< \brief IfxGtm_TOM0_3_TOUT38_P32_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3_TOUT3_P02_3_OUT;  /**< \brief IfxGtm_TOM0_3_TOUT3_P02_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3_TOUT56_P21_5_OUT;  /**< \brief IfxGtm_TOM0_3_TOUT56_P21_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3_TOUT71_P15_0_OUT;  /**< \brief IfxGtm_TOM0_3_TOUT71_P15_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3_TOUT80_P14_0_OUT;  /**< \brief IfxGtm_TOM0_3_TOUT80_P14_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_3_TOUT89_P14_9_OUT;  /**< \brief IfxGtm_TOM0_3_TOUT89_P14_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4N_TOUT10_P00_1_OUT;  /**< \brief IfxGtm_TOM0_4N_TOUT10_P00_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4N_TOUT1_P02_1_OUT;  /**< \brief IfxGtm_TOM0_4N_TOUT1_P02_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4N_TOUT29_P33_7_OUT;  /**< \brief IfxGtm_TOM0_4N_TOUT29_P33_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4N_TOUT36_P32_0_OUT;  /**< \brief IfxGtm_TOM0_4N_TOUT36_P32_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4N_TOUT54_P21_3_OUT;  /**< \brief IfxGtm_TOM0_4N_TOUT54_P21_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4N_TOUT56_P21_5_OUT;  /**< \brief IfxGtm_TOM0_4N_TOUT56_P21_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4N_TOUT65_P20_9_OUT;  /**< \brief IfxGtm_TOM0_4N_TOUT65_P20_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4N_TOUT73_P15_2_OUT;  /**< \brief IfxGtm_TOM0_4N_TOUT73_P15_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4N_TOUT89_P14_9_OUT;  /**< \brief IfxGtm_TOM0_4N_TOUT89_P14_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4N_TOUT8_P02_8_OUT;  /**< \brief IfxGtm_TOM0_4N_TOUT8_P02_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4N_TOUT95_P11_2_OUT;  /**< \brief IfxGtm_TOM0_4N_TOUT95_P11_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4N_TOUT96_P11_3_OUT;  /**< \brief IfxGtm_TOM0_4N_TOUT96_P11_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT0_P02_0_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT0_P02_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT102_P10_0_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT102_P10_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT124_P11_8_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT124_P11_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT22_P33_0_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT22_P33_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT30_P33_8_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT30_P33_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT37_P32_1_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT37_P32_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT39_P32_3_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT39_P32_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT53_P21_2_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT53_P21_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT57_P21_6_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT57_P21_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT64_P20_8_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT64_P20_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT72_P15_1_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT72_P15_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT81_P14_1_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT81_P14_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT90_P14_10_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT90_P14_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT94_P13_3_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT94_P13_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_4_TOUT9_P00_0_OUT;  /**< \brief IfxGtm_TOM0_4_TOUT9_P00_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT121_P11_4_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT121_P11_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT12_P00_3_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT12_P00_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT26_P33_4_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT26_P33_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT28_P33_6_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT28_P33_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT32_P33_10_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT32_P33_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT37_P32_1_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT37_P32_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT3_P02_3_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT3_P02_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT53_P21_2_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT53_P21_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT56_P21_5_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT56_P21_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT67_P20_11_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT67_P20_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT76_P15_5_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT76_P15_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT77_P15_6_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT77_P15_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT87_P14_7_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT87_P14_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5N_TOUT97_P11_6_OUT;  /**< \brief IfxGtm_TOM0_5N_TOUT97_P11_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT110_P10_8_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT110_P10_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT11_P00_2_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT11_P00_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT128_P12_0_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT128_P12_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT23_P33_1_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT23_P33_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT27_P33_5_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT27_P33_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT2_P02_2_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT2_P02_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT40_P32_4_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT40_P32_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT55_P21_4_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT55_P21_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT58_P21_7_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT58_P21_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT66_P20_10_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT66_P20_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT74_P15_3_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT74_P15_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT82_P14_2_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT82_P14_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT91_P13_0_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT91_P13_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_5_TOUT96_P11_3_OUT;  /**< \brief IfxGtm_TOM0_5_TOUT96_P11_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT14_P00_5_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT14_P00_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT27_P33_5_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT27_P33_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT30_P33_8_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT30_P33_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT31_P33_9_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT31_P33_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT38_P32_2_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT38_P32_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT40_P32_4_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT40_P32_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT49_P22_2_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT49_P22_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT54_P21_3_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT54_P21_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT5_P02_5_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT5_P02_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT69_P20_13_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT69_P20_13_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT78_P15_7_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT78_P15_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT82_P14_2_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT82_P14_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT86_P14_6_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT86_P14_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT91_P13_0_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT91_P13_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT97_P11_6_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT97_P11_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6N_TOUT99_P11_10_OUT;  /**< \brief IfxGtm_TOM0_6N_TOUT99_P11_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT106_P10_4_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT106_P10_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT129_P12_1_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT129_P12_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT13_P00_4_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT13_P00_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT24_P33_2_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT24_P33_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT29_P33_7_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT29_P33_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT42_P23_1_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT42_P23_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT48_P22_1_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT48_P22_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT4_P02_4_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT4_P02_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT59_P20_0_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT59_P20_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT68_P20_12_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT68_P20_12_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT80_P14_0_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT80_P14_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT83_P14_3_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT83_P14_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT92_P13_1_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT92_P13_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_6_TOUT98_P11_9_OUT;  /**< \brief IfxGtm_TOM0_6_TOUT98_P11_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT100_P11_11_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT100_P11_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT123_P11_7_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT123_P11_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT16_P00_7_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT16_P00_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT28_P33_6_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT28_P33_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT32_P33_10_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT32_P33_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT33_P33_11_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT33_P33_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT39_P32_3_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT39_P32_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT42_P23_1_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT42_P23_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT55_P21_4_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT55_P21_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT71_P15_0_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT71_P15_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT79_P15_8_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT79_P15_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT7_P02_7_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT7_P02_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT84_P14_4_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT84_P14_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT88_P14_8_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT88_P14_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7N_TOUT93_P13_2_OUT;  /**< \brief IfxGtm_TOM0_7N_TOUT93_P13_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT101_P11_12_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT101_P11_12_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT119_P11_0_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT119_P11_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT15_P00_6_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT15_P00_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT25_P33_3_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT25_P33_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT31_P33_9_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT31_P33_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT45_P23_4_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT45_P23_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT50_P22_3_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT50_P22_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT6_P02_6_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT6_P02_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT70_P20_14_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT70_P20_14_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT81_P14_1_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT81_P14_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT84_P14_4_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT84_P14_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT92_P13_1_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT92_P13_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_7_TOUT93_P13_2_OUT;  /**< \brief IfxGtm_TOM0_7_TOUT93_P13_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_8_TOUT0_P02_0_OUT;  /**< \brief IfxGtm_TOM0_8_TOUT0_P02_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_8_TOUT48_P22_1_OUT;  /**< \brief IfxGtm_TOM0_8_TOUT48_P22_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_8_TOUT51_P21_0_OUT;  /**< \brief IfxGtm_TOM0_8_TOUT51_P21_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_8_TOUT8_P02_8_OUT;  /**< \brief IfxGtm_TOM0_8_TOUT8_P02_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_8_TOUT94_P13_3_OUT;  /**< \brief IfxGtm_TOM0_8_TOUT94_P13_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_8_TOUT95_P11_2_OUT;  /**< \brief IfxGtm_TOM0_8_TOUT95_P11_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_8_TOUT9_P00_0_OUT;  /**< \brief IfxGtm_TOM0_8_TOUT9_P00_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_9_TOUT10_P00_1_OUT;  /**< \brief IfxGtm_TOM0_9_TOUT10_P00_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_9_TOUT11_P00_2_OUT;  /**< \brief IfxGtm_TOM0_9_TOUT11_P00_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_9_TOUT1_P02_1_OUT;  /**< \brief IfxGtm_TOM0_9_TOUT1_P02_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_9_TOUT47_P22_0_OUT;  /**< \brief IfxGtm_TOM0_9_TOUT47_P22_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM0_9_TOUT52_P21_1_OUT;  /**< \brief IfxGtm_TOM0_9_TOUT52_P21_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0N_TOUT17_P00_8_OUT;  /**< \brief IfxGtm_TOM1_0N_TOUT17_P00_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0N_TOUT25_P33_3_OUT;  /**< \brief IfxGtm_TOM1_0N_TOUT25_P33_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0N_TOUT34_P33_12_OUT;  /**< \brief IfxGtm_TOM1_0N_TOUT34_P33_12_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0N_TOUT75_P15_4_OUT;  /**< \brief IfxGtm_TOM1_0N_TOUT75_P15_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0N_TOUT7_P02_7_OUT;  /**< \brief IfxGtm_TOM1_0N_TOUT7_P02_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0_TOUT0_P02_0_OUT;  /**< \brief IfxGtm_TOM1_0_TOUT0_P02_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0_TOUT18_P00_9_OUT;  /**< \brief IfxGtm_TOM1_0_TOUT18_P00_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0_TOUT26_P33_4_OUT;  /**< \brief IfxGtm_TOM1_0_TOUT26_P33_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0_TOUT32_P33_10_OUT;  /**< \brief IfxGtm_TOM1_0_TOUT32_P33_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0_TOUT68_P20_12_OUT;  /**< \brief IfxGtm_TOM1_0_TOUT68_P20_12_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0_TOUT76_P15_5_OUT;  /**< \brief IfxGtm_TOM1_0_TOUT76_P15_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0_TOUT77_P15_6_OUT;  /**< \brief IfxGtm_TOM1_0_TOUT77_P15_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0_TOUT85_P14_5_OUT;  /**< \brief IfxGtm_TOM1_0_TOUT85_P14_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0_TOUT8_P02_8_OUT;  /**< \brief IfxGtm_TOM1_0_TOUT8_P02_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_0_TOUT9_P00_0_OUT;  /**< \brief IfxGtm_TOM1_0_TOUT9_P00_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_10_TOUT2_P02_2_OUT;  /**< \brief IfxGtm_TOM1_10_TOUT2_P02_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_10_TOUT62_P20_6_OUT;  /**< \brief IfxGtm_TOM1_10_TOUT62_P20_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_11_TOUT3_P02_3_OUT;  /**< \brief IfxGtm_TOM1_11_TOUT3_P02_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_11_TOUT60_P20_1_OUT;  /**< \brief IfxGtm_TOM1_11_TOUT60_P20_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_11_TOUT63_P20_7_OUT;  /**< \brief IfxGtm_TOM1_11_TOUT63_P20_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_12_TOUT34_P33_12_OUT;  /**< \brief IfxGtm_TOM1_12_TOUT34_P33_12_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_12_TOUT4_P02_4_OUT;  /**< \brief IfxGtm_TOM1_12_TOUT4_P02_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_12_TOUT61_P20_3_OUT;  /**< \brief IfxGtm_TOM1_12_TOUT61_P20_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_13_TOUT35_P33_13_OUT;  /**< \brief IfxGtm_TOM1_13_TOUT35_P33_13_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_13_TOUT5_P02_5_OUT;  /**< \brief IfxGtm_TOM1_13_TOUT5_P02_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_13_TOUT65_P20_9_OUT;  /**< \brief IfxGtm_TOM1_13_TOUT65_P20_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_14_TOUT36_P32_0_OUT;  /**< \brief IfxGtm_TOM1_14_TOUT36_P32_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_14_TOUT66_P20_10_OUT;  /**< \brief IfxGtm_TOM1_14_TOUT66_P20_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_14_TOUT6_P02_6_OUT;  /**< \brief IfxGtm_TOM1_14_TOUT6_P02_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_15_TOUT37_P32_1_OUT;  /**< \brief IfxGtm_TOM1_15_TOUT37_P32_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_15_TOUT67_P20_11_OUT;  /**< \brief IfxGtm_TOM1_15_TOUT67_P20_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_15_TOUT7_P02_7_OUT;  /**< \brief IfxGtm_TOM1_15_TOUT7_P02_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1N_TOUT14_P00_5_OUT;  /**< \brief IfxGtm_TOM1_1N_TOUT14_P00_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1N_TOUT22_P33_0_OUT;  /**< \brief IfxGtm_TOM1_1N_TOUT22_P33_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1N_TOUT30_P33_8_OUT;  /**< \brief IfxGtm_TOM1_1N_TOUT30_P33_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1N_TOUT35_P33_13_OUT;  /**< \brief IfxGtm_TOM1_1N_TOUT35_P33_13_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1N_TOUT39_P32_3_OUT;  /**< \brief IfxGtm_TOM1_1N_TOUT39_P32_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1N_TOUT4_P02_4_OUT;  /**< \brief IfxGtm_TOM1_1N_TOUT4_P02_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1N_TOUT72_P15_1_OUT;  /**< \brief IfxGtm_TOM1_1N_TOUT72_P15_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1_TOUT10_P00_1_OUT;  /**< \brief IfxGtm_TOM1_1_TOUT10_P00_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1_TOUT11_P00_2_OUT;  /**< \brief IfxGtm_TOM1_1_TOUT11_P00_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1_TOUT19_P00_10_OUT;  /**< \brief IfxGtm_TOM1_1_TOUT19_P00_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1_TOUT1_P02_1_OUT;  /**< \brief IfxGtm_TOM1_1_TOUT1_P02_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1_TOUT27_P33_5_OUT;  /**< \brief IfxGtm_TOM1_1_TOUT27_P33_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1_TOUT31_P33_9_OUT;  /**< \brief IfxGtm_TOM1_1_TOUT31_P33_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1_TOUT69_P20_13_OUT;  /**< \brief IfxGtm_TOM1_1_TOUT69_P20_13_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1_TOUT78_P15_7_OUT;  /**< \brief IfxGtm_TOM1_1_TOUT78_P15_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_1_TOUT86_P14_6_OUT;  /**< \brief IfxGtm_TOM1_1_TOUT86_P14_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2N_TOUT15_P00_6_OUT;  /**< \brief IfxGtm_TOM1_2N_TOUT15_P00_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2N_TOUT23_P33_1_OUT;  /**< \brief IfxGtm_TOM1_2N_TOUT23_P33_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2N_TOUT40_P32_4_OUT;  /**< \brief IfxGtm_TOM1_2N_TOUT40_P32_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2N_TOUT41_P23_0_OUT;  /**< \brief IfxGtm_TOM1_2N_TOUT41_P23_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2N_TOUT5_P02_5_OUT;  /**< \brief IfxGtm_TOM1_2N_TOUT5_P02_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2N_TOUT73_P15_2_OUT;  /**< \brief IfxGtm_TOM1_2N_TOUT73_P15_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2_TOUT12_P00_3_OUT;  /**< \brief IfxGtm_TOM1_2_TOUT12_P00_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2_TOUT20_P00_11_OUT;  /**< \brief IfxGtm_TOM1_2_TOUT20_P00_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2_TOUT28_P33_6_OUT;  /**< \brief IfxGtm_TOM1_2_TOUT28_P33_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2_TOUT2_P02_2_OUT;  /**< \brief IfxGtm_TOM1_2_TOUT2_P02_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2_TOUT33_P33_11_OUT;  /**< \brief IfxGtm_TOM1_2_TOUT33_P33_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2_TOUT70_P20_14_OUT;  /**< \brief IfxGtm_TOM1_2_TOUT70_P20_14_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_2_TOUT79_P15_8_OUT;  /**< \brief IfxGtm_TOM1_2_TOUT79_P15_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_3N_TOUT16_P00_7_OUT;  /**< \brief IfxGtm_TOM1_3N_TOUT16_P00_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_3N_TOUT24_P33_2_OUT;  /**< \brief IfxGtm_TOM1_3N_TOUT24_P33_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_3N_TOUT43_P23_2_OUT;  /**< \brief IfxGtm_TOM1_3N_TOUT43_P23_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_3N_TOUT6_P02_6_OUT;  /**< \brief IfxGtm_TOM1_3N_TOUT6_P02_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_3N_TOUT74_P15_3_OUT;  /**< \brief IfxGtm_TOM1_3N_TOUT74_P15_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_3_TOUT13_P00_4_OUT;  /**< \brief IfxGtm_TOM1_3_TOUT13_P00_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_3_TOUT21_P00_12_OUT;  /**< \brief IfxGtm_TOM1_3_TOUT21_P00_12_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_3_TOUT29_P33_7_OUT;  /**< \brief IfxGtm_TOM1_3_TOUT29_P33_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_3_TOUT38_P32_2_OUT;  /**< \brief IfxGtm_TOM1_3_TOUT38_P32_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_3_TOUT3_P02_3_OUT;  /**< \brief IfxGtm_TOM1_3_TOUT3_P02_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_3_TOUT71_P15_0_OUT;  /**< \brief IfxGtm_TOM1_3_TOUT71_P15_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_3_TOUT80_P14_0_OUT;  /**< \brief IfxGtm_TOM1_3_TOUT80_P14_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4N_TOUT10_P00_1_OUT;  /**< \brief IfxGtm_TOM1_4N_TOUT10_P00_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4N_TOUT13_P00_4_OUT;  /**< \brief IfxGtm_TOM1_4N_TOUT13_P00_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4N_TOUT1_P02_1_OUT;  /**< \brief IfxGtm_TOM1_4N_TOUT1_P02_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4N_TOUT21_P00_12_OUT;  /**< \brief IfxGtm_TOM1_4N_TOUT21_P00_12_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4N_TOUT29_P33_7_OUT;  /**< \brief IfxGtm_TOM1_4N_TOUT29_P33_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4N_TOUT36_P32_0_OUT;  /**< \brief IfxGtm_TOM1_4N_TOUT36_P32_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4N_TOUT54_P21_3_OUT;  /**< \brief IfxGtm_TOM1_4N_TOUT54_P21_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4N_TOUT65_P20_9_OUT;  /**< \brief IfxGtm_TOM1_4N_TOUT65_P20_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4N_TOUT71_P15_0_OUT;  /**< \brief IfxGtm_TOM1_4N_TOUT71_P15_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4N_TOUT73_P15_2_OUT;  /**< \brief IfxGtm_TOM1_4N_TOUT73_P15_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4N_TOUT8_P02_8_OUT;  /**< \brief IfxGtm_TOM1_4N_TOUT8_P02_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4N_TOUT95_P11_2_OUT;  /**< \brief IfxGtm_TOM1_4N_TOUT95_P11_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT0_P02_0_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT0_P02_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT124_P11_8_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT124_P11_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT14_P00_5_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT14_P00_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT22_P33_0_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT22_P33_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT30_P33_8_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT30_P33_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT37_P32_1_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT37_P32_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT39_P32_3_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT39_P32_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT53_P21_2_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT53_P21_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT64_P20_8_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT64_P20_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT72_P15_1_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT72_P15_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT81_P14_1_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT81_P14_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT94_P13_3_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT94_P13_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_4_TOUT9_P00_0_OUT;  /**< \brief IfxGtm_TOM1_4_TOUT9_P00_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT12_P00_3_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT12_P00_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT18_P00_9_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT18_P00_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT26_P33_4_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT26_P33_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT28_P33_6_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT28_P33_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT32_P33_10_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT32_P33_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT37_P32_1_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT37_P32_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT3_P02_3_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT3_P02_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT56_P21_5_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT56_P21_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT67_P20_11_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT67_P20_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT76_P15_5_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT76_P15_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT77_P15_6_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT77_P15_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT97_P11_6_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT97_P11_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5N_TOUT9_P00_0_OUT;  /**< \brief IfxGtm_TOM1_5N_TOUT9_P00_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT11_P00_2_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT11_P00_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT15_P00_6_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT15_P00_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT23_P33_1_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT23_P33_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT27_P33_5_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT27_P33_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT2_P02_2_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT2_P02_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT40_P32_4_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT40_P32_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT41_P23_0_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT41_P23_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT55_P21_4_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT55_P21_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT66_P20_10_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT66_P20_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT73_P15_2_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT73_P15_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT74_P15_3_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT74_P15_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT82_P14_2_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT82_P14_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_5_TOUT96_P11_3_OUT;  /**< \brief IfxGtm_TOM1_5_TOUT96_P11_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT10_P00_1_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT10_P00_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT11_P00_2_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT11_P00_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT14_P00_5_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT14_P00_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT19_P00_10_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT19_P00_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT27_P33_5_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT27_P33_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT30_P33_8_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT30_P33_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT31_P33_9_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT31_P33_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT38_P32_2_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT38_P32_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT40_P32_4_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT40_P32_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT49_P22_2_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT49_P22_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT5_P02_5_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT5_P02_5_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT69_P20_13_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT69_P20_13_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT78_P15_7_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT78_P15_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT82_P14_2_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT82_P14_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT91_P13_0_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT91_P13_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6N_TOUT99_P11_10_OUT;  /**< \brief IfxGtm_TOM1_6N_TOUT99_P11_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6_TOUT13_P00_4_OUT;  /**< \brief IfxGtm_TOM1_6_TOUT13_P00_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6_TOUT16_P00_7_OUT;  /**< \brief IfxGtm_TOM1_6_TOUT16_P00_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6_TOUT24_P33_2_OUT;  /**< \brief IfxGtm_TOM1_6_TOUT24_P33_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6_TOUT29_P33_7_OUT;  /**< \brief IfxGtm_TOM1_6_TOUT29_P33_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6_TOUT43_P23_2_OUT;  /**< \brief IfxGtm_TOM1_6_TOUT43_P23_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6_TOUT48_P22_1_OUT;  /**< \brief IfxGtm_TOM1_6_TOUT48_P22_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6_TOUT4_P02_4_OUT;  /**< \brief IfxGtm_TOM1_6_TOUT4_P02_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6_TOUT68_P20_12_OUT;  /**< \brief IfxGtm_TOM1_6_TOUT68_P20_12_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6_TOUT74_P15_3_OUT;  /**< \brief IfxGtm_TOM1_6_TOUT74_P15_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6_TOUT80_P14_0_OUT;  /**< \brief IfxGtm_TOM1_6_TOUT80_P14_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6_TOUT83_P14_3_OUT;  /**< \brief IfxGtm_TOM1_6_TOUT83_P14_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_6_TOUT98_P11_9_OUT;  /**< \brief IfxGtm_TOM1_6_TOUT98_P11_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT100_P11_11_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT100_P11_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT12_P00_3_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT12_P00_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT16_P00_7_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT16_P00_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT20_P00_11_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT20_P00_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT28_P33_6_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT28_P33_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT32_P33_10_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT32_P33_10_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT33_P33_11_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT33_P33_11_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT39_P32_3_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT39_P32_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT42_P23_1_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT42_P23_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT71_P15_0_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT71_P15_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT79_P15_8_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT79_P15_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT7_P02_7_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT7_P02_7_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT84_P14_4_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT84_P14_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7N_TOUT93_P13_2_OUT;  /**< \brief IfxGtm_TOM1_7N_TOUT93_P13_2_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT101_P11_12_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT101_P11_12_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT15_P00_6_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT15_P00_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT17_P00_8_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT17_P00_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT25_P33_3_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT25_P33_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT31_P33_9_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT31_P33_9_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT44_P23_3_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT44_P23_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT45_P23_4_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT45_P23_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT50_P22_3_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT50_P22_3_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT64_P20_8_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT64_P20_8_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT6_P02_6_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT6_P02_6_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT70_P20_14_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT70_P20_14_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT75_P15_4_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT75_P15_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT81_P14_1_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT81_P14_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT84_P14_4_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT84_P14_4_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_7_TOUT92_P13_1_OUT;  /**< \brief IfxGtm_TOM1_7_TOUT92_P13_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_8_TOUT0_P02_0_OUT;  /**< \brief IfxGtm_TOM1_8_TOUT0_P02_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_8_TOUT128_P12_0_OUT;  /**< \brief IfxGtm_TOM1_8_TOUT128_P12_0_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_9_TOUT129_P12_1_OUT;  /**< \brief IfxGtm_TOM1_9_TOUT129_P12_1_OUT */
IFX_EXTERN IfxGtm_Tom_ToutMap IfxGtm_TOM1_9_TOUT1_P02_1_OUT;  /**< \brief IfxGtm_TOM1_9_TOUT1_P02_1_OUT */

/** \} */

#endif /* IFXGTM_PINMAP_H */
