/**
 * \file IfxSmu_Smu.h
 * \brief SMU SMU details
 * \ingroup IfxLld_Smu
 *
 * \version iLLD_1_0_1_11_0
 * \copyright Copyright (c) 2018 Infineon Technologies AG. All rights reserved.
 *
 *
 *                                 IMPORTANT NOTICE
 *
 *
 * Use of this file is subject to the terms of use agreed between (i) you or 
 * the company in which ordinary course of business you are acting and (ii) 
 * Infineon Technologies AG or its licensees. If and as long as no such 
 * terms of use are agreed, use of this file is subject to following:


 * Boost Software License - Version 1.0 - August 17th, 2003

 * Permission is hereby granted, free of charge, to any person or 
 * organization obtaining a copy of the software and accompanying 
 * documentation covered by this license (the "Software") to use, reproduce,
 * display, distribute, execute, and transmit the Software, and to prepare
 * derivative works of the Software, and to permit third-parties to whom the 
 * Software is furnished to do so, all subject to the following:

 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer, must
 * be included in all copies of the Software, in whole or in part, and all
 * derivative works of the Software, unless such copies or derivative works are
 * solely in the form of machine-executable object code generated by a source
 * language processor.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.

 *
 * \defgroup IfxLld_Smu_Smu SMU
 * \ingroup IfxLld_Smu
 * \defgroup IfxLld_Smu_Smu_DataStructures Data Structures
 * \ingroup IfxLld_Smu_Smu
 * \defgroup IfxLld_Smu_Smu_SmuFunctions Smu Functions
 * \ingroup IfxLld_Smu_Smu
 */

#ifndef IFXSMU_SMU_H
#define IFXSMU_SMU_H 1

/******************************************************************************/
/*----------------------------------Includes----------------------------------*/
/******************************************************************************/

#include "Smu/Std/IfxSmu.h"
#include "_Impl/IfxSmu_cfg.h"

/******************************************************************************/
/*-----------------------------Data Structures--------------------------------*/
/******************************************************************************/

/** \addtogroup IfxLld_Smu_Smu_DataStructures
 * \{ */
/** \brief Alarm Global Configuration
 */
typedef struct
{
    uint8   igcs0;                            /**< \brief AGC.B.IGCS0 */
    uint8   igcs1;                            /**< \brief AGC.B.IGCS1 */
    uint8   igcs2;                            /**< \brief AGC.B.IGCS2 */
    uint8   resetConfigSet;                   /**< \brief AGC.B.RCS */
    uint8   portEmergencyStop;                /**< \brief AGC.B.PES */
    boolean enableFaultToRunTransition;       /**< \brief AGC.B.EFRST */
} IfxSmu_Smu_AlarmGlobalConfiguration;

/** \brief FSP configuration
 */
typedef struct
{
    IfxSmu_FspPrescalar1 prescalar1;                   /**< \brief FSP.B.PRE1 */
    IfxSmu_FspPrescalar2 prescalar2;                   /**< \brief FSP.B.PRE2 */
    IfxSmu_FspMode       mode;
    boolean              portEmergencyStop;            /**< \brief FSP.B.PES */
    uint16               faultStateDurationHigh;       /**< \brief FSP.B.TFSP_HIGH */
    uint16               faultStateDurationLow;        /**< \brief FSP.B.TFSP_LOW */
} IfxSmu_Smu_FaultSignalingProtocol;

/** \brief Recovery Timer/s Alarm Configuration
 */
typedef struct
{
    uint8 groupIndex0;
    uint8 alarmId0;
    uint8 groupIndex1;
    uint8 alarmId1;
    uint8 groupIndex2;
    uint8 alarmId2;
    uint8 groupIndex3;
    uint8 alarmId3;
} IfxSmu_Smu_RecoveryTimerAlarmConfiguration;

/** \brief Recovery Timer Configuration
 */
typedef struct
{
    boolean enableRecoveryTimer0;        /**< \brief RTC.B.RT0E */
    boolean enableRecoveryTimer1;        /**< \brief RTC.B.RT1E */
    uint32  recoveryTimerDuration;       /**< \brief RTC.B.RTD */
} IfxSmu_Smu_RecoveryTimerConfig;

/** \} */

/** \addtogroup IfxLld_Smu_Smu_DataStructures
 * \{ */
typedef struct
{
    IfxSmu_Smu_FaultSignalingProtocol          fsp;
    IfxSmu_Smu_AlarmGlobalConfiguration        alarmGlobalConfig;
    IfxSmu_Smu_RecoveryTimerConfig             recoveryTimerConfig;
    IfxSmu_Smu_RecoveryTimerAlarmConfiguration recoveryTimerAlarmConfig[2];                           /**< \brief recovery Timer Alarm 0/1 configuration */
    uint32                                     alarmConfigRegister[IFXSMU_NUM_ALARM_GROUPS][3];       /**< \brief AGCF */
    uint32                                     fspConfigRegister[IFXSMU_NUM_ALARM_GROUPS];            /**< \brief AGFSP */
} IfxSmu_Smu_Config;

/** \} */

/** \addtogroup IfxLld_Smu_Smu_SmuFunctions
 * \{ */

/******************************************************************************/
/*-------------------------Global Function Prototypes-------------------------*/
/******************************************************************************/

/** \brief Fills the configuration stucture of the SMU Module with default values
 * \param config configuration structure of the module
 * \return None
 */
IFX_EXTERN void IfxSmu_Smu_initModuleConfig(IfxSmu_Smu_Config *config);

/** \brief Initialises the SMU Module
 * \param config configuration structure of the module
 * \return None
 */
IFX_EXTERN void IfxSmu_Smu_initModule(IfxSmu_Smu_Config *config);

/** \brief Check if any alarm is Triggered.
 * \return Returns True if any alarm is set
 */
IFX_EXTERN boolean IfxSmu_Smu_isAlarmTriggered(void);

/** \} */

#endif /* IFXSMU_SMU_H */
