/**
 * \file IfxMtu_reg.h
 * \brief
 * \copyright Copyright (c) 2019 Infineon Technologies AG. All rights reserved.
 *
 *
 * Version: TC36XA_UM_V1.2.0.R0
 * Specification: TC3xx User Manual.V1.2.0
 * MAY BE CHANGED BY USER [yes/no]: No
 *
 *                                 IMPORTANT NOTICE
 *
 *
 * Use of this file is subject to the terms of use agreed between (i) you or 
 * the company in which ordinary course of business you are acting and (ii) 
 * Infineon Technologies AG or its licensees. If and as long as no such 
 * terms of use are agreed, use of this file is subject to following:


 * Boost Software License - Version 1.0 - August 17th, 2003

 * Permission is hereby granted, free of charge, to any person or 
 * organization obtaining a copy of the software and accompanying 
 * documentation covered by this license (the "Software") to use, reproduce,
 * display, distribute, execute, and transmit the Software, and to prepare
 * derivative works of the Software, and to permit third-parties to whom the 
 * Software is furnished to do so, all subject to the following:

 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer, must
 * be included in all copies of the Software, in whole or in part, and all
 * derivative works of the Software, unless such copies or derivative works are
 * solely in the form of machine-executable object code generated by a source
 * language processor.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * \defgroup IfxSfr_Mtu_Registers_Cfg Mtu address
 * \ingroup IfxSfr_Mtu_Registers
 * 
 * \defgroup IfxSfr_Mtu_Registers_Cfg_BaseAddress Base address
 * \ingroup IfxSfr_Mtu_Registers_Cfg
 *
 * \defgroup IfxSfr_Mtu_Registers_Cfg_Mtu 2-MTU
 * \ingroup IfxSfr_Mtu_Registers_Cfg
 *
 *
 */
#ifndef IFXMTU_REG_H
#define IFXMTU_REG_H 1
/******************************************************************************/
#include "IfxMtu_regdef.h"
/******************************************************************************/

/******************************************************************************/

/******************************************************************************/

/** \addtogroup IfxSfr_Mtu_Registers_Cfg_BaseAddress
 * \{  */

/** \brief MTU object */
#define MODULE_MTU /*lint --e(923, 9078)*/ ((*(Ifx_MTU*)0xF0060000u))
/** \}  */


/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Mtu_Registers_Cfg_Mtu
 * \{  */
/** \brief 0, Clock Control Register */
#define MTU_CLC /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_CLC*)0xF0060000u)

/** \brief 8, Identification Register */
#define MTU_ID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_ID*)0xF0060008u)

/** \brief 10, Memory MBIST Enable Register 0 */
#define MTU_MEMTEST0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMTEST0*)0xF0060010u)

/** \brief 14, Memory MBIST Enable Register 1 */
#define MTU_MEMTEST1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMTEST1*)0xF0060014u)

/** \brief 18, Memory MBIST Enable Register 2 */
#define MTU_MEMTEST2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMTEST2*)0xF0060018u)

/** \brief 1C, Memory Mapping Enable Register */
#define MTU_MEMMAP /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMMAP*)0xF006001Cu)

/** \brief 38, Memory Status Register 0 */
#define MTU_MEMSTAT0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMSTAT0*)0xF0060038u)

/** \brief 3C, Memory Status Register 1 */
#define MTU_MEMSTAT1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMSTAT1*)0xF006003Cu)

/** \brief 40, Memory Status Register 2 */
#define MTU_MEMSTAT2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMSTAT2*)0xF0060040u)

/** \brief 50, Memory Test Done Status Register 0 */
#define MTU_MEMDONE0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMDONE0*)0xF0060050u)

/** \brief 54, Memory Test Done Status Register 1 */
#define MTU_MEMDONE1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMDONE1*)0xF0060054u)

/** \brief 58, Memory Test Done Status Register 2 */
#define MTU_MEMDONE2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMDONE2*)0xF0060058u)

/** \brief 60, Memory Test FDA Status Register 0 */
#define MTU_MEMFDA0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMFDA0*)0xF0060060u)

/** \brief 64, Memory Test FDA Status Register 1 */
#define MTU_MEMFDA1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMFDA1*)0xF0060064u)

/** \brief 68, Memory Test FDA Status Register 2 */
#define MTU_MEMFDA2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MEMFDA2*)0xF0060068u)

/** \brief F8, Access Enable Register 1 */
#define MTU_ACCEN1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_ACCEN1*)0xF00600F8u)

/** \brief FC, Access Enable Register 0 */
#define MTU_ACCEN0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_ACCEN0*)0xF00600FCu)

/** \brief 0, Configuration Registers */
#define MTU_MC0_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061000u)

/** \brief 2, Configuration Register 1 */
#define MTU_MC0_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061002u)

/** \brief 4, MBIST Control Register */
#define MTU_MC0_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061004u)

/** \brief 6, Status Register */
#define MTU_MC0_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061006u)

/** \brief 8, Range Register, single address mode */
#define MTU_MC0_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061008u)

/** \brief C, Revision ID Register */
#define MTU_MC0_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006100Cu)

/** \brief E, ECC Safety Register */
#define MTU_MC0_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006100Eu)

/** \brief 10, Memory ECC Detection Register */
#define MTU_MC0_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061010u)

/** \brief 12, Error Tracking Register 0 */
#define MTU_MC0_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061012u)

/** \brief 14, Error Tracking Register 1 */
#define MTU_MC0_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061014u)

/** \brief 16, Error Tracking Register 2 */
#define MTU_MC0_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061016u)

/** \brief 18, Error Tracking Register 3 */
#define MTU_MC0_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061018u)

/** \brief 1A, Error Tracking Register 4 */
#define MTU_MC0_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006101Au)

/** \brief 60, Read Data and Bit Flip Register 0 */
#define MTU_MC0_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061060u)

/** \brief 62, Read Data and Bit Flip Register 1 */
#define MTU_MC0_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061062u)

/** \brief 64, Read Data and Bit Flip Register 2 */
#define MTU_MC0_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061064u)

/** \brief 66, Read Data and Bit Flip Register 3 */
#define MTU_MC0_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061066u)

/** \brief 68, Read Data and Bit Flip Register 4 */
#define MTU_MC0_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061068u)

/** \brief 6A, Read Data and Bit Flip Register 5 */
#define MTU_MC0_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006106Au)

/** \brief 6C, Read Data and Bit Flip Register 6 */
#define MTU_MC0_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006106Cu)

/** \brief 6E, Read Data and Bit Flip Register 7 */
#define MTU_MC0_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006106Eu)

/** \brief 70, Read Data and Bit Flip Register 8 */
#define MTU_MC0_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061070u)

/** \brief 72, Read Data and Bit Flip Register 9 */
#define MTU_MC0_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061072u)

/** \brief 74, Read Data and Bit Flip Register 10 */
#define MTU_MC0_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061074u)

/** \brief 76, Read Data and Bit Flip Register 11 */
#define MTU_MC0_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061076u)

/** \brief 78, Read Data and Bit Flip Register 12 */
#define MTU_MC0_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061078u)

/** \brief 7A, Read Data and Bit Flip Register 13 */
#define MTU_MC0_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006107Au)

/** \brief 7C, Read Data and Bit Flip Register 14 */
#define MTU_MC0_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006107Cu)

/** \brief 7E, Read Data and Bit Flip Register 15 */
#define MTU_MC0_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006107Eu)

/** \brief 80, Read Data and Bit Flip Register 16 */
#define MTU_MC0_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061080u)

/** \brief 82, Read Data and Bit Flip Register 17 */
#define MTU_MC0_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061082u)

/** \brief 84, Read Data and Bit Flip Register 18 */
#define MTU_MC0_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061084u)

/** \brief 86, Read Data and Bit Flip Register 19 */
#define MTU_MC0_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061086u)

/** \brief 88, Read Data and Bit Flip Register 20 */
#define MTU_MC0_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061088u)

/** \brief 8A, Read Data and Bit Flip Register 21 */
#define MTU_MC0_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006108Au)

/** \brief 8C, Read Data and Bit Flip Register 22 */
#define MTU_MC0_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006108Cu)

/** \brief 8E, Read Data and Bit Flip Register 23 */
#define MTU_MC0_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006108Eu)

/** \brief 90, Read Data and Bit Flip Register 24 */
#define MTU_MC0_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061090u)

/** \brief 92, Read Data and Bit Flip Register 25 */
#define MTU_MC0_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061092u)

/** \brief 94, Read Data and Bit Flip Register 26 */
#define MTU_MC0_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061094u)

/** \brief 96, Read Data and Bit Flip Register 27 */
#define MTU_MC0_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061096u)

/** \brief 98, Read Data and Bit Flip Register 28 */
#define MTU_MC0_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061098u)

/** \brief 9A, Read Data and Bit Flip Register 29 */
#define MTU_MC0_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006109Au)

/** \brief 9C, Read Data and Bit Flip Register 30 */
#define MTU_MC0_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006109Cu)

/** \brief 9E, Read Data and Bit Flip Register 31 */
#define MTU_MC0_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006109Eu)

/** \brief A0, Read Data and Bit Flip Register 32 */
#define MTU_MC0_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610A0u)

/** \brief A2, Read Data and Bit Flip Register 33 */
#define MTU_MC0_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610A2u)

/** \brief A4, Read Data and Bit Flip Register 34 */
#define MTU_MC0_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610A4u)

/** \brief A6, Read Data and Bit Flip Register 35 */
#define MTU_MC0_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610A6u)

/** \brief A8, Read Data and Bit Flip Register 36 */
#define MTU_MC0_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610A8u)

/** \brief AA, Read Data and Bit Flip Register 37 */
#define MTU_MC0_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610AAu)

/** \brief AC, Read Data and Bit Flip Register 38 */
#define MTU_MC0_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610ACu)

/** \brief AE, Read Data and Bit Flip Register 39 */
#define MTU_MC0_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610AEu)

/** \brief B0, Read Data and Bit Flip Register 40 */
#define MTU_MC0_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610B0u)

/** \brief B2, Read Data and Bit Flip Register 41 */
#define MTU_MC0_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610B2u)

/** \brief B4, Read Data and Bit Flip Register 42 */
#define MTU_MC0_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610B4u)

/** \brief B6, Read Data and Bit Flip Register 43 */
#define MTU_MC0_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610B6u)

/** \brief B8, Read Data and Bit Flip Register 44 */
#define MTU_MC0_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610B8u)

/** \brief BA, Read Data and Bit Flip Register 45 */
#define MTU_MC0_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610BAu)

/** \brief BC, Read Data and Bit Flip Register 46 */
#define MTU_MC0_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610BCu)

/** \brief BE, Read Data and Bit Flip Register 47 */
#define MTU_MC0_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610BEu)

/** \brief C0, Read Data and Bit Flip Register 48 */
#define MTU_MC0_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610C0u)

/** \brief C2, Read Data and Bit Flip Register 49 */
#define MTU_MC0_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610C2u)

/** \brief C4, Read Data and Bit Flip Register 50 */
#define MTU_MC0_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610C4u)

/** \brief C6, Read Data and Bit Flip Register 51 */
#define MTU_MC0_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610C6u)

/** \brief C8, Read Data and Bit Flip Register 52 */
#define MTU_MC0_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610C8u)

/** \brief CA, Read Data and Bit Flip Register 53 */
#define MTU_MC0_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610CAu)

/** \brief CC, Read Data and Bit Flip Register 54 */
#define MTU_MC0_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610CCu)

/** \brief CE, Read Data and Bit Flip Register 55 */
#define MTU_MC0_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610CEu)

/** \brief D0, Read Data and Bit Flip Register 56 */
#define MTU_MC0_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610D0u)

/** \brief D2, Read Data and Bit Flip Register 57 */
#define MTU_MC0_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610D2u)

/** \brief D4, Read Data and Bit Flip Register 58 */
#define MTU_MC0_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610D4u)

/** \brief D6, Read Data and Bit Flip Register 59 */
#define MTU_MC0_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610D6u)

/** \brief D8, Read Data and Bit Flip Register 60 */
#define MTU_MC0_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610D8u)

/** \brief DA, Read Data and Bit Flip Register 61 */
#define MTU_MC0_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610DAu)

/** \brief DC, Read Data and Bit Flip Register 62 */
#define MTU_MC0_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610DCu)

/** \brief DE, Read Data and Bit Flip Register 63 */
#define MTU_MC0_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610DEu)

/** \brief E0, Read Data and Bit Flip Register 64 */
#define MTU_MC0_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610E0u)

/** \brief E2, Read Data and Bit Flip Register 65 */
#define MTU_MC0_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610E2u)

/** \brief E4, Read Data and Bit Flip Register 66 */
#define MTU_MC0_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00610E4u)

/** \brief EE, Alarm Sources Configuration Register */
#define MTU_MC0_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00610EEu)

/** \brief F0, SSH Safety Faults Status Register  */
#define MTU_MC0_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00610F0u)

/** \brief F2, Error Information Register 0 */
#define MTU_MC0_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00610F2u)

/** \brief F4, Error Information Register 1 */
#define MTU_MC0_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00610F4u)

/** \brief F6, Error Information Register 2 */
#define MTU_MC0_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00610F6u)

/** \brief F8, Error Information Register 3 */
#define MTU_MC0_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00610F8u)

/** \brief FA, Error Information Register 4 */
#define MTU_MC0_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00610FAu)

/** \brief 100, Configuration Registers */
#define MTU_MC1_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061100u)

/** \brief 102, Configuration Register 1 */
#define MTU_MC1_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061102u)

/** \brief 104, MBIST Control Register */
#define MTU_MC1_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061104u)

/** \brief 106, Status Register */
#define MTU_MC1_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061106u)

/** \brief 108, Range Register, single address mode */
#define MTU_MC1_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061108u)

/** \brief 10C, Revision ID Register */
#define MTU_MC1_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006110Cu)

/** \brief 10E, ECC Safety Register */
#define MTU_MC1_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006110Eu)

/** \brief 110, Memory ECC Detection Register */
#define MTU_MC1_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061110u)

/** \brief 112, Error Tracking Register 0 */
#define MTU_MC1_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061112u)

/** \brief 114, Error Tracking Register 1 */
#define MTU_MC1_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061114u)

/** \brief 116, Error Tracking Register 2 */
#define MTU_MC1_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061116u)

/** \brief 118, Error Tracking Register 3 */
#define MTU_MC1_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061118u)

/** \brief 11A, Error Tracking Register 4 */
#define MTU_MC1_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006111Au)

/** \brief 160, Read Data and Bit Flip Register 0 */
#define MTU_MC1_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061160u)

/** \brief 162, Read Data and Bit Flip Register 1 */
#define MTU_MC1_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061162u)

/** \brief 164, Read Data and Bit Flip Register 2 */
#define MTU_MC1_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061164u)

/** \brief 166, Read Data and Bit Flip Register 3 */
#define MTU_MC1_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061166u)

/** \brief 168, Read Data and Bit Flip Register 4 */
#define MTU_MC1_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061168u)

/** \brief 16A, Read Data and Bit Flip Register 5 */
#define MTU_MC1_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006116Au)

/** \brief 16C, Read Data and Bit Flip Register 6 */
#define MTU_MC1_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006116Cu)

/** \brief 16E, Read Data and Bit Flip Register 7 */
#define MTU_MC1_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006116Eu)

/** \brief 170, Read Data and Bit Flip Register 8 */
#define MTU_MC1_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061170u)

/** \brief 172, Read Data and Bit Flip Register 9 */
#define MTU_MC1_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061172u)

/** \brief 174, Read Data and Bit Flip Register 10 */
#define MTU_MC1_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061174u)

/** \brief 176, Read Data and Bit Flip Register 11 */
#define MTU_MC1_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061176u)

/** \brief 178, Read Data and Bit Flip Register 12 */
#define MTU_MC1_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061178u)

/** \brief 17A, Read Data and Bit Flip Register 13 */
#define MTU_MC1_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006117Au)

/** \brief 17C, Read Data and Bit Flip Register 14 */
#define MTU_MC1_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006117Cu)

/** \brief 17E, Read Data and Bit Flip Register 15 */
#define MTU_MC1_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006117Eu)

/** \brief 180, Read Data and Bit Flip Register 16 */
#define MTU_MC1_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061180u)

/** \brief 182, Read Data and Bit Flip Register 17 */
#define MTU_MC1_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061182u)

/** \brief 184, Read Data and Bit Flip Register 18 */
#define MTU_MC1_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061184u)

/** \brief 186, Read Data and Bit Flip Register 19 */
#define MTU_MC1_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061186u)

/** \brief 188, Read Data and Bit Flip Register 20 */
#define MTU_MC1_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061188u)

/** \brief 18A, Read Data and Bit Flip Register 21 */
#define MTU_MC1_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006118Au)

/** \brief 18C, Read Data and Bit Flip Register 22 */
#define MTU_MC1_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006118Cu)

/** \brief 18E, Read Data and Bit Flip Register 23 */
#define MTU_MC1_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006118Eu)

/** \brief 190, Read Data and Bit Flip Register 24 */
#define MTU_MC1_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061190u)

/** \brief 192, Read Data and Bit Flip Register 25 */
#define MTU_MC1_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061192u)

/** \brief 194, Read Data and Bit Flip Register 26 */
#define MTU_MC1_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061194u)

/** \brief 196, Read Data and Bit Flip Register 27 */
#define MTU_MC1_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061196u)

/** \brief 198, Read Data and Bit Flip Register 28 */
#define MTU_MC1_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061198u)

/** \brief 19A, Read Data and Bit Flip Register 29 */
#define MTU_MC1_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006119Au)

/** \brief 19C, Read Data and Bit Flip Register 30 */
#define MTU_MC1_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006119Cu)

/** \brief 19E, Read Data and Bit Flip Register 31 */
#define MTU_MC1_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006119Eu)

/** \brief 1A0, Read Data and Bit Flip Register 32 */
#define MTU_MC1_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611A0u)

/** \brief 1A2, Read Data and Bit Flip Register 33 */
#define MTU_MC1_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611A2u)

/** \brief 1A4, Read Data and Bit Flip Register 34 */
#define MTU_MC1_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611A4u)

/** \brief 1A6, Read Data and Bit Flip Register 35 */
#define MTU_MC1_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611A6u)

/** \brief 1A8, Read Data and Bit Flip Register 36 */
#define MTU_MC1_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611A8u)

/** \brief 1AA, Read Data and Bit Flip Register 37 */
#define MTU_MC1_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611AAu)

/** \brief 1AC, Read Data and Bit Flip Register 38 */
#define MTU_MC1_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611ACu)

/** \brief 1AE, Read Data and Bit Flip Register 39 */
#define MTU_MC1_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611AEu)

/** \brief 1B0, Read Data and Bit Flip Register 40 */
#define MTU_MC1_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611B0u)

/** \brief 1B2, Read Data and Bit Flip Register 41 */
#define MTU_MC1_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611B2u)

/** \brief 1B4, Read Data and Bit Flip Register 42 */
#define MTU_MC1_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611B4u)

/** \brief 1B6, Read Data and Bit Flip Register 43 */
#define MTU_MC1_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611B6u)

/** \brief 1B8, Read Data and Bit Flip Register 44 */
#define MTU_MC1_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611B8u)

/** \brief 1BA, Read Data and Bit Flip Register 45 */
#define MTU_MC1_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611BAu)

/** \brief 1BC, Read Data and Bit Flip Register 46 */
#define MTU_MC1_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611BCu)

/** \brief 1BE, Read Data and Bit Flip Register 47 */
#define MTU_MC1_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611BEu)

/** \brief 1C0, Read Data and Bit Flip Register 48 */
#define MTU_MC1_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611C0u)

/** \brief 1C2, Read Data and Bit Flip Register 49 */
#define MTU_MC1_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611C2u)

/** \brief 1C4, Read Data and Bit Flip Register 50 */
#define MTU_MC1_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611C4u)

/** \brief 1C6, Read Data and Bit Flip Register 51 */
#define MTU_MC1_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611C6u)

/** \brief 1C8, Read Data and Bit Flip Register 52 */
#define MTU_MC1_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611C8u)

/** \brief 1CA, Read Data and Bit Flip Register 53 */
#define MTU_MC1_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611CAu)

/** \brief 1CC, Read Data and Bit Flip Register 54 */
#define MTU_MC1_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611CCu)

/** \brief 1CE, Read Data and Bit Flip Register 55 */
#define MTU_MC1_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611CEu)

/** \brief 1D0, Read Data and Bit Flip Register 56 */
#define MTU_MC1_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611D0u)

/** \brief 1D2, Read Data and Bit Flip Register 57 */
#define MTU_MC1_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611D2u)

/** \brief 1D4, Read Data and Bit Flip Register 58 */
#define MTU_MC1_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611D4u)

/** \brief 1D6, Read Data and Bit Flip Register 59 */
#define MTU_MC1_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611D6u)

/** \brief 1D8, Read Data and Bit Flip Register 60 */
#define MTU_MC1_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611D8u)

/** \brief 1DA, Read Data and Bit Flip Register 61 */
#define MTU_MC1_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611DAu)

/** \brief 1DC, Read Data and Bit Flip Register 62 */
#define MTU_MC1_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611DCu)

/** \brief 1DE, Read Data and Bit Flip Register 63 */
#define MTU_MC1_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611DEu)

/** \brief 1E0, Read Data and Bit Flip Register 64 */
#define MTU_MC1_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611E0u)

/** \brief 1E2, Read Data and Bit Flip Register 65 */
#define MTU_MC1_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611E2u)

/** \brief 1E4, Read Data and Bit Flip Register 66 */
#define MTU_MC1_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00611E4u)

/** \brief 1EE, Alarm Sources Configuration Register */
#define MTU_MC1_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00611EEu)

/** \brief 1F0, SSH Safety Faults Status Register  */
#define MTU_MC1_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00611F0u)

/** \brief 1F2, Error Information Register 0 */
#define MTU_MC1_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00611F2u)

/** \brief 1F4, Error Information Register 1 */
#define MTU_MC1_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00611F4u)

/** \brief 1F6, Error Information Register 2 */
#define MTU_MC1_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00611F6u)

/** \brief 1F8, Error Information Register 3 */
#define MTU_MC1_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00611F8u)

/** \brief 1FA, Error Information Register 4 */
#define MTU_MC1_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00611FAu)

/** \brief 200, Configuration Registers */
#define MTU_MC2_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061200u)

/** \brief 202, Configuration Register 1 */
#define MTU_MC2_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061202u)

/** \brief 204, MBIST Control Register */
#define MTU_MC2_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061204u)

/** \brief 206, Status Register */
#define MTU_MC2_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061206u)

/** \brief 208, Range Register, single address mode */
#define MTU_MC2_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061208u)

/** \brief 20C, Revision ID Register */
#define MTU_MC2_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006120Cu)

/** \brief 20E, ECC Safety Register */
#define MTU_MC2_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006120Eu)

/** \brief 210, Memory ECC Detection Register */
#define MTU_MC2_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061210u)

/** \brief 212, Error Tracking Register 0 */
#define MTU_MC2_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061212u)

/** \brief 214, Error Tracking Register 1 */
#define MTU_MC2_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061214u)

/** \brief 216, Error Tracking Register 2 */
#define MTU_MC2_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061216u)

/** \brief 218, Error Tracking Register 3 */
#define MTU_MC2_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061218u)

/** \brief 21A, Error Tracking Register 4 */
#define MTU_MC2_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006121Au)

/** \brief 260, Read Data and Bit Flip Register 0 */
#define MTU_MC2_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061260u)

/** \brief 262, Read Data and Bit Flip Register 1 */
#define MTU_MC2_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061262u)

/** \brief 264, Read Data and Bit Flip Register 2 */
#define MTU_MC2_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061264u)

/** \brief 266, Read Data and Bit Flip Register 3 */
#define MTU_MC2_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061266u)

/** \brief 268, Read Data and Bit Flip Register 4 */
#define MTU_MC2_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061268u)

/** \brief 26A, Read Data and Bit Flip Register 5 */
#define MTU_MC2_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006126Au)

/** \brief 26C, Read Data and Bit Flip Register 6 */
#define MTU_MC2_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006126Cu)

/** \brief 26E, Read Data and Bit Flip Register 7 */
#define MTU_MC2_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006126Eu)

/** \brief 270, Read Data and Bit Flip Register 8 */
#define MTU_MC2_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061270u)

/** \brief 272, Read Data and Bit Flip Register 9 */
#define MTU_MC2_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061272u)

/** \brief 274, Read Data and Bit Flip Register 10 */
#define MTU_MC2_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061274u)

/** \brief 276, Read Data and Bit Flip Register 11 */
#define MTU_MC2_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061276u)

/** \brief 278, Read Data and Bit Flip Register 12 */
#define MTU_MC2_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061278u)

/** \brief 27A, Read Data and Bit Flip Register 13 */
#define MTU_MC2_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006127Au)

/** \brief 27C, Read Data and Bit Flip Register 14 */
#define MTU_MC2_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006127Cu)

/** \brief 27E, Read Data and Bit Flip Register 15 */
#define MTU_MC2_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006127Eu)

/** \brief 280, Read Data and Bit Flip Register 16 */
#define MTU_MC2_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061280u)

/** \brief 282, Read Data and Bit Flip Register 17 */
#define MTU_MC2_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061282u)

/** \brief 284, Read Data and Bit Flip Register 18 */
#define MTU_MC2_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061284u)

/** \brief 286, Read Data and Bit Flip Register 19 */
#define MTU_MC2_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061286u)

/** \brief 288, Read Data and Bit Flip Register 20 */
#define MTU_MC2_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061288u)

/** \brief 28A, Read Data and Bit Flip Register 21 */
#define MTU_MC2_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006128Au)

/** \brief 28C, Read Data and Bit Flip Register 22 */
#define MTU_MC2_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006128Cu)

/** \brief 28E, Read Data and Bit Flip Register 23 */
#define MTU_MC2_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006128Eu)

/** \brief 290, Read Data and Bit Flip Register 24 */
#define MTU_MC2_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061290u)

/** \brief 292, Read Data and Bit Flip Register 25 */
#define MTU_MC2_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061292u)

/** \brief 294, Read Data and Bit Flip Register 26 */
#define MTU_MC2_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061294u)

/** \brief 296, Read Data and Bit Flip Register 27 */
#define MTU_MC2_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061296u)

/** \brief 298, Read Data and Bit Flip Register 28 */
#define MTU_MC2_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061298u)

/** \brief 29A, Read Data and Bit Flip Register 29 */
#define MTU_MC2_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006129Au)

/** \brief 29C, Read Data and Bit Flip Register 30 */
#define MTU_MC2_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006129Cu)

/** \brief 29E, Read Data and Bit Flip Register 31 */
#define MTU_MC2_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006129Eu)

/** \brief 2A0, Read Data and Bit Flip Register 32 */
#define MTU_MC2_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612A0u)

/** \brief 2A2, Read Data and Bit Flip Register 33 */
#define MTU_MC2_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612A2u)

/** \brief 2A4, Read Data and Bit Flip Register 34 */
#define MTU_MC2_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612A4u)

/** \brief 2A6, Read Data and Bit Flip Register 35 */
#define MTU_MC2_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612A6u)

/** \brief 2A8, Read Data and Bit Flip Register 36 */
#define MTU_MC2_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612A8u)

/** \brief 2AA, Read Data and Bit Flip Register 37 */
#define MTU_MC2_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612AAu)

/** \brief 2AC, Read Data and Bit Flip Register 38 */
#define MTU_MC2_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612ACu)

/** \brief 2AE, Read Data and Bit Flip Register 39 */
#define MTU_MC2_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612AEu)

/** \brief 2B0, Read Data and Bit Flip Register 40 */
#define MTU_MC2_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612B0u)

/** \brief 2B2, Read Data and Bit Flip Register 41 */
#define MTU_MC2_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612B2u)

/** \brief 2B4, Read Data and Bit Flip Register 42 */
#define MTU_MC2_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612B4u)

/** \brief 2B6, Read Data and Bit Flip Register 43 */
#define MTU_MC2_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612B6u)

/** \brief 2B8, Read Data and Bit Flip Register 44 */
#define MTU_MC2_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612B8u)

/** \brief 2BA, Read Data and Bit Flip Register 45 */
#define MTU_MC2_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612BAu)

/** \brief 2BC, Read Data and Bit Flip Register 46 */
#define MTU_MC2_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612BCu)

/** \brief 2BE, Read Data and Bit Flip Register 47 */
#define MTU_MC2_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612BEu)

/** \brief 2C0, Read Data and Bit Flip Register 48 */
#define MTU_MC2_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612C0u)

/** \brief 2C2, Read Data and Bit Flip Register 49 */
#define MTU_MC2_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612C2u)

/** \brief 2C4, Read Data and Bit Flip Register 50 */
#define MTU_MC2_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612C4u)

/** \brief 2C6, Read Data and Bit Flip Register 51 */
#define MTU_MC2_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612C6u)

/** \brief 2C8, Read Data and Bit Flip Register 52 */
#define MTU_MC2_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612C8u)

/** \brief 2CA, Read Data and Bit Flip Register 53 */
#define MTU_MC2_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612CAu)

/** \brief 2CC, Read Data and Bit Flip Register 54 */
#define MTU_MC2_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612CCu)

/** \brief 2CE, Read Data and Bit Flip Register 55 */
#define MTU_MC2_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612CEu)

/** \brief 2D0, Read Data and Bit Flip Register 56 */
#define MTU_MC2_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612D0u)

/** \brief 2D2, Read Data and Bit Flip Register 57 */
#define MTU_MC2_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612D2u)

/** \brief 2D4, Read Data and Bit Flip Register 58 */
#define MTU_MC2_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612D4u)

/** \brief 2D6, Read Data and Bit Flip Register 59 */
#define MTU_MC2_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612D6u)

/** \brief 2D8, Read Data and Bit Flip Register 60 */
#define MTU_MC2_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612D8u)

/** \brief 2DA, Read Data and Bit Flip Register 61 */
#define MTU_MC2_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612DAu)

/** \brief 2DC, Read Data and Bit Flip Register 62 */
#define MTU_MC2_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612DCu)

/** \brief 2DE, Read Data and Bit Flip Register 63 */
#define MTU_MC2_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612DEu)

/** \brief 2E0, Read Data and Bit Flip Register 64 */
#define MTU_MC2_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612E0u)

/** \brief 2E2, Read Data and Bit Flip Register 65 */
#define MTU_MC2_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612E2u)

/** \brief 2E4, Read Data and Bit Flip Register 66 */
#define MTU_MC2_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00612E4u)

/** \brief 2EE, Alarm Sources Configuration Register */
#define MTU_MC2_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00612EEu)

/** \brief 2F0, SSH Safety Faults Status Register  */
#define MTU_MC2_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00612F0u)

/** \brief 2F2, Error Information Register 0 */
#define MTU_MC2_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00612F2u)

/** \brief 2F4, Error Information Register 1 */
#define MTU_MC2_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00612F4u)

/** \brief 2F6, Error Information Register 2 */
#define MTU_MC2_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00612F6u)

/** \brief 2F8, Error Information Register 3 */
#define MTU_MC2_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00612F8u)

/** \brief 2FA, Error Information Register 4 */
#define MTU_MC2_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00612FAu)

/** \brief 300, Configuration Registers */
#define MTU_MC3_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061300u)

/** \brief 302, Configuration Register 1 */
#define MTU_MC3_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061302u)

/** \brief 304, MBIST Control Register */
#define MTU_MC3_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061304u)

/** \brief 306, Status Register */
#define MTU_MC3_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061306u)

/** \brief 308, Range Register, single address mode */
#define MTU_MC3_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061308u)

/** \brief 30C, Revision ID Register */
#define MTU_MC3_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006130Cu)

/** \brief 30E, ECC Safety Register */
#define MTU_MC3_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006130Eu)

/** \brief 310, Memory ECC Detection Register */
#define MTU_MC3_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061310u)

/** \brief 312, Error Tracking Register 0 */
#define MTU_MC3_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061312u)

/** \brief 314, Error Tracking Register 1 */
#define MTU_MC3_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061314u)

/** \brief 316, Error Tracking Register 2 */
#define MTU_MC3_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061316u)

/** \brief 318, Error Tracking Register 3 */
#define MTU_MC3_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061318u)

/** \brief 31A, Error Tracking Register 4 */
#define MTU_MC3_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006131Au)

/** \brief 360, Read Data and Bit Flip Register 0 */
#define MTU_MC3_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061360u)

/** \brief 362, Read Data and Bit Flip Register 1 */
#define MTU_MC3_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061362u)

/** \brief 364, Read Data and Bit Flip Register 2 */
#define MTU_MC3_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061364u)

/** \brief 366, Read Data and Bit Flip Register 3 */
#define MTU_MC3_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061366u)

/** \brief 368, Read Data and Bit Flip Register 4 */
#define MTU_MC3_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061368u)

/** \brief 36A, Read Data and Bit Flip Register 5 */
#define MTU_MC3_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006136Au)

/** \brief 36C, Read Data and Bit Flip Register 6 */
#define MTU_MC3_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006136Cu)

/** \brief 36E, Read Data and Bit Flip Register 7 */
#define MTU_MC3_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006136Eu)

/** \brief 370, Read Data and Bit Flip Register 8 */
#define MTU_MC3_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061370u)

/** \brief 372, Read Data and Bit Flip Register 9 */
#define MTU_MC3_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061372u)

/** \brief 374, Read Data and Bit Flip Register 10 */
#define MTU_MC3_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061374u)

/** \brief 376, Read Data and Bit Flip Register 11 */
#define MTU_MC3_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061376u)

/** \brief 378, Read Data and Bit Flip Register 12 */
#define MTU_MC3_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061378u)

/** \brief 37A, Read Data and Bit Flip Register 13 */
#define MTU_MC3_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006137Au)

/** \brief 37C, Read Data and Bit Flip Register 14 */
#define MTU_MC3_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006137Cu)

/** \brief 37E, Read Data and Bit Flip Register 15 */
#define MTU_MC3_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006137Eu)

/** \brief 380, Read Data and Bit Flip Register 16 */
#define MTU_MC3_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061380u)

/** \brief 382, Read Data and Bit Flip Register 17 */
#define MTU_MC3_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061382u)

/** \brief 384, Read Data and Bit Flip Register 18 */
#define MTU_MC3_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061384u)

/** \brief 386, Read Data and Bit Flip Register 19 */
#define MTU_MC3_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061386u)

/** \brief 388, Read Data and Bit Flip Register 20 */
#define MTU_MC3_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061388u)

/** \brief 38A, Read Data and Bit Flip Register 21 */
#define MTU_MC3_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006138Au)

/** \brief 38C, Read Data and Bit Flip Register 22 */
#define MTU_MC3_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006138Cu)

/** \brief 38E, Read Data and Bit Flip Register 23 */
#define MTU_MC3_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006138Eu)

/** \brief 390, Read Data and Bit Flip Register 24 */
#define MTU_MC3_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061390u)

/** \brief 392, Read Data and Bit Flip Register 25 */
#define MTU_MC3_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061392u)

/** \brief 394, Read Data and Bit Flip Register 26 */
#define MTU_MC3_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061394u)

/** \brief 396, Read Data and Bit Flip Register 27 */
#define MTU_MC3_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061396u)

/** \brief 398, Read Data and Bit Flip Register 28 */
#define MTU_MC3_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061398u)

/** \brief 39A, Read Data and Bit Flip Register 29 */
#define MTU_MC3_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006139Au)

/** \brief 39C, Read Data and Bit Flip Register 30 */
#define MTU_MC3_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006139Cu)

/** \brief 39E, Read Data and Bit Flip Register 31 */
#define MTU_MC3_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006139Eu)

/** \brief 3A0, Read Data and Bit Flip Register 32 */
#define MTU_MC3_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613A0u)

/** \brief 3A2, Read Data and Bit Flip Register 33 */
#define MTU_MC3_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613A2u)

/** \brief 3A4, Read Data and Bit Flip Register 34 */
#define MTU_MC3_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613A4u)

/** \brief 3A6, Read Data and Bit Flip Register 35 */
#define MTU_MC3_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613A6u)

/** \brief 3A8, Read Data and Bit Flip Register 36 */
#define MTU_MC3_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613A8u)

/** \brief 3AA, Read Data and Bit Flip Register 37 */
#define MTU_MC3_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613AAu)

/** \brief 3AC, Read Data and Bit Flip Register 38 */
#define MTU_MC3_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613ACu)

/** \brief 3AE, Read Data and Bit Flip Register 39 */
#define MTU_MC3_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613AEu)

/** \brief 3B0, Read Data and Bit Flip Register 40 */
#define MTU_MC3_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613B0u)

/** \brief 3B2, Read Data and Bit Flip Register 41 */
#define MTU_MC3_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613B2u)

/** \brief 3B4, Read Data and Bit Flip Register 42 */
#define MTU_MC3_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613B4u)

/** \brief 3B6, Read Data and Bit Flip Register 43 */
#define MTU_MC3_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613B6u)

/** \brief 3B8, Read Data and Bit Flip Register 44 */
#define MTU_MC3_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613B8u)

/** \brief 3BA, Read Data and Bit Flip Register 45 */
#define MTU_MC3_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613BAu)

/** \brief 3BC, Read Data and Bit Flip Register 46 */
#define MTU_MC3_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613BCu)

/** \brief 3BE, Read Data and Bit Flip Register 47 */
#define MTU_MC3_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613BEu)

/** \brief 3C0, Read Data and Bit Flip Register 48 */
#define MTU_MC3_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613C0u)

/** \brief 3C2, Read Data and Bit Flip Register 49 */
#define MTU_MC3_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613C2u)

/** \brief 3C4, Read Data and Bit Flip Register 50 */
#define MTU_MC3_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613C4u)

/** \brief 3C6, Read Data and Bit Flip Register 51 */
#define MTU_MC3_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613C6u)

/** \brief 3C8, Read Data and Bit Flip Register 52 */
#define MTU_MC3_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613C8u)

/** \brief 3CA, Read Data and Bit Flip Register 53 */
#define MTU_MC3_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613CAu)

/** \brief 3CC, Read Data and Bit Flip Register 54 */
#define MTU_MC3_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613CCu)

/** \brief 3CE, Read Data and Bit Flip Register 55 */
#define MTU_MC3_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613CEu)

/** \brief 3D0, Read Data and Bit Flip Register 56 */
#define MTU_MC3_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613D0u)

/** \brief 3D2, Read Data and Bit Flip Register 57 */
#define MTU_MC3_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613D2u)

/** \brief 3D4, Read Data and Bit Flip Register 58 */
#define MTU_MC3_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613D4u)

/** \brief 3D6, Read Data and Bit Flip Register 59 */
#define MTU_MC3_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613D6u)

/** \brief 3D8, Read Data and Bit Flip Register 60 */
#define MTU_MC3_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613D8u)

/** \brief 3DA, Read Data and Bit Flip Register 61 */
#define MTU_MC3_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613DAu)

/** \brief 3DC, Read Data and Bit Flip Register 62 */
#define MTU_MC3_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613DCu)

/** \brief 3DE, Read Data and Bit Flip Register 63 */
#define MTU_MC3_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613DEu)

/** \brief 3E0, Read Data and Bit Flip Register 64 */
#define MTU_MC3_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613E0u)

/** \brief 3E2, Read Data and Bit Flip Register 65 */
#define MTU_MC3_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613E2u)

/** \brief 3E4, Read Data and Bit Flip Register 66 */
#define MTU_MC3_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00613E4u)

/** \brief 3EE, Alarm Sources Configuration Register */
#define MTU_MC3_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00613EEu)

/** \brief 3F0, SSH Safety Faults Status Register  */
#define MTU_MC3_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00613F0u)

/** \brief 3F2, Error Information Register 0 */
#define MTU_MC3_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00613F2u)

/** \brief 3F4, Error Information Register 1 */
#define MTU_MC3_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00613F4u)

/** \brief 3F6, Error Information Register 2 */
#define MTU_MC3_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00613F6u)

/** \brief 3F8, Error Information Register 3 */
#define MTU_MC3_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00613F8u)

/** \brief 3FA, Error Information Register 4 */
#define MTU_MC3_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00613FAu)

/** \brief 400, Configuration Registers */
#define MTU_MC4_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061400u)

/** \brief 402, Configuration Register 1 */
#define MTU_MC4_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061402u)

/** \brief 404, MBIST Control Register */
#define MTU_MC4_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061404u)

/** \brief 406, Status Register */
#define MTU_MC4_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061406u)

/** \brief 408, Range Register, single address mode */
#define MTU_MC4_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061408u)

/** \brief 40C, Revision ID Register */
#define MTU_MC4_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006140Cu)

/** \brief 40E, ECC Safety Register */
#define MTU_MC4_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006140Eu)

/** \brief 410, Memory ECC Detection Register */
#define MTU_MC4_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061410u)

/** \brief 412, Error Tracking Register 0 */
#define MTU_MC4_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061412u)

/** \brief 414, Error Tracking Register 1 */
#define MTU_MC4_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061414u)

/** \brief 416, Error Tracking Register 2 */
#define MTU_MC4_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061416u)

/** \brief 418, Error Tracking Register 3 */
#define MTU_MC4_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061418u)

/** \brief 41A, Error Tracking Register 4 */
#define MTU_MC4_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006141Au)

/** \brief 460, Read Data and Bit Flip Register 0 */
#define MTU_MC4_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061460u)

/** \brief 462, Read Data and Bit Flip Register 1 */
#define MTU_MC4_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061462u)

/** \brief 464, Read Data and Bit Flip Register 2 */
#define MTU_MC4_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061464u)

/** \brief 466, Read Data and Bit Flip Register 3 */
#define MTU_MC4_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061466u)

/** \brief 468, Read Data and Bit Flip Register 4 */
#define MTU_MC4_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061468u)

/** \brief 46A, Read Data and Bit Flip Register 5 */
#define MTU_MC4_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006146Au)

/** \brief 46C, Read Data and Bit Flip Register 6 */
#define MTU_MC4_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006146Cu)

/** \brief 46E, Read Data and Bit Flip Register 7 */
#define MTU_MC4_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006146Eu)

/** \brief 470, Read Data and Bit Flip Register 8 */
#define MTU_MC4_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061470u)

/** \brief 472, Read Data and Bit Flip Register 9 */
#define MTU_MC4_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061472u)

/** \brief 474, Read Data and Bit Flip Register 10 */
#define MTU_MC4_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061474u)

/** \brief 476, Read Data and Bit Flip Register 11 */
#define MTU_MC4_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061476u)

/** \brief 478, Read Data and Bit Flip Register 12 */
#define MTU_MC4_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061478u)

/** \brief 47A, Read Data and Bit Flip Register 13 */
#define MTU_MC4_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006147Au)

/** \brief 47C, Read Data and Bit Flip Register 14 */
#define MTU_MC4_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006147Cu)

/** \brief 47E, Read Data and Bit Flip Register 15 */
#define MTU_MC4_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006147Eu)

/** \brief 480, Read Data and Bit Flip Register 16 */
#define MTU_MC4_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061480u)

/** \brief 482, Read Data and Bit Flip Register 17 */
#define MTU_MC4_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061482u)

/** \brief 484, Read Data and Bit Flip Register 18 */
#define MTU_MC4_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061484u)

/** \brief 486, Read Data and Bit Flip Register 19 */
#define MTU_MC4_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061486u)

/** \brief 488, Read Data and Bit Flip Register 20 */
#define MTU_MC4_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061488u)

/** \brief 48A, Read Data and Bit Flip Register 21 */
#define MTU_MC4_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006148Au)

/** \brief 48C, Read Data and Bit Flip Register 22 */
#define MTU_MC4_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006148Cu)

/** \brief 48E, Read Data and Bit Flip Register 23 */
#define MTU_MC4_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006148Eu)

/** \brief 490, Read Data and Bit Flip Register 24 */
#define MTU_MC4_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061490u)

/** \brief 492, Read Data and Bit Flip Register 25 */
#define MTU_MC4_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061492u)

/** \brief 494, Read Data and Bit Flip Register 26 */
#define MTU_MC4_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061494u)

/** \brief 496, Read Data and Bit Flip Register 27 */
#define MTU_MC4_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061496u)

/** \brief 498, Read Data and Bit Flip Register 28 */
#define MTU_MC4_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061498u)

/** \brief 49A, Read Data and Bit Flip Register 29 */
#define MTU_MC4_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006149Au)

/** \brief 49C, Read Data and Bit Flip Register 30 */
#define MTU_MC4_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006149Cu)

/** \brief 49E, Read Data and Bit Flip Register 31 */
#define MTU_MC4_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006149Eu)

/** \brief 4A0, Read Data and Bit Flip Register 32 */
#define MTU_MC4_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614A0u)

/** \brief 4A2, Read Data and Bit Flip Register 33 */
#define MTU_MC4_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614A2u)

/** \brief 4A4, Read Data and Bit Flip Register 34 */
#define MTU_MC4_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614A4u)

/** \brief 4A6, Read Data and Bit Flip Register 35 */
#define MTU_MC4_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614A6u)

/** \brief 4A8, Read Data and Bit Flip Register 36 */
#define MTU_MC4_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614A8u)

/** \brief 4AA, Read Data and Bit Flip Register 37 */
#define MTU_MC4_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614AAu)

/** \brief 4AC, Read Data and Bit Flip Register 38 */
#define MTU_MC4_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614ACu)

/** \brief 4AE, Read Data and Bit Flip Register 39 */
#define MTU_MC4_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614AEu)

/** \brief 4B0, Read Data and Bit Flip Register 40 */
#define MTU_MC4_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614B0u)

/** \brief 4B2, Read Data and Bit Flip Register 41 */
#define MTU_MC4_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614B2u)

/** \brief 4B4, Read Data and Bit Flip Register 42 */
#define MTU_MC4_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614B4u)

/** \brief 4B6, Read Data and Bit Flip Register 43 */
#define MTU_MC4_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614B6u)

/** \brief 4B8, Read Data and Bit Flip Register 44 */
#define MTU_MC4_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614B8u)

/** \brief 4BA, Read Data and Bit Flip Register 45 */
#define MTU_MC4_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614BAu)

/** \brief 4BC, Read Data and Bit Flip Register 46 */
#define MTU_MC4_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614BCu)

/** \brief 4BE, Read Data and Bit Flip Register 47 */
#define MTU_MC4_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614BEu)

/** \brief 4C0, Read Data and Bit Flip Register 48 */
#define MTU_MC4_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614C0u)

/** \brief 4C2, Read Data and Bit Flip Register 49 */
#define MTU_MC4_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614C2u)

/** \brief 4C4, Read Data and Bit Flip Register 50 */
#define MTU_MC4_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614C4u)

/** \brief 4C6, Read Data and Bit Flip Register 51 */
#define MTU_MC4_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614C6u)

/** \brief 4C8, Read Data and Bit Flip Register 52 */
#define MTU_MC4_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614C8u)

/** \brief 4CA, Read Data and Bit Flip Register 53 */
#define MTU_MC4_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614CAu)

/** \brief 4CC, Read Data and Bit Flip Register 54 */
#define MTU_MC4_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614CCu)

/** \brief 4CE, Read Data and Bit Flip Register 55 */
#define MTU_MC4_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614CEu)

/** \brief 4D0, Read Data and Bit Flip Register 56 */
#define MTU_MC4_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614D0u)

/** \brief 4D2, Read Data and Bit Flip Register 57 */
#define MTU_MC4_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614D2u)

/** \brief 4D4, Read Data and Bit Flip Register 58 */
#define MTU_MC4_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614D4u)

/** \brief 4D6, Read Data and Bit Flip Register 59 */
#define MTU_MC4_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614D6u)

/** \brief 4D8, Read Data and Bit Flip Register 60 */
#define MTU_MC4_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614D8u)

/** \brief 4DA, Read Data and Bit Flip Register 61 */
#define MTU_MC4_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614DAu)

/** \brief 4DC, Read Data and Bit Flip Register 62 */
#define MTU_MC4_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614DCu)

/** \brief 4DE, Read Data and Bit Flip Register 63 */
#define MTU_MC4_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614DEu)

/** \brief 4E0, Read Data and Bit Flip Register 64 */
#define MTU_MC4_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614E0u)

/** \brief 4E2, Read Data and Bit Flip Register 65 */
#define MTU_MC4_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614E2u)

/** \brief 4E4, Read Data and Bit Flip Register 66 */
#define MTU_MC4_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00614E4u)

/** \brief 4EE, Alarm Sources Configuration Register */
#define MTU_MC4_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00614EEu)

/** \brief 4F0, SSH Safety Faults Status Register  */
#define MTU_MC4_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00614F0u)

/** \brief 4F2, Error Information Register 0 */
#define MTU_MC4_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00614F2u)

/** \brief 4F4, Error Information Register 1 */
#define MTU_MC4_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00614F4u)

/** \brief 4F6, Error Information Register 2 */
#define MTU_MC4_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00614F6u)

/** \brief 4F8, Error Information Register 3 */
#define MTU_MC4_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00614F8u)

/** \brief 4FA, Error Information Register 4 */
#define MTU_MC4_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00614FAu)

/** \brief 500, Configuration Registers */
#define MTU_MC5_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061500u)

/** \brief 502, Configuration Register 1 */
#define MTU_MC5_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061502u)

/** \brief 504, MBIST Control Register */
#define MTU_MC5_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061504u)

/** \brief 506, Status Register */
#define MTU_MC5_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061506u)

/** \brief 508, Range Register, single address mode */
#define MTU_MC5_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061508u)

/** \brief 50C, Revision ID Register */
#define MTU_MC5_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006150Cu)

/** \brief 50E, ECC Safety Register */
#define MTU_MC5_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006150Eu)

/** \brief 510, Memory ECC Detection Register */
#define MTU_MC5_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061510u)

/** \brief 512, Error Tracking Register 0 */
#define MTU_MC5_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061512u)

/** \brief 514, Error Tracking Register 1 */
#define MTU_MC5_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061514u)

/** \brief 516, Error Tracking Register 2 */
#define MTU_MC5_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061516u)

/** \brief 518, Error Tracking Register 3 */
#define MTU_MC5_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061518u)

/** \brief 51A, Error Tracking Register 4 */
#define MTU_MC5_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006151Au)

/** \brief 560, Read Data and Bit Flip Register 0 */
#define MTU_MC5_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061560u)

/** \brief 562, Read Data and Bit Flip Register 1 */
#define MTU_MC5_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061562u)

/** \brief 564, Read Data and Bit Flip Register 2 */
#define MTU_MC5_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061564u)

/** \brief 566, Read Data and Bit Flip Register 3 */
#define MTU_MC5_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061566u)

/** \brief 568, Read Data and Bit Flip Register 4 */
#define MTU_MC5_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061568u)

/** \brief 56A, Read Data and Bit Flip Register 5 */
#define MTU_MC5_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006156Au)

/** \brief 56C, Read Data and Bit Flip Register 6 */
#define MTU_MC5_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006156Cu)

/** \brief 56E, Read Data and Bit Flip Register 7 */
#define MTU_MC5_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006156Eu)

/** \brief 570, Read Data and Bit Flip Register 8 */
#define MTU_MC5_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061570u)

/** \brief 572, Read Data and Bit Flip Register 9 */
#define MTU_MC5_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061572u)

/** \brief 574, Read Data and Bit Flip Register 10 */
#define MTU_MC5_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061574u)

/** \brief 576, Read Data and Bit Flip Register 11 */
#define MTU_MC5_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061576u)

/** \brief 578, Read Data and Bit Flip Register 12 */
#define MTU_MC5_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061578u)

/** \brief 57A, Read Data and Bit Flip Register 13 */
#define MTU_MC5_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006157Au)

/** \brief 57C, Read Data and Bit Flip Register 14 */
#define MTU_MC5_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006157Cu)

/** \brief 57E, Read Data and Bit Flip Register 15 */
#define MTU_MC5_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006157Eu)

/** \brief 580, Read Data and Bit Flip Register 16 */
#define MTU_MC5_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061580u)

/** \brief 582, Read Data and Bit Flip Register 17 */
#define MTU_MC5_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061582u)

/** \brief 584, Read Data and Bit Flip Register 18 */
#define MTU_MC5_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061584u)

/** \brief 586, Read Data and Bit Flip Register 19 */
#define MTU_MC5_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061586u)

/** \brief 588, Read Data and Bit Flip Register 20 */
#define MTU_MC5_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061588u)

/** \brief 58A, Read Data and Bit Flip Register 21 */
#define MTU_MC5_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006158Au)

/** \brief 58C, Read Data and Bit Flip Register 22 */
#define MTU_MC5_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006158Cu)

/** \brief 58E, Read Data and Bit Flip Register 23 */
#define MTU_MC5_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006158Eu)

/** \brief 590, Read Data and Bit Flip Register 24 */
#define MTU_MC5_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061590u)

/** \brief 592, Read Data and Bit Flip Register 25 */
#define MTU_MC5_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061592u)

/** \brief 594, Read Data and Bit Flip Register 26 */
#define MTU_MC5_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061594u)

/** \brief 596, Read Data and Bit Flip Register 27 */
#define MTU_MC5_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061596u)

/** \brief 598, Read Data and Bit Flip Register 28 */
#define MTU_MC5_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061598u)

/** \brief 59A, Read Data and Bit Flip Register 29 */
#define MTU_MC5_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006159Au)

/** \brief 59C, Read Data and Bit Flip Register 30 */
#define MTU_MC5_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006159Cu)

/** \brief 59E, Read Data and Bit Flip Register 31 */
#define MTU_MC5_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006159Eu)

/** \brief 5A0, Read Data and Bit Flip Register 32 */
#define MTU_MC5_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615A0u)

/** \brief 5A2, Read Data and Bit Flip Register 33 */
#define MTU_MC5_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615A2u)

/** \brief 5A4, Read Data and Bit Flip Register 34 */
#define MTU_MC5_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615A4u)

/** \brief 5A6, Read Data and Bit Flip Register 35 */
#define MTU_MC5_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615A6u)

/** \brief 5A8, Read Data and Bit Flip Register 36 */
#define MTU_MC5_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615A8u)

/** \brief 5AA, Read Data and Bit Flip Register 37 */
#define MTU_MC5_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615AAu)

/** \brief 5AC, Read Data and Bit Flip Register 38 */
#define MTU_MC5_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615ACu)

/** \brief 5AE, Read Data and Bit Flip Register 39 */
#define MTU_MC5_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615AEu)

/** \brief 5B0, Read Data and Bit Flip Register 40 */
#define MTU_MC5_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615B0u)

/** \brief 5B2, Read Data and Bit Flip Register 41 */
#define MTU_MC5_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615B2u)

/** \brief 5B4, Read Data and Bit Flip Register 42 */
#define MTU_MC5_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615B4u)

/** \brief 5B6, Read Data and Bit Flip Register 43 */
#define MTU_MC5_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615B6u)

/** \brief 5B8, Read Data and Bit Flip Register 44 */
#define MTU_MC5_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615B8u)

/** \brief 5BA, Read Data and Bit Flip Register 45 */
#define MTU_MC5_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615BAu)

/** \brief 5BC, Read Data and Bit Flip Register 46 */
#define MTU_MC5_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615BCu)

/** \brief 5BE, Read Data and Bit Flip Register 47 */
#define MTU_MC5_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615BEu)

/** \brief 5C0, Read Data and Bit Flip Register 48 */
#define MTU_MC5_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615C0u)

/** \brief 5C2, Read Data and Bit Flip Register 49 */
#define MTU_MC5_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615C2u)

/** \brief 5C4, Read Data and Bit Flip Register 50 */
#define MTU_MC5_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615C4u)

/** \brief 5C6, Read Data and Bit Flip Register 51 */
#define MTU_MC5_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615C6u)

/** \brief 5C8, Read Data and Bit Flip Register 52 */
#define MTU_MC5_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615C8u)

/** \brief 5CA, Read Data and Bit Flip Register 53 */
#define MTU_MC5_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615CAu)

/** \brief 5CC, Read Data and Bit Flip Register 54 */
#define MTU_MC5_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615CCu)

/** \brief 5CE, Read Data and Bit Flip Register 55 */
#define MTU_MC5_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615CEu)

/** \brief 5D0, Read Data and Bit Flip Register 56 */
#define MTU_MC5_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615D0u)

/** \brief 5D2, Read Data and Bit Flip Register 57 */
#define MTU_MC5_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615D2u)

/** \brief 5D4, Read Data and Bit Flip Register 58 */
#define MTU_MC5_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615D4u)

/** \brief 5D6, Read Data and Bit Flip Register 59 */
#define MTU_MC5_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615D6u)

/** \brief 5D8, Read Data and Bit Flip Register 60 */
#define MTU_MC5_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615D8u)

/** \brief 5DA, Read Data and Bit Flip Register 61 */
#define MTU_MC5_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615DAu)

/** \brief 5DC, Read Data and Bit Flip Register 62 */
#define MTU_MC5_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615DCu)

/** \brief 5DE, Read Data and Bit Flip Register 63 */
#define MTU_MC5_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615DEu)

/** \brief 5E0, Read Data and Bit Flip Register 64 */
#define MTU_MC5_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615E0u)

/** \brief 5E2, Read Data and Bit Flip Register 65 */
#define MTU_MC5_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615E2u)

/** \brief 5E4, Read Data and Bit Flip Register 66 */
#define MTU_MC5_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00615E4u)

/** \brief 5EE, Alarm Sources Configuration Register */
#define MTU_MC5_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00615EEu)

/** \brief 5F0, SSH Safety Faults Status Register  */
#define MTU_MC5_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00615F0u)

/** \brief 5F2, Error Information Register 0 */
#define MTU_MC5_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00615F2u)

/** \brief 5F4, Error Information Register 1 */
#define MTU_MC5_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00615F4u)

/** \brief 5F6, Error Information Register 2 */
#define MTU_MC5_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00615F6u)

/** \brief 5F8, Error Information Register 3 */
#define MTU_MC5_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00615F8u)

/** \brief 5FA, Error Information Register 4 */
#define MTU_MC5_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00615FAu)

/** \brief 600, Configuration Registers */
#define MTU_MC6_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061600u)

/** \brief 602, Configuration Register 1 */
#define MTU_MC6_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061602u)

/** \brief 604, MBIST Control Register */
#define MTU_MC6_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061604u)

/** \brief 606, Status Register */
#define MTU_MC6_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061606u)

/** \brief 608, Range Register, single address mode */
#define MTU_MC6_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061608u)

/** \brief 60C, Revision ID Register */
#define MTU_MC6_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006160Cu)

/** \brief 60E, ECC Safety Register */
#define MTU_MC6_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006160Eu)

/** \brief 610, Memory ECC Detection Register */
#define MTU_MC6_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061610u)

/** \brief 612, Error Tracking Register 0 */
#define MTU_MC6_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061612u)

/** \brief 614, Error Tracking Register 1 */
#define MTU_MC6_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061614u)

/** \brief 616, Error Tracking Register 2 */
#define MTU_MC6_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061616u)

/** \brief 618, Error Tracking Register 3 */
#define MTU_MC6_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061618u)

/** \brief 61A, Error Tracking Register 4 */
#define MTU_MC6_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006161Au)

/** \brief 660, Read Data and Bit Flip Register 0 */
#define MTU_MC6_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061660u)

/** \brief 662, Read Data and Bit Flip Register 1 */
#define MTU_MC6_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061662u)

/** \brief 664, Read Data and Bit Flip Register 2 */
#define MTU_MC6_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061664u)

/** \brief 666, Read Data and Bit Flip Register 3 */
#define MTU_MC6_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061666u)

/** \brief 668, Read Data and Bit Flip Register 4 */
#define MTU_MC6_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061668u)

/** \brief 66A, Read Data and Bit Flip Register 5 */
#define MTU_MC6_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006166Au)

/** \brief 66C, Read Data and Bit Flip Register 6 */
#define MTU_MC6_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006166Cu)

/** \brief 66E, Read Data and Bit Flip Register 7 */
#define MTU_MC6_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006166Eu)

/** \brief 670, Read Data and Bit Flip Register 8 */
#define MTU_MC6_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061670u)

/** \brief 672, Read Data and Bit Flip Register 9 */
#define MTU_MC6_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061672u)

/** \brief 674, Read Data and Bit Flip Register 10 */
#define MTU_MC6_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061674u)

/** \brief 676, Read Data and Bit Flip Register 11 */
#define MTU_MC6_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061676u)

/** \brief 678, Read Data and Bit Flip Register 12 */
#define MTU_MC6_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061678u)

/** \brief 67A, Read Data and Bit Flip Register 13 */
#define MTU_MC6_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006167Au)

/** \brief 67C, Read Data and Bit Flip Register 14 */
#define MTU_MC6_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006167Cu)

/** \brief 67E, Read Data and Bit Flip Register 15 */
#define MTU_MC6_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006167Eu)

/** \brief 680, Read Data and Bit Flip Register 16 */
#define MTU_MC6_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061680u)

/** \brief 682, Read Data and Bit Flip Register 17 */
#define MTU_MC6_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061682u)

/** \brief 684, Read Data and Bit Flip Register 18 */
#define MTU_MC6_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061684u)

/** \brief 686, Read Data and Bit Flip Register 19 */
#define MTU_MC6_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061686u)

/** \brief 688, Read Data and Bit Flip Register 20 */
#define MTU_MC6_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061688u)

/** \brief 68A, Read Data and Bit Flip Register 21 */
#define MTU_MC6_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006168Au)

/** \brief 68C, Read Data and Bit Flip Register 22 */
#define MTU_MC6_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006168Cu)

/** \brief 68E, Read Data and Bit Flip Register 23 */
#define MTU_MC6_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006168Eu)

/** \brief 690, Read Data and Bit Flip Register 24 */
#define MTU_MC6_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061690u)

/** \brief 692, Read Data and Bit Flip Register 25 */
#define MTU_MC6_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061692u)

/** \brief 694, Read Data and Bit Flip Register 26 */
#define MTU_MC6_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061694u)

/** \brief 696, Read Data and Bit Flip Register 27 */
#define MTU_MC6_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061696u)

/** \brief 698, Read Data and Bit Flip Register 28 */
#define MTU_MC6_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061698u)

/** \brief 69A, Read Data and Bit Flip Register 29 */
#define MTU_MC6_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006169Au)

/** \brief 69C, Read Data and Bit Flip Register 30 */
#define MTU_MC6_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006169Cu)

/** \brief 69E, Read Data and Bit Flip Register 31 */
#define MTU_MC6_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006169Eu)

/** \brief 6A0, Read Data and Bit Flip Register 32 */
#define MTU_MC6_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616A0u)

/** \brief 6A2, Read Data and Bit Flip Register 33 */
#define MTU_MC6_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616A2u)

/** \brief 6A4, Read Data and Bit Flip Register 34 */
#define MTU_MC6_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616A4u)

/** \brief 6A6, Read Data and Bit Flip Register 35 */
#define MTU_MC6_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616A6u)

/** \brief 6A8, Read Data and Bit Flip Register 36 */
#define MTU_MC6_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616A8u)

/** \brief 6AA, Read Data and Bit Flip Register 37 */
#define MTU_MC6_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616AAu)

/** \brief 6AC, Read Data and Bit Flip Register 38 */
#define MTU_MC6_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616ACu)

/** \brief 6AE, Read Data and Bit Flip Register 39 */
#define MTU_MC6_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616AEu)

/** \brief 6B0, Read Data and Bit Flip Register 40 */
#define MTU_MC6_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616B0u)

/** \brief 6B2, Read Data and Bit Flip Register 41 */
#define MTU_MC6_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616B2u)

/** \brief 6B4, Read Data and Bit Flip Register 42 */
#define MTU_MC6_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616B4u)

/** \brief 6B6, Read Data and Bit Flip Register 43 */
#define MTU_MC6_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616B6u)

/** \brief 6B8, Read Data and Bit Flip Register 44 */
#define MTU_MC6_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616B8u)

/** \brief 6BA, Read Data and Bit Flip Register 45 */
#define MTU_MC6_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616BAu)

/** \brief 6BC, Read Data and Bit Flip Register 46 */
#define MTU_MC6_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616BCu)

/** \brief 6BE, Read Data and Bit Flip Register 47 */
#define MTU_MC6_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616BEu)

/** \brief 6C0, Read Data and Bit Flip Register 48 */
#define MTU_MC6_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616C0u)

/** \brief 6C2, Read Data and Bit Flip Register 49 */
#define MTU_MC6_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616C2u)

/** \brief 6C4, Read Data and Bit Flip Register 50 */
#define MTU_MC6_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616C4u)

/** \brief 6C6, Read Data and Bit Flip Register 51 */
#define MTU_MC6_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616C6u)

/** \brief 6C8, Read Data and Bit Flip Register 52 */
#define MTU_MC6_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616C8u)

/** \brief 6CA, Read Data and Bit Flip Register 53 */
#define MTU_MC6_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616CAu)

/** \brief 6CC, Read Data and Bit Flip Register 54 */
#define MTU_MC6_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616CCu)

/** \brief 6CE, Read Data and Bit Flip Register 55 */
#define MTU_MC6_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616CEu)

/** \brief 6D0, Read Data and Bit Flip Register 56 */
#define MTU_MC6_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616D0u)

/** \brief 6D2, Read Data and Bit Flip Register 57 */
#define MTU_MC6_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616D2u)

/** \brief 6D4, Read Data and Bit Flip Register 58 */
#define MTU_MC6_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616D4u)

/** \brief 6D6, Read Data and Bit Flip Register 59 */
#define MTU_MC6_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616D6u)

/** \brief 6D8, Read Data and Bit Flip Register 60 */
#define MTU_MC6_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616D8u)

/** \brief 6DA, Read Data and Bit Flip Register 61 */
#define MTU_MC6_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616DAu)

/** \brief 6DC, Read Data and Bit Flip Register 62 */
#define MTU_MC6_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616DCu)

/** \brief 6DE, Read Data and Bit Flip Register 63 */
#define MTU_MC6_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616DEu)

/** \brief 6E0, Read Data and Bit Flip Register 64 */
#define MTU_MC6_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616E0u)

/** \brief 6E2, Read Data and Bit Flip Register 65 */
#define MTU_MC6_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616E2u)

/** \brief 6E4, Read Data and Bit Flip Register 66 */
#define MTU_MC6_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00616E4u)

/** \brief 6EE, Alarm Sources Configuration Register */
#define MTU_MC6_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00616EEu)

/** \brief 6F0, SSH Safety Faults Status Register  */
#define MTU_MC6_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00616F0u)

/** \brief 6F2, Error Information Register 0 */
#define MTU_MC6_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00616F2u)

/** \brief 6F4, Error Information Register 1 */
#define MTU_MC6_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00616F4u)

/** \brief 6F6, Error Information Register 2 */
#define MTU_MC6_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00616F6u)

/** \brief 6F8, Error Information Register 3 */
#define MTU_MC6_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00616F8u)

/** \brief 6FA, Error Information Register 4 */
#define MTU_MC6_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00616FAu)

/** \brief 700, Configuration Registers */
#define MTU_MC7_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061700u)

/** \brief 702, Configuration Register 1 */
#define MTU_MC7_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061702u)

/** \brief 704, MBIST Control Register */
#define MTU_MC7_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061704u)

/** \brief 706, Status Register */
#define MTU_MC7_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061706u)

/** \brief 708, Range Register, single address mode */
#define MTU_MC7_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061708u)

/** \brief 70C, Revision ID Register */
#define MTU_MC7_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006170Cu)

/** \brief 70E, ECC Safety Register */
#define MTU_MC7_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006170Eu)

/** \brief 710, Memory ECC Detection Register */
#define MTU_MC7_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061710u)

/** \brief 712, Error Tracking Register 0 */
#define MTU_MC7_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061712u)

/** \brief 714, Error Tracking Register 1 */
#define MTU_MC7_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061714u)

/** \brief 716, Error Tracking Register 2 */
#define MTU_MC7_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061716u)

/** \brief 718, Error Tracking Register 3 */
#define MTU_MC7_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061718u)

/** \brief 71A, Error Tracking Register 4 */
#define MTU_MC7_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006171Au)

/** \brief 760, Read Data and Bit Flip Register 0 */
#define MTU_MC7_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061760u)

/** \brief 762, Read Data and Bit Flip Register 1 */
#define MTU_MC7_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061762u)

/** \brief 764, Read Data and Bit Flip Register 2 */
#define MTU_MC7_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061764u)

/** \brief 766, Read Data and Bit Flip Register 3 */
#define MTU_MC7_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061766u)

/** \brief 768, Read Data and Bit Flip Register 4 */
#define MTU_MC7_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061768u)

/** \brief 76A, Read Data and Bit Flip Register 5 */
#define MTU_MC7_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006176Au)

/** \brief 76C, Read Data and Bit Flip Register 6 */
#define MTU_MC7_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006176Cu)

/** \brief 76E, Read Data and Bit Flip Register 7 */
#define MTU_MC7_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006176Eu)

/** \brief 770, Read Data and Bit Flip Register 8 */
#define MTU_MC7_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061770u)

/** \brief 772, Read Data and Bit Flip Register 9 */
#define MTU_MC7_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061772u)

/** \brief 774, Read Data and Bit Flip Register 10 */
#define MTU_MC7_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061774u)

/** \brief 776, Read Data and Bit Flip Register 11 */
#define MTU_MC7_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061776u)

/** \brief 778, Read Data and Bit Flip Register 12 */
#define MTU_MC7_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061778u)

/** \brief 77A, Read Data and Bit Flip Register 13 */
#define MTU_MC7_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006177Au)

/** \brief 77C, Read Data and Bit Flip Register 14 */
#define MTU_MC7_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006177Cu)

/** \brief 77E, Read Data and Bit Flip Register 15 */
#define MTU_MC7_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006177Eu)

/** \brief 780, Read Data and Bit Flip Register 16 */
#define MTU_MC7_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061780u)

/** \brief 782, Read Data and Bit Flip Register 17 */
#define MTU_MC7_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061782u)

/** \brief 784, Read Data and Bit Flip Register 18 */
#define MTU_MC7_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061784u)

/** \brief 786, Read Data and Bit Flip Register 19 */
#define MTU_MC7_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061786u)

/** \brief 788, Read Data and Bit Flip Register 20 */
#define MTU_MC7_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061788u)

/** \brief 78A, Read Data and Bit Flip Register 21 */
#define MTU_MC7_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006178Au)

/** \brief 78C, Read Data and Bit Flip Register 22 */
#define MTU_MC7_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006178Cu)

/** \brief 78E, Read Data and Bit Flip Register 23 */
#define MTU_MC7_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006178Eu)

/** \brief 790, Read Data and Bit Flip Register 24 */
#define MTU_MC7_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061790u)

/** \brief 792, Read Data and Bit Flip Register 25 */
#define MTU_MC7_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061792u)

/** \brief 794, Read Data and Bit Flip Register 26 */
#define MTU_MC7_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061794u)

/** \brief 796, Read Data and Bit Flip Register 27 */
#define MTU_MC7_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061796u)

/** \brief 798, Read Data and Bit Flip Register 28 */
#define MTU_MC7_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061798u)

/** \brief 79A, Read Data and Bit Flip Register 29 */
#define MTU_MC7_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006179Au)

/** \brief 79C, Read Data and Bit Flip Register 30 */
#define MTU_MC7_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006179Cu)

/** \brief 79E, Read Data and Bit Flip Register 31 */
#define MTU_MC7_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006179Eu)

/** \brief 7A0, Read Data and Bit Flip Register 32 */
#define MTU_MC7_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617A0u)

/** \brief 7A2, Read Data and Bit Flip Register 33 */
#define MTU_MC7_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617A2u)

/** \brief 7A4, Read Data and Bit Flip Register 34 */
#define MTU_MC7_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617A4u)

/** \brief 7A6, Read Data and Bit Flip Register 35 */
#define MTU_MC7_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617A6u)

/** \brief 7A8, Read Data and Bit Flip Register 36 */
#define MTU_MC7_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617A8u)

/** \brief 7AA, Read Data and Bit Flip Register 37 */
#define MTU_MC7_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617AAu)

/** \brief 7AC, Read Data and Bit Flip Register 38 */
#define MTU_MC7_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617ACu)

/** \brief 7AE, Read Data and Bit Flip Register 39 */
#define MTU_MC7_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617AEu)

/** \brief 7B0, Read Data and Bit Flip Register 40 */
#define MTU_MC7_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617B0u)

/** \brief 7B2, Read Data and Bit Flip Register 41 */
#define MTU_MC7_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617B2u)

/** \brief 7B4, Read Data and Bit Flip Register 42 */
#define MTU_MC7_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617B4u)

/** \brief 7B6, Read Data and Bit Flip Register 43 */
#define MTU_MC7_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617B6u)

/** \brief 7B8, Read Data and Bit Flip Register 44 */
#define MTU_MC7_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617B8u)

/** \brief 7BA, Read Data and Bit Flip Register 45 */
#define MTU_MC7_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617BAu)

/** \brief 7BC, Read Data and Bit Flip Register 46 */
#define MTU_MC7_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617BCu)

/** \brief 7BE, Read Data and Bit Flip Register 47 */
#define MTU_MC7_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617BEu)

/** \brief 7C0, Read Data and Bit Flip Register 48 */
#define MTU_MC7_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617C0u)

/** \brief 7C2, Read Data and Bit Flip Register 49 */
#define MTU_MC7_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617C2u)

/** \brief 7C4, Read Data and Bit Flip Register 50 */
#define MTU_MC7_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617C4u)

/** \brief 7C6, Read Data and Bit Flip Register 51 */
#define MTU_MC7_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617C6u)

/** \brief 7C8, Read Data and Bit Flip Register 52 */
#define MTU_MC7_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617C8u)

/** \brief 7CA, Read Data and Bit Flip Register 53 */
#define MTU_MC7_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617CAu)

/** \brief 7CC, Read Data and Bit Flip Register 54 */
#define MTU_MC7_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617CCu)

/** \brief 7CE, Read Data and Bit Flip Register 55 */
#define MTU_MC7_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617CEu)

/** \brief 7D0, Read Data and Bit Flip Register 56 */
#define MTU_MC7_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617D0u)

/** \brief 7D2, Read Data and Bit Flip Register 57 */
#define MTU_MC7_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617D2u)

/** \brief 7D4, Read Data and Bit Flip Register 58 */
#define MTU_MC7_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617D4u)

/** \brief 7D6, Read Data and Bit Flip Register 59 */
#define MTU_MC7_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617D6u)

/** \brief 7D8, Read Data and Bit Flip Register 60 */
#define MTU_MC7_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617D8u)

/** \brief 7DA, Read Data and Bit Flip Register 61 */
#define MTU_MC7_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617DAu)

/** \brief 7DC, Read Data and Bit Flip Register 62 */
#define MTU_MC7_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617DCu)

/** \brief 7DE, Read Data and Bit Flip Register 63 */
#define MTU_MC7_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617DEu)

/** \brief 7E0, Read Data and Bit Flip Register 64 */
#define MTU_MC7_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617E0u)

/** \brief 7E2, Read Data and Bit Flip Register 65 */
#define MTU_MC7_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617E2u)

/** \brief 7E4, Read Data and Bit Flip Register 66 */
#define MTU_MC7_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00617E4u)

/** \brief 7EE, Alarm Sources Configuration Register */
#define MTU_MC7_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00617EEu)

/** \brief 7F0, SSH Safety Faults Status Register  */
#define MTU_MC7_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00617F0u)

/** \brief 7F2, Error Information Register 0 */
#define MTU_MC7_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00617F2u)

/** \brief 7F4, Error Information Register 1 */
#define MTU_MC7_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00617F4u)

/** \brief 7F6, Error Information Register 2 */
#define MTU_MC7_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00617F6u)

/** \brief 7F8, Error Information Register 3 */
#define MTU_MC7_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00617F8u)

/** \brief 7FA, Error Information Register 4 */
#define MTU_MC7_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00617FAu)

/** \brief 800, Configuration Registers */
#define MTU_MC8_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061800u)

/** \brief 802, Configuration Register 1 */
#define MTU_MC8_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061802u)

/** \brief 804, MBIST Control Register */
#define MTU_MC8_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061804u)

/** \brief 806, Status Register */
#define MTU_MC8_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061806u)

/** \brief 808, Range Register, single address mode */
#define MTU_MC8_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061808u)

/** \brief 80C, Revision ID Register */
#define MTU_MC8_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006180Cu)

/** \brief 80E, ECC Safety Register */
#define MTU_MC8_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006180Eu)

/** \brief 810, Memory ECC Detection Register */
#define MTU_MC8_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061810u)

/** \brief 812, Error Tracking Register 0 */
#define MTU_MC8_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061812u)

/** \brief 814, Error Tracking Register 1 */
#define MTU_MC8_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061814u)

/** \brief 816, Error Tracking Register 2 */
#define MTU_MC8_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061816u)

/** \brief 818, Error Tracking Register 3 */
#define MTU_MC8_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061818u)

/** \brief 81A, Error Tracking Register 4 */
#define MTU_MC8_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006181Au)

/** \brief 860, Read Data and Bit Flip Register 0 */
#define MTU_MC8_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061860u)

/** \brief 862, Read Data and Bit Flip Register 1 */
#define MTU_MC8_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061862u)

/** \brief 864, Read Data and Bit Flip Register 2 */
#define MTU_MC8_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061864u)

/** \brief 866, Read Data and Bit Flip Register 3 */
#define MTU_MC8_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061866u)

/** \brief 868, Read Data and Bit Flip Register 4 */
#define MTU_MC8_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061868u)

/** \brief 86A, Read Data and Bit Flip Register 5 */
#define MTU_MC8_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006186Au)

/** \brief 86C, Read Data and Bit Flip Register 6 */
#define MTU_MC8_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006186Cu)

/** \brief 86E, Read Data and Bit Flip Register 7 */
#define MTU_MC8_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006186Eu)

/** \brief 870, Read Data and Bit Flip Register 8 */
#define MTU_MC8_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061870u)

/** \brief 872, Read Data and Bit Flip Register 9 */
#define MTU_MC8_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061872u)

/** \brief 874, Read Data and Bit Flip Register 10 */
#define MTU_MC8_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061874u)

/** \brief 876, Read Data and Bit Flip Register 11 */
#define MTU_MC8_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061876u)

/** \brief 878, Read Data and Bit Flip Register 12 */
#define MTU_MC8_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061878u)

/** \brief 87A, Read Data and Bit Flip Register 13 */
#define MTU_MC8_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006187Au)

/** \brief 87C, Read Data and Bit Flip Register 14 */
#define MTU_MC8_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006187Cu)

/** \brief 87E, Read Data and Bit Flip Register 15 */
#define MTU_MC8_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006187Eu)

/** \brief 880, Read Data and Bit Flip Register 16 */
#define MTU_MC8_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061880u)

/** \brief 882, Read Data and Bit Flip Register 17 */
#define MTU_MC8_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061882u)

/** \brief 884, Read Data and Bit Flip Register 18 */
#define MTU_MC8_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061884u)

/** \brief 886, Read Data and Bit Flip Register 19 */
#define MTU_MC8_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061886u)

/** \brief 888, Read Data and Bit Flip Register 20 */
#define MTU_MC8_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061888u)

/** \brief 88A, Read Data and Bit Flip Register 21 */
#define MTU_MC8_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006188Au)

/** \brief 88C, Read Data and Bit Flip Register 22 */
#define MTU_MC8_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006188Cu)

/** \brief 88E, Read Data and Bit Flip Register 23 */
#define MTU_MC8_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006188Eu)

/** \brief 890, Read Data and Bit Flip Register 24 */
#define MTU_MC8_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061890u)

/** \brief 892, Read Data and Bit Flip Register 25 */
#define MTU_MC8_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061892u)

/** \brief 894, Read Data and Bit Flip Register 26 */
#define MTU_MC8_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061894u)

/** \brief 896, Read Data and Bit Flip Register 27 */
#define MTU_MC8_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061896u)

/** \brief 898, Read Data and Bit Flip Register 28 */
#define MTU_MC8_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061898u)

/** \brief 89A, Read Data and Bit Flip Register 29 */
#define MTU_MC8_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006189Au)

/** \brief 89C, Read Data and Bit Flip Register 30 */
#define MTU_MC8_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006189Cu)

/** \brief 89E, Read Data and Bit Flip Register 31 */
#define MTU_MC8_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006189Eu)

/** \brief 8A0, Read Data and Bit Flip Register 32 */
#define MTU_MC8_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618A0u)

/** \brief 8A2, Read Data and Bit Flip Register 33 */
#define MTU_MC8_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618A2u)

/** \brief 8A4, Read Data and Bit Flip Register 34 */
#define MTU_MC8_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618A4u)

/** \brief 8A6, Read Data and Bit Flip Register 35 */
#define MTU_MC8_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618A6u)

/** \brief 8A8, Read Data and Bit Flip Register 36 */
#define MTU_MC8_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618A8u)

/** \brief 8AA, Read Data and Bit Flip Register 37 */
#define MTU_MC8_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618AAu)

/** \brief 8AC, Read Data and Bit Flip Register 38 */
#define MTU_MC8_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618ACu)

/** \brief 8AE, Read Data and Bit Flip Register 39 */
#define MTU_MC8_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618AEu)

/** \brief 8B0, Read Data and Bit Flip Register 40 */
#define MTU_MC8_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618B0u)

/** \brief 8B2, Read Data and Bit Flip Register 41 */
#define MTU_MC8_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618B2u)

/** \brief 8B4, Read Data and Bit Flip Register 42 */
#define MTU_MC8_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618B4u)

/** \brief 8B6, Read Data and Bit Flip Register 43 */
#define MTU_MC8_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618B6u)

/** \brief 8B8, Read Data and Bit Flip Register 44 */
#define MTU_MC8_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618B8u)

/** \brief 8BA, Read Data and Bit Flip Register 45 */
#define MTU_MC8_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618BAu)

/** \brief 8BC, Read Data and Bit Flip Register 46 */
#define MTU_MC8_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618BCu)

/** \brief 8BE, Read Data and Bit Flip Register 47 */
#define MTU_MC8_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618BEu)

/** \brief 8C0, Read Data and Bit Flip Register 48 */
#define MTU_MC8_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618C0u)

/** \brief 8C2, Read Data and Bit Flip Register 49 */
#define MTU_MC8_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618C2u)

/** \brief 8C4, Read Data and Bit Flip Register 50 */
#define MTU_MC8_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618C4u)

/** \brief 8C6, Read Data and Bit Flip Register 51 */
#define MTU_MC8_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618C6u)

/** \brief 8C8, Read Data and Bit Flip Register 52 */
#define MTU_MC8_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618C8u)

/** \brief 8CA, Read Data and Bit Flip Register 53 */
#define MTU_MC8_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618CAu)

/** \brief 8CC, Read Data and Bit Flip Register 54 */
#define MTU_MC8_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618CCu)

/** \brief 8CE, Read Data and Bit Flip Register 55 */
#define MTU_MC8_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618CEu)

/** \brief 8D0, Read Data and Bit Flip Register 56 */
#define MTU_MC8_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618D0u)

/** \brief 8D2, Read Data and Bit Flip Register 57 */
#define MTU_MC8_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618D2u)

/** \brief 8D4, Read Data and Bit Flip Register 58 */
#define MTU_MC8_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618D4u)

/** \brief 8D6, Read Data and Bit Flip Register 59 */
#define MTU_MC8_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618D6u)

/** \brief 8D8, Read Data and Bit Flip Register 60 */
#define MTU_MC8_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618D8u)

/** \brief 8DA, Read Data and Bit Flip Register 61 */
#define MTU_MC8_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618DAu)

/** \brief 8DC, Read Data and Bit Flip Register 62 */
#define MTU_MC8_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618DCu)

/** \brief 8DE, Read Data and Bit Flip Register 63 */
#define MTU_MC8_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618DEu)

/** \brief 8E0, Read Data and Bit Flip Register 64 */
#define MTU_MC8_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618E0u)

/** \brief 8E2, Read Data and Bit Flip Register 65 */
#define MTU_MC8_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618E2u)

/** \brief 8E4, Read Data and Bit Flip Register 66 */
#define MTU_MC8_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00618E4u)

/** \brief 8EE, Alarm Sources Configuration Register */
#define MTU_MC8_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00618EEu)

/** \brief 8F0, SSH Safety Faults Status Register  */
#define MTU_MC8_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00618F0u)

/** \brief 8F2, Error Information Register 0 */
#define MTU_MC8_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00618F2u)

/** \brief 8F4, Error Information Register 1 */
#define MTU_MC8_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00618F4u)

/** \brief 8F6, Error Information Register 2 */
#define MTU_MC8_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00618F6u)

/** \brief 8F8, Error Information Register 3 */
#define MTU_MC8_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00618F8u)

/** \brief 8FA, Error Information Register 4 */
#define MTU_MC8_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00618FAu)

/** \brief 900, Configuration Registers */
#define MTU_MC9_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061900u)

/** \brief 902, Configuration Register 1 */
#define MTU_MC9_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061902u)

/** \brief 904, MBIST Control Register */
#define MTU_MC9_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061904u)

/** \brief 906, Status Register */
#define MTU_MC9_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061906u)

/** \brief 908, Range Register, single address mode */
#define MTU_MC9_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061908u)

/** \brief 90C, Revision ID Register */
#define MTU_MC9_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006190Cu)

/** \brief 90E, ECC Safety Register */
#define MTU_MC9_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006190Eu)

/** \brief 910, Memory ECC Detection Register */
#define MTU_MC9_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061910u)

/** \brief 912, Error Tracking Register 0 */
#define MTU_MC9_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061912u)

/** \brief 914, Error Tracking Register 1 */
#define MTU_MC9_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061914u)

/** \brief 916, Error Tracking Register 2 */
#define MTU_MC9_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061916u)

/** \brief 918, Error Tracking Register 3 */
#define MTU_MC9_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061918u)

/** \brief 91A, Error Tracking Register 4 */
#define MTU_MC9_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006191Au)

/** \brief 960, Read Data and Bit Flip Register 0 */
#define MTU_MC9_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061960u)

/** \brief 962, Read Data and Bit Flip Register 1 */
#define MTU_MC9_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061962u)

/** \brief 964, Read Data and Bit Flip Register 2 */
#define MTU_MC9_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061964u)

/** \brief 966, Read Data and Bit Flip Register 3 */
#define MTU_MC9_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061966u)

/** \brief 968, Read Data and Bit Flip Register 4 */
#define MTU_MC9_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061968u)

/** \brief 96A, Read Data and Bit Flip Register 5 */
#define MTU_MC9_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006196Au)

/** \brief 96C, Read Data and Bit Flip Register 6 */
#define MTU_MC9_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006196Cu)

/** \brief 96E, Read Data and Bit Flip Register 7 */
#define MTU_MC9_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006196Eu)

/** \brief 970, Read Data and Bit Flip Register 8 */
#define MTU_MC9_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061970u)

/** \brief 972, Read Data and Bit Flip Register 9 */
#define MTU_MC9_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061972u)

/** \brief 974, Read Data and Bit Flip Register 10 */
#define MTU_MC9_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061974u)

/** \brief 976, Read Data and Bit Flip Register 11 */
#define MTU_MC9_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061976u)

/** \brief 978, Read Data and Bit Flip Register 12 */
#define MTU_MC9_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061978u)

/** \brief 97A, Read Data and Bit Flip Register 13 */
#define MTU_MC9_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006197Au)

/** \brief 97C, Read Data and Bit Flip Register 14 */
#define MTU_MC9_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006197Cu)

/** \brief 97E, Read Data and Bit Flip Register 15 */
#define MTU_MC9_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006197Eu)

/** \brief 980, Read Data and Bit Flip Register 16 */
#define MTU_MC9_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061980u)

/** \brief 982, Read Data and Bit Flip Register 17 */
#define MTU_MC9_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061982u)

/** \brief 984, Read Data and Bit Flip Register 18 */
#define MTU_MC9_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061984u)

/** \brief 986, Read Data and Bit Flip Register 19 */
#define MTU_MC9_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061986u)

/** \brief 988, Read Data and Bit Flip Register 20 */
#define MTU_MC9_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061988u)

/** \brief 98A, Read Data and Bit Flip Register 21 */
#define MTU_MC9_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006198Au)

/** \brief 98C, Read Data and Bit Flip Register 22 */
#define MTU_MC9_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006198Cu)

/** \brief 98E, Read Data and Bit Flip Register 23 */
#define MTU_MC9_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006198Eu)

/** \brief 990, Read Data and Bit Flip Register 24 */
#define MTU_MC9_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061990u)

/** \brief 992, Read Data and Bit Flip Register 25 */
#define MTU_MC9_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061992u)

/** \brief 994, Read Data and Bit Flip Register 26 */
#define MTU_MC9_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061994u)

/** \brief 996, Read Data and Bit Flip Register 27 */
#define MTU_MC9_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061996u)

/** \brief 998, Read Data and Bit Flip Register 28 */
#define MTU_MC9_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061998u)

/** \brief 99A, Read Data and Bit Flip Register 29 */
#define MTU_MC9_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006199Au)

/** \brief 99C, Read Data and Bit Flip Register 30 */
#define MTU_MC9_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006199Cu)

/** \brief 99E, Read Data and Bit Flip Register 31 */
#define MTU_MC9_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006199Eu)

/** \brief 9A0, Read Data and Bit Flip Register 32 */
#define MTU_MC9_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619A0u)

/** \brief 9A2, Read Data and Bit Flip Register 33 */
#define MTU_MC9_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619A2u)

/** \brief 9A4, Read Data and Bit Flip Register 34 */
#define MTU_MC9_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619A4u)

/** \brief 9A6, Read Data and Bit Flip Register 35 */
#define MTU_MC9_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619A6u)

/** \brief 9A8, Read Data and Bit Flip Register 36 */
#define MTU_MC9_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619A8u)

/** \brief 9AA, Read Data and Bit Flip Register 37 */
#define MTU_MC9_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619AAu)

/** \brief 9AC, Read Data and Bit Flip Register 38 */
#define MTU_MC9_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619ACu)

/** \brief 9AE, Read Data and Bit Flip Register 39 */
#define MTU_MC9_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619AEu)

/** \brief 9B0, Read Data and Bit Flip Register 40 */
#define MTU_MC9_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619B0u)

/** \brief 9B2, Read Data and Bit Flip Register 41 */
#define MTU_MC9_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619B2u)

/** \brief 9B4, Read Data and Bit Flip Register 42 */
#define MTU_MC9_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619B4u)

/** \brief 9B6, Read Data and Bit Flip Register 43 */
#define MTU_MC9_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619B6u)

/** \brief 9B8, Read Data and Bit Flip Register 44 */
#define MTU_MC9_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619B8u)

/** \brief 9BA, Read Data and Bit Flip Register 45 */
#define MTU_MC9_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619BAu)

/** \brief 9BC, Read Data and Bit Flip Register 46 */
#define MTU_MC9_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619BCu)

/** \brief 9BE, Read Data and Bit Flip Register 47 */
#define MTU_MC9_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619BEu)

/** \brief 9C0, Read Data and Bit Flip Register 48 */
#define MTU_MC9_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619C0u)

/** \brief 9C2, Read Data and Bit Flip Register 49 */
#define MTU_MC9_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619C2u)

/** \brief 9C4, Read Data and Bit Flip Register 50 */
#define MTU_MC9_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619C4u)

/** \brief 9C6, Read Data and Bit Flip Register 51 */
#define MTU_MC9_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619C6u)

/** \brief 9C8, Read Data and Bit Flip Register 52 */
#define MTU_MC9_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619C8u)

/** \brief 9CA, Read Data and Bit Flip Register 53 */
#define MTU_MC9_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619CAu)

/** \brief 9CC, Read Data and Bit Flip Register 54 */
#define MTU_MC9_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619CCu)

/** \brief 9CE, Read Data and Bit Flip Register 55 */
#define MTU_MC9_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619CEu)

/** \brief 9D0, Read Data and Bit Flip Register 56 */
#define MTU_MC9_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619D0u)

/** \brief 9D2, Read Data and Bit Flip Register 57 */
#define MTU_MC9_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619D2u)

/** \brief 9D4, Read Data and Bit Flip Register 58 */
#define MTU_MC9_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619D4u)

/** \brief 9D6, Read Data and Bit Flip Register 59 */
#define MTU_MC9_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619D6u)

/** \brief 9D8, Read Data and Bit Flip Register 60 */
#define MTU_MC9_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619D8u)

/** \brief 9DA, Read Data and Bit Flip Register 61 */
#define MTU_MC9_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619DAu)

/** \brief 9DC, Read Data and Bit Flip Register 62 */
#define MTU_MC9_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619DCu)

/** \brief 9DE, Read Data and Bit Flip Register 63 */
#define MTU_MC9_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619DEu)

/** \brief 9E0, Read Data and Bit Flip Register 64 */
#define MTU_MC9_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619E0u)

/** \brief 9E2, Read Data and Bit Flip Register 65 */
#define MTU_MC9_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619E2u)

/** \brief 9E4, Read Data and Bit Flip Register 66 */
#define MTU_MC9_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00619E4u)

/** \brief 9EE, Alarm Sources Configuration Register */
#define MTU_MC9_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00619EEu)

/** \brief 9F0, SSH Safety Faults Status Register  */
#define MTU_MC9_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00619F0u)

/** \brief 9F2, Error Information Register 0 */
#define MTU_MC9_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00619F2u)

/** \brief 9F4, Error Information Register 1 */
#define MTU_MC9_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00619F4u)

/** \brief 9F6, Error Information Register 2 */
#define MTU_MC9_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00619F6u)

/** \brief 9F8, Error Information Register 3 */
#define MTU_MC9_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00619F8u)

/** \brief 9FA, Error Information Register 4 */
#define MTU_MC9_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00619FAu)

/** \brief A00, Configuration Registers */
#define MTU_MC10_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061A00u)

/** \brief A02, Configuration Register 1 */
#define MTU_MC10_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061A02u)

/** \brief A04, MBIST Control Register */
#define MTU_MC10_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061A04u)

/** \brief A06, Status Register */
#define MTU_MC10_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061A06u)

/** \brief A08, Range Register, single address mode */
#define MTU_MC10_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061A08u)

/** \brief A0C, Revision ID Register */
#define MTU_MC10_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0061A0Cu)

/** \brief A0E, ECC Safety Register */
#define MTU_MC10_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0061A0Eu)

/** \brief A10, Memory ECC Detection Register */
#define MTU_MC10_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061A10u)

/** \brief A12, Error Tracking Register 0 */
#define MTU_MC10_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061A12u)

/** \brief A14, Error Tracking Register 1 */
#define MTU_MC10_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061A14u)

/** \brief A16, Error Tracking Register 2 */
#define MTU_MC10_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061A16u)

/** \brief A18, Error Tracking Register 3 */
#define MTU_MC10_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061A18u)

/** \brief A1A, Error Tracking Register 4 */
#define MTU_MC10_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061A1Au)

/** \brief A60, Read Data and Bit Flip Register 0 */
#define MTU_MC10_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A60u)

/** \brief A62, Read Data and Bit Flip Register 1 */
#define MTU_MC10_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A62u)

/** \brief A64, Read Data and Bit Flip Register 2 */
#define MTU_MC10_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A64u)

/** \brief A66, Read Data and Bit Flip Register 3 */
#define MTU_MC10_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A66u)

/** \brief A68, Read Data and Bit Flip Register 4 */
#define MTU_MC10_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A68u)

/** \brief A6A, Read Data and Bit Flip Register 5 */
#define MTU_MC10_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A6Au)

/** \brief A6C, Read Data and Bit Flip Register 6 */
#define MTU_MC10_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A6Cu)

/** \brief A6E, Read Data and Bit Flip Register 7 */
#define MTU_MC10_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A6Eu)

/** \brief A70, Read Data and Bit Flip Register 8 */
#define MTU_MC10_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A70u)

/** \brief A72, Read Data and Bit Flip Register 9 */
#define MTU_MC10_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A72u)

/** \brief A74, Read Data and Bit Flip Register 10 */
#define MTU_MC10_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A74u)

/** \brief A76, Read Data and Bit Flip Register 11 */
#define MTU_MC10_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A76u)

/** \brief A78, Read Data and Bit Flip Register 12 */
#define MTU_MC10_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A78u)

/** \brief A7A, Read Data and Bit Flip Register 13 */
#define MTU_MC10_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A7Au)

/** \brief A7C, Read Data and Bit Flip Register 14 */
#define MTU_MC10_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A7Cu)

/** \brief A7E, Read Data and Bit Flip Register 15 */
#define MTU_MC10_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A7Eu)

/** \brief A80, Read Data and Bit Flip Register 16 */
#define MTU_MC10_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A80u)

/** \brief A82, Read Data and Bit Flip Register 17 */
#define MTU_MC10_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A82u)

/** \brief A84, Read Data and Bit Flip Register 18 */
#define MTU_MC10_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A84u)

/** \brief A86, Read Data and Bit Flip Register 19 */
#define MTU_MC10_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A86u)

/** \brief A88, Read Data and Bit Flip Register 20 */
#define MTU_MC10_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A88u)

/** \brief A8A, Read Data and Bit Flip Register 21 */
#define MTU_MC10_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A8Au)

/** \brief A8C, Read Data and Bit Flip Register 22 */
#define MTU_MC10_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A8Cu)

/** \brief A8E, Read Data and Bit Flip Register 23 */
#define MTU_MC10_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A8Eu)

/** \brief A90, Read Data and Bit Flip Register 24 */
#define MTU_MC10_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A90u)

/** \brief A92, Read Data and Bit Flip Register 25 */
#define MTU_MC10_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A92u)

/** \brief A94, Read Data and Bit Flip Register 26 */
#define MTU_MC10_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A94u)

/** \brief A96, Read Data and Bit Flip Register 27 */
#define MTU_MC10_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A96u)

/** \brief A98, Read Data and Bit Flip Register 28 */
#define MTU_MC10_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A98u)

/** \brief A9A, Read Data and Bit Flip Register 29 */
#define MTU_MC10_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A9Au)

/** \brief A9C, Read Data and Bit Flip Register 30 */
#define MTU_MC10_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A9Cu)

/** \brief A9E, Read Data and Bit Flip Register 31 */
#define MTU_MC10_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061A9Eu)

/** \brief AA0, Read Data and Bit Flip Register 32 */
#define MTU_MC10_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AA0u)

/** \brief AA2, Read Data and Bit Flip Register 33 */
#define MTU_MC10_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AA2u)

/** \brief AA4, Read Data and Bit Flip Register 34 */
#define MTU_MC10_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AA4u)

/** \brief AA6, Read Data and Bit Flip Register 35 */
#define MTU_MC10_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AA6u)

/** \brief AA8, Read Data and Bit Flip Register 36 */
#define MTU_MC10_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AA8u)

/** \brief AAA, Read Data and Bit Flip Register 37 */
#define MTU_MC10_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AAAu)

/** \brief AAC, Read Data and Bit Flip Register 38 */
#define MTU_MC10_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AACu)

/** \brief AAE, Read Data and Bit Flip Register 39 */
#define MTU_MC10_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AAEu)

/** \brief AB0, Read Data and Bit Flip Register 40 */
#define MTU_MC10_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AB0u)

/** \brief AB2, Read Data and Bit Flip Register 41 */
#define MTU_MC10_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AB2u)

/** \brief AB4, Read Data and Bit Flip Register 42 */
#define MTU_MC10_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AB4u)

/** \brief AB6, Read Data and Bit Flip Register 43 */
#define MTU_MC10_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AB6u)

/** \brief AB8, Read Data and Bit Flip Register 44 */
#define MTU_MC10_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AB8u)

/** \brief ABA, Read Data and Bit Flip Register 45 */
#define MTU_MC10_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ABAu)

/** \brief ABC, Read Data and Bit Flip Register 46 */
#define MTU_MC10_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ABCu)

/** \brief ABE, Read Data and Bit Flip Register 47 */
#define MTU_MC10_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ABEu)

/** \brief AC0, Read Data and Bit Flip Register 48 */
#define MTU_MC10_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AC0u)

/** \brief AC2, Read Data and Bit Flip Register 49 */
#define MTU_MC10_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AC2u)

/** \brief AC4, Read Data and Bit Flip Register 50 */
#define MTU_MC10_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AC4u)

/** \brief AC6, Read Data and Bit Flip Register 51 */
#define MTU_MC10_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AC6u)

/** \brief AC8, Read Data and Bit Flip Register 52 */
#define MTU_MC10_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AC8u)

/** \brief ACA, Read Data and Bit Flip Register 53 */
#define MTU_MC10_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ACAu)

/** \brief ACC, Read Data and Bit Flip Register 54 */
#define MTU_MC10_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ACCu)

/** \brief ACE, Read Data and Bit Flip Register 55 */
#define MTU_MC10_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ACEu)

/** \brief AD0, Read Data and Bit Flip Register 56 */
#define MTU_MC10_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AD0u)

/** \brief AD2, Read Data and Bit Flip Register 57 */
#define MTU_MC10_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AD2u)

/** \brief AD4, Read Data and Bit Flip Register 58 */
#define MTU_MC10_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AD4u)

/** \brief AD6, Read Data and Bit Flip Register 59 */
#define MTU_MC10_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AD6u)

/** \brief AD8, Read Data and Bit Flip Register 60 */
#define MTU_MC10_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AD8u)

/** \brief ADA, Read Data and Bit Flip Register 61 */
#define MTU_MC10_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ADAu)

/** \brief ADC, Read Data and Bit Flip Register 62 */
#define MTU_MC10_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ADCu)

/** \brief ADE, Read Data and Bit Flip Register 63 */
#define MTU_MC10_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ADEu)

/** \brief AE0, Read Data and Bit Flip Register 64 */
#define MTU_MC10_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AE0u)

/** \brief AE2, Read Data and Bit Flip Register 65 */
#define MTU_MC10_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AE2u)

/** \brief AE4, Read Data and Bit Flip Register 66 */
#define MTU_MC10_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061AE4u)

/** \brief AEE, Alarm Sources Configuration Register */
#define MTU_MC10_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0061AEEu)

/** \brief AF0, SSH Safety Faults Status Register  */
#define MTU_MC10_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0061AF0u)

/** \brief AF2, Error Information Register 0 */
#define MTU_MC10_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061AF2u)

/** \brief AF4, Error Information Register 1 */
#define MTU_MC10_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061AF4u)

/** \brief AF6, Error Information Register 2 */
#define MTU_MC10_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061AF6u)

/** \brief AF8, Error Information Register 3 */
#define MTU_MC10_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061AF8u)

/** \brief AFA, Error Information Register 4 */
#define MTU_MC10_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061AFAu)

/** \brief B00, Configuration Registers */
#define MTU_MC11_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061B00u)

/** \brief B02, Configuration Register 1 */
#define MTU_MC11_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061B02u)

/** \brief B04, MBIST Control Register */
#define MTU_MC11_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061B04u)

/** \brief B06, Status Register */
#define MTU_MC11_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061B06u)

/** \brief B08, Range Register, single address mode */
#define MTU_MC11_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061B08u)

/** \brief B0C, Revision ID Register */
#define MTU_MC11_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0061B0Cu)

/** \brief B0E, ECC Safety Register */
#define MTU_MC11_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0061B0Eu)

/** \brief B10, Memory ECC Detection Register */
#define MTU_MC11_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061B10u)

/** \brief B12, Error Tracking Register 0 */
#define MTU_MC11_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061B12u)

/** \brief B14, Error Tracking Register 1 */
#define MTU_MC11_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061B14u)

/** \brief B16, Error Tracking Register 2 */
#define MTU_MC11_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061B16u)

/** \brief B18, Error Tracking Register 3 */
#define MTU_MC11_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061B18u)

/** \brief B1A, Error Tracking Register 4 */
#define MTU_MC11_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061B1Au)

/** \brief B60, Read Data and Bit Flip Register 0 */
#define MTU_MC11_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B60u)

/** \brief B62, Read Data and Bit Flip Register 1 */
#define MTU_MC11_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B62u)

/** \brief B64, Read Data and Bit Flip Register 2 */
#define MTU_MC11_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B64u)

/** \brief B66, Read Data and Bit Flip Register 3 */
#define MTU_MC11_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B66u)

/** \brief B68, Read Data and Bit Flip Register 4 */
#define MTU_MC11_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B68u)

/** \brief B6A, Read Data and Bit Flip Register 5 */
#define MTU_MC11_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B6Au)

/** \brief B6C, Read Data and Bit Flip Register 6 */
#define MTU_MC11_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B6Cu)

/** \brief B6E, Read Data and Bit Flip Register 7 */
#define MTU_MC11_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B6Eu)

/** \brief B70, Read Data and Bit Flip Register 8 */
#define MTU_MC11_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B70u)

/** \brief B72, Read Data and Bit Flip Register 9 */
#define MTU_MC11_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B72u)

/** \brief B74, Read Data and Bit Flip Register 10 */
#define MTU_MC11_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B74u)

/** \brief B76, Read Data and Bit Flip Register 11 */
#define MTU_MC11_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B76u)

/** \brief B78, Read Data and Bit Flip Register 12 */
#define MTU_MC11_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B78u)

/** \brief B7A, Read Data and Bit Flip Register 13 */
#define MTU_MC11_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B7Au)

/** \brief B7C, Read Data and Bit Flip Register 14 */
#define MTU_MC11_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B7Cu)

/** \brief B7E, Read Data and Bit Flip Register 15 */
#define MTU_MC11_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B7Eu)

/** \brief B80, Read Data and Bit Flip Register 16 */
#define MTU_MC11_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B80u)

/** \brief B82, Read Data and Bit Flip Register 17 */
#define MTU_MC11_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B82u)

/** \brief B84, Read Data and Bit Flip Register 18 */
#define MTU_MC11_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B84u)

/** \brief B86, Read Data and Bit Flip Register 19 */
#define MTU_MC11_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B86u)

/** \brief B88, Read Data and Bit Flip Register 20 */
#define MTU_MC11_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B88u)

/** \brief B8A, Read Data and Bit Flip Register 21 */
#define MTU_MC11_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B8Au)

/** \brief B8C, Read Data and Bit Flip Register 22 */
#define MTU_MC11_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B8Cu)

/** \brief B8E, Read Data and Bit Flip Register 23 */
#define MTU_MC11_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B8Eu)

/** \brief B90, Read Data and Bit Flip Register 24 */
#define MTU_MC11_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B90u)

/** \brief B92, Read Data and Bit Flip Register 25 */
#define MTU_MC11_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B92u)

/** \brief B94, Read Data and Bit Flip Register 26 */
#define MTU_MC11_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B94u)

/** \brief B96, Read Data and Bit Flip Register 27 */
#define MTU_MC11_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B96u)

/** \brief B98, Read Data and Bit Flip Register 28 */
#define MTU_MC11_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B98u)

/** \brief B9A, Read Data and Bit Flip Register 29 */
#define MTU_MC11_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B9Au)

/** \brief B9C, Read Data and Bit Flip Register 30 */
#define MTU_MC11_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B9Cu)

/** \brief B9E, Read Data and Bit Flip Register 31 */
#define MTU_MC11_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061B9Eu)

/** \brief BA0, Read Data and Bit Flip Register 32 */
#define MTU_MC11_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BA0u)

/** \brief BA2, Read Data and Bit Flip Register 33 */
#define MTU_MC11_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BA2u)

/** \brief BA4, Read Data and Bit Flip Register 34 */
#define MTU_MC11_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BA4u)

/** \brief BA6, Read Data and Bit Flip Register 35 */
#define MTU_MC11_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BA6u)

/** \brief BA8, Read Data and Bit Flip Register 36 */
#define MTU_MC11_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BA8u)

/** \brief BAA, Read Data and Bit Flip Register 37 */
#define MTU_MC11_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BAAu)

/** \brief BAC, Read Data and Bit Flip Register 38 */
#define MTU_MC11_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BACu)

/** \brief BAE, Read Data and Bit Flip Register 39 */
#define MTU_MC11_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BAEu)

/** \brief BB0, Read Data and Bit Flip Register 40 */
#define MTU_MC11_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BB0u)

/** \brief BB2, Read Data and Bit Flip Register 41 */
#define MTU_MC11_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BB2u)

/** \brief BB4, Read Data and Bit Flip Register 42 */
#define MTU_MC11_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BB4u)

/** \brief BB6, Read Data and Bit Flip Register 43 */
#define MTU_MC11_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BB6u)

/** \brief BB8, Read Data and Bit Flip Register 44 */
#define MTU_MC11_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BB8u)

/** \brief BBA, Read Data and Bit Flip Register 45 */
#define MTU_MC11_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BBAu)

/** \brief BBC, Read Data and Bit Flip Register 46 */
#define MTU_MC11_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BBCu)

/** \brief BBE, Read Data and Bit Flip Register 47 */
#define MTU_MC11_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BBEu)

/** \brief BC0, Read Data and Bit Flip Register 48 */
#define MTU_MC11_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BC0u)

/** \brief BC2, Read Data and Bit Flip Register 49 */
#define MTU_MC11_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BC2u)

/** \brief BC4, Read Data and Bit Flip Register 50 */
#define MTU_MC11_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BC4u)

/** \brief BC6, Read Data and Bit Flip Register 51 */
#define MTU_MC11_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BC6u)

/** \brief BC8, Read Data and Bit Flip Register 52 */
#define MTU_MC11_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BC8u)

/** \brief BCA, Read Data and Bit Flip Register 53 */
#define MTU_MC11_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BCAu)

/** \brief BCC, Read Data and Bit Flip Register 54 */
#define MTU_MC11_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BCCu)

/** \brief BCE, Read Data and Bit Flip Register 55 */
#define MTU_MC11_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BCEu)

/** \brief BD0, Read Data and Bit Flip Register 56 */
#define MTU_MC11_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BD0u)

/** \brief BD2, Read Data and Bit Flip Register 57 */
#define MTU_MC11_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BD2u)

/** \brief BD4, Read Data and Bit Flip Register 58 */
#define MTU_MC11_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BD4u)

/** \brief BD6, Read Data and Bit Flip Register 59 */
#define MTU_MC11_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BD6u)

/** \brief BD8, Read Data and Bit Flip Register 60 */
#define MTU_MC11_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BD8u)

/** \brief BDA, Read Data and Bit Flip Register 61 */
#define MTU_MC11_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BDAu)

/** \brief BDC, Read Data and Bit Flip Register 62 */
#define MTU_MC11_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BDCu)

/** \brief BDE, Read Data and Bit Flip Register 63 */
#define MTU_MC11_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BDEu)

/** \brief BE0, Read Data and Bit Flip Register 64 */
#define MTU_MC11_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BE0u)

/** \brief BE2, Read Data and Bit Flip Register 65 */
#define MTU_MC11_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BE2u)

/** \brief BE4, Read Data and Bit Flip Register 66 */
#define MTU_MC11_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061BE4u)

/** \brief BEE, Alarm Sources Configuration Register */
#define MTU_MC11_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0061BEEu)

/** \brief BF0, SSH Safety Faults Status Register  */
#define MTU_MC11_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0061BF0u)

/** \brief BF2, Error Information Register 0 */
#define MTU_MC11_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061BF2u)

/** \brief BF4, Error Information Register 1 */
#define MTU_MC11_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061BF4u)

/** \brief BF6, Error Information Register 2 */
#define MTU_MC11_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061BF6u)

/** \brief BF8, Error Information Register 3 */
#define MTU_MC11_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061BF8u)

/** \brief BFA, Error Information Register 4 */
#define MTU_MC11_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061BFAu)

/** \brief C00, Configuration Registers */
#define MTU_MC12_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061C00u)

/** \brief C02, Configuration Register 1 */
#define MTU_MC12_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061C02u)

/** \brief C04, MBIST Control Register */
#define MTU_MC12_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061C04u)

/** \brief C06, Status Register */
#define MTU_MC12_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061C06u)

/** \brief C08, Range Register, single address mode */
#define MTU_MC12_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061C08u)

/** \brief C0C, Revision ID Register */
#define MTU_MC12_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0061C0Cu)

/** \brief C0E, ECC Safety Register */
#define MTU_MC12_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0061C0Eu)

/** \brief C10, Memory ECC Detection Register */
#define MTU_MC12_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061C10u)

/** \brief C12, Error Tracking Register 0 */
#define MTU_MC12_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061C12u)

/** \brief C14, Error Tracking Register 1 */
#define MTU_MC12_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061C14u)

/** \brief C16, Error Tracking Register 2 */
#define MTU_MC12_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061C16u)

/** \brief C18, Error Tracking Register 3 */
#define MTU_MC12_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061C18u)

/** \brief C1A, Error Tracking Register 4 */
#define MTU_MC12_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061C1Au)

/** \brief C60, Read Data and Bit Flip Register 0 */
#define MTU_MC12_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C60u)

/** \brief C62, Read Data and Bit Flip Register 1 */
#define MTU_MC12_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C62u)

/** \brief C64, Read Data and Bit Flip Register 2 */
#define MTU_MC12_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C64u)

/** \brief C66, Read Data and Bit Flip Register 3 */
#define MTU_MC12_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C66u)

/** \brief C68, Read Data and Bit Flip Register 4 */
#define MTU_MC12_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C68u)

/** \brief C6A, Read Data and Bit Flip Register 5 */
#define MTU_MC12_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C6Au)

/** \brief C6C, Read Data and Bit Flip Register 6 */
#define MTU_MC12_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C6Cu)

/** \brief C6E, Read Data and Bit Flip Register 7 */
#define MTU_MC12_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C6Eu)

/** \brief C70, Read Data and Bit Flip Register 8 */
#define MTU_MC12_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C70u)

/** \brief C72, Read Data and Bit Flip Register 9 */
#define MTU_MC12_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C72u)

/** \brief C74, Read Data and Bit Flip Register 10 */
#define MTU_MC12_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C74u)

/** \brief C76, Read Data and Bit Flip Register 11 */
#define MTU_MC12_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C76u)

/** \brief C78, Read Data and Bit Flip Register 12 */
#define MTU_MC12_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C78u)

/** \brief C7A, Read Data and Bit Flip Register 13 */
#define MTU_MC12_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C7Au)

/** \brief C7C, Read Data and Bit Flip Register 14 */
#define MTU_MC12_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C7Cu)

/** \brief C7E, Read Data and Bit Flip Register 15 */
#define MTU_MC12_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C7Eu)

/** \brief C80, Read Data and Bit Flip Register 16 */
#define MTU_MC12_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C80u)

/** \brief C82, Read Data and Bit Flip Register 17 */
#define MTU_MC12_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C82u)

/** \brief C84, Read Data and Bit Flip Register 18 */
#define MTU_MC12_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C84u)

/** \brief C86, Read Data and Bit Flip Register 19 */
#define MTU_MC12_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C86u)

/** \brief C88, Read Data and Bit Flip Register 20 */
#define MTU_MC12_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C88u)

/** \brief C8A, Read Data and Bit Flip Register 21 */
#define MTU_MC12_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C8Au)

/** \brief C8C, Read Data and Bit Flip Register 22 */
#define MTU_MC12_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C8Cu)

/** \brief C8E, Read Data and Bit Flip Register 23 */
#define MTU_MC12_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C8Eu)

/** \brief C90, Read Data and Bit Flip Register 24 */
#define MTU_MC12_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C90u)

/** \brief C92, Read Data and Bit Flip Register 25 */
#define MTU_MC12_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C92u)

/** \brief C94, Read Data and Bit Flip Register 26 */
#define MTU_MC12_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C94u)

/** \brief C96, Read Data and Bit Flip Register 27 */
#define MTU_MC12_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C96u)

/** \brief C98, Read Data and Bit Flip Register 28 */
#define MTU_MC12_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C98u)

/** \brief C9A, Read Data and Bit Flip Register 29 */
#define MTU_MC12_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C9Au)

/** \brief C9C, Read Data and Bit Flip Register 30 */
#define MTU_MC12_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C9Cu)

/** \brief C9E, Read Data and Bit Flip Register 31 */
#define MTU_MC12_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061C9Eu)

/** \brief CA0, Read Data and Bit Flip Register 32 */
#define MTU_MC12_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CA0u)

/** \brief CA2, Read Data and Bit Flip Register 33 */
#define MTU_MC12_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CA2u)

/** \brief CA4, Read Data and Bit Flip Register 34 */
#define MTU_MC12_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CA4u)

/** \brief CA6, Read Data and Bit Flip Register 35 */
#define MTU_MC12_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CA6u)

/** \brief CA8, Read Data and Bit Flip Register 36 */
#define MTU_MC12_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CA8u)

/** \brief CAA, Read Data and Bit Flip Register 37 */
#define MTU_MC12_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CAAu)

/** \brief CAC, Read Data and Bit Flip Register 38 */
#define MTU_MC12_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CACu)

/** \brief CAE, Read Data and Bit Flip Register 39 */
#define MTU_MC12_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CAEu)

/** \brief CB0, Read Data and Bit Flip Register 40 */
#define MTU_MC12_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CB0u)

/** \brief CB2, Read Data and Bit Flip Register 41 */
#define MTU_MC12_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CB2u)

/** \brief CB4, Read Data and Bit Flip Register 42 */
#define MTU_MC12_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CB4u)

/** \brief CB6, Read Data and Bit Flip Register 43 */
#define MTU_MC12_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CB6u)

/** \brief CB8, Read Data and Bit Flip Register 44 */
#define MTU_MC12_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CB8u)

/** \brief CBA, Read Data and Bit Flip Register 45 */
#define MTU_MC12_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CBAu)

/** \brief CBC, Read Data and Bit Flip Register 46 */
#define MTU_MC12_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CBCu)

/** \brief CBE, Read Data and Bit Flip Register 47 */
#define MTU_MC12_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CBEu)

/** \brief CC0, Read Data and Bit Flip Register 48 */
#define MTU_MC12_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CC0u)

/** \brief CC2, Read Data and Bit Flip Register 49 */
#define MTU_MC12_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CC2u)

/** \brief CC4, Read Data and Bit Flip Register 50 */
#define MTU_MC12_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CC4u)

/** \brief CC6, Read Data and Bit Flip Register 51 */
#define MTU_MC12_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CC6u)

/** \brief CC8, Read Data and Bit Flip Register 52 */
#define MTU_MC12_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CC8u)

/** \brief CCA, Read Data and Bit Flip Register 53 */
#define MTU_MC12_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CCAu)

/** \brief CCC, Read Data and Bit Flip Register 54 */
#define MTU_MC12_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CCCu)

/** \brief CCE, Read Data and Bit Flip Register 55 */
#define MTU_MC12_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CCEu)

/** \brief CD0, Read Data and Bit Flip Register 56 */
#define MTU_MC12_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CD0u)

/** \brief CD2, Read Data and Bit Flip Register 57 */
#define MTU_MC12_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CD2u)

/** \brief CD4, Read Data and Bit Flip Register 58 */
#define MTU_MC12_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CD4u)

/** \brief CD6, Read Data and Bit Flip Register 59 */
#define MTU_MC12_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CD6u)

/** \brief CD8, Read Data and Bit Flip Register 60 */
#define MTU_MC12_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CD8u)

/** \brief CDA, Read Data and Bit Flip Register 61 */
#define MTU_MC12_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CDAu)

/** \brief CDC, Read Data and Bit Flip Register 62 */
#define MTU_MC12_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CDCu)

/** \brief CDE, Read Data and Bit Flip Register 63 */
#define MTU_MC12_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CDEu)

/** \brief CE0, Read Data and Bit Flip Register 64 */
#define MTU_MC12_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CE0u)

/** \brief CE2, Read Data and Bit Flip Register 65 */
#define MTU_MC12_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CE2u)

/** \brief CE4, Read Data and Bit Flip Register 66 */
#define MTU_MC12_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061CE4u)

/** \brief CEE, Alarm Sources Configuration Register */
#define MTU_MC12_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0061CEEu)

/** \brief CF0, SSH Safety Faults Status Register  */
#define MTU_MC12_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0061CF0u)

/** \brief CF2, Error Information Register 0 */
#define MTU_MC12_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061CF2u)

/** \brief CF4, Error Information Register 1 */
#define MTU_MC12_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061CF4u)

/** \brief CF6, Error Information Register 2 */
#define MTU_MC12_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061CF6u)

/** \brief CF8, Error Information Register 3 */
#define MTU_MC12_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061CF8u)

/** \brief CFA, Error Information Register 4 */
#define MTU_MC12_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061CFAu)

/** \brief D00, Configuration Registers */
#define MTU_MC13_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061D00u)

/** \brief D02, Configuration Register 1 */
#define MTU_MC13_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061D02u)

/** \brief D04, MBIST Control Register */
#define MTU_MC13_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061D04u)

/** \brief D06, Status Register */
#define MTU_MC13_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061D06u)

/** \brief D08, Range Register, single address mode */
#define MTU_MC13_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061D08u)

/** \brief D0C, Revision ID Register */
#define MTU_MC13_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0061D0Cu)

/** \brief D0E, ECC Safety Register */
#define MTU_MC13_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0061D0Eu)

/** \brief D10, Memory ECC Detection Register */
#define MTU_MC13_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061D10u)

/** \brief D12, Error Tracking Register 0 */
#define MTU_MC13_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061D12u)

/** \brief D14, Error Tracking Register 1 */
#define MTU_MC13_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061D14u)

/** \brief D16, Error Tracking Register 2 */
#define MTU_MC13_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061D16u)

/** \brief D18, Error Tracking Register 3 */
#define MTU_MC13_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061D18u)

/** \brief D1A, Error Tracking Register 4 */
#define MTU_MC13_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061D1Au)

/** \brief D60, Read Data and Bit Flip Register 0 */
#define MTU_MC13_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D60u)

/** \brief D62, Read Data and Bit Flip Register 1 */
#define MTU_MC13_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D62u)

/** \brief D64, Read Data and Bit Flip Register 2 */
#define MTU_MC13_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D64u)

/** \brief D66, Read Data and Bit Flip Register 3 */
#define MTU_MC13_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D66u)

/** \brief D68, Read Data and Bit Flip Register 4 */
#define MTU_MC13_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D68u)

/** \brief D6A, Read Data and Bit Flip Register 5 */
#define MTU_MC13_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D6Au)

/** \brief D6C, Read Data and Bit Flip Register 6 */
#define MTU_MC13_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D6Cu)

/** \brief D6E, Read Data and Bit Flip Register 7 */
#define MTU_MC13_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D6Eu)

/** \brief D70, Read Data and Bit Flip Register 8 */
#define MTU_MC13_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D70u)

/** \brief D72, Read Data and Bit Flip Register 9 */
#define MTU_MC13_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D72u)

/** \brief D74, Read Data and Bit Flip Register 10 */
#define MTU_MC13_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D74u)

/** \brief D76, Read Data and Bit Flip Register 11 */
#define MTU_MC13_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D76u)

/** \brief D78, Read Data and Bit Flip Register 12 */
#define MTU_MC13_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D78u)

/** \brief D7A, Read Data and Bit Flip Register 13 */
#define MTU_MC13_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D7Au)

/** \brief D7C, Read Data and Bit Flip Register 14 */
#define MTU_MC13_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D7Cu)

/** \brief D7E, Read Data and Bit Flip Register 15 */
#define MTU_MC13_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D7Eu)

/** \brief D80, Read Data and Bit Flip Register 16 */
#define MTU_MC13_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D80u)

/** \brief D82, Read Data and Bit Flip Register 17 */
#define MTU_MC13_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D82u)

/** \brief D84, Read Data and Bit Flip Register 18 */
#define MTU_MC13_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D84u)

/** \brief D86, Read Data and Bit Flip Register 19 */
#define MTU_MC13_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D86u)

/** \brief D88, Read Data and Bit Flip Register 20 */
#define MTU_MC13_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D88u)

/** \brief D8A, Read Data and Bit Flip Register 21 */
#define MTU_MC13_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D8Au)

/** \brief D8C, Read Data and Bit Flip Register 22 */
#define MTU_MC13_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D8Cu)

/** \brief D8E, Read Data and Bit Flip Register 23 */
#define MTU_MC13_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D8Eu)

/** \brief D90, Read Data and Bit Flip Register 24 */
#define MTU_MC13_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D90u)

/** \brief D92, Read Data and Bit Flip Register 25 */
#define MTU_MC13_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D92u)

/** \brief D94, Read Data and Bit Flip Register 26 */
#define MTU_MC13_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D94u)

/** \brief D96, Read Data and Bit Flip Register 27 */
#define MTU_MC13_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D96u)

/** \brief D98, Read Data and Bit Flip Register 28 */
#define MTU_MC13_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D98u)

/** \brief D9A, Read Data and Bit Flip Register 29 */
#define MTU_MC13_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D9Au)

/** \brief D9C, Read Data and Bit Flip Register 30 */
#define MTU_MC13_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D9Cu)

/** \brief D9E, Read Data and Bit Flip Register 31 */
#define MTU_MC13_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061D9Eu)

/** \brief DA0, Read Data and Bit Flip Register 32 */
#define MTU_MC13_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DA0u)

/** \brief DA2, Read Data and Bit Flip Register 33 */
#define MTU_MC13_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DA2u)

/** \brief DA4, Read Data and Bit Flip Register 34 */
#define MTU_MC13_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DA4u)

/** \brief DA6, Read Data and Bit Flip Register 35 */
#define MTU_MC13_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DA6u)

/** \brief DA8, Read Data and Bit Flip Register 36 */
#define MTU_MC13_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DA8u)

/** \brief DAA, Read Data and Bit Flip Register 37 */
#define MTU_MC13_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DAAu)

/** \brief DAC, Read Data and Bit Flip Register 38 */
#define MTU_MC13_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DACu)

/** \brief DAE, Read Data and Bit Flip Register 39 */
#define MTU_MC13_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DAEu)

/** \brief DB0, Read Data and Bit Flip Register 40 */
#define MTU_MC13_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DB0u)

/** \brief DB2, Read Data and Bit Flip Register 41 */
#define MTU_MC13_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DB2u)

/** \brief DB4, Read Data and Bit Flip Register 42 */
#define MTU_MC13_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DB4u)

/** \brief DB6, Read Data and Bit Flip Register 43 */
#define MTU_MC13_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DB6u)

/** \brief DB8, Read Data and Bit Flip Register 44 */
#define MTU_MC13_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DB8u)

/** \brief DBA, Read Data and Bit Flip Register 45 */
#define MTU_MC13_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DBAu)

/** \brief DBC, Read Data and Bit Flip Register 46 */
#define MTU_MC13_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DBCu)

/** \brief DBE, Read Data and Bit Flip Register 47 */
#define MTU_MC13_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DBEu)

/** \brief DC0, Read Data and Bit Flip Register 48 */
#define MTU_MC13_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DC0u)

/** \brief DC2, Read Data and Bit Flip Register 49 */
#define MTU_MC13_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DC2u)

/** \brief DC4, Read Data and Bit Flip Register 50 */
#define MTU_MC13_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DC4u)

/** \brief DC6, Read Data and Bit Flip Register 51 */
#define MTU_MC13_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DC6u)

/** \brief DC8, Read Data and Bit Flip Register 52 */
#define MTU_MC13_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DC8u)

/** \brief DCA, Read Data and Bit Flip Register 53 */
#define MTU_MC13_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DCAu)

/** \brief DCC, Read Data and Bit Flip Register 54 */
#define MTU_MC13_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DCCu)

/** \brief DCE, Read Data and Bit Flip Register 55 */
#define MTU_MC13_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DCEu)

/** \brief DD0, Read Data and Bit Flip Register 56 */
#define MTU_MC13_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DD0u)

/** \brief DD2, Read Data and Bit Flip Register 57 */
#define MTU_MC13_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DD2u)

/** \brief DD4, Read Data and Bit Flip Register 58 */
#define MTU_MC13_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DD4u)

/** \brief DD6, Read Data and Bit Flip Register 59 */
#define MTU_MC13_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DD6u)

/** \brief DD8, Read Data and Bit Flip Register 60 */
#define MTU_MC13_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DD8u)

/** \brief DDA, Read Data and Bit Flip Register 61 */
#define MTU_MC13_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DDAu)

/** \brief DDC, Read Data and Bit Flip Register 62 */
#define MTU_MC13_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DDCu)

/** \brief DDE, Read Data and Bit Flip Register 63 */
#define MTU_MC13_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DDEu)

/** \brief DE0, Read Data and Bit Flip Register 64 */
#define MTU_MC13_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DE0u)

/** \brief DE2, Read Data and Bit Flip Register 65 */
#define MTU_MC13_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DE2u)

/** \brief DE4, Read Data and Bit Flip Register 66 */
#define MTU_MC13_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061DE4u)

/** \brief DEE, Alarm Sources Configuration Register */
#define MTU_MC13_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0061DEEu)

/** \brief DF0, SSH Safety Faults Status Register  */
#define MTU_MC13_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0061DF0u)

/** \brief DF2, Error Information Register 0 */
#define MTU_MC13_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061DF2u)

/** \brief DF4, Error Information Register 1 */
#define MTU_MC13_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061DF4u)

/** \brief DF6, Error Information Register 2 */
#define MTU_MC13_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061DF6u)

/** \brief DF8, Error Information Register 3 */
#define MTU_MC13_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061DF8u)

/** \brief DFA, Error Information Register 4 */
#define MTU_MC13_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061DFAu)

/** \brief E00, Configuration Registers */
#define MTU_MC14_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061E00u)

/** \brief E02, Configuration Register 1 */
#define MTU_MC14_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061E02u)

/** \brief E04, MBIST Control Register */
#define MTU_MC14_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061E04u)

/** \brief E06, Status Register */
#define MTU_MC14_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061E06u)

/** \brief E08, Range Register, single address mode */
#define MTU_MC14_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061E08u)

/** \brief E0C, Revision ID Register */
#define MTU_MC14_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0061E0Cu)

/** \brief E0E, ECC Safety Register */
#define MTU_MC14_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0061E0Eu)

/** \brief E10, Memory ECC Detection Register */
#define MTU_MC14_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061E10u)

/** \brief E12, Error Tracking Register 0 */
#define MTU_MC14_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061E12u)

/** \brief E14, Error Tracking Register 1 */
#define MTU_MC14_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061E14u)

/** \brief E16, Error Tracking Register 2 */
#define MTU_MC14_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061E16u)

/** \brief E18, Error Tracking Register 3 */
#define MTU_MC14_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061E18u)

/** \brief E1A, Error Tracking Register 4 */
#define MTU_MC14_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061E1Au)

/** \brief E60, Read Data and Bit Flip Register 0 */
#define MTU_MC14_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E60u)

/** \brief E62, Read Data and Bit Flip Register 1 */
#define MTU_MC14_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E62u)

/** \brief E64, Read Data and Bit Flip Register 2 */
#define MTU_MC14_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E64u)

/** \brief E66, Read Data and Bit Flip Register 3 */
#define MTU_MC14_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E66u)

/** \brief E68, Read Data and Bit Flip Register 4 */
#define MTU_MC14_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E68u)

/** \brief E6A, Read Data and Bit Flip Register 5 */
#define MTU_MC14_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E6Au)

/** \brief E6C, Read Data and Bit Flip Register 6 */
#define MTU_MC14_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E6Cu)

/** \brief E6E, Read Data and Bit Flip Register 7 */
#define MTU_MC14_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E6Eu)

/** \brief E70, Read Data and Bit Flip Register 8 */
#define MTU_MC14_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E70u)

/** \brief E72, Read Data and Bit Flip Register 9 */
#define MTU_MC14_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E72u)

/** \brief E74, Read Data and Bit Flip Register 10 */
#define MTU_MC14_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E74u)

/** \brief E76, Read Data and Bit Flip Register 11 */
#define MTU_MC14_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E76u)

/** \brief E78, Read Data and Bit Flip Register 12 */
#define MTU_MC14_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E78u)

/** \brief E7A, Read Data and Bit Flip Register 13 */
#define MTU_MC14_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E7Au)

/** \brief E7C, Read Data and Bit Flip Register 14 */
#define MTU_MC14_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E7Cu)

/** \brief E7E, Read Data and Bit Flip Register 15 */
#define MTU_MC14_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E7Eu)

/** \brief E80, Read Data and Bit Flip Register 16 */
#define MTU_MC14_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E80u)

/** \brief E82, Read Data and Bit Flip Register 17 */
#define MTU_MC14_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E82u)

/** \brief E84, Read Data and Bit Flip Register 18 */
#define MTU_MC14_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E84u)

/** \brief E86, Read Data and Bit Flip Register 19 */
#define MTU_MC14_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E86u)

/** \brief E88, Read Data and Bit Flip Register 20 */
#define MTU_MC14_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E88u)

/** \brief E8A, Read Data and Bit Flip Register 21 */
#define MTU_MC14_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E8Au)

/** \brief E8C, Read Data and Bit Flip Register 22 */
#define MTU_MC14_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E8Cu)

/** \brief E8E, Read Data and Bit Flip Register 23 */
#define MTU_MC14_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E8Eu)

/** \brief E90, Read Data and Bit Flip Register 24 */
#define MTU_MC14_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E90u)

/** \brief E92, Read Data and Bit Flip Register 25 */
#define MTU_MC14_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E92u)

/** \brief E94, Read Data and Bit Flip Register 26 */
#define MTU_MC14_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E94u)

/** \brief E96, Read Data and Bit Flip Register 27 */
#define MTU_MC14_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E96u)

/** \brief E98, Read Data and Bit Flip Register 28 */
#define MTU_MC14_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E98u)

/** \brief E9A, Read Data and Bit Flip Register 29 */
#define MTU_MC14_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E9Au)

/** \brief E9C, Read Data and Bit Flip Register 30 */
#define MTU_MC14_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E9Cu)

/** \brief E9E, Read Data and Bit Flip Register 31 */
#define MTU_MC14_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061E9Eu)

/** \brief EA0, Read Data and Bit Flip Register 32 */
#define MTU_MC14_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EA0u)

/** \brief EA2, Read Data and Bit Flip Register 33 */
#define MTU_MC14_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EA2u)

/** \brief EA4, Read Data and Bit Flip Register 34 */
#define MTU_MC14_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EA4u)

/** \brief EA6, Read Data and Bit Flip Register 35 */
#define MTU_MC14_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EA6u)

/** \brief EA8, Read Data and Bit Flip Register 36 */
#define MTU_MC14_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EA8u)

/** \brief EAA, Read Data and Bit Flip Register 37 */
#define MTU_MC14_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EAAu)

/** \brief EAC, Read Data and Bit Flip Register 38 */
#define MTU_MC14_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EACu)

/** \brief EAE, Read Data and Bit Flip Register 39 */
#define MTU_MC14_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EAEu)

/** \brief EB0, Read Data and Bit Flip Register 40 */
#define MTU_MC14_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EB0u)

/** \brief EB2, Read Data and Bit Flip Register 41 */
#define MTU_MC14_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EB2u)

/** \brief EB4, Read Data and Bit Flip Register 42 */
#define MTU_MC14_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EB4u)

/** \brief EB6, Read Data and Bit Flip Register 43 */
#define MTU_MC14_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EB6u)

/** \brief EB8, Read Data and Bit Flip Register 44 */
#define MTU_MC14_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EB8u)

/** \brief EBA, Read Data and Bit Flip Register 45 */
#define MTU_MC14_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EBAu)

/** \brief EBC, Read Data and Bit Flip Register 46 */
#define MTU_MC14_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EBCu)

/** \brief EBE, Read Data and Bit Flip Register 47 */
#define MTU_MC14_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EBEu)

/** \brief EC0, Read Data and Bit Flip Register 48 */
#define MTU_MC14_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EC0u)

/** \brief EC2, Read Data and Bit Flip Register 49 */
#define MTU_MC14_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EC2u)

/** \brief EC4, Read Data and Bit Flip Register 50 */
#define MTU_MC14_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EC4u)

/** \brief EC6, Read Data and Bit Flip Register 51 */
#define MTU_MC14_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EC6u)

/** \brief EC8, Read Data and Bit Flip Register 52 */
#define MTU_MC14_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EC8u)

/** \brief ECA, Read Data and Bit Flip Register 53 */
#define MTU_MC14_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ECAu)

/** \brief ECC, Read Data and Bit Flip Register 54 */
#define MTU_MC14_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ECCu)

/** \brief ECE, Read Data and Bit Flip Register 55 */
#define MTU_MC14_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ECEu)

/** \brief ED0, Read Data and Bit Flip Register 56 */
#define MTU_MC14_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ED0u)

/** \brief ED2, Read Data and Bit Flip Register 57 */
#define MTU_MC14_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ED2u)

/** \brief ED4, Read Data and Bit Flip Register 58 */
#define MTU_MC14_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ED4u)

/** \brief ED6, Read Data and Bit Flip Register 59 */
#define MTU_MC14_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ED6u)

/** \brief ED8, Read Data and Bit Flip Register 60 */
#define MTU_MC14_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061ED8u)

/** \brief EDA, Read Data and Bit Flip Register 61 */
#define MTU_MC14_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EDAu)

/** \brief EDC, Read Data and Bit Flip Register 62 */
#define MTU_MC14_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EDCu)

/** \brief EDE, Read Data and Bit Flip Register 63 */
#define MTU_MC14_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EDEu)

/** \brief EE0, Read Data and Bit Flip Register 64 */
#define MTU_MC14_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EE0u)

/** \brief EE2, Read Data and Bit Flip Register 65 */
#define MTU_MC14_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EE2u)

/** \brief EE4, Read Data and Bit Flip Register 66 */
#define MTU_MC14_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061EE4u)

/** \brief EEE, Alarm Sources Configuration Register */
#define MTU_MC14_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0061EEEu)

/** \brief EF0, SSH Safety Faults Status Register  */
#define MTU_MC14_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0061EF0u)

/** \brief EF2, Error Information Register 0 */
#define MTU_MC14_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061EF2u)

/** \brief EF4, Error Information Register 1 */
#define MTU_MC14_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061EF4u)

/** \brief EF6, Error Information Register 2 */
#define MTU_MC14_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061EF6u)

/** \brief EF8, Error Information Register 3 */
#define MTU_MC14_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061EF8u)

/** \brief EFA, Error Information Register 4 */
#define MTU_MC14_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061EFAu)

/** \brief F00, Configuration Registers */
#define MTU_MC15_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0061F00u)

/** \brief F02, Configuration Register 1 */
#define MTU_MC15_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0061F02u)

/** \brief F04, MBIST Control Register */
#define MTU_MC15_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0061F04u)

/** \brief F06, Status Register */
#define MTU_MC15_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0061F06u)

/** \brief F08, Range Register, single address mode */
#define MTU_MC15_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0061F08u)

/** \brief F0C, Revision ID Register */
#define MTU_MC15_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0061F0Cu)

/** \brief F0E, ECC Safety Register */
#define MTU_MC15_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0061F0Eu)

/** \brief F10, Memory ECC Detection Register */
#define MTU_MC15_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0061F10u)

/** \brief F12, Error Tracking Register 0 */
#define MTU_MC15_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061F12u)

/** \brief F14, Error Tracking Register 1 */
#define MTU_MC15_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061F14u)

/** \brief F16, Error Tracking Register 2 */
#define MTU_MC15_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061F16u)

/** \brief F18, Error Tracking Register 3 */
#define MTU_MC15_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061F18u)

/** \brief F1A, Error Tracking Register 4 */
#define MTU_MC15_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0061F1Au)

/** \brief F60, Read Data and Bit Flip Register 0 */
#define MTU_MC15_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F60u)

/** \brief F62, Read Data and Bit Flip Register 1 */
#define MTU_MC15_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F62u)

/** \brief F64, Read Data and Bit Flip Register 2 */
#define MTU_MC15_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F64u)

/** \brief F66, Read Data and Bit Flip Register 3 */
#define MTU_MC15_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F66u)

/** \brief F68, Read Data and Bit Flip Register 4 */
#define MTU_MC15_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F68u)

/** \brief F6A, Read Data and Bit Flip Register 5 */
#define MTU_MC15_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F6Au)

/** \brief F6C, Read Data and Bit Flip Register 6 */
#define MTU_MC15_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F6Cu)

/** \brief F6E, Read Data and Bit Flip Register 7 */
#define MTU_MC15_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F6Eu)

/** \brief F70, Read Data and Bit Flip Register 8 */
#define MTU_MC15_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F70u)

/** \brief F72, Read Data and Bit Flip Register 9 */
#define MTU_MC15_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F72u)

/** \brief F74, Read Data and Bit Flip Register 10 */
#define MTU_MC15_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F74u)

/** \brief F76, Read Data and Bit Flip Register 11 */
#define MTU_MC15_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F76u)

/** \brief F78, Read Data and Bit Flip Register 12 */
#define MTU_MC15_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F78u)

/** \brief F7A, Read Data and Bit Flip Register 13 */
#define MTU_MC15_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F7Au)

/** \brief F7C, Read Data and Bit Flip Register 14 */
#define MTU_MC15_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F7Cu)

/** \brief F7E, Read Data and Bit Flip Register 15 */
#define MTU_MC15_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F7Eu)

/** \brief F80, Read Data and Bit Flip Register 16 */
#define MTU_MC15_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F80u)

/** \brief F82, Read Data and Bit Flip Register 17 */
#define MTU_MC15_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F82u)

/** \brief F84, Read Data and Bit Flip Register 18 */
#define MTU_MC15_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F84u)

/** \brief F86, Read Data and Bit Flip Register 19 */
#define MTU_MC15_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F86u)

/** \brief F88, Read Data and Bit Flip Register 20 */
#define MTU_MC15_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F88u)

/** \brief F8A, Read Data and Bit Flip Register 21 */
#define MTU_MC15_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F8Au)

/** \brief F8C, Read Data and Bit Flip Register 22 */
#define MTU_MC15_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F8Cu)

/** \brief F8E, Read Data and Bit Flip Register 23 */
#define MTU_MC15_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F8Eu)

/** \brief F90, Read Data and Bit Flip Register 24 */
#define MTU_MC15_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F90u)

/** \brief F92, Read Data and Bit Flip Register 25 */
#define MTU_MC15_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F92u)

/** \brief F94, Read Data and Bit Flip Register 26 */
#define MTU_MC15_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F94u)

/** \brief F96, Read Data and Bit Flip Register 27 */
#define MTU_MC15_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F96u)

/** \brief F98, Read Data and Bit Flip Register 28 */
#define MTU_MC15_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F98u)

/** \brief F9A, Read Data and Bit Flip Register 29 */
#define MTU_MC15_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F9Au)

/** \brief F9C, Read Data and Bit Flip Register 30 */
#define MTU_MC15_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F9Cu)

/** \brief F9E, Read Data and Bit Flip Register 31 */
#define MTU_MC15_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061F9Eu)

/** \brief FA0, Read Data and Bit Flip Register 32 */
#define MTU_MC15_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FA0u)

/** \brief FA2, Read Data and Bit Flip Register 33 */
#define MTU_MC15_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FA2u)

/** \brief FA4, Read Data and Bit Flip Register 34 */
#define MTU_MC15_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FA4u)

/** \brief FA6, Read Data and Bit Flip Register 35 */
#define MTU_MC15_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FA6u)

/** \brief FA8, Read Data and Bit Flip Register 36 */
#define MTU_MC15_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FA8u)

/** \brief FAA, Read Data and Bit Flip Register 37 */
#define MTU_MC15_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FAAu)

/** \brief FAC, Read Data and Bit Flip Register 38 */
#define MTU_MC15_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FACu)

/** \brief FAE, Read Data and Bit Flip Register 39 */
#define MTU_MC15_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FAEu)

/** \brief FB0, Read Data and Bit Flip Register 40 */
#define MTU_MC15_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FB0u)

/** \brief FB2, Read Data and Bit Flip Register 41 */
#define MTU_MC15_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FB2u)

/** \brief FB4, Read Data and Bit Flip Register 42 */
#define MTU_MC15_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FB4u)

/** \brief FB6, Read Data and Bit Flip Register 43 */
#define MTU_MC15_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FB6u)

/** \brief FB8, Read Data and Bit Flip Register 44 */
#define MTU_MC15_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FB8u)

/** \brief FBA, Read Data and Bit Flip Register 45 */
#define MTU_MC15_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FBAu)

/** \brief FBC, Read Data and Bit Flip Register 46 */
#define MTU_MC15_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FBCu)

/** \brief FBE, Read Data and Bit Flip Register 47 */
#define MTU_MC15_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FBEu)

/** \brief FC0, Read Data and Bit Flip Register 48 */
#define MTU_MC15_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FC0u)

/** \brief FC2, Read Data and Bit Flip Register 49 */
#define MTU_MC15_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FC2u)

/** \brief FC4, Read Data and Bit Flip Register 50 */
#define MTU_MC15_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FC4u)

/** \brief FC6, Read Data and Bit Flip Register 51 */
#define MTU_MC15_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FC6u)

/** \brief FC8, Read Data and Bit Flip Register 52 */
#define MTU_MC15_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FC8u)

/** \brief FCA, Read Data and Bit Flip Register 53 */
#define MTU_MC15_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FCAu)

/** \brief FCC, Read Data and Bit Flip Register 54 */
#define MTU_MC15_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FCCu)

/** \brief FCE, Read Data and Bit Flip Register 55 */
#define MTU_MC15_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FCEu)

/** \brief FD0, Read Data and Bit Flip Register 56 */
#define MTU_MC15_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FD0u)

/** \brief FD2, Read Data and Bit Flip Register 57 */
#define MTU_MC15_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FD2u)

/** \brief FD4, Read Data and Bit Flip Register 58 */
#define MTU_MC15_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FD4u)

/** \brief FD6, Read Data and Bit Flip Register 59 */
#define MTU_MC15_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FD6u)

/** \brief FD8, Read Data and Bit Flip Register 60 */
#define MTU_MC15_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FD8u)

/** \brief FDA, Read Data and Bit Flip Register 61 */
#define MTU_MC15_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FDAu)

/** \brief FDC, Read Data and Bit Flip Register 62 */
#define MTU_MC15_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FDCu)

/** \brief FDE, Read Data and Bit Flip Register 63 */
#define MTU_MC15_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FDEu)

/** \brief FE0, Read Data and Bit Flip Register 64 */
#define MTU_MC15_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FE0u)

/** \brief FE2, Read Data and Bit Flip Register 65 */
#define MTU_MC15_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FE2u)

/** \brief FE4, Read Data and Bit Flip Register 66 */
#define MTU_MC15_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0061FE4u)

/** \brief FEE, Alarm Sources Configuration Register */
#define MTU_MC15_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0061FEEu)

/** \brief FF0, SSH Safety Faults Status Register  */
#define MTU_MC15_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0061FF0u)

/** \brief FF2, Error Information Register 0 */
#define MTU_MC15_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061FF2u)

/** \brief FF4, Error Information Register 1 */
#define MTU_MC15_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061FF4u)

/** \brief FF6, Error Information Register 2 */
#define MTU_MC15_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061FF6u)

/** \brief FF8, Error Information Register 3 */
#define MTU_MC15_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061FF8u)

/** \brief FFA, Error Information Register 4 */
#define MTU_MC15_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0061FFAu)

/** \brief 1000, Configuration Registers */
#define MTU_MC16_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062000u)

/** \brief 1002, Configuration Register 1 */
#define MTU_MC16_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062002u)

/** \brief 1004, MBIST Control Register */
#define MTU_MC16_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062004u)

/** \brief 1006, Status Register */
#define MTU_MC16_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062006u)

/** \brief 1008, Range Register, single address mode */
#define MTU_MC16_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062008u)

/** \brief 100C, Revision ID Register */
#define MTU_MC16_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006200Cu)

/** \brief 100E, ECC Safety Register */
#define MTU_MC16_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006200Eu)

/** \brief 1010, Memory ECC Detection Register */
#define MTU_MC16_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062010u)

/** \brief 1012, Error Tracking Register 0 */
#define MTU_MC16_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062012u)

/** \brief 1014, Error Tracking Register 1 */
#define MTU_MC16_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062014u)

/** \brief 1016, Error Tracking Register 2 */
#define MTU_MC16_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062016u)

/** \brief 1018, Error Tracking Register 3 */
#define MTU_MC16_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062018u)

/** \brief 101A, Error Tracking Register 4 */
#define MTU_MC16_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006201Au)

/** \brief 1060, Read Data and Bit Flip Register 0 */
#define MTU_MC16_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062060u)

/** \brief 1062, Read Data and Bit Flip Register 1 */
#define MTU_MC16_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062062u)

/** \brief 1064, Read Data and Bit Flip Register 2 */
#define MTU_MC16_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062064u)

/** \brief 1066, Read Data and Bit Flip Register 3 */
#define MTU_MC16_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062066u)

/** \brief 1068, Read Data and Bit Flip Register 4 */
#define MTU_MC16_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062068u)

/** \brief 106A, Read Data and Bit Flip Register 5 */
#define MTU_MC16_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006206Au)

/** \brief 106C, Read Data and Bit Flip Register 6 */
#define MTU_MC16_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006206Cu)

/** \brief 106E, Read Data and Bit Flip Register 7 */
#define MTU_MC16_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006206Eu)

/** \brief 1070, Read Data and Bit Flip Register 8 */
#define MTU_MC16_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062070u)

/** \brief 1072, Read Data and Bit Flip Register 9 */
#define MTU_MC16_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062072u)

/** \brief 1074, Read Data and Bit Flip Register 10 */
#define MTU_MC16_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062074u)

/** \brief 1076, Read Data and Bit Flip Register 11 */
#define MTU_MC16_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062076u)

/** \brief 1078, Read Data and Bit Flip Register 12 */
#define MTU_MC16_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062078u)

/** \brief 107A, Read Data and Bit Flip Register 13 */
#define MTU_MC16_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006207Au)

/** \brief 107C, Read Data and Bit Flip Register 14 */
#define MTU_MC16_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006207Cu)

/** \brief 107E, Read Data and Bit Flip Register 15 */
#define MTU_MC16_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006207Eu)

/** \brief 1080, Read Data and Bit Flip Register 16 */
#define MTU_MC16_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062080u)

/** \brief 1082, Read Data and Bit Flip Register 17 */
#define MTU_MC16_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062082u)

/** \brief 1084, Read Data and Bit Flip Register 18 */
#define MTU_MC16_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062084u)

/** \brief 1086, Read Data and Bit Flip Register 19 */
#define MTU_MC16_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062086u)

/** \brief 1088, Read Data and Bit Flip Register 20 */
#define MTU_MC16_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062088u)

/** \brief 108A, Read Data and Bit Flip Register 21 */
#define MTU_MC16_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006208Au)

/** \brief 108C, Read Data and Bit Flip Register 22 */
#define MTU_MC16_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006208Cu)

/** \brief 108E, Read Data and Bit Flip Register 23 */
#define MTU_MC16_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006208Eu)

/** \brief 1090, Read Data and Bit Flip Register 24 */
#define MTU_MC16_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062090u)

/** \brief 1092, Read Data and Bit Flip Register 25 */
#define MTU_MC16_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062092u)

/** \brief 1094, Read Data and Bit Flip Register 26 */
#define MTU_MC16_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062094u)

/** \brief 1096, Read Data and Bit Flip Register 27 */
#define MTU_MC16_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062096u)

/** \brief 1098, Read Data and Bit Flip Register 28 */
#define MTU_MC16_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062098u)

/** \brief 109A, Read Data and Bit Flip Register 29 */
#define MTU_MC16_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006209Au)

/** \brief 109C, Read Data and Bit Flip Register 30 */
#define MTU_MC16_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006209Cu)

/** \brief 109E, Read Data and Bit Flip Register 31 */
#define MTU_MC16_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006209Eu)

/** \brief 10A0, Read Data and Bit Flip Register 32 */
#define MTU_MC16_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620A0u)

/** \brief 10A2, Read Data and Bit Flip Register 33 */
#define MTU_MC16_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620A2u)

/** \brief 10A4, Read Data and Bit Flip Register 34 */
#define MTU_MC16_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620A4u)

/** \brief 10A6, Read Data and Bit Flip Register 35 */
#define MTU_MC16_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620A6u)

/** \brief 10A8, Read Data and Bit Flip Register 36 */
#define MTU_MC16_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620A8u)

/** \brief 10AA, Read Data and Bit Flip Register 37 */
#define MTU_MC16_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620AAu)

/** \brief 10AC, Read Data and Bit Flip Register 38 */
#define MTU_MC16_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620ACu)

/** \brief 10AE, Read Data and Bit Flip Register 39 */
#define MTU_MC16_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620AEu)

/** \brief 10B0, Read Data and Bit Flip Register 40 */
#define MTU_MC16_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620B0u)

/** \brief 10B2, Read Data and Bit Flip Register 41 */
#define MTU_MC16_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620B2u)

/** \brief 10B4, Read Data and Bit Flip Register 42 */
#define MTU_MC16_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620B4u)

/** \brief 10B6, Read Data and Bit Flip Register 43 */
#define MTU_MC16_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620B6u)

/** \brief 10B8, Read Data and Bit Flip Register 44 */
#define MTU_MC16_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620B8u)

/** \brief 10BA, Read Data and Bit Flip Register 45 */
#define MTU_MC16_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620BAu)

/** \brief 10BC, Read Data and Bit Flip Register 46 */
#define MTU_MC16_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620BCu)

/** \brief 10BE, Read Data and Bit Flip Register 47 */
#define MTU_MC16_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620BEu)

/** \brief 10C0, Read Data and Bit Flip Register 48 */
#define MTU_MC16_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620C0u)

/** \brief 10C2, Read Data and Bit Flip Register 49 */
#define MTU_MC16_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620C2u)

/** \brief 10C4, Read Data and Bit Flip Register 50 */
#define MTU_MC16_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620C4u)

/** \brief 10C6, Read Data and Bit Flip Register 51 */
#define MTU_MC16_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620C6u)

/** \brief 10C8, Read Data and Bit Flip Register 52 */
#define MTU_MC16_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620C8u)

/** \brief 10CA, Read Data and Bit Flip Register 53 */
#define MTU_MC16_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620CAu)

/** \brief 10CC, Read Data and Bit Flip Register 54 */
#define MTU_MC16_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620CCu)

/** \brief 10CE, Read Data and Bit Flip Register 55 */
#define MTU_MC16_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620CEu)

/** \brief 10D0, Read Data and Bit Flip Register 56 */
#define MTU_MC16_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620D0u)

/** \brief 10D2, Read Data and Bit Flip Register 57 */
#define MTU_MC16_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620D2u)

/** \brief 10D4, Read Data and Bit Flip Register 58 */
#define MTU_MC16_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620D4u)

/** \brief 10D6, Read Data and Bit Flip Register 59 */
#define MTU_MC16_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620D6u)

/** \brief 10D8, Read Data and Bit Flip Register 60 */
#define MTU_MC16_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620D8u)

/** \brief 10DA, Read Data and Bit Flip Register 61 */
#define MTU_MC16_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620DAu)

/** \brief 10DC, Read Data and Bit Flip Register 62 */
#define MTU_MC16_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620DCu)

/** \brief 10DE, Read Data and Bit Flip Register 63 */
#define MTU_MC16_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620DEu)

/** \brief 10E0, Read Data and Bit Flip Register 64 */
#define MTU_MC16_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620E0u)

/** \brief 10E2, Read Data and Bit Flip Register 65 */
#define MTU_MC16_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620E2u)

/** \brief 10E4, Read Data and Bit Flip Register 66 */
#define MTU_MC16_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00620E4u)

/** \brief 10EE, Alarm Sources Configuration Register */
#define MTU_MC16_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00620EEu)

/** \brief 10F0, SSH Safety Faults Status Register  */
#define MTU_MC16_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00620F0u)

/** \brief 10F2, Error Information Register 0 */
#define MTU_MC16_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00620F2u)

/** \brief 10F4, Error Information Register 1 */
#define MTU_MC16_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00620F4u)

/** \brief 10F6, Error Information Register 2 */
#define MTU_MC16_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00620F6u)

/** \brief 10F8, Error Information Register 3 */
#define MTU_MC16_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00620F8u)

/** \brief 10FA, Error Information Register 4 */
#define MTU_MC16_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00620FAu)

/** \brief 1100, Configuration Registers */
#define MTU_MC17_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062100u)

/** \brief 1102, Configuration Register 1 */
#define MTU_MC17_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062102u)

/** \brief 1104, MBIST Control Register */
#define MTU_MC17_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062104u)

/** \brief 1106, Status Register */
#define MTU_MC17_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062106u)

/** \brief 1108, Range Register, single address mode */
#define MTU_MC17_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062108u)

/** \brief 110C, Revision ID Register */
#define MTU_MC17_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006210Cu)

/** \brief 110E, ECC Safety Register */
#define MTU_MC17_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006210Eu)

/** \brief 1110, Memory ECC Detection Register */
#define MTU_MC17_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062110u)

/** \brief 1112, Error Tracking Register 0 */
#define MTU_MC17_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062112u)

/** \brief 1114, Error Tracking Register 1 */
#define MTU_MC17_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062114u)

/** \brief 1116, Error Tracking Register 2 */
#define MTU_MC17_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062116u)

/** \brief 1118, Error Tracking Register 3 */
#define MTU_MC17_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062118u)

/** \brief 111A, Error Tracking Register 4 */
#define MTU_MC17_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006211Au)

/** \brief 1160, Read Data and Bit Flip Register 0 */
#define MTU_MC17_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062160u)

/** \brief 1162, Read Data and Bit Flip Register 1 */
#define MTU_MC17_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062162u)

/** \brief 1164, Read Data and Bit Flip Register 2 */
#define MTU_MC17_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062164u)

/** \brief 1166, Read Data and Bit Flip Register 3 */
#define MTU_MC17_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062166u)

/** \brief 1168, Read Data and Bit Flip Register 4 */
#define MTU_MC17_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062168u)

/** \brief 116A, Read Data and Bit Flip Register 5 */
#define MTU_MC17_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006216Au)

/** \brief 116C, Read Data and Bit Flip Register 6 */
#define MTU_MC17_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006216Cu)

/** \brief 116E, Read Data and Bit Flip Register 7 */
#define MTU_MC17_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006216Eu)

/** \brief 1170, Read Data and Bit Flip Register 8 */
#define MTU_MC17_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062170u)

/** \brief 1172, Read Data and Bit Flip Register 9 */
#define MTU_MC17_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062172u)

/** \brief 1174, Read Data and Bit Flip Register 10 */
#define MTU_MC17_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062174u)

/** \brief 1176, Read Data and Bit Flip Register 11 */
#define MTU_MC17_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062176u)

/** \brief 1178, Read Data and Bit Flip Register 12 */
#define MTU_MC17_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062178u)

/** \brief 117A, Read Data and Bit Flip Register 13 */
#define MTU_MC17_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006217Au)

/** \brief 117C, Read Data and Bit Flip Register 14 */
#define MTU_MC17_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006217Cu)

/** \brief 117E, Read Data and Bit Flip Register 15 */
#define MTU_MC17_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006217Eu)

/** \brief 1180, Read Data and Bit Flip Register 16 */
#define MTU_MC17_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062180u)

/** \brief 1182, Read Data and Bit Flip Register 17 */
#define MTU_MC17_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062182u)

/** \brief 1184, Read Data and Bit Flip Register 18 */
#define MTU_MC17_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062184u)

/** \brief 1186, Read Data and Bit Flip Register 19 */
#define MTU_MC17_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062186u)

/** \brief 1188, Read Data and Bit Flip Register 20 */
#define MTU_MC17_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062188u)

/** \brief 118A, Read Data and Bit Flip Register 21 */
#define MTU_MC17_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006218Au)

/** \brief 118C, Read Data and Bit Flip Register 22 */
#define MTU_MC17_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006218Cu)

/** \brief 118E, Read Data and Bit Flip Register 23 */
#define MTU_MC17_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006218Eu)

/** \brief 1190, Read Data and Bit Flip Register 24 */
#define MTU_MC17_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062190u)

/** \brief 1192, Read Data and Bit Flip Register 25 */
#define MTU_MC17_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062192u)

/** \brief 1194, Read Data and Bit Flip Register 26 */
#define MTU_MC17_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062194u)

/** \brief 1196, Read Data and Bit Flip Register 27 */
#define MTU_MC17_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062196u)

/** \brief 1198, Read Data and Bit Flip Register 28 */
#define MTU_MC17_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062198u)

/** \brief 119A, Read Data and Bit Flip Register 29 */
#define MTU_MC17_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006219Au)

/** \brief 119C, Read Data and Bit Flip Register 30 */
#define MTU_MC17_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006219Cu)

/** \brief 119E, Read Data and Bit Flip Register 31 */
#define MTU_MC17_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006219Eu)

/** \brief 11A0, Read Data and Bit Flip Register 32 */
#define MTU_MC17_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621A0u)

/** \brief 11A2, Read Data and Bit Flip Register 33 */
#define MTU_MC17_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621A2u)

/** \brief 11A4, Read Data and Bit Flip Register 34 */
#define MTU_MC17_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621A4u)

/** \brief 11A6, Read Data and Bit Flip Register 35 */
#define MTU_MC17_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621A6u)

/** \brief 11A8, Read Data and Bit Flip Register 36 */
#define MTU_MC17_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621A8u)

/** \brief 11AA, Read Data and Bit Flip Register 37 */
#define MTU_MC17_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621AAu)

/** \brief 11AC, Read Data and Bit Flip Register 38 */
#define MTU_MC17_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621ACu)

/** \brief 11AE, Read Data and Bit Flip Register 39 */
#define MTU_MC17_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621AEu)

/** \brief 11B0, Read Data and Bit Flip Register 40 */
#define MTU_MC17_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621B0u)

/** \brief 11B2, Read Data and Bit Flip Register 41 */
#define MTU_MC17_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621B2u)

/** \brief 11B4, Read Data and Bit Flip Register 42 */
#define MTU_MC17_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621B4u)

/** \brief 11B6, Read Data and Bit Flip Register 43 */
#define MTU_MC17_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621B6u)

/** \brief 11B8, Read Data and Bit Flip Register 44 */
#define MTU_MC17_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621B8u)

/** \brief 11BA, Read Data and Bit Flip Register 45 */
#define MTU_MC17_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621BAu)

/** \brief 11BC, Read Data and Bit Flip Register 46 */
#define MTU_MC17_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621BCu)

/** \brief 11BE, Read Data and Bit Flip Register 47 */
#define MTU_MC17_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621BEu)

/** \brief 11C0, Read Data and Bit Flip Register 48 */
#define MTU_MC17_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621C0u)

/** \brief 11C2, Read Data and Bit Flip Register 49 */
#define MTU_MC17_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621C2u)

/** \brief 11C4, Read Data and Bit Flip Register 50 */
#define MTU_MC17_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621C4u)

/** \brief 11C6, Read Data and Bit Flip Register 51 */
#define MTU_MC17_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621C6u)

/** \brief 11C8, Read Data and Bit Flip Register 52 */
#define MTU_MC17_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621C8u)

/** \brief 11CA, Read Data and Bit Flip Register 53 */
#define MTU_MC17_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621CAu)

/** \brief 11CC, Read Data and Bit Flip Register 54 */
#define MTU_MC17_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621CCu)

/** \brief 11CE, Read Data and Bit Flip Register 55 */
#define MTU_MC17_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621CEu)

/** \brief 11D0, Read Data and Bit Flip Register 56 */
#define MTU_MC17_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621D0u)

/** \brief 11D2, Read Data and Bit Flip Register 57 */
#define MTU_MC17_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621D2u)

/** \brief 11D4, Read Data and Bit Flip Register 58 */
#define MTU_MC17_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621D4u)

/** \brief 11D6, Read Data and Bit Flip Register 59 */
#define MTU_MC17_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621D6u)

/** \brief 11D8, Read Data and Bit Flip Register 60 */
#define MTU_MC17_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621D8u)

/** \brief 11DA, Read Data and Bit Flip Register 61 */
#define MTU_MC17_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621DAu)

/** \brief 11DC, Read Data and Bit Flip Register 62 */
#define MTU_MC17_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621DCu)

/** \brief 11DE, Read Data and Bit Flip Register 63 */
#define MTU_MC17_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621DEu)

/** \brief 11E0, Read Data and Bit Flip Register 64 */
#define MTU_MC17_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621E0u)

/** \brief 11E2, Read Data and Bit Flip Register 65 */
#define MTU_MC17_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621E2u)

/** \brief 11E4, Read Data and Bit Flip Register 66 */
#define MTU_MC17_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00621E4u)

/** \brief 11EE, Alarm Sources Configuration Register */
#define MTU_MC17_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00621EEu)

/** \brief 11F0, SSH Safety Faults Status Register  */
#define MTU_MC17_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00621F0u)

/** \brief 11F2, Error Information Register 0 */
#define MTU_MC17_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00621F2u)

/** \brief 11F4, Error Information Register 1 */
#define MTU_MC17_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00621F4u)

/** \brief 11F6, Error Information Register 2 */
#define MTU_MC17_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00621F6u)

/** \brief 11F8, Error Information Register 3 */
#define MTU_MC17_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00621F8u)

/** \brief 11FA, Error Information Register 4 */
#define MTU_MC17_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00621FAu)

/** \brief 1200, Configuration Registers */
#define MTU_MC18_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062200u)

/** \brief 1202, Configuration Register 1 */
#define MTU_MC18_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062202u)

/** \brief 1204, MBIST Control Register */
#define MTU_MC18_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062204u)

/** \brief 1206, Status Register */
#define MTU_MC18_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062206u)

/** \brief 1208, Range Register, single address mode */
#define MTU_MC18_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062208u)

/** \brief 120C, Revision ID Register */
#define MTU_MC18_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006220Cu)

/** \brief 120E, ECC Safety Register */
#define MTU_MC18_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006220Eu)

/** \brief 1210, Memory ECC Detection Register */
#define MTU_MC18_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062210u)

/** \brief 1212, Error Tracking Register 0 */
#define MTU_MC18_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062212u)

/** \brief 1214, Error Tracking Register 1 */
#define MTU_MC18_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062214u)

/** \brief 1216, Error Tracking Register 2 */
#define MTU_MC18_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062216u)

/** \brief 1218, Error Tracking Register 3 */
#define MTU_MC18_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062218u)

/** \brief 121A, Error Tracking Register 4 */
#define MTU_MC18_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006221Au)

/** \brief 1260, Read Data and Bit Flip Register 0 */
#define MTU_MC18_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062260u)

/** \brief 1262, Read Data and Bit Flip Register 1 */
#define MTU_MC18_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062262u)

/** \brief 1264, Read Data and Bit Flip Register 2 */
#define MTU_MC18_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062264u)

/** \brief 1266, Read Data and Bit Flip Register 3 */
#define MTU_MC18_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062266u)

/** \brief 1268, Read Data and Bit Flip Register 4 */
#define MTU_MC18_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062268u)

/** \brief 126A, Read Data and Bit Flip Register 5 */
#define MTU_MC18_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006226Au)

/** \brief 126C, Read Data and Bit Flip Register 6 */
#define MTU_MC18_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006226Cu)

/** \brief 126E, Read Data and Bit Flip Register 7 */
#define MTU_MC18_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006226Eu)

/** \brief 1270, Read Data and Bit Flip Register 8 */
#define MTU_MC18_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062270u)

/** \brief 1272, Read Data and Bit Flip Register 9 */
#define MTU_MC18_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062272u)

/** \brief 1274, Read Data and Bit Flip Register 10 */
#define MTU_MC18_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062274u)

/** \brief 1276, Read Data and Bit Flip Register 11 */
#define MTU_MC18_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062276u)

/** \brief 1278, Read Data and Bit Flip Register 12 */
#define MTU_MC18_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062278u)

/** \brief 127A, Read Data and Bit Flip Register 13 */
#define MTU_MC18_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006227Au)

/** \brief 127C, Read Data and Bit Flip Register 14 */
#define MTU_MC18_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006227Cu)

/** \brief 127E, Read Data and Bit Flip Register 15 */
#define MTU_MC18_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006227Eu)

/** \brief 1280, Read Data and Bit Flip Register 16 */
#define MTU_MC18_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062280u)

/** \brief 1282, Read Data and Bit Flip Register 17 */
#define MTU_MC18_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062282u)

/** \brief 1284, Read Data and Bit Flip Register 18 */
#define MTU_MC18_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062284u)

/** \brief 1286, Read Data and Bit Flip Register 19 */
#define MTU_MC18_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062286u)

/** \brief 1288, Read Data and Bit Flip Register 20 */
#define MTU_MC18_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062288u)

/** \brief 128A, Read Data and Bit Flip Register 21 */
#define MTU_MC18_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006228Au)

/** \brief 128C, Read Data and Bit Flip Register 22 */
#define MTU_MC18_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006228Cu)

/** \brief 128E, Read Data and Bit Flip Register 23 */
#define MTU_MC18_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006228Eu)

/** \brief 1290, Read Data and Bit Flip Register 24 */
#define MTU_MC18_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062290u)

/** \brief 1292, Read Data and Bit Flip Register 25 */
#define MTU_MC18_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062292u)

/** \brief 1294, Read Data and Bit Flip Register 26 */
#define MTU_MC18_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062294u)

/** \brief 1296, Read Data and Bit Flip Register 27 */
#define MTU_MC18_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062296u)

/** \brief 1298, Read Data and Bit Flip Register 28 */
#define MTU_MC18_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062298u)

/** \brief 129A, Read Data and Bit Flip Register 29 */
#define MTU_MC18_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006229Au)

/** \brief 129C, Read Data and Bit Flip Register 30 */
#define MTU_MC18_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006229Cu)

/** \brief 129E, Read Data and Bit Flip Register 31 */
#define MTU_MC18_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006229Eu)

/** \brief 12A0, Read Data and Bit Flip Register 32 */
#define MTU_MC18_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622A0u)

/** \brief 12A2, Read Data and Bit Flip Register 33 */
#define MTU_MC18_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622A2u)

/** \brief 12A4, Read Data and Bit Flip Register 34 */
#define MTU_MC18_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622A4u)

/** \brief 12A6, Read Data and Bit Flip Register 35 */
#define MTU_MC18_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622A6u)

/** \brief 12A8, Read Data and Bit Flip Register 36 */
#define MTU_MC18_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622A8u)

/** \brief 12AA, Read Data and Bit Flip Register 37 */
#define MTU_MC18_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622AAu)

/** \brief 12AC, Read Data and Bit Flip Register 38 */
#define MTU_MC18_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622ACu)

/** \brief 12AE, Read Data and Bit Flip Register 39 */
#define MTU_MC18_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622AEu)

/** \brief 12B0, Read Data and Bit Flip Register 40 */
#define MTU_MC18_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622B0u)

/** \brief 12B2, Read Data and Bit Flip Register 41 */
#define MTU_MC18_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622B2u)

/** \brief 12B4, Read Data and Bit Flip Register 42 */
#define MTU_MC18_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622B4u)

/** \brief 12B6, Read Data and Bit Flip Register 43 */
#define MTU_MC18_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622B6u)

/** \brief 12B8, Read Data and Bit Flip Register 44 */
#define MTU_MC18_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622B8u)

/** \brief 12BA, Read Data and Bit Flip Register 45 */
#define MTU_MC18_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622BAu)

/** \brief 12BC, Read Data and Bit Flip Register 46 */
#define MTU_MC18_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622BCu)

/** \brief 12BE, Read Data and Bit Flip Register 47 */
#define MTU_MC18_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622BEu)

/** \brief 12C0, Read Data and Bit Flip Register 48 */
#define MTU_MC18_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622C0u)

/** \brief 12C2, Read Data and Bit Flip Register 49 */
#define MTU_MC18_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622C2u)

/** \brief 12C4, Read Data and Bit Flip Register 50 */
#define MTU_MC18_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622C4u)

/** \brief 12C6, Read Data and Bit Flip Register 51 */
#define MTU_MC18_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622C6u)

/** \brief 12C8, Read Data and Bit Flip Register 52 */
#define MTU_MC18_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622C8u)

/** \brief 12CA, Read Data and Bit Flip Register 53 */
#define MTU_MC18_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622CAu)

/** \brief 12CC, Read Data and Bit Flip Register 54 */
#define MTU_MC18_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622CCu)

/** \brief 12CE, Read Data and Bit Flip Register 55 */
#define MTU_MC18_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622CEu)

/** \brief 12D0, Read Data and Bit Flip Register 56 */
#define MTU_MC18_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622D0u)

/** \brief 12D2, Read Data and Bit Flip Register 57 */
#define MTU_MC18_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622D2u)

/** \brief 12D4, Read Data and Bit Flip Register 58 */
#define MTU_MC18_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622D4u)

/** \brief 12D6, Read Data and Bit Flip Register 59 */
#define MTU_MC18_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622D6u)

/** \brief 12D8, Read Data and Bit Flip Register 60 */
#define MTU_MC18_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622D8u)

/** \brief 12DA, Read Data and Bit Flip Register 61 */
#define MTU_MC18_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622DAu)

/** \brief 12DC, Read Data and Bit Flip Register 62 */
#define MTU_MC18_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622DCu)

/** \brief 12DE, Read Data and Bit Flip Register 63 */
#define MTU_MC18_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622DEu)

/** \brief 12E0, Read Data and Bit Flip Register 64 */
#define MTU_MC18_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622E0u)

/** \brief 12E2, Read Data and Bit Flip Register 65 */
#define MTU_MC18_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622E2u)

/** \brief 12E4, Read Data and Bit Flip Register 66 */
#define MTU_MC18_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00622E4u)

/** \brief 12EE, Alarm Sources Configuration Register */
#define MTU_MC18_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00622EEu)

/** \brief 12F0, SSH Safety Faults Status Register  */
#define MTU_MC18_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00622F0u)

/** \brief 12F2, Error Information Register 0 */
#define MTU_MC18_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00622F2u)

/** \brief 12F4, Error Information Register 1 */
#define MTU_MC18_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00622F4u)

/** \brief 12F6, Error Information Register 2 */
#define MTU_MC18_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00622F6u)

/** \brief 12F8, Error Information Register 3 */
#define MTU_MC18_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00622F8u)

/** \brief 12FA, Error Information Register 4 */
#define MTU_MC18_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00622FAu)

/** \brief 1300, Configuration Registers */
#define MTU_MC19_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062300u)

/** \brief 1302, Configuration Register 1 */
#define MTU_MC19_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062302u)

/** \brief 1304, MBIST Control Register */
#define MTU_MC19_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062304u)

/** \brief 1306, Status Register */
#define MTU_MC19_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062306u)

/** \brief 1308, Range Register, single address mode */
#define MTU_MC19_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062308u)

/** \brief 130C, Revision ID Register */
#define MTU_MC19_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006230Cu)

/** \brief 130E, ECC Safety Register */
#define MTU_MC19_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006230Eu)

/** \brief 1310, Memory ECC Detection Register */
#define MTU_MC19_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062310u)

/** \brief 1312, Error Tracking Register 0 */
#define MTU_MC19_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062312u)

/** \brief 1314, Error Tracking Register 1 */
#define MTU_MC19_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062314u)

/** \brief 1316, Error Tracking Register 2 */
#define MTU_MC19_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062316u)

/** \brief 1318, Error Tracking Register 3 */
#define MTU_MC19_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062318u)

/** \brief 131A, Error Tracking Register 4 */
#define MTU_MC19_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006231Au)

/** \brief 1360, Read Data and Bit Flip Register 0 */
#define MTU_MC19_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062360u)

/** \brief 1362, Read Data and Bit Flip Register 1 */
#define MTU_MC19_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062362u)

/** \brief 1364, Read Data and Bit Flip Register 2 */
#define MTU_MC19_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062364u)

/** \brief 1366, Read Data and Bit Flip Register 3 */
#define MTU_MC19_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062366u)

/** \brief 1368, Read Data and Bit Flip Register 4 */
#define MTU_MC19_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062368u)

/** \brief 136A, Read Data and Bit Flip Register 5 */
#define MTU_MC19_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006236Au)

/** \brief 136C, Read Data and Bit Flip Register 6 */
#define MTU_MC19_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006236Cu)

/** \brief 136E, Read Data and Bit Flip Register 7 */
#define MTU_MC19_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006236Eu)

/** \brief 1370, Read Data and Bit Flip Register 8 */
#define MTU_MC19_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062370u)

/** \brief 1372, Read Data and Bit Flip Register 9 */
#define MTU_MC19_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062372u)

/** \brief 1374, Read Data and Bit Flip Register 10 */
#define MTU_MC19_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062374u)

/** \brief 1376, Read Data and Bit Flip Register 11 */
#define MTU_MC19_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062376u)

/** \brief 1378, Read Data and Bit Flip Register 12 */
#define MTU_MC19_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062378u)

/** \brief 137A, Read Data and Bit Flip Register 13 */
#define MTU_MC19_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006237Au)

/** \brief 137C, Read Data and Bit Flip Register 14 */
#define MTU_MC19_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006237Cu)

/** \brief 137E, Read Data and Bit Flip Register 15 */
#define MTU_MC19_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006237Eu)

/** \brief 1380, Read Data and Bit Flip Register 16 */
#define MTU_MC19_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062380u)

/** \brief 1382, Read Data and Bit Flip Register 17 */
#define MTU_MC19_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062382u)

/** \brief 1384, Read Data and Bit Flip Register 18 */
#define MTU_MC19_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062384u)

/** \brief 1386, Read Data and Bit Flip Register 19 */
#define MTU_MC19_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062386u)

/** \brief 1388, Read Data and Bit Flip Register 20 */
#define MTU_MC19_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062388u)

/** \brief 138A, Read Data and Bit Flip Register 21 */
#define MTU_MC19_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006238Au)

/** \brief 138C, Read Data and Bit Flip Register 22 */
#define MTU_MC19_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006238Cu)

/** \brief 138E, Read Data and Bit Flip Register 23 */
#define MTU_MC19_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006238Eu)

/** \brief 1390, Read Data and Bit Flip Register 24 */
#define MTU_MC19_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062390u)

/** \brief 1392, Read Data and Bit Flip Register 25 */
#define MTU_MC19_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062392u)

/** \brief 1394, Read Data and Bit Flip Register 26 */
#define MTU_MC19_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062394u)

/** \brief 1396, Read Data and Bit Flip Register 27 */
#define MTU_MC19_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062396u)

/** \brief 1398, Read Data and Bit Flip Register 28 */
#define MTU_MC19_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062398u)

/** \brief 139A, Read Data and Bit Flip Register 29 */
#define MTU_MC19_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006239Au)

/** \brief 139C, Read Data and Bit Flip Register 30 */
#define MTU_MC19_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006239Cu)

/** \brief 139E, Read Data and Bit Flip Register 31 */
#define MTU_MC19_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006239Eu)

/** \brief 13A0, Read Data and Bit Flip Register 32 */
#define MTU_MC19_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623A0u)

/** \brief 13A2, Read Data and Bit Flip Register 33 */
#define MTU_MC19_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623A2u)

/** \brief 13A4, Read Data and Bit Flip Register 34 */
#define MTU_MC19_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623A4u)

/** \brief 13A6, Read Data and Bit Flip Register 35 */
#define MTU_MC19_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623A6u)

/** \brief 13A8, Read Data and Bit Flip Register 36 */
#define MTU_MC19_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623A8u)

/** \brief 13AA, Read Data and Bit Flip Register 37 */
#define MTU_MC19_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623AAu)

/** \brief 13AC, Read Data and Bit Flip Register 38 */
#define MTU_MC19_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623ACu)

/** \brief 13AE, Read Data and Bit Flip Register 39 */
#define MTU_MC19_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623AEu)

/** \brief 13B0, Read Data and Bit Flip Register 40 */
#define MTU_MC19_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623B0u)

/** \brief 13B2, Read Data and Bit Flip Register 41 */
#define MTU_MC19_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623B2u)

/** \brief 13B4, Read Data and Bit Flip Register 42 */
#define MTU_MC19_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623B4u)

/** \brief 13B6, Read Data and Bit Flip Register 43 */
#define MTU_MC19_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623B6u)

/** \brief 13B8, Read Data and Bit Flip Register 44 */
#define MTU_MC19_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623B8u)

/** \brief 13BA, Read Data and Bit Flip Register 45 */
#define MTU_MC19_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623BAu)

/** \brief 13BC, Read Data and Bit Flip Register 46 */
#define MTU_MC19_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623BCu)

/** \brief 13BE, Read Data and Bit Flip Register 47 */
#define MTU_MC19_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623BEu)

/** \brief 13C0, Read Data and Bit Flip Register 48 */
#define MTU_MC19_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623C0u)

/** \brief 13C2, Read Data and Bit Flip Register 49 */
#define MTU_MC19_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623C2u)

/** \brief 13C4, Read Data and Bit Flip Register 50 */
#define MTU_MC19_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623C4u)

/** \brief 13C6, Read Data and Bit Flip Register 51 */
#define MTU_MC19_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623C6u)

/** \brief 13C8, Read Data and Bit Flip Register 52 */
#define MTU_MC19_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623C8u)

/** \brief 13CA, Read Data and Bit Flip Register 53 */
#define MTU_MC19_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623CAu)

/** \brief 13CC, Read Data and Bit Flip Register 54 */
#define MTU_MC19_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623CCu)

/** \brief 13CE, Read Data and Bit Flip Register 55 */
#define MTU_MC19_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623CEu)

/** \brief 13D0, Read Data and Bit Flip Register 56 */
#define MTU_MC19_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623D0u)

/** \brief 13D2, Read Data and Bit Flip Register 57 */
#define MTU_MC19_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623D2u)

/** \brief 13D4, Read Data and Bit Flip Register 58 */
#define MTU_MC19_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623D4u)

/** \brief 13D6, Read Data and Bit Flip Register 59 */
#define MTU_MC19_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623D6u)

/** \brief 13D8, Read Data and Bit Flip Register 60 */
#define MTU_MC19_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623D8u)

/** \brief 13DA, Read Data and Bit Flip Register 61 */
#define MTU_MC19_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623DAu)

/** \brief 13DC, Read Data and Bit Flip Register 62 */
#define MTU_MC19_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623DCu)

/** \brief 13DE, Read Data and Bit Flip Register 63 */
#define MTU_MC19_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623DEu)

/** \brief 13E0, Read Data and Bit Flip Register 64 */
#define MTU_MC19_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623E0u)

/** \brief 13E2, Read Data and Bit Flip Register 65 */
#define MTU_MC19_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623E2u)

/** \brief 13E4, Read Data and Bit Flip Register 66 */
#define MTU_MC19_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00623E4u)

/** \brief 13EE, Alarm Sources Configuration Register */
#define MTU_MC19_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00623EEu)

/** \brief 13F0, SSH Safety Faults Status Register  */
#define MTU_MC19_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00623F0u)

/** \brief 13F2, Error Information Register 0 */
#define MTU_MC19_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00623F2u)

/** \brief 13F4, Error Information Register 1 */
#define MTU_MC19_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00623F4u)

/** \brief 13F6, Error Information Register 2 */
#define MTU_MC19_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00623F6u)

/** \brief 13F8, Error Information Register 3 */
#define MTU_MC19_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00623F8u)

/** \brief 13FA, Error Information Register 4 */
#define MTU_MC19_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00623FAu)

/** \brief 1400, Configuration Registers */
#define MTU_MC20_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062400u)

/** \brief 1402, Configuration Register 1 */
#define MTU_MC20_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062402u)

/** \brief 1404, MBIST Control Register */
#define MTU_MC20_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062404u)

/** \brief 1406, Status Register */
#define MTU_MC20_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062406u)

/** \brief 1408, Range Register, single address mode */
#define MTU_MC20_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062408u)

/** \brief 140C, Revision ID Register */
#define MTU_MC20_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006240Cu)

/** \brief 140E, ECC Safety Register */
#define MTU_MC20_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006240Eu)

/** \brief 1410, Memory ECC Detection Register */
#define MTU_MC20_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062410u)

/** \brief 1412, Error Tracking Register 0 */
#define MTU_MC20_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062412u)

/** \brief 1414, Error Tracking Register 1 */
#define MTU_MC20_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062414u)

/** \brief 1416, Error Tracking Register 2 */
#define MTU_MC20_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062416u)

/** \brief 1418, Error Tracking Register 3 */
#define MTU_MC20_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062418u)

/** \brief 141A, Error Tracking Register 4 */
#define MTU_MC20_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006241Au)

/** \brief 1460, Read Data and Bit Flip Register 0 */
#define MTU_MC20_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062460u)

/** \brief 1462, Read Data and Bit Flip Register 1 */
#define MTU_MC20_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062462u)

/** \brief 1464, Read Data and Bit Flip Register 2 */
#define MTU_MC20_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062464u)

/** \brief 1466, Read Data and Bit Flip Register 3 */
#define MTU_MC20_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062466u)

/** \brief 1468, Read Data and Bit Flip Register 4 */
#define MTU_MC20_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062468u)

/** \brief 146A, Read Data and Bit Flip Register 5 */
#define MTU_MC20_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006246Au)

/** \brief 146C, Read Data and Bit Flip Register 6 */
#define MTU_MC20_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006246Cu)

/** \brief 146E, Read Data and Bit Flip Register 7 */
#define MTU_MC20_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006246Eu)

/** \brief 1470, Read Data and Bit Flip Register 8 */
#define MTU_MC20_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062470u)

/** \brief 1472, Read Data and Bit Flip Register 9 */
#define MTU_MC20_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062472u)

/** \brief 1474, Read Data and Bit Flip Register 10 */
#define MTU_MC20_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062474u)

/** \brief 1476, Read Data and Bit Flip Register 11 */
#define MTU_MC20_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062476u)

/** \brief 1478, Read Data and Bit Flip Register 12 */
#define MTU_MC20_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062478u)

/** \brief 147A, Read Data and Bit Flip Register 13 */
#define MTU_MC20_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006247Au)

/** \brief 147C, Read Data and Bit Flip Register 14 */
#define MTU_MC20_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006247Cu)

/** \brief 147E, Read Data and Bit Flip Register 15 */
#define MTU_MC20_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006247Eu)

/** \brief 1480, Read Data and Bit Flip Register 16 */
#define MTU_MC20_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062480u)

/** \brief 1482, Read Data and Bit Flip Register 17 */
#define MTU_MC20_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062482u)

/** \brief 1484, Read Data and Bit Flip Register 18 */
#define MTU_MC20_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062484u)

/** \brief 1486, Read Data and Bit Flip Register 19 */
#define MTU_MC20_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062486u)

/** \brief 1488, Read Data and Bit Flip Register 20 */
#define MTU_MC20_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062488u)

/** \brief 148A, Read Data and Bit Flip Register 21 */
#define MTU_MC20_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006248Au)

/** \brief 148C, Read Data and Bit Flip Register 22 */
#define MTU_MC20_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006248Cu)

/** \brief 148E, Read Data and Bit Flip Register 23 */
#define MTU_MC20_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006248Eu)

/** \brief 1490, Read Data and Bit Flip Register 24 */
#define MTU_MC20_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062490u)

/** \brief 1492, Read Data and Bit Flip Register 25 */
#define MTU_MC20_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062492u)

/** \brief 1494, Read Data and Bit Flip Register 26 */
#define MTU_MC20_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062494u)

/** \brief 1496, Read Data and Bit Flip Register 27 */
#define MTU_MC20_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062496u)

/** \brief 1498, Read Data and Bit Flip Register 28 */
#define MTU_MC20_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062498u)

/** \brief 149A, Read Data and Bit Flip Register 29 */
#define MTU_MC20_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006249Au)

/** \brief 149C, Read Data and Bit Flip Register 30 */
#define MTU_MC20_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006249Cu)

/** \brief 149E, Read Data and Bit Flip Register 31 */
#define MTU_MC20_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006249Eu)

/** \brief 14A0, Read Data and Bit Flip Register 32 */
#define MTU_MC20_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624A0u)

/** \brief 14A2, Read Data and Bit Flip Register 33 */
#define MTU_MC20_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624A2u)

/** \brief 14A4, Read Data and Bit Flip Register 34 */
#define MTU_MC20_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624A4u)

/** \brief 14A6, Read Data and Bit Flip Register 35 */
#define MTU_MC20_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624A6u)

/** \brief 14A8, Read Data and Bit Flip Register 36 */
#define MTU_MC20_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624A8u)

/** \brief 14AA, Read Data and Bit Flip Register 37 */
#define MTU_MC20_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624AAu)

/** \brief 14AC, Read Data and Bit Flip Register 38 */
#define MTU_MC20_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624ACu)

/** \brief 14AE, Read Data and Bit Flip Register 39 */
#define MTU_MC20_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624AEu)

/** \brief 14B0, Read Data and Bit Flip Register 40 */
#define MTU_MC20_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624B0u)

/** \brief 14B2, Read Data and Bit Flip Register 41 */
#define MTU_MC20_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624B2u)

/** \brief 14B4, Read Data and Bit Flip Register 42 */
#define MTU_MC20_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624B4u)

/** \brief 14B6, Read Data and Bit Flip Register 43 */
#define MTU_MC20_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624B6u)

/** \brief 14B8, Read Data and Bit Flip Register 44 */
#define MTU_MC20_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624B8u)

/** \brief 14BA, Read Data and Bit Flip Register 45 */
#define MTU_MC20_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624BAu)

/** \brief 14BC, Read Data and Bit Flip Register 46 */
#define MTU_MC20_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624BCu)

/** \brief 14BE, Read Data and Bit Flip Register 47 */
#define MTU_MC20_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624BEu)

/** \brief 14C0, Read Data and Bit Flip Register 48 */
#define MTU_MC20_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624C0u)

/** \brief 14C2, Read Data and Bit Flip Register 49 */
#define MTU_MC20_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624C2u)

/** \brief 14C4, Read Data and Bit Flip Register 50 */
#define MTU_MC20_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624C4u)

/** \brief 14C6, Read Data and Bit Flip Register 51 */
#define MTU_MC20_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624C6u)

/** \brief 14C8, Read Data and Bit Flip Register 52 */
#define MTU_MC20_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624C8u)

/** \brief 14CA, Read Data and Bit Flip Register 53 */
#define MTU_MC20_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624CAu)

/** \brief 14CC, Read Data and Bit Flip Register 54 */
#define MTU_MC20_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624CCu)

/** \brief 14CE, Read Data and Bit Flip Register 55 */
#define MTU_MC20_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624CEu)

/** \brief 14D0, Read Data and Bit Flip Register 56 */
#define MTU_MC20_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624D0u)

/** \brief 14D2, Read Data and Bit Flip Register 57 */
#define MTU_MC20_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624D2u)

/** \brief 14D4, Read Data and Bit Flip Register 58 */
#define MTU_MC20_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624D4u)

/** \brief 14D6, Read Data and Bit Flip Register 59 */
#define MTU_MC20_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624D6u)

/** \brief 14D8, Read Data and Bit Flip Register 60 */
#define MTU_MC20_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624D8u)

/** \brief 14DA, Read Data and Bit Flip Register 61 */
#define MTU_MC20_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624DAu)

/** \brief 14DC, Read Data and Bit Flip Register 62 */
#define MTU_MC20_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624DCu)

/** \brief 14DE, Read Data and Bit Flip Register 63 */
#define MTU_MC20_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624DEu)

/** \brief 14E0, Read Data and Bit Flip Register 64 */
#define MTU_MC20_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624E0u)

/** \brief 14E2, Read Data and Bit Flip Register 65 */
#define MTU_MC20_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624E2u)

/** \brief 14E4, Read Data and Bit Flip Register 66 */
#define MTU_MC20_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00624E4u)

/** \brief 14EE, Alarm Sources Configuration Register */
#define MTU_MC20_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00624EEu)

/** \brief 14F0, SSH Safety Faults Status Register  */
#define MTU_MC20_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00624F0u)

/** \brief 14F2, Error Information Register 0 */
#define MTU_MC20_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00624F2u)

/** \brief 14F4, Error Information Register 1 */
#define MTU_MC20_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00624F4u)

/** \brief 14F6, Error Information Register 2 */
#define MTU_MC20_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00624F6u)

/** \brief 14F8, Error Information Register 3 */
#define MTU_MC20_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00624F8u)

/** \brief 14FA, Error Information Register 4 */
#define MTU_MC20_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00624FAu)

/** \brief 1500, Configuration Registers */
#define MTU_MC21_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062500u)

/** \brief 1502, Configuration Register 1 */
#define MTU_MC21_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062502u)

/** \brief 1504, MBIST Control Register */
#define MTU_MC21_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062504u)

/** \brief 1506, Status Register */
#define MTU_MC21_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062506u)

/** \brief 1508, Range Register, single address mode */
#define MTU_MC21_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062508u)

/** \brief 150C, Revision ID Register */
#define MTU_MC21_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006250Cu)

/** \brief 150E, ECC Safety Register */
#define MTU_MC21_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006250Eu)

/** \brief 1510, Memory ECC Detection Register */
#define MTU_MC21_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062510u)

/** \brief 1512, Error Tracking Register 0 */
#define MTU_MC21_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062512u)

/** \brief 1514, Error Tracking Register 1 */
#define MTU_MC21_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062514u)

/** \brief 1516, Error Tracking Register 2 */
#define MTU_MC21_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062516u)

/** \brief 1518, Error Tracking Register 3 */
#define MTU_MC21_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062518u)

/** \brief 151A, Error Tracking Register 4 */
#define MTU_MC21_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006251Au)

/** \brief 1560, Read Data and Bit Flip Register 0 */
#define MTU_MC21_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062560u)

/** \brief 1562, Read Data and Bit Flip Register 1 */
#define MTU_MC21_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062562u)

/** \brief 1564, Read Data and Bit Flip Register 2 */
#define MTU_MC21_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062564u)

/** \brief 1566, Read Data and Bit Flip Register 3 */
#define MTU_MC21_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062566u)

/** \brief 1568, Read Data and Bit Flip Register 4 */
#define MTU_MC21_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062568u)

/** \brief 156A, Read Data and Bit Flip Register 5 */
#define MTU_MC21_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006256Au)

/** \brief 156C, Read Data and Bit Flip Register 6 */
#define MTU_MC21_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006256Cu)

/** \brief 156E, Read Data and Bit Flip Register 7 */
#define MTU_MC21_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006256Eu)

/** \brief 1570, Read Data and Bit Flip Register 8 */
#define MTU_MC21_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062570u)

/** \brief 1572, Read Data and Bit Flip Register 9 */
#define MTU_MC21_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062572u)

/** \brief 1574, Read Data and Bit Flip Register 10 */
#define MTU_MC21_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062574u)

/** \brief 1576, Read Data and Bit Flip Register 11 */
#define MTU_MC21_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062576u)

/** \brief 1578, Read Data and Bit Flip Register 12 */
#define MTU_MC21_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062578u)

/** \brief 157A, Read Data and Bit Flip Register 13 */
#define MTU_MC21_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006257Au)

/** \brief 157C, Read Data and Bit Flip Register 14 */
#define MTU_MC21_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006257Cu)

/** \brief 157E, Read Data and Bit Flip Register 15 */
#define MTU_MC21_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006257Eu)

/** \brief 1580, Read Data and Bit Flip Register 16 */
#define MTU_MC21_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062580u)

/** \brief 1582, Read Data and Bit Flip Register 17 */
#define MTU_MC21_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062582u)

/** \brief 1584, Read Data and Bit Flip Register 18 */
#define MTU_MC21_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062584u)

/** \brief 1586, Read Data and Bit Flip Register 19 */
#define MTU_MC21_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062586u)

/** \brief 1588, Read Data and Bit Flip Register 20 */
#define MTU_MC21_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062588u)

/** \brief 158A, Read Data and Bit Flip Register 21 */
#define MTU_MC21_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006258Au)

/** \brief 158C, Read Data and Bit Flip Register 22 */
#define MTU_MC21_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006258Cu)

/** \brief 158E, Read Data and Bit Flip Register 23 */
#define MTU_MC21_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006258Eu)

/** \brief 1590, Read Data and Bit Flip Register 24 */
#define MTU_MC21_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062590u)

/** \brief 1592, Read Data and Bit Flip Register 25 */
#define MTU_MC21_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062592u)

/** \brief 1594, Read Data and Bit Flip Register 26 */
#define MTU_MC21_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062594u)

/** \brief 1596, Read Data and Bit Flip Register 27 */
#define MTU_MC21_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062596u)

/** \brief 1598, Read Data and Bit Flip Register 28 */
#define MTU_MC21_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062598u)

/** \brief 159A, Read Data and Bit Flip Register 29 */
#define MTU_MC21_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006259Au)

/** \brief 159C, Read Data and Bit Flip Register 30 */
#define MTU_MC21_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006259Cu)

/** \brief 159E, Read Data and Bit Flip Register 31 */
#define MTU_MC21_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006259Eu)

/** \brief 15A0, Read Data and Bit Flip Register 32 */
#define MTU_MC21_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625A0u)

/** \brief 15A2, Read Data and Bit Flip Register 33 */
#define MTU_MC21_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625A2u)

/** \brief 15A4, Read Data and Bit Flip Register 34 */
#define MTU_MC21_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625A4u)

/** \brief 15A6, Read Data and Bit Flip Register 35 */
#define MTU_MC21_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625A6u)

/** \brief 15A8, Read Data and Bit Flip Register 36 */
#define MTU_MC21_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625A8u)

/** \brief 15AA, Read Data and Bit Flip Register 37 */
#define MTU_MC21_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625AAu)

/** \brief 15AC, Read Data and Bit Flip Register 38 */
#define MTU_MC21_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625ACu)

/** \brief 15AE, Read Data and Bit Flip Register 39 */
#define MTU_MC21_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625AEu)

/** \brief 15B0, Read Data and Bit Flip Register 40 */
#define MTU_MC21_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625B0u)

/** \brief 15B2, Read Data and Bit Flip Register 41 */
#define MTU_MC21_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625B2u)

/** \brief 15B4, Read Data and Bit Flip Register 42 */
#define MTU_MC21_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625B4u)

/** \brief 15B6, Read Data and Bit Flip Register 43 */
#define MTU_MC21_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625B6u)

/** \brief 15B8, Read Data and Bit Flip Register 44 */
#define MTU_MC21_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625B8u)

/** \brief 15BA, Read Data and Bit Flip Register 45 */
#define MTU_MC21_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625BAu)

/** \brief 15BC, Read Data and Bit Flip Register 46 */
#define MTU_MC21_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625BCu)

/** \brief 15BE, Read Data and Bit Flip Register 47 */
#define MTU_MC21_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625BEu)

/** \brief 15C0, Read Data and Bit Flip Register 48 */
#define MTU_MC21_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625C0u)

/** \brief 15C2, Read Data and Bit Flip Register 49 */
#define MTU_MC21_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625C2u)

/** \brief 15C4, Read Data and Bit Flip Register 50 */
#define MTU_MC21_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625C4u)

/** \brief 15C6, Read Data and Bit Flip Register 51 */
#define MTU_MC21_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625C6u)

/** \brief 15C8, Read Data and Bit Flip Register 52 */
#define MTU_MC21_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625C8u)

/** \brief 15CA, Read Data and Bit Flip Register 53 */
#define MTU_MC21_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625CAu)

/** \brief 15CC, Read Data and Bit Flip Register 54 */
#define MTU_MC21_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625CCu)

/** \brief 15CE, Read Data and Bit Flip Register 55 */
#define MTU_MC21_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625CEu)

/** \brief 15D0, Read Data and Bit Flip Register 56 */
#define MTU_MC21_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625D0u)

/** \brief 15D2, Read Data and Bit Flip Register 57 */
#define MTU_MC21_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625D2u)

/** \brief 15D4, Read Data and Bit Flip Register 58 */
#define MTU_MC21_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625D4u)

/** \brief 15D6, Read Data and Bit Flip Register 59 */
#define MTU_MC21_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625D6u)

/** \brief 15D8, Read Data and Bit Flip Register 60 */
#define MTU_MC21_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625D8u)

/** \brief 15DA, Read Data and Bit Flip Register 61 */
#define MTU_MC21_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625DAu)

/** \brief 15DC, Read Data and Bit Flip Register 62 */
#define MTU_MC21_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625DCu)

/** \brief 15DE, Read Data and Bit Flip Register 63 */
#define MTU_MC21_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625DEu)

/** \brief 15E0, Read Data and Bit Flip Register 64 */
#define MTU_MC21_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625E0u)

/** \brief 15E2, Read Data and Bit Flip Register 65 */
#define MTU_MC21_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625E2u)

/** \brief 15E4, Read Data and Bit Flip Register 66 */
#define MTU_MC21_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00625E4u)

/** \brief 15EE, Alarm Sources Configuration Register */
#define MTU_MC21_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00625EEu)

/** \brief 15F0, SSH Safety Faults Status Register  */
#define MTU_MC21_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00625F0u)

/** \brief 15F2, Error Information Register 0 */
#define MTU_MC21_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00625F2u)

/** \brief 15F4, Error Information Register 1 */
#define MTU_MC21_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00625F4u)

/** \brief 15F6, Error Information Register 2 */
#define MTU_MC21_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00625F6u)

/** \brief 15F8, Error Information Register 3 */
#define MTU_MC21_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00625F8u)

/** \brief 15FA, Error Information Register 4 */
#define MTU_MC21_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00625FAu)

/** \brief 1600, Configuration Registers */
#define MTU_MC22_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062600u)

/** \brief 1602, Configuration Register 1 */
#define MTU_MC22_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062602u)

/** \brief 1604, MBIST Control Register */
#define MTU_MC22_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062604u)

/** \brief 1606, Status Register */
#define MTU_MC22_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062606u)

/** \brief 1608, Range Register, single address mode */
#define MTU_MC22_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062608u)

/** \brief 160C, Revision ID Register */
#define MTU_MC22_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006260Cu)

/** \brief 160E, ECC Safety Register */
#define MTU_MC22_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006260Eu)

/** \brief 1610, Memory ECC Detection Register */
#define MTU_MC22_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062610u)

/** \brief 1612, Error Tracking Register 0 */
#define MTU_MC22_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062612u)

/** \brief 1614, Error Tracking Register 1 */
#define MTU_MC22_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062614u)

/** \brief 1616, Error Tracking Register 2 */
#define MTU_MC22_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062616u)

/** \brief 1618, Error Tracking Register 3 */
#define MTU_MC22_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062618u)

/** \brief 161A, Error Tracking Register 4 */
#define MTU_MC22_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006261Au)

/** \brief 1660, Read Data and Bit Flip Register 0 */
#define MTU_MC22_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062660u)

/** \brief 1662, Read Data and Bit Flip Register 1 */
#define MTU_MC22_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062662u)

/** \brief 1664, Read Data and Bit Flip Register 2 */
#define MTU_MC22_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062664u)

/** \brief 1666, Read Data and Bit Flip Register 3 */
#define MTU_MC22_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062666u)

/** \brief 1668, Read Data and Bit Flip Register 4 */
#define MTU_MC22_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062668u)

/** \brief 166A, Read Data and Bit Flip Register 5 */
#define MTU_MC22_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006266Au)

/** \brief 166C, Read Data and Bit Flip Register 6 */
#define MTU_MC22_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006266Cu)

/** \brief 166E, Read Data and Bit Flip Register 7 */
#define MTU_MC22_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006266Eu)

/** \brief 1670, Read Data and Bit Flip Register 8 */
#define MTU_MC22_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062670u)

/** \brief 1672, Read Data and Bit Flip Register 9 */
#define MTU_MC22_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062672u)

/** \brief 1674, Read Data and Bit Flip Register 10 */
#define MTU_MC22_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062674u)

/** \brief 1676, Read Data and Bit Flip Register 11 */
#define MTU_MC22_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062676u)

/** \brief 1678, Read Data and Bit Flip Register 12 */
#define MTU_MC22_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062678u)

/** \brief 167A, Read Data and Bit Flip Register 13 */
#define MTU_MC22_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006267Au)

/** \brief 167C, Read Data and Bit Flip Register 14 */
#define MTU_MC22_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006267Cu)

/** \brief 167E, Read Data and Bit Flip Register 15 */
#define MTU_MC22_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006267Eu)

/** \brief 1680, Read Data and Bit Flip Register 16 */
#define MTU_MC22_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062680u)

/** \brief 1682, Read Data and Bit Flip Register 17 */
#define MTU_MC22_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062682u)

/** \brief 1684, Read Data and Bit Flip Register 18 */
#define MTU_MC22_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062684u)

/** \brief 1686, Read Data and Bit Flip Register 19 */
#define MTU_MC22_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062686u)

/** \brief 1688, Read Data and Bit Flip Register 20 */
#define MTU_MC22_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062688u)

/** \brief 168A, Read Data and Bit Flip Register 21 */
#define MTU_MC22_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006268Au)

/** \brief 168C, Read Data and Bit Flip Register 22 */
#define MTU_MC22_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006268Cu)

/** \brief 168E, Read Data and Bit Flip Register 23 */
#define MTU_MC22_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006268Eu)

/** \brief 1690, Read Data and Bit Flip Register 24 */
#define MTU_MC22_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062690u)

/** \brief 1692, Read Data and Bit Flip Register 25 */
#define MTU_MC22_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062692u)

/** \brief 1694, Read Data and Bit Flip Register 26 */
#define MTU_MC22_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062694u)

/** \brief 1696, Read Data and Bit Flip Register 27 */
#define MTU_MC22_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062696u)

/** \brief 1698, Read Data and Bit Flip Register 28 */
#define MTU_MC22_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062698u)

/** \brief 169A, Read Data and Bit Flip Register 29 */
#define MTU_MC22_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006269Au)

/** \brief 169C, Read Data and Bit Flip Register 30 */
#define MTU_MC22_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006269Cu)

/** \brief 169E, Read Data and Bit Flip Register 31 */
#define MTU_MC22_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006269Eu)

/** \brief 16A0, Read Data and Bit Flip Register 32 */
#define MTU_MC22_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626A0u)

/** \brief 16A2, Read Data and Bit Flip Register 33 */
#define MTU_MC22_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626A2u)

/** \brief 16A4, Read Data and Bit Flip Register 34 */
#define MTU_MC22_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626A4u)

/** \brief 16A6, Read Data and Bit Flip Register 35 */
#define MTU_MC22_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626A6u)

/** \brief 16A8, Read Data and Bit Flip Register 36 */
#define MTU_MC22_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626A8u)

/** \brief 16AA, Read Data and Bit Flip Register 37 */
#define MTU_MC22_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626AAu)

/** \brief 16AC, Read Data and Bit Flip Register 38 */
#define MTU_MC22_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626ACu)

/** \brief 16AE, Read Data and Bit Flip Register 39 */
#define MTU_MC22_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626AEu)

/** \brief 16B0, Read Data and Bit Flip Register 40 */
#define MTU_MC22_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626B0u)

/** \brief 16B2, Read Data and Bit Flip Register 41 */
#define MTU_MC22_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626B2u)

/** \brief 16B4, Read Data and Bit Flip Register 42 */
#define MTU_MC22_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626B4u)

/** \brief 16B6, Read Data and Bit Flip Register 43 */
#define MTU_MC22_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626B6u)

/** \brief 16B8, Read Data and Bit Flip Register 44 */
#define MTU_MC22_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626B8u)

/** \brief 16BA, Read Data and Bit Flip Register 45 */
#define MTU_MC22_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626BAu)

/** \brief 16BC, Read Data and Bit Flip Register 46 */
#define MTU_MC22_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626BCu)

/** \brief 16BE, Read Data and Bit Flip Register 47 */
#define MTU_MC22_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626BEu)

/** \brief 16C0, Read Data and Bit Flip Register 48 */
#define MTU_MC22_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626C0u)

/** \brief 16C2, Read Data and Bit Flip Register 49 */
#define MTU_MC22_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626C2u)

/** \brief 16C4, Read Data and Bit Flip Register 50 */
#define MTU_MC22_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626C4u)

/** \brief 16C6, Read Data and Bit Flip Register 51 */
#define MTU_MC22_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626C6u)

/** \brief 16C8, Read Data and Bit Flip Register 52 */
#define MTU_MC22_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626C8u)

/** \brief 16CA, Read Data and Bit Flip Register 53 */
#define MTU_MC22_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626CAu)

/** \brief 16CC, Read Data and Bit Flip Register 54 */
#define MTU_MC22_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626CCu)

/** \brief 16CE, Read Data and Bit Flip Register 55 */
#define MTU_MC22_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626CEu)

/** \brief 16D0, Read Data and Bit Flip Register 56 */
#define MTU_MC22_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626D0u)

/** \brief 16D2, Read Data and Bit Flip Register 57 */
#define MTU_MC22_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626D2u)

/** \brief 16D4, Read Data and Bit Flip Register 58 */
#define MTU_MC22_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626D4u)

/** \brief 16D6, Read Data and Bit Flip Register 59 */
#define MTU_MC22_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626D6u)

/** \brief 16D8, Read Data and Bit Flip Register 60 */
#define MTU_MC22_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626D8u)

/** \brief 16DA, Read Data and Bit Flip Register 61 */
#define MTU_MC22_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626DAu)

/** \brief 16DC, Read Data and Bit Flip Register 62 */
#define MTU_MC22_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626DCu)

/** \brief 16DE, Read Data and Bit Flip Register 63 */
#define MTU_MC22_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626DEu)

/** \brief 16E0, Read Data and Bit Flip Register 64 */
#define MTU_MC22_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626E0u)

/** \brief 16E2, Read Data and Bit Flip Register 65 */
#define MTU_MC22_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626E2u)

/** \brief 16E4, Read Data and Bit Flip Register 66 */
#define MTU_MC22_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00626E4u)

/** \brief 16EE, Alarm Sources Configuration Register */
#define MTU_MC22_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00626EEu)

/** \brief 16F0, SSH Safety Faults Status Register  */
#define MTU_MC22_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00626F0u)

/** \brief 16F2, Error Information Register 0 */
#define MTU_MC22_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00626F2u)

/** \brief 16F4, Error Information Register 1 */
#define MTU_MC22_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00626F4u)

/** \brief 16F6, Error Information Register 2 */
#define MTU_MC22_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00626F6u)

/** \brief 16F8, Error Information Register 3 */
#define MTU_MC22_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00626F8u)

/** \brief 16FA, Error Information Register 4 */
#define MTU_MC22_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00626FAu)

/** \brief 1700, Configuration Registers */
#define MTU_MC23_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062700u)

/** \brief 1702, Configuration Register 1 */
#define MTU_MC23_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062702u)

/** \brief 1704, MBIST Control Register */
#define MTU_MC23_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062704u)

/** \brief 1706, Status Register */
#define MTU_MC23_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062706u)

/** \brief 1708, Range Register, single address mode */
#define MTU_MC23_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062708u)

/** \brief 170C, Revision ID Register */
#define MTU_MC23_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006270Cu)

/** \brief 170E, ECC Safety Register */
#define MTU_MC23_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006270Eu)

/** \brief 1710, Memory ECC Detection Register */
#define MTU_MC23_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062710u)

/** \brief 1712, Error Tracking Register 0 */
#define MTU_MC23_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062712u)

/** \brief 1714, Error Tracking Register 1 */
#define MTU_MC23_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062714u)

/** \brief 1716, Error Tracking Register 2 */
#define MTU_MC23_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062716u)

/** \brief 1718, Error Tracking Register 3 */
#define MTU_MC23_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062718u)

/** \brief 171A, Error Tracking Register 4 */
#define MTU_MC23_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006271Au)

/** \brief 1760, Read Data and Bit Flip Register 0 */
#define MTU_MC23_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062760u)

/** \brief 1762, Read Data and Bit Flip Register 1 */
#define MTU_MC23_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062762u)

/** \brief 1764, Read Data and Bit Flip Register 2 */
#define MTU_MC23_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062764u)

/** \brief 1766, Read Data and Bit Flip Register 3 */
#define MTU_MC23_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062766u)

/** \brief 1768, Read Data and Bit Flip Register 4 */
#define MTU_MC23_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062768u)

/** \brief 176A, Read Data and Bit Flip Register 5 */
#define MTU_MC23_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006276Au)

/** \brief 176C, Read Data and Bit Flip Register 6 */
#define MTU_MC23_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006276Cu)

/** \brief 176E, Read Data and Bit Flip Register 7 */
#define MTU_MC23_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006276Eu)

/** \brief 1770, Read Data and Bit Flip Register 8 */
#define MTU_MC23_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062770u)

/** \brief 1772, Read Data and Bit Flip Register 9 */
#define MTU_MC23_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062772u)

/** \brief 1774, Read Data and Bit Flip Register 10 */
#define MTU_MC23_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062774u)

/** \brief 1776, Read Data and Bit Flip Register 11 */
#define MTU_MC23_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062776u)

/** \brief 1778, Read Data and Bit Flip Register 12 */
#define MTU_MC23_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062778u)

/** \brief 177A, Read Data and Bit Flip Register 13 */
#define MTU_MC23_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006277Au)

/** \brief 177C, Read Data and Bit Flip Register 14 */
#define MTU_MC23_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006277Cu)

/** \brief 177E, Read Data and Bit Flip Register 15 */
#define MTU_MC23_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006277Eu)

/** \brief 1780, Read Data and Bit Flip Register 16 */
#define MTU_MC23_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062780u)

/** \brief 1782, Read Data and Bit Flip Register 17 */
#define MTU_MC23_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062782u)

/** \brief 1784, Read Data and Bit Flip Register 18 */
#define MTU_MC23_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062784u)

/** \brief 1786, Read Data and Bit Flip Register 19 */
#define MTU_MC23_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062786u)

/** \brief 1788, Read Data and Bit Flip Register 20 */
#define MTU_MC23_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062788u)

/** \brief 178A, Read Data and Bit Flip Register 21 */
#define MTU_MC23_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006278Au)

/** \brief 178C, Read Data and Bit Flip Register 22 */
#define MTU_MC23_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006278Cu)

/** \brief 178E, Read Data and Bit Flip Register 23 */
#define MTU_MC23_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006278Eu)

/** \brief 1790, Read Data and Bit Flip Register 24 */
#define MTU_MC23_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062790u)

/** \brief 1792, Read Data and Bit Flip Register 25 */
#define MTU_MC23_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062792u)

/** \brief 1794, Read Data and Bit Flip Register 26 */
#define MTU_MC23_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062794u)

/** \brief 1796, Read Data and Bit Flip Register 27 */
#define MTU_MC23_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062796u)

/** \brief 1798, Read Data and Bit Flip Register 28 */
#define MTU_MC23_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062798u)

/** \brief 179A, Read Data and Bit Flip Register 29 */
#define MTU_MC23_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006279Au)

/** \brief 179C, Read Data and Bit Flip Register 30 */
#define MTU_MC23_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006279Cu)

/** \brief 179E, Read Data and Bit Flip Register 31 */
#define MTU_MC23_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006279Eu)

/** \brief 17A0, Read Data and Bit Flip Register 32 */
#define MTU_MC23_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627A0u)

/** \brief 17A2, Read Data and Bit Flip Register 33 */
#define MTU_MC23_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627A2u)

/** \brief 17A4, Read Data and Bit Flip Register 34 */
#define MTU_MC23_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627A4u)

/** \brief 17A6, Read Data and Bit Flip Register 35 */
#define MTU_MC23_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627A6u)

/** \brief 17A8, Read Data and Bit Flip Register 36 */
#define MTU_MC23_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627A8u)

/** \brief 17AA, Read Data and Bit Flip Register 37 */
#define MTU_MC23_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627AAu)

/** \brief 17AC, Read Data and Bit Flip Register 38 */
#define MTU_MC23_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627ACu)

/** \brief 17AE, Read Data and Bit Flip Register 39 */
#define MTU_MC23_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627AEu)

/** \brief 17B0, Read Data and Bit Flip Register 40 */
#define MTU_MC23_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627B0u)

/** \brief 17B2, Read Data and Bit Flip Register 41 */
#define MTU_MC23_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627B2u)

/** \brief 17B4, Read Data and Bit Flip Register 42 */
#define MTU_MC23_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627B4u)

/** \brief 17B6, Read Data and Bit Flip Register 43 */
#define MTU_MC23_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627B6u)

/** \brief 17B8, Read Data and Bit Flip Register 44 */
#define MTU_MC23_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627B8u)

/** \brief 17BA, Read Data and Bit Flip Register 45 */
#define MTU_MC23_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627BAu)

/** \brief 17BC, Read Data and Bit Flip Register 46 */
#define MTU_MC23_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627BCu)

/** \brief 17BE, Read Data and Bit Flip Register 47 */
#define MTU_MC23_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627BEu)

/** \brief 17C0, Read Data and Bit Flip Register 48 */
#define MTU_MC23_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627C0u)

/** \brief 17C2, Read Data and Bit Flip Register 49 */
#define MTU_MC23_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627C2u)

/** \brief 17C4, Read Data and Bit Flip Register 50 */
#define MTU_MC23_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627C4u)

/** \brief 17C6, Read Data and Bit Flip Register 51 */
#define MTU_MC23_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627C6u)

/** \brief 17C8, Read Data and Bit Flip Register 52 */
#define MTU_MC23_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627C8u)

/** \brief 17CA, Read Data and Bit Flip Register 53 */
#define MTU_MC23_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627CAu)

/** \brief 17CC, Read Data and Bit Flip Register 54 */
#define MTU_MC23_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627CCu)

/** \brief 17CE, Read Data and Bit Flip Register 55 */
#define MTU_MC23_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627CEu)

/** \brief 17D0, Read Data and Bit Flip Register 56 */
#define MTU_MC23_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627D0u)

/** \brief 17D2, Read Data and Bit Flip Register 57 */
#define MTU_MC23_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627D2u)

/** \brief 17D4, Read Data and Bit Flip Register 58 */
#define MTU_MC23_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627D4u)

/** \brief 17D6, Read Data and Bit Flip Register 59 */
#define MTU_MC23_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627D6u)

/** \brief 17D8, Read Data and Bit Flip Register 60 */
#define MTU_MC23_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627D8u)

/** \brief 17DA, Read Data and Bit Flip Register 61 */
#define MTU_MC23_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627DAu)

/** \brief 17DC, Read Data and Bit Flip Register 62 */
#define MTU_MC23_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627DCu)

/** \brief 17DE, Read Data and Bit Flip Register 63 */
#define MTU_MC23_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627DEu)

/** \brief 17E0, Read Data and Bit Flip Register 64 */
#define MTU_MC23_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627E0u)

/** \brief 17E2, Read Data and Bit Flip Register 65 */
#define MTU_MC23_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627E2u)

/** \brief 17E4, Read Data and Bit Flip Register 66 */
#define MTU_MC23_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00627E4u)

/** \brief 17EE, Alarm Sources Configuration Register */
#define MTU_MC23_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00627EEu)

/** \brief 17F0, SSH Safety Faults Status Register  */
#define MTU_MC23_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00627F0u)

/** \brief 17F2, Error Information Register 0 */
#define MTU_MC23_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00627F2u)

/** \brief 17F4, Error Information Register 1 */
#define MTU_MC23_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00627F4u)

/** \brief 17F6, Error Information Register 2 */
#define MTU_MC23_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00627F6u)

/** \brief 17F8, Error Information Register 3 */
#define MTU_MC23_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00627F8u)

/** \brief 17FA, Error Information Register 4 */
#define MTU_MC23_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00627FAu)

/** \brief 1800, Configuration Registers */
#define MTU_MC24_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062800u)

/** \brief 1802, Configuration Register 1 */
#define MTU_MC24_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062802u)

/** \brief 1804, MBIST Control Register */
#define MTU_MC24_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062804u)

/** \brief 1806, Status Register */
#define MTU_MC24_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062806u)

/** \brief 1808, Range Register, single address mode */
#define MTU_MC24_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062808u)

/** \brief 180C, Revision ID Register */
#define MTU_MC24_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006280Cu)

/** \brief 180E, ECC Safety Register */
#define MTU_MC24_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006280Eu)

/** \brief 1810, Memory ECC Detection Register */
#define MTU_MC24_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062810u)

/** \brief 1812, Error Tracking Register 0 */
#define MTU_MC24_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062812u)

/** \brief 1814, Error Tracking Register 1 */
#define MTU_MC24_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062814u)

/** \brief 1816, Error Tracking Register 2 */
#define MTU_MC24_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062816u)

/** \brief 1818, Error Tracking Register 3 */
#define MTU_MC24_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062818u)

/** \brief 181A, Error Tracking Register 4 */
#define MTU_MC24_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006281Au)

/** \brief 1860, Read Data and Bit Flip Register 0 */
#define MTU_MC24_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062860u)

/** \brief 1862, Read Data and Bit Flip Register 1 */
#define MTU_MC24_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062862u)

/** \brief 1864, Read Data and Bit Flip Register 2 */
#define MTU_MC24_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062864u)

/** \brief 1866, Read Data and Bit Flip Register 3 */
#define MTU_MC24_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062866u)

/** \brief 1868, Read Data and Bit Flip Register 4 */
#define MTU_MC24_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062868u)

/** \brief 186A, Read Data and Bit Flip Register 5 */
#define MTU_MC24_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006286Au)

/** \brief 186C, Read Data and Bit Flip Register 6 */
#define MTU_MC24_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006286Cu)

/** \brief 186E, Read Data and Bit Flip Register 7 */
#define MTU_MC24_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006286Eu)

/** \brief 1870, Read Data and Bit Flip Register 8 */
#define MTU_MC24_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062870u)

/** \brief 1872, Read Data and Bit Flip Register 9 */
#define MTU_MC24_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062872u)

/** \brief 1874, Read Data and Bit Flip Register 10 */
#define MTU_MC24_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062874u)

/** \brief 1876, Read Data and Bit Flip Register 11 */
#define MTU_MC24_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062876u)

/** \brief 1878, Read Data and Bit Flip Register 12 */
#define MTU_MC24_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062878u)

/** \brief 187A, Read Data and Bit Flip Register 13 */
#define MTU_MC24_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006287Au)

/** \brief 187C, Read Data and Bit Flip Register 14 */
#define MTU_MC24_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006287Cu)

/** \brief 187E, Read Data and Bit Flip Register 15 */
#define MTU_MC24_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006287Eu)

/** \brief 1880, Read Data and Bit Flip Register 16 */
#define MTU_MC24_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062880u)

/** \brief 1882, Read Data and Bit Flip Register 17 */
#define MTU_MC24_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062882u)

/** \brief 1884, Read Data and Bit Flip Register 18 */
#define MTU_MC24_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062884u)

/** \brief 1886, Read Data and Bit Flip Register 19 */
#define MTU_MC24_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062886u)

/** \brief 1888, Read Data and Bit Flip Register 20 */
#define MTU_MC24_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062888u)

/** \brief 188A, Read Data and Bit Flip Register 21 */
#define MTU_MC24_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006288Au)

/** \brief 188C, Read Data and Bit Flip Register 22 */
#define MTU_MC24_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006288Cu)

/** \brief 188E, Read Data and Bit Flip Register 23 */
#define MTU_MC24_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006288Eu)

/** \brief 1890, Read Data and Bit Flip Register 24 */
#define MTU_MC24_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062890u)

/** \brief 1892, Read Data and Bit Flip Register 25 */
#define MTU_MC24_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062892u)

/** \brief 1894, Read Data and Bit Flip Register 26 */
#define MTU_MC24_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062894u)

/** \brief 1896, Read Data and Bit Flip Register 27 */
#define MTU_MC24_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062896u)

/** \brief 1898, Read Data and Bit Flip Register 28 */
#define MTU_MC24_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062898u)

/** \brief 189A, Read Data and Bit Flip Register 29 */
#define MTU_MC24_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006289Au)

/** \brief 189C, Read Data and Bit Flip Register 30 */
#define MTU_MC24_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006289Cu)

/** \brief 189E, Read Data and Bit Flip Register 31 */
#define MTU_MC24_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006289Eu)

/** \brief 18A0, Read Data and Bit Flip Register 32 */
#define MTU_MC24_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628A0u)

/** \brief 18A2, Read Data and Bit Flip Register 33 */
#define MTU_MC24_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628A2u)

/** \brief 18A4, Read Data and Bit Flip Register 34 */
#define MTU_MC24_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628A4u)

/** \brief 18A6, Read Data and Bit Flip Register 35 */
#define MTU_MC24_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628A6u)

/** \brief 18A8, Read Data and Bit Flip Register 36 */
#define MTU_MC24_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628A8u)

/** \brief 18AA, Read Data and Bit Flip Register 37 */
#define MTU_MC24_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628AAu)

/** \brief 18AC, Read Data and Bit Flip Register 38 */
#define MTU_MC24_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628ACu)

/** \brief 18AE, Read Data and Bit Flip Register 39 */
#define MTU_MC24_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628AEu)

/** \brief 18B0, Read Data and Bit Flip Register 40 */
#define MTU_MC24_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628B0u)

/** \brief 18B2, Read Data and Bit Flip Register 41 */
#define MTU_MC24_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628B2u)

/** \brief 18B4, Read Data and Bit Flip Register 42 */
#define MTU_MC24_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628B4u)

/** \brief 18B6, Read Data and Bit Flip Register 43 */
#define MTU_MC24_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628B6u)

/** \brief 18B8, Read Data and Bit Flip Register 44 */
#define MTU_MC24_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628B8u)

/** \brief 18BA, Read Data and Bit Flip Register 45 */
#define MTU_MC24_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628BAu)

/** \brief 18BC, Read Data and Bit Flip Register 46 */
#define MTU_MC24_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628BCu)

/** \brief 18BE, Read Data and Bit Flip Register 47 */
#define MTU_MC24_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628BEu)

/** \brief 18C0, Read Data and Bit Flip Register 48 */
#define MTU_MC24_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628C0u)

/** \brief 18C2, Read Data and Bit Flip Register 49 */
#define MTU_MC24_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628C2u)

/** \brief 18C4, Read Data and Bit Flip Register 50 */
#define MTU_MC24_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628C4u)

/** \brief 18C6, Read Data and Bit Flip Register 51 */
#define MTU_MC24_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628C6u)

/** \brief 18C8, Read Data and Bit Flip Register 52 */
#define MTU_MC24_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628C8u)

/** \brief 18CA, Read Data and Bit Flip Register 53 */
#define MTU_MC24_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628CAu)

/** \brief 18CC, Read Data and Bit Flip Register 54 */
#define MTU_MC24_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628CCu)

/** \brief 18CE, Read Data and Bit Flip Register 55 */
#define MTU_MC24_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628CEu)

/** \brief 18D0, Read Data and Bit Flip Register 56 */
#define MTU_MC24_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628D0u)

/** \brief 18D2, Read Data and Bit Flip Register 57 */
#define MTU_MC24_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628D2u)

/** \brief 18D4, Read Data and Bit Flip Register 58 */
#define MTU_MC24_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628D4u)

/** \brief 18D6, Read Data and Bit Flip Register 59 */
#define MTU_MC24_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628D6u)

/** \brief 18D8, Read Data and Bit Flip Register 60 */
#define MTU_MC24_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628D8u)

/** \brief 18DA, Read Data and Bit Flip Register 61 */
#define MTU_MC24_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628DAu)

/** \brief 18DC, Read Data and Bit Flip Register 62 */
#define MTU_MC24_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628DCu)

/** \brief 18DE, Read Data and Bit Flip Register 63 */
#define MTU_MC24_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628DEu)

/** \brief 18E0, Read Data and Bit Flip Register 64 */
#define MTU_MC24_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628E0u)

/** \brief 18E2, Read Data and Bit Flip Register 65 */
#define MTU_MC24_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628E2u)

/** \brief 18E4, Read Data and Bit Flip Register 66 */
#define MTU_MC24_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00628E4u)

/** \brief 18EE, Alarm Sources Configuration Register */
#define MTU_MC24_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00628EEu)

/** \brief 18F0, SSH Safety Faults Status Register  */
#define MTU_MC24_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00628F0u)

/** \brief 18F2, Error Information Register 0 */
#define MTU_MC24_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00628F2u)

/** \brief 18F4, Error Information Register 1 */
#define MTU_MC24_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00628F4u)

/** \brief 18F6, Error Information Register 2 */
#define MTU_MC24_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00628F6u)

/** \brief 18F8, Error Information Register 3 */
#define MTU_MC24_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00628F8u)

/** \brief 18FA, Error Information Register 4 */
#define MTU_MC24_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00628FAu)

/** \brief 1900, Configuration Registers */
#define MTU_MC25_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062900u)

/** \brief 1902, Configuration Register 1 */
#define MTU_MC25_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062902u)

/** \brief 1904, MBIST Control Register */
#define MTU_MC25_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062904u)

/** \brief 1906, Status Register */
#define MTU_MC25_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062906u)

/** \brief 1908, Range Register, single address mode */
#define MTU_MC25_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062908u)

/** \brief 190C, Revision ID Register */
#define MTU_MC25_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006290Cu)

/** \brief 190E, ECC Safety Register */
#define MTU_MC25_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006290Eu)

/** \brief 1910, Memory ECC Detection Register */
#define MTU_MC25_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062910u)

/** \brief 1912, Error Tracking Register 0 */
#define MTU_MC25_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062912u)

/** \brief 1914, Error Tracking Register 1 */
#define MTU_MC25_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062914u)

/** \brief 1916, Error Tracking Register 2 */
#define MTU_MC25_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062916u)

/** \brief 1918, Error Tracking Register 3 */
#define MTU_MC25_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062918u)

/** \brief 191A, Error Tracking Register 4 */
#define MTU_MC25_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006291Au)

/** \brief 1960, Read Data and Bit Flip Register 0 */
#define MTU_MC25_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062960u)

/** \brief 1962, Read Data and Bit Flip Register 1 */
#define MTU_MC25_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062962u)

/** \brief 1964, Read Data and Bit Flip Register 2 */
#define MTU_MC25_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062964u)

/** \brief 1966, Read Data and Bit Flip Register 3 */
#define MTU_MC25_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062966u)

/** \brief 1968, Read Data and Bit Flip Register 4 */
#define MTU_MC25_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062968u)

/** \brief 196A, Read Data and Bit Flip Register 5 */
#define MTU_MC25_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006296Au)

/** \brief 196C, Read Data and Bit Flip Register 6 */
#define MTU_MC25_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006296Cu)

/** \brief 196E, Read Data and Bit Flip Register 7 */
#define MTU_MC25_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006296Eu)

/** \brief 1970, Read Data and Bit Flip Register 8 */
#define MTU_MC25_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062970u)

/** \brief 1972, Read Data and Bit Flip Register 9 */
#define MTU_MC25_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062972u)

/** \brief 1974, Read Data and Bit Flip Register 10 */
#define MTU_MC25_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062974u)

/** \brief 1976, Read Data and Bit Flip Register 11 */
#define MTU_MC25_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062976u)

/** \brief 1978, Read Data and Bit Flip Register 12 */
#define MTU_MC25_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062978u)

/** \brief 197A, Read Data and Bit Flip Register 13 */
#define MTU_MC25_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006297Au)

/** \brief 197C, Read Data and Bit Flip Register 14 */
#define MTU_MC25_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006297Cu)

/** \brief 197E, Read Data and Bit Flip Register 15 */
#define MTU_MC25_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006297Eu)

/** \brief 1980, Read Data and Bit Flip Register 16 */
#define MTU_MC25_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062980u)

/** \brief 1982, Read Data and Bit Flip Register 17 */
#define MTU_MC25_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062982u)

/** \brief 1984, Read Data and Bit Flip Register 18 */
#define MTU_MC25_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062984u)

/** \brief 1986, Read Data and Bit Flip Register 19 */
#define MTU_MC25_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062986u)

/** \brief 1988, Read Data and Bit Flip Register 20 */
#define MTU_MC25_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062988u)

/** \brief 198A, Read Data and Bit Flip Register 21 */
#define MTU_MC25_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006298Au)

/** \brief 198C, Read Data and Bit Flip Register 22 */
#define MTU_MC25_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006298Cu)

/** \brief 198E, Read Data and Bit Flip Register 23 */
#define MTU_MC25_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006298Eu)

/** \brief 1990, Read Data and Bit Flip Register 24 */
#define MTU_MC25_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062990u)

/** \brief 1992, Read Data and Bit Flip Register 25 */
#define MTU_MC25_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062992u)

/** \brief 1994, Read Data and Bit Flip Register 26 */
#define MTU_MC25_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062994u)

/** \brief 1996, Read Data and Bit Flip Register 27 */
#define MTU_MC25_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062996u)

/** \brief 1998, Read Data and Bit Flip Register 28 */
#define MTU_MC25_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062998u)

/** \brief 199A, Read Data and Bit Flip Register 29 */
#define MTU_MC25_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006299Au)

/** \brief 199C, Read Data and Bit Flip Register 30 */
#define MTU_MC25_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006299Cu)

/** \brief 199E, Read Data and Bit Flip Register 31 */
#define MTU_MC25_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006299Eu)

/** \brief 19A0, Read Data and Bit Flip Register 32 */
#define MTU_MC25_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629A0u)

/** \brief 19A2, Read Data and Bit Flip Register 33 */
#define MTU_MC25_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629A2u)

/** \brief 19A4, Read Data and Bit Flip Register 34 */
#define MTU_MC25_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629A4u)

/** \brief 19A6, Read Data and Bit Flip Register 35 */
#define MTU_MC25_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629A6u)

/** \brief 19A8, Read Data and Bit Flip Register 36 */
#define MTU_MC25_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629A8u)

/** \brief 19AA, Read Data and Bit Flip Register 37 */
#define MTU_MC25_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629AAu)

/** \brief 19AC, Read Data and Bit Flip Register 38 */
#define MTU_MC25_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629ACu)

/** \brief 19AE, Read Data and Bit Flip Register 39 */
#define MTU_MC25_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629AEu)

/** \brief 19B0, Read Data and Bit Flip Register 40 */
#define MTU_MC25_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629B0u)

/** \brief 19B2, Read Data and Bit Flip Register 41 */
#define MTU_MC25_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629B2u)

/** \brief 19B4, Read Data and Bit Flip Register 42 */
#define MTU_MC25_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629B4u)

/** \brief 19B6, Read Data and Bit Flip Register 43 */
#define MTU_MC25_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629B6u)

/** \brief 19B8, Read Data and Bit Flip Register 44 */
#define MTU_MC25_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629B8u)

/** \brief 19BA, Read Data and Bit Flip Register 45 */
#define MTU_MC25_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629BAu)

/** \brief 19BC, Read Data and Bit Flip Register 46 */
#define MTU_MC25_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629BCu)

/** \brief 19BE, Read Data and Bit Flip Register 47 */
#define MTU_MC25_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629BEu)

/** \brief 19C0, Read Data and Bit Flip Register 48 */
#define MTU_MC25_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629C0u)

/** \brief 19C2, Read Data and Bit Flip Register 49 */
#define MTU_MC25_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629C2u)

/** \brief 19C4, Read Data and Bit Flip Register 50 */
#define MTU_MC25_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629C4u)

/** \brief 19C6, Read Data and Bit Flip Register 51 */
#define MTU_MC25_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629C6u)

/** \brief 19C8, Read Data and Bit Flip Register 52 */
#define MTU_MC25_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629C8u)

/** \brief 19CA, Read Data and Bit Flip Register 53 */
#define MTU_MC25_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629CAu)

/** \brief 19CC, Read Data and Bit Flip Register 54 */
#define MTU_MC25_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629CCu)

/** \brief 19CE, Read Data and Bit Flip Register 55 */
#define MTU_MC25_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629CEu)

/** \brief 19D0, Read Data and Bit Flip Register 56 */
#define MTU_MC25_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629D0u)

/** \brief 19D2, Read Data and Bit Flip Register 57 */
#define MTU_MC25_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629D2u)

/** \brief 19D4, Read Data and Bit Flip Register 58 */
#define MTU_MC25_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629D4u)

/** \brief 19D6, Read Data and Bit Flip Register 59 */
#define MTU_MC25_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629D6u)

/** \brief 19D8, Read Data and Bit Flip Register 60 */
#define MTU_MC25_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629D8u)

/** \brief 19DA, Read Data and Bit Flip Register 61 */
#define MTU_MC25_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629DAu)

/** \brief 19DC, Read Data and Bit Flip Register 62 */
#define MTU_MC25_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629DCu)

/** \brief 19DE, Read Data and Bit Flip Register 63 */
#define MTU_MC25_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629DEu)

/** \brief 19E0, Read Data and Bit Flip Register 64 */
#define MTU_MC25_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629E0u)

/** \brief 19E2, Read Data and Bit Flip Register 65 */
#define MTU_MC25_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629E2u)

/** \brief 19E4, Read Data and Bit Flip Register 66 */
#define MTU_MC25_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00629E4u)

/** \brief 19EE, Alarm Sources Configuration Register */
#define MTU_MC25_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00629EEu)

/** \brief 19F0, SSH Safety Faults Status Register  */
#define MTU_MC25_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00629F0u)

/** \brief 19F2, Error Information Register 0 */
#define MTU_MC25_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00629F2u)

/** \brief 19F4, Error Information Register 1 */
#define MTU_MC25_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00629F4u)

/** \brief 19F6, Error Information Register 2 */
#define MTU_MC25_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00629F6u)

/** \brief 19F8, Error Information Register 3 */
#define MTU_MC25_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00629F8u)

/** \brief 19FA, Error Information Register 4 */
#define MTU_MC25_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00629FAu)

/** \brief 1A00, Configuration Registers */
#define MTU_MC26_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062A00u)

/** \brief 1A02, Configuration Register 1 */
#define MTU_MC26_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062A02u)

/** \brief 1A04, MBIST Control Register */
#define MTU_MC26_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062A04u)

/** \brief 1A06, Status Register */
#define MTU_MC26_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062A06u)

/** \brief 1A08, Range Register, single address mode */
#define MTU_MC26_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062A08u)

/** \brief 1A0C, Revision ID Register */
#define MTU_MC26_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0062A0Cu)

/** \brief 1A0E, ECC Safety Register */
#define MTU_MC26_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0062A0Eu)

/** \brief 1A10, Memory ECC Detection Register */
#define MTU_MC26_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062A10u)

/** \brief 1A12, Error Tracking Register 0 */
#define MTU_MC26_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062A12u)

/** \brief 1A14, Error Tracking Register 1 */
#define MTU_MC26_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062A14u)

/** \brief 1A16, Error Tracking Register 2 */
#define MTU_MC26_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062A16u)

/** \brief 1A18, Error Tracking Register 3 */
#define MTU_MC26_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062A18u)

/** \brief 1A1A, Error Tracking Register 4 */
#define MTU_MC26_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062A1Au)

/** \brief 1A60, Read Data and Bit Flip Register 0 */
#define MTU_MC26_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A60u)

/** \brief 1A62, Read Data and Bit Flip Register 1 */
#define MTU_MC26_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A62u)

/** \brief 1A64, Read Data and Bit Flip Register 2 */
#define MTU_MC26_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A64u)

/** \brief 1A66, Read Data and Bit Flip Register 3 */
#define MTU_MC26_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A66u)

/** \brief 1A68, Read Data and Bit Flip Register 4 */
#define MTU_MC26_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A68u)

/** \brief 1A6A, Read Data and Bit Flip Register 5 */
#define MTU_MC26_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A6Au)

/** \brief 1A6C, Read Data and Bit Flip Register 6 */
#define MTU_MC26_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A6Cu)

/** \brief 1A6E, Read Data and Bit Flip Register 7 */
#define MTU_MC26_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A6Eu)

/** \brief 1A70, Read Data and Bit Flip Register 8 */
#define MTU_MC26_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A70u)

/** \brief 1A72, Read Data and Bit Flip Register 9 */
#define MTU_MC26_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A72u)

/** \brief 1A74, Read Data and Bit Flip Register 10 */
#define MTU_MC26_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A74u)

/** \brief 1A76, Read Data and Bit Flip Register 11 */
#define MTU_MC26_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A76u)

/** \brief 1A78, Read Data and Bit Flip Register 12 */
#define MTU_MC26_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A78u)

/** \brief 1A7A, Read Data and Bit Flip Register 13 */
#define MTU_MC26_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A7Au)

/** \brief 1A7C, Read Data and Bit Flip Register 14 */
#define MTU_MC26_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A7Cu)

/** \brief 1A7E, Read Data and Bit Flip Register 15 */
#define MTU_MC26_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A7Eu)

/** \brief 1A80, Read Data and Bit Flip Register 16 */
#define MTU_MC26_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A80u)

/** \brief 1A82, Read Data and Bit Flip Register 17 */
#define MTU_MC26_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A82u)

/** \brief 1A84, Read Data and Bit Flip Register 18 */
#define MTU_MC26_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A84u)

/** \brief 1A86, Read Data and Bit Flip Register 19 */
#define MTU_MC26_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A86u)

/** \brief 1A88, Read Data and Bit Flip Register 20 */
#define MTU_MC26_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A88u)

/** \brief 1A8A, Read Data and Bit Flip Register 21 */
#define MTU_MC26_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A8Au)

/** \brief 1A8C, Read Data and Bit Flip Register 22 */
#define MTU_MC26_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A8Cu)

/** \brief 1A8E, Read Data and Bit Flip Register 23 */
#define MTU_MC26_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A8Eu)

/** \brief 1A90, Read Data and Bit Flip Register 24 */
#define MTU_MC26_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A90u)

/** \brief 1A92, Read Data and Bit Flip Register 25 */
#define MTU_MC26_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A92u)

/** \brief 1A94, Read Data and Bit Flip Register 26 */
#define MTU_MC26_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A94u)

/** \brief 1A96, Read Data and Bit Flip Register 27 */
#define MTU_MC26_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A96u)

/** \brief 1A98, Read Data and Bit Flip Register 28 */
#define MTU_MC26_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A98u)

/** \brief 1A9A, Read Data and Bit Flip Register 29 */
#define MTU_MC26_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A9Au)

/** \brief 1A9C, Read Data and Bit Flip Register 30 */
#define MTU_MC26_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A9Cu)

/** \brief 1A9E, Read Data and Bit Flip Register 31 */
#define MTU_MC26_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062A9Eu)

/** \brief 1AA0, Read Data and Bit Flip Register 32 */
#define MTU_MC26_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AA0u)

/** \brief 1AA2, Read Data and Bit Flip Register 33 */
#define MTU_MC26_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AA2u)

/** \brief 1AA4, Read Data and Bit Flip Register 34 */
#define MTU_MC26_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AA4u)

/** \brief 1AA6, Read Data and Bit Flip Register 35 */
#define MTU_MC26_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AA6u)

/** \brief 1AA8, Read Data and Bit Flip Register 36 */
#define MTU_MC26_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AA8u)

/** \brief 1AAA, Read Data and Bit Flip Register 37 */
#define MTU_MC26_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AAAu)

/** \brief 1AAC, Read Data and Bit Flip Register 38 */
#define MTU_MC26_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AACu)

/** \brief 1AAE, Read Data and Bit Flip Register 39 */
#define MTU_MC26_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AAEu)

/** \brief 1AB0, Read Data and Bit Flip Register 40 */
#define MTU_MC26_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AB0u)

/** \brief 1AB2, Read Data and Bit Flip Register 41 */
#define MTU_MC26_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AB2u)

/** \brief 1AB4, Read Data and Bit Flip Register 42 */
#define MTU_MC26_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AB4u)

/** \brief 1AB6, Read Data and Bit Flip Register 43 */
#define MTU_MC26_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AB6u)

/** \brief 1AB8, Read Data and Bit Flip Register 44 */
#define MTU_MC26_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AB8u)

/** \brief 1ABA, Read Data and Bit Flip Register 45 */
#define MTU_MC26_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ABAu)

/** \brief 1ABC, Read Data and Bit Flip Register 46 */
#define MTU_MC26_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ABCu)

/** \brief 1ABE, Read Data and Bit Flip Register 47 */
#define MTU_MC26_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ABEu)

/** \brief 1AC0, Read Data and Bit Flip Register 48 */
#define MTU_MC26_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AC0u)

/** \brief 1AC2, Read Data and Bit Flip Register 49 */
#define MTU_MC26_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AC2u)

/** \brief 1AC4, Read Data and Bit Flip Register 50 */
#define MTU_MC26_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AC4u)

/** \brief 1AC6, Read Data and Bit Flip Register 51 */
#define MTU_MC26_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AC6u)

/** \brief 1AC8, Read Data and Bit Flip Register 52 */
#define MTU_MC26_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AC8u)

/** \brief 1ACA, Read Data and Bit Flip Register 53 */
#define MTU_MC26_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ACAu)

/** \brief 1ACC, Read Data and Bit Flip Register 54 */
#define MTU_MC26_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ACCu)

/** \brief 1ACE, Read Data and Bit Flip Register 55 */
#define MTU_MC26_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ACEu)

/** \brief 1AD0, Read Data and Bit Flip Register 56 */
#define MTU_MC26_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AD0u)

/** \brief 1AD2, Read Data and Bit Flip Register 57 */
#define MTU_MC26_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AD2u)

/** \brief 1AD4, Read Data and Bit Flip Register 58 */
#define MTU_MC26_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AD4u)

/** \brief 1AD6, Read Data and Bit Flip Register 59 */
#define MTU_MC26_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AD6u)

/** \brief 1AD8, Read Data and Bit Flip Register 60 */
#define MTU_MC26_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AD8u)

/** \brief 1ADA, Read Data and Bit Flip Register 61 */
#define MTU_MC26_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ADAu)

/** \brief 1ADC, Read Data and Bit Flip Register 62 */
#define MTU_MC26_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ADCu)

/** \brief 1ADE, Read Data and Bit Flip Register 63 */
#define MTU_MC26_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ADEu)

/** \brief 1AE0, Read Data and Bit Flip Register 64 */
#define MTU_MC26_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AE0u)

/** \brief 1AE2, Read Data and Bit Flip Register 65 */
#define MTU_MC26_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AE2u)

/** \brief 1AE4, Read Data and Bit Flip Register 66 */
#define MTU_MC26_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062AE4u)

/** \brief 1AEE, Alarm Sources Configuration Register */
#define MTU_MC26_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0062AEEu)

/** \brief 1AF0, SSH Safety Faults Status Register  */
#define MTU_MC26_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0062AF0u)

/** \brief 1AF2, Error Information Register 0 */
#define MTU_MC26_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062AF2u)

/** \brief 1AF4, Error Information Register 1 */
#define MTU_MC26_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062AF4u)

/** \brief 1AF6, Error Information Register 2 */
#define MTU_MC26_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062AF6u)

/** \brief 1AF8, Error Information Register 3 */
#define MTU_MC26_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062AF8u)

/** \brief 1AFA, Error Information Register 4 */
#define MTU_MC26_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062AFAu)

/** \brief 1B00, Configuration Registers */
#define MTU_MC27_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062B00u)

/** \brief 1B02, Configuration Register 1 */
#define MTU_MC27_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062B02u)

/** \brief 1B04, MBIST Control Register */
#define MTU_MC27_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062B04u)

/** \brief 1B06, Status Register */
#define MTU_MC27_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062B06u)

/** \brief 1B08, Range Register, single address mode */
#define MTU_MC27_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062B08u)

/** \brief 1B0C, Revision ID Register */
#define MTU_MC27_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0062B0Cu)

/** \brief 1B0E, ECC Safety Register */
#define MTU_MC27_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0062B0Eu)

/** \brief 1B10, Memory ECC Detection Register */
#define MTU_MC27_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062B10u)

/** \brief 1B12, Error Tracking Register 0 */
#define MTU_MC27_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062B12u)

/** \brief 1B14, Error Tracking Register 1 */
#define MTU_MC27_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062B14u)

/** \brief 1B16, Error Tracking Register 2 */
#define MTU_MC27_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062B16u)

/** \brief 1B18, Error Tracking Register 3 */
#define MTU_MC27_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062B18u)

/** \brief 1B1A, Error Tracking Register 4 */
#define MTU_MC27_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062B1Au)

/** \brief 1B60, Read Data and Bit Flip Register 0 */
#define MTU_MC27_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B60u)

/** \brief 1B62, Read Data and Bit Flip Register 1 */
#define MTU_MC27_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B62u)

/** \brief 1B64, Read Data and Bit Flip Register 2 */
#define MTU_MC27_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B64u)

/** \brief 1B66, Read Data and Bit Flip Register 3 */
#define MTU_MC27_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B66u)

/** \brief 1B68, Read Data and Bit Flip Register 4 */
#define MTU_MC27_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B68u)

/** \brief 1B6A, Read Data and Bit Flip Register 5 */
#define MTU_MC27_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B6Au)

/** \brief 1B6C, Read Data and Bit Flip Register 6 */
#define MTU_MC27_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B6Cu)

/** \brief 1B6E, Read Data and Bit Flip Register 7 */
#define MTU_MC27_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B6Eu)

/** \brief 1B70, Read Data and Bit Flip Register 8 */
#define MTU_MC27_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B70u)

/** \brief 1B72, Read Data and Bit Flip Register 9 */
#define MTU_MC27_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B72u)

/** \brief 1B74, Read Data and Bit Flip Register 10 */
#define MTU_MC27_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B74u)

/** \brief 1B76, Read Data and Bit Flip Register 11 */
#define MTU_MC27_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B76u)

/** \brief 1B78, Read Data and Bit Flip Register 12 */
#define MTU_MC27_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B78u)

/** \brief 1B7A, Read Data and Bit Flip Register 13 */
#define MTU_MC27_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B7Au)

/** \brief 1B7C, Read Data and Bit Flip Register 14 */
#define MTU_MC27_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B7Cu)

/** \brief 1B7E, Read Data and Bit Flip Register 15 */
#define MTU_MC27_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B7Eu)

/** \brief 1B80, Read Data and Bit Flip Register 16 */
#define MTU_MC27_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B80u)

/** \brief 1B82, Read Data and Bit Flip Register 17 */
#define MTU_MC27_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B82u)

/** \brief 1B84, Read Data and Bit Flip Register 18 */
#define MTU_MC27_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B84u)

/** \brief 1B86, Read Data and Bit Flip Register 19 */
#define MTU_MC27_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B86u)

/** \brief 1B88, Read Data and Bit Flip Register 20 */
#define MTU_MC27_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B88u)

/** \brief 1B8A, Read Data and Bit Flip Register 21 */
#define MTU_MC27_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B8Au)

/** \brief 1B8C, Read Data and Bit Flip Register 22 */
#define MTU_MC27_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B8Cu)

/** \brief 1B8E, Read Data and Bit Flip Register 23 */
#define MTU_MC27_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B8Eu)

/** \brief 1B90, Read Data and Bit Flip Register 24 */
#define MTU_MC27_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B90u)

/** \brief 1B92, Read Data and Bit Flip Register 25 */
#define MTU_MC27_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B92u)

/** \brief 1B94, Read Data and Bit Flip Register 26 */
#define MTU_MC27_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B94u)

/** \brief 1B96, Read Data and Bit Flip Register 27 */
#define MTU_MC27_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B96u)

/** \brief 1B98, Read Data and Bit Flip Register 28 */
#define MTU_MC27_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B98u)

/** \brief 1B9A, Read Data and Bit Flip Register 29 */
#define MTU_MC27_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B9Au)

/** \brief 1B9C, Read Data and Bit Flip Register 30 */
#define MTU_MC27_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B9Cu)

/** \brief 1B9E, Read Data and Bit Flip Register 31 */
#define MTU_MC27_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062B9Eu)

/** \brief 1BA0, Read Data and Bit Flip Register 32 */
#define MTU_MC27_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BA0u)

/** \brief 1BA2, Read Data and Bit Flip Register 33 */
#define MTU_MC27_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BA2u)

/** \brief 1BA4, Read Data and Bit Flip Register 34 */
#define MTU_MC27_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BA4u)

/** \brief 1BA6, Read Data and Bit Flip Register 35 */
#define MTU_MC27_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BA6u)

/** \brief 1BA8, Read Data and Bit Flip Register 36 */
#define MTU_MC27_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BA8u)

/** \brief 1BAA, Read Data and Bit Flip Register 37 */
#define MTU_MC27_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BAAu)

/** \brief 1BAC, Read Data and Bit Flip Register 38 */
#define MTU_MC27_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BACu)

/** \brief 1BAE, Read Data and Bit Flip Register 39 */
#define MTU_MC27_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BAEu)

/** \brief 1BB0, Read Data and Bit Flip Register 40 */
#define MTU_MC27_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BB0u)

/** \brief 1BB2, Read Data and Bit Flip Register 41 */
#define MTU_MC27_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BB2u)

/** \brief 1BB4, Read Data and Bit Flip Register 42 */
#define MTU_MC27_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BB4u)

/** \brief 1BB6, Read Data and Bit Flip Register 43 */
#define MTU_MC27_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BB6u)

/** \brief 1BB8, Read Data and Bit Flip Register 44 */
#define MTU_MC27_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BB8u)

/** \brief 1BBA, Read Data and Bit Flip Register 45 */
#define MTU_MC27_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BBAu)

/** \brief 1BBC, Read Data and Bit Flip Register 46 */
#define MTU_MC27_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BBCu)

/** \brief 1BBE, Read Data and Bit Flip Register 47 */
#define MTU_MC27_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BBEu)

/** \brief 1BC0, Read Data and Bit Flip Register 48 */
#define MTU_MC27_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BC0u)

/** \brief 1BC2, Read Data and Bit Flip Register 49 */
#define MTU_MC27_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BC2u)

/** \brief 1BC4, Read Data and Bit Flip Register 50 */
#define MTU_MC27_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BC4u)

/** \brief 1BC6, Read Data and Bit Flip Register 51 */
#define MTU_MC27_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BC6u)

/** \brief 1BC8, Read Data and Bit Flip Register 52 */
#define MTU_MC27_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BC8u)

/** \brief 1BCA, Read Data and Bit Flip Register 53 */
#define MTU_MC27_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BCAu)

/** \brief 1BCC, Read Data and Bit Flip Register 54 */
#define MTU_MC27_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BCCu)

/** \brief 1BCE, Read Data and Bit Flip Register 55 */
#define MTU_MC27_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BCEu)

/** \brief 1BD0, Read Data and Bit Flip Register 56 */
#define MTU_MC27_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BD0u)

/** \brief 1BD2, Read Data and Bit Flip Register 57 */
#define MTU_MC27_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BD2u)

/** \brief 1BD4, Read Data and Bit Flip Register 58 */
#define MTU_MC27_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BD4u)

/** \brief 1BD6, Read Data and Bit Flip Register 59 */
#define MTU_MC27_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BD6u)

/** \brief 1BD8, Read Data and Bit Flip Register 60 */
#define MTU_MC27_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BD8u)

/** \brief 1BDA, Read Data and Bit Flip Register 61 */
#define MTU_MC27_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BDAu)

/** \brief 1BDC, Read Data and Bit Flip Register 62 */
#define MTU_MC27_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BDCu)

/** \brief 1BDE, Read Data and Bit Flip Register 63 */
#define MTU_MC27_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BDEu)

/** \brief 1BE0, Read Data and Bit Flip Register 64 */
#define MTU_MC27_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BE0u)

/** \brief 1BE2, Read Data and Bit Flip Register 65 */
#define MTU_MC27_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BE2u)

/** \brief 1BE4, Read Data and Bit Flip Register 66 */
#define MTU_MC27_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062BE4u)

/** \brief 1BEE, Alarm Sources Configuration Register */
#define MTU_MC27_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0062BEEu)

/** \brief 1BF0, SSH Safety Faults Status Register  */
#define MTU_MC27_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0062BF0u)

/** \brief 1BF2, Error Information Register 0 */
#define MTU_MC27_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062BF2u)

/** \brief 1BF4, Error Information Register 1 */
#define MTU_MC27_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062BF4u)

/** \brief 1BF6, Error Information Register 2 */
#define MTU_MC27_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062BF6u)

/** \brief 1BF8, Error Information Register 3 */
#define MTU_MC27_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062BF8u)

/** \brief 1BFA, Error Information Register 4 */
#define MTU_MC27_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062BFAu)

/** \brief 1C00, Configuration Registers */
#define MTU_MC28_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062C00u)

/** \brief 1C02, Configuration Register 1 */
#define MTU_MC28_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062C02u)

/** \brief 1C04, MBIST Control Register */
#define MTU_MC28_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062C04u)

/** \brief 1C06, Status Register */
#define MTU_MC28_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062C06u)

/** \brief 1C08, Range Register, single address mode */
#define MTU_MC28_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062C08u)

/** \brief 1C0C, Revision ID Register */
#define MTU_MC28_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0062C0Cu)

/** \brief 1C0E, ECC Safety Register */
#define MTU_MC28_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0062C0Eu)

/** \brief 1C10, Memory ECC Detection Register */
#define MTU_MC28_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062C10u)

/** \brief 1C12, Error Tracking Register 0 */
#define MTU_MC28_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062C12u)

/** \brief 1C14, Error Tracking Register 1 */
#define MTU_MC28_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062C14u)

/** \brief 1C16, Error Tracking Register 2 */
#define MTU_MC28_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062C16u)

/** \brief 1C18, Error Tracking Register 3 */
#define MTU_MC28_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062C18u)

/** \brief 1C1A, Error Tracking Register 4 */
#define MTU_MC28_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062C1Au)

/** \brief 1C60, Read Data and Bit Flip Register 0 */
#define MTU_MC28_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C60u)

/** \brief 1C62, Read Data and Bit Flip Register 1 */
#define MTU_MC28_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C62u)

/** \brief 1C64, Read Data and Bit Flip Register 2 */
#define MTU_MC28_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C64u)

/** \brief 1C66, Read Data and Bit Flip Register 3 */
#define MTU_MC28_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C66u)

/** \brief 1C68, Read Data and Bit Flip Register 4 */
#define MTU_MC28_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C68u)

/** \brief 1C6A, Read Data and Bit Flip Register 5 */
#define MTU_MC28_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C6Au)

/** \brief 1C6C, Read Data and Bit Flip Register 6 */
#define MTU_MC28_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C6Cu)

/** \brief 1C6E, Read Data and Bit Flip Register 7 */
#define MTU_MC28_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C6Eu)

/** \brief 1C70, Read Data and Bit Flip Register 8 */
#define MTU_MC28_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C70u)

/** \brief 1C72, Read Data and Bit Flip Register 9 */
#define MTU_MC28_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C72u)

/** \brief 1C74, Read Data and Bit Flip Register 10 */
#define MTU_MC28_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C74u)

/** \brief 1C76, Read Data and Bit Flip Register 11 */
#define MTU_MC28_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C76u)

/** \brief 1C78, Read Data and Bit Flip Register 12 */
#define MTU_MC28_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C78u)

/** \brief 1C7A, Read Data and Bit Flip Register 13 */
#define MTU_MC28_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C7Au)

/** \brief 1C7C, Read Data and Bit Flip Register 14 */
#define MTU_MC28_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C7Cu)

/** \brief 1C7E, Read Data and Bit Flip Register 15 */
#define MTU_MC28_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C7Eu)

/** \brief 1C80, Read Data and Bit Flip Register 16 */
#define MTU_MC28_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C80u)

/** \brief 1C82, Read Data and Bit Flip Register 17 */
#define MTU_MC28_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C82u)

/** \brief 1C84, Read Data and Bit Flip Register 18 */
#define MTU_MC28_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C84u)

/** \brief 1C86, Read Data and Bit Flip Register 19 */
#define MTU_MC28_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C86u)

/** \brief 1C88, Read Data and Bit Flip Register 20 */
#define MTU_MC28_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C88u)

/** \brief 1C8A, Read Data and Bit Flip Register 21 */
#define MTU_MC28_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C8Au)

/** \brief 1C8C, Read Data and Bit Flip Register 22 */
#define MTU_MC28_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C8Cu)

/** \brief 1C8E, Read Data and Bit Flip Register 23 */
#define MTU_MC28_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C8Eu)

/** \brief 1C90, Read Data and Bit Flip Register 24 */
#define MTU_MC28_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C90u)

/** \brief 1C92, Read Data and Bit Flip Register 25 */
#define MTU_MC28_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C92u)

/** \brief 1C94, Read Data and Bit Flip Register 26 */
#define MTU_MC28_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C94u)

/** \brief 1C96, Read Data and Bit Flip Register 27 */
#define MTU_MC28_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C96u)

/** \brief 1C98, Read Data and Bit Flip Register 28 */
#define MTU_MC28_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C98u)

/** \brief 1C9A, Read Data and Bit Flip Register 29 */
#define MTU_MC28_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C9Au)

/** \brief 1C9C, Read Data and Bit Flip Register 30 */
#define MTU_MC28_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C9Cu)

/** \brief 1C9E, Read Data and Bit Flip Register 31 */
#define MTU_MC28_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062C9Eu)

/** \brief 1CA0, Read Data and Bit Flip Register 32 */
#define MTU_MC28_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CA0u)

/** \brief 1CA2, Read Data and Bit Flip Register 33 */
#define MTU_MC28_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CA2u)

/** \brief 1CA4, Read Data and Bit Flip Register 34 */
#define MTU_MC28_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CA4u)

/** \brief 1CA6, Read Data and Bit Flip Register 35 */
#define MTU_MC28_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CA6u)

/** \brief 1CA8, Read Data and Bit Flip Register 36 */
#define MTU_MC28_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CA8u)

/** \brief 1CAA, Read Data and Bit Flip Register 37 */
#define MTU_MC28_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CAAu)

/** \brief 1CAC, Read Data and Bit Flip Register 38 */
#define MTU_MC28_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CACu)

/** \brief 1CAE, Read Data and Bit Flip Register 39 */
#define MTU_MC28_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CAEu)

/** \brief 1CB0, Read Data and Bit Flip Register 40 */
#define MTU_MC28_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CB0u)

/** \brief 1CB2, Read Data and Bit Flip Register 41 */
#define MTU_MC28_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CB2u)

/** \brief 1CB4, Read Data and Bit Flip Register 42 */
#define MTU_MC28_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CB4u)

/** \brief 1CB6, Read Data and Bit Flip Register 43 */
#define MTU_MC28_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CB6u)

/** \brief 1CB8, Read Data and Bit Flip Register 44 */
#define MTU_MC28_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CB8u)

/** \brief 1CBA, Read Data and Bit Flip Register 45 */
#define MTU_MC28_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CBAu)

/** \brief 1CBC, Read Data and Bit Flip Register 46 */
#define MTU_MC28_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CBCu)

/** \brief 1CBE, Read Data and Bit Flip Register 47 */
#define MTU_MC28_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CBEu)

/** \brief 1CC0, Read Data and Bit Flip Register 48 */
#define MTU_MC28_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CC0u)

/** \brief 1CC2, Read Data and Bit Flip Register 49 */
#define MTU_MC28_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CC2u)

/** \brief 1CC4, Read Data and Bit Flip Register 50 */
#define MTU_MC28_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CC4u)

/** \brief 1CC6, Read Data and Bit Flip Register 51 */
#define MTU_MC28_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CC6u)

/** \brief 1CC8, Read Data and Bit Flip Register 52 */
#define MTU_MC28_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CC8u)

/** \brief 1CCA, Read Data and Bit Flip Register 53 */
#define MTU_MC28_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CCAu)

/** \brief 1CCC, Read Data and Bit Flip Register 54 */
#define MTU_MC28_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CCCu)

/** \brief 1CCE, Read Data and Bit Flip Register 55 */
#define MTU_MC28_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CCEu)

/** \brief 1CD0, Read Data and Bit Flip Register 56 */
#define MTU_MC28_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CD0u)

/** \brief 1CD2, Read Data and Bit Flip Register 57 */
#define MTU_MC28_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CD2u)

/** \brief 1CD4, Read Data and Bit Flip Register 58 */
#define MTU_MC28_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CD4u)

/** \brief 1CD6, Read Data and Bit Flip Register 59 */
#define MTU_MC28_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CD6u)

/** \brief 1CD8, Read Data and Bit Flip Register 60 */
#define MTU_MC28_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CD8u)

/** \brief 1CDA, Read Data and Bit Flip Register 61 */
#define MTU_MC28_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CDAu)

/** \brief 1CDC, Read Data and Bit Flip Register 62 */
#define MTU_MC28_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CDCu)

/** \brief 1CDE, Read Data and Bit Flip Register 63 */
#define MTU_MC28_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CDEu)

/** \brief 1CE0, Read Data and Bit Flip Register 64 */
#define MTU_MC28_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CE0u)

/** \brief 1CE2, Read Data and Bit Flip Register 65 */
#define MTU_MC28_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CE2u)

/** \brief 1CE4, Read Data and Bit Flip Register 66 */
#define MTU_MC28_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062CE4u)

/** \brief 1CEE, Alarm Sources Configuration Register */
#define MTU_MC28_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0062CEEu)

/** \brief 1CF0, SSH Safety Faults Status Register  */
#define MTU_MC28_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0062CF0u)

/** \brief 1CF2, Error Information Register 0 */
#define MTU_MC28_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062CF2u)

/** \brief 1CF4, Error Information Register 1 */
#define MTU_MC28_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062CF4u)

/** \brief 1CF6, Error Information Register 2 */
#define MTU_MC28_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062CF6u)

/** \brief 1CF8, Error Information Register 3 */
#define MTU_MC28_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062CF8u)

/** \brief 1CFA, Error Information Register 4 */
#define MTU_MC28_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062CFAu)

/** \brief 1D00, Configuration Registers */
#define MTU_MC29_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062D00u)

/** \brief 1D02, Configuration Register 1 */
#define MTU_MC29_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062D02u)

/** \brief 1D04, MBIST Control Register */
#define MTU_MC29_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062D04u)

/** \brief 1D06, Status Register */
#define MTU_MC29_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062D06u)

/** \brief 1D08, Range Register, single address mode */
#define MTU_MC29_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062D08u)

/** \brief 1D0C, Revision ID Register */
#define MTU_MC29_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0062D0Cu)

/** \brief 1D0E, ECC Safety Register */
#define MTU_MC29_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0062D0Eu)

/** \brief 1D10, Memory ECC Detection Register */
#define MTU_MC29_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062D10u)

/** \brief 1D12, Error Tracking Register 0 */
#define MTU_MC29_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062D12u)

/** \brief 1D14, Error Tracking Register 1 */
#define MTU_MC29_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062D14u)

/** \brief 1D16, Error Tracking Register 2 */
#define MTU_MC29_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062D16u)

/** \brief 1D18, Error Tracking Register 3 */
#define MTU_MC29_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062D18u)

/** \brief 1D1A, Error Tracking Register 4 */
#define MTU_MC29_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062D1Au)

/** \brief 1D60, Read Data and Bit Flip Register 0 */
#define MTU_MC29_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D60u)

/** \brief 1D62, Read Data and Bit Flip Register 1 */
#define MTU_MC29_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D62u)

/** \brief 1D64, Read Data and Bit Flip Register 2 */
#define MTU_MC29_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D64u)

/** \brief 1D66, Read Data and Bit Flip Register 3 */
#define MTU_MC29_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D66u)

/** \brief 1D68, Read Data and Bit Flip Register 4 */
#define MTU_MC29_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D68u)

/** \brief 1D6A, Read Data and Bit Flip Register 5 */
#define MTU_MC29_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D6Au)

/** \brief 1D6C, Read Data and Bit Flip Register 6 */
#define MTU_MC29_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D6Cu)

/** \brief 1D6E, Read Data and Bit Flip Register 7 */
#define MTU_MC29_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D6Eu)

/** \brief 1D70, Read Data and Bit Flip Register 8 */
#define MTU_MC29_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D70u)

/** \brief 1D72, Read Data and Bit Flip Register 9 */
#define MTU_MC29_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D72u)

/** \brief 1D74, Read Data and Bit Flip Register 10 */
#define MTU_MC29_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D74u)

/** \brief 1D76, Read Data and Bit Flip Register 11 */
#define MTU_MC29_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D76u)

/** \brief 1D78, Read Data and Bit Flip Register 12 */
#define MTU_MC29_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D78u)

/** \brief 1D7A, Read Data and Bit Flip Register 13 */
#define MTU_MC29_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D7Au)

/** \brief 1D7C, Read Data and Bit Flip Register 14 */
#define MTU_MC29_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D7Cu)

/** \brief 1D7E, Read Data and Bit Flip Register 15 */
#define MTU_MC29_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D7Eu)

/** \brief 1D80, Read Data and Bit Flip Register 16 */
#define MTU_MC29_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D80u)

/** \brief 1D82, Read Data and Bit Flip Register 17 */
#define MTU_MC29_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D82u)

/** \brief 1D84, Read Data and Bit Flip Register 18 */
#define MTU_MC29_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D84u)

/** \brief 1D86, Read Data and Bit Flip Register 19 */
#define MTU_MC29_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D86u)

/** \brief 1D88, Read Data and Bit Flip Register 20 */
#define MTU_MC29_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D88u)

/** \brief 1D8A, Read Data and Bit Flip Register 21 */
#define MTU_MC29_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D8Au)

/** \brief 1D8C, Read Data and Bit Flip Register 22 */
#define MTU_MC29_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D8Cu)

/** \brief 1D8E, Read Data and Bit Flip Register 23 */
#define MTU_MC29_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D8Eu)

/** \brief 1D90, Read Data and Bit Flip Register 24 */
#define MTU_MC29_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D90u)

/** \brief 1D92, Read Data and Bit Flip Register 25 */
#define MTU_MC29_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D92u)

/** \brief 1D94, Read Data and Bit Flip Register 26 */
#define MTU_MC29_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D94u)

/** \brief 1D96, Read Data and Bit Flip Register 27 */
#define MTU_MC29_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D96u)

/** \brief 1D98, Read Data and Bit Flip Register 28 */
#define MTU_MC29_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D98u)

/** \brief 1D9A, Read Data and Bit Flip Register 29 */
#define MTU_MC29_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D9Au)

/** \brief 1D9C, Read Data and Bit Flip Register 30 */
#define MTU_MC29_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D9Cu)

/** \brief 1D9E, Read Data and Bit Flip Register 31 */
#define MTU_MC29_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062D9Eu)

/** \brief 1DA0, Read Data and Bit Flip Register 32 */
#define MTU_MC29_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DA0u)

/** \brief 1DA2, Read Data and Bit Flip Register 33 */
#define MTU_MC29_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DA2u)

/** \brief 1DA4, Read Data and Bit Flip Register 34 */
#define MTU_MC29_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DA4u)

/** \brief 1DA6, Read Data and Bit Flip Register 35 */
#define MTU_MC29_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DA6u)

/** \brief 1DA8, Read Data and Bit Flip Register 36 */
#define MTU_MC29_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DA8u)

/** \brief 1DAA, Read Data and Bit Flip Register 37 */
#define MTU_MC29_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DAAu)

/** \brief 1DAC, Read Data and Bit Flip Register 38 */
#define MTU_MC29_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DACu)

/** \brief 1DAE, Read Data and Bit Flip Register 39 */
#define MTU_MC29_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DAEu)

/** \brief 1DB0, Read Data and Bit Flip Register 40 */
#define MTU_MC29_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DB0u)

/** \brief 1DB2, Read Data and Bit Flip Register 41 */
#define MTU_MC29_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DB2u)

/** \brief 1DB4, Read Data and Bit Flip Register 42 */
#define MTU_MC29_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DB4u)

/** \brief 1DB6, Read Data and Bit Flip Register 43 */
#define MTU_MC29_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DB6u)

/** \brief 1DB8, Read Data and Bit Flip Register 44 */
#define MTU_MC29_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DB8u)

/** \brief 1DBA, Read Data and Bit Flip Register 45 */
#define MTU_MC29_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DBAu)

/** \brief 1DBC, Read Data and Bit Flip Register 46 */
#define MTU_MC29_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DBCu)

/** \brief 1DBE, Read Data and Bit Flip Register 47 */
#define MTU_MC29_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DBEu)

/** \brief 1DC0, Read Data and Bit Flip Register 48 */
#define MTU_MC29_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DC0u)

/** \brief 1DC2, Read Data and Bit Flip Register 49 */
#define MTU_MC29_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DC2u)

/** \brief 1DC4, Read Data and Bit Flip Register 50 */
#define MTU_MC29_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DC4u)

/** \brief 1DC6, Read Data and Bit Flip Register 51 */
#define MTU_MC29_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DC6u)

/** \brief 1DC8, Read Data and Bit Flip Register 52 */
#define MTU_MC29_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DC8u)

/** \brief 1DCA, Read Data and Bit Flip Register 53 */
#define MTU_MC29_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DCAu)

/** \brief 1DCC, Read Data and Bit Flip Register 54 */
#define MTU_MC29_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DCCu)

/** \brief 1DCE, Read Data and Bit Flip Register 55 */
#define MTU_MC29_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DCEu)

/** \brief 1DD0, Read Data and Bit Flip Register 56 */
#define MTU_MC29_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DD0u)

/** \brief 1DD2, Read Data and Bit Flip Register 57 */
#define MTU_MC29_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DD2u)

/** \brief 1DD4, Read Data and Bit Flip Register 58 */
#define MTU_MC29_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DD4u)

/** \brief 1DD6, Read Data and Bit Flip Register 59 */
#define MTU_MC29_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DD6u)

/** \brief 1DD8, Read Data and Bit Flip Register 60 */
#define MTU_MC29_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DD8u)

/** \brief 1DDA, Read Data and Bit Flip Register 61 */
#define MTU_MC29_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DDAu)

/** \brief 1DDC, Read Data and Bit Flip Register 62 */
#define MTU_MC29_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DDCu)

/** \brief 1DDE, Read Data and Bit Flip Register 63 */
#define MTU_MC29_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DDEu)

/** \brief 1DE0, Read Data and Bit Flip Register 64 */
#define MTU_MC29_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DE0u)

/** \brief 1DE2, Read Data and Bit Flip Register 65 */
#define MTU_MC29_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DE2u)

/** \brief 1DE4, Read Data and Bit Flip Register 66 */
#define MTU_MC29_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062DE4u)

/** \brief 1DEE, Alarm Sources Configuration Register */
#define MTU_MC29_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0062DEEu)

/** \brief 1DF0, SSH Safety Faults Status Register  */
#define MTU_MC29_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0062DF0u)

/** \brief 1DF2, Error Information Register 0 */
#define MTU_MC29_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062DF2u)

/** \brief 1DF4, Error Information Register 1 */
#define MTU_MC29_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062DF4u)

/** \brief 1DF6, Error Information Register 2 */
#define MTU_MC29_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062DF6u)

/** \brief 1DF8, Error Information Register 3 */
#define MTU_MC29_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062DF8u)

/** \brief 1DFA, Error Information Register 4 */
#define MTU_MC29_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062DFAu)

/** \brief 1E00, Configuration Registers */
#define MTU_MC30_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062E00u)

/** \brief 1E02, Configuration Register 1 */
#define MTU_MC30_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062E02u)

/** \brief 1E04, MBIST Control Register */
#define MTU_MC30_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062E04u)

/** \brief 1E06, Status Register */
#define MTU_MC30_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062E06u)

/** \brief 1E08, Range Register, single address mode */
#define MTU_MC30_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062E08u)

/** \brief 1E0C, Revision ID Register */
#define MTU_MC30_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0062E0Cu)

/** \brief 1E0E, ECC Safety Register */
#define MTU_MC30_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0062E0Eu)

/** \brief 1E10, Memory ECC Detection Register */
#define MTU_MC30_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062E10u)

/** \brief 1E12, Error Tracking Register 0 */
#define MTU_MC30_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062E12u)

/** \brief 1E14, Error Tracking Register 1 */
#define MTU_MC30_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062E14u)

/** \brief 1E16, Error Tracking Register 2 */
#define MTU_MC30_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062E16u)

/** \brief 1E18, Error Tracking Register 3 */
#define MTU_MC30_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062E18u)

/** \brief 1E1A, Error Tracking Register 4 */
#define MTU_MC30_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062E1Au)

/** \brief 1E60, Read Data and Bit Flip Register 0 */
#define MTU_MC30_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E60u)

/** \brief 1E62, Read Data and Bit Flip Register 1 */
#define MTU_MC30_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E62u)

/** \brief 1E64, Read Data and Bit Flip Register 2 */
#define MTU_MC30_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E64u)

/** \brief 1E66, Read Data and Bit Flip Register 3 */
#define MTU_MC30_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E66u)

/** \brief 1E68, Read Data and Bit Flip Register 4 */
#define MTU_MC30_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E68u)

/** \brief 1E6A, Read Data and Bit Flip Register 5 */
#define MTU_MC30_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E6Au)

/** \brief 1E6C, Read Data and Bit Flip Register 6 */
#define MTU_MC30_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E6Cu)

/** \brief 1E6E, Read Data and Bit Flip Register 7 */
#define MTU_MC30_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E6Eu)

/** \brief 1E70, Read Data and Bit Flip Register 8 */
#define MTU_MC30_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E70u)

/** \brief 1E72, Read Data and Bit Flip Register 9 */
#define MTU_MC30_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E72u)

/** \brief 1E74, Read Data and Bit Flip Register 10 */
#define MTU_MC30_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E74u)

/** \brief 1E76, Read Data and Bit Flip Register 11 */
#define MTU_MC30_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E76u)

/** \brief 1E78, Read Data and Bit Flip Register 12 */
#define MTU_MC30_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E78u)

/** \brief 1E7A, Read Data and Bit Flip Register 13 */
#define MTU_MC30_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E7Au)

/** \brief 1E7C, Read Data and Bit Flip Register 14 */
#define MTU_MC30_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E7Cu)

/** \brief 1E7E, Read Data and Bit Flip Register 15 */
#define MTU_MC30_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E7Eu)

/** \brief 1E80, Read Data and Bit Flip Register 16 */
#define MTU_MC30_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E80u)

/** \brief 1E82, Read Data and Bit Flip Register 17 */
#define MTU_MC30_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E82u)

/** \brief 1E84, Read Data and Bit Flip Register 18 */
#define MTU_MC30_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E84u)

/** \brief 1E86, Read Data and Bit Flip Register 19 */
#define MTU_MC30_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E86u)

/** \brief 1E88, Read Data and Bit Flip Register 20 */
#define MTU_MC30_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E88u)

/** \brief 1E8A, Read Data and Bit Flip Register 21 */
#define MTU_MC30_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E8Au)

/** \brief 1E8C, Read Data and Bit Flip Register 22 */
#define MTU_MC30_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E8Cu)

/** \brief 1E8E, Read Data and Bit Flip Register 23 */
#define MTU_MC30_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E8Eu)

/** \brief 1E90, Read Data and Bit Flip Register 24 */
#define MTU_MC30_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E90u)

/** \brief 1E92, Read Data and Bit Flip Register 25 */
#define MTU_MC30_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E92u)

/** \brief 1E94, Read Data and Bit Flip Register 26 */
#define MTU_MC30_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E94u)

/** \brief 1E96, Read Data and Bit Flip Register 27 */
#define MTU_MC30_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E96u)

/** \brief 1E98, Read Data and Bit Flip Register 28 */
#define MTU_MC30_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E98u)

/** \brief 1E9A, Read Data and Bit Flip Register 29 */
#define MTU_MC30_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E9Au)

/** \brief 1E9C, Read Data and Bit Flip Register 30 */
#define MTU_MC30_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E9Cu)

/** \brief 1E9E, Read Data and Bit Flip Register 31 */
#define MTU_MC30_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062E9Eu)

/** \brief 1EA0, Read Data and Bit Flip Register 32 */
#define MTU_MC30_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EA0u)

/** \brief 1EA2, Read Data and Bit Flip Register 33 */
#define MTU_MC30_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EA2u)

/** \brief 1EA4, Read Data and Bit Flip Register 34 */
#define MTU_MC30_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EA4u)

/** \brief 1EA6, Read Data and Bit Flip Register 35 */
#define MTU_MC30_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EA6u)

/** \brief 1EA8, Read Data and Bit Flip Register 36 */
#define MTU_MC30_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EA8u)

/** \brief 1EAA, Read Data and Bit Flip Register 37 */
#define MTU_MC30_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EAAu)

/** \brief 1EAC, Read Data and Bit Flip Register 38 */
#define MTU_MC30_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EACu)

/** \brief 1EAE, Read Data and Bit Flip Register 39 */
#define MTU_MC30_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EAEu)

/** \brief 1EB0, Read Data and Bit Flip Register 40 */
#define MTU_MC30_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EB0u)

/** \brief 1EB2, Read Data and Bit Flip Register 41 */
#define MTU_MC30_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EB2u)

/** \brief 1EB4, Read Data and Bit Flip Register 42 */
#define MTU_MC30_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EB4u)

/** \brief 1EB6, Read Data and Bit Flip Register 43 */
#define MTU_MC30_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EB6u)

/** \brief 1EB8, Read Data and Bit Flip Register 44 */
#define MTU_MC30_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EB8u)

/** \brief 1EBA, Read Data and Bit Flip Register 45 */
#define MTU_MC30_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EBAu)

/** \brief 1EBC, Read Data and Bit Flip Register 46 */
#define MTU_MC30_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EBCu)

/** \brief 1EBE, Read Data and Bit Flip Register 47 */
#define MTU_MC30_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EBEu)

/** \brief 1EC0, Read Data and Bit Flip Register 48 */
#define MTU_MC30_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EC0u)

/** \brief 1EC2, Read Data and Bit Flip Register 49 */
#define MTU_MC30_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EC2u)

/** \brief 1EC4, Read Data and Bit Flip Register 50 */
#define MTU_MC30_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EC4u)

/** \brief 1EC6, Read Data and Bit Flip Register 51 */
#define MTU_MC30_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EC6u)

/** \brief 1EC8, Read Data and Bit Flip Register 52 */
#define MTU_MC30_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EC8u)

/** \brief 1ECA, Read Data and Bit Flip Register 53 */
#define MTU_MC30_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ECAu)

/** \brief 1ECC, Read Data and Bit Flip Register 54 */
#define MTU_MC30_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ECCu)

/** \brief 1ECE, Read Data and Bit Flip Register 55 */
#define MTU_MC30_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ECEu)

/** \brief 1ED0, Read Data and Bit Flip Register 56 */
#define MTU_MC30_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ED0u)

/** \brief 1ED2, Read Data and Bit Flip Register 57 */
#define MTU_MC30_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ED2u)

/** \brief 1ED4, Read Data and Bit Flip Register 58 */
#define MTU_MC30_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ED4u)

/** \brief 1ED6, Read Data and Bit Flip Register 59 */
#define MTU_MC30_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ED6u)

/** \brief 1ED8, Read Data and Bit Flip Register 60 */
#define MTU_MC30_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062ED8u)

/** \brief 1EDA, Read Data and Bit Flip Register 61 */
#define MTU_MC30_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EDAu)

/** \brief 1EDC, Read Data and Bit Flip Register 62 */
#define MTU_MC30_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EDCu)

/** \brief 1EDE, Read Data and Bit Flip Register 63 */
#define MTU_MC30_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EDEu)

/** \brief 1EE0, Read Data and Bit Flip Register 64 */
#define MTU_MC30_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EE0u)

/** \brief 1EE2, Read Data and Bit Flip Register 65 */
#define MTU_MC30_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EE2u)

/** \brief 1EE4, Read Data and Bit Flip Register 66 */
#define MTU_MC30_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062EE4u)

/** \brief 1EEE, Alarm Sources Configuration Register */
#define MTU_MC30_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0062EEEu)

/** \brief 1EF0, SSH Safety Faults Status Register  */
#define MTU_MC30_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0062EF0u)

/** \brief 1EF2, Error Information Register 0 */
#define MTU_MC30_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062EF2u)

/** \brief 1EF4, Error Information Register 1 */
#define MTU_MC30_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062EF4u)

/** \brief 1EF6, Error Information Register 2 */
#define MTU_MC30_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062EF6u)

/** \brief 1EF8, Error Information Register 3 */
#define MTU_MC30_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062EF8u)

/** \brief 1EFA, Error Information Register 4 */
#define MTU_MC30_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062EFAu)

/** \brief 1F00, Configuration Registers */
#define MTU_MC31_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0062F00u)

/** \brief 1F02, Configuration Register 1 */
#define MTU_MC31_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0062F02u)

/** \brief 1F04, MBIST Control Register */
#define MTU_MC31_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0062F04u)

/** \brief 1F06, Status Register */
#define MTU_MC31_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0062F06u)

/** \brief 1F08, Range Register, single address mode */
#define MTU_MC31_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0062F08u)

/** \brief 1F0C, Revision ID Register */
#define MTU_MC31_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0062F0Cu)

/** \brief 1F0E, ECC Safety Register */
#define MTU_MC31_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0062F0Eu)

/** \brief 1F10, Memory ECC Detection Register */
#define MTU_MC31_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0062F10u)

/** \brief 1F12, Error Tracking Register 0 */
#define MTU_MC31_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062F12u)

/** \brief 1F14, Error Tracking Register 1 */
#define MTU_MC31_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062F14u)

/** \brief 1F16, Error Tracking Register 2 */
#define MTU_MC31_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062F16u)

/** \brief 1F18, Error Tracking Register 3 */
#define MTU_MC31_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062F18u)

/** \brief 1F1A, Error Tracking Register 4 */
#define MTU_MC31_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0062F1Au)

/** \brief 1F60, Read Data and Bit Flip Register 0 */
#define MTU_MC31_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F60u)

/** \brief 1F62, Read Data and Bit Flip Register 1 */
#define MTU_MC31_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F62u)

/** \brief 1F64, Read Data and Bit Flip Register 2 */
#define MTU_MC31_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F64u)

/** \brief 1F66, Read Data and Bit Flip Register 3 */
#define MTU_MC31_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F66u)

/** \brief 1F68, Read Data and Bit Flip Register 4 */
#define MTU_MC31_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F68u)

/** \brief 1F6A, Read Data and Bit Flip Register 5 */
#define MTU_MC31_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F6Au)

/** \brief 1F6C, Read Data and Bit Flip Register 6 */
#define MTU_MC31_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F6Cu)

/** \brief 1F6E, Read Data and Bit Flip Register 7 */
#define MTU_MC31_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F6Eu)

/** \brief 1F70, Read Data and Bit Flip Register 8 */
#define MTU_MC31_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F70u)

/** \brief 1F72, Read Data and Bit Flip Register 9 */
#define MTU_MC31_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F72u)

/** \brief 1F74, Read Data and Bit Flip Register 10 */
#define MTU_MC31_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F74u)

/** \brief 1F76, Read Data and Bit Flip Register 11 */
#define MTU_MC31_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F76u)

/** \brief 1F78, Read Data and Bit Flip Register 12 */
#define MTU_MC31_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F78u)

/** \brief 1F7A, Read Data and Bit Flip Register 13 */
#define MTU_MC31_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F7Au)

/** \brief 1F7C, Read Data and Bit Flip Register 14 */
#define MTU_MC31_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F7Cu)

/** \brief 1F7E, Read Data and Bit Flip Register 15 */
#define MTU_MC31_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F7Eu)

/** \brief 1F80, Read Data and Bit Flip Register 16 */
#define MTU_MC31_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F80u)

/** \brief 1F82, Read Data and Bit Flip Register 17 */
#define MTU_MC31_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F82u)

/** \brief 1F84, Read Data and Bit Flip Register 18 */
#define MTU_MC31_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F84u)

/** \brief 1F86, Read Data and Bit Flip Register 19 */
#define MTU_MC31_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F86u)

/** \brief 1F88, Read Data and Bit Flip Register 20 */
#define MTU_MC31_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F88u)

/** \brief 1F8A, Read Data and Bit Flip Register 21 */
#define MTU_MC31_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F8Au)

/** \brief 1F8C, Read Data and Bit Flip Register 22 */
#define MTU_MC31_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F8Cu)

/** \brief 1F8E, Read Data and Bit Flip Register 23 */
#define MTU_MC31_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F8Eu)

/** \brief 1F90, Read Data and Bit Flip Register 24 */
#define MTU_MC31_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F90u)

/** \brief 1F92, Read Data and Bit Flip Register 25 */
#define MTU_MC31_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F92u)

/** \brief 1F94, Read Data and Bit Flip Register 26 */
#define MTU_MC31_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F94u)

/** \brief 1F96, Read Data and Bit Flip Register 27 */
#define MTU_MC31_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F96u)

/** \brief 1F98, Read Data and Bit Flip Register 28 */
#define MTU_MC31_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F98u)

/** \brief 1F9A, Read Data and Bit Flip Register 29 */
#define MTU_MC31_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F9Au)

/** \brief 1F9C, Read Data and Bit Flip Register 30 */
#define MTU_MC31_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F9Cu)

/** \brief 1F9E, Read Data and Bit Flip Register 31 */
#define MTU_MC31_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062F9Eu)

/** \brief 1FA0, Read Data and Bit Flip Register 32 */
#define MTU_MC31_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FA0u)

/** \brief 1FA2, Read Data and Bit Flip Register 33 */
#define MTU_MC31_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FA2u)

/** \brief 1FA4, Read Data and Bit Flip Register 34 */
#define MTU_MC31_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FA4u)

/** \brief 1FA6, Read Data and Bit Flip Register 35 */
#define MTU_MC31_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FA6u)

/** \brief 1FA8, Read Data and Bit Flip Register 36 */
#define MTU_MC31_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FA8u)

/** \brief 1FAA, Read Data and Bit Flip Register 37 */
#define MTU_MC31_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FAAu)

/** \brief 1FAC, Read Data and Bit Flip Register 38 */
#define MTU_MC31_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FACu)

/** \brief 1FAE, Read Data and Bit Flip Register 39 */
#define MTU_MC31_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FAEu)

/** \brief 1FB0, Read Data and Bit Flip Register 40 */
#define MTU_MC31_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FB0u)

/** \brief 1FB2, Read Data and Bit Flip Register 41 */
#define MTU_MC31_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FB2u)

/** \brief 1FB4, Read Data and Bit Flip Register 42 */
#define MTU_MC31_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FB4u)

/** \brief 1FB6, Read Data and Bit Flip Register 43 */
#define MTU_MC31_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FB6u)

/** \brief 1FB8, Read Data and Bit Flip Register 44 */
#define MTU_MC31_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FB8u)

/** \brief 1FBA, Read Data and Bit Flip Register 45 */
#define MTU_MC31_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FBAu)

/** \brief 1FBC, Read Data and Bit Flip Register 46 */
#define MTU_MC31_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FBCu)

/** \brief 1FBE, Read Data and Bit Flip Register 47 */
#define MTU_MC31_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FBEu)

/** \brief 1FC0, Read Data and Bit Flip Register 48 */
#define MTU_MC31_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FC0u)

/** \brief 1FC2, Read Data and Bit Flip Register 49 */
#define MTU_MC31_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FC2u)

/** \brief 1FC4, Read Data and Bit Flip Register 50 */
#define MTU_MC31_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FC4u)

/** \brief 1FC6, Read Data and Bit Flip Register 51 */
#define MTU_MC31_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FC6u)

/** \brief 1FC8, Read Data and Bit Flip Register 52 */
#define MTU_MC31_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FC8u)

/** \brief 1FCA, Read Data and Bit Flip Register 53 */
#define MTU_MC31_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FCAu)

/** \brief 1FCC, Read Data and Bit Flip Register 54 */
#define MTU_MC31_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FCCu)

/** \brief 1FCE, Read Data and Bit Flip Register 55 */
#define MTU_MC31_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FCEu)

/** \brief 1FD0, Read Data and Bit Flip Register 56 */
#define MTU_MC31_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FD0u)

/** \brief 1FD2, Read Data and Bit Flip Register 57 */
#define MTU_MC31_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FD2u)

/** \brief 1FD4, Read Data and Bit Flip Register 58 */
#define MTU_MC31_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FD4u)

/** \brief 1FD6, Read Data and Bit Flip Register 59 */
#define MTU_MC31_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FD6u)

/** \brief 1FD8, Read Data and Bit Flip Register 60 */
#define MTU_MC31_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FD8u)

/** \brief 1FDA, Read Data and Bit Flip Register 61 */
#define MTU_MC31_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FDAu)

/** \brief 1FDC, Read Data and Bit Flip Register 62 */
#define MTU_MC31_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FDCu)

/** \brief 1FDE, Read Data and Bit Flip Register 63 */
#define MTU_MC31_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FDEu)

/** \brief 1FE0, Read Data and Bit Flip Register 64 */
#define MTU_MC31_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FE0u)

/** \brief 1FE2, Read Data and Bit Flip Register 65 */
#define MTU_MC31_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FE2u)

/** \brief 1FE4, Read Data and Bit Flip Register 66 */
#define MTU_MC31_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0062FE4u)

/** \brief 1FEE, Alarm Sources Configuration Register */
#define MTU_MC31_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0062FEEu)

/** \brief 1FF0, SSH Safety Faults Status Register  */
#define MTU_MC31_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0062FF0u)

/** \brief 1FF2, Error Information Register 0 */
#define MTU_MC31_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062FF2u)

/** \brief 1FF4, Error Information Register 1 */
#define MTU_MC31_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062FF4u)

/** \brief 1FF6, Error Information Register 2 */
#define MTU_MC31_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062FF6u)

/** \brief 1FF8, Error Information Register 3 */
#define MTU_MC31_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062FF8u)

/** \brief 1FFA, Error Information Register 4 */
#define MTU_MC31_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0062FFAu)

/** \brief 2000, Configuration Registers */
#define MTU_MC32_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063000u)

/** \brief 2002, Configuration Register 1 */
#define MTU_MC32_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063002u)

/** \brief 2004, MBIST Control Register */
#define MTU_MC32_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063004u)

/** \brief 2006, Status Register */
#define MTU_MC32_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063006u)

/** \brief 2008, Range Register, single address mode */
#define MTU_MC32_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063008u)

/** \brief 200C, Revision ID Register */
#define MTU_MC32_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006300Cu)

/** \brief 200E, ECC Safety Register */
#define MTU_MC32_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006300Eu)

/** \brief 2010, Memory ECC Detection Register */
#define MTU_MC32_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063010u)

/** \brief 2012, Error Tracking Register 0 */
#define MTU_MC32_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063012u)

/** \brief 2014, Error Tracking Register 1 */
#define MTU_MC32_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063014u)

/** \brief 2016, Error Tracking Register 2 */
#define MTU_MC32_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063016u)

/** \brief 2018, Error Tracking Register 3 */
#define MTU_MC32_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063018u)

/** \brief 201A, Error Tracking Register 4 */
#define MTU_MC32_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006301Au)

/** \brief 2060, Read Data and Bit Flip Register 0 */
#define MTU_MC32_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063060u)

/** \brief 2062, Read Data and Bit Flip Register 1 */
#define MTU_MC32_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063062u)

/** \brief 2064, Read Data and Bit Flip Register 2 */
#define MTU_MC32_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063064u)

/** \brief 2066, Read Data and Bit Flip Register 3 */
#define MTU_MC32_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063066u)

/** \brief 2068, Read Data and Bit Flip Register 4 */
#define MTU_MC32_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063068u)

/** \brief 206A, Read Data and Bit Flip Register 5 */
#define MTU_MC32_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006306Au)

/** \brief 206C, Read Data and Bit Flip Register 6 */
#define MTU_MC32_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006306Cu)

/** \brief 206E, Read Data and Bit Flip Register 7 */
#define MTU_MC32_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006306Eu)

/** \brief 2070, Read Data and Bit Flip Register 8 */
#define MTU_MC32_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063070u)

/** \brief 2072, Read Data and Bit Flip Register 9 */
#define MTU_MC32_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063072u)

/** \brief 2074, Read Data and Bit Flip Register 10 */
#define MTU_MC32_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063074u)

/** \brief 2076, Read Data and Bit Flip Register 11 */
#define MTU_MC32_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063076u)

/** \brief 2078, Read Data and Bit Flip Register 12 */
#define MTU_MC32_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063078u)

/** \brief 207A, Read Data and Bit Flip Register 13 */
#define MTU_MC32_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006307Au)

/** \brief 207C, Read Data and Bit Flip Register 14 */
#define MTU_MC32_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006307Cu)

/** \brief 207E, Read Data and Bit Flip Register 15 */
#define MTU_MC32_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006307Eu)

/** \brief 2080, Read Data and Bit Flip Register 16 */
#define MTU_MC32_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063080u)

/** \brief 2082, Read Data and Bit Flip Register 17 */
#define MTU_MC32_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063082u)

/** \brief 2084, Read Data and Bit Flip Register 18 */
#define MTU_MC32_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063084u)

/** \brief 2086, Read Data and Bit Flip Register 19 */
#define MTU_MC32_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063086u)

/** \brief 2088, Read Data and Bit Flip Register 20 */
#define MTU_MC32_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063088u)

/** \brief 208A, Read Data and Bit Flip Register 21 */
#define MTU_MC32_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006308Au)

/** \brief 208C, Read Data and Bit Flip Register 22 */
#define MTU_MC32_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006308Cu)

/** \brief 208E, Read Data and Bit Flip Register 23 */
#define MTU_MC32_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006308Eu)

/** \brief 2090, Read Data and Bit Flip Register 24 */
#define MTU_MC32_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063090u)

/** \brief 2092, Read Data and Bit Flip Register 25 */
#define MTU_MC32_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063092u)

/** \brief 2094, Read Data and Bit Flip Register 26 */
#define MTU_MC32_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063094u)

/** \brief 2096, Read Data and Bit Flip Register 27 */
#define MTU_MC32_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063096u)

/** \brief 2098, Read Data and Bit Flip Register 28 */
#define MTU_MC32_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063098u)

/** \brief 209A, Read Data and Bit Flip Register 29 */
#define MTU_MC32_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006309Au)

/** \brief 209C, Read Data and Bit Flip Register 30 */
#define MTU_MC32_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006309Cu)

/** \brief 209E, Read Data and Bit Flip Register 31 */
#define MTU_MC32_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006309Eu)

/** \brief 20A0, Read Data and Bit Flip Register 32 */
#define MTU_MC32_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630A0u)

/** \brief 20A2, Read Data and Bit Flip Register 33 */
#define MTU_MC32_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630A2u)

/** \brief 20A4, Read Data and Bit Flip Register 34 */
#define MTU_MC32_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630A4u)

/** \brief 20A6, Read Data and Bit Flip Register 35 */
#define MTU_MC32_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630A6u)

/** \brief 20A8, Read Data and Bit Flip Register 36 */
#define MTU_MC32_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630A8u)

/** \brief 20AA, Read Data and Bit Flip Register 37 */
#define MTU_MC32_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630AAu)

/** \brief 20AC, Read Data and Bit Flip Register 38 */
#define MTU_MC32_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630ACu)

/** \brief 20AE, Read Data and Bit Flip Register 39 */
#define MTU_MC32_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630AEu)

/** \brief 20B0, Read Data and Bit Flip Register 40 */
#define MTU_MC32_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630B0u)

/** \brief 20B2, Read Data and Bit Flip Register 41 */
#define MTU_MC32_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630B2u)

/** \brief 20B4, Read Data and Bit Flip Register 42 */
#define MTU_MC32_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630B4u)

/** \brief 20B6, Read Data and Bit Flip Register 43 */
#define MTU_MC32_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630B6u)

/** \brief 20B8, Read Data and Bit Flip Register 44 */
#define MTU_MC32_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630B8u)

/** \brief 20BA, Read Data and Bit Flip Register 45 */
#define MTU_MC32_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630BAu)

/** \brief 20BC, Read Data and Bit Flip Register 46 */
#define MTU_MC32_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630BCu)

/** \brief 20BE, Read Data and Bit Flip Register 47 */
#define MTU_MC32_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630BEu)

/** \brief 20C0, Read Data and Bit Flip Register 48 */
#define MTU_MC32_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630C0u)

/** \brief 20C2, Read Data and Bit Flip Register 49 */
#define MTU_MC32_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630C2u)

/** \brief 20C4, Read Data and Bit Flip Register 50 */
#define MTU_MC32_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630C4u)

/** \brief 20C6, Read Data and Bit Flip Register 51 */
#define MTU_MC32_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630C6u)

/** \brief 20C8, Read Data and Bit Flip Register 52 */
#define MTU_MC32_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630C8u)

/** \brief 20CA, Read Data and Bit Flip Register 53 */
#define MTU_MC32_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630CAu)

/** \brief 20CC, Read Data and Bit Flip Register 54 */
#define MTU_MC32_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630CCu)

/** \brief 20CE, Read Data and Bit Flip Register 55 */
#define MTU_MC32_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630CEu)

/** \brief 20D0, Read Data and Bit Flip Register 56 */
#define MTU_MC32_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630D0u)

/** \brief 20D2, Read Data and Bit Flip Register 57 */
#define MTU_MC32_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630D2u)

/** \brief 20D4, Read Data and Bit Flip Register 58 */
#define MTU_MC32_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630D4u)

/** \brief 20D6, Read Data and Bit Flip Register 59 */
#define MTU_MC32_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630D6u)

/** \brief 20D8, Read Data and Bit Flip Register 60 */
#define MTU_MC32_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630D8u)

/** \brief 20DA, Read Data and Bit Flip Register 61 */
#define MTU_MC32_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630DAu)

/** \brief 20DC, Read Data and Bit Flip Register 62 */
#define MTU_MC32_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630DCu)

/** \brief 20DE, Read Data and Bit Flip Register 63 */
#define MTU_MC32_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630DEu)

/** \brief 20E0, Read Data and Bit Flip Register 64 */
#define MTU_MC32_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630E0u)

/** \brief 20E2, Read Data and Bit Flip Register 65 */
#define MTU_MC32_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630E2u)

/** \brief 20E4, Read Data and Bit Flip Register 66 */
#define MTU_MC32_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00630E4u)

/** \brief 20EE, Alarm Sources Configuration Register */
#define MTU_MC32_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00630EEu)

/** \brief 20F0, SSH Safety Faults Status Register  */
#define MTU_MC32_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00630F0u)

/** \brief 20F2, Error Information Register 0 */
#define MTU_MC32_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00630F2u)

/** \brief 20F4, Error Information Register 1 */
#define MTU_MC32_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00630F4u)

/** \brief 20F6, Error Information Register 2 */
#define MTU_MC32_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00630F6u)

/** \brief 20F8, Error Information Register 3 */
#define MTU_MC32_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00630F8u)

/** \brief 20FA, Error Information Register 4 */
#define MTU_MC32_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00630FAu)

/** \brief 2100, Configuration Registers */
#define MTU_MC33_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063100u)

/** \brief 2102, Configuration Register 1 */
#define MTU_MC33_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063102u)

/** \brief 2104, MBIST Control Register */
#define MTU_MC33_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063104u)

/** \brief 2106, Status Register */
#define MTU_MC33_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063106u)

/** \brief 2108, Range Register, single address mode */
#define MTU_MC33_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063108u)

/** \brief 210C, Revision ID Register */
#define MTU_MC33_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006310Cu)

/** \brief 210E, ECC Safety Register */
#define MTU_MC33_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006310Eu)

/** \brief 2110, Memory ECC Detection Register */
#define MTU_MC33_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063110u)

/** \brief 2112, Error Tracking Register 0 */
#define MTU_MC33_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063112u)

/** \brief 2114, Error Tracking Register 1 */
#define MTU_MC33_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063114u)

/** \brief 2116, Error Tracking Register 2 */
#define MTU_MC33_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063116u)

/** \brief 2118, Error Tracking Register 3 */
#define MTU_MC33_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063118u)

/** \brief 211A, Error Tracking Register 4 */
#define MTU_MC33_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006311Au)

/** \brief 2160, Read Data and Bit Flip Register 0 */
#define MTU_MC33_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063160u)

/** \brief 2162, Read Data and Bit Flip Register 1 */
#define MTU_MC33_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063162u)

/** \brief 2164, Read Data and Bit Flip Register 2 */
#define MTU_MC33_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063164u)

/** \brief 2166, Read Data and Bit Flip Register 3 */
#define MTU_MC33_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063166u)

/** \brief 2168, Read Data and Bit Flip Register 4 */
#define MTU_MC33_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063168u)

/** \brief 216A, Read Data and Bit Flip Register 5 */
#define MTU_MC33_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006316Au)

/** \brief 216C, Read Data and Bit Flip Register 6 */
#define MTU_MC33_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006316Cu)

/** \brief 216E, Read Data and Bit Flip Register 7 */
#define MTU_MC33_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006316Eu)

/** \brief 2170, Read Data and Bit Flip Register 8 */
#define MTU_MC33_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063170u)

/** \brief 2172, Read Data and Bit Flip Register 9 */
#define MTU_MC33_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063172u)

/** \brief 2174, Read Data and Bit Flip Register 10 */
#define MTU_MC33_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063174u)

/** \brief 2176, Read Data and Bit Flip Register 11 */
#define MTU_MC33_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063176u)

/** \brief 2178, Read Data and Bit Flip Register 12 */
#define MTU_MC33_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063178u)

/** \brief 217A, Read Data and Bit Flip Register 13 */
#define MTU_MC33_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006317Au)

/** \brief 217C, Read Data and Bit Flip Register 14 */
#define MTU_MC33_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006317Cu)

/** \brief 217E, Read Data and Bit Flip Register 15 */
#define MTU_MC33_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006317Eu)

/** \brief 2180, Read Data and Bit Flip Register 16 */
#define MTU_MC33_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063180u)

/** \brief 2182, Read Data and Bit Flip Register 17 */
#define MTU_MC33_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063182u)

/** \brief 2184, Read Data and Bit Flip Register 18 */
#define MTU_MC33_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063184u)

/** \brief 2186, Read Data and Bit Flip Register 19 */
#define MTU_MC33_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063186u)

/** \brief 2188, Read Data and Bit Flip Register 20 */
#define MTU_MC33_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063188u)

/** \brief 218A, Read Data and Bit Flip Register 21 */
#define MTU_MC33_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006318Au)

/** \brief 218C, Read Data and Bit Flip Register 22 */
#define MTU_MC33_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006318Cu)

/** \brief 218E, Read Data and Bit Flip Register 23 */
#define MTU_MC33_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006318Eu)

/** \brief 2190, Read Data and Bit Flip Register 24 */
#define MTU_MC33_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063190u)

/** \brief 2192, Read Data and Bit Flip Register 25 */
#define MTU_MC33_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063192u)

/** \brief 2194, Read Data and Bit Flip Register 26 */
#define MTU_MC33_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063194u)

/** \brief 2196, Read Data and Bit Flip Register 27 */
#define MTU_MC33_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063196u)

/** \brief 2198, Read Data and Bit Flip Register 28 */
#define MTU_MC33_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063198u)

/** \brief 219A, Read Data and Bit Flip Register 29 */
#define MTU_MC33_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006319Au)

/** \brief 219C, Read Data and Bit Flip Register 30 */
#define MTU_MC33_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006319Cu)

/** \brief 219E, Read Data and Bit Flip Register 31 */
#define MTU_MC33_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006319Eu)

/** \brief 21A0, Read Data and Bit Flip Register 32 */
#define MTU_MC33_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631A0u)

/** \brief 21A2, Read Data and Bit Flip Register 33 */
#define MTU_MC33_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631A2u)

/** \brief 21A4, Read Data and Bit Flip Register 34 */
#define MTU_MC33_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631A4u)

/** \brief 21A6, Read Data and Bit Flip Register 35 */
#define MTU_MC33_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631A6u)

/** \brief 21A8, Read Data and Bit Flip Register 36 */
#define MTU_MC33_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631A8u)

/** \brief 21AA, Read Data and Bit Flip Register 37 */
#define MTU_MC33_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631AAu)

/** \brief 21AC, Read Data and Bit Flip Register 38 */
#define MTU_MC33_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631ACu)

/** \brief 21AE, Read Data and Bit Flip Register 39 */
#define MTU_MC33_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631AEu)

/** \brief 21B0, Read Data and Bit Flip Register 40 */
#define MTU_MC33_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631B0u)

/** \brief 21B2, Read Data and Bit Flip Register 41 */
#define MTU_MC33_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631B2u)

/** \brief 21B4, Read Data and Bit Flip Register 42 */
#define MTU_MC33_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631B4u)

/** \brief 21B6, Read Data and Bit Flip Register 43 */
#define MTU_MC33_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631B6u)

/** \brief 21B8, Read Data and Bit Flip Register 44 */
#define MTU_MC33_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631B8u)

/** \brief 21BA, Read Data and Bit Flip Register 45 */
#define MTU_MC33_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631BAu)

/** \brief 21BC, Read Data and Bit Flip Register 46 */
#define MTU_MC33_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631BCu)

/** \brief 21BE, Read Data and Bit Flip Register 47 */
#define MTU_MC33_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631BEu)

/** \brief 21C0, Read Data and Bit Flip Register 48 */
#define MTU_MC33_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631C0u)

/** \brief 21C2, Read Data and Bit Flip Register 49 */
#define MTU_MC33_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631C2u)

/** \brief 21C4, Read Data and Bit Flip Register 50 */
#define MTU_MC33_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631C4u)

/** \brief 21C6, Read Data and Bit Flip Register 51 */
#define MTU_MC33_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631C6u)

/** \brief 21C8, Read Data and Bit Flip Register 52 */
#define MTU_MC33_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631C8u)

/** \brief 21CA, Read Data and Bit Flip Register 53 */
#define MTU_MC33_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631CAu)

/** \brief 21CC, Read Data and Bit Flip Register 54 */
#define MTU_MC33_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631CCu)

/** \brief 21CE, Read Data and Bit Flip Register 55 */
#define MTU_MC33_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631CEu)

/** \brief 21D0, Read Data and Bit Flip Register 56 */
#define MTU_MC33_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631D0u)

/** \brief 21D2, Read Data and Bit Flip Register 57 */
#define MTU_MC33_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631D2u)

/** \brief 21D4, Read Data and Bit Flip Register 58 */
#define MTU_MC33_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631D4u)

/** \brief 21D6, Read Data and Bit Flip Register 59 */
#define MTU_MC33_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631D6u)

/** \brief 21D8, Read Data and Bit Flip Register 60 */
#define MTU_MC33_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631D8u)

/** \brief 21DA, Read Data and Bit Flip Register 61 */
#define MTU_MC33_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631DAu)

/** \brief 21DC, Read Data and Bit Flip Register 62 */
#define MTU_MC33_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631DCu)

/** \brief 21DE, Read Data and Bit Flip Register 63 */
#define MTU_MC33_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631DEu)

/** \brief 21E0, Read Data and Bit Flip Register 64 */
#define MTU_MC33_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631E0u)

/** \brief 21E2, Read Data and Bit Flip Register 65 */
#define MTU_MC33_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631E2u)

/** \brief 21E4, Read Data and Bit Flip Register 66 */
#define MTU_MC33_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00631E4u)

/** \brief 21EE, Alarm Sources Configuration Register */
#define MTU_MC33_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00631EEu)

/** \brief 21F0, SSH Safety Faults Status Register  */
#define MTU_MC33_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00631F0u)

/** \brief 21F2, Error Information Register 0 */
#define MTU_MC33_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00631F2u)

/** \brief 21F4, Error Information Register 1 */
#define MTU_MC33_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00631F4u)

/** \brief 21F6, Error Information Register 2 */
#define MTU_MC33_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00631F6u)

/** \brief 21F8, Error Information Register 3 */
#define MTU_MC33_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00631F8u)

/** \brief 21FA, Error Information Register 4 */
#define MTU_MC33_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00631FAu)

/** \brief 2200, Configuration Registers */
#define MTU_MC34_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063200u)

/** \brief 2202, Configuration Register 1 */
#define MTU_MC34_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063202u)

/** \brief 2204, MBIST Control Register */
#define MTU_MC34_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063204u)

/** \brief 2206, Status Register */
#define MTU_MC34_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063206u)

/** \brief 2208, Range Register, single address mode */
#define MTU_MC34_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063208u)

/** \brief 220C, Revision ID Register */
#define MTU_MC34_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006320Cu)

/** \brief 220E, ECC Safety Register */
#define MTU_MC34_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006320Eu)

/** \brief 2210, Memory ECC Detection Register */
#define MTU_MC34_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063210u)

/** \brief 2212, Error Tracking Register 0 */
#define MTU_MC34_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063212u)

/** \brief 2214, Error Tracking Register 1 */
#define MTU_MC34_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063214u)

/** \brief 2216, Error Tracking Register 2 */
#define MTU_MC34_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063216u)

/** \brief 2218, Error Tracking Register 3 */
#define MTU_MC34_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063218u)

/** \brief 221A, Error Tracking Register 4 */
#define MTU_MC34_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006321Au)

/** \brief 2260, Read Data and Bit Flip Register 0 */
#define MTU_MC34_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063260u)

/** \brief 2262, Read Data and Bit Flip Register 1 */
#define MTU_MC34_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063262u)

/** \brief 2264, Read Data and Bit Flip Register 2 */
#define MTU_MC34_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063264u)

/** \brief 2266, Read Data and Bit Flip Register 3 */
#define MTU_MC34_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063266u)

/** \brief 2268, Read Data and Bit Flip Register 4 */
#define MTU_MC34_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063268u)

/** \brief 226A, Read Data and Bit Flip Register 5 */
#define MTU_MC34_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006326Au)

/** \brief 226C, Read Data and Bit Flip Register 6 */
#define MTU_MC34_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006326Cu)

/** \brief 226E, Read Data and Bit Flip Register 7 */
#define MTU_MC34_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006326Eu)

/** \brief 2270, Read Data and Bit Flip Register 8 */
#define MTU_MC34_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063270u)

/** \brief 2272, Read Data and Bit Flip Register 9 */
#define MTU_MC34_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063272u)

/** \brief 2274, Read Data and Bit Flip Register 10 */
#define MTU_MC34_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063274u)

/** \brief 2276, Read Data and Bit Flip Register 11 */
#define MTU_MC34_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063276u)

/** \brief 2278, Read Data and Bit Flip Register 12 */
#define MTU_MC34_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063278u)

/** \brief 227A, Read Data and Bit Flip Register 13 */
#define MTU_MC34_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006327Au)

/** \brief 227C, Read Data and Bit Flip Register 14 */
#define MTU_MC34_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006327Cu)

/** \brief 227E, Read Data and Bit Flip Register 15 */
#define MTU_MC34_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006327Eu)

/** \brief 2280, Read Data and Bit Flip Register 16 */
#define MTU_MC34_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063280u)

/** \brief 2282, Read Data and Bit Flip Register 17 */
#define MTU_MC34_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063282u)

/** \brief 2284, Read Data and Bit Flip Register 18 */
#define MTU_MC34_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063284u)

/** \brief 2286, Read Data and Bit Flip Register 19 */
#define MTU_MC34_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063286u)

/** \brief 2288, Read Data and Bit Flip Register 20 */
#define MTU_MC34_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063288u)

/** \brief 228A, Read Data and Bit Flip Register 21 */
#define MTU_MC34_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006328Au)

/** \brief 228C, Read Data and Bit Flip Register 22 */
#define MTU_MC34_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006328Cu)

/** \brief 228E, Read Data and Bit Flip Register 23 */
#define MTU_MC34_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006328Eu)

/** \brief 2290, Read Data and Bit Flip Register 24 */
#define MTU_MC34_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063290u)

/** \brief 2292, Read Data and Bit Flip Register 25 */
#define MTU_MC34_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063292u)

/** \brief 2294, Read Data and Bit Flip Register 26 */
#define MTU_MC34_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063294u)

/** \brief 2296, Read Data and Bit Flip Register 27 */
#define MTU_MC34_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063296u)

/** \brief 2298, Read Data and Bit Flip Register 28 */
#define MTU_MC34_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063298u)

/** \brief 229A, Read Data and Bit Flip Register 29 */
#define MTU_MC34_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006329Au)

/** \brief 229C, Read Data and Bit Flip Register 30 */
#define MTU_MC34_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006329Cu)

/** \brief 229E, Read Data and Bit Flip Register 31 */
#define MTU_MC34_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006329Eu)

/** \brief 22A0, Read Data and Bit Flip Register 32 */
#define MTU_MC34_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632A0u)

/** \brief 22A2, Read Data and Bit Flip Register 33 */
#define MTU_MC34_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632A2u)

/** \brief 22A4, Read Data and Bit Flip Register 34 */
#define MTU_MC34_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632A4u)

/** \brief 22A6, Read Data and Bit Flip Register 35 */
#define MTU_MC34_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632A6u)

/** \brief 22A8, Read Data and Bit Flip Register 36 */
#define MTU_MC34_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632A8u)

/** \brief 22AA, Read Data and Bit Flip Register 37 */
#define MTU_MC34_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632AAu)

/** \brief 22AC, Read Data and Bit Flip Register 38 */
#define MTU_MC34_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632ACu)

/** \brief 22AE, Read Data and Bit Flip Register 39 */
#define MTU_MC34_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632AEu)

/** \brief 22B0, Read Data and Bit Flip Register 40 */
#define MTU_MC34_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632B0u)

/** \brief 22B2, Read Data and Bit Flip Register 41 */
#define MTU_MC34_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632B2u)

/** \brief 22B4, Read Data and Bit Flip Register 42 */
#define MTU_MC34_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632B4u)

/** \brief 22B6, Read Data and Bit Flip Register 43 */
#define MTU_MC34_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632B6u)

/** \brief 22B8, Read Data and Bit Flip Register 44 */
#define MTU_MC34_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632B8u)

/** \brief 22BA, Read Data and Bit Flip Register 45 */
#define MTU_MC34_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632BAu)

/** \brief 22BC, Read Data and Bit Flip Register 46 */
#define MTU_MC34_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632BCu)

/** \brief 22BE, Read Data and Bit Flip Register 47 */
#define MTU_MC34_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632BEu)

/** \brief 22C0, Read Data and Bit Flip Register 48 */
#define MTU_MC34_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632C0u)

/** \brief 22C2, Read Data and Bit Flip Register 49 */
#define MTU_MC34_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632C2u)

/** \brief 22C4, Read Data and Bit Flip Register 50 */
#define MTU_MC34_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632C4u)

/** \brief 22C6, Read Data and Bit Flip Register 51 */
#define MTU_MC34_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632C6u)

/** \brief 22C8, Read Data and Bit Flip Register 52 */
#define MTU_MC34_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632C8u)

/** \brief 22CA, Read Data and Bit Flip Register 53 */
#define MTU_MC34_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632CAu)

/** \brief 22CC, Read Data and Bit Flip Register 54 */
#define MTU_MC34_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632CCu)

/** \brief 22CE, Read Data and Bit Flip Register 55 */
#define MTU_MC34_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632CEu)

/** \brief 22D0, Read Data and Bit Flip Register 56 */
#define MTU_MC34_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632D0u)

/** \brief 22D2, Read Data and Bit Flip Register 57 */
#define MTU_MC34_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632D2u)

/** \brief 22D4, Read Data and Bit Flip Register 58 */
#define MTU_MC34_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632D4u)

/** \brief 22D6, Read Data and Bit Flip Register 59 */
#define MTU_MC34_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632D6u)

/** \brief 22D8, Read Data and Bit Flip Register 60 */
#define MTU_MC34_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632D8u)

/** \brief 22DA, Read Data and Bit Flip Register 61 */
#define MTU_MC34_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632DAu)

/** \brief 22DC, Read Data and Bit Flip Register 62 */
#define MTU_MC34_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632DCu)

/** \brief 22DE, Read Data and Bit Flip Register 63 */
#define MTU_MC34_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632DEu)

/** \brief 22E0, Read Data and Bit Flip Register 64 */
#define MTU_MC34_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632E0u)

/** \brief 22E2, Read Data and Bit Flip Register 65 */
#define MTU_MC34_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632E2u)

/** \brief 22E4, Read Data and Bit Flip Register 66 */
#define MTU_MC34_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00632E4u)

/** \brief 22EE, Alarm Sources Configuration Register */
#define MTU_MC34_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00632EEu)

/** \brief 22F0, SSH Safety Faults Status Register  */
#define MTU_MC34_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00632F0u)

/** \brief 22F2, Error Information Register 0 */
#define MTU_MC34_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00632F2u)

/** \brief 22F4, Error Information Register 1 */
#define MTU_MC34_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00632F4u)

/** \brief 22F6, Error Information Register 2 */
#define MTU_MC34_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00632F6u)

/** \brief 22F8, Error Information Register 3 */
#define MTU_MC34_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00632F8u)

/** \brief 22FA, Error Information Register 4 */
#define MTU_MC34_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00632FAu)

/** \brief 2300, Configuration Registers */
#define MTU_MC35_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063300u)

/** \brief 2302, Configuration Register 1 */
#define MTU_MC35_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063302u)

/** \brief 2304, MBIST Control Register */
#define MTU_MC35_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063304u)

/** \brief 2306, Status Register */
#define MTU_MC35_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063306u)

/** \brief 2308, Range Register, single address mode */
#define MTU_MC35_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063308u)

/** \brief 230C, Revision ID Register */
#define MTU_MC35_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006330Cu)

/** \brief 230E, ECC Safety Register */
#define MTU_MC35_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006330Eu)

/** \brief 2310, Memory ECC Detection Register */
#define MTU_MC35_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063310u)

/** \brief 2312, Error Tracking Register 0 */
#define MTU_MC35_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063312u)

/** \brief 2314, Error Tracking Register 1 */
#define MTU_MC35_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063314u)

/** \brief 2316, Error Tracking Register 2 */
#define MTU_MC35_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063316u)

/** \brief 2318, Error Tracking Register 3 */
#define MTU_MC35_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063318u)

/** \brief 231A, Error Tracking Register 4 */
#define MTU_MC35_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006331Au)

/** \brief 2360, Read Data and Bit Flip Register 0 */
#define MTU_MC35_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063360u)

/** \brief 2362, Read Data and Bit Flip Register 1 */
#define MTU_MC35_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063362u)

/** \brief 2364, Read Data and Bit Flip Register 2 */
#define MTU_MC35_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063364u)

/** \brief 2366, Read Data and Bit Flip Register 3 */
#define MTU_MC35_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063366u)

/** \brief 2368, Read Data and Bit Flip Register 4 */
#define MTU_MC35_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063368u)

/** \brief 236A, Read Data and Bit Flip Register 5 */
#define MTU_MC35_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006336Au)

/** \brief 236C, Read Data and Bit Flip Register 6 */
#define MTU_MC35_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006336Cu)

/** \brief 236E, Read Data and Bit Flip Register 7 */
#define MTU_MC35_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006336Eu)

/** \brief 2370, Read Data and Bit Flip Register 8 */
#define MTU_MC35_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063370u)

/** \brief 2372, Read Data and Bit Flip Register 9 */
#define MTU_MC35_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063372u)

/** \brief 2374, Read Data and Bit Flip Register 10 */
#define MTU_MC35_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063374u)

/** \brief 2376, Read Data and Bit Flip Register 11 */
#define MTU_MC35_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063376u)

/** \brief 2378, Read Data and Bit Flip Register 12 */
#define MTU_MC35_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063378u)

/** \brief 237A, Read Data and Bit Flip Register 13 */
#define MTU_MC35_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006337Au)

/** \brief 237C, Read Data and Bit Flip Register 14 */
#define MTU_MC35_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006337Cu)

/** \brief 237E, Read Data and Bit Flip Register 15 */
#define MTU_MC35_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006337Eu)

/** \brief 2380, Read Data and Bit Flip Register 16 */
#define MTU_MC35_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063380u)

/** \brief 2382, Read Data and Bit Flip Register 17 */
#define MTU_MC35_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063382u)

/** \brief 2384, Read Data and Bit Flip Register 18 */
#define MTU_MC35_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063384u)

/** \brief 2386, Read Data and Bit Flip Register 19 */
#define MTU_MC35_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063386u)

/** \brief 2388, Read Data and Bit Flip Register 20 */
#define MTU_MC35_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063388u)

/** \brief 238A, Read Data and Bit Flip Register 21 */
#define MTU_MC35_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006338Au)

/** \brief 238C, Read Data and Bit Flip Register 22 */
#define MTU_MC35_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006338Cu)

/** \brief 238E, Read Data and Bit Flip Register 23 */
#define MTU_MC35_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006338Eu)

/** \brief 2390, Read Data and Bit Flip Register 24 */
#define MTU_MC35_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063390u)

/** \brief 2392, Read Data and Bit Flip Register 25 */
#define MTU_MC35_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063392u)

/** \brief 2394, Read Data and Bit Flip Register 26 */
#define MTU_MC35_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063394u)

/** \brief 2396, Read Data and Bit Flip Register 27 */
#define MTU_MC35_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063396u)

/** \brief 2398, Read Data and Bit Flip Register 28 */
#define MTU_MC35_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063398u)

/** \brief 239A, Read Data and Bit Flip Register 29 */
#define MTU_MC35_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006339Au)

/** \brief 239C, Read Data and Bit Flip Register 30 */
#define MTU_MC35_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006339Cu)

/** \brief 239E, Read Data and Bit Flip Register 31 */
#define MTU_MC35_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006339Eu)

/** \brief 23A0, Read Data and Bit Flip Register 32 */
#define MTU_MC35_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633A0u)

/** \brief 23A2, Read Data and Bit Flip Register 33 */
#define MTU_MC35_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633A2u)

/** \brief 23A4, Read Data and Bit Flip Register 34 */
#define MTU_MC35_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633A4u)

/** \brief 23A6, Read Data and Bit Flip Register 35 */
#define MTU_MC35_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633A6u)

/** \brief 23A8, Read Data and Bit Flip Register 36 */
#define MTU_MC35_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633A8u)

/** \brief 23AA, Read Data and Bit Flip Register 37 */
#define MTU_MC35_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633AAu)

/** \brief 23AC, Read Data and Bit Flip Register 38 */
#define MTU_MC35_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633ACu)

/** \brief 23AE, Read Data and Bit Flip Register 39 */
#define MTU_MC35_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633AEu)

/** \brief 23B0, Read Data and Bit Flip Register 40 */
#define MTU_MC35_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633B0u)

/** \brief 23B2, Read Data and Bit Flip Register 41 */
#define MTU_MC35_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633B2u)

/** \brief 23B4, Read Data and Bit Flip Register 42 */
#define MTU_MC35_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633B4u)

/** \brief 23B6, Read Data and Bit Flip Register 43 */
#define MTU_MC35_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633B6u)

/** \brief 23B8, Read Data and Bit Flip Register 44 */
#define MTU_MC35_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633B8u)

/** \brief 23BA, Read Data and Bit Flip Register 45 */
#define MTU_MC35_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633BAu)

/** \brief 23BC, Read Data and Bit Flip Register 46 */
#define MTU_MC35_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633BCu)

/** \brief 23BE, Read Data and Bit Flip Register 47 */
#define MTU_MC35_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633BEu)

/** \brief 23C0, Read Data and Bit Flip Register 48 */
#define MTU_MC35_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633C0u)

/** \brief 23C2, Read Data and Bit Flip Register 49 */
#define MTU_MC35_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633C2u)

/** \brief 23C4, Read Data and Bit Flip Register 50 */
#define MTU_MC35_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633C4u)

/** \brief 23C6, Read Data and Bit Flip Register 51 */
#define MTU_MC35_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633C6u)

/** \brief 23C8, Read Data and Bit Flip Register 52 */
#define MTU_MC35_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633C8u)

/** \brief 23CA, Read Data and Bit Flip Register 53 */
#define MTU_MC35_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633CAu)

/** \brief 23CC, Read Data and Bit Flip Register 54 */
#define MTU_MC35_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633CCu)

/** \brief 23CE, Read Data and Bit Flip Register 55 */
#define MTU_MC35_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633CEu)

/** \brief 23D0, Read Data and Bit Flip Register 56 */
#define MTU_MC35_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633D0u)

/** \brief 23D2, Read Data and Bit Flip Register 57 */
#define MTU_MC35_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633D2u)

/** \brief 23D4, Read Data and Bit Flip Register 58 */
#define MTU_MC35_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633D4u)

/** \brief 23D6, Read Data and Bit Flip Register 59 */
#define MTU_MC35_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633D6u)

/** \brief 23D8, Read Data and Bit Flip Register 60 */
#define MTU_MC35_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633D8u)

/** \brief 23DA, Read Data and Bit Flip Register 61 */
#define MTU_MC35_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633DAu)

/** \brief 23DC, Read Data and Bit Flip Register 62 */
#define MTU_MC35_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633DCu)

/** \brief 23DE, Read Data and Bit Flip Register 63 */
#define MTU_MC35_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633DEu)

/** \brief 23E0, Read Data and Bit Flip Register 64 */
#define MTU_MC35_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633E0u)

/** \brief 23E2, Read Data and Bit Flip Register 65 */
#define MTU_MC35_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633E2u)

/** \brief 23E4, Read Data and Bit Flip Register 66 */
#define MTU_MC35_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00633E4u)

/** \brief 23EE, Alarm Sources Configuration Register */
#define MTU_MC35_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00633EEu)

/** \brief 23F0, SSH Safety Faults Status Register  */
#define MTU_MC35_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00633F0u)

/** \brief 23F2, Error Information Register 0 */
#define MTU_MC35_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00633F2u)

/** \brief 23F4, Error Information Register 1 */
#define MTU_MC35_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00633F4u)

/** \brief 23F6, Error Information Register 2 */
#define MTU_MC35_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00633F6u)

/** \brief 23F8, Error Information Register 3 */
#define MTU_MC35_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00633F8u)

/** \brief 23FA, Error Information Register 4 */
#define MTU_MC35_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00633FAu)

/** \brief 2400, Configuration Registers */
#define MTU_MC36_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063400u)

/** \brief 2402, Configuration Register 1 */
#define MTU_MC36_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063402u)

/** \brief 2404, MBIST Control Register */
#define MTU_MC36_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063404u)

/** \brief 2406, Status Register */
#define MTU_MC36_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063406u)

/** \brief 2408, Range Register, single address mode */
#define MTU_MC36_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063408u)

/** \brief 240C, Revision ID Register */
#define MTU_MC36_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006340Cu)

/** \brief 240E, ECC Safety Register */
#define MTU_MC36_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006340Eu)

/** \brief 2410, Memory ECC Detection Register */
#define MTU_MC36_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063410u)

/** \brief 2412, Error Tracking Register 0 */
#define MTU_MC36_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063412u)

/** \brief 2414, Error Tracking Register 1 */
#define MTU_MC36_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063414u)

/** \brief 2416, Error Tracking Register 2 */
#define MTU_MC36_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063416u)

/** \brief 2418, Error Tracking Register 3 */
#define MTU_MC36_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063418u)

/** \brief 241A, Error Tracking Register 4 */
#define MTU_MC36_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006341Au)

/** \brief 2460, Read Data and Bit Flip Register 0 */
#define MTU_MC36_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063460u)

/** \brief 2462, Read Data and Bit Flip Register 1 */
#define MTU_MC36_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063462u)

/** \brief 2464, Read Data and Bit Flip Register 2 */
#define MTU_MC36_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063464u)

/** \brief 2466, Read Data and Bit Flip Register 3 */
#define MTU_MC36_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063466u)

/** \brief 2468, Read Data and Bit Flip Register 4 */
#define MTU_MC36_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063468u)

/** \brief 246A, Read Data and Bit Flip Register 5 */
#define MTU_MC36_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006346Au)

/** \brief 246C, Read Data and Bit Flip Register 6 */
#define MTU_MC36_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006346Cu)

/** \brief 246E, Read Data and Bit Flip Register 7 */
#define MTU_MC36_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006346Eu)

/** \brief 2470, Read Data and Bit Flip Register 8 */
#define MTU_MC36_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063470u)

/** \brief 2472, Read Data and Bit Flip Register 9 */
#define MTU_MC36_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063472u)

/** \brief 2474, Read Data and Bit Flip Register 10 */
#define MTU_MC36_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063474u)

/** \brief 2476, Read Data and Bit Flip Register 11 */
#define MTU_MC36_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063476u)

/** \brief 2478, Read Data and Bit Flip Register 12 */
#define MTU_MC36_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063478u)

/** \brief 247A, Read Data and Bit Flip Register 13 */
#define MTU_MC36_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006347Au)

/** \brief 247C, Read Data and Bit Flip Register 14 */
#define MTU_MC36_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006347Cu)

/** \brief 247E, Read Data and Bit Flip Register 15 */
#define MTU_MC36_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006347Eu)

/** \brief 2480, Read Data and Bit Flip Register 16 */
#define MTU_MC36_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063480u)

/** \brief 2482, Read Data and Bit Flip Register 17 */
#define MTU_MC36_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063482u)

/** \brief 2484, Read Data and Bit Flip Register 18 */
#define MTU_MC36_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063484u)

/** \brief 2486, Read Data and Bit Flip Register 19 */
#define MTU_MC36_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063486u)

/** \brief 2488, Read Data and Bit Flip Register 20 */
#define MTU_MC36_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063488u)

/** \brief 248A, Read Data and Bit Flip Register 21 */
#define MTU_MC36_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006348Au)

/** \brief 248C, Read Data and Bit Flip Register 22 */
#define MTU_MC36_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006348Cu)

/** \brief 248E, Read Data and Bit Flip Register 23 */
#define MTU_MC36_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006348Eu)

/** \brief 2490, Read Data and Bit Flip Register 24 */
#define MTU_MC36_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063490u)

/** \brief 2492, Read Data and Bit Flip Register 25 */
#define MTU_MC36_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063492u)

/** \brief 2494, Read Data and Bit Flip Register 26 */
#define MTU_MC36_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063494u)

/** \brief 2496, Read Data and Bit Flip Register 27 */
#define MTU_MC36_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063496u)

/** \brief 2498, Read Data and Bit Flip Register 28 */
#define MTU_MC36_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063498u)

/** \brief 249A, Read Data and Bit Flip Register 29 */
#define MTU_MC36_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006349Au)

/** \brief 249C, Read Data and Bit Flip Register 30 */
#define MTU_MC36_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006349Cu)

/** \brief 249E, Read Data and Bit Flip Register 31 */
#define MTU_MC36_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006349Eu)

/** \brief 24A0, Read Data and Bit Flip Register 32 */
#define MTU_MC36_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634A0u)

/** \brief 24A2, Read Data and Bit Flip Register 33 */
#define MTU_MC36_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634A2u)

/** \brief 24A4, Read Data and Bit Flip Register 34 */
#define MTU_MC36_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634A4u)

/** \brief 24A6, Read Data and Bit Flip Register 35 */
#define MTU_MC36_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634A6u)

/** \brief 24A8, Read Data and Bit Flip Register 36 */
#define MTU_MC36_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634A8u)

/** \brief 24AA, Read Data and Bit Flip Register 37 */
#define MTU_MC36_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634AAu)

/** \brief 24AC, Read Data and Bit Flip Register 38 */
#define MTU_MC36_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634ACu)

/** \brief 24AE, Read Data and Bit Flip Register 39 */
#define MTU_MC36_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634AEu)

/** \brief 24B0, Read Data and Bit Flip Register 40 */
#define MTU_MC36_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634B0u)

/** \brief 24B2, Read Data and Bit Flip Register 41 */
#define MTU_MC36_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634B2u)

/** \brief 24B4, Read Data and Bit Flip Register 42 */
#define MTU_MC36_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634B4u)

/** \brief 24B6, Read Data and Bit Flip Register 43 */
#define MTU_MC36_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634B6u)

/** \brief 24B8, Read Data and Bit Flip Register 44 */
#define MTU_MC36_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634B8u)

/** \brief 24BA, Read Data and Bit Flip Register 45 */
#define MTU_MC36_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634BAu)

/** \brief 24BC, Read Data and Bit Flip Register 46 */
#define MTU_MC36_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634BCu)

/** \brief 24BE, Read Data and Bit Flip Register 47 */
#define MTU_MC36_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634BEu)

/** \brief 24C0, Read Data and Bit Flip Register 48 */
#define MTU_MC36_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634C0u)

/** \brief 24C2, Read Data and Bit Flip Register 49 */
#define MTU_MC36_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634C2u)

/** \brief 24C4, Read Data and Bit Flip Register 50 */
#define MTU_MC36_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634C4u)

/** \brief 24C6, Read Data and Bit Flip Register 51 */
#define MTU_MC36_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634C6u)

/** \brief 24C8, Read Data and Bit Flip Register 52 */
#define MTU_MC36_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634C8u)

/** \brief 24CA, Read Data and Bit Flip Register 53 */
#define MTU_MC36_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634CAu)

/** \brief 24CC, Read Data and Bit Flip Register 54 */
#define MTU_MC36_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634CCu)

/** \brief 24CE, Read Data and Bit Flip Register 55 */
#define MTU_MC36_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634CEu)

/** \brief 24D0, Read Data and Bit Flip Register 56 */
#define MTU_MC36_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634D0u)

/** \brief 24D2, Read Data and Bit Flip Register 57 */
#define MTU_MC36_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634D2u)

/** \brief 24D4, Read Data and Bit Flip Register 58 */
#define MTU_MC36_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634D4u)

/** \brief 24D6, Read Data and Bit Flip Register 59 */
#define MTU_MC36_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634D6u)

/** \brief 24D8, Read Data and Bit Flip Register 60 */
#define MTU_MC36_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634D8u)

/** \brief 24DA, Read Data and Bit Flip Register 61 */
#define MTU_MC36_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634DAu)

/** \brief 24DC, Read Data and Bit Flip Register 62 */
#define MTU_MC36_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634DCu)

/** \brief 24DE, Read Data and Bit Flip Register 63 */
#define MTU_MC36_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634DEu)

/** \brief 24E0, Read Data and Bit Flip Register 64 */
#define MTU_MC36_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634E0u)

/** \brief 24E2, Read Data and Bit Flip Register 65 */
#define MTU_MC36_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634E2u)

/** \brief 24E4, Read Data and Bit Flip Register 66 */
#define MTU_MC36_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00634E4u)

/** \brief 24EE, Alarm Sources Configuration Register */
#define MTU_MC36_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00634EEu)

/** \brief 24F0, SSH Safety Faults Status Register  */
#define MTU_MC36_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00634F0u)

/** \brief 24F2, Error Information Register 0 */
#define MTU_MC36_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00634F2u)

/** \brief 24F4, Error Information Register 1 */
#define MTU_MC36_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00634F4u)

/** \brief 24F6, Error Information Register 2 */
#define MTU_MC36_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00634F6u)

/** \brief 24F8, Error Information Register 3 */
#define MTU_MC36_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00634F8u)

/** \brief 24FA, Error Information Register 4 */
#define MTU_MC36_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00634FAu)

/** \brief 2500, Configuration Registers */
#define MTU_MC37_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063500u)

/** \brief 2502, Configuration Register 1 */
#define MTU_MC37_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063502u)

/** \brief 2504, MBIST Control Register */
#define MTU_MC37_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063504u)

/** \brief 2506, Status Register */
#define MTU_MC37_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063506u)

/** \brief 2508, Range Register, single address mode */
#define MTU_MC37_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063508u)

/** \brief 250C, Revision ID Register */
#define MTU_MC37_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006350Cu)

/** \brief 250E, ECC Safety Register */
#define MTU_MC37_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006350Eu)

/** \brief 2510, Memory ECC Detection Register */
#define MTU_MC37_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063510u)

/** \brief 2512, Error Tracking Register 0 */
#define MTU_MC37_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063512u)

/** \brief 2514, Error Tracking Register 1 */
#define MTU_MC37_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063514u)

/** \brief 2516, Error Tracking Register 2 */
#define MTU_MC37_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063516u)

/** \brief 2518, Error Tracking Register 3 */
#define MTU_MC37_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063518u)

/** \brief 251A, Error Tracking Register 4 */
#define MTU_MC37_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006351Au)

/** \brief 2560, Read Data and Bit Flip Register 0 */
#define MTU_MC37_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063560u)

/** \brief 2562, Read Data and Bit Flip Register 1 */
#define MTU_MC37_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063562u)

/** \brief 2564, Read Data and Bit Flip Register 2 */
#define MTU_MC37_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063564u)

/** \brief 2566, Read Data and Bit Flip Register 3 */
#define MTU_MC37_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063566u)

/** \brief 2568, Read Data and Bit Flip Register 4 */
#define MTU_MC37_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063568u)

/** \brief 256A, Read Data and Bit Flip Register 5 */
#define MTU_MC37_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006356Au)

/** \brief 256C, Read Data and Bit Flip Register 6 */
#define MTU_MC37_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006356Cu)

/** \brief 256E, Read Data and Bit Flip Register 7 */
#define MTU_MC37_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006356Eu)

/** \brief 2570, Read Data and Bit Flip Register 8 */
#define MTU_MC37_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063570u)

/** \brief 2572, Read Data and Bit Flip Register 9 */
#define MTU_MC37_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063572u)

/** \brief 2574, Read Data and Bit Flip Register 10 */
#define MTU_MC37_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063574u)

/** \brief 2576, Read Data and Bit Flip Register 11 */
#define MTU_MC37_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063576u)

/** \brief 2578, Read Data and Bit Flip Register 12 */
#define MTU_MC37_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063578u)

/** \brief 257A, Read Data and Bit Flip Register 13 */
#define MTU_MC37_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006357Au)

/** \brief 257C, Read Data and Bit Flip Register 14 */
#define MTU_MC37_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006357Cu)

/** \brief 257E, Read Data and Bit Flip Register 15 */
#define MTU_MC37_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006357Eu)

/** \brief 2580, Read Data and Bit Flip Register 16 */
#define MTU_MC37_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063580u)

/** \brief 2582, Read Data and Bit Flip Register 17 */
#define MTU_MC37_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063582u)

/** \brief 2584, Read Data and Bit Flip Register 18 */
#define MTU_MC37_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063584u)

/** \brief 2586, Read Data and Bit Flip Register 19 */
#define MTU_MC37_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063586u)

/** \brief 2588, Read Data and Bit Flip Register 20 */
#define MTU_MC37_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063588u)

/** \brief 258A, Read Data and Bit Flip Register 21 */
#define MTU_MC37_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006358Au)

/** \brief 258C, Read Data and Bit Flip Register 22 */
#define MTU_MC37_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006358Cu)

/** \brief 258E, Read Data and Bit Flip Register 23 */
#define MTU_MC37_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006358Eu)

/** \brief 2590, Read Data and Bit Flip Register 24 */
#define MTU_MC37_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063590u)

/** \brief 2592, Read Data and Bit Flip Register 25 */
#define MTU_MC37_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063592u)

/** \brief 2594, Read Data and Bit Flip Register 26 */
#define MTU_MC37_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063594u)

/** \brief 2596, Read Data and Bit Flip Register 27 */
#define MTU_MC37_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063596u)

/** \brief 2598, Read Data and Bit Flip Register 28 */
#define MTU_MC37_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063598u)

/** \brief 259A, Read Data and Bit Flip Register 29 */
#define MTU_MC37_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006359Au)

/** \brief 259C, Read Data and Bit Flip Register 30 */
#define MTU_MC37_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006359Cu)

/** \brief 259E, Read Data and Bit Flip Register 31 */
#define MTU_MC37_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006359Eu)

/** \brief 25A0, Read Data and Bit Flip Register 32 */
#define MTU_MC37_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635A0u)

/** \brief 25A2, Read Data and Bit Flip Register 33 */
#define MTU_MC37_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635A2u)

/** \brief 25A4, Read Data and Bit Flip Register 34 */
#define MTU_MC37_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635A4u)

/** \brief 25A6, Read Data and Bit Flip Register 35 */
#define MTU_MC37_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635A6u)

/** \brief 25A8, Read Data and Bit Flip Register 36 */
#define MTU_MC37_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635A8u)

/** \brief 25AA, Read Data and Bit Flip Register 37 */
#define MTU_MC37_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635AAu)

/** \brief 25AC, Read Data and Bit Flip Register 38 */
#define MTU_MC37_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635ACu)

/** \brief 25AE, Read Data and Bit Flip Register 39 */
#define MTU_MC37_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635AEu)

/** \brief 25B0, Read Data and Bit Flip Register 40 */
#define MTU_MC37_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635B0u)

/** \brief 25B2, Read Data and Bit Flip Register 41 */
#define MTU_MC37_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635B2u)

/** \brief 25B4, Read Data and Bit Flip Register 42 */
#define MTU_MC37_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635B4u)

/** \brief 25B6, Read Data and Bit Flip Register 43 */
#define MTU_MC37_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635B6u)

/** \brief 25B8, Read Data and Bit Flip Register 44 */
#define MTU_MC37_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635B8u)

/** \brief 25BA, Read Data and Bit Flip Register 45 */
#define MTU_MC37_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635BAu)

/** \brief 25BC, Read Data and Bit Flip Register 46 */
#define MTU_MC37_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635BCu)

/** \brief 25BE, Read Data and Bit Flip Register 47 */
#define MTU_MC37_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635BEu)

/** \brief 25C0, Read Data and Bit Flip Register 48 */
#define MTU_MC37_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635C0u)

/** \brief 25C2, Read Data and Bit Flip Register 49 */
#define MTU_MC37_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635C2u)

/** \brief 25C4, Read Data and Bit Flip Register 50 */
#define MTU_MC37_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635C4u)

/** \brief 25C6, Read Data and Bit Flip Register 51 */
#define MTU_MC37_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635C6u)

/** \brief 25C8, Read Data and Bit Flip Register 52 */
#define MTU_MC37_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635C8u)

/** \brief 25CA, Read Data and Bit Flip Register 53 */
#define MTU_MC37_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635CAu)

/** \brief 25CC, Read Data and Bit Flip Register 54 */
#define MTU_MC37_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635CCu)

/** \brief 25CE, Read Data and Bit Flip Register 55 */
#define MTU_MC37_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635CEu)

/** \brief 25D0, Read Data and Bit Flip Register 56 */
#define MTU_MC37_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635D0u)

/** \brief 25D2, Read Data and Bit Flip Register 57 */
#define MTU_MC37_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635D2u)

/** \brief 25D4, Read Data and Bit Flip Register 58 */
#define MTU_MC37_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635D4u)

/** \brief 25D6, Read Data and Bit Flip Register 59 */
#define MTU_MC37_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635D6u)

/** \brief 25D8, Read Data and Bit Flip Register 60 */
#define MTU_MC37_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635D8u)

/** \brief 25DA, Read Data and Bit Flip Register 61 */
#define MTU_MC37_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635DAu)

/** \brief 25DC, Read Data and Bit Flip Register 62 */
#define MTU_MC37_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635DCu)

/** \brief 25DE, Read Data and Bit Flip Register 63 */
#define MTU_MC37_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635DEu)

/** \brief 25E0, Read Data and Bit Flip Register 64 */
#define MTU_MC37_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635E0u)

/** \brief 25E2, Read Data and Bit Flip Register 65 */
#define MTU_MC37_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635E2u)

/** \brief 25E4, Read Data and Bit Flip Register 66 */
#define MTU_MC37_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00635E4u)

/** \brief 25EE, Alarm Sources Configuration Register */
#define MTU_MC37_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00635EEu)

/** \brief 25F0, SSH Safety Faults Status Register  */
#define MTU_MC37_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00635F0u)

/** \brief 25F2, Error Information Register 0 */
#define MTU_MC37_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00635F2u)

/** \brief 25F4, Error Information Register 1 */
#define MTU_MC37_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00635F4u)

/** \brief 25F6, Error Information Register 2 */
#define MTU_MC37_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00635F6u)

/** \brief 25F8, Error Information Register 3 */
#define MTU_MC37_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00635F8u)

/** \brief 25FA, Error Information Register 4 */
#define MTU_MC37_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00635FAu)

/** \brief 2600, Configuration Registers */
#define MTU_MC38_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063600u)

/** \brief 2602, Configuration Register 1 */
#define MTU_MC38_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063602u)

/** \brief 2604, MBIST Control Register */
#define MTU_MC38_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063604u)

/** \brief 2606, Status Register */
#define MTU_MC38_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063606u)

/** \brief 2608, Range Register, single address mode */
#define MTU_MC38_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063608u)

/** \brief 260C, Revision ID Register */
#define MTU_MC38_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006360Cu)

/** \brief 260E, ECC Safety Register */
#define MTU_MC38_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006360Eu)

/** \brief 2610, Memory ECC Detection Register */
#define MTU_MC38_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063610u)

/** \brief 2612, Error Tracking Register 0 */
#define MTU_MC38_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063612u)

/** \brief 2614, Error Tracking Register 1 */
#define MTU_MC38_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063614u)

/** \brief 2616, Error Tracking Register 2 */
#define MTU_MC38_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063616u)

/** \brief 2618, Error Tracking Register 3 */
#define MTU_MC38_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063618u)

/** \brief 261A, Error Tracking Register 4 */
#define MTU_MC38_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006361Au)

/** \brief 2660, Read Data and Bit Flip Register 0 */
#define MTU_MC38_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063660u)

/** \brief 2662, Read Data and Bit Flip Register 1 */
#define MTU_MC38_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063662u)

/** \brief 2664, Read Data and Bit Flip Register 2 */
#define MTU_MC38_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063664u)

/** \brief 2666, Read Data and Bit Flip Register 3 */
#define MTU_MC38_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063666u)

/** \brief 2668, Read Data and Bit Flip Register 4 */
#define MTU_MC38_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063668u)

/** \brief 266A, Read Data and Bit Flip Register 5 */
#define MTU_MC38_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006366Au)

/** \brief 266C, Read Data and Bit Flip Register 6 */
#define MTU_MC38_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006366Cu)

/** \brief 266E, Read Data and Bit Flip Register 7 */
#define MTU_MC38_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006366Eu)

/** \brief 2670, Read Data and Bit Flip Register 8 */
#define MTU_MC38_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063670u)

/** \brief 2672, Read Data and Bit Flip Register 9 */
#define MTU_MC38_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063672u)

/** \brief 2674, Read Data and Bit Flip Register 10 */
#define MTU_MC38_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063674u)

/** \brief 2676, Read Data and Bit Flip Register 11 */
#define MTU_MC38_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063676u)

/** \brief 2678, Read Data and Bit Flip Register 12 */
#define MTU_MC38_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063678u)

/** \brief 267A, Read Data and Bit Flip Register 13 */
#define MTU_MC38_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006367Au)

/** \brief 267C, Read Data and Bit Flip Register 14 */
#define MTU_MC38_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006367Cu)

/** \brief 267E, Read Data and Bit Flip Register 15 */
#define MTU_MC38_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006367Eu)

/** \brief 2680, Read Data and Bit Flip Register 16 */
#define MTU_MC38_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063680u)

/** \brief 2682, Read Data and Bit Flip Register 17 */
#define MTU_MC38_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063682u)

/** \brief 2684, Read Data and Bit Flip Register 18 */
#define MTU_MC38_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063684u)

/** \brief 2686, Read Data and Bit Flip Register 19 */
#define MTU_MC38_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063686u)

/** \brief 2688, Read Data and Bit Flip Register 20 */
#define MTU_MC38_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063688u)

/** \brief 268A, Read Data and Bit Flip Register 21 */
#define MTU_MC38_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006368Au)

/** \brief 268C, Read Data and Bit Flip Register 22 */
#define MTU_MC38_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006368Cu)

/** \brief 268E, Read Data and Bit Flip Register 23 */
#define MTU_MC38_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006368Eu)

/** \brief 2690, Read Data and Bit Flip Register 24 */
#define MTU_MC38_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063690u)

/** \brief 2692, Read Data and Bit Flip Register 25 */
#define MTU_MC38_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063692u)

/** \brief 2694, Read Data and Bit Flip Register 26 */
#define MTU_MC38_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063694u)

/** \brief 2696, Read Data and Bit Flip Register 27 */
#define MTU_MC38_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063696u)

/** \brief 2698, Read Data and Bit Flip Register 28 */
#define MTU_MC38_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063698u)

/** \brief 269A, Read Data and Bit Flip Register 29 */
#define MTU_MC38_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006369Au)

/** \brief 269C, Read Data and Bit Flip Register 30 */
#define MTU_MC38_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006369Cu)

/** \brief 269E, Read Data and Bit Flip Register 31 */
#define MTU_MC38_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006369Eu)

/** \brief 26A0, Read Data and Bit Flip Register 32 */
#define MTU_MC38_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636A0u)

/** \brief 26A2, Read Data and Bit Flip Register 33 */
#define MTU_MC38_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636A2u)

/** \brief 26A4, Read Data and Bit Flip Register 34 */
#define MTU_MC38_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636A4u)

/** \brief 26A6, Read Data and Bit Flip Register 35 */
#define MTU_MC38_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636A6u)

/** \brief 26A8, Read Data and Bit Flip Register 36 */
#define MTU_MC38_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636A8u)

/** \brief 26AA, Read Data and Bit Flip Register 37 */
#define MTU_MC38_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636AAu)

/** \brief 26AC, Read Data and Bit Flip Register 38 */
#define MTU_MC38_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636ACu)

/** \brief 26AE, Read Data and Bit Flip Register 39 */
#define MTU_MC38_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636AEu)

/** \brief 26B0, Read Data and Bit Flip Register 40 */
#define MTU_MC38_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636B0u)

/** \brief 26B2, Read Data and Bit Flip Register 41 */
#define MTU_MC38_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636B2u)

/** \brief 26B4, Read Data and Bit Flip Register 42 */
#define MTU_MC38_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636B4u)

/** \brief 26B6, Read Data and Bit Flip Register 43 */
#define MTU_MC38_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636B6u)

/** \brief 26B8, Read Data and Bit Flip Register 44 */
#define MTU_MC38_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636B8u)

/** \brief 26BA, Read Data and Bit Flip Register 45 */
#define MTU_MC38_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636BAu)

/** \brief 26BC, Read Data and Bit Flip Register 46 */
#define MTU_MC38_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636BCu)

/** \brief 26BE, Read Data and Bit Flip Register 47 */
#define MTU_MC38_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636BEu)

/** \brief 26C0, Read Data and Bit Flip Register 48 */
#define MTU_MC38_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636C0u)

/** \brief 26C2, Read Data and Bit Flip Register 49 */
#define MTU_MC38_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636C2u)

/** \brief 26C4, Read Data and Bit Flip Register 50 */
#define MTU_MC38_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636C4u)

/** \brief 26C6, Read Data and Bit Flip Register 51 */
#define MTU_MC38_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636C6u)

/** \brief 26C8, Read Data and Bit Flip Register 52 */
#define MTU_MC38_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636C8u)

/** \brief 26CA, Read Data and Bit Flip Register 53 */
#define MTU_MC38_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636CAu)

/** \brief 26CC, Read Data and Bit Flip Register 54 */
#define MTU_MC38_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636CCu)

/** \brief 26CE, Read Data and Bit Flip Register 55 */
#define MTU_MC38_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636CEu)

/** \brief 26D0, Read Data and Bit Flip Register 56 */
#define MTU_MC38_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636D0u)

/** \brief 26D2, Read Data and Bit Flip Register 57 */
#define MTU_MC38_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636D2u)

/** \brief 26D4, Read Data and Bit Flip Register 58 */
#define MTU_MC38_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636D4u)

/** \brief 26D6, Read Data and Bit Flip Register 59 */
#define MTU_MC38_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636D6u)

/** \brief 26D8, Read Data and Bit Flip Register 60 */
#define MTU_MC38_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636D8u)

/** \brief 26DA, Read Data and Bit Flip Register 61 */
#define MTU_MC38_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636DAu)

/** \brief 26DC, Read Data and Bit Flip Register 62 */
#define MTU_MC38_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636DCu)

/** \brief 26DE, Read Data and Bit Flip Register 63 */
#define MTU_MC38_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636DEu)

/** \brief 26E0, Read Data and Bit Flip Register 64 */
#define MTU_MC38_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636E0u)

/** \brief 26E2, Read Data and Bit Flip Register 65 */
#define MTU_MC38_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636E2u)

/** \brief 26E4, Read Data and Bit Flip Register 66 */
#define MTU_MC38_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00636E4u)

/** \brief 26EE, Alarm Sources Configuration Register */
#define MTU_MC38_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00636EEu)

/** \brief 26F0, SSH Safety Faults Status Register  */
#define MTU_MC38_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00636F0u)

/** \brief 26F2, Error Information Register 0 */
#define MTU_MC38_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00636F2u)

/** \brief 26F4, Error Information Register 1 */
#define MTU_MC38_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00636F4u)

/** \brief 26F6, Error Information Register 2 */
#define MTU_MC38_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00636F6u)

/** \brief 26F8, Error Information Register 3 */
#define MTU_MC38_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00636F8u)

/** \brief 26FA, Error Information Register 4 */
#define MTU_MC38_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00636FAu)

/** \brief 2700, Configuration Registers */
#define MTU_MC39_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063700u)

/** \brief 2702, Configuration Register 1 */
#define MTU_MC39_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063702u)

/** \brief 2704, MBIST Control Register */
#define MTU_MC39_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063704u)

/** \brief 2706, Status Register */
#define MTU_MC39_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063706u)

/** \brief 2708, Range Register, single address mode */
#define MTU_MC39_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063708u)

/** \brief 270C, Revision ID Register */
#define MTU_MC39_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006370Cu)

/** \brief 270E, ECC Safety Register */
#define MTU_MC39_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006370Eu)

/** \brief 2710, Memory ECC Detection Register */
#define MTU_MC39_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063710u)

/** \brief 2712, Error Tracking Register 0 */
#define MTU_MC39_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063712u)

/** \brief 2714, Error Tracking Register 1 */
#define MTU_MC39_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063714u)

/** \brief 2716, Error Tracking Register 2 */
#define MTU_MC39_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063716u)

/** \brief 2718, Error Tracking Register 3 */
#define MTU_MC39_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063718u)

/** \brief 271A, Error Tracking Register 4 */
#define MTU_MC39_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006371Au)

/** \brief 2760, Read Data and Bit Flip Register 0 */
#define MTU_MC39_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063760u)

/** \brief 2762, Read Data and Bit Flip Register 1 */
#define MTU_MC39_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063762u)

/** \brief 2764, Read Data and Bit Flip Register 2 */
#define MTU_MC39_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063764u)

/** \brief 2766, Read Data and Bit Flip Register 3 */
#define MTU_MC39_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063766u)

/** \brief 2768, Read Data and Bit Flip Register 4 */
#define MTU_MC39_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063768u)

/** \brief 276A, Read Data and Bit Flip Register 5 */
#define MTU_MC39_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006376Au)

/** \brief 276C, Read Data and Bit Flip Register 6 */
#define MTU_MC39_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006376Cu)

/** \brief 276E, Read Data and Bit Flip Register 7 */
#define MTU_MC39_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006376Eu)

/** \brief 2770, Read Data and Bit Flip Register 8 */
#define MTU_MC39_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063770u)

/** \brief 2772, Read Data and Bit Flip Register 9 */
#define MTU_MC39_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063772u)

/** \brief 2774, Read Data and Bit Flip Register 10 */
#define MTU_MC39_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063774u)

/** \brief 2776, Read Data and Bit Flip Register 11 */
#define MTU_MC39_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063776u)

/** \brief 2778, Read Data and Bit Flip Register 12 */
#define MTU_MC39_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063778u)

/** \brief 277A, Read Data and Bit Flip Register 13 */
#define MTU_MC39_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006377Au)

/** \brief 277C, Read Data and Bit Flip Register 14 */
#define MTU_MC39_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006377Cu)

/** \brief 277E, Read Data and Bit Flip Register 15 */
#define MTU_MC39_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006377Eu)

/** \brief 2780, Read Data and Bit Flip Register 16 */
#define MTU_MC39_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063780u)

/** \brief 2782, Read Data and Bit Flip Register 17 */
#define MTU_MC39_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063782u)

/** \brief 2784, Read Data and Bit Flip Register 18 */
#define MTU_MC39_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063784u)

/** \brief 2786, Read Data and Bit Flip Register 19 */
#define MTU_MC39_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063786u)

/** \brief 2788, Read Data and Bit Flip Register 20 */
#define MTU_MC39_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063788u)

/** \brief 278A, Read Data and Bit Flip Register 21 */
#define MTU_MC39_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006378Au)

/** \brief 278C, Read Data and Bit Flip Register 22 */
#define MTU_MC39_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006378Cu)

/** \brief 278E, Read Data and Bit Flip Register 23 */
#define MTU_MC39_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006378Eu)

/** \brief 2790, Read Data and Bit Flip Register 24 */
#define MTU_MC39_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063790u)

/** \brief 2792, Read Data and Bit Flip Register 25 */
#define MTU_MC39_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063792u)

/** \brief 2794, Read Data and Bit Flip Register 26 */
#define MTU_MC39_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063794u)

/** \brief 2796, Read Data and Bit Flip Register 27 */
#define MTU_MC39_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063796u)

/** \brief 2798, Read Data and Bit Flip Register 28 */
#define MTU_MC39_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063798u)

/** \brief 279A, Read Data and Bit Flip Register 29 */
#define MTU_MC39_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006379Au)

/** \brief 279C, Read Data and Bit Flip Register 30 */
#define MTU_MC39_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006379Cu)

/** \brief 279E, Read Data and Bit Flip Register 31 */
#define MTU_MC39_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006379Eu)

/** \brief 27A0, Read Data and Bit Flip Register 32 */
#define MTU_MC39_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637A0u)

/** \brief 27A2, Read Data and Bit Flip Register 33 */
#define MTU_MC39_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637A2u)

/** \brief 27A4, Read Data and Bit Flip Register 34 */
#define MTU_MC39_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637A4u)

/** \brief 27A6, Read Data and Bit Flip Register 35 */
#define MTU_MC39_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637A6u)

/** \brief 27A8, Read Data and Bit Flip Register 36 */
#define MTU_MC39_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637A8u)

/** \brief 27AA, Read Data and Bit Flip Register 37 */
#define MTU_MC39_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637AAu)

/** \brief 27AC, Read Data and Bit Flip Register 38 */
#define MTU_MC39_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637ACu)

/** \brief 27AE, Read Data and Bit Flip Register 39 */
#define MTU_MC39_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637AEu)

/** \brief 27B0, Read Data and Bit Flip Register 40 */
#define MTU_MC39_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637B0u)

/** \brief 27B2, Read Data and Bit Flip Register 41 */
#define MTU_MC39_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637B2u)

/** \brief 27B4, Read Data and Bit Flip Register 42 */
#define MTU_MC39_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637B4u)

/** \brief 27B6, Read Data and Bit Flip Register 43 */
#define MTU_MC39_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637B6u)

/** \brief 27B8, Read Data and Bit Flip Register 44 */
#define MTU_MC39_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637B8u)

/** \brief 27BA, Read Data and Bit Flip Register 45 */
#define MTU_MC39_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637BAu)

/** \brief 27BC, Read Data and Bit Flip Register 46 */
#define MTU_MC39_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637BCu)

/** \brief 27BE, Read Data and Bit Flip Register 47 */
#define MTU_MC39_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637BEu)

/** \brief 27C0, Read Data and Bit Flip Register 48 */
#define MTU_MC39_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637C0u)

/** \brief 27C2, Read Data and Bit Flip Register 49 */
#define MTU_MC39_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637C2u)

/** \brief 27C4, Read Data and Bit Flip Register 50 */
#define MTU_MC39_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637C4u)

/** \brief 27C6, Read Data and Bit Flip Register 51 */
#define MTU_MC39_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637C6u)

/** \brief 27C8, Read Data and Bit Flip Register 52 */
#define MTU_MC39_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637C8u)

/** \brief 27CA, Read Data and Bit Flip Register 53 */
#define MTU_MC39_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637CAu)

/** \brief 27CC, Read Data and Bit Flip Register 54 */
#define MTU_MC39_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637CCu)

/** \brief 27CE, Read Data and Bit Flip Register 55 */
#define MTU_MC39_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637CEu)

/** \brief 27D0, Read Data and Bit Flip Register 56 */
#define MTU_MC39_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637D0u)

/** \brief 27D2, Read Data and Bit Flip Register 57 */
#define MTU_MC39_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637D2u)

/** \brief 27D4, Read Data and Bit Flip Register 58 */
#define MTU_MC39_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637D4u)

/** \brief 27D6, Read Data and Bit Flip Register 59 */
#define MTU_MC39_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637D6u)

/** \brief 27D8, Read Data and Bit Flip Register 60 */
#define MTU_MC39_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637D8u)

/** \brief 27DA, Read Data and Bit Flip Register 61 */
#define MTU_MC39_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637DAu)

/** \brief 27DC, Read Data and Bit Flip Register 62 */
#define MTU_MC39_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637DCu)

/** \brief 27DE, Read Data and Bit Flip Register 63 */
#define MTU_MC39_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637DEu)

/** \brief 27E0, Read Data and Bit Flip Register 64 */
#define MTU_MC39_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637E0u)

/** \brief 27E2, Read Data and Bit Flip Register 65 */
#define MTU_MC39_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637E2u)

/** \brief 27E4, Read Data and Bit Flip Register 66 */
#define MTU_MC39_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00637E4u)

/** \brief 27EE, Alarm Sources Configuration Register */
#define MTU_MC39_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00637EEu)

/** \brief 27F0, SSH Safety Faults Status Register  */
#define MTU_MC39_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00637F0u)

/** \brief 27F2, Error Information Register 0 */
#define MTU_MC39_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00637F2u)

/** \brief 27F4, Error Information Register 1 */
#define MTU_MC39_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00637F4u)

/** \brief 27F6, Error Information Register 2 */
#define MTU_MC39_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00637F6u)

/** \brief 27F8, Error Information Register 3 */
#define MTU_MC39_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00637F8u)

/** \brief 27FA, Error Information Register 4 */
#define MTU_MC39_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00637FAu)

/** \brief 2800, Configuration Registers */
#define MTU_MC40_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063800u)

/** \brief 2802, Configuration Register 1 */
#define MTU_MC40_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063802u)

/** \brief 2804, MBIST Control Register */
#define MTU_MC40_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063804u)

/** \brief 2806, Status Register */
#define MTU_MC40_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063806u)

/** \brief 2808, Range Register, single address mode */
#define MTU_MC40_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063808u)

/** \brief 280C, Revision ID Register */
#define MTU_MC40_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006380Cu)

/** \brief 280E, ECC Safety Register */
#define MTU_MC40_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006380Eu)

/** \brief 2810, Memory ECC Detection Register */
#define MTU_MC40_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063810u)

/** \brief 2812, Error Tracking Register 0 */
#define MTU_MC40_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063812u)

/** \brief 2814, Error Tracking Register 1 */
#define MTU_MC40_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063814u)

/** \brief 2816, Error Tracking Register 2 */
#define MTU_MC40_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063816u)

/** \brief 2818, Error Tracking Register 3 */
#define MTU_MC40_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063818u)

/** \brief 281A, Error Tracking Register 4 */
#define MTU_MC40_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006381Au)

/** \brief 2860, Read Data and Bit Flip Register 0 */
#define MTU_MC40_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063860u)

/** \brief 2862, Read Data and Bit Flip Register 1 */
#define MTU_MC40_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063862u)

/** \brief 2864, Read Data and Bit Flip Register 2 */
#define MTU_MC40_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063864u)

/** \brief 2866, Read Data and Bit Flip Register 3 */
#define MTU_MC40_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063866u)

/** \brief 2868, Read Data and Bit Flip Register 4 */
#define MTU_MC40_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063868u)

/** \brief 286A, Read Data and Bit Flip Register 5 */
#define MTU_MC40_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006386Au)

/** \brief 286C, Read Data and Bit Flip Register 6 */
#define MTU_MC40_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006386Cu)

/** \brief 286E, Read Data and Bit Flip Register 7 */
#define MTU_MC40_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006386Eu)

/** \brief 2870, Read Data and Bit Flip Register 8 */
#define MTU_MC40_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063870u)

/** \brief 2872, Read Data and Bit Flip Register 9 */
#define MTU_MC40_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063872u)

/** \brief 2874, Read Data and Bit Flip Register 10 */
#define MTU_MC40_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063874u)

/** \brief 2876, Read Data and Bit Flip Register 11 */
#define MTU_MC40_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063876u)

/** \brief 2878, Read Data and Bit Flip Register 12 */
#define MTU_MC40_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063878u)

/** \brief 287A, Read Data and Bit Flip Register 13 */
#define MTU_MC40_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006387Au)

/** \brief 287C, Read Data and Bit Flip Register 14 */
#define MTU_MC40_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006387Cu)

/** \brief 287E, Read Data and Bit Flip Register 15 */
#define MTU_MC40_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006387Eu)

/** \brief 2880, Read Data and Bit Flip Register 16 */
#define MTU_MC40_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063880u)

/** \brief 2882, Read Data and Bit Flip Register 17 */
#define MTU_MC40_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063882u)

/** \brief 2884, Read Data and Bit Flip Register 18 */
#define MTU_MC40_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063884u)

/** \brief 2886, Read Data and Bit Flip Register 19 */
#define MTU_MC40_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063886u)

/** \brief 2888, Read Data and Bit Flip Register 20 */
#define MTU_MC40_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063888u)

/** \brief 288A, Read Data and Bit Flip Register 21 */
#define MTU_MC40_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006388Au)

/** \brief 288C, Read Data and Bit Flip Register 22 */
#define MTU_MC40_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006388Cu)

/** \brief 288E, Read Data and Bit Flip Register 23 */
#define MTU_MC40_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006388Eu)

/** \brief 2890, Read Data and Bit Flip Register 24 */
#define MTU_MC40_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063890u)

/** \brief 2892, Read Data and Bit Flip Register 25 */
#define MTU_MC40_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063892u)

/** \brief 2894, Read Data and Bit Flip Register 26 */
#define MTU_MC40_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063894u)

/** \brief 2896, Read Data and Bit Flip Register 27 */
#define MTU_MC40_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063896u)

/** \brief 2898, Read Data and Bit Flip Register 28 */
#define MTU_MC40_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063898u)

/** \brief 289A, Read Data and Bit Flip Register 29 */
#define MTU_MC40_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006389Au)

/** \brief 289C, Read Data and Bit Flip Register 30 */
#define MTU_MC40_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006389Cu)

/** \brief 289E, Read Data and Bit Flip Register 31 */
#define MTU_MC40_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006389Eu)

/** \brief 28A0, Read Data and Bit Flip Register 32 */
#define MTU_MC40_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638A0u)

/** \brief 28A2, Read Data and Bit Flip Register 33 */
#define MTU_MC40_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638A2u)

/** \brief 28A4, Read Data and Bit Flip Register 34 */
#define MTU_MC40_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638A4u)

/** \brief 28A6, Read Data and Bit Flip Register 35 */
#define MTU_MC40_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638A6u)

/** \brief 28A8, Read Data and Bit Flip Register 36 */
#define MTU_MC40_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638A8u)

/** \brief 28AA, Read Data and Bit Flip Register 37 */
#define MTU_MC40_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638AAu)

/** \brief 28AC, Read Data and Bit Flip Register 38 */
#define MTU_MC40_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638ACu)

/** \brief 28AE, Read Data and Bit Flip Register 39 */
#define MTU_MC40_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638AEu)

/** \brief 28B0, Read Data and Bit Flip Register 40 */
#define MTU_MC40_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638B0u)

/** \brief 28B2, Read Data and Bit Flip Register 41 */
#define MTU_MC40_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638B2u)

/** \brief 28B4, Read Data and Bit Flip Register 42 */
#define MTU_MC40_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638B4u)

/** \brief 28B6, Read Data and Bit Flip Register 43 */
#define MTU_MC40_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638B6u)

/** \brief 28B8, Read Data and Bit Flip Register 44 */
#define MTU_MC40_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638B8u)

/** \brief 28BA, Read Data and Bit Flip Register 45 */
#define MTU_MC40_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638BAu)

/** \brief 28BC, Read Data and Bit Flip Register 46 */
#define MTU_MC40_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638BCu)

/** \brief 28BE, Read Data and Bit Flip Register 47 */
#define MTU_MC40_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638BEu)

/** \brief 28C0, Read Data and Bit Flip Register 48 */
#define MTU_MC40_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638C0u)

/** \brief 28C2, Read Data and Bit Flip Register 49 */
#define MTU_MC40_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638C2u)

/** \brief 28C4, Read Data and Bit Flip Register 50 */
#define MTU_MC40_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638C4u)

/** \brief 28C6, Read Data and Bit Flip Register 51 */
#define MTU_MC40_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638C6u)

/** \brief 28C8, Read Data and Bit Flip Register 52 */
#define MTU_MC40_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638C8u)

/** \brief 28CA, Read Data and Bit Flip Register 53 */
#define MTU_MC40_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638CAu)

/** \brief 28CC, Read Data and Bit Flip Register 54 */
#define MTU_MC40_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638CCu)

/** \brief 28CE, Read Data and Bit Flip Register 55 */
#define MTU_MC40_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638CEu)

/** \brief 28D0, Read Data and Bit Flip Register 56 */
#define MTU_MC40_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638D0u)

/** \brief 28D2, Read Data and Bit Flip Register 57 */
#define MTU_MC40_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638D2u)

/** \brief 28D4, Read Data and Bit Flip Register 58 */
#define MTU_MC40_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638D4u)

/** \brief 28D6, Read Data and Bit Flip Register 59 */
#define MTU_MC40_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638D6u)

/** \brief 28D8, Read Data and Bit Flip Register 60 */
#define MTU_MC40_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638D8u)

/** \brief 28DA, Read Data and Bit Flip Register 61 */
#define MTU_MC40_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638DAu)

/** \brief 28DC, Read Data and Bit Flip Register 62 */
#define MTU_MC40_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638DCu)

/** \brief 28DE, Read Data and Bit Flip Register 63 */
#define MTU_MC40_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638DEu)

/** \brief 28E0, Read Data and Bit Flip Register 64 */
#define MTU_MC40_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638E0u)

/** \brief 28E2, Read Data and Bit Flip Register 65 */
#define MTU_MC40_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638E2u)

/** \brief 28E4, Read Data and Bit Flip Register 66 */
#define MTU_MC40_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00638E4u)

/** \brief 28EE, Alarm Sources Configuration Register */
#define MTU_MC40_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00638EEu)

/** \brief 28F0, SSH Safety Faults Status Register  */
#define MTU_MC40_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00638F0u)

/** \brief 28F2, Error Information Register 0 */
#define MTU_MC40_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00638F2u)

/** \brief 28F4, Error Information Register 1 */
#define MTU_MC40_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00638F4u)

/** \brief 28F6, Error Information Register 2 */
#define MTU_MC40_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00638F6u)

/** \brief 28F8, Error Information Register 3 */
#define MTU_MC40_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00638F8u)

/** \brief 28FA, Error Information Register 4 */
#define MTU_MC40_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00638FAu)

/** \brief 2900, Configuration Registers */
#define MTU_MC41_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063900u)

/** \brief 2902, Configuration Register 1 */
#define MTU_MC41_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063902u)

/** \brief 2904, MBIST Control Register */
#define MTU_MC41_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063904u)

/** \brief 2906, Status Register */
#define MTU_MC41_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063906u)

/** \brief 2908, Range Register, single address mode */
#define MTU_MC41_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063908u)

/** \brief 290C, Revision ID Register */
#define MTU_MC41_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006390Cu)

/** \brief 290E, ECC Safety Register */
#define MTU_MC41_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006390Eu)

/** \brief 2910, Memory ECC Detection Register */
#define MTU_MC41_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063910u)

/** \brief 2912, Error Tracking Register 0 */
#define MTU_MC41_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063912u)

/** \brief 2914, Error Tracking Register 1 */
#define MTU_MC41_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063914u)

/** \brief 2916, Error Tracking Register 2 */
#define MTU_MC41_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063916u)

/** \brief 2918, Error Tracking Register 3 */
#define MTU_MC41_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063918u)

/** \brief 291A, Error Tracking Register 4 */
#define MTU_MC41_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006391Au)

/** \brief 2960, Read Data and Bit Flip Register 0 */
#define MTU_MC41_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063960u)

/** \brief 2962, Read Data and Bit Flip Register 1 */
#define MTU_MC41_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063962u)

/** \brief 2964, Read Data and Bit Flip Register 2 */
#define MTU_MC41_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063964u)

/** \brief 2966, Read Data and Bit Flip Register 3 */
#define MTU_MC41_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063966u)

/** \brief 2968, Read Data and Bit Flip Register 4 */
#define MTU_MC41_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063968u)

/** \brief 296A, Read Data and Bit Flip Register 5 */
#define MTU_MC41_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006396Au)

/** \brief 296C, Read Data and Bit Flip Register 6 */
#define MTU_MC41_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006396Cu)

/** \brief 296E, Read Data and Bit Flip Register 7 */
#define MTU_MC41_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006396Eu)

/** \brief 2970, Read Data and Bit Flip Register 8 */
#define MTU_MC41_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063970u)

/** \brief 2972, Read Data and Bit Flip Register 9 */
#define MTU_MC41_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063972u)

/** \brief 2974, Read Data and Bit Flip Register 10 */
#define MTU_MC41_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063974u)

/** \brief 2976, Read Data and Bit Flip Register 11 */
#define MTU_MC41_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063976u)

/** \brief 2978, Read Data and Bit Flip Register 12 */
#define MTU_MC41_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063978u)

/** \brief 297A, Read Data and Bit Flip Register 13 */
#define MTU_MC41_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006397Au)

/** \brief 297C, Read Data and Bit Flip Register 14 */
#define MTU_MC41_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006397Cu)

/** \brief 297E, Read Data and Bit Flip Register 15 */
#define MTU_MC41_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006397Eu)

/** \brief 2980, Read Data and Bit Flip Register 16 */
#define MTU_MC41_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063980u)

/** \brief 2982, Read Data and Bit Flip Register 17 */
#define MTU_MC41_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063982u)

/** \brief 2984, Read Data and Bit Flip Register 18 */
#define MTU_MC41_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063984u)

/** \brief 2986, Read Data and Bit Flip Register 19 */
#define MTU_MC41_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063986u)

/** \brief 2988, Read Data and Bit Flip Register 20 */
#define MTU_MC41_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063988u)

/** \brief 298A, Read Data and Bit Flip Register 21 */
#define MTU_MC41_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006398Au)

/** \brief 298C, Read Data and Bit Flip Register 22 */
#define MTU_MC41_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006398Cu)

/** \brief 298E, Read Data and Bit Flip Register 23 */
#define MTU_MC41_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006398Eu)

/** \brief 2990, Read Data and Bit Flip Register 24 */
#define MTU_MC41_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063990u)

/** \brief 2992, Read Data and Bit Flip Register 25 */
#define MTU_MC41_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063992u)

/** \brief 2994, Read Data and Bit Flip Register 26 */
#define MTU_MC41_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063994u)

/** \brief 2996, Read Data and Bit Flip Register 27 */
#define MTU_MC41_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063996u)

/** \brief 2998, Read Data and Bit Flip Register 28 */
#define MTU_MC41_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063998u)

/** \brief 299A, Read Data and Bit Flip Register 29 */
#define MTU_MC41_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006399Au)

/** \brief 299C, Read Data and Bit Flip Register 30 */
#define MTU_MC41_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006399Cu)

/** \brief 299E, Read Data and Bit Flip Register 31 */
#define MTU_MC41_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006399Eu)

/** \brief 29A0, Read Data and Bit Flip Register 32 */
#define MTU_MC41_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639A0u)

/** \brief 29A2, Read Data and Bit Flip Register 33 */
#define MTU_MC41_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639A2u)

/** \brief 29A4, Read Data and Bit Flip Register 34 */
#define MTU_MC41_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639A4u)

/** \brief 29A6, Read Data and Bit Flip Register 35 */
#define MTU_MC41_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639A6u)

/** \brief 29A8, Read Data and Bit Flip Register 36 */
#define MTU_MC41_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639A8u)

/** \brief 29AA, Read Data and Bit Flip Register 37 */
#define MTU_MC41_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639AAu)

/** \brief 29AC, Read Data and Bit Flip Register 38 */
#define MTU_MC41_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639ACu)

/** \brief 29AE, Read Data and Bit Flip Register 39 */
#define MTU_MC41_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639AEu)

/** \brief 29B0, Read Data and Bit Flip Register 40 */
#define MTU_MC41_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639B0u)

/** \brief 29B2, Read Data and Bit Flip Register 41 */
#define MTU_MC41_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639B2u)

/** \brief 29B4, Read Data and Bit Flip Register 42 */
#define MTU_MC41_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639B4u)

/** \brief 29B6, Read Data and Bit Flip Register 43 */
#define MTU_MC41_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639B6u)

/** \brief 29B8, Read Data and Bit Flip Register 44 */
#define MTU_MC41_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639B8u)

/** \brief 29BA, Read Data and Bit Flip Register 45 */
#define MTU_MC41_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639BAu)

/** \brief 29BC, Read Data and Bit Flip Register 46 */
#define MTU_MC41_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639BCu)

/** \brief 29BE, Read Data and Bit Flip Register 47 */
#define MTU_MC41_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639BEu)

/** \brief 29C0, Read Data and Bit Flip Register 48 */
#define MTU_MC41_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639C0u)

/** \brief 29C2, Read Data and Bit Flip Register 49 */
#define MTU_MC41_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639C2u)

/** \brief 29C4, Read Data and Bit Flip Register 50 */
#define MTU_MC41_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639C4u)

/** \brief 29C6, Read Data and Bit Flip Register 51 */
#define MTU_MC41_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639C6u)

/** \brief 29C8, Read Data and Bit Flip Register 52 */
#define MTU_MC41_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639C8u)

/** \brief 29CA, Read Data and Bit Flip Register 53 */
#define MTU_MC41_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639CAu)

/** \brief 29CC, Read Data and Bit Flip Register 54 */
#define MTU_MC41_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639CCu)

/** \brief 29CE, Read Data and Bit Flip Register 55 */
#define MTU_MC41_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639CEu)

/** \brief 29D0, Read Data and Bit Flip Register 56 */
#define MTU_MC41_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639D0u)

/** \brief 29D2, Read Data and Bit Flip Register 57 */
#define MTU_MC41_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639D2u)

/** \brief 29D4, Read Data and Bit Flip Register 58 */
#define MTU_MC41_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639D4u)

/** \brief 29D6, Read Data and Bit Flip Register 59 */
#define MTU_MC41_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639D6u)

/** \brief 29D8, Read Data and Bit Flip Register 60 */
#define MTU_MC41_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639D8u)

/** \brief 29DA, Read Data and Bit Flip Register 61 */
#define MTU_MC41_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639DAu)

/** \brief 29DC, Read Data and Bit Flip Register 62 */
#define MTU_MC41_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639DCu)

/** \brief 29DE, Read Data and Bit Flip Register 63 */
#define MTU_MC41_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639DEu)

/** \brief 29E0, Read Data and Bit Flip Register 64 */
#define MTU_MC41_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639E0u)

/** \brief 29E2, Read Data and Bit Flip Register 65 */
#define MTU_MC41_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639E2u)

/** \brief 29E4, Read Data and Bit Flip Register 66 */
#define MTU_MC41_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00639E4u)

/** \brief 29EE, Alarm Sources Configuration Register */
#define MTU_MC41_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00639EEu)

/** \brief 29F0, SSH Safety Faults Status Register  */
#define MTU_MC41_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00639F0u)

/** \brief 29F2, Error Information Register 0 */
#define MTU_MC41_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00639F2u)

/** \brief 29F4, Error Information Register 1 */
#define MTU_MC41_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00639F4u)

/** \brief 29F6, Error Information Register 2 */
#define MTU_MC41_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00639F6u)

/** \brief 29F8, Error Information Register 3 */
#define MTU_MC41_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00639F8u)

/** \brief 29FA, Error Information Register 4 */
#define MTU_MC41_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00639FAu)

/** \brief 2A00, Configuration Registers */
#define MTU_MC42_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063A00u)

/** \brief 2A02, Configuration Register 1 */
#define MTU_MC42_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063A02u)

/** \brief 2A04, MBIST Control Register */
#define MTU_MC42_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063A04u)

/** \brief 2A06, Status Register */
#define MTU_MC42_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063A06u)

/** \brief 2A08, Range Register, single address mode */
#define MTU_MC42_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063A08u)

/** \brief 2A0C, Revision ID Register */
#define MTU_MC42_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0063A0Cu)

/** \brief 2A0E, ECC Safety Register */
#define MTU_MC42_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0063A0Eu)

/** \brief 2A10, Memory ECC Detection Register */
#define MTU_MC42_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063A10u)

/** \brief 2A12, Error Tracking Register 0 */
#define MTU_MC42_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063A12u)

/** \brief 2A14, Error Tracking Register 1 */
#define MTU_MC42_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063A14u)

/** \brief 2A16, Error Tracking Register 2 */
#define MTU_MC42_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063A16u)

/** \brief 2A18, Error Tracking Register 3 */
#define MTU_MC42_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063A18u)

/** \brief 2A1A, Error Tracking Register 4 */
#define MTU_MC42_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063A1Au)

/** \brief 2A60, Read Data and Bit Flip Register 0 */
#define MTU_MC42_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A60u)

/** \brief 2A62, Read Data and Bit Flip Register 1 */
#define MTU_MC42_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A62u)

/** \brief 2A64, Read Data and Bit Flip Register 2 */
#define MTU_MC42_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A64u)

/** \brief 2A66, Read Data and Bit Flip Register 3 */
#define MTU_MC42_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A66u)

/** \brief 2A68, Read Data and Bit Flip Register 4 */
#define MTU_MC42_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A68u)

/** \brief 2A6A, Read Data and Bit Flip Register 5 */
#define MTU_MC42_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A6Au)

/** \brief 2A6C, Read Data and Bit Flip Register 6 */
#define MTU_MC42_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A6Cu)

/** \brief 2A6E, Read Data and Bit Flip Register 7 */
#define MTU_MC42_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A6Eu)

/** \brief 2A70, Read Data and Bit Flip Register 8 */
#define MTU_MC42_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A70u)

/** \brief 2A72, Read Data and Bit Flip Register 9 */
#define MTU_MC42_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A72u)

/** \brief 2A74, Read Data and Bit Flip Register 10 */
#define MTU_MC42_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A74u)

/** \brief 2A76, Read Data and Bit Flip Register 11 */
#define MTU_MC42_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A76u)

/** \brief 2A78, Read Data and Bit Flip Register 12 */
#define MTU_MC42_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A78u)

/** \brief 2A7A, Read Data and Bit Flip Register 13 */
#define MTU_MC42_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A7Au)

/** \brief 2A7C, Read Data and Bit Flip Register 14 */
#define MTU_MC42_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A7Cu)

/** \brief 2A7E, Read Data and Bit Flip Register 15 */
#define MTU_MC42_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A7Eu)

/** \brief 2A80, Read Data and Bit Flip Register 16 */
#define MTU_MC42_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A80u)

/** \brief 2A82, Read Data and Bit Flip Register 17 */
#define MTU_MC42_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A82u)

/** \brief 2A84, Read Data and Bit Flip Register 18 */
#define MTU_MC42_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A84u)

/** \brief 2A86, Read Data and Bit Flip Register 19 */
#define MTU_MC42_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A86u)

/** \brief 2A88, Read Data and Bit Flip Register 20 */
#define MTU_MC42_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A88u)

/** \brief 2A8A, Read Data and Bit Flip Register 21 */
#define MTU_MC42_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A8Au)

/** \brief 2A8C, Read Data and Bit Flip Register 22 */
#define MTU_MC42_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A8Cu)

/** \brief 2A8E, Read Data and Bit Flip Register 23 */
#define MTU_MC42_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A8Eu)

/** \brief 2A90, Read Data and Bit Flip Register 24 */
#define MTU_MC42_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A90u)

/** \brief 2A92, Read Data and Bit Flip Register 25 */
#define MTU_MC42_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A92u)

/** \brief 2A94, Read Data and Bit Flip Register 26 */
#define MTU_MC42_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A94u)

/** \brief 2A96, Read Data and Bit Flip Register 27 */
#define MTU_MC42_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A96u)

/** \brief 2A98, Read Data and Bit Flip Register 28 */
#define MTU_MC42_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A98u)

/** \brief 2A9A, Read Data and Bit Flip Register 29 */
#define MTU_MC42_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A9Au)

/** \brief 2A9C, Read Data and Bit Flip Register 30 */
#define MTU_MC42_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A9Cu)

/** \brief 2A9E, Read Data and Bit Flip Register 31 */
#define MTU_MC42_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063A9Eu)

/** \brief 2AA0, Read Data and Bit Flip Register 32 */
#define MTU_MC42_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AA0u)

/** \brief 2AA2, Read Data and Bit Flip Register 33 */
#define MTU_MC42_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AA2u)

/** \brief 2AA4, Read Data and Bit Flip Register 34 */
#define MTU_MC42_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AA4u)

/** \brief 2AA6, Read Data and Bit Flip Register 35 */
#define MTU_MC42_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AA6u)

/** \brief 2AA8, Read Data and Bit Flip Register 36 */
#define MTU_MC42_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AA8u)

/** \brief 2AAA, Read Data and Bit Flip Register 37 */
#define MTU_MC42_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AAAu)

/** \brief 2AAC, Read Data and Bit Flip Register 38 */
#define MTU_MC42_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AACu)

/** \brief 2AAE, Read Data and Bit Flip Register 39 */
#define MTU_MC42_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AAEu)

/** \brief 2AB0, Read Data and Bit Flip Register 40 */
#define MTU_MC42_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AB0u)

/** \brief 2AB2, Read Data and Bit Flip Register 41 */
#define MTU_MC42_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AB2u)

/** \brief 2AB4, Read Data and Bit Flip Register 42 */
#define MTU_MC42_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AB4u)

/** \brief 2AB6, Read Data and Bit Flip Register 43 */
#define MTU_MC42_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AB6u)

/** \brief 2AB8, Read Data and Bit Flip Register 44 */
#define MTU_MC42_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AB8u)

/** \brief 2ABA, Read Data and Bit Flip Register 45 */
#define MTU_MC42_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ABAu)

/** \brief 2ABC, Read Data and Bit Flip Register 46 */
#define MTU_MC42_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ABCu)

/** \brief 2ABE, Read Data and Bit Flip Register 47 */
#define MTU_MC42_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ABEu)

/** \brief 2AC0, Read Data and Bit Flip Register 48 */
#define MTU_MC42_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AC0u)

/** \brief 2AC2, Read Data and Bit Flip Register 49 */
#define MTU_MC42_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AC2u)

/** \brief 2AC4, Read Data and Bit Flip Register 50 */
#define MTU_MC42_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AC4u)

/** \brief 2AC6, Read Data and Bit Flip Register 51 */
#define MTU_MC42_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AC6u)

/** \brief 2AC8, Read Data and Bit Flip Register 52 */
#define MTU_MC42_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AC8u)

/** \brief 2ACA, Read Data and Bit Flip Register 53 */
#define MTU_MC42_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ACAu)

/** \brief 2ACC, Read Data and Bit Flip Register 54 */
#define MTU_MC42_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ACCu)

/** \brief 2ACE, Read Data and Bit Flip Register 55 */
#define MTU_MC42_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ACEu)

/** \brief 2AD0, Read Data and Bit Flip Register 56 */
#define MTU_MC42_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AD0u)

/** \brief 2AD2, Read Data and Bit Flip Register 57 */
#define MTU_MC42_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AD2u)

/** \brief 2AD4, Read Data and Bit Flip Register 58 */
#define MTU_MC42_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AD4u)

/** \brief 2AD6, Read Data and Bit Flip Register 59 */
#define MTU_MC42_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AD6u)

/** \brief 2AD8, Read Data and Bit Flip Register 60 */
#define MTU_MC42_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AD8u)

/** \brief 2ADA, Read Data and Bit Flip Register 61 */
#define MTU_MC42_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ADAu)

/** \brief 2ADC, Read Data and Bit Flip Register 62 */
#define MTU_MC42_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ADCu)

/** \brief 2ADE, Read Data and Bit Flip Register 63 */
#define MTU_MC42_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ADEu)

/** \brief 2AE0, Read Data and Bit Flip Register 64 */
#define MTU_MC42_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AE0u)

/** \brief 2AE2, Read Data and Bit Flip Register 65 */
#define MTU_MC42_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AE2u)

/** \brief 2AE4, Read Data and Bit Flip Register 66 */
#define MTU_MC42_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063AE4u)

/** \brief 2AEE, Alarm Sources Configuration Register */
#define MTU_MC42_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0063AEEu)

/** \brief 2AF0, SSH Safety Faults Status Register  */
#define MTU_MC42_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0063AF0u)

/** \brief 2AF2, Error Information Register 0 */
#define MTU_MC42_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063AF2u)

/** \brief 2AF4, Error Information Register 1 */
#define MTU_MC42_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063AF4u)

/** \brief 2AF6, Error Information Register 2 */
#define MTU_MC42_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063AF6u)

/** \brief 2AF8, Error Information Register 3 */
#define MTU_MC42_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063AF8u)

/** \brief 2AFA, Error Information Register 4 */
#define MTU_MC42_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063AFAu)

/** \brief 2B00, Configuration Registers */
#define MTU_MC43_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063B00u)

/** \brief 2B02, Configuration Register 1 */
#define MTU_MC43_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063B02u)

/** \brief 2B04, MBIST Control Register */
#define MTU_MC43_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063B04u)

/** \brief 2B06, Status Register */
#define MTU_MC43_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063B06u)

/** \brief 2B08, Range Register, single address mode */
#define MTU_MC43_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063B08u)

/** \brief 2B0C, Revision ID Register */
#define MTU_MC43_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0063B0Cu)

/** \brief 2B0E, ECC Safety Register */
#define MTU_MC43_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0063B0Eu)

/** \brief 2B10, Memory ECC Detection Register */
#define MTU_MC43_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063B10u)

/** \brief 2B12, Error Tracking Register 0 */
#define MTU_MC43_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063B12u)

/** \brief 2B14, Error Tracking Register 1 */
#define MTU_MC43_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063B14u)

/** \brief 2B16, Error Tracking Register 2 */
#define MTU_MC43_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063B16u)

/** \brief 2B18, Error Tracking Register 3 */
#define MTU_MC43_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063B18u)

/** \brief 2B1A, Error Tracking Register 4 */
#define MTU_MC43_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063B1Au)

/** \brief 2B60, Read Data and Bit Flip Register 0 */
#define MTU_MC43_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B60u)

/** \brief 2B62, Read Data and Bit Flip Register 1 */
#define MTU_MC43_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B62u)

/** \brief 2B64, Read Data and Bit Flip Register 2 */
#define MTU_MC43_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B64u)

/** \brief 2B66, Read Data and Bit Flip Register 3 */
#define MTU_MC43_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B66u)

/** \brief 2B68, Read Data and Bit Flip Register 4 */
#define MTU_MC43_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B68u)

/** \brief 2B6A, Read Data and Bit Flip Register 5 */
#define MTU_MC43_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B6Au)

/** \brief 2B6C, Read Data and Bit Flip Register 6 */
#define MTU_MC43_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B6Cu)

/** \brief 2B6E, Read Data and Bit Flip Register 7 */
#define MTU_MC43_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B6Eu)

/** \brief 2B70, Read Data and Bit Flip Register 8 */
#define MTU_MC43_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B70u)

/** \brief 2B72, Read Data and Bit Flip Register 9 */
#define MTU_MC43_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B72u)

/** \brief 2B74, Read Data and Bit Flip Register 10 */
#define MTU_MC43_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B74u)

/** \brief 2B76, Read Data and Bit Flip Register 11 */
#define MTU_MC43_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B76u)

/** \brief 2B78, Read Data and Bit Flip Register 12 */
#define MTU_MC43_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B78u)

/** \brief 2B7A, Read Data and Bit Flip Register 13 */
#define MTU_MC43_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B7Au)

/** \brief 2B7C, Read Data and Bit Flip Register 14 */
#define MTU_MC43_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B7Cu)

/** \brief 2B7E, Read Data and Bit Flip Register 15 */
#define MTU_MC43_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B7Eu)

/** \brief 2B80, Read Data and Bit Flip Register 16 */
#define MTU_MC43_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B80u)

/** \brief 2B82, Read Data and Bit Flip Register 17 */
#define MTU_MC43_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B82u)

/** \brief 2B84, Read Data and Bit Flip Register 18 */
#define MTU_MC43_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B84u)

/** \brief 2B86, Read Data and Bit Flip Register 19 */
#define MTU_MC43_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B86u)

/** \brief 2B88, Read Data and Bit Flip Register 20 */
#define MTU_MC43_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B88u)

/** \brief 2B8A, Read Data and Bit Flip Register 21 */
#define MTU_MC43_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B8Au)

/** \brief 2B8C, Read Data and Bit Flip Register 22 */
#define MTU_MC43_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B8Cu)

/** \brief 2B8E, Read Data and Bit Flip Register 23 */
#define MTU_MC43_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B8Eu)

/** \brief 2B90, Read Data and Bit Flip Register 24 */
#define MTU_MC43_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B90u)

/** \brief 2B92, Read Data and Bit Flip Register 25 */
#define MTU_MC43_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B92u)

/** \brief 2B94, Read Data and Bit Flip Register 26 */
#define MTU_MC43_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B94u)

/** \brief 2B96, Read Data and Bit Flip Register 27 */
#define MTU_MC43_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B96u)

/** \brief 2B98, Read Data and Bit Flip Register 28 */
#define MTU_MC43_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B98u)

/** \brief 2B9A, Read Data and Bit Flip Register 29 */
#define MTU_MC43_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B9Au)

/** \brief 2B9C, Read Data and Bit Flip Register 30 */
#define MTU_MC43_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B9Cu)

/** \brief 2B9E, Read Data and Bit Flip Register 31 */
#define MTU_MC43_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063B9Eu)

/** \brief 2BA0, Read Data and Bit Flip Register 32 */
#define MTU_MC43_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BA0u)

/** \brief 2BA2, Read Data and Bit Flip Register 33 */
#define MTU_MC43_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BA2u)

/** \brief 2BA4, Read Data and Bit Flip Register 34 */
#define MTU_MC43_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BA4u)

/** \brief 2BA6, Read Data and Bit Flip Register 35 */
#define MTU_MC43_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BA6u)

/** \brief 2BA8, Read Data and Bit Flip Register 36 */
#define MTU_MC43_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BA8u)

/** \brief 2BAA, Read Data and Bit Flip Register 37 */
#define MTU_MC43_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BAAu)

/** \brief 2BAC, Read Data and Bit Flip Register 38 */
#define MTU_MC43_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BACu)

/** \brief 2BAE, Read Data and Bit Flip Register 39 */
#define MTU_MC43_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BAEu)

/** \brief 2BB0, Read Data and Bit Flip Register 40 */
#define MTU_MC43_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BB0u)

/** \brief 2BB2, Read Data and Bit Flip Register 41 */
#define MTU_MC43_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BB2u)

/** \brief 2BB4, Read Data and Bit Flip Register 42 */
#define MTU_MC43_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BB4u)

/** \brief 2BB6, Read Data and Bit Flip Register 43 */
#define MTU_MC43_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BB6u)

/** \brief 2BB8, Read Data and Bit Flip Register 44 */
#define MTU_MC43_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BB8u)

/** \brief 2BBA, Read Data and Bit Flip Register 45 */
#define MTU_MC43_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BBAu)

/** \brief 2BBC, Read Data and Bit Flip Register 46 */
#define MTU_MC43_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BBCu)

/** \brief 2BBE, Read Data and Bit Flip Register 47 */
#define MTU_MC43_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BBEu)

/** \brief 2BC0, Read Data and Bit Flip Register 48 */
#define MTU_MC43_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BC0u)

/** \brief 2BC2, Read Data and Bit Flip Register 49 */
#define MTU_MC43_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BC2u)

/** \brief 2BC4, Read Data and Bit Flip Register 50 */
#define MTU_MC43_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BC4u)

/** \brief 2BC6, Read Data and Bit Flip Register 51 */
#define MTU_MC43_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BC6u)

/** \brief 2BC8, Read Data and Bit Flip Register 52 */
#define MTU_MC43_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BC8u)

/** \brief 2BCA, Read Data and Bit Flip Register 53 */
#define MTU_MC43_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BCAu)

/** \brief 2BCC, Read Data and Bit Flip Register 54 */
#define MTU_MC43_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BCCu)

/** \brief 2BCE, Read Data and Bit Flip Register 55 */
#define MTU_MC43_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BCEu)

/** \brief 2BD0, Read Data and Bit Flip Register 56 */
#define MTU_MC43_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BD0u)

/** \brief 2BD2, Read Data and Bit Flip Register 57 */
#define MTU_MC43_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BD2u)

/** \brief 2BD4, Read Data and Bit Flip Register 58 */
#define MTU_MC43_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BD4u)

/** \brief 2BD6, Read Data and Bit Flip Register 59 */
#define MTU_MC43_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BD6u)

/** \brief 2BD8, Read Data and Bit Flip Register 60 */
#define MTU_MC43_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BD8u)

/** \brief 2BDA, Read Data and Bit Flip Register 61 */
#define MTU_MC43_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BDAu)

/** \brief 2BDC, Read Data and Bit Flip Register 62 */
#define MTU_MC43_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BDCu)

/** \brief 2BDE, Read Data and Bit Flip Register 63 */
#define MTU_MC43_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BDEu)

/** \brief 2BE0, Read Data and Bit Flip Register 64 */
#define MTU_MC43_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BE0u)

/** \brief 2BE2, Read Data and Bit Flip Register 65 */
#define MTU_MC43_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BE2u)

/** \brief 2BE4, Read Data and Bit Flip Register 66 */
#define MTU_MC43_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063BE4u)

/** \brief 2BEE, Alarm Sources Configuration Register */
#define MTU_MC43_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0063BEEu)

/** \brief 2BF0, SSH Safety Faults Status Register  */
#define MTU_MC43_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0063BF0u)

/** \brief 2BF2, Error Information Register 0 */
#define MTU_MC43_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063BF2u)

/** \brief 2BF4, Error Information Register 1 */
#define MTU_MC43_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063BF4u)

/** \brief 2BF6, Error Information Register 2 */
#define MTU_MC43_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063BF6u)

/** \brief 2BF8, Error Information Register 3 */
#define MTU_MC43_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063BF8u)

/** \brief 2BFA, Error Information Register 4 */
#define MTU_MC43_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063BFAu)

/** \brief 2C00, Configuration Registers */
#define MTU_MC44_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063C00u)

/** \brief 2C02, Configuration Register 1 */
#define MTU_MC44_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063C02u)

/** \brief 2C04, MBIST Control Register */
#define MTU_MC44_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063C04u)

/** \brief 2C06, Status Register */
#define MTU_MC44_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063C06u)

/** \brief 2C08, Range Register, single address mode */
#define MTU_MC44_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063C08u)

/** \brief 2C0C, Revision ID Register */
#define MTU_MC44_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0063C0Cu)

/** \brief 2C0E, ECC Safety Register */
#define MTU_MC44_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0063C0Eu)

/** \brief 2C10, Memory ECC Detection Register */
#define MTU_MC44_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063C10u)

/** \brief 2C12, Error Tracking Register 0 */
#define MTU_MC44_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063C12u)

/** \brief 2C14, Error Tracking Register 1 */
#define MTU_MC44_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063C14u)

/** \brief 2C16, Error Tracking Register 2 */
#define MTU_MC44_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063C16u)

/** \brief 2C18, Error Tracking Register 3 */
#define MTU_MC44_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063C18u)

/** \brief 2C1A, Error Tracking Register 4 */
#define MTU_MC44_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063C1Au)

/** \brief 2C60, Read Data and Bit Flip Register 0 */
#define MTU_MC44_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C60u)

/** \brief 2C62, Read Data and Bit Flip Register 1 */
#define MTU_MC44_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C62u)

/** \brief 2C64, Read Data and Bit Flip Register 2 */
#define MTU_MC44_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C64u)

/** \brief 2C66, Read Data and Bit Flip Register 3 */
#define MTU_MC44_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C66u)

/** \brief 2C68, Read Data and Bit Flip Register 4 */
#define MTU_MC44_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C68u)

/** \brief 2C6A, Read Data and Bit Flip Register 5 */
#define MTU_MC44_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C6Au)

/** \brief 2C6C, Read Data and Bit Flip Register 6 */
#define MTU_MC44_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C6Cu)

/** \brief 2C6E, Read Data and Bit Flip Register 7 */
#define MTU_MC44_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C6Eu)

/** \brief 2C70, Read Data and Bit Flip Register 8 */
#define MTU_MC44_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C70u)

/** \brief 2C72, Read Data and Bit Flip Register 9 */
#define MTU_MC44_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C72u)

/** \brief 2C74, Read Data and Bit Flip Register 10 */
#define MTU_MC44_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C74u)

/** \brief 2C76, Read Data and Bit Flip Register 11 */
#define MTU_MC44_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C76u)

/** \brief 2C78, Read Data and Bit Flip Register 12 */
#define MTU_MC44_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C78u)

/** \brief 2C7A, Read Data and Bit Flip Register 13 */
#define MTU_MC44_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C7Au)

/** \brief 2C7C, Read Data and Bit Flip Register 14 */
#define MTU_MC44_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C7Cu)

/** \brief 2C7E, Read Data and Bit Flip Register 15 */
#define MTU_MC44_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C7Eu)

/** \brief 2C80, Read Data and Bit Flip Register 16 */
#define MTU_MC44_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C80u)

/** \brief 2C82, Read Data and Bit Flip Register 17 */
#define MTU_MC44_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C82u)

/** \brief 2C84, Read Data and Bit Flip Register 18 */
#define MTU_MC44_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C84u)

/** \brief 2C86, Read Data and Bit Flip Register 19 */
#define MTU_MC44_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C86u)

/** \brief 2C88, Read Data and Bit Flip Register 20 */
#define MTU_MC44_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C88u)

/** \brief 2C8A, Read Data and Bit Flip Register 21 */
#define MTU_MC44_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C8Au)

/** \brief 2C8C, Read Data and Bit Flip Register 22 */
#define MTU_MC44_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C8Cu)

/** \brief 2C8E, Read Data and Bit Flip Register 23 */
#define MTU_MC44_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C8Eu)

/** \brief 2C90, Read Data and Bit Flip Register 24 */
#define MTU_MC44_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C90u)

/** \brief 2C92, Read Data and Bit Flip Register 25 */
#define MTU_MC44_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C92u)

/** \brief 2C94, Read Data and Bit Flip Register 26 */
#define MTU_MC44_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C94u)

/** \brief 2C96, Read Data and Bit Flip Register 27 */
#define MTU_MC44_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C96u)

/** \brief 2C98, Read Data and Bit Flip Register 28 */
#define MTU_MC44_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C98u)

/** \brief 2C9A, Read Data and Bit Flip Register 29 */
#define MTU_MC44_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C9Au)

/** \brief 2C9C, Read Data and Bit Flip Register 30 */
#define MTU_MC44_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C9Cu)

/** \brief 2C9E, Read Data and Bit Flip Register 31 */
#define MTU_MC44_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063C9Eu)

/** \brief 2CA0, Read Data and Bit Flip Register 32 */
#define MTU_MC44_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CA0u)

/** \brief 2CA2, Read Data and Bit Flip Register 33 */
#define MTU_MC44_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CA2u)

/** \brief 2CA4, Read Data and Bit Flip Register 34 */
#define MTU_MC44_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CA4u)

/** \brief 2CA6, Read Data and Bit Flip Register 35 */
#define MTU_MC44_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CA6u)

/** \brief 2CA8, Read Data and Bit Flip Register 36 */
#define MTU_MC44_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CA8u)

/** \brief 2CAA, Read Data and Bit Flip Register 37 */
#define MTU_MC44_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CAAu)

/** \brief 2CAC, Read Data and Bit Flip Register 38 */
#define MTU_MC44_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CACu)

/** \brief 2CAE, Read Data and Bit Flip Register 39 */
#define MTU_MC44_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CAEu)

/** \brief 2CB0, Read Data and Bit Flip Register 40 */
#define MTU_MC44_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CB0u)

/** \brief 2CB2, Read Data and Bit Flip Register 41 */
#define MTU_MC44_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CB2u)

/** \brief 2CB4, Read Data and Bit Flip Register 42 */
#define MTU_MC44_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CB4u)

/** \brief 2CB6, Read Data and Bit Flip Register 43 */
#define MTU_MC44_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CB6u)

/** \brief 2CB8, Read Data and Bit Flip Register 44 */
#define MTU_MC44_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CB8u)

/** \brief 2CBA, Read Data and Bit Flip Register 45 */
#define MTU_MC44_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CBAu)

/** \brief 2CBC, Read Data and Bit Flip Register 46 */
#define MTU_MC44_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CBCu)

/** \brief 2CBE, Read Data and Bit Flip Register 47 */
#define MTU_MC44_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CBEu)

/** \brief 2CC0, Read Data and Bit Flip Register 48 */
#define MTU_MC44_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CC0u)

/** \brief 2CC2, Read Data and Bit Flip Register 49 */
#define MTU_MC44_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CC2u)

/** \brief 2CC4, Read Data and Bit Flip Register 50 */
#define MTU_MC44_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CC4u)

/** \brief 2CC6, Read Data and Bit Flip Register 51 */
#define MTU_MC44_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CC6u)

/** \brief 2CC8, Read Data and Bit Flip Register 52 */
#define MTU_MC44_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CC8u)

/** \brief 2CCA, Read Data and Bit Flip Register 53 */
#define MTU_MC44_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CCAu)

/** \brief 2CCC, Read Data and Bit Flip Register 54 */
#define MTU_MC44_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CCCu)

/** \brief 2CCE, Read Data and Bit Flip Register 55 */
#define MTU_MC44_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CCEu)

/** \brief 2CD0, Read Data and Bit Flip Register 56 */
#define MTU_MC44_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CD0u)

/** \brief 2CD2, Read Data and Bit Flip Register 57 */
#define MTU_MC44_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CD2u)

/** \brief 2CD4, Read Data and Bit Flip Register 58 */
#define MTU_MC44_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CD4u)

/** \brief 2CD6, Read Data and Bit Flip Register 59 */
#define MTU_MC44_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CD6u)

/** \brief 2CD8, Read Data and Bit Flip Register 60 */
#define MTU_MC44_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CD8u)

/** \brief 2CDA, Read Data and Bit Flip Register 61 */
#define MTU_MC44_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CDAu)

/** \brief 2CDC, Read Data and Bit Flip Register 62 */
#define MTU_MC44_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CDCu)

/** \brief 2CDE, Read Data and Bit Flip Register 63 */
#define MTU_MC44_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CDEu)

/** \brief 2CE0, Read Data and Bit Flip Register 64 */
#define MTU_MC44_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CE0u)

/** \brief 2CE2, Read Data and Bit Flip Register 65 */
#define MTU_MC44_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CE2u)

/** \brief 2CE4, Read Data and Bit Flip Register 66 */
#define MTU_MC44_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063CE4u)

/** \brief 2CEE, Alarm Sources Configuration Register */
#define MTU_MC44_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0063CEEu)

/** \brief 2CF0, SSH Safety Faults Status Register  */
#define MTU_MC44_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0063CF0u)

/** \brief 2CF2, Error Information Register 0 */
#define MTU_MC44_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063CF2u)

/** \brief 2CF4, Error Information Register 1 */
#define MTU_MC44_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063CF4u)

/** \brief 2CF6, Error Information Register 2 */
#define MTU_MC44_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063CF6u)

/** \brief 2CF8, Error Information Register 3 */
#define MTU_MC44_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063CF8u)

/** \brief 2CFA, Error Information Register 4 */
#define MTU_MC44_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063CFAu)

/** \brief 2D00, Configuration Registers */
#define MTU_MC45_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063D00u)

/** \brief 2D02, Configuration Register 1 */
#define MTU_MC45_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063D02u)

/** \brief 2D04, MBIST Control Register */
#define MTU_MC45_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063D04u)

/** \brief 2D06, Status Register */
#define MTU_MC45_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063D06u)

/** \brief 2D08, Range Register, single address mode */
#define MTU_MC45_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063D08u)

/** \brief 2D0C, Revision ID Register */
#define MTU_MC45_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0063D0Cu)

/** \brief 2D0E, ECC Safety Register */
#define MTU_MC45_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0063D0Eu)

/** \brief 2D10, Memory ECC Detection Register */
#define MTU_MC45_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063D10u)

/** \brief 2D12, Error Tracking Register 0 */
#define MTU_MC45_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063D12u)

/** \brief 2D14, Error Tracking Register 1 */
#define MTU_MC45_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063D14u)

/** \brief 2D16, Error Tracking Register 2 */
#define MTU_MC45_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063D16u)

/** \brief 2D18, Error Tracking Register 3 */
#define MTU_MC45_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063D18u)

/** \brief 2D1A, Error Tracking Register 4 */
#define MTU_MC45_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063D1Au)

/** \brief 2D60, Read Data and Bit Flip Register 0 */
#define MTU_MC45_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D60u)

/** \brief 2D62, Read Data and Bit Flip Register 1 */
#define MTU_MC45_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D62u)

/** \brief 2D64, Read Data and Bit Flip Register 2 */
#define MTU_MC45_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D64u)

/** \brief 2D66, Read Data and Bit Flip Register 3 */
#define MTU_MC45_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D66u)

/** \brief 2D68, Read Data and Bit Flip Register 4 */
#define MTU_MC45_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D68u)

/** \brief 2D6A, Read Data and Bit Flip Register 5 */
#define MTU_MC45_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D6Au)

/** \brief 2D6C, Read Data and Bit Flip Register 6 */
#define MTU_MC45_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D6Cu)

/** \brief 2D6E, Read Data and Bit Flip Register 7 */
#define MTU_MC45_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D6Eu)

/** \brief 2D70, Read Data and Bit Flip Register 8 */
#define MTU_MC45_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D70u)

/** \brief 2D72, Read Data and Bit Flip Register 9 */
#define MTU_MC45_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D72u)

/** \brief 2D74, Read Data and Bit Flip Register 10 */
#define MTU_MC45_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D74u)

/** \brief 2D76, Read Data and Bit Flip Register 11 */
#define MTU_MC45_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D76u)

/** \brief 2D78, Read Data and Bit Flip Register 12 */
#define MTU_MC45_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D78u)

/** \brief 2D7A, Read Data and Bit Flip Register 13 */
#define MTU_MC45_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D7Au)

/** \brief 2D7C, Read Data and Bit Flip Register 14 */
#define MTU_MC45_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D7Cu)

/** \brief 2D7E, Read Data and Bit Flip Register 15 */
#define MTU_MC45_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D7Eu)

/** \brief 2D80, Read Data and Bit Flip Register 16 */
#define MTU_MC45_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D80u)

/** \brief 2D82, Read Data and Bit Flip Register 17 */
#define MTU_MC45_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D82u)

/** \brief 2D84, Read Data and Bit Flip Register 18 */
#define MTU_MC45_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D84u)

/** \brief 2D86, Read Data and Bit Flip Register 19 */
#define MTU_MC45_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D86u)

/** \brief 2D88, Read Data and Bit Flip Register 20 */
#define MTU_MC45_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D88u)

/** \brief 2D8A, Read Data and Bit Flip Register 21 */
#define MTU_MC45_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D8Au)

/** \brief 2D8C, Read Data and Bit Flip Register 22 */
#define MTU_MC45_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D8Cu)

/** \brief 2D8E, Read Data and Bit Flip Register 23 */
#define MTU_MC45_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D8Eu)

/** \brief 2D90, Read Data and Bit Flip Register 24 */
#define MTU_MC45_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D90u)

/** \brief 2D92, Read Data and Bit Flip Register 25 */
#define MTU_MC45_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D92u)

/** \brief 2D94, Read Data and Bit Flip Register 26 */
#define MTU_MC45_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D94u)

/** \brief 2D96, Read Data and Bit Flip Register 27 */
#define MTU_MC45_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D96u)

/** \brief 2D98, Read Data and Bit Flip Register 28 */
#define MTU_MC45_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D98u)

/** \brief 2D9A, Read Data and Bit Flip Register 29 */
#define MTU_MC45_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D9Au)

/** \brief 2D9C, Read Data and Bit Flip Register 30 */
#define MTU_MC45_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D9Cu)

/** \brief 2D9E, Read Data and Bit Flip Register 31 */
#define MTU_MC45_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063D9Eu)

/** \brief 2DA0, Read Data and Bit Flip Register 32 */
#define MTU_MC45_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DA0u)

/** \brief 2DA2, Read Data and Bit Flip Register 33 */
#define MTU_MC45_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DA2u)

/** \brief 2DA4, Read Data and Bit Flip Register 34 */
#define MTU_MC45_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DA4u)

/** \brief 2DA6, Read Data and Bit Flip Register 35 */
#define MTU_MC45_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DA6u)

/** \brief 2DA8, Read Data and Bit Flip Register 36 */
#define MTU_MC45_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DA8u)

/** \brief 2DAA, Read Data and Bit Flip Register 37 */
#define MTU_MC45_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DAAu)

/** \brief 2DAC, Read Data and Bit Flip Register 38 */
#define MTU_MC45_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DACu)

/** \brief 2DAE, Read Data and Bit Flip Register 39 */
#define MTU_MC45_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DAEu)

/** \brief 2DB0, Read Data and Bit Flip Register 40 */
#define MTU_MC45_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DB0u)

/** \brief 2DB2, Read Data and Bit Flip Register 41 */
#define MTU_MC45_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DB2u)

/** \brief 2DB4, Read Data and Bit Flip Register 42 */
#define MTU_MC45_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DB4u)

/** \brief 2DB6, Read Data and Bit Flip Register 43 */
#define MTU_MC45_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DB6u)

/** \brief 2DB8, Read Data and Bit Flip Register 44 */
#define MTU_MC45_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DB8u)

/** \brief 2DBA, Read Data and Bit Flip Register 45 */
#define MTU_MC45_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DBAu)

/** \brief 2DBC, Read Data and Bit Flip Register 46 */
#define MTU_MC45_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DBCu)

/** \brief 2DBE, Read Data and Bit Flip Register 47 */
#define MTU_MC45_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DBEu)

/** \brief 2DC0, Read Data and Bit Flip Register 48 */
#define MTU_MC45_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DC0u)

/** \brief 2DC2, Read Data and Bit Flip Register 49 */
#define MTU_MC45_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DC2u)

/** \brief 2DC4, Read Data and Bit Flip Register 50 */
#define MTU_MC45_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DC4u)

/** \brief 2DC6, Read Data and Bit Flip Register 51 */
#define MTU_MC45_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DC6u)

/** \brief 2DC8, Read Data and Bit Flip Register 52 */
#define MTU_MC45_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DC8u)

/** \brief 2DCA, Read Data and Bit Flip Register 53 */
#define MTU_MC45_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DCAu)

/** \brief 2DCC, Read Data and Bit Flip Register 54 */
#define MTU_MC45_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DCCu)

/** \brief 2DCE, Read Data and Bit Flip Register 55 */
#define MTU_MC45_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DCEu)

/** \brief 2DD0, Read Data and Bit Flip Register 56 */
#define MTU_MC45_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DD0u)

/** \brief 2DD2, Read Data and Bit Flip Register 57 */
#define MTU_MC45_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DD2u)

/** \brief 2DD4, Read Data and Bit Flip Register 58 */
#define MTU_MC45_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DD4u)

/** \brief 2DD6, Read Data and Bit Flip Register 59 */
#define MTU_MC45_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DD6u)

/** \brief 2DD8, Read Data and Bit Flip Register 60 */
#define MTU_MC45_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DD8u)

/** \brief 2DDA, Read Data and Bit Flip Register 61 */
#define MTU_MC45_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DDAu)

/** \brief 2DDC, Read Data and Bit Flip Register 62 */
#define MTU_MC45_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DDCu)

/** \brief 2DDE, Read Data and Bit Flip Register 63 */
#define MTU_MC45_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DDEu)

/** \brief 2DE0, Read Data and Bit Flip Register 64 */
#define MTU_MC45_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DE0u)

/** \brief 2DE2, Read Data and Bit Flip Register 65 */
#define MTU_MC45_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DE2u)

/** \brief 2DE4, Read Data and Bit Flip Register 66 */
#define MTU_MC45_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063DE4u)

/** \brief 2DEE, Alarm Sources Configuration Register */
#define MTU_MC45_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0063DEEu)

/** \brief 2DF0, SSH Safety Faults Status Register  */
#define MTU_MC45_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0063DF0u)

/** \brief 2DF2, Error Information Register 0 */
#define MTU_MC45_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063DF2u)

/** \brief 2DF4, Error Information Register 1 */
#define MTU_MC45_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063DF4u)

/** \brief 2DF6, Error Information Register 2 */
#define MTU_MC45_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063DF6u)

/** \brief 2DF8, Error Information Register 3 */
#define MTU_MC45_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063DF8u)

/** \brief 2DFA, Error Information Register 4 */
#define MTU_MC45_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063DFAu)

/** \brief 2E00, Configuration Registers */
#define MTU_MC46_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063E00u)

/** \brief 2E02, Configuration Register 1 */
#define MTU_MC46_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063E02u)

/** \brief 2E04, MBIST Control Register */
#define MTU_MC46_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063E04u)

/** \brief 2E06, Status Register */
#define MTU_MC46_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063E06u)

/** \brief 2E08, Range Register, single address mode */
#define MTU_MC46_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063E08u)

/** \brief 2E0C, Revision ID Register */
#define MTU_MC46_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0063E0Cu)

/** \brief 2E0E, ECC Safety Register */
#define MTU_MC46_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0063E0Eu)

/** \brief 2E10, Memory ECC Detection Register */
#define MTU_MC46_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063E10u)

/** \brief 2E12, Error Tracking Register 0 */
#define MTU_MC46_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063E12u)

/** \brief 2E14, Error Tracking Register 1 */
#define MTU_MC46_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063E14u)

/** \brief 2E16, Error Tracking Register 2 */
#define MTU_MC46_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063E16u)

/** \brief 2E18, Error Tracking Register 3 */
#define MTU_MC46_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063E18u)

/** \brief 2E1A, Error Tracking Register 4 */
#define MTU_MC46_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063E1Au)

/** \brief 2E60, Read Data and Bit Flip Register 0 */
#define MTU_MC46_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E60u)

/** \brief 2E62, Read Data and Bit Flip Register 1 */
#define MTU_MC46_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E62u)

/** \brief 2E64, Read Data and Bit Flip Register 2 */
#define MTU_MC46_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E64u)

/** \brief 2E66, Read Data and Bit Flip Register 3 */
#define MTU_MC46_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E66u)

/** \brief 2E68, Read Data and Bit Flip Register 4 */
#define MTU_MC46_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E68u)

/** \brief 2E6A, Read Data and Bit Flip Register 5 */
#define MTU_MC46_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E6Au)

/** \brief 2E6C, Read Data and Bit Flip Register 6 */
#define MTU_MC46_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E6Cu)

/** \brief 2E6E, Read Data and Bit Flip Register 7 */
#define MTU_MC46_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E6Eu)

/** \brief 2E70, Read Data and Bit Flip Register 8 */
#define MTU_MC46_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E70u)

/** \brief 2E72, Read Data and Bit Flip Register 9 */
#define MTU_MC46_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E72u)

/** \brief 2E74, Read Data and Bit Flip Register 10 */
#define MTU_MC46_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E74u)

/** \brief 2E76, Read Data and Bit Flip Register 11 */
#define MTU_MC46_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E76u)

/** \brief 2E78, Read Data and Bit Flip Register 12 */
#define MTU_MC46_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E78u)

/** \brief 2E7A, Read Data and Bit Flip Register 13 */
#define MTU_MC46_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E7Au)

/** \brief 2E7C, Read Data and Bit Flip Register 14 */
#define MTU_MC46_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E7Cu)

/** \brief 2E7E, Read Data and Bit Flip Register 15 */
#define MTU_MC46_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E7Eu)

/** \brief 2E80, Read Data and Bit Flip Register 16 */
#define MTU_MC46_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E80u)

/** \brief 2E82, Read Data and Bit Flip Register 17 */
#define MTU_MC46_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E82u)

/** \brief 2E84, Read Data and Bit Flip Register 18 */
#define MTU_MC46_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E84u)

/** \brief 2E86, Read Data and Bit Flip Register 19 */
#define MTU_MC46_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E86u)

/** \brief 2E88, Read Data and Bit Flip Register 20 */
#define MTU_MC46_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E88u)

/** \brief 2E8A, Read Data and Bit Flip Register 21 */
#define MTU_MC46_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E8Au)

/** \brief 2E8C, Read Data and Bit Flip Register 22 */
#define MTU_MC46_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E8Cu)

/** \brief 2E8E, Read Data and Bit Flip Register 23 */
#define MTU_MC46_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E8Eu)

/** \brief 2E90, Read Data and Bit Flip Register 24 */
#define MTU_MC46_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E90u)

/** \brief 2E92, Read Data and Bit Flip Register 25 */
#define MTU_MC46_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E92u)

/** \brief 2E94, Read Data and Bit Flip Register 26 */
#define MTU_MC46_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E94u)

/** \brief 2E96, Read Data and Bit Flip Register 27 */
#define MTU_MC46_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E96u)

/** \brief 2E98, Read Data and Bit Flip Register 28 */
#define MTU_MC46_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E98u)

/** \brief 2E9A, Read Data and Bit Flip Register 29 */
#define MTU_MC46_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E9Au)

/** \brief 2E9C, Read Data and Bit Flip Register 30 */
#define MTU_MC46_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E9Cu)

/** \brief 2E9E, Read Data and Bit Flip Register 31 */
#define MTU_MC46_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063E9Eu)

/** \brief 2EA0, Read Data and Bit Flip Register 32 */
#define MTU_MC46_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EA0u)

/** \brief 2EA2, Read Data and Bit Flip Register 33 */
#define MTU_MC46_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EA2u)

/** \brief 2EA4, Read Data and Bit Flip Register 34 */
#define MTU_MC46_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EA4u)

/** \brief 2EA6, Read Data and Bit Flip Register 35 */
#define MTU_MC46_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EA6u)

/** \brief 2EA8, Read Data and Bit Flip Register 36 */
#define MTU_MC46_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EA8u)

/** \brief 2EAA, Read Data and Bit Flip Register 37 */
#define MTU_MC46_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EAAu)

/** \brief 2EAC, Read Data and Bit Flip Register 38 */
#define MTU_MC46_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EACu)

/** \brief 2EAE, Read Data and Bit Flip Register 39 */
#define MTU_MC46_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EAEu)

/** \brief 2EB0, Read Data and Bit Flip Register 40 */
#define MTU_MC46_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EB0u)

/** \brief 2EB2, Read Data and Bit Flip Register 41 */
#define MTU_MC46_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EB2u)

/** \brief 2EB4, Read Data and Bit Flip Register 42 */
#define MTU_MC46_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EB4u)

/** \brief 2EB6, Read Data and Bit Flip Register 43 */
#define MTU_MC46_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EB6u)

/** \brief 2EB8, Read Data and Bit Flip Register 44 */
#define MTU_MC46_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EB8u)

/** \brief 2EBA, Read Data and Bit Flip Register 45 */
#define MTU_MC46_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EBAu)

/** \brief 2EBC, Read Data and Bit Flip Register 46 */
#define MTU_MC46_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EBCu)

/** \brief 2EBE, Read Data and Bit Flip Register 47 */
#define MTU_MC46_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EBEu)

/** \brief 2EC0, Read Data and Bit Flip Register 48 */
#define MTU_MC46_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EC0u)

/** \brief 2EC2, Read Data and Bit Flip Register 49 */
#define MTU_MC46_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EC2u)

/** \brief 2EC4, Read Data and Bit Flip Register 50 */
#define MTU_MC46_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EC4u)

/** \brief 2EC6, Read Data and Bit Flip Register 51 */
#define MTU_MC46_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EC6u)

/** \brief 2EC8, Read Data and Bit Flip Register 52 */
#define MTU_MC46_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EC8u)

/** \brief 2ECA, Read Data and Bit Flip Register 53 */
#define MTU_MC46_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ECAu)

/** \brief 2ECC, Read Data and Bit Flip Register 54 */
#define MTU_MC46_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ECCu)

/** \brief 2ECE, Read Data and Bit Flip Register 55 */
#define MTU_MC46_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ECEu)

/** \brief 2ED0, Read Data and Bit Flip Register 56 */
#define MTU_MC46_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ED0u)

/** \brief 2ED2, Read Data and Bit Flip Register 57 */
#define MTU_MC46_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ED2u)

/** \brief 2ED4, Read Data and Bit Flip Register 58 */
#define MTU_MC46_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ED4u)

/** \brief 2ED6, Read Data and Bit Flip Register 59 */
#define MTU_MC46_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ED6u)

/** \brief 2ED8, Read Data and Bit Flip Register 60 */
#define MTU_MC46_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063ED8u)

/** \brief 2EDA, Read Data and Bit Flip Register 61 */
#define MTU_MC46_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EDAu)

/** \brief 2EDC, Read Data and Bit Flip Register 62 */
#define MTU_MC46_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EDCu)

/** \brief 2EDE, Read Data and Bit Flip Register 63 */
#define MTU_MC46_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EDEu)

/** \brief 2EE0, Read Data and Bit Flip Register 64 */
#define MTU_MC46_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EE0u)

/** \brief 2EE2, Read Data and Bit Flip Register 65 */
#define MTU_MC46_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EE2u)

/** \brief 2EE4, Read Data and Bit Flip Register 66 */
#define MTU_MC46_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063EE4u)

/** \brief 2EEE, Alarm Sources Configuration Register */
#define MTU_MC46_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0063EEEu)

/** \brief 2EF0, SSH Safety Faults Status Register  */
#define MTU_MC46_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0063EF0u)

/** \brief 2EF2, Error Information Register 0 */
#define MTU_MC46_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063EF2u)

/** \brief 2EF4, Error Information Register 1 */
#define MTU_MC46_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063EF4u)

/** \brief 2EF6, Error Information Register 2 */
#define MTU_MC46_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063EF6u)

/** \brief 2EF8, Error Information Register 3 */
#define MTU_MC46_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063EF8u)

/** \brief 2EFA, Error Information Register 4 */
#define MTU_MC46_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063EFAu)

/** \brief 2F00, Configuration Registers */
#define MTU_MC47_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0063F00u)

/** \brief 2F02, Configuration Register 1 */
#define MTU_MC47_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0063F02u)

/** \brief 2F04, MBIST Control Register */
#define MTU_MC47_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0063F04u)

/** \brief 2F06, Status Register */
#define MTU_MC47_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0063F06u)

/** \brief 2F08, Range Register, single address mode */
#define MTU_MC47_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0063F08u)

/** \brief 2F0C, Revision ID Register */
#define MTU_MC47_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0063F0Cu)

/** \brief 2F0E, ECC Safety Register */
#define MTU_MC47_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0063F0Eu)

/** \brief 2F10, Memory ECC Detection Register */
#define MTU_MC47_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0063F10u)

/** \brief 2F12, Error Tracking Register 0 */
#define MTU_MC47_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063F12u)

/** \brief 2F14, Error Tracking Register 1 */
#define MTU_MC47_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063F14u)

/** \brief 2F16, Error Tracking Register 2 */
#define MTU_MC47_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063F16u)

/** \brief 2F18, Error Tracking Register 3 */
#define MTU_MC47_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063F18u)

/** \brief 2F1A, Error Tracking Register 4 */
#define MTU_MC47_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0063F1Au)

/** \brief 2F60, Read Data and Bit Flip Register 0 */
#define MTU_MC47_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F60u)

/** \brief 2F62, Read Data and Bit Flip Register 1 */
#define MTU_MC47_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F62u)

/** \brief 2F64, Read Data and Bit Flip Register 2 */
#define MTU_MC47_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F64u)

/** \brief 2F66, Read Data and Bit Flip Register 3 */
#define MTU_MC47_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F66u)

/** \brief 2F68, Read Data and Bit Flip Register 4 */
#define MTU_MC47_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F68u)

/** \brief 2F6A, Read Data and Bit Flip Register 5 */
#define MTU_MC47_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F6Au)

/** \brief 2F6C, Read Data and Bit Flip Register 6 */
#define MTU_MC47_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F6Cu)

/** \brief 2F6E, Read Data and Bit Flip Register 7 */
#define MTU_MC47_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F6Eu)

/** \brief 2F70, Read Data and Bit Flip Register 8 */
#define MTU_MC47_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F70u)

/** \brief 2F72, Read Data and Bit Flip Register 9 */
#define MTU_MC47_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F72u)

/** \brief 2F74, Read Data and Bit Flip Register 10 */
#define MTU_MC47_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F74u)

/** \brief 2F76, Read Data and Bit Flip Register 11 */
#define MTU_MC47_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F76u)

/** \brief 2F78, Read Data and Bit Flip Register 12 */
#define MTU_MC47_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F78u)

/** \brief 2F7A, Read Data and Bit Flip Register 13 */
#define MTU_MC47_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F7Au)

/** \brief 2F7C, Read Data and Bit Flip Register 14 */
#define MTU_MC47_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F7Cu)

/** \brief 2F7E, Read Data and Bit Flip Register 15 */
#define MTU_MC47_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F7Eu)

/** \brief 2F80, Read Data and Bit Flip Register 16 */
#define MTU_MC47_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F80u)

/** \brief 2F82, Read Data and Bit Flip Register 17 */
#define MTU_MC47_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F82u)

/** \brief 2F84, Read Data and Bit Flip Register 18 */
#define MTU_MC47_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F84u)

/** \brief 2F86, Read Data and Bit Flip Register 19 */
#define MTU_MC47_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F86u)

/** \brief 2F88, Read Data and Bit Flip Register 20 */
#define MTU_MC47_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F88u)

/** \brief 2F8A, Read Data and Bit Flip Register 21 */
#define MTU_MC47_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F8Au)

/** \brief 2F8C, Read Data and Bit Flip Register 22 */
#define MTU_MC47_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F8Cu)

/** \brief 2F8E, Read Data and Bit Flip Register 23 */
#define MTU_MC47_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F8Eu)

/** \brief 2F90, Read Data and Bit Flip Register 24 */
#define MTU_MC47_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F90u)

/** \brief 2F92, Read Data and Bit Flip Register 25 */
#define MTU_MC47_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F92u)

/** \brief 2F94, Read Data and Bit Flip Register 26 */
#define MTU_MC47_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F94u)

/** \brief 2F96, Read Data and Bit Flip Register 27 */
#define MTU_MC47_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F96u)

/** \brief 2F98, Read Data and Bit Flip Register 28 */
#define MTU_MC47_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F98u)

/** \brief 2F9A, Read Data and Bit Flip Register 29 */
#define MTU_MC47_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F9Au)

/** \brief 2F9C, Read Data and Bit Flip Register 30 */
#define MTU_MC47_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F9Cu)

/** \brief 2F9E, Read Data and Bit Flip Register 31 */
#define MTU_MC47_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063F9Eu)

/** \brief 2FA0, Read Data and Bit Flip Register 32 */
#define MTU_MC47_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FA0u)

/** \brief 2FA2, Read Data and Bit Flip Register 33 */
#define MTU_MC47_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FA2u)

/** \brief 2FA4, Read Data and Bit Flip Register 34 */
#define MTU_MC47_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FA4u)

/** \brief 2FA6, Read Data and Bit Flip Register 35 */
#define MTU_MC47_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FA6u)

/** \brief 2FA8, Read Data and Bit Flip Register 36 */
#define MTU_MC47_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FA8u)

/** \brief 2FAA, Read Data and Bit Flip Register 37 */
#define MTU_MC47_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FAAu)

/** \brief 2FAC, Read Data and Bit Flip Register 38 */
#define MTU_MC47_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FACu)

/** \brief 2FAE, Read Data and Bit Flip Register 39 */
#define MTU_MC47_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FAEu)

/** \brief 2FB0, Read Data and Bit Flip Register 40 */
#define MTU_MC47_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FB0u)

/** \brief 2FB2, Read Data and Bit Flip Register 41 */
#define MTU_MC47_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FB2u)

/** \brief 2FB4, Read Data and Bit Flip Register 42 */
#define MTU_MC47_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FB4u)

/** \brief 2FB6, Read Data and Bit Flip Register 43 */
#define MTU_MC47_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FB6u)

/** \brief 2FB8, Read Data and Bit Flip Register 44 */
#define MTU_MC47_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FB8u)

/** \brief 2FBA, Read Data and Bit Flip Register 45 */
#define MTU_MC47_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FBAu)

/** \brief 2FBC, Read Data and Bit Flip Register 46 */
#define MTU_MC47_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FBCu)

/** \brief 2FBE, Read Data and Bit Flip Register 47 */
#define MTU_MC47_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FBEu)

/** \brief 2FC0, Read Data and Bit Flip Register 48 */
#define MTU_MC47_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FC0u)

/** \brief 2FC2, Read Data and Bit Flip Register 49 */
#define MTU_MC47_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FC2u)

/** \brief 2FC4, Read Data and Bit Flip Register 50 */
#define MTU_MC47_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FC4u)

/** \brief 2FC6, Read Data and Bit Flip Register 51 */
#define MTU_MC47_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FC6u)

/** \brief 2FC8, Read Data and Bit Flip Register 52 */
#define MTU_MC47_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FC8u)

/** \brief 2FCA, Read Data and Bit Flip Register 53 */
#define MTU_MC47_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FCAu)

/** \brief 2FCC, Read Data and Bit Flip Register 54 */
#define MTU_MC47_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FCCu)

/** \brief 2FCE, Read Data and Bit Flip Register 55 */
#define MTU_MC47_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FCEu)

/** \brief 2FD0, Read Data and Bit Flip Register 56 */
#define MTU_MC47_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FD0u)

/** \brief 2FD2, Read Data and Bit Flip Register 57 */
#define MTU_MC47_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FD2u)

/** \brief 2FD4, Read Data and Bit Flip Register 58 */
#define MTU_MC47_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FD4u)

/** \brief 2FD6, Read Data and Bit Flip Register 59 */
#define MTU_MC47_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FD6u)

/** \brief 2FD8, Read Data and Bit Flip Register 60 */
#define MTU_MC47_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FD8u)

/** \brief 2FDA, Read Data and Bit Flip Register 61 */
#define MTU_MC47_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FDAu)

/** \brief 2FDC, Read Data and Bit Flip Register 62 */
#define MTU_MC47_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FDCu)

/** \brief 2FDE, Read Data and Bit Flip Register 63 */
#define MTU_MC47_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FDEu)

/** \brief 2FE0, Read Data and Bit Flip Register 64 */
#define MTU_MC47_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FE0u)

/** \brief 2FE2, Read Data and Bit Flip Register 65 */
#define MTU_MC47_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FE2u)

/** \brief 2FE4, Read Data and Bit Flip Register 66 */
#define MTU_MC47_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0063FE4u)

/** \brief 2FEE, Alarm Sources Configuration Register */
#define MTU_MC47_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0063FEEu)

/** \brief 2FF0, SSH Safety Faults Status Register  */
#define MTU_MC47_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0063FF0u)

/** \brief 2FF2, Error Information Register 0 */
#define MTU_MC47_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063FF2u)

/** \brief 2FF4, Error Information Register 1 */
#define MTU_MC47_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063FF4u)

/** \brief 2FF6, Error Information Register 2 */
#define MTU_MC47_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063FF6u)

/** \brief 2FF8, Error Information Register 3 */
#define MTU_MC47_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063FF8u)

/** \brief 2FFA, Error Information Register 4 */
#define MTU_MC47_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0063FFAu)

/** \brief 3000, Configuration Registers */
#define MTU_MC48_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064000u)

/** \brief 3002, Configuration Register 1 */
#define MTU_MC48_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064002u)

/** \brief 3004, MBIST Control Register */
#define MTU_MC48_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064004u)

/** \brief 3006, Status Register */
#define MTU_MC48_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064006u)

/** \brief 3008, Range Register, single address mode */
#define MTU_MC48_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064008u)

/** \brief 300C, Revision ID Register */
#define MTU_MC48_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006400Cu)

/** \brief 300E, ECC Safety Register */
#define MTU_MC48_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006400Eu)

/** \brief 3010, Memory ECC Detection Register */
#define MTU_MC48_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064010u)

/** \brief 3012, Error Tracking Register 0 */
#define MTU_MC48_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064012u)

/** \brief 3014, Error Tracking Register 1 */
#define MTU_MC48_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064014u)

/** \brief 3016, Error Tracking Register 2 */
#define MTU_MC48_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064016u)

/** \brief 3018, Error Tracking Register 3 */
#define MTU_MC48_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064018u)

/** \brief 301A, Error Tracking Register 4 */
#define MTU_MC48_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006401Au)

/** \brief 3060, Read Data and Bit Flip Register 0 */
#define MTU_MC48_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064060u)

/** \brief 3062, Read Data and Bit Flip Register 1 */
#define MTU_MC48_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064062u)

/** \brief 3064, Read Data and Bit Flip Register 2 */
#define MTU_MC48_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064064u)

/** \brief 3066, Read Data and Bit Flip Register 3 */
#define MTU_MC48_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064066u)

/** \brief 3068, Read Data and Bit Flip Register 4 */
#define MTU_MC48_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064068u)

/** \brief 306A, Read Data and Bit Flip Register 5 */
#define MTU_MC48_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006406Au)

/** \brief 306C, Read Data and Bit Flip Register 6 */
#define MTU_MC48_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006406Cu)

/** \brief 306E, Read Data and Bit Flip Register 7 */
#define MTU_MC48_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006406Eu)

/** \brief 3070, Read Data and Bit Flip Register 8 */
#define MTU_MC48_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064070u)

/** \brief 3072, Read Data and Bit Flip Register 9 */
#define MTU_MC48_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064072u)

/** \brief 3074, Read Data and Bit Flip Register 10 */
#define MTU_MC48_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064074u)

/** \brief 3076, Read Data and Bit Flip Register 11 */
#define MTU_MC48_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064076u)

/** \brief 3078, Read Data and Bit Flip Register 12 */
#define MTU_MC48_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064078u)

/** \brief 307A, Read Data and Bit Flip Register 13 */
#define MTU_MC48_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006407Au)

/** \brief 307C, Read Data and Bit Flip Register 14 */
#define MTU_MC48_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006407Cu)

/** \brief 307E, Read Data and Bit Flip Register 15 */
#define MTU_MC48_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006407Eu)

/** \brief 3080, Read Data and Bit Flip Register 16 */
#define MTU_MC48_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064080u)

/** \brief 3082, Read Data and Bit Flip Register 17 */
#define MTU_MC48_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064082u)

/** \brief 3084, Read Data and Bit Flip Register 18 */
#define MTU_MC48_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064084u)

/** \brief 3086, Read Data and Bit Flip Register 19 */
#define MTU_MC48_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064086u)

/** \brief 3088, Read Data and Bit Flip Register 20 */
#define MTU_MC48_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064088u)

/** \brief 308A, Read Data and Bit Flip Register 21 */
#define MTU_MC48_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006408Au)

/** \brief 308C, Read Data and Bit Flip Register 22 */
#define MTU_MC48_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006408Cu)

/** \brief 308E, Read Data and Bit Flip Register 23 */
#define MTU_MC48_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006408Eu)

/** \brief 3090, Read Data and Bit Flip Register 24 */
#define MTU_MC48_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064090u)

/** \brief 3092, Read Data and Bit Flip Register 25 */
#define MTU_MC48_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064092u)

/** \brief 3094, Read Data and Bit Flip Register 26 */
#define MTU_MC48_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064094u)

/** \brief 3096, Read Data and Bit Flip Register 27 */
#define MTU_MC48_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064096u)

/** \brief 3098, Read Data and Bit Flip Register 28 */
#define MTU_MC48_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064098u)

/** \brief 309A, Read Data and Bit Flip Register 29 */
#define MTU_MC48_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006409Au)

/** \brief 309C, Read Data and Bit Flip Register 30 */
#define MTU_MC48_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006409Cu)

/** \brief 309E, Read Data and Bit Flip Register 31 */
#define MTU_MC48_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006409Eu)

/** \brief 30A0, Read Data and Bit Flip Register 32 */
#define MTU_MC48_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640A0u)

/** \brief 30A2, Read Data and Bit Flip Register 33 */
#define MTU_MC48_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640A2u)

/** \brief 30A4, Read Data and Bit Flip Register 34 */
#define MTU_MC48_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640A4u)

/** \brief 30A6, Read Data and Bit Flip Register 35 */
#define MTU_MC48_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640A6u)

/** \brief 30A8, Read Data and Bit Flip Register 36 */
#define MTU_MC48_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640A8u)

/** \brief 30AA, Read Data and Bit Flip Register 37 */
#define MTU_MC48_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640AAu)

/** \brief 30AC, Read Data and Bit Flip Register 38 */
#define MTU_MC48_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640ACu)

/** \brief 30AE, Read Data and Bit Flip Register 39 */
#define MTU_MC48_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640AEu)

/** \brief 30B0, Read Data and Bit Flip Register 40 */
#define MTU_MC48_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640B0u)

/** \brief 30B2, Read Data and Bit Flip Register 41 */
#define MTU_MC48_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640B2u)

/** \brief 30B4, Read Data and Bit Flip Register 42 */
#define MTU_MC48_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640B4u)

/** \brief 30B6, Read Data and Bit Flip Register 43 */
#define MTU_MC48_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640B6u)

/** \brief 30B8, Read Data and Bit Flip Register 44 */
#define MTU_MC48_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640B8u)

/** \brief 30BA, Read Data and Bit Flip Register 45 */
#define MTU_MC48_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640BAu)

/** \brief 30BC, Read Data and Bit Flip Register 46 */
#define MTU_MC48_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640BCu)

/** \brief 30BE, Read Data and Bit Flip Register 47 */
#define MTU_MC48_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640BEu)

/** \brief 30C0, Read Data and Bit Flip Register 48 */
#define MTU_MC48_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640C0u)

/** \brief 30C2, Read Data and Bit Flip Register 49 */
#define MTU_MC48_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640C2u)

/** \brief 30C4, Read Data and Bit Flip Register 50 */
#define MTU_MC48_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640C4u)

/** \brief 30C6, Read Data and Bit Flip Register 51 */
#define MTU_MC48_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640C6u)

/** \brief 30C8, Read Data and Bit Flip Register 52 */
#define MTU_MC48_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640C8u)

/** \brief 30CA, Read Data and Bit Flip Register 53 */
#define MTU_MC48_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640CAu)

/** \brief 30CC, Read Data and Bit Flip Register 54 */
#define MTU_MC48_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640CCu)

/** \brief 30CE, Read Data and Bit Flip Register 55 */
#define MTU_MC48_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640CEu)

/** \brief 30D0, Read Data and Bit Flip Register 56 */
#define MTU_MC48_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640D0u)

/** \brief 30D2, Read Data and Bit Flip Register 57 */
#define MTU_MC48_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640D2u)

/** \brief 30D4, Read Data and Bit Flip Register 58 */
#define MTU_MC48_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640D4u)

/** \brief 30D6, Read Data and Bit Flip Register 59 */
#define MTU_MC48_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640D6u)

/** \brief 30D8, Read Data and Bit Flip Register 60 */
#define MTU_MC48_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640D8u)

/** \brief 30DA, Read Data and Bit Flip Register 61 */
#define MTU_MC48_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640DAu)

/** \brief 30DC, Read Data and Bit Flip Register 62 */
#define MTU_MC48_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640DCu)

/** \brief 30DE, Read Data and Bit Flip Register 63 */
#define MTU_MC48_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640DEu)

/** \brief 30E0, Read Data and Bit Flip Register 64 */
#define MTU_MC48_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640E0u)

/** \brief 30E2, Read Data and Bit Flip Register 65 */
#define MTU_MC48_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640E2u)

/** \brief 30E4, Read Data and Bit Flip Register 66 */
#define MTU_MC48_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00640E4u)

/** \brief 30EE, Alarm Sources Configuration Register */
#define MTU_MC48_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00640EEu)

/** \brief 30F0, SSH Safety Faults Status Register  */
#define MTU_MC48_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00640F0u)

/** \brief 30F2, Error Information Register 0 */
#define MTU_MC48_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00640F2u)

/** \brief 30F4, Error Information Register 1 */
#define MTU_MC48_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00640F4u)

/** \brief 30F6, Error Information Register 2 */
#define MTU_MC48_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00640F6u)

/** \brief 30F8, Error Information Register 3 */
#define MTU_MC48_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00640F8u)

/** \brief 30FA, Error Information Register 4 */
#define MTU_MC48_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00640FAu)

/** \brief 3100, Configuration Registers */
#define MTU_MC49_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064100u)

/** \brief 3102, Configuration Register 1 */
#define MTU_MC49_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064102u)

/** \brief 3104, MBIST Control Register */
#define MTU_MC49_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064104u)

/** \brief 3106, Status Register */
#define MTU_MC49_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064106u)

/** \brief 3108, Range Register, single address mode */
#define MTU_MC49_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064108u)

/** \brief 310C, Revision ID Register */
#define MTU_MC49_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006410Cu)

/** \brief 310E, ECC Safety Register */
#define MTU_MC49_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006410Eu)

/** \brief 3110, Memory ECC Detection Register */
#define MTU_MC49_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064110u)

/** \brief 3112, Error Tracking Register 0 */
#define MTU_MC49_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064112u)

/** \brief 3114, Error Tracking Register 1 */
#define MTU_MC49_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064114u)

/** \brief 3116, Error Tracking Register 2 */
#define MTU_MC49_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064116u)

/** \brief 3118, Error Tracking Register 3 */
#define MTU_MC49_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064118u)

/** \brief 311A, Error Tracking Register 4 */
#define MTU_MC49_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006411Au)

/** \brief 3160, Read Data and Bit Flip Register 0 */
#define MTU_MC49_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064160u)

/** \brief 3162, Read Data and Bit Flip Register 1 */
#define MTU_MC49_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064162u)

/** \brief 3164, Read Data and Bit Flip Register 2 */
#define MTU_MC49_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064164u)

/** \brief 3166, Read Data and Bit Flip Register 3 */
#define MTU_MC49_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064166u)

/** \brief 3168, Read Data and Bit Flip Register 4 */
#define MTU_MC49_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064168u)

/** \brief 316A, Read Data and Bit Flip Register 5 */
#define MTU_MC49_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006416Au)

/** \brief 316C, Read Data and Bit Flip Register 6 */
#define MTU_MC49_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006416Cu)

/** \brief 316E, Read Data and Bit Flip Register 7 */
#define MTU_MC49_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006416Eu)

/** \brief 3170, Read Data and Bit Flip Register 8 */
#define MTU_MC49_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064170u)

/** \brief 3172, Read Data and Bit Flip Register 9 */
#define MTU_MC49_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064172u)

/** \brief 3174, Read Data and Bit Flip Register 10 */
#define MTU_MC49_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064174u)

/** \brief 3176, Read Data and Bit Flip Register 11 */
#define MTU_MC49_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064176u)

/** \brief 3178, Read Data and Bit Flip Register 12 */
#define MTU_MC49_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064178u)

/** \brief 317A, Read Data and Bit Flip Register 13 */
#define MTU_MC49_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006417Au)

/** \brief 317C, Read Data and Bit Flip Register 14 */
#define MTU_MC49_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006417Cu)

/** \brief 317E, Read Data and Bit Flip Register 15 */
#define MTU_MC49_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006417Eu)

/** \brief 3180, Read Data and Bit Flip Register 16 */
#define MTU_MC49_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064180u)

/** \brief 3182, Read Data and Bit Flip Register 17 */
#define MTU_MC49_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064182u)

/** \brief 3184, Read Data and Bit Flip Register 18 */
#define MTU_MC49_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064184u)

/** \brief 3186, Read Data and Bit Flip Register 19 */
#define MTU_MC49_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064186u)

/** \brief 3188, Read Data and Bit Flip Register 20 */
#define MTU_MC49_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064188u)

/** \brief 318A, Read Data and Bit Flip Register 21 */
#define MTU_MC49_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006418Au)

/** \brief 318C, Read Data and Bit Flip Register 22 */
#define MTU_MC49_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006418Cu)

/** \brief 318E, Read Data and Bit Flip Register 23 */
#define MTU_MC49_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006418Eu)

/** \brief 3190, Read Data and Bit Flip Register 24 */
#define MTU_MC49_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064190u)

/** \brief 3192, Read Data and Bit Flip Register 25 */
#define MTU_MC49_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064192u)

/** \brief 3194, Read Data and Bit Flip Register 26 */
#define MTU_MC49_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064194u)

/** \brief 3196, Read Data and Bit Flip Register 27 */
#define MTU_MC49_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064196u)

/** \brief 3198, Read Data and Bit Flip Register 28 */
#define MTU_MC49_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064198u)

/** \brief 319A, Read Data and Bit Flip Register 29 */
#define MTU_MC49_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006419Au)

/** \brief 319C, Read Data and Bit Flip Register 30 */
#define MTU_MC49_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006419Cu)

/** \brief 319E, Read Data and Bit Flip Register 31 */
#define MTU_MC49_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006419Eu)

/** \brief 31A0, Read Data and Bit Flip Register 32 */
#define MTU_MC49_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641A0u)

/** \brief 31A2, Read Data and Bit Flip Register 33 */
#define MTU_MC49_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641A2u)

/** \brief 31A4, Read Data and Bit Flip Register 34 */
#define MTU_MC49_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641A4u)

/** \brief 31A6, Read Data and Bit Flip Register 35 */
#define MTU_MC49_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641A6u)

/** \brief 31A8, Read Data and Bit Flip Register 36 */
#define MTU_MC49_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641A8u)

/** \brief 31AA, Read Data and Bit Flip Register 37 */
#define MTU_MC49_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641AAu)

/** \brief 31AC, Read Data and Bit Flip Register 38 */
#define MTU_MC49_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641ACu)

/** \brief 31AE, Read Data and Bit Flip Register 39 */
#define MTU_MC49_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641AEu)

/** \brief 31B0, Read Data and Bit Flip Register 40 */
#define MTU_MC49_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641B0u)

/** \brief 31B2, Read Data and Bit Flip Register 41 */
#define MTU_MC49_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641B2u)

/** \brief 31B4, Read Data and Bit Flip Register 42 */
#define MTU_MC49_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641B4u)

/** \brief 31B6, Read Data and Bit Flip Register 43 */
#define MTU_MC49_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641B6u)

/** \brief 31B8, Read Data and Bit Flip Register 44 */
#define MTU_MC49_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641B8u)

/** \brief 31BA, Read Data and Bit Flip Register 45 */
#define MTU_MC49_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641BAu)

/** \brief 31BC, Read Data and Bit Flip Register 46 */
#define MTU_MC49_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641BCu)

/** \brief 31BE, Read Data and Bit Flip Register 47 */
#define MTU_MC49_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641BEu)

/** \brief 31C0, Read Data and Bit Flip Register 48 */
#define MTU_MC49_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641C0u)

/** \brief 31C2, Read Data and Bit Flip Register 49 */
#define MTU_MC49_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641C2u)

/** \brief 31C4, Read Data and Bit Flip Register 50 */
#define MTU_MC49_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641C4u)

/** \brief 31C6, Read Data and Bit Flip Register 51 */
#define MTU_MC49_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641C6u)

/** \brief 31C8, Read Data and Bit Flip Register 52 */
#define MTU_MC49_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641C8u)

/** \brief 31CA, Read Data and Bit Flip Register 53 */
#define MTU_MC49_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641CAu)

/** \brief 31CC, Read Data and Bit Flip Register 54 */
#define MTU_MC49_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641CCu)

/** \brief 31CE, Read Data and Bit Flip Register 55 */
#define MTU_MC49_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641CEu)

/** \brief 31D0, Read Data and Bit Flip Register 56 */
#define MTU_MC49_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641D0u)

/** \brief 31D2, Read Data and Bit Flip Register 57 */
#define MTU_MC49_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641D2u)

/** \brief 31D4, Read Data and Bit Flip Register 58 */
#define MTU_MC49_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641D4u)

/** \brief 31D6, Read Data and Bit Flip Register 59 */
#define MTU_MC49_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641D6u)

/** \brief 31D8, Read Data and Bit Flip Register 60 */
#define MTU_MC49_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641D8u)

/** \brief 31DA, Read Data and Bit Flip Register 61 */
#define MTU_MC49_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641DAu)

/** \brief 31DC, Read Data and Bit Flip Register 62 */
#define MTU_MC49_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641DCu)

/** \brief 31DE, Read Data and Bit Flip Register 63 */
#define MTU_MC49_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641DEu)

/** \brief 31E0, Read Data and Bit Flip Register 64 */
#define MTU_MC49_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641E0u)

/** \brief 31E2, Read Data and Bit Flip Register 65 */
#define MTU_MC49_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641E2u)

/** \brief 31E4, Read Data and Bit Flip Register 66 */
#define MTU_MC49_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00641E4u)

/** \brief 31EE, Alarm Sources Configuration Register */
#define MTU_MC49_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00641EEu)

/** \brief 31F0, SSH Safety Faults Status Register  */
#define MTU_MC49_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00641F0u)

/** \brief 31F2, Error Information Register 0 */
#define MTU_MC49_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00641F2u)

/** \brief 31F4, Error Information Register 1 */
#define MTU_MC49_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00641F4u)

/** \brief 31F6, Error Information Register 2 */
#define MTU_MC49_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00641F6u)

/** \brief 31F8, Error Information Register 3 */
#define MTU_MC49_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00641F8u)

/** \brief 31FA, Error Information Register 4 */
#define MTU_MC49_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00641FAu)

/** \brief 3200, Configuration Registers */
#define MTU_MC50_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064200u)

/** \brief 3202, Configuration Register 1 */
#define MTU_MC50_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064202u)

/** \brief 3204, MBIST Control Register */
#define MTU_MC50_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064204u)

/** \brief 3206, Status Register */
#define MTU_MC50_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064206u)

/** \brief 3208, Range Register, single address mode */
#define MTU_MC50_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064208u)

/** \brief 320C, Revision ID Register */
#define MTU_MC50_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006420Cu)

/** \brief 320E, ECC Safety Register */
#define MTU_MC50_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006420Eu)

/** \brief 3210, Memory ECC Detection Register */
#define MTU_MC50_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064210u)

/** \brief 3212, Error Tracking Register 0 */
#define MTU_MC50_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064212u)

/** \brief 3214, Error Tracking Register 1 */
#define MTU_MC50_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064214u)

/** \brief 3216, Error Tracking Register 2 */
#define MTU_MC50_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064216u)

/** \brief 3218, Error Tracking Register 3 */
#define MTU_MC50_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064218u)

/** \brief 321A, Error Tracking Register 4 */
#define MTU_MC50_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006421Au)

/** \brief 3260, Read Data and Bit Flip Register 0 */
#define MTU_MC50_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064260u)

/** \brief 3262, Read Data and Bit Flip Register 1 */
#define MTU_MC50_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064262u)

/** \brief 3264, Read Data and Bit Flip Register 2 */
#define MTU_MC50_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064264u)

/** \brief 3266, Read Data and Bit Flip Register 3 */
#define MTU_MC50_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064266u)

/** \brief 3268, Read Data and Bit Flip Register 4 */
#define MTU_MC50_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064268u)

/** \brief 326A, Read Data and Bit Flip Register 5 */
#define MTU_MC50_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006426Au)

/** \brief 326C, Read Data and Bit Flip Register 6 */
#define MTU_MC50_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006426Cu)

/** \brief 326E, Read Data and Bit Flip Register 7 */
#define MTU_MC50_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006426Eu)

/** \brief 3270, Read Data and Bit Flip Register 8 */
#define MTU_MC50_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064270u)

/** \brief 3272, Read Data and Bit Flip Register 9 */
#define MTU_MC50_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064272u)

/** \brief 3274, Read Data and Bit Flip Register 10 */
#define MTU_MC50_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064274u)

/** \brief 3276, Read Data and Bit Flip Register 11 */
#define MTU_MC50_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064276u)

/** \brief 3278, Read Data and Bit Flip Register 12 */
#define MTU_MC50_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064278u)

/** \brief 327A, Read Data and Bit Flip Register 13 */
#define MTU_MC50_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006427Au)

/** \brief 327C, Read Data and Bit Flip Register 14 */
#define MTU_MC50_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006427Cu)

/** \brief 327E, Read Data and Bit Flip Register 15 */
#define MTU_MC50_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006427Eu)

/** \brief 3280, Read Data and Bit Flip Register 16 */
#define MTU_MC50_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064280u)

/** \brief 3282, Read Data and Bit Flip Register 17 */
#define MTU_MC50_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064282u)

/** \brief 3284, Read Data and Bit Flip Register 18 */
#define MTU_MC50_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064284u)

/** \brief 3286, Read Data and Bit Flip Register 19 */
#define MTU_MC50_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064286u)

/** \brief 3288, Read Data and Bit Flip Register 20 */
#define MTU_MC50_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064288u)

/** \brief 328A, Read Data and Bit Flip Register 21 */
#define MTU_MC50_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006428Au)

/** \brief 328C, Read Data and Bit Flip Register 22 */
#define MTU_MC50_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006428Cu)

/** \brief 328E, Read Data and Bit Flip Register 23 */
#define MTU_MC50_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006428Eu)

/** \brief 3290, Read Data and Bit Flip Register 24 */
#define MTU_MC50_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064290u)

/** \brief 3292, Read Data and Bit Flip Register 25 */
#define MTU_MC50_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064292u)

/** \brief 3294, Read Data and Bit Flip Register 26 */
#define MTU_MC50_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064294u)

/** \brief 3296, Read Data and Bit Flip Register 27 */
#define MTU_MC50_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064296u)

/** \brief 3298, Read Data and Bit Flip Register 28 */
#define MTU_MC50_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064298u)

/** \brief 329A, Read Data and Bit Flip Register 29 */
#define MTU_MC50_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006429Au)

/** \brief 329C, Read Data and Bit Flip Register 30 */
#define MTU_MC50_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006429Cu)

/** \brief 329E, Read Data and Bit Flip Register 31 */
#define MTU_MC50_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006429Eu)

/** \brief 32A0, Read Data and Bit Flip Register 32 */
#define MTU_MC50_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642A0u)

/** \brief 32A2, Read Data and Bit Flip Register 33 */
#define MTU_MC50_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642A2u)

/** \brief 32A4, Read Data and Bit Flip Register 34 */
#define MTU_MC50_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642A4u)

/** \brief 32A6, Read Data and Bit Flip Register 35 */
#define MTU_MC50_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642A6u)

/** \brief 32A8, Read Data and Bit Flip Register 36 */
#define MTU_MC50_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642A8u)

/** \brief 32AA, Read Data and Bit Flip Register 37 */
#define MTU_MC50_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642AAu)

/** \brief 32AC, Read Data and Bit Flip Register 38 */
#define MTU_MC50_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642ACu)

/** \brief 32AE, Read Data and Bit Flip Register 39 */
#define MTU_MC50_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642AEu)

/** \brief 32B0, Read Data and Bit Flip Register 40 */
#define MTU_MC50_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642B0u)

/** \brief 32B2, Read Data and Bit Flip Register 41 */
#define MTU_MC50_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642B2u)

/** \brief 32B4, Read Data and Bit Flip Register 42 */
#define MTU_MC50_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642B4u)

/** \brief 32B6, Read Data and Bit Flip Register 43 */
#define MTU_MC50_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642B6u)

/** \brief 32B8, Read Data and Bit Flip Register 44 */
#define MTU_MC50_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642B8u)

/** \brief 32BA, Read Data and Bit Flip Register 45 */
#define MTU_MC50_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642BAu)

/** \brief 32BC, Read Data and Bit Flip Register 46 */
#define MTU_MC50_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642BCu)

/** \brief 32BE, Read Data and Bit Flip Register 47 */
#define MTU_MC50_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642BEu)

/** \brief 32C0, Read Data and Bit Flip Register 48 */
#define MTU_MC50_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642C0u)

/** \brief 32C2, Read Data and Bit Flip Register 49 */
#define MTU_MC50_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642C2u)

/** \brief 32C4, Read Data and Bit Flip Register 50 */
#define MTU_MC50_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642C4u)

/** \brief 32C6, Read Data and Bit Flip Register 51 */
#define MTU_MC50_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642C6u)

/** \brief 32C8, Read Data and Bit Flip Register 52 */
#define MTU_MC50_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642C8u)

/** \brief 32CA, Read Data and Bit Flip Register 53 */
#define MTU_MC50_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642CAu)

/** \brief 32CC, Read Data and Bit Flip Register 54 */
#define MTU_MC50_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642CCu)

/** \brief 32CE, Read Data and Bit Flip Register 55 */
#define MTU_MC50_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642CEu)

/** \brief 32D0, Read Data and Bit Flip Register 56 */
#define MTU_MC50_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642D0u)

/** \brief 32D2, Read Data and Bit Flip Register 57 */
#define MTU_MC50_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642D2u)

/** \brief 32D4, Read Data and Bit Flip Register 58 */
#define MTU_MC50_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642D4u)

/** \brief 32D6, Read Data and Bit Flip Register 59 */
#define MTU_MC50_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642D6u)

/** \brief 32D8, Read Data and Bit Flip Register 60 */
#define MTU_MC50_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642D8u)

/** \brief 32DA, Read Data and Bit Flip Register 61 */
#define MTU_MC50_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642DAu)

/** \brief 32DC, Read Data and Bit Flip Register 62 */
#define MTU_MC50_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642DCu)

/** \brief 32DE, Read Data and Bit Flip Register 63 */
#define MTU_MC50_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642DEu)

/** \brief 32E0, Read Data and Bit Flip Register 64 */
#define MTU_MC50_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642E0u)

/** \brief 32E2, Read Data and Bit Flip Register 65 */
#define MTU_MC50_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642E2u)

/** \brief 32E4, Read Data and Bit Flip Register 66 */
#define MTU_MC50_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00642E4u)

/** \brief 32EE, Alarm Sources Configuration Register */
#define MTU_MC50_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00642EEu)

/** \brief 32F0, SSH Safety Faults Status Register  */
#define MTU_MC50_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00642F0u)

/** \brief 32F2, Error Information Register 0 */
#define MTU_MC50_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00642F2u)

/** \brief 32F4, Error Information Register 1 */
#define MTU_MC50_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00642F4u)

/** \brief 32F6, Error Information Register 2 */
#define MTU_MC50_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00642F6u)

/** \brief 32F8, Error Information Register 3 */
#define MTU_MC50_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00642F8u)

/** \brief 32FA, Error Information Register 4 */
#define MTU_MC50_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00642FAu)

/** \brief 3300, Configuration Registers */
#define MTU_MC51_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064300u)

/** \brief 3302, Configuration Register 1 */
#define MTU_MC51_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064302u)

/** \brief 3304, MBIST Control Register */
#define MTU_MC51_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064304u)

/** \brief 3306, Status Register */
#define MTU_MC51_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064306u)

/** \brief 3308, Range Register, single address mode */
#define MTU_MC51_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064308u)

/** \brief 330C, Revision ID Register */
#define MTU_MC51_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006430Cu)

/** \brief 330E, ECC Safety Register */
#define MTU_MC51_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006430Eu)

/** \brief 3310, Memory ECC Detection Register */
#define MTU_MC51_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064310u)

/** \brief 3312, Error Tracking Register 0 */
#define MTU_MC51_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064312u)

/** \brief 3314, Error Tracking Register 1 */
#define MTU_MC51_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064314u)

/** \brief 3316, Error Tracking Register 2 */
#define MTU_MC51_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064316u)

/** \brief 3318, Error Tracking Register 3 */
#define MTU_MC51_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064318u)

/** \brief 331A, Error Tracking Register 4 */
#define MTU_MC51_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006431Au)

/** \brief 3360, Read Data and Bit Flip Register 0 */
#define MTU_MC51_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064360u)

/** \brief 3362, Read Data and Bit Flip Register 1 */
#define MTU_MC51_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064362u)

/** \brief 3364, Read Data and Bit Flip Register 2 */
#define MTU_MC51_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064364u)

/** \brief 3366, Read Data and Bit Flip Register 3 */
#define MTU_MC51_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064366u)

/** \brief 3368, Read Data and Bit Flip Register 4 */
#define MTU_MC51_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064368u)

/** \brief 336A, Read Data and Bit Flip Register 5 */
#define MTU_MC51_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006436Au)

/** \brief 336C, Read Data and Bit Flip Register 6 */
#define MTU_MC51_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006436Cu)

/** \brief 336E, Read Data and Bit Flip Register 7 */
#define MTU_MC51_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006436Eu)

/** \brief 3370, Read Data and Bit Flip Register 8 */
#define MTU_MC51_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064370u)

/** \brief 3372, Read Data and Bit Flip Register 9 */
#define MTU_MC51_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064372u)

/** \brief 3374, Read Data and Bit Flip Register 10 */
#define MTU_MC51_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064374u)

/** \brief 3376, Read Data and Bit Flip Register 11 */
#define MTU_MC51_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064376u)

/** \brief 3378, Read Data and Bit Flip Register 12 */
#define MTU_MC51_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064378u)

/** \brief 337A, Read Data and Bit Flip Register 13 */
#define MTU_MC51_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006437Au)

/** \brief 337C, Read Data and Bit Flip Register 14 */
#define MTU_MC51_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006437Cu)

/** \brief 337E, Read Data and Bit Flip Register 15 */
#define MTU_MC51_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006437Eu)

/** \brief 3380, Read Data and Bit Flip Register 16 */
#define MTU_MC51_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064380u)

/** \brief 3382, Read Data and Bit Flip Register 17 */
#define MTU_MC51_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064382u)

/** \brief 3384, Read Data and Bit Flip Register 18 */
#define MTU_MC51_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064384u)

/** \brief 3386, Read Data and Bit Flip Register 19 */
#define MTU_MC51_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064386u)

/** \brief 3388, Read Data and Bit Flip Register 20 */
#define MTU_MC51_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064388u)

/** \brief 338A, Read Data and Bit Flip Register 21 */
#define MTU_MC51_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006438Au)

/** \brief 338C, Read Data and Bit Flip Register 22 */
#define MTU_MC51_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006438Cu)

/** \brief 338E, Read Data and Bit Flip Register 23 */
#define MTU_MC51_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006438Eu)

/** \brief 3390, Read Data and Bit Flip Register 24 */
#define MTU_MC51_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064390u)

/** \brief 3392, Read Data and Bit Flip Register 25 */
#define MTU_MC51_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064392u)

/** \brief 3394, Read Data and Bit Flip Register 26 */
#define MTU_MC51_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064394u)

/** \brief 3396, Read Data and Bit Flip Register 27 */
#define MTU_MC51_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064396u)

/** \brief 3398, Read Data and Bit Flip Register 28 */
#define MTU_MC51_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064398u)

/** \brief 339A, Read Data and Bit Flip Register 29 */
#define MTU_MC51_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006439Au)

/** \brief 339C, Read Data and Bit Flip Register 30 */
#define MTU_MC51_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006439Cu)

/** \brief 339E, Read Data and Bit Flip Register 31 */
#define MTU_MC51_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006439Eu)

/** \brief 33A0, Read Data and Bit Flip Register 32 */
#define MTU_MC51_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643A0u)

/** \brief 33A2, Read Data and Bit Flip Register 33 */
#define MTU_MC51_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643A2u)

/** \brief 33A4, Read Data and Bit Flip Register 34 */
#define MTU_MC51_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643A4u)

/** \brief 33A6, Read Data and Bit Flip Register 35 */
#define MTU_MC51_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643A6u)

/** \brief 33A8, Read Data and Bit Flip Register 36 */
#define MTU_MC51_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643A8u)

/** \brief 33AA, Read Data and Bit Flip Register 37 */
#define MTU_MC51_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643AAu)

/** \brief 33AC, Read Data and Bit Flip Register 38 */
#define MTU_MC51_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643ACu)

/** \brief 33AE, Read Data and Bit Flip Register 39 */
#define MTU_MC51_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643AEu)

/** \brief 33B0, Read Data and Bit Flip Register 40 */
#define MTU_MC51_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643B0u)

/** \brief 33B2, Read Data and Bit Flip Register 41 */
#define MTU_MC51_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643B2u)

/** \brief 33B4, Read Data and Bit Flip Register 42 */
#define MTU_MC51_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643B4u)

/** \brief 33B6, Read Data and Bit Flip Register 43 */
#define MTU_MC51_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643B6u)

/** \brief 33B8, Read Data and Bit Flip Register 44 */
#define MTU_MC51_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643B8u)

/** \brief 33BA, Read Data and Bit Flip Register 45 */
#define MTU_MC51_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643BAu)

/** \brief 33BC, Read Data and Bit Flip Register 46 */
#define MTU_MC51_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643BCu)

/** \brief 33BE, Read Data and Bit Flip Register 47 */
#define MTU_MC51_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643BEu)

/** \brief 33C0, Read Data and Bit Flip Register 48 */
#define MTU_MC51_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643C0u)

/** \brief 33C2, Read Data and Bit Flip Register 49 */
#define MTU_MC51_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643C2u)

/** \brief 33C4, Read Data and Bit Flip Register 50 */
#define MTU_MC51_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643C4u)

/** \brief 33C6, Read Data and Bit Flip Register 51 */
#define MTU_MC51_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643C6u)

/** \brief 33C8, Read Data and Bit Flip Register 52 */
#define MTU_MC51_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643C8u)

/** \brief 33CA, Read Data and Bit Flip Register 53 */
#define MTU_MC51_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643CAu)

/** \brief 33CC, Read Data and Bit Flip Register 54 */
#define MTU_MC51_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643CCu)

/** \brief 33CE, Read Data and Bit Flip Register 55 */
#define MTU_MC51_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643CEu)

/** \brief 33D0, Read Data and Bit Flip Register 56 */
#define MTU_MC51_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643D0u)

/** \brief 33D2, Read Data and Bit Flip Register 57 */
#define MTU_MC51_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643D2u)

/** \brief 33D4, Read Data and Bit Flip Register 58 */
#define MTU_MC51_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643D4u)

/** \brief 33D6, Read Data and Bit Flip Register 59 */
#define MTU_MC51_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643D6u)

/** \brief 33D8, Read Data and Bit Flip Register 60 */
#define MTU_MC51_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643D8u)

/** \brief 33DA, Read Data and Bit Flip Register 61 */
#define MTU_MC51_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643DAu)

/** \brief 33DC, Read Data and Bit Flip Register 62 */
#define MTU_MC51_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643DCu)

/** \brief 33DE, Read Data and Bit Flip Register 63 */
#define MTU_MC51_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643DEu)

/** \brief 33E0, Read Data and Bit Flip Register 64 */
#define MTU_MC51_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643E0u)

/** \brief 33E2, Read Data and Bit Flip Register 65 */
#define MTU_MC51_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643E2u)

/** \brief 33E4, Read Data and Bit Flip Register 66 */
#define MTU_MC51_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00643E4u)

/** \brief 33EE, Alarm Sources Configuration Register */
#define MTU_MC51_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00643EEu)

/** \brief 33F0, SSH Safety Faults Status Register  */
#define MTU_MC51_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00643F0u)

/** \brief 33F2, Error Information Register 0 */
#define MTU_MC51_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00643F2u)

/** \brief 33F4, Error Information Register 1 */
#define MTU_MC51_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00643F4u)

/** \brief 33F6, Error Information Register 2 */
#define MTU_MC51_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00643F6u)

/** \brief 33F8, Error Information Register 3 */
#define MTU_MC51_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00643F8u)

/** \brief 33FA, Error Information Register 4 */
#define MTU_MC51_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00643FAu)

/** \brief 3400, Configuration Registers */
#define MTU_MC52_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064400u)

/** \brief 3402, Configuration Register 1 */
#define MTU_MC52_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064402u)

/** \brief 3404, MBIST Control Register */
#define MTU_MC52_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064404u)

/** \brief 3406, Status Register */
#define MTU_MC52_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064406u)

/** \brief 3408, Range Register, single address mode */
#define MTU_MC52_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064408u)

/** \brief 340C, Revision ID Register */
#define MTU_MC52_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006440Cu)

/** \brief 340E, ECC Safety Register */
#define MTU_MC52_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006440Eu)

/** \brief 3410, Memory ECC Detection Register */
#define MTU_MC52_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064410u)

/** \brief 3412, Error Tracking Register 0 */
#define MTU_MC52_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064412u)

/** \brief 3414, Error Tracking Register 1 */
#define MTU_MC52_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064414u)

/** \brief 3416, Error Tracking Register 2 */
#define MTU_MC52_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064416u)

/** \brief 3418, Error Tracking Register 3 */
#define MTU_MC52_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064418u)

/** \brief 341A, Error Tracking Register 4 */
#define MTU_MC52_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006441Au)

/** \brief 3460, Read Data and Bit Flip Register 0 */
#define MTU_MC52_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064460u)

/** \brief 3462, Read Data and Bit Flip Register 1 */
#define MTU_MC52_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064462u)

/** \brief 3464, Read Data and Bit Flip Register 2 */
#define MTU_MC52_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064464u)

/** \brief 3466, Read Data and Bit Flip Register 3 */
#define MTU_MC52_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064466u)

/** \brief 3468, Read Data and Bit Flip Register 4 */
#define MTU_MC52_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064468u)

/** \brief 346A, Read Data and Bit Flip Register 5 */
#define MTU_MC52_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006446Au)

/** \brief 346C, Read Data and Bit Flip Register 6 */
#define MTU_MC52_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006446Cu)

/** \brief 346E, Read Data and Bit Flip Register 7 */
#define MTU_MC52_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006446Eu)

/** \brief 3470, Read Data and Bit Flip Register 8 */
#define MTU_MC52_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064470u)

/** \brief 3472, Read Data and Bit Flip Register 9 */
#define MTU_MC52_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064472u)

/** \brief 3474, Read Data and Bit Flip Register 10 */
#define MTU_MC52_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064474u)

/** \brief 3476, Read Data and Bit Flip Register 11 */
#define MTU_MC52_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064476u)

/** \brief 3478, Read Data and Bit Flip Register 12 */
#define MTU_MC52_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064478u)

/** \brief 347A, Read Data and Bit Flip Register 13 */
#define MTU_MC52_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006447Au)

/** \brief 347C, Read Data and Bit Flip Register 14 */
#define MTU_MC52_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006447Cu)

/** \brief 347E, Read Data and Bit Flip Register 15 */
#define MTU_MC52_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006447Eu)

/** \brief 3480, Read Data and Bit Flip Register 16 */
#define MTU_MC52_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064480u)

/** \brief 3482, Read Data and Bit Flip Register 17 */
#define MTU_MC52_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064482u)

/** \brief 3484, Read Data and Bit Flip Register 18 */
#define MTU_MC52_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064484u)

/** \brief 3486, Read Data and Bit Flip Register 19 */
#define MTU_MC52_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064486u)

/** \brief 3488, Read Data and Bit Flip Register 20 */
#define MTU_MC52_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064488u)

/** \brief 348A, Read Data and Bit Flip Register 21 */
#define MTU_MC52_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006448Au)

/** \brief 348C, Read Data and Bit Flip Register 22 */
#define MTU_MC52_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006448Cu)

/** \brief 348E, Read Data and Bit Flip Register 23 */
#define MTU_MC52_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006448Eu)

/** \brief 3490, Read Data and Bit Flip Register 24 */
#define MTU_MC52_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064490u)

/** \brief 3492, Read Data and Bit Flip Register 25 */
#define MTU_MC52_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064492u)

/** \brief 3494, Read Data and Bit Flip Register 26 */
#define MTU_MC52_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064494u)

/** \brief 3496, Read Data and Bit Flip Register 27 */
#define MTU_MC52_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064496u)

/** \brief 3498, Read Data and Bit Flip Register 28 */
#define MTU_MC52_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064498u)

/** \brief 349A, Read Data and Bit Flip Register 29 */
#define MTU_MC52_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006449Au)

/** \brief 349C, Read Data and Bit Flip Register 30 */
#define MTU_MC52_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006449Cu)

/** \brief 349E, Read Data and Bit Flip Register 31 */
#define MTU_MC52_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006449Eu)

/** \brief 34A0, Read Data and Bit Flip Register 32 */
#define MTU_MC52_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644A0u)

/** \brief 34A2, Read Data and Bit Flip Register 33 */
#define MTU_MC52_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644A2u)

/** \brief 34A4, Read Data and Bit Flip Register 34 */
#define MTU_MC52_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644A4u)

/** \brief 34A6, Read Data and Bit Flip Register 35 */
#define MTU_MC52_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644A6u)

/** \brief 34A8, Read Data and Bit Flip Register 36 */
#define MTU_MC52_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644A8u)

/** \brief 34AA, Read Data and Bit Flip Register 37 */
#define MTU_MC52_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644AAu)

/** \brief 34AC, Read Data and Bit Flip Register 38 */
#define MTU_MC52_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644ACu)

/** \brief 34AE, Read Data and Bit Flip Register 39 */
#define MTU_MC52_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644AEu)

/** \brief 34B0, Read Data and Bit Flip Register 40 */
#define MTU_MC52_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644B0u)

/** \brief 34B2, Read Data and Bit Flip Register 41 */
#define MTU_MC52_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644B2u)

/** \brief 34B4, Read Data and Bit Flip Register 42 */
#define MTU_MC52_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644B4u)

/** \brief 34B6, Read Data and Bit Flip Register 43 */
#define MTU_MC52_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644B6u)

/** \brief 34B8, Read Data and Bit Flip Register 44 */
#define MTU_MC52_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644B8u)

/** \brief 34BA, Read Data and Bit Flip Register 45 */
#define MTU_MC52_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644BAu)

/** \brief 34BC, Read Data and Bit Flip Register 46 */
#define MTU_MC52_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644BCu)

/** \brief 34BE, Read Data and Bit Flip Register 47 */
#define MTU_MC52_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644BEu)

/** \brief 34C0, Read Data and Bit Flip Register 48 */
#define MTU_MC52_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644C0u)

/** \brief 34C2, Read Data and Bit Flip Register 49 */
#define MTU_MC52_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644C2u)

/** \brief 34C4, Read Data and Bit Flip Register 50 */
#define MTU_MC52_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644C4u)

/** \brief 34C6, Read Data and Bit Flip Register 51 */
#define MTU_MC52_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644C6u)

/** \brief 34C8, Read Data and Bit Flip Register 52 */
#define MTU_MC52_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644C8u)

/** \brief 34CA, Read Data and Bit Flip Register 53 */
#define MTU_MC52_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644CAu)

/** \brief 34CC, Read Data and Bit Flip Register 54 */
#define MTU_MC52_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644CCu)

/** \brief 34CE, Read Data and Bit Flip Register 55 */
#define MTU_MC52_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644CEu)

/** \brief 34D0, Read Data and Bit Flip Register 56 */
#define MTU_MC52_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644D0u)

/** \brief 34D2, Read Data and Bit Flip Register 57 */
#define MTU_MC52_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644D2u)

/** \brief 34D4, Read Data and Bit Flip Register 58 */
#define MTU_MC52_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644D4u)

/** \brief 34D6, Read Data and Bit Flip Register 59 */
#define MTU_MC52_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644D6u)

/** \brief 34D8, Read Data and Bit Flip Register 60 */
#define MTU_MC52_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644D8u)

/** \brief 34DA, Read Data and Bit Flip Register 61 */
#define MTU_MC52_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644DAu)

/** \brief 34DC, Read Data and Bit Flip Register 62 */
#define MTU_MC52_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644DCu)

/** \brief 34DE, Read Data and Bit Flip Register 63 */
#define MTU_MC52_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644DEu)

/** \brief 34E0, Read Data and Bit Flip Register 64 */
#define MTU_MC52_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644E0u)

/** \brief 34E2, Read Data and Bit Flip Register 65 */
#define MTU_MC52_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644E2u)

/** \brief 34E4, Read Data and Bit Flip Register 66 */
#define MTU_MC52_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00644E4u)

/** \brief 34EE, Alarm Sources Configuration Register */
#define MTU_MC52_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00644EEu)

/** \brief 34F0, SSH Safety Faults Status Register  */
#define MTU_MC52_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00644F0u)

/** \brief 34F2, Error Information Register 0 */
#define MTU_MC52_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00644F2u)

/** \brief 34F4, Error Information Register 1 */
#define MTU_MC52_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00644F4u)

/** \brief 34F6, Error Information Register 2 */
#define MTU_MC52_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00644F6u)

/** \brief 34F8, Error Information Register 3 */
#define MTU_MC52_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00644F8u)

/** \brief 34FA, Error Information Register 4 */
#define MTU_MC52_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00644FAu)

/** \brief 3500, Configuration Registers */
#define MTU_MC53_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064500u)

/** \brief 3502, Configuration Register 1 */
#define MTU_MC53_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064502u)

/** \brief 3504, MBIST Control Register */
#define MTU_MC53_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064504u)

/** \brief 3506, Status Register */
#define MTU_MC53_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064506u)

/** \brief 3508, Range Register, single address mode */
#define MTU_MC53_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064508u)

/** \brief 350C, Revision ID Register */
#define MTU_MC53_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006450Cu)

/** \brief 350E, ECC Safety Register */
#define MTU_MC53_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006450Eu)

/** \brief 3510, Memory ECC Detection Register */
#define MTU_MC53_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064510u)

/** \brief 3512, Error Tracking Register 0 */
#define MTU_MC53_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064512u)

/** \brief 3514, Error Tracking Register 1 */
#define MTU_MC53_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064514u)

/** \brief 3516, Error Tracking Register 2 */
#define MTU_MC53_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064516u)

/** \brief 3518, Error Tracking Register 3 */
#define MTU_MC53_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064518u)

/** \brief 351A, Error Tracking Register 4 */
#define MTU_MC53_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006451Au)

/** \brief 3560, Read Data and Bit Flip Register 0 */
#define MTU_MC53_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064560u)

/** \brief 3562, Read Data and Bit Flip Register 1 */
#define MTU_MC53_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064562u)

/** \brief 3564, Read Data and Bit Flip Register 2 */
#define MTU_MC53_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064564u)

/** \brief 3566, Read Data and Bit Flip Register 3 */
#define MTU_MC53_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064566u)

/** \brief 3568, Read Data and Bit Flip Register 4 */
#define MTU_MC53_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064568u)

/** \brief 356A, Read Data and Bit Flip Register 5 */
#define MTU_MC53_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006456Au)

/** \brief 356C, Read Data and Bit Flip Register 6 */
#define MTU_MC53_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006456Cu)

/** \brief 356E, Read Data and Bit Flip Register 7 */
#define MTU_MC53_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006456Eu)

/** \brief 3570, Read Data and Bit Flip Register 8 */
#define MTU_MC53_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064570u)

/** \brief 3572, Read Data and Bit Flip Register 9 */
#define MTU_MC53_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064572u)

/** \brief 3574, Read Data and Bit Flip Register 10 */
#define MTU_MC53_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064574u)

/** \brief 3576, Read Data and Bit Flip Register 11 */
#define MTU_MC53_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064576u)

/** \brief 3578, Read Data and Bit Flip Register 12 */
#define MTU_MC53_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064578u)

/** \brief 357A, Read Data and Bit Flip Register 13 */
#define MTU_MC53_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006457Au)

/** \brief 357C, Read Data and Bit Flip Register 14 */
#define MTU_MC53_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006457Cu)

/** \brief 357E, Read Data and Bit Flip Register 15 */
#define MTU_MC53_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006457Eu)

/** \brief 3580, Read Data and Bit Flip Register 16 */
#define MTU_MC53_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064580u)

/** \brief 3582, Read Data and Bit Flip Register 17 */
#define MTU_MC53_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064582u)

/** \brief 3584, Read Data and Bit Flip Register 18 */
#define MTU_MC53_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064584u)

/** \brief 3586, Read Data and Bit Flip Register 19 */
#define MTU_MC53_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064586u)

/** \brief 3588, Read Data and Bit Flip Register 20 */
#define MTU_MC53_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064588u)

/** \brief 358A, Read Data and Bit Flip Register 21 */
#define MTU_MC53_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006458Au)

/** \brief 358C, Read Data and Bit Flip Register 22 */
#define MTU_MC53_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006458Cu)

/** \brief 358E, Read Data and Bit Flip Register 23 */
#define MTU_MC53_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006458Eu)

/** \brief 3590, Read Data and Bit Flip Register 24 */
#define MTU_MC53_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064590u)

/** \brief 3592, Read Data and Bit Flip Register 25 */
#define MTU_MC53_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064592u)

/** \brief 3594, Read Data and Bit Flip Register 26 */
#define MTU_MC53_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064594u)

/** \brief 3596, Read Data and Bit Flip Register 27 */
#define MTU_MC53_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064596u)

/** \brief 3598, Read Data and Bit Flip Register 28 */
#define MTU_MC53_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064598u)

/** \brief 359A, Read Data and Bit Flip Register 29 */
#define MTU_MC53_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006459Au)

/** \brief 359C, Read Data and Bit Flip Register 30 */
#define MTU_MC53_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006459Cu)

/** \brief 359E, Read Data and Bit Flip Register 31 */
#define MTU_MC53_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006459Eu)

/** \brief 35A0, Read Data and Bit Flip Register 32 */
#define MTU_MC53_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645A0u)

/** \brief 35A2, Read Data and Bit Flip Register 33 */
#define MTU_MC53_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645A2u)

/** \brief 35A4, Read Data and Bit Flip Register 34 */
#define MTU_MC53_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645A4u)

/** \brief 35A6, Read Data and Bit Flip Register 35 */
#define MTU_MC53_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645A6u)

/** \brief 35A8, Read Data and Bit Flip Register 36 */
#define MTU_MC53_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645A8u)

/** \brief 35AA, Read Data and Bit Flip Register 37 */
#define MTU_MC53_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645AAu)

/** \brief 35AC, Read Data and Bit Flip Register 38 */
#define MTU_MC53_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645ACu)

/** \brief 35AE, Read Data and Bit Flip Register 39 */
#define MTU_MC53_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645AEu)

/** \brief 35B0, Read Data and Bit Flip Register 40 */
#define MTU_MC53_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645B0u)

/** \brief 35B2, Read Data and Bit Flip Register 41 */
#define MTU_MC53_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645B2u)

/** \brief 35B4, Read Data and Bit Flip Register 42 */
#define MTU_MC53_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645B4u)

/** \brief 35B6, Read Data and Bit Flip Register 43 */
#define MTU_MC53_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645B6u)

/** \brief 35B8, Read Data and Bit Flip Register 44 */
#define MTU_MC53_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645B8u)

/** \brief 35BA, Read Data and Bit Flip Register 45 */
#define MTU_MC53_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645BAu)

/** \brief 35BC, Read Data and Bit Flip Register 46 */
#define MTU_MC53_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645BCu)

/** \brief 35BE, Read Data and Bit Flip Register 47 */
#define MTU_MC53_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645BEu)

/** \brief 35C0, Read Data and Bit Flip Register 48 */
#define MTU_MC53_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645C0u)

/** \brief 35C2, Read Data and Bit Flip Register 49 */
#define MTU_MC53_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645C2u)

/** \brief 35C4, Read Data and Bit Flip Register 50 */
#define MTU_MC53_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645C4u)

/** \brief 35C6, Read Data and Bit Flip Register 51 */
#define MTU_MC53_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645C6u)

/** \brief 35C8, Read Data and Bit Flip Register 52 */
#define MTU_MC53_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645C8u)

/** \brief 35CA, Read Data and Bit Flip Register 53 */
#define MTU_MC53_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645CAu)

/** \brief 35CC, Read Data and Bit Flip Register 54 */
#define MTU_MC53_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645CCu)

/** \brief 35CE, Read Data and Bit Flip Register 55 */
#define MTU_MC53_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645CEu)

/** \brief 35D0, Read Data and Bit Flip Register 56 */
#define MTU_MC53_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645D0u)

/** \brief 35D2, Read Data and Bit Flip Register 57 */
#define MTU_MC53_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645D2u)

/** \brief 35D4, Read Data and Bit Flip Register 58 */
#define MTU_MC53_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645D4u)

/** \brief 35D6, Read Data and Bit Flip Register 59 */
#define MTU_MC53_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645D6u)

/** \brief 35D8, Read Data and Bit Flip Register 60 */
#define MTU_MC53_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645D8u)

/** \brief 35DA, Read Data and Bit Flip Register 61 */
#define MTU_MC53_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645DAu)

/** \brief 35DC, Read Data and Bit Flip Register 62 */
#define MTU_MC53_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645DCu)

/** \brief 35DE, Read Data and Bit Flip Register 63 */
#define MTU_MC53_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645DEu)

/** \brief 35E0, Read Data and Bit Flip Register 64 */
#define MTU_MC53_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645E0u)

/** \brief 35E2, Read Data and Bit Flip Register 65 */
#define MTU_MC53_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645E2u)

/** \brief 35E4, Read Data and Bit Flip Register 66 */
#define MTU_MC53_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00645E4u)

/** \brief 35EE, Alarm Sources Configuration Register */
#define MTU_MC53_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00645EEu)

/** \brief 35F0, SSH Safety Faults Status Register  */
#define MTU_MC53_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00645F0u)

/** \brief 35F2, Error Information Register 0 */
#define MTU_MC53_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00645F2u)

/** \brief 35F4, Error Information Register 1 */
#define MTU_MC53_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00645F4u)

/** \brief 35F6, Error Information Register 2 */
#define MTU_MC53_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00645F6u)

/** \brief 35F8, Error Information Register 3 */
#define MTU_MC53_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00645F8u)

/** \brief 35FA, Error Information Register 4 */
#define MTU_MC53_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00645FAu)

/** \brief 3600, Configuration Registers */
#define MTU_MC54_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064600u)

/** \brief 3602, Configuration Register 1 */
#define MTU_MC54_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064602u)

/** \brief 3604, MBIST Control Register */
#define MTU_MC54_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064604u)

/** \brief 3606, Status Register */
#define MTU_MC54_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064606u)

/** \brief 3608, Range Register, single address mode */
#define MTU_MC54_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064608u)

/** \brief 360C, Revision ID Register */
#define MTU_MC54_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006460Cu)

/** \brief 360E, ECC Safety Register */
#define MTU_MC54_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006460Eu)

/** \brief 3610, Memory ECC Detection Register */
#define MTU_MC54_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064610u)

/** \brief 3612, Error Tracking Register 0 */
#define MTU_MC54_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064612u)

/** \brief 3614, Error Tracking Register 1 */
#define MTU_MC54_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064614u)

/** \brief 3616, Error Tracking Register 2 */
#define MTU_MC54_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064616u)

/** \brief 3618, Error Tracking Register 3 */
#define MTU_MC54_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064618u)

/** \brief 361A, Error Tracking Register 4 */
#define MTU_MC54_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006461Au)

/** \brief 3660, Read Data and Bit Flip Register 0 */
#define MTU_MC54_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064660u)

/** \brief 3662, Read Data and Bit Flip Register 1 */
#define MTU_MC54_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064662u)

/** \brief 3664, Read Data and Bit Flip Register 2 */
#define MTU_MC54_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064664u)

/** \brief 3666, Read Data and Bit Flip Register 3 */
#define MTU_MC54_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064666u)

/** \brief 3668, Read Data and Bit Flip Register 4 */
#define MTU_MC54_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064668u)

/** \brief 366A, Read Data and Bit Flip Register 5 */
#define MTU_MC54_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006466Au)

/** \brief 366C, Read Data and Bit Flip Register 6 */
#define MTU_MC54_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006466Cu)

/** \brief 366E, Read Data and Bit Flip Register 7 */
#define MTU_MC54_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006466Eu)

/** \brief 3670, Read Data and Bit Flip Register 8 */
#define MTU_MC54_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064670u)

/** \brief 3672, Read Data and Bit Flip Register 9 */
#define MTU_MC54_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064672u)

/** \brief 3674, Read Data and Bit Flip Register 10 */
#define MTU_MC54_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064674u)

/** \brief 3676, Read Data and Bit Flip Register 11 */
#define MTU_MC54_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064676u)

/** \brief 3678, Read Data and Bit Flip Register 12 */
#define MTU_MC54_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064678u)

/** \brief 367A, Read Data and Bit Flip Register 13 */
#define MTU_MC54_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006467Au)

/** \brief 367C, Read Data and Bit Flip Register 14 */
#define MTU_MC54_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006467Cu)

/** \brief 367E, Read Data and Bit Flip Register 15 */
#define MTU_MC54_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006467Eu)

/** \brief 3680, Read Data and Bit Flip Register 16 */
#define MTU_MC54_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064680u)

/** \brief 3682, Read Data and Bit Flip Register 17 */
#define MTU_MC54_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064682u)

/** \brief 3684, Read Data and Bit Flip Register 18 */
#define MTU_MC54_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064684u)

/** \brief 3686, Read Data and Bit Flip Register 19 */
#define MTU_MC54_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064686u)

/** \brief 3688, Read Data and Bit Flip Register 20 */
#define MTU_MC54_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064688u)

/** \brief 368A, Read Data and Bit Flip Register 21 */
#define MTU_MC54_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006468Au)

/** \brief 368C, Read Data and Bit Flip Register 22 */
#define MTU_MC54_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006468Cu)

/** \brief 368E, Read Data and Bit Flip Register 23 */
#define MTU_MC54_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006468Eu)

/** \brief 3690, Read Data and Bit Flip Register 24 */
#define MTU_MC54_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064690u)

/** \brief 3692, Read Data and Bit Flip Register 25 */
#define MTU_MC54_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064692u)

/** \brief 3694, Read Data and Bit Flip Register 26 */
#define MTU_MC54_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064694u)

/** \brief 3696, Read Data and Bit Flip Register 27 */
#define MTU_MC54_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064696u)

/** \brief 3698, Read Data and Bit Flip Register 28 */
#define MTU_MC54_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064698u)

/** \brief 369A, Read Data and Bit Flip Register 29 */
#define MTU_MC54_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006469Au)

/** \brief 369C, Read Data and Bit Flip Register 30 */
#define MTU_MC54_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006469Cu)

/** \brief 369E, Read Data and Bit Flip Register 31 */
#define MTU_MC54_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006469Eu)

/** \brief 36A0, Read Data and Bit Flip Register 32 */
#define MTU_MC54_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646A0u)

/** \brief 36A2, Read Data and Bit Flip Register 33 */
#define MTU_MC54_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646A2u)

/** \brief 36A4, Read Data and Bit Flip Register 34 */
#define MTU_MC54_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646A4u)

/** \brief 36A6, Read Data and Bit Flip Register 35 */
#define MTU_MC54_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646A6u)

/** \brief 36A8, Read Data and Bit Flip Register 36 */
#define MTU_MC54_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646A8u)

/** \brief 36AA, Read Data and Bit Flip Register 37 */
#define MTU_MC54_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646AAu)

/** \brief 36AC, Read Data and Bit Flip Register 38 */
#define MTU_MC54_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646ACu)

/** \brief 36AE, Read Data and Bit Flip Register 39 */
#define MTU_MC54_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646AEu)

/** \brief 36B0, Read Data and Bit Flip Register 40 */
#define MTU_MC54_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646B0u)

/** \brief 36B2, Read Data and Bit Flip Register 41 */
#define MTU_MC54_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646B2u)

/** \brief 36B4, Read Data and Bit Flip Register 42 */
#define MTU_MC54_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646B4u)

/** \brief 36B6, Read Data and Bit Flip Register 43 */
#define MTU_MC54_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646B6u)

/** \brief 36B8, Read Data and Bit Flip Register 44 */
#define MTU_MC54_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646B8u)

/** \brief 36BA, Read Data and Bit Flip Register 45 */
#define MTU_MC54_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646BAu)

/** \brief 36BC, Read Data and Bit Flip Register 46 */
#define MTU_MC54_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646BCu)

/** \brief 36BE, Read Data and Bit Flip Register 47 */
#define MTU_MC54_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646BEu)

/** \brief 36C0, Read Data and Bit Flip Register 48 */
#define MTU_MC54_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646C0u)

/** \brief 36C2, Read Data and Bit Flip Register 49 */
#define MTU_MC54_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646C2u)

/** \brief 36C4, Read Data and Bit Flip Register 50 */
#define MTU_MC54_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646C4u)

/** \brief 36C6, Read Data and Bit Flip Register 51 */
#define MTU_MC54_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646C6u)

/** \brief 36C8, Read Data and Bit Flip Register 52 */
#define MTU_MC54_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646C8u)

/** \brief 36CA, Read Data and Bit Flip Register 53 */
#define MTU_MC54_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646CAu)

/** \brief 36CC, Read Data and Bit Flip Register 54 */
#define MTU_MC54_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646CCu)

/** \brief 36CE, Read Data and Bit Flip Register 55 */
#define MTU_MC54_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646CEu)

/** \brief 36D0, Read Data and Bit Flip Register 56 */
#define MTU_MC54_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646D0u)

/** \brief 36D2, Read Data and Bit Flip Register 57 */
#define MTU_MC54_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646D2u)

/** \brief 36D4, Read Data and Bit Flip Register 58 */
#define MTU_MC54_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646D4u)

/** \brief 36D6, Read Data and Bit Flip Register 59 */
#define MTU_MC54_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646D6u)

/** \brief 36D8, Read Data and Bit Flip Register 60 */
#define MTU_MC54_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646D8u)

/** \brief 36DA, Read Data and Bit Flip Register 61 */
#define MTU_MC54_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646DAu)

/** \brief 36DC, Read Data and Bit Flip Register 62 */
#define MTU_MC54_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646DCu)

/** \brief 36DE, Read Data and Bit Flip Register 63 */
#define MTU_MC54_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646DEu)

/** \brief 36E0, Read Data and Bit Flip Register 64 */
#define MTU_MC54_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646E0u)

/** \brief 36E2, Read Data and Bit Flip Register 65 */
#define MTU_MC54_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646E2u)

/** \brief 36E4, Read Data and Bit Flip Register 66 */
#define MTU_MC54_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00646E4u)

/** \brief 36EE, Alarm Sources Configuration Register */
#define MTU_MC54_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00646EEu)

/** \brief 36F0, SSH Safety Faults Status Register  */
#define MTU_MC54_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00646F0u)

/** \brief 36F2, Error Information Register 0 */
#define MTU_MC54_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00646F2u)

/** \brief 36F4, Error Information Register 1 */
#define MTU_MC54_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00646F4u)

/** \brief 36F6, Error Information Register 2 */
#define MTU_MC54_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00646F6u)

/** \brief 36F8, Error Information Register 3 */
#define MTU_MC54_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00646F8u)

/** \brief 36FA, Error Information Register 4 */
#define MTU_MC54_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00646FAu)

/** \brief 3700, Configuration Registers */
#define MTU_MC55_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064700u)

/** \brief 3702, Configuration Register 1 */
#define MTU_MC55_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064702u)

/** \brief 3704, MBIST Control Register */
#define MTU_MC55_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064704u)

/** \brief 3706, Status Register */
#define MTU_MC55_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064706u)

/** \brief 3708, Range Register, single address mode */
#define MTU_MC55_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064708u)

/** \brief 370C, Revision ID Register */
#define MTU_MC55_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006470Cu)

/** \brief 370E, ECC Safety Register */
#define MTU_MC55_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006470Eu)

/** \brief 3710, Memory ECC Detection Register */
#define MTU_MC55_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064710u)

/** \brief 3712, Error Tracking Register 0 */
#define MTU_MC55_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064712u)

/** \brief 3714, Error Tracking Register 1 */
#define MTU_MC55_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064714u)

/** \brief 3716, Error Tracking Register 2 */
#define MTU_MC55_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064716u)

/** \brief 3718, Error Tracking Register 3 */
#define MTU_MC55_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064718u)

/** \brief 371A, Error Tracking Register 4 */
#define MTU_MC55_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006471Au)

/** \brief 3760, Read Data and Bit Flip Register 0 */
#define MTU_MC55_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064760u)

/** \brief 3762, Read Data and Bit Flip Register 1 */
#define MTU_MC55_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064762u)

/** \brief 3764, Read Data and Bit Flip Register 2 */
#define MTU_MC55_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064764u)

/** \brief 3766, Read Data and Bit Flip Register 3 */
#define MTU_MC55_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064766u)

/** \brief 3768, Read Data and Bit Flip Register 4 */
#define MTU_MC55_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064768u)

/** \brief 376A, Read Data and Bit Flip Register 5 */
#define MTU_MC55_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006476Au)

/** \brief 376C, Read Data and Bit Flip Register 6 */
#define MTU_MC55_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006476Cu)

/** \brief 376E, Read Data and Bit Flip Register 7 */
#define MTU_MC55_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006476Eu)

/** \brief 3770, Read Data and Bit Flip Register 8 */
#define MTU_MC55_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064770u)

/** \brief 3772, Read Data and Bit Flip Register 9 */
#define MTU_MC55_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064772u)

/** \brief 3774, Read Data and Bit Flip Register 10 */
#define MTU_MC55_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064774u)

/** \brief 3776, Read Data and Bit Flip Register 11 */
#define MTU_MC55_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064776u)

/** \brief 3778, Read Data and Bit Flip Register 12 */
#define MTU_MC55_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064778u)

/** \brief 377A, Read Data and Bit Flip Register 13 */
#define MTU_MC55_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006477Au)

/** \brief 377C, Read Data and Bit Flip Register 14 */
#define MTU_MC55_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006477Cu)

/** \brief 377E, Read Data and Bit Flip Register 15 */
#define MTU_MC55_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006477Eu)

/** \brief 3780, Read Data and Bit Flip Register 16 */
#define MTU_MC55_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064780u)

/** \brief 3782, Read Data and Bit Flip Register 17 */
#define MTU_MC55_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064782u)

/** \brief 3784, Read Data and Bit Flip Register 18 */
#define MTU_MC55_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064784u)

/** \brief 3786, Read Data and Bit Flip Register 19 */
#define MTU_MC55_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064786u)

/** \brief 3788, Read Data and Bit Flip Register 20 */
#define MTU_MC55_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064788u)

/** \brief 378A, Read Data and Bit Flip Register 21 */
#define MTU_MC55_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006478Au)

/** \brief 378C, Read Data and Bit Flip Register 22 */
#define MTU_MC55_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006478Cu)

/** \brief 378E, Read Data and Bit Flip Register 23 */
#define MTU_MC55_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006478Eu)

/** \brief 3790, Read Data and Bit Flip Register 24 */
#define MTU_MC55_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064790u)

/** \brief 3792, Read Data and Bit Flip Register 25 */
#define MTU_MC55_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064792u)

/** \brief 3794, Read Data and Bit Flip Register 26 */
#define MTU_MC55_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064794u)

/** \brief 3796, Read Data and Bit Flip Register 27 */
#define MTU_MC55_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064796u)

/** \brief 3798, Read Data and Bit Flip Register 28 */
#define MTU_MC55_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064798u)

/** \brief 379A, Read Data and Bit Flip Register 29 */
#define MTU_MC55_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006479Au)

/** \brief 379C, Read Data and Bit Flip Register 30 */
#define MTU_MC55_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006479Cu)

/** \brief 379E, Read Data and Bit Flip Register 31 */
#define MTU_MC55_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006479Eu)

/** \brief 37A0, Read Data and Bit Flip Register 32 */
#define MTU_MC55_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647A0u)

/** \brief 37A2, Read Data and Bit Flip Register 33 */
#define MTU_MC55_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647A2u)

/** \brief 37A4, Read Data and Bit Flip Register 34 */
#define MTU_MC55_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647A4u)

/** \brief 37A6, Read Data and Bit Flip Register 35 */
#define MTU_MC55_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647A6u)

/** \brief 37A8, Read Data and Bit Flip Register 36 */
#define MTU_MC55_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647A8u)

/** \brief 37AA, Read Data and Bit Flip Register 37 */
#define MTU_MC55_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647AAu)

/** \brief 37AC, Read Data and Bit Flip Register 38 */
#define MTU_MC55_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647ACu)

/** \brief 37AE, Read Data and Bit Flip Register 39 */
#define MTU_MC55_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647AEu)

/** \brief 37B0, Read Data and Bit Flip Register 40 */
#define MTU_MC55_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647B0u)

/** \brief 37B2, Read Data and Bit Flip Register 41 */
#define MTU_MC55_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647B2u)

/** \brief 37B4, Read Data and Bit Flip Register 42 */
#define MTU_MC55_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647B4u)

/** \brief 37B6, Read Data and Bit Flip Register 43 */
#define MTU_MC55_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647B6u)

/** \brief 37B8, Read Data and Bit Flip Register 44 */
#define MTU_MC55_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647B8u)

/** \brief 37BA, Read Data and Bit Flip Register 45 */
#define MTU_MC55_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647BAu)

/** \brief 37BC, Read Data and Bit Flip Register 46 */
#define MTU_MC55_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647BCu)

/** \brief 37BE, Read Data and Bit Flip Register 47 */
#define MTU_MC55_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647BEu)

/** \brief 37C0, Read Data and Bit Flip Register 48 */
#define MTU_MC55_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647C0u)

/** \brief 37C2, Read Data and Bit Flip Register 49 */
#define MTU_MC55_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647C2u)

/** \brief 37C4, Read Data and Bit Flip Register 50 */
#define MTU_MC55_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647C4u)

/** \brief 37C6, Read Data and Bit Flip Register 51 */
#define MTU_MC55_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647C6u)

/** \brief 37C8, Read Data and Bit Flip Register 52 */
#define MTU_MC55_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647C8u)

/** \brief 37CA, Read Data and Bit Flip Register 53 */
#define MTU_MC55_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647CAu)

/** \brief 37CC, Read Data and Bit Flip Register 54 */
#define MTU_MC55_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647CCu)

/** \brief 37CE, Read Data and Bit Flip Register 55 */
#define MTU_MC55_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647CEu)

/** \brief 37D0, Read Data and Bit Flip Register 56 */
#define MTU_MC55_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647D0u)

/** \brief 37D2, Read Data and Bit Flip Register 57 */
#define MTU_MC55_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647D2u)

/** \brief 37D4, Read Data and Bit Flip Register 58 */
#define MTU_MC55_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647D4u)

/** \brief 37D6, Read Data and Bit Flip Register 59 */
#define MTU_MC55_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647D6u)

/** \brief 37D8, Read Data and Bit Flip Register 60 */
#define MTU_MC55_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647D8u)

/** \brief 37DA, Read Data and Bit Flip Register 61 */
#define MTU_MC55_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647DAu)

/** \brief 37DC, Read Data and Bit Flip Register 62 */
#define MTU_MC55_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647DCu)

/** \brief 37DE, Read Data and Bit Flip Register 63 */
#define MTU_MC55_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647DEu)

/** \brief 37E0, Read Data and Bit Flip Register 64 */
#define MTU_MC55_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647E0u)

/** \brief 37E2, Read Data and Bit Flip Register 65 */
#define MTU_MC55_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647E2u)

/** \brief 37E4, Read Data and Bit Flip Register 66 */
#define MTU_MC55_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00647E4u)

/** \brief 37EE, Alarm Sources Configuration Register */
#define MTU_MC55_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00647EEu)

/** \brief 37F0, SSH Safety Faults Status Register  */
#define MTU_MC55_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00647F0u)

/** \brief 37F2, Error Information Register 0 */
#define MTU_MC55_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00647F2u)

/** \brief 37F4, Error Information Register 1 */
#define MTU_MC55_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00647F4u)

/** \brief 37F6, Error Information Register 2 */
#define MTU_MC55_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00647F6u)

/** \brief 37F8, Error Information Register 3 */
#define MTU_MC55_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00647F8u)

/** \brief 37FA, Error Information Register 4 */
#define MTU_MC55_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00647FAu)

/** \brief 3800, Configuration Registers */
#define MTU_MC56_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064800u)

/** \brief 3802, Configuration Register 1 */
#define MTU_MC56_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064802u)

/** \brief 3804, MBIST Control Register */
#define MTU_MC56_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064804u)

/** \brief 3806, Status Register */
#define MTU_MC56_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064806u)

/** \brief 3808, Range Register, single address mode */
#define MTU_MC56_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064808u)

/** \brief 380C, Revision ID Register */
#define MTU_MC56_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006480Cu)

/** \brief 380E, ECC Safety Register */
#define MTU_MC56_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006480Eu)

/** \brief 3810, Memory ECC Detection Register */
#define MTU_MC56_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064810u)

/** \brief 3812, Error Tracking Register 0 */
#define MTU_MC56_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064812u)

/** \brief 3814, Error Tracking Register 1 */
#define MTU_MC56_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064814u)

/** \brief 3816, Error Tracking Register 2 */
#define MTU_MC56_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064816u)

/** \brief 3818, Error Tracking Register 3 */
#define MTU_MC56_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064818u)

/** \brief 381A, Error Tracking Register 4 */
#define MTU_MC56_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006481Au)

/** \brief 3860, Read Data and Bit Flip Register 0 */
#define MTU_MC56_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064860u)

/** \brief 3862, Read Data and Bit Flip Register 1 */
#define MTU_MC56_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064862u)

/** \brief 3864, Read Data and Bit Flip Register 2 */
#define MTU_MC56_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064864u)

/** \brief 3866, Read Data and Bit Flip Register 3 */
#define MTU_MC56_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064866u)

/** \brief 3868, Read Data and Bit Flip Register 4 */
#define MTU_MC56_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064868u)

/** \brief 386A, Read Data and Bit Flip Register 5 */
#define MTU_MC56_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006486Au)

/** \brief 386C, Read Data and Bit Flip Register 6 */
#define MTU_MC56_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006486Cu)

/** \brief 386E, Read Data and Bit Flip Register 7 */
#define MTU_MC56_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006486Eu)

/** \brief 3870, Read Data and Bit Flip Register 8 */
#define MTU_MC56_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064870u)

/** \brief 3872, Read Data and Bit Flip Register 9 */
#define MTU_MC56_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064872u)

/** \brief 3874, Read Data and Bit Flip Register 10 */
#define MTU_MC56_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064874u)

/** \brief 3876, Read Data and Bit Flip Register 11 */
#define MTU_MC56_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064876u)

/** \brief 3878, Read Data and Bit Flip Register 12 */
#define MTU_MC56_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064878u)

/** \brief 387A, Read Data and Bit Flip Register 13 */
#define MTU_MC56_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006487Au)

/** \brief 387C, Read Data and Bit Flip Register 14 */
#define MTU_MC56_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006487Cu)

/** \brief 387E, Read Data and Bit Flip Register 15 */
#define MTU_MC56_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006487Eu)

/** \brief 3880, Read Data and Bit Flip Register 16 */
#define MTU_MC56_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064880u)

/** \brief 3882, Read Data and Bit Flip Register 17 */
#define MTU_MC56_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064882u)

/** \brief 3884, Read Data and Bit Flip Register 18 */
#define MTU_MC56_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064884u)

/** \brief 3886, Read Data and Bit Flip Register 19 */
#define MTU_MC56_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064886u)

/** \brief 3888, Read Data and Bit Flip Register 20 */
#define MTU_MC56_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064888u)

/** \brief 388A, Read Data and Bit Flip Register 21 */
#define MTU_MC56_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006488Au)

/** \brief 388C, Read Data and Bit Flip Register 22 */
#define MTU_MC56_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006488Cu)

/** \brief 388E, Read Data and Bit Flip Register 23 */
#define MTU_MC56_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006488Eu)

/** \brief 3890, Read Data and Bit Flip Register 24 */
#define MTU_MC56_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064890u)

/** \brief 3892, Read Data and Bit Flip Register 25 */
#define MTU_MC56_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064892u)

/** \brief 3894, Read Data and Bit Flip Register 26 */
#define MTU_MC56_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064894u)

/** \brief 3896, Read Data and Bit Flip Register 27 */
#define MTU_MC56_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064896u)

/** \brief 3898, Read Data and Bit Flip Register 28 */
#define MTU_MC56_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064898u)

/** \brief 389A, Read Data and Bit Flip Register 29 */
#define MTU_MC56_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006489Au)

/** \brief 389C, Read Data and Bit Flip Register 30 */
#define MTU_MC56_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006489Cu)

/** \brief 389E, Read Data and Bit Flip Register 31 */
#define MTU_MC56_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006489Eu)

/** \brief 38A0, Read Data and Bit Flip Register 32 */
#define MTU_MC56_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648A0u)

/** \brief 38A2, Read Data and Bit Flip Register 33 */
#define MTU_MC56_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648A2u)

/** \brief 38A4, Read Data and Bit Flip Register 34 */
#define MTU_MC56_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648A4u)

/** \brief 38A6, Read Data and Bit Flip Register 35 */
#define MTU_MC56_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648A6u)

/** \brief 38A8, Read Data and Bit Flip Register 36 */
#define MTU_MC56_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648A8u)

/** \brief 38AA, Read Data and Bit Flip Register 37 */
#define MTU_MC56_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648AAu)

/** \brief 38AC, Read Data and Bit Flip Register 38 */
#define MTU_MC56_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648ACu)

/** \brief 38AE, Read Data and Bit Flip Register 39 */
#define MTU_MC56_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648AEu)

/** \brief 38B0, Read Data and Bit Flip Register 40 */
#define MTU_MC56_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648B0u)

/** \brief 38B2, Read Data and Bit Flip Register 41 */
#define MTU_MC56_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648B2u)

/** \brief 38B4, Read Data and Bit Flip Register 42 */
#define MTU_MC56_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648B4u)

/** \brief 38B6, Read Data and Bit Flip Register 43 */
#define MTU_MC56_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648B6u)

/** \brief 38B8, Read Data and Bit Flip Register 44 */
#define MTU_MC56_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648B8u)

/** \brief 38BA, Read Data and Bit Flip Register 45 */
#define MTU_MC56_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648BAu)

/** \brief 38BC, Read Data and Bit Flip Register 46 */
#define MTU_MC56_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648BCu)

/** \brief 38BE, Read Data and Bit Flip Register 47 */
#define MTU_MC56_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648BEu)

/** \brief 38C0, Read Data and Bit Flip Register 48 */
#define MTU_MC56_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648C0u)

/** \brief 38C2, Read Data and Bit Flip Register 49 */
#define MTU_MC56_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648C2u)

/** \brief 38C4, Read Data and Bit Flip Register 50 */
#define MTU_MC56_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648C4u)

/** \brief 38C6, Read Data and Bit Flip Register 51 */
#define MTU_MC56_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648C6u)

/** \brief 38C8, Read Data and Bit Flip Register 52 */
#define MTU_MC56_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648C8u)

/** \brief 38CA, Read Data and Bit Flip Register 53 */
#define MTU_MC56_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648CAu)

/** \brief 38CC, Read Data and Bit Flip Register 54 */
#define MTU_MC56_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648CCu)

/** \brief 38CE, Read Data and Bit Flip Register 55 */
#define MTU_MC56_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648CEu)

/** \brief 38D0, Read Data and Bit Flip Register 56 */
#define MTU_MC56_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648D0u)

/** \brief 38D2, Read Data and Bit Flip Register 57 */
#define MTU_MC56_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648D2u)

/** \brief 38D4, Read Data and Bit Flip Register 58 */
#define MTU_MC56_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648D4u)

/** \brief 38D6, Read Data and Bit Flip Register 59 */
#define MTU_MC56_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648D6u)

/** \brief 38D8, Read Data and Bit Flip Register 60 */
#define MTU_MC56_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648D8u)

/** \brief 38DA, Read Data and Bit Flip Register 61 */
#define MTU_MC56_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648DAu)

/** \brief 38DC, Read Data and Bit Flip Register 62 */
#define MTU_MC56_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648DCu)

/** \brief 38DE, Read Data and Bit Flip Register 63 */
#define MTU_MC56_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648DEu)

/** \brief 38E0, Read Data and Bit Flip Register 64 */
#define MTU_MC56_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648E0u)

/** \brief 38E2, Read Data and Bit Flip Register 65 */
#define MTU_MC56_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648E2u)

/** \brief 38E4, Read Data and Bit Flip Register 66 */
#define MTU_MC56_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00648E4u)

/** \brief 38EE, Alarm Sources Configuration Register */
#define MTU_MC56_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00648EEu)

/** \brief 38F0, SSH Safety Faults Status Register  */
#define MTU_MC56_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00648F0u)

/** \brief 38F2, Error Information Register 0 */
#define MTU_MC56_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00648F2u)

/** \brief 38F4, Error Information Register 1 */
#define MTU_MC56_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00648F4u)

/** \brief 38F6, Error Information Register 2 */
#define MTU_MC56_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00648F6u)

/** \brief 38F8, Error Information Register 3 */
#define MTU_MC56_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00648F8u)

/** \brief 38FA, Error Information Register 4 */
#define MTU_MC56_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00648FAu)

/** \brief 3900, Configuration Registers */
#define MTU_MC57_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064900u)

/** \brief 3902, Configuration Register 1 */
#define MTU_MC57_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064902u)

/** \brief 3904, MBIST Control Register */
#define MTU_MC57_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064904u)

/** \brief 3906, Status Register */
#define MTU_MC57_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064906u)

/** \brief 3908, Range Register, single address mode */
#define MTU_MC57_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064908u)

/** \brief 390C, Revision ID Register */
#define MTU_MC57_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006490Cu)

/** \brief 390E, ECC Safety Register */
#define MTU_MC57_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006490Eu)

/** \brief 3910, Memory ECC Detection Register */
#define MTU_MC57_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064910u)

/** \brief 3912, Error Tracking Register 0 */
#define MTU_MC57_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064912u)

/** \brief 3914, Error Tracking Register 1 */
#define MTU_MC57_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064914u)

/** \brief 3916, Error Tracking Register 2 */
#define MTU_MC57_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064916u)

/** \brief 3918, Error Tracking Register 3 */
#define MTU_MC57_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064918u)

/** \brief 391A, Error Tracking Register 4 */
#define MTU_MC57_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006491Au)

/** \brief 3960, Read Data and Bit Flip Register 0 */
#define MTU_MC57_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064960u)

/** \brief 3962, Read Data and Bit Flip Register 1 */
#define MTU_MC57_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064962u)

/** \brief 3964, Read Data and Bit Flip Register 2 */
#define MTU_MC57_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064964u)

/** \brief 3966, Read Data and Bit Flip Register 3 */
#define MTU_MC57_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064966u)

/** \brief 3968, Read Data and Bit Flip Register 4 */
#define MTU_MC57_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064968u)

/** \brief 396A, Read Data and Bit Flip Register 5 */
#define MTU_MC57_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006496Au)

/** \brief 396C, Read Data and Bit Flip Register 6 */
#define MTU_MC57_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006496Cu)

/** \brief 396E, Read Data and Bit Flip Register 7 */
#define MTU_MC57_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006496Eu)

/** \brief 3970, Read Data and Bit Flip Register 8 */
#define MTU_MC57_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064970u)

/** \brief 3972, Read Data and Bit Flip Register 9 */
#define MTU_MC57_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064972u)

/** \brief 3974, Read Data and Bit Flip Register 10 */
#define MTU_MC57_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064974u)

/** \brief 3976, Read Data and Bit Flip Register 11 */
#define MTU_MC57_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064976u)

/** \brief 3978, Read Data and Bit Flip Register 12 */
#define MTU_MC57_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064978u)

/** \brief 397A, Read Data and Bit Flip Register 13 */
#define MTU_MC57_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006497Au)

/** \brief 397C, Read Data and Bit Flip Register 14 */
#define MTU_MC57_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006497Cu)

/** \brief 397E, Read Data and Bit Flip Register 15 */
#define MTU_MC57_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006497Eu)

/** \brief 3980, Read Data and Bit Flip Register 16 */
#define MTU_MC57_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064980u)

/** \brief 3982, Read Data and Bit Flip Register 17 */
#define MTU_MC57_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064982u)

/** \brief 3984, Read Data and Bit Flip Register 18 */
#define MTU_MC57_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064984u)

/** \brief 3986, Read Data and Bit Flip Register 19 */
#define MTU_MC57_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064986u)

/** \brief 3988, Read Data and Bit Flip Register 20 */
#define MTU_MC57_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064988u)

/** \brief 398A, Read Data and Bit Flip Register 21 */
#define MTU_MC57_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006498Au)

/** \brief 398C, Read Data and Bit Flip Register 22 */
#define MTU_MC57_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006498Cu)

/** \brief 398E, Read Data and Bit Flip Register 23 */
#define MTU_MC57_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006498Eu)

/** \brief 3990, Read Data and Bit Flip Register 24 */
#define MTU_MC57_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064990u)

/** \brief 3992, Read Data and Bit Flip Register 25 */
#define MTU_MC57_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064992u)

/** \brief 3994, Read Data and Bit Flip Register 26 */
#define MTU_MC57_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064994u)

/** \brief 3996, Read Data and Bit Flip Register 27 */
#define MTU_MC57_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064996u)

/** \brief 3998, Read Data and Bit Flip Register 28 */
#define MTU_MC57_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064998u)

/** \brief 399A, Read Data and Bit Flip Register 29 */
#define MTU_MC57_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006499Au)

/** \brief 399C, Read Data and Bit Flip Register 30 */
#define MTU_MC57_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006499Cu)

/** \brief 399E, Read Data and Bit Flip Register 31 */
#define MTU_MC57_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006499Eu)

/** \brief 39A0, Read Data and Bit Flip Register 32 */
#define MTU_MC57_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649A0u)

/** \brief 39A2, Read Data and Bit Flip Register 33 */
#define MTU_MC57_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649A2u)

/** \brief 39A4, Read Data and Bit Flip Register 34 */
#define MTU_MC57_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649A4u)

/** \brief 39A6, Read Data and Bit Flip Register 35 */
#define MTU_MC57_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649A6u)

/** \brief 39A8, Read Data and Bit Flip Register 36 */
#define MTU_MC57_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649A8u)

/** \brief 39AA, Read Data and Bit Flip Register 37 */
#define MTU_MC57_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649AAu)

/** \brief 39AC, Read Data and Bit Flip Register 38 */
#define MTU_MC57_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649ACu)

/** \brief 39AE, Read Data and Bit Flip Register 39 */
#define MTU_MC57_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649AEu)

/** \brief 39B0, Read Data and Bit Flip Register 40 */
#define MTU_MC57_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649B0u)

/** \brief 39B2, Read Data and Bit Flip Register 41 */
#define MTU_MC57_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649B2u)

/** \brief 39B4, Read Data and Bit Flip Register 42 */
#define MTU_MC57_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649B4u)

/** \brief 39B6, Read Data and Bit Flip Register 43 */
#define MTU_MC57_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649B6u)

/** \brief 39B8, Read Data and Bit Flip Register 44 */
#define MTU_MC57_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649B8u)

/** \brief 39BA, Read Data and Bit Flip Register 45 */
#define MTU_MC57_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649BAu)

/** \brief 39BC, Read Data and Bit Flip Register 46 */
#define MTU_MC57_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649BCu)

/** \brief 39BE, Read Data and Bit Flip Register 47 */
#define MTU_MC57_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649BEu)

/** \brief 39C0, Read Data and Bit Flip Register 48 */
#define MTU_MC57_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649C0u)

/** \brief 39C2, Read Data and Bit Flip Register 49 */
#define MTU_MC57_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649C2u)

/** \brief 39C4, Read Data and Bit Flip Register 50 */
#define MTU_MC57_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649C4u)

/** \brief 39C6, Read Data and Bit Flip Register 51 */
#define MTU_MC57_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649C6u)

/** \brief 39C8, Read Data and Bit Flip Register 52 */
#define MTU_MC57_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649C8u)

/** \brief 39CA, Read Data and Bit Flip Register 53 */
#define MTU_MC57_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649CAu)

/** \brief 39CC, Read Data and Bit Flip Register 54 */
#define MTU_MC57_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649CCu)

/** \brief 39CE, Read Data and Bit Flip Register 55 */
#define MTU_MC57_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649CEu)

/** \brief 39D0, Read Data and Bit Flip Register 56 */
#define MTU_MC57_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649D0u)

/** \brief 39D2, Read Data and Bit Flip Register 57 */
#define MTU_MC57_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649D2u)

/** \brief 39D4, Read Data and Bit Flip Register 58 */
#define MTU_MC57_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649D4u)

/** \brief 39D6, Read Data and Bit Flip Register 59 */
#define MTU_MC57_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649D6u)

/** \brief 39D8, Read Data and Bit Flip Register 60 */
#define MTU_MC57_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649D8u)

/** \brief 39DA, Read Data and Bit Flip Register 61 */
#define MTU_MC57_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649DAu)

/** \brief 39DC, Read Data and Bit Flip Register 62 */
#define MTU_MC57_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649DCu)

/** \brief 39DE, Read Data and Bit Flip Register 63 */
#define MTU_MC57_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649DEu)

/** \brief 39E0, Read Data and Bit Flip Register 64 */
#define MTU_MC57_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649E0u)

/** \brief 39E2, Read Data and Bit Flip Register 65 */
#define MTU_MC57_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649E2u)

/** \brief 39E4, Read Data and Bit Flip Register 66 */
#define MTU_MC57_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00649E4u)

/** \brief 39EE, Alarm Sources Configuration Register */
#define MTU_MC57_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00649EEu)

/** \brief 39F0, SSH Safety Faults Status Register  */
#define MTU_MC57_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00649F0u)

/** \brief 39F2, Error Information Register 0 */
#define MTU_MC57_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00649F2u)

/** \brief 39F4, Error Information Register 1 */
#define MTU_MC57_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00649F4u)

/** \brief 39F6, Error Information Register 2 */
#define MTU_MC57_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00649F6u)

/** \brief 39F8, Error Information Register 3 */
#define MTU_MC57_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00649F8u)

/** \brief 39FA, Error Information Register 4 */
#define MTU_MC57_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00649FAu)

/** \brief 3A00, Configuration Registers */
#define MTU_MC58_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064A00u)

/** \brief 3A02, Configuration Register 1 */
#define MTU_MC58_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064A02u)

/** \brief 3A04, MBIST Control Register */
#define MTU_MC58_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064A04u)

/** \brief 3A06, Status Register */
#define MTU_MC58_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064A06u)

/** \brief 3A08, Range Register, single address mode */
#define MTU_MC58_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064A08u)

/** \brief 3A0C, Revision ID Register */
#define MTU_MC58_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0064A0Cu)

/** \brief 3A0E, ECC Safety Register */
#define MTU_MC58_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0064A0Eu)

/** \brief 3A10, Memory ECC Detection Register */
#define MTU_MC58_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064A10u)

/** \brief 3A12, Error Tracking Register 0 */
#define MTU_MC58_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064A12u)

/** \brief 3A14, Error Tracking Register 1 */
#define MTU_MC58_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064A14u)

/** \brief 3A16, Error Tracking Register 2 */
#define MTU_MC58_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064A16u)

/** \brief 3A18, Error Tracking Register 3 */
#define MTU_MC58_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064A18u)

/** \brief 3A1A, Error Tracking Register 4 */
#define MTU_MC58_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064A1Au)

/** \brief 3A60, Read Data and Bit Flip Register 0 */
#define MTU_MC58_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A60u)

/** \brief 3A62, Read Data and Bit Flip Register 1 */
#define MTU_MC58_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A62u)

/** \brief 3A64, Read Data and Bit Flip Register 2 */
#define MTU_MC58_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A64u)

/** \brief 3A66, Read Data and Bit Flip Register 3 */
#define MTU_MC58_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A66u)

/** \brief 3A68, Read Data and Bit Flip Register 4 */
#define MTU_MC58_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A68u)

/** \brief 3A6A, Read Data and Bit Flip Register 5 */
#define MTU_MC58_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A6Au)

/** \brief 3A6C, Read Data and Bit Flip Register 6 */
#define MTU_MC58_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A6Cu)

/** \brief 3A6E, Read Data and Bit Flip Register 7 */
#define MTU_MC58_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A6Eu)

/** \brief 3A70, Read Data and Bit Flip Register 8 */
#define MTU_MC58_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A70u)

/** \brief 3A72, Read Data and Bit Flip Register 9 */
#define MTU_MC58_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A72u)

/** \brief 3A74, Read Data and Bit Flip Register 10 */
#define MTU_MC58_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A74u)

/** \brief 3A76, Read Data and Bit Flip Register 11 */
#define MTU_MC58_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A76u)

/** \brief 3A78, Read Data and Bit Flip Register 12 */
#define MTU_MC58_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A78u)

/** \brief 3A7A, Read Data and Bit Flip Register 13 */
#define MTU_MC58_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A7Au)

/** \brief 3A7C, Read Data and Bit Flip Register 14 */
#define MTU_MC58_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A7Cu)

/** \brief 3A7E, Read Data and Bit Flip Register 15 */
#define MTU_MC58_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A7Eu)

/** \brief 3A80, Read Data and Bit Flip Register 16 */
#define MTU_MC58_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A80u)

/** \brief 3A82, Read Data and Bit Flip Register 17 */
#define MTU_MC58_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A82u)

/** \brief 3A84, Read Data and Bit Flip Register 18 */
#define MTU_MC58_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A84u)

/** \brief 3A86, Read Data and Bit Flip Register 19 */
#define MTU_MC58_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A86u)

/** \brief 3A88, Read Data and Bit Flip Register 20 */
#define MTU_MC58_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A88u)

/** \brief 3A8A, Read Data and Bit Flip Register 21 */
#define MTU_MC58_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A8Au)

/** \brief 3A8C, Read Data and Bit Flip Register 22 */
#define MTU_MC58_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A8Cu)

/** \brief 3A8E, Read Data and Bit Flip Register 23 */
#define MTU_MC58_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A8Eu)

/** \brief 3A90, Read Data and Bit Flip Register 24 */
#define MTU_MC58_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A90u)

/** \brief 3A92, Read Data and Bit Flip Register 25 */
#define MTU_MC58_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A92u)

/** \brief 3A94, Read Data and Bit Flip Register 26 */
#define MTU_MC58_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A94u)

/** \brief 3A96, Read Data and Bit Flip Register 27 */
#define MTU_MC58_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A96u)

/** \brief 3A98, Read Data and Bit Flip Register 28 */
#define MTU_MC58_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A98u)

/** \brief 3A9A, Read Data and Bit Flip Register 29 */
#define MTU_MC58_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A9Au)

/** \brief 3A9C, Read Data and Bit Flip Register 30 */
#define MTU_MC58_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A9Cu)

/** \brief 3A9E, Read Data and Bit Flip Register 31 */
#define MTU_MC58_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064A9Eu)

/** \brief 3AA0, Read Data and Bit Flip Register 32 */
#define MTU_MC58_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AA0u)

/** \brief 3AA2, Read Data and Bit Flip Register 33 */
#define MTU_MC58_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AA2u)

/** \brief 3AA4, Read Data and Bit Flip Register 34 */
#define MTU_MC58_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AA4u)

/** \brief 3AA6, Read Data and Bit Flip Register 35 */
#define MTU_MC58_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AA6u)

/** \brief 3AA8, Read Data and Bit Flip Register 36 */
#define MTU_MC58_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AA8u)

/** \brief 3AAA, Read Data and Bit Flip Register 37 */
#define MTU_MC58_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AAAu)

/** \brief 3AAC, Read Data and Bit Flip Register 38 */
#define MTU_MC58_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AACu)

/** \brief 3AAE, Read Data and Bit Flip Register 39 */
#define MTU_MC58_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AAEu)

/** \brief 3AB0, Read Data and Bit Flip Register 40 */
#define MTU_MC58_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AB0u)

/** \brief 3AB2, Read Data and Bit Flip Register 41 */
#define MTU_MC58_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AB2u)

/** \brief 3AB4, Read Data and Bit Flip Register 42 */
#define MTU_MC58_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AB4u)

/** \brief 3AB6, Read Data and Bit Flip Register 43 */
#define MTU_MC58_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AB6u)

/** \brief 3AB8, Read Data and Bit Flip Register 44 */
#define MTU_MC58_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AB8u)

/** \brief 3ABA, Read Data and Bit Flip Register 45 */
#define MTU_MC58_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ABAu)

/** \brief 3ABC, Read Data and Bit Flip Register 46 */
#define MTU_MC58_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ABCu)

/** \brief 3ABE, Read Data and Bit Flip Register 47 */
#define MTU_MC58_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ABEu)

/** \brief 3AC0, Read Data and Bit Flip Register 48 */
#define MTU_MC58_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AC0u)

/** \brief 3AC2, Read Data and Bit Flip Register 49 */
#define MTU_MC58_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AC2u)

/** \brief 3AC4, Read Data and Bit Flip Register 50 */
#define MTU_MC58_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AC4u)

/** \brief 3AC6, Read Data and Bit Flip Register 51 */
#define MTU_MC58_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AC6u)

/** \brief 3AC8, Read Data and Bit Flip Register 52 */
#define MTU_MC58_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AC8u)

/** \brief 3ACA, Read Data and Bit Flip Register 53 */
#define MTU_MC58_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ACAu)

/** \brief 3ACC, Read Data and Bit Flip Register 54 */
#define MTU_MC58_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ACCu)

/** \brief 3ACE, Read Data and Bit Flip Register 55 */
#define MTU_MC58_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ACEu)

/** \brief 3AD0, Read Data and Bit Flip Register 56 */
#define MTU_MC58_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AD0u)

/** \brief 3AD2, Read Data and Bit Flip Register 57 */
#define MTU_MC58_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AD2u)

/** \brief 3AD4, Read Data and Bit Flip Register 58 */
#define MTU_MC58_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AD4u)

/** \brief 3AD6, Read Data and Bit Flip Register 59 */
#define MTU_MC58_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AD6u)

/** \brief 3AD8, Read Data and Bit Flip Register 60 */
#define MTU_MC58_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AD8u)

/** \brief 3ADA, Read Data and Bit Flip Register 61 */
#define MTU_MC58_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ADAu)

/** \brief 3ADC, Read Data and Bit Flip Register 62 */
#define MTU_MC58_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ADCu)

/** \brief 3ADE, Read Data and Bit Flip Register 63 */
#define MTU_MC58_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ADEu)

/** \brief 3AE0, Read Data and Bit Flip Register 64 */
#define MTU_MC58_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AE0u)

/** \brief 3AE2, Read Data and Bit Flip Register 65 */
#define MTU_MC58_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AE2u)

/** \brief 3AE4, Read Data and Bit Flip Register 66 */
#define MTU_MC58_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064AE4u)

/** \brief 3AEE, Alarm Sources Configuration Register */
#define MTU_MC58_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0064AEEu)

/** \brief 3AF0, SSH Safety Faults Status Register  */
#define MTU_MC58_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0064AF0u)

/** \brief 3AF2, Error Information Register 0 */
#define MTU_MC58_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064AF2u)

/** \brief 3AF4, Error Information Register 1 */
#define MTU_MC58_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064AF4u)

/** \brief 3AF6, Error Information Register 2 */
#define MTU_MC58_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064AF6u)

/** \brief 3AF8, Error Information Register 3 */
#define MTU_MC58_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064AF8u)

/** \brief 3AFA, Error Information Register 4 */
#define MTU_MC58_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064AFAu)

/** \brief 3B00, Configuration Registers */
#define MTU_MC59_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064B00u)

/** \brief 3B02, Configuration Register 1 */
#define MTU_MC59_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064B02u)

/** \brief 3B04, MBIST Control Register */
#define MTU_MC59_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064B04u)

/** \brief 3B06, Status Register */
#define MTU_MC59_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064B06u)

/** \brief 3B08, Range Register, single address mode */
#define MTU_MC59_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064B08u)

/** \brief 3B0C, Revision ID Register */
#define MTU_MC59_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0064B0Cu)

/** \brief 3B0E, ECC Safety Register */
#define MTU_MC59_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0064B0Eu)

/** \brief 3B10, Memory ECC Detection Register */
#define MTU_MC59_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064B10u)

/** \brief 3B12, Error Tracking Register 0 */
#define MTU_MC59_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064B12u)

/** \brief 3B14, Error Tracking Register 1 */
#define MTU_MC59_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064B14u)

/** \brief 3B16, Error Tracking Register 2 */
#define MTU_MC59_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064B16u)

/** \brief 3B18, Error Tracking Register 3 */
#define MTU_MC59_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064B18u)

/** \brief 3B1A, Error Tracking Register 4 */
#define MTU_MC59_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064B1Au)

/** \brief 3B60, Read Data and Bit Flip Register 0 */
#define MTU_MC59_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B60u)

/** \brief 3B62, Read Data and Bit Flip Register 1 */
#define MTU_MC59_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B62u)

/** \brief 3B64, Read Data and Bit Flip Register 2 */
#define MTU_MC59_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B64u)

/** \brief 3B66, Read Data and Bit Flip Register 3 */
#define MTU_MC59_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B66u)

/** \brief 3B68, Read Data and Bit Flip Register 4 */
#define MTU_MC59_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B68u)

/** \brief 3B6A, Read Data and Bit Flip Register 5 */
#define MTU_MC59_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B6Au)

/** \brief 3B6C, Read Data and Bit Flip Register 6 */
#define MTU_MC59_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B6Cu)

/** \brief 3B6E, Read Data and Bit Flip Register 7 */
#define MTU_MC59_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B6Eu)

/** \brief 3B70, Read Data and Bit Flip Register 8 */
#define MTU_MC59_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B70u)

/** \brief 3B72, Read Data and Bit Flip Register 9 */
#define MTU_MC59_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B72u)

/** \brief 3B74, Read Data and Bit Flip Register 10 */
#define MTU_MC59_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B74u)

/** \brief 3B76, Read Data and Bit Flip Register 11 */
#define MTU_MC59_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B76u)

/** \brief 3B78, Read Data and Bit Flip Register 12 */
#define MTU_MC59_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B78u)

/** \brief 3B7A, Read Data and Bit Flip Register 13 */
#define MTU_MC59_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B7Au)

/** \brief 3B7C, Read Data and Bit Flip Register 14 */
#define MTU_MC59_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B7Cu)

/** \brief 3B7E, Read Data and Bit Flip Register 15 */
#define MTU_MC59_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B7Eu)

/** \brief 3B80, Read Data and Bit Flip Register 16 */
#define MTU_MC59_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B80u)

/** \brief 3B82, Read Data and Bit Flip Register 17 */
#define MTU_MC59_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B82u)

/** \brief 3B84, Read Data and Bit Flip Register 18 */
#define MTU_MC59_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B84u)

/** \brief 3B86, Read Data and Bit Flip Register 19 */
#define MTU_MC59_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B86u)

/** \brief 3B88, Read Data and Bit Flip Register 20 */
#define MTU_MC59_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B88u)

/** \brief 3B8A, Read Data and Bit Flip Register 21 */
#define MTU_MC59_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B8Au)

/** \brief 3B8C, Read Data and Bit Flip Register 22 */
#define MTU_MC59_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B8Cu)

/** \brief 3B8E, Read Data and Bit Flip Register 23 */
#define MTU_MC59_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B8Eu)

/** \brief 3B90, Read Data and Bit Flip Register 24 */
#define MTU_MC59_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B90u)

/** \brief 3B92, Read Data and Bit Flip Register 25 */
#define MTU_MC59_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B92u)

/** \brief 3B94, Read Data and Bit Flip Register 26 */
#define MTU_MC59_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B94u)

/** \brief 3B96, Read Data and Bit Flip Register 27 */
#define MTU_MC59_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B96u)

/** \brief 3B98, Read Data and Bit Flip Register 28 */
#define MTU_MC59_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B98u)

/** \brief 3B9A, Read Data and Bit Flip Register 29 */
#define MTU_MC59_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B9Au)

/** \brief 3B9C, Read Data and Bit Flip Register 30 */
#define MTU_MC59_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B9Cu)

/** \brief 3B9E, Read Data and Bit Flip Register 31 */
#define MTU_MC59_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064B9Eu)

/** \brief 3BA0, Read Data and Bit Flip Register 32 */
#define MTU_MC59_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BA0u)

/** \brief 3BA2, Read Data and Bit Flip Register 33 */
#define MTU_MC59_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BA2u)

/** \brief 3BA4, Read Data and Bit Flip Register 34 */
#define MTU_MC59_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BA4u)

/** \brief 3BA6, Read Data and Bit Flip Register 35 */
#define MTU_MC59_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BA6u)

/** \brief 3BA8, Read Data and Bit Flip Register 36 */
#define MTU_MC59_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BA8u)

/** \brief 3BAA, Read Data and Bit Flip Register 37 */
#define MTU_MC59_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BAAu)

/** \brief 3BAC, Read Data and Bit Flip Register 38 */
#define MTU_MC59_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BACu)

/** \brief 3BAE, Read Data and Bit Flip Register 39 */
#define MTU_MC59_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BAEu)

/** \brief 3BB0, Read Data and Bit Flip Register 40 */
#define MTU_MC59_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BB0u)

/** \brief 3BB2, Read Data and Bit Flip Register 41 */
#define MTU_MC59_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BB2u)

/** \brief 3BB4, Read Data and Bit Flip Register 42 */
#define MTU_MC59_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BB4u)

/** \brief 3BB6, Read Data and Bit Flip Register 43 */
#define MTU_MC59_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BB6u)

/** \brief 3BB8, Read Data and Bit Flip Register 44 */
#define MTU_MC59_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BB8u)

/** \brief 3BBA, Read Data and Bit Flip Register 45 */
#define MTU_MC59_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BBAu)

/** \brief 3BBC, Read Data and Bit Flip Register 46 */
#define MTU_MC59_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BBCu)

/** \brief 3BBE, Read Data and Bit Flip Register 47 */
#define MTU_MC59_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BBEu)

/** \brief 3BC0, Read Data and Bit Flip Register 48 */
#define MTU_MC59_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BC0u)

/** \brief 3BC2, Read Data and Bit Flip Register 49 */
#define MTU_MC59_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BC2u)

/** \brief 3BC4, Read Data and Bit Flip Register 50 */
#define MTU_MC59_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BC4u)

/** \brief 3BC6, Read Data and Bit Flip Register 51 */
#define MTU_MC59_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BC6u)

/** \brief 3BC8, Read Data and Bit Flip Register 52 */
#define MTU_MC59_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BC8u)

/** \brief 3BCA, Read Data and Bit Flip Register 53 */
#define MTU_MC59_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BCAu)

/** \brief 3BCC, Read Data and Bit Flip Register 54 */
#define MTU_MC59_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BCCu)

/** \brief 3BCE, Read Data and Bit Flip Register 55 */
#define MTU_MC59_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BCEu)

/** \brief 3BD0, Read Data and Bit Flip Register 56 */
#define MTU_MC59_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BD0u)

/** \brief 3BD2, Read Data and Bit Flip Register 57 */
#define MTU_MC59_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BD2u)

/** \brief 3BD4, Read Data and Bit Flip Register 58 */
#define MTU_MC59_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BD4u)

/** \brief 3BD6, Read Data and Bit Flip Register 59 */
#define MTU_MC59_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BD6u)

/** \brief 3BD8, Read Data and Bit Flip Register 60 */
#define MTU_MC59_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BD8u)

/** \brief 3BDA, Read Data and Bit Flip Register 61 */
#define MTU_MC59_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BDAu)

/** \brief 3BDC, Read Data and Bit Flip Register 62 */
#define MTU_MC59_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BDCu)

/** \brief 3BDE, Read Data and Bit Flip Register 63 */
#define MTU_MC59_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BDEu)

/** \brief 3BE0, Read Data and Bit Flip Register 64 */
#define MTU_MC59_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BE0u)

/** \brief 3BE2, Read Data and Bit Flip Register 65 */
#define MTU_MC59_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BE2u)

/** \brief 3BE4, Read Data and Bit Flip Register 66 */
#define MTU_MC59_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064BE4u)

/** \brief 3BEE, Alarm Sources Configuration Register */
#define MTU_MC59_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0064BEEu)

/** \brief 3BF0, SSH Safety Faults Status Register  */
#define MTU_MC59_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0064BF0u)

/** \brief 3BF2, Error Information Register 0 */
#define MTU_MC59_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064BF2u)

/** \brief 3BF4, Error Information Register 1 */
#define MTU_MC59_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064BF4u)

/** \brief 3BF6, Error Information Register 2 */
#define MTU_MC59_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064BF6u)

/** \brief 3BF8, Error Information Register 3 */
#define MTU_MC59_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064BF8u)

/** \brief 3BFA, Error Information Register 4 */
#define MTU_MC59_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064BFAu)

/** \brief 3C00, Configuration Registers */
#define MTU_MC60_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064C00u)

/** \brief 3C02, Configuration Register 1 */
#define MTU_MC60_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064C02u)

/** \brief 3C04, MBIST Control Register */
#define MTU_MC60_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064C04u)

/** \brief 3C06, Status Register */
#define MTU_MC60_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064C06u)

/** \brief 3C08, Range Register, single address mode */
#define MTU_MC60_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064C08u)

/** \brief 3C0C, Revision ID Register */
#define MTU_MC60_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0064C0Cu)

/** \brief 3C0E, ECC Safety Register */
#define MTU_MC60_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0064C0Eu)

/** \brief 3C10, Memory ECC Detection Register */
#define MTU_MC60_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064C10u)

/** \brief 3C12, Error Tracking Register 0 */
#define MTU_MC60_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064C12u)

/** \brief 3C14, Error Tracking Register 1 */
#define MTU_MC60_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064C14u)

/** \brief 3C16, Error Tracking Register 2 */
#define MTU_MC60_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064C16u)

/** \brief 3C18, Error Tracking Register 3 */
#define MTU_MC60_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064C18u)

/** \brief 3C1A, Error Tracking Register 4 */
#define MTU_MC60_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064C1Au)

/** \brief 3C60, Read Data and Bit Flip Register 0 */
#define MTU_MC60_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C60u)

/** \brief 3C62, Read Data and Bit Flip Register 1 */
#define MTU_MC60_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C62u)

/** \brief 3C64, Read Data and Bit Flip Register 2 */
#define MTU_MC60_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C64u)

/** \brief 3C66, Read Data and Bit Flip Register 3 */
#define MTU_MC60_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C66u)

/** \brief 3C68, Read Data and Bit Flip Register 4 */
#define MTU_MC60_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C68u)

/** \brief 3C6A, Read Data and Bit Flip Register 5 */
#define MTU_MC60_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C6Au)

/** \brief 3C6C, Read Data and Bit Flip Register 6 */
#define MTU_MC60_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C6Cu)

/** \brief 3C6E, Read Data and Bit Flip Register 7 */
#define MTU_MC60_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C6Eu)

/** \brief 3C70, Read Data and Bit Flip Register 8 */
#define MTU_MC60_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C70u)

/** \brief 3C72, Read Data and Bit Flip Register 9 */
#define MTU_MC60_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C72u)

/** \brief 3C74, Read Data and Bit Flip Register 10 */
#define MTU_MC60_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C74u)

/** \brief 3C76, Read Data and Bit Flip Register 11 */
#define MTU_MC60_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C76u)

/** \brief 3C78, Read Data and Bit Flip Register 12 */
#define MTU_MC60_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C78u)

/** \brief 3C7A, Read Data and Bit Flip Register 13 */
#define MTU_MC60_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C7Au)

/** \brief 3C7C, Read Data and Bit Flip Register 14 */
#define MTU_MC60_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C7Cu)

/** \brief 3C7E, Read Data and Bit Flip Register 15 */
#define MTU_MC60_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C7Eu)

/** \brief 3C80, Read Data and Bit Flip Register 16 */
#define MTU_MC60_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C80u)

/** \brief 3C82, Read Data and Bit Flip Register 17 */
#define MTU_MC60_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C82u)

/** \brief 3C84, Read Data and Bit Flip Register 18 */
#define MTU_MC60_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C84u)

/** \brief 3C86, Read Data and Bit Flip Register 19 */
#define MTU_MC60_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C86u)

/** \brief 3C88, Read Data and Bit Flip Register 20 */
#define MTU_MC60_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C88u)

/** \brief 3C8A, Read Data and Bit Flip Register 21 */
#define MTU_MC60_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C8Au)

/** \brief 3C8C, Read Data and Bit Flip Register 22 */
#define MTU_MC60_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C8Cu)

/** \brief 3C8E, Read Data and Bit Flip Register 23 */
#define MTU_MC60_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C8Eu)

/** \brief 3C90, Read Data and Bit Flip Register 24 */
#define MTU_MC60_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C90u)

/** \brief 3C92, Read Data and Bit Flip Register 25 */
#define MTU_MC60_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C92u)

/** \brief 3C94, Read Data and Bit Flip Register 26 */
#define MTU_MC60_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C94u)

/** \brief 3C96, Read Data and Bit Flip Register 27 */
#define MTU_MC60_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C96u)

/** \brief 3C98, Read Data and Bit Flip Register 28 */
#define MTU_MC60_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C98u)

/** \brief 3C9A, Read Data and Bit Flip Register 29 */
#define MTU_MC60_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C9Au)

/** \brief 3C9C, Read Data and Bit Flip Register 30 */
#define MTU_MC60_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C9Cu)

/** \brief 3C9E, Read Data and Bit Flip Register 31 */
#define MTU_MC60_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064C9Eu)

/** \brief 3CA0, Read Data and Bit Flip Register 32 */
#define MTU_MC60_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CA0u)

/** \brief 3CA2, Read Data and Bit Flip Register 33 */
#define MTU_MC60_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CA2u)

/** \brief 3CA4, Read Data and Bit Flip Register 34 */
#define MTU_MC60_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CA4u)

/** \brief 3CA6, Read Data and Bit Flip Register 35 */
#define MTU_MC60_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CA6u)

/** \brief 3CA8, Read Data and Bit Flip Register 36 */
#define MTU_MC60_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CA8u)

/** \brief 3CAA, Read Data and Bit Flip Register 37 */
#define MTU_MC60_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CAAu)

/** \brief 3CAC, Read Data and Bit Flip Register 38 */
#define MTU_MC60_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CACu)

/** \brief 3CAE, Read Data and Bit Flip Register 39 */
#define MTU_MC60_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CAEu)

/** \brief 3CB0, Read Data and Bit Flip Register 40 */
#define MTU_MC60_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CB0u)

/** \brief 3CB2, Read Data and Bit Flip Register 41 */
#define MTU_MC60_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CB2u)

/** \brief 3CB4, Read Data and Bit Flip Register 42 */
#define MTU_MC60_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CB4u)

/** \brief 3CB6, Read Data and Bit Flip Register 43 */
#define MTU_MC60_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CB6u)

/** \brief 3CB8, Read Data and Bit Flip Register 44 */
#define MTU_MC60_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CB8u)

/** \brief 3CBA, Read Data and Bit Flip Register 45 */
#define MTU_MC60_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CBAu)

/** \brief 3CBC, Read Data and Bit Flip Register 46 */
#define MTU_MC60_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CBCu)

/** \brief 3CBE, Read Data and Bit Flip Register 47 */
#define MTU_MC60_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CBEu)

/** \brief 3CC0, Read Data and Bit Flip Register 48 */
#define MTU_MC60_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CC0u)

/** \brief 3CC2, Read Data and Bit Flip Register 49 */
#define MTU_MC60_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CC2u)

/** \brief 3CC4, Read Data and Bit Flip Register 50 */
#define MTU_MC60_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CC4u)

/** \brief 3CC6, Read Data and Bit Flip Register 51 */
#define MTU_MC60_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CC6u)

/** \brief 3CC8, Read Data and Bit Flip Register 52 */
#define MTU_MC60_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CC8u)

/** \brief 3CCA, Read Data and Bit Flip Register 53 */
#define MTU_MC60_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CCAu)

/** \brief 3CCC, Read Data and Bit Flip Register 54 */
#define MTU_MC60_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CCCu)

/** \brief 3CCE, Read Data and Bit Flip Register 55 */
#define MTU_MC60_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CCEu)

/** \brief 3CD0, Read Data and Bit Flip Register 56 */
#define MTU_MC60_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CD0u)

/** \brief 3CD2, Read Data and Bit Flip Register 57 */
#define MTU_MC60_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CD2u)

/** \brief 3CD4, Read Data and Bit Flip Register 58 */
#define MTU_MC60_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CD4u)

/** \brief 3CD6, Read Data and Bit Flip Register 59 */
#define MTU_MC60_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CD6u)

/** \brief 3CD8, Read Data and Bit Flip Register 60 */
#define MTU_MC60_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CD8u)

/** \brief 3CDA, Read Data and Bit Flip Register 61 */
#define MTU_MC60_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CDAu)

/** \brief 3CDC, Read Data and Bit Flip Register 62 */
#define MTU_MC60_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CDCu)

/** \brief 3CDE, Read Data and Bit Flip Register 63 */
#define MTU_MC60_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CDEu)

/** \brief 3CE0, Read Data and Bit Flip Register 64 */
#define MTU_MC60_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CE0u)

/** \brief 3CE2, Read Data and Bit Flip Register 65 */
#define MTU_MC60_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CE2u)

/** \brief 3CE4, Read Data and Bit Flip Register 66 */
#define MTU_MC60_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064CE4u)

/** \brief 3CEE, Alarm Sources Configuration Register */
#define MTU_MC60_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0064CEEu)

/** \brief 3CF0, SSH Safety Faults Status Register  */
#define MTU_MC60_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0064CF0u)

/** \brief 3CF2, Error Information Register 0 */
#define MTU_MC60_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064CF2u)

/** \brief 3CF4, Error Information Register 1 */
#define MTU_MC60_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064CF4u)

/** \brief 3CF6, Error Information Register 2 */
#define MTU_MC60_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064CF6u)

/** \brief 3CF8, Error Information Register 3 */
#define MTU_MC60_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064CF8u)

/** \brief 3CFA, Error Information Register 4 */
#define MTU_MC60_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064CFAu)

/** \brief 3D00, Configuration Registers */
#define MTU_MC61_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064D00u)

/** \brief 3D02, Configuration Register 1 */
#define MTU_MC61_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064D02u)

/** \brief 3D04, MBIST Control Register */
#define MTU_MC61_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064D04u)

/** \brief 3D06, Status Register */
#define MTU_MC61_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064D06u)

/** \brief 3D08, Range Register, single address mode */
#define MTU_MC61_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064D08u)

/** \brief 3D0C, Revision ID Register */
#define MTU_MC61_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0064D0Cu)

/** \brief 3D0E, ECC Safety Register */
#define MTU_MC61_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0064D0Eu)

/** \brief 3D10, Memory ECC Detection Register */
#define MTU_MC61_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064D10u)

/** \brief 3D12, Error Tracking Register 0 */
#define MTU_MC61_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064D12u)

/** \brief 3D14, Error Tracking Register 1 */
#define MTU_MC61_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064D14u)

/** \brief 3D16, Error Tracking Register 2 */
#define MTU_MC61_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064D16u)

/** \brief 3D18, Error Tracking Register 3 */
#define MTU_MC61_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064D18u)

/** \brief 3D1A, Error Tracking Register 4 */
#define MTU_MC61_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064D1Au)

/** \brief 3D60, Read Data and Bit Flip Register 0 */
#define MTU_MC61_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D60u)

/** \brief 3D62, Read Data and Bit Flip Register 1 */
#define MTU_MC61_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D62u)

/** \brief 3D64, Read Data and Bit Flip Register 2 */
#define MTU_MC61_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D64u)

/** \brief 3D66, Read Data and Bit Flip Register 3 */
#define MTU_MC61_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D66u)

/** \brief 3D68, Read Data and Bit Flip Register 4 */
#define MTU_MC61_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D68u)

/** \brief 3D6A, Read Data and Bit Flip Register 5 */
#define MTU_MC61_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D6Au)

/** \brief 3D6C, Read Data and Bit Flip Register 6 */
#define MTU_MC61_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D6Cu)

/** \brief 3D6E, Read Data and Bit Flip Register 7 */
#define MTU_MC61_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D6Eu)

/** \brief 3D70, Read Data and Bit Flip Register 8 */
#define MTU_MC61_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D70u)

/** \brief 3D72, Read Data and Bit Flip Register 9 */
#define MTU_MC61_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D72u)

/** \brief 3D74, Read Data and Bit Flip Register 10 */
#define MTU_MC61_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D74u)

/** \brief 3D76, Read Data and Bit Flip Register 11 */
#define MTU_MC61_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D76u)

/** \brief 3D78, Read Data and Bit Flip Register 12 */
#define MTU_MC61_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D78u)

/** \brief 3D7A, Read Data and Bit Flip Register 13 */
#define MTU_MC61_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D7Au)

/** \brief 3D7C, Read Data and Bit Flip Register 14 */
#define MTU_MC61_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D7Cu)

/** \brief 3D7E, Read Data and Bit Flip Register 15 */
#define MTU_MC61_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D7Eu)

/** \brief 3D80, Read Data and Bit Flip Register 16 */
#define MTU_MC61_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D80u)

/** \brief 3D82, Read Data and Bit Flip Register 17 */
#define MTU_MC61_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D82u)

/** \brief 3D84, Read Data and Bit Flip Register 18 */
#define MTU_MC61_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D84u)

/** \brief 3D86, Read Data and Bit Flip Register 19 */
#define MTU_MC61_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D86u)

/** \brief 3D88, Read Data and Bit Flip Register 20 */
#define MTU_MC61_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D88u)

/** \brief 3D8A, Read Data and Bit Flip Register 21 */
#define MTU_MC61_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D8Au)

/** \brief 3D8C, Read Data and Bit Flip Register 22 */
#define MTU_MC61_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D8Cu)

/** \brief 3D8E, Read Data and Bit Flip Register 23 */
#define MTU_MC61_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D8Eu)

/** \brief 3D90, Read Data and Bit Flip Register 24 */
#define MTU_MC61_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D90u)

/** \brief 3D92, Read Data and Bit Flip Register 25 */
#define MTU_MC61_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D92u)

/** \brief 3D94, Read Data and Bit Flip Register 26 */
#define MTU_MC61_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D94u)

/** \brief 3D96, Read Data and Bit Flip Register 27 */
#define MTU_MC61_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D96u)

/** \brief 3D98, Read Data and Bit Flip Register 28 */
#define MTU_MC61_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D98u)

/** \brief 3D9A, Read Data and Bit Flip Register 29 */
#define MTU_MC61_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D9Au)

/** \brief 3D9C, Read Data and Bit Flip Register 30 */
#define MTU_MC61_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D9Cu)

/** \brief 3D9E, Read Data and Bit Flip Register 31 */
#define MTU_MC61_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064D9Eu)

/** \brief 3DA0, Read Data and Bit Flip Register 32 */
#define MTU_MC61_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DA0u)

/** \brief 3DA2, Read Data and Bit Flip Register 33 */
#define MTU_MC61_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DA2u)

/** \brief 3DA4, Read Data and Bit Flip Register 34 */
#define MTU_MC61_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DA4u)

/** \brief 3DA6, Read Data and Bit Flip Register 35 */
#define MTU_MC61_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DA6u)

/** \brief 3DA8, Read Data and Bit Flip Register 36 */
#define MTU_MC61_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DA8u)

/** \brief 3DAA, Read Data and Bit Flip Register 37 */
#define MTU_MC61_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DAAu)

/** \brief 3DAC, Read Data and Bit Flip Register 38 */
#define MTU_MC61_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DACu)

/** \brief 3DAE, Read Data and Bit Flip Register 39 */
#define MTU_MC61_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DAEu)

/** \brief 3DB0, Read Data and Bit Flip Register 40 */
#define MTU_MC61_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DB0u)

/** \brief 3DB2, Read Data and Bit Flip Register 41 */
#define MTU_MC61_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DB2u)

/** \brief 3DB4, Read Data and Bit Flip Register 42 */
#define MTU_MC61_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DB4u)

/** \brief 3DB6, Read Data and Bit Flip Register 43 */
#define MTU_MC61_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DB6u)

/** \brief 3DB8, Read Data and Bit Flip Register 44 */
#define MTU_MC61_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DB8u)

/** \brief 3DBA, Read Data and Bit Flip Register 45 */
#define MTU_MC61_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DBAu)

/** \brief 3DBC, Read Data and Bit Flip Register 46 */
#define MTU_MC61_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DBCu)

/** \brief 3DBE, Read Data and Bit Flip Register 47 */
#define MTU_MC61_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DBEu)

/** \brief 3DC0, Read Data and Bit Flip Register 48 */
#define MTU_MC61_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DC0u)

/** \brief 3DC2, Read Data and Bit Flip Register 49 */
#define MTU_MC61_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DC2u)

/** \brief 3DC4, Read Data and Bit Flip Register 50 */
#define MTU_MC61_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DC4u)

/** \brief 3DC6, Read Data and Bit Flip Register 51 */
#define MTU_MC61_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DC6u)

/** \brief 3DC8, Read Data and Bit Flip Register 52 */
#define MTU_MC61_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DC8u)

/** \brief 3DCA, Read Data and Bit Flip Register 53 */
#define MTU_MC61_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DCAu)

/** \brief 3DCC, Read Data and Bit Flip Register 54 */
#define MTU_MC61_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DCCu)

/** \brief 3DCE, Read Data and Bit Flip Register 55 */
#define MTU_MC61_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DCEu)

/** \brief 3DD0, Read Data and Bit Flip Register 56 */
#define MTU_MC61_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DD0u)

/** \brief 3DD2, Read Data and Bit Flip Register 57 */
#define MTU_MC61_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DD2u)

/** \brief 3DD4, Read Data and Bit Flip Register 58 */
#define MTU_MC61_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DD4u)

/** \brief 3DD6, Read Data and Bit Flip Register 59 */
#define MTU_MC61_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DD6u)

/** \brief 3DD8, Read Data and Bit Flip Register 60 */
#define MTU_MC61_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DD8u)

/** \brief 3DDA, Read Data and Bit Flip Register 61 */
#define MTU_MC61_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DDAu)

/** \brief 3DDC, Read Data and Bit Flip Register 62 */
#define MTU_MC61_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DDCu)

/** \brief 3DDE, Read Data and Bit Flip Register 63 */
#define MTU_MC61_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DDEu)

/** \brief 3DE0, Read Data and Bit Flip Register 64 */
#define MTU_MC61_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DE0u)

/** \brief 3DE2, Read Data and Bit Flip Register 65 */
#define MTU_MC61_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DE2u)

/** \brief 3DE4, Read Data and Bit Flip Register 66 */
#define MTU_MC61_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064DE4u)

/** \brief 3DEE, Alarm Sources Configuration Register */
#define MTU_MC61_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0064DEEu)

/** \brief 3DF0, SSH Safety Faults Status Register  */
#define MTU_MC61_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0064DF0u)

/** \brief 3DF2, Error Information Register 0 */
#define MTU_MC61_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064DF2u)

/** \brief 3DF4, Error Information Register 1 */
#define MTU_MC61_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064DF4u)

/** \brief 3DF6, Error Information Register 2 */
#define MTU_MC61_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064DF6u)

/** \brief 3DF8, Error Information Register 3 */
#define MTU_MC61_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064DF8u)

/** \brief 3DFA, Error Information Register 4 */
#define MTU_MC61_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064DFAu)

/** \brief 3E00, Configuration Registers */
#define MTU_MC62_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064E00u)

/** \brief 3E02, Configuration Register 1 */
#define MTU_MC62_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064E02u)

/** \brief 3E04, MBIST Control Register */
#define MTU_MC62_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064E04u)

/** \brief 3E06, Status Register */
#define MTU_MC62_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064E06u)

/** \brief 3E08, Range Register, single address mode */
#define MTU_MC62_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064E08u)

/** \brief 3E0C, Revision ID Register */
#define MTU_MC62_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0064E0Cu)

/** \brief 3E0E, ECC Safety Register */
#define MTU_MC62_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0064E0Eu)

/** \brief 3E10, Memory ECC Detection Register */
#define MTU_MC62_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064E10u)

/** \brief 3E12, Error Tracking Register 0 */
#define MTU_MC62_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064E12u)

/** \brief 3E14, Error Tracking Register 1 */
#define MTU_MC62_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064E14u)

/** \brief 3E16, Error Tracking Register 2 */
#define MTU_MC62_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064E16u)

/** \brief 3E18, Error Tracking Register 3 */
#define MTU_MC62_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064E18u)

/** \brief 3E1A, Error Tracking Register 4 */
#define MTU_MC62_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064E1Au)

/** \brief 3E60, Read Data and Bit Flip Register 0 */
#define MTU_MC62_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E60u)

/** \brief 3E62, Read Data and Bit Flip Register 1 */
#define MTU_MC62_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E62u)

/** \brief 3E64, Read Data and Bit Flip Register 2 */
#define MTU_MC62_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E64u)

/** \brief 3E66, Read Data and Bit Flip Register 3 */
#define MTU_MC62_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E66u)

/** \brief 3E68, Read Data and Bit Flip Register 4 */
#define MTU_MC62_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E68u)

/** \brief 3E6A, Read Data and Bit Flip Register 5 */
#define MTU_MC62_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E6Au)

/** \brief 3E6C, Read Data and Bit Flip Register 6 */
#define MTU_MC62_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E6Cu)

/** \brief 3E6E, Read Data and Bit Flip Register 7 */
#define MTU_MC62_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E6Eu)

/** \brief 3E70, Read Data and Bit Flip Register 8 */
#define MTU_MC62_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E70u)

/** \brief 3E72, Read Data and Bit Flip Register 9 */
#define MTU_MC62_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E72u)

/** \brief 3E74, Read Data and Bit Flip Register 10 */
#define MTU_MC62_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E74u)

/** \brief 3E76, Read Data and Bit Flip Register 11 */
#define MTU_MC62_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E76u)

/** \brief 3E78, Read Data and Bit Flip Register 12 */
#define MTU_MC62_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E78u)

/** \brief 3E7A, Read Data and Bit Flip Register 13 */
#define MTU_MC62_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E7Au)

/** \brief 3E7C, Read Data and Bit Flip Register 14 */
#define MTU_MC62_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E7Cu)

/** \brief 3E7E, Read Data and Bit Flip Register 15 */
#define MTU_MC62_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E7Eu)

/** \brief 3E80, Read Data and Bit Flip Register 16 */
#define MTU_MC62_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E80u)

/** \brief 3E82, Read Data and Bit Flip Register 17 */
#define MTU_MC62_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E82u)

/** \brief 3E84, Read Data and Bit Flip Register 18 */
#define MTU_MC62_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E84u)

/** \brief 3E86, Read Data and Bit Flip Register 19 */
#define MTU_MC62_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E86u)

/** \brief 3E88, Read Data and Bit Flip Register 20 */
#define MTU_MC62_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E88u)

/** \brief 3E8A, Read Data and Bit Flip Register 21 */
#define MTU_MC62_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E8Au)

/** \brief 3E8C, Read Data and Bit Flip Register 22 */
#define MTU_MC62_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E8Cu)

/** \brief 3E8E, Read Data and Bit Flip Register 23 */
#define MTU_MC62_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E8Eu)

/** \brief 3E90, Read Data and Bit Flip Register 24 */
#define MTU_MC62_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E90u)

/** \brief 3E92, Read Data and Bit Flip Register 25 */
#define MTU_MC62_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E92u)

/** \brief 3E94, Read Data and Bit Flip Register 26 */
#define MTU_MC62_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E94u)

/** \brief 3E96, Read Data and Bit Flip Register 27 */
#define MTU_MC62_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E96u)

/** \brief 3E98, Read Data and Bit Flip Register 28 */
#define MTU_MC62_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E98u)

/** \brief 3E9A, Read Data and Bit Flip Register 29 */
#define MTU_MC62_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E9Au)

/** \brief 3E9C, Read Data and Bit Flip Register 30 */
#define MTU_MC62_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E9Cu)

/** \brief 3E9E, Read Data and Bit Flip Register 31 */
#define MTU_MC62_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064E9Eu)

/** \brief 3EA0, Read Data and Bit Flip Register 32 */
#define MTU_MC62_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EA0u)

/** \brief 3EA2, Read Data and Bit Flip Register 33 */
#define MTU_MC62_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EA2u)

/** \brief 3EA4, Read Data and Bit Flip Register 34 */
#define MTU_MC62_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EA4u)

/** \brief 3EA6, Read Data and Bit Flip Register 35 */
#define MTU_MC62_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EA6u)

/** \brief 3EA8, Read Data and Bit Flip Register 36 */
#define MTU_MC62_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EA8u)

/** \brief 3EAA, Read Data and Bit Flip Register 37 */
#define MTU_MC62_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EAAu)

/** \brief 3EAC, Read Data and Bit Flip Register 38 */
#define MTU_MC62_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EACu)

/** \brief 3EAE, Read Data and Bit Flip Register 39 */
#define MTU_MC62_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EAEu)

/** \brief 3EB0, Read Data and Bit Flip Register 40 */
#define MTU_MC62_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EB0u)

/** \brief 3EB2, Read Data and Bit Flip Register 41 */
#define MTU_MC62_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EB2u)

/** \brief 3EB4, Read Data and Bit Flip Register 42 */
#define MTU_MC62_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EB4u)

/** \brief 3EB6, Read Data and Bit Flip Register 43 */
#define MTU_MC62_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EB6u)

/** \brief 3EB8, Read Data and Bit Flip Register 44 */
#define MTU_MC62_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EB8u)

/** \brief 3EBA, Read Data and Bit Flip Register 45 */
#define MTU_MC62_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EBAu)

/** \brief 3EBC, Read Data and Bit Flip Register 46 */
#define MTU_MC62_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EBCu)

/** \brief 3EBE, Read Data and Bit Flip Register 47 */
#define MTU_MC62_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EBEu)

/** \brief 3EC0, Read Data and Bit Flip Register 48 */
#define MTU_MC62_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EC0u)

/** \brief 3EC2, Read Data and Bit Flip Register 49 */
#define MTU_MC62_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EC2u)

/** \brief 3EC4, Read Data and Bit Flip Register 50 */
#define MTU_MC62_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EC4u)

/** \brief 3EC6, Read Data and Bit Flip Register 51 */
#define MTU_MC62_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EC6u)

/** \brief 3EC8, Read Data and Bit Flip Register 52 */
#define MTU_MC62_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EC8u)

/** \brief 3ECA, Read Data and Bit Flip Register 53 */
#define MTU_MC62_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ECAu)

/** \brief 3ECC, Read Data and Bit Flip Register 54 */
#define MTU_MC62_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ECCu)

/** \brief 3ECE, Read Data and Bit Flip Register 55 */
#define MTU_MC62_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ECEu)

/** \brief 3ED0, Read Data and Bit Flip Register 56 */
#define MTU_MC62_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ED0u)

/** \brief 3ED2, Read Data and Bit Flip Register 57 */
#define MTU_MC62_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ED2u)

/** \brief 3ED4, Read Data and Bit Flip Register 58 */
#define MTU_MC62_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ED4u)

/** \brief 3ED6, Read Data and Bit Flip Register 59 */
#define MTU_MC62_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ED6u)

/** \brief 3ED8, Read Data and Bit Flip Register 60 */
#define MTU_MC62_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064ED8u)

/** \brief 3EDA, Read Data and Bit Flip Register 61 */
#define MTU_MC62_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EDAu)

/** \brief 3EDC, Read Data and Bit Flip Register 62 */
#define MTU_MC62_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EDCu)

/** \brief 3EDE, Read Data and Bit Flip Register 63 */
#define MTU_MC62_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EDEu)

/** \brief 3EE0, Read Data and Bit Flip Register 64 */
#define MTU_MC62_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EE0u)

/** \brief 3EE2, Read Data and Bit Flip Register 65 */
#define MTU_MC62_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EE2u)

/** \brief 3EE4, Read Data and Bit Flip Register 66 */
#define MTU_MC62_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064EE4u)

/** \brief 3EEE, Alarm Sources Configuration Register */
#define MTU_MC62_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0064EEEu)

/** \brief 3EF0, SSH Safety Faults Status Register  */
#define MTU_MC62_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0064EF0u)

/** \brief 3EF2, Error Information Register 0 */
#define MTU_MC62_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064EF2u)

/** \brief 3EF4, Error Information Register 1 */
#define MTU_MC62_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064EF4u)

/** \brief 3EF6, Error Information Register 2 */
#define MTU_MC62_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064EF6u)

/** \brief 3EF8, Error Information Register 3 */
#define MTU_MC62_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064EF8u)

/** \brief 3EFA, Error Information Register 4 */
#define MTU_MC62_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064EFAu)

/** \brief 3F00, Configuration Registers */
#define MTU_MC63_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0064F00u)

/** \brief 3F02, Configuration Register 1 */
#define MTU_MC63_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0064F02u)

/** \brief 3F04, MBIST Control Register */
#define MTU_MC63_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0064F04u)

/** \brief 3F06, Status Register */
#define MTU_MC63_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0064F06u)

/** \brief 3F08, Range Register, single address mode */
#define MTU_MC63_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0064F08u)

/** \brief 3F0C, Revision ID Register */
#define MTU_MC63_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0064F0Cu)

/** \brief 3F0E, ECC Safety Register */
#define MTU_MC63_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0064F0Eu)

/** \brief 3F10, Memory ECC Detection Register */
#define MTU_MC63_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0064F10u)

/** \brief 3F12, Error Tracking Register 0 */
#define MTU_MC63_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064F12u)

/** \brief 3F14, Error Tracking Register 1 */
#define MTU_MC63_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064F14u)

/** \brief 3F16, Error Tracking Register 2 */
#define MTU_MC63_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064F16u)

/** \brief 3F18, Error Tracking Register 3 */
#define MTU_MC63_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064F18u)

/** \brief 3F1A, Error Tracking Register 4 */
#define MTU_MC63_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0064F1Au)

/** \brief 3F60, Read Data and Bit Flip Register 0 */
#define MTU_MC63_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F60u)

/** \brief 3F62, Read Data and Bit Flip Register 1 */
#define MTU_MC63_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F62u)

/** \brief 3F64, Read Data and Bit Flip Register 2 */
#define MTU_MC63_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F64u)

/** \brief 3F66, Read Data and Bit Flip Register 3 */
#define MTU_MC63_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F66u)

/** \brief 3F68, Read Data and Bit Flip Register 4 */
#define MTU_MC63_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F68u)

/** \brief 3F6A, Read Data and Bit Flip Register 5 */
#define MTU_MC63_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F6Au)

/** \brief 3F6C, Read Data and Bit Flip Register 6 */
#define MTU_MC63_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F6Cu)

/** \brief 3F6E, Read Data and Bit Flip Register 7 */
#define MTU_MC63_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F6Eu)

/** \brief 3F70, Read Data and Bit Flip Register 8 */
#define MTU_MC63_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F70u)

/** \brief 3F72, Read Data and Bit Flip Register 9 */
#define MTU_MC63_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F72u)

/** \brief 3F74, Read Data and Bit Flip Register 10 */
#define MTU_MC63_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F74u)

/** \brief 3F76, Read Data and Bit Flip Register 11 */
#define MTU_MC63_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F76u)

/** \brief 3F78, Read Data and Bit Flip Register 12 */
#define MTU_MC63_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F78u)

/** \brief 3F7A, Read Data and Bit Flip Register 13 */
#define MTU_MC63_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F7Au)

/** \brief 3F7C, Read Data and Bit Flip Register 14 */
#define MTU_MC63_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F7Cu)

/** \brief 3F7E, Read Data and Bit Flip Register 15 */
#define MTU_MC63_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F7Eu)

/** \brief 3F80, Read Data and Bit Flip Register 16 */
#define MTU_MC63_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F80u)

/** \brief 3F82, Read Data and Bit Flip Register 17 */
#define MTU_MC63_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F82u)

/** \brief 3F84, Read Data and Bit Flip Register 18 */
#define MTU_MC63_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F84u)

/** \brief 3F86, Read Data and Bit Flip Register 19 */
#define MTU_MC63_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F86u)

/** \brief 3F88, Read Data and Bit Flip Register 20 */
#define MTU_MC63_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F88u)

/** \brief 3F8A, Read Data and Bit Flip Register 21 */
#define MTU_MC63_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F8Au)

/** \brief 3F8C, Read Data and Bit Flip Register 22 */
#define MTU_MC63_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F8Cu)

/** \brief 3F8E, Read Data and Bit Flip Register 23 */
#define MTU_MC63_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F8Eu)

/** \brief 3F90, Read Data and Bit Flip Register 24 */
#define MTU_MC63_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F90u)

/** \brief 3F92, Read Data and Bit Flip Register 25 */
#define MTU_MC63_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F92u)

/** \brief 3F94, Read Data and Bit Flip Register 26 */
#define MTU_MC63_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F94u)

/** \brief 3F96, Read Data and Bit Flip Register 27 */
#define MTU_MC63_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F96u)

/** \brief 3F98, Read Data and Bit Flip Register 28 */
#define MTU_MC63_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F98u)

/** \brief 3F9A, Read Data and Bit Flip Register 29 */
#define MTU_MC63_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F9Au)

/** \brief 3F9C, Read Data and Bit Flip Register 30 */
#define MTU_MC63_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F9Cu)

/** \brief 3F9E, Read Data and Bit Flip Register 31 */
#define MTU_MC63_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064F9Eu)

/** \brief 3FA0, Read Data and Bit Flip Register 32 */
#define MTU_MC63_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FA0u)

/** \brief 3FA2, Read Data and Bit Flip Register 33 */
#define MTU_MC63_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FA2u)

/** \brief 3FA4, Read Data and Bit Flip Register 34 */
#define MTU_MC63_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FA4u)

/** \brief 3FA6, Read Data and Bit Flip Register 35 */
#define MTU_MC63_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FA6u)

/** \brief 3FA8, Read Data and Bit Flip Register 36 */
#define MTU_MC63_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FA8u)

/** \brief 3FAA, Read Data and Bit Flip Register 37 */
#define MTU_MC63_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FAAu)

/** \brief 3FAC, Read Data and Bit Flip Register 38 */
#define MTU_MC63_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FACu)

/** \brief 3FAE, Read Data and Bit Flip Register 39 */
#define MTU_MC63_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FAEu)

/** \brief 3FB0, Read Data and Bit Flip Register 40 */
#define MTU_MC63_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FB0u)

/** \brief 3FB2, Read Data and Bit Flip Register 41 */
#define MTU_MC63_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FB2u)

/** \brief 3FB4, Read Data and Bit Flip Register 42 */
#define MTU_MC63_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FB4u)

/** \brief 3FB6, Read Data and Bit Flip Register 43 */
#define MTU_MC63_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FB6u)

/** \brief 3FB8, Read Data and Bit Flip Register 44 */
#define MTU_MC63_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FB8u)

/** \brief 3FBA, Read Data and Bit Flip Register 45 */
#define MTU_MC63_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FBAu)

/** \brief 3FBC, Read Data and Bit Flip Register 46 */
#define MTU_MC63_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FBCu)

/** \brief 3FBE, Read Data and Bit Flip Register 47 */
#define MTU_MC63_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FBEu)

/** \brief 3FC0, Read Data and Bit Flip Register 48 */
#define MTU_MC63_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FC0u)

/** \brief 3FC2, Read Data and Bit Flip Register 49 */
#define MTU_MC63_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FC2u)

/** \brief 3FC4, Read Data and Bit Flip Register 50 */
#define MTU_MC63_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FC4u)

/** \brief 3FC6, Read Data and Bit Flip Register 51 */
#define MTU_MC63_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FC6u)

/** \brief 3FC8, Read Data and Bit Flip Register 52 */
#define MTU_MC63_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FC8u)

/** \brief 3FCA, Read Data and Bit Flip Register 53 */
#define MTU_MC63_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FCAu)

/** \brief 3FCC, Read Data and Bit Flip Register 54 */
#define MTU_MC63_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FCCu)

/** \brief 3FCE, Read Data and Bit Flip Register 55 */
#define MTU_MC63_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FCEu)

/** \brief 3FD0, Read Data and Bit Flip Register 56 */
#define MTU_MC63_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FD0u)

/** \brief 3FD2, Read Data and Bit Flip Register 57 */
#define MTU_MC63_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FD2u)

/** \brief 3FD4, Read Data and Bit Flip Register 58 */
#define MTU_MC63_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FD4u)

/** \brief 3FD6, Read Data and Bit Flip Register 59 */
#define MTU_MC63_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FD6u)

/** \brief 3FD8, Read Data and Bit Flip Register 60 */
#define MTU_MC63_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FD8u)

/** \brief 3FDA, Read Data and Bit Flip Register 61 */
#define MTU_MC63_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FDAu)

/** \brief 3FDC, Read Data and Bit Flip Register 62 */
#define MTU_MC63_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FDCu)

/** \brief 3FDE, Read Data and Bit Flip Register 63 */
#define MTU_MC63_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FDEu)

/** \brief 3FE0, Read Data and Bit Flip Register 64 */
#define MTU_MC63_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FE0u)

/** \brief 3FE2, Read Data and Bit Flip Register 65 */
#define MTU_MC63_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FE2u)

/** \brief 3FE4, Read Data and Bit Flip Register 66 */
#define MTU_MC63_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0064FE4u)

/** \brief 3FEE, Alarm Sources Configuration Register */
#define MTU_MC63_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0064FEEu)

/** \brief 3FF0, SSH Safety Faults Status Register  */
#define MTU_MC63_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0064FF0u)

/** \brief 3FF2, Error Information Register 0 */
#define MTU_MC63_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064FF2u)

/** \brief 3FF4, Error Information Register 1 */
#define MTU_MC63_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064FF4u)

/** \brief 3FF6, Error Information Register 2 */
#define MTU_MC63_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064FF6u)

/** \brief 3FF8, Error Information Register 3 */
#define MTU_MC63_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064FF8u)

/** \brief 3FFA, Error Information Register 4 */
#define MTU_MC63_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0064FFAu)

/** \brief 4000, Configuration Registers */
#define MTU_MC64_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065000u)

/** \brief 4002, Configuration Register 1 */
#define MTU_MC64_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065002u)

/** \brief 4004, MBIST Control Register */
#define MTU_MC64_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065004u)

/** \brief 4006, Status Register */
#define MTU_MC64_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065006u)

/** \brief 4008, Range Register, single address mode */
#define MTU_MC64_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065008u)

/** \brief 400C, Revision ID Register */
#define MTU_MC64_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006500Cu)

/** \brief 400E, ECC Safety Register */
#define MTU_MC64_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006500Eu)

/** \brief 4010, Memory ECC Detection Register */
#define MTU_MC64_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065010u)

/** \brief 4012, Error Tracking Register 0 */
#define MTU_MC64_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065012u)

/** \brief 4014, Error Tracking Register 1 */
#define MTU_MC64_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065014u)

/** \brief 4016, Error Tracking Register 2 */
#define MTU_MC64_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065016u)

/** \brief 4018, Error Tracking Register 3 */
#define MTU_MC64_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065018u)

/** \brief 401A, Error Tracking Register 4 */
#define MTU_MC64_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006501Au)

/** \brief 4060, Read Data and Bit Flip Register 0 */
#define MTU_MC64_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065060u)

/** \brief 4062, Read Data and Bit Flip Register 1 */
#define MTU_MC64_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065062u)

/** \brief 4064, Read Data and Bit Flip Register 2 */
#define MTU_MC64_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065064u)

/** \brief 4066, Read Data and Bit Flip Register 3 */
#define MTU_MC64_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065066u)

/** \brief 4068, Read Data and Bit Flip Register 4 */
#define MTU_MC64_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065068u)

/** \brief 406A, Read Data and Bit Flip Register 5 */
#define MTU_MC64_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006506Au)

/** \brief 406C, Read Data and Bit Flip Register 6 */
#define MTU_MC64_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006506Cu)

/** \brief 406E, Read Data and Bit Flip Register 7 */
#define MTU_MC64_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006506Eu)

/** \brief 4070, Read Data and Bit Flip Register 8 */
#define MTU_MC64_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065070u)

/** \brief 4072, Read Data and Bit Flip Register 9 */
#define MTU_MC64_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065072u)

/** \brief 4074, Read Data and Bit Flip Register 10 */
#define MTU_MC64_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065074u)

/** \brief 4076, Read Data and Bit Flip Register 11 */
#define MTU_MC64_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065076u)

/** \brief 4078, Read Data and Bit Flip Register 12 */
#define MTU_MC64_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065078u)

/** \brief 407A, Read Data and Bit Flip Register 13 */
#define MTU_MC64_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006507Au)

/** \brief 407C, Read Data and Bit Flip Register 14 */
#define MTU_MC64_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006507Cu)

/** \brief 407E, Read Data and Bit Flip Register 15 */
#define MTU_MC64_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006507Eu)

/** \brief 4080, Read Data and Bit Flip Register 16 */
#define MTU_MC64_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065080u)

/** \brief 4082, Read Data and Bit Flip Register 17 */
#define MTU_MC64_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065082u)

/** \brief 4084, Read Data and Bit Flip Register 18 */
#define MTU_MC64_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065084u)

/** \brief 4086, Read Data and Bit Flip Register 19 */
#define MTU_MC64_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065086u)

/** \brief 4088, Read Data and Bit Flip Register 20 */
#define MTU_MC64_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065088u)

/** \brief 408A, Read Data and Bit Flip Register 21 */
#define MTU_MC64_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006508Au)

/** \brief 408C, Read Data and Bit Flip Register 22 */
#define MTU_MC64_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006508Cu)

/** \brief 408E, Read Data and Bit Flip Register 23 */
#define MTU_MC64_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006508Eu)

/** \brief 4090, Read Data and Bit Flip Register 24 */
#define MTU_MC64_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065090u)

/** \brief 4092, Read Data and Bit Flip Register 25 */
#define MTU_MC64_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065092u)

/** \brief 4094, Read Data and Bit Flip Register 26 */
#define MTU_MC64_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065094u)

/** \brief 4096, Read Data and Bit Flip Register 27 */
#define MTU_MC64_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065096u)

/** \brief 4098, Read Data and Bit Flip Register 28 */
#define MTU_MC64_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065098u)

/** \brief 409A, Read Data and Bit Flip Register 29 */
#define MTU_MC64_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006509Au)

/** \brief 409C, Read Data and Bit Flip Register 30 */
#define MTU_MC64_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006509Cu)

/** \brief 409E, Read Data and Bit Flip Register 31 */
#define MTU_MC64_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006509Eu)

/** \brief 40A0, Read Data and Bit Flip Register 32 */
#define MTU_MC64_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650A0u)

/** \brief 40A2, Read Data and Bit Flip Register 33 */
#define MTU_MC64_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650A2u)

/** \brief 40A4, Read Data and Bit Flip Register 34 */
#define MTU_MC64_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650A4u)

/** \brief 40A6, Read Data and Bit Flip Register 35 */
#define MTU_MC64_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650A6u)

/** \brief 40A8, Read Data and Bit Flip Register 36 */
#define MTU_MC64_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650A8u)

/** \brief 40AA, Read Data and Bit Flip Register 37 */
#define MTU_MC64_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650AAu)

/** \brief 40AC, Read Data and Bit Flip Register 38 */
#define MTU_MC64_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650ACu)

/** \brief 40AE, Read Data and Bit Flip Register 39 */
#define MTU_MC64_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650AEu)

/** \brief 40B0, Read Data and Bit Flip Register 40 */
#define MTU_MC64_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650B0u)

/** \brief 40B2, Read Data and Bit Flip Register 41 */
#define MTU_MC64_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650B2u)

/** \brief 40B4, Read Data and Bit Flip Register 42 */
#define MTU_MC64_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650B4u)

/** \brief 40B6, Read Data and Bit Flip Register 43 */
#define MTU_MC64_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650B6u)

/** \brief 40B8, Read Data and Bit Flip Register 44 */
#define MTU_MC64_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650B8u)

/** \brief 40BA, Read Data and Bit Flip Register 45 */
#define MTU_MC64_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650BAu)

/** \brief 40BC, Read Data and Bit Flip Register 46 */
#define MTU_MC64_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650BCu)

/** \brief 40BE, Read Data and Bit Flip Register 47 */
#define MTU_MC64_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650BEu)

/** \brief 40C0, Read Data and Bit Flip Register 48 */
#define MTU_MC64_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650C0u)

/** \brief 40C2, Read Data and Bit Flip Register 49 */
#define MTU_MC64_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650C2u)

/** \brief 40C4, Read Data and Bit Flip Register 50 */
#define MTU_MC64_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650C4u)

/** \brief 40C6, Read Data and Bit Flip Register 51 */
#define MTU_MC64_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650C6u)

/** \brief 40C8, Read Data and Bit Flip Register 52 */
#define MTU_MC64_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650C8u)

/** \brief 40CA, Read Data and Bit Flip Register 53 */
#define MTU_MC64_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650CAu)

/** \brief 40CC, Read Data and Bit Flip Register 54 */
#define MTU_MC64_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650CCu)

/** \brief 40CE, Read Data and Bit Flip Register 55 */
#define MTU_MC64_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650CEu)

/** \brief 40D0, Read Data and Bit Flip Register 56 */
#define MTU_MC64_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650D0u)

/** \brief 40D2, Read Data and Bit Flip Register 57 */
#define MTU_MC64_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650D2u)

/** \brief 40D4, Read Data and Bit Flip Register 58 */
#define MTU_MC64_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650D4u)

/** \brief 40D6, Read Data and Bit Flip Register 59 */
#define MTU_MC64_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650D6u)

/** \brief 40D8, Read Data and Bit Flip Register 60 */
#define MTU_MC64_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650D8u)

/** \brief 40DA, Read Data and Bit Flip Register 61 */
#define MTU_MC64_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650DAu)

/** \brief 40DC, Read Data and Bit Flip Register 62 */
#define MTU_MC64_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650DCu)

/** \brief 40DE, Read Data and Bit Flip Register 63 */
#define MTU_MC64_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650DEu)

/** \brief 40E0, Read Data and Bit Flip Register 64 */
#define MTU_MC64_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650E0u)

/** \brief 40E2, Read Data and Bit Flip Register 65 */
#define MTU_MC64_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650E2u)

/** \brief 40E4, Read Data and Bit Flip Register 66 */
#define MTU_MC64_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00650E4u)

/** \brief 40EE, Alarm Sources Configuration Register */
#define MTU_MC64_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00650EEu)

/** \brief 40F0, SSH Safety Faults Status Register  */
#define MTU_MC64_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00650F0u)

/** \brief 40F2, Error Information Register 0 */
#define MTU_MC64_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00650F2u)

/** \brief 40F4, Error Information Register 1 */
#define MTU_MC64_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00650F4u)

/** \brief 40F6, Error Information Register 2 */
#define MTU_MC64_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00650F6u)

/** \brief 40F8, Error Information Register 3 */
#define MTU_MC64_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00650F8u)

/** \brief 40FA, Error Information Register 4 */
#define MTU_MC64_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00650FAu)

/** \brief 4100, Configuration Registers */
#define MTU_MC65_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065100u)

/** \brief 4102, Configuration Register 1 */
#define MTU_MC65_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065102u)

/** \brief 4104, MBIST Control Register */
#define MTU_MC65_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065104u)

/** \brief 4106, Status Register */
#define MTU_MC65_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065106u)

/** \brief 4108, Range Register, single address mode */
#define MTU_MC65_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065108u)

/** \brief 410C, Revision ID Register */
#define MTU_MC65_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006510Cu)

/** \brief 410E, ECC Safety Register */
#define MTU_MC65_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006510Eu)

/** \brief 4110, Memory ECC Detection Register */
#define MTU_MC65_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065110u)

/** \brief 4112, Error Tracking Register 0 */
#define MTU_MC65_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065112u)

/** \brief 4114, Error Tracking Register 1 */
#define MTU_MC65_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065114u)

/** \brief 4116, Error Tracking Register 2 */
#define MTU_MC65_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065116u)

/** \brief 4118, Error Tracking Register 3 */
#define MTU_MC65_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065118u)

/** \brief 411A, Error Tracking Register 4 */
#define MTU_MC65_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006511Au)

/** \brief 4160, Read Data and Bit Flip Register 0 */
#define MTU_MC65_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065160u)

/** \brief 4162, Read Data and Bit Flip Register 1 */
#define MTU_MC65_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065162u)

/** \brief 4164, Read Data and Bit Flip Register 2 */
#define MTU_MC65_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065164u)

/** \brief 4166, Read Data and Bit Flip Register 3 */
#define MTU_MC65_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065166u)

/** \brief 4168, Read Data and Bit Flip Register 4 */
#define MTU_MC65_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065168u)

/** \brief 416A, Read Data and Bit Flip Register 5 */
#define MTU_MC65_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006516Au)

/** \brief 416C, Read Data and Bit Flip Register 6 */
#define MTU_MC65_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006516Cu)

/** \brief 416E, Read Data and Bit Flip Register 7 */
#define MTU_MC65_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006516Eu)

/** \brief 4170, Read Data and Bit Flip Register 8 */
#define MTU_MC65_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065170u)

/** \brief 4172, Read Data and Bit Flip Register 9 */
#define MTU_MC65_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065172u)

/** \brief 4174, Read Data and Bit Flip Register 10 */
#define MTU_MC65_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065174u)

/** \brief 4176, Read Data and Bit Flip Register 11 */
#define MTU_MC65_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065176u)

/** \brief 4178, Read Data and Bit Flip Register 12 */
#define MTU_MC65_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065178u)

/** \brief 417A, Read Data and Bit Flip Register 13 */
#define MTU_MC65_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006517Au)

/** \brief 417C, Read Data and Bit Flip Register 14 */
#define MTU_MC65_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006517Cu)

/** \brief 417E, Read Data and Bit Flip Register 15 */
#define MTU_MC65_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006517Eu)

/** \brief 4180, Read Data and Bit Flip Register 16 */
#define MTU_MC65_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065180u)

/** \brief 4182, Read Data and Bit Flip Register 17 */
#define MTU_MC65_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065182u)

/** \brief 4184, Read Data and Bit Flip Register 18 */
#define MTU_MC65_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065184u)

/** \brief 4186, Read Data and Bit Flip Register 19 */
#define MTU_MC65_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065186u)

/** \brief 4188, Read Data and Bit Flip Register 20 */
#define MTU_MC65_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065188u)

/** \brief 418A, Read Data and Bit Flip Register 21 */
#define MTU_MC65_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006518Au)

/** \brief 418C, Read Data and Bit Flip Register 22 */
#define MTU_MC65_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006518Cu)

/** \brief 418E, Read Data and Bit Flip Register 23 */
#define MTU_MC65_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006518Eu)

/** \brief 4190, Read Data and Bit Flip Register 24 */
#define MTU_MC65_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065190u)

/** \brief 4192, Read Data and Bit Flip Register 25 */
#define MTU_MC65_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065192u)

/** \brief 4194, Read Data and Bit Flip Register 26 */
#define MTU_MC65_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065194u)

/** \brief 4196, Read Data and Bit Flip Register 27 */
#define MTU_MC65_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065196u)

/** \brief 4198, Read Data and Bit Flip Register 28 */
#define MTU_MC65_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065198u)

/** \brief 419A, Read Data and Bit Flip Register 29 */
#define MTU_MC65_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006519Au)

/** \brief 419C, Read Data and Bit Flip Register 30 */
#define MTU_MC65_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006519Cu)

/** \brief 419E, Read Data and Bit Flip Register 31 */
#define MTU_MC65_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006519Eu)

/** \brief 41A0, Read Data and Bit Flip Register 32 */
#define MTU_MC65_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651A0u)

/** \brief 41A2, Read Data and Bit Flip Register 33 */
#define MTU_MC65_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651A2u)

/** \brief 41A4, Read Data and Bit Flip Register 34 */
#define MTU_MC65_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651A4u)

/** \brief 41A6, Read Data and Bit Flip Register 35 */
#define MTU_MC65_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651A6u)

/** \brief 41A8, Read Data and Bit Flip Register 36 */
#define MTU_MC65_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651A8u)

/** \brief 41AA, Read Data and Bit Flip Register 37 */
#define MTU_MC65_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651AAu)

/** \brief 41AC, Read Data and Bit Flip Register 38 */
#define MTU_MC65_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651ACu)

/** \brief 41AE, Read Data and Bit Flip Register 39 */
#define MTU_MC65_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651AEu)

/** \brief 41B0, Read Data and Bit Flip Register 40 */
#define MTU_MC65_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651B0u)

/** \brief 41B2, Read Data and Bit Flip Register 41 */
#define MTU_MC65_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651B2u)

/** \brief 41B4, Read Data and Bit Flip Register 42 */
#define MTU_MC65_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651B4u)

/** \brief 41B6, Read Data and Bit Flip Register 43 */
#define MTU_MC65_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651B6u)

/** \brief 41B8, Read Data and Bit Flip Register 44 */
#define MTU_MC65_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651B8u)

/** \brief 41BA, Read Data and Bit Flip Register 45 */
#define MTU_MC65_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651BAu)

/** \brief 41BC, Read Data and Bit Flip Register 46 */
#define MTU_MC65_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651BCu)

/** \brief 41BE, Read Data and Bit Flip Register 47 */
#define MTU_MC65_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651BEu)

/** \brief 41C0, Read Data and Bit Flip Register 48 */
#define MTU_MC65_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651C0u)

/** \brief 41C2, Read Data and Bit Flip Register 49 */
#define MTU_MC65_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651C2u)

/** \brief 41C4, Read Data and Bit Flip Register 50 */
#define MTU_MC65_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651C4u)

/** \brief 41C6, Read Data and Bit Flip Register 51 */
#define MTU_MC65_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651C6u)

/** \brief 41C8, Read Data and Bit Flip Register 52 */
#define MTU_MC65_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651C8u)

/** \brief 41CA, Read Data and Bit Flip Register 53 */
#define MTU_MC65_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651CAu)

/** \brief 41CC, Read Data and Bit Flip Register 54 */
#define MTU_MC65_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651CCu)

/** \brief 41CE, Read Data and Bit Flip Register 55 */
#define MTU_MC65_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651CEu)

/** \brief 41D0, Read Data and Bit Flip Register 56 */
#define MTU_MC65_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651D0u)

/** \brief 41D2, Read Data and Bit Flip Register 57 */
#define MTU_MC65_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651D2u)

/** \brief 41D4, Read Data and Bit Flip Register 58 */
#define MTU_MC65_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651D4u)

/** \brief 41D6, Read Data and Bit Flip Register 59 */
#define MTU_MC65_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651D6u)

/** \brief 41D8, Read Data and Bit Flip Register 60 */
#define MTU_MC65_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651D8u)

/** \brief 41DA, Read Data and Bit Flip Register 61 */
#define MTU_MC65_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651DAu)

/** \brief 41DC, Read Data and Bit Flip Register 62 */
#define MTU_MC65_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651DCu)

/** \brief 41DE, Read Data and Bit Flip Register 63 */
#define MTU_MC65_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651DEu)

/** \brief 41E0, Read Data and Bit Flip Register 64 */
#define MTU_MC65_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651E0u)

/** \brief 41E2, Read Data and Bit Flip Register 65 */
#define MTU_MC65_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651E2u)

/** \brief 41E4, Read Data and Bit Flip Register 66 */
#define MTU_MC65_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00651E4u)

/** \brief 41EE, Alarm Sources Configuration Register */
#define MTU_MC65_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00651EEu)

/** \brief 41F0, SSH Safety Faults Status Register  */
#define MTU_MC65_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00651F0u)

/** \brief 41F2, Error Information Register 0 */
#define MTU_MC65_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00651F2u)

/** \brief 41F4, Error Information Register 1 */
#define MTU_MC65_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00651F4u)

/** \brief 41F6, Error Information Register 2 */
#define MTU_MC65_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00651F6u)

/** \brief 41F8, Error Information Register 3 */
#define MTU_MC65_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00651F8u)

/** \brief 41FA, Error Information Register 4 */
#define MTU_MC65_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00651FAu)

/** \brief 4200, Configuration Registers */
#define MTU_MC66_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065200u)

/** \brief 4202, Configuration Register 1 */
#define MTU_MC66_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065202u)

/** \brief 4204, MBIST Control Register */
#define MTU_MC66_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065204u)

/** \brief 4206, Status Register */
#define MTU_MC66_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065206u)

/** \brief 4208, Range Register, single address mode */
#define MTU_MC66_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065208u)

/** \brief 420C, Revision ID Register */
#define MTU_MC66_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006520Cu)

/** \brief 420E, ECC Safety Register */
#define MTU_MC66_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006520Eu)

/** \brief 4210, Memory ECC Detection Register */
#define MTU_MC66_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065210u)

/** \brief 4212, Error Tracking Register 0 */
#define MTU_MC66_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065212u)

/** \brief 4214, Error Tracking Register 1 */
#define MTU_MC66_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065214u)

/** \brief 4216, Error Tracking Register 2 */
#define MTU_MC66_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065216u)

/** \brief 4218, Error Tracking Register 3 */
#define MTU_MC66_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065218u)

/** \brief 421A, Error Tracking Register 4 */
#define MTU_MC66_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006521Au)

/** \brief 4260, Read Data and Bit Flip Register 0 */
#define MTU_MC66_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065260u)

/** \brief 4262, Read Data and Bit Flip Register 1 */
#define MTU_MC66_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065262u)

/** \brief 4264, Read Data and Bit Flip Register 2 */
#define MTU_MC66_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065264u)

/** \brief 4266, Read Data and Bit Flip Register 3 */
#define MTU_MC66_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065266u)

/** \brief 4268, Read Data and Bit Flip Register 4 */
#define MTU_MC66_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065268u)

/** \brief 426A, Read Data and Bit Flip Register 5 */
#define MTU_MC66_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006526Au)

/** \brief 426C, Read Data and Bit Flip Register 6 */
#define MTU_MC66_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006526Cu)

/** \brief 426E, Read Data and Bit Flip Register 7 */
#define MTU_MC66_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006526Eu)

/** \brief 4270, Read Data and Bit Flip Register 8 */
#define MTU_MC66_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065270u)

/** \brief 4272, Read Data and Bit Flip Register 9 */
#define MTU_MC66_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065272u)

/** \brief 4274, Read Data and Bit Flip Register 10 */
#define MTU_MC66_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065274u)

/** \brief 4276, Read Data and Bit Flip Register 11 */
#define MTU_MC66_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065276u)

/** \brief 4278, Read Data and Bit Flip Register 12 */
#define MTU_MC66_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065278u)

/** \brief 427A, Read Data and Bit Flip Register 13 */
#define MTU_MC66_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006527Au)

/** \brief 427C, Read Data and Bit Flip Register 14 */
#define MTU_MC66_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006527Cu)

/** \brief 427E, Read Data and Bit Flip Register 15 */
#define MTU_MC66_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006527Eu)

/** \brief 4280, Read Data and Bit Flip Register 16 */
#define MTU_MC66_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065280u)

/** \brief 4282, Read Data and Bit Flip Register 17 */
#define MTU_MC66_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065282u)

/** \brief 4284, Read Data and Bit Flip Register 18 */
#define MTU_MC66_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065284u)

/** \brief 4286, Read Data and Bit Flip Register 19 */
#define MTU_MC66_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065286u)

/** \brief 4288, Read Data and Bit Flip Register 20 */
#define MTU_MC66_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065288u)

/** \brief 428A, Read Data and Bit Flip Register 21 */
#define MTU_MC66_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006528Au)

/** \brief 428C, Read Data and Bit Flip Register 22 */
#define MTU_MC66_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006528Cu)

/** \brief 428E, Read Data and Bit Flip Register 23 */
#define MTU_MC66_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006528Eu)

/** \brief 4290, Read Data and Bit Flip Register 24 */
#define MTU_MC66_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065290u)

/** \brief 4292, Read Data and Bit Flip Register 25 */
#define MTU_MC66_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065292u)

/** \brief 4294, Read Data and Bit Flip Register 26 */
#define MTU_MC66_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065294u)

/** \brief 4296, Read Data and Bit Flip Register 27 */
#define MTU_MC66_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065296u)

/** \brief 4298, Read Data and Bit Flip Register 28 */
#define MTU_MC66_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065298u)

/** \brief 429A, Read Data and Bit Flip Register 29 */
#define MTU_MC66_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006529Au)

/** \brief 429C, Read Data and Bit Flip Register 30 */
#define MTU_MC66_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006529Cu)

/** \brief 429E, Read Data and Bit Flip Register 31 */
#define MTU_MC66_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006529Eu)

/** \brief 42A0, Read Data and Bit Flip Register 32 */
#define MTU_MC66_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652A0u)

/** \brief 42A2, Read Data and Bit Flip Register 33 */
#define MTU_MC66_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652A2u)

/** \brief 42A4, Read Data and Bit Flip Register 34 */
#define MTU_MC66_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652A4u)

/** \brief 42A6, Read Data and Bit Flip Register 35 */
#define MTU_MC66_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652A6u)

/** \brief 42A8, Read Data and Bit Flip Register 36 */
#define MTU_MC66_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652A8u)

/** \brief 42AA, Read Data and Bit Flip Register 37 */
#define MTU_MC66_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652AAu)

/** \brief 42AC, Read Data and Bit Flip Register 38 */
#define MTU_MC66_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652ACu)

/** \brief 42AE, Read Data and Bit Flip Register 39 */
#define MTU_MC66_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652AEu)

/** \brief 42B0, Read Data and Bit Flip Register 40 */
#define MTU_MC66_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652B0u)

/** \brief 42B2, Read Data and Bit Flip Register 41 */
#define MTU_MC66_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652B2u)

/** \brief 42B4, Read Data and Bit Flip Register 42 */
#define MTU_MC66_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652B4u)

/** \brief 42B6, Read Data and Bit Flip Register 43 */
#define MTU_MC66_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652B6u)

/** \brief 42B8, Read Data and Bit Flip Register 44 */
#define MTU_MC66_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652B8u)

/** \brief 42BA, Read Data and Bit Flip Register 45 */
#define MTU_MC66_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652BAu)

/** \brief 42BC, Read Data and Bit Flip Register 46 */
#define MTU_MC66_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652BCu)

/** \brief 42BE, Read Data and Bit Flip Register 47 */
#define MTU_MC66_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652BEu)

/** \brief 42C0, Read Data and Bit Flip Register 48 */
#define MTU_MC66_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652C0u)

/** \brief 42C2, Read Data and Bit Flip Register 49 */
#define MTU_MC66_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652C2u)

/** \brief 42C4, Read Data and Bit Flip Register 50 */
#define MTU_MC66_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652C4u)

/** \brief 42C6, Read Data and Bit Flip Register 51 */
#define MTU_MC66_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652C6u)

/** \brief 42C8, Read Data and Bit Flip Register 52 */
#define MTU_MC66_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652C8u)

/** \brief 42CA, Read Data and Bit Flip Register 53 */
#define MTU_MC66_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652CAu)

/** \brief 42CC, Read Data and Bit Flip Register 54 */
#define MTU_MC66_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652CCu)

/** \brief 42CE, Read Data and Bit Flip Register 55 */
#define MTU_MC66_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652CEu)

/** \brief 42D0, Read Data and Bit Flip Register 56 */
#define MTU_MC66_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652D0u)

/** \brief 42D2, Read Data and Bit Flip Register 57 */
#define MTU_MC66_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652D2u)

/** \brief 42D4, Read Data and Bit Flip Register 58 */
#define MTU_MC66_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652D4u)

/** \brief 42D6, Read Data and Bit Flip Register 59 */
#define MTU_MC66_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652D6u)

/** \brief 42D8, Read Data and Bit Flip Register 60 */
#define MTU_MC66_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652D8u)

/** \brief 42DA, Read Data and Bit Flip Register 61 */
#define MTU_MC66_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652DAu)

/** \brief 42DC, Read Data and Bit Flip Register 62 */
#define MTU_MC66_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652DCu)

/** \brief 42DE, Read Data and Bit Flip Register 63 */
#define MTU_MC66_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652DEu)

/** \brief 42E0, Read Data and Bit Flip Register 64 */
#define MTU_MC66_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652E0u)

/** \brief 42E2, Read Data and Bit Flip Register 65 */
#define MTU_MC66_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652E2u)

/** \brief 42E4, Read Data and Bit Flip Register 66 */
#define MTU_MC66_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00652E4u)

/** \brief 42EE, Alarm Sources Configuration Register */
#define MTU_MC66_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00652EEu)

/** \brief 42F0, SSH Safety Faults Status Register  */
#define MTU_MC66_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00652F0u)

/** \brief 42F2, Error Information Register 0 */
#define MTU_MC66_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00652F2u)

/** \brief 42F4, Error Information Register 1 */
#define MTU_MC66_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00652F4u)

/** \brief 42F6, Error Information Register 2 */
#define MTU_MC66_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00652F6u)

/** \brief 42F8, Error Information Register 3 */
#define MTU_MC66_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00652F8u)

/** \brief 42FA, Error Information Register 4 */
#define MTU_MC66_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00652FAu)

/** \brief 4300, Configuration Registers */
#define MTU_MC67_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065300u)

/** \brief 4302, Configuration Register 1 */
#define MTU_MC67_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065302u)

/** \brief 4304, MBIST Control Register */
#define MTU_MC67_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065304u)

/** \brief 4306, Status Register */
#define MTU_MC67_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065306u)

/** \brief 4308, Range Register, single address mode */
#define MTU_MC67_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065308u)

/** \brief 430C, Revision ID Register */
#define MTU_MC67_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006530Cu)

/** \brief 430E, ECC Safety Register */
#define MTU_MC67_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006530Eu)

/** \brief 4310, Memory ECC Detection Register */
#define MTU_MC67_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065310u)

/** \brief 4312, Error Tracking Register 0 */
#define MTU_MC67_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065312u)

/** \brief 4314, Error Tracking Register 1 */
#define MTU_MC67_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065314u)

/** \brief 4316, Error Tracking Register 2 */
#define MTU_MC67_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065316u)

/** \brief 4318, Error Tracking Register 3 */
#define MTU_MC67_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065318u)

/** \brief 431A, Error Tracking Register 4 */
#define MTU_MC67_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006531Au)

/** \brief 4360, Read Data and Bit Flip Register 0 */
#define MTU_MC67_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065360u)

/** \brief 4362, Read Data and Bit Flip Register 1 */
#define MTU_MC67_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065362u)

/** \brief 4364, Read Data and Bit Flip Register 2 */
#define MTU_MC67_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065364u)

/** \brief 4366, Read Data and Bit Flip Register 3 */
#define MTU_MC67_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065366u)

/** \brief 4368, Read Data and Bit Flip Register 4 */
#define MTU_MC67_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065368u)

/** \brief 436A, Read Data and Bit Flip Register 5 */
#define MTU_MC67_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006536Au)

/** \brief 436C, Read Data and Bit Flip Register 6 */
#define MTU_MC67_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006536Cu)

/** \brief 436E, Read Data and Bit Flip Register 7 */
#define MTU_MC67_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006536Eu)

/** \brief 4370, Read Data and Bit Flip Register 8 */
#define MTU_MC67_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065370u)

/** \brief 4372, Read Data and Bit Flip Register 9 */
#define MTU_MC67_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065372u)

/** \brief 4374, Read Data and Bit Flip Register 10 */
#define MTU_MC67_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065374u)

/** \brief 4376, Read Data and Bit Flip Register 11 */
#define MTU_MC67_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065376u)

/** \brief 4378, Read Data and Bit Flip Register 12 */
#define MTU_MC67_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065378u)

/** \brief 437A, Read Data and Bit Flip Register 13 */
#define MTU_MC67_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006537Au)

/** \brief 437C, Read Data and Bit Flip Register 14 */
#define MTU_MC67_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006537Cu)

/** \brief 437E, Read Data and Bit Flip Register 15 */
#define MTU_MC67_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006537Eu)

/** \brief 4380, Read Data and Bit Flip Register 16 */
#define MTU_MC67_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065380u)

/** \brief 4382, Read Data and Bit Flip Register 17 */
#define MTU_MC67_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065382u)

/** \brief 4384, Read Data and Bit Flip Register 18 */
#define MTU_MC67_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065384u)

/** \brief 4386, Read Data and Bit Flip Register 19 */
#define MTU_MC67_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065386u)

/** \brief 4388, Read Data and Bit Flip Register 20 */
#define MTU_MC67_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065388u)

/** \brief 438A, Read Data and Bit Flip Register 21 */
#define MTU_MC67_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006538Au)

/** \brief 438C, Read Data and Bit Flip Register 22 */
#define MTU_MC67_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006538Cu)

/** \brief 438E, Read Data and Bit Flip Register 23 */
#define MTU_MC67_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006538Eu)

/** \brief 4390, Read Data and Bit Flip Register 24 */
#define MTU_MC67_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065390u)

/** \brief 4392, Read Data and Bit Flip Register 25 */
#define MTU_MC67_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065392u)

/** \brief 4394, Read Data and Bit Flip Register 26 */
#define MTU_MC67_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065394u)

/** \brief 4396, Read Data and Bit Flip Register 27 */
#define MTU_MC67_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065396u)

/** \brief 4398, Read Data and Bit Flip Register 28 */
#define MTU_MC67_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065398u)

/** \brief 439A, Read Data and Bit Flip Register 29 */
#define MTU_MC67_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006539Au)

/** \brief 439C, Read Data and Bit Flip Register 30 */
#define MTU_MC67_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006539Cu)

/** \brief 439E, Read Data and Bit Flip Register 31 */
#define MTU_MC67_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006539Eu)

/** \brief 43A0, Read Data and Bit Flip Register 32 */
#define MTU_MC67_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653A0u)

/** \brief 43A2, Read Data and Bit Flip Register 33 */
#define MTU_MC67_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653A2u)

/** \brief 43A4, Read Data and Bit Flip Register 34 */
#define MTU_MC67_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653A4u)

/** \brief 43A6, Read Data and Bit Flip Register 35 */
#define MTU_MC67_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653A6u)

/** \brief 43A8, Read Data and Bit Flip Register 36 */
#define MTU_MC67_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653A8u)

/** \brief 43AA, Read Data and Bit Flip Register 37 */
#define MTU_MC67_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653AAu)

/** \brief 43AC, Read Data and Bit Flip Register 38 */
#define MTU_MC67_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653ACu)

/** \brief 43AE, Read Data and Bit Flip Register 39 */
#define MTU_MC67_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653AEu)

/** \brief 43B0, Read Data and Bit Flip Register 40 */
#define MTU_MC67_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653B0u)

/** \brief 43B2, Read Data and Bit Flip Register 41 */
#define MTU_MC67_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653B2u)

/** \brief 43B4, Read Data and Bit Flip Register 42 */
#define MTU_MC67_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653B4u)

/** \brief 43B6, Read Data and Bit Flip Register 43 */
#define MTU_MC67_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653B6u)

/** \brief 43B8, Read Data and Bit Flip Register 44 */
#define MTU_MC67_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653B8u)

/** \brief 43BA, Read Data and Bit Flip Register 45 */
#define MTU_MC67_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653BAu)

/** \brief 43BC, Read Data and Bit Flip Register 46 */
#define MTU_MC67_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653BCu)

/** \brief 43BE, Read Data and Bit Flip Register 47 */
#define MTU_MC67_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653BEu)

/** \brief 43C0, Read Data and Bit Flip Register 48 */
#define MTU_MC67_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653C0u)

/** \brief 43C2, Read Data and Bit Flip Register 49 */
#define MTU_MC67_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653C2u)

/** \brief 43C4, Read Data and Bit Flip Register 50 */
#define MTU_MC67_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653C4u)

/** \brief 43C6, Read Data and Bit Flip Register 51 */
#define MTU_MC67_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653C6u)

/** \brief 43C8, Read Data and Bit Flip Register 52 */
#define MTU_MC67_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653C8u)

/** \brief 43CA, Read Data and Bit Flip Register 53 */
#define MTU_MC67_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653CAu)

/** \brief 43CC, Read Data and Bit Flip Register 54 */
#define MTU_MC67_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653CCu)

/** \brief 43CE, Read Data and Bit Flip Register 55 */
#define MTU_MC67_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653CEu)

/** \brief 43D0, Read Data and Bit Flip Register 56 */
#define MTU_MC67_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653D0u)

/** \brief 43D2, Read Data and Bit Flip Register 57 */
#define MTU_MC67_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653D2u)

/** \brief 43D4, Read Data and Bit Flip Register 58 */
#define MTU_MC67_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653D4u)

/** \brief 43D6, Read Data and Bit Flip Register 59 */
#define MTU_MC67_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653D6u)

/** \brief 43D8, Read Data and Bit Flip Register 60 */
#define MTU_MC67_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653D8u)

/** \brief 43DA, Read Data and Bit Flip Register 61 */
#define MTU_MC67_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653DAu)

/** \brief 43DC, Read Data and Bit Flip Register 62 */
#define MTU_MC67_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653DCu)

/** \brief 43DE, Read Data and Bit Flip Register 63 */
#define MTU_MC67_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653DEu)

/** \brief 43E0, Read Data and Bit Flip Register 64 */
#define MTU_MC67_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653E0u)

/** \brief 43E2, Read Data and Bit Flip Register 65 */
#define MTU_MC67_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653E2u)

/** \brief 43E4, Read Data and Bit Flip Register 66 */
#define MTU_MC67_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00653E4u)

/** \brief 43EE, Alarm Sources Configuration Register */
#define MTU_MC67_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00653EEu)

/** \brief 43F0, SSH Safety Faults Status Register  */
#define MTU_MC67_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00653F0u)

/** \brief 43F2, Error Information Register 0 */
#define MTU_MC67_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00653F2u)

/** \brief 43F4, Error Information Register 1 */
#define MTU_MC67_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00653F4u)

/** \brief 43F6, Error Information Register 2 */
#define MTU_MC67_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00653F6u)

/** \brief 43F8, Error Information Register 3 */
#define MTU_MC67_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00653F8u)

/** \brief 43FA, Error Information Register 4 */
#define MTU_MC67_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00653FAu)

/** \brief 4400, Configuration Registers */
#define MTU_MC68_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065400u)

/** \brief 4402, Configuration Register 1 */
#define MTU_MC68_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065402u)

/** \brief 4404, MBIST Control Register */
#define MTU_MC68_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065404u)

/** \brief 4406, Status Register */
#define MTU_MC68_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065406u)

/** \brief 4408, Range Register, single address mode */
#define MTU_MC68_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065408u)

/** \brief 440C, Revision ID Register */
#define MTU_MC68_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006540Cu)

/** \brief 440E, ECC Safety Register */
#define MTU_MC68_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006540Eu)

/** \brief 4410, Memory ECC Detection Register */
#define MTU_MC68_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065410u)

/** \brief 4412, Error Tracking Register 0 */
#define MTU_MC68_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065412u)

/** \brief 4414, Error Tracking Register 1 */
#define MTU_MC68_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065414u)

/** \brief 4416, Error Tracking Register 2 */
#define MTU_MC68_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065416u)

/** \brief 4418, Error Tracking Register 3 */
#define MTU_MC68_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065418u)

/** \brief 441A, Error Tracking Register 4 */
#define MTU_MC68_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006541Au)

/** \brief 4460, Read Data and Bit Flip Register 0 */
#define MTU_MC68_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065460u)

/** \brief 4462, Read Data and Bit Flip Register 1 */
#define MTU_MC68_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065462u)

/** \brief 4464, Read Data and Bit Flip Register 2 */
#define MTU_MC68_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065464u)

/** \brief 4466, Read Data and Bit Flip Register 3 */
#define MTU_MC68_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065466u)

/** \brief 4468, Read Data and Bit Flip Register 4 */
#define MTU_MC68_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065468u)

/** \brief 446A, Read Data and Bit Flip Register 5 */
#define MTU_MC68_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006546Au)

/** \brief 446C, Read Data and Bit Flip Register 6 */
#define MTU_MC68_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006546Cu)

/** \brief 446E, Read Data and Bit Flip Register 7 */
#define MTU_MC68_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006546Eu)

/** \brief 4470, Read Data and Bit Flip Register 8 */
#define MTU_MC68_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065470u)

/** \brief 4472, Read Data and Bit Flip Register 9 */
#define MTU_MC68_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065472u)

/** \brief 4474, Read Data and Bit Flip Register 10 */
#define MTU_MC68_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065474u)

/** \brief 4476, Read Data and Bit Flip Register 11 */
#define MTU_MC68_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065476u)

/** \brief 4478, Read Data and Bit Flip Register 12 */
#define MTU_MC68_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065478u)

/** \brief 447A, Read Data and Bit Flip Register 13 */
#define MTU_MC68_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006547Au)

/** \brief 447C, Read Data and Bit Flip Register 14 */
#define MTU_MC68_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006547Cu)

/** \brief 447E, Read Data and Bit Flip Register 15 */
#define MTU_MC68_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006547Eu)

/** \brief 4480, Read Data and Bit Flip Register 16 */
#define MTU_MC68_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065480u)

/** \brief 4482, Read Data and Bit Flip Register 17 */
#define MTU_MC68_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065482u)

/** \brief 4484, Read Data and Bit Flip Register 18 */
#define MTU_MC68_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065484u)

/** \brief 4486, Read Data and Bit Flip Register 19 */
#define MTU_MC68_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065486u)

/** \brief 4488, Read Data and Bit Flip Register 20 */
#define MTU_MC68_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065488u)

/** \brief 448A, Read Data and Bit Flip Register 21 */
#define MTU_MC68_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006548Au)

/** \brief 448C, Read Data and Bit Flip Register 22 */
#define MTU_MC68_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006548Cu)

/** \brief 448E, Read Data and Bit Flip Register 23 */
#define MTU_MC68_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006548Eu)

/** \brief 4490, Read Data and Bit Flip Register 24 */
#define MTU_MC68_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065490u)

/** \brief 4492, Read Data and Bit Flip Register 25 */
#define MTU_MC68_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065492u)

/** \brief 4494, Read Data and Bit Flip Register 26 */
#define MTU_MC68_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065494u)

/** \brief 4496, Read Data and Bit Flip Register 27 */
#define MTU_MC68_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065496u)

/** \brief 4498, Read Data and Bit Flip Register 28 */
#define MTU_MC68_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065498u)

/** \brief 449A, Read Data and Bit Flip Register 29 */
#define MTU_MC68_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006549Au)

/** \brief 449C, Read Data and Bit Flip Register 30 */
#define MTU_MC68_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006549Cu)

/** \brief 449E, Read Data and Bit Flip Register 31 */
#define MTU_MC68_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006549Eu)

/** \brief 44A0, Read Data and Bit Flip Register 32 */
#define MTU_MC68_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654A0u)

/** \brief 44A2, Read Data and Bit Flip Register 33 */
#define MTU_MC68_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654A2u)

/** \brief 44A4, Read Data and Bit Flip Register 34 */
#define MTU_MC68_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654A4u)

/** \brief 44A6, Read Data and Bit Flip Register 35 */
#define MTU_MC68_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654A6u)

/** \brief 44A8, Read Data and Bit Flip Register 36 */
#define MTU_MC68_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654A8u)

/** \brief 44AA, Read Data and Bit Flip Register 37 */
#define MTU_MC68_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654AAu)

/** \brief 44AC, Read Data and Bit Flip Register 38 */
#define MTU_MC68_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654ACu)

/** \brief 44AE, Read Data and Bit Flip Register 39 */
#define MTU_MC68_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654AEu)

/** \brief 44B0, Read Data and Bit Flip Register 40 */
#define MTU_MC68_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654B0u)

/** \brief 44B2, Read Data and Bit Flip Register 41 */
#define MTU_MC68_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654B2u)

/** \brief 44B4, Read Data and Bit Flip Register 42 */
#define MTU_MC68_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654B4u)

/** \brief 44B6, Read Data and Bit Flip Register 43 */
#define MTU_MC68_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654B6u)

/** \brief 44B8, Read Data and Bit Flip Register 44 */
#define MTU_MC68_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654B8u)

/** \brief 44BA, Read Data and Bit Flip Register 45 */
#define MTU_MC68_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654BAu)

/** \brief 44BC, Read Data and Bit Flip Register 46 */
#define MTU_MC68_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654BCu)

/** \brief 44BE, Read Data and Bit Flip Register 47 */
#define MTU_MC68_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654BEu)

/** \brief 44C0, Read Data and Bit Flip Register 48 */
#define MTU_MC68_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654C0u)

/** \brief 44C2, Read Data and Bit Flip Register 49 */
#define MTU_MC68_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654C2u)

/** \brief 44C4, Read Data and Bit Flip Register 50 */
#define MTU_MC68_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654C4u)

/** \brief 44C6, Read Data and Bit Flip Register 51 */
#define MTU_MC68_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654C6u)

/** \brief 44C8, Read Data and Bit Flip Register 52 */
#define MTU_MC68_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654C8u)

/** \brief 44CA, Read Data and Bit Flip Register 53 */
#define MTU_MC68_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654CAu)

/** \brief 44CC, Read Data and Bit Flip Register 54 */
#define MTU_MC68_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654CCu)

/** \brief 44CE, Read Data and Bit Flip Register 55 */
#define MTU_MC68_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654CEu)

/** \brief 44D0, Read Data and Bit Flip Register 56 */
#define MTU_MC68_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654D0u)

/** \brief 44D2, Read Data and Bit Flip Register 57 */
#define MTU_MC68_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654D2u)

/** \brief 44D4, Read Data and Bit Flip Register 58 */
#define MTU_MC68_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654D4u)

/** \brief 44D6, Read Data and Bit Flip Register 59 */
#define MTU_MC68_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654D6u)

/** \brief 44D8, Read Data and Bit Flip Register 60 */
#define MTU_MC68_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654D8u)

/** \brief 44DA, Read Data and Bit Flip Register 61 */
#define MTU_MC68_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654DAu)

/** \brief 44DC, Read Data and Bit Flip Register 62 */
#define MTU_MC68_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654DCu)

/** \brief 44DE, Read Data and Bit Flip Register 63 */
#define MTU_MC68_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654DEu)

/** \brief 44E0, Read Data and Bit Flip Register 64 */
#define MTU_MC68_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654E0u)

/** \brief 44E2, Read Data and Bit Flip Register 65 */
#define MTU_MC68_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654E2u)

/** \brief 44E4, Read Data and Bit Flip Register 66 */
#define MTU_MC68_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00654E4u)

/** \brief 44EE, Alarm Sources Configuration Register */
#define MTU_MC68_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00654EEu)

/** \brief 44F0, SSH Safety Faults Status Register  */
#define MTU_MC68_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00654F0u)

/** \brief 44F2, Error Information Register 0 */
#define MTU_MC68_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00654F2u)

/** \brief 44F4, Error Information Register 1 */
#define MTU_MC68_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00654F4u)

/** \brief 44F6, Error Information Register 2 */
#define MTU_MC68_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00654F6u)

/** \brief 44F8, Error Information Register 3 */
#define MTU_MC68_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00654F8u)

/** \brief 44FA, Error Information Register 4 */
#define MTU_MC68_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00654FAu)

/** \brief 4500, Configuration Registers */
#define MTU_MC69_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065500u)

/** \brief 4502, Configuration Register 1 */
#define MTU_MC69_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065502u)

/** \brief 4504, MBIST Control Register */
#define MTU_MC69_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065504u)

/** \brief 4506, Status Register */
#define MTU_MC69_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065506u)

/** \brief 4508, Range Register, single address mode */
#define MTU_MC69_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065508u)

/** \brief 450C, Revision ID Register */
#define MTU_MC69_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006550Cu)

/** \brief 450E, ECC Safety Register */
#define MTU_MC69_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006550Eu)

/** \brief 4510, Memory ECC Detection Register */
#define MTU_MC69_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065510u)

/** \brief 4512, Error Tracking Register 0 */
#define MTU_MC69_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065512u)

/** \brief 4514, Error Tracking Register 1 */
#define MTU_MC69_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065514u)

/** \brief 4516, Error Tracking Register 2 */
#define MTU_MC69_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065516u)

/** \brief 4518, Error Tracking Register 3 */
#define MTU_MC69_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065518u)

/** \brief 451A, Error Tracking Register 4 */
#define MTU_MC69_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006551Au)

/** \brief 4560, Read Data and Bit Flip Register 0 */
#define MTU_MC69_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065560u)

/** \brief 4562, Read Data and Bit Flip Register 1 */
#define MTU_MC69_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065562u)

/** \brief 4564, Read Data and Bit Flip Register 2 */
#define MTU_MC69_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065564u)

/** \brief 4566, Read Data and Bit Flip Register 3 */
#define MTU_MC69_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065566u)

/** \brief 4568, Read Data and Bit Flip Register 4 */
#define MTU_MC69_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065568u)

/** \brief 456A, Read Data and Bit Flip Register 5 */
#define MTU_MC69_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006556Au)

/** \brief 456C, Read Data and Bit Flip Register 6 */
#define MTU_MC69_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006556Cu)

/** \brief 456E, Read Data and Bit Flip Register 7 */
#define MTU_MC69_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006556Eu)

/** \brief 4570, Read Data and Bit Flip Register 8 */
#define MTU_MC69_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065570u)

/** \brief 4572, Read Data and Bit Flip Register 9 */
#define MTU_MC69_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065572u)

/** \brief 4574, Read Data and Bit Flip Register 10 */
#define MTU_MC69_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065574u)

/** \brief 4576, Read Data and Bit Flip Register 11 */
#define MTU_MC69_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065576u)

/** \brief 4578, Read Data and Bit Flip Register 12 */
#define MTU_MC69_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065578u)

/** \brief 457A, Read Data and Bit Flip Register 13 */
#define MTU_MC69_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006557Au)

/** \brief 457C, Read Data and Bit Flip Register 14 */
#define MTU_MC69_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006557Cu)

/** \brief 457E, Read Data and Bit Flip Register 15 */
#define MTU_MC69_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006557Eu)

/** \brief 4580, Read Data and Bit Flip Register 16 */
#define MTU_MC69_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065580u)

/** \brief 4582, Read Data and Bit Flip Register 17 */
#define MTU_MC69_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065582u)

/** \brief 4584, Read Data and Bit Flip Register 18 */
#define MTU_MC69_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065584u)

/** \brief 4586, Read Data and Bit Flip Register 19 */
#define MTU_MC69_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065586u)

/** \brief 4588, Read Data and Bit Flip Register 20 */
#define MTU_MC69_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065588u)

/** \brief 458A, Read Data and Bit Flip Register 21 */
#define MTU_MC69_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006558Au)

/** \brief 458C, Read Data and Bit Flip Register 22 */
#define MTU_MC69_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006558Cu)

/** \brief 458E, Read Data and Bit Flip Register 23 */
#define MTU_MC69_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006558Eu)

/** \brief 4590, Read Data and Bit Flip Register 24 */
#define MTU_MC69_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065590u)

/** \brief 4592, Read Data and Bit Flip Register 25 */
#define MTU_MC69_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065592u)

/** \brief 4594, Read Data and Bit Flip Register 26 */
#define MTU_MC69_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065594u)

/** \brief 4596, Read Data and Bit Flip Register 27 */
#define MTU_MC69_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065596u)

/** \brief 4598, Read Data and Bit Flip Register 28 */
#define MTU_MC69_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065598u)

/** \brief 459A, Read Data and Bit Flip Register 29 */
#define MTU_MC69_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006559Au)

/** \brief 459C, Read Data and Bit Flip Register 30 */
#define MTU_MC69_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006559Cu)

/** \brief 459E, Read Data and Bit Flip Register 31 */
#define MTU_MC69_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006559Eu)

/** \brief 45A0, Read Data and Bit Flip Register 32 */
#define MTU_MC69_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655A0u)

/** \brief 45A2, Read Data and Bit Flip Register 33 */
#define MTU_MC69_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655A2u)

/** \brief 45A4, Read Data and Bit Flip Register 34 */
#define MTU_MC69_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655A4u)

/** \brief 45A6, Read Data and Bit Flip Register 35 */
#define MTU_MC69_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655A6u)

/** \brief 45A8, Read Data and Bit Flip Register 36 */
#define MTU_MC69_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655A8u)

/** \brief 45AA, Read Data and Bit Flip Register 37 */
#define MTU_MC69_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655AAu)

/** \brief 45AC, Read Data and Bit Flip Register 38 */
#define MTU_MC69_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655ACu)

/** \brief 45AE, Read Data and Bit Flip Register 39 */
#define MTU_MC69_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655AEu)

/** \brief 45B0, Read Data and Bit Flip Register 40 */
#define MTU_MC69_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655B0u)

/** \brief 45B2, Read Data and Bit Flip Register 41 */
#define MTU_MC69_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655B2u)

/** \brief 45B4, Read Data and Bit Flip Register 42 */
#define MTU_MC69_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655B4u)

/** \brief 45B6, Read Data and Bit Flip Register 43 */
#define MTU_MC69_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655B6u)

/** \brief 45B8, Read Data and Bit Flip Register 44 */
#define MTU_MC69_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655B8u)

/** \brief 45BA, Read Data and Bit Flip Register 45 */
#define MTU_MC69_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655BAu)

/** \brief 45BC, Read Data and Bit Flip Register 46 */
#define MTU_MC69_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655BCu)

/** \brief 45BE, Read Data and Bit Flip Register 47 */
#define MTU_MC69_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655BEu)

/** \brief 45C0, Read Data and Bit Flip Register 48 */
#define MTU_MC69_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655C0u)

/** \brief 45C2, Read Data and Bit Flip Register 49 */
#define MTU_MC69_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655C2u)

/** \brief 45C4, Read Data and Bit Flip Register 50 */
#define MTU_MC69_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655C4u)

/** \brief 45C6, Read Data and Bit Flip Register 51 */
#define MTU_MC69_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655C6u)

/** \brief 45C8, Read Data and Bit Flip Register 52 */
#define MTU_MC69_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655C8u)

/** \brief 45CA, Read Data and Bit Flip Register 53 */
#define MTU_MC69_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655CAu)

/** \brief 45CC, Read Data and Bit Flip Register 54 */
#define MTU_MC69_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655CCu)

/** \brief 45CE, Read Data and Bit Flip Register 55 */
#define MTU_MC69_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655CEu)

/** \brief 45D0, Read Data and Bit Flip Register 56 */
#define MTU_MC69_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655D0u)

/** \brief 45D2, Read Data and Bit Flip Register 57 */
#define MTU_MC69_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655D2u)

/** \brief 45D4, Read Data and Bit Flip Register 58 */
#define MTU_MC69_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655D4u)

/** \brief 45D6, Read Data and Bit Flip Register 59 */
#define MTU_MC69_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655D6u)

/** \brief 45D8, Read Data and Bit Flip Register 60 */
#define MTU_MC69_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655D8u)

/** \brief 45DA, Read Data and Bit Flip Register 61 */
#define MTU_MC69_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655DAu)

/** \brief 45DC, Read Data and Bit Flip Register 62 */
#define MTU_MC69_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655DCu)

/** \brief 45DE, Read Data and Bit Flip Register 63 */
#define MTU_MC69_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655DEu)

/** \brief 45E0, Read Data and Bit Flip Register 64 */
#define MTU_MC69_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655E0u)

/** \brief 45E2, Read Data and Bit Flip Register 65 */
#define MTU_MC69_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655E2u)

/** \brief 45E4, Read Data and Bit Flip Register 66 */
#define MTU_MC69_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00655E4u)

/** \brief 45EE, Alarm Sources Configuration Register */
#define MTU_MC69_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00655EEu)

/** \brief 45F0, SSH Safety Faults Status Register  */
#define MTU_MC69_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00655F0u)

/** \brief 45F2, Error Information Register 0 */
#define MTU_MC69_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00655F2u)

/** \brief 45F4, Error Information Register 1 */
#define MTU_MC69_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00655F4u)

/** \brief 45F6, Error Information Register 2 */
#define MTU_MC69_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00655F6u)

/** \brief 45F8, Error Information Register 3 */
#define MTU_MC69_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00655F8u)

/** \brief 45FA, Error Information Register 4 */
#define MTU_MC69_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00655FAu)

/** \brief 4600, Configuration Registers */
#define MTU_MC70_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065600u)

/** \brief 4602, Configuration Register 1 */
#define MTU_MC70_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065602u)

/** \brief 4604, MBIST Control Register */
#define MTU_MC70_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065604u)

/** \brief 4606, Status Register */
#define MTU_MC70_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065606u)

/** \brief 4608, Range Register, single address mode */
#define MTU_MC70_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065608u)

/** \brief 460C, Revision ID Register */
#define MTU_MC70_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006560Cu)

/** \brief 460E, ECC Safety Register */
#define MTU_MC70_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006560Eu)

/** \brief 4610, Memory ECC Detection Register */
#define MTU_MC70_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065610u)

/** \brief 4612, Error Tracking Register 0 */
#define MTU_MC70_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065612u)

/** \brief 4614, Error Tracking Register 1 */
#define MTU_MC70_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065614u)

/** \brief 4616, Error Tracking Register 2 */
#define MTU_MC70_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065616u)

/** \brief 4618, Error Tracking Register 3 */
#define MTU_MC70_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065618u)

/** \brief 461A, Error Tracking Register 4 */
#define MTU_MC70_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006561Au)

/** \brief 4660, Read Data and Bit Flip Register 0 */
#define MTU_MC70_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065660u)

/** \brief 4662, Read Data and Bit Flip Register 1 */
#define MTU_MC70_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065662u)

/** \brief 4664, Read Data and Bit Flip Register 2 */
#define MTU_MC70_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065664u)

/** \brief 4666, Read Data and Bit Flip Register 3 */
#define MTU_MC70_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065666u)

/** \brief 4668, Read Data and Bit Flip Register 4 */
#define MTU_MC70_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065668u)

/** \brief 466A, Read Data and Bit Flip Register 5 */
#define MTU_MC70_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006566Au)

/** \brief 466C, Read Data and Bit Flip Register 6 */
#define MTU_MC70_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006566Cu)

/** \brief 466E, Read Data and Bit Flip Register 7 */
#define MTU_MC70_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006566Eu)

/** \brief 4670, Read Data and Bit Flip Register 8 */
#define MTU_MC70_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065670u)

/** \brief 4672, Read Data and Bit Flip Register 9 */
#define MTU_MC70_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065672u)

/** \brief 4674, Read Data and Bit Flip Register 10 */
#define MTU_MC70_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065674u)

/** \brief 4676, Read Data and Bit Flip Register 11 */
#define MTU_MC70_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065676u)

/** \brief 4678, Read Data and Bit Flip Register 12 */
#define MTU_MC70_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065678u)

/** \brief 467A, Read Data and Bit Flip Register 13 */
#define MTU_MC70_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006567Au)

/** \brief 467C, Read Data and Bit Flip Register 14 */
#define MTU_MC70_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006567Cu)

/** \brief 467E, Read Data and Bit Flip Register 15 */
#define MTU_MC70_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006567Eu)

/** \brief 4680, Read Data and Bit Flip Register 16 */
#define MTU_MC70_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065680u)

/** \brief 4682, Read Data and Bit Flip Register 17 */
#define MTU_MC70_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065682u)

/** \brief 4684, Read Data and Bit Flip Register 18 */
#define MTU_MC70_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065684u)

/** \brief 4686, Read Data and Bit Flip Register 19 */
#define MTU_MC70_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065686u)

/** \brief 4688, Read Data and Bit Flip Register 20 */
#define MTU_MC70_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065688u)

/** \brief 468A, Read Data and Bit Flip Register 21 */
#define MTU_MC70_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006568Au)

/** \brief 468C, Read Data and Bit Flip Register 22 */
#define MTU_MC70_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006568Cu)

/** \brief 468E, Read Data and Bit Flip Register 23 */
#define MTU_MC70_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006568Eu)

/** \brief 4690, Read Data and Bit Flip Register 24 */
#define MTU_MC70_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065690u)

/** \brief 4692, Read Data and Bit Flip Register 25 */
#define MTU_MC70_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065692u)

/** \brief 4694, Read Data and Bit Flip Register 26 */
#define MTU_MC70_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065694u)

/** \brief 4696, Read Data and Bit Flip Register 27 */
#define MTU_MC70_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065696u)

/** \brief 4698, Read Data and Bit Flip Register 28 */
#define MTU_MC70_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065698u)

/** \brief 469A, Read Data and Bit Flip Register 29 */
#define MTU_MC70_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006569Au)

/** \brief 469C, Read Data and Bit Flip Register 30 */
#define MTU_MC70_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006569Cu)

/** \brief 469E, Read Data and Bit Flip Register 31 */
#define MTU_MC70_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006569Eu)

/** \brief 46A0, Read Data and Bit Flip Register 32 */
#define MTU_MC70_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656A0u)

/** \brief 46A2, Read Data and Bit Flip Register 33 */
#define MTU_MC70_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656A2u)

/** \brief 46A4, Read Data and Bit Flip Register 34 */
#define MTU_MC70_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656A4u)

/** \brief 46A6, Read Data and Bit Flip Register 35 */
#define MTU_MC70_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656A6u)

/** \brief 46A8, Read Data and Bit Flip Register 36 */
#define MTU_MC70_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656A8u)

/** \brief 46AA, Read Data and Bit Flip Register 37 */
#define MTU_MC70_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656AAu)

/** \brief 46AC, Read Data and Bit Flip Register 38 */
#define MTU_MC70_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656ACu)

/** \brief 46AE, Read Data and Bit Flip Register 39 */
#define MTU_MC70_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656AEu)

/** \brief 46B0, Read Data and Bit Flip Register 40 */
#define MTU_MC70_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656B0u)

/** \brief 46B2, Read Data and Bit Flip Register 41 */
#define MTU_MC70_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656B2u)

/** \brief 46B4, Read Data and Bit Flip Register 42 */
#define MTU_MC70_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656B4u)

/** \brief 46B6, Read Data and Bit Flip Register 43 */
#define MTU_MC70_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656B6u)

/** \brief 46B8, Read Data and Bit Flip Register 44 */
#define MTU_MC70_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656B8u)

/** \brief 46BA, Read Data and Bit Flip Register 45 */
#define MTU_MC70_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656BAu)

/** \brief 46BC, Read Data and Bit Flip Register 46 */
#define MTU_MC70_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656BCu)

/** \brief 46BE, Read Data and Bit Flip Register 47 */
#define MTU_MC70_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656BEu)

/** \brief 46C0, Read Data and Bit Flip Register 48 */
#define MTU_MC70_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656C0u)

/** \brief 46C2, Read Data and Bit Flip Register 49 */
#define MTU_MC70_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656C2u)

/** \brief 46C4, Read Data and Bit Flip Register 50 */
#define MTU_MC70_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656C4u)

/** \brief 46C6, Read Data and Bit Flip Register 51 */
#define MTU_MC70_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656C6u)

/** \brief 46C8, Read Data and Bit Flip Register 52 */
#define MTU_MC70_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656C8u)

/** \brief 46CA, Read Data and Bit Flip Register 53 */
#define MTU_MC70_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656CAu)

/** \brief 46CC, Read Data and Bit Flip Register 54 */
#define MTU_MC70_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656CCu)

/** \brief 46CE, Read Data and Bit Flip Register 55 */
#define MTU_MC70_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656CEu)

/** \brief 46D0, Read Data and Bit Flip Register 56 */
#define MTU_MC70_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656D0u)

/** \brief 46D2, Read Data and Bit Flip Register 57 */
#define MTU_MC70_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656D2u)

/** \brief 46D4, Read Data and Bit Flip Register 58 */
#define MTU_MC70_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656D4u)

/** \brief 46D6, Read Data and Bit Flip Register 59 */
#define MTU_MC70_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656D6u)

/** \brief 46D8, Read Data and Bit Flip Register 60 */
#define MTU_MC70_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656D8u)

/** \brief 46DA, Read Data and Bit Flip Register 61 */
#define MTU_MC70_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656DAu)

/** \brief 46DC, Read Data and Bit Flip Register 62 */
#define MTU_MC70_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656DCu)

/** \brief 46DE, Read Data and Bit Flip Register 63 */
#define MTU_MC70_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656DEu)

/** \brief 46E0, Read Data and Bit Flip Register 64 */
#define MTU_MC70_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656E0u)

/** \brief 46E2, Read Data and Bit Flip Register 65 */
#define MTU_MC70_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656E2u)

/** \brief 46E4, Read Data and Bit Flip Register 66 */
#define MTU_MC70_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00656E4u)

/** \brief 46EE, Alarm Sources Configuration Register */
#define MTU_MC70_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00656EEu)

/** \brief 46F0, SSH Safety Faults Status Register  */
#define MTU_MC70_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00656F0u)

/** \brief 46F2, Error Information Register 0 */
#define MTU_MC70_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00656F2u)

/** \brief 46F4, Error Information Register 1 */
#define MTU_MC70_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00656F4u)

/** \brief 46F6, Error Information Register 2 */
#define MTU_MC70_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00656F6u)

/** \brief 46F8, Error Information Register 3 */
#define MTU_MC70_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00656F8u)

/** \brief 46FA, Error Information Register 4 */
#define MTU_MC70_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00656FAu)

/** \brief 4700, Configuration Registers */
#define MTU_MC71_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065700u)

/** \brief 4702, Configuration Register 1 */
#define MTU_MC71_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065702u)

/** \brief 4704, MBIST Control Register */
#define MTU_MC71_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065704u)

/** \brief 4706, Status Register */
#define MTU_MC71_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065706u)

/** \brief 4708, Range Register, single address mode */
#define MTU_MC71_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065708u)

/** \brief 470C, Revision ID Register */
#define MTU_MC71_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006570Cu)

/** \brief 470E, ECC Safety Register */
#define MTU_MC71_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006570Eu)

/** \brief 4710, Memory ECC Detection Register */
#define MTU_MC71_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065710u)

/** \brief 4712, Error Tracking Register 0 */
#define MTU_MC71_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065712u)

/** \brief 4714, Error Tracking Register 1 */
#define MTU_MC71_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065714u)

/** \brief 4716, Error Tracking Register 2 */
#define MTU_MC71_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065716u)

/** \brief 4718, Error Tracking Register 3 */
#define MTU_MC71_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065718u)

/** \brief 471A, Error Tracking Register 4 */
#define MTU_MC71_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006571Au)

/** \brief 4760, Read Data and Bit Flip Register 0 */
#define MTU_MC71_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065760u)

/** \brief 4762, Read Data and Bit Flip Register 1 */
#define MTU_MC71_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065762u)

/** \brief 4764, Read Data and Bit Flip Register 2 */
#define MTU_MC71_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065764u)

/** \brief 4766, Read Data and Bit Flip Register 3 */
#define MTU_MC71_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065766u)

/** \brief 4768, Read Data and Bit Flip Register 4 */
#define MTU_MC71_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065768u)

/** \brief 476A, Read Data and Bit Flip Register 5 */
#define MTU_MC71_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006576Au)

/** \brief 476C, Read Data and Bit Flip Register 6 */
#define MTU_MC71_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006576Cu)

/** \brief 476E, Read Data and Bit Flip Register 7 */
#define MTU_MC71_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006576Eu)

/** \brief 4770, Read Data and Bit Flip Register 8 */
#define MTU_MC71_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065770u)

/** \brief 4772, Read Data and Bit Flip Register 9 */
#define MTU_MC71_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065772u)

/** \brief 4774, Read Data and Bit Flip Register 10 */
#define MTU_MC71_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065774u)

/** \brief 4776, Read Data and Bit Flip Register 11 */
#define MTU_MC71_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065776u)

/** \brief 4778, Read Data and Bit Flip Register 12 */
#define MTU_MC71_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065778u)

/** \brief 477A, Read Data and Bit Flip Register 13 */
#define MTU_MC71_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006577Au)

/** \brief 477C, Read Data and Bit Flip Register 14 */
#define MTU_MC71_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006577Cu)

/** \brief 477E, Read Data and Bit Flip Register 15 */
#define MTU_MC71_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006577Eu)

/** \brief 4780, Read Data and Bit Flip Register 16 */
#define MTU_MC71_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065780u)

/** \brief 4782, Read Data and Bit Flip Register 17 */
#define MTU_MC71_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065782u)

/** \brief 4784, Read Data and Bit Flip Register 18 */
#define MTU_MC71_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065784u)

/** \brief 4786, Read Data and Bit Flip Register 19 */
#define MTU_MC71_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065786u)

/** \brief 4788, Read Data and Bit Flip Register 20 */
#define MTU_MC71_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065788u)

/** \brief 478A, Read Data and Bit Flip Register 21 */
#define MTU_MC71_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006578Au)

/** \brief 478C, Read Data and Bit Flip Register 22 */
#define MTU_MC71_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006578Cu)

/** \brief 478E, Read Data and Bit Flip Register 23 */
#define MTU_MC71_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006578Eu)

/** \brief 4790, Read Data and Bit Flip Register 24 */
#define MTU_MC71_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065790u)

/** \brief 4792, Read Data and Bit Flip Register 25 */
#define MTU_MC71_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065792u)

/** \brief 4794, Read Data and Bit Flip Register 26 */
#define MTU_MC71_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065794u)

/** \brief 4796, Read Data and Bit Flip Register 27 */
#define MTU_MC71_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065796u)

/** \brief 4798, Read Data and Bit Flip Register 28 */
#define MTU_MC71_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065798u)

/** \brief 479A, Read Data and Bit Flip Register 29 */
#define MTU_MC71_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006579Au)

/** \brief 479C, Read Data and Bit Flip Register 30 */
#define MTU_MC71_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006579Cu)

/** \brief 479E, Read Data and Bit Flip Register 31 */
#define MTU_MC71_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006579Eu)

/** \brief 47A0, Read Data and Bit Flip Register 32 */
#define MTU_MC71_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657A0u)

/** \brief 47A2, Read Data and Bit Flip Register 33 */
#define MTU_MC71_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657A2u)

/** \brief 47A4, Read Data and Bit Flip Register 34 */
#define MTU_MC71_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657A4u)

/** \brief 47A6, Read Data and Bit Flip Register 35 */
#define MTU_MC71_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657A6u)

/** \brief 47A8, Read Data and Bit Flip Register 36 */
#define MTU_MC71_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657A8u)

/** \brief 47AA, Read Data and Bit Flip Register 37 */
#define MTU_MC71_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657AAu)

/** \brief 47AC, Read Data and Bit Flip Register 38 */
#define MTU_MC71_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657ACu)

/** \brief 47AE, Read Data and Bit Flip Register 39 */
#define MTU_MC71_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657AEu)

/** \brief 47B0, Read Data and Bit Flip Register 40 */
#define MTU_MC71_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657B0u)

/** \brief 47B2, Read Data and Bit Flip Register 41 */
#define MTU_MC71_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657B2u)

/** \brief 47B4, Read Data and Bit Flip Register 42 */
#define MTU_MC71_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657B4u)

/** \brief 47B6, Read Data and Bit Flip Register 43 */
#define MTU_MC71_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657B6u)

/** \brief 47B8, Read Data and Bit Flip Register 44 */
#define MTU_MC71_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657B8u)

/** \brief 47BA, Read Data and Bit Flip Register 45 */
#define MTU_MC71_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657BAu)

/** \brief 47BC, Read Data and Bit Flip Register 46 */
#define MTU_MC71_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657BCu)

/** \brief 47BE, Read Data and Bit Flip Register 47 */
#define MTU_MC71_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657BEu)

/** \brief 47C0, Read Data and Bit Flip Register 48 */
#define MTU_MC71_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657C0u)

/** \brief 47C2, Read Data and Bit Flip Register 49 */
#define MTU_MC71_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657C2u)

/** \brief 47C4, Read Data and Bit Flip Register 50 */
#define MTU_MC71_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657C4u)

/** \brief 47C6, Read Data and Bit Flip Register 51 */
#define MTU_MC71_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657C6u)

/** \brief 47C8, Read Data and Bit Flip Register 52 */
#define MTU_MC71_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657C8u)

/** \brief 47CA, Read Data and Bit Flip Register 53 */
#define MTU_MC71_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657CAu)

/** \brief 47CC, Read Data and Bit Flip Register 54 */
#define MTU_MC71_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657CCu)

/** \brief 47CE, Read Data and Bit Flip Register 55 */
#define MTU_MC71_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657CEu)

/** \brief 47D0, Read Data and Bit Flip Register 56 */
#define MTU_MC71_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657D0u)

/** \brief 47D2, Read Data and Bit Flip Register 57 */
#define MTU_MC71_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657D2u)

/** \brief 47D4, Read Data and Bit Flip Register 58 */
#define MTU_MC71_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657D4u)

/** \brief 47D6, Read Data and Bit Flip Register 59 */
#define MTU_MC71_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657D6u)

/** \brief 47D8, Read Data and Bit Flip Register 60 */
#define MTU_MC71_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657D8u)

/** \brief 47DA, Read Data and Bit Flip Register 61 */
#define MTU_MC71_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657DAu)

/** \brief 47DC, Read Data and Bit Flip Register 62 */
#define MTU_MC71_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657DCu)

/** \brief 47DE, Read Data and Bit Flip Register 63 */
#define MTU_MC71_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657DEu)

/** \brief 47E0, Read Data and Bit Flip Register 64 */
#define MTU_MC71_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657E0u)

/** \brief 47E2, Read Data and Bit Flip Register 65 */
#define MTU_MC71_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657E2u)

/** \brief 47E4, Read Data and Bit Flip Register 66 */
#define MTU_MC71_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00657E4u)

/** \brief 47EE, Alarm Sources Configuration Register */
#define MTU_MC71_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00657EEu)

/** \brief 47F0, SSH Safety Faults Status Register  */
#define MTU_MC71_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00657F0u)

/** \brief 47F2, Error Information Register 0 */
#define MTU_MC71_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00657F2u)

/** \brief 47F4, Error Information Register 1 */
#define MTU_MC71_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00657F4u)

/** \brief 47F6, Error Information Register 2 */
#define MTU_MC71_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00657F6u)

/** \brief 47F8, Error Information Register 3 */
#define MTU_MC71_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00657F8u)

/** \brief 47FA, Error Information Register 4 */
#define MTU_MC71_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00657FAu)

/** \brief 4800, Configuration Registers */
#define MTU_MC72_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065800u)

/** \brief 4802, Configuration Register 1 */
#define MTU_MC72_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065802u)

/** \brief 4804, MBIST Control Register */
#define MTU_MC72_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065804u)

/** \brief 4806, Status Register */
#define MTU_MC72_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065806u)

/** \brief 4808, Range Register, single address mode */
#define MTU_MC72_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065808u)

/** \brief 480C, Revision ID Register */
#define MTU_MC72_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006580Cu)

/** \brief 480E, ECC Safety Register */
#define MTU_MC72_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006580Eu)

/** \brief 4810, Memory ECC Detection Register */
#define MTU_MC72_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065810u)

/** \brief 4812, Error Tracking Register 0 */
#define MTU_MC72_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065812u)

/** \brief 4814, Error Tracking Register 1 */
#define MTU_MC72_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065814u)

/** \brief 4816, Error Tracking Register 2 */
#define MTU_MC72_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065816u)

/** \brief 4818, Error Tracking Register 3 */
#define MTU_MC72_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065818u)

/** \brief 481A, Error Tracking Register 4 */
#define MTU_MC72_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006581Au)

/** \brief 4860, Read Data and Bit Flip Register 0 */
#define MTU_MC72_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065860u)

/** \brief 4862, Read Data and Bit Flip Register 1 */
#define MTU_MC72_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065862u)

/** \brief 4864, Read Data and Bit Flip Register 2 */
#define MTU_MC72_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065864u)

/** \brief 4866, Read Data and Bit Flip Register 3 */
#define MTU_MC72_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065866u)

/** \brief 4868, Read Data and Bit Flip Register 4 */
#define MTU_MC72_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065868u)

/** \brief 486A, Read Data and Bit Flip Register 5 */
#define MTU_MC72_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006586Au)

/** \brief 486C, Read Data and Bit Flip Register 6 */
#define MTU_MC72_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006586Cu)

/** \brief 486E, Read Data and Bit Flip Register 7 */
#define MTU_MC72_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006586Eu)

/** \brief 4870, Read Data and Bit Flip Register 8 */
#define MTU_MC72_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065870u)

/** \brief 4872, Read Data and Bit Flip Register 9 */
#define MTU_MC72_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065872u)

/** \brief 4874, Read Data and Bit Flip Register 10 */
#define MTU_MC72_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065874u)

/** \brief 4876, Read Data and Bit Flip Register 11 */
#define MTU_MC72_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065876u)

/** \brief 4878, Read Data and Bit Flip Register 12 */
#define MTU_MC72_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065878u)

/** \brief 487A, Read Data and Bit Flip Register 13 */
#define MTU_MC72_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006587Au)

/** \brief 487C, Read Data and Bit Flip Register 14 */
#define MTU_MC72_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006587Cu)

/** \brief 487E, Read Data and Bit Flip Register 15 */
#define MTU_MC72_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006587Eu)

/** \brief 4880, Read Data and Bit Flip Register 16 */
#define MTU_MC72_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065880u)

/** \brief 4882, Read Data and Bit Flip Register 17 */
#define MTU_MC72_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065882u)

/** \brief 4884, Read Data and Bit Flip Register 18 */
#define MTU_MC72_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065884u)

/** \brief 4886, Read Data and Bit Flip Register 19 */
#define MTU_MC72_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065886u)

/** \brief 4888, Read Data and Bit Flip Register 20 */
#define MTU_MC72_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065888u)

/** \brief 488A, Read Data and Bit Flip Register 21 */
#define MTU_MC72_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006588Au)

/** \brief 488C, Read Data and Bit Flip Register 22 */
#define MTU_MC72_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006588Cu)

/** \brief 488E, Read Data and Bit Flip Register 23 */
#define MTU_MC72_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006588Eu)

/** \brief 4890, Read Data and Bit Flip Register 24 */
#define MTU_MC72_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065890u)

/** \brief 4892, Read Data and Bit Flip Register 25 */
#define MTU_MC72_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065892u)

/** \brief 4894, Read Data and Bit Flip Register 26 */
#define MTU_MC72_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065894u)

/** \brief 4896, Read Data and Bit Flip Register 27 */
#define MTU_MC72_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065896u)

/** \brief 4898, Read Data and Bit Flip Register 28 */
#define MTU_MC72_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065898u)

/** \brief 489A, Read Data and Bit Flip Register 29 */
#define MTU_MC72_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006589Au)

/** \brief 489C, Read Data and Bit Flip Register 30 */
#define MTU_MC72_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006589Cu)

/** \brief 489E, Read Data and Bit Flip Register 31 */
#define MTU_MC72_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006589Eu)

/** \brief 48A0, Read Data and Bit Flip Register 32 */
#define MTU_MC72_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658A0u)

/** \brief 48A2, Read Data and Bit Flip Register 33 */
#define MTU_MC72_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658A2u)

/** \brief 48A4, Read Data and Bit Flip Register 34 */
#define MTU_MC72_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658A4u)

/** \brief 48A6, Read Data and Bit Flip Register 35 */
#define MTU_MC72_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658A6u)

/** \brief 48A8, Read Data and Bit Flip Register 36 */
#define MTU_MC72_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658A8u)

/** \brief 48AA, Read Data and Bit Flip Register 37 */
#define MTU_MC72_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658AAu)

/** \brief 48AC, Read Data and Bit Flip Register 38 */
#define MTU_MC72_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658ACu)

/** \brief 48AE, Read Data and Bit Flip Register 39 */
#define MTU_MC72_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658AEu)

/** \brief 48B0, Read Data and Bit Flip Register 40 */
#define MTU_MC72_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658B0u)

/** \brief 48B2, Read Data and Bit Flip Register 41 */
#define MTU_MC72_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658B2u)

/** \brief 48B4, Read Data and Bit Flip Register 42 */
#define MTU_MC72_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658B4u)

/** \brief 48B6, Read Data and Bit Flip Register 43 */
#define MTU_MC72_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658B6u)

/** \brief 48B8, Read Data and Bit Flip Register 44 */
#define MTU_MC72_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658B8u)

/** \brief 48BA, Read Data and Bit Flip Register 45 */
#define MTU_MC72_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658BAu)

/** \brief 48BC, Read Data and Bit Flip Register 46 */
#define MTU_MC72_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658BCu)

/** \brief 48BE, Read Data and Bit Flip Register 47 */
#define MTU_MC72_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658BEu)

/** \brief 48C0, Read Data and Bit Flip Register 48 */
#define MTU_MC72_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658C0u)

/** \brief 48C2, Read Data and Bit Flip Register 49 */
#define MTU_MC72_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658C2u)

/** \brief 48C4, Read Data and Bit Flip Register 50 */
#define MTU_MC72_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658C4u)

/** \brief 48C6, Read Data and Bit Flip Register 51 */
#define MTU_MC72_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658C6u)

/** \brief 48C8, Read Data and Bit Flip Register 52 */
#define MTU_MC72_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658C8u)

/** \brief 48CA, Read Data and Bit Flip Register 53 */
#define MTU_MC72_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658CAu)

/** \brief 48CC, Read Data and Bit Flip Register 54 */
#define MTU_MC72_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658CCu)

/** \brief 48CE, Read Data and Bit Flip Register 55 */
#define MTU_MC72_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658CEu)

/** \brief 48D0, Read Data and Bit Flip Register 56 */
#define MTU_MC72_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658D0u)

/** \brief 48D2, Read Data and Bit Flip Register 57 */
#define MTU_MC72_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658D2u)

/** \brief 48D4, Read Data and Bit Flip Register 58 */
#define MTU_MC72_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658D4u)

/** \brief 48D6, Read Data and Bit Flip Register 59 */
#define MTU_MC72_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658D6u)

/** \brief 48D8, Read Data and Bit Flip Register 60 */
#define MTU_MC72_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658D8u)

/** \brief 48DA, Read Data and Bit Flip Register 61 */
#define MTU_MC72_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658DAu)

/** \brief 48DC, Read Data and Bit Flip Register 62 */
#define MTU_MC72_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658DCu)

/** \brief 48DE, Read Data and Bit Flip Register 63 */
#define MTU_MC72_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658DEu)

/** \brief 48E0, Read Data and Bit Flip Register 64 */
#define MTU_MC72_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658E0u)

/** \brief 48E2, Read Data and Bit Flip Register 65 */
#define MTU_MC72_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658E2u)

/** \brief 48E4, Read Data and Bit Flip Register 66 */
#define MTU_MC72_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00658E4u)

/** \brief 48EE, Alarm Sources Configuration Register */
#define MTU_MC72_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00658EEu)

/** \brief 48F0, SSH Safety Faults Status Register  */
#define MTU_MC72_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00658F0u)

/** \brief 48F2, Error Information Register 0 */
#define MTU_MC72_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00658F2u)

/** \brief 48F4, Error Information Register 1 */
#define MTU_MC72_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00658F4u)

/** \brief 48F6, Error Information Register 2 */
#define MTU_MC72_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00658F6u)

/** \brief 48F8, Error Information Register 3 */
#define MTU_MC72_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00658F8u)

/** \brief 48FA, Error Information Register 4 */
#define MTU_MC72_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00658FAu)

/** \brief 4900, Configuration Registers */
#define MTU_MC73_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065900u)

/** \brief 4902, Configuration Register 1 */
#define MTU_MC73_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065902u)

/** \brief 4904, MBIST Control Register */
#define MTU_MC73_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065904u)

/** \brief 4906, Status Register */
#define MTU_MC73_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065906u)

/** \brief 4908, Range Register, single address mode */
#define MTU_MC73_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065908u)

/** \brief 490C, Revision ID Register */
#define MTU_MC73_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF006590Cu)

/** \brief 490E, ECC Safety Register */
#define MTU_MC73_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF006590Eu)

/** \brief 4910, Memory ECC Detection Register */
#define MTU_MC73_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065910u)

/** \brief 4912, Error Tracking Register 0 */
#define MTU_MC73_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065912u)

/** \brief 4914, Error Tracking Register 1 */
#define MTU_MC73_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065914u)

/** \brief 4916, Error Tracking Register 2 */
#define MTU_MC73_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065916u)

/** \brief 4918, Error Tracking Register 3 */
#define MTU_MC73_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065918u)

/** \brief 491A, Error Tracking Register 4 */
#define MTU_MC73_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF006591Au)

/** \brief 4960, Read Data and Bit Flip Register 0 */
#define MTU_MC73_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065960u)

/** \brief 4962, Read Data and Bit Flip Register 1 */
#define MTU_MC73_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065962u)

/** \brief 4964, Read Data and Bit Flip Register 2 */
#define MTU_MC73_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065964u)

/** \brief 4966, Read Data and Bit Flip Register 3 */
#define MTU_MC73_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065966u)

/** \brief 4968, Read Data and Bit Flip Register 4 */
#define MTU_MC73_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065968u)

/** \brief 496A, Read Data and Bit Flip Register 5 */
#define MTU_MC73_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006596Au)

/** \brief 496C, Read Data and Bit Flip Register 6 */
#define MTU_MC73_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006596Cu)

/** \brief 496E, Read Data and Bit Flip Register 7 */
#define MTU_MC73_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006596Eu)

/** \brief 4970, Read Data and Bit Flip Register 8 */
#define MTU_MC73_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065970u)

/** \brief 4972, Read Data and Bit Flip Register 9 */
#define MTU_MC73_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065972u)

/** \brief 4974, Read Data and Bit Flip Register 10 */
#define MTU_MC73_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065974u)

/** \brief 4976, Read Data and Bit Flip Register 11 */
#define MTU_MC73_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065976u)

/** \brief 4978, Read Data and Bit Flip Register 12 */
#define MTU_MC73_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065978u)

/** \brief 497A, Read Data and Bit Flip Register 13 */
#define MTU_MC73_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006597Au)

/** \brief 497C, Read Data and Bit Flip Register 14 */
#define MTU_MC73_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006597Cu)

/** \brief 497E, Read Data and Bit Flip Register 15 */
#define MTU_MC73_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006597Eu)

/** \brief 4980, Read Data and Bit Flip Register 16 */
#define MTU_MC73_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065980u)

/** \brief 4982, Read Data and Bit Flip Register 17 */
#define MTU_MC73_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065982u)

/** \brief 4984, Read Data and Bit Flip Register 18 */
#define MTU_MC73_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065984u)

/** \brief 4986, Read Data and Bit Flip Register 19 */
#define MTU_MC73_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065986u)

/** \brief 4988, Read Data and Bit Flip Register 20 */
#define MTU_MC73_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065988u)

/** \brief 498A, Read Data and Bit Flip Register 21 */
#define MTU_MC73_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006598Au)

/** \brief 498C, Read Data and Bit Flip Register 22 */
#define MTU_MC73_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006598Cu)

/** \brief 498E, Read Data and Bit Flip Register 23 */
#define MTU_MC73_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006598Eu)

/** \brief 4990, Read Data and Bit Flip Register 24 */
#define MTU_MC73_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065990u)

/** \brief 4992, Read Data and Bit Flip Register 25 */
#define MTU_MC73_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065992u)

/** \brief 4994, Read Data and Bit Flip Register 26 */
#define MTU_MC73_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065994u)

/** \brief 4996, Read Data and Bit Flip Register 27 */
#define MTU_MC73_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065996u)

/** \brief 4998, Read Data and Bit Flip Register 28 */
#define MTU_MC73_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065998u)

/** \brief 499A, Read Data and Bit Flip Register 29 */
#define MTU_MC73_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006599Au)

/** \brief 499C, Read Data and Bit Flip Register 30 */
#define MTU_MC73_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006599Cu)

/** \brief 499E, Read Data and Bit Flip Register 31 */
#define MTU_MC73_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF006599Eu)

/** \brief 49A0, Read Data and Bit Flip Register 32 */
#define MTU_MC73_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659A0u)

/** \brief 49A2, Read Data and Bit Flip Register 33 */
#define MTU_MC73_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659A2u)

/** \brief 49A4, Read Data and Bit Flip Register 34 */
#define MTU_MC73_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659A4u)

/** \brief 49A6, Read Data and Bit Flip Register 35 */
#define MTU_MC73_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659A6u)

/** \brief 49A8, Read Data and Bit Flip Register 36 */
#define MTU_MC73_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659A8u)

/** \brief 49AA, Read Data and Bit Flip Register 37 */
#define MTU_MC73_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659AAu)

/** \brief 49AC, Read Data and Bit Flip Register 38 */
#define MTU_MC73_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659ACu)

/** \brief 49AE, Read Data and Bit Flip Register 39 */
#define MTU_MC73_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659AEu)

/** \brief 49B0, Read Data and Bit Flip Register 40 */
#define MTU_MC73_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659B0u)

/** \brief 49B2, Read Data and Bit Flip Register 41 */
#define MTU_MC73_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659B2u)

/** \brief 49B4, Read Data and Bit Flip Register 42 */
#define MTU_MC73_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659B4u)

/** \brief 49B6, Read Data and Bit Flip Register 43 */
#define MTU_MC73_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659B6u)

/** \brief 49B8, Read Data and Bit Flip Register 44 */
#define MTU_MC73_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659B8u)

/** \brief 49BA, Read Data and Bit Flip Register 45 */
#define MTU_MC73_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659BAu)

/** \brief 49BC, Read Data and Bit Flip Register 46 */
#define MTU_MC73_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659BCu)

/** \brief 49BE, Read Data and Bit Flip Register 47 */
#define MTU_MC73_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659BEu)

/** \brief 49C0, Read Data and Bit Flip Register 48 */
#define MTU_MC73_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659C0u)

/** \brief 49C2, Read Data and Bit Flip Register 49 */
#define MTU_MC73_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659C2u)

/** \brief 49C4, Read Data and Bit Flip Register 50 */
#define MTU_MC73_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659C4u)

/** \brief 49C6, Read Data and Bit Flip Register 51 */
#define MTU_MC73_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659C6u)

/** \brief 49C8, Read Data and Bit Flip Register 52 */
#define MTU_MC73_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659C8u)

/** \brief 49CA, Read Data and Bit Flip Register 53 */
#define MTU_MC73_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659CAu)

/** \brief 49CC, Read Data and Bit Flip Register 54 */
#define MTU_MC73_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659CCu)

/** \brief 49CE, Read Data and Bit Flip Register 55 */
#define MTU_MC73_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659CEu)

/** \brief 49D0, Read Data and Bit Flip Register 56 */
#define MTU_MC73_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659D0u)

/** \brief 49D2, Read Data and Bit Flip Register 57 */
#define MTU_MC73_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659D2u)

/** \brief 49D4, Read Data and Bit Flip Register 58 */
#define MTU_MC73_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659D4u)

/** \brief 49D6, Read Data and Bit Flip Register 59 */
#define MTU_MC73_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659D6u)

/** \brief 49D8, Read Data and Bit Flip Register 60 */
#define MTU_MC73_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659D8u)

/** \brief 49DA, Read Data and Bit Flip Register 61 */
#define MTU_MC73_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659DAu)

/** \brief 49DC, Read Data and Bit Flip Register 62 */
#define MTU_MC73_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659DCu)

/** \brief 49DE, Read Data and Bit Flip Register 63 */
#define MTU_MC73_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659DEu)

/** \brief 49E0, Read Data and Bit Flip Register 64 */
#define MTU_MC73_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659E0u)

/** \brief 49E2, Read Data and Bit Flip Register 65 */
#define MTU_MC73_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659E2u)

/** \brief 49E4, Read Data and Bit Flip Register 66 */
#define MTU_MC73_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF00659E4u)

/** \brief 49EE, Alarm Sources Configuration Register */
#define MTU_MC73_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF00659EEu)

/** \brief 49F0, SSH Safety Faults Status Register  */
#define MTU_MC73_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF00659F0u)

/** \brief 49F2, Error Information Register 0 */
#define MTU_MC73_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00659F2u)

/** \brief 49F4, Error Information Register 1 */
#define MTU_MC73_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00659F4u)

/** \brief 49F6, Error Information Register 2 */
#define MTU_MC73_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00659F6u)

/** \brief 49F8, Error Information Register 3 */
#define MTU_MC73_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00659F8u)

/** \brief 49FA, Error Information Register 4 */
#define MTU_MC73_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF00659FAu)

/** \brief 4A00, Configuration Registers */
#define MTU_MC74_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065A00u)

/** \brief 4A02, Configuration Register 1 */
#define MTU_MC74_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065A02u)

/** \brief 4A04, MBIST Control Register */
#define MTU_MC74_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065A04u)

/** \brief 4A06, Status Register */
#define MTU_MC74_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065A06u)

/** \brief 4A08, Range Register, single address mode */
#define MTU_MC74_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065A08u)

/** \brief 4A0C, Revision ID Register */
#define MTU_MC74_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0065A0Cu)

/** \brief 4A0E, ECC Safety Register */
#define MTU_MC74_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0065A0Eu)

/** \brief 4A10, Memory ECC Detection Register */
#define MTU_MC74_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065A10u)

/** \brief 4A12, Error Tracking Register 0 */
#define MTU_MC74_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065A12u)

/** \brief 4A14, Error Tracking Register 1 */
#define MTU_MC74_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065A14u)

/** \brief 4A16, Error Tracking Register 2 */
#define MTU_MC74_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065A16u)

/** \brief 4A18, Error Tracking Register 3 */
#define MTU_MC74_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065A18u)

/** \brief 4A1A, Error Tracking Register 4 */
#define MTU_MC74_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065A1Au)

/** \brief 4A60, Read Data and Bit Flip Register 0 */
#define MTU_MC74_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A60u)

/** \brief 4A62, Read Data and Bit Flip Register 1 */
#define MTU_MC74_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A62u)

/** \brief 4A64, Read Data and Bit Flip Register 2 */
#define MTU_MC74_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A64u)

/** \brief 4A66, Read Data and Bit Flip Register 3 */
#define MTU_MC74_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A66u)

/** \brief 4A68, Read Data and Bit Flip Register 4 */
#define MTU_MC74_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A68u)

/** \brief 4A6A, Read Data and Bit Flip Register 5 */
#define MTU_MC74_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A6Au)

/** \brief 4A6C, Read Data and Bit Flip Register 6 */
#define MTU_MC74_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A6Cu)

/** \brief 4A6E, Read Data and Bit Flip Register 7 */
#define MTU_MC74_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A6Eu)

/** \brief 4A70, Read Data and Bit Flip Register 8 */
#define MTU_MC74_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A70u)

/** \brief 4A72, Read Data and Bit Flip Register 9 */
#define MTU_MC74_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A72u)

/** \brief 4A74, Read Data and Bit Flip Register 10 */
#define MTU_MC74_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A74u)

/** \brief 4A76, Read Data and Bit Flip Register 11 */
#define MTU_MC74_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A76u)

/** \brief 4A78, Read Data and Bit Flip Register 12 */
#define MTU_MC74_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A78u)

/** \brief 4A7A, Read Data and Bit Flip Register 13 */
#define MTU_MC74_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A7Au)

/** \brief 4A7C, Read Data and Bit Flip Register 14 */
#define MTU_MC74_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A7Cu)

/** \brief 4A7E, Read Data and Bit Flip Register 15 */
#define MTU_MC74_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A7Eu)

/** \brief 4A80, Read Data and Bit Flip Register 16 */
#define MTU_MC74_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A80u)

/** \brief 4A82, Read Data and Bit Flip Register 17 */
#define MTU_MC74_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A82u)

/** \brief 4A84, Read Data and Bit Flip Register 18 */
#define MTU_MC74_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A84u)

/** \brief 4A86, Read Data and Bit Flip Register 19 */
#define MTU_MC74_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A86u)

/** \brief 4A88, Read Data and Bit Flip Register 20 */
#define MTU_MC74_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A88u)

/** \brief 4A8A, Read Data and Bit Flip Register 21 */
#define MTU_MC74_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A8Au)

/** \brief 4A8C, Read Data and Bit Flip Register 22 */
#define MTU_MC74_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A8Cu)

/** \brief 4A8E, Read Data and Bit Flip Register 23 */
#define MTU_MC74_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A8Eu)

/** \brief 4A90, Read Data and Bit Flip Register 24 */
#define MTU_MC74_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A90u)

/** \brief 4A92, Read Data and Bit Flip Register 25 */
#define MTU_MC74_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A92u)

/** \brief 4A94, Read Data and Bit Flip Register 26 */
#define MTU_MC74_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A94u)

/** \brief 4A96, Read Data and Bit Flip Register 27 */
#define MTU_MC74_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A96u)

/** \brief 4A98, Read Data and Bit Flip Register 28 */
#define MTU_MC74_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A98u)

/** \brief 4A9A, Read Data and Bit Flip Register 29 */
#define MTU_MC74_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A9Au)

/** \brief 4A9C, Read Data and Bit Flip Register 30 */
#define MTU_MC74_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A9Cu)

/** \brief 4A9E, Read Data and Bit Flip Register 31 */
#define MTU_MC74_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065A9Eu)

/** \brief 4AA0, Read Data and Bit Flip Register 32 */
#define MTU_MC74_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AA0u)

/** \brief 4AA2, Read Data and Bit Flip Register 33 */
#define MTU_MC74_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AA2u)

/** \brief 4AA4, Read Data and Bit Flip Register 34 */
#define MTU_MC74_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AA4u)

/** \brief 4AA6, Read Data and Bit Flip Register 35 */
#define MTU_MC74_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AA6u)

/** \brief 4AA8, Read Data and Bit Flip Register 36 */
#define MTU_MC74_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AA8u)

/** \brief 4AAA, Read Data and Bit Flip Register 37 */
#define MTU_MC74_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AAAu)

/** \brief 4AAC, Read Data and Bit Flip Register 38 */
#define MTU_MC74_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AACu)

/** \brief 4AAE, Read Data and Bit Flip Register 39 */
#define MTU_MC74_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AAEu)

/** \brief 4AB0, Read Data and Bit Flip Register 40 */
#define MTU_MC74_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AB0u)

/** \brief 4AB2, Read Data and Bit Flip Register 41 */
#define MTU_MC74_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AB2u)

/** \brief 4AB4, Read Data and Bit Flip Register 42 */
#define MTU_MC74_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AB4u)

/** \brief 4AB6, Read Data and Bit Flip Register 43 */
#define MTU_MC74_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AB6u)

/** \brief 4AB8, Read Data and Bit Flip Register 44 */
#define MTU_MC74_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AB8u)

/** \brief 4ABA, Read Data and Bit Flip Register 45 */
#define MTU_MC74_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065ABAu)

/** \brief 4ABC, Read Data and Bit Flip Register 46 */
#define MTU_MC74_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065ABCu)

/** \brief 4ABE, Read Data and Bit Flip Register 47 */
#define MTU_MC74_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065ABEu)

/** \brief 4AC0, Read Data and Bit Flip Register 48 */
#define MTU_MC74_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AC0u)

/** \brief 4AC2, Read Data and Bit Flip Register 49 */
#define MTU_MC74_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AC2u)

/** \brief 4AC4, Read Data and Bit Flip Register 50 */
#define MTU_MC74_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AC4u)

/** \brief 4AC6, Read Data and Bit Flip Register 51 */
#define MTU_MC74_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AC6u)

/** \brief 4AC8, Read Data and Bit Flip Register 52 */
#define MTU_MC74_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AC8u)

/** \brief 4ACA, Read Data and Bit Flip Register 53 */
#define MTU_MC74_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065ACAu)

/** \brief 4ACC, Read Data and Bit Flip Register 54 */
#define MTU_MC74_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065ACCu)

/** \brief 4ACE, Read Data and Bit Flip Register 55 */
#define MTU_MC74_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065ACEu)

/** \brief 4AD0, Read Data and Bit Flip Register 56 */
#define MTU_MC74_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AD0u)

/** \brief 4AD2, Read Data and Bit Flip Register 57 */
#define MTU_MC74_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AD2u)

/** \brief 4AD4, Read Data and Bit Flip Register 58 */
#define MTU_MC74_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AD4u)

/** \brief 4AD6, Read Data and Bit Flip Register 59 */
#define MTU_MC74_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AD6u)

/** \brief 4AD8, Read Data and Bit Flip Register 60 */
#define MTU_MC74_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AD8u)

/** \brief 4ADA, Read Data and Bit Flip Register 61 */
#define MTU_MC74_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065ADAu)

/** \brief 4ADC, Read Data and Bit Flip Register 62 */
#define MTU_MC74_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065ADCu)

/** \brief 4ADE, Read Data and Bit Flip Register 63 */
#define MTU_MC74_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065ADEu)

/** \brief 4AE0, Read Data and Bit Flip Register 64 */
#define MTU_MC74_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AE0u)

/** \brief 4AE2, Read Data and Bit Flip Register 65 */
#define MTU_MC74_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AE2u)

/** \brief 4AE4, Read Data and Bit Flip Register 66 */
#define MTU_MC74_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065AE4u)

/** \brief 4AEE, Alarm Sources Configuration Register */
#define MTU_MC74_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0065AEEu)

/** \brief 4AF0, SSH Safety Faults Status Register  */
#define MTU_MC74_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0065AF0u)

/** \brief 4AF2, Error Information Register 0 */
#define MTU_MC74_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065AF2u)

/** \brief 4AF4, Error Information Register 1 */
#define MTU_MC74_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065AF4u)

/** \brief 4AF6, Error Information Register 2 */
#define MTU_MC74_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065AF6u)

/** \brief 4AF8, Error Information Register 3 */
#define MTU_MC74_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065AF8u)

/** \brief 4AFA, Error Information Register 4 */
#define MTU_MC74_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065AFAu)

/** \brief 4B00, Configuration Registers */
#define MTU_MC75_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065B00u)

/** \brief 4B02, Configuration Register 1 */
#define MTU_MC75_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065B02u)

/** \brief 4B04, MBIST Control Register */
#define MTU_MC75_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065B04u)

/** \brief 4B06, Status Register */
#define MTU_MC75_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065B06u)

/** \brief 4B08, Range Register, single address mode */
#define MTU_MC75_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065B08u)

/** \brief 4B0C, Revision ID Register */
#define MTU_MC75_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0065B0Cu)

/** \brief 4B0E, ECC Safety Register */
#define MTU_MC75_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0065B0Eu)

/** \brief 4B10, Memory ECC Detection Register */
#define MTU_MC75_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065B10u)

/** \brief 4B12, Error Tracking Register 0 */
#define MTU_MC75_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065B12u)

/** \brief 4B14, Error Tracking Register 1 */
#define MTU_MC75_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065B14u)

/** \brief 4B16, Error Tracking Register 2 */
#define MTU_MC75_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065B16u)

/** \brief 4B18, Error Tracking Register 3 */
#define MTU_MC75_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065B18u)

/** \brief 4B1A, Error Tracking Register 4 */
#define MTU_MC75_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065B1Au)

/** \brief 4B60, Read Data and Bit Flip Register 0 */
#define MTU_MC75_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B60u)

/** \brief 4B62, Read Data and Bit Flip Register 1 */
#define MTU_MC75_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B62u)

/** \brief 4B64, Read Data and Bit Flip Register 2 */
#define MTU_MC75_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B64u)

/** \brief 4B66, Read Data and Bit Flip Register 3 */
#define MTU_MC75_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B66u)

/** \brief 4B68, Read Data and Bit Flip Register 4 */
#define MTU_MC75_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B68u)

/** \brief 4B6A, Read Data and Bit Flip Register 5 */
#define MTU_MC75_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B6Au)

/** \brief 4B6C, Read Data and Bit Flip Register 6 */
#define MTU_MC75_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B6Cu)

/** \brief 4B6E, Read Data and Bit Flip Register 7 */
#define MTU_MC75_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B6Eu)

/** \brief 4B70, Read Data and Bit Flip Register 8 */
#define MTU_MC75_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B70u)

/** \brief 4B72, Read Data and Bit Flip Register 9 */
#define MTU_MC75_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B72u)

/** \brief 4B74, Read Data and Bit Flip Register 10 */
#define MTU_MC75_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B74u)

/** \brief 4B76, Read Data and Bit Flip Register 11 */
#define MTU_MC75_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B76u)

/** \brief 4B78, Read Data and Bit Flip Register 12 */
#define MTU_MC75_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B78u)

/** \brief 4B7A, Read Data and Bit Flip Register 13 */
#define MTU_MC75_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B7Au)

/** \brief 4B7C, Read Data and Bit Flip Register 14 */
#define MTU_MC75_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B7Cu)

/** \brief 4B7E, Read Data and Bit Flip Register 15 */
#define MTU_MC75_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B7Eu)

/** \brief 4B80, Read Data and Bit Flip Register 16 */
#define MTU_MC75_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B80u)

/** \brief 4B82, Read Data and Bit Flip Register 17 */
#define MTU_MC75_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B82u)

/** \brief 4B84, Read Data and Bit Flip Register 18 */
#define MTU_MC75_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B84u)

/** \brief 4B86, Read Data and Bit Flip Register 19 */
#define MTU_MC75_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B86u)

/** \brief 4B88, Read Data and Bit Flip Register 20 */
#define MTU_MC75_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B88u)

/** \brief 4B8A, Read Data and Bit Flip Register 21 */
#define MTU_MC75_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B8Au)

/** \brief 4B8C, Read Data and Bit Flip Register 22 */
#define MTU_MC75_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B8Cu)

/** \brief 4B8E, Read Data and Bit Flip Register 23 */
#define MTU_MC75_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B8Eu)

/** \brief 4B90, Read Data and Bit Flip Register 24 */
#define MTU_MC75_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B90u)

/** \brief 4B92, Read Data and Bit Flip Register 25 */
#define MTU_MC75_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B92u)

/** \brief 4B94, Read Data and Bit Flip Register 26 */
#define MTU_MC75_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B94u)

/** \brief 4B96, Read Data and Bit Flip Register 27 */
#define MTU_MC75_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B96u)

/** \brief 4B98, Read Data and Bit Flip Register 28 */
#define MTU_MC75_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B98u)

/** \brief 4B9A, Read Data and Bit Flip Register 29 */
#define MTU_MC75_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B9Au)

/** \brief 4B9C, Read Data and Bit Flip Register 30 */
#define MTU_MC75_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B9Cu)

/** \brief 4B9E, Read Data and Bit Flip Register 31 */
#define MTU_MC75_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065B9Eu)

/** \brief 4BA0, Read Data and Bit Flip Register 32 */
#define MTU_MC75_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BA0u)

/** \brief 4BA2, Read Data and Bit Flip Register 33 */
#define MTU_MC75_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BA2u)

/** \brief 4BA4, Read Data and Bit Flip Register 34 */
#define MTU_MC75_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BA4u)

/** \brief 4BA6, Read Data and Bit Flip Register 35 */
#define MTU_MC75_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BA6u)

/** \brief 4BA8, Read Data and Bit Flip Register 36 */
#define MTU_MC75_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BA8u)

/** \brief 4BAA, Read Data and Bit Flip Register 37 */
#define MTU_MC75_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BAAu)

/** \brief 4BAC, Read Data and Bit Flip Register 38 */
#define MTU_MC75_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BACu)

/** \brief 4BAE, Read Data and Bit Flip Register 39 */
#define MTU_MC75_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BAEu)

/** \brief 4BB0, Read Data and Bit Flip Register 40 */
#define MTU_MC75_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BB0u)

/** \brief 4BB2, Read Data and Bit Flip Register 41 */
#define MTU_MC75_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BB2u)

/** \brief 4BB4, Read Data and Bit Flip Register 42 */
#define MTU_MC75_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BB4u)

/** \brief 4BB6, Read Data and Bit Flip Register 43 */
#define MTU_MC75_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BB6u)

/** \brief 4BB8, Read Data and Bit Flip Register 44 */
#define MTU_MC75_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BB8u)

/** \brief 4BBA, Read Data and Bit Flip Register 45 */
#define MTU_MC75_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BBAu)

/** \brief 4BBC, Read Data and Bit Flip Register 46 */
#define MTU_MC75_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BBCu)

/** \brief 4BBE, Read Data and Bit Flip Register 47 */
#define MTU_MC75_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BBEu)

/** \brief 4BC0, Read Data and Bit Flip Register 48 */
#define MTU_MC75_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BC0u)

/** \brief 4BC2, Read Data and Bit Flip Register 49 */
#define MTU_MC75_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BC2u)

/** \brief 4BC4, Read Data and Bit Flip Register 50 */
#define MTU_MC75_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BC4u)

/** \brief 4BC6, Read Data and Bit Flip Register 51 */
#define MTU_MC75_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BC6u)

/** \brief 4BC8, Read Data and Bit Flip Register 52 */
#define MTU_MC75_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BC8u)

/** \brief 4BCA, Read Data and Bit Flip Register 53 */
#define MTU_MC75_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BCAu)

/** \brief 4BCC, Read Data and Bit Flip Register 54 */
#define MTU_MC75_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BCCu)

/** \brief 4BCE, Read Data and Bit Flip Register 55 */
#define MTU_MC75_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BCEu)

/** \brief 4BD0, Read Data and Bit Flip Register 56 */
#define MTU_MC75_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BD0u)

/** \brief 4BD2, Read Data and Bit Flip Register 57 */
#define MTU_MC75_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BD2u)

/** \brief 4BD4, Read Data and Bit Flip Register 58 */
#define MTU_MC75_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BD4u)

/** \brief 4BD6, Read Data and Bit Flip Register 59 */
#define MTU_MC75_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BD6u)

/** \brief 4BD8, Read Data and Bit Flip Register 60 */
#define MTU_MC75_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BD8u)

/** \brief 4BDA, Read Data and Bit Flip Register 61 */
#define MTU_MC75_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BDAu)

/** \brief 4BDC, Read Data and Bit Flip Register 62 */
#define MTU_MC75_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BDCu)

/** \brief 4BDE, Read Data and Bit Flip Register 63 */
#define MTU_MC75_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BDEu)

/** \brief 4BE0, Read Data and Bit Flip Register 64 */
#define MTU_MC75_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BE0u)

/** \brief 4BE2, Read Data and Bit Flip Register 65 */
#define MTU_MC75_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BE2u)

/** \brief 4BE4, Read Data and Bit Flip Register 66 */
#define MTU_MC75_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065BE4u)

/** \brief 4BEE, Alarm Sources Configuration Register */
#define MTU_MC75_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0065BEEu)

/** \brief 4BF0, SSH Safety Faults Status Register  */
#define MTU_MC75_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0065BF0u)

/** \brief 4BF2, Error Information Register 0 */
#define MTU_MC75_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065BF2u)

/** \brief 4BF4, Error Information Register 1 */
#define MTU_MC75_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065BF4u)

/** \brief 4BF6, Error Information Register 2 */
#define MTU_MC75_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065BF6u)

/** \brief 4BF8, Error Information Register 3 */
#define MTU_MC75_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065BF8u)

/** \brief 4BFA, Error Information Register 4 */
#define MTU_MC75_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065BFAu)

/** \brief 4C00, Configuration Registers */
#define MTU_MC76_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065C00u)

/** \brief 4C02, Configuration Register 1 */
#define MTU_MC76_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065C02u)

/** \brief 4C04, MBIST Control Register */
#define MTU_MC76_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065C04u)

/** \brief 4C06, Status Register */
#define MTU_MC76_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065C06u)

/** \brief 4C08, Range Register, single address mode */
#define MTU_MC76_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065C08u)

/** \brief 4C0C, Revision ID Register */
#define MTU_MC76_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0065C0Cu)

/** \brief 4C0E, ECC Safety Register */
#define MTU_MC76_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0065C0Eu)

/** \brief 4C10, Memory ECC Detection Register */
#define MTU_MC76_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065C10u)

/** \brief 4C12, Error Tracking Register 0 */
#define MTU_MC76_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065C12u)

/** \brief 4C14, Error Tracking Register 1 */
#define MTU_MC76_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065C14u)

/** \brief 4C16, Error Tracking Register 2 */
#define MTU_MC76_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065C16u)

/** \brief 4C18, Error Tracking Register 3 */
#define MTU_MC76_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065C18u)

/** \brief 4C1A, Error Tracking Register 4 */
#define MTU_MC76_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065C1Au)

/** \brief 4C60, Read Data and Bit Flip Register 0 */
#define MTU_MC76_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C60u)

/** \brief 4C62, Read Data and Bit Flip Register 1 */
#define MTU_MC76_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C62u)

/** \brief 4C64, Read Data and Bit Flip Register 2 */
#define MTU_MC76_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C64u)

/** \brief 4C66, Read Data and Bit Flip Register 3 */
#define MTU_MC76_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C66u)

/** \brief 4C68, Read Data and Bit Flip Register 4 */
#define MTU_MC76_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C68u)

/** \brief 4C6A, Read Data and Bit Flip Register 5 */
#define MTU_MC76_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C6Au)

/** \brief 4C6C, Read Data and Bit Flip Register 6 */
#define MTU_MC76_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C6Cu)

/** \brief 4C6E, Read Data and Bit Flip Register 7 */
#define MTU_MC76_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C6Eu)

/** \brief 4C70, Read Data and Bit Flip Register 8 */
#define MTU_MC76_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C70u)

/** \brief 4C72, Read Data and Bit Flip Register 9 */
#define MTU_MC76_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C72u)

/** \brief 4C74, Read Data and Bit Flip Register 10 */
#define MTU_MC76_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C74u)

/** \brief 4C76, Read Data and Bit Flip Register 11 */
#define MTU_MC76_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C76u)

/** \brief 4C78, Read Data and Bit Flip Register 12 */
#define MTU_MC76_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C78u)

/** \brief 4C7A, Read Data and Bit Flip Register 13 */
#define MTU_MC76_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C7Au)

/** \brief 4C7C, Read Data and Bit Flip Register 14 */
#define MTU_MC76_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C7Cu)

/** \brief 4C7E, Read Data and Bit Flip Register 15 */
#define MTU_MC76_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C7Eu)

/** \brief 4C80, Read Data and Bit Flip Register 16 */
#define MTU_MC76_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C80u)

/** \brief 4C82, Read Data and Bit Flip Register 17 */
#define MTU_MC76_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C82u)

/** \brief 4C84, Read Data and Bit Flip Register 18 */
#define MTU_MC76_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C84u)

/** \brief 4C86, Read Data and Bit Flip Register 19 */
#define MTU_MC76_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C86u)

/** \brief 4C88, Read Data and Bit Flip Register 20 */
#define MTU_MC76_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C88u)

/** \brief 4C8A, Read Data and Bit Flip Register 21 */
#define MTU_MC76_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C8Au)

/** \brief 4C8C, Read Data and Bit Flip Register 22 */
#define MTU_MC76_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C8Cu)

/** \brief 4C8E, Read Data and Bit Flip Register 23 */
#define MTU_MC76_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C8Eu)

/** \brief 4C90, Read Data and Bit Flip Register 24 */
#define MTU_MC76_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C90u)

/** \brief 4C92, Read Data and Bit Flip Register 25 */
#define MTU_MC76_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C92u)

/** \brief 4C94, Read Data and Bit Flip Register 26 */
#define MTU_MC76_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C94u)

/** \brief 4C96, Read Data and Bit Flip Register 27 */
#define MTU_MC76_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C96u)

/** \brief 4C98, Read Data and Bit Flip Register 28 */
#define MTU_MC76_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C98u)

/** \brief 4C9A, Read Data and Bit Flip Register 29 */
#define MTU_MC76_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C9Au)

/** \brief 4C9C, Read Data and Bit Flip Register 30 */
#define MTU_MC76_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C9Cu)

/** \brief 4C9E, Read Data and Bit Flip Register 31 */
#define MTU_MC76_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065C9Eu)

/** \brief 4CA0, Read Data and Bit Flip Register 32 */
#define MTU_MC76_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CA0u)

/** \brief 4CA2, Read Data and Bit Flip Register 33 */
#define MTU_MC76_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CA2u)

/** \brief 4CA4, Read Data and Bit Flip Register 34 */
#define MTU_MC76_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CA4u)

/** \brief 4CA6, Read Data and Bit Flip Register 35 */
#define MTU_MC76_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CA6u)

/** \brief 4CA8, Read Data and Bit Flip Register 36 */
#define MTU_MC76_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CA8u)

/** \brief 4CAA, Read Data and Bit Flip Register 37 */
#define MTU_MC76_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CAAu)

/** \brief 4CAC, Read Data and Bit Flip Register 38 */
#define MTU_MC76_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CACu)

/** \brief 4CAE, Read Data and Bit Flip Register 39 */
#define MTU_MC76_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CAEu)

/** \brief 4CB0, Read Data and Bit Flip Register 40 */
#define MTU_MC76_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CB0u)

/** \brief 4CB2, Read Data and Bit Flip Register 41 */
#define MTU_MC76_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CB2u)

/** \brief 4CB4, Read Data and Bit Flip Register 42 */
#define MTU_MC76_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CB4u)

/** \brief 4CB6, Read Data and Bit Flip Register 43 */
#define MTU_MC76_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CB6u)

/** \brief 4CB8, Read Data and Bit Flip Register 44 */
#define MTU_MC76_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CB8u)

/** \brief 4CBA, Read Data and Bit Flip Register 45 */
#define MTU_MC76_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CBAu)

/** \brief 4CBC, Read Data and Bit Flip Register 46 */
#define MTU_MC76_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CBCu)

/** \brief 4CBE, Read Data and Bit Flip Register 47 */
#define MTU_MC76_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CBEu)

/** \brief 4CC0, Read Data and Bit Flip Register 48 */
#define MTU_MC76_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CC0u)

/** \brief 4CC2, Read Data and Bit Flip Register 49 */
#define MTU_MC76_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CC2u)

/** \brief 4CC4, Read Data and Bit Flip Register 50 */
#define MTU_MC76_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CC4u)

/** \brief 4CC6, Read Data and Bit Flip Register 51 */
#define MTU_MC76_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CC6u)

/** \brief 4CC8, Read Data and Bit Flip Register 52 */
#define MTU_MC76_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CC8u)

/** \brief 4CCA, Read Data and Bit Flip Register 53 */
#define MTU_MC76_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CCAu)

/** \brief 4CCC, Read Data and Bit Flip Register 54 */
#define MTU_MC76_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CCCu)

/** \brief 4CCE, Read Data and Bit Flip Register 55 */
#define MTU_MC76_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CCEu)

/** \brief 4CD0, Read Data and Bit Flip Register 56 */
#define MTU_MC76_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CD0u)

/** \brief 4CD2, Read Data and Bit Flip Register 57 */
#define MTU_MC76_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CD2u)

/** \brief 4CD4, Read Data and Bit Flip Register 58 */
#define MTU_MC76_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CD4u)

/** \brief 4CD6, Read Data and Bit Flip Register 59 */
#define MTU_MC76_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CD6u)

/** \brief 4CD8, Read Data and Bit Flip Register 60 */
#define MTU_MC76_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CD8u)

/** \brief 4CDA, Read Data and Bit Flip Register 61 */
#define MTU_MC76_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CDAu)

/** \brief 4CDC, Read Data and Bit Flip Register 62 */
#define MTU_MC76_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CDCu)

/** \brief 4CDE, Read Data and Bit Flip Register 63 */
#define MTU_MC76_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CDEu)

/** \brief 4CE0, Read Data and Bit Flip Register 64 */
#define MTU_MC76_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CE0u)

/** \brief 4CE2, Read Data and Bit Flip Register 65 */
#define MTU_MC76_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CE2u)

/** \brief 4CE4, Read Data and Bit Flip Register 66 */
#define MTU_MC76_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065CE4u)

/** \brief 4CEE, Alarm Sources Configuration Register */
#define MTU_MC76_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0065CEEu)

/** \brief 4CF0, SSH Safety Faults Status Register  */
#define MTU_MC76_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0065CF0u)

/** \brief 4CF2, Error Information Register 0 */
#define MTU_MC76_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065CF2u)

/** \brief 4CF4, Error Information Register 1 */
#define MTU_MC76_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065CF4u)

/** \brief 4CF6, Error Information Register 2 */
#define MTU_MC76_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065CF6u)

/** \brief 4CF8, Error Information Register 3 */
#define MTU_MC76_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065CF8u)

/** \brief 4CFA, Error Information Register 4 */
#define MTU_MC76_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065CFAu)

/** \brief 4D00, Configuration Registers */
#define MTU_MC77_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065D00u)

/** \brief 4D02, Configuration Register 1 */
#define MTU_MC77_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065D02u)

/** \brief 4D04, MBIST Control Register */
#define MTU_MC77_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065D04u)

/** \brief 4D06, Status Register */
#define MTU_MC77_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065D06u)

/** \brief 4D08, Range Register, single address mode */
#define MTU_MC77_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065D08u)

/** \brief 4D0C, Revision ID Register */
#define MTU_MC77_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0065D0Cu)

/** \brief 4D0E, ECC Safety Register */
#define MTU_MC77_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0065D0Eu)

/** \brief 4D10, Memory ECC Detection Register */
#define MTU_MC77_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065D10u)

/** \brief 4D12, Error Tracking Register 0 */
#define MTU_MC77_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065D12u)

/** \brief 4D14, Error Tracking Register 1 */
#define MTU_MC77_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065D14u)

/** \brief 4D16, Error Tracking Register 2 */
#define MTU_MC77_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065D16u)

/** \brief 4D18, Error Tracking Register 3 */
#define MTU_MC77_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065D18u)

/** \brief 4D1A, Error Tracking Register 4 */
#define MTU_MC77_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065D1Au)

/** \brief 4D60, Read Data and Bit Flip Register 0 */
#define MTU_MC77_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D60u)

/** \brief 4D62, Read Data and Bit Flip Register 1 */
#define MTU_MC77_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D62u)

/** \brief 4D64, Read Data and Bit Flip Register 2 */
#define MTU_MC77_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D64u)

/** \brief 4D66, Read Data and Bit Flip Register 3 */
#define MTU_MC77_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D66u)

/** \brief 4D68, Read Data and Bit Flip Register 4 */
#define MTU_MC77_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D68u)

/** \brief 4D6A, Read Data and Bit Flip Register 5 */
#define MTU_MC77_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D6Au)

/** \brief 4D6C, Read Data and Bit Flip Register 6 */
#define MTU_MC77_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D6Cu)

/** \brief 4D6E, Read Data and Bit Flip Register 7 */
#define MTU_MC77_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D6Eu)

/** \brief 4D70, Read Data and Bit Flip Register 8 */
#define MTU_MC77_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D70u)

/** \brief 4D72, Read Data and Bit Flip Register 9 */
#define MTU_MC77_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D72u)

/** \brief 4D74, Read Data and Bit Flip Register 10 */
#define MTU_MC77_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D74u)

/** \brief 4D76, Read Data and Bit Flip Register 11 */
#define MTU_MC77_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D76u)

/** \brief 4D78, Read Data and Bit Flip Register 12 */
#define MTU_MC77_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D78u)

/** \brief 4D7A, Read Data and Bit Flip Register 13 */
#define MTU_MC77_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D7Au)

/** \brief 4D7C, Read Data and Bit Flip Register 14 */
#define MTU_MC77_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D7Cu)

/** \brief 4D7E, Read Data and Bit Flip Register 15 */
#define MTU_MC77_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D7Eu)

/** \brief 4D80, Read Data and Bit Flip Register 16 */
#define MTU_MC77_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D80u)

/** \brief 4D82, Read Data and Bit Flip Register 17 */
#define MTU_MC77_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D82u)

/** \brief 4D84, Read Data and Bit Flip Register 18 */
#define MTU_MC77_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D84u)

/** \brief 4D86, Read Data and Bit Flip Register 19 */
#define MTU_MC77_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D86u)

/** \brief 4D88, Read Data and Bit Flip Register 20 */
#define MTU_MC77_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D88u)

/** \brief 4D8A, Read Data and Bit Flip Register 21 */
#define MTU_MC77_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D8Au)

/** \brief 4D8C, Read Data and Bit Flip Register 22 */
#define MTU_MC77_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D8Cu)

/** \brief 4D8E, Read Data and Bit Flip Register 23 */
#define MTU_MC77_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D8Eu)

/** \brief 4D90, Read Data and Bit Flip Register 24 */
#define MTU_MC77_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D90u)

/** \brief 4D92, Read Data and Bit Flip Register 25 */
#define MTU_MC77_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D92u)

/** \brief 4D94, Read Data and Bit Flip Register 26 */
#define MTU_MC77_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D94u)

/** \brief 4D96, Read Data and Bit Flip Register 27 */
#define MTU_MC77_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D96u)

/** \brief 4D98, Read Data and Bit Flip Register 28 */
#define MTU_MC77_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D98u)

/** \brief 4D9A, Read Data and Bit Flip Register 29 */
#define MTU_MC77_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D9Au)

/** \brief 4D9C, Read Data and Bit Flip Register 30 */
#define MTU_MC77_RDBFL30 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D9Cu)

/** \brief 4D9E, Read Data and Bit Flip Register 31 */
#define MTU_MC77_RDBFL31 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065D9Eu)

/** \brief 4DA0, Read Data and Bit Flip Register 32 */
#define MTU_MC77_RDBFL32 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DA0u)

/** \brief 4DA2, Read Data and Bit Flip Register 33 */
#define MTU_MC77_RDBFL33 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DA2u)

/** \brief 4DA4, Read Data and Bit Flip Register 34 */
#define MTU_MC77_RDBFL34 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DA4u)

/** \brief 4DA6, Read Data and Bit Flip Register 35 */
#define MTU_MC77_RDBFL35 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DA6u)

/** \brief 4DA8, Read Data and Bit Flip Register 36 */
#define MTU_MC77_RDBFL36 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DA8u)

/** \brief 4DAA, Read Data and Bit Flip Register 37 */
#define MTU_MC77_RDBFL37 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DAAu)

/** \brief 4DAC, Read Data and Bit Flip Register 38 */
#define MTU_MC77_RDBFL38 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DACu)

/** \brief 4DAE, Read Data and Bit Flip Register 39 */
#define MTU_MC77_RDBFL39 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DAEu)

/** \brief 4DB0, Read Data and Bit Flip Register 40 */
#define MTU_MC77_RDBFL40 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DB0u)

/** \brief 4DB2, Read Data and Bit Flip Register 41 */
#define MTU_MC77_RDBFL41 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DB2u)

/** \brief 4DB4, Read Data and Bit Flip Register 42 */
#define MTU_MC77_RDBFL42 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DB4u)

/** \brief 4DB6, Read Data and Bit Flip Register 43 */
#define MTU_MC77_RDBFL43 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DB6u)

/** \brief 4DB8, Read Data and Bit Flip Register 44 */
#define MTU_MC77_RDBFL44 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DB8u)

/** \brief 4DBA, Read Data and Bit Flip Register 45 */
#define MTU_MC77_RDBFL45 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DBAu)

/** \brief 4DBC, Read Data and Bit Flip Register 46 */
#define MTU_MC77_RDBFL46 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DBCu)

/** \brief 4DBE, Read Data and Bit Flip Register 47 */
#define MTU_MC77_RDBFL47 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DBEu)

/** \brief 4DC0, Read Data and Bit Flip Register 48 */
#define MTU_MC77_RDBFL48 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DC0u)

/** \brief 4DC2, Read Data and Bit Flip Register 49 */
#define MTU_MC77_RDBFL49 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DC2u)

/** \brief 4DC4, Read Data and Bit Flip Register 50 */
#define MTU_MC77_RDBFL50 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DC4u)

/** \brief 4DC6, Read Data and Bit Flip Register 51 */
#define MTU_MC77_RDBFL51 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DC6u)

/** \brief 4DC8, Read Data and Bit Flip Register 52 */
#define MTU_MC77_RDBFL52 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DC8u)

/** \brief 4DCA, Read Data and Bit Flip Register 53 */
#define MTU_MC77_RDBFL53 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DCAu)

/** \brief 4DCC, Read Data and Bit Flip Register 54 */
#define MTU_MC77_RDBFL54 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DCCu)

/** \brief 4DCE, Read Data and Bit Flip Register 55 */
#define MTU_MC77_RDBFL55 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DCEu)

/** \brief 4DD0, Read Data and Bit Flip Register 56 */
#define MTU_MC77_RDBFL56 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DD0u)

/** \brief 4DD2, Read Data and Bit Flip Register 57 */
#define MTU_MC77_RDBFL57 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DD2u)

/** \brief 4DD4, Read Data and Bit Flip Register 58 */
#define MTU_MC77_RDBFL58 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DD4u)

/** \brief 4DD6, Read Data and Bit Flip Register 59 */
#define MTU_MC77_RDBFL59 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DD6u)

/** \brief 4DD8, Read Data and Bit Flip Register 60 */
#define MTU_MC77_RDBFL60 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DD8u)

/** \brief 4DDA, Read Data and Bit Flip Register 61 */
#define MTU_MC77_RDBFL61 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DDAu)

/** \brief 4DDC, Read Data and Bit Flip Register 62 */
#define MTU_MC77_RDBFL62 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DDCu)

/** \brief 4DDE, Read Data and Bit Flip Register 63 */
#define MTU_MC77_RDBFL63 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DDEu)

/** \brief 4DE0, Read Data and Bit Flip Register 64 */
#define MTU_MC77_RDBFL64 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DE0u)

/** \brief 4DE2, Read Data and Bit Flip Register 65 */
#define MTU_MC77_RDBFL65 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DE2u)

/** \brief 4DE4, Read Data and Bit Flip Register 66 */
#define MTU_MC77_RDBFL66 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065DE4u)

/** \brief 4DEE, Alarm Sources Configuration Register */
#define MTU_MC77_ALMSRCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ALMSRCS*)0xF0065DEEu)

/** \brief 4DF0, SSH Safety Faults Status Register  */
#define MTU_MC77_FAULTSTS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_FAULTSTS*)0xF0065DF0u)

/** \brief 4DF2, Error Information Register 0 */
#define MTU_MC77_ERRINFO0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065DF2u)

/** \brief 4DF4, Error Information Register 1 */
#define MTU_MC77_ERRINFO1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065DF4u)

/** \brief 4DF6, Error Information Register 2 */
#define MTU_MC77_ERRINFO2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065DF6u)

/** \brief 4DF8, Error Information Register 3 */
#define MTU_MC77_ERRINFO3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065DF8u)

/** \brief 4DFA, Error Information Register 4 */
#define MTU_MC77_ERRINFO4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ERRINFO*)0xF0065DFAu)

/** \brief 4E00, Configuration Registers */
#define MTU_MC78_CONFIG0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG0*)0xF0065E00u)

/** \brief 4E02, Configuration Register 1 */
#define MTU_MC78_CONFIG1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_CONFIG1*)0xF0065E02u)

/** \brief 4E04, MBIST Control Register */
#define MTU_MC78_MCONTROL /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MCONTROL*)0xF0065E04u)

/** \brief 4E06, Status Register */
#define MTU_MC78_MSTATUS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_MSTATUS*)0xF0065E06u)

/** \brief 4E08, Range Register, single address mode */
#define MTU_MC78_RANGE /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RANGE*)0xF0065E08u)

/** \brief 4E0C, Revision ID Register */
#define MTU_MC78_REVID /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_REVID*)0xF0065E0Cu)

/** \brief 4E0E, ECC Safety Register */
#define MTU_MC78_ECCS /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCS*)0xF0065E0Eu)

/** \brief 4E10, Memory ECC Detection Register */
#define MTU_MC78_ECCD /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ECCD*)0xF0065E10u)

/** \brief 4E12, Error Tracking Register 0 */
#define MTU_MC78_ETRR0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065E12u)

/** \brief 4E14, Error Tracking Register 1 */
#define MTU_MC78_ETRR1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065E14u)

/** \brief 4E16, Error Tracking Register 2 */
#define MTU_MC78_ETRR2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065E16u)

/** \brief 4E18, Error Tracking Register 3 */
#define MTU_MC78_ETRR3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065E18u)

/** \brief 4E1A, Error Tracking Register 4 */
#define MTU_MC78_ETRR4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_ETRR*)0xF0065E1Au)

/** \brief 4E60, Read Data and Bit Flip Register 0 */
#define MTU_MC78_RDBFL0 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E60u)

/** \brief 4E62, Read Data and Bit Flip Register 1 */
#define MTU_MC78_RDBFL1 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E62u)

/** \brief 4E64, Read Data and Bit Flip Register 2 */
#define MTU_MC78_RDBFL2 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E64u)

/** \brief 4E66, Read Data and Bit Flip Register 3 */
#define MTU_MC78_RDBFL3 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E66u)

/** \brief 4E68, Read Data and Bit Flip Register 4 */
#define MTU_MC78_RDBFL4 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E68u)

/** \brief 4E6A, Read Data and Bit Flip Register 5 */
#define MTU_MC78_RDBFL5 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E6Au)

/** \brief 4E6C, Read Data and Bit Flip Register 6 */
#define MTU_MC78_RDBFL6 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E6Cu)

/** \brief 4E6E, Read Data and Bit Flip Register 7 */
#define MTU_MC78_RDBFL7 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E6Eu)

/** \brief 4E70, Read Data and Bit Flip Register 8 */
#define MTU_MC78_RDBFL8 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E70u)

/** \brief 4E72, Read Data and Bit Flip Register 9 */
#define MTU_MC78_RDBFL9 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E72u)

/** \brief 4E74, Read Data and Bit Flip Register 10 */
#define MTU_MC78_RDBFL10 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E74u)

/** \brief 4E76, Read Data and Bit Flip Register 11 */
#define MTU_MC78_RDBFL11 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E76u)

/** \brief 4E78, Read Data and Bit Flip Register 12 */
#define MTU_MC78_RDBFL12 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E78u)

/** \brief 4E7A, Read Data and Bit Flip Register 13 */
#define MTU_MC78_RDBFL13 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E7Au)

/** \brief 4E7C, Read Data and Bit Flip Register 14 */
#define MTU_MC78_RDBFL14 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E7Cu)

/** \brief 4E7E, Read Data and Bit Flip Register 15 */
#define MTU_MC78_RDBFL15 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E7Eu)

/** \brief 4E80, Read Data and Bit Flip Register 16 */
#define MTU_MC78_RDBFL16 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E80u)

/** \brief 4E82, Read Data and Bit Flip Register 17 */
#define MTU_MC78_RDBFL17 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E82u)

/** \brief 4E84, Read Data and Bit Flip Register 18 */
#define MTU_MC78_RDBFL18 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E84u)

/** \brief 4E86, Read Data and Bit Flip Register 19 */
#define MTU_MC78_RDBFL19 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E86u)

/** \brief 4E88, Read Data and Bit Flip Register 20 */
#define MTU_MC78_RDBFL20 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E88u)

/** \brief 4E8A, Read Data and Bit Flip Register 21 */
#define MTU_MC78_RDBFL21 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E8Au)

/** \brief 4E8C, Read Data and Bit Flip Register 22 */
#define MTU_MC78_RDBFL22 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E8Cu)

/** \brief 4E8E, Read Data and Bit Flip Register 23 */
#define MTU_MC78_RDBFL23 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E8Eu)

/** \brief 4E90, Read Data and Bit Flip Register 24 */
#define MTU_MC78_RDBFL24 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E90u)

/** \brief 4E92, Read Data and Bit Flip Register 25 */
#define MTU_MC78_RDBFL25 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E92u)

/** \brief 4E94, Read Data and Bit Flip Register 26 */
#define MTU_MC78_RDBFL26 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E94u)

/** \brief 4E96, Read Data and Bit Flip Register 27 */
#define MTU_MC78_RDBFL27 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E96u)

/** \brief 4E98, Read Data and Bit Flip Register 28 */
#define MTU_MC78_RDBFL28 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E98u)

/** \brief 4E9A, Read Data and Bit Flip Register 29 */
#define MTU_MC78_RDBFL29 /*lint --e(923, 9078)*/ (*(volatile Ifx_MTU_MC_RDBFL*)0xF0065E9Au)

/** \brief 4E9C, Read Data and Bit Flip Register