/*********************************************************************************************************************
* TC364 Opensourec Library TC364 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC364 Դһ
*
* TC364 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_driver_gpio
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC364DP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-02       pudding            first version
********************************************************************************************************************/

#ifndef _zf_driver_gpio_h_
#define _zf_driver_gpio_h_

#include "IFXPORT.h"
#include "zf_common_typedef.h"

typedef enum // öٶ˿ öٶ岻û޸
{
    // IOʱиӲȷϵǰоƬǷдIO
    P00_0 = 0*32,  P00_1, P00_2,  P00_3,  P00_4,  P00_5,  P00_6,  P00_7,
    P00_8,         P00_9, P00_10, P00_11, P00_12, P00_13, P00_14, P00_15,

    P02_0 = 2*32,  P02_1, P02_2,  P02_3,  P02_4,  P02_5,  P02_6,  P02_7,
    P02_8,         P02_9, P02_10, P02_11, P02_12, P02_13, P02_14, P02_15,

    P10_0 = 10*32, P10_1, P10_2,  P10_3,  P10_4,  P10_5,  P10_6,  P10_7,
    P10_8,         P10_9, P10_10, P10_11, P10_12, P10_13, P10_14, P10_15,

    P11_0 = 11*32, P11_1, P11_2,  P11_3,  P11_4,  P11_5,  P11_6,  P11_7,
    P11_8,         P11_9, P11_10, P11_11, P11_12, P11_13, P11_14, P11_15,

    P13_0 = 13*32, P13_1, P13_2,  P13_3,  P13_4,  P13_5,  P13_6,  P13_7,
    P13_8,         P13_9, P13_10, P13_11, P13_12, P13_13, P13_14, P13_15,

    P14_0 = 14*32, P14_1, P14_2,  P14_3,  P14_4,  P14_5,  P14_6,  P14_7,
    P14_8,         P14_9, P14_10, P14_11, P14_12, P14_13, P14_14, P14_15,

    P15_0 = 15*32, P15_1, P15_2,  P15_3,  P15_4,  P15_5,  P15_6,  P15_7,
    P15_8,         P15_9, P15_10, P15_11, P15_12, P15_13, P15_14, P15_15,

    P20_0 = 20*32, P20_1, P20_2,  P20_3,  P20_4,  P20_5,  P20_6,  P20_7,
    P20_8,         P20_9, P20_10, P20_11, P20_12, P20_13, P20_14, P20_15,

    P21_0 = 21*32, P21_1, P21_2,  P21_3,  P21_4,  P21_5,  P21_6,  P21_7,
    P21_8,         P21_9, P21_10, P21_11, P21_12, P21_13, P21_14, P21_15,

    P22_0 = 22*32, P22_1, P22_2,  P22_3,  P22_4,  P22_5,  P22_6,  P22_7,
    P22_8,         P22_9, P22_10, P22_11, P22_12, P22_13, P22_14, P22_15,

    P23_0 = 23*32, P23_1, P23_2,  P23_3,  P23_4,  P23_5,  P23_6,  P23_7,
    P23_8,         P23_9, P23_10, P23_11, P23_12, P23_13, P23_14, P23_15,

    P32_0 = 32*32, P32_1, P32_2,  P32_3,  P32_4,  P32_5,  P32_6,  P32_7,
    P32_8,         P32_9, P32_10, P32_11, P32_12, P32_13, P32_14, P32_15,

    P33_0 = 33*32, P33_1, P33_2,  P33_3,  P33_4,  P33_5,  P33_6,  P33_7,
    P33_8,         P33_9, P33_10, P33_11, P33_12, P33_13, P33_14, P33_15,

}gpio_pin_enum;

typedef enum               // öٶ˿ڷ    öٶ岻û޸
{
    GPI = 0,               // ܽ뷽
    GPO = 1,               // ܽ
}gpio_dir_enum;

typedef enum               // öٶ˿ڵƽ    öٶ岻û޸
{
    GPIO_LOW =  0,         // ͵ƽ
    GPIO_HIGH = 1,         // ߵƽ
}gpio_level_enum;

typedef enum               // öٶ˿ģʽ   öٶ岻û޸
{
    GPI_FLOATING_IN,       // ܽŸ
    GPI_PULL_UP    ,       // ܽ
    GPI_PULL_DOWN  ,       // ܽ

    GPO_PUSH_PULL  ,       // ܽ
    GPO_OPEN_DTAIN ,       // ܽſ©
}gpio_mode_enum;

//====================================================GPIO ݺ====================================================
Ifx_P*      get_port                    (gpio_pin_enum pin);
#define     get_port_in_addr(pin)       (uint8 *)(&IfxPort_getAddress((IfxPort_Index)(pin/32))->IN + pin%32/8)
#define     get_port_out_addr(port)     (((Ifx_P *)IfxPort_cfg_indexMap[port].module)->OUT.U)

//------------------------------------------------------------------------------------------------------------------
//      Ӧ IO λΪߵƽ
// ˵     x           ѡ (ѡΧ zf_driver_gpio.h  gpio_pin_enum öֵȷ)
// ز     void
// ʹʾ     gpio_high(P00_0);// P00_0 ߵƽ
// עϢ
//------------------------------------------------------------------------------------------------------------------
#define     gpio_high(x)                (get_port(x))->OMR.U = 1 << ((x)&0x1f)       // GPIOλ (get_port(x))->OMR.U = 1 << ((x)&0x1f)

//------------------------------------------------------------------------------------------------------------------
//      Ӧ IO λΪ͵ƽ
// ˵     x           ѡ (ѡΧ zf_driver_gpio.h  gpio_pin_enum öֵȷ)
// ز     void
// ʹʾ     gpio_low(P00_0);// P00_0 ͵ƽ
// עϢ
//------------------------------------------------------------------------------------------------------------------
#define     gpio_low(x)                 (get_port(x))->OMR.U = 65536 << ((x)&0x1f)   // GPIOλ (get_port(x))->OMR.U = 65536 << ((x)&0x1f)

//====================================================GPIO ݺ====================================================

//====================================================GPIO ====================================================
void  gpio_set_level    (gpio_pin_enum pin, uint8 dat);
uint8 gpio_get_level    (gpio_pin_enum pin);
void  gpio_toggle_level (gpio_pin_enum pin);
void  gpio_set_dir      (gpio_pin_enum pin, gpio_dir_enum dir, gpio_mode_enum pinconf);
void  gpio_init         (gpio_pin_enum pin, gpio_dir_enum dir, uint8 dat, gpio_mode_enum pinconf);
//====================================================GPIO ====================================================

//==================================================ݾɰ汾Դӿ=================================================
#ifdef COMPATIBLE_WITH_OLDER_VERSIONS
#define     gpio_set(pin, dat)          (gpio_set_level((pin), (dat)))
#define     gpio_get(pin)               (gpio_get_level((pin)))
#define     gpio_dir(pin, dir, mode)    (gpio_set_dir((pin), (dir), (mode)))
#define     gpio_toggle(pin)            (gpio_toggle_level((pin)))
#endif
//==================================================ݾɰ汾Դӿ=================================================

#endif
