/*********************************************************************************************************************
* TC364 Opensourec Library TC364 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC364 Դһ
*
* TC364 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_device_tft180
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC364DP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-11-02       pudding            first version
* 2023-04-28       pudding            ע˵
********************************************************************************************************************/
/*********************************************************************************************************************
* ߶壺
*                  ------------------------------------
*                  ģܽ              Ƭܽ
*                  SCL                 鿴 zf_device_tft180.h  TFT180_SCL_PIN 궨
*                  SDA                 鿴 zf_device_tft180.h  TFT180_SDA_PIN 궨
*                  RES                 鿴 zf_device_tft180.h  TFT180_RES_PIN 궨
*                  DC                  鿴 zf_device_tft180.h  TFT180_DC_PIN 궨
*                  CS                  鿴 zf_device_tft180.h  TFT180_CS_PIN 궨
*                  BL                  鿴 zf_device_tft180.h  TFT180_BL_PIN 궨
*                  VCC                 3.3VԴ
*                  GND                 Դ
*                  ֱ160*128
*                  ------------------------------------
********************************************************************************************************************/

#ifndef _zf_device_tft180_h_
#define _zf_device_tft180_h_

#include "zf_common_typedef.h"

//================================================= TFT180 ================================================
#define TFT180_USE_SOFT_SPI             (0)                                     // ĬʹӲ SPI ʽ ʹӲ SPI ʽ
#if TFT180_USE_SOFT_SPI                                                         //  ɫĲȷ ɫҵľûõ
//==================================================== SPI ====================================================
#define TFT180_SOFT_SPI_DELAY           (0 )                                    //  SPI ʱʱ ֵԽС SPI ͨԽ
#define TFT180_SCL_PIN                  (P15_3)                                 //  SPI SCK 
#define TFT180_SDA_PIN                  (P15_5)                                 //  SPI MOSI 
//==================================================== SPI ====================================================
#else
//====================================================Ӳ SPI ====================================================
#define TFT180_SPI_SPEED                (60*1000*1000)                          // Ӳ SPI 
#define TFT180_SPI                      (SPI_2)                                 // Ӳ SPI 
#define TFT180_SCL_PIN                  (SPI2_SCLK_P15_3)                       // Ӳ SPI SCK 
#define TFT180_SDA_PIN                  (SPI2_MOSI_P15_5)                       // Ӳ SPI MOSI 
#define TFT180_SDA_PIN_IN               (SPI2_MISO_P15_4)                       // Ӳ SPI MISO   TFTûMISOţȻҪ壬spiĳʼʱҪʹ
//====================================================Ӳ SPI ====================================================
#endif

#define TFT180_RES_PIN                  (P15_1)                                 // ҺλŶ
#define TFT180_DC_PIN                   (P15_0)                                 // ҺλŶ
#define TFT180_CS_PIN                   (P15_2)                                 // CS Ƭѡ
#define TFT180_BL_PIN                   (P15_4)                                 // ҺŶ

#define TFT180_DEFAULT_DISPLAY_DIR      (TFT180_PORTAIT)                        // Ĭϵʾ
#define TFT180_DEFAULT_PENCOLOR         (RGB565_RED)                            // ĬϵĻɫ
#define TFT180_DEFAULT_BGCOLOR          (RGB565_WHITE)                          // Ĭϵıɫ
#define TFT180_DEFAULT_DISPLAY_FONT     (TFT180_8X16_FONT)                      // Ĭϵģʽ

#define TFT180_DC(x)                    ((x) ? (gpio_high(TFT180_DC_PIN))  : (gpio_low(TFT180_DC_PIN)))
#define TFT180_RST(x)                   ((x) ? (gpio_high(TFT180_RES_PIN)) : (gpio_low(TFT180_RES_PIN)))
#define TFT180_CS(x)                    ((x) ? (gpio_high(TFT180_CS_PIN))  : (gpio_low(TFT180_CS_PIN)))
#define TFT180_BLK(x)                   ((x) ? (gpio_high(TFT180_BL_PIN))  : (gpio_low(TFT180_BL_PIN)))
//================================================= TFT180 ================================================


//================================================= TFT180 ṹ===============================================
typedef enum
{
    TFT180_PORTAIT                      = 0,                                    // ģʽ
    TFT180_PORTAIT_180                  = 1,                                    // ģʽ  ת180
    TFT180_CROSSWISE                    = 2,                                    // ģʽ
    TFT180_CROSSWISE_180                = 3,                                    // ģʽ  ת180
}tft180_dir_enum;

typedef enum
{
    TFT180_6X8_FONT                     = 0,                                    // 6x8      
    TFT180_8X16_FONT                    = 1,                                    // 8x16     
    TFT180_16X16_FONT                   = 2,                                    // 16x16     Ŀǰ֧
}tft180_font_size_enum;

extern  uint16  tft180_width_max ;
extern  uint16  tft180_height_max;
//================================================= TFT180 ṹ===============================================


//================================================= TFT180 ================================================
void    tft180_clear                    (void);                                                                               // TFT180 
void    tft180_full                     (const uint16 color);                                                                 // TFT180 Ļ亯
void    tft180_set_dir                  (tft180_dir_enum dir);                                                                // TFT180 ʾ
void    tft180_set_font                 (tft180_font_size_enum font);                                                         // TFT180 ʾ
void    tft180_set_color                (const uint16 pen, const  uint16 bgcolor);                                            // TFT180 ʾɫ
void    tft180_draw_point               (uint16 x, uint16 y, const uint16 color);                                             // TFT180 㺯
void    tft180_draw_line                (uint16 x_start, uint16 y_start, uint16 x_end, uint16 y_end, const uint16 color);     // TFT180 ߺ

void    tft180_show_char                (uint16 x, uint16 y, const char dat);                                                 // TFT180 ʾַ
void    tft180_show_string              (uint16 x, uint16 y, const char dat[]);                                               // TFT180 ʾַ
void    tft180_show_int                 (uint16 x,uint16 y, const int32 dat, uint8 num);                                      // TFT180 ʾ32λз (ȥЧ0)
void    tft180_show_uint                (uint16 x,uint16 y, const uint32 dat, uint8 num);                                     // TFT180 ʾ32λ޷ (ȥЧ0)
void    tft180_show_float               (uint16 x, uint16 y, const double dat, uint8 num, uint8 pointnum);

void    tft180_show_binary_image        (uint16 x, uint16 y, const uint8 *image, uint16 width, uint16 height, uint16 dis_width, uint16 dis_height);                    // TFT180 ʾֵͼ ÿ˸һֽ
void    tft180_show_gray_image          (uint16 x, uint16 y, const uint8 *image, uint16 width, uint16 height, uint16 dis_width, uint16 dis_height, uint8 threshold);   // TFT180 ʾ 8bit Ҷͼ ֵֵ
void    tft180_show_rgb565_image        (uint16 x, uint16 y, const uint16 *image, uint16 width, uint16 height, uint16 dis_width, uint16 dis_height, uint8 color_mode); // TFT180 ʾ RGB565 ɫͼ

void    tft180_show_wave                (uint16 x, uint16 y, const uint16 *wave, uint16 width, uint16 value_max, uint16 dis_width, uint16 dis_value_max);              // TFT180 ʾ
void    tft180_show_chinese             (uint16 x, uint16 y, uint8 size, const uint8 *chinese_buffer, uint8 number, const uint16 color);                               // TFT180 ʾ
                                                                                                                              // 1.8TFTĻʼ
void    tft180_init                     (void);
//================================================= TFT180 ================================================


//================================================= TFT180 չ================================================
//-------------------------------------------------------------------------------------------------------------------
//      TFT180 ʾСͼ
// ˵     p               ͼָ
// ˵     width           ͼʵʿ
// ˵     height          ͼʵʸ߶
// ز     void
// ʹʾ     tft180_displayimage7725(ov7725_image_binary[0], OV7725_W, OV7725_H);
// עϢ     չһʾĬţĻʼ㿪ʼʾ
//-------------------------------------------------------------------------------------------------------------------
#define tft180_displayimage7725(p, width, height)       (tft180_show_binary_image(0, 0, (p), OV7725_W, OV7725_H, (width), (height)))
//-------------------------------------------------------------------------------------------------------------------
//      TFT180 ʾͼ
// ˵     p               ͼָ
// ˵     width           ͼʵʿ
// ˵     height          ͼʵʸ߶
// ز     void
// ʹʾ     tft180_displayimage03x(mt9v03x_image[0], MT9V03X_W, MT9V03X_H);
// עϢ     չһʾĬţĻʼ㿪ʼʾ
//-------------------------------------------------------------------------------------------------------------------
#define tft180_displayimage03x(p, width, height)        (tft180_show_gray_image(0, 0, (p), MT9V03X_W, MT9V03X_H, (width), (height), 0))
//-------------------------------------------------------------------------------------------------------------------
//      TFT180 ʾͫͼ
// ˵     p               ͼָ
// ˵     width           ͼʵʿ
// ˵     height          ͼʵʸ߶
// ز     void
// ʹʾ     tft180_displayimage8660(scc8660_image[0], SCC8660_W, SCC8660_H);
// עϢ     չһʾĬţĻʼ㿪ʼʾ
//-------------------------------------------------------------------------------------------------------------------
#define tft180_displayimage8660(p, width, height)       (tft180_show_rgb565_image(0, 0, (p), SCC8660_W, SCC8660_H, (width), (height), 1))
//================================================= TFT180 չ================================================


#endif
