/*********************************************************************************************************************
* TC364 Opensourec Library TC364 Դ⣩һڹٷ SDK ӿڵĵԴ
* Copyright (c) 2022 SEEKFREE ɿƼ
*
* ļ TC364 Դһ
*
* TC364 Դ 
* Ըᷢ GPLGNU General Public License GNUͨù֤
*  GPL ĵ3棨 GPL3.0ѡģκκİ汾·/޸
*
* Դķϣܷãδκεı֤
* ûԻʺض;ı֤
* ϸμ GPL
*
* ӦյԴͬʱյһ GPL ĸ
* ûУ<https://www.gnu.org/licenses/>
*
* ע
* Դʹ GPL3.0 Դ֤Э Ϊİ汾
* Ӣİ libraries/doc ļµ GPL3_permission_statement.txt ļ
* ֤ libraries ļ ļµ LICENSE ļ
* ӭλʹò ޸ʱ뱣ɿƼİȨ
*
* ļ          zf_common_clock
* ˾          ɶɿƼ޹˾
* 汾Ϣ          鿴 libraries/doc ļ version ļ 汾˵
*           ADS v1.9.20
* ƽ̨          TC364DP
*           https://seekfree.taobao.com/
*
* ޸ļ¼
*                               ע
* 2022-09-15       pudding            first version
* 2023-04-26       pudding            ʼɱ־ȴҪȴCPU0ʼɺCPUܽиֵ
********************************************************************************************************************/

#include "IfxScuEru.h"
#include "Ifxstm.h"
#include "Cpu0_Main.h"
#include "IfxCpu.h"
#include "zf_driver_delay.h"
#include "zf_common_interrupt.h"
#include "zf_common_clock.h"


App_Cpu0 g_AppCpu0;                               // ƵϢ

static vuint8 cpu_init_finish[IfxCpu_Id_none];      // ĳʼɱ־λ

//-------------------------------------------------------------------------------------------------------------------
//           ϵͳƵ
//           void
// ʹʾ          set_clock();
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void set_clock (void)
{
    IfxScuCcu_setCpuFrequency(IfxCpu_ResourceCpu_0, (float32)AURIX_MCU_FREQUENCY);
    IfxScuCcu_setCpuFrequency(IfxCpu_ResourceCpu_1, (float32)AURIX_MCU_FREQUENCY);
}

//-------------------------------------------------------------------------------------------------------------------
//           ȡϵͳƵ
//           void
// ʹʾ          get_clock();
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void get_clock (void)
{
    // ȡʱƵʣڲ鿴ǰϵͳƵ
    g_AppCpu0.info.pllFreq = IfxScuCcu_getPllFrequency();
    g_AppCpu0.info.cpuFreq = IfxScuCcu_getCpuFrequency(IfxCpu_getCoreIndex());
    g_AppCpu0.info.sysFreq = IfxScuCcu_getSpbFrequency();
    g_AppCpu0.info.stmFreq = IfxStm_getFrequency(&MODULE_STM0);
}

//-------------------------------------------------------------------------------------------------------------------
//           رտŹ
//           void
// ʹʾ          disable_Watchdog();
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void disable_Watchdog (void)
{
    IfxScuWdt_disableCpuWatchdog(IfxScuWdt_getCpuWatchdogPassword());
    IfxScuWdt_disableSafetyWatchdog(IfxScuWdt_getSafetyWatchdogPassword());
}

//-------------------------------------------------------------------------------------------------------------------
//           ʱӳʼ
//           void
// ʹʾ          clock_init();
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void clock_init (void)
{
    interrupt_global_disable();     // رж
    disable_Watchdog();             // رտŹ
    get_clock();                    // ȡϵͳƵ
    system_delay_init();            // ʱʼ
    interrupt_global_enable(0);     // ȫж
}


//-------------------------------------------------------------------------------------------------------------------
//           ȴкĳʼ
//           void
// ʹʾ          cpu_wait_event_ready();
// עϢ
//-------------------------------------------------------------------------------------------------------------------
void cpu_wait_event_ready (void)
{
    uint8 i;
    uint8 all_cpu_init_finish;

    if(IfxCpu_getCoreId() != 0)
    {
        while(cpu_init_finish[0] == 0);
    }

    // ô˺ĺĳʼϣ־λһ
    cpu_init_finish[IfxCpu_getCoreId()] = 1;

    // ȴĳʼ
    do
    {
        all_cpu_init_finish = 1;
        for(i = 0; i < IfxCpu_Id_none; i++)
        {
            all_cpu_init_finish *= cpu_init_finish[i];
        }
        system_delay_ms(1);
    }while(0 == all_cpu_init_finish);
}
