/**
 * \file IfxSrc_regdef.h
 * \brief
 * \copyright Copyright (c) 2019 Infineon Technologies AG. All rights reserved.
 *
 *
 * Version: TC36XA_UM_V1.2.0.R0
 * Specification: TC3xx User Manual.V1.2.0
 * MAY BE CHANGED BY USER [yes/no]: No
 *
 *                                 IMPORTANT NOTICE
 *
 *
 * Use of this file is subject to the terms of use agreed between (i) you or 
 * the company in which ordinary course of business you are acting and (ii) 
 * Infineon Technologies AG or its licensees. If and as long as no such 
 * terms of use are agreed, use of this file is subject to following:


 * Boost Software License - Version 1.0 - August 17th, 2003

 * Permission is hereby granted, free of charge, to any person or 
 * organization obtaining a copy of the software and accompanying 
 * documentation covered by this license (the "Software") to use, reproduce,
 * display, distribute, execute, and transmit the Software, and to prepare
 * derivative works of the Software, and to permit third-parties to whom the 
 * Software is furnished to do so, all subject to the following:

 * The copyright notices in the Software and this entire statement, including
 * the above license grant, this restriction and the following disclaimer, must
 * be included in all copies of the Software, in whole or in part, and all
 * derivative works of the Software, unless such copies or derivative works are
 * solely in the form of machine-executable object code generated by a source
 * language processor.

 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
 * SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE 
 * FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * \defgroup IfxSfr_Src_Registers Src Registers
 * \ingroup IfxSfr
 * 
 * \defgroup IfxSfr_Src_Registers_Bitfields Bitfields
 * \ingroup IfxSfr_Src_Registers
 * 
 * \defgroup IfxSfr_Src_Registers_union Register unions
 * \ingroup IfxSfr_Src_Registers
 * 
 * \defgroup IfxSfr_Src_Registers_struct Memory map
 * \ingroup IfxSfr_Src_Registers
 */
#ifndef IFXSRC_REGDEF_H
#define IFXSRC_REGDEF_H 1
/******************************************************************************/
#include "Ifx_TypesReg.h"
/******************************************************************************/

/******************************************************************************/

/******************************************************************************/


/** \addtogroup IfxSfr_Src_Registers_Bitfields
 * \{  */
/** \brief  */
typedef struct _Ifx_SRC_SRCR_Bits
{
    Ifx_UReg_32Bit SRPN:8;            /**< \brief [7:0] Service Request Priority Number (rw) */
    Ifx_UReg_32Bit reserved_8:2;      /**< \brief [9:8] \internal Reserved */
    Ifx_UReg_32Bit SRE:1;             /**< \brief [10:10] Service Request Enable (rw) */
    Ifx_UReg_32Bit TOS:3;             /**< \brief [13:11] Type of Service Control (rw) */
    Ifx_UReg_32Bit reserved_14:2;     /**< \brief [15:14] \internal Reserved */
    Ifx_UReg_32Bit ECC:5;             /**< \brief [20:16] Error Correction Code (rwh) */
    Ifx_UReg_32Bit reserved_21:3;     /**< \brief [23:21] \internal Reserved */
    Ifx_UReg_32Bit SRR:1;             /**< \brief [24:24] Service Request Flag (rh) */
    Ifx_UReg_32Bit CLRR:1;            /**< \brief [25:25] Request Clear Bit (w) */
    Ifx_UReg_32Bit SETR:1;            /**< \brief [26:26] Request Set Bit (w) */
    Ifx_UReg_32Bit IOV:1;             /**< \brief [27:27] Interrupt Trigger Overflow Bit (rh) */
    Ifx_UReg_32Bit IOVCLR:1;          /**< \brief [28:28] Interrupt Trigger Overflow Clear Bit (w) */
    Ifx_UReg_32Bit SWS:1;             /**< \brief [29:29] SW Sticky Bit (rh) */
    Ifx_UReg_32Bit SWSCLR:1;          /**< \brief [30:30] SW Sticky Clear Bit (w) */
    Ifx_UReg_32Bit reserved_31:1;     /**< \brief [31:31] \internal Reserved */
} Ifx_SRC_SRCR_Bits;

/** \}  */
/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_src_Registers_union
 * \{   */
/** \brief    */
typedef union
{
    Ifx_UReg_32Bit U;                 /**< \brief Unsigned access */
    Ifx_SReg_32Bit I;                 /**< \brief Signed access */
    Ifx_SRC_SRCR_Bits B;              /**< \brief Bitfield access */
} Ifx_SRC_SRCR;

/** \}  */

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_CPU_CPU_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief CPU object */
typedef volatile struct _Ifx_SRC_CPU_CPU
{
       Ifx_SRC_SRCR                        SB;                     /**< \brief 0, CPU${x} Software Breakpoint Service Request*/
} Ifx_SRC_CPU_CPU;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_CPU_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief CPU object */
typedef volatile struct _Ifx_SRC_CPU
{
       Ifx_SRC_CPU_CPU                     CPU[2];                 /**< \brief 0, CPU${x} Software Breakpoint Service Request*/
} Ifx_SRC_CPU;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_CERBERUS_CERBERUS_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief CERBERUS object */
typedef volatile struct _Ifx_SRC_CERBERUS_CERBERUS
{
       Ifx_SRC_SRCR                        SR[2];                  /**< \brief 0, Cerberus Service Request ${y}*/
} Ifx_SRC_CERBERUS_CERBERUS;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_CERBERUS_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief CERBERUS object */
typedef volatile struct _Ifx_SRC_CERBERUS
{
       Ifx_SRC_CERBERUS_CERBERUS           CERBERUS;               /**< \brief 0, */
} Ifx_SRC_CERBERUS;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_ASCLIN_ASCLIN_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief ASCLIN object */
typedef volatile struct _Ifx_SRC_ASCLIN_ASCLIN
{
       Ifx_SRC_SRCR                        TX;                     /**< \brief 0, ASCLIN${x} Transmit Service Request*/
       Ifx_SRC_SRCR                        RX;                     /**< \brief 4, ASCLIN${x} Receive Service Request*/
       Ifx_SRC_SRCR                        ERR;                    /**< \brief 8, ASCLIN${x} Error Service Request*/
} Ifx_SRC_ASCLIN_ASCLIN;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_ASCLIN_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief ASCLIN object */
typedef volatile struct _Ifx_SRC_ASCLIN
{
       Ifx_SRC_ASCLIN_ASCLIN               ASCLIN[12];             /**< \brief 0, ASCLIN${x} Error Service Request*/
} Ifx_SRC_ASCLIN;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_QSPI_QSPI_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief QSPI object */
typedef volatile struct _Ifx_SRC_QSPI_QSPI
{
       Ifx_SRC_SRCR                        TX;                     /**< \brief 0, QSPI${x} Transmit Service Request*/
       Ifx_SRC_SRCR                        RX;                     /**< \brief 4, QSPI${x} Receive Service Request*/
       Ifx_SRC_SRCR                        ERR;                    /**< \brief 8, QSPI${x} Error Service Request*/
       Ifx_SRC_SRCR                        PT;                     /**< \brief C, QSPI${x} Phase Transition Service Request*/
       Ifx_SRC_SRCR                        U;                      /**< \brief 10, QSPI${x} User Defined Service Request*/
} Ifx_SRC_QSPI_QSPI;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_QSPI_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief QSPI object */
typedef volatile struct _Ifx_SRC_QSPI
{
       Ifx_SRC_QSPI_QSPI                   QSPI[4];                /**< \brief 0, QSPI${x} User Defined Service Request*/
} Ifx_SRC_QSPI;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_HSCT_HSCT_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief HSCT object */
typedef volatile struct _Ifx_SRC_HSCT_HSCT
{
       Ifx_SRC_SRCR                        SR;                     /**< \brief 0, HSCT0 Service Request*/
} Ifx_SRC_HSCT_HSCT;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_HSCT_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief HSCT object */
typedef volatile struct _Ifx_SRC_HSCT
{
       Ifx_SRC_HSCT_HSCT                   HSCT[1];                /**< \brief 0, HSCT0 Service Request*/
} Ifx_SRC_HSCT;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_HSSL_HSSL_CH_struct
 * \{  */
/******************************************************************************/
/** \name Object L3
 * \{  */
/** \brief CH object */
typedef volatile struct _Ifx_SRC_HSSL_HSSL_CH
{
       Ifx_SRC_SRCR                        COK;                    /**< \brief 0, HSSL0 Channel ${y} OK Service Request*/
       Ifx_SRC_SRCR                        RDI;                    /**< \brief 4, HSSL0 Channel ${y} Read Data Service Request*/
       Ifx_SRC_SRCR                        ERR;                    /**< \brief 8, HSSL0 Channel ${y} Error Service Request*/
       Ifx_SRC_SRCR                        TRG;                    /**< \brief C, HSSL0 Channel ${y} Trigger Interrupt Service Request*/
} Ifx_SRC_HSSL_HSSL_CH;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_HSSL_HSSL_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief HSSL object */
typedef volatile struct _Ifx_SRC_HSSL_HSSL
{
       Ifx_SRC_HSSL_HSSL_CH                CH[4];                  /**< \brief 0, HSSL0 Channel ${y} Trigger Interrupt Service Request*/
       Ifx_SRC_SRCR                        EXI;                    /**< \brief 40, HSSL${x} Exception Service Request*/
} Ifx_SRC_HSSL_HSSL;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_HSSL_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief HSSL object */
typedef volatile struct _Ifx_SRC_HSSL
{
       Ifx_SRC_HSSL_HSSL                   HSSL[1];                /**< \brief 0, HSSL${x} Exception Service Request*/
} Ifx_SRC_HSSL;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_I2C_I2C_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief I2C object */
typedef volatile struct _Ifx_SRC_I2C_I2C
{
       Ifx_SRC_SRCR                        DTR;                    /**< \brief 0, I2C${x} Data Transfer Request*/
       Ifx_SRC_SRCR                        ERR;                    /**< \brief 4, I2C${x} Error Service Request*/
       Ifx_SRC_SRCR                        P;                      /**< \brief 8, I2C${x} Protocol Service Request*/
       Ifx_UReg_8Bit                       reserved_C[4];          /**< \brief C, \internal Reserved */
} Ifx_SRC_I2C_I2C;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_I2C_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief I2C object */
typedef volatile struct _Ifx_SRC_I2C
{
       Ifx_SRC_I2C_I2C                     I2C[1];                 /**< \brief 0, */
} Ifx_SRC_I2C;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_SENT_SENT_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief SENT object */
typedef volatile struct _Ifx_SRC_SENT_SENT
{
       Ifx_SRC_SRCR                        SR;                     /**< \brief 0, SENT TRIG${x} Service Request*/
} Ifx_SRC_SENT_SENT;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_SENT_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief SENT object */
typedef volatile struct _Ifx_SRC_SENT
{
       Ifx_SRC_SENT_SENT                   SENT[10];               /**< \brief 0, SENT TRIG${x} Service Request*/
} Ifx_SRC_SENT;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_MSC_MSC_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief MSC object */
typedef volatile struct _Ifx_SRC_MSC_MSC
{
       Ifx_SRC_SRCR                        SR[5];                  /**< \brief 0, MSC${x} Service Request ${y}*/
} Ifx_SRC_MSC_MSC;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_MSC_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief MSC object */
typedef volatile struct _Ifx_SRC_MSC
{
       Ifx_SRC_MSC_MSC                     MSC[1];                 /**< \brief 0, */
} Ifx_SRC_MSC;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_CCU6_CCU_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief CCU object */
typedef volatile struct _Ifx_SRC_CCU6_CCU
{
       Ifx_SRC_SRCR                        SR[4];                  /**< \brief 0, CCU${x} Service Request ${y}*/
} Ifx_SRC_CCU6_CCU;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_CCU6_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief CCU6 object */
typedef volatile struct _Ifx_SRC_CCU6
{
       Ifx_SRC_CCU6_CCU                    CCU[2];                 /**< \brief 0, */
} Ifx_SRC_CCU6;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_GPT12_GPT12_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief GPT12 object */
typedef volatile struct _Ifx_SRC_GPT12_GPT12
{
       Ifx_SRC_SRCR                        CIRQ;                   /**< \brief 0, GPT120 CAPREL Service Request*/
       Ifx_SRC_SRCR                        T2;                     /**< \brief 4, GPT120 Timer 2 Service Request*/
       Ifx_SRC_SRCR                        T3;                     /**< \brief 8, GPT120 Timer 3 Service Request*/
       Ifx_SRC_SRCR                        T4;                     /**< \brief C, GPT120 Timer 4 Service Request*/
       Ifx_SRC_SRCR                        T5;                     /**< \brief 10, GPT120 Timer 5 Service Request*/
       Ifx_SRC_SRCR                        T6;                     /**< \brief 14, GPT120 Timer 6 Service Request*/
} Ifx_SRC_GPT12_GPT12;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_GPT12_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief GPT12 object */
typedef volatile struct _Ifx_SRC_GPT12
{
       Ifx_SRC_GPT12_GPT12                 GPT12[1];               /**< \brief 0, GPT120 Timer 6 Service Request*/
} Ifx_SRC_GPT12;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_STM_STM_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief STM object */
typedef volatile struct _Ifx_SRC_STM_STM
{
       Ifx_SRC_SRCR                        SR[2];                  /**< \brief 0, System Timer ${x} Service Request ${y}*/
} Ifx_SRC_STM_STM;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_STM_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief STM object */
typedef volatile struct _Ifx_SRC_STM
{
       Ifx_SRC_STM_STM                     STM[2];                 /**< \brief 0, */
} Ifx_SRC_STM;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_FCE_FCE0_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief FCE0 object */
typedef volatile struct _Ifx_SRC_FCE_FCE0
{
       Ifx_SRC_SRCR                        SR;                     /**< \brief 0, FCE0 Error Service Request*/
} Ifx_SRC_FCE_FCE0;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_FCE_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief FCE object */
typedef volatile struct _Ifx_SRC_FCE
{
       Ifx_SRC_FCE_FCE0                    FCE0;                   /**< \brief 0, FCE0 Error Service Request*/
} Ifx_SRC_FCE;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_DMA_DMA_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief DMA object */
typedef volatile struct _Ifx_SRC_DMA_DMA
{
       Ifx_SRC_SRCR                        ERR[4];                 /**< \brief 0, DMA Error Service Request ${y}*/
       Ifx_UReg_8Bit                       reserved_10[32];        /**< \brief 10, \internal Reserved */
       Ifx_SRC_SRCR                        CH[64];                 /**< \brief 30, DMA Channel  ${y} Service Request*/
} Ifx_SRC_DMA_DMA;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_DMA_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief DMA object */
typedef volatile struct _Ifx_SRC_DMA
{
       Ifx_SRC_DMA_DMA                     DMA[1];                 /**< \brief 0, */
} Ifx_SRC_DMA;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_GETH_GETH_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief GETH object */
typedef volatile struct _Ifx_SRC_GETH_GETH
{
       Ifx_SRC_SRCR                        SR[10];                 /**< \brief 0, GETH Service Request ${y}*/
} Ifx_SRC_GETH_GETH;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_GETH_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief GETH object */
typedef volatile struct _Ifx_SRC_GETH
{
       Ifx_SRC_GETH_GETH                   GETH[1];                /**< \brief 0, */
} Ifx_SRC_GETH;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_CAN_CAN_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief CAN object */
typedef volatile struct _Ifx_SRC_CAN_CAN
{
       Ifx_SRC_SRCR                        INT[16];                /**< \brief 0, CAN${x} Service Request ${y}*/
} Ifx_SRC_CAN_CAN;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_CAN_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief CAN object */
typedef volatile struct _Ifx_SRC_CAN
{
       Ifx_SRC_CAN_CAN                     CAN[2];                 /**< \brief 0, */
} Ifx_SRC_CAN;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_VADC_G_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief G object */
typedef volatile struct _Ifx_SRC_VADC_G
{
       Ifx_SRC_SRCR                        SR0;                    /**< \brief 0, EVADC Group ${x} Service Request ${y}*/
       Ifx_SRC_SRCR                        SR1;                    /**< \brief 4, EVADC Group ${x} Service Request ${y}*/
       Ifx_SRC_SRCR                        SR2;                    /**< \brief 8, EVADC Group ${x} Service Request ${y}*/
       Ifx_SRC_SRCR                        SR3;                    /**< \brief C, EVADC Group ${x} Service Request ${y}*/
} Ifx_SRC_VADC_G;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/



/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_VADC_FC_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief FC object */
typedef volatile struct _Ifx_SRC_VADC_FC
{
       Ifx_SRC_SRCR                        SR0;                    /**< \brief 0, EVADC Fast Compare ${x} Service Request SR0*/
} Ifx_SRC_VADC_FC;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/


/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_VADC_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief VADC object */
typedef volatile struct _Ifx_SRC_VADC
{
       Ifx_SRC_VADC_G                      G[4];                   /**< \brief 0, */
       Ifx_UReg_8Bit                       reserved_40[64];        /**< \brief 40, \internal Reserved */
       Ifx_SRC_VADC_G                      G8;                     /**< \brief 80, */
       Ifx_SRC_VADC_G                      G9;                     /**< \brief 90, */
       Ifx_UReg_8Bit                       reserved_A0[32];        /**< \brief A0, \internal Reserved */
       Ifx_SRC_VADC_FC                     FC[2];                  /**< \brief C0, EVADC Fast Compare ${x} Service Request SR0*/
       Ifx_UReg_8Bit                       reserved_C8[24];        /**< \brief C8, \internal Reserved */
       Ifx_SRC_VADC_G                      CG[2];                  /**< \brief E0, */
} Ifx_SRC_VADC;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_DSADC_DSADC_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief DSADC object */
typedef volatile struct _Ifx_SRC_DSADC_DSADC
{
       Ifx_SRC_SRCR                        SRM;                    /**< \brief 0, DSADC SRM${x} Service Request*/
       Ifx_SRC_SRCR                        SRA;                    /**< \brief 4, DSADC SRA${x} Service Request*/
} Ifx_SRC_DSADC_DSADC;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_DSADC_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief DSADC object */
typedef volatile struct _Ifx_SRC_DSADC
{
       Ifx_SRC_DSADC_DSADC                 DSADC[4];               /**< \brief 0, DSADC SRA${x} Service Request*/
} Ifx_SRC_DSADC;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_ERAY_ERAY_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief ERAY object */
typedef volatile struct _Ifx_SRC_ERAY_ERAY
{
       Ifx_SRC_SRCR                        INT0;                   /**< \brief 0, E-RAY ${x} Service Request 0*/
       Ifx_SRC_SRCR                        INT1;                   /**< \brief 4, E-RAY ${x} Service Request 1*/
       Ifx_SRC_SRCR                        TINT0;                  /**< \brief 8, E-RAY ${x} Timer Interrupt 0 Service Request*/
       Ifx_SRC_SRCR                        TINT1;                  /**< \brief C, E-RAY ${x} Timer Interrupt 1 Service Request*/
       Ifx_SRC_SRCR                        NDAT0;                  /**< \brief 10, E-RAY ${x} New Data 0 Service Request*/
       Ifx_SRC_SRCR                        NDAT1;                  /**< \brief 14, E-RAY ${x} New Data 1 Service Request*/
       Ifx_SRC_SRCR                        MBSC0;                  /**< \brief 18, E-RAY ${x} Message Buffer Status Changed 0 Service Request*/
       Ifx_SRC_SRCR                        MBSC1;                  /**< \brief 1C, E-RAY ${x} Message Buffer Status Changed 1 Service Request*/
       Ifx_SRC_SRCR                        OBUSY;                  /**< \brief 20, E-RAY ${x} Output Buffer Busy*/
       Ifx_SRC_SRCR                        IBUSY;                  /**< \brief 24, E-RAY ${x} Input Buffer Busy*/
       Ifx_UReg_8Bit                       reserved_28[8];         /**< \brief 28, \internal Reserved */
} Ifx_SRC_ERAY_ERAY;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_ERAY_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief ERAY object */
typedef volatile struct _Ifx_SRC_ERAY
{
       Ifx_SRC_ERAY_ERAY                   ERAY[1];                /**< \brief 0, */
} Ifx_SRC_ERAY;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_HSM_HSM_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief HSM object */
typedef volatile struct _Ifx_SRC_HSM_HSM
{
       Ifx_SRC_SRCR                        HSM[2];                 /**< \brief 0, HSM Service Request ${y}*/
} Ifx_SRC_HSM_HSM;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_HSM_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief HSM object */
typedef volatile struct _Ifx_SRC_HSM
{
       Ifx_SRC_HSM_HSM                     HSM[1];                 /**< \brief 0, */
} Ifx_SRC_HSM;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_SCU_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief SCU object */
typedef volatile struct _Ifx_SRC_SCU
{
       Ifx_SRC_SRCR                        SCUERU[4];              /**< \brief 0, SCU ERU Service Request ${x}*/
} Ifx_SRC_SCU;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_PMS_PMS_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief PMS object */
typedef volatile struct _Ifx_SRC_PMS_PMS
{
       Ifx_SRC_SRCR                        SR;                     /**< \brief 0, Power Management System Service Request ${x}*/
} Ifx_SRC_PMS_PMS;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_PMS_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief PMS object */
typedef volatile struct _Ifx_SRC_PMS
{
       Ifx_SRC_PMS_PMS                     PMS[4];                 /**< \brief 0, Power Management System Service Request ${x}*/
} Ifx_SRC_PMS;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_SMU_SMU_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief SMU object */
typedef volatile struct _Ifx_SRC_SMU_SMU
{
       Ifx_SRC_SRCR                        SR[3];                  /**< \brief 0, SMU Service Request ${y}*/
} Ifx_SRC_SMU_SMU;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_SMU_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief SMU object */
typedef volatile struct _Ifx_SRC_SMU
{
       Ifx_SRC_SMU_SMU                     SMU[1];                 /**< \brief 0, */
} Ifx_SRC_SMU;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_PSI5_PSI5_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief PSI5 object */
typedef volatile struct _Ifx_SRC_PSI5_PSI5
{
       Ifx_SRC_SRCR                        SR[8];                  /**< \brief 0, PSI5 Service Request ${y}*/
} Ifx_SRC_PSI5_PSI5;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_PSI5_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief PSI5 object */
typedef volatile struct _Ifx_SRC_PSI5
{
       Ifx_SRC_PSI5_PSI5                   PSI5[1];                /**< \brief 0, */
} Ifx_SRC_PSI5;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_PSI5S_PSI5S_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief PSI5S object */
typedef volatile struct _Ifx_SRC_PSI5S_PSI5S
{
       Ifx_SRC_SRCR                        SR[8];                  /**< \brief 0, PSI5-S Service Request ${y}*/
} Ifx_SRC_PSI5S_PSI5S;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_PSI5S_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief PSI5S object */
typedef volatile struct _Ifx_SRC_PSI5S
{
       Ifx_SRC_PSI5S_PSI5S                 PSI5S[1];               /**< \brief 0, */
} Ifx_SRC_PSI5S;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_GPSR_GPSR_struct
 * \{  */
/******************************************************************************/
/** \name Object L2
 * \{  */
/** \brief GPSR object */
typedef volatile struct _Ifx_SRC_GPSR_GPSR
{
       Ifx_SRC_SRCR                        SR[8];                  /**< \brief 0, General Purpose Group ${x} Service Request ${y}*/
} Ifx_SRC_GPSR_GPSR;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/******************************************************************************/
/** \addtogroup IfxSfr_Src_GPSR_struct
 * \{  */
/******************************************************************************/
/** \name Object L1
 * \{  */
/** \brief GPSR object */
typedef volatile struct _Ifx_SRC_GPSR
{
       Ifx_SRC_GPSR_GPSR                   GPSR[2];                /**< \brief 0, */
} Ifx_SRC_GPSR;
/** \}  */
/******************************************************************************/
/** \}  */
/******************************************************************************/
/******************************************************************************/

/******************************************************************************/
/** \addtogroup IfxSfr_Src_Registers_struct
 * \{  */
/******************************************************************************/
/** \name Object L0
 * \{  */

/** \brief SRC object */
typedef volatile struct _Ifx_SRC
{
       Ifx_SRC_CPU                         CPU;                    /**< \brief 0, */
       Ifx_UReg_8Bit                       reserved_8[24];         /**< \brief 8, \internal Reserved */
       Ifx_SRC_SRCR                        SBCU;                   /**< \brief 20, SBCU Service Request (SPB Bus Control Unit)*/
       Ifx_UReg_8Bit                       reserved_24[12];        /**< \brief 24, \internal Reserved */
       Ifx_SRC_SRCR                        XBAR0;                  /**< \brief 30, SRI Domain 0 Service Request*/
       Ifx_UReg_8Bit                       reserved_34[12];        /**< \brief 34, \internal Reserved */
       Ifx_SRC_CERBERUS                    CERBERUS;               /**< \brief 40, */
       Ifx_UReg_8Bit                       reserved_48[8];         /**< \brief 48, \internal Reserved */
       Ifx_SRC_ASCLIN                      ASCLIN;                 /**< \brief 50, */
       Ifx_UReg_8Bit                       reserved_E0[12];        /**< \brief E0, \internal Reserved */
       Ifx_SRC_SRCR                        MTUDONE;                /**< \brief EC, MTU Done Service Request*/
       Ifx_SRC_QSPI                        QSPI;                   /**< \brief F0, */
       Ifx_UReg_8Bit                       reserved_140[64];       /**< \brief 140, \internal Reserved */
       Ifx_SRC_HSCT                        HSCT;                   /**< \brief 180, */
       Ifx_UReg_8Bit                       reserved_184[12];       /**< \brief 184, \internal Reserved */
       Ifx_SRC_HSSL                        HSSL;                   /**< \brief 190, */
       Ifx_UReg_8Bit                       reserved_1D4[76];       /**< \brief 1D4, \internal Reserved */
       Ifx_SRC_I2C                         I2C;                    /**< \brief 220, */
       Ifx_UReg_8Bit                       reserved_230[16];       /**< \brief 230, \internal Reserved */
       Ifx_SRC_SENT                        SENT;                   /**< \brief 240, */
       Ifx_UReg_8Bit                       reserved_268[8];        /**< \brief 268, \internal Reserved */
       Ifx_SRC_MSC                         MSC;                    /**< \brief 270, */
       Ifx_UReg_8Bit                       reserved_284[60];       /**< \brief 284, \internal Reserved */
       Ifx_SRC_CCU6                        CCU6;                   /**< \brief 2C0, */
       Ifx_SRC_GPT12                       GPT12;                  /**< \brief 2E0, */
       Ifx_UReg_8Bit                       reserved_2F8[8];        /**< \brief 2F8, \internal Reserved */
       Ifx_SRC_STM                         STM;                    /**< \brief 300, */
       Ifx_UReg_8Bit                       reserved_310[32];       /**< \brief 310, \internal Reserved */
       Ifx_SRC_FCE                         FCE;                    /**< \brief 330, */
       Ifx_UReg_8Bit                       reserved_334[12];       /**< \brief 334, \internal Reserved */
       Ifx_SRC_DMA                         DMA;                    /**< \brief 340, */
       Ifx_UReg_8Bit                       reserved_470[272];      /**< \brief 470, \internal Reserved */
       Ifx_SRC_GETH                        GETH;                   /**< \brief 580, */
       Ifx_UReg_8Bit                       reserved_5A8[8];        /**< \brief 5A8, \internal Reserved */
       Ifx_SRC_CAN                         CAN;                    /**< \brief 5B0, */
       Ifx_UReg_8Bit                       reserved_630[64];       /**< \brief 630, \internal Reserved */
       Ifx_SRC_VADC                        VADC;                   /**< \brief 670, */
       Ifx_SRC_DSADC                       DSADC;                  /**< \brief 770, */
       Ifx_UReg_8Bit                       reserved_790[112];      /**< \brief 790, \internal Reserved */
       Ifx_SRC_ERAY                        ERAY;                   /**< \brief 800, */
       Ifx_UReg_8Bit                       reserved_830[48];       /**< \brief 830, \internal Reserved */
       Ifx_SRC_SRCR                        DMUHOST;                /**< \brief 860, DMU Host Service Request*/
       Ifx_SRC_SRCR                        DMUFSI;                 /**< \brief 864, DMU FSI Service Request*/
       Ifx_UReg_8Bit                       reserved_868[8];        /**< \brief 868, \internal Reserved */
       Ifx_SRC_HSM                         HSM;                    /**< \brief 870, */
       Ifx_UReg_8Bit                       reserved_878[8];        /**< \brief 878, \internal Reserved */
       Ifx_SRC_SCU                         SCU;                    /**< \brief 880, */
       Ifx_UReg_8Bit                       reserved_890[28];       /**< \brief 890, \internal Reserved */
       Ifx_SRC_SRCR                        PMSDTS;                 /**< \brief 8AC, PMS DTS Service Request*/
       Ifx_SRC_PMS                         PMS;                    /**< \brief 8B0, */
       Ifx_SRC_SRCR                        SCR;                    /**< \brief 8C0, Stand By Controller Service Request*/
       Ifx_UReg_8Bit                       reserved_8C4[12];       /**< \brief 8C4, \internal Reserved */
       Ifx_SRC_SMU                         SMU;                    /**< \brief 8D0, */
       Ifx_UReg_8Bit                       reserved_8DC[4];        /**< \brief 8DC, \internal Reserved */
       Ifx_SRC_PSI5                        PSI5;                   /**< \brief 8E0, */
       Ifx_UReg_8Bit                       reserved_900[80];       /**< \brief 900, \internal Reserved */
       Ifx_SRC_PSI5S                       PSI5S;                  /**< \brief 950, */
       Ifx_UReg_8Bit                       reserved_970[32];       /**< \brief 970, \internal Reserved */
       Ifx_SRC_GPSR                        GPSR;                   /**< \brief 990, */
       Ifx_UReg_8Bit                       reserved_9D0[160];      /**< \brief 9D0, \internal Reserved */
       Ifx_SRC_SRCR                        GTM_AEIIRQ;             /**< \brief A70, AEI Shared Service Request*/
       Ifx_SRC_SRCR                        GTM_ARUIRQ[3];          /**< \brief A74, ARU Shared Service Request ${w}*/
       Ifx_SRC_SRCR                        GTM_BRCIRQ;             /**< \brief A80, BRC Shared Service Request*/
       Ifx_SRC_SRCR                        GTM_CMBIRQ;             /**< \brief A84, CMP Shared Service Request*/
       Ifx_SRC_SRCR                        GTM_SPEIRQ[2];          /**< \brief A88, SPE${w} Shared Service Request*/
       Ifx_UReg_8Bit                       reserved_A90[16];       /**< \brief A90, \internal Reserved */
       Ifx_SRC_SRCR                        GTM_PSM[1][8];          /**< \brief AA0, */
       Ifx_UReg_8Bit                       reserved_AC0[64];       /**< \brief AC0, \internal Reserved */
       Ifx_SRC_SRCR                        GTM_DPLL[27];           /**< \brief B00, DPLL Service Request ${w}*/
       Ifx_UReg_8Bit                       reserved_B6C[4];        /**< \brief B6C, \internal Reserved */
       Ifx_SRC_SRCR                        GTM_ERR;                /**< \brief B70, Error Service Request*/
       Ifx_UReg_8Bit                       reserved_B74[28];       /**< \brief B74, \internal Reserved */
       Ifx_SRC_SRCR                        GTM_TIM[3][8];          /**< \brief B90, */
       Ifx_UReg_8Bit                       reserved_BF0[192];      /**< \brief BF0, \internal Reserved */
       Ifx_SRC_SRCR                        GTM_MCS[3][8];          /**< \brief CB0, */
       Ifx_UReg_8Bit                       reserved_D10[256];      /**< \brief D10, \internal Reserved */
       Ifx_SRC_SRCR                        GTM_TOM[2][8];          /**< \brief E10, */
       Ifx_UReg_8Bit                       reserved_E50[160];      /**< \brief E50, \internal Reserved */
       Ifx_SRC_SRCR                        GTM_ATOM[4][4];         /**< \brief EF0, */
       Ifx_UReg_8Bit                       reserved_F30[160];      /**< \brief F30, \internal Reserved */
       Ifx_SRC_SRCR                        GTM_MCSW[10];           /**< \brief FD0, GTM Multi Channel Sequencer Service Request ${w}*/
       Ifx_UReg_8Bit                       reserved_FF8[4104];     /**< \brief FF8, \internal Reserved */
} Ifx_SRC;

/** \}  */
/******************************************************************************/
/** \}  */


/******************************************************************************/

/******************************************************************************/

#endif /* IFXSRC_REGDEF_H */
