#include "eeprom.h"

void EEPROM_Update_All_Para(void)
{
    flash_buffer_clear();
    flash_read_page_to_buffer(FLASH_SECTION_INDEX, FLASH_PAGE_INDEX);
    motor_l.p=flash_union_buffer[speed_para_set*para_num+motor_l_p].float_type;
    motor_l.i=flash_union_buffer[speed_para_set*para_num+motor_l_i].float_type;
    motor_l.d=flash_union_buffer[speed_para_set*para_num+motor_l_d].float_type;
    motor_r.p=flash_union_buffer[speed_para_set*para_num+motor_r_p].float_type;
    motor_r.i=flash_union_buffer[speed_para_set*para_num+motor_r_i].float_type;
    motor_r.d=flash_union_buffer[speed_para_set*para_num+motor_r_d].float_type;
    dir_p_set=flash_union_buffer[speed_para_set*para_num+dir_p].float_type;
    dir.p=dir_p_set;
    dir.i=flash_union_buffer[speed_para_set*para_num+dir_i].float_type;
    dir.d=flash_union_buffer[speed_para_set*para_num+dir_d].float_type;
    kp2=flash_union_buffer[speed_para_set*para_num+dir_kp2].float_type;
    gkd=flash_union_buffer[speed_para_set*para_num+dir_gkd].float_type;
    dir_error_k=flash_union_buffer[speed_para_set*para_num+para_error_k].float_type;
    dynamic_p_coef=flash_union_buffer[speed_para_set*para_num+para_dynamic_p_coef].float_type;
    dynamic_frontsight=flash_union_buffer[speed_para_set*para_num+para_dynamic_frontsight].float_type;
    round_p1_decrease=flash_union_buffer[speed_para_set*para_num+para_round_p1_decrease].float_type;
    round_p2_decrease=flash_union_buffer[speed_para_set*para_num+para_round_p2_decrease].float_type;
    round_size_set=flash_union_buffer[speed_para_set*para_num+para_round_size].uint16_type;
    start_row_set=flash_union_buffer[speed_para_set*para_num+para_startrow].uint8_type;
    down_round_speed=flash_union_buffer[speed_para_set*para_num+para_down_round_speed].uint8_type;
}

float EEPROM_Read_Data(parameter para)
{
    flash_buffer_clear();
    flash_read_page_to_buffer(FLASH_SECTION_INDEX, FLASH_PAGE_INDEX);
    return flash_union_buffer[para].float_type;
}

void EEPROM_Write_Data(parameter para, float data)
{
    flash_buffer_clear();
    flash_read_page_to_buffer(FLASH_SECTION_INDEX, FLASH_PAGE_INDEX);
    flash_union_buffer[para].float_type=data;
    flash_write_page_from_buffer(FLASH_SECTION_INDEX, FLASH_PAGE_INDEX);
}

void EEPROM_Write_Data_uint16(parameter para, uint16 data)
{
    flash_buffer_clear();
    flash_read_page_to_buffer(FLASH_SECTION_INDEX, FLASH_PAGE_INDEX);
    flash_union_buffer[para].uint16_type=data;
    flash_write_page_from_buffer(FLASH_SECTION_INDEX, FLASH_PAGE_INDEX);
}
