#ifndef __DEVICE_H__
#define __DEVICE_H__

#include "zf_common_headfile.h"

//ư棬LED

//ö
typedef enum
{
    key1,key2,key3,key4,nokey
}Key_enum;

//״̬ö
typedef enum
{
    idle,           //δ
    maypress,       //ܰ
    press,          //ȷ
    release         //ͷ
}Key_State_enum;

typedef enum
{
    speed_120,
    speed_135,
    speed_150,
    speed_160,
    speed_170,
    speed_180,
    speed_190,
    speed_200,
    speed_210,
    speed_220,
    speed_230,
    speed_240,
    speed_idle
}Speed_enum;

typedef enum
{
    page_main,page_setting,page_pid_choose,page_value_set
}Menu_enum;

typedef enum
{
    menu_motor_l,menu_motor_r,menu_dir,
    menu_gkd,menu_error_k,menu_error_b,
    menu_bldc,menu_speedup,
    menu_dynamic_frontsight,menu_dynamic_p_coef,menu_round_p1_decrease,menu_round_p2_decrease,
    menu_round_size,menu_startrow,menu_down_round_speed,
    menu_para_count
}Menu_Para_enum;

typedef enum
{
    menu_p,menu_i,menu_d,
    menu_pid_count
}Menu_PID_enum;


//Ŷ
#define LED_PIN             (P00_12)        //LED
#define BUZZER_PIN          (P33_3)         //
#define LIGHT_PIN           (P13_1)         //ư
#define KEY1                (P11_11)        //
#define KEY2                (P11_9)
#define KEY3                (P13_2)
#define KEY4                (P13_0)

//豸غ01
#define LED(x)              (gpio_set_level(LED_PIN, (!x)))
#define BUZZER(x)           (gpio_set_level(BUZZER_PIN, (x)))
#define LIGHT(x)            (gpio_set_level(LIGHT_PIN, (x)))
#define DEVICE_TOGGLE(x)    (gpio_toggle_level(x))



extern Key_enum key_press;
extern float gyro_z;
extern Speed_enum speed_para_set;
extern Menu_enum menu;
extern Menu_Para_enum menu_para;
extern Menu_PID_enum menu_pid;
extern float menu_offset;
extern uint8 menu_update_flag;
extern uint16 round_size_set;
extern uint8 round_size;
extern uint16 round_size_full;

//ʼ
void Led_Init(void);
void Buzzer_Init(void);
void Light_Init(void);
void Key_Init(void);
void Menu_Update(void);
void Menu_Display(void);


//
void Key_Scan(void);


//ȡzٶ
void Get_Gyro_Z(void);

//ٶȶӦ
void Speed_Para_Update(void);


#endif
