学习不走弯路，[关注公众号](#公众号) 回复「学习路线」，获取mall项目专属学习路线！

# 推荐一个项目管理工具，落地基于Scrum的敏捷开发！

> 作为一个开发人员，我们也该懂一些项目管理的知识，今天我们来讲一个基于Scrum的项目管理工具`禅道`。本文将从禅道的安装部署开始讲起，然后讲讲Scrum的核心概念，最后通过禅道的一套操作来实践下Scrum的开发流程。

## 禅道简介

禅道由青岛易软天创网络科技有限公司开发，国产开源项目管理软件。它集产品管理、项目管理、质量管理、文档管理、组织管理和事务管理于一体，是一款专业的研发项目管理软件，完整覆盖了研发项目管理的核心流程。禅道项目管理软件的主要管理思想基于国际流行的敏捷项目管理方法—Scrum。Scrum方法注重实效，操作性强，非常适合软件研发项目的快速迭代开发。禅道在遵循其管理方式基础上，结合国内研发现状，整合了Bug管理，测试用例管理，发布管理，文档管理等功能，完整的覆盖了软件研发项目的整个生命周期。

## 安装及部署

> 禅道的安装方式有很多，这里我们使用它在Docker环境下的安装方式。

- 下载禅道的Docker镜像：

```bash
docker pull idoop/zentao:latest
```

- 在Docker容器中运行禅道：

```bash
docker run -d -p 80:80 -p 4306:3306 --name zentao-server \
        -e ADMINER_USER="admin" -e ADMINER_PASSWD="123456" \
        -e BIND_ADDRESS="false" \
        -v /mydata/zbox/:/opt/zbox/ \
        --add-host smtp.exmail.qq.com:163.177.90.125 \
        -d idoop/zentao:latest
```

- 启动参数说明：
    - ADMINER_USER：管理员账号；
    - ADMINER_PASSWD：管理员密码；
    - BIND_ADDRESS：若设置参数为"false"，禅道数据库启动后允许远程访问,选填；
    - SMTP_HOST：设置smtp服务IP和主机名，用于解决无法发送邮件的问题。

- 安装成功后，访问该地址即可登录禅道系统，登录用户名和密码为`admin:123456`：http://192.168.6.132/

![](../images/zentao_use_01.png)

## Scrum的核心概念

### 敏捷开发的产生

我们比较熟知的软件项目管理方法是瀑布，其基本流程是需求->设计->开发->测试。基本假设只要每个环节都做正确，那么终得到的结果也是正确的。但从总体来讲，瀑布项目失败率比较高。国外的软件先行者们针对瀑布开发中暴露出来的问题进行了一系列的探索、思考和总结，最终提出了敏捷开发的概念。敏捷开发有很多种方式，其中Scrum是比较流行的一种。

### Scrum中的角色

Scrum是由产品经理(product owner)、项目经理(scrum master)和研发团队(dev team)组成的。

- 其中产品经理负责整理用户故事(user story)，定义其商业价值，对其进行排序，制定发布计划，对产品负责；
- 项目经理负责召开各种会议，协调项目，为研发团队服务；
- 研发团队则由不同技能的成员组成，通过紧密协同，完成每一次迭代的目标，交付产品。 

这里我们讲下什么是用户故事：所谓用户故事，就是来描述一件事情，作为什么用户，希望如何，这样做的目的或者价值何在，这样有用户角色，有行为，也有目的和价值所在，非常方便与团队成员进行沟通。

### Scrum中的迭代开发

与瀑布不同，Scrum将产品的开发分解为若干个小迭代(sprint)，其周期从1周到4周不等，但不会超过4周。
参与的团队成员一般是5到9人，每期迭代要完成的用户故事是固定的，每次迭代会产生一定的交付。

### Scrum的基本流程

![](../images/zentao_use_02.png)

Scrum的基本流程如上图所示：

- 产品经理负责整理用户故事，形成左侧的产品订单(product backlog)；
- 发布计划会议：项目经理负责讲解用户故事，对其进行估算和排序，发布计划会议的产出就是制定出这一期迭代要完成的用户故事列表，即迭代订单(sprint backlog)；
- 迭代计划会议：项目团队对每一个用户故事进行任务分解，分解的标准是完成该用户故事的所有任务，最终每个任务都有明确的负责人，并完成工时的初估计；
- 每日例会：每天项目经理召集站立会议，团队成员回答昨天做了什么，今天计划做什么，遇到了什么问题；
- 演示会议：迭代结束之后，召开演示会议，相关人员都受邀参加，团队负责向大家展示本次迭代取得的成果。期间大家的反馈记录下来，由产品经理整理，形成新的用户故事；
- 回顾会议：项目团队对本期迭代进行总结，发现不足，制定改进计划，下一次迭代继续改进，已达到持续改进的效果。

## 禅道使用

> 接下来我们将按角色来讲讲如何使用禅道来实现基于Scrum的项目管理。

### 管理员

> 禅道安装成功之后，管理员的第一件要做的事情就是设置部门结构，并添加用户账号。

- 通过`组织->用户->维护部门`可以为企业添加部门结构：

![](../images/zentao_use_03.png)

- 通过`组织->用户->添加用户`可以为企业添加用户：

![](../images/zentao_use_04.png)

- 注意添加用户是需要添加职位和权限分组的：

![](../images/zentao_use_05.png)

- 这里我们添加了产品经理、项目经理、研发主管、测试主管四个账号以便下面使用。

![](../images/zentao_use_06.png)

### 产品经理

> 产品经理对于公司来讲，至关重要。只有做出好的产品或者服务出来，才能赢得市场，谋求发展和生存。
下面我们用产品经理的账号登录，来演示下产品经理在敏捷开发中所要做的事情。

- 通过产品左上角的下拉菜单可以添加产品：

![](../images/zentao_use_07.png)

- 添加产品时需要完善相关信息：

![](../images/zentao_use_08.png)

- 添加完产品后产品经理可以通过`产品->需求->维护模块`来创建产品的模块：

![](../images/zentao_use_09.png)

- 在相应模块中通过`产品->需求->提需求`可以创建需求：

![](../images/zentao_use_10.png)

- 之后可以完善需求的信息并进行创建：

![](../images/zentao_use_11.png)

- 创建完需求后还需要对需求进行评审操作，只有评审通过的需求才会由项目经理进行任务分解，从而转为为开发任务指派给开发团队：

![](../images/zentao_use_12.png)

- 评审时选择评审结果为确认通过后该需求就会被激活了：

![](../images/zentao_use_13.png)

- 当然产品经理也可以对当前的需求进行变更操作，但是变更完的需求需要开发团队确认后才能进行后续开发；

![](../images/zentao_use_14.png)

- 产品经理还可以创建计划，规定需求的完成时间：

![](../images/zentao_use_15.png)

- 完善计划信息时，主要是要完善计划的开始和截止时间：

![](../images/zentao_use_16.png)

- 可以通过关联需求，指定此次产品计划需要完成的需求：

![](../images/zentao_use_17.png)

### 项目经理

> 项目经理主要负责管理开发团队，将产品经理的需求讲解给开发团队听，确定项目要完成的需求列表，对需求进行任务分解并指派给开发团队，以及各种会议的组织。下面我们用项目经理的账号登录，来演示下项目经理在敏捷开发中所要做的事情。

- 在禅道中项目其实对应的是敏捷开发里面的迭代的概念，项目经理首先需要创建一个项目：

![](../images/zentao_use_18.png)

- 创建时需要完善项目信息，设定项目开发时间以及关联相关产品与计划：

![](../images/zentao_use_19.png)

- 接下来项目经理要做的就是创建项目团队，可以通过`项目->团队->团队管理`来为项目团队添加成员：

![](../images/zentao_use_20.png)

- 项目团队组建完毕之后，项目经理通过关联产品即可将项目和产品进行关联：

![](../images/zentao_use_21.png)

- 然后通过关联需求即可确定当前项目要做的需求，可以选择关联需求或按计划关联需求：

![](../images/zentao_use_22.png)

- 需求确定之后，项目中几个关键的因素都有了：周期确定、资源确定、需求确定。下面项目经理要做的事情就是为每一个需求做任务分解：

![](../images/zentao_use_23.png)

- 任务分解时需要完善任务详情，明确任务的执行时间：

![](../images/zentao_use_24.png)

- 这里把商品管理功能这个需求分解为了商品列表、添加商品和编辑商品三个任务并指派给了开发人员。

![](../images/zentao_use_25.png)

### 开发团队

> 项目的任务分解完毕之后，开发团队成员需要领取自己的任务，开始每天的开发。除了日常的编码工作之外，还应当每天花点时间在禅道里面更新下任务的状态以及消耗情况。下面我们用开发人员的账号登录，来演示下开发人员在敏捷开发中所要做的事情。

- 首先开发人员需要找到自己需要完成的任务，从`项目->任务`中可以查看到指派给自己的任务：

![](../images/zentao_use_26.png)

- 开发人员开始做任务时点击开始按钮，完成任务时点击完成按钮：

![](../images/zentao_use_27.png)

- 任务开始时需要填写自己的预计剩余时间，最初预计工时可以在编辑任务里设置：

![](../images/zentao_use_28.png)

- 任务完成时需要填写自己的本次消耗时间：

![](../images/zentao_use_29.png)

- 物理介质的看板比较直观，是Scrum标准的管理工具，禅道里面也有一个电子看板：

![](../images/zentao_use_30.png)

- 当项目的任务都完成以后，开发人员可以创建版本：

![](../images/zentao_use_31.png)

- 完善完版本信息后即可创建版本：

![](../images/zentao_use_32.png)

- 有了版本以后，才可以根据当前版本创建测试单：

![](../images/zentao_use_33.png)

- 创建测试单需要完善版本、负责人、名称等信息：

![](../images/zentao_use_34.png)

### 测试团队

> 测试团队是项目质量的保证，测试团队主要负责对项目的版本进行测试，提出Bug指派给开发人员，开发人员解决Bug后对Bug进行验证并关闭。下面我们用测试人员的账号登录，来演示下测试人员在敏捷开发中所要做的事情。

- 测试人员开始测试时，需要把测试单状态设置为进行中：

![](../images/zentao_use_35.png)

- 测试人员可以在`测试->Bug`中提出测试过程中发现的Bug：

![](../images/zentao_use_36.png)

- 需要完善BUG信息并指派给相应开发人员：

![](../images/zentao_use_37.png)

- 当开发人员解决完Bug后可以把Bug标记为已经解决：

![](../images/zentao_use_38.png)

- 此时该Bug会自动指派给测试人员，测试人员确认已经解决后可以关闭该问题，如未解决，可以激活该问题。

![](../images/zentao_use_39.png)

## 总结

我们通过在禅道里面的一系列操作完整地演示了一套基于Scrum敏捷开发流程，其实所有角色的职责可以用下图来概况。

![](../images/zentao_use_40.png)

## 参考资料

更多资料可以参考官方文档：https://www.zentao.net/book/zentaopmshelp/38.html

## 公众号

![公众号图片](http://macro-oss.oss-cn-shenzhen.aliyuncs.com/mall/banner/qrcode_for_macrozheng_258.jpg)
