# mall学习教程
<p>
    <a href="#公众号"><img src="http://macro-oss.oss-cn-shenzhen.aliyuncs.com/mall/badge/%E5%85%AC%E4%BC%97%E5%8F%B7-macrozheng-blue.svg" alt="公众号"></a>
    <a href="#公众号"><img src="http://macro-oss.oss-cn-shenzhen.aliyuncs.com/mall/badge/%E4%BA%A4%E6%B5%81-%E5%BE%AE%E4%BF%A1%E7%BE%A4-2BA245.svg" alt="交流"></a>
    <a href="https://github.com/macrozheng/mall"><img src="http://macro-oss.oss-cn-shenzhen.aliyuncs.com/mall/badge/%E5%90%8E%E5%8F%B0%E9%A1%B9%E7%9B%AE-mall-blue.svg" alt="后台项目"></a>
    <a href="https://github.com/macrozheng/mall-admin-web"><img src="http://macro-oss.oss-cn-shenzhen.aliyuncs.com/mall/badge/%E5%89%8D%E7%AB%AF%E9%A1%B9%E7%9B%AE-mall--admin--web-green.svg" alt="前端项目"></a>
    <a href="https://github.com/macrozheng/mall-swarm"><img src="http://macro-oss.oss-cn-shenzhen.aliyuncs.com/mall/badge/Cloud%E7%89%88%E6%9C%AC-mall--swarm-brightgreen.svg" alt="SpringCloud版本"></a>
</p>

## 简介

mall学习教程，架构、业务、技术要点全方位解析。mall项目（60k+star）是一套电商系统，使用现阶段主流技术实现。涵盖了SpringBoot、MyBatis、Elasticsearch、RabbitMQ、Redis、MongoDB、MySQL等技术，采用Docker容器化部署。

## 教程网站

- 文档教程：[https://www.macrozheng.com](https://www.macrozheng.com)
- 视频教程：[https://www.macrozheng.com/video/](https://www.macrozheng.com/video/)

## 项目地址

### Github

- 后端项目：[https://github.com/macrozheng/mall](https://github.com/macrozheng/mall)
- 后台管理系统项目：[https://github.com/macrozheng/mall-admin-web](https://github.com/macrozheng/mall-admin-web)
- 前台商城项目：[https://github.com/macrozheng/mall-app-web](https://github.com/macrozheng/mall-app-web)
- mall学习教程示例代码：[https://github.com/macrozheng/mall-learning](https://github.com/macrozheng/mall-learning)

### Gitee

- 后端项目：[https://gitee.com/macrozheng/mall](https://gitee.com/macrozheng/mall)
- 后台管理系统项目：[https://gitee.com/macrozheng/mall-admin-web](https://gitee.com/macrozheng/mall-admin-web)
- 前台商城项目：[https://gitee.com/macrozheng/mall-app-web](https://gitee.com/macrozheng/mall-app-web)
- mall学习教程示例代码：[https://gitee.com/macrozheng/mall-learning](https://gitee.com/macrozheng/mall-learning)

## 序章

> 对mall项目的架构、业务及学习思路进行介绍。

- [mall项目架构及功能概览](https://www.macrozheng.com/mall/foreword/mall_foreword_01.html)
- [mall项目核心功能演示](https://www.macrozheng.com/mall/foreword/mall_foreword_02.html)
- [mall项目学习所需知识点](https://www.macrozheng.com/mall/foreword/mall_foreword_03.html)
- [mall项目学习思路及课程介绍](https://www.macrozheng.com/mall/foreword/mall_foreword_04.html)

## 快速开始

> 对mall项目的前后端开发环境搭建进行讲解。

- [mall项目后端开发环境搭建](https://www.macrozheng.com/mall/start/mall_deploy_windows.html)
- [mall项目前端开发环境搭建](https://www.macrozheng.com/mall/start/mall_deploy_web.html)

## 架构篇

> 循序渐进带大家搭建一个mall项目在使用的脚手架，学习主流Java技术栈。涵盖SpringBoot、MyBatis、Lombok、Hutool、Swagger、Redis、SpringSecurity、Elasticsearch、MongoDB、RabbitMQ、MinIO等技术。

- [mall项目架构篇介绍](https://www.macrozheng.com/mall/architect/mall_arch_overview.html)
- [mall整合SpringBoot+MyBatis搭建基本骨架](https://www.macrozheng.com/mall/architect/mall_arch_01.html)
- [mall整合Swagger-UI实现在线API文档](https://www.macrozheng.com/mall/architect/mall_arch_02.html)
- [mall整合Redis实现缓存功能](https://www.macrozheng.com/mall/architect/mall_arch_03.html)
- [mall整合SpringSecurity和JWT实现认证和授权（一）](https://www.macrozheng.com/mall/architect/mall_arch_04.html)
- [mall整合SpringSecurity和JWT实现认证和授权（二）](https://www.macrozheng.com/mall/architect/mall_arch_05.html)
- [mall整合SpringTask实现定时任务](https://www.macrozheng.com/mall/architect/mall_arch_06.html)
- [mall整合Elasticsearch实现商品搜索](https://www.macrozheng.com/mall/architect/mall_arch_07.html)
- [mall整合Mongodb实现文档操作](https://www.macrozheng.com/mall/architect/mall_arch_08.html)
- [mall整合RabbitMQ实现延迟消息](https://www.macrozheng.com/mall/architect/mall_arch_09.html)
- [mall整合OSS实现文件上传](https://www.macrozheng.com/mall/architect/mall_arch_10.html)

## 业务篇

> mall项目电商业务与技术实现全方位解析，涵盖权限模块、商品模块、订单模块、营销模块、会员模块的解析。

- [mall项目后台管理系统业务介绍](https://www.macrozheng.com/mall/database/mall_business_overview.html)
- [mall项目前台商城系统业务介绍](https://www.macrozheng.com/mall/database/mall_business_app_overview.html)
- [mall项目开发设计思路](https://www.macrozheng.com/mall/database/mall_dev_design.html)
- [权限模块数据库表解析](https://www.macrozheng.com/mall/database/mall_ums_01.html)
- [商品模块数据库表解析（一）](https://www.macrozheng.com/mall/database/mall_pms_01.html)
- [商品模块数据库表解析（二）](https://www.macrozheng.com/mall/database/mall_pms_02.html)
- [订单模块数据库表解析（一）](https://www.macrozheng.com/mall/database/mall_oms_01.html)
- [订单模块数据库表解析（二）](https://www.macrozheng.com/mall/database/mall_oms_02.html)
- [订单模块数据库表解析（三）](https://www.macrozheng.com/mall/database/mall_oms_03.html)
- [营销模块数据库表解析（一）](https://www.macrozheng.com/mall/database/mall_sms_01.html)
- [营销模块数据库表解析（二）](https://www.macrozheng.com/mall/database/mall_sms_02.html)
- [营销模块数据库表解析（三）](https://www.macrozheng.com/mall/database/mall_sms_03.html)
- [权限管理功能设计与优化](https://www.macrozheng.com/mall/database/mall_permission.html)

## 部署篇

> 实现mall项目的Docker容器化部署和Jenkins自动化部署，同时学习Linux、Docker、Jenkins等技术。

- [mall项目部署篇介绍](https://www.macrozheng.com/mall/deploy/mall_deploy_overview.html)
- [使用虚拟机安装Linux](https://www.macrozheng.com/mall/deploy/linux_install.html)
- [Linux常用命令](https://www.macrozheng.com/mall/deploy/linux_command.html)
- [Linux防火墙Firewall和Iptables的使用](https://www.macrozheng.com/mall/deploy/linux_firewall.html)
- [Docker环境安装及常用命令](https://www.macrozheng.com/mall/deploy/docker_command.html)
- [使用Maven插件为SpringBoot应用构建Docker镜像](https://www.macrozheng.com/mall/deploy/docker_maven.html)
- [使用Dockerfile为SpringBoot应用构建Docker镜像](https://www.macrozheng.com/mall/deploy/docker_file.html)
- [使用Docker Compose部署SpringBoot应用](https://www.macrozheng.com/mall/deploy/docker_compose.html)
- [MySQL常用命令](https://www.macrozheng.com/mall/deploy/mysql.html)
- [mall在Linux环境下的部署（基于Docker容器）](https://www.macrozheng.com/mall/deploy/mall_deploy_docker.html)
- [mall在Linux环境下的部署（基于Docker Compose）](https://www.macrozheng.com/mall/deploy/mall_deploy_docker_compose.html)
- [在Linux上搭建Git服务](https://www.macrozheng.com/mall/deploy/gogs_start.html)
- [使用Jenkins一键打包部署SpringBoot应用](https://www.macrozheng.com/mall/deploy/jenkins.html)
- [使用Jenkins一键打包部署前端应用](https://www.macrozheng.com/mall/deploy/jenkins_vue.html)
- [mall使用Jenkins实现自动化部署](https://www.macrozheng.com/mall/deploy/mall_deploy_jenkins.html)


## 技术要点篇

> mall中一些功能的技术要点解析，这些技术要点和业务结合地比较紧密。

- [MyBatis Generator使用过程中踩过的一个坑](https://www.macrozheng.com/mall/technology/mybatis_mapper.html)
- [SpringBoot应用中使用AOP记录接口访问日志](https://www.macrozheng.com/mall/technology/aop_log.html)
- [前后端分离项目，如何解决跨域问题](https://www.macrozheng.com/mall/technology/springboot_cors.html)
- [Java 8都出那么久了，Stream API了解下？](https://www.macrozheng.com/mall/technology/java_stream.html)
- [仅需四步，整合SpringSecurity+JWT实现登录认证！](https://www.macrozheng.com/mall/technology/springsecurity_use.html)
- [前后端分离项目，如何优雅实现文件存储！](https://www.macrozheng.com/mall/technology/minio_use.html)
- [前后端分离项目，引入Spring Cloud Gateway遇到的一个问题！](https://www.macrozheng.com/mall/technology/gateway_cors.html)
- [手把手教你搞定权限管理，结合Spring Security实现接口的动态权限控制！](https://www.macrozheng.com/mall/technology/permission_back.html)
- [手把手教你搞定权限管理，结合Vue实现菜单的动态权限控制！](https://www.macrozheng.com/mall/technology/permission_front.html)
- [商品SKU功能设计与优化](https://www.macrozheng.com/mall/technology/product_sku.html)
- [SpringBoot中处理校验逻辑的两种方式，真的很机智！](https://www.macrozheng.com/mall/technology/springboot_validator.html)
- [使用Redis+AOP优化权限管理功能，这波操作贼爽！](https://www.macrozheng.com/mall/technology/redis_permission.html)
- [Elasticsearch项目实战，商品搜索功能设计与实现！](https://www.macrozheng.com/mall/technology/product_search.html)
- [RabbitMQ实现延迟消息居然如此简单，整个插件就完事了！](https://www.macrozheng.com/mall/technology/rabbitmq_delay.html)
- [给Swagger升级了新版本，没想到居然有这么多坑！](https://www.macrozheng.com/mall/technology/swagger_upgrade.html)
- [Elasticsearch 升级 7.x 版本后，我感觉掉坑里了！](https://www.macrozheng.com/mall/technology/elasticsearch_upgrade.html)
- [搞定Mall项目中的权限管理功能，弄懂这些问题就妥了！](https://www.macrozheng.com/mall/technology/mall_permission_question.html)

## 参考篇

> mall相关技术的参考教程，每篇都是可以独立学习的教程，学习过程中遇到不懂的知识点可以从这里找找。

- [Hutool中那些常用的工具类和方法 ](https://www.macrozheng.com/mall/reference/hutool_start.html)
- [Nginx的这些妙用，你肯定有不知道的！](https://www.macrozheng.com/mall/reference/nginx.html)
- [Github标星19K+Star，10分钟自建对象存储服务！](https://www.macrozheng.com/mall/reference/minio.html)
- [Spring Data Redis 最佳实践！](https://www.macrozheng.com/mall/reference/spring_data_redis.html)
- [Elasticsearch快速入门，掌握这些刚刚好！](https://www.macrozheng.com/mall/reference/elasticsearch_start.html)
- [MongoDB快速入门，掌握这些刚刚好！](https://www.macrozheng.com/mall/reference/mongodb_start.html)
- [我常用的自动化部署技巧，贼好用，推荐给大家！](https://www.macrozheng.com/mall/reference/springboot_auto_deploy.html)
- [连RabbitMQ的5种核心消息模式都不懂，也敢说自己会用消息队列！](https://www.macrozheng.com/mall/reference/rabbitmq_start.html)
- [SpringBoot应用整合ELK实现日志收集](https://www.macrozheng.com/mall/reference/mall_tiny_elk.html)
- [你居然还去服务器上捞日志，搭个日志收集系统难道不香么！](https://www.macrozheng.com/mall/reference/mall_elk_advance.html)
- [给Swagger换了个新皮肤，瞬间高大上了！](https://www.macrozheng.com/mall/reference/knife4j_start.html)
- [Docker服务开放了这个端口，服务器分分钟变肉机！](https://www.macrozheng.com/mall/reference/docker_protect_socket.html)
- [居然有人想白嫖我的日志，赶紧开启安全保护压压惊！](https://www.macrozheng.com/mall/reference/elk_security.html)
- [Nginx如何支持HTTPS？手把手教贼简单！](https://www.macrozheng.com/mall/reference/nginx_https_start.html)
- [还在手动整合Swagger？Swagger官方Starter是真的香！](https://www.macrozheng.com/mall/reference/swagger_starter.html)
- [肝了一周总结的SpringBoot实战教程，太实用了！](https://www.macrozheng.com/mall/reference/springboot_start.html)
- [解放双手！MyBatis官方代码生成工具给力！](https://www.macrozheng.com/mall/reference/mybatis_generator_start.html)
- [Lombok有啥牛皮的？SpringBoot和IDEA官方都要支持它！](https://www.macrozheng.com/mall/reference/lombok_start.html)

## 公众号

学习不走弯路，关注公众号「**macrozheng**」，回复「**学习路线**」，获取mall项目专属学习路线！

加微信群交流，公众号后台回复「**加群**」即可。

![公众号图片](http://macro-oss.oss-cn-shenzhen.aliyuncs.com/mall/banner/qrcode_for_macrozheng_258.jpg)
