# me - this DAT
# scriptOp - the OP which is cooking

import json

triangles = []

# press 'Setup Parameters' in the OP to call this function to re-create the parameters

# called whenever custom pulse parameter is pushed
def onPulse(par):
	print(par)
	if(par.name == 'Rebuild'):
		# Load a set of landmark data points
		rawdata = json.loads(op('in1').text)

		# Clear the existing SOP and fill out the points
		par.owner.clear()
		landmarks = rawdata['gestureResults']['landmarks'][0]

		# Draw all the points
		for i in range (len(landmarks)):
			p = par.owner.appendPoint()
			p.x = landmarks[i]['x']
			p.y = 1- landmarks[i]['y']
			p.z = landmarks[i]['z']

		# Now draw the poly shapes
		palm = par.owner.appendPoly(7, closed=True, addPoints=False)
		palm[0].point = par.owner.points[0]
		palm[1].point = par.owner.points[1]
		palm[2].point = par.owner.points[2]
		palm[3].point = par.owner.points[5]
		palm[4].point = par.owner.points[9]
		palm[5].point = par.owner.points[13]
		palm[6].point = par.owner.points[17]
	
		thumb = par.owner.appendPoly(3, closed=False, addPoints=False)
		thumb[0].point = par.owner.points[2]
		thumb[1].point = par.owner.points[3]
		thumb[2].point = par.owner.points[4]
	
		index = par.owner.appendPoly(4, closed=False, addPoints=False)
		index[0].point = par.owner.points[5]
		index[1].point = par.owner.points[6]
		index[2].point = par.owner.points[7]
		index[3].point = par.owner.points[8]
	
		middle = par.owner.appendPoly(4, closed=False, addPoints=False)
		middle[0].point = par.owner.points[9]
		middle[1].point = par.owner.points[10]
		middle[2].point = par.owner.points[11]
		middle[3].point = par.owner.points[12]
	
		ring = par.owner.appendPoly(4, closed=False, addPoints=False)
		ring[0].point = par.owner.points[13]
		ring[1].point = par.owner.points[14]
		ring[2].point = par.owner.points[15]
		ring[3].point = par.owner.points[16]
	
		pinky = par.owner.appendPoly(4, closed=False, addPoints=False)
		pinky[0].point = par.owner.points[17]
		pinky[1].point = par.owner.points[18]
		pinky[2].point = par.owner.points[19]
		pinky[3].point = par.owner.points[20]
	return

def onCook(scriptOp):
	return

def onSetupParameters(scriptOp):
	"""Auto-generated by Component Editor"""
	# manual changes to anything other than parJSON will be	# destroyed by Comp Editor unless doc string above is	# changed

	TDJSON = op.TDModules.mod.TDJSON
	parJSON = """
	{
		"Custom": {
			"Rebuild": {
				"name": "Rebuild",
				"label": "Rebuild",
				"page": "Custom",
				"style": "Pulse",
				"default": false,
				"enable": true,
				"startSection": false,
				"readOnly": false,
				"enableExpr": null,
				"help": ""
			}
		}
	}
	"""
	parData = TDJSON.textToJSON(parJSON)
	TDJSON.addParametersFromJSONOp(scriptOp, parData, destroyOthers=True)