# me - this DAT
# scriptOp - the OP which is cooking

import json
import numpy as np

# press 'Setup Parameters' in the OP to call this function to re-create the parameters.
openPosePoints = [
0,
2,
4,
5,
6,
13,
14,
17,
33,
37,
39,
58,
59,
61,
63,
66,
70,
78,
82,
84,
87,
93,
99,
105,
107,
127,
132,
133,
136,
144,
148,
149,
150,
152,
153,
158,
160,
168,
172,
176,
181,
195,
197,
234,
263,
267,
269,
288,
289,
291,
293,
296,
300,
308,
312,
314,
317,
323,
328,
334,
336,
356,
361,
362,
365,
373,
377,
378,
379,
380,
385,
387,
397,
400,
405,
454,
468,
473
]

# called whenever custom pulse parameter is pushed
def onPulse(par):
	return

def onCook(scriptOp):
	scriptOp.clear()
	scriptOp.numSamples = 0
	scriptOp.appendChan('x')
	scriptOp.appendChan('y')
	scriptOp.appendChan('z')
	if(op('in1').text != "" and parent().parent().par.Chops == True):
		rawdata = json.loads(op('in1').text)
			
		digits = scriptOp.digits -1
		# print("digits: " +str(digits))
		# print(str(len(rawdata['faceResults']['faceLandmarks'])))
		if not len(rawdata):
			return
		# Check to see if we have a face
		if(len(rawdata['faceLandmarkResults']) > 0 and rawdata['faceLandmarkResults']['faceLandmarks']):

			if(parent().par.Pointtype == "openpose"):
				i = 0
				for landmarks in rawdata['faceLandmarkResults']['faceLandmarks']:
					scriptOp.numSamples = scriptOp.numSamples + len(openPosePoints)
					for point in openPosePoints:
						# print("Len: " + str(len(landmarks)) + ", i: " + str(i), ", point: " + str(point))
						scriptOp['x'][i] = landmarks[point]['x']
						scriptOp['y'][i] = 1- landmarks[point]['y']
						scriptOp['z'][i] = landmarks[point]['z']
						i += 1
				return
			else:
				i = 0
				for landmarks in rawdata['faceLandmarkResults']['faceLandmarks']:
					# print(rawdata['faceResults']['faceLandmarks'])
					# landmarks = rawdata['faceLandmarkResults']['faceLandmarks'][digits]
					scriptOp.numSamples = scriptOp.numSamples + len(landmarks)

					for landmark in landmarks:
						scriptOp['x'][i] = landmark['x']
						scriptOp['y'][i] = 1- landmark['y']
						scriptOp['z'][i] = landmark['z']
						i += 1
				return

	# No faces detected, so make a 0 filled CHOP
	if(parent().par.Pointtype == "openpose"):
		# print("no OpenPose face")
		scriptOp.copyNumpyArray(np.zeros((3,68),np.float32))
		return
	else:
		# print("no face")
		scriptOp.copyNumpyArray(np.zeros((3,478),np.float32))
		return

def onSetupParameters(scriptOp):
	"""Auto-generated by Component Editor"""
	# manual changes to anything other than parJSON will be	# destroyed by Comp Editor unless doc string above is	# changed

	TDJSON = op.TDModules.mod.TDJSON
	parJSON = """
	{}
	"""
	parData = TDJSON.textToJSON(parJSON)
	TDJSON.addParametersFromJSONOp(scriptOp, parData, destroyOthers=True)