/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.servlet.init;

import jakarta.servlet.Registration;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.ext.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.glassfish.jersey.servlet.init.internal.LocalizationMessages;
import org.glassfish.jersey.servlet.internal.ServletContainerProviderFactory;
import org.glassfish.jersey.servlet.internal.Utils;
import org.glassfish.jersey.servlet.internal.spi.ServletContainerProvider;

@HandlesTypes(value={Path.class, Provider.class, Application.class, ApplicationPath.class})
public final class JerseyServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOGGER = Logger.getLogger(JerseyServletContainerInitializer.class.getName());

    @Override
    public void onStartup(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        ServletContainerProvider[] allServletContainerProviders = ServletContainerProviderFactory.getAllServletContainerProviders();
        if (classes == null) {
            classes = Collections.emptySet();
        }
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders) {
            servletContainerProvider.preInit(servletContext, classes);
        }
        this.onStartupImpl(classes, servletContext);
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders) {
            servletContainerProvider.postInit(servletContext, classes, JerseyServletContainerInitializer.findJerseyServletNames(servletContext));
        }
        for (ServletContainerProvider servletContainerProvider : allServletContainerProviders) {
            servletContainerProvider.onRegister(servletContext, JerseyServletContainerInitializer.findJerseyServletNames(servletContext));
        }
    }

    private void onStartupImpl(Set<Class<?>> classes, ServletContext servletContext) throws ServletException {
        HashSet<ServletRegistration> registrationsWithApplication = new HashSet<ServletRegistration>();
        for (Class<? extends Application> applicationClass : JerseyServletContainerInitializer.getApplicationClasses(classes)) {
            ServletRegistration servletRegistration = servletContext.getServletRegistration(applicationClass.getName());
            if (servletRegistration != null) {
                JerseyServletContainerInitializer.addServletWithExistingRegistration(servletContext, servletRegistration, applicationClass, classes);
                registrationsWithApplication.add(servletRegistration);
                continue;
            }
            List<Registration> srs = JerseyServletContainerInitializer.getInitParamDeclaredRegistrations(servletContext, applicationClass);
            if (!srs.isEmpty()) {
                for (Registration sr : srs) {
                    if (!(sr instanceof ServletRegistration)) continue;
                    JerseyServletContainerInitializer.addServletWithExistingRegistration(servletContext, (ServletRegistration)sr, applicationClass, classes);
                    registrationsWithApplication.add((ServletRegistration)sr);
                }
                continue;
            }
            ServletRegistration sr = JerseyServletContainerInitializer.addServletWithApplication(servletContext, applicationClass, classes);
            if (sr == null) continue;
            registrationsWithApplication.add(sr);
        }
        JerseyServletContainerInitializer.addServletWithDefaultConfiguration(servletContext, registrationsWithApplication, classes);
    }

    private static Set<String> findJerseyServletNames(ServletContext servletContext) {
        HashSet<String> jerseyServletNames = new HashSet<String>();
        for (ServletRegistration servletRegistration : servletContext.getServletRegistrations().values()) {
            if (!JerseyServletContainerInitializer.isJerseyServlet(servletRegistration.getClassName())) continue;
            jerseyServletNames.add(servletRegistration.getName());
        }
        return Collections.unmodifiableSet(jerseyServletNames);
    }

    private static boolean isJerseyServlet(String className) {
        return ServletContainer.class.getName().equals(className) || "org.glassfish.jersey.servlet.portability.PortableServletContainer".equals(className);
    }

    private static List<Registration> getInitParamDeclaredRegistrations(ServletContext context, Class<? extends Application> clazz) {
        ArrayList<Registration> registrations = new ArrayList<Registration>();
        JerseyServletContainerInitializer.collectJaxRsRegistrations(context.getServletRegistrations(), registrations, clazz);
        JerseyServletContainerInitializer.collectJaxRsRegistrations(context.getFilterRegistrations(), registrations, clazz);
        return registrations;
    }

    private static void collectJaxRsRegistrations(Map<String, ? extends Registration> registrations, List<Registration> collected, Class<? extends Application> a) {
        for (Registration registration : registrations.values()) {
            Map<String, String> ips = registration.getInitParameters();
            if (!ips.containsKey("jakarta.ws.rs.Application") || !ips.get("jakarta.ws.rs.Application").equals(a.getName())) continue;
            collected.add(registration);
        }
    }

    private static void addServletWithDefaultConfiguration(ServletContext context, Set<ServletRegistration> registrationsWithApplication, Set<Class<?>> classes) throws ServletException {
        ServletRegistration registration = context.getServletRegistration(Application.class.getName());
        Set<Class<?>> appClasses = JerseyServletContainerInitializer.getRootResourceAndProviderClasses(classes);
        if (registration != null) {
            ResourceConfig resourceConfig = ResourceConfig.forApplicationClass(ResourceConfig.class, appClasses).addProperties(JerseyServletContainerInitializer.getInitParams(registration)).addProperties(Utils.getContextParams(context));
            if (registration.getClassName() != null) {
                Utils.store(resourceConfig, context, registration.getName());
            } else {
                ServletContainer servletContainer = new ServletContainer(resourceConfig);
                registration = context.addServlet(registration.getName(), servletContainer);
                ((ServletRegistration.Dynamic)registration).setLoadOnStartup(1);
                if (registration.getMappings().isEmpty()) {
                    LOGGER.log(Level.WARNING, LocalizationMessages.JERSEY_APP_NO_MAPPING(registration.getName()));
                } else {
                    LOGGER.log(Level.CONFIG, LocalizationMessages.JERSEY_APP_REGISTERED_CLASSES(registration.getName(), appClasses));
                }
            }
        }
        for (ServletRegistration servletRegistration : context.getServletRegistrations().values()) {
            if (!JerseyServletContainerInitializer.isJerseyServlet(servletRegistration.getClassName()) || servletRegistration == registration || registrationsWithApplication.contains(servletRegistration) || !JerseyServletContainerInitializer.getInitParams(servletRegistration).isEmpty()) continue;
            ResourceConfig resourceConfig = ResourceConfig.forApplicationClass(ResourceConfig.class, appClasses).addProperties(Utils.getContextParams(context));
            Utils.store(resourceConfig, context, servletRegistration.getName());
        }
    }

    private static ServletRegistration addServletWithApplication(ServletContext context, Class<? extends Application> clazz, Set<Class<?>> defaultClasses) throws ServletException {
        ApplicationPath ap = clazz.getAnnotation(ApplicationPath.class);
        if (ap != null) {
            ResourceConfig resourceConfig = ResourceConfig.forApplicationClass(clazz, defaultClasses).addProperties(Utils.getContextParams(context));
            ServletContainer s2 = new ServletContainer(resourceConfig);
            ServletRegistration.Dynamic dsr = context.addServlet(clazz.getName(), s2);
            dsr.setAsyncSupported(true);
            dsr.setLoadOnStartup(1);
            String mapping = JerseyServletContainerInitializer.createMappingPath(ap);
            if (!JerseyServletContainerInitializer.mappingExists(context, mapping)) {
                dsr.addMapping(mapping);
                LOGGER.log(Level.CONFIG, LocalizationMessages.JERSEY_APP_REGISTERED_MAPPING(clazz.getName(), mapping));
            } else {
                LOGGER.log(Level.WARNING, LocalizationMessages.JERSEY_APP_MAPPING_CONFLICT(clazz.getName(), mapping));
            }
            return dsr;
        }
        return null;
    }

    private static void addServletWithExistingRegistration(ServletContext context, ServletRegistration registration, Class<? extends Application> clazz, Set<Class<?>> classes) throws ServletException {
        ResourceConfig resourceConfig = ResourceConfig.forApplicationClass(clazz, classes).addProperties(JerseyServletContainerInitializer.getInitParams(registration)).addProperties(Utils.getContextParams(context));
        if (registration.getClassName() != null) {
            Utils.store(resourceConfig, context, registration.getName());
        } else {
            ServletContainer servlet = new ServletContainer(resourceConfig);
            ServletRegistration.Dynamic dynamicRegistration = context.addServlet(clazz.getName(), servlet);
            dynamicRegistration.setAsyncSupported(true);
            dynamicRegistration.setLoadOnStartup(1);
            registration = dynamicRegistration;
        }
        if (registration.getMappings().isEmpty()) {
            ApplicationPath ap = clazz.getAnnotation(ApplicationPath.class);
            if (ap != null) {
                String mapping = JerseyServletContainerInitializer.createMappingPath(ap);
                if (!JerseyServletContainerInitializer.mappingExists(context, mapping)) {
                    registration.addMapping(mapping);
                    LOGGER.log(Level.CONFIG, LocalizationMessages.JERSEY_APP_REGISTERED_MAPPING(clazz.getName(), mapping));
                } else {
                    LOGGER.log(Level.WARNING, LocalizationMessages.JERSEY_APP_MAPPING_CONFLICT(clazz.getName(), mapping));
                }
            } else {
                LOGGER.log(Level.WARNING, LocalizationMessages.JERSEY_APP_NO_MAPPING_OR_ANNOTATION(clazz.getName(), ApplicationPath.class.getSimpleName()));
            }
        } else {
            LOGGER.log(Level.CONFIG, LocalizationMessages.JERSEY_APP_REGISTERED_APPLICATION(clazz.getName()));
        }
    }

    private static Map<String, Object> getInitParams(ServletRegistration sr) {
        HashMap<String, Object> initParams = new HashMap<String, Object>();
        for (Map.Entry<String, String> entry : sr.getInitParameters().entrySet()) {
            initParams.put(entry.getKey(), entry.getValue());
        }
        return initParams;
    }

    private static boolean mappingExists(ServletContext sc, String mapping) {
        for (ServletRegistration servletRegistration : sc.getServletRegistrations().values()) {
            for (String declaredMapping : servletRegistration.getMappings()) {
                if (!mapping.equals(declaredMapping)) continue;
                return true;
            }
        }
        return false;
    }

    private static String createMappingPath(ApplicationPath ap) {
        Object path = ap.value();
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        if (!((String)path).endsWith("/*")) {
            path = ((String)path).endsWith("/") ? (String)path + "*" : (String)path + "/*";
        }
        return path;
    }

    private static Set<Class<? extends Application>> getApplicationClasses(Set<Class<?>> classes) {
        LinkedHashSet<Class<? extends Application>> s2 = new LinkedHashSet<Class<? extends Application>>();
        for (Class<?> c : classes) {
            if (Application.class == c || !Application.class.isAssignableFrom(c)) continue;
            s2.add(c.asSubclass(Application.class));
        }
        return s2;
    }

    private static Set<Class<?>> getRootResourceAndProviderClasses(Set<Class<?>> classes) {
        LinkedHashSet s2 = new LinkedHashSet();
        for (Class<?> c : classes) {
            if (!c.isAnnotationPresent(Path.class) && !c.isAnnotationPresent(Provider.class)) continue;
            s2.add(c);
        }
        return s2;
    }
}

