/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jsonb;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Feature;
import jakarta.ws.rs.core.FeatureContext;
import java.security.AccessController;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.glassfish.jersey.ApplicationSupplier;
import org.glassfish.jersey.CommonProperties;
import org.glassfish.jersey.internal.inject.InjectionManagerSupplier;
import org.glassfish.jersey.internal.util.PropertiesHelper;
import org.glassfish.jersey.jsonb.LocalizationMessages;
import org.glassfish.jersey.jsonb.internal.JsonBindingProvider;

public class JsonBindingFeature
implements Feature {
    private static final Logger LOGGER = Logger.getLogger(JsonBindingFeature.class.getName());
    private static final String JSON_FEATURE = JsonBindingFeature.class.getSimpleName();

    @Override
    public boolean configure(FeatureContext context) {
        String jsonFeature;
        Configuration config = context.getConfiguration();
        String bindingDisabledBySystemProperty = AccessController.doPrivileged(PropertiesHelper.getSystemProperty("jersey.config.disableJsonBinding"));
        String bindingDisabledBySystemPropertyClient = AccessController.doPrivileged(PropertiesHelper.getSystemProperty("jersey.config.client.disableJsonBinding"));
        String bindingDisabledBySystemPropertyServer = AccessController.doPrivileged(PropertiesHelper.getSystemProperty("jersey.config.server.disableJsonBinding"));
        RuntimeType runtimeType = config.getRuntimeType();
        boolean bindingDisabledBySystem = PropertiesHelper.isPropertyOrNotSet(bindingDisabledBySystemProperty) || runtimeType == RuntimeType.CLIENT && PropertiesHelper.isPropertyOrNotSet(bindingDisabledBySystemPropertyClient) || runtimeType == RuntimeType.SERVER && PropertiesHelper.isPropertyOrNotSet(bindingDisabledBySystemPropertyServer);
        Boolean bindingDisabled = CommonProperties.getValue(config.getProperties(), runtimeType, "jersey.config.disableJsonBinding", Boolean.class);
        if (bindingDisabledBySystem && !Boolean.FALSE.equals(bindingDisabled) || Boolean.TRUE.equals(bindingDisabled)) {
            return false;
        }
        HashSet<String> disabledPackageNames = new HashSet<String>();
        String bindingDisabledPackageBySystemProperty = RuntimeType.SERVER == runtimeType ? AccessController.doPrivileged(PropertiesHelper.getSystemProperty("jersey.config.application.disableJsonBinding")) : null;
        String bindingDisabledPackage = RuntimeType.SERVER == runtimeType ? CommonProperties.getValue(config.getProperties(), runtimeType, "jersey.config.application.disableJsonBinding", String.class) : null;
        JsonBindingFeature.separatePackageNames(disabledPackageNames, bindingDisabledPackageBySystemProperty);
        JsonBindingFeature.separatePackageNames(disabledPackageNames, bindingDisabledPackage);
        if (!disabledPackageNames.isEmpty() && !Boolean.FALSE.equals(bindingDisabled)) {
            try {
                Application app = null;
                if (InjectionManagerSupplier.class.isInstance(context) && (app = ((InjectionManagerSupplier)((Object)context)).getInjectionManager().getInstance(Application.class)) != null) {
                    while (ApplicationSupplier.class.isInstance(app) && ((ApplicationSupplier)((Object)app)).getApplication() != app) {
                        app = ((ApplicationSupplier)((Object)app)).getApplication();
                    }
                    for (String disabledPackageName : disabledPackageNames) {
                        if (!app.getClass().getName().startsWith(disabledPackageName)) continue;
                        return false;
                    }
                }
                if (app == null) {
                    LOGGER.warning(LocalizationMessages.ERROR_JSONB_DETECTING_APPLICATION(LocalizationMessages.ERROR_JSONB_APPLICATION_NOT_FOUND()));
                }
            }
            catch (Throwable throwable) {
                LOGGER.warning(LocalizationMessages.ERROR_JSONB_DETECTING_APPLICATION(throwable.getMessage()));
            }
        }
        if (!JSON_FEATURE.equalsIgnoreCase(jsonFeature = CommonProperties.getValue(config.getProperties(), config.getRuntimeType(), "jersey.config.jsonFeature", JSON_FEATURE, String.class))) {
            return false;
        }
        context.property(PropertiesHelper.getPropertyNameForRuntime("jersey.config.jsonFeature", config.getRuntimeType()), JSON_FEATURE);
        context.register(JsonBindingProvider.class);
        return true;
    }

    private static void separatePackageNames(Set<String> set, String packages) {
        if (packages != null) {
            for (String packageName : packages.split(",")) {
                set.add(packageName.trim());
            }
        }
    }
}

