/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jaxb.runtime.v2.runtime;

import jakarta.xml.bind.helpers.ValidationEventImpl;
import java.io.IOException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.glassfish.jaxb.runtime.api.AccessorException;
import org.glassfish.jaxb.runtime.v2.model.runtime.RuntimeLeafInfo;
import org.glassfish.jaxb.runtime.v2.model.runtime.RuntimeTypeInfo;
import org.glassfish.jaxb.runtime.v2.runtime.JAXBContextImpl;
import org.glassfish.jaxb.runtime.v2.runtime.JaxBeanInfo;
import org.glassfish.jaxb.runtime.v2.runtime.Messages;
import org.glassfish.jaxb.runtime.v2.runtime.Name;
import org.glassfish.jaxb.runtime.v2.runtime.Transducer;
import org.glassfish.jaxb.runtime.v2.runtime.XMLSerializer;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.Loader;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.TextLoader;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.UnmarshallingContext;
import org.glassfish.jaxb.runtime.v2.runtime.unmarshaller.XsiTypeLoader;
import org.xml.sax.SAXException;

final class LeafBeanInfoImpl<BeanT>
extends JaxBeanInfo<BeanT> {
    private final Loader loader;
    private final Loader loaderWithSubst;
    private final Transducer<BeanT> xducer;
    private final Name tagName;

    public LeafBeanInfoImpl(JAXBContextImpl grammar, RuntimeLeafInfo li) {
        super(grammar, (RuntimeTypeInfo)li, li.getClazz(), li.getTypeNames(), li.isElement(), true, false);
        this.xducer = li.getTransducer();
        this.loader = new TextLoader(this.xducer);
        this.loaderWithSubst = new XsiTypeLoader(this);
        this.tagName = this.isElement() ? grammar.nameBuilder.createElementName(li.getElementName()) : null;
    }

    @Override
    public QName getTypeName(BeanT instance) {
        QName tn = this.xducer.getTypeName(instance);
        if (tn != null) {
            return tn;
        }
        return super.getTypeName(instance);
    }

    @Override
    public String getElementNamespaceURI(BeanT t2) {
        return this.tagName.nsUri;
    }

    @Override
    public String getElementLocalName(BeanT t2) {
        return this.tagName.localName;
    }

    @Override
    public BeanT createInstance(UnmarshallingContext context) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean reset(BeanT bean, UnmarshallingContext context) {
        return false;
    }

    @Override
    public String getId(BeanT bean, XMLSerializer target) {
        return null;
    }

    @Override
    public void serializeBody(BeanT bean, XMLSerializer w) throws SAXException, IOException, XMLStreamException {
        try {
            this.xducer.writeText(w, bean, null);
        }
        catch (AccessorException e) {
            w.reportError(null, e);
        }
    }

    @Override
    public void serializeAttributes(BeanT bean, XMLSerializer target) {
    }

    @Override
    public void serializeRoot(BeanT bean, XMLSerializer target) throws SAXException, IOException, XMLStreamException {
        if (this.tagName == null) {
            target.reportError(new ValidationEventImpl(1, Messages.UNABLE_TO_MARSHAL_NON_ELEMENT.format(bean.getClass().getName()), null, null));
        } else {
            target.startElement(this.tagName, bean);
            target.childAsSoleContent(bean, null);
            target.endElement();
        }
    }

    @Override
    public void serializeURIs(BeanT bean, XMLSerializer target) throws SAXException {
        if (this.xducer.useNamespace()) {
            try {
                this.xducer.declareNamespace(bean, target);
            }
            catch (AccessorException e) {
                target.reportError(null, e);
            }
        }
    }

    @Override
    public Loader getLoader(JAXBContextImpl context, boolean typeSubstitutionCapable) {
        if (typeSubstitutionCapable) {
            return this.loaderWithSubst;
        }
        return this.loader;
    }

    @Override
    public Transducer<BeanT> getTransducer() {
        return this.xducer;
    }
}

